# Generated by Django 5.2.6 on 2025-09-23 07:44

import datetime
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="CloudflareApiKey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Friendly name for this API key (e.g., 'Production', 'Staging')",
                        max_length=100,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, help_text="Optional description of what this key is used for"
                    ),
                ),
                ("api_token", models.CharField(help_text="Cloudflare API token", max_length=255)),
                (
                    "account_id",
                    models.CharField(
                        blank=True,
                        help_text="Cloudflare Account ID (auto-discovered if empty)",
                        max_length=32,
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, help_text="Whether this API key is active"),
                ),
                (
                    "is_default",
                    models.BooleanField(
                        default=False, help_text="Whether this is the default API key to use"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "last_used_at",
                    models.DateTimeField(
                        blank=True, help_text="When this API key was last used", null=True
                    ),
                ),
            ],
            options={
                "verbose_name": "Cloudflare API Key",
                "verbose_name_plural": "Cloudflare API Keys",
                "ordering": ["-is_default", "name"],
                "indexes": [
                    models.Index(fields=["is_active"], name="maintenance_is_acti_a3fc7a_idx"),
                    models.Index(fields=["is_default"], name="maintenance_is_defa_10fec0_idx"),
                ],
            },
        ),
        migrations.CreateModel(
            name="CloudflareSite",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Friendly site name for identification", max_length=100
                    ),
                ),
                (
                    "domain",
                    models.CharField(
                        help_text="Domain name (e.g., vamcar.com)", max_length=255, unique=True
                    ),
                ),
                (
                    "zone_id",
                    models.CharField(help_text="Cloudflare Zone ID", max_length=32, unique=True),
                ),
                ("account_id", models.CharField(help_text="Cloudflare Account ID", max_length=32)),
                (
                    "maintenance_active",
                    models.BooleanField(
                        default=False, help_text="Whether maintenance mode is currently active"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True, help_text="Whether this site is active in our system"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "last_maintenance_at",
                    models.DateTimeField(
                        blank=True, help_text="When maintenance was last activated", null=True
                    ),
                ),
                (
                    "api_key",
                    models.ForeignKey(
                        help_text="API key to use for this site",
                        on_delete=django.db.models.deletion.PROTECT,
                        to="maintenance.cloudflareapikey",
                    ),
                ),
            ],
            options={
                "verbose_name": "Cloudflare Site",
                "verbose_name_plural": "Cloudflare Sites",
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="MaintenanceLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "action",
                    models.CharField(
                        choices=[
                            ("enable", "Enable Maintenance"),
                            ("disable", "Disable Maintenance"),
                            ("error", "Error"),
                            ("sync", "Sync from Cloudflare"),
                        ],
                        help_text="What action was performed",
                        max_length=20,
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("success", "Success"),
                            ("failed", "Failed"),
                            ("pending", "Pending"),
                        ],
                        help_text="Result of the operation",
                        max_length=20,
                    ),
                ),
                (
                    "reason",
                    models.TextField(blank=True, help_text="Why maintenance was enabled/disabled"),
                ),
                (
                    "error_message",
                    models.TextField(blank=True, help_text="Error details if operation failed"),
                ),
                (
                    "cloudflare_response",
                    models.JSONField(
                        blank=True,
                        help_text="Full Cloudflare API response for debugging",
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "duration_seconds",
                    models.IntegerField(
                        blank=True, help_text="How long the operation took", null=True
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        help_text="Site this log entry belongs to",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="logs",
                        to="maintenance.cloudflaresite",
                    ),
                ),
            ],
            options={
                "verbose_name": "Maintenance Log",
                "verbose_name_plural": "Maintenance Logs",
                "ordering": ["-created_at"],
            },
        ),
        migrations.CreateModel(
            name="ScheduledMaintenance",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("title", models.CharField(help_text="Maintenance event title", max_length=200)),
                (
                    "description",
                    models.TextField(blank=True, help_text="Detailed description of maintenance"),
                ),
                (
                    "scheduled_start",
                    models.DateTimeField(help_text="When maintenance should start"),
                ),
                (
                    "estimated_duration",
                    models.DurationField(help_text="Expected duration of maintenance"),
                ),
                (
                    "scheduled_end",
                    models.DateTimeField(editable=False, help_text="Auto-calculated end time"),
                ),
                (
                    "status",
                    models.CharField(
                        choices=[
                            ("scheduled", "Scheduled"),
                            ("active", "Active"),
                            ("completed", "Completed"),
                            ("cancelled", "Cancelled"),
                            ("failed", "Failed"),
                        ],
                        default="scheduled",
                        max_length=20,
                    ),
                ),
                (
                    "priority",
                    models.CharField(
                        choices=[
                            ("low", "Low"),
                            ("normal", "Normal"),
                            ("high", "High"),
                            ("critical", "Critical"),
                        ],
                        default="normal",
                        max_length=20,
                    ),
                ),
                ("actual_start", models.DateTimeField(blank=True, null=True)),
                ("actual_end", models.DateTimeField(blank=True, null=True)),
                (
                    "maintenance_message",
                    models.TextField(
                        blank=True, help_text="Custom message to display during maintenance"
                    ),
                ),
                (
                    "template",
                    models.CharField(
                        choices=[
                            ("modern", "Modern"),
                            ("simple", "Simple"),
                            ("premium", "Premium"),
                            ("minimal", "Minimal"),
                        ],
                        default="modern",
                        help_text="Maintenance page template",
                        max_length=50,
                    ),
                ),
                (
                    "auto_enable",
                    models.BooleanField(
                        default=True, help_text="Automatically enable maintenance at scheduled time"
                    ),
                ),
                (
                    "auto_disable",
                    models.BooleanField(
                        default=True, help_text="Automatically disable maintenance after duration"
                    ),
                ),
                (
                    "notify_before",
                    models.DurationField(
                        default=datetime.timedelta(seconds=3600),
                        help_text="Send notification before maintenance starts",
                    ),
                ),
                ("notify_on_start", models.BooleanField(default=True)),
                ("notify_on_complete", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "created_by",
                    models.CharField(
                        blank=True, help_text="Who created this maintenance", max_length=100
                    ),
                ),
                (
                    "execution_log",
                    models.JSONField(
                        blank=True, default=dict, help_text="Log of execution steps and results"
                    ),
                ),
                (
                    "sites",
                    models.ManyToManyField(
                        help_text="Sites affected by this maintenance",
                        related_name="scheduled_maintenances",
                        to="maintenance.cloudflaresite",
                    ),
                ),
            ],
            options={
                "verbose_name": "Scheduled Maintenance",
                "verbose_name_plural": "Scheduled Maintenances",
                "ordering": ["scheduled_start"],
            },
        ),
        migrations.AddIndex(
            model_name="cloudflaresite",
            index=models.Index(fields=["domain"], name="maintenance_domain_b9a739_idx"),
        ),
        migrations.AddIndex(
            model_name="cloudflaresite",
            index=models.Index(
                fields=["maintenance_active"], name="maintenance_mainten_26f0c1_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="cloudflaresite",
            index=models.Index(fields=["is_active"], name="maintenance_is_acti_335998_idx"),
        ),
        migrations.AddIndex(
            model_name="maintenancelog",
            index=models.Index(
                fields=["site", "-created_at"], name="maintenance_site_id_c57d8c_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="maintenancelog",
            index=models.Index(
                fields=["action", "-created_at"], name="maintenance_action_1676f8_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="maintenancelog",
            index=models.Index(
                fields=["status", "-created_at"], name="maintenance_status_47eaad_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="scheduledmaintenance",
            index=models.Index(
                fields=["status", "scheduled_start"], name="maintenance_status_77021b_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="scheduledmaintenance",
            index=models.Index(fields=["scheduled_start"], name="maintenance_schedul_7c49c4_idx"),
        ),
        migrations.AddIndex(
            model_name="scheduledmaintenance",
            index=models.Index(fields=["status"], name="maintenance_status_92c0e9_idx"),
        ),
    ]
