# Generated by Django 5.2.5 on 2025-09-09 05:19

import django.db.models.deletion
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Newsletter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, verbose_name='Newsletter Title')),
                ('description', models.TextField(blank=True, verbose_name='Description')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('auto_subscribe', models.BooleanField(default=False, help_text='Automatically subscribe new users to this newsletter', verbose_name='Auto Subscribe New Users')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Newsletter',
                'verbose_name_plural': 'Newsletters',
                'ordering': ['-created_at'],
            },
        ),
        migrations.CreateModel(
            name='NewsletterCampaign',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(max_length=255, verbose_name='Subject')),
                ('email_title', models.CharField(max_length=255, verbose_name='Email Title')),
                ('main_text', models.TextField(verbose_name='Main Text')),
                ('main_html_content', models.TextField(blank=True, verbose_name='HTML Content')),
                ('button_text', models.CharField(blank=True, max_length=100, verbose_name='Button Text')),
                ('button_url', models.URLField(blank=True, verbose_name='Button URL')),
                ('secondary_text', models.TextField(blank=True, verbose_name='Secondary Text')),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('sending', 'Sending'), ('sent', 'Sent'), ('failed', 'Failed')], default='draft', max_length=10, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('sent_at', models.DateTimeField(blank=True, null=True, verbose_name='Sent At')),
                ('recipient_count', models.PositiveIntegerField(default=0, editable=False, verbose_name='Recipient Count')),
                ('newsletter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='campaigns', to='django_cfg_newsletter.newsletter', verbose_name='Newsletter')),
            ],
            options={
                'verbose_name': 'Newsletter Campaign',
                'verbose_name_plural': 'Newsletter Campaigns',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='EmailLog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('recipient', models.TextField(help_text='Comma-separated email addresses', verbose_name='Recipient(s)')),
                ('subject', models.CharField(max_length=255, verbose_name='Subject')),
                ('body', models.TextField(verbose_name='Body (HTML)')),
                ('status', models.CharField(choices=[('pending', 'Pending'), ('sent', 'Sent'), ('failed', 'Failed')], default='pending', max_length=10, verbose_name='Status')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('sent_at', models.DateTimeField(blank=True, null=True, verbose_name='Sent At')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='Error Message')),
                ('opened_at', models.DateTimeField(blank=True, help_text='When email was first opened', null=True, verbose_name='Opened At')),
                ('clicked_at', models.DateTimeField(blank=True, help_text='When link was first clicked', null=True, verbose_name='Clicked At')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, verbose_name='User Account')),
                ('newsletter', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='email_logs', to='django_cfg_newsletter.newsletter', verbose_name='Related Newsletter')),
                ('campaign', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='email_logs', to='django_cfg_newsletter.newslettercampaign', verbose_name='Related Campaign')),
            ],
            options={
                'verbose_name': 'Email Log',
                'verbose_name_plural': 'Email Logs',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='NewsletterSubscription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('email', models.EmailField(max_length=254, verbose_name='Email Address')),
                ('is_active', models.BooleanField(default=True, verbose_name='Active')),
                ('subscribed_at', models.DateTimeField(auto_now_add=True)),
                ('unsubscribed_at', models.DateTimeField(blank=True, null=True)),
                ('newsletter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to='django_cfg_newsletter.newsletter', verbose_name='Newsletter')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Newsletter Subscription',
                'verbose_name_plural': 'Newsletter Subscriptions',
                'ordering': ['-subscribed_at'],
                'unique_together': {('newsletter', 'email')},
            },
        ),
    ]
