"""
Parsing patterns for NowPayments currency recognition.

Contains precise patterns, fallback patterns, and provider code patterns
for extracting base currency codes from various data sources.
"""

# Precise patterns from real NowPayments API data
PRECISE_PATTERNS = {
    # Stablecoins - most common
    'tether usd': 'USDT',
    'tether (': 'USDT',          # "Tether (Arbitrum One)"
    'tether ': 'USDT',           # "Tether USD (Algorand)"
    'usd coin': 'USDC',          # "USD Coin (Ethereum)"
    'usd coin bridged': 'USDC',  # "USD Coin Bridged (Polygon)"
    'trueusd': 'TUSD',           # "TrueUSD (Tron)"
    'binance usd': 'BUSD',       # "Binance USD (Polygon)"
    'paxos standard': 'PAX',     # "Paxos Standard"
    'gemini dollar': 'GUSD',     # "Gemini Dollar"
    
    # Major cryptocurrencies  
    'bitcoin': 'BTC',
    'ethereum': 'ETH',
    'cardano': 'ADA',
    'dogecoin': 'DOGE',
    'litecoin': 'LTC',
    'bitcoin cash': 'BCH',
    'ripple': 'XRP',
    'polkadot': 'DOT',
    'avalanche': 'AVAX',
    'chainlink': 'LINK',
    'uniswap': 'UNI',
    'ethereum classic': 'ETC',
    'stellar': 'XLM',
    'monero': 'XMR',
    'zcash': 'ZEC',
    'dash': 'DASH',
    'tezos': 'XTZ',
    'cosmos': 'ATOM',
    'algorand': 'ALGO',
    'eos': 'EOS',
    'tron': 'TRX',
    'vechain': 'VET',
    'theta network': 'THETA',
    'filecoin': 'FIL',
    'internet computer': 'ICP',
    'hedera': 'HBAR',
    'multiversx': 'EGLD',
    'elrond': 'EGLD',
    'flow': 'FLOW',
    'near protocol': 'NEAR',
    'solana': 'SOL',
    'fantom': 'FTM',
    'harmony': 'ONE',
    'zilliqa': 'ZIL',
    'ontology': 'ONT',
    'icon': 'ICX',
    'qtum': 'QTUM',
    'waves': 'WAVES',
    'lisk': 'LSK',
    'nano': 'NANO',
    'digibyte': 'DGB',
    'ravencoin': 'RVN',
    'siacoin': 'SC',
    'decred': 'DCR',
    'horizen': 'ZEN',
    'komodo': 'KMD',
    'stratis': 'STRAT',
    'ark': 'ARK',
    'nxt': 'NXT',
    'bitshares': 'BTS',
    'steem': 'STEEM',
    
    # Exchange tokens
    'binance coin': 'BNB',
    'bnb': 'BNB',
    'kucoin shares': 'KCS',
    'huobi token': 'HT',
    'okb': 'OKB',
    'crypto.com coin': 'CRO',
    'ftx token': 'FTT',
    'binance usd': 'BUSD',
    
    # Layer 1/2 tokens
    'polygon': 'MATIC',
    'matic network': 'MATIC',
    'avalanche': 'AVAX',
    'solana': 'SOL',
    'chainlink': 'LINK',
    'uniswap': 'UNI',
    'aave': 'AAVE',
    'compound': 'COMP',
    'maker': 'MKR',
    'synthetix': 'SNX',
    'yearn.finance': 'YFI',
    'sushiswap': 'SUSHI',
    'curve dao token': 'CRV',
    'balancer': 'BAL',
    'ren': 'REN',
    'kyber network': 'KNC',
    '0x': 'ZRX',
    'basic attention token': 'BAT',
    'enjin coin': 'ENJ',
    'decentraland': 'MANA',
    'the sandbox': 'SAND',
    'axie infinity': 'AXS',
    
    # Other stablecoins
    'dai stablecoin': 'DAI',
    'frax': 'FRAX',
    'liquity usd': 'LUSD',
    'susd': 'SUSD',
    'neutrino usd': 'USDN',
    'reserve rights': 'RSR',
    'ampleforth': 'AMPL',
    'tribe': 'TRIBE',
    'fei usd': 'FEI',
    
    # Meme coins
    'shiba inu': 'SHIB',
    'dogecoin': 'DOGE',
    'safemoon': 'SAFEMOON',
    'floki inu': 'FLOKI',
    'baby doge coin': 'BABYDOGE',
    
    # Gaming tokens
    'axie infinity': 'AXS',
    'smooth love potion': 'SLP',
    'the sandbox': 'SAND',
    'decentraland': 'MANA',
    'enjin coin': 'ENJ',
    'gala': 'GALA',
    'illuvium': 'ILV',
    'star atlas': 'ATLAS',
    'yield guild games': 'YGG',
    
    # NFT tokens
    'opensea': 'OS',
    'looks rare': 'LOOKS',
    'x2y2': 'X2Y2',
    
    # Privacy coins
    'monero': 'XMR',
    'zcash': 'ZEC',
    'dash': 'DASH',
    'verge': 'XVG',
    'beam': 'BEAM',
    'grin': 'GRIN',
    
    # Oracle tokens
    'chainlink': 'LINK',
    'band protocol': 'BAND',
    'api3': 'API3',
    'tellor': 'TRB',
    
    # Storage tokens
    'filecoin': 'FIL',
    'storj': 'STORJ',
    'siacoin': 'SC',
    'arweave': 'AR',
    
    # Cross-chain tokens
    'thorchain': 'RUNE',
    'cosmos': 'ATOM',
    'polkadot': 'DOT',
    'kusama': 'KSM',
    'ren': 'REN',
    'anyswap': 'ANY',
    
    # Yield farming tokens
    'yearn.finance': 'YFI',
    'harvest finance': 'FARM',
    'pickle finance': 'PICKLE',
    'cream finance': 'CREAM',
    'alpha finance lab': 'ALPHA',
    
    # Lending tokens
    'aave': 'AAVE',
    'compound': 'COMP',
    'maker': 'MKR',
    'venus': 'XVS',
    'justlend': 'JST',
    
    # Insurance tokens
    'nexus mutual': 'NXM',
    'cover protocol': 'COVER',
    'nsure network': 'NSURE',
    
    # Prediction market tokens
    'augur': 'REP',
    'gnosis': 'GNO',
    'polymarket': 'POLY',
    
    # Social tokens
    'rally': 'RLY',
    'whale': 'WHALE',
    'friends with benefits': 'FWB',
    
    # Fan tokens
    'chiliz': 'CHZ',
    'socios.com': 'CHZ',
    
    # Metaverse tokens
    'decentraland': 'MANA',
    'the sandbox': 'SAND',
    'enjin coin': 'ENJ',
    'bloktopia': 'BLOK',
    'star atlas': 'ATLAS',
    'illuvium': 'ILV',
    'gala': 'GALA',
    'axie infinity': 'AXS',
    'smooth love potion': 'SLP',
    'yield guild games': 'YGG',
    'merit circle': 'MC',
    'ultra': 'UOS',
    'wax': 'WAXP',
    'alien worlds': 'TLM',
    'my neighbor alice': 'ALICE',
    'radio caca': 'RACA',
    'derace': 'DERC',
    'vulcan forged': 'PYR',
    'mobox': 'MBOX',
    'cryptoblades': 'SKILL',
    'thetan arena': 'THG',
    'gods unchained': 'GODS',
    'immutable x': 'IMX',
    'ecomi': 'OMI',
    'veve': 'VVV',
    'efinity token': 'EFI',
    'chromia': 'CHR',
    'phantasma': 'SOUL',
    'wax': 'WAXP',
    'enjin coin': 'ENJ',
    'flow': 'FLOW',
    'dapper labs': 'FLOW',
    'nba top shot': 'FLOW',
    'cryptokitties': 'ETH',
    'cryptopunks': 'ETH',
    'bored ape yacht club': 'ETH',
    'mutant ape yacht club': 'ETH',
    'cool cats': 'ETH',
    'world of women': 'ETH',
    'pudgy penguins': 'ETH',
    'azuki': 'ETH',
    'clone x': 'ETH',
    'moonbirds': 'ETH',
    'otherdeeds for otherside': 'ETH',
    'yuga labs': 'ETH',
}

# Fallback patterns for edge cases
FALLBACK_PATTERNS = {
    'usdt': 'USDT',
    'usdc': 'USDC', 
    'tusd': 'TUSD',
    'busd': 'BUSD',
    'dai': 'DAI',
    'frax': 'FRAX',
    'btc': 'BTC',
    'eth ': 'ETH',
    'ada': 'ADA',
    'doge': 'DOGE',
    'matic': 'MATIC',
    'avax': 'AVAX',
    'sol': 'SOL',
    'dot': 'DOT',
    'atom': 'ATOM',
    'near': 'NEAR',
    'algo': 'ALGO',
    'xtz': 'XTZ',
    'eos': 'EOS',
    'trx': 'TRX',
    'xlm': 'XLM',
    'xrp': 'XRP',
    'ltc': 'LTC',
    'bch': 'BCH',
    'etc': 'ETC',
    'xmr': 'XMR',
    'zec': 'ZEC',
    'dash': 'DASH',
    'bnb': 'BNB',
    'link': 'LINK',
    'uni': 'UNI',
    'aave': 'AAVE',
    'comp': 'COMP',
    'mkr': 'MKR',
    'snx': 'SNX',
    'yfi': 'YFI',
    'sushi': 'SUSHI',
    'crv': 'CRV',
    'bal': 'BAL',
    'ren': 'REN',
    'knc': 'KNC',
    'zrx': 'ZRX',
    'bat': 'BAT',
    'enj': 'ENJ',
    'mana': 'MANA',
    'sand': 'SAND',
    'axs': 'AXS',
    'ftm': 'FTM',
    'one': 'ONE',
    'zil': 'ZIL',
    'ont': 'ONT',
    'icx': 'ICX',
    'qtum': 'QTUM',
    'waves': 'WAVES',
    'lsk': 'LSK',
    'nano': 'NANO',
    'dgb': 'DGB',
    'rvn': 'RVN',
    'sc': 'SC',
    'dcr': 'DCR',
    'zen': 'ZEN',
    'kmd': 'KMD',
    'strat': 'STRAT',
    'ark': 'ARK',
    'nxt': 'NXT',
    'bts': 'BTS',
    'steem': 'STEEM',
    'vet': 'VET',
    'theta': 'THETA',
    'fil': 'FIL',
    'icp': 'ICP',
    'hbar': 'HBAR',
    'egld': 'EGLD',
    'flow': 'FLOW',
    'iota': 'IOTA',
    'shib': 'SHIB',
    'floki': 'FLOKI',
    'safemoon': 'SAFEMOON',
    'babydoge': 'BABYDOGE',
    'slp': 'SLP',
    'gala': 'GALA',
    'ilv': 'ILV',
    'atlas': 'ATLAS',
    'ygg': 'YGG',
    'rune': 'RUNE',
    'ksm': 'KSM',
    'any': 'ANY',
    'farm': 'FARM',
    'pickle': 'PICKLE',
    'cream': 'CREAM',
    'alpha': 'ALPHA',
    'xvs': 'XVS',
    'jst': 'JST',
    'nxm': 'NXM',
    'cover': 'COVER',
    'nsure': 'NSURE',
    'rep': 'REP',
    'gno': 'GNO',
    'poly': 'POLY',
    'rly': 'RLY',
    'whale': 'WHALE',
    'fwb': 'FWB',
    'chz': 'CHZ',
    'blok': 'BLOK',
    'mc': 'MC',
    'uos': 'UOS',
    'waxp': 'WAXP',
    'tlm': 'TLM',
    'alice': 'ALICE',
    'raca': 'RACA',
    'derc': 'DERC',
    'pyr': 'PYR',
    'mbox': 'MBOX',
    'skill': 'SKILL',
    'thg': 'THG',
    'gods': 'GODS',
    'imx': 'IMX',
    'omi': 'OMI',
    'vvv': 'VVV',
    'efi': 'EFI',
    'chr': 'CHR',
    'soul': 'SOUL',
}

# Provider code exact matches
PROVIDER_CODE_PATTERNS = {
    # Stablecoins with network suffixes
    'USDTERC20': 'USDT',
    'USDTTRC20': 'USDT', 
    'USDTBSC': 'USDT',
    'USDTMATIC': 'USDT',
    'USDTARB': 'USDT',
    'USDTALGO': 'USDT',
    'USDTARC20': 'USDT',  # Avalanche
    'USDTOP': 'USDT',     # Optimism
    'USDTSOL': 'USDT',    # Solana
    'USDTTON': 'USDT',    # TON
    'USDTNEAR': 'USDT',   # NEAR
    'USDTEOS': 'USDT',    # EOS
    'USDTDOT': 'USDT',    # Polkadot
    'USDTCELO': 'USDT',   # Celo
    'USDTKAVA': 'USDT',   # Kava
    'USDTXTZ': 'USDT',    # Tezos
    
    # USDC variants
    'USDCERC20': 'USDC',
    'USDCBSC': 'USDC',
    'USDCMATIC': 'USDC',
    'USDCARB': 'USDC',
    'USDCALGO': 'USDC',
    'USDCARC20': 'USDC',  # Avalanche
    'USDCOP': 'USDC',     # Optimism
    'USDCSOL': 'USDC',    # Solana
    'USDCBASE': 'USDC',   # Base
    'USDCKCC': 'USDC',    # KCC
    'USDCXLM': 'USDC',    # Stellar
    
    # ETH variants
    'ETHBSC': 'ETH',
    'ETHARB': 'ETH',
    'ETHBASE': 'ETH',
    'ETHLNA': 'ETH',      # Linea
    
    # Other common patterns
    'BTCBSC': 'BTC',      # Wrapped BTC
    'WBTC': 'BTC',        # Wrapped Bitcoin
    'WETH': 'ETH',        # Wrapped Ethereum
    
    # Network-specific tokens with suffixes
    'BNBBSC': 'BNB',
    'MATICMATIC': 'MATIC',
    'AVAXARC20': 'AVAX',
    'SOLANASOL': 'SOL',
    
    # Additional patterns from NowPayments
    '1INCHBSC': '1INCH',
    '1INCHERC20': '1INCH',
    'AAVEERC20': 'AAVE',
    'AAVEBSC': 'AAVE',
    'ADABSC': 'ADA',
    'ALGOERC20': 'ALGO',
    'APEERC20': 'APE',
    'APEBSC': 'APE',
    'ATOMCOSMOS': 'ATOM',
    'AVAXBSC': 'AVAX',
    'AXSERC20': 'AXS',
    'AXSBSC': 'AXS',
    'BATERC20': 'BAT',
    'BATBSC': 'BAT',
    'BCHBSC': 'BCH',
    'BNBERC20': 'BNB',
    'BUSDBSC': 'BUSD',
    'BUSDERC20': 'BUSD',
    'CAKEBSC': 'CAKE',
    'COMPBSC': 'COMP',
    'COMPERC20': 'COMP',
    'CRVERC20': 'CRV',
    'CRVBSC': 'CRV',
    'DAIBSC': 'DAI',
    'DAIERC20': 'DAI',
    'DOGEERC20': 'DOGE',
    'DOGEBSC': 'DOGE',
    'DOTBSC': 'DOT',
    'DOTERC20': 'DOT',
    'ENJERC20': 'ENJ',
    'ENJBSC': 'ENJ',
    'ETCBSC': 'ETC',
    'ETCERC20': 'ETC',
    'FILBSC': 'FIL',
    'FILERC20': 'FIL',
    'FTMBSC': 'FTM',
    'FTMERC20': 'FTM',
    'GALAERC20': 'GALA',
    'GALABSC': 'GALA',
    'GRTERC20': 'GRT',
    'GRTBSC': 'GRT',
    'ICPERC20': 'ICP',
    'ICPBSC': 'ICP',
    'LINKERC20': 'LINK',
    'LINKBSC': 'LINK',
    'LTCBSC': 'LTC',
    'LTCERC20': 'LTC',
    'MANAERC20': 'MANA',
    'MANABSC': 'MANA',
    'MKRBSC': 'MKR',
    'MKRERC20': 'MKR',
    'NEARERC20': 'NEAR',
    'NEARBSC': 'NEAR',
    'ONEERC20': 'ONE',
    'ONEBSC': 'ONE',
    'SANDERC20': 'SAND',
    'SANDBSC': 'SAND',
    'SHIBERC20': 'SHIB',
    'SHIBBSC': 'SHIB',
    'SNXERC20': 'SNX',
    'SNXBSC': 'SNX',
    'SOLERC20': 'SOL',
    'SOLBSC': 'SOL',
    'SUSHIERC20': 'SUSHI',
    'SUSHIBSC': 'SUSHI',
    'TRXBSC': 'TRX',
    'TRXERC20': 'TRX',
    'TUSDTRC20': 'TUSD',
    'TUSDBSC': 'TUSD',
    'TUSDERC20': 'TUSD',
    'UNIERC20': 'UNI',
    'UNIBSC': 'UNI',
    'VETBSC': 'VET',
    'VETERC20': 'VET',
    'XLMBSC': 'XLM',
    'XLMERC20': 'XLM',
    'XRPBSC': 'XRP',
    'XRPERC20': 'XRP',
    'XTZXTZ': 'XTZ',
    'YFIIERC20': 'YFI',
    'YFIIBSC': 'YFI',
    'ZRXERC20': 'ZRX',
    'ZRXBSC': 'ZRX',
}
