# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.03.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ApplicationsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_application(self, app_id, **kwargs):  # noqa: E501
        """Remove an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_application(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_application_with_http_info(app_id, **kwargs)  # noqa: E501

    def delete_application_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Remove an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_application_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `delete_application`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `delete_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def env_config_delete(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Remove an environment configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_delete(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.env_config_delete_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, **kwargs)  # noqa: E501

    def env_config_delete_with_http_info(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Remove an environment configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_delete_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'env_config_id', 'maintenance_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method env_config_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `env_config_delete`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `env_config_delete`")  # noqa: E501
        # verify the required parameter 'env_config_id' is set
        if self.api_client.client_side_validation and ('env_config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_config_id` when calling `env_config_delete`")  # noqa: E501
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `env_config_delete`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `env_config_delete`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `env_config_delete`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_config_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_config_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_config_id` when calling `env_config_delete`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `env_config_delete`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501
        if 'env_config_id' in local_var_params:
            path_params['env_config_id'] = local_var_params['env_config_id']  # noqa: E501

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def env_config_get(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Get environment configuration  # noqa: E501

        Retrieve environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_get(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.env_config_get_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, **kwargs)  # noqa: E501

    def env_config_get_with_http_info(self, app_id, env_name, env_config_id, maintenance_org_id, **kwargs):  # noqa: E501
        """Get environment configuration  # noqa: E501

        Retrieve environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_get_with_http_info(app_id, env_name, env_config_id, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'env_config_id', 'maintenance_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method env_config_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `env_config_get`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `env_config_get`")  # noqa: E501
        # verify the required parameter 'env_config_id' is set
        if self.api_client.client_side_validation and ('env_config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_config_id` when calling `env_config_get`")  # noqa: E501
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `env_config_get`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `env_config_get`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `env_config_get`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_config_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_config_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_config_id` when calling `env_config_get`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `env_config_get`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501
        if 'env_config_id' in local_var_params:
            path_params['env_config_id'] = local_var_params['env_config_id']  # noqa: E501

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def env_config_get_all(self, app_id, env_name, maintenance_org_id, **kwargs):  # noqa: E501
        """Get all environment configuration  # noqa: E501

        Retrieve all environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_get_all(app_id, env_name, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EnvironmentConfig]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.env_config_get_all_with_http_info(app_id, env_name, maintenance_org_id, **kwargs)  # noqa: E501

    def env_config_get_all_with_http_info(self, app_id, env_name, maintenance_org_id, **kwargs):  # noqa: E501
        """Get all environment configuration  # noqa: E501

        Retrieve all environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_get_all_with_http_info(app_id, env_name, maintenance_org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str maintenance_org_id: Organisation unique identifier for an object being maintained by an organisation different than it.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EnvironmentConfig], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'maintenance_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method env_config_get_all" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `env_config_get_all`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `env_config_get_all`")  # noqa: E501
        # verify the required parameter 'maintenance_org_id' is set
        if self.api_client.client_side_validation and ('maintenance_org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['maintenance_org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `maintenance_org_id` when calling `env_config_get_all`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `env_config_get_all`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `env_config_get_all`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'maintenance_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['maintenance_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `maintenance_org_id` when calling `env_config_get_all`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []
        if 'maintenance_org_id' in local_var_params and local_var_params['maintenance_org_id'] is not None:  # noqa: E501
            query_params.append(('maintenance_org_id', local_var_params['maintenance_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EnvironmentConfig]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def env_config_post(self, app_id, env_name, environment_config, **kwargs):  # noqa: E501
        """Add an environment configuration row  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_post(app_id, env_name, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param EnvironmentConfig environment_config: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.env_config_post_with_http_info(app_id, env_name, environment_config, **kwargs)  # noqa: E501

    def env_config_post_with_http_info(self, app_id, env_name, environment_config, **kwargs):  # noqa: E501
        """Add an environment configuration row  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_post_with_http_info(app_id, env_name, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param EnvironmentConfig environment_config: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'environment_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method env_config_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `env_config_post`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `env_config_post`")  # noqa: E501
        # verify the required parameter 'environment_config' is set
        if self.api_client.client_side_validation and ('environment_config' not in local_var_params or  # noqa: E501
                                                        local_var_params['environment_config'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `environment_config` when calling `env_config_post`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `env_config_post`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `env_config_post`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'environment_config' in local_var_params:
            body_params = local_var_params['environment_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def env_config_put(self, app_id, env_name, env_config_id, environment_config, **kwargs):  # noqa: E501
        """Update environment configuration  # noqa: E501

        Update environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_put(app_id, env_name, env_config_id, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param EnvironmentConfig environment_config: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EnvironmentConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.env_config_put_with_http_info(app_id, env_name, env_config_id, environment_config, **kwargs)  # noqa: E501

    def env_config_put_with_http_info(self, app_id, env_name, env_config_id, environment_config, **kwargs):  # noqa: E501
        """Update environment configuration  # noqa: E501

        Update environment configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.env_config_put_with_http_info(app_id, env_name, env_config_id, environment_config, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str env_config_id: environment configuration id (required)
        :param EnvironmentConfig environment_config: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EnvironmentConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'env_config_id', 'environment_config']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method env_config_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `env_config_put`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `env_config_put`")  # noqa: E501
        # verify the required parameter 'env_config_id' is set
        if self.api_client.client_side_validation and ('env_config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_config_id` when calling `env_config_put`")  # noqa: E501
        # verify the required parameter 'environment_config' is set
        if self.api_client.client_side_validation and ('environment_config' not in local_var_params or  # noqa: E501
                                                        local_var_params['environment_config'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `environment_config` when calling `env_config_put`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `env_config_put`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `env_config_put`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_config_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_config_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_config_id` when calling `env_config_put`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501
        if 'env_config_id' in local_var_params:
            path_params['env_config_id'] = local_var_params['env_config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'environment_config' in local_var_params:
            body_params = local_var_params['environment_config']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EnvironmentConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_application(self, app_id, **kwargs):  # noqa: E501
        """Get a application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_application(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_application_with_http_info(app_id, **kwargs)  # noqa: E501

    def get_application_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Get a application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_application_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Application, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'org_id', 'assigned_org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_application`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'assigned_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['assigned_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `assigned_org_id` when calling `get_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'assigned_org_id' in local_var_params and local_var_params['assigned_org_id'] is not None:  # noqa: E501
            query_params.append(('assigned_org_id', local_var_params['assigned_org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_applications(self, **kwargs):  # noqa: E501
        """Get applications  # noqa: E501

        Retrieves all applications related to the org_id. Different types of relationship may be queried by setting the appropriate flags:   - assigned: Has an Environment assigned to the organisation.   - owned: Owned by the organisation.   - maintained: Has an Environment maintained by the organisation. Any combination of the relationship flags may be set. Note that if the organisation does not own the Application, but maintains or is assigned an environment only those assignments and environments for the querying organisation will be shown.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_applications(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param bool maintained: Query for Applications maintained by the `org_id`. These are Applications which have an Environment whose `maintenance_org_id` is the `org_id`. 
        :param bool assigned: Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. 
        :param bool owned: Query for Applications owned by the `org_id`.
        :param datetime updated_since: query since updated
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Application]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_applications_with_http_info(**kwargs)  # noqa: E501

    def get_applications_with_http_info(self, **kwargs):  # noqa: E501
        """Get applications  # noqa: E501

        Retrieves all applications related to the org_id. Different types of relationship may be queried by setting the appropriate flags:   - assigned: Has an Environment assigned to the organisation.   - owned: Owned by the organisation.   - maintained: Has an Environment maintained by the organisation. Any combination of the relationship flags may be set. Note that if the organisation does not own the Application, but maintains or is assigned an environment only those assignments and environments for the querying organisation will be shown.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_applications_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str org_id: Organisation Unique identifier
        :param str assigned_org_id: Organisation unique identifier for an assigned object
        :param bool maintained: Query for Applications maintained by the `org_id`. These are Applications which have an Environment whose `maintenance_org_id` is the `org_id`. 
        :param bool assigned: Query for Applications assigned to the `org_id`. These are Applications with at least one Environment assigned to the `org_id`. 
        :param bool owned: Query for Applications owned by the `org_id`.
        :param datetime updated_since: query since updated
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Application], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['org_id', 'assigned_org_id', 'maintained', 'assigned', 'owned', 'updated_since']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_applications" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'assigned_org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['assigned_org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `assigned_org_id` when calling `get_applications`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'assigned_org_id' in local_var_params and local_var_params['assigned_org_id'] is not None:  # noqa: E501
            query_params.append(('assigned_org_id', local_var_params['assigned_org_id']))  # noqa: E501
        if 'maintained' in local_var_params and local_var_params['maintained'] is not None:  # noqa: E501
            query_params.append(('maintained', local_var_params['maintained']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501
        if 'owned' in local_var_params and local_var_params['owned'] is not None:  # noqa: E501
            query_params.append(('owned', local_var_params['owned']))  # noqa: E501
        if 'updated_since' in local_var_params and local_var_params['updated_since'] is not None:  # noqa: E501
            query_params.append(('updated_since', local_var_params['updated_since']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Application]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_environment(self, app_id, env_name, org_id, **kwargs):  # noqa: E501
        """Get an environment  # noqa: E501

        This allows an environment maintainer to get an environment they maintain.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment(app_id, env_name, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str org_id: Organisation unique identifier (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Environment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_environment_with_http_info(app_id, env_name, org_id, **kwargs)  # noqa: E501

    def get_environment_with_http_info(self, app_id, env_name, org_id, **kwargs):  # noqa: E501
        """Get an environment  # noqa: E501

        This allows an environment maintainer to get an environment they maintain.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_environment_with_http_info(app_id, env_name, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param str org_id: Organisation unique identifier (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Environment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_environment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `get_environment`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `get_environment`")  # noqa: E501
        # verify the required parameter 'org_id' is set
        if self.api_client.client_side_validation and ('org_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['org_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `org_id` when calling `get_environment`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `get_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `get_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'org_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['org_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `org_id` when calling `get_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Environment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_application(self, application, **kwargs):  # noqa: E501
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_application(application, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Application application: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Application
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.post_application_with_http_info(application, **kwargs)  # noqa: E501

    def post_application_with_http_info(self, application, **kwargs):  # noqa: E501
        """Create an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_application_with_http_info(application, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Application application: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Application, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['application']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'application' is set
        if self.api_client.client_side_validation and ('application' not in local_var_params or  # noqa: E501
                                                        local_var_params['application'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `application` when calling `post_application`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'application' in local_var_params:
            body_params = local_var_params['application']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Application',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_application(self, app_id, **kwargs):  # noqa: E501
        """Create or update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_application(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param Application application:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_application_with_http_info(app_id, **kwargs)  # noqa: E501

    def put_application_with_http_info(self, app_id, **kwargs):  # noqa: E501
        """Create or update an application  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_application_with_http_info(app_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param Application application:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'application']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_application" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `put_application`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `put_application`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'application' in local_var_params:
            body_params = local_var_params['application']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_environment(self, app_id, env_name, **kwargs):  # noqa: E501
        """Update an environment  # noqa: E501

        This allows an environment maintainer to update the environment. Note that the maintenence_organisation in the body must match the existing one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_environment(app_id, env_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param Environment environment:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.put_environment_with_http_info(app_id, env_name, **kwargs)  # noqa: E501

    def put_environment_with_http_info(self, app_id, env_name, **kwargs):  # noqa: E501
        """Update an environment  # noqa: E501

        This allows an environment maintainer to update the environment. Note that the maintenence_organisation in the body must match the existing one.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_environment_with_http_info(app_id, env_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str app_id: Application unique identifier (required)
        :param str env_name: The name of an Environment (required)
        :param Environment environment:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['app_id', 'env_name', 'environment']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_environment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'app_id' is set
        if self.api_client.client_side_validation and ('app_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['app_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `app_id` when calling `put_environment`")  # noqa: E501
        # verify the required parameter 'env_name' is set
        if self.api_client.client_side_validation and ('env_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['env_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `env_name` when calling `put_environment`")  # noqa: E501

        if self.api_client.client_side_validation and 'app_id' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['app_id']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `app_id` when calling `put_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'env_name' in local_var_params and not re.search(r'^[a-zA-Z0-9-]+$', local_var_params['env_name']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `env_name` when calling `put_environment`, must conform to the pattern `/^[a-zA-Z0-9-]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'app_id' in local_var_params:
            path_params['app_id'] = local_var_params['app_id']  # noqa: E501
        if 'env_name' in local_var_params:
            path_params['env_name'] = local_var_params['env_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'environment' in local_var_params:
            body_params = local_var_params['environment']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v2/applications/{app_id}/environments/{env_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
