# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.03.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class IssuersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clients_delete(self, issuer_id, client_id, **kwargs):  # noqa: E501
        """Delete a client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_delete(issuer_id, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clients_delete_with_http_info(issuer_id, client_id, **kwargs)  # noqa: E501

    def clients_delete_with_http_info(self, issuer_id, client_id, **kwargs):  # noqa: E501
        """Delete a client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_delete_with_http_info(issuer_id, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clients_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `clients_delete`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `clients_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clients_get(self, issuer_id, client_id, **kwargs):  # noqa: E501
        """Get client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_get(issuer_id, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IssuerClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clients_get_with_http_info(issuer_id, client_id, **kwargs)  # noqa: E501

    def clients_get_with_http_info(self, issuer_id, client_id, **kwargs):  # noqa: E501
        """Get client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_get_with_http_info(issuer_id, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IssuerClient, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clients_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `clients_get`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `clients_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IssuerClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clients_post(self, issuer_id, issuer_client, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_post(issuer_id, issuer_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param IssuerClient issuer_client: IssuerClient (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IssuerClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clients_post_with_http_info(issuer_id, issuer_client, **kwargs)  # noqa: E501

    def clients_post_with_http_info(self, issuer_id, issuer_client, **kwargs):  # noqa: E501
        """Create a client  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_post_with_http_info(issuer_id, issuer_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param IssuerClient issuer_client: IssuerClient (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IssuerClient, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'issuer_client']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clients_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `clients_post`")  # noqa: E501
        # verify the required parameter 'issuer_client' is set
        if self.api_client.client_side_validation and ('issuer_client' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_client'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_client` when calling `clients_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'issuer_client' in local_var_params:
            body_params = local_var_params['issuer_client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IssuerClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clients_put(self, issuer_id, client_id, issuer_client, **kwargs):  # noqa: E501
        """Update a client  # noqa: E501

        Update a client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_put(issuer_id, client_id, issuer_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param IssuerClient issuer_client: Issuer client (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IssuerClient
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clients_put_with_http_info(issuer_id, client_id, issuer_client, **kwargs)  # noqa: E501

    def clients_put_with_http_info(self, issuer_id, client_id, issuer_client, **kwargs):  # noqa: E501
        """Update a client  # noqa: E501

        Update a client  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_put_with_http_info(issuer_id, client_id, issuer_client, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param IssuerClient issuer_client: Issuer client (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IssuerClient, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id', 'issuer_client']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clients_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `clients_put`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `clients_put`")  # noqa: E501
        # verify the required parameter 'issuer_client' is set
        if self.api_client.client_side_validation and ('issuer_client' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_client'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_client` when calling `clients_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'issuer_client' in local_var_params:
            body_params = local_var_params['issuer_client']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IssuerClient',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def clients_query(self, issuer_id, **kwargs):  # noqa: E501
        """Query Clients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_query(issuer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param int limit: limit the number of rows in the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[IssuerClient]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clients_query_with_http_info(issuer_id, **kwargs)  # noqa: E501

    def clients_query_with_http_info(self, issuer_id, **kwargs):  # noqa: E501
        """Query Clients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clients_query_with_http_info(issuer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param int limit: limit the number of rows in the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[IssuerClient], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clients_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `clients_query`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `clients_query`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `clients_query`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IssuerClient]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issuers_delete(self, issuer_id, **kwargs):  # noqa: E501
        """Delete an Issuer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_delete(issuer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issuers_delete_with_http_info(issuer_id, **kwargs)  # noqa: E501

    def issuers_delete_with_http_info(self, issuer_id, **kwargs):  # noqa: E501
        """Delete an Issuer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_delete_with_http_info(issuer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issuers_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `issuers_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issuers_get(self, issuer_id, **kwargs):  # noqa: E501
        """Get issuer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_get(issuer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Issuer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issuers_get_with_http_info(issuer_id, **kwargs)  # noqa: E501

    def issuers_get_with_http_info(self, issuer_id, **kwargs):  # noqa: E501
        """Get issuer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_get_with_http_info(issuer_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Issuer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issuers_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `issuers_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issuer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issuers_post(self, issuer, **kwargs):  # noqa: E501
        """Create an issuer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_post(issuer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Issuer issuer: Issuer (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Issuer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issuers_post_with_http_info(issuer, **kwargs)  # noqa: E501

    def issuers_post_with_http_info(self, issuer, **kwargs):  # noqa: E501
        """Create an issuer  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_post_with_http_info(issuer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Issuer issuer: Issuer (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Issuer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issuers_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer' is set
        if self.api_client.client_side_validation and ('issuer' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer` when calling `issuers_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'issuer' in local_var_params:
            body_params = local_var_params['issuer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issuer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issuers_put(self, issuer_id, issuer, **kwargs):  # noqa: E501
        """Update an issuer  # noqa: E501

        Update an issuer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_put(issuer_id, issuer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param Issuer issuer: Issuer (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Issuer
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issuers_put_with_http_info(issuer_id, issuer, **kwargs)  # noqa: E501

    def issuers_put_with_http_info(self, issuer_id, issuer, **kwargs):  # noqa: E501
        """Update an issuer  # noqa: E501

        Update an issuer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_put_with_http_info(issuer_id, issuer, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param Issuer issuer: Issuer (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Issuer, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'issuer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issuers_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `issuers_put`")  # noqa: E501
        # verify the required parameter 'issuer' is set
        if self.api_client.client_side_validation and ('issuer' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer` when calling `issuers_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'issuer' in local_var_params:
            body_params = local_var_params['issuer']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Issuer',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issuers_query(self, **kwargs):  # noqa: E501
        """Query Issuers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_query(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str issuer: Organisation issuer
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Issuer]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.issuers_query_with_http_info(**kwargs)  # noqa: E501

    def issuers_query_with_http_info(self, **kwargs):  # noqa: E501
        """Query Issuers  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issuers_query_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str issuer: Organisation issuer
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Issuer], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'issuer']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issuers_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `issuers_query`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `issuers_query`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'issuer' in local_var_params and local_var_params['issuer'] is not None:  # noqa: E501
            query_params.append(('issuer', local_var_params['issuer']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Issuer]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def redirects_delete(self, issuer_id, client_id, redirect_id, **kwargs):  # noqa: E501
        """Delete a client redirect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_delete(issuer_id, client_id, redirect_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param str redirect_id: redirect_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.redirects_delete_with_http_info(issuer_id, client_id, redirect_id, **kwargs)  # noqa: E501

    def redirects_delete_with_http_info(self, issuer_id, client_id, redirect_id, **kwargs):  # noqa: E501
        """Delete a client redirect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_delete_with_http_info(issuer_id, client_id, redirect_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param str redirect_id: redirect_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id', 'redirect_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirects_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `redirects_delete`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `redirects_delete`")  # noqa: E501
        # verify the required parameter 'redirect_id' is set
        if self.api_client.client_side_validation and ('redirect_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['redirect_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `redirect_id` when calling `redirects_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501
        if 'redirect_id' in local_var_params:
            path_params['redirect_id'] = local_var_params['redirect_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}/redirects/{redirect_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def redirects_get(self, issuer_id, client_id, redirect_id, **kwargs):  # noqa: E501
        """Get redirect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_get(issuer_id, client_id, redirect_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param str redirect_id: redirect_id path (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IssuerClientRedirect
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.redirects_get_with_http_info(issuer_id, client_id, redirect_id, **kwargs)  # noqa: E501

    def redirects_get_with_http_info(self, issuer_id, client_id, redirect_id, **kwargs):  # noqa: E501
        """Get redirect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_get_with_http_info(issuer_id, client_id, redirect_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param str redirect_id: redirect_id path (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IssuerClientRedirect, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id', 'redirect_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirects_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `redirects_get`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `redirects_get`")  # noqa: E501
        # verify the required parameter 'redirect_id' is set
        if self.api_client.client_side_validation and ('redirect_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['redirect_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `redirect_id` when calling `redirects_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501
        if 'redirect_id' in local_var_params:
            path_params['redirect_id'] = local_var_params['redirect_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}/redirects/{redirect_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IssuerClientRedirect',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def redirects_post(self, issuer_id, client_id, issuer_client_redirect, **kwargs):  # noqa: E501
        """Create a redirect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_post(issuer_id, client_id, issuer_client_redirect, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param IssuerClientRedirect issuer_client_redirect: IssuerClientRedirect (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IssuerClientRedirect
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.redirects_post_with_http_info(issuer_id, client_id, issuer_client_redirect, **kwargs)  # noqa: E501

    def redirects_post_with_http_info(self, issuer_id, client_id, issuer_client_redirect, **kwargs):  # noqa: E501
        """Create a redirect  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_post_with_http_info(issuer_id, client_id, issuer_client_redirect, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param IssuerClientRedirect issuer_client_redirect: IssuerClientRedirect (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IssuerClientRedirect, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id', 'issuer_client_redirect']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirects_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `redirects_post`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `redirects_post`")  # noqa: E501
        # verify the required parameter 'issuer_client_redirect' is set
        if self.api_client.client_side_validation and ('issuer_client_redirect' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_client_redirect'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_client_redirect` when calling `redirects_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'issuer_client_redirect' in local_var_params:
            body_params = local_var_params['issuer_client_redirect']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}/redirects', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IssuerClientRedirect',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def redirects_query(self, issuer_id, client_id, **kwargs):  # noqa: E501
        """Query Redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_query(issuer_id, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param int limit: limit the number of rows in the response
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[IssuerClientRedirect]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.redirects_query_with_http_info(issuer_id, client_id, **kwargs)  # noqa: E501

    def redirects_query_with_http_info(self, issuer_id, client_id, **kwargs):  # noqa: E501
        """Query Redirects  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.redirects_query_with_http_info(issuer_id, client_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str issuer_id: issuer_id path (required)
        :param str client_id: client_id path (required)
        :param int limit: limit the number of rows in the response
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[IssuerClientRedirect], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['issuer_id', 'client_id', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method redirects_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'issuer_id' is set
        if self.api_client.client_side_validation and ('issuer_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['issuer_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `issuer_id` when calling `redirects_query`")  # noqa: E501
        # verify the required parameter 'client_id' is set
        if self.api_client.client_side_validation and ('client_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['client_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `client_id` when calling `redirects_query`")  # noqa: E501

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `redirects_query`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `redirects_query`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'issuer_id' in local_var_params:
            path_params['issuer_id'] = local_var_params['issuer_id']  # noqa: E501
        if 'client_id' in local_var_params:
            path_params['client_id'] = local_var_params['client_id']  # noqa: E501

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/issuers/{issuer_id}/clients/{client_id}/redirects', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[IssuerClientRedirect]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
