# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.03.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class LogsQueryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def query(self, dt_sort, **kwargs):  # noqa: E501
        """Query Elasticsearch  # noqa: E501

        Query Elasticsearch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query(dt_sort, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dt_sort: Sort order: *'asc' - ascending, from old to new logs *'desc' - descending, from new to old logs  (required)
        :param str dt_from: search critera, search logs from
        :param str dt_to: search critera, search logs to
        :param str app: search critera, search logs for an app
        :param int limit: limit number of output logs
        :param str org_id: query for a specific organization
        :param str sub_org_id: query for a specific sub-organization
        :param str env: query for a specific environment
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Log]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_with_http_info(dt_sort, **kwargs)  # noqa: E501

    def query_with_http_info(self, dt_sort, **kwargs):  # noqa: E501
        """Query Elasticsearch  # noqa: E501

        Query Elasticsearch  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_with_http_info(dt_sort, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str dt_sort: Sort order: *'asc' - ascending, from old to new logs *'desc' - descending, from new to old logs  (required)
        :param str dt_from: search critera, search logs from
        :param str dt_to: search critera, search logs to
        :param str app: search critera, search logs for an app
        :param int limit: limit number of output logs
        :param str org_id: query for a specific organization
        :param str sub_org_id: query for a specific sub-organization
        :param str env: query for a specific environment
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Log], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['dt_sort', 'dt_from', 'dt_to', 'app', 'limit', 'org_id', 'sub_org_id', 'env']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'dt_sort' is set
        if self.api_client.client_side_validation and ('dt_sort' not in local_var_params or  # noqa: E501
                                                        local_var_params['dt_sort'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `dt_sort` when calling `query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'dt_from' in local_var_params and local_var_params['dt_from'] is not None:  # noqa: E501
            query_params.append(('dt_from', local_var_params['dt_from']))  # noqa: E501
        if 'dt_to' in local_var_params and local_var_params['dt_to'] is not None:  # noqa: E501
            query_params.append(('dt_to', local_var_params['dt_to']))  # noqa: E501
        if 'app' in local_var_params and local_var_params['app'] is not None:  # noqa: E501
            query_params.append(('app', local_var_params['app']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501
        if 'sub_org_id' in local_var_params and local_var_params['sub_org_id'] is not None:  # noqa: E501
            query_params.append(('sub_org_id', local_var_params['sub_org_id']))  # noqa: E501
        if 'env' in local_var_params and local_var_params['env'] is not None:  # noqa: E501
            query_params.append(('env', local_var_params['env']))  # noqa: E501
        if 'dt_sort' in local_var_params and local_var_params['dt_sort'] is not None:  # noqa: E501
            query_params.append(('dt_sort', local_var_params['dt_sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/diagnostics/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Log]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
