# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.03.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from agilicus_api.api_client import ApiClient
from agilicus_api.exceptions import (
    ApiTypeError,
    ApiValueError
)


class ViewAuditRecordsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def audits_audit_query(self, **kwargs):  # noqa: E501
        """View audit records  # noqa: E501

        View audit records for any API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audits_audit_query(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str user_id: Query based on user id
        :param str dt_from: Search criteria from when the query happened. * Inclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". 
        :param str dt_to: Search criteria until when the query happened. * Exclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". 
        :param str action: the type of action which caused the log
        :param str target_id: The identifier for the target of the log (e.g. the jti of a created token). 
        :param str token_id: The id of the bearer token for which to find records.
        :param str api_name: The name of the API for which to find audit logs
        :param str org_id: Organisation Unique identifier
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AuditQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.audits_audit_query_with_http_info(**kwargs)  # noqa: E501

    def audits_audit_query_with_http_info(self, **kwargs):  # noqa: E501
        """View audit records  # noqa: E501

        View audit records for any API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.audits_audit_query_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: limit the number of rows in the response
        :param str user_id: Query based on user id
        :param str dt_from: Search criteria from when the query happened. * Inclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". 
        :param str dt_to: Search criteria until when the query happened. * Exclusive. * In UTC. * Supports human-friendly values such as \"now\", \"today\", \"now-1day\". 
        :param str action: the type of action which caused the log
        :param str target_id: The identifier for the target of the log (e.g. the jti of a created token). 
        :param str token_id: The id of the bearer token for which to find records.
        :param str api_name: The name of the API for which to find audit logs
        :param str org_id: Organisation Unique identifier
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AuditQueryResult, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ['limit', 'user_id', 'dt_from', 'dt_to', 'action', 'target_id', 'token_id', 'api_name', 'org_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method audits_audit_query" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `audits_audit_query`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `audits_audit_query`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('user_id', local_var_params['user_id']))  # noqa: E501
        if 'dt_from' in local_var_params and local_var_params['dt_from'] is not None:  # noqa: E501
            query_params.append(('dt_from', local_var_params['dt_from']))  # noqa: E501
        if 'dt_to' in local_var_params and local_var_params['dt_to'] is not None:  # noqa: E501
            query_params.append(('dt_to', local_var_params['dt_to']))  # noqa: E501
        if 'action' in local_var_params and local_var_params['action'] is not None:  # noqa: E501
            query_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'target_id' in local_var_params and local_var_params['target_id'] is not None:  # noqa: E501
            query_params.append(('target_id', local_var_params['target_id']))  # noqa: E501
        if 'token_id' in local_var_params and local_var_params['token_id'] is not None:  # noqa: E501
            query_params.append(('token_id', local_var_params['token_id']))  # noqa: E501
        if 'api_name' in local_var_params and local_var_params['api_name'] is not None:  # noqa: E501
            query_params.append(('api_name', local_var_params['api_name']))  # noqa: E501
        if 'org_id' in local_var_params and local_var_params['org_id'] is not None:  # noqa: E501
            query_params.append(('org_id', local_var_params['org_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['token-valid']  # noqa: E501

        return self.api_client.call_api(
            '/v1/audits', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuditQueryResult',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
