# agilicus_api.FilesApi

All URIs are relative to *https://api.agilicus.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**delete_file**](FilesApi.md#delete_file) | **DELETE** /v1/files/{file_id} | Delete a File
[**download**](FilesApi.md#download) | **GET** /v1/files/{file_id}/download | Download File
[**get_file**](FilesApi.md#get_file) | **GET** /v1/files/{file_id} | Get File metadata
[**post**](FilesApi.md#post) | **POST** /v1/files | upload a file
[**put_file**](FilesApi.md#put_file) | **PUT** /v1/files/{file_id} | Update a file
[**query_files**](FilesApi.md#query_files) | **GET** /v1/files | Query Files


# **delete_file**
> object delete_file(file_id, org_id=org_id)

Delete a File

Delete a File

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.FilesApi(api_client)
    file_id = '1234' # str | file_id path
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Delete a File
        api_response = api_instance.delete_file(file_id, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling FilesApi->delete_file: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_id** | **str**| file_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

**object**

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**204** | File was deleted |  -  |
**404** | File does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **download**
> file download(file_id, org_id=org_id)

Download File

Download File

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.FilesApi(api_client)
    file_id = '1234' # str | file_id path
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Download File
        api_response = api_instance.download(file_id, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling FilesApi->download: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_id** | **str**| file_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

**file**

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/octet-stream

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Downloaded |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **get_file**
> File get_file(file_id, org_id=org_id)

Get File metadata

Get File metadata

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.FilesApi(api_client)
    file_id = '1234' # str | file_id path
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Get File metadata
        api_response = api_instance.get_file(file_id, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling FilesApi->get_file: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_id** | **str**| file_id path | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

[**File**](File.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return File by id |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **post**
> file post(name, file_zip, org_id=org_id, tag=tag, label=label, region=region, md5_hash=md5_hash)

upload a file

Upload a file

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.FilesApi(api_client)
    name = 'name_example' # str | Name of file
file_zip = '/path/to/file' # file | 
org_id = 'org_id_example' # str | Unique identifier (optional)
tag = 'tag_example' # str | A file tag (optional)
label = 'label_example' # str | A file label (optional)
region = agilicus_api.StorageRegion() # StorageRegion |  (optional)
md5_hash = 'md5_hash_example' # str | MD5 Hash of file in base64 (optional)

    try:
        # upload a file
        api_response = api_instance.post(name, file_zip, org_id=org_id, tag=tag, label=label, region=region, md5_hash=md5_hash)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling FilesApi->post: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **str**| Name of file | 
 **file_zip** | **file**|  | 
 **org_id** | **str**| Unique identifier | [optional] 
 **tag** | **str**| A file tag | [optional] 
 **label** | **str**| A file label | [optional] 
 **region** | [**StorageRegion**](StorageRegion.md)|  | [optional] 
 **md5_hash** | **str**| MD5 Hash of file in base64 | [optional] 

### Return type

**file**

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: multipart/form-data
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**201** | Successfully uploaded file |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **put_file**
> File put_file(file_id, file, org_id=org_id)

Update a file

Update a file

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.FilesApi(api_client)
    file_id = '1234' # str | file_id path
file = '/path/to/file' # File | Upload file request
org_id = '1234' # str | Organisation Unique identifier (optional)

    try:
        # Update a file
        api_response = api_instance.put_file(file_id, file, org_id=org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling FilesApi->put_file: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **file_id** | **str**| file_id path | 
 **file** | [**File**](File.md)| Upload file request | 
 **org_id** | **str**| Organisation Unique identifier | [optional] 

### Return type

[**File**](File.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | File was updated |  -  |
**404** | File does not exist |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

# **query_files**
> list[FileSummary] query_files(limit=limit, org_id=org_id, user_id=user_id, tag=tag)

Query Files

Query Files

### Example

* Bearer (JWT) Authentication (token-valid):
```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint
configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.FilesApi(api_client)
    limit = 500 # int | limit the number of rows in the response (optional) (default to 500)
org_id = '1234' # str | Organisation Unique identifier (optional)
user_id = '1234' # str | Query based on user id (optional)
tag = 'theme' # str | Search files based on tag (optional)

    try:
        # Query Files
        api_response = api_instance.query_files(limit=limit, org_id=org_id, user_id=user_id, tag=tag)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling FilesApi->query_files: %s\n" % e)
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **int**| limit the number of rows in the response | [optional] [default to 500]
 **org_id** | **str**| Organisation Unique identifier | [optional] 
 **user_id** | **str**| Query based on user id | [optional] 
 **tag** | **str**| Search files based on tag | [optional] 

### Return type

[**list[FileSummary]**](FileSummary.md)

### Authorization

[token-valid](../README.md#token-valid)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details
| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Return files list |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

