# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.03.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from agilicus_api.configuration import Configuration


class ApplicationService(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'org_id': 'str',
        'hostname': 'str',
        'ipv4_addresses': 'list[str]',
        'name_resolution': 'str',
        'port': 'int',
        'protocol': 'str',
        'assignments': 'list[ApplicationServiceAssignment]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'org_id': 'org_id',
        'hostname': 'hostname',
        'ipv4_addresses': 'ipv4_addresses',
        'name_resolution': 'name_resolution',
        'port': 'port',
        'protocol': 'protocol',
        'assignments': 'assignments'
    }

    def __init__(self, id=None, name=None, org_id=None, hostname=None, ipv4_addresses=None, name_resolution='STATIC', port=None, protocol='TCP', assignments=None, local_vars_configuration=None):  # noqa: E501
        """ApplicationService - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._org_id = None
        self._hostname = None
        self._ipv4_addresses = None
        self._name_resolution = None
        self._port = None
        self._protocol = None
        self._assignments = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        self.org_id = org_id
        self.hostname = hostname
        if ipv4_addresses is not None:
            self.ipv4_addresses = ipv4_addresses
        if name_resolution is not None:
            self.name_resolution = name_resolution
        self.port = port
        if protocol is not None:
            self.protocol = protocol
        if assignments is not None:
            self.assignments = assignments

    @property
    def id(self):
        """Gets the id of this ApplicationService.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The id of this ApplicationService.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ApplicationService.

        Unique identifier  # noqa: E501

        :param id: The id of this ApplicationService.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this ApplicationService.  # noqa: E501

        The name of the service. Services will be selected and assigned using this. This value must be unique within an organisation.   # noqa: E501

        :return: The name of this ApplicationService.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ApplicationService.

        The name of the service. Services will be selected and assigned using this. This value must be unique within an organisation.   # noqa: E501

        :param name: The name of this ApplicationService.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def org_id(self):
        """Gets the org_id of this ApplicationService.  # noqa: E501

        The organisation which owns this service.  # noqa: E501

        :return: The org_id of this ApplicationService.  # noqa: E501
        :rtype: str
        """
        return self._org_id

    @org_id.setter
    def org_id(self, org_id):
        """Sets the org_id of this ApplicationService.

        The organisation which owns this service.  # noqa: E501

        :param org_id: The org_id of this ApplicationService.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and org_id is None:  # noqa: E501
            raise ValueError("Invalid value for `org_id`, must not be `None`")  # noqa: E501

        self._org_id = org_id

    @property
    def hostname(self):
        """Gets the hostname of this ApplicationService.  # noqa: E501

        The hostname of the service. Your applications will refer to this service using its hostname.   # noqa: E501

        :return: The hostname of this ApplicationService.  # noqa: E501
        :rtype: str
        """
        return self._hostname

    @hostname.setter
    def hostname(self, hostname):
        """Sets the hostname of this ApplicationService.

        The hostname of the service. Your applications will refer to this service using its hostname.   # noqa: E501

        :param hostname: The hostname of this ApplicationService.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and hostname is None:  # noqa: E501
            raise ValueError("Invalid value for `hostname`, must not be `None`")  # noqa: E501

        self._hostname = hostname

    @property
    def ipv4_addresses(self):
        """Gets the ipv4_addresses of this ApplicationService.  # noqa: E501

        The IPv4 addresses of `hostname` within the data center.  # noqa: E501

        :return: The ipv4_addresses of this ApplicationService.  # noqa: E501
        :rtype: list[str]
        """
        return self._ipv4_addresses

    @ipv4_addresses.setter
    def ipv4_addresses(self, ipv4_addresses):
        """Sets the ipv4_addresses of this ApplicationService.

        The IPv4 addresses of `hostname` within the data center.  # noqa: E501

        :param ipv4_addresses: The ipv4_addresses of this ApplicationService.  # noqa: E501
        :type: list[str]
        """

        self._ipv4_addresses = ipv4_addresses

    @property
    def name_resolution(self):
        """Gets the name_resolution of this ApplicationService.  # noqa: E501

        How to resolve the hostname of the service. If STATIC, then ipv4_address will be used. Otherwise, if DNS the Organisation's DNS services will be queried.   # noqa: E501

        :return: The name_resolution of this ApplicationService.  # noqa: E501
        :rtype: str
        """
        return self._name_resolution

    @name_resolution.setter
    def name_resolution(self, name_resolution):
        """Sets the name_resolution of this ApplicationService.

        How to resolve the hostname of the service. If STATIC, then ipv4_address will be used. Otherwise, if DNS the Organisation's DNS services will be queried.   # noqa: E501

        :param name_resolution: The name_resolution of this ApplicationService.  # noqa: E501
        :type: str
        """
        allowed_values = ["STATIC", "DNS"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and name_resolution not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `name_resolution` ({0}), must be one of {1}"  # noqa: E501
                .format(name_resolution, allowed_values)
            )

        self._name_resolution = name_resolution

    @property
    def port(self):
        """Gets the port of this ApplicationService.  # noqa: E501

        The transport-layer port on which to access the service. exclusiveMinimum: 0 exclusiveMaximum: 65536   # noqa: E501

        :return: The port of this ApplicationService.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this ApplicationService.

        The transport-layer port on which to access the service. exclusiveMinimum: 0 exclusiveMaximum: 65536   # noqa: E501

        :param port: The port of this ApplicationService.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and port is None:  # noqa: E501
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def protocol(self):
        """Gets the protocol of this ApplicationService.  # noqa: E501

        The transport-layer protocol over which to communicate with the service.   # noqa: E501

        :return: The protocol of this ApplicationService.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ApplicationService.

        The transport-layer protocol over which to communicate with the service.   # noqa: E501

        :param protocol: The protocol of this ApplicationService.  # noqa: E501
        :type: str
        """
        allowed_values = ["TCP"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and protocol not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `protocol` ({0}), must be one of {1}"  # noqa: E501
                .format(protocol, allowed_values)
            )

        self._protocol = protocol

    @property
    def assignments(self):
        """Gets the assignments of this ApplicationService.  # noqa: E501

        The Application Environments which have access to this ApplicationService. Manipulate this list to add or remove access to the ApplicationService.   # noqa: E501

        :return: The assignments of this ApplicationService.  # noqa: E501
        :rtype: list[ApplicationServiceAssignment]
        """
        return self._assignments

    @assignments.setter
    def assignments(self, assignments):
        """Sets the assignments of this ApplicationService.

        The Application Environments which have access to this ApplicationService. Manipulate this list to add or remove access to the ApplicationService.   # noqa: E501

        :param assignments: The assignments of this ApplicationService.  # noqa: E501
        :type: list[ApplicationServiceAssignment]
        """

        self._assignments = assignments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ApplicationService):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ApplicationService):
            return True

        return self.to_dict() != other.to_dict()
