# coding: utf-8

"""
    Agilicus API

    Agilicus API endpoints  # noqa: E501

    The version of the OpenAPI document: 2020.03.06
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from agilicus_api.configuration import Configuration


class Issuer(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'issuer': 'str',
        'clients': 'list[IssuerClient]'
    }

    attribute_map = {
        'id': 'id',
        'issuer': 'issuer',
        'clients': 'clients'
    }

    def __init__(self, id=None, issuer=None, clients=None, local_vars_configuration=None):  # noqa: E501
        """Issuer - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._issuer = None
        self._clients = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.issuer = issuer
        if clients is not None:
            self.clients = clients

    @property
    def id(self):
        """Gets the id of this Issuer.  # noqa: E501

        Unique identifier  # noqa: E501

        :return: The id of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Issuer.

        Unique identifier  # noqa: E501

        :param id: The id of this Issuer.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def issuer(self):
        """Gets the issuer of this Issuer.  # noqa: E501

        connect id issuer  # noqa: E501

        :return: The issuer of this Issuer.  # noqa: E501
        :rtype: str
        """
        return self._issuer

    @issuer.setter
    def issuer(self, issuer):
        """Sets the issuer of this Issuer.

        connect id issuer  # noqa: E501

        :param issuer: The issuer of this Issuer.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and issuer is None:  # noqa: E501
            raise ValueError("Invalid value for `issuer`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                issuer is not None and len(issuer) > 100):
            raise ValueError("Invalid value for `issuer`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                issuer is not None and len(issuer) < 1):
            raise ValueError("Invalid value for `issuer`, length must be greater than or equal to `1`")  # noqa: E501

        self._issuer = issuer

    @property
    def clients(self):
        """Gets the clients of this Issuer.  # noqa: E501


        :return: The clients of this Issuer.  # noqa: E501
        :rtype: list[IssuerClient]
        """
        return self._clients

    @clients.setter
    def clients(self, clients):
        """Sets the clients of this Issuer.


        :param clients: The clients of this Issuer.  # noqa: E501
        :type: list[IssuerClient]
        """

        self._clients = clients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Issuer):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Issuer):
            return True

        return self.to_dict() != other.to_dict()
