# agilicus-api
Agilicus API endpoints

The `agilicus_api` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2020.03.06
- Package version: 1.5.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.agilicus.com](https://www.agilicus.com)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.15
* six >= 1.10
* certifi
* python-dateutil

## Getting Started

In your own code, to use this library to connect and interact with agilicus-api,
you can run the following:

```python
from __future__ import print_function
import time
import agilicus_api
from agilicus_api.rest import ApiException
from pprint import pprint

configuration = agilicus_api.Configuration()
# Configure Bearer authorization (JWT): token-valid
configuration.access_token = 'YOUR_BEARER_TOKEN'

# Defining host is optional and default to https://api.agilicus.com
configuration.host = "https://api.agilicus.com"
# Enter a context with an instance of the API client
with agilicus_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = agilicus_api.ApplicationServicesApi(api_client)
    app_service_id = 'app_service_id_example' # str | Application Service unique identifier
org_id = 'org_id_example' # str | Organisation unique identifier

    try:
        # Remove an ApplicationService
        api_response = api_instance.delete_application_service(app_service_id, org_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ApplicationServicesApi->delete_application_service: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://api.agilicus.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ApplicationServicesApi* | [**delete_application_service**](agilicus_api/docs/ApplicationServicesApi.md#delete_application_service) | **DELETE** /v2/application_services/{app_service_id} | Remove an ApplicationService
*ApplicationServicesApi* | [**get_application_service**](agilicus_api/docs/ApplicationServicesApi.md#get_application_service) | **GET** /v2/application_services/{app_service_id} | Get a single ApplicationService
*ApplicationServicesApi* | [**get_application_services**](agilicus_api/docs/ApplicationServicesApi.md#get_application_services) | **GET** /v2/application_services | Get a subset of the ApplicationServices
*ApplicationServicesApi* | [**post_application_service**](agilicus_api/docs/ApplicationServicesApi.md#post_application_service) | **POST** /v2/application_services | Create an ApplicationService
*ApplicationServicesApi* | [**put_application_service**](agilicus_api/docs/ApplicationServicesApi.md#put_application_service) | **PUT** /v2/application_services/{app_service_id} | Create or update an Application Service.
*ApplicationsApi* | [**delete_application**](agilicus_api/docs/ApplicationsApi.md#delete_application) | **DELETE** /v2/applications/{app_id} | Remove an application
*ApplicationsApi* | [**env_config_delete**](agilicus_api/docs/ApplicationsApi.md#env_config_delete) | **DELETE** /v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id} | Remove an environment configuration
*ApplicationsApi* | [**env_config_get**](agilicus_api/docs/ApplicationsApi.md#env_config_get) | **GET** /v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id} | Get environment configuration
*ApplicationsApi* | [**env_config_get_all**](agilicus_api/docs/ApplicationsApi.md#env_config_get_all) | **GET** /v2/applications/{app_id}/environments/{env_name}/configs | Get all environment configuration
*ApplicationsApi* | [**env_config_post**](agilicus_api/docs/ApplicationsApi.md#env_config_post) | **POST** /v2/applications/{app_id}/environments/{env_name}/configs | Add an environment configuration row
*ApplicationsApi* | [**env_config_put**](agilicus_api/docs/ApplicationsApi.md#env_config_put) | **PUT** /v2/applications/{app_id}/environments/{env_name}/configs/{env_config_id} | Update environment configuration
*ApplicationsApi* | [**get_application**](agilicus_api/docs/ApplicationsApi.md#get_application) | **GET** /v2/applications/{app_id} | Get a application
*ApplicationsApi* | [**get_applications**](agilicus_api/docs/ApplicationsApi.md#get_applications) | **GET** /v2/applications | Get applications
*ApplicationsApi* | [**get_environment**](agilicus_api/docs/ApplicationsApi.md#get_environment) | **GET** /v2/applications/{app_id}/environments/{env_name} | Get an environment
*ApplicationsApi* | [**post_application**](agilicus_api/docs/ApplicationsApi.md#post_application) | **POST** /v2/applications | Create an application
*ApplicationsApi* | [**put_application**](agilicus_api/docs/ApplicationsApi.md#put_application) | **PUT** /v2/applications/{app_id} | Create or update an application
*ApplicationsApi* | [**put_environment**](agilicus_api/docs/ApplicationsApi.md#put_environment) | **PUT** /v2/applications/{app_id}/environments/{env_name} | Update an environment
*FilesApi* | [**delete_file**](agilicus_api/docs/FilesApi.md#delete_file) | **DELETE** /v1/files/{file_id} | Delete a File
*FilesApi* | [**download**](agilicus_api/docs/FilesApi.md#download) | **GET** /v1/files/{file_id}/download | Download File
*FilesApi* | [**get_file**](agilicus_api/docs/FilesApi.md#get_file) | **GET** /v1/files/{file_id} | Get File metadata
*FilesApi* | [**post**](agilicus_api/docs/FilesApi.md#post) | **POST** /v1/files | upload a file
*FilesApi* | [**put_file**](agilicus_api/docs/FilesApi.md#put_file) | **PUT** /v1/files/{file_id} | Update a file
*FilesApi* | [**query_files**](agilicus_api/docs/FilesApi.md#query_files) | **GET** /v1/files | Query Files
*GroupsApi* | [**add_group_member**](agilicus_api/docs/GroupsApi.md#add_group_member) | **POST** /v1/groups/{group_id}/members | Add a group member
*GroupsApi* | [**delete_group**](agilicus_api/docs/GroupsApi.md#delete_group) | **DELETE** /v1/groups/{group_id} | Delete a group
*GroupsApi* | [**delete_group_member**](agilicus_api/docs/GroupsApi.md#delete_group_member) | **DELETE** /v1/groups/{group_id}/members/{member_id} | Remove a group member
*GroupsApi* | [**get_group**](agilicus_api/docs/GroupsApi.md#get_group) | **GET** /v1/groups/{group_id} | Get a group
*GroupsApi* | [**get_groups**](agilicus_api/docs/GroupsApi.md#get_groups) | **GET** /v1/groups | Get all groups
*GroupsApi* | [**post_group**](agilicus_api/docs/GroupsApi.md#post_group) | **POST** /v1/groups | Create a group
*GroupsApi* | [**put_group**](agilicus_api/docs/GroupsApi.md#put_group) | **PUT** /v1/groups/{group_id} | update a group
*IssuersApi* | [**clients_delete**](agilicus_api/docs/IssuersApi.md#clients_delete) | **DELETE** /v1/issuers/{issuer_id}/clients/{client_id} | Delete a client
*IssuersApi* | [**clients_get**](agilicus_api/docs/IssuersApi.md#clients_get) | **GET** /v1/issuers/{issuer_id}/clients/{client_id} | Get client
*IssuersApi* | [**clients_post**](agilicus_api/docs/IssuersApi.md#clients_post) | **POST** /v1/issuers/{issuer_id}/clients | Create a client
*IssuersApi* | [**clients_put**](agilicus_api/docs/IssuersApi.md#clients_put) | **PUT** /v1/issuers/{issuer_id}/clients/{client_id} | Update a client
*IssuersApi* | [**clients_query**](agilicus_api/docs/IssuersApi.md#clients_query) | **GET** /v1/issuers/{issuer_id}/clients | Query Clients
*IssuersApi* | [**issuers_delete**](agilicus_api/docs/IssuersApi.md#issuers_delete) | **DELETE** /v1/issuers/{issuer_id} | Delete an Issuer
*IssuersApi* | [**issuers_get**](agilicus_api/docs/IssuersApi.md#issuers_get) | **GET** /v1/issuers/{issuer_id} | Get issuer
*IssuersApi* | [**issuers_post**](agilicus_api/docs/IssuersApi.md#issuers_post) | **POST** /v1/issuers | Create an issuer
*IssuersApi* | [**issuers_put**](agilicus_api/docs/IssuersApi.md#issuers_put) | **PUT** /v1/issuers/{issuer_id} | Update an issuer
*IssuersApi* | [**issuers_query**](agilicus_api/docs/IssuersApi.md#issuers_query) | **GET** /v1/issuers | Query Issuers
*IssuersApi* | [**redirects_delete**](agilicus_api/docs/IssuersApi.md#redirects_delete) | **DELETE** /v1/issuers/{issuer_id}/clients/{client_id}/redirects/{redirect_id} | Delete a client redirect
*IssuersApi* | [**redirects_get**](agilicus_api/docs/IssuersApi.md#redirects_get) | **GET** /v1/issuers/{issuer_id}/clients/{client_id}/redirects/{redirect_id} | Get redirect
*IssuersApi* | [**redirects_post**](agilicus_api/docs/IssuersApi.md#redirects_post) | **POST** /v1/issuers/{issuer_id}/clients/{client_id}/redirects | Create a redirect
*IssuersApi* | [**redirects_query**](agilicus_api/docs/IssuersApi.md#redirects_query) | **GET** /v1/issuers/{issuer_id}/clients/{client_id}/redirects | Query Redirects
*LogsQueryApi* | [**query**](agilicus_api/docs/LogsQueryApi.md#query) | **GET** /v1/diagnostics/logs | Query Elasticsearch
*MetricsApi* | [**metrics_metrics_query_active**](agilicus_api/docs/MetricsApi.md#metrics_metrics_query_active) | **GET** /v1/metrics/{org_id}/users:active | 
*MetricsApi* | [**metrics_metrics_query_top**](agilicus_api/docs/MetricsApi.md#metrics_metrics_query_top) | **GET** /v1/metrics/{org_id}/users:top | View top users
*OrganisationsApi* | [**delete_sub_org**](agilicus_api/docs/OrganisationsApi.md#delete_sub_org) | **DELETE** /v1/orgs/{org_id}/orgs/{sub_org_id} | Delete a sub organisation
*OrganisationsApi* | [**get_org**](agilicus_api/docs/OrganisationsApi.md#get_org) | **GET** /v1/orgs/{org_id} | Get a single organisation
*OrganisationsApi* | [**get_orgs**](agilicus_api/docs/OrganisationsApi.md#get_orgs) | **GET** /v1/orgs | Get all organisations
*OrganisationsApi* | [**get_sub_orgs**](agilicus_api/docs/OrganisationsApi.md#get_sub_orgs) | **GET** /v1/orgs/{org_id}/orgs | Get all sub organisations
*OrganisationsApi* | [**post_org**](agilicus_api/docs/OrganisationsApi.md#post_org) | **POST** /v1/orgs | Create an organisation
*OrganisationsApi* | [**post_sub_org**](agilicus_api/docs/OrganisationsApi.md#post_sub_org) | **POST** /v1/orgs/{org_id}/orgs | Create a sub organisation
*OrganisationsApi* | [**post_upgrade_orgs**](agilicus_api/docs/OrganisationsApi.md#post_upgrade_orgs) | **POST** /v1/orgs/upgrade | utility to upgrade organisations
*OrganisationsApi* | [**put_org**](agilicus_api/docs/OrganisationsApi.md#put_org) | **PUT** /v1/orgs/{org_id} | Create or update an organisation
*ServicesApi* | [**delete_service**](agilicus_api/docs/ServicesApi.md#delete_service) | **DELETE** /v2/services/{service_id} | Remove a Service
*ServicesApi* | [**get_service**](agilicus_api/docs/ServicesApi.md#get_service) | **GET** /v2/services/{service_id} | Get a single Service
*ServicesApi* | [**get_services**](agilicus_api/docs/ServicesApi.md#get_services) | **GET** /v2/services | Get a subset of the Services
*ServicesApi* | [**post_service**](agilicus_api/docs/ServicesApi.md#post_service) | **POST** /v2/services | Create a Service
*ServicesApi* | [**put_service**](agilicus_api/docs/ServicesApi.md#put_service) | **PUT** /v2/services/{service_id} | Create or update a Service.
*TokensApi* | [**introspect_token**](agilicus_api/docs/TokensApi.md#introspect_token) | **POST** /v1/tokens/introspect | Introspect a token
*TokensApi* | [**post_creator**](agilicus_api/docs/TokensApi.md#post_creator) | **POST** /v1/tokens | Create a token
*TokensApi* | [**query_tokens**](agilicus_api/docs/TokensApi.md#query_tokens) | **GET** /v1/tokens | Query tokens
*TokensApi* | [**revoke_token**](agilicus_api/docs/TokensApi.md#revoke_token) | **POST** /v1/tokens/revoke | Revoke a token
*UsersApi* | [**delete_user**](agilicus_api/docs/UsersApi.md#delete_user) | **DELETE** /v1/orgs/{org_id}/users/{user_id} | Remove a user from an organisation
*UsersApi* | [**get_all_user_orgs**](agilicus_api/docs/UsersApi.md#get_all_user_orgs) | **GET** /users/{user_id}/orgs | Return all organisations a user has been assigned to
*UsersApi* | [**get_all_user_roles**](agilicus_api/docs/UsersApi.md#get_all_user_roles) | **GET** /users/{user_id}/render_roles | Return all roles for a user
*UsersApi* | [**get_user**](agilicus_api/docs/UsersApi.md#get_user) | **GET** /users/{user_id} | Get a single user
*UsersApi* | [**get_user_permissions**](agilicus_api/docs/UsersApi.md#get_user_permissions) | **GET** /users/{user_id}/host_permissions | Return the user&#39;s host permissions
*UsersApi* | [**get_users**](agilicus_api/docs/UsersApi.md#get_users) | **GET** /users | Get all users
*UsersApi* | [**get_users_list**](agilicus_api/docs/UsersApi.md#get_users_list) | **GET** /users:ids | Get a list of all user GUIDs
*UsersApi* | [**post_user**](agilicus_api/docs/UsersApi.md#post_user) | **POST** /users | Create a user
*UsersApi* | [**put_user**](agilicus_api/docs/UsersApi.md#put_user) | **PUT** /users/{user_id} | Create or update a user
*UsersApi* | [**put_user_role**](agilicus_api/docs/UsersApi.md#put_user_role) | **PUT** /users/{user_id}/roles | Create or update a user role
*ViewAuditRecordsApi* | [**audits_audit_query**](agilicus_api/docs/ViewAuditRecordsApi.md#audits_audit_query) | **GET** /v1/audits | View audit records
*WhoamiApi* | [**post_whoami**](agilicus_api/docs/WhoamiApi.md#post_whoami) | **POST** /v1/whoami | login through whoami


## Documentation For Models

 - [Application](agilicus_api/docs/Application.md)
 - [ApplicationAssignment](agilicus_api/docs/ApplicationAssignment.md)
 - [ApplicationService](agilicus_api/docs/ApplicationService.md)
 - [ApplicationServiceAssignment](agilicus_api/docs/ApplicationServiceAssignment.md)
 - [AuditQueryResult](agilicus_api/docs/AuditQueryResult.md)
 - [AuditQueryResultResults](agilicus_api/docs/AuditQueryResultResults.md)
 - [Definition](agilicus_api/docs/Definition.md)
 - [Environment](agilicus_api/docs/Environment.md)
 - [EnvironmentConfig](agilicus_api/docs/EnvironmentConfig.md)
 - [File](agilicus_api/docs/File.md)
 - [FileSummary](agilicus_api/docs/FileSummary.md)
 - [FileUpload](agilicus_api/docs/FileUpload.md)
 - [Group](agilicus_api/docs/Group.md)
 - [GroupData](agilicus_api/docs/GroupData.md)
 - [GroupMember](agilicus_api/docs/GroupMember.md)
 - [GroupMemberAdd](agilicus_api/docs/GroupMemberAdd.md)
 - [GroupMemberData](agilicus_api/docs/GroupMemberData.md)
 - [HostPermissions](agilicus_api/docs/HostPermissions.md)
 - [HostPermissionsAllowedList](agilicus_api/docs/HostPermissionsAllowedList.md)
 - [HostPermissionsQueryParameters](agilicus_api/docs/HostPermissionsQueryParameters.md)
 - [Issuer](agilicus_api/docs/Issuer.md)
 - [IssuerClient](agilicus_api/docs/IssuerClient.md)
 - [IssuerClientRedirect](agilicus_api/docs/IssuerClientRedirect.md)
 - [Log](agilicus_api/docs/Log.md)
 - [NumActiveUsers](agilicus_api/docs/NumActiveUsers.md)
 - [NumActiveUsersActiveUsers](agilicus_api/docs/NumActiveUsersActiveUsers.md)
 - [Organisation](agilicus_api/docs/Organisation.md)
 - [OrganisationAdmin](agilicus_api/docs/OrganisationAdmin.md)
 - [RawToken](agilicus_api/docs/RawToken.md)
 - [Role](agilicus_api/docs/Role.md)
 - [RolesUpdate](agilicus_api/docs/RolesUpdate.md)
 - [Rule](agilicus_api/docs/Rule.md)
 - [RuleBody](agilicus_api/docs/RuleBody.md)
 - [RuleBodyJson](agilicus_api/docs/RuleBodyJson.md)
 - [RuleQueryParameters](agilicus_api/docs/RuleQueryParameters.md)
 - [Service](agilicus_api/docs/Service.md)
 - [StorageRegion](agilicus_api/docs/StorageRegion.md)
 - [Token](agilicus_api/docs/Token.md)
 - [TokenRequest](agilicus_api/docs/TokenRequest.md)
 - [TokenRequestTimeValidity](agilicus_api/docs/TokenRequestTimeValidity.md)
 - [TokenRequestValidity](agilicus_api/docs/TokenRequestValidity.md)
 - [TokenRevoke](agilicus_api/docs/TokenRevoke.md)
 - [TopUsers](agilicus_api/docs/TopUsers.md)
 - [TopUsersTopNUsers](agilicus_api/docs/TopUsersTopNUsers.md)
 - [User](agilicus_api/docs/User.md)
 - [UserIdentity](agilicus_api/docs/UserIdentity.md)
 - [UserInfo](agilicus_api/docs/UserInfo.md)
 - [UserLoginInfo](agilicus_api/docs/UserLoginInfo.md)
 - [UserMemberOf](agilicus_api/docs/UserMemberOf.md)
 - [UserSummary](agilicus_api/docs/UserSummary.md)


## Documentation For Authorization


## any-application-role-jwt

- **Type**: Bearer authentication (JWT)


## creator-bearer-jwt

- **Type**: Bearer authentication (JWT)


## creator-or-authorizer-bearer-jwt

- **Type**: Bearer authentication (JWT)


## creator-or-owner-bearer-jwt

- **Type**: Bearer authentication (JWT)


## creator-or-owner-or-user-bearer-jwt

- **Type**: Bearer authentication (JWT)


## creator-or-user-bearer-jwt

- **Type**: Bearer authentication (JWT)


## creator-self-owner-bearer-jwt

- **Type**: Bearer authentication (JWT)


## token-valid

- **Type**: Bearer authentication (JWT)


## Author

dev@agilicus.com


