#ifndef PACKING_H
#define PACKING_H

#include "api.h"
#include "params.h"
#include "polyvec.h"

void pack_pk(
    uint8_t pk[CRYPTO_PUBLICKEYBYTES],
    const uint8_t rho[SEEDBYTES],
    const polyveck *t1);
void pack_sk(
    uint8_t sk[CRYPTO_SECRETKEYBYTES],
    const uint8_t rho[SEEDBYTES],
    const uint8_t key[SEEDBYTES],
    const uint8_t tr[SEEDBYTES],
    const polyvecl *s1,
    const polyveck *s2,
    const polyveck *t0);
void pack_sig(
    uint8_t sig[CRYPTO_SECRETKEYBYTES],
    const polyvecl *z, const polyveck *h, const poly *c);

void unpack_pk(
    uint8_t rho[SEEDBYTES],
    polyveck *t1,
    const uint8_t pk[CRYPTO_PUBLICKEYBYTES]);
void unpack_sk(
    uint8_t rho[SEEDBYTES],
    uint8_t key[SEEDBYTES],
    uint8_t tr[CRHBYTES],
    polyvecl *s1,
    polyveck *s2,
    polyveck *t0,
    const uint8_t *sk);
int unpack_sig(
    polyvecl *z,
    polyveck *h,
    poly *c,
    const uint8_t sig[CRYPTO_BYTES]);

#endif
