#ifndef PARAMS_H
#define PARAMS_H

//#define CRYPTO_SECRETKEYBYTES CRYPTO_SECRETKEYBYTES
//#define CRYPTO_PUBLICKEYBYTES CRYPTO_PUBLICKEYBYTES
//#define CRYPTO_BYTES CRYPTO_BYTES
//#define CRYPTO_CIPHERTEXTBYTES CRYPTO_CIPHERTEXTBYTES

#define PARAMS_N 1344
#define PARAMS_NBAR 8
#define PARAMS_LOGQ 16
#define PARAMS_Q (1 << PARAMS_LOGQ)
#define PARAMS_EXTRACTED_BITS 4
#define PARAMS_STRIPE_STEP 8
#define PARAMS_PARALLEL 4
#define BYTES_SEED_A 16
#define BYTES_MU ((PARAMS_EXTRACTED_BITS * PARAMS_NBAR * PARAMS_NBAR) / 8)
#define BYTES_PKHASH CRYPTO_BYTES

// Selecting SHAKE XOF function for the KEM and noise sampling
#define shake     shake256

// CDF table
#define CDF_TABLE_DATA {9142, 23462, 30338, 32361, 32725, 32765, 32767}
#define CDF_TABLE_LEN 7

#endif
