# Publishing zach-tiktok to PyPI

Panduan lengkap untuk publish package `zach-tiktok` ke PyPI.

## Prerequisites

Sebelum publish, pastikan Anda sudah:

1. ✅ Package sudah di-build (file ada di folder `dist/`)
2. ✅ Memiliki akun PyPI di https://pypi.org/account/register/
3. ✅ Memiliki API token PyPI (akan dibuat di langkah berikutnya)

## Langkah 1: Buat Akun PyPI

1. Buka https://pypi.org/account/register/
2. Isi form registrasi
3. Verifikasi email Anda
4. Login ke akun PyPI

## Langkah 2: Buat API Token

1. Login ke PyPI: https://pypi.org/
2. Pergi ke Account Settings → API tokens
3. Klik "Add API token"
4. Nama: `zach-tiktok-upload`
5. Scope: **"Entire account"** (untuk upload pertama kali)
6. **SIMPAN TOKEN INI!** Token hanya ditampilkan sekali!
   ```
   pypi-AgEIcHlwaS5vcmcC...
   ```

## Langkah 3: Install Twine

Twine adalah tool untuk upload package ke PyPI:

```bash
# Install twine
uv add --group dev twine

# Atau dengan pip
pip install twine
```

## Langkah 4: Upload ke PyPI

### Test Upload ke TestPyPI (Opsional)

Disarankan untuk test di TestPyPI dulu sebelum upload ke PyPI yang sebenarnya:

```bash
# Upload ke TestPyPI
uv run twine upload --repository testpypi dist/*
```

Masukkan:
- Username: `__token__`
- Password: `<paste API token Anda>`

Test install:
```bash
pip install --index-url https://test.pypi.org/simple/ zach-tiktok
```

### Upload ke PyPI Production

Jika test berhasil, upload ke PyPI production:

```bash
# Upload ke PyPI
uv run twine upload dist/*
```

Masukkan:
- Username: `__token__`
- Password: `<paste API token Anda>`

## Langkah 5: Verifikasi

Cek apakah package sudah tersedia:

1. Buka: https://pypi.org/project/zach-tiktok/
2. Test install:
   ```bash
   pip install zach-tiktok
   ```

## Cara Menggunakan Package

Setelah di-install, users bisa:

```bash
# Install
pip install zach-tiktok

# Gunakan CLI
zach-tiktok -v video.mp4 -d "description" -c cookies.txt

# Atau gunakan via Python
```

```python
from tiktok_uploader.upload import upload_videos
from tiktok_uploader.auth import AuthBackend

videos = [{'video': 'video.mp4', 'description': 'test'}]
auth = AuthBackend(cookies='cookies.txt')

failed = upload_videos(videos=videos, auth=auth, headless=False)
```

**PENTING:** Module name tetap `tiktok_uploader` meskipun package name adalah `zach-tiktok`!

## Update Version Selanjutnya

Untuk publish versi baru:

1. Update version di `pyproject.toml`:
   ```toml
   version = "1.2.1"  # increment version
   ```

2. Rebuild package:
   ```bash
   # Hapus build lama
   rm -rf dist/

   # Build ulang
   uv build
   ```

3. Upload versi baru:
   ```bash
   uv run twine upload dist/*
   ```

## Troubleshooting

### Error: "File already exists"

Artinya version tersebut sudah di-upload. Anda harus increment version number di `pyproject.toml`.

### Error: "Invalid credentials"

- Pastikan username adalah `__token__` (dengan 2 underscore)
- Pastikan API token di-copy dengan benar
- Token harus dimulai dengan `pypi-`

### Error: "Package name already taken"

Nama `zach-tiktok` sudah diambil orang lain. Pilih nama lain seperti:
- `zach-tiktok-uploader`
- `zachs-tiktok`
- `tiktok-zach`

Ubah di `pyproject.toml` → `name = "nama-baru"`

## Security Best Practices

1. ✅ Jangan commit API token ke git
2. ✅ Gunakan token dengan scope minimal
3. ✅ Revoke token jika sudah tidak dipakai
4. ✅ Buat token baru untuk setiap project

## Dokumentasi Tambahan

- PyPI Guide: https://packaging.python.org/tutorials/packaging-projects/
- Twine Docs: https://twine.readthedocs.io/
- UV Docs: https://docs.astral.sh/uv/

---

## Quick Reference

```bash
# Build package
uv build

# Upload ke PyPI
uv run twine upload dist/*

# Install untuk testing
pip install zach-tiktok

# Uninstall
pip uninstall zach-tiktok
```

Good luck! 🚀
