"""Indices for the TLG.

Note: # ``TLG_MASTER_INDEX`` is the result of failed IDT parsing.

TODO: Add work names to ``TLG_WORKS_INDEX``
TODO: Add all TLG index data.
"""
from typing import Union

TLG_INDEX: dict[str, str] = {
    "TLG1560": "Matthiae Traditiones",
    "TLG1268": "Claudius Iolaus Hist.",
    "TLG0390": "Martyrium Carpi, Papyli Et Agathonicae",
    "TLG0602": "Comica Adespota (FCG)",
    "TLG4347": "Andron Hist.",
    "TLG0290": "Encomium Ducis Thebaidos",
    "TLG0280": "Andromachus Poet. Med.",
    "TLG0572": "Gaius Scr. Eccl.",
    "TLG0174": "Diotimus Epic.",
    "TLG2241": "Xenophilus Mus. et Phil.",
    "TLG2278": "Phanodicus Hist.",
    "TLG0707": "Alexis Hist.",
    "TLG0514": "Thugenides Comic.",
    "TLG1292": "Crito Phil.",
    "TLG1638": "Proxenus Hist.",
    "TLG1154": "Apocalypsis Baruch",
    "TLG1147": "Antiphon Soph.",
    "TLG0050": "Ptolemaei II Philadelphi Et Eleazari Epistulae",
    "TLG2866": "Oecumenius Phil. et Rhet.",
    "TLG4331": "Hierotheus Alchem.",
    "TLG2239": "Pythagoristae (D-K) Phil.",
    "TLG1651": "Pythermus Hist.",
    "TLG2445": "Amometus Hist.",
    "TLG1583": "Phanodemus Hist.",
    "TLG0291": "Alcman Lyr.",
    "TLG2355": "Xeniades Soph.",
    "TLG0515": "Timocles Comic.",
    "TLG0141": "Athenaeus Epigr.",
    "TLG0569": "Apollonius Paradox.",
    "TLG0640": "Alciphron Rhet. et Soph.",
    "TLG5021": "Scholia In Diophantum",
    "TLG1488": "Maximus Theol.",
    "TLG2074": "Apollinaris Theol.",
    "TLG1175": "Archestratus Parodius",
    "TLG0593": "Gorgias Rhet. et Soph.",
    "TLG0296": "Carmina Convivialia (PMG)",
    "TLG9019": "Stephanus Phil.",
    "TLG0301": "Thespis Trag.",
    "TLG0487": "Philemon Comic.",
    "TLG7051": "Doctrina Patrum",
    "TLG1701": "Testamentum Abrahae",
    "TLG0524": "Sophron Mimogr.",
    "TLG2681": "Diodorus Phil.",
    "TLG1498": "Menander Hist.",
    "TLG2169": "Herillus Phil.",
    "TLG0512": "Theophilus Comic.",
    "TLG1506": "Menodotus Hist.",
    "TLG0360": "Armenidas Hist.",
    "TLG0010": "Isocrates Orat.",
    "TLG4302": "Lexicon Patmense",
    "TLG1484": "Martyrium Polycarpi",
    "TLG0044": "Antiochi Regis Epistulae",
    "TLG0047": "Pausaniae I Et Xerxis Epistulae",
    "TLG1759": "Sententiae Pythagoreorum",
    "TLG4346": "Menecrates Hist.",
    "TLG0686": "Aethlius Hist.",
    "TLG0363": "Claudius Ptolemaeus Math.",
    "TLG4390": "Democles Hist.",
    "TLG0067": "Agatharchides Geogr.",
    "TLG2284": "Anaxandridas Hist.",
    "TLG4039": "Paulus Silentiarius Poeta",
    "TLG2742": "Apophthegmata",
    "TLG0408": "Comica Adespota (CAF)",
    "TLG0429": "Cephisodorus Comic.",
    "TLG0483": "Nicophon Comic.",
    "TLG1323": "Aelius Dionysius Attic.",
    "TLG4328": "Philosophus Christianus Alchem.",
    "TLG2061": "Asterius Sophista Scr. Eccl.",
    "TLG0426": "Callias Comic.",
    "TLG0585": "Publius Aelius Phlegon Paradox.",
    "TLG0740": "Jusjurandum Medicum",
    "TLG3136": "Pseudo-Zonaras Lexicogr.",
    "TLG1200": "Asclepiades Myth.",
    "TLG2618": "Didymarchus Poeta",
    "TLG3142": "Georgius Pachymeres Hist.",
    "TLG1613": "Pittaci Epistula",
    "TLG2153": "Bion Math. et Phil.",
    "TLG0228": "Anonymi Hymnus In Dactylos Idaeos",
    "TLG1683": "Sophaenetus Hist.",
    "TLG0271": "Conventus Avium",
    "TLG3086": "Nicephorus I Scr. Eccl., Hist. et Theol.",
    "TLG4344": "Menecrates Hist.",
    "TLG1606": "Phoenix Iamb.",
    "TLG1427": "Herodorus Hist.",
    "TLG2003": "Flavius Claudius Julianus Imperator Phil., Julian the Apostate",
    "TLG2038": "Acta Thomae",
    "TLG0361": "Cleonides Mus.",
    "TLG0330": "Dionysius I Trag.",
    "TLG1712": "Thebaïs",
    "TLG1307": "Demon Hist.",
    "TLG5010": "Scholia In Aeschylum",
    "TLG0650": "Herodas Mimogr.",
    "TLG2040": "Basilius Theol.",
    "TLG0584": "Philostephanus Hist.",
    "TLG1594": "Philo Judaeus Senior Epic.",
    "TLG1173": "Archedemus Phil.",
    "TLG3182": "Pseudo-Symeon Hist.",
    "TLG1632": "Posidippus Epigr.",
    "TLG1168": "Apollonius Soph.",
    "TLG2466": "Dionysius Hist.",
    "TLG1132": "Anonymus Alexandri Phil.",
    "TLG1734": "Timaeus Phil.",
    "TLG2314": "Diogenes Phil.",
    "TLG2635": "Persinus Poeta",
    "TLG2614": "Cleomachus Poeta",
    "TLG1343": "Eparchides Hist.",
    "TLG2632": "Comarius Alchem.",
    "TLG2871": "Joannes Malalas Chronogr.",
    "TLG0545": "Claudius Aelianus Soph.",
    "TLG0348": "Biotus Trag.",
    "TLG0345": "Apollonides Trag.",
    "TLG0605": "Polybius Rhet.",
    "TLG1447": "Irenaeus Theol.",
    "TLG4085": "Hesychius Lexicogr.",
    "TLG1729": "Thrasymachus Rhet. et Soph.",
    "TLG2216": "Aristippus Hist.",
    "TLG0299": "Terpander Lyr.",
    "TLG0622": "Cleobuli Epistula",
    "TLG4161": "Vitae Arati Et Varia De Arato",
    "TLG1663": "Semus Gramm.",
    "TLG5019": "Scholia In Dionysium Periegetam",
    "TLG0496": "Phrynichus Comic.",
    "TLG2270": "Callippus Hist.",
    "TLG0439": "Demetrius Comic.",
    "TLG0541": "Menander Comic.",
    "TLG1953": "Hieronymus Hist.",
    "TLG2428": "Thrasyllus Hist.",
    "TLG2118": "Gryllus",
    "TLG0517": "Timotheus Comic.",
    "TLG0264": "Susarion Comic.",
    "TLG2233": "Pseudo-Polemon",
    "TLG0660": "Apollonius Med.",
    "TLG0554": "Chariton Scr. Erot.",
    "TLG0249": "Echembrotus Eleg. et Lyr.",
    "TLG1286": "Corpus Hermeticum",
    "TLG2001": "Themistius Phil. et Rhet.",
    "TLG0676": "Aglaïs Poet. Med.",
    "TLG0391": "Acta Scillitanorum Martyrum",
    "TLG2181": "Moses Alchem.",
    "TLG0510": "Teleclides Comic.",
    "TLG4291": "Verba In Scripturis De Christo",
    "TLG0230": "Lyrica Adespota (CA)",
    "TLG0064": "Periplus Hannonis",
    "TLG0419": "Aristomenes Comic.",
    "TLG1556": "Pancrates Epigr.",
    "TLG4110": "Evagrius Scr. Eccl.",
    "TLG0749": "Antyllus Med.",
    "TLG0475": "Metagenes Comic.",
    "TLG1277": "Clinias Phil.",
    "TLG4102": "Catenae (Novum Testamentum)",
    "TLG2268": "Timagoras Hist.",
    "TLG2617": "Demetrius Poeta",
    "TLG0636": "Socratis Epistulae",
    "TLG0551": "Appianus Hist.",
    "TLG2006": "Synesius Phil.",
    "TLG2307": "Artemon Hist.",
    "TLG0417": "Archippus Comic.",
    "TLG0307": "Neophron Trag.",
    "TLG3141": "Georgius Acropolites Hist.",
    "TLG1115": "Archestratus Trag.",
    "TLG1351": "Epigoni",
    "TLG0500": "Posidippus Comic.",
    "TLG0094": "Pseudo-Plutarchus",
    "TLG1578": "Phaenias Phil.",
    "TLG3120": "Patria Constantinopoleos",
    "TLG1766": "Tatianus Apol.",
    "TLG2960": "Oracula Tiburtina",
    "TLG1196": "Aristophanes Hist.",
    "TLG1205": "Athenagoras Apol.",
    "TLG2642": "Astrampsychus Magus Onir.",
    "TLG5023": "Scholia In Euripidem",
    "TLG1875": "Aristodemus Hist. et Myth.",
    "TLG2585": "Marcellinus Biogr.",
    "TLG5029": "Scholia In Lucianum",
    "TLG1357": "Eudemus Phil.",
    "TLG5039": "Scholia In Thucydidem",
    "TLG2475": "Menecrates Hist.",
    "TLG0556": "Asclepiodotus Tact.",
    "TLG1622": "Polycarpus Scr. Eccl.",
    "TLG9021": "Stephanus Alchem.",
    "TLG1911": "Diyllus Hist.",
    "TLG1705": "Thales Phil.",
    "TLG2560": "Pythocles Hist.",
    "TLG1141": "Antimachus Epic.",
    "TLG2967": "Theodorus Heracleensis vel Theodorus Mopsuestenus Scr. Eccl.",
    "TLG0197": "Hedyle Epigr.",
    "TLG2956": "Sextus Julius Africanus Hist.",
    "TLG1332": "Diotogenes Phil.",
    "TLG1839": "Polyphrasmon Trag.",
    "TLG2703": "Anna Comnena Hist.",
    "TLG4394": "Joannes Antiochenus Hist.",
    "TLG0405": "Anaxandrides Comic.",
    "TLG1750": "Vitae Prophetarum",
    "TLG2175": "Autocharis Hist.",
    "TLG1405": "Heraclides Criticus Perieg.",
    "TLG2041": "Marcellus Theol.",
    "TLG4024": "Agathias Scholasticus Epigr. et Hist.",
    "TLG2605": "Agamestor Eleg.",
    "TLG1690": "Sotadea",
    "TLG1972": "Eumachus Hist.",
    "TLG1127": "Anonyma De Musica Scripta Bellermanniana",
    "TLG2372": "Euagon Hist.",
    "TLG0335": "Philiscus Trag.",
    "TLG0470": "Leuco Comic.",
    "TLG1373": "Evangelium Philippi",
    "TLG2721": "Theodorus Prodromus Poeta et Polyhist.",
    "TLG0003": "Thucydides Hist.",
    "TLG1206": "Athenodorus Phil.",
    "TLG0856": "Dieuches Med.",
    "TLG1285": "Conon Hist.",
    "TLG1421": "Hermippus Gramm. et Hist.",
    "TLG4393": "Nonnosus Hist.",
    "TLG0333": "Timocles Trag.",
    "TLG1572": "Perictione Phil.",
    "TLG0528": "Aëtius Doxogr.",
    "TLG0833": "Anaxion Trag.",
    "TLG0092": "Anonymi Geographiae Expositio Compendiaria",
    "TLG1339": "Duris Hist.",
    "TLG4005": "Anonymus Discipulus Isidori Milesii Mech.",
    "TLG0592": "Hermogenes Rhet.",
    "TLG2702": "Michael Psellus Polyhist.",
    "TLG1602": "Philoxenus Gramm.",
    "TLG1251": "Chamaeleon Phil.",
    "TLG2200": "Libanius Rhet. et Soph.",
    "TLG2506": "Capito Hist.",
    "TLG1247": "Cebes Phil.",
    "TLG0259": "Scythinus Poet. Phil.",
    "TLG0742": "Hymni Anonymi",
    "TLG1372": "Evangelium Evae",
    "TLG1549": "Onatas Phil.",
    "TLG1349": "Epistula A Martyribus Lugdunensibus",
    "TLG1304": "Democritus Phil.",
    "TLG0001": "Apollonius Rhodius Epic.",
    "TLG0900": "Cleomenes Lyr.",
    "TLG1146": "Antipater Phil.",
    "TLG0377": "Telestes Lyr.",
    "TLG3187": "Georgius Gramm.",
    "TLG2057": "Socrates Scholasticus Hist.",
    "TLG1680": "Sodamus Eleg.",
    "TLG1661": "Satyrus Hist.",
    "TLG1733": "Timaeus Hist.",
    "TLG0357": "Didymus Scriptor De Mensuris",
    "TLG3075": "Pseudo-Mauricius Tact.",
    "TLG1327": "Dionis Epistulae",
    "TLG2354": "Dionysius Hist.",
    "TLG4001": "Aeneas Phil. et Rhet.",
    "TLG0276": "Cantus Lugubris",
    "TLG3146": "Ducas Hist.",
    "TLG1915": "Eudoxus Hist.",
    "TLG0215": "Antagoras Epic.",
    "TLG0052": "Menippus Phil.",
    "TLG0238": "Ananius Iamb.",
    "TLG2624": "Hermias Poeta",
    "TLG1377": "Favorinus Phil. et Rhet.",
    "TLG2186": "Leo Hist.",
    "TLG1180": "Aristaeus Phil.",
    "TLG0289": "Ammonius Epigr.",
    "TLG2423": "Asclepiades Gramm. et Hist.",
    "TLG1435": "Hippias Hist.",
    "TLG3170": "Ephraem Hist. et Poeta",
    "TLG1687": "Sosicrates Hist.",
    "TLG1881": "Dionysius Scytobrachion Gramm.",
    "TLG4030": "Sophonias Phil.",
    "TLG1229": "[Boeus] Epic.",
    "TLG2333": "Possis Hist.",
    "TLG5012": "Scholia In Apollonium Rhodium",
    "TLG1719": "Theodosius Astron. et Math.",
    "TLG2608": "Archebulus Poeta",
    "TLG2970": "Severus Phil.",
    "TLG0320": "Diogenes Trag.",
    "TLG9020": "Stephanus Gramm.",
    "TLG1123": "Andron Hist.",
    "TLG2586": "Menander Rhet.",
    "TLG0555": "Clemens Alexandrinus Theol.",
    "TLG2025": "Maximus Rhet.",
    "TLG2031": "Sopater Rhet.",
    "TLG0697": "Cornelius Alexander Polyhist.",
    "TLG1321": "Diogenes Phil.",
    "TLG1706": "Thallus Hist.",
    "TLG1004": "Thessalus Astrol. et Med.",
    "TLG2679": "Testamentum Salomonis",
    "TLG4170": "Vitae Pindari Et Varia De Pindaro",
    "TLG2602": "Timaeus Sophista Gramm.",
    "TLG0625": "Polemaeus Trag.",
    "TLG0395": "Diophantus Comic.",
    "TLG0548": "Pseudo-Apollodorus Myth.",
    "TLG1511": "Mimnermus Trag.",
    "TLG0222": "Eratosthenes et Eratosthenica Philol.",
    "TLG3128": "Theognostus Gramm.",
    "TLG1859": "Liber Jannes Et Jambres",
    "TLG2117": "Anonymus De Metrorum Ratione",
    "TLG0746": "Theophilus Protospatharius et Stephanus Atheniensis Med.",
    "TLG0529": "Arius Didymus Doxogr.",
    "TLG1347": "Epimenides Phil.",
    "TLG2172": "Andron Hist.",
    "TLG0730": "Meletius Med.",
    "TLG2647": "Zenothemis Geogr.",
    "TLG2275": "Theagenes Phil.",
    "TLG2349": "[Pyrander] Hist.",
    "TLG1406": "Heraclides Hist.",
    "TLG1387": "(H)agias-Dercylus Hist.",
    "TLG0414": "Apollophanes Comic.",
    "TLG0048": "Philippus II Rex Macedonum Epist.",
    "TLG1840": "Euripides II Trag.",
    "TLG2625": "Herodicus Gramm.",
    "TLG1633": "Praxiteles Epigr.",
    "TLG1728": "Theseus Hist.",
    "TLG2007": "Martyrium Potamiaenae Et Basilidis",
    "TLG1228": "[Boeo] Epic.",
    "TLG1775": "Pseudo-Agathon Epigr.",
    "TLG1222": "Beros(s)us Astrol. et Hist.",
    "TLG0422": "Athenio Comic.",
    "TLG4117": "Eustathius Scr. Eccl. et Theol.",
    "TLG2949": "Acta Barnabae",
    "TLG0321": "Aeschylus Trag.",
    "TLG1833": "Pratinas Trag.",
    "TLG0661": "Archigenes Med.",
    "TLG0667": "Marcellinus I Med.",
    "TLG1310": "Dictys Hist.",
    "TLG1495": "Melito Apol.",
    "TLG9023": "Thomas Magister Philol.",
    "TLG0218": "Nicaenetus Epic.",
    "TLG4301": "Lexicon Rhetoricum Cantabrigiense",
    "TLG0398": "Simylus Comic.",
    "TLG4086": "[Agathodaemon] Alchem.",
    "TLG0061": "Pseudo-Lucianus Soph.",
    "TLG1665": "Seniores Apud Irenaeum Scr. Eccl.",
    "TLG0298": "Eumelus Epic.",
    "TLG0219": "Rhianus Epic.",
    "TLG3147": "Michael Critobulus Hist.",
    "TLG2398": "Basilides Phil.",
    "TLG1207": "Attalus Astron. et Math.",
    "TLG2051": "Himerius Soph.",
    "TLG1771": "Montanus et Montanistae Theol.",
    "TLG1849": "Demetrius Trag.",
    "TLG0725": "Anaximander Phil.",
    "TLG1094": "Theodorides Trag.",
    "TLG0300": "Acta Alexandrinorum",
    "TLG2532": "[Hermesianax] Hist.",
    "TLG1525": "Neanthes Hist.",
    "TLG1576": "Phaedimus Epic.",
    "TLG1977": "Lucius Licinius Lucullus Hist.",
    "TLG3157": "Theodorus Scutariota Hist.",
    "TLG1562": "Parmenides Poet. Phil.",
    "TLG2367": "Theognis Hist.",
    "TLG0273": "Scolia Alphabetica",
    "TLG4153": "Theophanes Continuatus",
    "TLG3169": "Joannes VI Cantacuzenus",
    "TLG1416": "(H)eren(n)ius Philo Gramm. et Hist.",
    "TLG1596": "Philolaus Phil.",
    "TLG4166": "Vitae Aeschinis",
    "TLG3127": "Pseudo-Nonnus",
    "TLG2565": "Mnesimachus Hist.",
    "TLG1383": "Geminus Astron.",
    "TLG1379": "Fragmenta Alchemica",
    "TLG0255": "Mimnermus Eleg.",
    "TLG1569": "Pausanias Attic.",
    "TLG1128": "Anonymi Commentarius In Platonis Theaetetum",
    "TLG4075": "Marinus Phil.",
    "TLG0037": "Anacharsidis Epistulae",
    "TLG3185": "Anonymus De Scientia Politica Hist.",
    "TLG0016": "Herodotus Hist.",
    "TLG0536": "Ephorus Hist.",
    "TLG3176": "Pseudo-Sphrantzes Hist.",
    "TLG2122": "Gaius Asinius Quadratus Hist.",
    "TLG0597": "Zenodorus Gramm.",
    "TLG0005": "Theocritus Bucol.",
    "TLG2273": "Damon Hist.",
    "TLG4093": "Georgius Choeroboscus Gramm.",
    "TLG0659": "Comica Adespota (Suppl. Com.)",
    "TLG0544": "Sextus Empiricus Phil.",
    "TLG0378": "Ariphron Lyr.",
    "TLG0509": "Myia Phil.",
    "TLG0651": "Antoninus Liberalis Myth.",
    "TLG1161": "Apocryphon Ezechiel",
    "TLG0315": "Sthenelus Trag.",
    "TLG0261": "Simonides Lyr.",
    "TLG5028": "Scholia In Isocratem",
    "TLG2148": "Aristodemus Hist.",
    "TLG2548": "Promathion Hist.",
    "TLG0338": "Sosiphanes Trag.",
    "TLG0221": "Euphorion Epic.",
    "TLG4091": "Callistratus Soph.",
    "TLG0888": "Eudemus Poet. Med.",
    "TLG1412": "Pseudo-Heracliti Epistulae",
    "TLG1437": "Hippon Phil.",
    "TLG2291": "Cratylus Phil.",
    "TLG2130": "Arethas Philol. et Scr. Eccl.",
    "TLG0581": "Paradoxographus Palatinus",
    "TLG2568": "[Sosthenes] Hist.",
    "TLG0007": "Plutarchus Biogr. et Phil.",
    "TLG1542": "Numenius Phil.",
    "TLG2140": "Iamblichus Alchem.",
    "TLG0724": "Stephanus Med. et Phil.",
    "TLG4287": "Etymologia Alphabeti",
    "TLG0413": "Apollodorus Comic.",
    "TLG2173": "Antileon Hist.",
    "TLG0071": "Periplus Maris Erythraei",
    "TLG2807": "Antonius Hagiographus Scr. Eccl.",
    "TLG0655": "Parthenius Myth.",
    "TLG0459": "Eunicus Comic.",
    "TLG0375": "Cinesias Lyr.",
    "TLG0463": "Hegemon Parodius",
    "TLG0562": "Marcus Aurelius Antoninus Imperator Phil.",
    "TLG1083": "Isigonus Paradox.",
    "TLG0331": "Polyidus Trag.",
    "TLG0089": "Praxiphanes Phil.",
    "TLG2589": "Olympiodorus Alchem.",
    "TLG0027": "Andocides Orat.",
    "TLG1693": "Sphaerus Phil.",
    "TLG0708": "Ammonius Gramm.",
    "TLG1625": "Polyclitus Phil.",
    "TLG0410": "Antiphanes Comic.",
    "TLG1164": "Apollodorus Hist.",
    "TLG1794": "Philocles Comic.",
    "TLG1906": "Simonides Epic.",
    "TLG2482": "Daimachus Hist.",
    "TLG2248": "Acta Xanthippae Et Polyxenae",
    "TLG4237": "Joannes Argyropulus Gramm.",
    "TLG1459": "Lepidus Hist.",
    "TLG0461": "Eupolis Comic.",
    "TLG0481": "Nicolaus Comic.",
    "TLG2274": "Hesychius Illustrius Hist.",
    "TLG1288": "Craterus Hist.",
    "TLG0612": "Dio Chrysostomus Soph.",
    "TLG1912": "Euphantus Phil.",
    "TLG4037": "Anonymi Paradoxographi",
    "TLG4165": "Anonymi In Aristotelis Librum De Interpretatione Phil.",
    "TLG4334": "[Isis Prophetissa] Alchem.",
    "TLG0577": "Nicolaus Hist.",
    "TLG0244": "Cleobulina Scriptor Aenigmatum",
    "TLG1504": "Menelaus Epic.",
    "TLG0042": "Alexandri Magni Epistulae",
    "TLG2877": "Cyrillus Biogr.",
    "TLG1309": "Dialexeis Δισσοὶ λόγοι",
    "TLG2566": "[Agathon] Hist.",
    "TLG2277": "Hypermenes Hist.",
    "TLG1670": "Serapion Scr. Eccl.",
    "TLG2385": "Polycritus Hist.",
    "TLG0236": "Alcibiades Eleg.",
    "TLG4066": "Damascius Phil.",
    "TLG1312": "Didymus Gramm.",
    "TLG0561": "Longus Scr. Erot.",
    "TLG1425": "Hermonax Epic.",
    "TLG2580": "Joannes Laurentius Lydus Hist.",
    "TLG0319": "Critias Eleg., Phil. et Trag.",
    "TLG2639": "Posidonius Epic.",
    "TLG0611": "Theodorus Trag.",
    "TLG9009": "Michael Apostolius Paroemiogr.",
    "TLG1303": "Demochares Hist. et Orat.",
    "TLG0386": "Chilonis Epistula",
    "TLG2032": "Pappus Math.",
    "TLG0430": "Chariclides Comic.",
    "TLG0981": "Stesichorus II Lyr.",
    "TLG3002": "Prolegomena De Comoedia",
    "TLG2010": "Martyrium Dasii",
    "TLG1135": "Anonymus Photii Phil.",
    "TLG2641": "Priscus Epic.",
    "TLG4330": "Cosmas Hieromonachus Alchem.",
    "TLG0506": "Stephanus Comic.",
    "TLG2217": "Nicias Hist.",
    "TLG2539": "Diophantus Hist.",
    "TLG1139": "Anonymi Historici (FGrH)",
    "TLG2303": "Archelaus Phil.",
    "TLG0268": "Mesomedes Lyr.",
    "TLG4173": "Vitae Dionysii Periegetae",
    "TLG3168": "Pseudo-Codinus Hist.",
    "TLG5040": "Scholia In Xenophontem",
    "TLG1605": "Pseudo-Phocylides Gnom.",
    "TLG0374": "Licymnius Lyr.",
    "TLG2226": "Iccus Phil.",
    "TLG4396": "Timagetus Hist.",
    "TLG0641": "Xenophon Scr. Erot.",
    "TLG0457": "Eubulides Comic.",
    "TLG2289": "Echephylidas Hist.",
    "TLG0645": "Justinus Martyr Apol.",
    "TLG0653": "Aratus Astron. et Epic.",
    "TLG1342": "Empedocles Poet. Phil.",
    "TLG2904": "Nicolaus Rhet. et Soph.",
    "TLG0415": "Araros Comic.",
    "TLG4242": "Cyrus Rhet.",
    "TLG2022": "Gregorius Nazianzenus Theol.",
    "TLG1245": "Carystius Hist.",
    "TLG0399": "Eudoxus Comic.",
    "TLG0436": "Crito Comic.",
    "TLG1643": "Ptolemaeus Gramm.",
    "TLG4171": "Anonymi In Oppiani Opera",
    "TLG1949": "Potamon Hist.",
    "TLG0316": "Xenocles Trag.",
    "TLG1992": "Ariston Apol.",
    "TLG0254": "Melanthius Eleg. et Trag.",
    "TLG0719": "Aretaeus Med.",
    "TLG4031": "Eustratius Phil.",
    "TLG5031": "Scholia In Nicandrum",
    "TLG1626": "Polycrates Scr. Eccl.",
    "TLG0631": "Pittacus Lyr.",
    "TLG0624": "Demetrius Hist. et Phil.",
    "TLG9004": "Anonymi In Aristotelis Librum Alterum Analyticorum Posteriorum Commentarium",
    "TLG4082": "Musaeus Grammaticus Epic.",
    "TLG4345": "Menecrates Hist.",
    "TLG4340": "Salmanas Alchem.",
    "TLG2215": "Ar(i)aethus Hist.",
    "TLG2621": "Diophilus vel Diophila Poeta",
    "TLG1189": "Aristocrates Hist.",
    "TLG1225": "Bion Hist.",
    "TLG1557": "Panyassis Epic.",
    "TLG1788": "Phormis Comic.",
    "TLG4081": "Colluthus Epic.",
    "TLG0312": "Philocles Trag.",
    "TLG0604": "Ptolemaeus IV Philopator Trag.",
    "TLG0411": "Apollodorus Comic.",
    "TLG3051": "Georgius Monachus Continuatus",
    "TLG0068": "Pseudo-Scymnus Geogr.",
    "TLG1821": "Iambica Adespota (ALG)",
    "TLG0658": "Heliodorus Scr. Erot.",
    "TLG0015": "Herodianus Hist.",
    "TLG0744": "Alexander Med.",
    "TLG3040": "Josephus Genesius Hist.",
    "TLG4105": "Julianus Scr. Eccl.",
    "TLG1157": "Apocalypsis Esdrae",
    "TLG1720": "Theodotus Judaeus Epic.",
    "TLG4333": "Nicephorus Blemmydes Alchem.",
    "TLG1544": "Nymphis Hist.",
    "TLG0014": "Demosthenes Orat.",
    "TLG0022": "Nicander Epic.",
    "TLG2734": "Flavius Justinianus Imperator Theol.",
    "TLG0446": "Dioxippus Comic.",
    "TLG1609": "Phylarchus Hist.",
    "TLG1204": "Athenaeus Mech.",
    "TLG0502": "Sophilus Comic.",
    "TLG0207": "Hermocles Lyr.",
    "TLG2218": "Calliphon et Democedes Med. et Phil.",
    "TLG1052": "Posidonius Phil.",
    "TLG0079": "Menippus Geogr.",
    "TLG0418": "Aristagoras Comic.",
    "TLG4072": "Eutocius Math.",
    "TLG0200": "Mantissa Proverbiorum",
    "TLG1523": "Myron Hist.",
    "TLG2636": "Pherenicus Epic.",
    "TLG1375": "Evangelium Thomae",
    "TLG2322": "Antenor Hist.",
    "TLG0308": "Ion Phil. et Poeta",
    "TLG2193": "[Aretades] Hist.",
    "TLG0281": "Marcellus Poet. Med.",
    "TLG2243": "Apocalypsis Sedrach",
    "TLG5022": "Scholia In Euclidem",
    "TLG1703": "Teucer Astrol.",
    "TLG0095": "Hermodorus Phil.",
    "TLG1835": "Agroetas Hist.",
    "TLG0385": "Cassius Dio Hist., Dio Cassius",
    "TLG2286": "Cercops Phil.",
    "TLG0703": "Numenius Poet. Didac.",
    "TLG7052": "Anthologiae Graecae Appendix",
    "TLG4238": "Athanasius Soph.",
    "TLG0516": "Timostratus Comic.",
    "TLG2655": "Damigeron Magus",
    "TLG2969": "Demonax Phil.",
    "TLG1787": "[Menippus] Comic.",
    "TLG1607": "Phoronis",
    "TLG4083": "Eustathius Philol. et Scr. Eccl.",
    "TLG2345": "Agl(a)osthenes Hist.",
    "TLG3023": "Constantinus VII Porphyrogenitus Imperator Hist.",
    "TLG2397": "Boethus Phil.",
    "TLG5015": "Scholia In Aristotelem",
    "TLG5038": "Scholia In Theocritum",
    "TLG2246": "Lycon Phil.",
    "TLG0341": "Lycophron Trag.",
    "TLG2600": "Simon Scriptor De Re Equestri",
    "TLG2628": "Idaeus Epic.",
    "TLG0710": "Amphiarai Exilium (?)",
    "TLG1772": "Paraleipomena Jeremiou",
    "TLG0630": "Pherecydes Myth. et Phil.",
    "TLG1641": "Ptolemaeus Gnost.",
    "TLG1654": "Rhinthon Comic.",
    "TLG1527": "Nepualius Med. et Phil.",
    "TLG4003": "Marcianus Geogr.",
    "TLG2115": "Hippolytus Scr. Eccl.",
    "TLG0387": "Sapphus vel Alcaei Fragmenta",
    "TLG2110": "Cyrillus Scr. Eccl.",
    "TLG2029": "Anonymi Geographia In Sphaera Intelligenda",
    "TLG2304": "Idaeus Phil.",
    "TLG2892": "Maximus Confessor Theol.",
    "TLG0227": "Anonymi Curetum Hymnus",
    "TLG5008": "Scholia In Aelium Aristidem",
    "TLG1155": "Apocalypsis Syriaca Baruchi",
    "TLG1460": "Lesbonax Gramm.",
    "TLG1791": "Menandri Et Philistionis Sententiae",
    "TLG1918": "Timagenes Hist.",
    "TLG1838": "Theon Gramm.",
    "TLG1699": "Teles Phil.",
    "TLG2606": "Agathyllus Eleg.",
    "TLG1266": "Tyrannion Gramm.",
    "TLG1749": "Vitae Hesiodi Particula",
    "TLG1678": "Socrates Hist.",
    "TLG0214": "Phanocles Eleg.",
    "TLG0278": "Praelusio Mimi",
    "TLG2699": "Amphicrates Rhet.",
    "TLG2178": "Cassius Longinus Phil. et Rhet.",
    "TLG1419": "Hermas Scr. Eccl., Pastor Hermae",
    "TLG4126": "Theodorus Scr. Eccl.",
    "TLG0020": "Hesiodus Epic.",
    "TLG1545": "Ocellus Phil.",
    "TLG2060": "Asterius Scr. Eccl.",
    "TLG1650": "Pytheas Perieg.",
    "TLG1145": "Antiochus Hist.",
    "TLG0260": "Semonides Eleg. et Iamb.",
    "TLG0713": "Anaxagoras Phil.",
    "TLG1691": "Sotades Iamb.",
    "TLG0277": "Monodia",
    "TLG0450": "Ephippus Comic.",
    "TLG0029": "Dinarchus Orat.",
    "TLG1732": "Timachidas Hist.",
    "TLG0329": "Theodectas Trag.",
    "TLG1534": "Nicocles Hist.",
    "TLG3144": "Joannes Cananus Hist.",
    "TLG1709": "Theagenes Hist.",
    "TLG0542": "Julius Pollux Gramm.",
    "TLG1436": "Hippodamus Phil.",
    "TLG1289": "Crates Hist.",
    "TLG0056": "Thrasybuli Epistula",
    "TLG0186": "Marcus Cornelius Fronto Rhet.",
    "TLG2020": "Theodosius Gramm.",
    "TLG0621": "[Ath]enodorus Trag.",
    "TLG0482": "Nicomachus Comic.",
    "TLG1386": "Historia Alexandri Magni",
    "TLG1611": "Tyrannion Junior Gramm.",
    "TLG0484": "Nicostratus Comic.",
    "TLG2797": "Hesychius Scr. Eccl.",
    "TLG0030": "Hyperides Orat.",
    "TLG1591": "Philistus Hist.",
    "TLG0434": "Cratinus Comic.",
    "TLG4332": "Hierotheus Alchem. et Poeta",
    "TLG1287": "Crantor Phil.",
    "TLG0472": "Lysippus Comic.",
    "TLG2592": "Joannes Pediasimus Philol. et Rhet.",
    "TLG2265": "Diodorus Perieg.",
    "TLG0235": "Iambica Adespota (IEG)",
    "TLG1780": "Alcimenes Comic.",
    "TLG1490": "Megillus Phil.",
    "TLG0460": "Euphro Comic.",
    "TLG2287": "Fragmentum Stoicum",
    "TLG0733": "Cassius Iatrosophista Med.",
    "TLG2058": "Philostorgius Scr. Eccl.",
    "TLG0019": "Aristophanes Comic.",
    "TLG2111": "Palladius Scr. Eccl.",
    "TLG2047": "Syriani, Sopatri Et Marcellini Scholia Ad Hermogenis Status",
    "TLG2305": "Clidemus Phil.",
    "TLG2313": "Antisthenes Phil.",
    "TLG1577": "Phaedimus Epigr.",
    "TLG0698": "Alexander Rhet.",
    "TLG1748": "Sosigenes Phil.",
    "TLG1324": "Dionysius Hist.",
    "TLG0715": "Paulus Med.",
    "TLG3155": "Joannes Protospatharius Gramm.",
    "TLG1846": "Spintharus Trag.",
    "TLG1499": "Menecles Hist.",
    "TLG0638": "Flavius Philostratus Soph.",
    "TLG1466": "Lollianus Scr. Erot.",
    "TLG1334": "Dius Phil.",
    "TLG1752": "Xenagoras Geogr. et Hist.",
    "TLG0695": "Alcimus Hist.",
    "TLG0623": "Cratetis Epistulae",
    "TLG0350": "Dionysius Scymnaeus Trag. vel Comic.",
    "TLG2644": "Sminthes Astron.",
    "TLG1382": "Fragmentum Teliambicum",
    "TLG0328": "Chaeremon Trag.",
    "TLG1376": "Eudemus Rhet.",
    "TLG2157": "Magnus Hist.",
    "TLG2623": "Euanthes Epic.",
    "TLG2102": "Didymus Caecus Scr. Eccl., Didymus the Blind",
    "TLG3125": "Theodosius Diaconus Hist. et Poeta",
    "TLG1783": "Callicrates Comic.",
    "TLG4096": "Dositheus Magister Gramm.",
    "TLG1828": "Pamphila Hist.",
    "TLG0043": "Amasis Epistulae",
    "TLG2595": "Philo Paradox.",
    "TLG0620": "Archytas Phil.",
    "TLG0720": "Harmodius Trag.",
    "TLG2701": "Georgius Pisides Poeta",
    "TLG1124": "Andronicus Rhodius Phil.",
    "TLG5025": "Scholia In Hesiodum",
    "TLG0087": "Aelius Herodianus et Pseudo-Herodianus Gramm. et Rhet.",
    "TLG0416": "Archedicus Comic.",
    "TLG0024": "Oppianus Epic.",
    "TLG0127": "Aulus Licinius Archias Epigr.",
    "TLG0647": "Triphiodorus Epic. et Gramm.",
    "TLG2630": "Lobo Poeta",
    "TLG0617": "Anaximenes Phil.",
    "TLG2800": "Basilius Scr. Eccl.",
    "TLG0137": "Asclepiades Epigr.",
    "TLG4034": "Michael Phil.",
    "TLG0498": "Poliochus Comic.",
    "TLG1715": "Theodoridas Epigr.",
    "TLG0396": "Euphanes Comic.",
    "TLG0445": "Dionysius Comic.",
    "TLG4124": "Eusebius Scr. Eccl.",
    "TLG1535": "Nicocrates Hist.",
    "TLG2914": "Leontius Scr. Eccl.",
    "TLG1462": "Liber Eldad Et Modad",
    "TLG0452": "Epigenes Comic.",
    "TLG0352": "Isidorus Trag.",
    "TLG2387": "Athanis Hist.",
    "TLG0198": "Hedylus Epigr.",
    "TLG0526": "Flavius Josephus Hist.",
    "TLG2011": "Martyrium Agapae, Irenae, Chionae Et Sodalium",
    "TLG2455": "Aristocreon Hist.",
    "TLG2014": "Acta Phileae",
    "TLG2346": "Andriscus Hist.",
    "TLG1700": "Testamenta XII Patriarcharum",
    "TLG2298": "Lysanias Hist.",
    "TLG0533": "Callimachus Philol.",
    "TLG2212": "Lyceas Hist.",
    "TLG4397": "Myronianus Hist.",
    "TLG2458": "Marcellus Hist.",
    "TLG4038": "Pamprepius Epic.",
    "TLG1815": "Sappho et Alcaeus Lyr.",
    "TLG1567": "Parrhasius Epigr.",
    "TLG2733": "Evagrius Scholasticus Scr. Eccl.",
    "TLG2048": "Salaminius Hermias Sozomenus Scr. Eccl.",
    "TLG0205": "Philodamus Lyr.",
    "TLG3020": "Joannes Cinnamus Gramm. et Hist.",
    "TLG1978": "Leo Hist.",
    "TLG0240": "Hermolochus Lyr.",
    "TLG0085": "Aeschylus Trag.",
    "TLG0662": "Comica Adespota (CGFPR)",
    "TLG1262": "Choerilus Epic.",
    "TLG2049": "Sallustius Phil.",
    "TLG0485": "Ophelio Comic.",
    "TLG2162": "Aratus Hist.",
    "TLG2966": "Phileas Scr. Eccl.",
    "TLG1714": "Theocritus Soph.",
    "TLG0210": "Euphronius Lyr.",
    "TLG2127": "Troilus Soph.",
    "TLG0583": "Philochorus Hist.",
    "TLG2042": "Origenes Theol.",
    "TLG0267": "Xenophanes Poet. Phil.",
    "TLG0351": "[Hippothoon] Trag.",
    "TLG0488": "Philemon Junior Comic.",
    "TLG1753": "Xenion Hist.",
    "TLG0404": "Amphis Comic.",
    "TLG0745": "Hierophilus Phil. et Soph.",
    "TLG2158": "Eutychianus Hist.",
    "TLG4036": "Proclus Phil.",
    "TLG4235": "Joannes Rhet.",
    "TLG1636": "Protagorides Hist.",
    "TLG1313": "Dieuchidas Hist.",
    "TLG0376": "Timotheus Lyr.",
    "TLG1600": "Philostratus Major Soph.",
    "TLG5034": "Scholia In Pindarum",
    "TLG1182": "[Aristeas] Epic.",
    "TLG2009": "Martyrium Marini",
    "TLG2196": "[Dercyllus] Hist.",
    "TLG0062": "Lucianus Soph.",
    "TLG4323": "Eugenius Alchem.",
    "TLG0480": "Nicochares Comic.",
    "TLG3014": "Joannes Camaterus Astrol. et Astron.",
    "TLG0206": "Theocles Lyr.",
    "TLG0574": "Lysimachus Hist.",
    "TLG1138": "Lycon Phil.",
    "TLG2383": "Diodorus Phil.",
    "TLG2247": "Petron Phil.",
    "TLG0202": "Mace(donius) Lyr.",
    "TLG0116": "Abydenus Hist.",
    "TLG0040": "Calani Epistula",
    "TLG1698": "Telephus Gramm.",
    "TLG2738": "Chronographiae Anonymae",
    "TLG1667": "Septem Sapientes Phil.",
    "TLG1890": "Moderatus Phil.",
    "TLG1688": "Sostratus Gramm.",
    "TLG1676": "Simylus Iamb.",
    "TLG2340": "Diotimus Phil.",
    "TLG0591": "Antisthenes Phil. et Rhet.",
    "TLG2547": "Antigonus",
    "TLG0679": "Aeschrion Lyr.",
    "TLG4089": "Theodoretus Scr. Eccl. et Theol.",
    "TLG2045": "Nonnus Epic.",
    "TLG0431": "Chionides Comic.",
    "TLG2053": "Paulus Astrol.",
    "TLG1431": "Hipparchus Astron. et Geogr.",
    "TLG1264": "Chrysippus Phil.",
    "TLG2971": "Georgius Peccator Poeta",
    "TLG0723": "Leo Phil.",
    "TLG0266": "Tyrtaeus Eleg.",
    "TLG0233": "Hipponax Iamb.",
    "TLG0489": "Philetaerus Comic.",
    "TLG4391": "Glaucus Hist.",
    "TLG1298": "Demetrii Phalerei Epistula",
    "TLG1438": "Hippys Hist.",
    "TLG0246": "Dionysius Chalcus Eleg.",
    "TLG0582": "Paradoxographus Vaticanus",
    "TLG0305": "Aristias Trag.",
    "TLG1896": "[Dositheus] Hist.",
    "TLG1724": "Theon Phil.",
    "TLG0340": "Sositheus Trag.",
    "TLG0342": "Nicomachus Trag.",
    "TLG4300": "Lexicon Sabbaiticum",
    "TLG4145": "Nicephorus Gregoras Hist.",
    "TLG0897": "Euthydemus Med.",
    "TLG4134": "Diodorus Scr. Eccl.",
    "TLG0388": "Acta Pauli",
    "TLG4139": "Severianus Scr. Eccl.",
    "TLG5052": "Scholia in Maximum Confessorem",
    "TLG1695": "Sthenidas Phil.",
    "TLG1224": "Bion Phil.",
    "TLG4335": "Cleopatra Alchem.",
    "TLG2116": "Arcadius Gramm.",
    "TLG1814": "Ptolemais Phil.",
    "TLG2225": "Parm(en)iscus Phil.",
    "TLG1736": "Timonax Hist.",
    "TLG1392": "Hegesander Hist.",
    "TLG2054": "Aristides Quintilianus Mus.",
    "TLG1172": "Arcesilaus Phil.",
    "TLG1340": "Eccelus Phil.",
    "TLG2234": "Oenopides Phil.",
    "TLG1692": "Speusippus Phil.",
    "TLG0368": "Cydias Lyr.",
    "TLG0629": "Periander Phil.",
    "TLG1764": "Vettius Valens Astrol.",
    "TLG2456": "Nessas Phil.",
    "TLG0458": "Eubulus Comic.",
    "TLG0971": "Oeniades Lyr.",
    "TLG1981": "Theophanes Hist.",
    "TLG2474": "Nicander Hist.",
    "TLG0344": "Melanthius Trag.",
    "TLG1345": "Epica Incerta (CA)",
    "TLG2556": "[Alexarchus] Hist.",
    "TLG0326": "Sophocles Junior Trag.",
    "TLG1784": "Heraclitus Comic.",
    "TLG0700": "Apollodorus Trag.",
    "TLG1133": "Anonymus Diodori Phil.",
    "TLG4040": "Photius Lexicogr., Scr. Eccl. et Theol.",
    "TLG1471": "Lyrica Adespota (SLG)",
    "TLG1675": "Simylus Eleg.",
    "TLG4395": "Menetor Hist.",
    "TLG0293": "Ibycus Lyr.",
    "TLG0728": "Theophilus Protospatharius, Damascius et Stephanus Atheniensis Med.",
    "TLG2577": "Anatolius Math. et Phil.",
    "TLG0212": "Philetas Eleg. et Gramm.",
    "TLG1507": "Metopus Phil.",
    "TLG1574": "Persaeus Phil.",
    "TLG1760": "Gaius Suetonius Tranquillus Gramm. et Hist.",
    "TLG5009": "Scholia In Aeschinem",
    "TLG2017": "Gregorius Nyssenus Theol.",
    "TLG1391": "Hegemon Epic.",
    "TLG2210": "Anaxicrates Hist.",
    "TLG2696": "Theodorus Poeta",
    "TLG4392": "Joannes Epiphaniensis Hist.",
    "TLG2027": "Valerius Apsines Rhet.",
    "TLG2232": "Damon Mus.",
    "TLG1341": "Ecphantus Phil.",
    "TLG0547": "Anaximenes Hist. et Rhet.",
    "TLG0535": "Demades Orat. et Rhet.",
    "TLG1274": "Cleobulus Epigr. et Lyr.",
    "TLG0423": "Autocrates Comic.",
    "TLG1662": "Sciras Comic.",
    "TLG0055": "Themistoclis Epistulae",
    "TLG1256": "Chares Gnom.",
    "TLG0369": "Telesilla Lyr.",
    "TLG1400": "Heliodorus Perieg.",
    "TLG0722": "Oribasius Med.",
    "TLG0503": "Sosicrates Comic.",
    "TLG0734": "Lucas Apostolus Med.",
    "TLG2189": "Callinicus Soph.",
    "TLG1252": "Certamen Homeri Et Hesiodi",
    "TLG1792": "Biottus Comic.",
    "TLG2695": "Vitae Aristotelis",
    "TLG1346": "Ephraem Scr. Eccl.",
    "TLG1571": "Pempelus Phil.",
    "TLG0716": "Erotianus Gramm. et Med.",
    "TLG2391": "Hippostratus Hist.",
    "TLG0017": "Isaeus Orat.",
    "TLG1365": "Melampus Scriptor De Divinatione",
    "TLG1516": "Molpis Hist.",
    "TLG1352": "Epistula Ecclesiarum Apud Lugdunum Et Viennam",
    "TLG3188": "Joannes Actuarius Med.",
    "TLG5002": "Magica",
    "TLG1367": "Euripidis Epistulae",
    "TLG2653": "Erycius Poeta",
    "TLG0370": "Lamprocles Lyr.",
    "TLG0253": "[Homerus] Epic.",
    "TLG0248": "Diphilus Epic. et Iamb.",
    "TLG1923": "Stesimbrotus Hist.",
    "TLG1763": "Tryphon II Gramm.",
    "TLG2242": "Echecrates Phil.",
    "TLG0540": "Lysias Orat.",
    "TLG0751": "Pseudo-Hippocrates Med.",
    "TLG4236": "Trophonius Rhet. et Soph.",
    "TLG2244": "Damon et Phintias Phil.",
    "TLG5033": "Scholia In Pausaniam",
    "TLG1197": "Artemon Gramm.",
    "TLG0511": "Theognetus Comic.",
    "TLG4017": "Syrianus Phil.",
    "TLG2881": "Romanus Melodus Hymnographus",
    "TLG1259": "Charondas Nomographus Phil.",
    "TLG0537": "Epicurus Phil.",
    "TLG4292": "Lexicon De Atticis Nominibus",
    "TLG0252": "Hermippus Comic.",
    "TLG0608": "Satyrus Biogr.",
    "TLG5024": "Anonymi In Hermogenem Rhet.",
    "TLG1232": "Butherus Phil.",
    "TLG0009": "Sappho Lyr.",
    "TLG1568": "Parthax Hist.",
    "TLG0752": "Eutecnius Soph.",
    "TLG1208": "Atticus Phil.",
    "TLG4307": "Lexica Synonymica",
    "TLG0437": "Crobylus Comic.",
    "TLG2204": "Autocrates Hist.",
    "TLG2573": "Pausanias Hist.",
    "TLG0668": "Aegimius",
    "TLG3135": "Joannes Zonaras Gramm. et Hist.",
    "TLG1337": "Dorotheus Astrol.",
    "TLG1016": "Ostanes Magus Alchem.",
    "TLG1326": "Dionysius Epic.",
    "TLG3173": "Joannes Theol.",
    "TLG0726": "Palladius Med.",
    "TLG1779": "Anonymus Epicureus Phil.",
    "TLG1515": "Moeris Attic.",
    "TLG0269": "Nautarum Cantiunculae",
    "TLG0523": "Menecrates Comic.",
    "TLG2652": "Diodorus Eleg.",
    "TLG2062": "Joannes Chrysostomus Scr. Eccl., John Chrysostom",
    "TLG0521": "Epicharmus Comic. et Pseudepicharmea",
    "TLG2559": "[Chrysippus] Hist.",
    "TLG0304": "Acta Et Martyrium Apollonii",
    "TLG2972": "Anonymi De Terrae Motibus",
    "TLG1311": "Didache XII Apostolorum",
    "TLG1181": "Aristarchus Astron.",
    "TLG1248": "Celsus Phil.",
    "TLG1258": "Charon Hist.",
    "TLG2627": "Damianus Scriptor De Opticis",
    "TLG0057": "Galenus Med.",
    "TLG1213": "Julia Balbilla Lyr.",
    "TLG1237": "Callicratidas Phil.",
    "TLG2860": "Alexander Scr. Eccl.",
    "TLG2596": "Phoebammon Soph.",
    "TLG1242": "Canon Librorum",
    "TLG2657": "Martyrium Ignatii",
    "TLG0557": "Epictetus Phil.",
    "TLG2744": "Historia Monachorum In Aegypto",
    "TLG1216": "Barnabae Epistula",
    "TLG1533": "Nicias Epigr.",
    "TLG0721": "Anonymi Medici Med.",
    "TLG0358": "Nicomachus Math.",
    "TLG1702": "Testamentum Jobi",
    "TLG0825": "Melito Trag.",
    "TLG1118": "Pseudo-Dioscorides Med.",
    "TLG0615": "Aspasius Phil.",
    "TLG0606": "Rufus Soph.",
    "TLG0598": "Rhetorica Anonyma",
    "TLG1679": "Socrates Hist.",
    "TLG0508": "Strattis Comic.",
    "TLG4329": "Philosophus Anonymus Alchem.",
    "TLG3158": "Theodorus Epist.",
    "TLG2063": "Gregorius Thaumaturgus Scr. Eccl.",
    "TLG4150": "Anacreontea",
    "TLG1590": "Philippus Hist.",
    "TLG4147": "Florilegium Cyrillianum",
    "TLG0609": "Tryphon I Gramm.",
    "TLG3070": "Symeon Logothetes Hist.",
    "TLG2002": "Anonymus Seguerianus Rhet.",
    "TLG0045": "Artaxerxis Epistulae",
    "TLG4021": "David Phil.",
    "TLG0531": "Hermias Apol.",
    "TLG2260": "Hippasus Phil.",
    "TLG0492": "Philonides Comic.",
    "TLG5032": "Scholia In Oppianum",
    "TLG1494": "Melissus Phil.",
    "TLG0616": "Polyaenus Rhet.",
    "TLG0288": "Pisander Epic.",
    "TLG1546": "Oechaliae Halosis",
    "TLG1858": "Oratio Manassis",
    "TLG1174": "Archemachus Hist.",
    "TLG4018": "Asclepius Phil.",
    "TLG1250": "Cercidas Iamb.",
    "TLG2546": "Publius Rutilius Rufus Hist.",
    "TLG1162": "Apollas Hist.",
    "TLG0493": "Philostephanus Comic.",
    "TLG0467": "Timotheus Trag.",
    "TLG0501": "Sannyrion Comic.",
    "TLG2339": "Maeandrius Hist.",
    "TLG2934": "Joannes Damascenus Scr. Eccl. et Theol., John of Damascus",
    "TLG0571": "Aristocles Paradox.",
    "TLG0538": "Hecataeus Hist.",
    "TLG5030": "Scholia In Lycophronem",
    "TLG1273": "Cleon Eleg.",
    "TLG0495": "Phoenicides Comic.",
    "TLG1167": "Apollonius Biogr.",
    "TLG3130": "Theophylactus Simocatta Epist. et Hist.",
    "TLG1642": "Pseudo-Ptolemaeus",
    "TLG3156": "Anonymi Exegesis In Hesiodi Theogoniam",
    "TLG3018": "Georgius Cedrenus Chronogr.",
    "TLG0490": "Philippides Comic.",
    "TLG4293": "Fragmentum Lexici Graeci",
    "TLG0527": "Septuaginta",
    "TLG0322": "Dicaeogenes Trag.",
    "TLG3043": "Georgius Monachus Chronogr.",
    "TLG0649": "Lesbonax Rhet.",
    "TLG2294": "Zeno Phil.",
    "TLG0302": "Choerilus Trag.",
    "TLG0002": "Theognis Eleg.",
    "TLG2654": "Physiologus",
    "TLG0379": "Philoxenus Lyr.",
    "TLG0564": "Rufus Med.",
    "TLG1409": "Heraclides Ponticus Phil.",
    "TLG2229": "Xuthus Phil.",
    "TLG0432": "Clearchus Comic.",
    "TLG2937": "Lachares Soph.",
    "TLG1451": "Josephus Et Aseneth",
    "TLG0409": "Antidotus Comic.",
    "TLG2615": "Daphitas Gramm. vel Soph.",
    "TLG0400": "Alcaeus Comic.",
    "TLG0425": "Bato Comic.",
    "TLG0343": "Ezechiel Trag.",
    "TLG1369": "Evangelium Mariae",
    "TLG2404": "Philogelos",
    "TLG0208": "Dosiadas Lyr.",
    "TLG1725": "Theophilus Apol.",
    "TLG2424": "Chaeremon Hist. et Phil.",
    "TLG0353": "Sclerias Trag.",
    "TLG1254": "Charax Hist.",
    "TLG2449": "Timotheus Gramm.",
    "TLG0090": "Agathemerus Geogr.",
    "TLG2034": "Porphyrius Phil.",
    "TLG1371": "Evangelium Petri",
    "TLG1799": "Euclides Geom.",
    "TLG1802": "Homerica",
    "TLG1434": "Hippias Soph.",
    "TLG2946": "Priscus Hist. et Rhet.",
    "TLG0479": "Nico Comic.",
    "TLG0026": "Aeschines Orat.",
    "TLG0580": "Paradoxographus Florentinus",
    "TLG5004": "Epimerismi",
    "TLG1463": "Liber Enoch",
    "TLG1153": "Apocalypsis Adam",
    "TLG1765": "Vitae Aesopi",
    "TLG0619": "Apollonius Phil.",
    "TLG2328": "Diogenes Hist.",
    "TLG1445": "Iliu Persis",
    "TLG2319": "Apollodorus Phil.",
    "TLG0243": "Callinus Eleg.",
    "TLG0546": "Aelianus Tact.",
    "TLG2192": "[Agatharchides] Hist.",
    "TLG1301": "Demetrius Poet. Phil.",
    "TLG1666": "Sententiae Sexti",
    "TLG1548": "Oenomaus Phil.",
    "TLG2409": "Dioscurides Hist.",
    "TLG1587": "Philiades Eleg.",
    "TLG1803": "Bruti Epistulae",
    "TLG4033": "Anonymi In Aristotelis Ethica Nicomachea Phil.",
    "TLG2330": "Scamon Hist.",
    "TLG0579": "Orphica",
    "TLG1645": "Ptolemaeus VIII Euergetes II Hist.",
    "TLG4201": "Joannes Chortasmenus Phil.",
    "TLG1179": "Arimnestus Phil.",
    "TLG0023": "Oppianus Epic.",
    "TLG1482": "Cyranides",
    "TLG0258": "Pigres Eleg.",
    "TLG5003": "Erotica Adespota",
    "TLG1608": "Phrynichus Attic.",
    "TLG1710": "Theages Phil.",
    "TLG0392": "Acusilaus Hist.",
    "TLG3143": "Georgius Sphrantzes Hist.",
    "TLG0732": "Alexander Phil.",
    "TLG0146": "Boethus Epigr.",
    "TLG0311": "Iophon Trag.",
    "TLG2555": "Agesilaus Hist.",
    "TLG2357": "Gorgon Hist.",
    "TLG2412": "Androetas Hist.",
    "TLG1524": "Naumachius Epic.",
    "TLG1746": "Valentinus Gnost.",
    "TLG1649": "Pythaenetus Hist.",
    "TLG4098": "Etymologicum Gudianum",
    "TLG2317": "Hermias Phil.",
    "TLG4174": "Paraphrases In Dionysium Periegetam",
    "TLG1362": "Eurytus Phil.",
    "TLG4374": "Anonymi De Astrologia Dialogus Astrol.",
    "TLG0553": "Artemidorus Onir.",
    "TLG1315": "Dinolochus Comic.",
    "TLG0077": "Periplus Maris Magni",
    "TLG0012": "Homerus Epic., Homer",
    "TLG0632": "Pythagoras Phil.",
    "TLG1899": "Aristonicus Hist.",
    "TLG1945": "Antigenes Hist.",
    "TLG1844": "Hera[clides] Trag.",
    "TLG1270": "Clearchus Phil.",
    "TLG4016": "Ammonius Phil.",
    "TLG1203": "Paeanes (CA)",
    "TLG0088": "Aristoxenus Mus.",
    "TLG1355": "Erinna Lyr.",
    "TLG1320": "Diogenes Phil.",
    "TLG2120": "Panteleius Epic.",
    "TLG0586": "Polemon Perieg.",
    "TLG0334": "Diogenes Phil. et Trag.",
    "TLG3027": "Joannes Doxapatres Rhet.",
    "TLG0737": "Julianus Scriptor Legis De Medicis",
    "TLG1183": "Aristeae Epistula",
    "TLG2012": "Acta Eupli",
    "TLG0451": "Epicrates Comic.",
    "TLG4115": "Theophilus Scr. Eccl.",
    "TLG0364": "Danaïs vel Danaïdes",
    "TLG1361": "Eumedes Comic.",
    "TLG0442": "Dexicrates Comic.",
    "TLG0729": "Theophilus Protospatharius Med.",
    "TLG1781": "Philippus Comic.",
    "TLG4319": "Zosimus Alchem.",
    "TLG1413": "Heraclitus Paradox.",
    "TLG2033": "Theon Math.",
    "TLG1514": "Mnaseas Perieg.",
    "TLG1723": "Theolytus Epic.",
    "TLG2236": "Eutropius Hist.",
    "TLG0035": "Moschus Bucol.",
    "TLG2005": "Martyrium Pionii",
    "TLG0552": "Archimedes Geom.",
    "TLG1239": "Domitius Callistratus Hist.",
    "TLG0539": "Hellanicus Hist.",
    "TLG1832": "Acesander Hist.",
    "TLG1407": "Heraclides Lembus Hist.",
    "TLG0518": "Xenarchus Comic.",
    "TLG4080": "Geoponica",
    "TLG0292": "Stesichorus Lyr.",
    "TLG1529": "Nicander Gramm.",
    "TLG1354": "Ergias Hist.",
    "TLG2434": "Aelius Dius Hist.",
    "TLG0383": "Alcaeus Lyr.",
    "TLG1450": "Ister Hist.",
    "TLG1178": "Aresas Phil.",
    "TLG0587": "Sotion Paradox.",
    "TLG1329": "Dionysius Scr. Eccl.",
    "TLG0367": "Tynnichus Lyr.",
    "TLG4318": "Vita Sophoclis",
    "TLG0476": "Mnesimachus Comic.",
    "TLG1489": "Megasthenes Hist.",
    "TLG3069": "Leo Diaconus Hist.",
    "TLG2334": "Nausiphanes Phil.",
    "TLG1553": "Palaephatus Myth.",
    "TLG5027": "Scholia In Iamblichum Philosophum",
    "TLG2948": "Acta Philippi",
    "TLG1429": "Hierocles Phil.",
    "TLG1296": "Cypria",
    "TLG0380": "Philoxenus Lyr.",
    "TLG0371": "Diagoras Lyr.",
    "TLG1868": "Damastes Hist.",
    "TLG0603": "Silenus Trag.",
    "TLG0031": "Novum Testamentum, New Testament",
    "TLG2037": "Joannes Stobaeus Anthologus",
    "TLG2729": "Prorus Phil.",
    "TLG0063": "Dionysius Thrax Gramm.",
    "TLG1464": "Liber Jubilaeorum",
    "TLG0491": "Philiscus Comic.",
    "TLG2000": "Plotinus Phil.",
    "TLG1685": "Sosibius Gramm.",
    "TLG0074": "Flavius Arrianus Hist. et Phil.",
    "TLG1871": "Bion Hist.",
    "TLG0069": "Dionysius Geogr.",
    "TLG0522": "Pisander Epic.",
    "TLG0532": "Achilles Tatius Scr. Erot.",
    "TLG1087": "Cleophon Trag.",
    "TLG2418": "Archinus Hist.",
    "TLG2945": "Gnomologium Vaticanum",
    "TLG1191": "Aristombrotus Phil.",
    "TLG3139": "Laonicus Chalcocondyles Hist.",
    "TLG1442": "Idomeneus Hist.",
    "TLG0217": "Anacreon Junior Eleg.",
    "TLG2607": "Alexinus Phil.",
    "TLG0646": "Pseudo-Justinus Martyr",
    "TLG4193": "Anonymi In Aristotelis Sophisticos Elenchos Phil.",
    "TLG4084": "Zosimus Hist.",
    "TLG0220": "Moero Epic.",
    "TLG2213": "[Timotheus] Hist.",
    "TLG2610": "Boiscus Iamb.",
    "TLG2816": "Joannes Gramm. et Theol.",
    "TLG1811": "Metrodorus Major Phil.",
    "TLG2479": "Patrocles Hist.",
    "TLG0384": "Acta Justini Et Septem Sodalium",
    "TLG2542": "Quintus Fabius Pictor Hist.",
    "TLG1184": "Aristides Apol.",
    "TLG1735": "Timon Phil.",
    "TLG2182": "Staphylus Hist.",
    "TLG1754": "Xenophontis Epistulae",
    "TLG1843": "Nicomachus Trag.",
    "TLG2300": "Promathidas Hist.",
    "TLG0465": "Heniochus Comic.",
    "TLG0381": "Lycophronides Lyr.",
    "TLG3100": "Nicolaus I Mysticus Theol. et Epist.",
    "TLG1275": "Cleostratus Poet. Phil.",
    "TLG1240": "Callixenus Hist.",
    "TLG0011": "Sophocles Trag.",
    "TLG0051": "Melissa Phil.",
    "TLG0474": "Magnes Comic.",
    "TLG0284": "Aelius Aristides Rhet.",
    "TLG1432": "Hipparchus Phil.",
    "TLG0256": "Panarces Scriptor Aenigmatum",
    "TLG0231": "Elegiaca Adespota (CA)",
    "TLG0262": "Socrates Phil.",
    "TLG2019": "Pelagius Alchem.",
    "TLG0440": "Demetrius Junior Comic.",
    "TLG0237": "Anacreon Lyr.",
    "TLG0671": "Philumenus Med.",
    "TLG2231": "Thrasyalces Phil.",
    "TLG0816": "Theudo[tus] Trag.",
    "TLG1521": "Vita Et Sententiae Secundi",
    "TLG2228": "Menestor Phil.",
    "TLG0626": "Heraclitus Phil.",
    "TLG1493": "Melinno Lyr.",
    "TLG4337": "Heliodorus Alchem. et Poeta",
    "TLG1503": "Menecrates Hist.",
    "TLG0004": "Diogenes Laertius Biogr.",
    "TLG2015": "Testamentum XL Martyrum",
    "TLG1969": "Philinus Hist.",
    "TLG4135": "Theodorus Theol.",
    "TLG0889": "Timesitheus Trag.",
    "TLG1615": "Platonius Gramm.",
    "TLG0570": "Archelaus Paradox.",
    "TLG1105": "Timaeus Praxidas Astrol.",
    "TLG1629": "Polystratus Phil.",
    "TLG1219": "Bato Hist. et Rhet.",
    "TLG4324": "Synesius Alchem.",
    "TLG0637": "Socraticorum Epistulae",
    "TLG2646": "Fragmenta Adespota (SH)",
    "TLG4013": "Simplicius Phil.",
    "TLG2141": "Publius Herennius Dexippus Hist.",
    "TLG2121": "Dioscorus Poeta",
    "TLG2613": "Callimachus Junior Epic.",
    "TLG1804": "Ninus",
    "TLG2460": "Glaucus Hist.",
    "TLG0449": "Ecphantides Comic.",
    "TLG2336": "Hereas Hist.",
    "TLG1603": "Phintys Phil.",
    "TLG0448": "Dromo Comic.",
    "TLG2557": "[Aristobulus] Hist.",
    "TLG1393": "Hegesianax Astron. et Epic.",
    "TLG1170": "Apollonius Hist.",
    "TLG0257": "Philiscus Rhet.",
    "TLG2583": "Manetho Astrol.",
    "TLG1360": "Euryphamus Phil.",
    "TLG5018": "Scholia In Dionysium Byzantium",
    "TLG1192": "Ariston Phil.",
    "TLG1148": "Antonius Diogenes Scr. Erot.",
    "TLG0279": "Discipulorum Cantiuncula",
    "TLG2995": "Orus Gramm.",
    "TLG2326": "Dei(l)ochus Hist.",
    "TLG3094": "Nicetas Choniates Hist., Scr. Eccl. et Rhet.",
    "TLG1595": "Philodemus Phil.",
    "TLG2021": "Epiphanius Scr. Eccl.",
    "TLG1805": "Vitae Homeri",
    "TLG1941": "Leo Hist.",
    "TLG0550": "Apollonius Geom.",
    "TLG0242": "Asius Eleg. et Epic.",
    "TLG2399": "Eudromus Phil.",
    "TLG0336": "Crates Poet. Phil.",
    "TLG0578": "Nymphodorus Hist.",
    "TLG0407": "Anaxippus Comic.",
    "TLG4325": "[Hermes] Alchem.",
    "TLG1272": "Cleomedes Astron.",
    "TLG0595": "Zeno Phil.",
    "TLG1570": "Epitaphium Pectorii",
    "TLG2059": "Alexander Theol.",
    "TLG4175": "Commentaria In Dionysii Thracis Artem Grammaticam",
    "TLG0265": "Timocreon Lyr.",
    "TLG1318": "Diodorus Rhet.",
    "TLG0303": "Phrynichus Trag.",
    "TLG0306": "Aristarchus Trag.",
    "TLG2525": "Laetus Hist.",
    "TLG1801": "Parodica Anonyma",
    "TLG2640": "Eusebius Phil.",
    "TLG1314": "Dinias Hist.",
    "TLG0199": "Bacchylides Lyr.",
    "TLG2245": "Simus Phil.",
    "TLG0499": "Polyzelus Comic.",
    "TLG2227": "Paron Phil.",
    "TLG0563": "Maximus Soph.",
    "TLG2331": "Myrsilus Hist.",
    "TLG3186": "Anonymus Dialogus Cum Judaeis",
    "TLG0086": "Aristoteles Phil. et Corpus Aristotelicum, Aristotle",
    "TLG3178": "Anonymi Lexeis Rhetoricae",
    "TLG1249": "Cephalion Hist. et Rhet.",
    "TLG4029": "Procopius Hist.",
    "TLG4046": "Theophanes Confessor Chronogr.",
    "TLG1646": "Ptolemaeus Hist.",
    "TLG0447": "Diphilus Comic.",
    "TLG2064": "Acacius Theol.",
    "TLG2591": "Orion Gramm.",
    "TLG0420": "Aristonymus Comic.",
    "TLG2543": "Lucius Cincius Alimentus Hist.",
    "TLG2444": "Lycophron Soph.",
    "TLG0216": "Alexander Lyr. et Trag.",
    "TLG0560": "[Longinus] Rhet., Pseudo-Longinus",
    "TLG2533": "Timolaus Hist.",
    "TLG4027": "Anonymi In Aristotelis Categorias Phil.",
    "TLG2645": "Stratonicus Poeta",
    "TLG2616": "Demareta Poeta",
    "TLG2594": "Phillis Hist.",
    "TLG1793": "Timoxenus Comic.",
    "TLG3181": "Nicephorus II Phocas Imperator Tact.",
    "TLG1281": "[Clitophon] Hist.",
    "TLG1399": "Pamphilus Trag.",
    "TLG0566": "Theopompus Hist.",
    "TLG1241": "Carmen Naupactium",
    "TLG4099": "Etymologicum Magnum",
    "TLG2008": "Martyrium Cononis",
    "TLG0478": "Nausicrates Comic.",
    "TLG1508": "Metrodorus Phil.",
    "TLG2512": "Paeon Hist.",
    "TLG2714": "Theodorus Studites Scr. Eccl. et Theol.",
    "TLG1177": "Pseudo-Archytas Phil.",
    "TLG0738": "Hippiatrica",
    "TLG1171": "Apollonius Scr. Eccl.",
    "TLG5013": "Scholia In Aratum",
    "TLG0203": "Limenius Lyr.",
    "TLG1308": "Demosthenes Epic.",
    "TLG2806": "Marcus Diaconus Scr. Eccl.",
    "TLG4061": "Cosmas Indicopleustes Geogr.",
    "TLG3140": "Joel Chronogr.",
    "TLG1244": "Carneiscus Phil.",
    "TLG0424": "Axionicus Comic.",
    "TLG4305": "Claudius Casilon Gramm.",
    "TLG0059": "Plato Phil.",
    "TLG4149": "Sophronius Gramm.",
    "TLG2631": "Menophilus Poeta",
    "TLG2255": "Gorgias Hist.",
    "TLG3074": "Constantinus Manasses Hist. et Poeta",
    "TLG0613": "Demetrius Rhet.",
    "TLG0041": "Chionis Epistulae",
    "TLG3015": "Joannes Cameniates Hist.",
    "TLG2903": "Minucianus Junior Rhet.",
    "TLG0046": "Niciae Epistula",
    "TLG0435": "Cratinus Junior Comic.",
    "TLG2718": "Manuel Philes Poeta et Scr. Rerum Nat.",
    "TLG0520": "Arcesilaus Comic.",
    "TLG0245": "Demodocus Eleg.",
    "TLG1125": "Androtion Hist.",
    "TLG0165": "Diodorus Rhet.",
    "TLG5014": "Scholia In Aristophanem",
    "TLG2697": "Timolaus Rhet.",
    "TLG0295": "Carmina Popularia (PMG)",
    "TLG3079": "Michael Attaliates Hist.",
    "TLG1443": "Ignatius Scr. Eccl.",
    "TLG1786": "Sogenes Comic.",
    "TLG1648": "Pyrgion Hist.",
    "TLG0918": "Lamynthius Lyr.",
    "TLG0549": "Apollodorus Gramm.",
    "TLG2055": "Serenus Geom.",
    "TLG0477": "Myrtilus Comic.",
    "TLG1263": "Choerilus Epic.",
    "TLG0714": "Anaxarchus Phil.",
    "TLG0209": "Seleucus Lyr.",
    "TLG0469": "Laon Comic.",
    "TLG0282": "Anonymus De Viribus Herbarum",
    "TLG1190": "Aristagoras Hist.",
    "TLG2762": "Gennadius I Scr. Eccl.",
    "TLG4172": "Vitae Oppiani",
    "TLG1325": "Diogenis Sinopensis Epistulae",
    "TLG1566": "Parmeno Iamb.",
    "TLG2622": "Dorieus Poeta",
    "TLG1433": "Hipparchus Epigr.",
    "TLG1194": "Aristonicus Gramm.",
    "TLG9006": "Gregorius Paroemiogr.",
    "TLG1297": "Damippus Phil.",
    "TLG0406": "Anaxilas Comic.",
    "TLG3064": "Scylitzes Continuatus",
    "TLG5045": "Anonymi In Aphthonium Rhet.",
    "TLG1485": "Martyrium Ptolemaei Et Lucii",
    "TLG0462": "Euthycles Comic.",
    "TLG4187": "Leo Magentinus Phil.",
    "TLG0565": "Soranus Med.",
    "TLG4014": "Priscianus Phil.",
    "TLG0513": "Theopompus Comic.",
    "TLG0013": "Hymni Homerici, Homeric Hymns",
    "TLG0347": "Serapion Trag.",
    "TLG4000": "Aristaenetus Epist.",
    "TLG2119": "Christodorus Epic.",
    "TLG1664": "Seniores Alexandrini Scr. Eccl.",
    "TLG2282": "Melisseus Hist.",
    "TLG9018": "Arsenius Paroemiogr.",
    "TLG1747": "Vita Adam Et Evae",
    "TLG1201": "Assumptio Mosis",
    "TLG1156": "Apocalypsis Eliae",
    "TLG0032": "Xenophon Hist.",
    "TLG0272": "De Arboribus Avibusque Fabulae",
    "TLG0468": "Hipparchus Comic.",
    "TLG0656": "Dioscorides Pedanius Med.",
    "TLG0049": "Pisistrati Epistula",
    "TLG1500": "Menecrates Poet. Phil.",
    "TLG1163": "Claudius Apollinarius Apol.",
    "TLG1368": "Evangelium Ebionitum",
    "TLG2043": "Hephaestion Astrol.",
    "TLG2648": "Adespota Papyracea (SH)",
    "TLG1306": "Bolus Med. et Phil.",
    "TLG0349": "Demonax Trag.",
    "TLG1469": "Lyceas Hist.",
    "TLG4288": "Lexicon αἱμωδεῖν",
    "TLG2499": "Eustochius Soph.",
    "TLG0394": "Apollonius Comic.",
    "TLG0098": "Zenobius Sophista Paroemiogr.",
    "TLG1218": "Basilis Hist.",
    "TLG0125": "Zenonis Epistula",
    "TLG2612": "Caecalus (?) Epic.",
    "TLG2205": "Autesion Hist.",
    "TLG4311": "Etymologicum Symeonis",
    "TLG9003": "Anonymus Lexicographus Lexicogr.",
    "TLG9010": "Suda, Suidas",
    "TLG1461": "Leucippus Phil.",
    "TLG0065": "Scylax Perieg.",
    "TLG2619": "Dionysius Epic.",
    "TLG2638": "Philo Poeta",
    "TLG1131": "Anonymus Ad Avircium Marcellum Contra Cataphrygas",
    "TLG2195": "[Chrysermus] Hist.",
    "TLG3159": "Barlaam Math., Theol. et Epist.",
    "TLG0673": "Aeschines Socraticus Phil.",
    "TLG0688": "Agathocles Hist.",
    "TLG2151": "Praxagoras Hist.",
    "TLG1800": "Euboeus Parodius",
    "TLG1096": "Euaretus Trag.",
    "TLG0204": "Aristonous Lyr.",
    "TLG3039": "Joannes Galenus Gramm.",
    "TLG1726": "Theopompus Epic.",
    "TLG0327": "Carcinus Junior Trag.",
    "TLG0693": "Albinus Phil.",
    "TLG4227": "Anonymus De Philosophia Platonica Phil.",
    "TLG1845": "Callistratus Trag.",
    "TLG1530": "Nicanor Gramm.",
    "TLG0247": "Dionysius II Eleg.",
    "TLG1319": "Diogenes Phil.",
    "TLG1541": "Nostoi",
    "TLG0412": "Apollodorus Carystius vel Apollodorus Gelous Comic.",
    "TLG2894": "Constitutiones Apostolorum",
    "TLG2016": "Passio Perpetuae Et Felicitatis",
    "TLG1487": "Maximus Astrol.",
    "TLG0657": "Crateuas Med.",
    "TLG1907": "Cratippus Hist.",
    "TLG4028": "Stephanus Gramm.",
    "TLG0610": "Alcidamas Rhet.",
    "TLG1282": "Clytus Hist.",
    "TLG2587": "Ariston Phil.",
    "TLG7000": "Anthologia Graeca, AG",
    "TLG0354": "Zenodotus Trag.",
    "TLG0748": "Severus Iatrosophista Med.",
    "TLG5016": "Scholia In Callimachum",
    "TLG0201": "Isyllus Lyr.",
    "TLG1597": "Telauges Phil.",
    "TLG0428": "Cantharus Comic.",
    "TLG1188": "Aristocles Phil.",
    "TLG2571": "Hierocles Phil.",
    "TLG0618": "Antigoni Epistula",
    "TLG1987": "Theodorus Poeta",
    "TLG1338": "Dosiadas Hist.",
    "TLG2865": "Olympiodorus Diaconus Scr. Eccl.",
    "TLG1555": "Pancrates Epic.",
    "TLG0634": "Xenocrates Phil.",
    "TLG1223": "Bias Phil.",
    "TLG2036": "Dexippus Phil.",
    "TLG1635": "Protagoras Soph.",
    "TLG0443": "Diocles Comic.",
    "TLG0635": "Zeno Phil.",
    "TLG4026": "Anonymi In Aristotelis Artem Rhetoricam Rhet.",
    "TLG1199": "Asclepiades Gramm. et Hist.",
    "TLG1751": "Xanthus Hist.",
    "TLG1496": "Memnon Hist.",
    "TLG4157": "Joannes Rhet.",
    "TLG0131": "Archimelus Epigr.",
    "TLG1785": "Paramonus Comic.",
    "TLG1305": "Democritus Hist.",
    "TLG2552": "Critolaus Hist.",
    "TLG1158": "Apocalypsis Joannis",
    "TLG0473": "Machon Comic.",
    "TLG2201": "[Ctesiphon] Hist.",
    "TLG0314": "Morsimus Trag.",
    "TLG0283": "Heraclides Ponticus Junior Gramm.",
    "TLG2230": "Boïdas Phil.",
    "TLG1444": "Ilias Parva",
    "TLG1954": "Heraclides Phil.",
    "TLG0453": "Epilycus Comic.",
    "TLG1634": "Prodicus Soph.",
    "TLG0297": "Lyrica Adespota (PMG)",
    "TLG1257": "Charinus Choliamb.",
    "TLG0250": "Euclides Comic. vel Iamb.",
    "TLG1231": "Bryson Phil.",
    "TLG2341": "Aristocritus Hist.",
    "TLG1322": "Diogenianus Phil.",
    "TLG1316": "Dinon Hist.",
    "TLG0525": "Pausanias Perieg.",
    "TLG0313": "Theognis Trag.",
    "TLG4163": "Telegonia",
    "TLG1414": "Heraclitus Phil.",
    "TLG4094": "Choricius Rhet. et Soph.",
    "TLG2393": "Andreas Hist.",
    "TLG1491": "Melanthius Hist.",
    "TLG1681": "Solonis Epistulae",
    "TLG9012": "Ignatius Biogr. et Poeta",
    "TLG0643": "Anonymus Londinensis Med.",
    "TLG1143": "Antiochus Phil.",
    "TLG0454": "Epinicus Comic.",
    "TLG3063": "Joannes Scylitzes Hist.",
    "TLG4294": "Lexicon Vindobonense",
    "TLG1220": "Batrachomyomachia",
    "TLG0006": "Euripides Trag.",
    "TLG1848": "Meletus Junior Trag.",
    "TLG1599": "Philo Mech.",
    "TLG1551": "Oracula Sibyllina",
    "TLG2219": "Amelesagoras Hist.",
    "TLG2766": "Eudocia Augusta Poeta",
    "TLG1186": "Aristobulus Judaeus Phil.",
    "TLG4304": "Glossae In Herodotum",
    "TLG2680": "Scythinus Epigr.",
    "TLG3145": "Joannes Anagnostes Hist. et Poeta",
    "TLG4338": "Theophrastus Alchem. et Poeta",
    "TLG4326": "Pappus Alchem.",
    "TLG0082": "Apollonius Dyscolus Gramm.",
    "TLG1526": "Neoptolemus Gramm.",
    "TLG0038": "Arcesilai Epistula",
    "TLG0505": "Sotades Comic.",
    "TLG2035": "Athanasius Theol.",
    "TLG0355": "Zopyrus Trag.",
    "TLG1293": "Crinis Phil.",
    "TLG0576": "Musaeus Epic.",
    "TLG1374": "Evangelium Secundum Hebraeos",
    "TLG0663": "Praecepta Salubria",
    "TLG0373": "Melanippides Lyr.",
    "TLG1212": "Atridarum Reditus",
    "TLG0736": "Stephanus Med.",
    "TLG1398": "Hegesippus Scr. Eccl.",
    "TLG2386": "Timonides Hist.",
    "TLG1160": "Apocalypsis Sophoniae",
    "TLG1627": "Polycrates Hist.",
    "TLG1302": "Demetrius Rhet.",
    "TLG1867": "Crito Hist.",
    "TLG1558": "Papias Scr. Eccl.",
    "TLG1970": "Silenus Hist.",
    "TLG3045": "Georgius Syncellus Chronogr.",
    "TLG2417": "Cineas Rhet.",
    "TLG0093": "Theophrastus Phil.",
    "TLG0456": "Euangelus Comic.",
    "TLG1366": "Evangelium Bartholomaei",
    "TLG1486": "Matron Parodius",
    "TLG0401": "Alexander Comic.",
    "TLG0727": "Joannes Med.",
    "TLG1812": "Demaratus Hist.",
    "TLG1713": "Themison Hist.",
    "TLG0471": "Lynceus Comic.",
    "TLG0717": "Hypsicles Astron. et Math.",
    "TLG0633": "Lysis Phil.",
    "TLG0337": "Python Trag.",
    "TLG9022": "Joannes Tzetzes Gramm. et Poeta",
    "TLG0628": "Gaius Musonius Rufus Phil.",
    "TLG1210": "Autolycus Astron.",
    "TLG1446": "Ion Eleg.",
    "TLG1402": "Hephaestion Gramm.",
    "TLG9008": "Macarius Chrysocephalus Paroemiogr.",
    "TLG1439": "Hermarchus Phil.",
    "TLG0530": "Pseudo-Galenus Med.",
    "TLG1908": "Daimachus Hist.",
    "TLG4020": "Elias Phil.",
    "TLG0039": "Mithridatis Epistula",
    "TLG4076": "Menander Protector Hist.",
    "TLG2426": "Hermaeus Hist.",
    "TLG0318": "Agathon Trag.",
    "TLG2531": "Metrophanes Hist.",
    "TLG1344": "Epica Adespota (CA)",
    "TLG2611": "Butas Eleg.",
    "TLG1917": "Demetrius Hist.",
    "TLG0438": "Damoxenus Comic.",
    "TLG0239": "Antimachus Eleg. et Epic.",
    "TLG2185": "Dionysius Μεταθέμενος Phil.",
    "TLG0559": "Heron Mech.",
    "TLG1152": "Apion Gramm.",
    "TLG2693": "Ptolemaeus III Euergetes I Epigr.",
    "TLG0766": "Alcmaeon Phil.",
    "TLG2202": "[Menyllus] Hist.",
    "TLG2030": "Geographica Adespota (GGM)",
    "TLG1430": "Hieronymus Phil.",
    "TLG1737": "Titanomachia",
    "TLG0232": "Archilochus Eleg. et Iamb.",
    "TLG0696": "Alcmaeonis",
    "TLG1353": "Epitaphium Abercii",
    "TLG1411": "Heracliti Ephesii Epistulae",
    "TLG1976": "Metrodorus Hist.",
    "TLG9007": "Appendix Proverbiorum",
    "TLG1580": "Phaestus Epic.",
    "TLG0097": "Diogenianus Gramm.",
    "TLG0494": "Philyllius Comic.",
    "TLG1547": "Oedipodea",
    "TLG0365": "Apollodorus Lyr.",
    "TLG2306": "Xenomedes Hist.",
    "TLG0639": "Menecrates Med.",
    "TLG0750": "Heliodorus Trag.",
    "TLG4290": "Lexicon Artis Grammaticae",
    "TLG0683": "Aethiopis",
    "TLG0427": "Callippus Comic.",
    "TLG0075": "Periplus Ponti Euxini",
    "TLG1483": "Martyrium Et Ascensio Isaiae",
    "TLG0691": "Harpocrationis Epistula",
    "TLG2598": "Procopius Rhet. et Scr. Eccl.",
    "TLG1552": "Oratio Josephi",
    "TLG1202": "Athamas Phil.",
    "TLG0652": "Philostratus Junior Soph.",
    "TLG2240": "Hicetas Phil.",
    "TLG1358": "Eudoxus Astron.",
    "TLG0081": "Dionysius Halicarnassensis Hist. et Rhet.",
    "TLG2601": "Tiberius Rhet.",
    "TLG0743": "Nemesius Theol.",
    "TLG4361": "Apomasar Astrol.",
    "TLG2604": "Ulpianus Gramm. et Rhet.",
    "TLG0382": "Castorion Lyr.",
    "TLG0028": "Antiphon Orat.",
    "TLG0008": "Athenaeus Soph.",
    "TLG0594": "Alexander Rhet. et Soph.",
    "TLG1193": "Ariston Phil.",
    "TLG2392": "Artemon Hist.",
    "TLG0402": "Alexis Comic.",
    "TLG0486": "Pherecrates Comic.",
    "TLG2050": "Eunapius Hist. et Soph.",
    "TLG5000": "Concilia Oecumenica (ACO)",
    "TLG0497": "Plato Comic.",
    "TLG4097": "Etymologicum Genuinum",
    "TLG0241": "Aristoxenus Comic.",
    "TLG4090": "Cyrillus Theol.",
    "TLG0845": "Ctesias Hist. et Med.",
    "TLG1021": "Meropis",
    "TLG2384": "Hermias Hist.",
    "TLG1817": "Fragmenta Anonyma (PsVTGr)",
    "TLG4100": "Aphthonius Rhet.",
    "TLG1512": "Minyas",
    "TLG1639": "Pseudo-Auctores Hellenistae (PsVTGr)",
    "TLG0654": "Lucius Annaeus Cornutus Phil.",
    "TLG2023": "Iamblichus Phil.",
    "TLG1364": "Evangelium Aegyptium",
    "TLG1389": "Harpocration Gramm.",
    "TLG2609": "Asopodorus Iamb.",
    "TLG1165": "Apollodorus Mech.",
    "TLG2396": "Hyperochus Hist.",
    "TLG0666": "Adrianus Rhet. et Soph.",
    "TLG0504": "Sosipater Comic.",
    "TLG2084": "Basilius Med. et Scr. Eccl.",
    "TLG0876": "Phrynichus II Trag.",
    "TLG1408": "Heraclides Gramm.",
    "TLG5048": "Scholia In Clementem Alexandrinum",
    "TLG1604": "Phocylides Eleg. et Gnom.",
    "TLG1269": "Cleanthes Phil.",
    "TLG2798": "Pseudo-Dionysius Areopagita Scr. Eccl. et Theol.",
    "TLG2536": "Andron Geogr.",
    "TLG2190": "[Clitonymus] Hist.",
    "TLG0466": "Heraclides Comic.",
    "TLG1428": "Hestiaeus Hist.",
    "TLG2968": "Monimus Phil.",
    "TLG0359": "Isidorus Scriptor Hymnorum",
    "TLG0072": "Anonymi Grammatici Gramm.",
    "TLG1738": "Tragica Adespota",
    "TLG4303": "Lexica In Opera Gregorii Nazianzeni",
    "TLG0558": "Hellenica",
    "TLG1420": "Hermias Iamb.",
    "TLG1227": "Blaesus Comic.",
    "TLG0627": "Hippocrates Med. et Corpus Hippocraticum",
    "TLG0718": "Aëtius Med.",
    "TLG0058": "Aeneas Tact.",
    "TLG0543": "Polybius Hist.",
    "TLG1727": "Theotimus Hist.",
    "TLG0310": "Carcinus Trag.",
    "TLG1426": "Herodes Atticus Soph.",
    "TLG0421": "Aristophon Comic.",
    "TLG5035": "Scholia In Platonem",
    "TLG1696": "Straton Phil.",
    "TLG2133": "Achilles Tatius Astron.",
    "TLG0054": "Theano Phil.",
    "TLG1476": "Mamercus Eleg.",
    "TLG1682": "Sopater Comic.",
    "TLG0568": "Antigonus Paradox.",
    "TLG1757": "Julius Epic.",
    "TLG1797": "Choliambica Adespota (ALG)",
    "TLG0053": "Phalaridis Epistulae",
    "TLG0607": "Aelius Theon Rhet.",
    "TLG0066": "Dicaearchus Phil.",
    "TLG1211": "Balagrus Hist.",
    "TLG0339": "Moschion Trag.",
    "TLG0644": "Aristophanes Gramm.",
    "TLG4184": "Dionysius Soph.",
    "TLG0507": "Straton Comic.",
    "TLG1136": "Anonymus Presbyter Scr. Eccl.",
    "TLG2962": "Petrus Scr. Eccl. et Theol.",
    "TLG0687": "Agaclytus Hist.",
    "TLG2052": "Horapollo Gramm.",
    "TLG3177": "Scriptor Incertus De Leone Armenio Hist.",
    "TLG1559": "Bucolicum",
    "TLG1291": "Creophylus Hist.",
    "TLG1134": "Anonymus Iamblichi Phil.",
    "TLG0519": "Xeno Comic.",
    "TLG1166": "Apollodorus Phil.",
    "TLG1121": "Anaximenis Milesii Epistulae",
    "TLG0534": "Callisthenes Hist.",
    "TLG2203": "[Theophilus] Hist.",
    "TLG1350": "Epistula Ad Diognetum",
    "TLG1294": "Critolaus Phil.",
    "TLG1505": "Menesthenes Hist.",
    "TLG1585": "Pherecydis Epistula",
    "TLG2112": "Amphilochius Scr. Eccl.",
    "TLG0433": "Crates Comic.",
    "TLG1441": "Iamblichus Scr. Erot.",
    "TLG1711": "Thearidas Phil.",
    "TLG5017": "Scholia In Demosthenem",
    "TLG0372": "Praxilla Lyr.",
    "TLG2634": "Pamphilus Poeta",
    "TLG1782": "Augeas Comic.",
    "TLG1475": "Maiistas Epic.",
    "TLG0346": "Pompeius Macer Trag.",
    "TLG1328": "Dionysius Hist.",
    "TLG1278": "Clitarchus Gnom.",
    "TLG1230": "Brotinus Phil.",
    "TLG0614": "Valerius Babrius Scr. Fab.",
    "TLG0444": "Diodorus Comic.",
    "TLG1388": "Harmodius Hist.",
    "TLG1381": "Fragmentum Synodicae Epistulae Concilii Caesariensis",
    "TLG0648": "Onasander Tact.",
    "TLG1176": "Archytas Epic.",
    "TLG1836": "Anonymi Aulodia",
    "TLG4286": "Lexica Syntactica",
    "TLG4088": "Anthemius Math. et Mech.",
    "TLG1584": "Pherecydes Hist.",
    "TLG0690": "Erasistratus Med.",
    "TLG1813": "Anonymus De Plantis Aegyptiis",
    "TLG2691": "[Musaeus] Phil.",
    "TLG0323": "Antiphon Trag.",
    "TLG0275": "Peirazomene",
    "TLG1704": "Teucer Hist.",
    "TLG1452": "Juba II Rex Mauretaniae Hist.",
    "TLG1756": "Demetrius Gramm.",
    "TLG0083": "Dionysius Geogr.",
    "TLG0332": "Cleaenetus Trag.",
    "TLG2194": "[Aristides] Hist.",
    "TLG4032": "Anonymi In Aristotelis Librum Primum Analyticorum Posteriorum Commentarium",
    "TLG0084": "Dionysius Perieg.",
    "TLG3088": "Nicephorus Bryennius Hist.",
    "TLG2235": "Hippocrates Math.",
    "TLG2371": "Chronicon Paschale",
    "TLG1390": "Hecataeus Hist.",
    "TLG0731": "Adamantius Judaeus Med.",
    "TLG0294": "Corinna Lyr.",
    "TLG1623": "Polycharmus Hist.",
    "TLG2160": "Pyrrhus Hist.",
    "TLG1637": "Protevangelium Jacobi",
    "TLG0324": "Patrocles Trag.",
    "TLG2004": "Amelii Epistula",
    "TLG0366": "Lasus Lyr.",
    "TLG0033": "Pindarus Lyr.",
    "TLG0060": "Diodorus Siculus Hist.",
    "TLG2626": "Hipparchus Parodius",
    "TLG2171": "Stesiclides Hist.",
    "TLG0317": "Acta Joannis",
    "TLG0096": "Aesopus Scr. Fab. et Aesopica",
    "TLG1509": "Milon Phil.",
    "TLG2039": "Diophantus Math.",
    "TLG0441": "Demonicus Comic.",
    "TLG1588": "Philicus Lyr.",
    "TLG1271": "Clemens Romanus Theol. et Clementina",
    "TLG4015": "Joannes Philoponus Phil.",
    "TLG4339": "Archelaus Alchem. et Poeta",
    "TLG0389": "Acta Petri",
    "TLG5037": "Scholia In Sophoclem",
    "TLG4282": "Anonymus Manichaeus Biogr.",
    "TLG1819": "Pseudo-Demosthenes Epigr.",
    "TLG1150": "Aphareus Rhet.",
    "TLG2649": "Amyntas Epigr.",
    "TLG1276": "Clidemus Hist.",
    "TLG2633": "Niceratus Epic.",
    "TLG2770": "Callinicus Biogr.",
    "TLG0018": "Philo Judaeus Phil.",
    "TLG4019": "Olympiodorus Phil.",
    "TLG2187": "Posidonius Hist.",
    "TLG2651": "Artemidorus Eleg.",
    "TLG2237": "Theodorus Math.",
    "TLG2511": "Demetrius Hist.",
    "TLG2578": "Joannes Gramm. et Poeta",
    "TLG1479": "Marci Aurelii Epistula",
    "TLG0234": "Elegiaca Adespota (IEG)",
    "TLG2461": "Uranius Hist.",
    "TLG4289": "Lexica Segueriana",
    "TLG0036": "Bion Bucol.",
    "TLG4327": "Joannes Archiereus Alchem.",
    "TLG1795": "Chaerion Comic.",
    "TLG2724": "Ammonius Scr. Eccl.",
    "TLG0397": "Pronomus Lyr.",
    "TLG1550": "Oracula Chaldaica",
    "TLG0213": "Hermesianax Eleg.",
    "TLG2694": "Sostratus Poeta",
    "TLG0309": "Achaeus Trag.",
    "TLG1260": "[Chersias] Epic.",
    "TLG1149": "Antonini Pii Imperatoris Epistula",
    "TLG0251": "Euenus Eleg.",
    "TLG0034": "Lycurgus Orat.",
    "TLG3047": "Michael Glycas Astrol. et Hist.",
    "TLG5046": "Scholia In Theonem Rhetorem",
    "TLG4138": "Ephraem Syrus Theol.",
    "TLG4101": "Etymologicum Parvum",
    "TLG2168": "Apollophanes Phil.",
    "TLG0099": "Strabo Geogr.",
    "TLG2620": "Dionysius Iambus Gramm. et Poeta",
    "TLG3115": "Symeon Metaphrastes Biogr. et Hist.",
    "TLG0464": "Hegesippus Comic.",
    "TLG0286": "Carmen Astrologicum",
    "TLG2545": "Gaius Acilius Hist. et Phil.",
    "TLG4239": "Severus Soph.",
    "TLG4167": "Leontius Mech.",
    "TLG2046": "Quintus Epic.",
    "TLG0211": "Simias Gramm.",
    "TLG1967": "Leschides Epic.",
    "TLG2950": "Adamantius Theol.",
    "TLG1395": "[Hegesinus] Epic.",
    "TLG1129": "Anonymi De Barbarismo Et Soloecismo Gramm.",
    "TLG2109": "Pseudo-Macarius Scr. Eccl.",
    "TLG2650": "Arrianus Epic.",
    "TLG5026": "Scholia In Homerum",
    "TLG1617": "Marcus Antonius Polemon Soph.",
    "TLG1470": "Lycus Hist.",
    "TLG0455": "Eriphus Comic.",
    "TLG1816": "Epica Adespota (GDRK)",
    "TLG1477": "Manetho Hist.",
    "TLG0325": "Astydamas Trag.",
    "TLG1397": "Hegesippus Hist.",
    "TLG1226": "Biton Mech.",
    "TLG2018": "Eusebius Scr. Eccl. et Theol.",
    "TLG0706": "Philo Med.",
    "TLG0263": "Solon Nomographus et Poeta",
    "TLG0601": "Zaleucus Nomographus Phil.",
    "TLG2364": "Zeno Hist.",
    "TLG0403": "Amipsias Comic.",
}


TLG_WORKS_INDEX: dict[str, dict[str, Union[list[str], str]]] = {
    "TLG2153": {"works": ["001"], "name": "Bion Math. et Phil."},
    "TLG0375": {"works": ["001", "002"], "name": "Cinesias Lyr."},
    "TLG2606": {"works": ["001"], "name": "Agathyllus Eleg."},
    "TLG3020": {"works": ["001", "002"], "name": "Joannes Cinnamus Gramm. et Hist."},
    "TLG0540": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
        ],
        "name": "Lysias Orat.",
    },
    "TLG0220": {"works": ["001", "002"], "name": "Moero Epic."},
    "TLG1804": {"works": ["001", "003", "004", "005"], "name": "Ninus"},
    "TLG1419": {
        "works": ["001", "002", "003", "004"],
        "name": "Hermas Scr. Eccl., Pastor Hermae",
    },
    "TLG1263": {"works": ["001", "003", "004", "005"], "name": "Choerilus Epic."},
    "TLG0324": {"works": ["001"], "name": "Patrocles Trag."},
    "TLG4039": {"works": ["001", "002"], "name": "Paulus Silentiarius Poeta"},
    "TLG0230": {"works": ["001"], "name": "Lyrica Adespota (CA)"},
    "TLG1178": {"works": ["001"], "name": "Aresas Phil."},
    "TLG2048": {"works": ["001"], "name": "Salaminius Hermias Sozomenus Scr. Eccl."},
    "TLG4289": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Lexica Segueriana",
    },
    "TLG1272": {"works": ["001"], "name": "Cleomedes Astron."},
    "TLG3120": {
        "works": ["001", "002", "003", "004"],
        "name": "Patria Constantinopoleos",
    },
    "TLG0050": {
        "works": ["001"],
        "name": "Ptolemaei II Philadelphi Et Eleazari Epistulae",
    },
    "TLG0333": {"works": ["001"], "name": "Timocles Trag."},
    "TLG4081": {"works": ["001"], "name": "Colluthus Epic."},
    "TLG4089": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "016",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
        ],
        "name": "Theodoretus Scr. Eccl. et Theol.",
    },
    "TLG2244": {"works": ["001"], "name": "Damon et Phintias Phil."},
    "TLG1305": {"works": ["003"], "name": "Democritus Hist."},
    "TLG1645": {"works": ["003"], "name": "Ptolemaeus VIII Euergetes II Hist."},
    "TLG0146": {"works": ["001", "002"], "name": "Boethus Epigr."},
    "TLG0282": {"works": ["001"], "name": "Anonymus De Viribus Herbarum"},
    "TLG4323": {"works": ["001"], "name": "Eugenius Alchem."},
    "TLG1016": {"works": ["001"], "name": "Ostanes Magus Alchem."},
    "TLG2178": {
        "works": ["001", "002", "004"],
        "name": "Cassius Longinus Phil. et Rhet.",
    },
    "TLG0520": {"works": ["001"], "name": "Arcesilaus Comic."},
    "TLG2171": {"works": ["002"], "name": "Stesiclides Hist."},
    "TLG2226": {"works": ["001"], "name": "Iccus Phil."},
    "TLG1177": {"works": ["001"], "name": "Pseudo-Archytas Phil."},
    "TLG2121": {"works": ["001"], "name": "Dioscorus Poeta"},
    "TLG3086": {
        "works": ["001", "002", "012"],
        "name": "Nicephorus I Scr. Eccl., Hist. et Theol.",
    },
    "TLG0360": {"works": ["002"], "name": "Armenidas Hist."},
    "TLG2059": {"works": ["001"], "name": "Alexander Theol."},
    "TLG1105": {"works": ["001"], "name": "Timaeus Praxidas Astrol."},
    "TLG2084": {"works": ["001"], "name": "Basilius Med. et Scr. Eccl."},
    "TLG1141": {"works": ["001", "002"], "name": "Antimachus Epic."},
    "TLG2652": {"works": ["001"], "name": "Diodorus Eleg."},
    "TLG0262": {"works": ["001"], "name": "Socrates Phil."},
    "TLG0303": {"works": ["001"], "name": "Phrynichus Trag."},
    "TLG0695": {"works": ["003"], "name": "Alcimus Hist."},
    "TLG2334": {"works": ["001", "002"], "name": "Nausiphanes Phil."},
    "TLG1976": {"works": ["003"], "name": "Metrodorus Hist."},
    "TLG0438": {"works": ["001", "002"], "name": "Damoxenus Comic."},
    "TLG2014": {"works": ["001"], "name": "Acta Phileae"},
    "TLG0420": {"works": ["001", "002"], "name": "Aristonymus Comic."},
    "TLG0608": {"works": ["001", "002"], "name": "Satyrus Biogr."},
    "TLG0198": {"works": ["001", "002"], "name": "Hedylus Epigr."},
    "TLG0383": {"works": ["001", "002", "003"], "name": "Alcaeus Lyr."},
    "TLG0621": {"works": ["001"], "name": "[Ath]enodorus Trag."},
    "TLG1972": {"works": ["002"], "name": "Eumachus Hist."},
    "TLG1562": {"works": ["001", "002"], "name": "Parmenides Poet. Phil."},
    "TLG1771": {"works": ["001"], "name": "Montanus et Montanistae Theol."},
    "TLG0574": {"works": ["002", "003"], "name": "Lysimachus Hist."},
    "TLG2175": {"works": ["002"], "name": "Autocharis Hist."},
    "TLG2466": {"works": ["003"], "name": "Dionysius Hist."},
    "TLG1292": {"works": ["001"], "name": "Crito Phil."},
    "TLG0297": {"works": ["001"], "name": "Lyrica Adespota (PMG)"},
    "TLG2565": {"works": ["002"], "name": "Mnesimachus Hist."},
    "TLG1251": {"works": ["001", "002"], "name": "Chamaeleon Phil."},
    "TLG4187": {"works": ["006", "008", "009"], "name": "Leo Magentinus Phil."},
    "TLG1369": {"works": ["001"], "name": "Evangelium Mariae"},
    "TLG2714": {
        "works": ["001", "002", "003"],
        "name": "Theodorus Studites Scr. Eccl. et Theol.",
    },
    "TLG0387": {"works": ["001", "002"], "name": "Sapphus vel Alcaei Fragmenta"},
    "TLG2119": {"works": ["001", "002", "003", "004"], "name": "Christodorus Epic."},
    "TLG1576": {"works": ["001"], "name": "Phaedimus Epic."},
    "TLG0876": {"works": ["001"], "name": "Phrynichus II Trag."},
    "TLG2612": {"works": ["001"], "name": "Caecalus (?) Epic."},
    "TLG2583": {"works": ["001"], "name": "Manetho Astrol."},
    "TLG1323": {"works": ["001"], "name": "Aelius Dionysius Attic."},
    "TLG2602": {"works": ["001"], "name": "Timaeus Sophista Gramm."},
    "TLG1503": {"works": ["002"], "name": "Menecrates Hist."},
    "TLG2556": {"works": ["002"], "name": "[Alexarchus] Hist."},
    "TLG0638": {
        "works": ["001", "003", "004", "005", "006", "007", "009"],
        "name": "Flavius Philostratus Soph.",
    },
    "TLG2117": {"works": ["001"], "name": "Anonymus De Metrorum Ratione"},
    "TLG2314": {"works": ["001"], "name": "Diogenes Phil."},
    "TLG1357": {"works": ["001"], "name": "Eudemus Phil."},
    "TLG2724": {"works": ["003"], "name": "Ammonius Scr. Eccl."},
    "TLG0308": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009"],
        "name": "Ion Phil. et Poeta",
    },
    "TLG2042": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "084",
            "086",
        ],
        "name": "Origenes Theol.",
    },
    "TLG0586": {"works": ["001", "002"], "name": "Polemon Perieg."},
    "TLG1373": {"works": ["001"], "name": "Evangelium Philippi"},
    "TLG3018": {"works": ["001"], "name": "Georgius Cedrenus Chronogr."},
    "TLG0432": {"works": ["001", "002"], "name": "Clearchus Comic."},
    "TLG0051": {"works": ["001"], "name": "Melissa Phil."},
    "TLG1291": {"works": ["002"], "name": "Creophylus Hist."},
    "TLG0583": {"works": ["001", "002", "003"], "name": "Philochorus Hist."},
    "TLG1222": {"works": ["003"], "name": "Beros(s)us Astrol. et Hist."},
    "TLG0414": {"works": ["001", "002", "003", "004"], "name": "Apollophanes Comic."},
    "TLG4171": {"works": ["001"], "name": "Anonymi In Oppiani Opera"},
    "TLG1693": {"works": ["001"], "name": "Sphaerus Phil."},
    "TLG1409": {"works": ["001"], "name": "Heraclides Ponticus Phil."},
    "TLG0351": {"works": ["001"], "name": "[Hippothoon] Trag."},
    "TLG0276": {"works": ["001"], "name": "Cantus Lugubris"},
    "TLG2797": {
        "works": [
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
        ],
        "name": "Hesychius Scr. Eccl.",
    },
    "TLG2458": {"works": ["002"], "name": "Marcellus Hist."},
    "TLG1867": {"works": ["003"], "name": "Crito Hist."},
    "TLG1606": {"works": ["001"], "name": "Phoenix Iamb."},
    "TLG1868": {"works": ["003"], "name": "Damastes Hist."},
    "TLG0649": {"works": ["001", "002", "003"], "name": "Lesbonax Rhet."},
    "TLG2018": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
        ],
        "name": "Eusebius Scr. Eccl. et Theol.",
    },
    "TLG1420": {"works": ["001"], "name": "Hermias Iamb."},
    "TLG1438": {"works": ["003"], "name": "Hippys Hist."},
    "TLG0716": {"works": ["001", "002"], "name": "Erotianus Gramm. et Med."},
    "TLG0082": {
        "works": ["001", "002", "003", "004"],
        "name": "Apollonius Dyscolus Gramm.",
    },
    "TLG1484": {"works": ["001"], "name": "Martyrium Polycarpi"},
    "TLG1388": {"works": ["002"], "name": "Harmodius Hist."},
    "TLG0125": {"works": ["001"], "name": "Zenonis Epistula"},
    "TLG4117": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
        ],
        "name": "Eustathius Scr. Eccl. et Theol.",
    },
    "TLG1526": {"works": ["001"], "name": "Neoptolemus Gramm."},
    "TLG0713": {"works": ["001", "002"], "name": "Anaxagoras Phil."},
    "TLG2586": {"works": ["001", "002"], "name": "Menander Rhet."},
    "TLG1152": {"works": ["003", "004", "005"], "name": "Apion Gramm."},
    "TLG1786": {"works": ["001"], "name": "Sogenes Comic."},
    "TLG0731": {"works": ["001", "002", "003"], "name": "Adamantius Judaeus Med."},
    "TLG5039": {"works": ["001"], "name": "Scholia In Thucydidem"},
    "TLG0510": {"works": ["001", "002", "003"], "name": "Teleclides Comic."},
    "TLG2273": {"works": ["002"], "name": "Damon Hist."},
    "TLG2009": {"works": ["001"], "name": "Martyrium Marini"},
    "TLG1680": {"works": ["001"], "name": "Sodamus Eleg."},
    "TLG0448": {"works": ["001", "002"], "name": "Dromo Comic."},
    "TLG1293": {"works": ["001"], "name": "Crinis Phil."},
    "TLG4082": {"works": ["001"], "name": "Musaeus Grammaticus Epic."},
    "TLG1832": {"works": ["001", "002"], "name": "Acesander Hist."},
    "TLG2157": {"works": ["003"], "name": "Magnus Hist."},
    "TLG2600": {"works": ["001", "002"], "name": "Simon Scriptor De Re Equestri"},
    "TLG0889": {"works": ["001"], "name": "Timesitheus Trag."},
    "TLG1306": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Bolus Med. et Phil.",
    },
    "TLG1213": {"works": ["001"], "name": "Julia Balbilla Lyr."},
    "TLG0043": {"works": ["001"], "name": "Amasis Epistulae"},
    "TLG1723": {"works": ["001"], "name": "Theolytus Epic."},
    "TLG7051": {"works": ["001"], "name": "Doctrina Patrum"},
    "TLG2203": {"works": ["002"], "name": "[Theophilus] Hist."},
    "TLG1304": {"works": ["001", "002"], "name": "Democritus Phil."},
    "TLG0088": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Aristoxenus Mus.",
    },
    "TLG1709": {"works": ["003"], "name": "Theagenes Hist."},
    "TLG2816": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Joannes Gramm. et Theol.",
    },
    "TLG0656": {
        "works": ["001", "002", "003", "004"],
        "name": "Dioscorides Pedanius Med.",
    },
    "TLG1568": {"works": ["002"], "name": "Parthax Hist."},
    "TLG0361": {"works": ["001"], "name": "Cleonides Mus."},
    "TLG2580": {
        "works": ["001", "002", "003"],
        "name": "Joannes Laurentius Lydus Hist.",
    },
    "TLG1688": {"works": ["001", "002"], "name": "Sostratus Gramm."},
    "TLG1534": {"works": ["002"], "name": "Nicocles Hist."},
    "TLG1308": {"works": ["001", "003"], "name": "Demosthenes Epic."},
    "TLG0611": {"works": ["001"], "name": "Theodorus Trag."},
    "TLG4086": {"works": ["001", "002"], "name": "[Agathodaemon] Alchem."},
    "TLG1664": {"works": ["001"], "name": "Seniores Alexandrini Scr. Eccl."},
    "TLG1162": {"works": ["002"], "name": "Apollas Hist."},
    "TLG5048": {"works": ["001"], "name": "Scholia In Clementem Alexandrinum"},
    "TLG0423": {"works": ["001", "002", "003"], "name": "Autocrates Comic."},
    "TLG0724": {
        "works": ["001", "002", "003", "004"],
        "name": "Stephanus Med. et Phil.",
    },
    "TLG0419": {"works": ["001", "002", "003"], "name": "Aristomenes Comic."},
    "TLG4327": {"works": ["001"], "name": "Joannes Archiereus Alchem."},
    "TLG0382": {"works": ["001", "002"], "name": "Castorion Lyr."},
    "TLG1571": {"works": ["001"], "name": "Pempelus Phil."},
    "TLG0487": {
        "works": ["001", "002", "003", "004", "006", "007", "008", "009"],
        "name": "Philemon Comic.",
    },
    "TLG1819": {"works": ["001"], "name": "Pseudo-Demosthenes Epigr."},
    "TLG0572": {"works": ["001"], "name": "Gaius Scr. Eccl."},
    "TLG2967": {
        "works": ["001"],
        "name": "Theodorus Heracleensis vel Theodorus Mopsuestenus Scr. Eccl.",
    },
    "TLG0598": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "007",
            "008",
            "009",
            "010",
            "011",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
        ],
        "name": "Rhetorica Anonyma",
    },
    "TLG1617": {"works": ["001", "002"], "name": "Marcus Antonius Polemon Soph."},
    "TLG1493": {"works": ["001"], "name": "Melinno Lyr."},
    "TLG0627": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
        ],
        "name": "Hippocrates Med. et Corpus Hippocraticum",
    },
    "TLG1179": {"works": ["001"], "name": "Arimnestus Phil."},
    "TLG1667": {
        "works": ["001", "002", "004", "005", "006"],
        "name": "Septem Sapientes Phil.",
    },
    "TLG1156": {"works": ["001"], "name": "Apocalypsis Eliae"},
    "TLG1381": {
        "works": ["001"],
        "name": "Fragmentum Synodicae Epistulae Concilii Caesariensis",
    },
    "TLG1772": {"works": ["001"], "name": "Paraleipomena Jeremiou"},
    "TLG0015": {"works": ["001"], "name": "Herodianus Hist."},
    "TLG1523": {"works": ["003"], "name": "Myron Hist."},
    "TLG1341": {"works": ["001", "002"], "name": "Ecphantus Phil."},
    "TLG0607": {"works": ["001"], "name": "Aelius Theon Rhet."},
    "TLG1595": {"works": ["107"], "name": "Philodemus Phil."},
    "TLG2969": {"works": ["001"], "name": "Demonax Phil."},
    "TLG0493": {"works": ["001", "002"], "name": "Philostephanus Comic."},
    "TLG1464": {"works": ["001"], "name": "Liber Jubilaeorum"},
    "TLG0603": {"works": ["001"], "name": "Silenus Trag."},
    "TLG2619": {"works": ["001"], "name": "Dionysius Epic."},
    "TLG0544": {"works": ["001", "002"], "name": "Sextus Empiricus Phil."},
    "TLG0293": {"works": ["001", "002"], "name": "Ibycus Lyr."},
    "TLG1813": {"works": ["001"], "name": "Anonymus De Plantis Aegyptiis"},
    "TLG2003": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
        ],
        "name": "Flavius Claudius Julianus Imperator Phil., Julian the Apostate",
    },
    "TLG1249": {"works": ["003"], "name": "Cephalion Hist. et Rhet."},
    "TLG5034": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Scholia In Pindarum",
    },
    "TLG1508": {"works": ["001", "002", "003"], "name": "Metrodorus Phil."},
    "TLG1626": {"works": ["001"], "name": "Polycrates Scr. Eccl."},
    "TLG2601": {"works": ["001"], "name": "Tiberius Rhet."},
    "TLG0671": {"works": ["001"], "name": "Philumenus Med."},
    "TLG0723": {"works": ["001", "002"], "name": "Leo Phil."},
    "TLG0240": {"works": ["001"], "name": "Hermolochus Lyr."},
    "TLG4238": {"works": ["001"], "name": "Athanasius Soph."},
    "TLG4102": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
        ],
        "name": "Catenae (Novum Testamentum)",
    },
    "TLG0470": {"works": ["001", "002", "003"], "name": "Leuco Comic."},
    "TLG1406": {"works": ["003"], "name": "Heraclides Hist."},
    "TLG1466": {"works": ["001", "002", "003"], "name": "Lollianus Scr. Erot."},
    "TLG1471": {"works": ["001"], "name": "Lyrica Adespota (SLG)"},
    "TLG2219": {"works": ["003"], "name": "Amelesagoras Hist."},
    "TLG1648": {"works": ["002"], "name": "Pyrgion Hist."},
    "TLG3094": {
        "works": ["001"],
        "name": "Nicetas Choniates Hist., Scr. Eccl. et Rhet.",
    },
    "TLG1875": {"works": ["002"], "name": "Aristodemus Hist. et Myth."},
    "TLG0449": {"works": ["001", "002", "003"], "name": "Ecphantides Comic."},
    "TLG1545": {"works": ["001", "002", "003"], "name": "Ocellus Phil."},
    "TLG0676": {"works": ["001", "002"], "name": "Aglaïs Poet. Med."},
    "TLG2227": {"works": ["001"], "name": "Paron Phil."},
    "TLG0036": {"works": ["001", "002", "003"], "name": "Bion Bucol."},
    "TLG4288": {"works": ["001"], "name": "Lexicon αἱμωδεῖν"},
    "TLG4091": {"works": ["001"], "name": "Callistratus Soph."},
    "TLG1912": {"works": ["004"], "name": "Euphantus Phil."},
    "TLG2160": {"works": ["002"], "name": "Pyrrhus Hist."},
    "TLG0377": {"works": ["001", "002"], "name": "Telestes Lyr."},
    "TLG0736": {"works": ["001"], "name": "Stephanus Med."},
    "TLG2033": {"works": ["001", "002", "006", "007", "009"], "name": "Theon Math."},
    "TLG0430": {"works": ["001", "002"], "name": "Chariclides Comic."},
    "TLG1431": {"works": ["002", "003"], "name": "Hipparchus Astron. et Geogr."},
    "TLG1310": {"works": ["002", "003"], "name": "Dictys Hist."},
    "TLG0095": {"works": ["001", "002"], "name": "Hermodorus Phil."},
    "TLG2681": {"works": ["001"], "name": "Diodorus Phil."},
    "TLG2631": {"works": ["001"], "name": "Menophilus Poeta"},
    "TLG2460": {"works": ["002"], "name": "Glaucus Hist."},
    "TLG0042": {"works": ["001"], "name": "Alexandri Magni Epistulae"},
    "TLG2011": {
        "works": ["001"],
        "name": "Martyrium Agapae, Irenae, Chionae Et Sodalium",
    },
    "TLG1204": {"works": ["001"], "name": "Athenaeus Mech."},
    "TLG1437": {"works": ["001", "002"], "name": "Hippon Phil."},
    "TLG1541": {"works": ["001"], "name": "Nostoi"},
    "TLG0519": {"works": ["001", "002"], "name": "Xeno Comic."},
    "TLG1322": {"works": ["001"], "name": "Diogenianus Phil."},
    "TLG0698": {"works": ["002"], "name": "Alexander Rhet."},
    "TLG1580": {"works": ["001", "003"], "name": "Phaestus Epic."},
    "TLG2639": {"works": ["001"], "name": "Posidonius Epic."},
    "TLG1425": {"works": ["001"], "name": "Hermonax Epic."},
    "TLG0219": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Rhianus Epic.",
    },
    "TLG0558": {"works": ["001", "002", "003", "004", "005"], "name": "Hellenica"},
    "TLG2613": {"works": ["001"], "name": "Callimachus Junior Epic."},
    "TLG1343": {"works": ["002"], "name": "Eparchides Hist."},
    "TLG2041": {"works": ["001", "004", "005"], "name": "Marcellus Theol."},
    "TLG4003": {"works": ["001", "002", "003"], "name": "Marcianus Geogr."},
    "TLG1637": {"works": ["001"], "name": "Protevangelium Jacobi"},
    "TLG0395": {"works": ["001", "002"], "name": "Diophantus Comic."},
    "TLG0292": {"works": ["001", "002"], "name": "Stesichorus Lyr."},
    "TLG0742": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
        ],
        "name": "Hymni Anonymi",
    },
    "TLG0252": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Hermippus Comic.",
    },
    "TLG2232": {"works": ["001", "002"], "name": "Damon Mus."},
    "TLG2218": {"works": ["001"], "name": "Calliphon et Democedes Med. et Phil."},
    "TLG0409": {"works": ["001", "002"], "name": "Antidotus Comic."},
    "TLG0744": {"works": ["001", "002", "003", "004", "005"], "name": "Alexander Med."},
    "TLG0476": {"works": ["001", "002"], "name": "Mnesimachus Comic."},
    "TLG1602": {"works": ["001"], "name": "Philoxenus Gramm."},
    "TLG1746": {"works": ["001"], "name": "Valentinus Gnost."},
    "TLG0020": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Hesiodus Epic.",
    },
    "TLG2546": {"works": ["003"], "name": "Publius Rutilius Rufus Hist."},
    "TLG4319": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
        ],
        "name": "Zosimus Alchem.",
    },
    "TLG1611": {"works": ["001"], "name": "Tyrannion Junior Gramm."},
    "TLG2212": {"works": ["002"], "name": "Lyceas Hist."},
    "TLG3170": {"works": ["001"], "name": "Ephraem Hist. et Poeta"},
    "TLG0041": {"works": ["001"], "name": "Chionis Epistulae"},
    "TLG2346": {"works": ["002"], "name": "Andriscus Hist."},
    "TLG3144": {"works": ["001"], "name": "Joannes Cananus Hist."},
    "TLG2742": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Apophthegmata",
    },
    "TLG0542": {"works": ["001"], "name": "Julius Pollux Gramm."},
    "TLG0686": {"works": ["003"], "name": "Aethlius Hist."},
    "TLG0612": {"works": ["001", "002", "003"], "name": "Dio Chrysostomus Soph."},
    "TLG1303": {"works": ["003"], "name": "Demochares Hist. et Orat."},
    "TLG0089": {"works": ["001"], "name": "Praxiphanes Phil."},
    "TLG0079": {"works": ["002"], "name": "Menippus Geogr."},
    "TLG0221": {"works": ["001", "002", "004"], "name": "Euphorion Epic."},
    "TLG2618": {"works": ["001"], "name": "Didymarchus Poeta"},
    "TLG2559": {"works": ["002"], "name": "[Chrysippus] Hist."},
    "TLG0622": {"works": ["001"], "name": "Cleobuli Epistula"},
    "TLG3064": {"works": ["002"], "name": "Scylitzes Continuatus"},
    "TLG4292": {"works": ["001", "002"], "name": "Lexicon De Atticis Nominibus"},
    "TLG0335": {"works": ["001"], "name": "Philiscus Trag."},
    "TLG1427": {"works": ["003"], "name": "Herodorus Hist."},
    "TLG1223": {"works": ["001", "002"], "name": "Bias Phil."},
    "TLG0039": {"works": ["001"], "name": "Mithridatis Epistula"},
    "TLG4339": {"works": ["001"], "name": "Archelaus Alchem. et Poeta"},
    "TLG0766": {"works": ["001", "002"], "name": "Alcmaeon Phil."},
    "TLG2695": {"works": ["001", "002"], "name": "Vitae Aristotelis"},
    "TLG0320": {"works": ["001"], "name": "Diogenes Trag."},
    "TLG2966": {"works": ["002"], "name": "Phileas Scr. Eccl."},
    "TLG2037": {"works": ["001"], "name": "Joannes Stobaeus Anthologus"},
    "TLG1183": {"works": ["001"], "name": "Aristeae Epistula"},
    "TLG1224": {"works": ["001", "002"], "name": "Bion Phil."},
    "TLG0222": {
        "works": ["001", "009", "010", "013", "015"],
        "name": "Eratosthenes et Eratosthenica Philol.",
    },
    "TLG2286": {"works": ["001"], "name": "Cercops Phil."},
    "TLG0363": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "014",
        ],
        "name": "Claudius Ptolemaeus Math.",
    },
    "TLG0249": {"works": ["001"], "name": "Echembrotus Eleg. et Lyr."},
    "TLG1521": {"works": ["001", "002"], "name": "Vita Et Sententiae Secundi"},
    "TLG1639": {"works": ["001"], "name": "Pseudo-Auctores Hellenistae (PsVTGr)"},
    "TLG0131": {"works": ["001", "002"], "name": "Archimelus Epigr."},
    "TLG2525": {"works": ["003"], "name": "Laetus Hist."},
    "TLG0720": {"works": ["001"], "name": "Harmodius Trag."},
    "TLG1383": {"works": ["001", "002", "005"], "name": "Geminus Astron."},
    "TLG0534": {"works": ["001", "002", "003"], "name": "Callisthenes Hist."},
    "TLG1542": {"works": ["001"], "name": "Numenius Phil."},
    "TLG0450": {"works": ["001", "002", "003"], "name": "Ephippus Comic."},
    "TLG1636": {"works": ["003"], "name": "Protagorides Hist."},
    "TLG0279": {"works": ["001"], "name": "Discipulorum Cantiuncula"},
    "TLG0202": {"works": ["001"], "name": "Mace(donius) Lyr."},
    "TLG1682": {"works": ["001"], "name": "Sopater Comic."},
    "TLG0081": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
        ],
        "name": "Dionysius Halicarnassensis Hist. et Rhet.",
    },
    "TLG3128": {"works": ["001"], "name": "Theognostus Gramm."},
    "TLG1188": {"works": ["001"], "name": "Aristocles Phil."},
    "TLG0302": {"works": ["001"], "name": "Choerilus Trag."},
    "TLG2038": {"works": ["001", "002", "003", "004", "005"], "name": "Acta Thomae"},
    "TLG2766": {"works": ["001", "002"], "name": "Eudocia Augusta Poeta"},
    "TLG2610": {"works": ["001"], "name": "Boiscus Iamb."},
    "TLG0256": {"works": ["001"], "name": "Panarces Scriptor Aenigmatum"},
    "TLG1792": {"works": ["001"], "name": "Biottus Comic."},
    "TLG1923": {"works": ["003"], "name": "Stesimbrotus Hist."},
    "TLG1570": {"works": ["001"], "name": "Epitaphium Pectorii"},
    "TLG0667": {"works": ["001"], "name": "Marcellinus I Med."},
    "TLG0306": {"works": ["001"], "name": "Aristarchus Trag."},
    "TLG1364": {"works": ["001"], "name": "Evangelium Aegyptium"},
    "TLG1395": {"works": ["004"], "name": "[Hegesinus] Epic."},
    "TLG0046": {"works": ["001"], "name": "Niciae Epistula"},
    "TLG0462": {"works": ["001", "002"], "name": "Euthycles Comic."},
    "TLG2012": {"works": ["001"], "name": "Acta Eupli"},
    "TLG0429": {"works": ["001", "002"], "name": "Cephisodorus Comic."},
    "TLG1978": {"works": ["003"], "name": "Leo Hist."},
    "TLG1347": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Epimenides Phil.",
    },
    "TLG4016": {"works": ["001", "002", "003", "004", "005"], "name": "Ammonius Phil."},
    "TLG1661": {"works": ["001"], "name": "Satyrus Hist."},
    "TLG4335": {"works": ["001"], "name": "Cleopatra Alchem."},
    "TLG0718": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "011",
            "012",
            "013",
            "015",
            "016",
        ],
        "name": "Aëtius Med.",
    },
    "TLG4324": {"works": ["001"], "name": "Synesius Alchem."},
    "TLG0495": {"works": ["001", "002", "003"], "name": "Phoenicides Comic."},
    "TLG1970": {"works": ["003"], "name": "Silenus Hist."},
    "TLG1766": {"works": ["001", "002"], "name": "Tatianus Apol."},
    "TLG0633": {"works": ["001", "002"], "name": "Lysis Phil."},
    "TLG2445": {"works": ["003"], "name": "Amometus Hist."},
    "TLG1992": {"works": ["003"], "name": "Ariston Apol."},
    "TLG1836": {"works": ["001"], "name": "Anonymi Aulodia"},
    "TLG1436": {"works": ["001", "002"], "name": "Hippodamus Phil."},
    "TLG1139": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
        ],
        "name": "Anonymi Historici (FGrH)",
    },
    "TLG4029": {"works": ["001", "002", "003"], "name": "Procopius Hist."},
    "TLG0380": {"works": ["001", "002"], "name": "Philoxenus Lyr."},
    "TLG0491": {"works": ["001", "002", "003"], "name": "Philiscus Comic."},
    "TLG0483": {"works": ["001", "002"], "name": "Nicophon Comic."},
    "TLG0468": {"works": ["001", "002"], "name": "Hipparchus Comic."},
    "TLG2287": {"works": ["001"], "name": "Fragmentum Stoicum"},
    "TLG2158": {"works": ["002"], "name": "Eutychianus Hist."},
    "TLG2734": {
        "works": [
            "001",
            "004",
            "005",
            "008",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
        ],
        "name": "Flavius Justinianus Imperator Theol.",
    },
    "TLG1757": {"works": ["001"], "name": "Julius Epic."},
    "TLG0697": {"works": ["003"], "name": "Cornelius Alexander Polyhist."},
    "TLG1447": {
        "works": ["001", "002", "003", "004", "005", "007", "008"],
        "name": "Irenaeus Theol.",
    },
    "TLG4124": {"works": ["007", "008", "009"], "name": "Eusebius Scr. Eccl."},
    "TLG1635": {"works": ["001", "002", "003"], "name": "Protagoras Soph."},
    "TLG0345": {"works": ["001"], "name": "Apollonides Trag."},
    "TLG1428": {"works": ["002"], "name": "Hestiaeus Hist."},
    "TLG1277": {"works": ["001", "002"], "name": "Clinias Phil."},
    "TLG4005": {"works": ["001"], "name": "Anonymus Discipulus Isidori Milesii Mech."},
    "TLG9019": {"works": ["001"], "name": "Stephanus Phil."},
    "TLG0683": {"works": ["002"], "name": "Aethiopis"},
    "TLG0290": {"works": ["001"], "name": "Encomium Ducis Thebaidos"},
    "TLG3136": {"works": ["001"], "name": "Pseudo-Zonaras Lexicogr."},
    "TLG2568": {"works": ["002"], "name": "[Sosthenes] Hist."},
    "TLG0266": {"works": ["001", "002"], "name": "Tyrtaeus Eleg."},
    "TLG4000": {"works": ["001"], "name": "Aristaenetus Epist."},
    "TLG0060": {"works": ["001", "002", "003"], "name": "Diodorus Siculus Hist."},
    "TLG1899": {"works": ["002"], "name": "Aristonicus Hist."},
    "TLG3075": {"works": ["001"], "name": "Pseudo-Mauricius Tact."},
    "TLG1302": {"works": ["001", "002"], "name": "Demetrius Rhet."},
    "TLG2608": {"works": ["001"], "name": "Archebulus Poeta"},
    "TLG0068": {"works": ["001", "002"], "name": "Pseudo-Scymnus Geogr."},
    "TLG0269": {"works": ["001", "002"], "name": "Nautarum Cantiunculae"},
    "TLG1556": {"works": ["001", "002"], "name": "Pancrates Epigr."},
    "TLG0591": {"works": ["001", "002"], "name": "Antisthenes Phil. et Rhet."},
    "TLG0452": {"works": ["001", "002"], "name": "Epigenes Comic."},
    "TLG4145": {"works": ["001"], "name": "Nicephorus Gregoras Hist."},
    "TLG0816": {"works": ["001"], "name": "Theudo[tus] Trag."},
    "TLG1096": {"works": ["001"], "name": "Euaretus Trag."},
    "TLG5045": {"works": ["001", "002"], "name": "Anonymi In Aphthonium Rhet."},
    "TLG0658": {"works": ["001", "002"], "name": "Heliodorus Scr. Erot."},
    "TLG1695": {"works": ["001"], "name": "Sthenidas Phil."},
    "TLG1351": {"works": ["001"], "name": "Epigoni"},
    "TLG1405": {"works": ["001"], "name": "Heraclides Criticus Perieg."},
    "TLG0628": {
        "works": ["001", "002", "003", "004"],
        "name": "Gaius Musonius Rufus Phil.",
    },
    "TLG1516": {"works": ["003"], "name": "Molpis Hist."},
    "TLG1622": {"works": ["001"], "name": "Polycarpus Scr. Eccl."},
    "TLG2762": {
        "works": ["004", "005", "006", "007", "008", "009"],
        "name": "Gennadius I Scr. Eccl.",
    },
    "TLG0250": {"works": ["001"], "name": "Euclides Comic. vel Iamb."},
    "TLG1859": {"works": ["001"], "name": "Liber Jannes Et Jambres"},
    "TLG1435": {"works": ["002"], "name": "Hippias Hist."},
    "TLG2552": {"works": ["002"], "name": "Critolaus Hist."},
    "TLG0654": {"works": ["002"], "name": "Lucius Annaeus Cornutus Phil."},
    "TLG0636": {"works": ["001"], "name": "Socratis Epistulae"},
    "TLG1662": {"works": ["001"], "name": "Sciras Comic."},
    "TLG2506": {"works": ["003"], "name": "Capito Hist."},
    "TLG1548": {"works": ["001"], "name": "Oenomaus Phil."},
    "TLG0307": {"works": ["001"], "name": "Neophron Trag."},
    "TLG0011": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009", "010"],
        "name": "Sophocles Trag.",
    },
    "TLG2733": {"works": ["001"], "name": "Evagrius Scholasticus Scr. Eccl."},
    "TLG1615": {"works": ["001"], "name": "Platonius Gramm."},
    "TLG2340": {"works": ["001"], "name": "Diotimus Phil."},
    "TLG0435": {"works": ["001", "002"], "name": "Cratinus Junior Comic."},
    "TLG0273": {"works": ["001", "002"], "name": "Scolia Alphabetica"},
    "TLG1574": {"works": ["001"], "name": "Persaeus Phil."},
    "TLG0399": {"works": ["001", "002"], "name": "Eudoxus Comic."},
    "TLG2744": {"works": ["001"], "name": "Historia Monachorum In Aegypto"},
    "TLG0412": {
        "works": ["001", "002"],
        "name": "Apollodorus Carystius vel Apollodorus Gelous Comic.",
    },
    "TLG1459": {"works": ["002"], "name": "Lepidus Hist."},
    "TLG1318": {"works": ["001"], "name": "Diodorus Rhet."},
    "TLG1477": {"works": ["003"], "name": "Manetho Hist."},
    "TLG0251": {"works": ["001"], "name": "Euenus Eleg."},
    "TLG0431": {"works": ["001", "002", "003"], "name": "Chionides Comic."},
    "TLG0254": {"works": ["001", "002"], "name": "Melanthius Eleg. et Trag."},
    "TLG0691": {"works": ["001"], "name": "Harpocrationis Epistula"},
    "TLG0845": {"works": ["001", "002", "003"], "name": "Ctesias Hist. et Med."},
    "TLG2650": {"works": ["001"], "name": "Arrianus Epic."},
    "TLG1275": {"works": ["001", "002", "003"], "name": "Cleostratus Poet. Phil."},
    "TLG0577": {"works": ["003"], "name": "Nicolaus Hist."},
    "TLG0481": {"works": ["001", "002"], "name": "Nicolaus Comic."},
    "TLG2697": {"works": ["001"], "name": "Timolaus Rhet."},
    "TLG0733": {"works": ["001"], "name": "Cassius Iatrosophista Med."},
    "TLG1296": {"works": ["001"], "name": "Cypria"},
    "TLG1125": {"works": ["003"], "name": "Androtion Hist."},
    "TLG2190": {"works": ["002"], "name": "[Clitonymus] Hist."},
    "TLG1389": {"works": ["001"], "name": "Harpocration Gramm."},
    "TLG1201": {"works": ["001"], "name": "Assumptio Mosis"},
    "TLG5018": {"works": ["001"], "name": "Scholia In Dionysium Byzantium"},
    "TLG0388": {"works": ["001", "002", "003", "004", "005"], "name": "Acta Pauli"},
    "TLG2721": {
        "works": ["001", "002"],
        "name": "Theodorus Prodromus Poeta et Polyhist.",
    },
    "TLG1138": {"works": ["001"], "name": "Lycon Phil."},
    "TLG1685": {"works": ["003", "004"], "name": "Sosibius Gramm."},
    "TLG0660": {"works": ["001"], "name": "Apollonius Med."},
    "TLG2300": {"works": ["003", "004"], "name": "Promathidas Hist."},
    "TLG1906": {"works": ["002"], "name": "Simonides Epic."},
    "TLG2057": {"works": ["001"], "name": "Socrates Scholasticus Hist."},
    "TLG1172": {"works": ["001"], "name": "Arcesilaus Phil."},
    "TLG0260": {"works": ["001", "002"], "name": "Semonides Eleg. et Iamb."},
    "TLG0639": {"works": ["001"], "name": "Menecrates Med."},
    "TLG1131": {
        "works": ["001"],
        "name": "Anonymus Ad Avircium Marcellum Contra Cataphrygas",
    },
    "TLG0291": {"works": ["001", "002"], "name": "Alcman Lyr."},
    "TLG2645": {"works": ["001"], "name": "Stratonicus Poeta"},
    "TLG1350": {"works": ["001"], "name": "Epistula Ad Diognetum"},
    "TLG1227": {"works": ["001"], "name": "Blaesus Comic."},
    "TLG1726": {"works": ["001", "002"], "name": "Theopompus Epic."},
    "TLG0746": {
        "works": ["001"],
        "name": "Theophilus Protospatharius et Stephanus Atheniensis Med.",
    },
    "TLG0328": {"works": ["001"], "name": "Chaeremon Trag."},
    "TLG0640": {"works": ["001"], "name": "Alciphron Rhet. et Soph."},
    "TLG0690": {"works": ["001"], "name": "Erasistratus Med."},
    "TLG0717": {"works": ["001", "002"], "name": "Hypsicles Astron. et Math."},
    "TLG4338": {"works": ["001"], "name": "Theophrastus Alchem. et Poeta"},
    "TLG0403": {"works": ["001", "002", "003", "004"], "name": "Amipsias Comic."},
    "TLG3187": {"works": ["001"], "name": "Georgius Gramm."},
    "TLG4013": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Simplicius Phil.",
    },
    "TLG2243": {"works": ["001"], "name": "Apocalypsis Sedrach"},
    "TLG1527": {"works": ["001"], "name": "Nepualius Med. et Phil."},
    "TLG0637": {"works": ["001"], "name": "Socraticorum Epistulae"},
    "TLG0407": {"works": ["001", "002"], "name": "Anaxippus Comic."},
    "TLG2248": {"works": ["001"], "name": "Acta Xanthippae Et Polyxenae"},
    "TLG1173": {"works": ["001"], "name": "Archedemus Phil."},
    "TLG3140": {"works": ["001"], "name": "Joel Chronogr."},
    "TLG0428": {"works": ["001", "002", "003", "004"], "name": "Cantharus Comic."},
    "TLG2367": {"works": ["002"], "name": "Theognis Hist."},
    "TLG1320": {"works": ["001"], "name": "Diogenes Phil."},
    "TLG1393": {"works": ["001", "004", "005"], "name": "Hegesianax Astron. et Epic."},
    "TLG1535": {"works": ["002"], "name": "Nicocrates Hist."},
    "TLG0295": {"works": ["001"], "name": "Carmina Popularia (PMG)"},
    "TLG1953": {"works": ["003"], "name": "Hieronymus Hist."},
    "TLG0602": {"works": ["001", "002"], "name": "Comica Adespota (FCG)"},
    "TLG1683": {"works": ["003"], "name": "Sophaenetus Hist."},
    "TLG0253": {"works": ["001"], "name": "[Homerus] Epic."},
    "TLG3130": {
        "works": ["001", "003", "007", "009"],
        "name": "Theophylactus Simocatta Epist. et Hist.",
    },
    "TLG2040": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "078",
            "079",
            "080",
            "081",
            "082",
        ],
        "name": "Basilius Theol.",
    },
    "TLG2456": {"works": ["001", "002"], "name": "Nessas Phil."},
    "TLG1147": {"works": ["001", "002", "003", "005"], "name": "Antiphon Soph."},
    "TLG0077": {"works": ["001"], "name": "Periplus Maris Magni"},
    "TLG0093": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "014",
            "015",
        ],
        "name": "Theophrastus Phil.",
    },
    "TLG0730": {"works": ["001", "002"], "name": "Meletius Med."},
    "TLG0259": {"works": ["001", "002", "004"], "name": "Scythinus Poet. Phil."},
    "TLG0485": {"works": ["001", "002"], "name": "Ophelio Comic."},
    "TLG1918": {"works": ["003"], "name": "Timagenes Hist."},
    "TLG0626": {"works": ["001", "002"], "name": "Heraclitus Phil."},
    "TLG0085": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
        ],
        "name": "Aeschylus Trag.",
    },
    "TLG2611": {"works": ["001"], "name": "Butas Eleg."},
    "TLG4076": {
        "works": ["003", "004", "005", "006"],
        "name": "Menander Protector Hist.",
    },
    "TLG4075": {"works": ["002"], "name": "Marinus Phil."},
    "TLG0522": {"works": ["001"], "name": "Pisander Epic."},
    "TLG0442": {"works": ["001", "002"], "name": "Dexicrates Comic."},
    "TLG1487": {"works": ["001", "002"], "name": "Maximus Astrol."},
    "TLG5025": {"works": ["001", "002", "003", "004"], "name": "Scholia In Hesiodum"},
    "TLG1208": {"works": ["001"], "name": "Atticus Phil."},
    "TLG2008": {"works": ["001"], "name": "Martyrium Cononis"},
    "TLG4150": {"works": ["001"], "name": "Anacreontea"},
    "TLG0700": {"works": ["001"], "name": "Apollodorus Trag."},
    "TLG1354": {"works": ["002"], "name": "Ergias Hist."},
    "TLG0213": {"works": ["001", "002", "003"], "name": "Hermesianax Eleg."},
    "TLG1835": {"works": ["002"], "name": "Agroetas Hist."},
    "TLG0443": {"works": ["001", "002", "003", "004"], "name": "Diocles Comic."},
    "TLG9021": {"works": ["001"], "name": "Stephanus Alchem."},
    "TLG4303": {
        "works": ["001", "002", "003", "004"],
        "name": "Lexica In Opera Gregorii Nazianzeni",
    },
    "TLG5013": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Scholia In Aratum",
    },
    "TLG1858": {"works": ["001"], "name": "Oratio Manassis"},
    "TLG9018": {"works": ["001"], "name": "Arsenius Paroemiogr."},
    "TLG9012": {"works": ["002"], "name": "Ignatius Biogr. et Poeta"},
    "TLG2120": {"works": ["001"], "name": "Panteleius Epic."},
    "TLG5024": {
        "works": [
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
        ],
        "name": "Anonymi In Hermogenem Rhet.",
    },
    "TLG1421": {"works": ["001", "003"], "name": "Hermippus Gramm. et Hist."},
    "TLG2738": {"works": ["002", "003", "004"], "name": "Chronographiae Anonymae"},
    "TLG1584": {"works": ["003"], "name": "Pherecydes Hist."},
    "TLG1226": {"works": ["001"], "name": "Biton Mech."},
    "TLG4115": {"works": ["029", "030"], "name": "Theophilus Scr. Eccl."},
    "TLG0245": {"works": ["001", "002"], "name": "Demodocus Eleg."},
    "TLG1514": {"works": ["001", "002"], "name": "Mnaseas Perieg."},
    "TLG0825": {"works": ["001"], "name": "Melito Trag."},
    "TLG0019": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
        ],
        "name": "Aristophanes Comic.",
    },
    "TLG4157": {"works": ["001"], "name": "Joannes Rhet."},
    "TLG2313": {"works": ["001"], "name": "Antisthenes Phil."},
    "TLG1399": {"works": ["001"], "name": "Pamphilus Trag."},
    "TLG0347": {"works": ["001"], "name": "Serapion Trag."},
    "TLG0235": {"works": ["001"], "name": "Iambica Adespota (IEG)"},
    "TLG1451": {"works": ["001"], "name": "Josephus Et Aseneth"},
    "TLG0595": {"works": ["001", "002"], "name": "Zeno Phil."},
    "TLG0673": {"works": ["001", "002"], "name": "Aeschines Socraticus Phil."},
    "TLG3177": {
        "works": ["001", "002"],
        "name": "Scriptor Incertus De Leone Armenio Hist.",
    },
    "TLG1206": {"works": ["003"], "name": "Athenodorus Phil."},
    "TLG4038": {"works": ["001"], "name": "Pamprepius Epic."},
    "TLG3043": {"works": ["001", "002"], "name": "Georgius Monachus Chronogr."},
    "TLG0027": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Andocides Orat.",
    },
    "TLG2557": {"works": ["002"], "name": "[Aristobulus] Hist."},
    "TLG4139": {
        "works": [
            "034",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "067",
            "072",
            "081",
            "087",
        ],
        "name": "Severianus Scr. Eccl.",
    },
    "TLG0401": {"works": ["001", "002"], "name": "Alexander Comic."},
    "TLG0312": {"works": ["001"], "name": "Philocles Trag."},
    "TLG3185": {"works": ["001"], "name": "Anonymus De Scientia Politica Hist."},
    "TLG4097": {"works": ["001", "002", "003"], "name": "Etymologicum Genuinum"},
    "TLG1175": {"works": ["001", "002"], "name": "Archestratus Parodius"},
    "TLG2270": {"works": ["002"], "name": "Callippus Hist."},
    "TLG0508": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Strattis Comic.",
    },
    "TLG0554": {"works": ["001"], "name": "Chariton Scr. Erot."},
    "TLG0647": {"works": ["001"], "name": "Triphiodorus Epic. et Gramm."},
    "TLG0048": {"works": ["001"], "name": "Philippus II Rex Macedonum Epist."},
    "TLG4135": {
        "works": ["009", "015", "016", "017", "018"],
        "name": "Theodorus Theol.",
    },
    "TLG0609": {"works": ["001", "002", "003"], "name": "Tryphon I Gramm."},
    "TLG0034": {"works": ["001", "002"], "name": "Lycurgus Orat."},
    "TLG1386": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "018",
            "019",
            "020",
        ],
        "name": "Historia Alexandri Magni",
    },
    "TLG0010": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
        ],
        "name": "Isocrates Orat.",
    },
    "TLG0461": {"works": ["001", "002", "003", "004", "005"], "name": "Eupolis Comic."},
    "TLG2074": {"works": ["037", "038", "039", "041"], "name": "Apollinaris Theol."},
    "TLG1578": {"works": ["001"], "name": "Phaenias Phil."},
    "TLG3063": {"works": ["001"], "name": "Joannes Scylitzes Hist."},
    "TLG0613": {"works": ["001"], "name": "Demetrius Rhet."},
    "TLG0366": {"works": ["001", "002"], "name": "Lasus Lyr."},
    "TLG0376": {"works": ["001", "002"], "name": "Timotheus Lyr."},
    "TLG2638": {"works": ["001"], "name": "Philo Poeta"},
    "TLG4328": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
        ],
        "name": "Philosophus Christianus Alchem.",
    },
    "TLG1445": {"works": ["001"], "name": "Iliu Persis"},
    "TLG4294": {"works": ["001"], "name": "Lexicon Vindobonense"},
    "TLG1794": {"works": ["001"], "name": "Philocles Comic."},
    "TLG4227": {"works": ["001"], "name": "Anonymus De Philosophia Platonica Phil."},
    "TLG1641": {"works": ["001"], "name": "Ptolemaeus Gnost."},
    "TLG1756": {"works": ["001"], "name": "Demetrius Gramm."},
    "TLG0053": {"works": ["001"], "name": "Phalaridis Epistulae"},
    "TLG0071": {"works": ["001"], "name": "Periplus Maris Erythraei"},
    "TLG2499": {"works": ["003"], "name": "Eustochius Soph."},
    "TLG2035": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "080",
            "081",
            "082",
            "083",
            "084",
            "085",
            "086",
            "087",
            "088",
            "089",
            "090",
            "091",
            "094",
            "099",
            "100",
            "101",
            "102",
            "103",
            "104",
            "105",
            "106",
            "107",
            "109",
            "110",
            "111",
            "115",
            "116",
            "117",
            "118",
            "119",
            "120",
            "121",
            "122",
            "123",
            "124",
            "125",
            "126",
            "127",
        ],
        "name": "Athanasius Theol.",
    },
    "TLG1324": {"works": ["002"], "name": "Dionysius Hist."},
    "TLG0018": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "038",
            "039",
            "041",
            "042",
        ],
        "name": "Philo Judaeus Phil.",
    },
    "TLG3147": {
        "works": ["001", "002", "003", "004"],
        "name": "Michael Critobulus Hist.",
    },
    "TLG2020": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Theodosius Gramm.",
    },
    "TLG0197": {"works": ["001"], "name": "Hedyle Epigr."},
    "TLG1452": {"works": ["003"], "name": "Juba II Rex Mauretaniae Hist."},
    "TLG1148": {"works": ["004", "005", "006"], "name": "Antonius Diogenes Scr. Erot."},
    "TLG1132": {"works": ["001"], "name": "Anonymus Alexandri Phil."},
    "TLG0556": {"works": ["001"], "name": "Asclepiodotus Tact."},
    "TLG1793": {"works": ["001"], "name": "Timoxenus Comic."},
    "TLG0515": {"works": ["001", "002", "003", "004"], "name": "Timocles Comic."},
    "TLG0900": {"works": ["001"], "name": "Cleomenes Lyr."},
    "TLG0552": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
        ],
        "name": "Archimedes Geom.",
    },
    "TLG2005": {"works": ["001"], "name": "Martyrium Pionii"},
    "TLG1550": {"works": ["001"], "name": "Oracula Chaldaica"},
    "TLG2937": {"works": ["002"], "name": "Lachares Soph."},
    "TLG5023": {
        "works": ["001", "003", "004", "005", "006"],
        "name": "Scholia In Euripidem",
    },
    "TLG1207": {"works": ["001"], "name": "Attalus Astron. et Math."},
    "TLG1325": {"works": ["001"], "name": "Diogenis Sinopensis Epistulae"},
    "TLG1749": {"works": ["001"], "name": "Vitae Hesiodi Particula"},
    "TLG0286": {"works": ["001"], "name": "Carmen Astrologicum"},
    "TLG4330": {"works": ["001"], "name": "Cosmas Hieromonachus Alchem."},
    "TLG1281": {"works": ["002"], "name": "[Clitophon] Hist."},
    "TLG4395": {"works": ["001"], "name": "Menetor Hist."},
    "TLG0436": {"works": ["001", "002"], "name": "Crito Comic."},
    "TLG0205": {"works": ["001", "002"], "name": "Philodamus Lyr."},
    "TLG1604": {"works": ["001", "002"], "name": "Phocylides Eleg. et Gnom."},
    "TLG0465": {"works": ["001", "002"], "name": "Heniochus Comic."},
    "TLG5035": {"works": ["001", "002"], "name": "Scholia In Platonem"},
    "TLG0218": {"works": ["001", "002"], "name": "Nicaenetus Epic."},
    "TLG0856": {"works": ["001"], "name": "Dieuches Med."},
    "TLG2063": {
        "works": [
            "001",
            "005",
            "006",
            "008",
            "009",
            "010",
            "013",
            "016",
            "021",
            "022",
            "025",
            "028",
        ],
        "name": "Gregorius Thaumaturgus Scr. Eccl.",
    },
    "TLG2289": {"works": ["002"], "name": "Echephylidas Hist."},
    "TLG2654": {"works": ["001"], "name": "Physiologus"},
    "TLG2703": {"works": ["001"], "name": "Anna Comnena Hist."},
    "TLG0294": {"works": ["001"], "name": "Corinna Lyr."},
    "TLG1651": {"works": ["002"], "name": "Pythermus Hist."},
    "TLG5052": {"works": ["001"], "name": "Scholia in Maximum Confessorem"},
    "TLG2213": {"works": ["002"], "name": "[Timotheus] Hist."},
    "TLG1839": {"works": ["001"], "name": "Polyphrasmon Trag."},
    "TLG1163": {"works": ["001"], "name": "Claudius Apollinarius Apol."},
    "TLG4084": {"works": ["001"], "name": "Zosimus Hist."},
    "TLG3014": {
        "works": ["001", "002"],
        "name": "Joannes Camaterus Astrol. et Astron.",
    },
    "TLG5022": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Scholia In Euclidem",
    },
    "TLG5008": {"works": ["001"], "name": "Scholia In Aelium Aristidem"},
    "TLG5040": {"works": ["001"], "name": "Scholia In Xenophontem"},
    "TLG0030": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Hyperides Orat.",
    },
    "TLG2275": {"works": ["001"], "name": "Theagenes Phil."},
    "TLG1704": {"works": ["003"], "name": "Teucer Hist."},
    "TLG0571": {"works": ["004", "005"], "name": "Aristocles Paradox."},
    "TLG1168": {"works": ["001"], "name": "Apollonius Soph."},
    "TLG0209": {"works": ["001"], "name": "Seleucus Lyr."},
    "TLG0530": {
        "works": [
            "001",
            "002",
            "003",
            "005",
            "006",
            "009",
            "012",
            "020",
            "022",
            "023",
            "024",
            "026",
            "029",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "041",
            "042",
            "043",
            "045",
            "046",
        ],
        "name": "Pseudo-Galenus Med.",
    },
    "TLG0444": {"works": ["001", "002"], "name": "Diodorus Comic."},
    "TLG1782": {"works": ["001", "002"], "name": "Augeas Comic."},
    "TLG2604": {"works": ["001"], "name": "Ulpianus Gramm. et Rhet."},
    "TLG4396": {"works": ["001"], "name": "Timagetus Hist."},
    "TLG4361": {"works": ["008"], "name": "Apomasar Astrol."},
    "TLG1134": {"works": ["001"], "name": "Anonymus Iamblichi Phil."},
    "TLG3023": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "008",
            "009",
            "010",
            "011",
            "013",
            "014",
            "019",
        ],
        "name": "Constantinus VII Porphyrogenitus Imperator Hist.",
    },
    "TLG0503": {"works": ["001", "002"], "name": "Sosicrates Comic."},
    "TLG0584": {"works": ["002", "003"], "name": "Philostephanus Hist."},
    "TLG2636": {"works": ["001"], "name": "Pherenicus Epic."},
    "TLG0721": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
        ],
        "name": "Anonymi Medici Med.",
    },
    "TLG1977": {"works": ["002"], "name": "Lucius Licinius Lucullus Hist."},
    "TLG1797": {"works": ["001", "002"], "name": "Choliambica Adespota (ALG)"},
    "TLG0472": {"works": ["001", "002", "003"], "name": "Lysippus Comic."},
    "TLG2047": {
        "works": ["001"],
        "name": "Syriani, Sopatri Et Marcellini Scholia Ad Hermogenis Status",
    },
    "TLG2609": {"works": ["001"], "name": "Asopodorus Iamb."},
    "TLG2598": {
        "works": ["002", "003", "004", "005", "006", "008", "009", "010", "012", "019"],
        "name": "Procopius Rhet. et Scr. Eccl.",
    },
    "TLG3047": {"works": ["001", "002"], "name": "Michael Glycas Astrol. et Hist."},
    "TLG1220": {"works": ["001", "002"], "name": "Batrachomyomachia"},
    "TLG1158": {"works": ["001", "002", "003"], "name": "Apocalypsis Joannis"},
    "TLG1702": {"works": ["001"], "name": "Testamentum Jobi"},
    "TLG0049": {"works": ["001"], "name": "Pisistrati Epistula"},
    "TLG0490": {"works": ["001", "002"], "name": "Philippides Comic."},
    "TLG0473": {"works": ["001", "002", "003"], "name": "Machon Comic."},
    "TLG0241": {"works": ["003"], "name": "Aristoxenus Comic."},
    "TLG0518": {"works": ["001", "002"], "name": "Xenarchus Comic."},
    "TLG1199": {"works": ["003"], "name": "Asclepiades Gramm. et Hist."},
    "TLG3182": {"works": ["001"], "name": "Pseudo-Symeon Hist."},
    "TLG0343": {"works": ["001"], "name": "Ezechiel Trag."},
    "TLG4173": {"works": ["001"], "name": "Vitae Dionysii Periegetae"},
    "TLG4333": {"works": ["001", "002"], "name": "Nicephorus Blemmydes Alchem."},
    "TLG1316": {"works": ["003"], "name": "Dinon Hist."},
    "TLG1402": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Hephaestion Gramm.",
    },
    "TLG1321": {"works": ["011"], "name": "Diogenes Phil."},
    "TLG1714": {"works": ["001", "003"], "name": "Theocritus Soph."},
    "TLG3051": {"works": ["001"], "name": "Georgius Monachus Continuatus"},
    "TLG1843": {"works": ["001"], "name": "Nicomachus Trag."},
    "TLG4332": {"works": ["001"], "name": "Hierotheus Alchem. et Poeta"},
    "TLG2948": {"works": ["001", "002", "003", "004"], "name": "Acta Philippi"},
    "TLG2424": {"works": ["003"], "name": "Chaeremon Hist. et Phil."},
    "TLG0055": {"works": ["001"], "name": "Themistoclis Epistulae"},
    "TLG0008": {"works": ["001", "002", "003"], "name": "Athenaeus Soph."},
    "TLG0031": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
        ],
        "name": "Novum Testamentum, New Testament",
    },
    "TLG0624": {"works": ["001"], "name": "Demetrius Hist. et Phil."},
    "TLG4166": {"works": ["001"], "name": "Vitae Aeschinis"},
    "TLG3135": {
        "works": ["001", "002", "003"],
        "name": "Joannes Zonaras Gramm. et Hist.",
    },
    "TLG0415": {"works": ["001", "002", "003"], "name": "Araros Comic."},
    "TLG4286": {"works": ["001", "002", "003", "004"], "name": "Lexica Syntactica"},
    "TLG1352": {
        "works": ["001"],
        "name": "Epistula Ecclesiarum Apud Lugdunum Et Viennam",
    },
    "TLG2412": {"works": ["002"], "name": "Androetas Hist."},
    "TLG4061": {"works": ["002"], "name": "Cosmas Indicopleustes Geogr."},
    "TLG2806": {"works": ["001"], "name": "Marcus Diaconus Scr. Eccl."},
    "TLG0546": {"works": ["001"], "name": "Aelianus Tact."},
    "TLG0601": {"works": ["001"], "name": "Zaleucus Nomographus Phil."},
    "TLG1551": {"works": ["001", "002"], "name": "Oracula Sibyllina"},
    "TLG2536": {"works": ["003"], "name": "Andron Geogr."},
    "TLG2210": {"works": ["002"], "name": "Anaxicrates Hist."},
    "TLG5026": {
        "works": ["001", "003", "004", "007", "008", "009", "016", "017"],
        "name": "Scholia In Homerum",
    },
    "TLG5037": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Scholia In Sophoclem",
    },
    "TLG0537": {
        "works": ["010", "011", "012", "013", "014", "015", "016", "017"],
        "name": "Epicurus Phil.",
    },
    "TLG2904": {"works": ["001", "002", "003"], "name": "Nicolaus Rhet. et Soph."},
    "TLG1164": {"works": ["002"], "name": "Apollodorus Hist."},
    "TLG0242": {"works": ["001", "003"], "name": "Asius Eleg. et Epic."},
    "TLG1301": {"works": ["002"], "name": "Demetrius Poet. Phil."},
    "TLG1379": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
        ],
        "name": "Fragmenta Alchemica",
    },
    "TLG1803": {"works": ["001"], "name": "Bruti Epistulae"},
    "TLG2228": {"works": ["001"], "name": "Menestor Phil."},
    "TLG1460": {"works": ["001"], "name": "Lesbonax Gramm."},
    "TLG1338": {"works": ["003"], "name": "Dosiadas Hist."},
    "TLG0693": {"works": ["001", "002"], "name": "Albinus Phil."},
    "TLG5012": {"works": ["001"], "name": "Scholia In Apollonium Rhodium"},
    "TLG4098": {"works": ["001", "002", "003", "004"], "name": "Etymologicum Gudianum"},
    "TLG0623": {"works": ["001"], "name": "Cratetis Epistulae"},
    "TLG1155": {"works": ["001"], "name": "Apocalypsis Syriaca Baruchi"},
    "TLG4024": {"works": ["001"], "name": "Agathias Scholasticus Epigr. et Hist."},
    "TLG1805": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
        ],
        "name": "Vitae Homeri",
    },
    "TLG2627": {"works": ["001"], "name": "Damianus Scriptor De Opticis"},
    "TLG2635": {"works": ["001"], "name": "Persinus Poeta"},
    "TLG1649": {"works": ["002"], "name": "Pythaenetus Hist."},
    "TLG1710": {"works": ["001"], "name": "Theages Phil."},
    "TLG3173": {"works": ["001", "002", "003"], "name": "Joannes Theol."},
    "TLG1285": {"works": ["003"], "name": "Conon Hist."},
    "TLG2328": {"works": ["003"], "name": "Diogenes Hist."},
    "TLG2479": {"works": ["003"], "name": "Patrocles Hist."},
    "TLG0918": {"works": ["001"], "name": "Lamynthius Lyr."},
    "TLG0267": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Xenophanes Poet. Phil.",
    },
    "TLG1160": {"works": ["001"], "name": "Apocalypsis Sophoniae"},
    "TLG4397": {"works": ["001"], "name": "Myronianus Hist."},
    "TLG5032": {"works": ["001", "002"], "name": "Scholia In Oppianum"},
    "TLG1759": {"works": ["001", "002"], "name": "Sententiae Pythagoreorum"},
    "TLG2185": {"works": ["001"], "name": "Dionysius Μεταθέμενος Phil."},
    "TLG2396": {"works": ["002", "003"], "name": "Hyperochus Hist."},
    "TLG4175": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Commentaria In Dionysii Thracis Artem Grammaticam",
    },
    "TLG1135": {"works": ["001"], "name": "Anonymus Photii Phil."},
    "TLG1737": {"works": ["001"], "name": "Titanomachia"},
    "TLG0204": {"works": ["001", "002"], "name": "Aristonous Lyr."},
    "TLG1696": {"works": ["001"], "name": "Straton Phil."},
    "TLG1732": {"works": ["002"], "name": "Timachidas Hist."},
    "TLG2455": {"works": ["003"], "name": "Aristocreon Hist."},
    "TLG1603": {"works": ["001"], "name": "Phintys Phil."},
    "TLG2387": {"works": ["003"], "name": "Athanis Hist."},
    "TLG1353": {"works": ["001"], "name": "Epitaphium Abercii"},
    "TLG2006": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
        ],
        "name": "Synesius Phil.",
    },
    "TLG1191": {"works": ["001"], "name": "Aristombrotus Phil."},
    "TLG2202": {"works": ["002"], "name": "[Menyllus] Hist."},
    "TLG2461": {"works": ["003"], "name": "Uranius Hist."},
    "TLG2699": {"works": ["001"], "name": "Amphicrates Rhet."},
    "TLG2428": {"works": ["002"], "name": "Thrasyllus Hist."},
    "TLG0338": {"works": ["001"], "name": "Sosiphanes Trag."},
    "TLG1362": {"works": ["001", "002"], "name": "Eurytus Phil."},
    "TLG0411": {"works": ["001", "002", "003", "004"], "name": "Apollodorus Comic."},
    "TLG1218": {"works": ["003"], "name": "Basilis Hist."},
    "TLG0549": {"works": ["003", "005"], "name": "Apollodorus Gramm."},
    "TLG1954": {"works": ["001"], "name": "Heraclides Phil."},
    "TLG0501": {"works": ["001", "002", "003", "004"], "name": "Sannyrion Comic."},
    "TLG0237": {"works": ["001", "002", "003", "004"], "name": "Anacreon Lyr."},
    "TLG1129": {
        "works": ["001", "002"],
        "name": "Anonymi De Barbarismo Et Soloecismo Gramm.",
    },
    "TLG2225": {"works": ["001"], "name": "Parm(en)iscus Phil."},
    "TLG0661": {"works": ["001", "002"], "name": "Archigenes Med."},
    "TLG0038": {"works": ["001"], "name": "Arcesilai Epistula"},
    "TLG0234": {"works": ["001"], "name": "Elegiaca Adespota (IEG)"},
    "TLG3002": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "018",
            "019",
        ],
        "name": "Prolegomena De Comoedia",
    },
    "TLG0014": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
        ],
        "name": "Demosthenes Orat.",
    },
    "TLG3088": {"works": ["002"], "name": "Nicephorus Bryennius Hist."},
    "TLG2404": {"works": ["001"], "name": "Philogelos"},
    "TLG1828": {"works": ["001"], "name": "Pamphila Hist."},
    "TLG1328": {"works": ["001"], "name": "Dionysius Hist."},
    "TLG0354": {"works": ["001"], "name": "Zenodotus Trag."},
    "TLG1260": {"works": ["002"], "name": "[Chersias] Epic."},
    "TLG0298": {"works": ["001", "002", "003", "004", "005"], "name": "Eumelus Epic."},
    "TLG1237": {"works": ["001"], "name": "Callicratidas Phil."},
    "TLG2284": {"works": ["003"], "name": "Anaxandridas Hist."},
    "TLG4094": {"works": ["001", "002"], "name": "Choricius Rhet. et Soph."},
    "TLG1715": {"works": ["001", "002"], "name": "Theodoridas Epigr."},
    "TLG0404": {"works": ["001", "002"], "name": "Amphis Comic."},
    "TLG1725": {"works": ["001"], "name": "Theophilus Apol."},
    "TLG2595": {"works": ["001"], "name": "Philo Paradox."},
    "TLG2386": {"works": ["003"], "name": "Timonides Hist."},
    "TLG1360": {"works": ["001"], "name": "Euryphamus Phil."},
    "TLG1241": {"works": ["002"], "name": "Carmen Naupactium"},
    "TLG2195": {"works": ["002"], "name": "[Chrysermus] Hist."},
    "TLG1765": {"works": ["001", "002", "003", "004", "005"], "name": "Vitae Aesopi"},
    "TLG0264": {"works": ["001", "002", "003"], "name": "Susarion Comic."},
    "TLG1844": {"works": ["001"], "name": "Hera[clides] Trag."},
    "TLG1941": {"works": ["003"], "name": "Leo Hist."},
    "TLG1355": {"works": ["001", "002", "003"], "name": "Erinna Lyr."},
    "TLG1643": {"works": ["003", "004"], "name": "Ptolemaeus Gramm."},
    "TLG0032": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
        ],
        "name": "Xenophon Hist.",
    },
    "TLG0072": {
        "works": [
            "001",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
        ],
        "name": "Anonymi Grammatici Gramm.",
    },
    "TLG1949": {"works": ["003"], "name": "Potamon Hist."},
    "TLG2866": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
        ],
        "name": "Oecumenius Phil. et Rhet.",
    },
    "TLG0268": {"works": ["001", "002"], "name": "Mesomedes Lyr."},
    "TLG0748": {"works": ["001"], "name": "Severus Iatrosophista Med."},
    "TLG2162": {"works": ["003"], "name": "Aratus Hist."},
    "TLG2620": {"works": ["001"], "name": "Dionysius Iambus Gramm. et Poeta"},
    "TLG1753": {"works": ["002"], "name": "Xenion Hist."},
    "TLG0441": {"works": ["001", "002"], "name": "Demonicus Comic."},
    "TLG1698": {"works": ["003"], "name": "Telephus Gramm."},
    "TLG0405": {"works": ["001", "002", "003", "004"], "name": "Anaxandrides Comic."},
    "TLG2260": {"works": ["001", "002"], "name": "Hippasus Phil."},
    "TLG3039": {"works": ["001", "002"], "name": "Joannes Galenus Gramm."},
    "TLG0455": {"works": ["001", "002"], "name": "Eriphus Comic."},
    "TLG1754": {"works": ["001"], "name": "Xenophontis Epistulae"},
    "TLG0005": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Theocritus Bucol.",
    },
    "TLG2045": {"works": ["001", "002", "003"], "name": "Nonnus Epic."},
    "TLG0313": {"works": ["001"], "name": "Theognis Trag."},
    "TLG2531": {"works": ["003"], "name": "Metrophanes Hist."},
    "TLG2001": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
        ],
        "name": "Themistius Phil. et Rhet.",
    },
    "TLG2701": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Georgius Pisides Poeta",
    },
    "TLG0532": {"works": ["001"], "name": "Achilles Tatius Scr. Erot."},
    "TLG0579": {
        "works": ["001", "002", "003", "007", "008", "009", "010", "011", "012", "013"],
        "name": "Orphica",
    },
    "TLG0513": {"works": ["001", "002", "003", "004"], "name": "Theopompus Comic."},
    "TLG4031": {"works": ["001", "002", "003"], "name": "Eustratius Phil."},
    "TLG2655": {"works": ["002"], "name": "Damigeron Magus"},
    "TLG2034": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "027",
            "029",
        ],
        "name": "Porphyrius Phil.",
    },
    "TLG1498": {"works": ["003"], "name": "Menander Hist."},
    "TLG0305": {"works": ["001"], "name": "Aristias Trag."},
    "TLG2201": {"works": ["002"], "name": "[Ctesiphon] Hist."},
    "TLG5009": {"works": ["001"], "name": "Scholia In Aeschinem"},
    "TLG0710": {"works": ["001"], "name": "Amphiarai Exilium (?)"},
    "TLG0437": {"works": ["001", "002"], "name": "Crobylus Comic."},
    "TLG1969": {"works": ["003"], "name": "Philinus Hist."},
    "TLG1171": {"works": ["001"], "name": "Apollonius Scr. Eccl."},
    "TLG0551": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
        ],
        "name": "Appianus Hist.",
    },
    "TLG1654": {"works": ["001", "002"], "name": "Rhinthon Comic."},
    "TLG2383": {"works": ["001"], "name": "Diodorus Phil."},
    "TLG0323": {"works": ["001"], "name": "Antiphon Trag."},
    "TLG1270": {"works": ["001"], "name": "Clearchus Phil."},
    "TLG0615": {"works": ["001"], "name": "Aspasius Phil."},
    "TLG4072": {"works": ["001", "002", "003", "004"], "name": "Eutocius Math."},
    "TLG0498": {"works": ["001", "002"], "name": "Poliochus Comic."},
    "TLG1210": {"works": ["001", "002"], "name": "Autolycus Astron."},
    "TLG0566": {"works": ["001", "002", "003"], "name": "Theopompus Hist."},
    "TLG0617": {"works": ["001", "002"], "name": "Anaximenes Phil."},
    "TLG0239": {
        "works": ["001", "002", "003", "004"],
        "name": "Antimachus Eleg. et Epic.",
    },
    "TLG1349": {"works": ["001"], "name": "Epistula A Martyribus Lugdunensibus"},
    "TLG2294": {"works": ["001"], "name": "Zeno Phil."},
    "TLG0094": {"works": ["001", "002", "003"], "name": "Pseudo-Plutarchus"},
    "TLG0726": {"works": ["001", "002", "003", "004"], "name": "Palladius Med."},
    "TLG1411": {"works": ["001"], "name": "Heracliti Ephesii Epistulae"},
    "TLG1313": {"works": ["003"], "name": "Dieuchidas Hist."},
    "TLG0062": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
        ],
        "name": "Lucianus Soph.",
    },
    "TLG0565": {"works": ["001", "002", "003", "004"], "name": "Soranus Med."},
    "TLG0389": {"works": ["001"], "name": "Acta Petri"},
    "TLG0570": {"works": ["002", "003"], "name": "Archelaus Paradox."},
    "TLG2512": {"works": ["002"], "name": "Paeon Hist."},
    "TLG0086": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
        ],
        "name": "Aristoteles Phil. et Corpus Aristotelicum, Aristotle",
    },
    "TLG9023": {"works": ["001", "002"], "name": "Thomas Magister Philol."},
    "TLG0981": {"works": ["001"], "name": "Stesichorus II Lyr."},
    "TLG0056": {"works": ["001"], "name": "Thrasybuli Epistula"},
    "TLG2268": {"works": ["002"], "name": "Timagoras Hist."},
    "TLG0059": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
        ],
        "name": "Plato Phil.",
    },
    "TLG0390": {"works": ["001"], "name": "Martyrium Carpi, Papyli Et Agathonicae"},
    "TLG1507": {"works": ["001"], "name": "Metopus Phil."},
    "TLG2050": {"works": ["001", "002"], "name": "Eunapius Hist. et Soph."},
    "TLG1269": {"works": ["001", "002"], "name": "Cleanthes Phil."},
    "TLG1632": {"works": ["001", "004"], "name": "Posidippus Epigr."},
    "TLG1733": {"works": ["001", "002", "003"], "name": "Timaeus Hist."},
    "TLG0489": {"works": ["001", "002", "003"], "name": "Philetaerus Comic."},
    "TLG1706": {"works": ["003"], "name": "Thallus Hist."},
    "TLG0083": {"works": ["002", "003"], "name": "Dionysius Geogr."},
    "TLG0576": {"works": ["003"], "name": "Musaeus Epic."},
    "TLG4026": {
        "works": ["001", "002", "003"],
        "name": "Anonymi In Aristotelis Artem Rhetoricam Rhet.",
    },
    "TLG0466": {"works": ["001", "002"], "name": "Heraclides Comic."},
    "TLG2326": {"works": ["003", "004"], "name": "Dei(l)ochus Hist."},
    "TLG1846": {"works": ["001"], "name": "Spintharus Trag."},
    "TLG2417": {"works": ["003"], "name": "Cineas Rhet."},
    "TLG2511": {"works": ["002"], "name": "Demetrius Hist."},
    "TLG1266": {"works": ["001"], "name": "Tyrannion Gramm."},
    "TLG1372": {"works": ["001"], "name": "Evangelium Evae"},
    "TLG2585": {"works": ["001"], "name": "Marcellinus Biogr."},
    "TLG2474": {"works": ["002"], "name": "Nicander Hist."},
    "TLG1482": {"works": ["001"], "name": "Cyranides"},
    "TLG1811": {"works": ["001"], "name": "Metrodorus Major Phil."},
    "TLG1225": {"works": ["003"], "name": "Bion Hist."},
    "TLG0344": {"works": ["001"], "name": "Melanthius Trag."},
    "TLG2881": {
        "works": ["001", "002", "003", "005"],
        "name": "Romanus Melodus Hymnographus",
    },
    "TLG0271": {"works": ["001"], "name": "Conventus Avium"},
    "TLG4046": {"works": ["001"], "name": "Theophanes Confessor Chronogr."},
    "TLG1319": {"works": ["001", "002"], "name": "Diogenes Phil."},
    "TLG4147": {"works": ["001"], "name": "Florilegium Cyrillianum"},
    "TLG2110": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
        ],
        "name": "Cyrillus Scr. Eccl.",
    },
    "TLG0054": {"works": ["001"], "name": "Theano Phil."},
    "TLG1176": {"works": ["001"], "name": "Archytas Epic."},
    "TLG0346": {"works": ["001"], "name": "Pompeius Macer Trag."},
    "TLG4033": {
        "works": ["001", "002", "003"],
        "name": "Anonymi In Aristotelis Ethica Nicomachea Phil.",
    },
    "TLG1597": {"works": ["001"], "name": "Telauges Phil."},
    "TLG1412": {"works": ["001"], "name": "Pseudo-Heracliti Epistulae"},
    "TLG0418": {"works": ["001", "002"], "name": "Aristagoras Comic."},
    "TLG1500": {"works": ["001"], "name": "Menecrates Poet. Phil."},
    "TLG0506": {"works": ["001", "002"], "name": "Stephanus Comic."},
    "TLG0309": {"works": ["001"], "name": "Achaeus Trag."},
    "TLG5010": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "009",
            "010",
            "011",
            "019",
            "020",
            "021",
            "022",
            "023",
        ],
        "name": "Scholia In Aeschylum",
    },
    "TLG1676": {"works": ["001", "002"], "name": "Simylus Iamb."},
    "TLG1596": {"works": ["001", "002", "003"], "name": "Philolaus Phil."},
    "TLG0212": {
        "works": ["001", "002", "003", "004"],
        "name": "Philetas Eleg. et Gramm.",
    },
    "TLG4083": {
        "works": ["001", "003", "004", "006"],
        "name": "Eustathius Philol. et Scr. Eccl.",
    },
    "TLG0424": {"works": ["001", "002", "003"], "name": "Axionicus Comic."},
    "TLG1713": {"works": ["002"], "name": "Themison Hist."},
    "TLG4235": {"works": ["001", "002"], "name": "Joannes Rhet."},
    "TLG0545": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Claudius Aelianus Soph.",
    },
    "TLG2061": {"works": ["001", "002"], "name": "Asterius Sophista Scr. Eccl."},
    "TLG0427": {"works": ["001", "002"], "name": "Callippus Comic."},
    "TLG5030": {"works": ["001"], "name": "Scholia In Lycophronem"},
    "TLG1701": {"works": ["001", "002"], "name": "Testamentum Abrahae"},
    "TLG0715": {"works": ["001"], "name": "Paulus Med."},
    "TLG2031": {"works": ["001", "002", "003"], "name": "Sopater Rhet."},
    "TLG0659": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Comica Adespota (Suppl. Com.)",
    },
    "TLG0479": {"works": ["001", "002"], "name": "Nico Comic."},
    "TLG0719": {"works": ["001", "002", "003", "004"], "name": "Aretaeus Med."},
    "TLG4080": {"works": ["001"], "name": "Geoponica"},
    "TLG4391": {"works": ["001"], "name": "Glaucus Hist."},
    "TLG1083": {"works": ["002"], "name": "Isigonus Paradox."},
    "TLG1268": {"works": ["002"], "name": "Claudius Iolaus Hist."},
    "TLG0165": {"works": ["001", "002"], "name": "Diodorus Rhet."},
    "TLG2240": {"works": ["001"], "name": "Hicetas Phil."},
    "TLG0074": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
        ],
        "name": "Flavius Arrianus Hist. et Phil.",
    },
    "TLG2141": {"works": ["003"], "name": "Publius Herennius Dexippus Hist."},
    "TLG4110": {
        "works": [
            "001",
            "002",
            "007",
            "008",
            "010",
            "015",
            "016",
            "017",
            "018",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "028",
            "030",
            "031",
            "040",
            "043",
        ],
        "name": "Evagrius Scr. Eccl.",
    },
    "TLG2903": {"works": ["001"], "name": "Minucianus Junior Rhet."},
    "TLG0017": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
        ],
        "name": "Isaeus Orat.",
    },
    "TLG1358": {"works": ["001", "003"], "name": "Eudoxus Astron."},
    "TLG1196": {"works": ["003", "004"], "name": "Aristophanes Hist."},
    "TLG0353": {"works": ["001"], "name": "Sclerias Trag."},
    "TLG1728": {"works": ["003"], "name": "Theseus Hist."},
    "TLG1371": {"works": ["001"], "name": "Evangelium Petri"},
    "TLG1625": {"works": ["001", "002"], "name": "Polyclitus Phil."},
    "TLG2151": {"works": ["002"], "name": "Praxagoras Hist."},
    "TLG0002": {"works": ["001", "002", "003", "004"], "name": "Theognis Eleg."},
    "TLG1248": {"works": ["001"], "name": "Celsus Phil."},
    "TLG0314": {"works": ["001"], "name": "Morsimus Trag."},
    "TLG4163": {"works": ["001"], "name": "Telegonia"},
    "TLG0359": {"works": ["001"], "name": "Isidorus Scriptor Hymnorum"},
    "TLG4037": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Anonymi Paradoxographi",
    },
    "TLG0300": {"works": ["001"], "name": "Acta Alexandrinorum"},
    "TLG1307": {"works": ["003"], "name": "Demon Hist."},
    "TLG1981": {"works": ["003"], "name": "Theophanes Hist."},
    "TLG2233": {"works": ["001"], "name": "Pseudo-Polemon"},
    "TLG5016": {
        "works": [
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "022",
            "023",
            "024",
        ],
        "name": "Scholia In Callimachum",
    },
    "TLG2397": {"works": ["001"], "name": "Boethus Phil."},
    "TLG1642": {"works": ["001"], "name": "Pseudo-Ptolemaeus"},
    "TLG2533": {"works": ["002"], "name": "Timolaus Hist."},
    "TLG1312": {"works": ["003", "004"], "name": "Didymus Gramm."},
    "TLG1143": {"works": ["001"], "name": "Antiochus Phil."},
    "TLG2950": {"works": ["001"], "name": "Adamantius Theol."},
    "TLG1558": {"works": ["001"], "name": "Papias Scr. Eccl."},
    "TLG2680": {"works": ["001"], "name": "Scythinus Epigr."},
    "TLG0553": {"works": ["001"], "name": "Artemidorus Onir."},
    "TLG0440": {"works": ["001", "002"], "name": "Demetrius Junior Comic."},
    "TLG1509": {"works": ["001"], "name": "Milon Phil."},
    "TLG0562": {"works": ["001"], "name": "Marcus Aurelius Antoninus Imperator Phil."},
    "TLG1821": {"works": ["001", "002"], "name": "Iambica Adespota (ALG)"},
    "TLG0646": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
        ],
        "name": "Pseudo-Justinus Martyr",
    },
    "TLG0494": {"works": ["001", "002", "003", "004"], "name": "Philyllius Comic."},
    "TLG0703": {"works": ["001"], "name": "Numenius Poet. Didac."},
    "TLG2632": {"works": ["001"], "name": "Comarius Alchem."},
    "TLG0469": {"works": ["001", "002"], "name": "Laon Comic."},
    "TLG1337": {"works": ["001", "002", "003"], "name": "Dorotheus Astrol."},
    "TLG1376": {"works": ["001"], "name": "Eudemus Rhet."},
    "TLG1197": {"works": ["001"], "name": "Artemon Gramm."},
    "TLG0738": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009", "010"],
        "name": "Hippiatrica",
    },
    "TLG9009": {"works": ["001"], "name": "Michael Apostolius Paroemiogr."},
    "TLG2130": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "032"],
        "name": "Arethas Philol. et Scr. Eccl.",
    },
    "TLG1115": {"works": ["001"], "name": "Archestratus Trag."},
    "TLG3070": {"works": ["001"], "name": "Symeon Logothetes Hist."},
    "TLG0228": {"works": ["001"], "name": "Anonymi Hymnus In Dactylos Idaeos"},
    "TLG0373": {"works": ["001"], "name": "Melanippides Lyr."},
    "TLG2019": {"works": ["001"], "name": "Pelagius Alchem."},
    "TLG0582": {"works": ["001"], "name": "Paradoxographus Vaticanus"},
    "TLG1760": {
        "works": ["001", "002"],
        "name": "Gaius Suetonius Tranquillus Gramm. et Hist.",
    },
    "TLG2877": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Cyrillus Biogr.",
    },
    "TLG1149": {"works": ["001"], "name": "Antonini Pii Imperatoris Epistula"},
    "TLG0400": {"works": ["001", "002", "003", "004"], "name": "Alcaeus Comic."},
    "TLG2475": {"works": ["002"], "name": "Menecrates Hist."},
    "TLG2298": {"works": ["002"], "name": "Lysanias Hist."},
    "TLG3155": {"works": ["001"], "name": "Joannes Protospatharius Gramm."},
    "TLG2245": {"works": ["001"], "name": "Simus Phil."},
    "TLG1720": {"works": ["002"], "name": "Theodotus Judaeus Epic."},
    "TLG0446": {"works": ["001", "002"], "name": "Dioxippus Comic."},
    "TLG1799": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
        ],
        "name": "Euclides Geom.",
    },
    "TLG0207": {"works": ["001"], "name": "Hermocles Lyr."},
    "TLG4302": {"works": ["001"], "name": "Lexicon Patmense"},
    "TLG0231": {"works": ["001"], "name": "Elegiaca Adespota (CA)"},
    "TLG4305": {"works": ["001"], "name": "Claudius Casilon Gramm."},
    "TLG0385": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
        ],
        "name": "Cassius Dio Hist., Dio Cassius",
    },
    "TLG2291": {"works": ["001"], "name": "Cratylus Phil."},
    "TLG2000": {"works": ["001"], "name": "Plotinus Phil."},
    "TLG2322": {"works": ["003"], "name": "Antenor Hist."},
    "TLG2640": {"works": ["001"], "name": "Eusebius Phil."},
    "TLG2049": {"works": ["001"], "name": "Sallustius Phil."},
    "TLG0199": {
        "works": [
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
        ],
        "name": "Bacchylides Lyr.",
    },
    "TLG1764": {"works": ["001"], "name": "Vettius Valens Astrol."},
    "TLG3157": {"works": ["001"], "name": "Theodorus Scutariota Hist."},
    "TLG1763": {"works": ["001"], "name": "Tryphon II Gramm."},
    "TLG1499": {"works": ["002"], "name": "Menecles Hist."},
    "TLG2634": {"works": ["001"], "name": "Pamphilus Poeta"},
    "TLG1605": {"works": ["001"], "name": "Pseudo-Phocylides Gnom."},
    "TLG4019": {
        "works": ["001", "002", "003", "004", "005", "006", "008"],
        "name": "Olympiodorus Phil.",
    },
    "TLG1750": {"works": ["001", "002", "003", "004"], "name": "Vitae Prophetarum"},
    "TLG2192": {"works": ["002"], "name": "[Agatharchides] Hist."},
    "TLG0009": {"works": ["001", "002", "003", "004"], "name": "Sappho Lyr."},
    "TLG1775": {"works": ["001"], "name": "Pseudo-Agathon Epigr."},
    "TLG0057": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "080",
            "081",
            "082",
            "083",
            "084",
            "085",
            "086",
            "087",
            "088",
            "089",
            "090",
            "091",
            "092",
            "093",
            "094",
            "095",
            "096",
            "097",
            "099",
            "100",
            "101",
            "102",
            "103",
            "104",
            "105",
            "106",
            "107",
            "111",
            "114",
            "115",
            "121",
        ],
        "name": "Galenus Med.",
    },
    "TLG1202": {"works": ["001"], "name": "Athamas Phil."},
    "TLG1779": {"works": ["001", "002"], "name": "Anonymus Epicureus Phil."},
    "TLG1190": {"works": ["003"], "name": "Aristagoras Hist."},
    "TLG4340": {"works": ["001"], "name": "Salmanas Alchem."},
    "TLG2317": {"works": ["001"], "name": "Hermias Phil."},
    "TLG2729": {"works": ["001"], "name": "Prorus Phil."},
    "TLG5002": {"works": ["001", "002", "003", "004"], "name": "Magica"},
    "TLG0137": {"works": ["001", "002"], "name": "Asclepiades Epigr."},
    "TLG0288": {"works": ["001", "003"], "name": "Pisander Epic."},
    "TLG1342": {"works": ["002", "003", "004"], "name": "Empedocles Poet. Phil."},
    "TLG5033": {"works": ["001"], "name": "Scholia In Pausaniam"},
    "TLG1687": {"works": ["003"], "name": "Sosicrates Hist."},
    "TLG1211": {"works": ["003"], "name": "Balagrus Hist."},
    "TLG1691": {"works": ["001"], "name": "Sotades Iamb."},
    "TLG0524": {"works": ["001", "002"], "name": "Sophron Mimogr."},
    "TLG0200": {"works": ["001"], "name": "Mantissa Proverbiorum"},
    "TLG2578": {"works": ["001", "002"], "name": "Joannes Gramm. et Poeta"},
    "TLG2592": {"works": ["003"], "name": "Joannes Pediasimus Philol. et Rhet."},
    "TLG2200": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "011",
            "012",
            "013",
        ],
        "name": "Libanius Rhet. et Soph.",
    },
    "TLG1329": {"works": ["001"], "name": "Dionysius Scr. Eccl."},
    "TLG0561": {"works": ["001"], "name": "Longus Scr. Erot."},
    "TLG2021": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
        ],
        "name": "Epiphanius Scr. Eccl.",
    },
    "TLG2307": {"works": ["002"], "name": "Artemon Hist."},
    "TLG1795": {"works": ["001"], "name": "Chaerion Comic."},
    "TLG1623": {"works": ["002"], "name": "Polycharmus Hist."},
    "TLG1736": {"works": ["002"], "name": "Timonax Hist."},
    "TLG0210": {"works": ["001"], "name": "Euphronius Lyr."},
    "TLG2274": {
        "works": ["004", "005", "006", "007"],
        "name": "Hesychius Illustrius Hist.",
    },
    "TLG1781": {"works": ["001", "002"], "name": "Philippus Comic."},
    "TLG2615": {"works": ["001"], "name": "Daphitas Gramm. vel Soph."},
    "TLG0244": {"works": ["001"], "name": "Cleobulina Scriptor Aenigmatum"},
    "TLG1699": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Teles Phil.",
    },
    "TLG0236": {"works": ["001"], "name": "Alcibiades Eleg."},
    "TLG2215": {"works": ["002"], "name": "Ar(i)aethus Hist."},
    "TLG1945": {"works": ["003"], "name": "Antigenes Hist."},
    "TLG2949": {"works": ["001"], "name": "Acta Barnabae"},
    "TLG2205": {"works": ["002"], "name": "Autesion Hist."},
    "TLG5029": {"works": ["001", "002"], "name": "Scholia In Lucianum"},
    "TLG1911": {"works": ["003"], "name": "Diyllus Hist."},
    "TLG4085": {"works": ["001", "002", "003"], "name": "Hesychius Lexicogr."},
    "TLG4337": {"works": ["001"], "name": "Heliodorus Alchem. et Poeta"},
    "TLG0316": {"works": ["001"], "name": "Xenocles Trag."},
    "TLG2247": {"works": ["001"], "name": "Petron Phil."},
    "TLG0478": {"works": ["001", "002", "003"], "name": "Nausicrates Comic."},
    "TLG1339": {"works": ["003", "005"], "name": "Duris Hist."},
    "TLG1182": {"works": ["004"], "name": "[Aristeas] Epic."},
    "TLG4030": {"works": ["001"], "name": "Sophonias Phil."},
    "TLG9022": {
        "works": ["003", "004", "006"],
        "name": "Joannes Tzetzes Gramm. et Poeta",
    },
    "TLG1407": {"works": ["001", "002"], "name": "Heraclides Lembus Hist."},
    "TLG0460": {"works": ["001", "002"], "name": "Euphro Comic."},
    "TLG2539": {"works": ["003"], "name": "Diophantus Hist."},
    "TLG1751": {"works": ["003", "004"], "name": "Xanthus Hist."},
    "TLG0445": {"works": ["001", "002", "003"], "name": "Dionysius Comic."},
    "TLG2016": {"works": ["001"], "name": "Passio Perpetuae Et Felicitatis"},
    "TLG2181": {"works": ["001", "002"], "name": "Moses Alchem."},
    "TLG2384": {"works": ["003"], "name": "Hermias Hist."},
    "TLG1180": {"works": ["001"], "name": "Aristaeus Phil."},
    "TLG2054": {"works": ["001"], "name": "Aristides Quintilianus Mus."},
    "TLG1557": {"works": ["001", "003"], "name": "Panyassis Epic."},
    "TLG0527": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
        ],
        "name": "Septuaginta",
    },
    "TLG4161": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
        ],
        "name": "Vitae Arati Et Varia De Arato",
    },
    "TLG5004": {"works": ["001", "002"], "name": "Epimerismi"},
    "TLG2339": {"works": ["002"], "name": "Maeandrius Hist."},
    "TLG4105": {"works": ["001"], "name": "Julianus Scr. Eccl."},
    "TLG0337": {"works": ["001"], "name": "Python Trag."},
    "TLG0355": {"works": ["001"], "name": "Zopyrus Trag."},
    "TLG0058": {"works": ["001"], "name": "Aeneas Tact."},
    "TLG0258": {"works": ["001"], "name": "Pigres Eleg."},
    "TLG1838": {"works": ["001", "002", "003"], "name": "Theon Gramm."},
    "TLG1791": {"works": ["001", "002"], "name": "Menandri Et Philistionis Sententiae"},
    "TLG1590": {"works": ["002"], "name": "Philippus Hist."},
    "TLG2633": {"works": ["001"], "name": "Niceratus Epic."},
    "TLG0248": {"works": ["001"], "name": "Diphilus Epic. et Iamb."},
    "TLG2970": {"works": ["001"], "name": "Severus Phil."},
    "TLG5046": {"works": ["001"], "name": "Scholia In Theonem Rhetorem"},
    "TLG0350": {"works": ["001"], "name": "Dionysius Scymnaeus Trag. vel Comic."},
    "TLG1553": {"works": ["001", "004"], "name": "Palaephatus Myth."},
    "TLG2691": {"works": ["001", "002"], "name": "[Musaeus] Phil."},
    "TLG0310": {"works": ["001"], "name": "Carcinus Trag."},
    "TLG1240": {"works": ["003"], "name": "Callixenus Hist."},
    "TLG2102": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "025",
            "026",
            "027",
            "028",
            "030",
            "032",
            "033",
            "035",
            "037",
            "040",
            "041",
            "042",
            "043",
            "046",
            "047",
            "048",
            "049",
        ],
        "name": "Didymus Caecus Scr. Eccl., Didymus the Blind",
    },
    "TLG4021": {"works": ["001", "002"], "name": "David Phil."},
    "TLG0539": {"works": ["001", "002", "003"], "name": "Hellanicus Hist."},
    "TLG0641": {"works": ["001", "002"], "name": "Xenophon Scr. Erot."},
    "TLG0370": {"works": ["001"], "name": "Lamprocles Lyr."},
    "TLG2482": {"works": ["003"], "name": "Daimachus Hist."},
    "TLG1121": {"works": ["001"], "name": "Anaximenis Milesii Epistulae"},
    "TLG1849": {"works": ["001"], "name": "Demetrius Trag."},
    "TLG1494": {"works": ["001", "002"], "name": "Melissus Phil."},
    "TLG2109": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
        ],
        "name": "Pseudo-Macarius Scr. Eccl.",
    },
    "TLG4346": {"works": ["001"], "name": "Menecrates Hist."},
    "TLG4184": {"works": ["001"], "name": "Dionysius Soph."},
    "TLG1397": {"works": ["003"], "name": "Hegesippus Hist."},
    "TLG0386": {"works": ["001"], "name": "Chilonis Epistula"},
    "TLG0016": {"works": ["001"], "name": "Herodotus Hist."},
    "TLG1442": {"works": ["004"], "name": "Idomeneus Hist."},
    "TLG1470": {"works": ["003", "004"], "name": "Lycus Hist."},
    "TLG0688": {"works": ["003", "005"], "name": "Agathocles Hist."},
    "TLG1491": {"works": ["002"], "name": "Melanthius Hist."},
    "TLG0548": {"works": ["001"], "name": "Pseudo-Apollodorus Myth."},
    "TLG0729": {
        "works": ["002", "003", "004", "005"],
        "name": "Theophilus Protospatharius Med.",
    },
    "TLG4153": {"works": ["001"], "name": "Theophanes Continuatus"},
    "TLG0619": {"works": ["001", "002", "003"], "name": "Apollonius Phil."},
    "TLG1609": {"works": ["001", "002", "003"], "name": "Phylarchus Hist."},
    "TLG2052": {"works": ["001", "002"], "name": "Horapollo Gramm."},
    "TLG0284": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
        ],
        "name": "Aelius Aristides Rhet.",
    },
    "TLG0311": {"works": ["001"], "name": "Iophon Trag."},
    "TLG0888": {"works": ["001"], "name": "Eudemus Poet. Med."},
    "TLG0092": {"works": ["001"], "name": "Anonymi Geographiae Expositio Compendiaria"},
    "TLG2187": {"works": ["002"], "name": "Posidonius Hist."},
    "TLG1533": {"works": ["001", "002"], "name": "Nicias Epigr."},
    "TLG1727": {"works": ["002"], "name": "Theotimus Hist."},
    "TLG2542": {"works": ["003"], "name": "Quintus Fabius Pictor Hist."},
    "TLG1216": {"works": ["001"], "name": "Barnabae Epistula"},
    "TLG0645": {"works": ["001", "002", "003", "004"], "name": "Justinus Martyr Apol."},
    "TLG2434": {"works": ["003"], "name": "Aelius Dius Hist."},
    "TLG1788": {"works": ["001", "002"], "name": "Phormis Comic."},
    "TLG4236": {"works": ["001"], "name": "Trophonius Rhet. et Soph."},
    "TLG0232": {"works": ["001", "002", "003"], "name": "Archilochus Eleg. et Iamb."},
    "TLG1587": {"works": ["001"], "name": "Philiades Eleg."},
    "TLG3168": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Pseudo-Codinus Hist.",
    },
    "TLG1566": {"works": ["001", "002"], "name": "Parmeno Iamb."},
    "TLG1239": {"works": ["002"], "name": "Domitius Callistratus Hist."},
    "TLG4326": {"works": ["001"], "name": "Pappus Alchem."},
    "TLG2560": {"works": ["002"], "name": "Pythocles Hist."},
    "TLG1692": {"works": ["001", "002", "004", "005"], "name": "Speusippus Phil."},
    "TLG2319": {"works": ["001"], "name": "Apollodorus Phil."},
    "TLG5017": {"works": ["001"], "name": "Scholia In Demosthenem"},
    "TLG0482": {"works": ["001", "002"], "name": "Nicomachus Comic."},
    "TLG0045": {"works": ["001"], "name": "Artaxerxis Epistulae"},
    "TLG1599": {"works": ["001", "002"], "name": "Philo Mech."},
    "TLG1747": {"works": ["001"], "name": "Vita Adam Et Evae"},
    "TLG1729": {"works": ["001", "002"], "name": "Thrasymachus Rhet. et Soph."},
    "TLG1560": {"works": ["001"], "name": "Matthiae Traditiones"},
    "TLG0289": {"works": ["001", "002"], "name": "Ammonius Epigr."},
    "TLG0381": {"works": ["001"], "name": "Lycophronides Lyr."},
    "TLG3142": {"works": ["001", "002"], "name": "Georgius Pachymeres Hist."},
    "TLG1735": {"works": ["002", "003"], "name": "Timon Phil."},
    "TLG1463": {"works": ["001", "002"], "name": "Liber Enoch"},
    "TLG1496": {"works": ["003"], "name": "Memnon Hist."},
    "TLG1585": {"works": ["001"], "name": "Pherecydis Epistula"},
    "TLG0499": {"works": ["001", "002", "003"], "name": "Polyzelus Comic."},
    "TLG2303": {"works": ["001", "002"], "name": "Archelaus Phil."},
    "TLG2115": {
        "works": [
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
        ],
        "name": "Hippolytus Scr. Eccl.",
    },
    "TLG0745": {"works": ["001", "002"], "name": "Hierophilus Phil. et Soph."},
    "TLG2614": {"works": ["001"], "name": "Cleomachus Poeta"},
    "TLG0421": {"works": ["001", "002"], "name": "Aristophon Comic."},
    "TLG1181": {"works": ["001"], "name": "Aristarchus Astron."},
    "TLG0502": {"works": ["001", "002"], "name": "Sophilus Comic."},
    "TLG0426": {"works": ["001", "002", "003", "004", "005"], "name": "Callias Comic."},
    "TLG1127": {"works": ["001"], "name": "Anonyma De Musica Scripta Bellermanniana"},
    "TLG0371": {"works": ["001"], "name": "Diagoras Lyr."},
    "TLG2372": {"works": ["003"], "name": "Euagon Hist."},
    "TLG1286": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
        ],
        "name": "Corpus Hermeticum",
    },
    "TLG0340": {"works": ["001"], "name": "Sositheus Trag."},
    "TLG0897": {"works": ["001"], "name": "Euthydemus Med."},
    "TLG4017": {"works": ["001", "002", "003", "004"], "name": "Syrianus Phil."},
    "TLG2058": {"works": ["001", "002", "003"], "name": "Philostorgius Scr. Eccl."},
    "TLG2216": {"works": ["003"], "name": "Aristippus Hist."},
    "TLG2972": {"works": ["001"], "name": "Anonymi De Terrae Motibus"},
    "TLG1259": {"works": ["001"], "name": "Charondas Nomographus Phil."},
    "TLG2230": {"works": ["001"], "name": "Boïdas Phil."},
    "TLG4374": {"works": ["001"], "name": "Anonymi De Astrologia Dialogus Astrol."},
    "TLG1547": {"works": ["001"], "name": "Oedipodea"},
    "TLG1382": {"works": ["001"], "name": "Fragmentum Teliambicum"},
    "TLG4170": {"works": ["001"], "name": "Vitae Pindari Et Varia De Pindaro"},
    "TLG2770": {"works": ["001"], "name": "Callinicus Biogr."},
    "TLG2004": {"works": ["001"], "name": "Amelii Epistula"},
    "TLG2229": {"works": ["001"], "name": "Xuthus Phil."},
    "TLG2140": {"works": ["001"], "name": "Iamblichus Alchem."},
    "TLG3145": {"works": ["001", "002"], "name": "Joannes Anagnostes Hist. et Poeta"},
    "TLG4237": {"works": ["001"], "name": "Joannes Argyropulus Gramm."},
    "TLG0319": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Critias Eleg., Phil. et Trag.",
    },
    "TLG4020": {"works": ["001", "002", "003"], "name": "Elias Phil."},
    "TLG1748": {"works": ["001"], "name": "Sosigenes Phil."},
    "TLG2241": {"works": ["001"], "name": "Xenophilus Mus. et Phil."},
    "TLG1326": {"works": ["001"], "name": "Dionysius Epic."},
    "TLG0536": {"works": ["002", "003", "004"], "name": "Ephorus Hist."},
    "TLG1845": {"works": ["001"], "name": "Callistratus Trag."},
    "TLG0425": {"works": ["001", "002"], "name": "Bato Comic."},
    "TLG1475": {"works": ["001"], "name": "Maiistas Epic."},
    "TLG0304": {"works": ["001"], "name": "Acta Et Martyrium Apollonii"},
    "TLG4034": {
        "works": ["001", "002", "003", "004", "005", "006", "008", "009"],
        "name": "Michael Phil.",
    },
    "TLG2657": {"works": ["001", "002"], "name": "Martyrium Ignatii"},
    "TLG2043": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Hephaestion Astrol.",
    },
    "TLG0357": {"works": ["001"], "name": "Didymus Scriptor De Mensuris"},
    "TLG1476": {"works": ["001"], "name": "Mamercus Eleg."},
    "TLG1529": {"works": ["003"], "name": "Nicander Gramm."},
    "TLG0296": {"works": ["001"], "name": "Carmina Convivialia (PMG)"},
    "TLG0467": {"works": ["001"], "name": "Timotheus Trag."},
    "TLG1192": {"works": ["001"], "name": "Ariston Phil."},
    "TLG2193": {"works": ["002"], "name": "[Aretades] Hist."},
    "TLG2418": {"works": ["002"], "name": "Archinus Hist."},
    "TLG3074": {
        "works": ["001", "002"],
        "name": "Constantinus Manasses Hist. et Poeta",
    },
    "TLG1724": {"works": ["001"], "name": "Theon Phil."},
    "TLG2630": {"works": ["001", "002"], "name": "Lobo Poeta"},
    "TLG0315": {"works": ["001", "002"], "name": "Sthenelus Trag."},
    "TLG9020": {"works": ["001"], "name": "Stephanus Gramm."},
    "TLG2718": {
        "works": ["001", "002"],
        "name": "Manuel Philes Poeta et Scr. Rerum Nat.",
    },
    "TLG0593": {"works": ["001", "002", "003"], "name": "Gorgias Rhet. et Soph."},
    "TLG2277": {"works": ["002"], "name": "Hypermenes Hist."},
    "TLG2371": {"works": ["001"], "name": "Chronicon Paschale"},
    "TLG0334": {"works": ["001"], "name": "Diogenes Phil. et Trag."},
    "TLG1315": {"works": ["001", "002"], "name": "Dinolochus Comic."},
    "TLG2239": {"works": ["001"], "name": "Pythagoristae (D-K) Phil."},
    "TLG0533": {
        "works": [
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
        ],
        "name": "Callimachus Philol.",
    },
    "TLG2231": {"works": ["001"], "name": "Thrasyalces Phil."},
    "TLG1309": {"works": ["001"], "name": "Dialexeis Δισσοὶ λόγοι"},
    "TLG1154": {"works": ["001"], "name": "Apocalypsis Baruch"},
    "TLG7000": {"works": ["001"], "name": "Anthologia Graeca, AG"},
    "TLG0397": {"works": ["001"], "name": "Pronomus Lyr."},
    "TLG0655": {"works": ["001", "002", "003"], "name": "Parthenius Myth."},
    "TLG1229": {"works": ["001"], "name": "[Boeus] Epic."},
    "TLG0749": {"works": ["001"], "name": "Antyllus Med."},
    "TLG1524": {"works": ["001"], "name": "Naumachius Epic."},
    "TLG1287": {"works": ["001", "002"], "name": "Crantor Phil."},
    "TLG1552": {"works": ["001"], "name": "Oratio Josephi"},
    "TLG0265": {"works": ["001", "002", "003"], "name": "Timocreon Lyr."},
    "TLG1678": {"works": ["003"], "name": "Socrates Hist."},
    "TLG1123": {"works": ["002"], "name": "Andron Hist."},
    "TLG0512": {"works": ["001", "002"], "name": "Theophilus Comic."},
    "TLG0214": {"works": ["001"], "name": "Phanocles Eleg."},
    "TLG0631": {"works": ["001", "002"], "name": "Pittacus Lyr."},
    "TLG2591": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Orion Gramm.",
    },
    "TLG1430": {"works": ["001"], "name": "Hieronymus Phil."},
    "TLG1118": {"works": ["001", "002", "003"], "name": "Pseudo-Dioscorides Med."},
    "TLG4040": {
        "works": [
            "001",
            "011",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
        ],
        "name": "Photius Lexicogr., Scr. Eccl. et Theol.",
    },
    "TLG0597": {"works": ["001"], "name": "Zenodorus Gramm."},
    "TLG0560": {"works": ["001"], "name": "[Longinus] Rhet., Pseudo-Longinus"},
    "TLG4027": {"works": ["001"], "name": "Anonymi In Aristotelis Categorias Phil."},
    "TLG0563": {"works": ["001"], "name": "Maximus Soph."},
    "TLG2148": {"works": ["001", "002"], "name": "Aristodemus Hist."},
    "TLG1145": {"works": ["003"], "name": "Antiochus Hist."},
    "TLG1441": {"works": ["001"], "name": "Iamblichus Scr. Erot."},
    "TLG4134": {"works": ["005"], "name": "Diodorus Scr. Eccl."},
    "TLG0321": {"works": ["001", "002", "003"], "name": "Aeschylus Trag."},
    "TLG1432": {"works": ["001"], "name": "Hipparchus Phil."},
    "TLG2392": {"works": ["003"], "name": "Artemon Hist."},
    "TLG2871": {"works": ["001", "002", "003"], "name": "Joannes Malalas Chronogr."},
    "TLG0413": {"works": ["001", "002"], "name": "Apollodorus Comic."},
    "TLG0084": {"works": ["001", "002", "003"], "name": "Dionysius Perieg."},
    "TLG1734": {"works": ["001", "002"], "name": "Timaeus Phil."},
    "TLG2800": {
        "works": ["002", "003", "004", "005", "006", "007", "008", "012", "018"],
        "name": "Basilius Scr. Eccl.",
    },
    "TLG2807": {"works": ["001"], "name": "Antonius Hagiographus Scr. Eccl."},
    "TLG1052": {"works": ["001", "002", "003"], "name": "Posidonius Phil."},
    "TLG7052": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Anthologiae Graecae Appendix",
    },
    "TLG1398": {"works": ["001"], "name": "Hegesippus Scr. Eccl."},
    "TLG2628": {"works": ["001"], "name": "Idaeus Epic."},
    "TLG2532": {"works": ["002"], "name": "[Hermesianax] Hist."},
    "TLG0500": {"works": ["001", "002", "003"], "name": "Posidippus Comic."},
    "TLG3125": {"works": ["001"], "name": "Theodosius Diaconus Hist. et Poeta"},
    "TLG1670": {"works": ["001"], "name": "Serapion Scr. Eccl."},
    "TLG1495": {"works": ["001", "002", "003"], "name": "Melito Apol."},
    "TLG4331": {"works": ["001"], "name": "Hierotheus Alchem."},
    "TLG1738": {"works": ["001", "002", "003"], "name": "Tragica Adespota"},
    "TLG2589": {"works": ["001", "002"], "name": "Olympiodorus Alchem."},
    "TLG2022": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "065",
            "066",
        ],
        "name": "Gregorius Nazianzenus Theol.",
    },
    "TLG2449": {"works": ["002", "003"], "name": "Timotheus Gramm."},
    "TLG0651": {"works": ["001"], "name": "Antoninus Liberalis Myth."},
    "TLG4287": {"works": ["001"], "name": "Etymologia Alphabeti"},
    "TLG2679": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009", "010"],
        "name": "Testamentum Salomonis",
    },
    "TLG2385": {"works": ["003"], "name": "Polycritus Hist."},
    "TLG0364": {"works": ["001"], "name": "Danaïs vel Danaïdes"},
    "TLG0587": {"works": ["001"], "name": "Sotion Paradox."},
    "TLG9004": {
        "works": ["001"],
        "name": "Anonymi In Aristotelis Librum Alterum Analyticorum Posteriorum Commentarium",
    },
    "TLG2336": {"works": ["002"], "name": "Hereas Hist."},
    "TLG1439": {"works": ["002"], "name": "Hermarchus Phil."},
    "TLG1366": {"works": ["001", "002"], "name": "Evangelium Bartholomaei"},
    "TLG1021": {"works": ["001"], "name": "Meropis"},
    "TLG0410": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Antiphanes Comic.",
    },
    "TLG2653": {"works": ["001"], "name": "Erycius Poeta"},
    "TLG0358": {"works": ["001", "002", "003", "004"], "name": "Nicomachus Math."},
    "TLG0255": {"works": ["001", "002", "003"], "name": "Mimnermus Eleg."},
    "TLG0477": {"works": ["001", "002", "003"], "name": "Myrtilus Comic."},
    "TLG1549": {"works": ["001"], "name": "Onatas Phil."},
    "TLG9006": {"works": ["001", "002", "003", "004"], "name": "Gregorius Paroemiogr."},
    "TLG4345": {"works": ["001"], "name": "Menecrates Hist."},
    "TLG2641": {"works": ["001"], "name": "Priscus Epic."},
    "TLG0594": {"works": ["001", "002"], "name": "Alexander Rhet. et Soph."},
    "TLG0616": {"works": ["001", "002", "003", "004"], "name": "Polyaenus Rhet."},
    "TLG2617": {"works": ["001"], "name": "Demetrius Poeta"},
    "TLG1650": {"works": ["001"], "name": "Pytheas Perieg."},
    "TLG2015": {"works": ["001"], "name": "Testamentum XL Martyrum"},
    "TLG1426": {"works": ["001"], "name": "Herodes Atticus Soph."},
    "TLG0722": {
        "works": ["001", "002", "003", "004", "005", "010"],
        "name": "Oribasius Med.",
    },
    "TLG2623": {"works": ["001"], "name": "Euanthes Epic."},
    "TLG2242": {"works": ["001"], "name": "Echecrates Phil."},
    "TLG0517": {"works": ["001", "002"], "name": "Timotheus Comic."},
    "TLG5003": {
        "works": [
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
        ],
        "name": "Erotica Adespota",
    },
    "TLG1848": {"works": ["001"], "name": "Meletus Junior Trag."},
    "TLG2053": {"works": ["001", "002"], "name": "Paulus Astrol."},
    "TLG1391": {"works": ["001", "002", "003", "004"], "name": "Hegemon Epic."},
    "TLG1200": {"works": ["003"], "name": "Asclepiades Myth."},
    "TLG1252": {"works": ["001", "002"], "name": "Certamen Homeri Et Hesiodi"},
    "TLG0605": {"works": ["001", "002"], "name": "Polybius Rhet."},
    "TLG1242": {"works": ["001"], "name": "Canon Librorum"},
    "TLG0374": {"works": ["001", "002"], "name": "Licymnius Lyr."},
    "TLG1433": {"works": ["001"], "name": "Hipparchus Epigr."},
    "TLG4028": {"works": ["001", "002"], "name": "Stephanus Gramm."},
    "TLG0525": {"works": ["001"], "name": "Pausanias Perieg."},
    "TLG0352": {"works": ["001"], "name": "Isidorus Trag."},
    "TLG1840": {"works": ["001"], "name": "Euripides II Trag."},
    "TLG4290": {"works": ["001"], "name": "Lexicon Artis Grammaticae"},
    "TLG0538": {"works": ["001", "002", "003"], "name": "Hecataeus Hist."},
    "TLG0281": {"works": ["001"], "name": "Marcellus Poet. Med."},
    "TLG0634": {"works": ["001"], "name": "Xenocrates Phil."},
    "TLG2055": {"works": ["001", "002"], "name": "Serenus Geom."},
    "TLG1174": {"works": ["002"], "name": "Archemachus Hist."},
    "TLG1511": {"works": ["001"], "name": "Mimnermus Trag."},
    "TLG3143": {"works": ["001"], "name": "Georgius Sphrantzes Hist."},
    "TLG0028": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009"],
        "name": "Antiphon Orat.",
    },
    "TLG2118": {"works": ["001"], "name": "Gryllus"},
    "TLG2642": {"works": ["002", "004"], "name": "Astrampsychus Magus Onir."},
    "TLG2010": {"works": ["001"], "name": "Martyrium Dasii"},
    "TLG0620": {"works": ["001", "002"], "name": "Archytas Phil."},
    "TLG1881": {
        "works": ["001", "002", "003"],
        "name": "Dionysius Scytobrachion Gramm.",
    },
    "TLG0732": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
        ],
        "name": "Alexander Phil.",
    },
    "TLG0329": {"works": ["001"], "name": "Theodectas Trag."},
    "TLG9008": {"works": ["001"], "name": "Macarius Chrysocephalus Paroemiogr."},
    "TLG1490": {"works": ["001"], "name": "Megillus Phil."},
    "TLG0001": {"works": ["001", "002", "003"], "name": "Apollonius Rhodius Epic."},
    "TLG4318": {"works": ["001"], "name": "Vita Sophoclis"},
    "TLG4311": {"works": ["001", "002"], "name": "Etymologicum Symeonis"},
    "TLG0247": {"works": ["001"], "name": "Dionysius II Eleg."},
    "TLG2116": {"works": ["001"], "name": "Arcadius Gramm."},
    "TLG0488": {"works": ["001", "002"], "name": "Philemon Junior Comic."},
    "TLG0725": {"works": ["001", "002"], "name": "Anaximander Phil."},
    "TLG0529": {"works": ["001", "002"], "name": "Arius Didymus Doxogr."},
    "TLG1205": {"works": ["001", "002"], "name": "Athenagoras Apol."},
    "TLG5019": {"works": ["001", "002"], "name": "Scholia In Dionysium Periegetam"},
    "TLG0486": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Pherecrates Comic.",
    },
    "TLG3188": {"works": ["001", "002", "003"], "name": "Joannes Actuarius Med."},
    "TLG2547": {"works": ["003"], "name": "Antigonus"},
    "TLG0052": {"works": ["001"], "name": "Menippus Phil."},
    "TLG1314": {"works": ["003", "004"], "name": "Dinias Hist."},
    "TLG0451": {"works": ["001", "002"], "name": "Epicrates Comic."},
    "TLG1801": {"works": ["001", "002"], "name": "Parodica Anonyma"},
    "TLG0528": {"works": ["001", "002"], "name": "Aëtius Doxogr."},
    "TLG1634": {"works": ["001", "002"], "name": "Prodicus Soph."},
    "TLG2217": {"works": ["002"], "name": "Nicias Hist."},
    "TLG1666": {"works": ["001"], "name": "Sententiae Sexti"},
    "TLG1264": {
        "works": ["001", "002", "003", "004", "005", "008"],
        "name": "Chrysippus Phil.",
    },
    "TLG2237": {"works": ["001"], "name": "Theodorus Math."},
    "TLG1146": {"works": ["001"], "name": "Antipater Phil."},
    "TLG0317": {"works": ["001", "002"], "name": "Acta Joannis"},
    "TLG0206": {"works": ["001"], "name": "Theocles Lyr."},
    "TLG1257": {"works": ["002"], "name": "Charinus Choliamb."},
    "TLG5028": {"works": ["001"], "name": "Scholia In Isocratem"},
    "TLG1504": {"works": ["003"], "name": "Menelaus Epic."},
    "TLG1787": {"works": ["001", "002"], "name": "[Menippus] Comic."},
    "TLG0216": {"works": ["001", "002", "003"], "name": "Alexander Lyr. et Trag."},
    "TLG0511": {"works": ["001", "002", "003"], "name": "Theognetus Comic."},
    "TLG1365": {
        "works": ["001", "002", "003", "004"],
        "name": "Melampus Scriptor De Divinatione",
    },
    "TLG0535": {"works": ["001", "002", "003"], "name": "Demades Orat. et Rhet."},
    "TLG0585": {
        "works": ["001", "002", "003"],
        "name": "Publius Aelius Phlegon Paradox.",
    },
    "TLG4334": {"works": ["001", "002"], "name": "[Isis Prophetissa] Alchem."},
    "TLG0396": {"works": ["001"], "name": "Euphanes Comic."},
    "TLG1298": {"works": ["001"], "name": "Demetrii Phalerei Epistula"},
    "TLG2112": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
        ],
        "name": "Amphilochius Scr. Eccl.",
    },
    "TLG0564": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Rufus Med.",
    },
    "TLG4390": {"works": ["001"], "name": "Democles Hist."},
    "TLG1703": {"works": ["001", "002"], "name": "Teucer Astrol."},
    "TLG1228": {"works": ["001"], "name": "[Boeo] Epic."},
    "TLG0341": {"works": ["001", "002"], "name": "Lycophron Trag."},
    "TLG1567": {"works": ["001"], "name": "Parrhasius Epigr."},
    "TLG2173": {"works": ["002"], "name": "Antileon Hist."},
    "TLG1165": {"works": ["001"], "name": "Apollodorus Mech."},
    "TLG1591": {"works": ["003"], "name": "Philistus Hist."},
    "TLG2693": {"works": ["001"], "name": "Ptolemaeus III Euergetes I Epigr."},
    "TLG4101": {"works": ["001"], "name": "Etymologicum Parvum"},
    "TLG4300": {"works": ["001"], "name": "Lexicon Sabbaiticum"},
    "TLG0238": {"works": ["001"], "name": "Ananius Iamb."},
    "TLG0037": {"works": ["001"], "name": "Anacharsidis Epistulae"},
    "TLG0657": {"works": ["001"], "name": "Crateuas Med."},
    "TLG2029": {"works": ["001"], "name": "Anonymi Geographia In Sphaera Intelligenda"},
    "TLG0098": {"works": ["001"], "name": "Zenobius Sophista Paroemiogr."},
    "TLG2060": {"works": ["001", "002"], "name": "Asterius Scr. Eccl."},
    "TLG1414": {"works": ["001"], "name": "Heraclitus Phil."},
    "TLG1546": {"works": ["001"], "name": "Oechaliae Halosis"},
    "TLG2036": {"works": ["001"], "name": "Dexippus Phil."},
    "TLG0555": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Clemens Alexandrinus Theol.",
    },
    "TLG0417": {"works": ["001", "002", "003", "004"], "name": "Archippus Comic."},
    "TLG0097": {"works": ["001", "002"], "name": "Diogenianus Gramm."},
    "TLG1274": {"works": ["001", "002"], "name": "Cleobulus Epigr. et Lyr."},
    "TLG4293": {"works": ["001"], "name": "Fragmentum Lexici Graeci"},
    "TLG1594": {"works": ["002"], "name": "Philo Judaeus Senior Epic."},
    "TLG0203": {"works": ["001"], "name": "Limenius Lyr."},
    "TLG1450": {"works": ["003", "004"], "name": "Ister Hist."},
    "TLG1705": {"works": ["001", "002", "003"], "name": "Thales Phil."},
    "TLG1479": {"works": ["001"], "name": "Marci Aurelii Epistula"},
    "TLG2398": {"works": ["001"], "name": "Basilides Phil."},
    "TLG1344": {"works": ["001"], "name": "Epica Adespota (CA)"},
    "TLG1700": {"works": ["001"], "name": "Testamenta XII Patriarcharum"},
    "TLG2032": {"works": ["001", "002"], "name": "Pappus Math."},
    "TLG0012": {"works": ["001", "002", "003"], "name": "Homerus Epic., Homer"},
    "TLG0127": {"works": ["001"], "name": "Aulus Licinius Archias Epigr."},
    "TLG4325": {"works": ["001", "002"], "name": "[Hermes] Alchem."},
    "TLG2007": {"works": ["001"], "name": "Martyrium Potamiaenae Et Basilidis"},
    "TLG0504": {"works": ["001", "002"], "name": "Sosipater Comic."},
    "TLG4015": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "017",
            "018",
        ],
        "name": "Joannes Philoponus Phil.",
    },
    "TLG0322": {"works": ["001"], "name": "Dicaeogenes Trag."},
    "TLG1345": {"works": ["001", "002"], "name": "Epica Incerta (CA)"},
    "TLG1377": {"works": ["003"], "name": "Favorinus Phil. et Rhet."},
    "TLG2330": {"works": ["003"], "name": "Scamon Hist."},
    "TLG1814": {"works": ["001"], "name": "Ptolemais Phil."},
    "TLG0246": {"works": ["001"], "name": "Dionysius Chalcus Eleg."},
    "TLG0416": {"works": ["001", "002"], "name": "Archedicus Comic."},
    "TLG1817": {"works": ["001"], "name": "Fragmenta Anonyma (PsVTGr)"},
    "TLG2341": {"works": ["003"], "name": "Aristocritus Hist."},
    "TLG1276": {"works": ["003"], "name": "Clidemus Hist."},
    "TLG1907": {"works": ["003"], "name": "Cratippus Hist."},
    "TLG0752": {"works": ["001", "002", "003", "005"], "name": "Eutecnius Soph."},
    "TLG1258": {"works": ["003"], "name": "Charon Hist."},
    "TLG0707": {"works": ["002"], "name": "Alexis Hist."},
    "TLG3159": {"works": ["001"], "name": "Barlaam Math., Theol. et Epist."},
    "TLG1608": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Phrynichus Attic.",
    },
    "TLG1588": {"works": ["001"], "name": "Philicus Lyr."},
    "TLG0023": {"works": ["001"], "name": "Oppianus Epic."},
    "TLG4394": {"works": ["001"], "name": "Joannes Antiochenus Hist."},
    "TLG1783": {"works": ["001", "002"], "name": "Callicrates Comic."},
    "TLG1375": {"works": ["001"], "name": "Evangelium Thomae"},
    "TLG1690": {"works": ["001"], "name": "Sotadea"},
    "TLG0261": {"works": ["001", "002", "003", "004", "005"], "name": "Simonides Lyr."},
    "TLG0096": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
        ],
        "name": "Aesopus Scr. Fab. et Aesopica",
    },
    "TLG2892": {
        "works": ["001", "002", "008", "049", "097", "110", "111", "112", "113", "114"],
        "name": "Maximus Confessor Theol.",
    },
    "TLG0523": {"works": ["001", "002", "003"], "name": "Menecrates Comic."},
    "TLG0509": {"works": ["001"], "name": "Myia Phil."},
    "TLG0348": {"works": ["001"], "name": "Biotus Trag."},
    "TLG1392": {"works": ["001"], "name": "Hegesander Hist."},
    "TLG1186": {"works": ["001"], "name": "Aristobulus Judaeus Phil."},
    "TLG2127": {"works": ["001", "002"], "name": "Troilus Soph."},
    "TLG0006": {
        "works": [
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
        ],
        "name": "Euripides Trag.",
    },
    "TLG1917": {"works": ["003"], "name": "Demetrius Hist."},
    "TLG2282": {"works": ["002"], "name": "Melisseus Hist."},
    "TLG5027": {"works": ["001"], "name": "Scholia In Iamblichum Philosophum"},
    "TLG0708": {"works": ["001", "002"], "name": "Ammonius Gramm."},
    "TLG0026": {"works": ["001", "002", "003", "004"], "name": "Aeschines Orat."},
    "TLG2017": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "046",
            "047",
            "048",
            "049",
            "051",
            "052",
            "053",
            "055",
            "056",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "080",
            "081",
            "082",
            "083",
            "084",
        ],
        "name": "Gregorius Nyssenus Theol.",
    },
    "TLG0728": {
        "works": ["001"],
        "name": "Theophilus Protospatharius, Damascius et Stephanus Atheniensis Med.",
    },
    "TLG1633": {"works": ["001"], "name": "Praxiteles Epigr."},
    "TLG1189": {"works": ["003"], "name": "Aristocrates Hist."},
    "TLG3069": {"works": ["001"], "name": "Leo Diaconus Hist."},
    "TLG1194": {"works": ["001", "002", "003", "004"], "name": "Aristonicus Gramm."},
    "TLG0201": {"works": ["001"], "name": "Isyllus Lyr."},
    "TLG1250": {"works": ["001"], "name": "Cercidas Iamb."},
    "TLG2625": {"works": ["001"], "name": "Herodicus Gramm."},
    "TLG0475": {"works": ["001", "002"], "name": "Metagenes Comic."},
    "TLG2023": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Iamblichus Phil.",
    },
    "TLG1525": {"works": ["003"], "name": "Neanthes Hist."},
    "TLG1462": {"works": ["001"], "name": "Liber Eldad Et Modad"},
    "TLG1815": {"works": ["001"], "name": "Sappho et Alcaeus Lyr."},
    "TLG2426": {"works": ["002"], "name": "Hermaeus Hist."},
    "TLG1461": {"works": ["001", "002"], "name": "Leucippus Phil."},
    "TLG2051": {"works": ["001", "002", "003"], "name": "Himerius Soph."},
    "TLG0696": {"works": ["002"], "name": "Alcmaeonis"},
    "TLG0406": {"works": ["001", "002"], "name": "Anaxilas Comic."},
    "TLG0318": {"works": ["001"], "name": "Agathon Trag."},
    "TLG2305": {"works": ["001"], "name": "Clidemus Phil."},
    "TLG0740": {"works": ["001"], "name": "Jusjurandum Medicum"},
    "TLG4014": {"works": ["001"], "name": "Priscianus Phil."},
    "TLG9003": {"works": ["001"], "name": "Anonymus Lexicographus Lexicogr."},
    "TLG0069": {"works": ["001"], "name": "Dionysius Geogr."},
    "TLG1802": {"works": ["002"], "name": "Homerica"},
    "TLG4282": {"works": ["001"], "name": "Anonymus Manichaeus Biogr."},
    "TLG1488": {"works": ["001"], "name": "Maximus Theol."},
    "TLG0349": {"works": ["001"], "name": "Demonax Trag."},
    "TLG4301": {"works": ["001"], "name": "Lexicon Rhetoricum Cantabrigiense"},
    "TLG0541": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
        ],
        "name": "Menander Comic.",
    },
    "TLG4239": {"works": ["001"], "name": "Severus Soph."},
    "TLG1271": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
        ],
        "name": "Clemens Romanus Theol. et Clementina",
    },
    "TLG0013": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
        ],
        "name": "Hymni Homerici, Homeric Hymns",
    },
    "TLG4093": {
        "works": ["001", "002", "005", "007", "008", "009", "010", "013"],
        "name": "Georgius Choeroboscus Gramm.",
    },
    "TLG1663": {"works": ["003"], "name": "Semus Gramm."},
    "TLG1161": {"works": ["001"], "name": "Apocryphon Ezechiel"},
    "TLG2002": {"works": ["001"], "name": "Anonymus Seguerianus Rhet."},
    "TLG1245": {"works": ["001"], "name": "Carystius Hist."},
    "TLG0263": {"works": ["001"], "name": "Solon Nomographus et Poeta"},
    "TLG0453": {"works": ["001", "002", "003"], "name": "Epilycus Comic."},
    "TLG0004": {"works": ["001", "002"], "name": "Diogenes Laertius Biogr."},
    "TLG2204": {"works": ["002"], "name": "Autocrates Hist."},
    "TLG2349": {"works": ["002"], "name": "[Pyrander] Hist."},
    "TLG4174": {"works": ["001", "002"], "name": "Paraphrases In Dionysium Periegetam"},
    "TLG0003": {"works": ["001", "002"], "name": "Thucydides Hist."},
    "TLG2355": {"works": ["001"], "name": "Xeniades Soph."},
    "TLG2030": {"works": ["001"], "name": "Geographica Adespota (GGM)"},
    "TLG2594": {"works": ["001"], "name": "Phillis Hist."},
    "TLG2039": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Diophantus Math.",
    },
    "TLG4036": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "020",
            "021",
            "023",
        ],
        "name": "Proclus Phil.",
    },
    "TLG0398": {"works": ["001", "002"], "name": "Simylus Comic."},
    "TLG1361": {"works": ["001"], "name": "Eumedes Comic."},
    "TLG1166": {"works": ["001"], "name": "Apollodorus Phil."},
    "TLG0368": {"works": ["001"], "name": "Cydias Lyr."},
    "TLG0372": {"works": ["001"], "name": "Praxilla Lyr."},
    "TLG0035": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Moschus Bucol.",
    },
    "TLG2596": {"works": ["001"], "name": "Phoebammon Soph."},
    "TLG1627": {"works": ["002"], "name": "Polycrates Hist."},
    "TLG0215": {"works": ["001", "002"], "name": "Antagoras Epic."},
    "TLG2621": {"works": ["001"], "name": "Diophilus vel Diophila Poeta"},
    "TLG2571": {"works": ["001"], "name": "Hierocles Phil."},
    "TLG1613": {"works": ["001"], "name": "Pittaci Epistula"},
    "TLG2182": {"works": ["003"], "name": "Staphylus Hist."},
    "TLG1890": {"works": ["001"], "name": "Moderatus Phil."},
    "TLG1429": {"works": ["001", "002", "003"], "name": "Hierocles Phil."},
    "TLG0663": {"works": ["001"], "name": "Praecepta Salubria"},
    "TLG2577": {"works": ["001"], "name": "Anatolius Math. et Phil."},
    "TLG0330": {"works": ["001", "002"], "name": "Dionysius I Trag."},
    "TLG1254": {"works": ["003"], "name": "Charax Hist."},
    "TLG2543": {"works": ["003"], "name": "Lucius Cincius Alimentus Hist."},
    "TLG1908": {"works": ["003"], "name": "Daimachus Hist."},
    "TLG0580": {"works": ["001"], "name": "Paradoxographus Florentinus"},
    "TLG2649": {"works": ["001"], "name": "Amyntas Epigr."},
    "TLG1569": {"works": ["001"], "name": "Pausanias Attic."},
    "TLG0227": {"works": ["001"], "name": "Anonymi Curetum Hymnus"},
    "TLG1712": {"works": ["001"], "name": "Thebaïs"},
    "TLG2624": {"works": ["001"], "name": "Hermias Poeta"},
    "TLG2648": {
        "works": ["001", "002", "003", "004"],
        "name": "Adespota Papyracea (SH)",
    },
    "TLG4088": {"works": ["003", "005"], "name": "Anthemius Math. et Mech."},
    "TLG0459": {"works": ["001", "002"], "name": "Eunicus Comic."},
    "TLG1784": {"works": ["001", "002"], "name": "Heraclitus Comic."},
    "TLG1278": {"works": ["001"], "name": "Clitarchus Gnom."},
    "TLG4201": {"works": ["001"], "name": "Joannes Chortasmenus Phil."},
    "TLG4242": {"works": ["001"], "name": "Cyrus Rhet."},
    "TLG0325": {"works": ["001"], "name": "Astydamas Trag."},
    "TLG5015": {"works": ["001", "002", "003"], "name": "Scholia In Aristotelem"},
    "TLG4138": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "080",
            "081",
            "082",
            "083",
            "084",
            "085",
            "086",
            "087",
            "088",
            "089",
            "090",
            "091",
            "092",
            "093",
            "094",
            "095",
            "096",
            "097",
            "098",
            "099",
            "100",
            "101",
            "102",
            "103",
            "104",
            "105",
            "106",
            "107",
            "108",
            "109",
            "110",
            "111",
            "112",
            "113",
            "114",
            "115",
            "116",
            "117",
            "118",
            "119",
            "120",
            "121",
            "122",
            "123",
            "124",
            "125",
            "126",
            "127",
            "128",
            "129",
            "130",
            "131",
            "132",
            "133",
            "134",
            "135",
            "136",
            "137",
            "138",
            "139",
            "140",
            "141",
            "142",
            "143",
            "144",
            "145",
            "146",
            "147",
            "148",
            "149",
            "150",
            "151",
            "152",
            "153",
            "154",
            "155",
            "156",
            "157",
        ],
        "name": "Ephraem Syrus Theol.",
    },
    "TLG1512": {"works": ["002"], "name": "Minyas"},
    "TLG2555": {"works": ["002"], "name": "Agesilaus Hist."},
    "TLG0299": {"works": ["001", "002"], "name": "Terpander Lyr."},
    "TLG0367": {"works": ["001"], "name": "Tynnichus Lyr."},
    "TLG1871": {"works": ["003"], "name": "Bion Hist."},
    "TLG0277": {"works": ["001"], "name": "Monodia"},
    "TLG2357": {"works": ["002"], "name": "Gorgon Hist."},
    "TLG1230": {"works": ["001", "002"], "name": "Brotinus Phil."},
    "TLG1170": {"works": ["003"], "name": "Apollonius Hist."},
    "TLG1559": {"works": ["001"], "name": "Bucolicum"},
    "TLG0516": {"works": ["001", "002", "003"], "name": "Timostratus Comic."},
    "TLG0463": {"works": ["001", "002", "003"], "name": "Hegemon Parodius"},
    "TLG2798": {
        "works": ["001", "002", "004", "005", "006"],
        "name": "Pseudo-Dionysius Areopagita Scr. Eccl. et Theol.",
    },
    "TLG1390": {"works": ["001", "002", "003", "004"], "name": "Hecataeus Hist."},
    "TLG0507": {"works": ["001", "002", "003"], "name": "Straton Comic."},
    "TLG2236": {"works": ["001"], "name": "Eutropius Hist."},
    "TLG3139": {"works": ["001"], "name": "Laonicus Chalcocondyles Hist."},
    "TLG0457": {"works": ["001", "002"], "name": "Eubulides Comic."},
    "TLG2545": {"works": ["003"], "name": "Gaius Acilius Hist. et Phil."},
    "TLG1780": {"works": ["001", "002"], "name": "Alcimenes Comic."},
    "TLG9010": {"works": ["001", "002"], "name": "Suda, Suidas"},
    "TLG1203": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Paeanes (CA)",
    },
    "TLG4096": {"works": ["001"], "name": "Dositheus Magister Gramm."},
    "TLG1400": {"works": ["003"], "name": "Heliodorus Perieg."},
    "TLG5038": {"works": ["001"], "name": "Scholia In Theocritum"},
    "TLG1485": {"works": ["001"], "name": "Martyrium Ptolemaei Et Lucii"},
    "TLG4032": {
        "works": ["001"],
        "name": "Anonymi In Aristotelis Librum Primum Analyticorum Posteriorum Commentarium",
    },
    "TLG2694": {"works": ["001"], "name": "Sostratus Poeta"},
    "TLG2278": {"works": ["002"], "name": "Phanodicus Hist."},
    "TLG0186": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Marcus Cornelius Fronto Rhet.",
    },
    "TLG1572": {"works": ["001"], "name": "Perictione Phil."},
    "TLG0064": {"works": ["001"], "name": "Periplus Hannonis"},
    "TLG3027": {
        "works": ["001", "002", "003", "004"],
        "name": "Joannes Doxapatres Rhet.",
    },
    "TLG0514": {"works": ["001", "002", "003"], "name": "Thugenides Comic."},
    "TLG0217": {"works": ["001"], "name": "Anacreon Junior Eleg."},
    "TLG1262": {"works": ["001", "002"], "name": "Choerilus Epic."},
    "TLG3186": {"works": ["001"], "name": "Anonymus Dialogus Cum Judaeis"},
    "TLG3156": {"works": ["001"], "name": "Anonymi Exegesis In Hesiodi Theogoniam"},
    "TLG1583": {"works": ["003"], "name": "Phanodemus Hist."},
    "TLG0065": {"works": ["001", "002", "003"], "name": "Scylax Perieg."},
    "TLG1915": {"works": ["003"], "name": "Eudoxus Hist."},
    "TLG2548": {"works": ["002"], "name": "Promathion Hist."},
    "TLG0391": {"works": ["001"], "name": "Acta Scillitanorum Martyrum"},
    "TLG1297": {"works": ["001"], "name": "Damippus Phil."},
    "TLG1413": {"works": ["001"], "name": "Heraclitus Paradox."},
    "TLG0456": {"works": ["001", "002"], "name": "Euangelus Comic."},
    "TLG1219": {"works": ["003"], "name": "Bato Hist. et Rhet."},
    "TLG3040": {"works": ["001"], "name": "Josephus Genesius Hist."},
    "TLG1128": {
        "works": ["001"],
        "name": "Anonymi Commentarius In Platonis Theaetetum",
    },
    "TLG2646": {"works": ["001"], "name": "Fragmenta Adespota (SH)"},
    "TLG2860": {"works": ["001", "002", "003"], "name": "Alexander Scr. Eccl."},
    "TLG4165": {
        "works": ["001"],
        "name": "Anonymi In Aristotelis Librum De Interpretatione Phil.",
    },
    "TLG2934": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "018",
            "019",
            "021",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "059",
            "060",
            "061",
            "062",
            "064",
            "066",
            "067",
            "068",
        ],
        "name": "Joannes Damascenus Scr. Eccl. et Theol., John of Damascus",
    },
    "TLG1256": {"works": ["001", "002"], "name": "Chares Gnom."},
    "TLG1167": {"works": ["001"], "name": "Apollonius Biogr."},
    "TLG0392": {"works": ["001", "002", "003", "004"], "name": "Acusilaus Hist."},
    "TLG0208": {"works": ["001", "002"], "name": "Dosiadas Lyr."},
    "TLG1094": {"works": ["001"], "name": "Theodorides Trag."},
    "TLG4347": {"works": ["001"], "name": "Andron Hist."},
    "TLG2168": {"works": ["001"], "name": "Apollophanes Phil."},
    "TLG2234": {"works": ["001"], "name": "Oenopides Phil."},
    "TLG0610": {"works": ["001"], "name": "Alcidamas Rhet."},
    "TLG0652": {"works": ["001"], "name": "Philostratus Junior Soph."},
    "TLG0063": {
        "works": ["001", "002", "003", "004"],
        "name": "Dionysius Thrax Gramm.",
    },
    "TLG2622": {"works": ["001"], "name": "Dorieus Poeta"},
    "TLG2333": {"works": ["002", "003"], "name": "Possis Hist."},
    "TLG2111": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Palladius Scr. Eccl.",
    },
    "TLG0075": {"works": ["001"], "name": "Periplus Ponti Euxini"},
    "TLG0047": {"works": ["001"], "name": "Pausaniae I Et Xerxis Epistulae"},
    "TLG4099": {"works": ["001"], "name": "Etymologicum Magnum"},
    "TLG2626": {"works": ["001"], "name": "Hipparchus Parodius"},
    "TLG0422": {"works": ["001", "002"], "name": "Athenio Comic."},
    "TLG3181": {"works": ["001"], "name": "Nicephorus II Phocas Imperator Tact."},
    "TLG0578": {"works": ["003"], "name": "Nymphodorus Hist."},
    "TLG5021": {"works": ["001"], "name": "Scholia In Diophantum"},
    "TLG2265": {"works": ["002"], "name": "Diodorus Perieg."},
    "TLG2391": {"works": ["003"], "name": "Hippostratus Hist."},
    "TLG0737": {"works": ["001"], "name": "Julianus Scriptor Legis De Medicis"},
    "TLG1711": {"works": ["001"], "name": "Thearidas Phil."},
    "TLG0331": {"works": ["001"], "name": "Polyidus Trag."},
    "TLG4307": {"works": ["001", "002", "003"], "name": "Lexica Synonymica"},
    "TLG0687": {"works": ["002"], "name": "Agaclytus Hist."},
    "TLG0379": {"works": ["001", "002"], "name": "Philoxenus Lyr."},
    "TLG0734": {"works": ["001"], "name": "Lucas Apostolus Med."},
    "TLG3141": {
        "works": [
            "002",
            "003",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
        ],
        "name": "Georgius Acropolites Hist.",
    },
    "TLG0278": {"works": ["001"], "name": "Praelusio Mimi"},
    "TLG1368": {"works": ["001"], "name": "Evangelium Ebionitum"},
    "TLG3158": {"works": ["001"], "name": "Theodorus Epist."},
    "TLG1505": {"works": ["001"], "name": "Menesthenes Hist."},
    "TLG1506": {"works": ["002"], "name": "Menodotus Hist."},
    "TLG2062": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "080",
            "081",
            "082",
            "083",
            "084",
            "085",
            "086",
            "087",
            "088",
            "089",
            "090",
            "091",
            "092",
            "093",
            "094",
            "095",
            "096",
            "097",
            "098",
            "099",
            "100",
            "101",
            "103",
            "104",
            "105",
            "106",
            "107",
            "108",
            "110",
            "111",
            "112",
            "113",
            "114",
            "115",
            "116",
            "117",
            "118",
            "119",
            "120",
            "121",
            "122",
            "123",
            "124",
            "125",
            "126",
            "127",
            "128",
            "129",
            "130",
            "131",
            "132",
            "133",
            "134",
            "135",
            "136",
            "137",
            "138",
            "139",
            "140",
            "141",
            "142",
            "143",
            "144",
            "145",
            "148",
            "149",
            "150",
            "151",
            "152",
            "153",
            "154",
            "155",
            "156",
            "157",
            "158",
            "159",
            "160",
            "161",
            "162",
            "163",
            "164",
            "165",
            "166",
            "167",
            "168",
            "169",
            "170",
            "171",
            "172",
            "173",
            "174",
            "175",
            "176",
            "177",
            "178",
            "179",
            "180",
            "181",
            "182",
            "184",
            "185",
            "186",
            "187",
            "196",
            "197",
            "198",
            "199",
            "200",
            "201",
            "202",
            "203",
            "204",
            "205",
            "206",
            "207",
            "208",
            "209",
            "210",
            "211",
            "212",
            "213",
            "214",
            "216",
            "217",
            "219",
            "220",
            "221",
            "224",
            "225",
            "226",
            "227",
            "228",
            "229",
            "230",
            "231",
            "232",
            "233",
            "234",
            "235",
            "237",
            "238",
            "239",
            "240",
            "241",
            "242",
            "243",
            "244",
            "245",
            "247",
            "248",
            "249",
            "250",
            "251",
            "252",
            "253",
            "254",
            "255",
            "256",
            "257",
            "258",
            "259",
            "260",
            "261",
            "262",
            "263",
            "264",
            "265",
            "266",
            "267",
            "268",
            "269",
            "270",
            "271",
            "272",
            "273",
            "274",
            "275",
            "276",
            "277",
            "278",
            "279",
            "280",
            "281",
            "282",
            "283",
            "284",
            "285",
            "286",
            "287",
            "288",
            "289",
            "290",
            "291",
            "292",
            "293",
            "294",
            "295",
            "296",
            "297",
            "298",
            "299",
            "300",
            "301",
            "302",
            "303",
            "304",
            "305",
            "306",
            "307",
            "308",
            "309",
            "310",
            "311",
            "312",
            "313",
            "314",
            "315",
            "316",
            "317",
            "318",
            "319",
            "320",
            "321",
            "322",
            "323",
            "324",
            "325",
            "326",
            "327",
            "328",
            "329",
            "330",
            "331",
            "332",
            "333",
            "334",
            "335",
            "336",
            "337",
            "338",
            "344",
            "345",
            "346",
            "347",
            "348",
            "349",
            "350",
            "351",
            "352",
            "353",
            "354",
            "355",
            "356",
            "357",
            "358",
            "359",
            "360",
            "361",
            "362",
            "363",
            "364",
            "365",
            "366",
            "367",
            "368",
            "369",
            "370",
            "371",
            "373",
            "374",
            "376",
            "378",
            "379",
            "380",
            "381",
            "382",
            "384",
            "402",
            "413",
            "414",
            "415",
            "417",
            "418",
            "419",
            "420",
            "421",
            "423",
            "424",
            "425",
            "426",
            "427",
            "428",
            "429",
            "430",
            "432",
            "433",
            "434",
            "435",
            "436",
            "437",
            "438",
            "442",
            "443",
            "444",
            "445",
            "446",
            "452",
            "463",
            "473",
            "484",
            "486",
            "488",
            "489",
            "491",
            "492",
            "493",
            "494",
            "495",
            "496",
            "497",
            "498",
            "499",
            "500",
            "502",
            "505",
        ],
        "name": "Joannes Chrysostomus Scr. Eccl., John Chrysostom",
    },
    "TLG0211": {"works": ["001", "002"], "name": "Simias Gramm."},
    "TLG2444": {"works": ["001"], "name": "Lycophron Soph."},
    "TLG0531": {"works": ["001"], "name": "Hermias Apol."},
    "TLG0714": {"works": ["001", "002"], "name": "Anaxarchus Phil."},
    "TLG0666": {"works": ["001"], "name": "Adrianus Rhet. et Soph."},
    "TLG2995": {"works": ["001", "002", "003"], "name": "Orus Gramm."},
    "TLG4001": {"works": ["001", "002"], "name": "Aeneas Phil. et Rhet."},
    "TLG0408": {"works": ["001", "002"], "name": "Comica Adespota (CAF)"},
    "TLG2189": {"works": ["001", "002"], "name": "Callinicus Soph."},
    "TLG4090": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "026",
            "027",
            "029",
            "030",
            "031",
            "032",
            "095",
            "096",
            "097",
            "098",
            "099",
            "100",
            "101",
            "102",
            "103",
            "104",
            "105",
            "106",
            "107",
            "108",
            "109",
            "110",
            "112",
            "114",
            "115",
            "116",
            "117",
            "118",
            "119",
            "120",
            "121",
            "122",
            "123",
            "124",
            "125",
            "126",
            "127",
            "129",
            "130",
            "135",
            "140",
            "144",
            "148",
            "149",
            "162",
            "163",
            "165",
            "166",
            "167",
            "170",
            "175",
            "176",
        ],
        "name": "Cyrillus Theol.",
    },
    "TLG1294": {"works": ["001"], "name": "Critolaus Phil."},
    "TLG2587": {"works": ["001"], "name": "Ariston Phil."},
    "TLG0644": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
        ],
        "name": "Aristophanes Gramm.",
    },
    "TLG0099": {"works": ["001", "002", "003"], "name": "Strabo Geogr."},
    "TLG1646": {"works": ["003"], "name": "Ptolemaeus Hist."},
    "TLG0557": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Epictetus Phil.",
    },
    "TLG0369": {"works": ["001"], "name": "Telesilla Lyr."},
    "TLG1752": {"works": ["003"], "name": "Xenagoras Geogr. et Hist."},
    "TLG2968": {"works": ["001"], "name": "Monimus Phil."},
    "TLG1489": {"works": ["003"], "name": "Megasthenes Hist."},
    "TLG1334": {"works": ["001"], "name": "Dius Phil."},
    "TLG0751": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Pseudo-Hippocrates Med.",
    },
    "TLG4344": {"works": ["001"], "name": "Menecrates Hist."},
    "TLG2644": {"works": ["001"], "name": "Sminthes Astron."},
    "TLG1530": {"works": ["005"], "name": "Nicanor Gramm."},
    "TLG0833": {"works": ["001"], "name": "Anaxion Trag."},
    "TLG3146": {"works": ["001"], "name": "Ducas Hist."},
    "TLG1629": {"works": ["001", "002"], "name": "Polystratus Phil."},
    "TLG1244": {"works": ["002", "003"], "name": "Carneiscus Phil."},
    "TLG0650": {"works": ["001"], "name": "Herodas Mimogr."},
    "TLG2607": {"works": ["001"], "name": "Alexinus Phil."},
    "TLG3079": {"works": ["001"], "name": "Michael Attaliates Hist."},
    "TLG2186": {"works": ["003"], "name": "Leo Hist."},
    "TLG1607": {"works": ["002"], "name": "Phoronis"},
    "TLG2393": {"works": ["002"], "name": "Andreas Hist."},
    "TLG1665": {"works": ["001"], "name": "Seniores Apud Irenaeum Scr. Eccl."},
    "TLG2647": {"works": ["001"], "name": "Zenothemis Geogr."},
    "TLG0402": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Alexis Comic.",
    },
    "TLG1577": {"works": ["001", "002"], "name": "Phaedimus Epigr."},
    "TLG1434": {"works": ["001", "002", "003", "004"], "name": "Hippias Soph."},
    "TLG0632": {
        "works": ["001", "002", "004", "005", "006", "007"],
        "name": "Pythagoras Phil.",
    },
    "TLG1087": {"works": ["001"], "name": "Cleophon Trag."},
    "TLG1896": {"works": ["002"], "name": "[Dositheus] Hist."},
    "TLG2409": {"works": ["003", "004"], "name": "Dioscurides Hist."},
    "TLG0447": {"works": ["001", "002", "003"], "name": "Diphilus Comic."},
    "TLG0458": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Eubulus Comic.",
    },
    "TLG2027": {"works": ["001", "002"], "name": "Valerius Apsines Rhet."},
    "TLG1679": {"works": ["002"], "name": "Socrates Hist."},
    "TLG2960": {"works": ["001"], "name": "Oracula Tiburtina"},
    "TLG0067": {"works": ["001", "003", "004", "005"], "name": "Agatharchides Geogr."},
    "TLG2255": {"works": ["003"], "name": "Gorgias Hist."},
    "TLG1150": {"works": ["001", "002"], "name": "Aphareus Rhet."},
    "TLG0007": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "048",
            "049",
            "050",
            "051",
            "052",
            "053",
            "054",
            "055",
            "056",
            "057",
            "058",
            "059",
            "060",
            "061",
            "062",
            "063",
            "064",
            "065",
            "066",
            "067",
            "068",
            "069",
            "070",
            "071",
            "072",
            "073",
            "074",
            "075",
            "076",
            "077",
            "078",
            "079",
            "080",
            "081",
            "082",
            "083",
            "084",
            "085",
            "086",
            "087",
            "088",
            "089",
            "090",
            "091",
            "092",
            "093",
            "094",
            "095",
            "096",
            "097",
            "098",
            "099",
            "100",
            "101",
            "102",
            "103",
            "104",
            "105",
            "106",
            "107",
            "108",
            "109",
            "110",
            "111",
            "112",
            "113",
            "114",
            "115",
            "116",
            "117",
            "118",
            "119",
            "120",
            "121",
            "122",
            "123",
            "125",
            "126",
            "127",
            "128",
            "129",
            "130",
            "131",
            "132",
            "133",
            "134",
            "135",
            "136",
            "137",
            "138",
            "139",
            "140",
            "141",
            "143",
            "144",
            "145",
            "146",
            "147",
            "148",
            "149",
        ],
        "name": "Plutarchus Biogr. et Phil.",
    },
    "TLG0618": {"works": ["001"], "name": "Antigoni Epistula"},
    "TLG1282": {"works": ["002"], "name": "Clytus Hist."},
    "TLG2696": {"works": ["001"], "name": "Theodorus Poeta"},
    "TLG5000": {
        "works": ["001", "002", "003", "004"],
        "name": "Concilia Oecumenica (ACO)",
    },
    "TLG0625": {"works": ["001"], "name": "Polemaeus Trag."},
    "TLG2651": {"works": ["001"], "name": "Artemidorus Eleg."},
    "TLG0433": {"works": ["001", "002", "003", "004", "005"], "name": "Crates Comic."},
    "TLG1231": {"works": ["001"], "name": "Bryson Phil."},
    "TLG3115": {"works": ["001"], "name": "Symeon Metaphrastes Biogr. et Hist."},
    "TLG1987": {"works": ["002"], "name": "Theodorus Poeta"},
    "TLG1544": {"works": ["003"], "name": "Nymphis Hist."},
    "TLG0332": {"works": ["001"], "name": "Cleaenetus Trag."},
    "TLG0022": {"works": ["001", "002", "003", "005", "006"], "name": "Nicander Epic."},
    "TLG3176": {"works": ["001", "002"], "name": "Pseudo-Sphrantzes Hist."},
    "TLG2399": {"works": ["001"], "name": "Eudromus Phil."},
    "TLG2304": {"works": ["001"], "name": "Idaeus Phil."},
    "TLG0604": {"works": ["001"], "name": "Ptolemaeus IV Philopator Trag."},
    "TLG0061": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009", "010"],
        "name": "Pseudo-Lucianus Soph.",
    },
    "TLG0592": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Hermogenes Rhet.",
    },
    "TLG3045": {"works": ["001"], "name": "Georgius Syncellus Chronogr."},
    "TLG0301": {"works": ["001"], "name": "Thespis Trag."},
    "TLG4167": {"works": ["001"], "name": "Leontius Mech."},
    "TLG4066": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Damascius Phil.",
    },
    "TLG0257": {"works": ["001"], "name": "Philiscus Rhet."},
    "TLG0339": {"works": ["001"], "name": "Moschion Trag."},
    "TLG4018": {"works": ["001", "002"], "name": "Asclepius Phil."},
    "TLG0474": {"works": ["001", "002", "003"], "name": "Magnes Comic."},
    "TLG0497": {
        "works": ["001", "002", "003", "004", "005", "006", "007"],
        "name": "Plato Comic.",
    },
    "TLG2962": {"works": ["004", "006"], "name": "Petrus Scr. Eccl. et Theol."},
    "TLG1555": {"works": ["001", "002", "003"], "name": "Pancrates Epic."},
    "TLG0040": {"works": ["001"], "name": "Calani Epistula"},
    "TLG0668": {"works": ["001"], "name": "Aegimius"},
    "TLG2246": {"works": ["001"], "name": "Lycon Phil."},
    "TLG1785": {"works": ["001"], "name": "Paramonus Comic."},
    "TLG0336": {"works": ["001", "002", "003", "004"], "name": "Crates Poet. Phil."},
    "TLG0326": {"works": ["001"], "name": "Sophocles Junior Trag."},
    "TLG2423": {"works": ["002"], "name": "Asclepiades Gramm. et Hist."},
    "TLG4392": {"works": ["001"], "name": "Joannes Epiphaniensis Hist."},
    "TLG1327": {"works": ["001"], "name": "Dionis Epistulae"},
    "TLG1812": {"works": ["002"], "name": "Demaratus Hist."},
    "TLG0116": {"works": ["002"], "name": "Abydenus Hist."},
    "TLG1469": {"works": ["002"], "name": "Lyceas Hist."},
    "TLG2196": {"works": ["002"], "name": "[Dercyllus] Hist."},
    "TLG0568": {"works": ["001", "002", "003", "004"], "name": "Antigonus Paradox."},
    "TLG4329": {"works": ["001", "002", "003"], "name": "Philosophus Anonymus Alchem."},
    "TLG0174": {"works": ["001", "002", "003"], "name": "Diotimus Epic."},
    "TLG3100": {
        "works": ["001", "002"],
        "name": "Nicolaus I Mysticus Theol. et Epist.",
    },
    "TLG1184": {"works": ["001", "002", "003"], "name": "Aristides Apol."},
    "TLG1157": {"works": ["001", "002"], "name": "Apocalypsis Esdrae"},
    "TLG0484": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Nicostratus Comic.",
    },
    "TLG2122": {"works": ["004"], "name": "Gaius Asinius Quadratus Hist."},
    "TLG0272": {"works": ["001"], "name": "De Arboribus Avibusque Fabulae"},
    "TLG0614": {"works": ["001"], "name": "Valerius Babrius Scr. Fab."},
    "TLG3015": {"works": ["001"], "name": "Joannes Cameniates Hist."},
    "TLG1638": {"works": ["002"], "name": "Proxenus Hist."},
    "TLG0521": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "Epicharmus Comic. et Pseudepicharmea",
    },
    "TLG1311": {"works": ["001"], "name": "Didache XII Apostolorum"},
    "TLG1273": {"works": ["001", "002"], "name": "Cleon Eleg."},
    "TLG0635": {"works": ["001", "002"], "name": "Zeno Phil."},
    "TLG2616": {"works": ["001"], "name": "Demareta Poeta"},
    "TLG4100": {"works": ["001"], "name": "Aphthonius Rhet."},
    "TLG1408": {"works": ["001", "002"], "name": "Heraclides Gramm."},
    "TLG1212": {"works": ["001"], "name": "Atridarum Reditus"},
    "TLG0090": {"works": ["001"], "name": "Agathemerus Geogr."},
    "TLG0569": {"works": ["001"], "name": "Apollonius Paradox."},
    "TLG1443": {"works": ["001", "002", "003"], "name": "Ignatius Scr. Eccl."},
    "TLG2573": {"works": ["003"], "name": "Pausanias Hist."},
    "TLG0327": {"works": ["001"], "name": "Carcinus Junior Trag."},
    "TLG0384": {
        "works": ["001", "002", "003"],
        "name": "Acta Justini Et Septem Sodalium",
    },
    "TLG2235": {"works": ["001"], "name": "Hippocrates Math."},
    "TLG2914": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
        ],
        "name": "Leontius Scr. Eccl.",
    },
    "TLG0439": {"works": ["001", "002", "003"], "name": "Demetrius Comic."},
    "TLG0606": {"works": ["001"], "name": "Rufus Soph."},
    "TLG1367": {"works": ["001"], "name": "Euripidis Epistulae"},
    "TLG0024": {"works": ["001"], "name": "Oppianus Epic."},
    "TLG0087": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
            "024",
            "025",
            "026",
            "027",
            "028",
            "029",
            "030",
            "031",
            "032",
            "033",
            "034",
            "035",
            "036",
            "037",
            "038",
            "039",
            "040",
            "041",
            "042",
            "043",
            "044",
            "045",
            "046",
            "047",
            "049",
            "050",
            "054",
        ],
        "name": "Aelius Herodianus et Pseudo-Herodianus Gramm. et Rhet.",
    },
    "TLG0280": {"works": ["001"], "name": "Andromachus Poet. Med."},
    "TLG1816": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
        ],
        "name": "Epica Adespota (GDRK)",
    },
    "TLG0029": {
        "works": ["004", "005", "006", "007", "008"],
        "name": "Dinarchus Orat.",
    },
    "TLG0971": {"works": ["001"], "name": "Oeniades Lyr."},
    "TLG1288": {"works": ["003"], "name": "Craterus Hist."},
    "TLG0044": {"works": ["001"], "name": "Antiochi Regis Epistulae"},
    "TLG1486": {"works": ["001", "002", "003"], "name": "Matron Parodius"},
    "TLG1346": {"works": ["001"], "name": "Ephraem Scr. Eccl."},
    "TLG0454": {"works": ["001", "002"], "name": "Epinicus Comic."},
    "TLG5014": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
            "017",
            "018",
            "019",
            "020",
            "021",
            "022",
            "023",
        ],
        "name": "Scholia In Aristophanem",
    },
    "TLG0743": {"works": ["001"], "name": "Nemesius Theol."},
    "TLG0653": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Aratus Astron. et Epic.",
    },
    "TLG1136": {"works": ["001"], "name": "Anonymus Presbyter Scr. Eccl."},
    "TLG0662": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008", "009"],
        "name": "Comica Adespota (CGFPR)",
    },
    "TLG0275": {"works": ["001"], "name": "Peirazomene"},
    "TLG4126": {"works": ["002", "004"], "name": "Theodorus Scr. Eccl."},
    "TLG0648": {"works": ["001"], "name": "Onasander Tact."},
    "TLG0464": {"works": ["001", "002"], "name": "Hegesippus Comic."},
    "TLG0630": {"works": ["001", "002"], "name": "Pherecydes Myth. et Phil."},
    "TLG1004": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Thessalus Astrol. et Med.",
    },
    "TLG0066": {"works": ["001"], "name": "Dicaearchus Phil."},
    "TLG1340": {"works": ["001"], "name": "Eccelus Phil."},
    "TLG2331": {"works": ["003"], "name": "Myrsilus Hist."},
    "TLG1247": {"works": ["001"], "name": "Cebes Phil."},
    "TLG2945": {"works": ["001"], "name": "Gnomologium Vaticanum"},
    "TLG2956": {
        "works": ["002", "003", "004"],
        "name": "Sextus Julius Africanus Hist.",
    },
    "TLG1374": {"works": ["001"], "name": "Evangelium Secundum Hebraeos"},
    "TLG2605": {"works": ["001"], "name": "Agamestor Eleg."},
    "TLG0243": {"works": ["001"], "name": "Callinus Eleg."},
    "TLG1416": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "008"],
        "name": "(H)eren(n)ius Philo Gramm. et Hist.",
    },
    "TLG0434": {
        "works": ["001", "002", "003", "004", "005", "006"],
        "name": "Cratinus Comic.",
    },
    "TLG0750": {"works": ["001", "002"], "name": "Heliodorus Trag."},
    "TLG1719": {"works": ["001", "002", "003"], "name": "Theodosius Astron. et Math."},
    "TLG2194": {"works": ["002"], "name": "[Aristides] Hist."},
    "TLG0505": {"works": ["001", "002", "003"], "name": "Sotades Comic."},
    "TLG0394": {"works": ["001"], "name": "Apollonius Comic."},
    "TLG2169": {"works": ["001"], "name": "Herillus Phil."},
    "TLG0480": {"works": ["001", "002", "003"], "name": "Nicochares Comic."},
    "TLG0141": {"works": ["002", "003"], "name": "Athenaeus Epigr."},
    "TLG1387": {"works": ["003"], "name": "(H)agias-Dercylus Hist."},
    "TLG0629": {"works": ["001"], "name": "Periander Phil."},
    "TLG1515": {"works": ["001"], "name": "Moeris Attic."},
    "TLG1483": {"works": ["001"], "name": "Martyrium Et Ascensio Isaiae"},
    "TLG4304": {"works": ["001", "002"], "name": "Glossae In Herodotum"},
    "TLG0342": {"works": ["001"], "name": "Nicomachus Trag."},
    "TLG0643": {"works": ["001", "002"], "name": "Anonymus Londinensis Med."},
    "TLG0471": {"works": ["001", "002"], "name": "Lynceus Comic."},
    "TLG1967": {"works": ["002"], "name": "Leschides Epic."},
    "TLG0283": {"works": ["001", "002"], "name": "Heraclides Ponticus Junior Gramm."},
    "TLG4393": {"works": ["001"], "name": "Nonnosus Hist."},
    "TLG1446": {"works": ["001", "002"], "name": "Ion Eleg."},
    "TLG3178": {"works": ["001"], "name": "Anonymi Lexeis Rhetoricae"},
    "TLG1153": {"works": ["001"], "name": "Apocalypsis Adam"},
    "TLG0547": {"works": ["001", "002", "003"], "name": "Anaximenes Hist. et Rhet."},
    "TLG0543": {"works": ["001", "002", "003"], "name": "Polybius Hist."},
    "TLG1289": {"works": ["002"], "name": "Crates Hist."},
    "TLG0033": {"works": ["001", "002", "003", "004", "005"], "name": "Pindarus Lyr."},
    "TLG2702": {
        "works": [
            "001",
            "006",
            "007",
            "009",
            "010",
            "011",
            "012",
            "015",
            "016",
            "017",
            "021",
            "022",
        ],
        "name": "Michael Psellus Polyhist.",
    },
    "TLG1133": {"works": ["001"], "name": "Anonymus Diodori Phil."},
    "TLG1800": {"works": ["001", "002"], "name": "Euboeus Parodius"},
    "TLG0581": {"works": ["001"], "name": "Paradoxographus Palatinus"},
    "TLG5031": {"works": ["001", "002"], "name": "Scholia In Nicandrum"},
    "TLG0559": {
        "works": [
            "001",
            "002",
            "003",
            "004",
            "005",
            "006",
            "007",
            "008",
            "009",
            "010",
            "011",
            "012",
            "013",
            "014",
            "015",
            "016",
        ],
        "name": "Heron Mech.",
    },
    "TLG1600": {"works": ["001"], "name": "Philostratus Major Soph."},
    "TLG2345": {"works": ["003"], "name": "Agl(a)osthenes Hist."},
    "TLG2046": {"works": ["001"], "name": "Quintus Epic."},
    "TLG2364": {"works": ["003"], "name": "Zeno Hist."},
    "TLG0706": {"works": ["001"], "name": "Philo Med."},
    "TLG1124": {"works": ["001", "002"], "name": "Andronicus Rhodius Phil."},
    "TLG0727": {"works": ["001"], "name": "Joannes Med."},
    "TLG2566": {"works": ["002"], "name": "[Agathon] Hist."},
    "TLG9007": {"works": ["001"], "name": "Appendix Proverbiorum"},
    "TLG1833": {"works": ["001", "002"], "name": "Pratinas Trag."},
    "TLG2971": {"works": ["001"], "name": "Georgius Peccator Poeta"},
    "TLG0679": {"works": ["001", "002"], "name": "Aeschrion Lyr."},
    "TLG1193": {"works": ["001", "002"], "name": "Ariston Phil."},
    "TLG4193": {
        "works": ["002", "003", "004", "005", "010", "012"],
        "name": "Anonymi In Aristotelis Sophisticos Elenchos Phil.",
    },
    "TLG0365": {"works": ["001"], "name": "Apollodorus Lyr."},
    "TLG2306": {"works": ["003"], "name": "Xenomedes Hist."},
    "TLG1444": {"works": ["001"], "name": "Ilias Parva"},
    "TLG4172": {"works": ["002", "004", "005", "006"], "name": "Vitae Oppiani"},
    "TLG1681": {"works": ["001"], "name": "Solonis Epistulae"},
    "TLG1332": {"works": ["001"], "name": "Diotogenes Phil."},
    "TLG2894": {"works": ["001"], "name": "Constitutiones Apostolorum"},
    "TLG0492": {"works": ["001", "002", "003"], "name": "Philonides Comic."},
    "TLG2865": {
        "works": ["001", "002", "003", "004", "005", "006", "007", "009"],
        "name": "Olympiodorus Diaconus Scr. Eccl.",
    },
    "TLG4149": {"works": ["001"], "name": "Sophronius Gramm."},
    "TLG0526": {
        "works": ["001", "002", "003", "004"],
        "name": "Flavius Josephus Hist.",
    },
    "TLG0496": {
        "works": ["001", "002", "003", "004", "005"],
        "name": "Phrynichus Comic.",
    },
    "TLG0233": {"works": ["001"], "name": "Hipponax Iamb."},
    "TLG4291": {"works": ["001"], "name": "Verba In Scripturis De Christo"},
    "TLG3127": {"works": ["001"], "name": "Pseudo-Nonnus"},
    "TLG2354": {"works": ["002"], "name": "Dionysius Hist."},
    "TLG3169": {"works": ["001"], "name": "Joannes VI Cantacuzenus"},
    "TLG2172": {"works": ["002"], "name": "Andron Hist."},
    "TLG1232": {"works": ["001"], "name": "Butherus Phil."},
    "TLG2064": {"works": ["002"], "name": "Acacius Theol."},
    "TLG2133": {"works": ["001"], "name": "Achilles Tatius Astron."},
    "TLG0550": {"works": ["001"], "name": "Apollonius Geom."},
    "TLG2946": {"works": ["001", "002"], "name": "Priscus Hist. et Rhet."},
    "TLG1675": {"works": ["002"], "name": "Simylus Eleg."},
    "TLG0378": {"works": ["001"], "name": "Ariphron Lyr."},
    "TLG2025": {"works": ["002"], "name": "Maximus Rhet."},
}


TLG_MASTER_INDEX = {
    "Oracula Sibyllina": {
        "tlg_id": "TLG1551",
        "names": {"name_authtab": "Oracula Sibyllina", "name_idt": "Oracula Sibyllina"},
        "works": {"Oracula": ["Section", "line"], "Fragmenta": ["Fragment", "line"]},
    },
    "Demosthenes Epic.": {
        "tlg_id": "TLG1308",
        "names": {"name_authtab": "Demosthenes Epic.", "name_idt": "Demosthenes Epic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aesopus et Aesopica Scr. Fab.": {
        "tlg_id": "TLG0096",
        "names": {
            "name_authtab": "Aesopus Scr. Fab. et Aesopica",
            "name_idt": "Aesopus et Aesopica Scr. Fab.",
        },
        "works": {
            "Fabulae Theophylacti Simocattae scholastici": ["Fable", "line"],
            "Sententiae": ["Sententia", "line"],
            "Fabulae Libanii": ["Fable", "line"],
            "Fabulae Themistii rhetoris": ["Fable", "line"],
            "Fabulae ap. Dionem Chrysostomum": ["Fable", "line"],
            "Proverbia": ["Proverb", "line"],
            "Fabula Nicephori": ["Fable", "line"],
            "Paroemiae": ["Section", "line"],
            "Fabulae Dosithei": ["Fable", "line"],
            "Fabulae (P. Ryl. 493)": ["Fable", "line"],
            "Fabulae tabulis ceratis Assendelftianis servatae": ["Fable", "line"],
            "Fabulae rhetoris anonymi Brancatiani": ["Fable", "line"],
            "Fabulae Syntipae philosophi": ["Fable", "line"],
            "Fabulae Aphthonii rhetoris": ["Fable", "line"],
            "Epigramma": ["Book", "epigram", "line"],
            "Fabulae (dodecasyllabi)": ["Fable", "line"],
            "Fabulae": ["Fable", "version", "line"],
        },
    },
    "Anonymus De Scientia Politica Hist.": {
        "tlg_id": "TLG3185",
        "names": {
            "name_authtab": "Anonymus De Scientia Politica Hist.",
            "name_idt": "Anonymus De Scientia Politica Hist.",
        },
        "works": {
            "De scientia politica dialogus (olim sub auctore Petro Patricio) (e cod. Vat. gr. 1298)": [
                "Page",
                "line",
            ]
        },
    },
    "Alexandri Magni Epistulae": {
        "tlg_id": "TLG0042",
        "names": {
            "name_authtab": "Alexandri Magni Epistulae",
            "name_idt": "Alexandri Magni Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Ammonius Scr. Eccl.": {
        "tlg_id": "TLG2724",
        "names": {
            "name_authtab": "Ammonius Scr. Eccl.",
            "name_idt": "Ammonius Scr. Eccl.",
        },
        "works": {"Fragmenta in Joannem (in catenis)": ["Fragment", "line"]},
    },
    "Anonymus Diodori Phil.": {
        "tlg_id": "TLG1133",
        "names": {
            "name_authtab": "Anonymus Diodori Phil.",
            "name_idt": "Anonymus Diodori Phil.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Leo Diaconus Hist.": {
        "tlg_id": "TLG3069",
        "names": {
            "name_authtab": "Leo Diaconus Hist.",
            "name_idt": "Leo Diaconus Hist.",
        },
        "works": {"Historia": ["Page", "line"]},
    },
    "Seniores Apud Irenaeum Scr. Eccl.": {
        "tlg_id": "TLG1665",
        "names": {
            "name_authtab": "Seniores Apud Irenaeum Scr. Eccl.",
            "name_idt": "Seniores Apud Irenaeum Scr. Eccl.",
        },
        "works": {"Reliquiae plurium anonymorum": ["Fragment", "line"]},
    },
    "Autocrates Hist.": {
        "tlg_id": "TLG2204",
        "names": {"name_authtab": "Autocrates Hist.", "name_idt": "Autocrates Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Amphilochius Scr. Eccl.": {
        "tlg_id": "TLG2112",
        "names": {
            "name_authtab": "Amphilochius Scr. Eccl.",
            "name_idt": "Amphilochius Scr. Eccl.",
        },
        "works": {
            "Contra haereticos": ["line"],
            "De recens baptizatis (orat. 7)": ["line"],
            "*In illud: Pater si possibile est (orat. 6)": ["line"],
            "#Encomium sancti Basilii Magni [Sp.]": ["line"],
            "<Oratio in resurrectionem domini [Sp.] (e cod. Vat. gr. 2194)": ["line"],
            "In occursum domini (orat. 2)": ["line"],
            "Fragmenta spuria": ["Fragment", "line"],
            "In Lazarum (orat. 3)": ["line"],
            "Oratio in mesopentecosten [Sp.]": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "In Zacchaeum (orat. 8)": ["line"],
            "Epistula synodalis": ["line"],
            "Expositio in illud: De meo accipiet et annuntiabit vobis (fr. 13) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "Fragmentum xxi [Sp.]": ["Volume", "page", "line"],
            " In diem sabbati sancti (orat. 5)": ["line"],
            "In Isaiam (fr. 5) [Sp.]": ["Volume", "page", "line"],
            "<Oratio in resurrectionem domini [Sp.] (e cod. Vat. gr. 1936)": [
                "Page",
                "line",
            ],
            "Fragmentum xvii [Sp.]": ["Volume", "page", "line"],
            "In natalitia domini (orat. 1)": ["line"],
            "Fragmenta ex tractatu in illud: Dominus creavit me (fr. 4)": [
                "Volume",
                "page",
                "line",
            ],
            "In illud: Non potest filius a se facere (orat. 9)": ["line"],
            "Fragmentum xx [Sp.]": ["Volume", "page", "line"],
            "In illud: Solvite templum hoc (fr. 9) [Sp.]": ["Volume", "page", "line"],
            "In mulierem peccatricem (orat. 4)": ["line"],
        },
    },
    "Menippus Phil.": {
        "tlg_id": "TLG0052",
        "names": {"name_authtab": "Menippus Phil.", "name_idt": "Menippus Phil."},
        "works": {"Epistula [Sp.]": ["line"]},
    },
    "[Boeus] Epic.": {
        "tlg_id": "TLG1229",
        "names": {"name_authtab": "[Boeus] Epic.", "name_idt": "[Boeus] Epic."},
        "works": {"Fragmentum": ["line"]},
    },
    "Demetrius Poet. Phil.": {
        "tlg_id": "TLG1301",
        "names": {
            "name_authtab": "Demetrius Poet. Phil.",
            "name_idt": "Demetrius Poet. Phil.",
        },
        "works": {"Fragmenta et titulus": ["Fragment", "line"]},
    },
    "Xenophon Hist.": {
        "tlg_id": "TLG0032",
        "names": {"name_authtab": "Xenophon Hist.", "name_idt": "Xenophon Hist."},
        "works": {
            "": ["Apologia Socratis", "Section", "line"],
            "Memorabilia": ["Book", "chapter", "section", "line"],
            "Atheniensium respublica [Sp.]": ["Chapter", "section", "line"],
            "Cyropaedia": ["Book", "chapter", "section", "line"],
            "De vectigalibus": ["Chapter", "section", "line"],
            "Agesilaus": ["Chapter", "section", "line"],
            "Hellenica": ["Book", "chapter", "section", "line"],
            "Cynegeticus": ["Chapter", "section", "line"],
            "Anabasis": ["Book", "chapter", "section", "line"],
            "Symposium": ["Chapter", "section", "line"],
            "Hipparchicus": ["Chapter", "section", "line"],
            "Hiero": ["Chapter", "section", "line"],
            "De re equestri": ["Chapter", "section", "line"],
            "De republica Lacedaemoniorum": ["Chapter", "section", "line"],
            "Oeconomicus": ["Chapter", "section", "line"],
        },
    },
    "Archestratus Parodius": {
        "tlg_id": "TLG1175",
        "names": {
            "name_authtab": "Archestratus Parodius",
            "name_idt": "Archestratus Parodius",
        },
        "works": {
            "Fragmenta et tituli": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Philiades Eleg.": {
        "tlg_id": "TLG1587",
        "names": {"name_authtab": "Philiades Eleg.", "name_idt": "Philiades Eleg."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Cratinus Comic.": {
        "tlg_id": "TLG0434",
        "names": {"name_authtab": "Cratinus Comic.", "name_idt": "Cratinus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Sositheus Trag.": {
        "tlg_id": "TLG0340",
        "names": {"name_authtab": "Sositheus Trag.", "name_idt": "Sositheus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Eudoxus Comic.": {
        "tlg_id": "TLG0399",
        "names": {"name_authtab": "Eudoxus Comic.", "name_idt": "Eudoxus Comic."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Tituli": ["Play", "fragment", "line"],
        },
    },
    "Hippostratus Hist.": {
        "tlg_id": "TLG2391",
        "names": {
            "name_authtab": "Hippostratus Hist.",
            "name_idt": "Hippostratus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scholia In Iamblichum Philosophum": {
        "tlg_id": "TLG5027",
        "names": {
            "name_authtab": "Scholia In Iamblichum Philosophum",
            "name_idt": "Scholia In Iamblichum Philosophum",
        },
        "works": {
            "Scholia in librum Iamblichi in Nicomachi arithmeticam introductionem (scholia vetera et recentiora)": [
                "Page",
                "scholion",
                "line",
            ]
        },
    },
    "Antigoni Epistula": {
        "tlg_id": "TLG0618",
        "names": {"name_authtab": "Antigoni Epistula", "name_idt": "Antigoni Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Panarces Scriptor Aenigmatum": {
        "tlg_id": "TLG0256",
        "names": {
            "name_authtab": "Panarces Scriptor Aenigmatum",
            "name_idt": "Panarces Scriptor Aenigmatum",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollonius Phil.": {
        "tlg_id": "TLG0619",
        "names": {"name_authtab": "Apollonius Phil.", "name_idt": "Apollonius Phil."},
        "works": {
            "Apotelesmata [Sp.]": ["Page", "line"],
            ":De horis diei et noctis (fragmenta e cod. Berol. 26) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "Apollonii epistulae [Dub.]": ["Epistle", "line"],
        },
    },
    "Crateuas Med.": {
        "tlg_id": "TLG0657",
        "names": {"name_authtab": "Crateuas Med.", "name_idt": "Crateuas Med."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scholia In Isocratem": {
        "tlg_id": "TLG5028",
        "names": {
            "name_authtab": "Scholia In Isocratem",
            "name_idt": "Scholia In Isocratem",
        },
        "works": {
            "Scholia in Isocratem (scholia vetera)": [
                " Vita-hypothesis-scholion+oration",
                "section",
                "line",
            ]
        },
    },
    "Acta Eupli": {
        "tlg_id": "TLG2012",
        "names": {"name_authtab": "Acta Eupli", "name_idt": "Acta Eupli"},
        "works": {"Acta Eupli": ["Chapter", "section", "line"]},
    },
    "Timoxenus Comic.": {
        "tlg_id": "TLG1793",
        "names": {"name_authtab": "Timoxenus Comic.", "name_idt": "Timoxenus Comic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Dieuchidas Hist.": {
        "tlg_id": "TLG1313",
        "names": {"name_authtab": "Dieuchidas Hist.", "name_idt": "Dieuchidas Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diogenes Phil.": {
        "tlg_id": "TLG1321",
        "names": {"name_authtab": "Diogenes Phil.", "name_idt": "Diogenes Phil."},
        "works": {"Fragmenta": ["Fragment", "column", "line"]},
    },
    "Scholia In Theonem Rhetorem": {
        "tlg_id": "TLG5046",
        "names": {
            "name_authtab": "Scholia In Theonem Rhetorem",
            "name_idt": "Scholia In Theonem Rhetorem",
        },
        "works": {"Scholia in progymnasmata (scholia recentiora)": ["Page", "line"]},
    },
    "Demaratus Hist.": {
        "tlg_id": "TLG1812",
        "names": {"name_authtab": "Demaratus Hist.", "name_idt": "Demaratus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aristaenetus Epist.": {
        "tlg_id": "TLG4000",
        "names": {
            "name_authtab": "Aristaenetus Epist.",
            "name_idt": "Aristaenetus Epist.",
        },
        "works": {"Epistulae": ["Book", "letter", "line"]},
    },
    "Juba II Rex Mauretaniae Hist.": {
        "tlg_id": "TLG1452",
        "names": {
            "name_authtab": "Juba II Rex Mauretaniae Hist.",
            "name_idt": "Juba II Rex Mauretaniae Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Thrasybuli Epistula": {
        "tlg_id": "TLG0056",
        "names": {
            "name_authtab": "Thrasybuli Epistula",
            "name_idt": "Thrasybuli Epistula",
        },
        "works": {"Epistula": ["line"]},
    },
    "Lydus Hist.": {
        "tlg_id": "TLG2580",
        "names": {
            "name_authtab": "Joannes Laurentius Lydus Hist.",
            "name_idt": "Lydus Hist.",
        },
        "works": {
            "De ostentis": ["Section", "line"],
            "De magistratibus populi Romani": ["Page", "line"],
            "De mensibus": ["Book", "section", "line"],
        },
    },
    "Dioscorides Med.": {
        "tlg_id": "TLG1118",
        "names": {
            "name_authtab": "Pseudo-Dioscorides Med.",
            "name_idt": "Dioscorides Med.",
        },
        "works": {
            "De iis, quae virus ejaculantur, animalibus libellus, in quo et de rabioso cane (%6 Theriaca)": [
                "Section",
                "line",
            ],
            "BDe venenis eorumque praecautione et medicatione (%6 Alexipharmaca)": [
                "Section",
                "line",
            ],
            "De lapidibus": ["Section", "line"],
        },
    },
    "Ephraem Syrus Theol.": {
        "tlg_id": "TLG4138",
        "names": {
            "name_authtab": "Ephraem Syrus Theol.",
            "name_idt": "Ephraem Syrus Theol.",
        },
        "works": {
            "": ["De Iuliano asceta", "Page", "line"],
            "De compunctione": ["Page", "line"],
            "Sermo alius compunctorius": ["Page", "line"],
            "6De latrone in crucem (e cod. Sinaiticus 493, fol. 220)": ["Page", "line"],
            "De uirtutibus et passionibus": ["Page", "line"],
            "qSermo adversus haereticos, in quo tum ex margaritae tum ex aliorum claris argumentis ostenditur credendum esse sa": [
                "Page",
                "line",
            ],
            "(Sermones paraenetici ad monachos Aegypti": ["Oration", "line"],
            "%Sermo de operatione peruersi daemonis": ["Page", "line"],
            "Interpretatio": ["Page", "line"],
            "$De recta vivendi ratione (capita xc)": ["Chapter", "line"],
            "De paenitentia": ["Page", "line"],
            "De timore animarum": ["Page", "line"],
            "De festis diebus": ["line"],
            "*Paraenesis ad ascetas (ordine alphabetico)": ["Page", "line"],
            "De passionibus animi": ["Page", "line"],
            "De statu spirituali": ["line"],
            "?Aduersus eos, qui dicunt terrae motus a terrae inflatione fieri": [
                "line"
            ],
            "hDe abstinendo a cupiditatibus carnalibus, et de certamine ac de multa securitate, ad fratrem qui excidit": [
                "Page",
                "line",
            ],
            "De his, quae haec vita continet": ["line"],
            "[2Precationes ad dei matrem]2": ["Prayer", "page", "line"],
            "Sermo de virtutibus et vitiis": ["Section", "line"],
            "Aduersus improbas mulieres": ["Page", "line"],
            "qSermo in martyrium sancti Bonifatii magnimartyris (e cod. 4887.767 Monasterii Iberonum in Monte Athonis, fol. 44v": [
                "Page",
                "line",
            ],
            "De quibusdam interrogationibus": ["line"],
            "!Sermo de iudicio et resurrectione": ["Page", "line"],
            "De perfectione monachi": ["Page", "line"],
            "De humilitate": ["line"],
            "qDe non suscipiendis rebus hisce momentaneis, et ne patiamur nos decipi huius vitae oblectamentis; et in psalmum l": [
                "Page",
                "line",
            ],
            "Sermo paraeneticus": ["Page", "line"],
            "&Reprehensio sui ipsius atque Confessio": ["Page", "line"],
            "HQuomodo anima cum lacrymis debeat orare deum, quando tentatur ab inimico": [
                "Page",
                "line",
            ],
            "De oratione": ["Page", "line"],
            "5Sermo in secundum adventum domini nostri Iesu Christi": ["Page", "line"],
            "De virtute (capita x)": ["Chapter", "line"],
            "De paenitentia et patientia": ["Page", "line"],
            "Ad imitationem proverbiorum": ["Page", "line"],
            "Sermo alius in patres defunctos": ["Page", "line"],
            "FEncomium in gloriosos martyres, qui in toto mundo martyrium sunt passi": [
                "Page",
                "line",
            ],
            "Sermo tetrasyllabus": ["Page", "line"],
            "!Ne decipiamur gentilium erroribus": ["Page", "line"],
            "De mansionibus beatis": ["line"],
            "PSermo unde magi in Hierosolymam ineunt (e cod. 284 Mosq. [Vlad. 215], fol. 101v)": [
                "Page",
                "line",
            ],
            "#Sermo de secundo aduentu et iudicio": ["Page", "line"],
            "qQuomodo latro ante resurrectionem in paradisum intrauit (e cod. 115 Monasterii sancti Dochiarii in Monte Athonis,": [
                "line"
            ],
            "Interrogationes ac responsiones": ["Page", "line"],
            "<Ad correctionem eorum qui vitiose vivunt et honores appetunt": [
                "Page",
                "line",
            ],
            "3De recordatione mortis et de uirtute ac de diuitiis": ["Page", "line"],
            "Sermo in Abraham et Isaac (i)": ["Page", "line"],
            "Sermo ad renuntiantes": ["Page", "line", ""],
            " Adhortatio de silentio et quiete": ["Page", "line"],
            "Diuisio affectionum": ["line"],
            "ASermo de paenitentia et iudicio et separatione animae et corporis": [
                "Page",
                "line",
            ],
            "(In illud: Attende tibi ipsi (capita xii)": ["Chapter", "line"],
            'qSermo in Danielem prophetam, et in sanctos tres pueros; et in eum qui dicit: "3Tempora mala sunt, salvari nequeo"': [
                "line"
            ],
            "De diuina gratia": ["Page", "line"],
            "`Sermo de Cain, et de Abel caedo (e cod. 99 Monasterii Pantocratoris in Monte Athonis, fol. 375r)": [
                "Page",
                "line",
            ],
            "9De conuersatione fratrum mutua in concordia et dilectione": [
                "Page",
                "line",
            ],
            "qPrecationes e sacris scripturis collectae, quarum pleraequae sunt Sancti Ephraim, pro iis qui uolunt suam ipsorum": [
                "Prayer",
                "page",
                "line",
            ],
            "Sermo compunctorius": ["Page", "line"],
            "De patientia": ["Page", "line"],
            "Sermo in pulcherrimum Ioseph": ["Page", "line"],
            "Fragmenta paraenetica": ["Section", "line"],
            "Beati Ephraem Testamentum": ["Page", "line"],
            "Sermo in patres defunctos": ["Page", "line"],
            "BAd Ioannem monachum, ut abstineat a Nestorii insania et blasphemia": [
                "Page",
                "line",
            ],
            "&Adhortatio sive Catechesis ad monachos": ["Page", "line"],
            "De fide": ["Page", "line"],
            "Precatio": ["Page", "line"],
            "2De virtute, ad novitium monachum (capita quattuor)": ["Section", "line"],
            " Sermo in sanctum Eliam prophetam": ["Page", "line"],
            "[2Precationes]2": ["Page", "line"],
            "1Sermo de habenda semper in mente die exitus uitae": ["line"],
            "Adhortatio ad fratres": ["Page", "line"],
            "In aduentum domini (sermo i)": ["Page", "line"],
            "[2Fragmenta]2": ["Page", "line"],
            "'De beatitudinibus atque infelicitatibus": ["line"],
            "/In sanctam parasceuen, et in latronem et crucem": ["Page", "line"],
            "De caritate": ["Page", "line"],
            "1De nostra libertate et quod liber factus est homo": ["line"],
            "mSermo de resurrectione, in consecrationibus, et de tumulo sancto (e cod. 244 MPT Athen. Nat. Bibl., fol. 60r)": [
                "Page",
                "line",
            ],
            "@De abstinendo ab omni consuetudine perniciosa, et de continentia": [
                "Page",
                "line",
            ],
            "#Beautitudines aliae, capita viginti": ["Chapter", "line"],
            "De paenitentia et compunctione": ["line"],
            "#Reprehensio sui ipsius et Confessio": ["Page", "line"],
            "Sermo in Abraham": ["Page", "line"],
            "(Encomium in sanctos quadraginta martyres": ["Page", "line"],
            "Ad eversionem superbiae": ["Page", "line"],
            "[Quod non oporteat ridere et extollli, sed plangere potius et nos ipsos et nos ipsos deflere": [
                "Page",
                "line",
            ],
            "Homilia in meretricem": ["Page", "line"],
            "Sermo de sacerdotio": ["Page", "line"],
            "Paraenesis": ["line"],
            "Encomium in magnum Basilium": ["Page", "line"],
            "?Consilium de vita spiritali, ad monachum novitium (capita xcvi)": [
                "Chapter",
                "line",
            ],
            "Institutio ad monachos": ["Page", "line", "®´»ÈÎÛî", "\\"],
            "De locis beatis": ["Page", "line"],
            "Sermo heptasyllabus": ["line"],
            "lSermo in crucem, in consecrationibus, et de sancto ligno crucis (e cod. Athen. Nat. Bibl. 244 MPT, fol. 62v)": [
                "Page",
                "line",
            ],
            "De panoplia, ad monachos": ["Page", "line"],
            " Septem sunt occupationes monachi": ["line"],
            "5Capita centum. Quomodo quis humilitatem sibi comparet": [
                "Chapter",
                "line",
            ],
            "IDe his, qui animas ad impudicitiam pelliciunt, cum dicant nihil mali esse": [
                "Page",
                "line",
            ],
            "Sermo de uirginitate": ["Page", "line"],
            "qSermo de communi resurrectione, de paenitentia et de caritate, et in secundum adventum domini nostri Iesu Christi": [
                "Page",
                "line",
            ],
            "*Beautitudines, capita quinquaginta quinque": ["Chapter", "line"],
            " De resurrectione mortuorum sermo": ["Page", "line"],
            "Encomium in martyres": ["Page", "line"],
            "Sermo asceticus": ["Page", "line"],
            "Sermo asceticus perutilis": ["Page", "line"],
            "4De iis, qui dicunt resurrectionem mortuorum non esse": ["Page", "line"],
            "In aduentum domini (sermo iii)": ["Page", "line"],
            "Modi dei prouidentiae": ["line"],
            "bIn sermonem, quem dixit dominus, quod: In hoc mundo pressuram habebitis, et de perfectione hominis": [
                "Page",
                "line",
            ],
            ".Apologia ad fratrem quendam, de Heli sacerdote": ["Page", "line"],
            "/Quod ludicris rebus abstinendum sit christianis": ["Page", "line"],
            "qEpistula ad Ioannem monachum de patientia, et de cavendo nequis decipiatur cogitationibus praetextu iustification": [
                "Page",
                "line",
            ],
            "Confessio seu Precatio ad deum": ["Page", "line"],
            "In aduentum domini (sermo ii)": ["Page", "line"],
            "Hypomnesticon, sive Epistula": ["Page", "line"],
            ".Paraenesis de patientia et animae compunctione": ["Page", "line"],
            "Interrogationes et responsiones": ["Page", "line"],
            "De monachis": ["line"],
            "Ad animam neglegentem": ["Page", "line"],
            "1De patientia et compunctione. Sermo adhortatorius": ["Page", "line"],
            "De octo cogitationibus": ["Page", "line"],
            "oEncomium in Petrum et Paulum et Andream, Thomam et Lucam et Ioannem, et in lectionem euangelii secundum Ioannem": [
                "Page",
                "line",
            ],
            "NSermo in Abraham et Isaac (ii) (e cod. 163 MPT Athen. Nat. Bibl., fol. 8v-17r)": [
                "Page",
                "line",
            ],
            "KOde optime fluens, in eos qui cotidie peccant et cotidie paenitentiam agunt": [
                "line"
            ],
            "GSermo in transfigurationem domini et dei salvatoris nostri Iesu Christi": [
                "Page",
                "line",
            ],
            ".In vitam beati Abrahamii et neptis eius Mariae": ["Page", "line"],
            "Sermo de passione Saluatoris": ["Page", "line"],
            "(Oratio in uanam uitam, et de paenitentia": ["Page", "line"],
            "(De iis, qui filii dei naturam scrutantur": ["Page", "line"],
            "Sermo animae utilis": ["Page", "line"],
            "De directione uirtutis": ["line"],
            "In Loth, et de securitate": ["Page", "line"],
            "\\De vera renuntiatione, et quo pacto anima deum inveniat, quam ob causam ad nos venit dominus": [
                "line"
            ],
            "QSermo in adventum domini, et de consummatione saeculi, et in adventum antichristi": [
                "Page",
                "line",
            ],
            "qDe patientia et consummatione huius saeculi, ac de secundo aduentu; necnon de meditatione diuinarum scripturarum;": [
                "Page",
                "line",
            ],
            "%De morbo linguae et prauis affectibus": ["Page", "line"],
            "De iudicio et compunctione": ["Page", "line"],
            "6Sermo in Ionam prophetam et de paenitentia Niniuitarum": ["Page", "line"],
            "]Sermo in pretiosam et vivificam crucem, et in secundum adventum, et de caritate et eleemosyna": [
                "Page",
                "line",
            ],
            "?Sermo paraeneticus de secundo aduentu domini, et de paenitentia": [
                "Page",
                "line",
            ],
            "?Institutio de exercitatione bonorum operum, et de dei patientia": [
                "line"
            ],
            "De ieiunio": ["line"],
            "/In secundum adventum domini nostri Iesu Christi": ["Page", "line"],
            "De psalmo": ["line"],
            ")Sermo in eos, qui in Christo obdormierunt": ["Page", "line"],
            "CDe non scandalizando proximo, et de recta vitae ratione, adhortatio": [
                "Page",
                "line",
            ],
            "Sermo de paenitentia": ["line"],
            "^De continentia ac de non aemulandis peccatoribus qui se temporis praetextu excusant; et in Noe": [
                "line"
            ],
        },
    },
    "Andocides Orat.": {
        "tlg_id": "TLG0027",
        "names": {"name_authtab": "Andocides Orat.", "name_idt": "Andocides Orat."},
        "works": {
            "De pace": ["Section", "line"],
            "In Alcibiadem [Sp.]": ["Section", "line", ""],
            "De mysteriis": ["Section", "line"],
            "De reditu suo": ["Section", "line"],
            "Fragmenta": ["Fragment", "section", "line", "", ""],
        },
    },
    "Lachares Soph.": {
        "tlg_id": "TLG2937",
        "names": {"name_authtab": "Lachares Soph.", "name_idt": "Lachares Soph."},
        "works": {
            "3Rhetorica (fragmentum e cod. Paris. suppl. gr. 670)": ["Page", "line"]
        },
    },
    "Lucullus Hist.": {
        "tlg_id": "TLG1977",
        "names": {
            "name_authtab": "Lucius Licinius Lucullus Hist.",
            "name_idt": "Lucullus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Elias Phil.": {
        "tlg_id": "TLG4020",
        "names": {"name_authtab": "Elias Phil.", "name_idt": "Elias Phil."},
        "works": {
            ",Commentarius in Aristotelis analytica priora": ["Page", "line"],
            "In Porphyrii isagogen": ["Page", "line"],
            ";Eliae (olim Davidis) in Aristotelis categorias commentarium": [
                "Page",
                "line",
            ],
        },
    },
    "Charinus Choliamb.": {
        "tlg_id": "TLG1257",
        "names": {
            "name_authtab": "Charinus Choliamb.",
            "name_idt": "Charinus Choliamb.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Eparchides Hist.": {
        "tlg_id": "TLG1343",
        "names": {"name_authtab": "Eparchides Hist.", "name_idt": "Eparchides Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Arcesilaus Phil.": {
        "tlg_id": "TLG1172",
        "names": {"name_authtab": "Arcesilaus Phil.", "name_idt": "Arcesilaus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Lysanias Hist.": {
        "tlg_id": "TLG2298",
        "names": {"name_authtab": "Lysanias Hist.", "name_idt": "Lysanias Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Crates Hist.": {
        "tlg_id": "TLG1289",
        "names": {"name_authtab": "Crates Hist.", "name_idt": "Crates Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philostephanus Comic.": {
        "tlg_id": "TLG0493",
        "names": {
            "name_authtab": "Philostephanus Comic.",
            "name_idt": "Philostephanus Comic.",
        },
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Patria Constantinopoleos": {
        "tlg_id": "TLG3120",
        "names": {
            "name_authtab": "Patria Constantinopoleos",
            "name_idt": "Patria Constantinopoleos",
        },
        "works": {
            "<$*DIH/GHSIS PERI\\ TH=S *(AGI/AS *SOFI/AS &(variae lectiones)": [
                "Section",
                "line",
            ],
            "#$*PARASTA/SEIS SU/NTOMOI XRONIKAI/&": ["Section", "line"],
            ")$*DIH/GHSIS PERI\\ TH=S *(AGI/AS *SOFI/AS&": ["Section", "line"],
            "BDe sepulcris imperatorum quae sunt in templo sanctorum apostolorum": [
                "Page",
                "line",
            ],
        },
    },
    "[Dositheus] Hist.": {
        "tlg_id": "TLG1896",
        "names": {"name_authtab": "[Dositheus] Hist.", "name_idt": "[Dositheus] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dexicrates Comic.": {
        "tlg_id": "TLG0442",
        "names": {"name_authtab": "Dexicrates Comic.", "name_idt": "Dexicrates Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Philinus Hist.": {
        "tlg_id": "TLG1969",
        "names": {"name_authtab": "Philinus Hist.", "name_idt": "Philinus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Antileon Hist.": {
        "tlg_id": "TLG2173",
        "names": {"name_authtab": "Antileon Hist.", "name_idt": "Antileon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Historia Alexandri Magni": {
        "tlg_id": "TLG1386",
        "names": {
            "name_authtab": "Historia Alexandri Magni",
            "name_idt": "Historia Alexandri Magni",
        },
        "works": {
            "Recensio $G& (lib. 2)": ["Section", "line"],
            ";Recensio $B& (e cod. Paris. gr. 1685 et cod. Messinensi 62)": [
                "Book",
                "section",
                "line",
            ],
            "Recensio $G& (lib. 1)": ["Section", "line"],
            ",Recensio $D &(e cod. Vat. gr. 1700, 88v-89r)": ["line"],
            "+Recensio $L& (Pseudo-Methodius, redactio 2)": ["Page", "line"],
            "Recensio $F&": ["Section", "line"],
            '"Recensio E (cod. Eton College 163)': ["Chapter", "section", "line"],
            "Recensio $L& (lib. 3)": ["Page", "line"],
            "1Recensio F (cod. Flor. Laurentianus Ashburn 1444)": [
                "Chapter",
                "section",
                "line",
            ],
            "+Recensio $L& (Pseudo-Methodius, redactio 1)": ["Page", "line"],
            "Recensio $E&": ["Chapter", "section", "line"],
            "3Recensio K (cod. 236 Kutlumussiu-Kloster des Athos)": ["Page", "line"],
            '"Recensio $A& sive Recensio vetusta': [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "/Recensio Byzantina poetica (cod. Marcianus 408)": ["line"],
            "'Recensio $B& (e cod. Leidensi Vulc. 93)": ["Book", "section", "line"],
            "&Recensio V (cod. Vind. theol. gr. 244)": ["Page", "line"],
            "Recensio $G& (lib. 3)": ["Section", "line"],
            "Recensio $B&": ["Book", "section", "line"],
            "Recensio poetica (recensio R)": ["line"],
        },
    },
    "Lycophron Soph.": {
        "tlg_id": "TLG2444",
        "names": {"name_authtab": "Lycophron Soph.", "name_idt": "Lycophron Soph."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Ephraem Hist., Poeta": {
        "tlg_id": "TLG3170",
        "names": {
            "name_authtab": "Ephraem Hist. et Poeta",
            "name_idt": "Ephraem Hist., Poeta",
        },
        "works": {
            "Chronicon": [
                "line",
                "î³´î³´",
                "",
                "î³î³",
                "",
                "î³î³",
                '»\x12î³î³\x12\x12î³³î³³\x12\x12î³³î³³\x12\x12î³´¶î³´¶\x12\x13î³´¶î³´¶\x13\x8c§\x14î³¶³î³¶³\x14í\x16î´¶î´¶\x16ºÖ\x92Í\x1aî´³\x1a¿§ù©«ü\x1eî¶î¶\x1e««Öþ"î¶î¶"³Í%î¶î¶%Û¶Â&î´î´&Ñ&îî&Òû´ºí¼½«*îî*½½¿ÀÂÃÉÉ0î¶î¶0ÊÆ¿ÇüÈ2îî2ÈÉ¶ÊÜ3î¶ÊîÌÍÏ§ÐÑ8ó³',
            ]
        },
    },
    "Hermogenes Rhet.": {
        "tlg_id": "TLG0592",
        "names": {"name_authtab": "Hermogenes Rhet.", "name_idt": "Hermogenes Rhet."},
        "works": {
            "": ["$*$*PERI\\ STA/SEWN& !!! TRANSLITERATE", "Section", "line"],
            "$*PERI\\ I)DEW=N LO/GOU&": ["Chapter", "section", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "Progymnasmata [Dub.]": ["Section", "line"],
            "$*PERI\\ EU(RE/SEWS& [Sp.]": ["Chapter", "section", "line"],
            "#$*PERI\\ MEQO/DOU DEINO/THTOS& [Sp.]": ["Section", "line"],
        },
    },
    "Cratetis Epistulae": {
        "tlg_id": "TLG0623",
        "names": {
            "name_authtab": "Cratetis Epistulae",
            "name_idt": "Cratetis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Agathemerus Geogr.": {
        "tlg_id": "TLG0090",
        "names": {
            "name_authtab": "Agathemerus Geogr.",
            "name_idt": "Agathemerus Geogr.",
        },
        "works": {"Geographiae informatio": ["Section", "line"]},
    },
    "Philostorgius Scr. Eccl.": {
        "tlg_id": "TLG2058",
        "names": {
            "name_authtab": "Philostorgius Scr. Eccl.",
            "name_idt": "Philostorgius Scr. Eccl.",
        },
        "works": {
            "5Historia ecclesiastica (fragmenta e passione Artemii)": [
                "Book",
                "fragment",
                "line",
            ],
            "HHistoria ecclesiastica (fragmenta e vita Constantini) (cod. Angelic. 22)": [
                "Book",
                "fragment",
                "line",
            ],
            ".Historia ecclesiastica (fragmenta ap. Photium)": [
                "Book",
                "fragment",
                "line",
            ],
        },
    },
    "Eurytus Phil.": {
        "tlg_id": "TLG1362",
        "names": {"name_authtab": "Eurytus Phil.", "name_idt": "Eurytus Phil."},
        "works": {"Fragmentum": ["Page", "line"], "Testimonia": ["Fragment", "line"]},
    },
    "Eustochius Soph.": {
        "tlg_id": "TLG2499",
        "names": {"name_authtab": "Eustochius Soph.", "name_idt": "Eustochius Soph."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Bion Math., Phil.": {
        "tlg_id": "TLG2153",
        "names": {
            "name_authtab": "Bion Math. et Phil.",
            "name_idt": "Bion Math., Phil.",
        },
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Marci Aurelii Epistula": {
        "tlg_id": "TLG1479",
        "names": {
            "name_authtab": "Marci Aurelii Epistula",
            "name_idt": "Marci Aurelii Epistula",
        },
        "works": {
            "EEpistula ad senatum, qua testatur Christianos victoriae causam fuisse": [
                "Page",
                "line",
            ]
        },
    },
    "Zeno Phil.": {
        "tlg_id": "TLG2294",
        "names": {"name_authtab": "Zeno Phil.", "name_idt": "Zeno Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Boiscus Iamb.": {
        "tlg_id": "TLG2610",
        "names": {"name_authtab": "Boiscus Iamb.", "name_idt": "Boiscus Iamb."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Pisander Epic.": {
        "tlg_id": "TLG0288",
        "names": {"name_authtab": "Pisander Epic.", "name_idt": "Pisander Epic."},
        "works": {
            "Heraclea (fragmenta)": ["Fragment", "line"],
            "Epigramma": ["Book", "epigram", "line"],
        },
    },
    "[Clitophon] Hist.": {
        "tlg_id": "TLG1281",
        "names": {"name_authtab": "[Clitophon] Hist.", "name_idt": "[Clitophon] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Moses Alchem.": {
        "tlg_id": "TLG2181",
        "names": {"name_authtab": "Moses Alchem.", "name_idt": "Moses Alchem."},
        "works": {
            "q$*EU)POI/A KAI\\ EU)TUXI/A TOU= KTISAME/NOU KAI\\ E)PITUXI/A KAMA/TOU KAI\\ MAKROXRONI/A BI/OU &(e cod. Paris. B.N. ": [
                "Volume",
                "page",
                "line",
            ],
            "9$*MWSE/WS DI/PLWSIS &(e cod. Venet. Marc. 299, fol. 185r)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Lamprocles Lyr.": {
        "tlg_id": "TLG0370",
        "names": {"name_authtab": "Lamprocles Lyr.", "name_idt": "Lamprocles Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sthenidas Phil.": {
        "tlg_id": "TLG1695",
        "names": {"name_authtab": "Sthenidas Phil.", "name_idt": "Sthenidas Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Hipparchus Epigr.": {
        "tlg_id": "TLG1433",
        "names": {"name_authtab": "Hipparchus Epigr.", "name_idt": "Hipparchus Epigr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hermocles Lyr.": {
        "tlg_id": "TLG0207",
        "names": {"name_authtab": "Hermocles Lyr.", "name_idt": "Hermocles Lyr."},
        "works": {"Ithyphalli": ["line"]},
    },
    "Epistula Ad Diognetum": {
        "tlg_id": "TLG1350",
        "names": {
            "name_authtab": "Epistula Ad Diognetum",
            "name_idt": "Epistula Ad Diognetum",
        },
        "works": {"Epistula ad Diognetum": ["Chapter", "section", "line"]},
    },
    "Dosiadas Lyr.": {
        "tlg_id": "TLG0208",
        "names": {"name_authtab": "Dosiadas Lyr.", "name_idt": "Dosiadas Lyr."},
        "works": {"Epigramma": ["Book", "epigram", "line"], "$*BWMO/S&": ["line"]},
    },
    "Isaeus Orat.": {
        "tlg_id": "TLG0017",
        "names": {"name_authtab": "Isaeus Orat.", "name_idt": "Isaeus Orat."},
        "works": {
            "De Cleonymo": ["Section", "line"],
            "De Apollodoro": ["Section", "line", "¤<\x14"],
            "De Hagnia": ["Section", "line"],
            "Pro Euphileto": ["Section", "line"],
            "De Aristarcho": ["Section", "line"],
            "De Astyphilo": ["Section", "line"],
            "De Menecle": ["Section", "line"],
            "De Dicaeogene": ["Section", "line"],
            "De Philoctemone": ["Section", "line", ""],
            "Fragmenta": ["Oration", "fragment", "section", "line"],
            "De Pyrrho": ["Section", "line"],
            "De Cirone": ["Section", "line"],
            "De Nicostrato": ["Section", "line"],
        },
    },
    "Anonymus Discipulus Isidori Milesii Mech.": {
        "tlg_id": "TLG4005",
        "names": {
            "name_authtab": "Anonymus Discipulus Isidori Milesii Mech.",
            "name_idt": "Anonymus Discipulus Isidori Milesii Mech.",
        },
        "works": {"(Euclidis elementorum qui fertur liber xv": ["Section", "line"]},
    },
    "Licymnius Lyr.": {
        "tlg_id": "TLG0374",
        "names": {"name_authtab": "Licymnius Lyr.", "name_idt": "Licymnius Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Astrampsychus Magus Onir.": {
        "tlg_id": "TLG2642",
        "names": {
            "name_authtab": "Astrampsychus Magus Onir.",
            "name_idt": "Astrampsychus Magus Onir.",
        },
        "works": {
            "Oracula": ["Chapter", "section", "line"],
            "Sortes": ["Section", "line"],
        },
    },
    "Stephanus Gramm.": {
        "tlg_id": "TLG4028",
        "names": {"name_authtab": "Stephanus Gramm.", "name_idt": "Stephanus Gramm."},
        "works": {
            "": ["Ethnica (epitome)", "Page", "line"],
            "Epigramma": ["Book", "epigram", "line"],
        },
    },
    "Asclepiodotus Tact.": {
        "tlg_id": "TLG0556",
        "names": {
            "name_authtab": "Asclepiodotus Tact.",
            "name_idt": "Asclepiodotus Tact.",
        },
        "works": {"Tactica": ["Chapter", "section", "line"]},
    },
    "Adamantius Judaeus Med.": {
        "tlg_id": "TLG0731",
        "names": {
            "name_authtab": "Adamantius Judaeus Med.",
            "name_idt": "Adamantius Judaeus Med.",
        },
        "works": {
            "De ventis": ["Page", "line"],
            "%Physiognomonica (epitome Matritensis)": ["Section", "line"],
            "Physiognomonica": ["Book", "section", "line"],
        },
    },
    "Sotion Paradox.": {
        "tlg_id": "TLG0587",
        "names": {"name_authtab": "Sotion Paradox.", "name_idt": "Sotion Paradox."},
        "works": {"Fragmenta": ["Section", "line"]},
    },
    "Celsus Phil.": {
        "tlg_id": "TLG1248",
        "names": {"name_authtab": "Celsus Phil.", "name_idt": "Celsus Phil."},
        "works": {"$*)ALHQH\\S LO/GOS&": ["Chapter", "section", "line"]},
    },
    "Strattis Comic.": {
        "tlg_id": "TLG0508",
        "names": {"name_authtab": "Strattis Comic.", "name_idt": "Strattis Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Orion Gramm.": {
        "tlg_id": "TLG2591",
        "names": {"name_authtab": "Orion Gramm.", "name_idt": "Orion Gramm."},
        "works": {
            "Anthologion": ["Title number", "entry", "line"],
            "0Etymologicum (excerpta e cod. regio Paris. 2630)": ["Page", "line"],
            ")Etymologicum (excerpta e cod. regio 2610)": ["Page", "line"],
            ",Etymologicum (excerpta e cod. Vat. gr. 1456)": ["Entry", "line"],
            "Etymologicum": ["", "Alphabetic letter", "page", "line"],
            "/Etymologicum (excerpta e cod. Darmstadino 2773)": [
                "",
                "Alphabetic letter",
                "page",
                "line",
            ],
        },
    },
    "Antimachus Epic.": {
        "tlg_id": "TLG1141",
        "names": {"name_authtab": "Antimachus Epic.", "name_idt": "Antimachus Epic."},
        "works": {
            "": ["Fragmentum [Dub.]", "Fragment", "line"],
            "Fragmentum": ["Fragment", "line"],
        },
    },
    "Heracliti Ephesii Epistulae": {
        "tlg_id": "TLG1411",
        "names": {
            "name_authtab": "Heracliti Ephesii Epistulae",
            "name_idt": "Heracliti Ephesii Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Scholia In Demosthenem": {
        "tlg_id": "TLG5017",
        "names": {
            "name_authtab": "Scholia In Demosthenem",
            "name_idt": "Scholia In Demosthenem",
        },
        "works": {
            "?Scholia in Demosthenem (scholia vetera) (fort. auctore Ulpiano)": [
                "Oration",
                "section",
                "line",
            ]
        },
    },
    "Melito Trag.": {
        "tlg_id": "TLG0825",
        "names": {"name_authtab": "Melito Trag.", "name_idt": "Melito Trag."},
        "works": {"Titulus": ["line"]},
    },
    "Diophantus Comic.": {
        "tlg_id": "TLG0395",
        "names": {"name_authtab": "Diophantus Comic.", "name_idt": "Diophantus Comic."},
        "works": {"Fragmentum": ["Fragment", "line"], "Fragmenta": ["Page", "line"]},
    },
    "Pamprepius Epic.": {
        "tlg_id": "TLG4038",
        "names": {"name_authtab": "Pamprepius Epic.", "name_idt": "Pamprepius Epic."},
        "works": {" Fragmenta (P. Vindob. 29788 A-C)": ["Fragment", "line"]},
    },
    "Evagrius Scr. Eccl.": {
        "tlg_id": "TLG4110",
        "names": {
            "name_authtab": "Evagrius Scr. Eccl.",
            "name_idt": "Evagrius Scr. Eccl.",
        },
        "works": {
            "Capita paraenetica": ["Chapter", "line"],
            "6De octo spiritibus malitiae (sub nomine Nili Ancyrani)": [
                "Volume",
                "page",
                "line",
            ],
            "Practicus (capita centum)": ["\x19Prologue-chapter-epilogue", "line"],
            "*Scholia in Proverbia (fragmenta e catenis)": ["Scholion", "line"],
            "9Institutio sive Paraenesis ad monachos (recensio brevior)": [
                "Volume",
                "page",
                "line",
            ],
            "0Tractatus ad Eulogium (sub nomine Nili Ancyrani)": [
                "Volume",
                "page",
                "line",
            ],
            "BDe vitiis quae opposita sunt virtutibus (sub nomine Nili Ancyrani)": [
                "Volume",
                "page",
                "line",
            ],
            "5De malignis cogitationibus (sub nomine Nili Ancyrani)": [
                "Volume",
                "page",
                "line",
            ],
            "1Spiritales sententiae per alphabeticum dispositae": ["Chapter", "line"],
            "Rerum monachalium rationes": ["Volume", "page", "line"],
            "$*EI)S TO\\ PIPI& [Sp.]": ["line"],
            "aDe magistris et discipulis (sub nomine Nili Ancyrani) (fragmenta e codd. Paris. gr. 1188 %7 1066)": [
                "line"
            ],
            ":Capitula xxxiii (definitiones passionum animae rationalis)": [
                "Volume",
                "page",
                "line",
            ],
            "Aliae sententiae": ["Chapter", "line"],
            "Sententiae ad monachos": ["Sententia", "line"],
            "Sententiae ad virginem": ["Sententia", "line"],
            "-Scholia in Ecclesiasten (fragmenta e catenis)": ["Scholion", "line"],
            " Expositio in Proverbia Salomonis": ["Page", "line"],
            "&De oratione (sub nomine Nili Ancyrani)": ["Volume", "page", "line"],
            "Gnosticus (fragmenta Graeca)": ["Chapter", "line"],
        },
    },
    "Alcmaeonis": {
        "tlg_id": "TLG0696",
        "names": {"name_authtab": "Alcmaeonis", "name_idt": "Alcmaeonis"},
        "works": {"Alcmaeonis (fragmenta)": ["Fragment", "line"]},
    },
    "Cassius Dio Hist.": {
        "tlg_id": "TLG0385",
        "names": {
            "name_authtab": "Cassius Dio Hist., Dio Cassius",
            "name_idt": "Cassius Dio Hist.",
        },
        "works": {
            "": ["Historiae Romanae", "Book", "chapter", "section", "line"],
            "GHistoriae Romanae (excerpta Constantiniana cum Dionis verbis composita)": [
                "Fragment",
                "line",
            ],
            "*Historiae Romanae (versio 2 in volumine 3)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "Reliquiae incertae sedis": ["Fragment", "section", "line"],
            "*Historiae Romanae (versio 1 in volumine 2)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            ".Historiae Romanae (ap. Photium, Bibl. cod. 71)": ["line"],
            "*Historiae Romanae (versio 2 in volumine 2)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "*Historiae Romanae (versio 1 in volumine 1)": ["Page", "line"],
            "@Historiae Romanae (Joannis Antiocheni excerpta e Dione derivata)": [
                "Page",
                "line",
            ],
            "*Historiae Romanae (versio 2 in volumine 1)": ["Page", "line"],
            "'Historiae Romanae (excerpta Salmasiana)": ["Page", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "%Historiae Romanae (Xiphilini epitome)": [
                "Dindorf-Stephanus page",
                "line",
            ],
            "*Historiae Romanae (versio 1 in volumine 3)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "%Historiae Romanae (excerpta Planudea)": ["Excerpt", "line"],
            "*Historiae Romanae (versio 3 in volumine 1)": ["Page", "line"],
            "@Historiae Romanae (Petri Patricii excerpta Vaticana sive Maiana)": [
                "Excerpt",
                "line",
            ],
        },
    },
    "Joannes Med.": {
        "tlg_id": "TLG0727",
        "names": {"name_authtab": "Joannes Med.", "name_idt": "Joannes Med."},
        "works": {
            "1Commentarii in Hippocratis librum de natura pueri": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Calliphon et Democedes Med., Phil.": {
        "tlg_id": "TLG2218",
        "names": {
            "name_authtab": "Calliphon et Democedes Med. et Phil.",
            "name_idt": "Calliphon et Democedes Med., Phil.",
        },
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Joannes Antiochenus Hist.": {
        "tlg_id": "TLG4394",
        "names": {
            "name_authtab": "Joannes Antiochenus Hist.",
            "name_idt": "Joannes Antiochenus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Moderatus Phil.": {
        "tlg_id": "TLG1890",
        "names": {"name_authtab": "Moderatus Phil.", "name_idt": "Moderatus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Theodorus Math.": {
        "tlg_id": "TLG2237",
        "names": {"name_authtab": "Theodorus Math.", "name_idt": "Theodorus Math."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Clearchus Comic.": {
        "tlg_id": "TLG0432",
        "names": {"name_authtab": "Clearchus Comic.", "name_idt": "Clearchus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Fragmenta Adespota (SH)": {
        "tlg_id": "TLG2646",
        "names": {
            "name_authtab": "Fragmenta Adespota (SH)",
            "name_idt": "Fragmenta Adespota (SH)",
        },
        "works": {"Frustula adespota ex auctoribus": ["Fragment", "line"]},
    },
    "Leontius Scr. Eccl.": {
        "tlg_id": "TLG2914",
        "names": {
            "name_authtab": "Leontius Scr. Eccl.",
            "name_idt": "Leontius Scr. Eccl.",
        },
        "works": {
            "In Job (homilia 5)": ["line"],
            "IIn nativitatem Christi (homilia 12) (olim sub nomine Joannis Chrysostomi)": [
                "line"
            ],
            "?In ramos palmarum (homilia 3a) (sub nomine Joannis Chrysostomi)": [
                "line"
            ],
            "In mesopentecosten (homilia 10)": ["line"],
            "CIn ramos palmarum (homilia 3) (olim sub nomine Joannis Chrysostomi)": [
                "line"
            ],
            "In Job (homilia 4)": ["line"],
            ".In natale sancti Joannis prophetae (homilia 1)": ["line"],
            "1In uxorem Job et in proditionem Judae (homilia 6)": ["line"],
            "AIn pentecosten (homilia 13) (olim sub nomine Joannis Chrysostomi)": [
                "line"
            ],
            "GIn transfigurationem (homilia 14) (olim sub nomine Joannis Chrysostomi)": [
                "line"
            ],
            "In pentecosten (homilia 11)": ["line"],
            "In sanctum pascha (homilia 8)": ["line"],
            "!In sanctam parasceven (homilia 7)": ["line"],
            "$In resurrectionem domini (homilia 9)": ["line"],
            "In ramos palmarum (homilia 2)": ["line"],
        },
    },
    "Lucianus Soph.": {
        "tlg_id": "TLG0062",
        "names": {"name_authtab": "Lucianus Soph.", "name_idt": "Lucianus Soph."},
        "works": {
            "": ["Dialogi mortuorum", "Dialogue", "section", "line"],
            "Dialogi deorum": ["Dialogue", "section", "line"],
            "Icaromenippus": ["Section", "line"],
            "Cataplus": ["Section", "line"],
            "Timon": ["Section", "line"],
            "Muscae encomium": ["Section", "line"],
            "Zeuxis": ["Section", "line"],
            "De astrologia": ["Section", "line"],
            "Gallus": ["Section", "line"],
            "Herodotus": ["Section", "line"],
            "Rhetorum praeceptor": ["Section", "line"],
            "Saturnalia": ["Section", "line"],
            "Abdicatus": ["Section", "line"],
            "De domo": ["Section", "line", ""],
            "Charon sive contemplantes": ["Section", "line"],
            "Patriae encomium": ["Section", "line", "\x8c", ">\x12"],
            "Pro imaginibus": ["Section", "line"],
            "Calumniae non temere credendum": ["Section", "line"],
            "Scytha": ["Section", "line"],
            "Verae historiae": ["Chapter", "section", "line"],
            "Menippus sive necyomantia": ["Section", "line"],
            "Demonax": ["Section", "line"],
            "De saltatione": ["Section", "line"],
            "Symposium": ["Section", "line"],
            "De morte Peregrini": ["Section", "line"],
            "De sacrificiis": ["Section", "line"],
            "Phalaris": ["Chapter", "section", "line"],
            "Juppiter confutatus": ["Section", "line"],
            "+De mercede conductis potentium familiaribus": ["Section", "line"],
            "Nigrinus": ["Section", "line"],
            "Apologia": ["Section", "line"],
            "Eunuchus": ["Section", "line"],
            "De luctu": ["Section", "line"],
            "Dialogi marini": ["Dialogue", "section", "line"],
            "Juppiter tragoedus": ["Section", "line"],
            "Hesiodus": ["Section", "line"],
            "Harmonides": ["Section", "line"],
            "'Lis consonantium (%6 Judicium vocalium)": ["Section", "line"],
            "Revivescentes sive piscator": ["Section", "line"],
            "Alexander": ["Section", "line"],
            "Electrum": ["Section", "line"],
            "Bis accusatus sive tribunalia": ["Section", "line"],
            "Dipsades": ["Section", "line"],
            "Philopseudes sive incredulus": ["Section", "line"],
            "Fugitivi": ["Section", "line"],
            "Lexiphanes": ["Section", "line"],
            "Prometheus es in verbis": ["Section", "line"],
            "*Adversus indoctum et libros multos ementem": ["Section", "line"],
            "Vitarum auctio": ["Section", "line"],
            "Dialogi meretricii": ["Dialogue", "section", "line"],
            "Prometheus": ["Section", "line"],
            "Toxaris vel amicitia": ["Section", "line"],
            "Hermotimus": ["Section", "line"],
            "De Syria dea": ["Section", "line"],
            "Podagra": ["line"],
            "Anacharsis": ["Section", "line"],
            "Pro lapsu inter salutandum": ["Section", "line"],
            "Somnium sive vita Luciani": ["Section", "line"],
            "'De parasito sive artem esse parasiticam": ["Section", "line"],
            "Hercules": ["Section", "line"],
            "Hippias": ["Section", "line"],
            "Imagines": ["Section", "line"],
            "Macrobii": ["Section", "line"],
            "Deorum concilium": ["Section", "line"],
            "!Quomodo historia conscribenda sit": ["Section", "line"],
            "Navigium": ["Section", "line"],
            "Soloecista": ["Section", "line"],
            "Dearum judicium": ["Section", "line"],
            "Bacchus": ["Section", "line"],
            "Pseudologista": ["Section", "line"],
            "Tyrannicida": ["Section", "line"],
        },
    },
    "Mnesimachus Comic.": {
        "tlg_id": "TLG0476",
        "names": {
            "name_authtab": "Mnesimachus Comic.",
            "name_idt": "Mnesimachus Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Pisistrati Epistula": {
        "tlg_id": "TLG0049",
        "names": {
            "name_authtab": "Pisistrati Epistula",
            "name_idt": "Pisistrati Epistula",
        },
        "works": {"Epistula": ["line"]},
    },
    "Critias Eleg., Phil., Trag.": {
        "tlg_id": "TLG0319",
        "names": {
            "name_authtab": "Critias Eleg., Phil. et Trag.",
            "name_idt": "Critias Eleg., Phil., Trag.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
            "2Pirithous (fragmenta) (P. Oxy. 17.2078 %7 50.3531)": ["Fragment", "line"],
        },
    },
    "Phylarchus Hist.": {
        "tlg_id": "TLG1609",
        "names": {"name_authtab": "Phylarchus Hist.", "name_idt": "Phylarchus Hist."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Didache XII Apostolorum": {
        "tlg_id": "TLG1311",
        "names": {
            "name_authtab": "Didache XII Apostolorum",
            "name_idt": "Didache XII Apostolorum",
        },
        "works": {"$*DIDAXAI\\ TW=N A)POSTOLW=N&": ["Chapter", "section", "line"]},
    },
    "Philyllius Comic.": {
        "tlg_id": "TLG0494",
        "names": {"name_authtab": "Philyllius Comic.", "name_idt": "Philyllius Comic."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Apollodorus Phil.": {
        "tlg_id": "TLG2319",
        "names": {"name_authtab": "Apollodorus Phil.", "name_idt": "Apollodorus Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Herillus Phil.": {
        "tlg_id": "TLG2169",
        "names": {"name_authtab": "Herillus Phil.", "name_idt": "Herillus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aristias Trag.": {
        "tlg_id": "TLG0305",
        "names": {"name_authtab": "Aristias Trag.", "name_idt": "Aristias Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Antagoras Epic.": {
        "tlg_id": "TLG0215",
        "names": {"name_authtab": "Antagoras Epic.", "name_idt": "Antagoras Epic."},
        "works": {"Epigrammata": ["Book", "epigram", "line"]},
    },
    "Tynnichus Lyr.": {
        "tlg_id": "TLG0367",
        "names": {"name_authtab": "Tynnichus Lyr.", "name_idt": "Tynnichus Lyr."},
        "works": {"Fragmentum": ["line"]},
    },
    "Eusebius Scr. Eccl.": {
        "tlg_id": "TLG4124",
        "names": {
            "name_authtab": "Eusebius Scr. Eccl.",
            "name_idt": "Eusebius Scr. Eccl.",
        },
        "works": {
            ".Fragmenta in epistulam ad Galatas (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            ";Fragmentum in epistulam i ad Corinthios (in catenis) [Dub.]": [
                "Page",
                "line",
            ],
        },
    },
    "Archytas Phil.": {
        "tlg_id": "TLG1177",
        "names": {
            "name_authtab": "Pseudo-Archytas Phil.",
            "name_idt": "Archytas Phil.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Hermonax Epic.": {
        "tlg_id": "TLG1425",
        "names": {"name_authtab": "Hermonax Epic.", "name_idt": "Hermonax Epic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Perictione Phil.": {
        "tlg_id": "TLG1572",
        "names": {"name_authtab": "Perictione Phil.", "name_idt": "Perictione Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Historia Monachorum In Aegypto": {
        "tlg_id": "TLG2744",
        "names": {
            "name_authtab": "Historia Monachorum In Aegypto",
            "name_idt": "Historia Monachorum In Aegypto",
        },
        "works": {"Historia monachorum in Aegypto": ["Vita", "line"]},
    },
    "Arcesilaus Comic.": {
        "tlg_id": "TLG0520",
        "names": {"name_authtab": "Arcesilaus Comic.", "name_idt": "Arcesilaus Comic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Parodica Anonyma": {
        "tlg_id": "TLG1801",
        "names": {"name_authtab": "Parodica Anonyma", "name_idt": "Parodica Anonyma"},
        "works": {
            "Incertorum fragmenta": ["Fragment", "line"],
            "Fragmenta dubia": ["Fragment", "line"],
        },
    },
    "Anonymus Alexandri Phil.": {
        "tlg_id": "TLG1132",
        "names": {
            "name_authtab": "Anonymus Alexandri Phil.",
            "name_idt": "Anonymus Alexandri Phil.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Apollophanes Phil.": {
        "tlg_id": "TLG2168",
        "names": {
            "name_authtab": "Apollophanes Phil.",
            "name_idt": "Apollophanes Phil.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Periander Phil.": {
        "tlg_id": "TLG0629",
        "names": {"name_authtab": "Periander Phil.", "name_idt": "Periander Phil."},
        "works": {"Epistulae [Sp.]": ["Epistle", "line"]},
    },
    "Etymologia Alphabeti": {
        "tlg_id": "TLG4287",
        "names": {
            "name_authtab": "Etymologia Alphabeti",
            "name_idt": "Etymologia Alphabeti",
        },
        "works": {"Etymologia alphabeti": ["Page", "line"]},
    },
    "Leucippus Phil.": {
        "tlg_id": "TLG1461",
        "names": {"name_authtab": "Leucippus Phil.", "name_idt": "Leucippus Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Choerilus Trag.": {
        "tlg_id": "TLG0302",
        "names": {"name_authtab": "Choerilus Trag.", "name_idt": "Choerilus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pappus Math.": {
        "tlg_id": "TLG2032",
        "names": {"name_authtab": "Pappus Math.", "name_idt": "Pappus Math."},
        "works": {
            "Synagoge": ["Book", "page", "line"],
            "2Commentaria in Ptolemaei syntaxin mathematicam 5-6": ["Page", "line"],
        },
    },
    "Vitae Aristotelis": {
        "tlg_id": "TLG2695",
        "names": {"name_authtab": "Vitae Aristotelis", "name_idt": "Vitae Aristotelis"},
        "works": {
            "DVita Marciana (post epitomen Ptolemaeeae vitae) (cod. Marc. gr. 257)": [
                "Section",
                "line",
            ],
            ".Vita vulgata (post epitomen Ptolemaeeae vitae)": ["Section", "line"],
        },
    },
    "Aeschines Orat.": {
        "tlg_id": "TLG0026",
        "names": {"name_authtab": "Aeschines Orat.", "name_idt": "Aeschines Orat."},
        "works": {
            "In Timarchum": ["Section", "line"],
            "In Ctesiphontem": ["Section", "line"],
            "Epistulae [Sp.]": ["Epistle", "section", "line"],
            "De falsa legatione": ["Section", "line"],
        },
    },
    "Philo Med.": {
        "tlg_id": "TLG0706",
        "names": {"name_authtab": "Philo Med.", "name_idt": "Philo Med."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Melampus Scriptor De Divinatione": {
        "tlg_id": "TLG1365",
        "names": {
            "name_authtab": "Melampus Scriptor De Divinatione",
            "name_idt": "Melampus Scriptor De Divinatione",
        },
        "works": {
            "@$*PERI\\ PALMW=N MANTIKH\\ PRO\\S *PTOLEMAI=ON BASILE/A& (versio A)": [
                "Section",
                "line",
            ],
            "M$*PERI\\ PALMW=N A)RXOME/NOU A)PO\\ KEFALH=S E(/WS PODW=N& (e cod. Berol. 1577)": [
                "Section",
                "line",
            ],
            "A$*PERI\\ PALMW=N TI/ SHMAI/NOUSIN E)N E(KA/STW| ME/REI& (versio P)": [
                "Section",
                "line",
            ],
            ";$*PERI\\ E)LAIW=N TOU= SW/MATOS PRO\\S *PTOLEMAI=ON BASILE/A&": [
                "Page",
                "line",
            ],
        },
    },
    "Ar(i)aethus Hist.": {
        "tlg_id": "TLG2215",
        "names": {"name_authtab": "Ar(i)aethus Hist.", "name_idt": "Ar(i)aethus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Telegonia": {
        "tlg_id": "TLG4163",
        "names": {"name_authtab": "Telegonia", "name_idt": "Telegonia"},
        "works": {"Telegonia (fragmentum)": ["Fragment", "line"]},
    },
    "Apion Gramm.": {
        "tlg_id": "TLG1152",
        "names": {"name_authtab": "Apion Gramm.", "name_idt": "Apion Gramm."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta de glossis Homericis": ["Fragment", "line"],
        },
    },
    "Dionis Epistulae": {
        "tlg_id": "TLG1327",
        "names": {"name_authtab": "Dionis Epistulae", "name_idt": "Dionis Epistulae"},
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Balbilla Lyr.": {
        "tlg_id": "TLG1213",
        "names": {"name_authtab": "Julia Balbilla Lyr.", "name_idt": "Balbilla Lyr."},
        "works": {"Epigrammata": ["Epigram", "line"]},
    },
    "Nessas Phil.": {
        "tlg_id": "TLG2456",
        "names": {"name_authtab": "Nessas Phil.", "name_idt": "Nessas Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Theognostus Gramm.": {
        "tlg_id": "TLG3128",
        "names": {
            "name_authtab": "Theognostus Gramm.",
            "name_idt": "Theognostus Gramm.",
        },
        "works": {"Canones sive De orthographia": ["Section", "line"]},
    },
    "Clemens Romanus et Clementina Theol.": {
        "tlg_id": "TLG1271",
        "names": {
            "name_authtab": "Clemens Romanus Theol. et Clementina",
            "name_idt": "Clemens Romanus et Clementina Theol.",
        },
        "works": {
            "": ["Contestatio [Sp.]", "Chapter", "section", "line"],
            " Recognitiones (ex Eusebio) [Sp.]": ["Book", "chapter", "line"],
            "Epistula i ad Corinthios": ["Chapter", "section", "line"],
            "Recognitiones [Sp.]": ["Book", "chapter", "section", "line"],
            "CPseudo-Clementina (epitome de gestis Petri praemetaphrastica) [Sp.]": [
                "Section",
                "line",
            ],
            "'Recognitiones (e Pseudo-Caesario) [Sp.]": ["Book", "chapter", "line"],
            "Epistula Petri ad Jacobum [Sp.]": ["Chapter", "section", "line"],
            "#Epistula Clementis ad Jacobum [Sp.]": ["Chapter", "section", "line"],
            "DPseudo-Clementina (epitome altera auctore Symeone Metaphrasta) [Sp.]": [
                "Section",
                "line",
            ],
            "Epistulae de virginitate [Sp.]": ["Book", "chapter", "section", "line"],
            "Homiliae [Sp.]": ["Homily", "chapter", "section", "line"],
            "Epistula ii ad Corinthios [Sp.]": ["Chapter", "section", "line"],
        },
    },
    "Praxilla Lyr.": {
        "tlg_id": "TLG0372",
        "names": {"name_authtab": "Praxilla Lyr.", "name_idt": "Praxilla Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philippus Hist.": {
        "tlg_id": "TLG1590",
        "names": {"name_authtab": "Philippus Hist.", "name_idt": "Philippus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cineas Rhet.": {
        "tlg_id": "TLG2417",
        "names": {"name_authtab": "Cineas Rhet.", "name_idt": "Cineas Rhet."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Theages Phil.": {
        "tlg_id": "TLG1710",
        "names": {"name_authtab": "Theages Phil.", "name_idt": "Theages Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Diocles Comic.": {
        "tlg_id": "TLG0443",
        "names": {"name_authtab": "Diocles Comic.", "name_idt": "Diocles Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Philetaerus Comic.": {
        "tlg_id": "TLG0489",
        "names": {
            "name_authtab": "Philetaerus Comic.",
            "name_idt": "Philetaerus Comic.",
        },
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Archemachus Hist.": {
        "tlg_id": "TLG1174",
        "names": {"name_authtab": "Archemachus Hist.", "name_idt": "Archemachus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Menophilus Poeta": {
        "tlg_id": "TLG2631",
        "names": {"name_authtab": "Menophilus Poeta", "name_idt": "Menophilus Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Joel Chronogr.": {
        "tlg_id": "TLG3140",
        "names": {"name_authtab": "Joel Chronogr.", "name_idt": "Joel Chronogr."},
        "works": {"Chronographia compendiaria": ["Page", "line"]},
    },
    "Oratio Josephi": {
        "tlg_id": "TLG1552",
        "names": {"name_authtab": "Oratio Josephi", "name_idt": "Oratio Josephi"},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Paron Phil.": {
        "tlg_id": "TLG2227",
        "names": {"name_authtab": "Paron Phil.", "name_idt": "Paron Phil."},
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "Chares Gnom.": {
        "tlg_id": "TLG1256",
        "names": {"name_authtab": "Chares Gnom.", "name_idt": "Chares Gnom."},
        "works": {"Sententiae": ["Sententia", "line"]},
    },
    "Philoxenus Gramm.": {
        "tlg_id": "TLG1602",
        "names": {"name_authtab": "Philoxenus Gramm.", "name_idt": "Philoxenus Gramm."},
        "works": {
            "Fragmenta": [
                "Fragment",
                "line",
                "³³³",
                "³³",
                '³³³³\x12³³¶³³\x14³´³\x15³´\x15´´\x16´³´¶\x16´\x16´´\x16´\x16´³¶³´ ¶³¶"',
            ]
        },
    },
    "Anaxippus Comic.": {
        "tlg_id": "TLG0407",
        "names": {"name_authtab": "Anaxippus Comic.", "name_idt": "Anaxippus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Anaximenes Phil.": {
        "tlg_id": "TLG0617",
        "names": {"name_authtab": "Anaximenes Phil.", "name_idt": "Anaximenes Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Anaxagoras Phil.": {
        "tlg_id": "TLG0713",
        "names": {"name_authtab": "Anaxagoras Phil.", "name_idt": "Anaxagoras Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Euthycles Comic.": {
        "tlg_id": "TLG0462",
        "names": {"name_authtab": "Euthycles Comic.", "name_idt": "Euthycles Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Heraclitus Paradox.": {
        "tlg_id": "TLG1413",
        "names": {
            "name_authtab": "Heraclitus Paradox.",
            "name_idt": "Heraclitus Paradox.",
        },
        "works": {"": ["De incredibilibus", "Section", "line"]},
    },
    "Pelagius Alchem.": {
        "tlg_id": "TLG2019",
        "names": {"name_authtab": "Pelagius Alchem.", "name_idt": "Pelagius Alchem."},
        "works": {
            "j$*PELAGI/OU FILOSO/FOU PERI\\ TH=S QEI/AS TAU/THS KAI\\ I(ERA=S TE/XNHS &(e cod. Venet. Marc. 299, fol. 62v)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "[Dercyllus] Hist.": {
        "tlg_id": "TLG2196",
        "names": {"name_authtab": "[Dercyllus] Hist.", "name_idt": "[Dercyllus] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "(H)eren(n)ius Philo Gramm., Hist.": {
        "tlg_id": "TLG1416",
        "names": {
            "name_authtab": "(H)eren(n)ius Philo Gramm. et Hist.",
            "name_idt": "(H)eren(n)ius Philo Gramm., Hist.",
        },
        "works": {
            "qDe diversis verborum significationibus (%6 $*PERI\\ DIAFO/ROUS SHMASI/AS KAT' A)LFA/BHTON&) (epitome operis Herenn": [
                "",
                "Alphabetic letter",
                "entry",
                "line",
                "Æíî",
                "óîê",
                "ë\x0f\x0f\x10ú\x10",
                "\x10ú¿",
                "",
                "",
                "",
            ],
            "qDe aetatum cognitione (%6 $*GNW=SIS PERI\\ H(LIKIW=N& (epitome opusculi sub nomine Herennii Philonis) (e codd. Amb": [
                "line"
            ],
            "Testimonia": ["line", "fragment", "line"],
            "qDe propria dictione (%6$ *PERI\\ KURIOLECI/AS& (epitome operis sub nomine Herennii Philonis) (e cod. Venet. Marcia": [
                "Entry",
                "line",
            ],
            "qDe diversis verborum significationibus (%6 $*PERI\\ DIAFO/ROUS SHMASI/AS&) (epitome operis Herennii Philonis) (e c": [
                "",
                "Alphabetic letter",
                "entry",
                "line",
            ],
            "Fragmenta": ["Fragment", "line", "ÈÊ", "", "\x14\x15\x15\x16\x16"],
            "qDe adfinium vocabulorum differentia (lexeis additae e similibus epitomis operis ejusdem cum titulis aliis e codic": [
                "Lexical entry",
                "line",
            ],
        },
    },
    "Hippodamus Phil.": {
        "tlg_id": "TLG1436",
        "names": {"name_authtab": "Hippodamus Phil.", "name_idt": "Hippodamus Phil."},
        "works": {
            "Fragmenta [Sp.]": ["Page", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Armenidas Hist.": {
        "tlg_id": "TLG0360",
        "names": {"name_authtab": "Armenidas Hist.", "name_idt": "Armenidas Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Julianus Scr. Eccl.": {
        "tlg_id": "TLG4105",
        "names": {
            "name_authtab": "Julianus Scr. Eccl.",
            "name_idt": "Julianus Scr. Eccl.",
        },
        "works": {"Commentarius in Job": ["Page", "line"]},
    },
    "Leschides Epic.": {
        "tlg_id": "TLG1967",
        "names": {"name_authtab": "Leschides Epic.", "name_idt": "Leschides Epic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Theagenes Phil.": {
        "tlg_id": "TLG2275",
        "names": {"name_authtab": "Theagenes Phil.", "name_idt": "Theagenes Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Pancrates Epic.": {
        "tlg_id": "TLG1555",
        "names": {"name_authtab": "Pancrates Epic.", "name_idt": "Pancrates Epic."},
        "works": {
            "Fragmentum": ["line", "fragment", "line"],
            "Fragmenta": ["\x0fFragment+column", "line"],
            "Testimonium": ["line", "fragment", "line"],
        },
    },
    "Philostephanus Hist.": {
        "tlg_id": "TLG0584",
        "names": {
            "name_authtab": "Philostephanus Hist.",
            "name_idt": "Philostephanus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dionysius Halicarnassensis Hist., Rhet.": {
        "tlg_id": "TLG0081",
        "names": {
            "name_authtab": "Dionysius Halicarnassensis Hist. et Rhet.",
            "name_idt": "Dionysius Halicarnassensis Hist., Rhet.",
        },
        "works": {
            "De Isaeo": ["Section", "line"],
            "Antiquitates Romanae": [
                "Book",
                "chapter",
                "section",
                "line",
                "\x92\x12º\x13¤\x8e\x92\x17\x92\x8c\x92\x1b0Iby«ÇßI\x1b",
            ],
            "Ad Ammaeum": ["Section", "line"],
            "Epistula ad Pompeium Geminum": ["Chapter", "section", "line"],
            "Ars rhetorica [Sp.]": ["Chapter", "section", "line"],
            "De Dinarcho": ["Section", "line"],
            "De Isocrate": ["Section", "line"],
            "De imitatione (fragmenta)": ["Fragment", "line"],
            "/De Thucydidis idiomatibus (epistula ad Ammaeum)": ["Section", "line"],
            "De compositione verborum": ["Section", "line"],
            "Testimonium": ["line", "fragment", "line"],
            ".Libri secundi de antiquis oratoribus reliquiae": ["Section", "line"],
            "De Demosthenis dictione": ["Section", "line"],
            '"De compositione verborum (epitome)': ["Section", "line"],
            "De Thucydide": ["Section", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "De antiquis oratoribus": ["Section", "line"],
            "De Lysia": ["Section", "line"],
        },
    },
    "Dexippus Hist.": {
        "tlg_id": "TLG2141",
        "names": {
            "name_authtab": "Publius Herennius Dexippus Hist.",
            "name_idt": "Dexippus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cosmas Hieromonachus Alchem.": {
        "tlg_id": "TLG4330",
        "names": {
            "name_authtab": "Cosmas Hieromonachus Alchem.",
            "name_idt": "Cosmas Hieromonachus Alchem.",
        },
        "works": {
            "q$*(ERMHNEI/A TH=S E)PISTH/MHS TH=S XRUSOPOII/AS I(EROMONA/XOU TOU= *KOSMA= &(e cod. Paris. B.N. gr. 2327, fol. 15": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Maximus Rhet.": {
        "tlg_id": "TLG2025",
        "names": {"name_authtab": "Maximus Rhet.", "name_idt": "Maximus Rhet."},
        "works": {
            "C$*PERI\\ TW=N A)LU/TWN A)NTIQE/SEWN &(fort. auctore Maximo Byzantio)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Iophon Trag.": {
        "tlg_id": "TLG0311",
        "names": {"name_authtab": "Iophon Trag.", "name_idt": "Iophon Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "[Agathon] Hist.": {
        "tlg_id": "TLG2566",
        "names": {"name_authtab": "[Agathon] Hist.", "name_idt": "[Agathon] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Alexis Comic.": {
        "tlg_id": "TLG0402",
        "names": {"name_authtab": "Alexis Comic.", "name_idt": "Alexis Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Diophantus Hist.": {
        "tlg_id": "TLG2539",
        "names": {"name_authtab": "Diophantus Hist.", "name_idt": "Diophantus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Archias Epigr.": {
        "tlg_id": "TLG0127",
        "names": {
            "name_authtab": "Aulus Licinius Archias Epigr.",
            "name_idt": "Archias Epigr.",
        },
        "works": {"Epigramma": ["Epigram", "line"]},
    },
    "Patrocles Hist.": {
        "tlg_id": "TLG2479",
        "names": {"name_authtab": "Patrocles Hist.", "name_idt": "Patrocles Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Joannes Malalas Chronogr.": {
        "tlg_id": "TLG2871",
        "names": {
            "name_authtab": "Joannes Malalas Chronogr.",
            "name_idt": "Joannes Malalas Chronogr.",
        },
        "works": {
            "@Chronologica (fort. auctore anonymo excerptorum chronologicorum)": [
                "Page",
                "line",
            ],
            "Chronographia": ["Page", "line"],
            ".Chronographia (eclogae e cod. Paris. gr. 1336)": ["Page", "line"],
        },
    },
    "Scholia In Pindarum": {
        "tlg_id": "TLG5034",
        "names": {
            "name_authtab": "Scholia In Pindarum",
            "name_idt": "Scholia In Pindarum",
        },
        "works": {
            "bScholia in Pythia v-vii (scholia vetera et recentiora Thomae Magistri et Triclinii) (e cod. Flor.)": [
                "Ode",
                "scholion",
                "line",
            ],
            "6Capitula ad praefationem scholiorum ad Pindari carmina": ["Page", "line"],
            "$Scholia in Pindarum (scholia vetera)": ["Ode", "scholion", "line"],
            "3Scholia in paeanes (scholia vetera) (P. Oxy. 5.841)": [
                "Paean",
                "scholion",
                "line",
            ],
            "qScholia et glossae in Olympia et Pythia (scholia recentiora Triclinii, Thomae Magistri, Moschopuli, Germani) (col": [
                "Ode-treatise",
                "\x10scholion-section",
                "line",
            ],
            "^Scholia in Nemea et Isthmia (scholia vetera et recentiora partim Thomae Magistri et Triclinii)": [
                "Ode",
                "scholion",
                "line",
            ],
            "mScholia in Pindarum (scholia vetera et recentiora partim Thomae Magistri et Alexandri Phortii) (e cod. Patm.)": [
                "Ode",
                "scholion",
                "line",
            ],
        },
    },
    "Timachidas Hist.": {
        "tlg_id": "TLG1732",
        "names": {"name_authtab": "Timachidas Hist.", "name_idt": "Timachidas Hist."},
        "works": {"Fragmenta et tituli": ["Fragment", "line"]},
    },
    "Scholia In Theocritum": {
        "tlg_id": "TLG5038",
        "names": {
            "name_authtab": "Scholia In Theocritum",
            "name_idt": "Scholia In Theocritum",
        },
        "works": {
            "&Scholia in Theocritum (scholia vetera)": [
                "\x1aProlegomenon-anecdote-poem",
                "section-verse",
                "line",
            ]
        },
    },
    "Heraclides Gramm.": {
        "tlg_id": "TLG1408",
        "names": {"name_authtab": "Heraclides Gramm.", "name_idt": "Heraclides Gramm."},
        "works": {
            "T$*PERI\\ DUSKLI/TWN R(HMA/TWN &(fragmentum) (P. Rain. 3.33A %6 P. Vindob. gr. 29815A)": [
                "line"
            ],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Hephaestion Gramm.": {
        "tlg_id": "TLG1402",
        "names": {
            "name_authtab": "Hephaestion Gramm.",
            "name_idt": "Hephaestion Gramm.",
        },
        "works": {
            "De poematis": ["Page", "line"],
            "Enchiridion de metris": ["Page", "line"],
            "Introductio metrica": ["Page", "line"],
            "De signis": ["Page", "line"],
            "Fragmenta Hephaestionea": ["Page", "line"],
        },
    },
    "Scholia In Platonem": {
        "tlg_id": "TLG5035",
        "names": {
            "name_authtab": "Scholia In Platonem",
            "name_idt": "Scholia In Platonem",
        },
        "works": {
            "0Scholia in Platonem (scholia recentiora Arethae)": [
                "Dialogue",
                "Stephanus page",
                "line",
            ],
            "$Scholia in Platonem (scholia vetera)": [
                "Dialogue",
                "Stephanus page",
                "line",
                "ÐÝ",
                "Ç¿¿óÉ×óúó\x17ÍîÆ\x18ÈÍ\x18ÈÍí\x18Éî\x92\x19Íë\x19Ã\x19ÒÇÌÛóûóÍóÇíó&ùóó(Ãó)Íî»)ÌùöúÉÊóó÷óÇÉ:îÍÛà;¾ÎÜóë>?Êóö÷?Öú?íüó?Óó??óÃÃÐÐíÐÓíÐü\x0e\x0eÈ\x0fí\x0f\x0fÃí\x10Ì\x10Ìù\x10",
                "Ð",
                "Ç\x15\x17Íî\x18ÈÍ\x18ÈÍ\x18Éî\x19Í\x19Ã\x19Ò&ù&&ó(Ã)Íî)Ìù/ó888:î;;;;Û;>?Êó?Ö?í?Óó??Q@",
            ],
        },
    },
    "Amometus Hist.": {
        "tlg_id": "TLG2445",
        "names": {"name_authtab": "Amometus Hist.", "name_idt": "Amometus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Nico Comic.": {
        "tlg_id": "TLG0479",
        "names": {"name_authtab": "Nico Comic.", "name_idt": "Nico Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Agathias Scholasticus Epigr., Hist.": {
        "tlg_id": "TLG4024",
        "names": {
            "name_authtab": "Agathias Scholasticus Epigr. et Hist.",
            "name_idt": "Agathias Scholasticus Epigr., Hist.",
        },
        "works": {"Historiae": ["Page", "line"]},
    },
    "Dionysius Geogr.": {
        "tlg_id": "TLG0083",
        "names": {"name_authtab": "Dionysius Geogr.", "name_idt": "Dionysius Geogr."},
        "works": {
            "Per Bosporum navigatio": ["Section", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Thomas Magister Philol.": {
        "tlg_id": "TLG9023",
        "names": {
            "name_authtab": "Thomas Magister Philol.",
            "name_idt": "Thomas Magister Philol.",
        },
        "works": {
            "$Ecloga nominum et verborum Atticorum": [
                "",
                "Alphabetic letter",
                "page",
                "line",
            ],
            "Poemata de Arato [Dub.]": ["Poem", "line"],
        },
    },
    "Dionysius Scymnaeus Trag. vel Comic.": {
        "tlg_id": "TLG0350",
        "names": {
            "name_authtab": "Dionysius Scymnaeus Trag. vel Comic.",
            "name_idt": "Dionysius Scymnaeus Trag. vel Comic.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Lexica Synonymica": {
        "tlg_id": "TLG4307",
        "names": {"name_authtab": "Lexica Synonymica", "name_idt": "Lexica Synonymica"},
        "works": {
            "RDifferentiae verborum (e cod. Paris. suppl. gr. 1238 servante litteram $A &tantum)": [
                "Alphabetic entry",
                "line",
            ],
            "oDe differentia vocabulorum (%6 $*PERI\\ DIAFORA=S LE/CEWN&) (e cod. Vat. gr. 2226, servante litteram $A &tantum)": [
                "line"
            ],
            "TExcerptum Casanatense sive Ecloga $DIAFO/RWN LE/CEWN &(e cod. bibl. Casanatense 264)": [
                "Entry",
                "line",
            ],
        },
    },
    "Theodorus Theol.": {
        "tlg_id": "TLG4135",
        "names": {"name_authtab": "Theodorus Theol.", "name_idt": "Theodorus Theol."},
        "works": {
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "4Fragmenta in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            "3Fragmenta in epistulam i ad Corinthios (in catenis)": ["Page", "line"],
            "#Fragmenta in Matthaeum (in catenis)": ["Fragment", "line"],
            "/Fragmenta in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
        },
    },
    "Ephraem Scr. Eccl.": {
        "tlg_id": "TLG1346",
        "names": {
            "name_authtab": "Ephraem Scr. Eccl.",
            "name_idt": "Ephraem Scr. Eccl.",
        },
        "works": {"De miraculo Clementis Romani": ["Page", "line"]},
    },
    "Iamblichus Phil.": {
        "tlg_id": "TLG2023",
        "names": {"name_authtab": "Iamblichus Phil.", "name_idt": "Iamblichus Phil."},
        "works": {
            "De vita Pythagorica": ["Chapter", "section", "line"],
            "De communi mathematica scientia": ["Section", "line"],
            "(In Nicomachi arithmeticam introductionem": ["Page", "line"],
            "Protrepticus": ["Page", "line"],
            "De mysteriis": ["Chapter", "section", "line"],
            "Theologoumena arithmeticae": ["Page", "line"],
        },
    },
    "Phileas Scr. Eccl.": {
        "tlg_id": "TLG2966",
        "names": {
            "name_authtab": "Phileas Scr. Eccl.",
            "name_idt": "Phileas Scr. Eccl.",
        },
        "works": {"%Epistula ad Thmuitanos (ap. Eusebium)": ["Section", "line"]},
    },
    "Apophthegmata": {
        "tlg_id": "TLG2742",
        "names": {"name_authtab": "Apophthegmata", "name_idt": "Apophthegmata"},
        "works": {
            ".Quaestiones et responsa senum de tentationibus": [
                "\x0fQuestion+answer",
                "line",
            ],
            "]Apophthegmata patrum (collectio anonyma) (e codd. Coislin. 126, 127 %7 Paris. gr. 1596, 2474)": [
                "Page",
                "line",
            ],
            "Dialogus de contemplatione": ["\x0fQuestion+answer", "line"],
            "HApophthegma patrum (e collectione anonyma) (e codd. Vat. gr. 1599, 1632)": [
                "Page",
                "line",
            ],
            "(De meditationibus duodecim anachoretarum": ["Section", "line"],
            ",Apophthegmata patrum (collectio alphabetica)": ["Page", "line"],
            "7Apophthegmata (collectio anonyma) (e cod. Coislin. 126)": [
                "Apophthegm",
                "line",
            ],
            "7Apophthegmata patrum (collectio systematica) (cap. 1-9)": [
                "Chapter",
                "paragraph",
                "line",
            ],
        },
    },
    "Basilis Hist.": {
        "tlg_id": "TLG1218",
        "names": {"name_authtab": "Basilis Hist.", "name_idt": "Basilis Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Capito Hist.": {
        "tlg_id": "TLG2506",
        "names": {"name_authtab": "Capito Hist.", "name_idt": "Capito Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cebes Phil.": {
        "tlg_id": "TLG1247",
        "names": {"name_authtab": "Cebes Phil.", "name_idt": "Cebes Phil."},
        "works": {"Cebetis tabula": ["Chapter", "section", "line"]},
    },
    "Maeandrius Hist.": {
        "tlg_id": "TLG2339",
        "names": {"name_authtab": "Maeandrius Hist.", "name_idt": "Maeandrius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Callinicus Soph.": {
        "tlg_id": "TLG2189",
        "names": {"name_authtab": "Callinicus Soph.", "name_idt": "Callinicus Soph."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Cassius Iatrosophista Med.": {
        "tlg_id": "TLG0733",
        "names": {
            "name_authtab": "Cassius Iatrosophista Med.",
            "name_idt": "Cassius Iatrosophista Med.",
        },
        "works": {")Quaestiones medicae et problemata physica": ["Section", "line"]},
    },
    "Aëtius Med.": {
        "tlg_id": "TLG0718",
        "names": {"name_authtab": "Aëtius Med.", "name_idt": "Aëtius Med."},
        "works": {
            "Iatricorum liber iii": ["Chapter", "line"],
            "Iatricorum liber xv": ["Chapter", "line"],
            "Iatricorum liber xi": ["Chapter", "line"],
            "Iatricorum liber viii": ["Chapter", "line"],
            "Iatricorum liber vi": ["Chapter", "line"],
            "Iatricorum liber iv": ["Chapter", "line"],
            "Iatricorum liber ix": ["Chapter", "line"],
            "Iatricorum liber xii": ["Chapter", "line"],
            "Iatricorum liber v": ["Chapter", "line"],
            "Iatricorum liber xvi": ["Chapter", "line"],
            "Iatricorum liber i": ["Chapter", "line"],
            "Iatricorum liber vii": ["Chapter", "line"],
            "Iatricorum liber ii": ["Chapter", "line"],
            "Iatricorum liber xiii": ["Chapter", "line"],
        },
    },
    "Straton Phil.": {
        "tlg_id": "TLG1696",
        "names": {"name_authtab": "Straton Phil.", "name_idt": "Straton Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Gnomologium Vaticanum": {
        "tlg_id": "TLG2945",
        "names": {
            "name_authtab": "Gnomologium Vaticanum",
            "name_idt": "Gnomologium Vaticanum",
        },
        "works": {"Gnomologium Vaticanum": ["Sententia", "line"]},
    },
    "Metrodorus Hist.": {
        "tlg_id": "TLG1976",
        "names": {"name_authtab": "Metrodorus Hist.", "name_idt": "Metrodorus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heron Mech.": {
        "tlg_id": "TLG0559",
        "names": {"name_authtab": "Heron Mech.", "name_idt": "Heron Mech."},
        "works": {
            "Liber geeponicus [Sp.]": ["Section", "line"],
            "Geodaesia [Sp.]": ["Chapter", "section", "line"],
            "Catoptrica": ["line"],
            "Stereometrica": ["Chapter", "subchapter", "section", "line"],
            "Belopoeica": ["Section", "line"],
            "Fragmenta Heroniana": ["Fragment", "section", "line"],
            "Fragmenta de horoscopiis": ["Fragment", "line"],
            "Metrica": ["Book", "chapter", "line"],
            "Definitiones": ["Chapter", "section", "line"],
            "Mechanicorum fragmenta": ["Book", "fragment", "line"],
            "Dioptra": ["Section", "line"],
            "De automatis": ["Chapter", "section", "line"],
            "De mensuris": ["Chapter", "section", "line"],
            ".$*XEIROBALLI/STRAS KATASKEUH\\ KAI\\ SUMMETRI/A&": [
                "Chapter",
                "section",
                "line",
            ],
            "Geometrica": ["Chapter", "section", "line"],
            "Pneumatica": ["Book", "chapter", "line"],
        },
    },
    "Theophanes Continuatus": {
        "tlg_id": "TLG4153",
        "names": {
            "name_authtab": "Theophanes Continuatus",
            "name_idt": "Theophanes Continuatus",
        },
        "works": {"Chronographia (lib. 1-6)": ["Page", "line"]},
    },
    "Antenor Hist.": {
        "tlg_id": "TLG2322",
        "names": {"name_authtab": "Antenor Hist.", "name_idt": "Antenor Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Bias Phil.": {
        "tlg_id": "TLG1223",
        "names": {"name_authtab": "Bias Phil.", "name_idt": "Bias Phil."},
        "works": {"Fragmentum": ["line"], "Testimonium": ["line", "fragment", "line"]},
    },
    "Euphorion Epic.": {
        "tlg_id": "TLG0221",
        "names": {"name_authtab": "Euphorion Epic.", "name_idt": "Euphorion Epic."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Callisthenes Hist.": {
        "tlg_id": "TLG0534",
        "names": {
            "name_authtab": "Callisthenes Hist.",
            "name_idt": "Callisthenes Hist.",
        },
        "works": {
            "Testimonium et fragmentum": ["FGrH fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Cleopatra Alchem.": {
        "tlg_id": "TLG4335",
        "names": {"name_authtab": "Cleopatra Alchem.", "name_idt": "Cleopatra Alchem."},
        "works": {"De ponderibus et mensuris": ["Fragment", "section", "line"]},
    },
    "Pratinas Trag.": {
        "tlg_id": "TLG1833",
        "names": {"name_authtab": "Pratinas Trag.", "name_idt": "Pratinas Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Numenius Poet. Didac.": {
        "tlg_id": "TLG0703",
        "names": {
            "name_authtab": "Numenius Poet. Didac.",
            "name_idt": "Numenius Poet. Didac.",
        },
        "works": {"Fragmenta et tituli": ["Fragment", "line"]},
    },
    "Blaesus Comic.": {
        "tlg_id": "TLG1227",
        "names": {"name_authtab": "Blaesus Comic.", "name_idt": "Blaesus Comic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Petron Phil.": {
        "tlg_id": "TLG2247",
        "names": {"name_authtab": "Petron Phil.", "name_idt": "Petron Phil."},
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "Theodorus Scr. Eccl.": {
        "tlg_id": "TLG4126",
        "names": {
            "name_authtab": "Theodorus Scr. Eccl.",
            "name_idt": "Theodorus Scr. Eccl.",
        },
        "works": {
            "!Fragmenta in Joannem (in catenis)": ["Fragment", "line"],
            "#Fragmenta in Matthaeum (in catenis)": ["Fragment", "line"],
        },
    },
    "Damon et Phintias Phil.": {
        "tlg_id": "TLG2244",
        "names": {
            "name_authtab": "Damon et Phintias Phil.",
            "name_idt": "Damon et Phintias Phil.",
        },
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "Theophanes Hist.": {
        "tlg_id": "TLG1981",
        "names": {"name_authtab": "Theophanes Hist.", "name_idt": "Theophanes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hermarchus Phil.": {
        "tlg_id": "TLG1439",
        "names": {"name_authtab": "Hermarchus Phil.", "name_idt": "Hermarchus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hellenica": {
        "tlg_id": "TLG0558",
        "names": {"name_authtab": "Hellenica", "name_idt": "Hellenica"},
        "works": {
            '"Fragmenta Florentina (PSI 13.1304)': [
                "Fragment",
                "column",
                "section",
                "line",
            ],
            "Fragmenta (P. Oxy. 5.842)": ["line", "fragment", "line"],
            "4Fragmenta Londinensia incertae sedis (P. Oxy. 5.842)": [
                "Fragment",
                "line",
            ],
            "-Fragmentum (P. Cairo inv. 26%3`6%3`27%3`1-35)": ["line"],
            "%Fragmenta Londinensia (P. Oxy. 5.842)": [
                "Fragment",
                "column",
                "section",
                "line",
            ],
        },
    },
    "Catenae (Novum Testamentum)": {
        "tlg_id": "TLG4102",
        "names": {
            "name_authtab": "Catenae (Novum Testamentum)",
            "name_idt": "Catenae (Novum Testamentum)",
        },
        "works": {
            "\\Supplementum et varietas lectionis ad catenam in evangelium sancti Joannis (e cod. Bodl. B.)": [
                "Page",
                "line",
            ],
            "DCatena in Matthaeum (catena integra) (e cod. Paris. Coislin. gr. 23)": [
                "Page",
                "line",
            ],
            "VCatena in epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Paris. gr. 223)": [
                "Page",
                "line",
            ],
            "ZCatena in Joannem (catena integra) (e codd. Paris. Coislin. 23 %7 Oxon. Bodl. Auct. T.1.4)": [
                "Page",
                "line",
            ],
            "?Catena in epistulam i ad Timotheum (e cod. Paris. Coislin. 204)": [
                "Page",
                "line",
            ],
            "VCatena in epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Paris. gr. 216)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam ad Galatas (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.1.7 [%": [
                "Page",
                "line",
                "",
                "©\x12¶",
            ],
            "HCatena in epistulam ad Hebraeos (catena Nicetae) (e cod. Paris. gr. 238)": [
                "Page",
                "line",
            ],
            "pSupplementum et varietas lectionis in epistulam ad Galatas (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe 16)": [
                "Page",
                "line",
            ],
            "KCatena in epistulam ad Philippenses (typus Parisinus) (e cod. Coislin. 204)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam ad Ephesios (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe 16)": [
                "Page",
                "line",
            ],
            "<Catena in epistulam ad Hebraeos (e cod. Paris. Coislin. 204)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam i ad Thessalonicenses (catena Pseudo-Oecumenii) (e cod. Bodl. Auc": [
                "Page",
                "line",
            ],
            "KCatena in epistulam Joannis i (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "JCatena in epistulam ad Colossenses (typus Parisinus) (e cod. Coislin. 204)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam ad Ephesios (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.1.7 [": [
                "Page",
                "line",
            ],
            ">Catena in epistulam ad Philemonem (e cod. Paris. Coislin. 204)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis ad epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Ro": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam ad Colossenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe ": [
                "Page",
                "line",
            ],
            "fSupplementum et varietas lectionis ad catenam in evangelium sancti Lucae (e cod. Oxon. Bodl. Laud. 33)": [
                "Page",
                "line",
            ],
            "<Catena in Acta (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "QCatena in epistulam i ad Thessalonicenses (typus Parisinus) (e cod. Coislin. 204)": [
                "Page",
                "line",
            ],
            "RCatena in epistulam ii ad Thessalonicenses (typus Parisinus) (e cod. Coislin. 204)": [
                "Page",
                "line",
                "",
            ],
            "9Catena in epistulam ad Titum (e cod. Paris. Coislin. 204)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis ad epistulam i ad Corinthios (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.1": [
                "Page",
                "line",
            ],
            "JCatena in epistulam Petri ii (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "GCatena in epistulam ad Ephesios (typus Parisinus) (e cod. Coislin. 204)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam i ad Thessalonicenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bod": [
                "Page",
                "line",
            ],
            "MCatena in epistulam Joannis iii (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "@Catena in epistulam ii ad Timotheum (e cod. Paris. Coislin. 204)": [
                "Page",
                "line",
            ],
            "`Catena in epistulam ad Romanos (typus Vaticanus) (e cod. Oxon. Bodl. Auct. E.2.20 [%6 Misc. 48])": [
                "Page",
                "line",
            ],
            "ICatena in epistulam Petri i (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "FCatena in epistulam ad Galatas (typus Parisinus) (e cod. Coislin. 204)": [
                "Page",
                "line",
            ],
            "MCatena in epistulam i ad Corinthios (typus Vaticanus) (e cod. Paris. gr. 227)": [
                "Page",
                "line",
            ],
            "HCatena in epistulam Jacobi (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis ad epistulam ii ad Corinthios (catena Pseudo-Oecumenii) (e cod. Bodl. Auct. T.": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam ii ad Thessalonicenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bo": [
                "Page",
                "line",
            ],
            "FCatena in epistulam Juda (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "ICatena in epistulam ad Romanos (typus Monacensis) (e cod. Monac. gr. 412)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis ad epistulam i ad Corinthios (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis ad commentarium Chrysostomi in evangelium sancti Matthaei (e cod. Oxon. Bodl. ": [
                "Page",
                "line",
            ],
            "LCatena in epistulam Joannis ii (catena Andreae) (e cod. Oxon. coll. nov. 58)": [
                "Page",
                "line",
            ],
            "qSupplementum et varietas lectionis in epistulam ad Philippenses (catena Pseudo-Oecumenii) (e cod. Oxon. Bodl. Roe": [
                "Page",
                "line",
            ],
            "eCatena in Marcum (recensio ii) (e codd. Oxon. Bodl. Laud. 33 %7 Paris. Coislin. 23 %7 Paris. gr. 178)": [
                "Page",
                "line",
            ],
            "OCatena in Lucam (typus B) (e codd. Paris. Coislin. 23 %7 Oxon. Bodl. Misc. 182)": [
                "Page",
                "line",
            ],
        },
    },
    "Serapion Scr. Eccl.": {
        "tlg_id": "TLG1670",
        "names": {
            "name_authtab": "Serapion Scr. Eccl.",
            "name_idt": "Serapion Scr. Eccl.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Anonymi In Oppiani Opera": {
        "tlg_id": "TLG4171",
        "names": {
            "name_authtab": "Anonymi In Oppiani Opera",
            "name_idt": "Anonymi In Oppiani Opera",
        },
        "works": {
            "7In Oppiani halieutica exegesis (e cod. Paris. gr. 2735)": [
                "Page",
                "column",
                "line",
            ]
        },
    },
    "Herodicus Gramm.": {
        "tlg_id": "TLG2625",
        "names": {"name_authtab": "Herodicus Gramm.", "name_idt": "Herodicus Gramm."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aeneas Tact.": {
        "tlg_id": "TLG0058",
        "names": {"name_authtab": "Aeneas Tact.", "name_idt": "Aeneas Tact."},
        "works": {"Poliorcetica": ["Chapter", "section", "line"]},
    },
    "Democles Hist.": {
        "tlg_id": "TLG4390",
        "names": {"name_authtab": "Democles Hist.", "name_idt": "Democles Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Xenomedes Hist.": {
        "tlg_id": "TLG2306",
        "names": {"name_authtab": "Xenomedes Hist.", "name_idt": "Xenomedes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heniochus Comic.": {
        "tlg_id": "TLG0465",
        "names": {"name_authtab": "Heniochus Comic.", "name_idt": "Heniochus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Paraphrases In Dionysium Periegetam": {
        "tlg_id": "TLG4174",
        "names": {
            "name_authtab": "Paraphrases In Dionysium Periegetam",
            "name_idt": "Paraphrases In Dionysium Periegetam",
        },
        "works": {"*In Dionysii periegetae orbis descriptionem": ["Section", "line"]},
    },
    "Pherecydis Epistula": {
        "tlg_id": "TLG1585",
        "names": {
            "name_authtab": "Pherecydis Epistula",
            "name_idt": "Pherecydis Epistula",
        },
        "works": {"Epistula": ["line"]},
    },
    "Hegesippus Scr. Eccl.": {
        "tlg_id": "TLG1398",
        "names": {
            "name_authtab": "Hegesippus Scr. Eccl.",
            "name_idt": "Hegesippus Scr. Eccl.",
        },
        "works": {"Fragmenta (ex incerto libro)": ["Page", "line"]},
    },
    "Gaius Scr. Eccl.": {
        "tlg_id": "TLG0572",
        "names": {"name_authtab": "Gaius Scr. Eccl.", "name_idt": "Gaius Scr. Eccl."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Sopater Rhet.": {
        "tlg_id": "TLG2031",
        "names": {"name_authtab": "Sopater Rhet.", "name_idt": "Sopater Rhet."},
        "works": {
            "1Scholia ad Hermogenis status seu artem rhetoricam": [
                "Volume",
                "page",
                "line",
            ],
            "Prolegomena in Aristidem": ["Volume", "page", "line"],
            "$*DIAI/RESIS ZHTHMA/TWN&": ["Volume", "page", "line"],
        },
    },
    "Teles Phil.": {
        "tlg_id": "TLG1699",
        "names": {"name_authtab": "Teles Phil.", "name_idt": "Teles Phil."},
        "works": {
            "$*PERI\\ AU)TARKEI/AS&": ["Page", "line"],
            "$*PERI\\ FUGH=S&": ["Page", "line"],
            "9$*PERI\\ SUGKRI/SEWS PENI/AS KAI\\ PLOU/TOU &(ap. Stobaeum)": [
                "Page",
                "line",
            ],
            "'$*PERI\\ TOU= DOKEI=N KAI\\ TOU= EI)=NAI&": ["Page", "line"],
            "$*PERI\\ A)PAQEI/AS&": ["Page", "line"],
            ")$*PERI\\ TOU= MH\\ EI)=NAI TE/LOS H(DONH/N&": ["Page", "line"],
            "$*PERI\\ PERISTA/SEWN&": ["Page", "line"],
        },
    },
    "Alcibiades Eleg.": {
        "tlg_id": "TLG0236",
        "names": {"name_authtab": "Alcibiades Eleg.", "name_idt": "Alcibiades Eleg."},
        "works": {"Fragmentum": ["line"]},
    },
    "Evangelium Petri": {
        "tlg_id": "TLG1371",
        "names": {"name_authtab": "Evangelium Petri", "name_idt": "Evangelium Petri"},
        "works": {"Evangelium Petri": ["Section", "line"]},
    },
    "Vitae Pindari Et Varia De Pindaro": {
        "tlg_id": "TLG4170",
        "names": {
            "name_authtab": "Vitae Pindari Et Varia De Pindaro",
            "name_idt": "Vitae Pindari Et Varia De Pindaro",
        },
        "works": {"!Vitae Pindari et varia de Pindaro": ["Page", "line"]},
    },
    "Alexander Med.": {
        "tlg_id": "TLG0744",
        "names": {"name_authtab": "Alexander Med.", "name_idt": "Alexander Med."},
        "works": {
            "Epistula de lumbricis": ["Volume", "page", "line"],
            "De oculis libri tres": ["Page", "line"],
            "De febribus": ["Volume", "page", "line"],
            "Dedicatio ad Cosman": ["Volume", "page", "line"],
            "Therapeutica": ["Volume", "page", "line"],
        },
    },
    "Epicharmus et Pseudepicharmea Comic.": {
        "tlg_id": "TLG0521",
        "names": {
            "name_authtab": "Epicharmus Comic. et Pseudepicharmea",
            "name_idt": "Epicharmus et Pseudepicharmea Comic.",
        },
        "works": {
            "Fragmentum Epicharmi": ["Fragment", "line"],
            "Fragmenta Epicharmi": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta Pseudepicharmea": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Nicephorus II Phocas Imperator Tact.": {
        "tlg_id": "TLG3181",
        "names": {
            "name_authtab": "Nicephorus II Phocas Imperator Tact.",
            "name_idt": "Nicephorus II Phocas Imperator Tact.",
        },
        "works": {
            "7De velitatione bellica (sub nomine Nicephori II Phocae)": [
                "Chapter",
                "section",
                "line",
            ]
        },
    },
    "[Hegesinus] Epic.": {
        "tlg_id": "TLG1395",
        "names": {"name_authtab": "[Hegesinus] Epic.", "name_idt": "[Hegesinus] Epic."},
        "works": {"4Atthis (fragmentum spurium) (fort. auctore Callippo)": ["line"]},
    },
    "Diotimus Phil.": {
        "tlg_id": "TLG2340",
        "names": {"name_authtab": "Diotimus Phil.", "name_idt": "Diotimus Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Philo Poeta": {
        "tlg_id": "TLG2638",
        "names": {"name_authtab": "Philo Poeta", "name_idt": "Philo Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Phormis Comic.": {
        "tlg_id": "TLG1788",
        "names": {"name_authtab": "Phormis Comic.", "name_idt": "Phormis Comic."},
        "works": {"Fragmentum": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Hypsicles Astron., Math.": {
        "tlg_id": "TLG0717",
        "names": {
            "name_authtab": "Hypsicles Astron. et Math.",
            "name_idt": "Hypsicles Astron., Math.",
        },
        "works": {
            "Anaphoricus": ["line"],
            "5Hypsiclis liber sive elementorum liber xiv qui fertur": [
                "Section",
                "line",
            ],
        },
    },
    "Antisthenes Phil.": {
        "tlg_id": "TLG2313",
        "names": {"name_authtab": "Antisthenes Phil.", "name_idt": "Antisthenes Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Lycus Hist.": {
        "tlg_id": "TLG1470",
        "names": {"name_authtab": "Lycus Hist.", "name_idt": "Lycus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aristeae Epistula": {
        "tlg_id": "TLG1183",
        "names": {"name_authtab": "Aristeae Epistula", "name_idt": "Aristeae Epistula"},
        "works": {" Aristeae epistula ad Philocratem": ["Section", "line"]},
    },
    "Beros(s)us Astrol., Hist.": {
        "tlg_id": "TLG1222",
        "names": {
            "name_authtab": "Beros(s)us Astrol. et Hist.",
            "name_idt": "Beros(s)us Astrol., Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scylitzes Continuatus": {
        "tlg_id": "TLG3064",
        "names": {
            "name_authtab": "Scylitzes Continuatus",
            "name_idt": "Scylitzes Continuatus",
        },
        "works": {"Continuatio Scylitzae": ["Page", "line"]},
    },
    "Anacharsidis Epistulae": {
        "tlg_id": "TLG0037",
        "names": {
            "name_authtab": "Anacharsidis Epistulae",
            "name_idt": "Anacharsidis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Pempelus Phil.": {
        "tlg_id": "TLG1571",
        "names": {"name_authtab": "Pempelus Phil.", "name_idt": "Pempelus Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Sogenes Comic.": {
        "tlg_id": "TLG1786",
        "names": {"name_authtab": "Sogenes Comic.", "name_idt": "Sogenes Comic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Theophilus Scr. Eccl.": {
        "tlg_id": "TLG4115",
        "names": {
            "name_authtab": "Theophilus Scr. Eccl.",
            "name_idt": "Theophilus Scr. Eccl.",
        },
        "works": {
            "!Fragmenta in Joannem (in catenis)": ["Fragment", "line"],
            "#Fragmenta in Matthaeum (in catenis)": ["Fragment", "line"],
        },
    },
    "Pythermus Hist.": {
        "tlg_id": "TLG1651",
        "names": {"name_authtab": "Pythermus Hist.", "name_idt": "Pythermus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Iambica Adespota (ALG)": {
        "tlg_id": "TLG1821",
        "names": {
            "name_authtab": "Iambica Adespota (ALG)",
            "name_idt": "Iambica Adespota (ALG)",
        },
        "works": {
            "Anonymorum iambica": ["Fragment", "section", "line"],
            "Fragmenta iambica adespota": ["Fragment", "line"],
        },
    },
    "Boethus Epigr.": {
        "tlg_id": "TLG0146",
        "names": {"name_authtab": "Boethus Epigr.", "name_idt": "Boethus Epigr."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Eumelus Epic.": {
        "tlg_id": "TLG0298",
        "names": {"name_authtab": "Eumelus Epic.", "name_idt": "Eumelus Epic."},
        "works": {
            "Fragmenta epica": ["Fragment", "line"],
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "Corinthiaca (fragmenta)": ["line", "fragment", "line"],
        },
    },
    "Sciras Comic.": {
        "tlg_id": "TLG1662",
        "names": {"name_authtab": "Sciras Comic.", "name_idt": "Sciras Comic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Phintys Phil.": {
        "tlg_id": "TLG1603",
        "names": {"name_authtab": "Phintys Phil.", "name_idt": "Phintys Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Antigonus": {
        "tlg_id": "TLG2547",
        "names": {"name_authtab": "Antigonus", "name_idt": "Antigonus"},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Rhinthon Comic.": {
        "tlg_id": "TLG1654",
        "names": {"name_authtab": "Rhinthon Comic.", "name_idt": "Rhinthon Comic."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Heraclitus Comic.": {
        "tlg_id": "TLG1784",
        "names": {"name_authtab": "Heraclitus Comic.", "name_idt": "Heraclitus Comic."},
        "works": {"Titulus": ["Page", "line"]},
    },
    "Valentinus Gnost.": {
        "tlg_id": "TLG1746",
        "names": {"name_authtab": "Valentinus Gnost.", "name_idt": "Valentinus Gnost."},
        "works": {"Valentini hymnus": ["line"]},
    },
    "Aristobulus Judaeus Phil.": {
        "tlg_id": "TLG1186",
        "names": {
            "name_authtab": "Aristobulus Judaeus Phil.",
            "name_idt": "Aristobulus Judaeus Phil.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Cinnamus Gramm., Hist.": {
        "tlg_id": "TLG3020",
        "names": {
            "name_authtab": "Joannes Cinnamus Gramm. et Hist.",
            "name_idt": "Cinnamus Gramm., Hist.",
        },
        "works": {
            "3Epitome rerum ab Joanne et Alexio Comnenis gestarum": ["Page", "line"],
            "Ethopoeia": ["line"],
        },
    },
    "Aristophanes Comic.": {
        "tlg_id": "TLG0019",
        "names": {
            "name_authtab": "Aristophanes Comic.",
            "name_idt": "Aristophanes Comic.",
        },
        "works": {
            "": ["Thesmophoriazusae", "line"],
            "Equites": ["line"],
            "Plutus": ["line"],
            "Vespae": ["line"],
            "Aves": ["line"],
            "Acharnenses": ["line"],
            "Pax": ["line"],
            "Lysistrata": ["line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Nubes": ["line"],
            "Ranae": ["line"],
            "Ecclesiazusae": ["line"],
        },
    },
    "Monodia": {
        "tlg_id": "TLG0277",
        "names": {"name_authtab": "Monodia", "name_idt": "Monodia"},
        "works": {'"Mirmillonis amatrix (P. Ryl. 1.15)': ["line"]},
    },
    "Alcaeus Comic.": {
        "tlg_id": "TLG0400",
        "names": {"name_authtab": "Alcaeus Comic.", "name_idt": "Alcaeus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Stesiclides Hist.": {
        "tlg_id": "TLG2171",
        "names": {"name_authtab": "Stesiclides Hist.", "name_idt": "Stesiclides Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hermodorus Phil.": {
        "tlg_id": "TLG0095",
        "names": {"name_authtab": "Hermodorus Phil.", "name_idt": "Hermodorus Phil."},
        "works": {
            "/De Platone (fort. auctore Hermodoro Syracusano)": [
                "Fragment",
                "column",
                "line",
            ],
            "Testimonia et fragmenta": ["Fragment", "line"],
        },
    },
    "Aethiopis": {
        "tlg_id": "TLG0683",
        "names": {"name_authtab": "Aethiopis", "name_idt": "Aethiopis"},
        "works": {"Aethiopis (fragmenta)": ["Fragment", "line"]},
    },
    "Athenaeus Soph.": {
        "tlg_id": "TLG0008",
        "names": {"name_authtab": "Athenaeus Soph.", "name_idt": "Athenaeus Soph."},
        "works": {
            "Fragmentum": ["line", "fragment", "line"],
            "Deipnosophistae (epitome)": ["Volume", "page", "line"],
            "Deipnosophistae": ["Book", "Kaibel paragraph", "line"],
        },
    },
    "Stesichorus II Lyr.": {
        "tlg_id": "TLG0981",
        "names": {
            "name_authtab": "Stesichorus II Lyr.",
            "name_idt": "Stesichorus II Lyr.",
        },
        "works": {"Titulus": ["line"]},
    },
    "Demon Hist.": {
        "tlg_id": "TLG1307",
        "names": {"name_authtab": "Demon Hist.", "name_idt": "Demon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hippiatrica": {
        "tlg_id": "TLG0738",
        "names": {"name_authtab": "Hippiatrica", "name_idt": "Hippiatrica"},
        "works": {
            "Fragmenta Anatolii de bubus": ["Chapter", "section", "line"],
            "Fragmenta Timothei Gazaei": ["Section", "line"],
            "Hippiatrica Berolinensia": ["Chapter", "section", "line"],
            "&Appendices ad hippiatrica Berolinensia": ["Appendix", "line"],
            "Fragmenta Anatolii de equis": ["Chapter", "section", "line"],
            "Fragmenta Anatolii": ["Section", "line"],
            "Hippiatrica Parisina": ["Section", "line"],
            "Hippiatrica Cantabrigiensia": ["Chapter", "section", "line"],
            "6Additamenta Londinensia ad hippiatrica Cantabrigiensia": [
                "Section",
                "line",
            ],
            "Excerpta Lugdunensia": ["Section", "line"],
        },
    },
    "Brotinus Phil.": {
        "tlg_id": "TLG1230",
        "names": {"name_authtab": "Brotinus Phil.", "name_idt": "Brotinus Phil."},
        "works": {"Fragmentum": ["Page", "line"], "Testimonia": ["Fragment", "line"]},
    },
    "Certamen Homeri Et Hesiodi": {
        "tlg_id": "TLG1252",
        "names": {
            "name_authtab": "Certamen Homeri Et Hesiodi",
            "name_idt": "Certamen Homeri Et Hesiodi",
        },
        "works": {
            "Certamen Homeri et Hesiodi": ["line"],
            ")Certamen Homeri et Hesiodi (P. Petrie 25)": ["line"],
        },
    },
    "Menander Rhet.": {
        "tlg_id": "TLG2586",
        "names": {"name_authtab": "Menander Rhet.", "name_idt": "Menander Rhet."},
        "works": {
            "$*PERI\\ E)PIDEIKTIKW=N&": ["Spengel page", "line"],
            ">$*DIAI/RESIS TW=N E)PIDEIKTIKW=N &(olim sub auctore Genethlio)": [
                "Spengel page",
                "line",
            ],
        },
    },
    "Gorgias Rhet., Soph.": {
        "tlg_id": "TLG0593",
        "names": {
            "name_authtab": "Gorgias Rhet. et Soph.",
            "name_idt": "Gorgias Rhet., Soph.",
        },
        "works": {
            "Testimonium": ["line", "fragment", "line"],
            "Testimonia": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Ducas Hist.": {
        "tlg_id": "TLG3146",
        "names": {"name_authtab": "Ducas Hist.", "name_idt": "Ducas Hist."},
        "works": {"Historia Turcobyzantina": ["Chapter", "section", "line"]},
    },
    "Cephalion Hist., Rhet.": {
        "tlg_id": "TLG1249",
        "names": {
            "name_authtab": "Cephalion Hist. et Rhet.",
            "name_idt": "Cephalion Hist., Rhet.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Demetrius Hist.": {
        "tlg_id": "TLG1917",
        "names": {"name_authtab": "Demetrius Hist.", "name_idt": "Demetrius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Menander Comic.": {
        "tlg_id": "TLG0541",
        "names": {"name_authtab": "Menander Comic.", "name_idt": "Menander Comic."},
        "works": {
            ".Fragmenta longiora apud alios auctores servata": ["Fragment", "line"],
            "Sententiae": ["Sententia", "section", "line"],
            "Epitrepontum fragmenta": ["Fragment", "line"],
            "Epitrepontes": ["line"],
            "Colacis fragmenta aliunde nota": ["Fragment", "line"],
            "Misumenus": ["line"],
            "Theophorumene": ["line"],
            "Carchedonius": ["line", "¶"],
            "!Sententiae e codicibus Byzantinis": ["line"],
            "Phasma": ["line"],
            "Misumeni nova fragmenta": ["Fragment", "column", "line"],
            "%Theophorumenae fragmenta aliunde nota": ["Fragment", "line"],
            "'Coneazomenarum fragmentum aliunde notum": ["Fragment", "line"],
            "Colax": ["line", "Ö", "F\x12"],
            "Aspis": ["line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Sicyonius": ["line"],
            "Dyscolus": ["line"],
            "Heros": ["line"],
            "Samiae fragmentum aliunde notum": ["line"],
            "Georgi fragmenta aliunde nota": ["Fragment", "line"],
            "Sicyonii fragmenta aliunde nota": ["Fragment", "line"],
            "$Periciromenae fragmenta aliunde nota": ["Fragment", "line"],
            "!Perinthiae fragmenta aliunde nota": ["Fragment", "line"],
            "Aspidis fragmenta aliunde nota": ["Fragment", "line"],
            "Misumeni fragmenta": ["Fragment", "line"],
            "Dis exapaton": ["line"],
            '"Carchedonii fragmenta aliunde nota': ["Fragment", "line", ".", ""],
            '"Citharistae fragmenta aliunde nota': ["Fragment", "line", "\x8c,", ""],
            "Herois fragmenta aliunde nota": ["Fragment", "line"],
            " Theophorumenae fragmentum dubium": ["line"],
            "Perinthia": ["line"],
            "&Dis exapatontis fragmenta aliunde nota": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Citharista": ["line", "", "K", ""],
            "Epigramma": ["Epigram", "fragment", "line"],
            "Sententiae e papyris": ["Sententia", "line"],
            "Samia": ["line"],
            "Georgus": ["line"],
            "#Fragmentum dubium (P. Oxy. 31.2533)": ["line"],
            "Coneazomenae": ["line"],
            "Periciromene": ["line"],
            "Fabula incerta": ["line"],
        },
    },
    "Antonius Diogenes Scr. Erot.": {
        "tlg_id": "TLG1148",
        "names": {
            "name_authtab": "Antonius Diogenes Scr. Erot.",
            "name_idt": "Antonius Diogenes Scr. Erot.",
        },
        "works": {
            ">De incredibilibus vel Herpyllis (?) (fragmentum) (P. Dubl. C3)": [
                "Column",
                "line",
            ],
            "0De incredibilibus (fragmentum) (P. Oxy. 42.3012)": ["line"],
            ",De incredibilibus (fragmentum) (PSI 10.1177)": ["line"],
        },
    },
    "Clytus Hist.": {
        "tlg_id": "TLG1282",
        "names": {"name_authtab": "Clytus Hist.", "name_idt": "Clytus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Damascius Phil.": {
        "tlg_id": "TLG4066",
        "names": {"name_authtab": "Damascius Phil.", "name_idt": "Damascius Phil."},
        "works": {
            "In Phaedonem (versio 2)": ["Section", "line"],
            "0Vita Isidori (ap. Photium, Bibl. codd. 181, 242)": ["Fragment", "line"],
            "@Vita Isidori (ap. Sudam, Hesychium, Photium et e cod. Vat. 1950)": [
                "Fragment",
                "line",
            ],
            "In Phaedonem (versio 1)": ["Section", "line"],
            "Epigramma": ["Book", "epigram", "line"],
            "In Parmenidem": ["Page", "line"],
            "In Philebum": ["Section", "line"],
            "De principiis": ["Volume", "page", "line"],
        },
    },
    "Theseus Hist.": {
        "tlg_id": "TLG1728",
        "names": {"name_authtab": "Theseus Hist.", "name_idt": "Theseus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Parthenius Myth.": {
        "tlg_id": "TLG0655",
        "names": {"name_authtab": "Parthenius Myth.", "name_idt": "Parthenius Myth."},
        "works": {
            "Poesis reliquiae": ["Fragment", "line"],
            "Narrationes amatoriae": ["Chapter", "section", "line"],
            "Fragmenta et tituli": ["Fragment", "line"],
        },
    },
    "Philo Paradox.": {
        "tlg_id": "TLG2595",
        "names": {"name_authtab": "Philo Paradox.", "name_idt": "Philo Paradox."},
        "works": {"De septem orbis spectaculis": ["Page", "line"]},
    },
    "Andriscus Hist.": {
        "tlg_id": "TLG2346",
        "names": {"name_authtab": "Andriscus Hist.", "name_idt": "Andriscus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Polycarpus Scr. Eccl.": {
        "tlg_id": "TLG1622",
        "names": {
            "name_authtab": "Polycarpus Scr. Eccl.",
            "name_idt": "Polycarpus Scr. Eccl.",
        },
        "works": {"Epistula ad Philippenses": ["Chapter", "section", "line"]},
    },
    "Caecalus (?) Epic.": {
        "tlg_id": "TLG2612",
        "names": {
            "name_authtab": "Caecalus (?) Epic.",
            "name_idt": "Caecalus (?) Epic.",
        },
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Metrophanes Hist.": {
        "tlg_id": "TLG2531",
        "names": {"name_authtab": "Metrophanes Hist.", "name_idt": "Metrophanes Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Archinus Hist.": {
        "tlg_id": "TLG2418",
        "names": {"name_authtab": "Archinus Hist.", "name_idt": "Archinus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dionysius I Trag.": {
        "tlg_id": "TLG0330",
        "names": {"name_authtab": "Dionysius I Trag.", "name_idt": "Dionysius I Trag."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonium": ["line", "fragment", "line"],
        },
    },
    "Vitae Dionysii Periegetae": {
        "tlg_id": "TLG4173",
        "names": {
            "name_authtab": "Vitae Dionysii Periegetae",
            "name_idt": "Vitae Dionysii Periegetae",
        },
        "works": {"Vita Dionysii": ["line"]},
    },
    "Aspasius Phil.": {
        "tlg_id": "TLG0615",
        "names": {"name_authtab": "Aspasius Phil.", "name_idt": "Aspasius Phil."},
        "works": {"!In ethica Nichomachea commentaria": ["Page", "line"]},
    },
    "Xenocles Trag.": {
        "tlg_id": "TLG0316",
        "names": {"name_authtab": "Xenocles Trag.", "name_idt": "Xenocles Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Nicochares Comic.": {
        "tlg_id": "TLG0480",
        "names": {"name_authtab": "Nicochares Comic.", "name_idt": "Nicochares Comic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Maximus Confessor Theol.": {
        "tlg_id": "TLG2892",
        "names": {
            "name_authtab": "Maximus Confessor Theol.",
            "name_idt": "Maximus Confessor Theol.",
        },
        "works": {
            "Mystagogia": ["Chapter", "line"],
            "Expositio in Psalmum LIX": ["line"],
            "Liber asceticus": ["Section", "line"],
            "Quaestiones et dubia": ["Section", "line"],
            "Hymni [Sp.]": ["Hymn", "line"],
            "9Scholia in Ecclesiasten (in catenis: catena trium patrum)": [
                "Section",
                "line",
            ],
            "Capita de caritate": ["Book", "section", "line"],
            "Opusculum de anima [Sp.]": ["Section", "line"],
            "Quaestiones ad Thalassium": ["Section", "line"],
            "Expositio orationis dominicae": ["line"],
        },
    },
    "Dinarchus Orat.": {
        "tlg_id": "TLG0029",
        "names": {"name_authtab": "Dinarchus Orat.", "name_idt": "Dinarchus Orat."},
        "works": {
            "In Demosthenem": ["Section", "line"],
            "Fragmenta incertae sedis": ["Fragment", "line"],
            "In Aristogitonem": ["Section", "line"],
            "Fragmenta": ["Oration", "fragment", "line"],
            "In Philoclem": ["Section", "line"],
        },
    },
    "Mnesimachus Hist.": {
        "tlg_id": "TLG2565",
        "names": {"name_authtab": "Mnesimachus Hist.", "name_idt": "Mnesimachus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sosibius Gramm.": {
        "tlg_id": "TLG1685",
        "names": {"name_authtab": "Sosibius Gramm.", "name_idt": "Sosibius Gramm."},
        "works": {
            "Fragmentum (P. Oxy. 24.2389)": ["FGrH fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Sotadea": {
        "tlg_id": "TLG1690",
        "names": {"name_authtab": "Sotadea", "name_idt": "Sotadea"},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymi Medici Med.": {
        "tlg_id": "TLG0721",
        "names": {
            "name_authtab": "Anonymi Medici Med.",
            "name_idt": "Anonymi Medici Med.",
        },
        "works": {
            "": ["Mensium adornatio", "line"],
            "De cibis": ["Chapter", "line", "\x8c", "d\x15"],
            "De diaeta": ["Chapter", "section", "line"],
            "De urinis in febribus": ["Volume", "page", "line", ""],
            "De pulsibus": ["line"],
            "De urinis secundum Persos": ["line"],
            "De duodecim mensium natura": ["Chapter", "section", "line"],
            "De urinis secundum Syros": ["Section", "line"],
            "$*PERI\\ TROFW=N DUNA/MEWS&": ["Page", "line"],
            "In aphorismos [Hippocratis]": ["line"],
            "Physiognomonica": ["Section", "line"],
            "Fragmenta varia": ["Section", "line"],
            "%$*PERI\\ TH=S TW=N PURETW=N DIAFORA=S&": ["Page", "line"],
            "De corporis hominis natura": ["Section", "line"],
            "Commentatio de urinis": ["Volume", "page", "line"],
            ")$*)ONOMATOPOII/A TH=S A)NQRW/POU FU/SEWS&": ["Page", "line"],
            "-$*)ONOMASI/AI TW=N KATA\\ A)/NQRWPON& (lib. 1)": ["Section", "line"],
            "De alimentis": ["Chapter", "line"],
            "$*PERI\\ LUKANQRWPI/AS&": ["line"],
            "De generatione et semine": ["Section", "line"],
            "_$*)ONO/MATA TW=N I)ATRIKW=N E)RGALEI/WN KATA\\ STOIXEI=A OI(=S E)N TAI=S XEIROURGI/AIS XRW/MEQA&": [
                "Page",
                "line",
            ],
            "9$*DIA/GNWSIS PERI\\ TW=N O)CE/WN KAI\\ XRONI/WN NOSHMA/TWN&": [
                "Section",
                "line",
            ],
            "Y$*PERI\\ XROIA=S TOU= AI(/MATOS TOU= A)PO\\ FLEBOTOMI/AS E)K TH=S I)ATRIKH=S TW=N *PERSW=N&": [
                "Section",
                "line",
            ],
        },
    },
    "Aristoteles et Corpus Aristotelicum Phil.": {
        "tlg_id": "TLG0086",
        "names": {
            "name_authtab": "Aristoteles Phil. et Corpus Aristotelicum, Aristotle",
            "name_idt": "Aristoteles et Corpus Aristotelicum Phil.",
        },
        "works": {
            "": ["De motu animalium", "Bekker page", "line"],
            "De somno et vigilia": ["Bekker page", "line"],
            "Meteorologica": ["Bekker page", "line"],
            "2Physicorum libri octavi textus alter (post 267b26)": [
                "Bekker page",
                "line",
            ],
            "Poetica": ["Bekker page", "line"],
            "Politica": ["Bekker page", "line"],
            "!De longitudine et brevitate vitae": ["Bekker page", "line"],
            "-De juventute et senectute %7 De vita et morte": ["Bekker page", "line"],
            "De insomniis": ["Bekker page", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Problemata": ["Bekker page", "line"],
            "De generatione et corruptione": ["Bekker page", "line"],
            "Mechanica": ["Bekker page", "line"],
            "Fragmenta varia": ["Category", "\x0etreatise title", "fragment", "line"],
            "De sensu et sensibilibus": ["Bekker page", "line"],
            "Sophistici elenchi": ["Bekker page", "line"],
            "Topica": ["Bekker page", "line"],
            "Protrepticus": ["Fragment", "line"],
            "De respiratione": ["Bekker page", "line"],
            "Rhetorica": ["Bekker page", "line"],
            "De coloribus": ["Bekker page", "line"],
            "De spiritu": ["Bekker page", "line"],
            "De interpretatione": ["Bekker page", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "Historia animalium": ["Bekker page", "line"],
            "De mundo": ["Bekker page", "line"],
            "Metaphysica": ["Bekker page", "line"],
            '"De Xenophane, de Zenone, de Gorgia': ["Bekker page", "line"],
            "De caelo": ["Bekker page", "line"],
            "De divinatione per somnum": ["Bekker page", "line"],
            "Categoriae": ["Bekker page", "line"],
            "Mirabilium auscultationes": ["Bekker page", "line"],
            "QDe anima (codicis P lectiones quae valde a lectionibus ceterorum codicum distant)": [
                "Fragment",
                "Bekker page",
                "line",
            ],
            "De lineis insecabilibus": ["Bekker page", "line"],
            "Epistulae": ["Epistle", "line"],
            "De incessu animalium": ["Bekker page", "line"],
            "Divisiones Aristoteleae": ["Page+column", "line"],
            "Fragmentum": ["line"],
            "=De anima (codicis E fragmenta recensionis a vulgata diversae)": [
                "Fragment",
                "Bekker page",
                "line",
            ],
            "Physiognomonica": ["Bekker page", "line"],
            "Oeconomica": ["Bekker page", "line", "³"],
            "Physica": ["Bekker page", "line"],
            "De generatione animalium": ["Bekker page", "line"],
            "De anima": ["Bekker page", "line"],
            "De partibus animalium": ["Bekker page", "line", "\x8e¤¤§©®\x8c³", "4³"],
            "De audibilibus": ["Bekker page", "line"],
            "$*)AQHNAI/WN POLITEI/A&": ["Section", "subsection", "line"],
            "De ventorum situ et nominibus": ["Bekker page", "line"],
            "De virtutibus et vitiis": ["Bekker page", "line"],
            "Ethica Eudemia": ["Bekker page", "line"],
            "Magna moralia": ["Book", "chapter", "section", "line"],
            "De memoria et reminiscentia": ["Bekker page", "line"],
            "Analytica priora et posteriora": ["Bekker page", "line"],
        },
    },
    "Anonymi In Aristotelis Categorias Phil.": {
        "tlg_id": "TLG4027",
        "names": {
            "name_authtab": "Anonymi In Aristotelis Categorias Phil.",
            "name_idt": "Anonymi In Aristotelis Categorias Phil.",
        },
        "works": {"Paraphrasis categoriarum": ["Page", "line"]},
    },
    "Etymologicum Parvum": {
        "tlg_id": "TLG4101",
        "names": {
            "name_authtab": "Etymologicum Parvum",
            "name_idt": "Etymologicum Parvum",
        },
        "works": {"Etymologicum parvum": ["Letter", "entry", "line"]},
    },
    "Dictys Hist.": {
        "tlg_id": "TLG1310",
        "names": {"name_authtab": "Dictys Hist.", "name_idt": "Dictys Hist."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Timonax Hist.": {
        "tlg_id": "TLG1736",
        "names": {"name_authtab": "Timonax Hist.", "name_idt": "Timonax Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sophaenetus Hist.": {
        "tlg_id": "TLG1683",
        "names": {"name_authtab": "Sophaenetus Hist.", "name_idt": "Sophaenetus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hierocles Phil.": {
        "tlg_id": "TLG2571",
        "names": {"name_authtab": "Hierocles Phil.", "name_idt": "Hierocles Phil."},
        "works": {"In aureum carmen": ["Chapter", "section", "line"]},
    },
    "David Phil.": {
        "tlg_id": "TLG4021",
        "names": {"name_authtab": "David Phil.", "name_idt": "David Phil."},
        "works": {
            '"In Porphyrii isagogen commentarium': ["Page", "line"],
            "Prolegomena philosophiae": ["Page", "line"],
        },
    },
    "Melanthius Eleg., Trag.": {
        "tlg_id": "TLG0254",
        "names": {
            "name_authtab": "Melanthius Eleg. et Trag.",
            "name_idt": "Melanthius Eleg., Trag.",
        },
        "works": {"Fragmentum": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Georgius Gramm.": {
        "tlg_id": "TLG3187",
        "names": {"name_authtab": "Georgius Gramm.", "name_idt": "Georgius Gramm."},
        "works": {"Anacreontea": ["Fragment", "line"]},
    },
    "Simonides Epic.": {
        "tlg_id": "TLG1906",
        "names": {"name_authtab": "Simonides Epic.", "name_idt": "Simonides Epic."},
        "works": {"Tituli": ["Fragment", "line"]},
    },
    "Aratus Hist.": {
        "tlg_id": "TLG2162",
        "names": {"name_authtab": "Aratus Hist.", "name_idt": "Aratus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Damon Mus.": {
        "tlg_id": "TLG2232",
        "names": {"name_authtab": "Damon Mus.", "name_idt": "Damon Mus."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Epica Incerta (CA)": {
        "tlg_id": "TLG1345",
        "names": {
            "name_authtab": "Epica Incerta (CA)",
            "name_idt": "Epica Incerta (CA)",
        },
        "works": {"Fragmentum": ["line"], "Fragmenta": ["Fragment", "line"]},
    },
    "Ammonius Phil.": {
        "tlg_id": "TLG4016",
        "names": {"name_authtab": "Ammonius Phil.", "name_idt": "Ammonius Phil."},
        "works": {
            "%In Aristotelis analytica priora [Sp.]": ["Page", "line"],
            "9In Aristotelis analyticorum priorum librum i commentarium": [
                "Page",
                "line",
            ],
            "&In Aristotelis categorias commentarius": ["Page", "line"],
            "(In Porphyrii isagogen sive quinque voces": ["Page", "line"],
            "5In Aristotelis librum de interpretatione commentarius": ["Page", "line"],
        },
    },
    "Stephanus Med.": {
        "tlg_id": "TLG0736",
        "names": {"name_authtab": "Stephanus Med.", "name_idt": "Stephanus Med."},
        "works": {"#In Magni sophistae librum de urinis": ["Section", "line"]},
    },
    "Antonini Pii Imperatoris Epistula": {
        "tlg_id": "TLG1149",
        "names": {
            "name_authtab": "Antonini Pii Imperatoris Epistula",
            "name_idt": "Antonini Pii Imperatoris Epistula",
        },
        "works": {"Epistula ad commune Asiae": ["line"]},
    },
    "Acta Joannis": {
        "tlg_id": "TLG0317",
        "names": {"name_authtab": "Acta Joannis", "name_idt": "Acta Joannis"},
        "works": {
            "Acta Joannis": ["Section", "line"],
            "Acta Joannis (recensio)": ["Section", "line"],
        },
    },
    "Strabo Geogr.": {
        "tlg_id": "TLG0099",
        "names": {"name_authtab": "Strabo Geogr.", "name_idt": "Strabo Geogr."},
        "works": {
            "Geographica": ["Book", "chapter", "section", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Simplicius Phil.": {
        "tlg_id": "TLG4013",
        "names": {"name_authtab": "Simplicius Phil.", "name_idt": "Simplicius Phil."},
        "works": {
            "'De caelo i (interpretatio Graeca ex Kc)": ["Volume", "page", "line"],
            "&In Aristotelis categorias commentarium": ["Volume", "page", "line"],
            "PIn Aristotelis libros de anima commentaria [Sp.?] (fort. auctore Prisciano Lydo)": [
                "Volume",
                "page",
                "line",
            ],
            "$Commentarius in Epicteti enchiridion": ["Page", "line"],
            ",In Aristotelis physicorum libros commentaria": ["Volume", "page", "line"],
            "3In Aristotelis quattuor libros de caelo commentaria": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "[Clitonymus] Hist.": {
        "tlg_id": "TLG2190",
        "names": {
            "name_authtab": "[Clitonymus] Hist.",
            "name_idt": "[Clitonymus] Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymus Presbyter Scr. Eccl.": {
        "tlg_id": "TLG1136",
        "names": {
            "name_authtab": "Anonymus Presbyter Scr. Eccl.",
            "name_idt": "Anonymus Presbyter Scr. Eccl.",
        },
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Theodosius Diaconus Hist., Poeta": {
        "tlg_id": "TLG3125",
        "names": {
            "name_authtab": "Theodosius Diaconus Hist. et Poeta",
            "name_idt": "Theodosius Diaconus Hist., Poeta",
        },
        "works": {"De Creta capta": ["\x0ePraefatio-poem", "line"]},
    },
    "Scholia In Lucianum": {
        "tlg_id": "TLG5029",
        "names": {
            "name_authtab": "Scholia In Lucianum",
            "name_idt": "Scholia In Lucianum",
        },
        "works": {
            "4Scholia in Pseudo-Luciani Halcyonem (scholia vetera)": [
                "Hermann page",
                "line",
            ],
            ":Scholia in Lucianum (scholia vetera et recentiora Arethae)": [
                "Lucianic work",
                "section",
                "line",
                "\x92\x13\x14î\x16º\x18\x19´\x1b´¾\x1f\x1fî\x8c \x92 î½\"\"\"î©#\x92\x8c$$î$î$î%¼&î'¼'\x92'\x8c*\x92\x8c**¶+î+\x92,\x8c\x8e,\x92,î-\x92..\x92®¾/î/\x92¾00\x920î1\x9211112\x922¾2½Ñ3334Í4Íî4î\x9244445\x925\x9255Í5Í555\x925666\x926Í66\x926\x926Í\x926\x926Í6Í³ÍÍ³7Î7Î7\x92777î\x9277Î77Î7Î´7\x927Ï7Ï\x927888Ï¶\x9288\x9288Ï88\x928888\x9288Ï\x928Ï88888Ï´9Ð9Ð99\x9299\x9299:Ð:Ð:\x92::::\x92\x8e\x92",
                "\x13\x16\x18\x19\x1b\x1f \"\"#$%'''***+³,,-../»001¿11112223334Í4Í³4445555Í5Í55556666Í6666Í66Í7Î7Î7777Î¶7Î77Î7Î´77Ï7Ï7888Ï¶8888Ï88888888Ï8Ï88889Ð\x8e;",
            ],
        },
    },
    "Rutilius Rufus Hist.": {
        "tlg_id": "TLG2546",
        "names": {
            "name_authtab": "Publius Rutilius Rufus Hist.",
            "name_idt": "Rutilius Rufus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Bato Comic.": {
        "tlg_id": "TLG0425",
        "names": {"name_authtab": "Bato Comic.", "name_idt": "Bato Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Diogenes Phil., Trag.": {
        "tlg_id": "TLG0334",
        "names": {
            "name_authtab": "Diogenes Phil. et Trag.",
            "name_idt": "Diogenes Phil., Trag.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollas Hist.": {
        "tlg_id": "TLG1162",
        "names": {"name_authtab": "Apollas Hist.", "name_idt": "Apollas Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "[Homerus] Epic.": {
        "tlg_id": "TLG0253",
        "names": {"name_authtab": "[Homerus] Epic.", "name_idt": "[Homerus] Epic."},
        "works": {"Margites (fragmenta)": ["Fragment", "line"]},
    },
    "Acesander Hist.": {
        "tlg_id": "TLG1832",
        "names": {"name_authtab": "Acesander Hist.", "name_idt": "Acesander Hist."},
        "works": {
            "Fragmentum (P. Oxy. 32.2637)": ["FGrH fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
        },
    },
    "Lobo Poeta": {
        "tlg_id": "TLG2630",
        "names": {"name_authtab": "Lobo Poeta", "name_idt": "Lobo Poeta"},
        "works": {
            "Fragmenta et titulus": ["Fragment", "line"],
            "9Epigrammata in poetas ante Alexandrinorum aetatem condita": [
                "Page",
                "line",
            ],
        },
    },
    "Iamblichus Scr. Erot.": {
        "tlg_id": "TLG1441",
        "names": {
            "name_authtab": "Iamblichus Scr. Erot.",
            "name_idt": "Iamblichus Scr. Erot.",
        },
        "works": {"Babyloniaca": ["Fragment", "line"]},
    },
    "Archilochus Eleg., Iamb.": {
        "tlg_id": "TLG0232",
        "names": {
            "name_authtab": "Archilochus Eleg. et Iamb.",
            "name_idt": "Archilochus Eleg., Iamb.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta lyrica": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Demetrii Phalerei Epistula": {
        "tlg_id": "TLG1298",
        "names": {
            "name_authtab": "Demetrii Phalerei Epistula",
            "name_idt": "Demetrii Phalerei Epistula",
        },
        "works": {"Epistula": ["line"]},
    },
    "Testamenta XII Patriarcharum": {
        "tlg_id": "TLG1700",
        "names": {
            "name_authtab": "Testamenta XII Patriarcharum",
            "name_idt": "Testamenta XII Patriarcharum",
        },
        "works": {
            "Testamenta xii patriarcharum": [
                "Testamentum",
                "chapter",
                "section",
                "line",
            ]
        },
    },
    "Antiphon Orat.": {
        "tlg_id": "TLG0028",
        "names": {"name_authtab": "Antiphon Orat.", "name_idt": "Antiphon Orat."},
        "works": {
            "Tetralogia 3": ["Tetralogy", "section", "line"],
            "Fragmenta": ["Fragment", "subfragment", "line"],
            "Tetralogia 2": ["Tetralogy", "section", "line"],
            "De caede Herodis": ["Section", "line"],
            "In novercam": ["Section", "line"],
            "Tetralogia 1": ["Tetralogy", "section", "line"],
            "De choreuta": ["Section", "line", ""],
        },
    },
    "Dieuches Med.": {
        "tlg_id": "TLG0856",
        "names": {"name_authtab": "Dieuches Med.", "name_idt": "Dieuches Med."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Anthologia Graeca": {
        "tlg_id": "TLG7000",
        "names": {
            "name_authtab": "Anthologia Graeca, AG",
            "name_idt": "Anthologia Graeca",
        },
        "works": {"": ["Anthologia Graeca", "Book", "epigram", "line"]},
    },
    "Diogenianus Phil.": {
        "tlg_id": "TLG1322",
        "names": {"name_authtab": "Diogenianus Phil.", "name_idt": "Diogenianus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Agroetas Hist.": {
        "tlg_id": "TLG1835",
        "names": {"name_authtab": "Agroetas Hist.", "name_idt": "Agroetas Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Fabius Pictor Hist.": {
        "tlg_id": "TLG2542",
        "names": {
            "name_authtab": "Quintus Fabius Pictor Hist.",
            "name_idt": "Fabius Pictor Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hephaestion Astrol.": {
        "tlg_id": "TLG2043",
        "names": {
            "name_authtab": "Hephaestion Astrol.",
            "name_idt": "Hephaestion Astrol.",
        },
        "works": {
            '"Excerptum (e cod. Paris. gr. 2506)': ["Page", "line"],
            "#Excerptum (e cod. Marcian. gr. 334)": ["Page", "line"],
            "Apotelesmatica": ["Page", "line"],
            " Excerptum (e cod. Vat. gr. 1056)": ["Page", "line"],
            '"Apotelesmatica (epitomae quattuor)': ["Page", "line"],
        },
    },
    "Lexica Segueriana": {
        "tlg_id": "TLG4289",
        "names": {"name_authtab": "Lexica Segueriana", "name_idt": "Lexica Segueriana"},
        "works": {
            "+Anonymus antatticista (e cod. Coislin. 345)": [
                "Alphabetic entry",
                "page",
                "line",
            ],
            "qCollectio verborum utilium e differentibus rhetoribus et sapientibus multis ($*S&<6b>6) (recensio aucta e cod. Co": [
                "Alphabetic entry",
                "page",
                "line",
            ],
            "(Glossae rhetoricae (e cod. Coislin. 345)": [
                "Alphabetic entry",
                "page",
                "line",
            ],
            "qCollectio verborum utilium e differentibus rhetoribus et sapientibus multis (%6 $*SUNAGWGH\\ LE/CEWN XRHSI/MWN E)K": [
                "Page",
                "line",
            ],
            "$De syntacticis (e cod. Coislin. 345)": [
                "Alphabetic entry",
                "page",
                "line",
            ],
            ")$*DIKW=N O)NO/MATA &(e cod. Coislin. 345)": [
                "Alphabetic entry",
                "page",
                "line",
            ],
        },
    },
    "Amelii Epistula": {
        "tlg_id": "TLG2004",
        "names": {"name_authtab": "Amelii Epistula", "name_idt": "Amelii Epistula"},
        "works": {"Amelii epistula": ["line"]},
    },
    "Carmen Astrologicum": {
        "tlg_id": "TLG0286",
        "names": {
            "name_authtab": "Carmen Astrologicum",
            "name_idt": "Carmen Astrologicum",
        },
        "works": {"Fragmentum": ["line"]},
    },
    "Sosiphanes Trag.": {
        "tlg_id": "TLG0338",
        "names": {"name_authtab": "Sosiphanes Trag.", "name_idt": "Sosiphanes Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heraclides Ponticus Phil.": {
        "tlg_id": "TLG1409",
        "names": {
            "name_authtab": "Heraclides Ponticus Phil.",
            "name_idt": "Heraclides Ponticus Phil.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Theodorus Studites Scr. Eccl., Theol.": {
        "tlg_id": "TLG2714",
        "names": {
            "name_authtab": "Theodorus Studites Scr. Eccl. et Theol.",
            "name_idt": "Theodorus Studites Scr. Eccl., Theol.",
        },
        "works": {
            "Epistulae": ["Epistle", "line"],
            "Iambi de variis argumentis": ["Epigram", "line"],
            "AHomilia in nativitatem Mariae (olim sub auctore Joanne Damasceno)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Commentaria In Dionysii Thracis Artem Grammaticam": {
        "tlg_id": "TLG4175",
        "names": {
            "name_authtab": "Commentaria In Dionysii Thracis Artem Grammaticam",
            "name_idt": "Commentaria In Dionysii Thracis Artem Grammaticam",
        },
        "works": {
            "Commentariolus Byzantinus": ["Page", "line"],
            "Prolegomena Vossiana": ["Page", "line"],
            "0Commentarius (sub auctore Melampode vel Diomede)": ["Page", "line"],
            "qScholia Marciana (partim excerpta ex Heliodoro, Tryphone, Diomede, Stephano, Georgio Choerobosco, Gregorio Corint": [
                "Page",
                "line",
            ],
            "2Scholia Londinensia (partim excerpta ex Heliodoro)": ["Page", "line"],
            "qScholia Vaticana (partim excerpta ex Georgio Choerobosco, Georgio quodam, Porphyrio, Melampode, Stephano, Diomede": [
                "Page",
                "line",
            ],
            "$Commentarius (sub auctore Heliodoro)": ["Page", "line"],
        },
    },
    "Euripides Trag.": {
        "tlg_id": "TLG0006",
        "names": {"name_authtab": "Euripides Trag.", "name_idt": "Euripides Trag."},
        "works": {
            "Fragmenta Alexandri": ["Fragment", "line"],
            "": ["Iphigenia Taurica", "line"],
            "Electra": ["line"],
            "Cyclops": ["line"],
            "Alcestis": ["line"],
            "#Fragmenta Phrixei (P. Oxy. 34.2685)": ["Fragment", "line"],
            "Fragmenta Antiopes": ["Fragment", "line"],
            "Troiades": ["line"],
            "Heraclidae": ["line"],
            "Iphigenia Aulidensis": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Helena": ["line"],
            "Hippolytus": ["line"],
            "Medea": ["line"],
            "Fragmenta Phaethontis": ["line"],
            "Andromacha": ["line"],
            "Supplices": ["line"],
            "Fragmenta fabulae incertae": ["Column", "line"],
            "Fragmenta Hypsipyles": ["Fragment", "line"],
            "Fragmenta Oenei": ["Page", "fragment", "line"],
            "Rhesus": ["line"],
            "Hercules": ["line"],
            "Bacchae": ["line"],
            "Phoenisae": ["line"],
            "Orestes": ["line"],
            "Ion": ["line"],
            "Hecuba": ["line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "$Fragmenta Phaethontis incertae sedis": ["Fragment", "line"],
            "Fragmenta papyracea": ["Fragment", "line"],
            "#Epinicium in Alcibiadem (fragmenta)": ["Fragment", "line"],
        },
    },
    "Amipsias Comic.": {
        "tlg_id": "TLG0403",
        "names": {"name_authtab": "Amipsias Comic.", "name_idt": "Amipsias Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Minucianus Junior Rhet.": {
        "tlg_id": "TLG2903",
        "names": {
            "name_authtab": "Minucianus Junior Rhet.",
            "name_idt": "Minucianus Junior Rhet.",
        },
        "works": {"$*PERI\\ E)PIXEIRHMA/TWN&": ["Page", "line"]},
    },
    "Phaedimus Epigr.": {
        "tlg_id": "TLG1577",
        "names": {"name_authtab": "Phaedimus Epigr.", "name_idt": "Phaedimus Epigr."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Tyrannion Junior Gramm.": {
        "tlg_id": "TLG1611",
        "names": {
            "name_authtab": "Tyrannion Junior Gramm.",
            "name_idt": "Tyrannion Junior Gramm.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Ptolemaeus Gnost.": {
        "tlg_id": "TLG1641",
        "names": {"name_authtab": "Ptolemaeus Gnost.", "name_idt": "Ptolemaeus Gnost."},
        "works": {"Epistula ad Floram": ["Chapter", "section", "line"]},
    },
    "Sallustius Phil.": {
        "tlg_id": "TLG2049",
        "names": {"name_authtab": "Sallustius Phil.", "name_idt": "Sallustius Phil."},
        "works": {"De deis et mundo": ["Chapter", "section", "line"]},
    },
    "Hermolochus Lyr.": {
        "tlg_id": "TLG0240",
        "names": {"name_authtab": "Hermolochus Lyr.", "name_idt": "Hermolochus Lyr."},
        "works": {"Fragmentum": ["line"]},
    },
    "Scholia In Diophantum": {
        "tlg_id": "TLG5021",
        "names": {
            "name_authtab": "Scholia In Diophantum",
            "name_idt": "Scholia In Diophantum",
        },
        "works": {
            "hScholia in Diophanti arithmetica (scholia recentiora e codd. Matr. Bibl. Nat. 4678; Vat. gr. 191 et 304)": [
                "Scholion",
                "line",
            ]
        },
    },
    "Ilias Parva": {
        "tlg_id": "TLG1444",
        "names": {"name_authtab": "Ilias Parva", "name_idt": "Ilias Parva"},
        "works": {"Ilias parva (fragmenta)": ["Fragment", "line"]},
    },
    "Melinno Lyr.": {
        "tlg_id": "TLG1493",
        "names": {"name_authtab": "Melinno Lyr.", "name_idt": "Melinno Lyr."},
        "works": {"$*EI)S *(RW/MHN&": ["Fragment", "line"]},
    },
    "Cleomedes Astron.": {
        "tlg_id": "TLG1272",
        "names": {"name_authtab": "Cleomedes Astron.", "name_idt": "Cleomedes Astron."},
        "works": {"%De motu circulari corporum caelestium": ["Page", "line"]},
    },
    "Codinus Hist.": {
        "tlg_id": "TLG3168",
        "names": {"name_authtab": "Pseudo-Codinus Hist.", "name_idt": "Codinus Hist."},
        "works": {
            "QPatria Constantinopoleos (ordo et tituli paragraphorum, quem sequitur recensio M)": [
                "Book",
                "section",
                "line",
            ],
            "+Patria Constantinopoleos (variae lectiones)": ["Book", "section", "line"],
            "Patria Constantinopoleos": ["Book", "section", "line"],
            "ODe officiis (%6 officia palatii Constantinopoleos) (e codd Vat. gr. 162 %7 975)": [
                "Page",
                "line",
            ],
            "CDe officiis (%6 officia magnae ecclesiae) (auctore Andrea Darmario)": [
                "Page",
                "line",
            ],
            "2De officiis (%6 officia palatii Constantinopoleos)": ["Page", "line"],
            "De annis ab orbe condito": ["Section", "line"],
            "fPatria Constantinopoleos (ordo et tituli paragraphorum, quem sequitur recensio C, ejusque additamenta)": [
                "Book",
                "section",
                "line",
            ],
        },
    },
    "Persinus Poeta": {
        "tlg_id": "TLG2635",
        "names": {"name_authtab": "Persinus Poeta", "name_idt": "Persinus Poeta"},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Geoponica": {
        "tlg_id": "TLG4080",
        "names": {"name_authtab": "Geoponica", "name_idt": "Geoponica"},
        "works": {"Geoponica": ["Book", "chapter", "section", "line"]},
    },
    "Prodicus Soph.": {
        "tlg_id": "TLG1634",
        "names": {"name_authtab": "Prodicus Soph.", "name_idt": "Prodicus Soph."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Cyranides": {
        "tlg_id": "TLG1482",
        "names": {"name_authtab": "Cyranides", "name_idt": "Cyranides"},
        "works": {"Cyranides": ["Book", "section", "line"]},
    },
    "Scholia In Aristophanem": {
        "tlg_id": "TLG5014",
        "names": {
            "name_authtab": "Scholia In Aristophanem",
            "name_idt": "Scholia In Aristophanem",
        },
        "works": {
            "TCommentarium in ranas (scholia recentiora Tzetzae) (cod. Ambrosianus gr. C 222 inf.)": [
                "\x1aDramatis personae-scholion",
                "verse",
                "line",
            ],
            "@Commentarium in plutum (recensio 1) (scholia recentiora Tzetzae)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
            "IScholia in nubes (scholia scholiorumque partes editionis Aldinae propria)": [
                "Play",
                "verse",
                "line",
            ],
            "@Commentarium in plutum (recensio 2) (scholia recentiora Tzetzae)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
            "!Scholia in nubes (scholia vetera)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
            "2Commentarium in ranas (scholia recentiora Tzetzae)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
            "MScholia in nubes (scholia recentiora Eustathii, Thomae Magistri et Triclinii)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
            " Scholia in aves (scholia vetera)": [
                "Argumentum-scholion",
                "verse",
                "line",
            ],
            "7Scholia in Acharnenses (scholia vetera) (P. Oxy. 6.856)": [
                "Play",
                "",
                "fragment + column",
                "line",
            ],
            ";Commentarium in aves (scholia vetera et recentiora Tzetzae)": [
                "Argumentum-dramatis personae-scholion",
                "section-verse",
                "line",
            ],
            "-Scholia in Thesmophoriazusas (scholia vetera)": [
                "Scholion",
                "verse",
                "line",
            ],
            "-Scholia in nubes (scholia anonyma recentiora)": ["Play", "verse", "line"],
            ".Glossae in plutum (scholia recentiora Tzetzae)": [
                "Play",
                "verse",
                "line",
            ],
            "2Commentarium in nubes (scholia recentiora Tzetzae)": [
                "Argumentum-dramatis personae-scholion",
                "verse-column",
                "line",
            ],
            ")Scholia in ecclesiazusas (scholia vetera)": [
                "Argumentum-scholion",
                "verse",
                "line",
            ],
            "DScholia in vespas (scholia vetera, recentiora Tricliniana et Aldina)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
            "MScholia in plutum (scholia vetera et fort. recentiora sub auctore Moschopulo)": [
                "Argumentum-scholion",
                "verse",
                "line",
            ],
            "-Argumentum in equites (argumentum Tzetzianum)": [
                "Argumentum-dramatis personae",
                "line",
            ],
            ";Scholia in equites (scholia vetera et recentiora Triclinii)": [
                "Argumentum-dramatis personae-scholion",
                "section-verse",
                "line",
            ],
            "?Scholia in Acharnenses (scholia vetera et recentiora Triclinii)": [
                "\x1bHypothesis-epigram-scholion",
                "verse",
                "line",
            ],
            "!Scholia in ranas (scholia vetera)": [
                "Argumentum-scholion",
                "verse",
                "line",
            ],
            "'Scholia in Lysistratam (scholia vetera)": [
                "Argumentum-scholion",
                "verse",
                "line",
            ],
            "9Scholia in pacem (scholia vetera et recentiora Triclinii)": [
                "Argumentum-dramatis personae-scholion",
                "verse",
                "line",
            ],
        },
    },
    "Ulpianus Gramm., Rhet.": {
        "tlg_id": "TLG2604",
        "names": {
            "name_authtab": "Ulpianus Gramm. et Rhet.",
            "name_idt": "Ulpianus Gramm., Rhet.",
        },
        "works": {
            "?Prolegomena in Demosthenis orationes Olynthiacas et Philippicas": [
                "Page",
                "line",
            ]
        },
    },
    "Constantinus VII Porphyrogenitus Imperator Hist.": {
        "tlg_id": "TLG3023",
        "names": {
            "name_authtab": "Constantinus VII Porphyrogenitus Imperator Hist.",
            "name_idt": "Constantinus VII Porphyrogenitus Imperator Hist.",
        },
        "works": {
            "": ["Oratio ad milites", "line"],
            "De sententiis": ["Page", "line"],
            "5De strategematibus (olim sub auctore Herone Byzantio)": [
                "Wescher page",
                "line",
            ],
            "De legationibus": ["Page", "line"],
            "/De cerimoniis aulae Byzantinae (lib. 1.84-2.56)": ["Page", "line"],
            "De virtutibus et vitiis": ["Volume", "page", "line"],
            "De insidiis": ["Page", "line"],
            '"Oratio de translatione Chrysostomi': ["Page", "line"],
            "De contionibus militaribus": ["Section", "line", "."],
            "De administrando imperio": ["Chapter", "line"],
            "Narratio de imagine Edessena": ["Section", "line"],
            ",De cerimoniis aulae Byzantinae (lib. 1.1-92)": ["Volume", "page", "line"],
            "De thematibus": ["Asia-Europe", "chapter", "line"],
        },
    },
    "Blemmydes Alchem.": {
        "tlg_id": "TLG4333",
        "names": {
            "name_authtab": "Nicephorus Blemmydes Alchem.",
            "name_idt": "Blemmydes Alchem.",
        },
        "works": {
            "q$*NIKHFO/ROU TOU= *BLEMMU/DOU PERI\\ TH=S XRUSOPOII/AS &(fort. auctore Nicephoro Blemmyde alio) (e cod. Paris. B.N": [
                "Volume",
                "page",
                "line",
            ],
            "q$*(/APER XRH/|ZEI H( PAROU=SA KATASKEUH/ &(fort. auctore Nicephoro Blemmyde alio) (e cod. Paris. B.N. gr. 2509, f": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Theophrastus Alchem., Poeta": {
        "tlg_id": "TLG4338",
        "names": {
            "name_authtab": "Theophrastus Alchem. et Poeta",
            "name_idt": "Theophrastus Alchem., Poeta",
        },
        "works": {
            "q$*QEOFRA/STOU FILOSO/FOU PERI\\ TH=S QEI/AS TE/XNHS DIA\\ STI/XWN I)A/MBWN &(fort. auctore Heliodoro alchemista et ": [
                "line"
            ]
        },
    },
    "Scholia In Lycophronem": {
        "tlg_id": "TLG5030",
        "names": {
            "name_authtab": "Scholia In Lycophronem",
            "name_idt": "Scholia In Lycophronem",
        },
        "works": {
            "UScholia in Lycophronem (scholia vetera et recentiora partim Isaac et Joannis Tzetzae)": [
                "Scholion",
                "line",
            ]
        },
    },
    "[Agatharchides] Hist.": {
        "tlg_id": "TLG2192",
        "names": {
            "name_authtab": "[Agatharchides] Hist.",
            "name_idt": "[Agatharchides] Hist.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "[Hermesianax] Hist.": {
        "tlg_id": "TLG2532",
        "names": {
            "name_authtab": "[Hermesianax] Hist.",
            "name_idt": "[Hermesianax] Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Acta Phileae": {
        "tlg_id": "TLG2014",
        "names": {"name_authtab": "Acta Phileae", "name_idt": "Acta Phileae"},
        "works": {"Acta Phileae (P. Bodmer 20)": ["Column", "line"]},
    },
    "Hermias Apol.": {
        "tlg_id": "TLG0531",
        "names": {"name_authtab": "Hermias Apol.", "name_idt": "Hermias Apol."},
        "works": {"Irrisio gentilium philosophorum": ["Section", "line"]},
    },
    "Archippus Comic.": {
        "tlg_id": "TLG0417",
        "names": {"name_authtab": "Archippus Comic.", "name_idt": "Archippus Comic."},
        "works": {"Fragmenta": ["Fragment", "line"], "Tituli": ["Fragment", "line"]},
    },
    "[Ath]enodorus Trag.": {
        "tlg_id": "TLG0621",
        "names": {
            "name_authtab": "[Ath]enodorus Trag.",
            "name_idt": "[Ath]enodorus Trag.",
        },
        "works": {"Titulus": ["line"]},
    },
    "Charax Hist.": {
        "tlg_id": "TLG1254",
        "names": {"name_authtab": "Charax Hist.", "name_idt": "Charax Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Arethas Philol., Scr. Eccl.": {
        "tlg_id": "TLG2130",
        "names": {
            "name_authtab": "Arethas Philol. et Scr. Eccl.",
            "name_idt": "Arethas Philol., Scr. Eccl.",
        },
        "works": {
            ";Fragmentum in epistulam ii ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "3Fragmenta in epistulam i ad Corinthios (in catenis)": ["Page", "line"],
            "kScholia Arethae in Cyrilli apologiam xii anathematismorum contra Theodoretum et in Theodoreti impugnationem": [
                "Page",
                "line",
            ],
            "3Fragmentum in epistulam i ad Timotheum (in catenis)": ["Page", "line"],
            "0Fragmentum in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "4Fragmenta in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Timaeus Phil.": {
        "tlg_id": "TLG1734",
        "names": {"name_authtab": "Timaeus Phil.", "name_idt": "Timaeus Phil."},
        "works": {
            "Fragmenta et titulus [Sp.]": ["Page", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Anonymus De Viribus Herbarum": {
        "tlg_id": "TLG0282",
        "names": {
            "name_authtab": "Anonymus De Viribus Herbarum",
            "name_idt": "Anonymus De Viribus Herbarum",
        },
        "works": {"'Carminis de viribus herbarum fragmentum": ["line"]},
    },
    "Hyperochus Hist.": {
        "tlg_id": "TLG2396",
        "names": {"name_authtab": "Hyperochus Hist.", "name_idt": "Hyperochus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Lesbonax Rhet.": {
        "tlg_id": "TLG0649",
        "names": {"name_authtab": "Lesbonax Rhet.", "name_idt": "Lesbonax Rhet."},
        "works": {
            "$*POLITIKO/S&": ["Section", "line"],
            "$*PROTREPTIKO\\S& B": ["Section", "line"],
            "$*PROTREPTIKO\\S& A": ["Section", "line"],
        },
    },
    "Phillis Hist.": {
        "tlg_id": "TLG2594",
        "names": {"name_authtab": "Phillis Hist.", "name_idt": "Phillis Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Asclepiades Epigr.": {
        "tlg_id": "TLG0137",
        "names": {
            "name_authtab": "Asclepiades Epigr.",
            "name_idt": "Asclepiades Epigr.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Diogenes Trag.": {
        "tlg_id": "TLG0320",
        "names": {"name_authtab": "Diogenes Trag.", "name_idt": "Diogenes Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Cornutus Phil.": {
        "tlg_id": "TLG0654",
        "names": {
            "name_authtab": "Lucius Annaeus Cornutus Phil.",
            "name_idt": "Cornutus Phil.",
        },
        "works": {"De natura deorum": ["Page", "line"]},
    },
    "Fragmentum Stoicum": {
        "tlg_id": "TLG2287",
        "names": {
            "name_authtab": "Fragmentum Stoicum",
            "name_idt": "Fragmentum Stoicum",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Philistus Hist.": {
        "tlg_id": "TLG1591",
        "names": {"name_authtab": "Philistus Hist.", "name_idt": "Philistus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hippocrates Med.": {
        "tlg_id": "TLG0751",
        "names": {
            "name_authtab": "Pseudo-Hippocrates Med.",
            "name_idt": "Hippocrates Med.",
        },
        "works": {
            "-$*PERI\\ DIAFORA=S TROFW=N PRO\\S *PTOLEMAI=ON&": ["Page", "line"],
            ")$*PERI\\ DIAFO/RWN KAI\\ PANTOI/WN TROFW=N&": ["Page", "line"],
            "Epistula ad Ptolemaeum regem": ["Page", "line"],
            "/Epistula ad Ptolemaeum regem de hominis fabrica": ["Page", "line"],
            "$$*(ERMHNEI/A PERI\\ E)NERGW=N LI/QWN&": ["Lexical entry", "line"],
        },
    },
    "Periplus Maris Erythraei": {
        "tlg_id": "TLG0071",
        "names": {
            "name_authtab": "Periplus Maris Erythraei",
            "name_idt": "Periplus Maris Erythraei",
        },
        "works": {
            "5Anonymi (Arriani, ut fertur) periplus maris Erythraei": [
                "Section",
                "line",
            ]
        },
    },
    "Orphica": {
        "tlg_id": "TLG0579",
        "names": {"name_authtab": "Orphica", "name_idt": "Orphica"},
        "works": {
            "Argonautica": ["line", "³"],
            "": ["Lithica kerygmata", "Section", "line"],
            "Fragmenta (P. Derveni)": ["Column", "line"],
            "Lithica": ["line"],
            "Testimonia": ["Fragment", "line"],
            "Hymni": ["Hymn", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Fragmentum astrologicum": ["Volume", "page", "line"],
        },
    },
    "Myia Phil.": {
        "tlg_id": "TLG0509",
        "names": {"name_authtab": "Myia Phil.", "name_idt": "Myia Phil."},
        "works": {"Epistula ad Phyllidem": ["Page", "line"]},
    },
    "Cleomenes Lyr.": {
        "tlg_id": "TLG0900",
        "names": {"name_authtab": "Cleomenes Lyr.", "name_idt": "Cleomenes Lyr."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Gregorius Nyssenus Theol.": {
        "tlg_id": "TLG2017",
        "names": {
            "name_authtab": "Gregorius Nyssenus Theol.",
            "name_idt": "Gregorius Nyssenus Theol.",
        },
        "works": {
            "": ["De paradiso [Sp.]", "Page", "line"],
            "+Adversus eos qui castigationes aegre ferunt": ["Volume", "page", "line"],
            "OSermo in sanctum Romanum (ap. Joannem Damascenum, Sacra parallela) (fragmentum)": [
                "Volume",
                "page",
                "line",
            ],
            "IIn sanctum et salutare pascha (vulgo In Christi resurrectionem oratio iv)": [
                "Volume",
                "page",
                "line",
            ],
            "%Ad Theophilum adversus Apollinaristas": ["Volume", "page", "line"],
            "De vita Mosis": ["Chapter", "section", "line"],
            "&De creatione hominis sermo alter [Sp.]": ["Page", "line"],
            "PSermo in Mariam et Joseph (ap. Joannem Damascenum, Sacra parallela) (fragmentum)": [
                "Volume",
                "page",
                "line",
            ],
            "[In luciferam sanctam domini resurrectionem (vulgo In Christi resurrectionem oratio v) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            " Orationes viii de beatitudinibus": ["Volume", "page", "line"],
            "De sancto Theodoro": ["Volume", "page", "line"],
            "Epistula canonica ad Letoium": ["Volume", "page", "line"],
            "3In diem luminum (vulgo In baptismum Christi oratio)": [
                "Volume",
                "page",
                "line",
            ],
            "#Antirrheticus adversus Apollinarium": ["Volume", "page", "line"],
            "Refutatio confessionis Eunomii": ["Section", "line"],
            "/De beneficentia (vulgo De pauperibus amandis i)": [
                "Volume",
                "page",
                "line",
            ],
            "%De pythonissa ad Theodosium episcopum": ["Page", "line"],
            "4De creatione hominis sermo primus (recensio C) [Sp.]": ["Page", "line"],
            '"Ad Ablabium quod non sint tres dei': ["Volume", "page", "line"],
            "Contra Eunomium": ["Book", "chapter", "section", "line"],
            "$In Canticum canticorum (homiliae 15)": ["Volume", "page", "line"],
            "De instituto Christiano": ["Volume", "page", "line"],
            "#Ad Graecos ex communibus notionibus": ["Volume", "page", "line"],
            "In inscriptiones Psalmorum": ["Volume", "page", "line"],
            "De iis qui baptismum differunt": ["Volume", "page", "line"],
            "VEpistula ad Philippum monachum (ap. Joannem Damascenum, Contra Jacobitas) (fragmentum)": [
                "Page",
                "line",
            ],
            "In annuntiationem [Sp.]": ["line"],
            "UIn illud: Quatenus uni ex his fecistis mihi fecistis (vulgo De pauperibus amandis ii)": [
                "Volume",
                "page",
                "line",
            ],
            "!Ad Eustathium de sancta trinitate": ["Volume", "page", "line"],
            "#De deitate filii et spiritus sancti": ["Volume", "page", "line"],
            ".Encomium in sanctum Stephanum protomartyrem ii": [
                "Volume",
                "page",
                "line",
            ],
            "Contra fatum": ["Page", "line"],
            "(Epistula xxvi ad Evagrium monachum [Sp.]": ["Volume", "page", "line"],
            '"Dialogus de anima et resurrectione': ["Volume", "page", "line"],
            "%Oratio funebris in Meletium episcopum": ["Volume", "page", "line"],
            " De oratione dominica orationes v": ["Page", "line"],
            "Vita sanctae Macrinae": ["Section", "line"],
            "In Ecclesiasten (homiliae 8)": ["Volume", "page", "line"],
            "#Tractatus ad Xenodorum (fragmentum)": ["line"],
            "In Basilium fratrem": ["Section", "line"],
            "Oratio catechetica magna": ["Section", "line"],
            "In ascensionem Christi": ["Volume", "page", "line"],
            "%De spiritu sancto sive In pentecosten": ["Volume", "page", "line"],
            "'De creatione hominis sermo primus [Sp.]": ["Page", "line"],
            '"De paradiso (recensio $*L&F) [Sp.]': ["Page", "line"],
            ">In sanctum pascha (vulgo In Christi resurrectionem oratio iii)": [
                "Volume",
                "page",
                "line",
            ],
            "De vita Gregorii Thaumaturgi": ["Volume", "page", "line"],
            "!De infantibus praemature abreptis": ["Page", "line"],
            "In sanctum Ephraim": ["Volume", "page", "line"],
            ")Ad imaginem dei et ad similitudinem [Sp.]": ["Volume", "page", "line"],
            "De opificio hominis": ["Page", "line"],
            "9De deitate adversus Evagrium (vulgo In suam ordinationem)": [
                "Volume",
                "page",
                "line",
            ],
            "!Oratio consolatoria in Pulcheriam": ["Volume", "page", "line"],
            "Epistulae": ["Epistle", "section", "line"],
            "Encomium in xl martyres ii": ["Volume", "page", "line"],
            "Encomium in xl martyres i": ["Volume", "page", "line"],
            "!Testimonia adversus Judaeos [Sp.]": ["Volume", "page", "line"],
            "-Adversus Arium et Sabellium de patre et filio": [
                "Volume",
                "page",
                "line",
            ],
            "(Decem syllogismi contra Manichaeos [Sp.]": ["Volume", "page", "line"],
            "%Inventio imaginis in Camulianis [Sp.]": ["Section", "line"],
            "De mortuis non esse dolendum": ["Volume", "page", "line"],
            ")Oratio funebris in Flacillam imperatricem": ["Volume", "page", "line"],
            "Apologia in hexaemeron": ["Page", "line"],
            "bSermo in illud: Hic est filius meus dilectus (ap. Joannem Damascenum, Sacra parallela) (fragmenta)": [
                "Volume",
                "page",
                "line",
            ],
            "Ad Simplicium de fide": ["Volume", "page", "line"],
            "'Adversus Macedonianos de spiritu sancto": ["Volume", "page", "line"],
            "Contra usurarios": ["Volume", "page", "line"],
            "qDe tridui inter mortem et resurrectionem domini nostri Jesu Christi spatio (vulgo In Christi resurrectionem orati": [
                "Volume",
                "page",
                "line",
            ],
            "&De professione Christiana ad Harmonium": ["Volume", "page", "line"],
            "De virginitate": ["Chapter", "section", "line"],
            ".De perfectione Christiana ad Olympium monachum": [
                "Volume",
                "page",
                "line",
            ],
            " De virginitate (recensio altera)": ["Chapter", "section", "line"],
            "3De creatione hominis sermo alter (recensio C) [Sp.]": ["Page", "line"],
            "-Encomium in sanctum Stephanum protomartyrem i": ["Page", "line"],
            "Oratio in diem natalem Christi": ["MPG page", "line"],
            "Contra fornicarios": ["Volume", "page", "line"],
            "hLiber de cognitione dei (%6 $*QEOGNWSI/A&) (fragmenta ap. Euthymium Zigabenum, Panoplia dogmatica) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "De occursu domini [Sp.]": ["Volume", "page", "line"],
            "In illud: Tunc et ipse filius": ["Page", "line"],
        },
    },
    "Joannes VI Cantacuzenus": {
        "tlg_id": "TLG3169",
        "names": {
            "name_authtab": "Joannes VI Cantacuzenus",
            "name_idt": "Joannes VI Cantacuzenus",
        },
        "works": {"Historiae": ["Volume", "page", "line"]},
    },
    "Hippasus Phil.": {
        "tlg_id": "TLG2260",
        "names": {"name_authtab": "Hippasus Phil.", "name_idt": "Hippasus Phil."},
        "works": {"Testimonia": ["Fragment", "line"], "Tituli": ["Page", "line"]},
    },
    "Democritus Phil.": {
        "tlg_id": "TLG1304",
        "names": {"name_authtab": "Democritus Phil.", "name_idt": "Democritus Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line", "´\x8eÂüÞ«\x12´\x14ë\x14\x15¶\x16¶\x16³"],
            "Testimonia": ["Fragment", "line", ""],
        },
    },
    "Chamaeleon Phil.": {
        "tlg_id": "TLG1251",
        "names": {"name_authtab": "Chamaeleon Phil.", "name_idt": "Chamaeleon Phil."},
        "works": {"Fragmenta": ["\x0fWehrli fragment", "line"]},
    },
    "Sophron Mimogr.": {
        "tlg_id": "TLG0524",
        "names": {"name_authtab": "Sophron Mimogr.", "name_idt": "Sophron Mimogr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hicetas Phil.": {
        "tlg_id": "TLG2240",
        "names": {"name_authtab": "Hicetas Phil.", "name_idt": "Hicetas Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Scholia In Aeschylum": {
        "tlg_id": "TLG5010",
        "names": {
            "name_authtab": "Scholia In Aeschylum",
            "name_idt": "Scholia In Aeschylum",
        },
        "works": {
            ".Scholia in Prometheum vinctum (scholia vetera)": [
                " Vita-argumentum-scholion-epigram",
                "verse",
                "line",
            ],
            "VScholia in Persas (scholia vetera et recentiora Thomae Magistri et Demetrii Triclinii)": [
                "\x0eScholion-gloss",
                "\x10hypothesis-verse",
                "line",
            ],
            "qScholia in Prometheum vinctum (scholia recentiora Thomae Magistri et Demetrii Triclinii) (e cod. Neapol. II.F.31)": [
                "\x18Hypothesis-verse of play",
                "line",
            ],
            "qArgumentum in margine et glossae interlineariae ad Persas (glossae recentiores) (e codd. Vindob. 197; Palatino 18": [
                "Scholion",
                "line",
            ],
            "%Scholia in Aeschylum (scholia vetera)": [
                "Play",
                "hypothesis-epigram-scholion",
                "line",
                "",
                "\x92",
                "\x12\x12óíîëÎÎÓà´í³¾ÊÒê´úêê³³ê³³ËëÐÝë÷³\x8e³¿´´Ìíë´³þ´¶ÆÓßû¶¶®¶ê¿´ÉÞ´\x8cî÷¶¶³Ç¶Üêê÷¶´§¶ùÃíùÓ\x10ù\x10\x10",
                "",
                "",
                "\x12\x12óí\x14\x14\x1aÎ\x1bÎ\x1b/³´/³¶0003³³8÷´¶8Bë´¶IIN¶´R®¶RRXÞ³\\^¶_¶ako",
            ],
            "*Catalogus in fabulas (e cod. Mediceo 32.9)": ["line"],
            "<Scholia in Aeschylum (scholia recentiora Demetrii Triclinii)": [
                "Play",
                "\x13hypothesis-scholion",
                "line",
            ],
            ":Scholia prototricliniana in Aeschylum (scholia recentiora)": [
                "Play",
                "scholion",
                "line",
            ],
            "BScholia de metris Aeschyli (scholia recentiora Demetrii Triclinii)": [
                "Play",
                "verse of play",
                "line",
            ],
            "8Scholia in Persas (scholia vetera) (e cod. Mediceo 32.9)": [
                "Scholion",
                "line",
            ],
            "qScholia et glossae in Persas (scholia vetera et recentiora Thomae Magistri et Demetrii Triclinii) (e cod. Laur. 3": [
                "Verse of play",
                "line",
            ],
            "_Scholia in Eumenides (scholia vetera et recentiora Demetrii Triclinii) (e cod. Neapol. II.F.31)": [
                "Argumentum-scholion",
                "line",
            ],
            "&Scholia in Persas (scholia recentiora)": ["Hypothesis-scholion", "line"],
            ")Scholia in Aeschylum (scholia recentiora)": [
                "Play",
                "hypothesis-verse of play",
                "line",
            ],
            '"Scholia in Persas (scholia vetera)': [
                "\x18Hypothesis-verse of play",
                "line",
            ],
        },
    },
    "Bato Hist., Rhet.": {
        "tlg_id": "TLG1219",
        "names": {
            "name_authtab": "Bato Hist. et Rhet.",
            "name_idt": "Bato Hist., Rhet.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pittaci Epistula": {
        "tlg_id": "TLG1613",
        "names": {"name_authtab": "Pittaci Epistula", "name_idt": "Pittaci Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Staphylus Hist.": {
        "tlg_id": "TLG2182",
        "names": {"name_authtab": "Staphylus Hist.", "name_idt": "Staphylus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymus De Plantis Aegyptiis": {
        "tlg_id": "TLG1813",
        "names": {
            "name_authtab": "Anonymus De Plantis Aegyptiis",
            "name_idt": "Anonymus De Plantis Aegyptiis",
        },
        "works": {"Fragmentum (P. Oxy. 15.1796)": ["Column", "line"]},
    },
    "Timagenes Hist.": {
        "tlg_id": "TLG1918",
        "names": {"name_authtab": "Timagenes Hist.", "name_idt": "Timagenes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Julius Epic.": {
        "tlg_id": "TLG1757",
        "names": {"name_authtab": "Julius Epic.", "name_idt": "Julius Epic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Procopius Rhet., Scr. Eccl.": {
        "tlg_id": "TLG2598",
        "names": {
            "name_authtab": "Procopius Rhet. et Scr. Eccl.",
            "name_idt": "Procopius Rhet., Scr. Eccl.",
        },
        "works": {
            "!Epistula (e cod. Barocc. gr. 131)": ["line"],
            "Commentarii in Isaiam": ["Page", "line"],
            "Horologium": ["line"],
            "Declamationes": ["Declamation", "line"],
            "2Refutatio Procli (fragmentum e cod. Vat. gr. 1096)": ["Page", "line"],
            "Epistula (e cod. Esc. gr. 234)": ["line"],
            "Descriptio imaginis": ["Section", "line"],
            "Epistulae 1-166": ["Epistle", "line"],
            ",Catena in Ecclesiasten (e cod. Marc. gr. 22)": [
                "Chapter",
                "section",
                "line",
            ],
            "Catena in Canticum canticorum": ["Page", "line"],
        },
    },
    "Androtion Hist.": {
        "tlg_id": "TLG1125",
        "names": {"name_authtab": "Androtion Hist.", "name_idt": "Androtion Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Timaeus Sophista Gramm.": {
        "tlg_id": "TLG2602",
        "names": {
            "name_authtab": "Timaeus Sophista Gramm.",
            "name_idt": "Timaeus Sophista Gramm.",
        },
        "works": {
            "(Lexicon Platonicum (e cod. Coislin. 345)": [
                "\x19Epistle-alphabetic letter",
                "page",
                "line",
            ]
        },
    },
    "Eccelus Phil.": {
        "tlg_id": "TLG1340",
        "names": {"name_authtab": "Eccelus Phil.", "name_idt": "Eccelus Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Thearidas Phil.": {
        "tlg_id": "TLG1711",
        "names": {"name_authtab": "Thearidas Phil.", "name_idt": "Thearidas Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Symeon Metaphrastes Biogr., Hist.": {
        "tlg_id": "TLG3115",
        "names": {
            "name_authtab": "Symeon Metaphrastes Biogr. et Hist.",
            "name_idt": "Symeon Metaphrastes Biogr., Hist.",
        },
        "works": {"/Chronicon breve (lib. 7-8) (redactio recentior)": ["Page", "line"]},
    },
    "Menecles Hist.": {
        "tlg_id": "TLG1499",
        "names": {"name_authtab": "Menecles Hist.", "name_idt": "Menecles Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Polybius Hist.": {
        "tlg_id": "TLG0543",
        "names": {"name_authtab": "Polybius Hist.", "name_idt": "Polybius Hist."},
        "works": {
            "Fragmenta ex incertis libris": ["Fragment", "line"],
            "Testimonium": ["line", "fragment", "line"],
            "Historiae": ["Book", "chapter", "section", "line"],
        },
    },
    "Scholia In Euclidem": {
        "tlg_id": "TLG5022",
        "names": {
            "name_authtab": "Scholia In Euclidem",
            "name_idt": "Scholia In Euclidem",
        },
        "works": {
            "9Scholia in opticorum recensionem Theonis (scholia vetera)": [
                "Scholion",
                "line",
            ],
            ";Scholia in Euclidis elementa (scholia vetera et recentiora)": [
                "Book",
                "scholion",
                "line",
                "\x15î\x16ó\x17ù³\x1b¶\x1eÂ¶$$%&¤&''*³+½¶.14½¶599;;<==«´>A´EÑ³K¶¶LS³¶Vë³¶\\^´_``afjî´lmîoÀr",
            ],
            ")Scholia in Euclidis data (scholia vetera)": [
                "Section",
                "scholion",
                "line",
            ],
            "/Scholia in Euclidis catoptrica (scholia vetera)": ["Scholion", "line"],
            "/Scholia in Euclidis phaenomena (scholia vetera)": ["Scholion", "line"],
            "+Scholia in Euclidis optica (scholia vetera)": ["Scholion", "line"],
            "7Scholia in Euclidis data et catoptrica (scholia vetera)": [
                "Page",
                "line",
            ],
        },
    },
    "Epicrates Comic.": {
        "tlg_id": "TLG0451",
        "names": {"name_authtab": "Epicrates Comic.", "name_idt": "Epicrates Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Lycurgus Orat.": {
        "tlg_id": "TLG0034",
        "names": {"name_authtab": "Lycurgus Orat.", "name_idt": "Lycurgus Orat."},
        "works": {
            "Fragmenta": ["Oration", "fragment", "line"],
            "Oratio in Leocratem": ["Section", "line"],
        },
    },
    "Anonymi Historici (FGrH)": {
        "tlg_id": "TLG1139",
        "names": {
            "name_authtab": "Anonymi Historici (FGrH)",
            "name_idt": "Anonymi Historici (FGrH)",
        },
        "works": {
            ")Alexandri historia (e cod. Sabbaitico 29)": ["line", "fragment", "line"],
            "": ["Anonymus Milesius", "line", "fragment", "line"],
            "De finibus urbis": ["line", "fragment", "line"],
            "Chronicon Romanum (IG 14.1297)": ["line", "fragment", "line"],
            "Apophthegmata Romana": ["line", "fragment", "line"],
            "Anonymus exegeta": ["line", "fragment", "line"],
            "Chronicon Pergamenum": ["line", "fragment", "line"],
            "1De historia diadochorum (epitome Heidelbergensis)": [
                "line",
                "fragment",
                "line",
            ],
            ".Heraclis historia (Tabula Albana) (IG 14.1293)": [
                "line",
                "fragment",
                "line",
            ],
            "De Theramene (P. Mich. 5982)": ["line", ":", "³"],
            "Enchiridion (P. Ryl. 22)": ["line", "fragment", "line"],
            "Anonymus philosophus": ["line", "fragment", "line"],
            "De Lesbo": ["line", "fragment", "line"],
            "Anonymi ex historiis Polybii": ["line", "fragment", "line"],
            "%$*EU)MOLPIDW=N PA/TRIA& (testimonium)": ["line", "fragment", "line"],
            "#Victores olympici (P. Oxy. 23.2381)": ["FGrH fragment", "line", ""],
            "KVictores Olympici (fort. auctore Phlegonte vel Eratosthene) (P. Oxy. 2.222)": [
                "line",
                "fragment",
                "line",
            ],
            "%Chronicon Archontum (P. Oxy. 13.1613)": ["line", "fragment", "line"],
            "#Chronicon Oxyrhynchi (P. Oxy. 1.12)": ["line", "fragment", "line"],
            "$$*EU)PATRIDW=N PA/TRIA& (fragmentum)": ["line", "fragment", "line"],
            "Anonymus de conditu Hermopolis": ["line", "fragment", "line"],
            "!Alexandri historia (P. Hamb. 652)": ["line", "Q", "´"],
            "Philippica (P. Ryl. 3.490)": ["line", "U", "³"],
            "Scriptores de Athenis": ["line", "fragment", "line", "³"],
            "7De agrimensore Syriae (fort. auctore Xenophonte quodam)": [
                "line",
                "fragment",
                "line",
            ],
            "Fragmenta historica": ["line", "fragment", "line"],
            "-Chronicon Olympicum (fort. auctore Phlegonte)": [
                "line",
                "fragment",
                "line",
            ],
            "De sacris Atheniensibus": ["line", "fragment", "line"],
            "2Belli Syrii tertii annales (P. Petrie 2.45; 3.144)": [
                "line",
                "fragment",
                "line",
            ],
            "De historia Alexandri": ["line", "fragment", "line"],
            "De Pyrrho (testimonium)": ["line", "fragment", "line"],
            "&Anonymus periegeta (P. Hawara 80%3`81)": ["line", "fragment", "line"],
            "Anagraphe Sicyonia": ["line", "fragment", "line"],
            "De Nilo": ["line", "fragment", "line"],
            "$Alexandri historia (P. Oxy. 17.2081)": [
                "FGrH fragment",
                "line",
                "A",
                "´",
            ],
            "'De Marco Aurelio Antonino (testimonium)": ["line", "fragment", "line"],
            "Anonymus Corinthius": ["line", "fragment", "line"],
            "$Alexandri historia (P. Oxy. 15.1798)": ["line", "fragment", "line"],
            "De Hannibale": ["line", "fragment", "line"],
        },
    },
    "Aristonicus Hist.": {
        "tlg_id": "TLG1899",
        "names": {"name_authtab": "Aristonicus Hist.", "name_idt": "Aristonicus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cantharus Comic.": {
        "tlg_id": "TLG0428",
        "names": {"name_authtab": "Cantharus Comic.", "name_idt": "Cantharus Comic."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Scholia In Dionysium Byzantium": {
        "tlg_id": "TLG5018",
        "names": {
            "name_authtab": "Scholia In Dionysium Byzantium",
            "name_idt": "Scholia In Dionysium Byzantium",
        },
        "works": {
            "KScholia in Dionysii Byzantii per Bosporum navigationem (scholia recentiora)": [
                "Scholion",
                "line",
            ]
        },
    },
    "Aristocles Phil.": {
        "tlg_id": "TLG1188",
        "names": {"name_authtab": "Aristocles Phil.", "name_idt": "Aristocles Phil."},
        "works": {"Fragmenta": ["\x15Fragment or vestigium", "line"]},
    },
    "Aristides Quintilianus Mus.": {
        "tlg_id": "TLG2054",
        "names": {
            "name_authtab": "Aristides Quintilianus Mus.",
            "name_idt": "Aristides Quintilianus Mus.",
        },
        "works": {"De musica": ["Book", "section", "line"]},
    },
    "Anonymus Seguerianus Rhet.": {
        "tlg_id": "TLG2002",
        "names": {
            "name_authtab": "Anonymus Seguerianus Rhet.",
            "name_idt": "Anonymus Seguerianus Rhet.",
        },
        "works": {"'Ars rhetorica (olim sub nomine Cornuti)": ["Section", "line"]},
    },
    "Philolaus Phil.": {
        "tlg_id": "TLG1596",
        "names": {"name_authtab": "Philolaus Phil.", "name_idt": "Philolaus Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta [Sp.]": ["Page", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Lynceus Comic.": {
        "tlg_id": "TLG0471",
        "names": {"name_authtab": "Lynceus Comic.", "name_idt": "Lynceus Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Nausicrates Comic.": {
        "tlg_id": "TLG0478",
        "names": {
            "name_authtab": "Nausicrates Comic.",
            "name_idt": "Nausicrates Comic.",
        },
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Artemidorus Eleg.": {
        "tlg_id": "TLG2651",
        "names": {"name_authtab": "Artemidorus Eleg.", "name_idt": "Artemidorus Eleg."},
        "works": {"Tituli": ["Fragment", "line"]},
    },
    "Demonicus Comic.": {
        "tlg_id": "TLG0441",
        "names": {"name_authtab": "Demonicus Comic.", "name_idt": "Demonicus Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Hermippus Comic.": {
        "tlg_id": "TLG0252",
        "names": {"name_authtab": "Hermippus Comic.", "name_idt": "Hermippus Comic."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmentum (P. Oxy. 13.1611)": ["Fragment", "line"],
        },
    },
    "Herodianus Hist.": {
        "tlg_id": "TLG0015",
        "names": {"name_authtab": "Herodianus Hist.", "name_idt": "Herodianus Hist."},
        "works": {"Ab excessu divi Marci": ["Book", "chapter", "section", "line"]},
    },
    "Hegesippus Hist.": {
        "tlg_id": "TLG1397",
        "names": {"name_authtab": "Hegesippus Hist.", "name_idt": "Hegesippus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Antigenes Hist.": {
        "tlg_id": "TLG1945",
        "names": {"name_authtab": "Antigenes Hist.", "name_idt": "Antigenes Hist."},
        "works": {"Fragmentum": ["FGrH fragment", "line"]},
    },
    "Themistius Phil., Rhet.": {
        "tlg_id": "TLG2001",
        "names": {
            "name_authtab": "Themistius Phil. et Rhet.",
            "name_idt": "Themistius Phil., Rhet.",
        },
        "works": {
            "": [
                "$*$*PENTAETHRIKO/S& !!! TRANSLITERATE",
                "Harduin page",
                "section",
                "line",
            ],
            "&$*FILA/DELFOI H)\\ PERI\\ FILANQRWPI/AS&": [
                "Harduin page",
                "section",
                "line",
            ],
            "!$*(H E)PI\\ TW=| LO/GW| DIA/LECIS&": ["Harduin page", "section", "line"],
            "b$*EI)S *KWNSTA/NTION TO\\N AU)TOKRA/TORA, O(/TI MA/LISTA FILO/SOFOS O( BASILEU/S, H)\\ XARISTH/RIOS&": [
                "Harduin page",
                "section",
                "line",
            ],
            "-$*PERI\\ TW=N H)TUXHKO/TWN E)PI\\ *OU)A/LENTOS&": [
                "Harduin page",
                "section",
                "line",
            ],
            "/$*PRESBEUTIKO\\S EI)S *QEODO/SION AU)TOKRA/TORA&": [
                "Harduin page",
                "section",
                "line",
            ],
            "+(Sophoniae) in parva naturalia commentarium": ["Volume", "page", "line"],
            "j$*XARISTH/RIOS TW=| AU)TOKRA/TORI U(PE\\R TH=S EI)RH/NHS KAI\\ TH=S U(PATEI/AS TOU= STRATHGOU= *SATORNI/NOU&": [
                "Harduin page",
                "section",
                "line",
            ],
            "0$*PROTREPTIKO\\S *NIKOMHDEU=SIN EI)S FILOSOFI/AN&": [
                "Harduin page",
                "section",
                "line",
            ],
            "B$*PRESBEUTIKO\\S U(PE\\R *KWNSTANTINOUPO/LEWS R(HQEI\\S E)N *(RW/MH|&": [
                "Harduin page",
                "section",
                "line",
            ],
            "#$*)EPI\\ TH=S EI)RH/NHS *OU)A/LENTI&": [
                "Harduin page",
                "section",
                "line",
            ],
            "+$*)ERWTIKO\\S H)\\ PERI\\ KA/LLOUS BASILIKOU=&": [
                "Harduin page",
                "section",
                "line",
            ],
            "+$*)EPI\\ TH=| XEIROTONI/A| TH=S POLIARXI/AS&": [
                "Harduin page",
                "section",
                "line",
            ],
            "[2$*F&]2$ILO/POLIS&": ["line"],
            "($*PERI\\ PROEDRI/AS EI)S TH\\N SU/GKLHTON&": [
                "Harduin page",
                "section",
                "line",
            ],
            "$*QE/SIS EI) GEWRGHTE/ON&": ["Harduin page", "section", "line"],
            "DQuae fertur in Aristotelis analyticorum priorum librum i paraphrasis": [
                "Volume",
                "page",
                "line",
            ],
            " $*PERI\\ FRONH/SEWS &(fragmentum)": ["Dindorf page", "section", "line"],
            "9$*PRO\\S TOU\\S OU)K O)RQW=S E)CHGOUME/NOUS TO\\N SOFISTH/N&": [
                "Harduin page",
                "section",
                "line",
            ],
            "$*PERI\\ FILI/AS&": ["Harduin page", "section", "line"],
            "*In Aristotelis libros de anima paraphrasis": ["Volume", "page", "line"],
            "<[2$*(UPE\\R TOU= LE/GEIN H)\\ PW=S TW=| FILOSO/FW| LEKTE/ON&]2": [
                "Harduin page",
                "section",
                "line",
            ],
            "$Analyticorum posteriorum paraphrasis": ["Volume", "page", "line"],
            "G$*PERI\\ TOU= MH\\ DEI=N TOI=S TO/POIS A)LLA\\ TOI=S A)NDRA/SI PROSE/XEIN&": [
                "Harduin page",
                "section",
                "line",
            ],
            "($*PROTREPTIKO\\S *OU)ALENTINIANW=| NE/W|&": [
                "Harduin page",
                "section",
                "line",
            ],
            "$*SOFISTH/S&": ["Harduin page", "section", "line"],
            ">$*DEKETHRIKO\\S H)\\ PERI\\ TW=N PREPO/NTWN LO/GWN TW=| BASILEI=&": [
                "Harduin page",
                "section",
                "line",
            ],
            '"In Aristotelis physica paraphrasis': ["Volume", "page", "line"],
            "9$*EI)S *QEODO/SION: TI/S H( BASILIKWTA/TH TW=N A)RETW=N &": [
                "Harduin page",
                "section",
                "line",
            ],
            "$*METRIOPAQH\\S H)\\ FILO/TEKNOS&": ["Harduin page", "section", "line"],
            "@$*PRO\\S TOU\\S AI)TIASAME/NOUS E)PI\\ TW=| DE/CASQAI TH\\N A)RXH/N&": [
                "Section",
                "line",
            ],
            ";$*)EPI\\ TH=| FILANQRWPI/A| TOU= AU)TOKRA/TOROS *QEODOSI/OU&": [
                "Harduin page",
                "section",
                "line",
            ],
            "$*PERI\\ YUXH=S &(fragmenta)": ["Fragment", "line"],
            ">[2$*PERI\\ TW=N O)NOMA/TWN TOU= BASILE/WS KAI\\ TOU= U(PA/TOU&]2": [
                "Harduin page",
                "section",
                "line",
            ],
            "5$*PRO\\S TO\\N A)CIW/SANTA LE/GEIN E)K TOU= PARAXRH=MA&": [
                "Harduin page",
                "section",
                "line",
            ],
            "1$*(UPATIKO\\S EI)S TO\\N AU)TOKRA/TORA *)IOBIANO/N&": [
                "Harduin page",
                "section",
                "line",
            ],
            "($*PERI\\ TH=S TOU= BASILE/WS FILHKOI/+AS&": [
                "Harduin page",
                "section",
                "line",
            ],
            ")$*EI)S TO\\N AU)TOKRA/TORA *KWNSTA/NTION &": [
                "Harduin page",
                "section",
                "line",
            ],
            "($*PERI\\ FILANQRWPI/AS H)\\ *KWNSTA/NTIOS&": [
                "Harduin page",
                "section",
                "line",
            ],
            " $*)EPITA/FIOS E)PI\\ TW=| PATRI/&": ["Harduin page", "section", "line"],
            "$*BASANISTH\\S H)\\ FILO/SOFOS&": ["Harduin page", "section", "line"],
        },
    },
    "Harpocration Gramm.": {
        "tlg_id": "TLG1389",
        "names": {
            "name_authtab": "Harpocration Gramm.",
            "name_idt": "Harpocration Gramm.",
        },
        "works": {"!Lexicon in decem oratores Atticos": ["Page", "line"]},
    },
    "Xenocrates Phil.": {
        "tlg_id": "TLG0634",
        "names": {"name_authtab": "Xenocrates Phil.", "name_idt": "Xenocrates Phil."},
        "works": {"!Testimonia, doctrina et fragmenta": ["Fragment", "line"]},
    },
    "Anonymi In Aristotelis Librum De Interpretatione Phil.": {
        "tlg_id": "TLG4165",
        "names": {
            "name_authtab": "Anonymi In Aristotelis Librum De Interpretatione Phil.",
            "name_idt": "Anonymi In Aristotelis Librum De Interpretatione Phil.",
        },
        "works": {
            "qCommentarium in librum de interpretatione (e cod. Paris. gr. 2064) (fort. auctore quodam Alexandrino vel Constant": [
                "Page",
                "line",
            ]
        },
    },
    "Butherus Phil.": {
        "tlg_id": "TLG1232",
        "names": {"name_authtab": "Butherus Phil.", "name_idt": "Butherus Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Oeniades Lyr.": {
        "tlg_id": "TLG0971",
        "names": {"name_authtab": "Oeniades Lyr.", "name_idt": "Oeniades Lyr."},
        "works": {"Titulus": ["line"]},
    },
    "Theon Gramm.": {
        "tlg_id": "TLG1838",
        "names": {"name_authtab": "Theon Gramm.", "name_idt": "Theon Gramm."},
        "works": {
            "Fragmenta": ["Page", "line"],
            "5Commentarium de Pythiis xii Pindari (P. Oxy. 31.2536)": [
                "Column",
                "line",
            ],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Joannes Chrysostomus Scr. Eccl.": {
        "tlg_id": "TLG2062",
        "names": {
            "name_authtab": "Joannes Chrysostomus Scr. Eccl., John Chrysostom",
            "name_idt": "Joannes Chrysostomus Scr. Eccl.",
        },
        "works": {
            "": ["In infirmos [Sp.]", "Pg", "ln\x0eÃÆ\x0eÃK\x0e´"],
            "1Adversus oppugnatores vitae monasticae (lib. 1-3)": [
                "Vol",
                "pg",
                "ln\x10¿ÂÇÉË\x15\x15Ë\x92ÍÏ¶Ò\x8cÖ¤ÛÝß¼\x92ê«´ó«÷úüþ\x10¿\x15Ë\x8c.´",
            ],
            "De futurae vitae deliciis": ["Vol", "pg", "ln³Û\x8eÞ®à¼³Û\x8cp©"],
            ")Ad Stagirium a daemone vexatum (lib. 1-3)": [
                "Vol",
                "pg",
                "ln;§©«¤´´¶»½¿E©F¿®ÂÆÉËÍÏ«Ñ»Ö®ÀÝß§ê³î;§F¿«Z",
            ],
            "In filium viduae [Sp.]": ["Vol", "pg", "ln½É½Èd³"],
            "#De sancta pentecoste (homiliae 1-2)": ["Vol", "pg", "lnÓÇÉ´ÌÎÐ¤Ò\x8cÓb³"],
            ",De jejunio, dominica quinta jejuniorum [Sp.]": [
                "Vol",
                "pg",
                "ln»¾Û»¾ÛZ¼³",
            ],
            "DIn illud: Propter fornicationes autem unusquisque suam uxorem habeat": [
                "Vol",
                "pg",
                "lnj³ÏÒ³×j³Ï\x92ao",
            ],
            "Expositiones in Psalmos": [
                "Vol",
                "pg",
                "ln§©«´»¾ÀÂÇÉË§ÎÐÒ§×ÛÞàêó³öú´¶§º§º³´¶\x8eº½¿Â\x8cÆÈ¶ËÍÏÒÖÛÝßëí¶\x8c÷ù\x8eû§\x92«¤©«®´¤¶»¾\x8eÀÃÇÊÌÏÑÓÖ«Ýß§¼©ëí¤öû®®\x92®¤§©«®³º¼«¿\x8cÃÆ\x8cÈÊÍÏÑÖÛÝßº®\x8cî§Ï´´",
            ],
            "+In epistulam i ad Timotheum (homiliae 1-18)": [
                "Vol",
                "pg",
                "ln¾û§«³§©«\x8c©¼§©\x19\x19©«¿\x1b\x1b³¤»»\x8e½¿´»Ã%%Ã½ÆÈ(´)ÉÌºÏÑ\x8eÓ§«¾i/¶",
            ],
            "Contra Anomoeos (homilia 11)": ["Vol", "pg", "lnº§º\x8c½"],
            "In sanctam Pelagiam [Sp.]": ["line"],
            "&Ad Stelechium de compunctione (lib. 2)": ["Vol", "pg", "ln6«»6=;¶"],
            "!In Juventinum et Maximum martyres": ["Vol", "pg", "lnà»½§¿Âà»m´³"],
            "*De prophetiarum obscuritate (homiliae 1-2)": [
                "Vol",
                "pg",
                "ln¾§©«º®«´¼»½À¾\x92}Ë",
            ],
            ".Quod grave sit dei clementiam contemnere [Sp.]": [
                "Vol",
                "pg",
                "ln\x0e}À´\x0e}À©`\x0e}³¶",
            ],
            "De Joseph et de castitate [Sp.]": ["Vol", "pg", "lníËÍ®íËT"],
            "De circo [Sp.]": ["Vol", "pg", "ln\x15»®«Ë\x15»\x16³"],
            '"Sermo catecheticus in pascha [Sp.]': ["Vol", "pg", "ln:»Ñ:»Ñq:¶"],
            "6In illud: Diligentibus deum omnia cooperantur in bonum": [
                "Vol",
                "pg",
                "lnY³\x8c´©Y³\\¶",
            ],
            ".Epistula ad episcopos, presbyteros et diaconos": [
                "Vol",
                "pg",
                "ln\x1b´\x1b´w\x1b",
            ],
            "(In illud: Pater meus usque modo operatur": ["Vol", "pg", "lnß¿§ß¿i"],
            "In Psalmum 100 [Sp.]": ["Vol", "pg", "lno÷»ù¤ûoÊs¶"],
            "De precatione [Sp.]": ["Vol", "pg", "ln\x0eÀÍÑ©\x0eÀÍ\\\x0e³¶¶"],
            "Precatio [Sp.]": ["Vol", "pg", "ln\x0eÀ\x0eÀ\x0e³³"],
            "GIn sanctum pascha (sermo 2) [Sp.] (fort. auctore Apollinare Laodicense)": [
                "Sect",
                "ln<m>¶",
            ],
            "(In epistulam ad Hebraeos (homiliae 1-34)": [
                "Vol",
                "pg",
                "lnc¿d\x8ee\x92jj\x8c½¤§©«rs§´¶»»½¿§Ã||ÃÆÈÊÍÏÑÖÛÝ§ßß®ëí§÷ùûû\x8c®«®¿º½\x8e®\x8c³¤©§©«º\x8c\x8c³»¶º¼¶¿Ã³ÆÈÊÍÏ\x92Ñ©ÓºÖ©ÛÝ§ß³¤³ê½c¿mÆ¶",
            ],
            "'In sanctum Paulum apostolum (excerptum)": ["Pg", "ln\x0f«®\x0f«\x0f´¶"],
            "%De confessione pretiosae crucis [Sp.]": ["Vol", "pg", "ln^´É«Ì^´ÉQ`"],
            "Oratio de epiphania [Sp.]": ["Sect", "ln\x0f\x0f>\x0f´¶³"],
            "Oratio ante lectionem [Sp.]": ["Vol", "pg", "ln\x0er¿\x0er¿V\x0er³´¶"],
            "De pseudoprophetis [Sp.]": ["Vol", "pg", "ln»©«¿«Â¤»©L\x15³"],
            " Quod frequenter conveniendum sit": ["Vol", "pg", "lnË¿ÍÏÑ¤¤Ë¿ÍiÎ"],
            "De Melchisedech [Sp.]": ["Vol", "pg", "ln³®³q"],
            "De sancto hieromartyre Phoca": ["Vol", "pg", "ln\x0e»½¿Â\x0e»]", ""],
            "In catechumenos [Sp.]": ["Vol", "pg", "lnu¼¶u¼`v"],
            "De cruce et latrone (homilia 1)": ["Vol", "pg", "ln½»¾½\x8eyÀ³³"],
            "/De cognitione dei et in sancta theophania [Sp.]": [
                "Vol",
                "pg",
                "ln\x0eÀ«®\x8c\x0eÀ«|\x0e³¶",
            ],
            "De regressu": ["Sect", "ln\x0e§\x0e§\x0e³¶"],
            "$In epistulam ad Titum (homiliae 1-6)": [
                "Vol",
                "pg",
                "lnK¾¤N´N¶¼\x92©S©S©³º³ºº¼»K¾\\¶",
            ],
            "In assumptionem domini [Sp.]": ["line"],
            "!In sanctum pascha (sermo 6) [Sp.]": ["Chapter", "section", "line"],
            "In Isaiam": ["Chapter", "section", "line"],
            "!In sanctum Eustathium Antiochenum": ["Vol", "pg", "ln©Ü¶Þ§h´¶"],
            "!Fragmenta in epistulas catholicas": ["Vol", "pg", "lnPÀ¤\x92PÀPWT¶"],
            "8Ad illuminandos catecheses 1-2 (series prima et secunda)": [
                "Vol",
                "pg",
                "lnvß¤y\x8cy\x92¼îvßy\x8eÛ¶",
            ],
            "&De turture seu de ecclesia sermo [Sp.]": ["Vol", "pg", "lni×i×Zk³"],
            "%In illud: Utinam sustineretis modicum": ["Vol", "pg", "ln³³f"],
            " Adversus Judaeos (orationes 1-8)": [
                "Vol",
                "pg",
                "lnËÎÀÑÓ×ÛÝÉÉÝ©à\x92ë¼î\x8c÷ù¶üþ¤\x92¤®«ËÉÝ\x8e\\í",
            ],
            "In Genesim (sermones 1-9)": [
                "Vol",
                "pg",
                "lnm¶îÉ\x8cËÍÐÒÖ\x92ÛÝ´à\x8e\x8cëî«³öm¶À´",
            ],
            "In Joannem theologum [Sp.]": ["Vol", "pg", "ln%»\x92¤%»e'´"],
            "De Lazaro et divite [Sp.]": ["Vol", "pg", "ln»Ï¾ÑÓ»Ï½d#´"],
            "In ramos palmarum [Sp.]": ["Pg", "ln\x0eû\x92\x0eûN\x0eü´³¶"],
            "In praecursorem domini [Sp.]": ["Vol", "pg", "lnó»§¶ó»]¶"],
            "!In venerabilem crucem sermo [Sp.]": ["Vol", "pg", "ln×³×¶l´"],
            "$De decem millium talentorum debitore": [
                "Vol",
                "pg",
                "ln\x1f³\x92«©\x1f³v%¶",
            ],
            "De perfecta caritate [Sp.]": ["Vol", "pg", "ln\x8c©Mº"],
            "2In epistulam ii ad Thessalonicenses (homiliae 1-5)": [
                "Vol",
                "pg",
                "ln¾Ó×®ÜÞà»§ëí¿®¾Ó§ü¶´",
            ],
            "$De adoratione pretiosae crucis [Sp.]": ["Vol", "pg", "ln[´ÃÆÈÍ[´Ãi^"],
            "!In poenitentiam Ninivitarum [Sp.]": ["Vol", "pg", "lnÀ©À\x8cùî´"],
            "De sanctis Bernice et Prosdoce": ["Vol", "pg", "lnó÷ù§û¶þÀó\x8cU´"],
            "In illud: Vidua eligatur": ["Vol", "pg", "ln³ÆÉËÍ§ÏÒ³\x8ce"],
            "In Lazarum (homilia 2) [Sp.]": ["Vol", "pg", "lnÖ¾©Ö¾X×³³¶"],
            "In illud: In faciem ei restiti": ["Vol", "pg", "ln³ó´úü§þ³\x8e³ó"],
            "De sancta Thecla martyre [Sp.]": ["Vol", "pg", "lnÂ\x92ÂÃ³"],
            "!In sanctum pascha (sermo 4) [Sp.]": ["Vol", "pg", "ln?»ÛÀ?»Ûe@¶´"],
            "&De fato et providentia (orationes 1-6)": [
                "Vol",
                "pg",
                "ln\x14í®÷ùû¤\x1b\x1b³«\x14í\x1b{\x1f¶",
            ],
            "In sanctum Julianum martyrem": ["Vol", "pg", "ln½¤¤c´"],
            "&In sanctum Stephanum (homilia 3) [Sp.]": [
                "Vol",
                "pg",
                "ln\x0ew¿\x92\x0ew¿{\x0ex³",
            ],
            "Peccata fratrum non evulganda": ["Vol", "pg", "ln©³³ë¤´©³c³"],
            "9In illud: Simile est regnum caelorum patri familias [Sp.]": [
                "Vol",
                "pg",
                "ln\x1a»³ÇÉ¤\x1a»\x1e´",
            ],
            "De pharisaeo [Sp.]": ["Vol", "pg", "ln »ÍÏº »Í´\\´´"],
            "'In illud: Homo quidam descendebat [Sp.]": ["Vol", "pg", "ln©½óÊö©½óo³"],
            "3In laudem sancti Joannis theologi (homilia 1) [Sp.]": [
                "Vol",
                "pg",
                "ln½Ï«½Ïm",
            ],
            "&In sanctum Stephanum (homilia 1) [Sp.]": [
                "Vol",
                "pg",
                "ln\x0ev¿Ê¤³\x0ev¿É`\x0ew³´",
            ],
            "&Catechesis de juramento (series prima)": ["Pg", "ln\x0eÀ\x0eÀr\x0eÃ³"],
            ".De iis qui in jejunio continenter vivunt [Sp.]": [
                "Vol",
                "pg",
                "ln\x0e|ÀÀÉ\x0e|À]\x0e}³´",
            ],
            "In sanctum Lucianum martyrem": ["Vol", "pg", "lnÜ\x8cº\x8eÜcÞ´"],
            "Epistula ad abbatem [Sp.]": ["line"],
            "De Eleazaro et septem pueris": ["Vol", "pg", "ln¿\x8e¿h"],
            "!In illud: Exiit qui seminat [Sp.]": ["Vol", "pg", "ln½¿º½¾{´³"],
            "De non judicando proximo [Sp.]": ["Vol", "pg", "ln¼û«þ¼ûR"],
            "(In sanctum Stephanum protomartyrem [Sp.]": ["Vol", "pg", "ln»úü»xü³"],
            "In Heliam et viduam": ["Vol", "pg", "ln³Ñ¤×\x92Ü³Ñf"],
            "De spe [Sp.]": ["Vol", "pg", "ln¼¼O"],
            ".Encomium in sanctum Joannem evangelistam [Sp.]": [
                "Pg",
                "ln\x0eþ×\x8e\x0eþC\x0f´³",
            ],
            "In ascensionem (sermo 1) [Sp.]": ["Vol", "pg", "lnN´¤N´kN"],
            "De sanctis martyribus": ["Vol", "pg", "ln", "©®Ç", "§K\x13"],
            "0De angusta porta et in orationem dominicam [Sp.]": [
                "Vol",
                "pg",
                "lnÛ³©®Û³©Þ´",
            ],
            "De profectu evangelii": ["Vol", "pg", "ln³º¼¿¿³\x8e}"],
            '"In operarios undecimae horae [Sp.]': ["line"],
            "Ad Eudoxiam (epist. 1-7) [Sp.]": ["Pg", "ln\x0e§û[\x0e³¶"],
            "De paenitentia (sermo 3) [Sp.]": ["Vol", "pg", "lna¼a¼Wc"],
            "In magnam feriam v [Sp.]": ["Pg", "ln\x0eÒI\x0e´"],
            "Ad viduam juniorem": ["line"],
            "$In principium Actorum (homiliae 1-4)": [
                "Vol",
                "pg",
                "ln/³¶®ÈÊ\x92ÌÏÑÓºÝß<=Àê½/³¶=C¶",
            ],
            "In transfigurationem [Sp.]": ["Vol", "pg", "ln½Ñ½ÑO³"],
            "+In epistulam ad Colossenses (homiliae 1-12)": [
                "Vol",
                "pg",
                "ln«¾«´¶»½¿¾ÆÈÊÍÏÑ»¼ÑÓºÖÝ\x8cßß\x8c\x8e³ë\x8cí\x8cÇ\x8cÈíºöû¼\x92«¾«qÓ¶",
            ],
            "In diem natalem": ["Vol", "pg", "ln©ß³ê©ßc®"],
            "De nativitate [Sp.]": ["line"],
            "8In lacum Genesareth et in sanctum Petrum apostolum [Sp.]": [
                "Vol",
                "pg",
                "ln\x0eÀÉ´\x0eÀ]\x0e³¶³",
            ],
            "+In illud: Pater, si possibile est, transeat": [
                "Vol",
                "pg",
                "ln%³\x92´§\x92«%³y)¶³",
            ],
            "In principium indictionis [Sp.]": ["Vol", "pg", "ln.»\x8c¶.»Z/"],
            "'In ingressum sanctorum jejuniorum [Sp.]": ["Vol", "pg", "ln»¾×¿»¾×e»³"],
            "4De patientia et de consummatione huius saeculi [Sp.]": [
                "Vol",
                "pg",
                "ln\x0ex¿©®\x0ex¿©½À\x0ez³",
            ],
            "De sancta Droside martyre": ["Vol", "pg", "ln«®³¾¶\x8e«W¶"],
            "In Christi ascensionem [Sp.]": ["line"],
            "In sanctum Romanum (homilia 1)": ["Vol", "pg", "lnÝà§Ýpî´"],
            "Adversus eos qui non adfuerant": ["Vol", "pg", "lnÎ¿Ýß§Î¿Ý\\Ñ³"],
            "De Maccabeis (homiliae 1-3)": ["Vol", "pg", "lnîî\x8eî\x92wó´"],
            "In parabolam Samaritani [Sp.]": ["Vol", "pg", "lnÊ¾ó\x8eÊ¾óNË³"],
            "3Quod regulares feminae viris cohabitare non debeant": [
                "Sect",
                "lncÓÛcËk",
            ],
            ".De occursu domini, de deipara et Symeone [Sp.]": [
                "Vol",
                "pg",
                "lnÓ§©«Ó§j³",
            ],
            "In Rachelem et infantes [Sp.]": ["Vol", "pg", "ln\x8e½Ë¼\x8e½Z"],
            "De libello repudii": ["Vol", "pg", "lno³Û½Þào³r"],
            "&In sanctum Stephanum (homilia 2) [Sp.]": [
                "Vol",
                "pg",
                "ln\x0ew¿Æ\x92\x0ew¿^\x0ew³",
            ],
            "In omnes sanctos [Sp.]": ["Pg", "ln\x0e\x8e\x0e<\x0e´"],
            "%In sanctum Joannem praecursorem [Sp.]": ["Vol", "pg", "lnÏ\x92ËÏpÒ³¶"],
            "In synaxim incorporalium [Sp.]": ["Sect", "ln\x0eü\x0eük\x0eþ´³"],
            "In quatriduanum Lazarum": ["Vol", "pg", "ln½\x8ceù"],
            "In illud: Messis quidem multa": ["Vol", "pg", "ln¿³®´¾\x8c¿r"],
            ",In principium indictionis, in martyres [Sp.]": [
                "Vol",
                "pg",
                "ln\x18»¿³Â¤\x18»¿\x1a´",
            ],
            "/In illud: Si qua in Christo nova creatura [Sp.]": [
                "Vol",
                "pg",
                "ln\x0eÀ§\x0eÀt\x0e³¶",
            ],
            "Contra haereticos [Sp.]": ["Vol", "pg", "lnx¼x¼Zy"],
            "De gloria in tribulationibus": ["Vol", "pg", "lnU³\x8eU³Y¶"],
            "In venerandum crucem [Sp.]": ["Vol", "pg", "ln/»À/»d1³"],
            "Ad eos qui scandalizati sunt": ["Chapter", "section", "line"],
            "#In parabolam de filio prodigo [Sp.]": ["Vol", "pg", "ln»´©»³c³"],
            "%Ad eos qui magni aestimant opes [Sp.]": [
                "Vol",
                "pg",
                "ln\x0eÀ§ÈÍ\x0eÀT\x0e³¶",
            ],
            "(In triduanam resurrectionem domini [Sp.]": ["Vol", "pg", "ln\x8cwÛ´"],
            "(In epistulam ad Ephesios (homiliae 1-24)": [
                "Vol",
                "pg",
                "ln1¾\x92\x92´¾©<<§®³\x8e¤\x92DDº¼¾À³ÃÇÉËMMËÎÐÒ×ÛºÞ\x92à´Z\x8e[\x8eî®ó÷úüþ®gg¤º\x8c\x8e§\x92pp¤¤´§©«©¶¤1¾\x0ez¶",
            ],
            "De negatione Petri [Sp.]": ["Vol", "pg", "ln'»½ë'»»¼r*´"],
            "=De sancta Thecla martyre (e cod. Athon. Panteleimon 58) [Sp.]": ["line"],
            "!In sanctum Thomam apostolum [Sp.]": ["Vol", "pg", "ln÷»÷»¤u"],
            '"Encomium in sanctos martyres [Sp.]': ["line"],
            " Homilia de capto Eutropio [Dub.]": ["Vol", "pg", "lnÞ´¿\x8c§³Þ´´¶´³"],
            "Oratio secunda [Sp.]": ["Vol", "pg", "ln\x0er¿\x8c\x0er¿t\x0et³´"],
            "De paenitentia (sermo 1) [Sp.]": ["Vol", "pg", "lnS¼©®«Í\x92´©Â¼S¼©d^"],
            "De patientia (sermo 1) [Sp.]": ["Vol", "pg", "lnl¼Ó©Ð®´l¼Ófp"],
            "Stichoi [Sp.]": ["line"],
            "In Psalmum 75 [Sp.]": ["Vol", "pg", "lngÑ¶Ó¼ÂgÑ´ji"],
            "GIn sanctum pascha (sermo 3) [Sp.] (fort. auctore Apollinare Laodicense)": [
                "Sect",
                "ln>\\?¶³",
            ],
            "0In illud: Credidi propter quod locutus sum [Sp.]": [
                "Pg",
                "ln\x0fß\x0fßE\x0f´´´",
            ],
            ".In illud: Verumtamen frustra conturbatur [Sp.]": [
                "Vol",
                "pg",
                "lnX®´XwZ",
            ],
            "/In novam dominicam et in apostolum Thomam [Sp.]": [
                "Vol",
                "pg",
                "ln\x0et¿\x8eÆÉ\x0et¿c\x0ev³´",
            ],
            "BDe incomprehensibili dei natura (%6 Contra Anomoeos, homiliae 1-5)": [
                "Homily",
                "line",
            ],
            "De coemeterio et de cruce": ["Vol", "pg", "lnº\x8c\x8e³ºo½³"],
            "Visio Danielis [Sp.]": ["Pg", "ln\x0e\x0ea\x0e´"],
            "In ascensionem (sermo 5) [Sp.]": ["Vol", "pg", "lnW´ÇÊW´«dX"],
            "De mansuetudine sermo [Sp.]": ["Vol", "pg", "ln¿§¿³³"],
            "De paenitentia [Sp.]": ["Vol", "pg", "ln¼§¼J¶"],
            '"Fragmenta in Jeremiam (in catenis)': [
                "Vol",
                "pg",
                "ln\x19À¶ù³¤©\x92´³À¶ÉÐ\x92Üü\x8c©¤©´®½\x8eÉÍà§\x8eù\x8c\x19À\x8e\x92sP",
            ],
            "In Petrum et Paulum [Sp.]": ["Vol", "pg", "ln»ëíÃ»ëYö"],
            "$De sancta Pelagia virgine et martyre": ["Vol", "pg", "lnÃ¿ÈÃk´´"],
            "4Quales ducendae sint uxores (%6 Encomium ad Maximum)": [
                "Vol",
                "pg",
                "lnr³®¶½êír³{y³",
            ],
            "?In oraculum Zachariae redditum [Sp.] (fort. sub auctore Proclo)": [
                "Vol",
                "pg",
                "lnÈÈÉ³",
            ],
            "De jejunio (sermones 1-7) [Sp.]": [
                "Vol",
                "pg",
                "lne¼ÇÊgÃhËÆÍ¤hhÍºÏiiÏÑjjÑ©e¼ÇhËhÍiÏjÑil´",
            ],
            "De cruce et latrone (homilia 2)": ["Vol", "pg", "lnÀ\x8e¤À³´"],
            "De Anna (sermones 1-5)": [
                "Vol",
                "pg",
                "ln¶÷©îùü\x8cþ®º\x8c\x8e\x92¤¤¤§¶÷«",
            ],
            "In Joannem (homiliae 1-88)": [
                "Vol",
                "pg",
                "ln»\x92\x92´\x8c¶\x8e«³\x12\x12«»\x15\x16»¤½\x16¤\x16½ÀÂÇÉ\x1b\x1bÉËÍÍÐÒÖ«¼ÛÝß®&&´((êî¼ó÷ùû23ûþ44©®;<®§¤»©«\x8e\x92JK³NN»P§Q»¾ÀÂ\x8c©UU´È®ÊÍÏYYÏ\x8eÑÓ[[Ó§¾×À__ÛÞà¾c§dÀ®êºíó¤÷lm÷ù½û¿\x8eqq½sºt«\x8c\x8e§©«§\x92©§\x8c©´¶³»½¿¤Ã©Ç¤\x92Ç§É³Ë´ÍÏ®ÏÑÀÓ¾\x92³ÜÞ\x92¤î¤Àö³¼û««\x8e\x8c\x8e\x8c\x8c\x8e\x92\x8e§©À©®´¶³½»\x8e½¿\x8cÊÊ¿\x8eÃÇÎÎÇÉËÐÑËÍÏ»ÒÓÖÜ¤Þà³»¤©\x12\x16»\x16½©\x1bÉÍ&(3û4<KNQ»«U«YÏ[Ó_Ûd¿m÷§qt§«ÇÏ«©Ê¿ÎÇÑËÓ%Û´",
            ],
            "2In epistulam i ad Thessalonicenses (homiliae 1-11)": [
                "Vol",
                "pg",
                "lnÓ¾\x8c«\x8eº¼³§©®³´»º½¤êê½ÀÂ§¶ÇÉ³Ë¾Î\x92ÐÒÓ¾Ã¶³",
            ],
            "In Zacchaeum publicanum [Sp.]": ["Vol", "pg", "ln½ÌÌ½\x8eT³³"],
            "1Caritatem secundum deum rem esse deo dignam [Sp.]": [
                "Vol",
                "pg",
                "ln½©¤½©X",
            ],
            "!In sanctum pascha (sermo 7) [Sp.]": ["Sect", "lnHºYM¶"],
            "In sanctum Stephanum [Sp.]": ["Vol", "pg", "ln2»»¾´2»»´c3"],
            "In centurionem [Sp.]": ["Vol", "pg", "ln½¿½½e³´"],
            "In ascensionem (sermo 4) [Sp.]": ["Vol", "pg", "lnV´«V´]W¶"],
            "-In epistulam ii ad Corinthios (homiliae 1-30)": [
                "Vol",
                "pg",
                "ln½®§\x92\x92¤¶©´ÎÏ¼¾À©ÃÓÇ´Ê\x92ÌÏÑÓ³ÖÛÝà¤§§ùûþ\x8e\x8eíí\x8c\x92´«´§»¾ÀÃ©ÈÊÍÏÒ«×ÛÞà½©6\x13",
            ],
            ")Homilia dicta postquam reliquiae martyrum": [
                "Vol",
                "pg",
                "lnÆ¿Ó¤©Ö½³Æ¿ÓdÈ",
            ],
            "In Psalmos 101-107 [Sp.]": [
                "Vol",
                "pg",
                "lnsû½\x8eÀÂ§¼\x8c\x8e\x8c½ÍÃºËsû¼À",
            ],
            "Commentarius in Job": [
                "Pg",
                "ln\x0fb\x8e§«\x8c³¼ÀÉÍÒ×Û\x8eàí\x8eöúþ\x92\x8c\x8c\x92©®»ÀÈ\x8e\x0fb",
            ],
            "#In Acta apostolorum (homiliae 1-55)": [
                "Vol",
                "pg",
                "lnÛ¼\x8eà®§©«´«¶´»½¿ÃÈÊÌÎÐÒ×ÛÝÝß´\x92êîºó÷÷ùºüþ¾\x15\x15\x8e§\x92\x19\x19©\x92§§©¤»©«##«&&³¤§)*½¼¾ÀÂÆ«ÈÊÍÏÑ\x8cÓ78×ÛÞà\x8c«´ëíóFF\x92÷ù³û³I\x8c´Jû¶þ\x8e´N³³O¶ºTUWW§\x8e§©«©»³c\x92c³´¶º¼¾®ÀÃ\x8eÇÉË¤Í¶ÐqrÑ§Ö´Üºßwxß\x8c¶ëí¶öú©Û¼Ý÷\x15\x19#«&*§8FJûOUWc³rÑxß\x1b",
            ],
            "In Psalmum 139 [Sp.]": ["Vol", "pg", "lnÃÃ¤"],
            "De beato Abraham [Sp.]": ["Vol", "pg", "ln¿¶ê¿_Â"],
            ".Catecheses ad illuminandos 1-8 (series tertia)": [
                "Catechesis",
                "section",
                "line",
            ],
            "(Epistula ad Antiochum (epist. 233) [Sp.]": ["line"],
            "%In decollationem sancti Joannis [Sp.]": ["Vol", "pg", "ln»\x8eÀê»\x8cZó"],
            "In Christi natalem diem [Sp.]": ["Vol", "pg", "ln½ÍÌ½j³"],
            ",In illud: Ignem veni mittere in terram [Sp.]": [
                "Vol",
                "pg",
                "lnÀ¾¿À¾\\Â³´",
            ],
            "2De consubstantiali (%6 Contra Anomoeos, homilia 7)": [
                "Vol",
                "pg",
                "lnó÷ùû\x92©ó«¶",
            ],
            "VContra Judaeos, gentiles et haereticos et in illud: Vocatus est Jesus ad nuptias [Sp.]": [
                "Vol",
                "pg",
                "ln®³³®³l³",
            ],
            "#In illud: Domine, non est in homine": ["Vol", "pg", "ln»\x8e³»\x8c®¾"],
            ",In epistulam ii ad Timotheum (homiliae 1-10)": [
                "Vol",
                "pg",
                "ln/¾×Ü12Ýºàº\x92ëí9:\x8c<<ú§´?´?û¼þ¼\x8c\x92E\x8eF¾\x8e\x92§´/¾×K¶¶",
            ],
            "Precatio in obsessos [Sp.]": ["Vol", "pg", "ln\x0eÀ\x0eÀ\x0eH\x0e³¶"],
            "In principium jejuniorum [Sp.]": ["Vol", "pg", "lnÃ¾ËÃ¾s³¶"],
            "In decem virgines [Sp.]": ["Vol", "pg", "ln»§¶»a³"],
            "6De Christi divinitate (%6 Contra Anomoeos, homilia 12)": [
                "Vol",
                "pg",
                "ln½»\x8c«½º",
            ],
            "FQuod mari similis sit haec vita [Sp.] (fort. auctore quodam Cappadoce)": [
                "Vol",
                "pg",
                "ln\x0eÀÃ¿\x0eÀÂq\x0e³",
            ],
            "Contra theatra [Sp.]": ["Vol", "pg", "ln¿\x8e¾Xë"],
            "'De inani gloria et de educandis liberis": ["line"],
            "*Interpretatio orationis Pater noster [Sp.]": ["Vol", "pg", "ln.»ó.»óZ."],
            "#In Psalmum 118 (homiliae 1-3) [Sp.]": [
                "Vol",
                "pg",
                "lnÂ§©¿®È´©¶½»\x8c¾©À\x8eV",
            ],
            "In Genesim (sermo 3) [Sp.]": ["Vol", "pg", "lnÝ\x92É³«Ýo"],
            "1In illud: Habentes eundem spiritum (homiliae 1-3)": [
                "Vol",
                "pg",
                "ln³\x92º\x92\x8c\x8c\x8e³¤³§\x8e©«´®³\x8eu",
            ],
            "In Herodem et infantes [Sp.]": ["Vol", "pg", "ln½»¤¾§½»g³"],
            "-Contra eos qui subintroductas habent virgines": ["Sect", "lnZÍ³ÍÓZc"],
            "4De Christi precibus (%6 Contra Anomoeos, homilia 10)": [
                "Vol",
                "pg",
                "ln¶\x92¶jº",
            ],
            "Laus Diodori episcopi": ["Vol", "pg", "lnJ´ùü\x92þWK"],
            "&In nativitatem Joannis Baptistae [Sp.]": ["Sect", "ln\x0e\x0eE\x0eí´´"],
            "*In illud: Ascendit dominus in templo [Sp.]": ["Vol", "pg", "ln½½X³¶"],
            "De corruptoribus virginum [Sp.]": ["Vol", "pg", "lnv¼¿v¼Tx"],
            "In Eliam prophetam [Sp.]": ["Vol", "pg", "lnëÇÉ\x8cëÇ_í"],
            ">In drachmam et in illud: Homo quidam habebat duos filios [Sp.]": [
                "Vol",
                "pg",
                "ln´½Í´½\x8eP³¶",
            ],
            "Fragmenta in Job (in catenis)": ["Vol", "pg", "lnîÀù«¤©´\x8c½ÈÍ§à®üîÀù"],
            "De siccitate [Sp.]": ["Vol", "pg", "ln½ÓÖ½ÓW³"],
            "/In illud: Apparuit gratia dei omnibus hominibus": [
                "Sect",
                "ln\x0e¾\x8c\x0e¾i\x0eÀ³",
            ],
            "De resurrectione mortuorum": ["Vol", "pg", "ln¿§\x8eË³"],
            "%Ad Demetrium de compunctione (lib. 1)": [
                "Vol",
                "pg",
                "ln.\x8c\x8e®¶º.|6",
            ],
            "In catenas sancti Petri [Sp.]": ["Sect", "ln\x0eó¤\x8e³¶\x0eó0\x0eú´³³"],
            '"In illud: Collegerunt Judaei [Sp.]': ["Vol", "pg", "ln»¤»[³´"],
            "&Ad populum Antiochenum (homiliae 1-21)": [
                "Vol",
                "pg",
                "ln\x18\x92©\x1f ¤¤®³\x8c»++»½´¿ºÂ/´0ÃºÆÈÊÌÎ³Ð»Ó×Û:;ÛÝ®ß==ëíCCó÷GG÷\x8eúüþ«ºRR\x8c¼¶®³»f¤g»©¾ÀÂÇÉËÍÐÒÖ³¾Ý\x18 +»\x8c\x8e0Ã;Û=CG÷Rg»§Ãv",
            ],
            "%De Babyla contra Julianum et gentiles": [
                "Sect",
                "ln\x0e\x8c©ºÂÉÐàíó\x8c\x0e9\x0e§³´",
            ],
            "In Bassum martyrem [Dub.]": ["Vol", "pg", "lnÏÓÖÏ\x8exº"],
            "%In illud: Vidi dominum (homiliae 1-6)": ["Homily", "section", "line"],
            "%In mediam hebdomadam jejuniorum [Sp.]": ["Vol", "pg", "ln3»½³¿À3»½^4¶"],
            "In Kalendas": ["Vol", "pg", "lní¼¾íQ³"],
            "De virtute animi [Sp.]": ["Vol", "pg", "ln\x0eÀÝà\x0eÀJ\x0e³¶"],
            "In Genesim (homiliae 1-67)": [
                "Vol",
                "pg",
                "ln`³¤³¤©»½¿§ÃÀÈÊÌÎÐÒÖ³Ü»ßëí«ó÷ùüþ\x92\x8c\x8e¤\x92§§©«´¶º¼¤¾À¶Ã\x8eÇÉË\x8eÍÏÑÓ×Û¶Þà\x8c\x8eêîö®ú¶üþ¶»\x8c¼½½¼Ã¤®\x92´¶º¼¤¾ÀÂÇÉË\x8eÍÏ\x92ÑÓ¤×Ü\x92Þàê§î´»÷ù\x8cû¾½\x92¾»\x8c¤®´¶º¼¿ÃÇÉË³ÍÏ«ÑÓ¶×º¿ÛÞà\x8cê©îö¼¶úº§\x8c\x92¤®³î´½»½¿Ãî`Ðm³",
            ],
            "In Eutropium": ["Vol", "pg", "ln\x0f´\x8c\x0f´", ""],
            ")In ascensionem domini nostri Jesu Christi": [
                "Vol",
                "pg",
                "lnÏ¼©¿Ï\x92Ó³",
            ],
            "*Homilia dicta in templo sanctae Anastasiae": [
                "Vol",
                "pg",
                "ln×¿í×¿í\x8c",
            ],
            "!Quod nemo laeditur nisi a se ipso": ["Sect", "lnÖ½\x8eÇÖÞ"],
            "De Susanna [Sp.]": ["Vol", "pg", "lnÍÏÍÒÍm´"],
            "De sancta trinitate [Sp.]": ["Vol", "pg", "ln¿¶Ã\x8eÈ¿\x92o´"],
            "(In illud: Sufficit tibi gratia mea [Sp.]": ["Vol", "pg", "lnü»ûÉ»ü»ûo³"],
            "De studio praesentium": ["Vol", "pg", "lnÑ¿êÑ¿N´"],
            '"In sancta et magna parasceve [Sp.]': ["Vol", "pg", "ln««´«©i×³"],
            "De paenitentia (homiliae 1-9)": [
                "Vol",
                "pg",
                "ln¼®«¶³¼¾À¤ÂÇÉ©Ë®Í´Ï¤§Ï«ÒÖÝ³³Ï©e©",
            ],
            " Non esse ad gratiam concionandum": ["Vol", "pg", "lnü\x92³\x8cüS"],
            "7In illud: Salutate Priscillam et Aquilam (sermones 1-2)": [
                "Vol",
                "pg",
                "lnb³»½¿¶Â\x8e¤ÆÈºËÍÐb³»\x8ej",
            ],
            "In Psalmum 50 (homilia 1) [Sp.]": ["Vol", "pg", "lnZº»½¿Zs`"],
            '"In illud: Filius ex se nihil facit': ["Vol", "pg", "ln÷úü¶³÷c"],
            "Epistula ad Caesarium [Sp.]": ["Version", "fragment", "line"],
            "In illud: Memor fui dei [Sp.]": ["Vol", "pg", "ln½´Ï®½[\x8e"],
            ";Homilia habita postquam presbyter Gothus concionatus fuerat": [
                "Vol",
                "pg",
                "ln¿ó¶÷ùû¿ónß",
            ],
            "$In meretricem et in pharisaeum [Sp.]": ["Vol", "pg", "ln½´ºÈ½³k¶"],
            "Ad Theodorum lapsum (lib. 1)": ["Sect", "lnÂÎ\x8eÆ\x92¤®>\x10³"],
            "Epistulae 18-242": [
                "Vol",
                "pg",
                "ln\x1b´\x8eö©ù\x92û´þ³³\x8e¤«\x92º¼¿Â\x92Ç<=Ç\x8eÊÌÏÒ×Ýßê\x1b´=ÇIJ",
            ],
            "!In sanctum pascha (sermo 5) [Sp.]": ["Vol", "pg", "ln@»ÛÝ»ß«@»ÛkB¶"],
            "PIn laudem conceptionis sancti Joannis Baptistae [Sp.] (fort. sub auctore Proclo)": [
                "Vol",
                "pg",
                "lnÉÉ´nË³³",
            ],
            "In natalem Christi diem [Dub.]": ["Vol", "pg", "lnÛ\x8cÛÝ¶"],
            "@Ad Theodorum lapsum (lib. 2) (%6 Epistula ad Theodorum monachum)": [
                "Sect",
                "ln",
            ],
            "In saltationem Herodiadis [Sp.]": ["Vol", "pg", "ln»´Ê\x8e\x92»³f³³"],
            "In ascensionem (sermo 3) [Sp.]": ["Vol", "pg", "lnU´¶U´_V"],
            "De continentia [Sp.]": ["Pg", "lnº¿º¿\x0e¼³"],
            "%De nativitate Joannis Baptistae [Sp.]": ["line"],
            "DIn illud: Dominus regnavit et in illud: Dies diei dicit verbum [Sp.]": [
                "Sect",
                "ln\x0eî\x0eîN\x0e´¶",
            ],
            "De non iterando conjugio": ["line"],
            "Sermo cum iret in exsilium": ["Vol", "pg", "ln\x15´³´¶\x15´³l\x16³"],
            "%Ascetam facetiis uti non debere [Sp.]": ["Vol", "pg", "lnÆ¤_"],
            "/In illud: Hoc scitote quod in novissimis diebus": ["Vol", "pg", "lnËËÎ"],
            "De meretrice [Sp.]": ["Pg", "ln\x0e\x8e\x0eP\x0e´"],
            "8In illud: Simile est regnum caelorum grano sinapis [Sp.]": [
                "Vol",
                "pg",
                "ln\x0eÀÂ\x0eÀ\x0e³",
            ],
            "2In sanctam theophaniam seu baptismum Christi [Sp.]": [
                "Vol",
                "pg",
                "lnÒ§\x8cÒuÓ³",
            ],
            "CIn illud: Ne timueritis cum dives factus fuerit homo (homiliae 1-2)": [
                "Vol",
                "pg",
                "lnó÷ùû¤¤¤®ó§a´",
            ],
            "/Catechesis ultima ad baptizandos (series prima)": [
                "Pg",
                "ln\x0eÃ\x0eÃ\x0eÆ³",
            ],
            "De Lazaro (homiliae 1-7)": [
                "Vol",
                "pg",
                "lnÃÆÉËÍÐÒ×¤ÛÞà®«íó÷ú\x8eü§þ\x8c\x92©Ãíh\x18´",
            ],
            "!In publicanum et pharisaeum [Sp.]": ["Vol", "pg", "ln¾ÓÐ¾Ó®_»³"],
            "+Eclogae i-xlviii ex diversis homiliis [Sp.]": [
                "Vol",
                "pg",
                "ln¿»½§ÀÃÇÉ³Ë¼ÍÍ©ÐÒ¶\x92×³ÜÞà³î««ê\x8cî¤ó\x8c÷\x92ö÷ùûþ¼\x8c\x0e«\x0e»³»§©\x0e\x0e©«\x0e\x0e\x0e\x0f\x8c»½\x0e\x15\x0e\x15½\x8eÀÂ³Æ½ÉËÍÏÑ´Ö©Üß\x92\x0e(\x0e(ê\x8eî§ó÷ùû¾¿\x0e5\x0e5´\x8e¤³®§¶©º«\x0eG\x0eG«³®¼\x0eJ\x0eK¿´¶»½¿ÃÇ\x0eT\x0eTÇ¤ÉË»ÍÀÏ\x0eX\x0eYÏÒ\x8e\x0e[\x0e[ÜÞ\x8e\x0ed\x0edë½îöúü\x0ep\x0eq¿Í\x8e©ö÷\x0eº\x0e©\x0e\x0f¶\x0e\x15½\x8c\x0e(\x0e5\x0eG«\x0eK½¾\x0eTÇ\x0eYÏ®\x0e[©\x0ed\x0eqL\x0er³´´",
            ],
            "1In passionem salvatoris nostri Jesu Christi [Sp.]": [
                "Pg",
                "ln\x0eú³\x0eú³J\x0eû´³",
            ],
            "#De diabolo tentatore (homiliae 1-3)": ["Vol", "pg", "ln´öû\x8c\x92¶´³¶U"],
            "IIn illud: Attendite ne eleemosynam vestram faciatis coram hominibus [Sp.]": [
                "Vol",
                "pg",
                "ln\x16»»½\x16»»k\x18´",
            ],
            "0De laudibus sancti Pauli apostoli (homiliae 1-7)": [
                "Homily",
                "section",
                "line",
            ],
            "@Adversus ebriosos et de resurrectione domini nostri Jesu Christi": [
                "Vol",
                "pg",
                "lnË´ºËxÏ³¶",
            ],
            "De sacerdotio (lib. 1-6)": [
                "Chapter",
                "section",
                "lnö\x8c\x8eÀ§\x8c\x8cÓ´oÖ¶",
            ],
            '"In paralyticum demissum per tectum': [
                "Vol",
                "pg",
                "ln)³º´\x8e¶º´½À)³§/¶´",
            ],
            '"In dictum Pauli: Nolo vos ignorare': ["Vol", "pg", "lny³\x8eö¤ú§üy³y´"],
            "Epitimia lxxiii [Sp.]": ["Sect", "ln\x0e©É\x0es\x0e´³"],
            "In Matthaeum (homiliae 1-90)": [
                "Vol",
                "pg",
                "lnÎ¤¤«§©\x92®³³º½¿Â¤ÇÉËÎÐ´Ó³º¼¾ÀÂ½Ç\x92ÉËÎÐÒ¤Ö¶Û\x8eÝ\x92ßêó÷®ùüþ«´\x8e³\x92§³³´º¼¾À©Â¶ÇÉÌ¼ÐÒÖÛÝßºëíó÷ù¼üþ\x8e\x8e\x92¶\x92®³³º¼¾À§Â³ÇÉËÍÐÒÖ×§ÜÞ\x8c«ê\x92îó÷ùûþº\x8e\x8e»¤©«©³¶º\x92¼¾¤ÀÃÇÉÌÎ\x8eÐÒÖÜß©êóúüþ\x8c½\x92\x92©³¤\x92³¶º\x8c¼¾ÀÂ´ÇÉ«ËÍÐÒ«ÖÛÝ¤ß®êî»ó÷³úüþ\x8e\x92\x92\x8eÎÖÖºüÏ¶ü»\x15\x19\x92##³¶1È\x8c4Î\x8cRRR[¤`«`³`»pÏp½¶¾¤©Ë©³Û\x8eº½÷½½»Ï»Îíí¼öZ³",
            ],
            "EDe petitione matris filiorum Zebedaei (%6 Contra Anomoeos, homilia 8)": [
                "Vol",
                "pg",
                "ln´",
            ],
            "Admonitiones spirituales [Sp.]": ["Vol", "pg", "lnÂ¾ÂÌÂ¾^Ã³"],
            "/In Samaritanam, in die mediae pentecostes [Sp.]": [
                "Vol",
                "pg",
                "ln½\x8c½ê½j§³",
            ],
            "(In natale sancti Joannis prophetae [Sp.]": ["Vol", "pg", "ln½¼÷´ù½\x92³"],
            "#De mutatione nominum (homiliae 1-4)": [
                "Vol",
                "pg",
                "lnC³ó¿\x92ú§JJ§\x8c\x8e´\x8c¼\x92C³JnU¶¶",
            ],
            "4Cum Saturninus et Aurelianus acti essent in exsilium": [
                "Vol",
                "pg",
                "ln",
                "´¤",
                "´®h\x13",
            ],
            "In Psalmum 50 (homilia 2) [Sp.]": ["Vol", "pg", "ln`¿ËÂ¾ÆÈ§ÊÌ\x8c[g"],
            "De precatione (orat. 1-2) [Sp.]": ["Vol", "pg", "lnÃ\x8e\x92Ã}È³"],
            "In Samaritanam [Sp.]": ["Vol", "pg", "ln»\x8e«¼»³"],
            '"Sermo cum presbyter fuit ordinatus': ["line"],
            "De sacerdotio (lib. 7) [Sp.]": ["Vol", "pg", "ln«®«o«"],
            "Ad Innocentium papam (epist. 1)": ["Vol", "pg", "ln\x18´¤³\x18´^\x1a"],
            "In synaxim archangelorum [Sp.]": ["Vol", "pg", "lnM»óÀM»óeN¶"],
            "In Psalmum 94 [Sp.]": ["Vol", "pg", "lnm´ê³m®ao"],
            "In Christi natalem [Sp.]": ["line"],
            "De sancto Meletio Antiocheno": ["Vol", "pg", "lnfÜ´"],
            "De eleemosyna [Sp.]": ["Vol", "pg", "ln\x0eÀ´¼\x92\x0eÀh\x0e³¶´"],
            "&In adorationem venerandae crucis [Sp.]": ["Vol", "pg", "ln¾ë´î¾ë\x92[É³"],
            " In annuntiationem deiparae [Sp.]": ["Vol", "pg", "lnÏ¾û¶®Ï¾ûMÒ³³"],
            "De salute animae [Sp.]": ["Vol", "pg", "lns¼ßs¼ßRu"],
            "-In annuntiationem sanctissimae deiparae [Sp.]": [
                "Vol",
                "pg",
                "ln¼ó¶Â¼ó³",
            ],
            "In illud: Exiit edictum [Sp.]": ["Vol", "pg", "lnÍ®ÆÍnÏ³"],
            "0Epistula ad Cyriacum (epist. 125 %7 recensiones)": [
                "\x14Version or recension",
                "line",
            ],
            "0In assumptionem domini nostri Jesu Christi [Sp.]": [
                "Vol",
                "pg",
                "ln½ÇÉ½Ç\x92Z",
            ],
            "De jejunio et eleemosyna [Sp.]": ["Vol", "pg", "lnÎ\\"],
            "In martyres Aegyptios": ["Vol", "pg", "lng\x0e"],
            ")In epistulam ad Philemonem (homiliae 1-3)": [
                "Vol",
                "pg",
                "ln\\¾½¿\\\\¿¤´ÂÇÉËÍ³Ð\\¾½\x8cVc¶",
            ],
            "%In Romanum martyrem (homilia 2) [Sp.]": ["Vol", "pg", "ln®êY"],
            "+In evangelii dictum et de virginitate [Sp.]": [
                "Vol",
                "pg",
                "ln\x0eÀ§©«\x0eÀ©n\x0e³¶",
            ],
            "!De fugienda simulata specie [Sp.]": ["Vol", "pg", "ln´\x8c®"],
            "!In secundum domini adventum [Sp.]": ["Vol", "pg", "ln*»ëí*»ë©b."],
            "!De Davide et Saule (homiliae 1-3)": [
                "Vol",
                "pg",
                "ln¶î§©¼\x8e®³\x92¼¾À«Ãº¶®i¶",
            ],
            " Synopsis scripturae sacrae [Sp.]": [
                "Vol",
                "pg",
                "ln¼¼¾Ã³ÈÊÌ©Î´ÑÓ§\x8cÝß´\x8cêî¼ó÷úüþ³¼dÛ´",
            ],
            "Fragmenta ex homiliis diversis": ["Fragment", "line"],
            "De eleemosyna": ["Vol", "pg", "ln³³¶"],
            "De paenitentia (sermo 2) [Sp.]": ["Vol", "pg", "ln^¼»¾ÇÂ^¼»]a"],
            "Ad Innocentium papam (epist. 2)": [
                "Vol",
                "pg",
                "ln\x1a´\x8e\x1a´\x8cn\x1b¶",
            ],
            "?De remissione peccatorum [Sp.] (fort. auctore quodam Cappadoce)": [
                "Vol",
                "pg",
                "ln¼÷ú\x8cü\x92¼÷\x8e]´",
            ],
            "De baptismo Christi": ["Vol", "pg", "ln®ëî¶®ë®³"],
            ".Contra haereticos et in sanctam deiparam [Sp.]": [
                "Vol",
                "pg",
                "ln7»½È\x92Ê´7»¼O9",
            ],
            "In mediam pentecosten [Sp.]": ["Vol", "pg", "ln½½l³"],
            "Deprecatio [Sp.]": ["line"],
            "De Chananaea [Dub.]": ["Vol", "pg", "lnN´Æ¤ÈÊºÌN´bS³"],
            "3De beato Philogonio (%6 Contra Anomoeos, homilia 6)": [
                "Vol",
                "pg",
                "ln§ëí§ë\x8e",
            ],
            "In sanctum Ignatium martyrem": ["Vol", "pg", "lnË´ÏÑËq´"],
            "&In dictum Pauli: Oportet haereses esse": ["Vol", "pg", "ln³û³û«^"],
            "#In Martham, Mariam et Lazarum [Sp.]": ["Vol", "pg", "ln½½ÀÉ½½©e´"],
            ",In illud Isaiae: Ego dominus deus feci lumen": ["Vol", "pg", "ln¶§¶s»´"],
            '"Comparatio regis et monachi [Dub.]': ["Vol", "pg", "lni"],
            "In Ecclesiasten [Sp.]": ["Sect", "ln\x0f \x0fü§\x0f V\x0f'´¶"],
            "De jejunio, de Davide [Sp.]": ["Vol", "pg", "lnÌ¾÷úü³Ì¾÷iÏ³³"],
            "De virginitate": ["Sect", "lnk\x8eÍ»¼¤\x92Ýþ´\x8eÌ½\x8eÉËÎÑ\x8ekE"],
            "$In epistulam ad Galatas commentarius": [
                "Vol",
                "pg",
                "ln\x13½«î¶óú\x8e³&&\x8c-.¤«\x13½@1",
            ],
            "Contra ludos et theatra": ["Vol", "pg", "ln\x8c\x8et×¶"],
            "2In Psalmum 50 (homilia 1) [Sp.] (P. Berol. 6788 A)": [
                "Sect",
                "ln\x0faP\x0fa",
            ],
            "In Lazarum (homilia 3) [Sp.]": ["Vol", "pg", "ln×¾\x8c×¾a³³"],
            '"De proditione Judae (homiliae 1-2)': ["Vol", "pg", "ln÷ùû¶¾¶©bº³"],
            "De terrae motu": ["Vol", "pg", "ln\x13ÉÌ\x13É\x14¶"],
            "In Psalmum 145": ["Vol", "pg", "ln\x8c§\x8e¶¶´"],
            "In Lazarum (homilia 1) [Sp.]": ["Vol", "pg", "ln¾À§¾¿ZÖ³³"],
            "!In pharisaeum et meretricem [Sp.]": ["Vol", "pg", "ln½×½Ý½×\x8eX³´"],
            "&In illud: Pater si possibile est [Sp.]": ["Vol", "pg", "ln§½É§½h©³"],
            "%Prooemia in Psalmos (fragmenta) [Sp.]": ["Vol", "pg", "lnUÇÃUsX"],
            "3In laudem sancti Joannis theologi (homilia 2) [Sp.]": [
                "Vol",
                "pg",
                "ln½Ï®Ò\x8e½ÏV³",
            ],
            "%Epistulae ad Olympiadem (epist. 1-17)": ["Epistle", "section", "line"],
            "In resurrectionem domini [Sp.]": ["line"],
            "#In sanguinis fluxu laborantem [Sp.]": [
                "Vol",
                "pg",
                "ln\x0e}À¶Æ¿\x0e}À\x0e³",
            ],
            "=In quatriduanum Lazarum (%6 Contra Anomoeos, homilia 9) [Sp.]": [
                "Vol",
                "pg",
                "ln´¼¤´¶",
            ],
            "'In annuntiationem beatae virginis [Sp.]": ["Vol", "pg", "lnË»«ËºeÍ³´"],
            "In Psalmum 50 [Sp.]": ["Vol", "pg", "lnTToU"],
            "6In natale domini et in sanctam Mariam genitricem [Sp.]": [
                "Sect",
                "ln\x0eà\x92¤\x0eàJ\x0e´´",
            ],
            "In Jordanem fluvium [Sp.]": ["Vol", "pg", "ln½¼\x8c½m³³"],
            " In resurrectionem domini B [Sp.]": ["line"],
            "'In epistulam ad Romanos (homiliae 1-32)": [
                "Vol",
                "pg",
                "ln¼\x8c«\x8eº´\x92¤§¶®¼³\x8c»§½®¿½¤ÈÊÌ«ÎºÑÓ«Ó×ÛÝß½êî¶ó÷\x8eùû½¾û®³½\x8e¤«\x92´§©«³³¶ºÜÝ»¾ÀÂ¼ÇÇÉËÍ³ÏºÑ¾Ó\x8cÓ\x8e»ÖÜ´ÞÀíí¾¤ó§óí©«½÷ùûúú\x8cº¶\x92¼\x8c\x92©´º§¼¶®«Ó¾û³Ý»ÇÓíóíú#\x0f¶",
            ],
            "Sermo antequam iret in exsilium": ["Vol", "pg", "ln\x13´«®\x13´«]\x15"],
            "De patientia (sermo 2) [Sp.]": ["Vol", "pg", "lnp¼¶ÛÌÝßp¼Ts¶"],
            "In ascensionem (sermo 2) [Sp.]": ["Vol", "pg", "lnS´§¿ÍS´^U´"],
            "In pentecosten (sermo 1) [Sp.]": ["Vol", "pg", "lnX´\x8e§X´\x8c`Z"],
            "!In sanctos Petrum et Heliam [Sp.]": ["Vol", "pg", "lnºÜßº\x8eb¿"],
            "3De cruce et latrone [Sp.] (fort. auctore Severiano)": [
                "Sect",
                "ln\x0e\x92\x0eE\x0e´",
            ],
            "In sanctum pascha [Sp.]": ["line"],
            "Epistula ad monachos [Sp.]": ["line"],
            "(Sermo exhortatorius de temperantia [Sp.]": [
                "Vol",
                "pg",
                "ln\x0e}À©\x0e}Àh\x0e}³",
            ],
            "'In exaltationem venerandae crucis [Sp.]": ["Vol", "pg", "ln1»§1»§X2´"],
            "#Fragmenta in Proverbia (in catenis)": [
                "Vol",
                "pg",
                "lnÀ\x8c¶ÀÉÐ\x8eÝ§À\x19¶",
            ],
            "In proditionem Judae [Sp.]": ["Vol", "pg", "ln½³Ë½o"],
            "'Post reditum a priore exsilio (sermo 2)": [
                "Vol",
                "pg",
                "ln\x16´»¾À\x8c\x16´»h\x18´",
            ],
            "@De paenitentia et in lectionem de Davide et de uxore Uriae [Sp.]": [
                "Vol",
                "pg",
                "ln\x0ezÀ\x0ezÀg\x0e|³³",
            ],
            "Non esse desperandum": ["Vol", "pg", "ln³ë³î³ë´"],
            "In sanctum Barlaam martyrem": ["Vol", "pg", "ln§n"],
            ",In epistulam i ad Corinthios (homiliae 1-44)": [
                "Vol",
                "pg",
                "ln\x0f½\x8c¼¤\x17\x17¤´§\x1b\x1b§©«§\x1f\x1f´»½¿®Ã((ÃÆÈÊÌ¾Ï\x8eÑÓ¼×11×§ÜÞà\x8eë::ëí³=>\x92öú³\x8e\x8c\x8eRS¤¼«³½º_`»³¾ÀÂÇÉËÍghÍÏÑÓjkÓ¤ÖÜ©Þ´ë¿î÷ù{|ùû§¾\x8c¿³º§©«®§©´»»½ÀÂÇÉË¤ÎÐÒ×\x8cÛ§§Û\x8e¤Þà©ëî\x8c÷ùûºþ\x0f½",
            ],
            "In illud: Si esurierit inimicus": ["Vol", "pg", "ln\\³«®³\x92³º\\³«b¶"],
            "Encomium in sanctum Polycarpum": ["line"],
            "KIn natale domini nostri Jesu Christi [Sp.] (fort. auctore quodam Cappadoce)": [
                "Vol",
                "pg",
                "ln½û¾þ¤\x8c½ûX³",
            ],
            "In duodecim apostolos [Sp.]": ["Vol", "pg", "lnö»º\x8cö»\x8cb÷"],
            '"In illud: Exeuntes pharisaei [Sp.]': ["Vol", "pg", "ln½ÊÃ½Éb"],
            "De jejunio [Sp.]": ["Vol", "pg", "lnË¾ÆË¾¶bÌ³³"],
            "Homilia in martyres": ["Vol", "pg", "ln³¼n³"],
            ")Interpretatio in Danielem prophetam [Sp.]": [
                "Vol",
                "pg",
                "lnÇÊÌÎÑÓÖ\x8eÛ«Þ§\x8c³ëíö[³",
            ],
            "-Christi discipulum benignum esse debere [Sp.]": ["Vol", "pg", "ln«È«`"],
            '"Homilia dicta praesente imperatore': ["Vol", "pg", "lnÈ¿ÛÞÈ¿mË"],
            "In Psalmum 92 [Sp.]": ["Vol", "pg", "lnkº¤§kZm´"],
            ",In nativitatem Christi (fragmenta duo) [Sp.]": ["Fragment", "line"],
            ";In parabolam de ficu [Sp.] (fort. auctore quodam Cappadoce)": [
                "Vol",
                "pg",
                "ln\x1e»ÉËÍ\x1e»É§P ´³",
            ],
            "De sancto hieromartyre Babyla": ["Vol", "pg", "lnÞ\x92©Þjà´"],
            "Oratio de hypapante [Sp.]": ["Pg", "ln\x0f¾Ì\x0fi\x0f´´³"],
            ";In illud: Nolite thesaurizare vobis thesauros in terra[Sp.]": [
                "Pg",
                "ln\x0e\x92÷ù\x0ef\x0eó´³",
            ],
            "GIn sanctum pascha (sermo 1) [Sp.] (fort. auctore Apollinare Laodicense)": [
                "Sect",
                "ln:s<¶",
            ],
            "In pentecosten (sermo 2) [Sp.]": ["Vol", "pg", "lnZ´§ÃZ´§k["],
            ",In epistulam ad Philippenses (homiliae 1-15)": [
                "Vol",
                "pg",
                "lnz¾´¼¾ÃÈËÍÍÏ¶Ò×ÜÞà¶\x8cê\x8eöùû©\x92©´\x8c\x8c©¤®z¾«¶",
            ],
        },
    },
    "Antisthenes Phil., Rhet.": {
        "tlg_id": "TLG0591",
        "names": {
            "name_authtab": "Antisthenes Phil. et Rhet.",
            "name_idt": "Antisthenes Phil., Rhet.",
        },
        "works": {
            "Fragmenta varia": ["Fragment", "line"],
            "Declamationes (fragmenta)": ["Fragment", "section", "line"],
        },
    },
    "Aristodemus Hist.": {
        "tlg_id": "TLG2148",
        "names": {"name_authtab": "Aristodemus Hist.", "name_idt": "Aristodemus Hist."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Fragmentum (P. Oxy. 27.2469)": ["FGrH fragment", "line"],
        },
    },
    "Aristonicus Gramm.": {
        "tlg_id": "TLG1194",
        "names": {
            "name_authtab": "Aristonicus Gramm.",
            "name_idt": "Aristonicus Gramm.",
        },
        "works": {
            "": ["De signis Iliadis", "Book of Iliad", "verse in book", "line"],
            "Fragmentum": ["line", "fragment", "line"],
            "De signis Odysseae": [
                "Book of Odyssey",
                "verse in book",
                "line",
                "\x12©×\x14\x16\x92É½¶\x18îù®³\x19\x92¾©\x1a\x1b\x92\x1b×«§³³\x1e\x1e\x92\x1f³\x1fÓ¶´³ ©\x16l ",
            ],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Archebulus Poeta": {
        "tlg_id": "TLG2608",
        "names": {"name_authtab": "Archebulus Poeta", "name_idt": "Archebulus Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Aelianus Tact.": {
        "tlg_id": "TLG0546",
        "names": {"name_authtab": "Aelianus Tact.", "name_idt": "Aelianus Tact."},
        "works": {"Tactica": ["Chapter", "section", "line"]},
    },
    "Pherenicus Epic.": {
        "tlg_id": "TLG2636",
        "names": {"name_authtab": "Pherenicus Epic.", "name_idt": "Pherenicus Epic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Nicias Epigr.": {
        "tlg_id": "TLG1533",
        "names": {"name_authtab": "Nicias Epigr.", "name_idt": "Nicias Epigr."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Scholia In Thucydidem": {
        "tlg_id": "TLG5039",
        "names": {
            "name_authtab": "Scholia In Thucydidem",
            "name_idt": "Scholia In Thucydidem",
        },
        "works": {
            "4Scholia in Thucydidem (scholia vetera et recentiora)": [
                "Book",
                "chapter",
                "section",
                "line",
            ]
        },
    },
    "Mimnermus Trag.": {
        "tlg_id": "TLG1511",
        "names": {"name_authtab": "Mimnermus Trag.", "name_idt": "Mimnermus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Memnon Hist.": {
        "tlg_id": "TLG1496",
        "names": {"name_authtab": "Memnon Hist.", "name_idt": "Memnon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Simus Phil.": {
        "tlg_id": "TLG2245",
        "names": {"name_authtab": "Simus Phil.", "name_idt": "Simus Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Damon Hist.": {
        "tlg_id": "TLG2273",
        "names": {"name_authtab": "Damon Hist.", "name_idt": "Damon Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Etymologicum Gudianum": {
        "tlg_id": "TLG4098",
        "names": {
            "name_authtab": "Etymologicum Gudianum",
            "name_idt": "Etymologicum Gudianum",
        },
        "works": {
            "qAdditamenta in Etymologicum Gudianum ($A)A/LION_ZEIAI/&) (e codd. Vat. Barber. gr. 70 [olim Barber. I 70] %7 Pari": [
                "Alphabetic entry",
                "page",
                "line",
            ],
            "$Additamenta in Etymologicum Gudianum": ["Page", "line"],
            ")Etymologicum Gudianum ($A)A/LION_ZEIAI/&)": [
                "Alphabetic entry",
                "page",
                "line",
            ],
            "*Etymologicum Gudianum ($ZEI/DWROS_W)=MAI&)": [
                "Alphabetic entry",
                "page",
                "line",
            ],
        },
    },
    "Crates Comic.": {
        "tlg_id": "TLG0433",
        "names": {"name_authtab": "Crates Comic.", "name_idt": "Crates Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Oenomaus Phil.": {
        "tlg_id": "TLG1548",
        "names": {"name_authtab": "Oenomaus Phil.", "name_idt": "Oenomaus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cleobulus Epigr., Lyr.": {
        "tlg_id": "TLG1274",
        "names": {
            "name_authtab": "Cleobulus Epigr. et Lyr.",
            "name_idt": "Cleobulus Epigr., Lyr.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Anonymus Iamblichi Phil.": {
        "tlg_id": "TLG1134",
        "names": {
            "name_authtab": "Anonymus Iamblichi Phil.",
            "name_idt": "Anonymus Iamblichi Phil.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Paulus Silentiarius Poeta": {
        "tlg_id": "TLG4039",
        "names": {
            "name_authtab": "Paulus Silentiarius Poeta",
            "name_idt": "Paulus Silentiarius Poeta",
        },
        "works": {
            "Descriptio ambonis": ["line"],
            "Descriptio Sanctae Sophiae": ["line"],
        },
    },
    "Autolycus Astron.": {
        "tlg_id": "TLG1210",
        "names": {"name_authtab": "Autolycus Astron.", "name_idt": "Autolycus Astron."},
        "works": {
            "De ortibus et occasibus": ["Chapter", "section", "line"],
            "De sphaera quae movetur": ["Section", "line"],
        },
    },
    "Menecrates Comic.": {
        "tlg_id": "TLG0523",
        "names": {"name_authtab": "Menecrates Comic.", "name_idt": "Menecrates Comic."},
        "works": {"Fragmentum": ["Fragment", "line"], "Titulus": ["Page", "line"]},
    },
    "Philetas Eleg., Gramm.": {
        "tlg_id": "TLG0212",
        "names": {
            "name_authtab": "Philetas Eleg. et Gramm.",
            "name_idt": "Philetas Eleg., Gramm.",
        },
        "works": {
            "": ["Fragmenta poetica", "Title", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta grammatica": ["Fragment", "line"],
        },
    },
    "[Musaeus] Phil.": {
        "tlg_id": "TLG2691",
        "names": {"name_authtab": "[Musaeus] Phil.", "name_idt": "[Musaeus] Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Sotades Iamb.": {
        "tlg_id": "TLG1691",
        "names": {"name_authtab": "Sotades Iamb.", "name_idt": "Sotades Iamb."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Severianus Scr. Eccl.": {
        "tlg_id": "TLG4139",
        "names": {
            "name_authtab": "Severianus Scr. Eccl.",
            "name_idt": "Severianus Scr. Eccl.",
        },
        "works": {
            ";In Job (sermones 1-4) (olim sub auctore Joanne Chrysostomo)": [
                "Volume",
                "page",
                "line",
            ],
            "3Fragmenta in epistulam i ad Corinthios (in catenis)": [
                "Page",
                "line",
                "",
                "\x12\x13í\x13í\x13í\x8e\x15\x15\x8c\x15\x8c\x92\x15ü\x18\x92\x92\x19\x1a\x1a\x92\x92\x92\x1e´",
            ],
            "2Fragmentum in epistulam ad Philemonem (in catenis)": ["Page", "line"],
            "/Fragmenta in epistulam ad Ephesios (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Galatas (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "3Fragmenta in epistulam ad Philippenses (in catenis)": ["Page", "line"],
            "2Fragmenta in epistulam i ad Timotheum (in catenis)": ["Page", "line"],
            "9Fragmenta in epistulam i ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "3Fragmenta in epistulam ii ad Timotheum (in catenis)": ["Page", "line"],
            ":Fragmenta in epistulam ii ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "4Fragmenta in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            "JIn illud: Quando ipsi subiciet omnia (olim sub auctore Joanne Chrysostomo)": [
                "Page",
                "line",
            ],
            "6De tribus pueris (olim sub auctore Joanne Chrysostomo)": [
                "Volume",
                "page",
                "line",
            ],
            "/Fragmenta in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
            "2Fragmenta in epistulam ad Colossenses (in catenis)": ["Page", "line"],
            "3De caeco nato (olim sub auctore Joanne Chrysostomo)": [
                "Volume",
                "page",
                "line",
            ],
            ",Fragmenta in epistulam ad Titum (in catenis)": ["Page", "line"],
            ":De caeco et Zacchaeo (olim sub auctore Joanne Chrysostomo)": [
                "Volume",
                "page",
                "line",
            ],
            ":In Genesim (sermo 1) (olim sub auctore Joanne Chrysostomo)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Phoenix Iamb.": {
        "tlg_id": "TLG1606",
        "names": {"name_authtab": "Phoenix Iamb.", "name_idt": "Phoenix Iamb."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Athenodorus Phil.": {
        "tlg_id": "TLG1206",
        "names": {"name_authtab": "Athenodorus Phil.", "name_idt": "Athenodorus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Symeon Logothetes Hist.": {
        "tlg_id": "TLG3070",
        "names": {
            "name_authtab": "Symeon Logothetes Hist.",
            "name_idt": "Symeon Logothetes Hist.",
        },
        "works": {
            "qChronicon (sub nomine Leonis Grammatici vel Theodosii Melisseni vel Julii Pollucis) (redactio A %7 B operis sub t": [
                "Page",
                "line",
            ]
        },
    },
    "Anacreon Lyr.": {
        "tlg_id": "TLG0237",
        "names": {"name_authtab": "Anacreon Lyr.", "name_idt": "Anacreon Lyr."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Diodorus Comic.": {
        "tlg_id": "TLG0444",
        "names": {"name_authtab": "Diodorus Comic.", "name_idt": "Diodorus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Apollodorus Mech.": {
        "tlg_id": "TLG1165",
        "names": {"name_authtab": "Apollodorus Mech.", "name_idt": "Apollodorus Mech."},
        "works": {"Poliorcetica": ["Wescher page", "line"]},
    },
    "Euagon Hist.": {
        "tlg_id": "TLG2372",
        "names": {"name_authtab": "Euagon Hist.", "name_idt": "Euagon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Menander Protector Hist.": {
        "tlg_id": "TLG4076",
        "names": {
            "name_authtab": "Menander Protector Hist.",
            "name_idt": "Menander Protector Hist.",
        },
        "works": {
            "+Fragmentum (e cod. Paris. gr. 1140A) [Dub.]": ["Page", "line"],
            "?De sententiis (ap. Constantinum Porphyrogenitum, De sententiis)": [
                "Section",
                "line",
            ],
            "aDe legationibus Romanorum ad gentes (fragmenta ap. Constantinum Porphyrogenitum, De legationibus)": [
                "Section",
                "line",
            ],
            "`De legationibus gentium ad Romanos (fragmenta ap. Constantinum Porphyrogenitum, De legationibus)": [
                "Section",
                "line",
            ],
        },
    },
    "Bion Phil.": {
        "tlg_id": "TLG1224",
        "names": {"name_authtab": "Bion Phil.", "name_idt": "Bion Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Nemesius Theol.": {
        "tlg_id": "TLG0743",
        "names": {"name_authtab": "Nemesius Theol.", "name_idt": "Nemesius Theol."},
        "works": {"": ["De natura hominis", "Section", "line"]},
    },
    "Dioscurides Hist.": {
        "tlg_id": "TLG2409",
        "names": {"name_authtab": "Dioscurides Hist.", "name_idt": "Dioscurides Hist."},
        "works": {
            "Fragmentum": ["FGrH fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Julianus Imperator Phil.": {
        "tlg_id": "TLG2003",
        "names": {
            "name_authtab": "Flavius Claudius Julianus Imperator Phil., Julian the Apostate",
            "name_idt": "Julianus Imperator Phil.",
        },
        "works": {
            "+$*)AQHNAI/WN TH=| BOULH=| KAI\\ TW=| DH/MW|&": ["Section", "line"],
            "$*QEMISTI/W| FILOSO/FW|&": ["Section", "line"],
            "3$*)EGKW/MION EI)S TO\\N AU)TOKRA/TORA *KWNSTA/NTION&": [
                "Section",
                "line",
            ],
            "1$*EI)S TO\\N BASILE/A *(/HLION PRO\\S *SALOU/STION&": ["Section", "line"],
            "Epistulae dubiae": ["Epistle", "line"],
            "Poematia et fragmenta": ["Fragment", "line"],
            "Fragmentum": ["line"],
            "/Misopogon (sc.$ *)ANTIOXIKO\\S H)\\ *MISOPW/GWN&)": ["Section", "line"],
            "Contra Galilaeos": ["Page", "line"],
            "": ["Epistulae spuriae", "Epistle", "line"],
            "R$*)EPI\\ TH=| E)CO/DW| TOU= A)GAQWTA/TOU *SALOUSTI/OU PARAMUQHTIKO\\S EI)S E(AUTO/N&": [
                "Section",
                "line",
            ],
            "$*EI)S TH\\N MHTE/RA TW=N QEW=N&": ["Section", "line"],
            "Testimonia": ["line", "fragment", "line"],
            '"$*EI)S TOU\\S A)PAIDEU/TOUS KU/NAS&': ["Section", "line"],
            "Epistulae": ["Epistle", "line"],
            "($*EU)SEBI/AS TH=S BASILI/DOS E)GKW/MION&": ["Section", "line"],
            "?$*PERI\\ TW=N TOU= AU)TOKRA/TOROS PRA/CEWN H)\\ PERI\\ BASILEI/AS&": [
                "Section",
                "line",
            ],
            "($*SUMPO/SION H)\\ *KRO/NIA &sive Caesares": ["Section", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "g$*PRO\\S *(HRA/KLEION KUNIKO\\N PERI\\ TOU= PW=S KUNISTE/ON KAI\\ EI) PRE/PEI TW=| KUNI\\ MU/QOUS PLA/TTEIN&": [
                "Section",
                "line",
            ],
        },
    },
    "Moschus Bucol.": {
        "tlg_id": "TLG0035",
        "names": {"name_authtab": "Moschus Bucol.", "name_idt": "Moschus Bucol."},
        "works": {
            "Megara [Sp.]": ["line"],
            "Epitaphius Bionis [Sp.]": ["line"],
            "Europa": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Eros drapeta": ["line"],
        },
    },
    "Severus Iatrosophista Med.": {
        "tlg_id": "TLG0748",
        "names": {
            "name_authtab": "Severus Iatrosophista Med.",
            "name_idt": "Severus Iatrosophista Med.",
        },
        "works": {
            "7De instrumentis infusoriis seu clysteribus ad Timotheum": ["Page", "line"]
        },
    },
    "Timaeus Praxidas Astrol.": {
        "tlg_id": "TLG1105",
        "names": {
            "name_authtab": "Timaeus Praxidas Astrol.",
            "name_idt": "Timaeus Praxidas Astrol.",
        },
        "works": {"Fragmentum": ["Volume", "page", "line"]},
    },
    "Martyrium Agapae, Irenae, Chionae Et Sodalium": {
        "tlg_id": "TLG2011",
        "names": {
            "name_authtab": "Martyrium Agapae, Irenae, Chionae Et Sodalium",
            "name_idt": "Martyrium Agapae, Irenae, Chionae Et Sodalium",
        },
        "works": {
            "-Martyrium Agapae, Irenae, Chionae et sodalium": [
                "Chapter",
                "section",
                "line",
            ]
        },
    },
    "Xanthus Hist.": {
        "tlg_id": "TLG1751",
        "names": {"name_authtab": "Xanthus Hist.", "name_idt": "Xanthus Hist."},
        "works": {
            "Fragmentum": ["FGrH fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Damianus Scriptor De Opticis": {
        "tlg_id": "TLG2627",
        "names": {
            "name_authtab": "Damianus Scriptor De Opticis",
            "name_idt": "Damianus Scriptor De Opticis",
        },
        "works": {"Optica": ["Section", "line"]},
    },
    "Timolaus Rhet.": {
        "tlg_id": "TLG2697",
        "names": {"name_authtab": "Timolaus Rhet.", "name_idt": "Timolaus Rhet."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Fragmenta Anonyma (PsVTGr)": {
        "tlg_id": "TLG1817",
        "names": {
            "name_authtab": "Fragmenta Anonyma (PsVTGr)",
            "name_idt": "Fragmenta Anonyma (PsVTGr)",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Ptolemaeus Math.": {
        "tlg_id": "TLG0363",
        "names": {
            "name_authtab": "Claudius Ptolemaeus Math.",
            "name_idt": "Ptolemaeus Math.",
        },
        "works": {
            "": ["Inscriptio Canobi", "Volume", "page", "line"],
            "Hypotheses": ["Volume", "page", "line"],
            "Geographia (lib. 4-8)": ["Book", "chapter", "section", "line"],
            "Phaseis": ["Volume", "page", "line"],
            "Syntaxis mathematica": ["Volume", "page", "line"],
            "Geographia (lib. 1-3)": ["Book", "chapter", "section", "line"],
            "Apotelesmatica (%6 Tetrabiblos)": ["Book", "chapter", "section", "line"],
            "*De judicandi facultate et animi principatu": ["Volume", "page", "line"],
            "De analemmate": ["Volume", "page", "line"],
            "0$*PROXEI/RWN KANO/NWN DIA/TACIS KAI\\ YHFOFORI/A&": [
                "Volume",
                "page",
                "line",
            ],
            "Fragmenta": ["Fragment", "line"],
            "Harmonica": ["Chapter", "section", "line"],
            "Musica": ["Section", "line"],
        },
    },
    "Stephanus Alchem.": {
        "tlg_id": "TLG9021",
        "names": {"name_authtab": "Stephanus Alchem.", "name_idt": "Stephanus Alchem."},
        "works": {
            "CDe magna et sacra arte (sub nomine Stephani Alexandrini philosophi)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Autocharis Hist.": {
        "tlg_id": "TLG2175",
        "names": {"name_authtab": "Autocharis Hist.", "name_idt": "Autocharis Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Scholia In Clementem Alexandrinum": {
        "tlg_id": "TLG5048",
        "names": {
            "name_authtab": "Scholia In Clementem Alexandrinum",
            "name_idt": "Scholia In Clementem Alexandrinum",
        },
        "works": {
            "TScholia in protrepticum et paedagogum (scholia recentiora partim sub auctore Aretha)": [
                "Page",
                "line",
            ]
        },
    },
    "Moschion Trag.": {
        "tlg_id": "TLG0339",
        "names": {"name_authtab": "Moschion Trag.", "name_idt": "Moschion Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pindarus Lyr.": {
        "tlg_id": "TLG0033",
        "names": {"name_authtab": "Pindarus Lyr.", "name_idt": "Pindarus Lyr."},
        "works": {
            "Olympia": ["Ode", "line"],
            "Nemea": ["Ode", "line", "³", "\x12\x13o\x13´"],
            "Isthmia": ["Ode", "line"],
            "Fragmenta": ["Type of poem", "fragment", "line"],
            "Pythia": ["Ode", "line"],
        },
    },
    "Chilonis Epistula": {
        "tlg_id": "TLG0386",
        "names": {"name_authtab": "Chilonis Epistula", "name_idt": "Chilonis Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Aeschines Socraticus Phil.": {
        "tlg_id": "TLG0673",
        "names": {
            "name_authtab": "Aeschines Socraticus Phil.",
            "name_idt": "Aeschines Socraticus Phil.",
        },
        "works": {"Fragmenta": ["Fragment", "subfragment", "line"]},
    },
    "Monimus Phil.": {
        "tlg_id": "TLG2968",
        "names": {"name_authtab": "Monimus Phil.", "name_idt": "Monimus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diodorus Rhet.": {
        "tlg_id": "TLG1318",
        "names": {"name_authtab": "Diodorus Rhet.", "name_idt": "Diodorus Rhet."},
        "works": {"Fragmentum de viris duobus": ["Page", "line"]},
    },
    "Theognis Trag.": {
        "tlg_id": "TLG0313",
        "names": {"name_authtab": "Theognis Trag.", "name_idt": "Theognis Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Acta Thomae": {
        "tlg_id": "TLG2038",
        "names": {"name_authtab": "Acta Thomae", "name_idt": "Acta Thomae"},
        "works": {
            "Actorum Thomae consummatio": ["Page", "line"],
            "Acta Thomae (recensio)": ["Section", "line"],
            "2Carmen animae (De margarita) (paraphrasis Nicetae)": ["line"],
            ";Carmen animae (De margarita) (cod. Rom. vallicellanus B 35)": ["line"],
            "Acta Thomae": ["Section", "line"],
        },
    },
    "Gregorius Paroemiogr.": {
        "tlg_id": "TLG9006",
        "names": {
            "name_authtab": "Gregorius Paroemiogr.",
            "name_idt": "Gregorius Paroemiogr.",
        },
        "works": {
            "Paroemiae (e cod. Vat.)": ["Centuria", "section", "line"],
            "Paroemiae": ["Centuria", "section", "line"],
            "Paroemiae (e cod. Mosq.)": ["Centuria", "section", "line"],
            "Paroemiae (e cod. Leidense)": ["Centuria", "section", "line"],
        },
    },
    "Eubulus Comic.": {
        "tlg_id": "TLG0458",
        "names": {"name_authtab": "Eubulus Comic.", "name_idt": "Eubulus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Pigres Eleg.": {
        "tlg_id": "TLG0258",
        "names": {"name_authtab": "Pigres Eleg.", "name_idt": "Pigres Eleg."},
        "works": {"Fragmentum": ["line"]},
    },
    "Alexis Hist.": {
        "tlg_id": "TLG0707",
        "names": {"name_authtab": "Alexis Hist.", "name_idt": "Alexis Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diodorus Scr. Eccl.": {
        "tlg_id": "TLG4134",
        "names": {
            "name_authtab": "Diodorus Scr. Eccl.",
            "name_idt": "Diodorus Scr. Eccl.",
        },
        "works": {".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"]},
    },
    "Tatianus Apol.": {
        "tlg_id": "TLG1766",
        "names": {"name_authtab": "Tatianus Apol.", "name_idt": "Tatianus Apol."},
        "works": {
            "": ["Oratio ad Graecos", "Chapter", "section", "line"],
            "Diatesseron": ["line"],
        },
    },
    "Musaeus Grammaticus Epic.": {
        "tlg_id": "TLG4082",
        "names": {
            "name_authtab": "Musaeus Grammaticus Epic.",
            "name_idt": "Musaeus Grammaticus Epic.",
        },
        "works": {"Hero et Leander": ["line"]},
    },
    "Acilius Hist., Phil.": {
        "tlg_id": "TLG2545",
        "names": {
            "name_authtab": "Gaius Acilius Hist. et Phil.",
            "name_idt": "Acilius Hist., Phil.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Martyrium Et Ascensio Isaiae": {
        "tlg_id": "TLG1483",
        "names": {
            "name_authtab": "Martyrium Et Ascensio Isaiae",
            "name_idt": "Martyrium Et Ascensio Isaiae",
        },
        "works": {"Fragmenta": ["Chapter", "section", "line"]},
    },
    "Sophocles Trag.": {
        "tlg_id": "TLG0011",
        "names": {"name_authtab": "Sophocles Trag.", "name_idt": "Sophocles Trag."},
        "works": {
            "Oedipus tyrannus": ["line"],
            "Trachiniae": ["line"],
            "Electra": ["line"],
            "Philoctetes": ["line"],
            "Antigone": ["line"],
            "Ajax": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Oedipus Coloneus": ["line"],
        },
    },
    "Dioscorus Poeta": {
        "tlg_id": "TLG2121",
        "names": {"name_authtab": "Dioscorus Poeta", "name_idt": "Dioscorus Poeta"},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Arcesilai Epistula": {
        "tlg_id": "TLG0038",
        "names": {
            "name_authtab": "Arcesilai Epistula",
            "name_idt": "Arcesilai Epistula",
        },
        "works": {"Epistula": ["line"]},
    },
    "Cinesias Lyr.": {
        "tlg_id": "TLG0375",
        "names": {"name_authtab": "Cinesias Lyr.", "name_idt": "Cinesias Lyr."},
        "works": {"Fragmentum": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Nicomachus Comic.": {
        "tlg_id": "TLG0482",
        "names": {"name_authtab": "Nicomachus Comic.", "name_idt": "Nicomachus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Acta Scillitanorum Martyrum": {
        "tlg_id": "TLG0391",
        "names": {
            "name_authtab": "Acta Scillitanorum Martyrum",
            "name_idt": "Acta Scillitanorum Martyrum",
        },
        "works": {
            ";Acta Scillitanorum martyrum sive Passio Sperati et sociorum": [
                "Page",
                "line",
            ]
        },
    },
    "Iliu Persis": {
        "tlg_id": "TLG1445",
        "names": {"name_authtab": "Iliu Persis", "name_idt": "Iliu Persis"},
        "works": {"Iliu persis (fragmenta)": ["Fragment", "line"]},
    },
    "Anna Comnena Hist.": {
        "tlg_id": "TLG2703",
        "names": {
            "name_authtab": "Anna Comnena Hist.",
            "name_idt": "Anna Comnena Hist.",
        },
        "works": {"Alexias": ["Book", "chapter", "section", "line"]},
    },
    "Chionis Epistulae": {
        "tlg_id": "TLG0041",
        "names": {"name_authtab": "Chionis Epistulae", "name_idt": "Chionis Epistulae"},
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Mithridatis Epistula": {
        "tlg_id": "TLG0039",
        "names": {
            "name_authtab": "Mithridatis Epistula",
            "name_idt": "Mithridatis Epistula",
        },
        "works": {"Epistula": ["Section", "line"]},
    },
    "Cercidas Iamb.": {
        "tlg_id": "TLG1250",
        "names": {"name_authtab": "Cercidas Iamb.", "name_idt": "Cercidas Iamb."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Basilius Theol.": {
        "tlg_id": "TLG2040",
        "names": {"name_authtab": "Basilius Theol.", "name_idt": "Basilius Theol."},
        "works": {
            "": ["De spiritu sancto", "Chapter", "section", "line"],
            "Prologus 7 (de judicio dei)": ["Volume", "page", "line"],
            "4Poenae in monachos delinquentes (epitimia 24) [Dub.]": [
                "Volume",
                "page",
                "line",
            ],
            "Epistulae tres": ["Epistle", "line"],
            "(Sermo 12 (de ascetica disciplina) [Dub.]": ["Volume", "page", "line"],
            "3Consolatoria ad aegrotum [Sp.] (sub auctore Proclo)": [
                "Volume",
                "page",
                "line",
            ],
            "Homilia in Psalmum 132 [Sp.]": ["Volume", "page", "line"],
            "3Prologus 3 (prooemium in regulas brevius tractatas)": [
                "Volume",
                "page",
                "line",
            ],
            "#Oratio pro inimicis et amicis [Sp.]": ["Volume", "page", "line"],
            "Homilia in Psalmum 37 [Sp.]": ["Volume", "page", "line"],
            "In ebriosos": ["Volume", "page", "line"],
            "In Gordium martyrem": ["Volume", "page", "line"],
            "In Barlaam martyrem [Sp.]": ["Volume", "page", "line"],
            "Orationes sive Exorcismi [Sp.]": ["Volume", "page", "line"],
            "Homilia de invidia": ["Volume", "page", "line"],
            ":Sermo ob sacerdotum instructionem (recensio brevior) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "=Asceticon magnum sive Quaestiones (regulae brevius tractatae)": [
                "Volume",
                "page",
                "line",
            ],
            "Homiliae in hexaemeron": ["Homily", "section", "line"],
            "#Homilia adversus eos qui irascuntur": ["Volume", "page", "line"],
            "FSermo 11 (sermo asceticus et exhortatio de renuntiatione mundi) [Dub.]": [
                "Volume",
                "page",
                "line",
            ],
            "In sanctam Christi generationem": ["Volume", "page", "line"],
            "De humilitate": ["Volume", "page", "line"],
            "9Sermo ob sacerdotum instructionem (recensio fusior) [Sp.]": [
                "Page",
                "line",
            ],
            "Sermo 14 (De fide) [Sp.]": ["line"],
            "*Epitimia in canonicas (epitimia 25) [Dub.]": ["Volume", "page", "line"],
            "%Prologus 6 (prooemium ad Hypotyposin)": ["line"],
            "#Prologus 5 (sermo asceticus) [Dub.]": ["Volume", "page", "line"],
            "Sermo 16 (De calumnia) [Sp.]": ["line"],
            "In Mamantem martyrem": ["Volume", "page", "line"],
            "$Enarratio in prophetam Isaiam [Dub.]": ["Chapter", "section", "line"],
            "#Homilia in illud: Attende tibi ipsi": ["Page", "line"],
            ":Homilia de paenitentia [Sp.] (sub auctore Eusebio Emeseno)": [
                "Volume",
                "page",
                "line",
            ],
            "In Psalmum 28 (homilia 2) [Sp.]": ["Volume", "page", "line"],
            "De legendis gentilium libris": ["Section", "line"],
            "<Adversus eos qui per calumniam dicunt dici a nobis tres deos": [
                "Volume",
                "page",
                "line",
            ],
            "Homilia in aquas [Sp.]": ["line"],
            "Homilia de gratiarum actione": ["Volume", "page", "line"],
            "(Homilia de misericordia et judicio [Sp.]": ["Volume", "page", "line"],
            "Homilia dicta in Lacisis": ["Volume", "page", "line"],
            "De baptismo libri duo": ["Volume", "page", "line"],
            "'Contra Sabellianos et Arium et Anomoeos": ["Volume", "page", "line"],
            "Homilia in martyrem Julittam": ["Volume", "page", "line"],
            '"Homilia in principium proverbiorum': ["Volume", "page", "line"],
            "%Homilia in illud: Destruam horrea mea": ["Section", "line"],
            "#In quadraginta martyres Sebastenses": ["Volume", "page", "line"],
            ".Sermo 15 (De vita monastica) (excerptum) [Sp.]": ["line"],
            "Homilia in Psalmum 115": ["Volume", "page", "line"],
            ")Homilia dicta tempore famis et siccitatis": ["Volume", "page", "line"],
            "<Asceticon magnum sive Quaestiones (regulae fusius tractatae)": [
                "Volume",
                "page",
                "line",
            ],
            "!Sermo 13 (sermo asceticus) [Dub.]": ["Volume", "page", "line"],
            "Homilia in divites": ["Section", "line"],
            "Epistulae": ["Epistle", "section", "line"],
            "*Prologus 4 (prooemium in asceticum magnum)": ["Volume", "page", "line"],
            '"In illud: In principio erat verbum': ["Volume", "page", "line"],
            "Epitimia (epitimia 26) [Sp.]": ["Volume", "page", "line"],
            "(Homilia exhortatoria ad sanctum baptisma": ["Volume", "page", "line"],
            "Regulae morales": ["Volume", "page", "line"],
            "Adversus Eunomium (libri 5)": ["Volume", "page", "line"],
            "Prologus 8 (de fide)": ["Volume", "page", "line"],
            "%Canon 96 (De haereticis) (fragmentum)": ["Page", "line"],
            "#Liturgia (recensio brevior vetusta)": ["Volume", "page", "line"],
            "Homilia de virginitate [Sp.]": ["Chapter", "section", "line"],
            "Homiliae super Psalmos": ["Volume", "page", "line"],
            "Homilia de spiritu sancto [Sp.]": ["Volume", "page", "line"],
            "5Homilia in illud: Ne dederis somnum oculis tuis [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "De fide": ["Volume", "page", "line"],
            "De jejunio (homilia 1)": ["Volume", "page", "line"],
            "De jejunio (homilia 2)": ["Volume", "page", "line"],
            " Quod deus non est auctor malorum": ["Volume", "page", "line"],
            "2Sermones de moribus a Symeone Metaphrasta collecti": [
                "Volume",
                "page",
                "line",
            ],
            "Sermo de contubernalibus [Sp.]": ["Volume", "page", "line"],
            "'Quod rebus mundanis adhaerendum non sit": ["Volume", "page", "line"],
            "-Sermo 10 (praevia institutio ascetica) [Dub.]": [
                "Volume",
                "page",
                "line",
            ],
            "De jejunio (homilia 3) [Sp.]": ["Volume", "page", "line"],
            "Expositio fidei Nicaenae [Sp.]": ["line"],
            "De spiritu [Sp.]": ["Page", "line"],
            "Constitutiones asceticae [Sp.]": ["Volume", "page", "line"],
        },
    },
    "Spintharus Trag.": {
        "tlg_id": "TLG1846",
        "names": {"name_authtab": "Spintharus Trag.", "name_idt": "Spintharus Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Philiscus Trag.": {
        "tlg_id": "TLG0335",
        "names": {"name_authtab": "Philiscus Trag.", "name_idt": "Philiscus Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Callistratus Trag.": {
        "tlg_id": "TLG1845",
        "names": {
            "name_authtab": "Callistratus Trag.",
            "name_idt": "Callistratus Trag.",
        },
        "works": {"Tituli": ["line"]},
    },
    "Isyllus Lyr.": {
        "tlg_id": "TLG0201",
        "names": {"name_authtab": "Isyllus Lyr.", "name_idt": "Isyllus Lyr."},
        "works": {"Fragmenta (IG 4.950)": ["line"]},
    },
    "Aristodemus Hist., Myth.": {
        "tlg_id": "TLG1875",
        "names": {
            "name_authtab": "Aristodemus Hist. et Myth.",
            "name_idt": "Aristodemus Hist., Myth.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Paulus Astrol.": {
        "tlg_id": "TLG2053",
        "names": {"name_authtab": "Paulus Astrol.", "name_idt": "Paulus Astrol."},
        "works": {
            "Elementa apotelesmatica": ["Page", "line"],
            "Anacephalaeosis": ["Page", "line"],
        },
    },
    "[Alexarchus] Hist.": {
        "tlg_id": "TLG2556",
        "names": {
            "name_authtab": "[Alexarchus] Hist.",
            "name_idt": "[Alexarchus] Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Morsimus Trag.": {
        "tlg_id": "TLG0314",
        "names": {"name_authtab": "Morsimus Trag.", "name_idt": "Morsimus Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "[Chrysippus] Hist.": {
        "tlg_id": "TLG2559",
        "names": {
            "name_authtab": "[Chrysippus] Hist.",
            "name_idt": "[Chrysippus] Hist.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Patrocles Trag.": {
        "tlg_id": "TLG0324",
        "names": {"name_authtab": "Patrocles Trag.", "name_idt": "Patrocles Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Oecumenius Phil., Rhet.": {
        "tlg_id": "TLG2866",
        "names": {
            "name_authtab": "Oecumenius Phil. et Rhet.",
            "name_idt": "Oecumenius Phil., Rhet.",
        },
        "works": {
            "/Fragmenta in epistulam ad Ephesios (in catenis)": ["Page", "line"],
            "3Fragmenta in epistulam i ad Corinthios (in catenis)": ["Page", "line"],
            "2Fragmentum in epistulam ad Philemonem (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Galatas (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "3Fragmenta in epistulam ad Philippenses (in catenis)": ["Page", "line"],
            "2Fragmenta in epistulam i ad Timotheum (in catenis)": ["Page", "line"],
            "Commentarius in Apocalypsin": ["Page", "line"],
            "9Fragmenta in epistulam i ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "3Fragmenta in epistulam ii ad Timotheum (in catenis)": ["Page", "line"],
            ":Fragmenta in epistulam ii ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "4Fragmenta in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            "/Fragmenta in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
            "2Fragmenta in epistulam ad Colossenses (in catenis)": ["Page", "line"],
            ",Fragmenta in epistulam ad Titum (in catenis)": ["Page", "line"],
        },
    },
    "Sphaerus Phil.": {
        "tlg_id": "TLG1693",
        "names": {"name_authtab": "Sphaerus Phil.", "name_idt": "Sphaerus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Neoptolemus Gramm.": {
        "tlg_id": "TLG1526",
        "names": {
            "name_authtab": "Neoptolemus Gramm.",
            "name_idt": "Neoptolemus Gramm.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Bacchylides Lyr.": {
        "tlg_id": "TLG0199",
        "names": {"name_authtab": "Bacchylides Lyr.", "name_idt": "Bacchylides Lyr."},
        "works": {
            "Paeanes (fragmenta)": ["Fragment", "line"],
            "Dithyramborum fragmenta": ["Fragment", "line"],
            "Hymnorum fragmenta": ["Fragment", "line"],
            "Partheneia (titulus solum)": ["line"],
            "Dithyrambi": ["Dithyramb", "line"],
            "Epigrammata": ["Epigram", "line"],
            "Encomia (fragmenta)": ["Fragment", "line"],
            "Fragmenta dubia": ["Fragment", "line"],
            "Erotica (fragmenta)": ["Fragment", "line"],
            "Epinicia": ["Ode", "line"],
            "Hyporchemata (fragmenta)": ["Fragment", "line"],
            "Fragmenta ex operibus incertis": ["Fragment", "line"],
            "Prosodia (fragmenta)": ["Fragment", "line"],
            "Epinicorum fragmenta": ["Fragment", "line"],
        },
    },
    "Christodorus Epic.": {
        "tlg_id": "TLG2119",
        "names": {
            "name_authtab": "Christodorus Epic.",
            "name_idt": "Christodorus Epic.",
        },
        "works": {
            "Fragmentum": ["line", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Testimonium": ["line", "fragment", "line"],
        },
    },
    "Phanodemus Hist.": {
        "tlg_id": "TLG1583",
        "names": {"name_authtab": "Phanodemus Hist.", "name_idt": "Phanodemus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hermippus Gramm., Hist.": {
        "tlg_id": "TLG1421",
        "names": {
            "name_authtab": "Hermippus Gramm. et Hist.",
            "name_idt": "Hermippus Gramm., Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Fragmentum Synodicae Epistulae Concilii Caesariensis": {
        "tlg_id": "TLG1381",
        "names": {
            "name_authtab": "Fragmentum Synodicae Epistulae Concilii Caesariensis",
            "name_idt": "Fragmentum Synodicae Epistulae Concilii Caesariensis",
        },
        "works": {"Fragmentum epistulae": ["Page", "line"]},
    },
    "Timotheus Trag.": {
        "tlg_id": "TLG0467",
        "names": {"name_authtab": "Timotheus Trag.", "name_idt": "Timotheus Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Potamon Hist.": {
        "tlg_id": "TLG1949",
        "names": {"name_authtab": "Potamon Hist.", "name_idt": "Potamon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aeschrion Lyr.": {
        "tlg_id": "TLG0679",
        "names": {"name_authtab": "Aeschrion Lyr.", "name_idt": "Aeschrion Lyr."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta et tituli": ["Fragment", "line"],
        },
    },
    "Astydamas Trag.": {
        "tlg_id": "TLG0325",
        "names": {"name_authtab": "Astydamas Trag.", "name_idt": "Astydamas Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scholia In Pausaniam": {
        "tlg_id": "TLG5033",
        "names": {
            "name_authtab": "Scholia In Pausaniam",
            "name_idt": "Scholia In Pausaniam",
        },
        "works": {
            "DScholia in Pausaniae periegesin (scholia vetera sub auctore Agathia)": [
                "\x1ePausanias book+chapter+section",
                "line",
            ]
        },
    },
    "Andron Hist.": {
        "tlg_id": "TLG2172",
        "names": {"name_authtab": "Andron Hist.", "name_idt": "Andron Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Stephanus Comic.": {
        "tlg_id": "TLG0506",
        "names": {"name_authtab": "Stephanus Comic.", "name_idt": "Stephanus Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Ariston Phil.": {
        "tlg_id": "TLG1192",
        "names": {"name_authtab": "Ariston Phil.", "name_idt": "Ariston Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Epicurus Phil.": {
        "tlg_id": "TLG0537",
        "names": {"name_authtab": "Epicurus Phil.", "name_idt": "Epicurus Phil."},
        "works": {
            "Ratae sententiae": ["Section", "line"],
            "Deperditorum librorum reliquiae": ["Fragment", "section", "line"],
            "Incertae sedis fragmenta": ["Fragment", "line"],
            "Epistularum fragmenta": ["Fragment", "line"],
            "Epistula ad Pythoclem": ["Section", "line"],
            "Epistula ad Herodotum": ["Section", "line"],
            "Epistula ad Menoeceum": ["Section", "line"],
            "Gnomologium Vaticanum Epicureum": ["Fragment", "line"],
        },
    },
    "Marcellinus Biogr.": {
        "tlg_id": "TLG2585",
        "names": {
            "name_authtab": "Marcellinus Biogr.",
            "name_idt": "Marcellinus Biogr.",
        },
        "works": {"Vita Thucydidis": ["Section", "line"]},
    },
    "Polyclitus Phil.": {
        "tlg_id": "TLG1625",
        "names": {"name_authtab": "Polyclitus Phil.", "name_idt": "Polyclitus Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Marinus Phil.": {
        "tlg_id": "TLG4075",
        "names": {"name_authtab": "Marinus Phil.", "name_idt": "Marinus Phil."},
        "works": {"Commentarium in Euclidis data": ["Page", "line"]},
    },
    "Timesitheus Trag.": {
        "tlg_id": "TLG0889",
        "names": {"name_authtab": "Timesitheus Trag.", "name_idt": "Timesitheus Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Aristippus Hist.": {
        "tlg_id": "TLG2216",
        "names": {"name_authtab": "Aristippus Hist.", "name_idt": "Aristippus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sodamus Eleg.": {
        "tlg_id": "TLG1680",
        "names": {"name_authtab": "Sodamus Eleg.", "name_idt": "Sodamus Eleg."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Nicephorus Bryennius Hist.": {
        "tlg_id": "TLG3088",
        "names": {
            "name_authtab": "Nicephorus Bryennius Hist.",
            "name_idt": "Nicephorus Bryennius Hist.",
        },
        "works": {"Historiae": ["Book", "section", "line"]},
    },
    "Corinna Lyr.": {
        "tlg_id": "TLG0294",
        "names": {"name_authtab": "Corinna Lyr.", "name_idt": "Corinna Lyr."},
        "works": {"Fragmenta": ["Fragment", "\x15column or subfragment", "line"]},
    },
    "Polyphrasmon Trag.": {
        "tlg_id": "TLG1839",
        "names": {
            "name_authtab": "Polyphrasmon Trag.",
            "name_idt": "Polyphrasmon Trag.",
        },
        "works": {"Tituli": ["line"]},
    },
    "Diodorus Perieg.": {
        "tlg_id": "TLG2265",
        "names": {"name_authtab": "Diodorus Perieg.", "name_idt": "Diodorus Perieg."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Synesius Alchem.": {
        "tlg_id": "TLG4324",
        "names": {"name_authtab": "Synesius Alchem.", "name_idt": "Synesius Alchem."},
        "works": {
            "q$*SUNESI/OU FILOSO/FOU PRO\\S *DIO/SKORON EI)S TH\\N BI/BLON *DHMOKRI/TOU, W(S E)N SXOLI/OIS &(e cod. Venet. Marc. ": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Epistula Ecclesiarum Apud Lugdunum Et Viennam": {
        "tlg_id": "TLG1352",
        "names": {
            "name_authtab": "Epistula Ecclesiarum Apud Lugdunum Et Viennam",
            "name_idt": "Epistula Ecclesiarum Apud Lugdunum Et Viennam",
        },
        "works": {
            "-Epistula ecclesiarum apud Lugdunum et Viennam": [
                "Chapter",
                "section",
                "line",
            ]
        },
    },
    "Dionysius Areopagita Scr. Eccl., Theol.": {
        "tlg_id": "TLG2798",
        "names": {
            "name_authtab": "Pseudo-Dionysius Areopagita Scr. Eccl. et Theol.",
            "name_idt": "Dionysius Areopagita Scr. Eccl., Theol.",
        },
        "works": {
            "Epistulae": ["Epistle", "section", "line"],
            "De divinis nominibus": ["Page", "line"],
            "De mystica theologia": ["Page", "line"],
            "De ecclesiastica hierarchia": ["Page", "line"],
            "De caelesti hierarchia": ["Page", "line"],
        },
    },
    "Hermias Phil.": {
        "tlg_id": "TLG2317",
        "names": {"name_authtab": "Hermias Phil.", "name_idt": "Hermias Phil."},
        "works": {"In Platonis Phaedrum scholia": ["Page", "line"]},
    },
    "Agatharchides Geogr.": {
        "tlg_id": "TLG0067",
        "names": {
            "name_authtab": "Agatharchides Geogr.",
            "name_idt": "Agatharchides Geogr.",
        },
        "works": {
            "Fragmenta sedis incertae": ["Fragment", "line"],
            "De mari Erythraeo (excerpta)": ["Section", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
        },
    },
    "Axionicus Comic.": {
        "tlg_id": "TLG0424",
        "names": {"name_authtab": "Axionicus Comic.", "name_idt": "Axionicus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Lepidus Hist.": {
        "tlg_id": "TLG1459",
        "names": {"name_authtab": "Lepidus Hist.", "name_idt": "Lepidus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Eudromus Phil.": {
        "tlg_id": "TLG2399",
        "names": {"name_authtab": "Eudromus Phil.", "name_idt": "Eudromus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Nicolaus Comic.": {
        "tlg_id": "TLG0481",
        "names": {"name_authtab": "Nicolaus Comic.", "name_idt": "Nicolaus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Posidonius Phil.": {
        "tlg_id": "TLG1052",
        "names": {"name_authtab": "Posidonius Phil.", "name_idt": "Posidonius Phil."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Timocreon Lyr.": {
        "tlg_id": "TLG0265",
        "names": {"name_authtab": "Timocreon Lyr.", "name_idt": "Timocreon Lyr."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Alcidamas Rhet.": {
        "tlg_id": "TLG0610",
        "names": {"name_authtab": "Alcidamas Rhet.", "name_idt": "Alcidamas Rhet."},
        "works": {"Fragmenta": ["Fragment", "section", "line"]},
    },
    "Scholia In Euripidem": {
        "tlg_id": "TLG5023",
        "names": {
            "name_authtab": "Scholia In Euripidem",
            "name_idt": "Scholia In Euripidem",
        },
        "works": {
            "AGlossae codicis Vaticani 909 in Euripidis Rhesum (scholia vetera)": [
                "Section",
                "line",
            ],
            ".Glossae in Euripidis Troiades (scholia vetera)": ["Section", "line"],
            "6Glossae codicis C in Euripidis Rhesum (scholia vetera)": [
                "Section",
                "line",
            ],
            "%Scholia in Euripidem (scholia vetera)": [
                "Vita-argumentum-scholion",
                "section",
                "line",
            ],
            "=Scholia in Euripidem (cod. Hierosolymitanus patriarchalis 36)": [
                "Play",
                "verse",
                "line",
            ],
        },
    },
    "Sophilus Comic.": {
        "tlg_id": "TLG0502",
        "names": {"name_authtab": "Sophilus Comic.", "name_idt": "Sophilus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Archedicus Comic.": {
        "tlg_id": "TLG0416",
        "names": {"name_authtab": "Archedicus Comic.", "name_idt": "Archedicus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Theodotus Judaeus Epic.": {
        "tlg_id": "TLG1720",
        "names": {
            "name_authtab": "Theodotus Judaeus Epic.",
            "name_idt": "Theodotus Judaeus Epic.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aglaïs Poet. Med.": {
        "tlg_id": "TLG0676",
        "names": {"name_authtab": "Aglaïs Poet. Med.", "name_idt": "Aglaïs Poet. Med."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            " Adversus suffusiones incipientes": ["line"],
        },
    },
    "Troilus Soph.": {
        "tlg_id": "TLG2127",
        "names": {"name_authtab": "Troilus Soph.", "name_idt": "Troilus Soph."},
        "works": {
            "%Epigramma (auctore Troilo Grammatico)": ["Book", "epigram", "line"],
            "*Prolegomena in Hermogenis artem rhetoricam": ["Page", "line"],
        },
    },
    "Magica": {
        "tlg_id": "TLG5002",
        "names": {"name_authtab": "Magica", "name_idt": "Magica"},
        "works": {
            "Papyri magicae": ["Preisendanz number", "line"],
            "Papyri magicae (tabulae)": ["Preisendanz number", "line"],
            "Papyri magicae (ostraca)": ["Preisendanz number", "line"],
            "%Papyri magicae (fragmenta Christiana)": ["Preisendanz number", "line"],
        },
    },
    "Hellanicus Hist.": {
        "tlg_id": "TLG0539",
        "names": {"name_authtab": "Hellanicus Hist.", "name_idt": "Hellanicus Hist."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Fragmentum (P. Oxy. 26.2442)": ["FGrH fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Anonymi Paradoxographi": {
        "tlg_id": "TLG4037",
        "names": {
            "name_authtab": "Anonymi Paradoxographi",
            "name_idt": "Anonymi Paradoxographi",
        },
        "works": {
            "De Cleobi et Bitone": ["line"],
            "De fratribus amicis": ["line"],
            "%De incredibilibus (excerpta Vaticana)": ["Section", "line"],
            "De amicis": ["line"],
            "De transformationibus": ["Page", "line"],
            "Tractatus de mulieribus": ["Section", "line"],
            "7$*TI/NES OI)=KOI A)NA/STATOI DIA\\ GUNAI=KAS E)GE/NONTO&": ["line"],
            "De impiis": ["Page", "line"],
        },
    },
    "Heraclides Phil.": {
        "tlg_id": "TLG1954",
        "names": {"name_authtab": "Heraclides Phil.", "name_idt": "Heraclides Phil."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Demetrius Trag.": {
        "tlg_id": "TLG1849",
        "names": {"name_authtab": "Demetrius Trag.", "name_idt": "Demetrius Trag."},
        "works": {"Titulus (%7 dramatis personae)": ["line"]},
    },
    "Claudius Casilon Gramm.": {
        "tlg_id": "TLG4305",
        "names": {
            "name_authtab": "Claudius Casilon Gramm.",
            "name_idt": "Claudius Casilon Gramm.",
        },
        "works": {
            "o$*PARA\\ TOI=S *)ATTIKOI=S R(H/TORSI ZHTOU/MENA &(fragmentum) (e cod. Paris. suppl. gr. 1164 [olim cod. Athon.])": [
                "Page",
                "line",
            ]
        },
    },
    "Nicophon Comic.": {
        "tlg_id": "TLG0483",
        "names": {"name_authtab": "Nicophon Comic.", "name_idt": "Nicophon Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Aristombrotus Phil.": {
        "tlg_id": "TLG1191",
        "names": {
            "name_authtab": "Aristombrotus Phil.",
            "name_idt": "Aristombrotus Phil.",
        },
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Platonius Gramm.": {
        "tlg_id": "TLG1615",
        "names": {"name_authtab": "Platonius Gramm.", "name_idt": "Platonius Gramm."},
        "works": {"Fragmenta de comoedia Graeca": ["line"]},
    },
    "Ptolemaeus Gramm.": {
        "tlg_id": "TLG1643",
        "names": {"name_authtab": "Ptolemaeus Gramm.", "name_idt": "Ptolemaeus Gramm."},
        "works": {
            "lDe differentia vocabulorum (%6 $*PERI\\ DIAFORA=S LE/CEWN KATA\\ STOIXEI=ON&) [Sp.] (e cod. Ambros. E 26 sup.)": [
                "",
                "Alphabetic letter",
                "entry",
                "line",
            ],
            "jDe differentia vocabulorum (%6 $*PERI\\ DIAFORA=S LE/CEWN&) [Sp.] (e codd. Ottobon. gr. 43 %7 Vat. gr. 197)": [
                "Page",
                "line",
            ],
        },
    },
    "Theophilus Protospatharius et Stephanus Atheniensis Med.": {
        "tlg_id": "TLG0746",
        "names": {
            "name_authtab": "Theophilus Protospatharius et Stephanus Atheniensis Med.",
            "name_idt": "Theophilus Protospatharius et Stephanus Atheniensis Med.",
        },
        "works": {"De febrium differentia": ["Page", "line"]},
    },
    "Polycrates Hist.": {
        "tlg_id": "TLG1627",
        "names": {"name_authtab": "Polycrates Hist.", "name_idt": "Polycrates Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Thales Phil.": {
        "tlg_id": "TLG1705",
        "names": {"name_authtab": "Thales Phil.", "name_idt": "Thales Phil."},
        "works": {
            "Epistulae": ["Epistle", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Sapphus vel Alcaei Fragmenta": {
        "tlg_id": "TLG0387",
        "names": {
            "name_authtab": "Sapphus vel Alcaei Fragmenta",
            "name_idt": "Sapphus vel Alcaei Fragmenta",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scolia Alphabetica": {
        "tlg_id": "TLG0273",
        "names": {
            "name_authtab": "Scolia Alphabetica",
            "name_idt": "Scolia Alphabetica",
        },
        "works": {
            "Fragmenta (P. Oxy. 15.1795)": ["Column", "fragment", "line"],
            "Fragmenta (P. Oxy. 1.15)": ["Column", "line"],
        },
    },
    "Anonymi In Aristotelis Ethica Nicomachea Phil.": {
        "tlg_id": "TLG4033",
        "names": {
            "name_authtab": "Anonymi In Aristotelis Ethica Nicomachea Phil.",
            "name_idt": "Anonymi In Aristotelis Ethica Nicomachea Phil.",
        },
        "works": {
            "$In ethica Nicomachea vii commentaria": ["Page", "line"],
            "qIn ethica Nicomachea paraphrasis (pseudepigraphum olim a Constantino Palaeocappa confectum et olim sub auctore He": [
                "Page",
                "line",
            ],
            "%In ethica Nicomachea ii-v commentaria": ["Page", "line"],
        },
    },
    "Epimenides Phil.": {
        "tlg_id": "TLG1347",
        "names": {"name_authtab": "Epimenides Phil.", "name_idt": "Epimenides Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmentum (P. Oxy. 26.2442)": ["FGrH fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Justinus Martyr": {
        "tlg_id": "TLG0646",
        "names": {
            "name_authtab": "Pseudo-Justinus Martyr",
            "name_idt": "Justinus Martyr",
        },
        "works": {
            "Epistula ad Zenam et Serenum": ["Morel page", "section", "line"],
            "%Quaestiones Christianorum ad gentiles": ["Morel page", "section", "line"],
            "De resurrectione": ["Morel page", "section", "line"],
            ")Quaestiones et responsiones ad orthodoxos": [
                "Morel page",
                "section",
                "line",
            ],
            "Expositio rectae fidei": ["Morel page", "section", "line"],
            "De monarchia": ["Morel page", "section", "line"],
            "-Confutatio dogmatum quorundam Aristotelicorum": [
                "Morel page",
                "section",
                "line",
            ],
            "Oratio ad gentiles": ["Morel page", "section", "line"],
            "$Quaestiones gentilium ad Christianos": ["Morel page", "section", "line"],
            "Epistula ad Diognetum": ["Morel page", "section", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Cohortatio ad gentiles": ["Morel page", "section", "line"],
        },
    },
    "Crinis Phil.": {
        "tlg_id": "TLG1293",
        "names": {"name_authtab": "Crinis Phil.", "name_idt": "Crinis Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scholia in Maximum Confessorem": {
        "tlg_id": "TLG5052",
        "names": {
            "name_authtab": "Scholia in Maximum Confessorem",
            "name_idt": "Scholia in Maximum Confessorem",
        },
        "works": {"Scholia": ["Section", "line"]},
    },
    "Androetas Hist.": {
        "tlg_id": "TLG2412",
        "names": {"name_authtab": "Androetas Hist.", "name_idt": "Androetas Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Serapion Trag.": {
        "tlg_id": "TLG0347",
        "names": {"name_authtab": "Serapion Trag.", "name_idt": "Serapion Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Anonymi In Aristotelis Artem Rhetoricam Rhet.": {
        "tlg_id": "TLG4026",
        "names": {
            "name_authtab": "Anonymi In Aristotelis Artem Rhetoricam Rhet.",
            "name_idt": "Anonymi In Aristotelis Artem Rhetoricam Rhet.",
        },
        "works": {
            "/Fragmentum commentarii in Aristotelis rhetorica": ["Page", "line"],
            ",In Aristotelis artem rhetoricam commentarium": ["Page", "line"],
            "/Fragmentum paraphrasis in Aristotelis rhetorica": ["Page", "line"],
        },
    },
    "Anaximenis Milesii Epistulae": {
        "tlg_id": "TLG1121",
        "names": {
            "name_authtab": "Anaximenis Milesii Epistulae",
            "name_idt": "Anaximenis Milesii Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Demochares Hist., Orat.": {
        "tlg_id": "TLG1303",
        "names": {
            "name_authtab": "Demochares Hist. et Orat.",
            "name_idt": "Demochares Hist., Orat.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Ariston Apol.": {
        "tlg_id": "TLG1992",
        "names": {"name_authtab": "Ariston Apol.", "name_idt": "Ariston Apol."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Erotica Adespota": {
        "tlg_id": "TLG5003",
        "names": {"name_authtab": "Erotica Adespota", "name_idt": "Erotica Adespota"},
        "works": {
            "Apollonius (PSI 2.151)": ["line"],
            "Sesonchosis (P. Oxy 15.1826)": ["Recto-verso", "line"],
            "Fragmentum (P. Oxy. 3.416)": ["line"],
            "Calligone (PSI 8.981)": ["line"],
            ">Metiochus et Parthenope (P. Berol. inv. 7927 %7 9588 %7 21179)": [
                "Column",
                "line",
            ],
            "0Tefnut (P. Lit. Lond. 192 [Brit. Mus. inv. 274])": [
                "Fragment",
                "column",
                "line",
            ],
            " Apollonius (P. Mil. Vogl. 6.260)": ["line"],
            "<Fragmentum (fort. auctore Antonio Diogene) (P. Mich. inv. 5)": ["line"],
            "<Chione (fort. auctore Charitone) (codex Thebanus deperditus)": [
                "Column",
                "line",
            ],
            "Theano (P. Oxy 3.417)": ["Column", "line"],
            "4Antheia (fort. epitome operis Ephesiaca) (PSI 6.726)": ["Column", "line"],
            "Fragmenta (P. Michael. 4)": ["Column", "line"],
            ")Metiochus et Parthenope (O. Bodl. 2.2175)": ["line"],
            "Staphylus (PSI 11.1220)": ["Column", "line"],
            "Sesonchosis (P. Oxy. 47.3319)": ["Column", "line"],
            "Sesonchosis (P. Oxy. 27.2466)": ["line"],
            ".Tinouphis (P. Turner 8 [%6 P. Haun. inv. 400])": ["line"],
            "Daulis (P. Berol. inv. 11517)": ["Column", "line"],
            "Fragmentum (P. Ant. 1.18)": ["line"],
            "Fragmentum (PSI inv. 516)": ["Column", "line"],
            "IFragmenta (fort. pars operis Chione vel Ninus) (P. Berol. 10535 %7 21234)": [
                "Papyrus",
                "column",
                "line",
            ],
            "+Metiochus et Parthenope (?) (P. Oxy. 3.435)": ["Column", "line"],
            "Fragmentum (P. Mich. inv. 3378)": ["line"],
            "Iolaus (P. Oxy. 42.3010)": ["line"],
            "Fragmentum (PSI 3.725)": ["line"],
        },
    },
    "Nicander Epic.": {
        "tlg_id": "TLG0022",
        "names": {"name_authtab": "Nicander Epic.", "name_idt": "Nicander Epic."},
        "works": {
            "Alexipharmaca": ["line"],
            "Theriaca": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Hippias Soph.": {
        "tlg_id": "TLG1434",
        "names": {"name_authtab": "Hippias Soph.", "name_idt": "Hippias Soph."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Cantus Lugubris": {
        "tlg_id": "TLG0276",
        "names": {"name_authtab": "Cantus Lugubris", "name_idt": "Cantus Lugubris"},
        "works": {"!Fragmentum (Brit. Mus. inv. 2103)": ["line"]},
    },
    "Agaclytus Hist.": {
        "tlg_id": "TLG0687",
        "names": {"name_authtab": "Agaclytus Hist.", "name_idt": "Agaclytus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Constitutiones Apostolorum": {
        "tlg_id": "TLG2894",
        "names": {
            "name_authtab": "Constitutiones Apostolorum",
            "name_idt": "Constitutiones Apostolorum",
        },
        "works": {
            "=Constitutiones apostolorum (fort. compilatore Juliano Ariano)": [
                "Book",
                "chapter",
                "line",
            ]
        },
    },
    "Nostoi": {
        "tlg_id": "TLG1541",
        "names": {"name_authtab": "Nostoi", "name_idt": "Nostoi"},
        "works": {"Nostoi (fragmenta)": ["Fragment", "line"]},
    },
    "Alexander Polyhist.": {
        "tlg_id": "TLG0697",
        "names": {
            "name_authtab": "Cornelius Alexander Polyhist.",
            "name_idt": "Alexander Polyhist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Metopus Phil.": {
        "tlg_id": "TLG1507",
        "names": {"name_authtab": "Metopus Phil.", "name_idt": "Metopus Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Satyrus Hist.": {
        "tlg_id": "TLG1661",
        "names": {"name_authtab": "Satyrus Hist.", "name_idt": "Satyrus Hist."},
        "works": {
            "Fragmentum (P. Oxy. 27.2465)": [
                "(FGrH fragment+papyrus fragment or column",
                "line",
            ]
        },
    },
    "Demades Orat., Rhet.": {
        "tlg_id": "TLG0535",
        "names": {
            "name_authtab": "Demades Orat. et Rhet.",
            "name_idt": "Demades Orat., Rhet.",
        },
        "works": {
            "Fragmentum": ["line", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Testimonium": ["line", "fragment", "line"],
        },
    },
    "Apollonius Comic.": {
        "tlg_id": "TLG0394",
        "names": {"name_authtab": "Apollonius Comic.", "name_idt": "Apollonius Comic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Clinias Phil.": {
        "tlg_id": "TLG1277",
        "names": {"name_authtab": "Clinias Phil.", "name_idt": "Clinias Phil."},
        "works": {"Fragmenta": ["Page", "line"], "Testimonia": ["Fragment", "line"]},
    },
    "Eumedes Comic.": {
        "tlg_id": "TLG1361",
        "names": {"name_authtab": "Eumedes Comic.", "name_idt": "Eumedes Comic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Atridarum Reditus": {
        "tlg_id": "TLG1212",
        "names": {"name_authtab": "Atridarum Reditus", "name_idt": "Atridarum Reditus"},
        "works": {"Fragmentum": ["line"]},
    },
    "Phrynichus Trag.": {
        "tlg_id": "TLG0303",
        "names": {"name_authtab": "Phrynichus Trag.", "name_idt": "Phrynichus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pittacus Lyr.": {
        "tlg_id": "TLG0631",
        "names": {"name_authtab": "Pittacus Lyr.", "name_idt": "Pittacus Lyr."},
        "works": {"Fragmentum": ["line"], "Epigramma": ["Book", "epigram", "line"]},
    },
    "Manetho Astrol.": {
        "tlg_id": "TLG2583",
        "names": {"name_authtab": "Manetho Astrol.", "name_idt": "Manetho Astrol."},
        "works": {"Apotelesmatica": ["Book", "line"]},
    },
    "Sotades Comic.": {
        "tlg_id": "TLG0505",
        "names": {"name_authtab": "Sotades Comic.", "name_idt": "Sotades Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Antiphanes Comic.": {
        "tlg_id": "TLG0410",
        "names": {"name_authtab": "Antiphanes Comic.", "name_idt": "Antiphanes Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Pyrrhus Hist.": {
        "tlg_id": "TLG2160",
        "names": {"name_authtab": "Pyrrhus Hist.", "name_idt": "Pyrrhus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hippon Phil.": {
        "tlg_id": "TLG1437",
        "names": {"name_authtab": "Hippon Phil.", "name_idt": "Hippon Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Oedipodea": {
        "tlg_id": "TLG1547",
        "names": {"name_authtab": "Oedipodea", "name_idt": "Oedipodea"},
        "works": {
            "1Oedipodea (fragmentum) (fort. auctore Cinaethone)": ["Fragment", "line"]
        },
    },
    "Glaucus Hist.": {
        "tlg_id": "TLG4391",
        "names": {"name_authtab": "Glaucus Hist.", "name_idt": "Glaucus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Marcellus Theol.": {
        "tlg_id": "TLG2041",
        "names": {"name_authtab": "Marcellus Theol.", "name_idt": "Marcellus Theol."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "!De incarnatione et contra Arianos": ["Page", "line"],
            "Expositio fidei": ["Chapter", "section", "line"],
        },
    },
    "Hereas Hist.": {
        "tlg_id": "TLG2336",
        "names": {"name_authtab": "Hereas Hist.", "name_idt": "Hereas Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dioscorides Pedanius Med.": {
        "tlg_id": "TLG0656",
        "names": {
            "name_authtab": "Dioscorides Pedanius Med.",
            "name_idt": "Dioscorides Pedanius Med.",
        },
        "works": {
            "": ["De materia medica", "Book", "chapter", "section", "line"],
            "Y$*PERI\\ PAIWNI/AS KAI\\ O(/SA POIEI=N DU/NATAI& (e cod. Matrit. Bibl. Nat. 4616, fol. 159)": [
                "Volume",
                "page",
                "line",
            ],
            "&Euporista vel De simplicibus medicinis": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "oDe materia medica (recensiones e codd. Vindob. med. gr. 1 %7 suppl. gr. 28; Laur. 73, 41 %7 73, 16 %7 Vind. 93)": [
                "Book",
                "section",
                "line",
            ],
        },
    },
    "Montanus et Montanistae Theol.": {
        "tlg_id": "TLG1771",
        "names": {
            "name_authtab": "Montanus et Montanistae Theol.",
            "name_idt": "Montanus et Montanistae Theol.",
        },
        "works": {"Oracula": ["Oracle number", "line"]},
    },
    "Eudemus Phil.": {
        "tlg_id": "TLG1357",
        "names": {"name_authtab": "Eudemus Phil.", "name_idt": "Eudemus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cleon Eleg.": {
        "tlg_id": "TLG1273",
        "names": {"name_authtab": "Cleon Eleg.", "name_idt": "Cleon Eleg."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta et titulus": ["Fragment", "line"],
        },
    },
    "Trophonius Rhet., Soph.": {
        "tlg_id": "TLG4236",
        "names": {
            "name_authtab": "Trophonius Rhet. et Soph.",
            "name_idt": "Trophonius Rhet., Soph.",
        },
        "works": {"Prolegomena in artem rhetoricam": ["Page", "line"]},
    },
    "Justinianus Imperator Theol.": {
        "tlg_id": "TLG2734",
        "names": {
            "name_authtab": "Flavius Justinianus Imperator Theol.",
            "name_idt": "Justinianus Imperator Theol.",
        },
        "works": {
            "Edictum contra Origenem": ["Page", "line"],
            "*Edictum de aphthartodocetismo (fragmentum)": ["line"],
            "Edictum de asylo": ["line"],
            "Epistula dogmatica ad Zoilum": ["Page", "line"],
            "Epistula contra tria capitula": ["Section", "line"],
            "Epistula ad synodum de Origene": ["Page", "line"],
            " Decretum ad abbatem montis Sinai": ["line"],
            "Troparium": ["line"],
            "Contra monophysitas": ["Section", "line"],
            "+Contra Nestorianos (ap. Chronicon paschale)": ["Page", "line"],
            "6Constitutio contra Anthimum, Severum, Petrum et Zooram": ["Page", "line"],
            "Edictum rectae fidei": ["Page", "line"],
            "AContra Nestorianos et Acephalos (ap. acta concilii oecumenici vi)": [
                "line"
            ],
            "Novellae": ["Page", "line"],
            "7Epistula ad synodum de Theodoro Mopsuesteno et reliquis": [
                "Page",
                "line",
            ],
            "#Appendix constitutionum dispersarum": ["Page", "line"],
        },
    },
    "Aristophon Comic.": {
        "tlg_id": "TLG0421",
        "names": {"name_authtab": "Aristophon Comic.", "name_idt": "Aristophon Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "[Ctesiphon] Hist.": {
        "tlg_id": "TLG2201",
        "names": {"name_authtab": "[Ctesiphon] Hist.", "name_idt": "[Ctesiphon] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Chionides Comic.": {
        "tlg_id": "TLG0431",
        "names": {"name_authtab": "Chionides Comic.", "name_idt": "Chionides Comic."},
        "works": {
            "Fragmentum": ["Page", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Amasis Epistulae": {
        "tlg_id": "TLG0043",
        "names": {"name_authtab": "Amasis Epistulae", "name_idt": "Amasis Epistulae"},
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Sosipater Comic.": {
        "tlg_id": "TLG0504",
        "names": {"name_authtab": "Sosipater Comic.", "name_idt": "Sosipater Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Chalcocondyles Hist.": {
        "tlg_id": "TLG3139",
        "names": {
            "name_authtab": "Laonicus Chalcocondyles Hist.",
            "name_idt": "Chalcocondyles Hist.",
        },
        "works": {"Historiae": ["Volume", "page", "line"]},
    },
    "Vitae Arati Et Varia De Arato": {
        "tlg_id": "TLG4161",
        "names": {
            "name_authtab": "Vitae Arati Et Varia De Arato",
            "name_idt": "Vitae Arati Et Varia De Arato",
        },
        "works": {
            "qVita Arati (%6 Vita 4) (e codd. Matrit. 4691 %7 4629; Vat. gr. 1910; Paris. gr. 2403; Scorial. $*S &III 3; Palat.": [
                "Page",
                "line",
            ],
            "5Prolegomena in Aratum (e cod. Paris. suppl. gr. 607A)": [
                "Section",
                "line",
            ],
            "I$*)EC E(TE/RWN SXOLI/WN EI)SAGWGH/ &(%6 Anonymus I) (e cod. Vat. gr. 191)": [
                "Section",
                "line",
            ],
            "7Excerptum praefationis in phaenomena (%6 Anonymus II.3)": [
                "Page",
                "line",
            ],
            "#Excerpta varia de phaenomenis Arati": ["Section", "line"],
            "/De zodiaco (olim sub auctore Leontio Mechanico)": ["Page", "line"],
            "5Vita Arati (%6 Vita 2) (e codd. Matrit. 4691 %7 4629)": ["Page", "line"],
            "MVita Arati (%6 Vita 1) (olim sub auctore Achille Tatio) (e cod. Vat. gr. 191)": [
                "Page",
                "line",
            ],
            "$Sphaera (olim sub auctore Empedocle)": ["Section", "line"],
            "7Astronomica (in appendice cod. Scorialensis $*S &III 3)": [
                "Section",
                "line",
            ],
            "MEpistula ad Julianum quendam data (olim sub auctore Theone Alexandrino Math.)": [
                "Page",
                "line",
            ],
            "fProlegomena in Aratum (%6 $*PERI\\ E)CHGH/SEWS&) (olim sub auctore Achille Tatio) (e cod. Vat. gr. 191)": [
                "Page",
                "line",
            ],
            "qArati genus (%6 Vita 3) (olim sub auctore Theone Alexandrino Gramm. vel Theone Alexandrino Math.) (e codd. Edimbu": [
                "Page",
                "line",
            ],
            "Prooemium in Arati phaenomena": ["Section", "line"],
        },
    },
    "Theodosius Gramm.": {
        "tlg_id": "TLG2020",
        "names": {"name_authtab": "Theodosius Gramm.", "name_idt": "Theodosius Gramm."},
        "works": {
            "?$*PERI\\ KLI/SEWS TW=N EI)S <WN> BARUTO/NWN &(e cod. Haun. 1965)": [
                "Page",
                "line",
            ],
            "%Canones isagogici de flexione nominum": [
                "Part",
                "volume",
                "page",
                "line",
            ],
            "&Canones isagogici de flexione verborum": [
                "Part",
                "volume",
                "page",
                "line",
            ],
            "LEpitome catholicae Herodiani [Sp.] (fort. auctore quodam Theodosio Byzantio)": [
                "Page",
                "line",
            ],
            "=De dialectis [Sp.] (fort. auctore Theodosio alio vel anonymo)": [
                "Dialect",
                "section",
                "line",
            ],
            "?$*PERI\\ KLI/SEWS TW=N EI)S <WN> O)CUTO/NWN &(e cod. Haun. 1965)": [
                "Page",
                "line",
            ],
            "=$*PERI\\ GRAMMATIKH=S& [Sp.] (fort. auctore Theodoro Prodromo)": [
                "Page",
                "line",
            ],
            "7$*PERI\\ TO/NOU& [Sp.] (fort. auctore Theodoro Prodromo)": [
                "Page",
                "line",
            ],
        },
    },
    "Aristophanes Hist.": {
        "tlg_id": "TLG1196",
        "names": {
            "name_authtab": "Aristophanes Hist.",
            "name_idt": "Aristophanes Hist.",
        },
        "works": {
            "Fragmentum (P. Oxy. 27.2463)": ["FGrH fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Apollodorus Myth.": {
        "tlg_id": "TLG0548",
        "names": {
            "name_authtab": "Pseudo-Apollodorus Myth.",
            "name_idt": "Apollodorus Myth.",
        },
        "works": {
            "#Bibliotheca (sub nomine Apollodori)": ["Chapter", "section", "line"]
        },
    },
    "Hegemon Parodius": {
        "tlg_id": "TLG0463",
        "names": {"name_authtab": "Hegemon Parodius", "name_idt": "Hegemon Parodius"},
        "works": {"Fragmentum": ["line"]},
    },
    "Hermias Iamb.": {
        "tlg_id": "TLG1420",
        "names": {"name_authtab": "Hermias Iamb.", "name_idt": "Hermias Iamb."},
        "works": {"Fragmentum": ["line"]},
    },
    "Polemon Perieg.": {
        "tlg_id": "TLG0586",
        "names": {"name_authtab": "Polemon Perieg.", "name_idt": "Polemon Perieg."},
        "works": {
            "Testimonium et fragmenta": ["FHG fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Dionysius Perieg.": {
        "tlg_id": "TLG0084",
        "names": {"name_authtab": "Dionysius Perieg.", "name_idt": "Dionysius Perieg."},
        "works": {
            " Lithiaca vel lithica (fragmenta)": ["line"],
            "Orbis descriptio": ["line"],
            "CIxeuticon sive De aucupio (paraphrasis) (olim sub auctore Eutecnio)": [
                "Chapter",
                "section",
                "line",
            ],
        },
    },
    "Acta Et Martyrium Apollonii": {
        "tlg_id": "TLG0304",
        "names": {
            "name_authtab": "Acta Et Martyrium Apollonii",
            "name_idt": "Acta Et Martyrium Apollonii",
        },
        "works": {"Acta et martyrium Apollonii": ["Section", "line"]},
    },
    "Ptolemaeus IV Philopator Trag.": {
        "tlg_id": "TLG0604",
        "names": {
            "name_authtab": "Ptolemaeus IV Philopator Trag.",
            "name_idt": "Ptolemaeus IV Philopator Trag.",
        },
        "works": {"Titulus": ["line"]},
    },
    "Simias Gramm.": {
        "tlg_id": "TLG0211",
        "names": {"name_authtab": "Simias Gramm.", "name_idt": "Simias Gramm."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Philodemus Phil.": {
        "tlg_id": "TLG1595",
        "names": {"name_authtab": "Philodemus Phil.", "name_idt": "Philodemus Phil."},
        "works": {
            "Z$*PERI\\ EU)SEBEI/AS &(pars i) (P. Herc. 229, 247%3`242, 437%3`452, 1077, 1098, 1610, 1788)": [
                "Fragment",
                "line",
            ]
        },
    },
    "Hegesippus Comic.": {
        "tlg_id": "TLG0464",
        "names": {"name_authtab": "Hegesippus Comic.", "name_idt": "Hegesippus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Zenobius Sophista Paroemiogr.": {
        "tlg_id": "TLG0098",
        "names": {
            "name_authtab": "Zenobius Sophista Paroemiogr.",
            "name_idt": "Zenobius Sophista Paroemiogr.",
        },
        "works": {
            "/Epitome collectionum Lucilli Tarrhaei et Didymi": [
                "Centuria",
                "section",
                "line",
            ]
        },
    },
    "Empedocles Poet. Phil.": {
        "tlg_id": "TLG1342",
        "names": {
            "name_authtab": "Empedocles Poet. Phil.",
            "name_idt": "Empedocles Poet. Phil.",
        },
        "works": {
            "Epigramma": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Neophron Trag.": {
        "tlg_id": "TLG0307",
        "names": {"name_authtab": "Neophron Trag.", "name_idt": "Neophron Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sententiae Pythagoreorum": {
        "tlg_id": "TLG1759",
        "names": {
            "name_authtab": "Sententiae Pythagoreorum",
            "name_idt": "Sententiae Pythagoreorum",
        },
        "works": {
            "ASententiae Pythagoreorum (fort. auctore vel collectore Demophilo)": [
                "Sententia",
                "line",
            ],
            "Sententiae Pythagoreorum": ["Sententia", "line"],
        },
    },
    "Theophylactus Simocatta Epist., Hist.": {
        "tlg_id": "TLG3130",
        "names": {
            "name_authtab": "Theophylactus Simocatta Epist. et Hist.",
            "name_idt": "Theophylactus Simocatta Epist., Hist.",
        },
        "works": {
            "Epistulae": ["Epistle", "line"],
            "De vitae termino": ["Section", "line"],
            "Historiae": ["\x13Book-dialogue-index", "chapter", "section", "line"],
            "Quaestiones physicae": ["Page", "line"],
        },
    },
    "Theognis Hist.": {
        "tlg_id": "TLG2367",
        "names": {"name_authtab": "Theognis Hist.", "name_idt": "Theognis Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Xenion Hist.": {
        "tlg_id": "TLG1753",
        "names": {"name_authtab": "Xenion Hist.", "name_idt": "Xenion Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Asclepiades Gramm., Hist.": {
        "tlg_id": "TLG1199",
        "names": {
            "name_authtab": "Asclepiades Gramm. et Hist.",
            "name_idt": "Asclepiades Gramm., Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Lycophron Trag.": {
        "tlg_id": "TLG0341",
        "names": {"name_authtab": "Lycophron Trag.", "name_idt": "Lycophron Trag."},
        "works": {"Fragmenta": ["Fragment", "line"], "Alexandra": ["line"]},
    },
    "Priscus Epic.": {
        "tlg_id": "TLG2641",
        "names": {"name_authtab": "Priscus Epic.", "name_idt": "Priscus Epic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "[Menippus] Comic.": {
        "tlg_id": "TLG1787",
        "names": {"name_authtab": "[Menippus] Comic.", "name_idt": "[Menippus] Comic."},
        "works": {"Tituli": ["Page", "line"]},
    },
    "Marcianus Geogr.": {
        "tlg_id": "TLG4003",
        "names": {"name_authtab": "Marcianus Geogr.", "name_idt": "Marcianus Geogr."},
        "works": {
            "(Artemidori geographia (epitome Marciani)": ["Fragment", "line"],
            "1Menippi periplus maris interni (epitome Marciani)": ["Section", "line"],
            "Periplus maris exteri": ["Book", "section", "line"],
        },
    },
    "Ammonius Gramm.": {
        "tlg_id": "TLG0708",
        "names": {"name_authtab": "Ammonius Gramm.", "name_idt": "Ammonius Gramm."},
        "works": {
            "jDe impropriis (%6 $*PERI\\ A)KUROLOGI/AS&) (quoque sub nominibus Anonymi et Herennii Philonis et Herodiani)": [
                "Section",
                "line",
                "",
                "©³",
                "",
            ],
            "qDe adfinium vocabulorum differentia (%6 $*PERI\\ O(MOI/WN KAI\\ DIAFO/RWN LE/CEWN&) (fort. epitome operis sub aucto": [
                "Lexical entry",
                "line",
                "",
            ],
        },
    },
    "Georgius Monachus Chronogr.": {
        "tlg_id": "TLG3043",
        "names": {
            "name_authtab": "Georgius Monachus Chronogr.",
            "name_idt": "Georgius Monachus Chronogr.",
        },
        "works": {
            "Chronicon (lib. 1-4)": ["Page", "line"],
            "/Chronicon breve (lib. 1-6) (redactio recentior)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Proclus Phil.": {
        "tlg_id": "TLG4036",
        "names": {"name_authtab": "Proclus Phil.", "name_idt": "Proclus Phil."},
        "works": {
            "1In primum Euclidis elementorum librum commentarii": ["Page", "line"],
            "BDe providentia et fato et eo quod in nobis ad Theodorum mechanicum": [
                "Section",
                "line",
            ],
            "De sacrificio et magia": ["Page", "line"],
            "*De decem dubitationibus circa providentiam": ["Section", "line"],
            " In Platonis Cratylum commentaria": ["Section", "line"],
            "Chrestomathia [Dub.] (epitome)": ["line"],
            " Eclogae de philosophia Chaldaica": ["Fragment", "line"],
            "Institutio theologica": ["Section", "line"],
            "Hymnorum fragmenta": ["Fragment", "line"],
            "Theologia Platonica (lib. 1-5)": ["Volume", "page", "line"],
            "Institutio physica": ["Book", "section", "line"],
            "De malorum subsistentia": ["Section", "line"],
            "%Excerpta e Platonica Procli theologia": ["Page", "line"],
            "Epigramma": ["Book", "epigram", "line"],
            "In Platonis Parmenidem": ["Page", "line"],
            "In Platonis Timaeum commentaria": ["Volume", "page", "line"],
            "Hymni 1-7": ["Hymn", "line"],
            "%Hypotyposis astronomicarum positionum": ["Chapter", "section", "line"],
            "Epigrammata": ["Epigram", "line"],
            "In Platonis Alcibiadem i": ["Section", "line"],
            "$In Platonis rem publicam commentarii": ["Volume", "page", "line"],
        },
    },
    "Praxiteles Epigr.": {
        "tlg_id": "TLG1633",
        "names": {"name_authtab": "Praxiteles Epigr.", "name_idt": "Praxiteles Epigr."},
        "works": {"Epigramma": ["Epigram", "line"]},
    },
    "Satyrus Biogr.": {
        "tlg_id": "TLG0608",
        "names": {"name_authtab": "Satyrus Biogr.", "name_idt": "Satyrus Biogr."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Vita Euripidis (P. Oxy. 9.1176)": ["Fragment", "line"],
        },
    },
    "Ecphantides Comic.": {
        "tlg_id": "TLG0449",
        "names": {
            "name_authtab": "Ecphantides Comic.",
            "name_idt": "Ecphantides Comic.",
        },
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Nicias Hist.": {
        "tlg_id": "TLG2217",
        "names": {"name_authtab": "Nicias Hist.", "name_idt": "Nicias Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Speusippus Phil.": {
        "tlg_id": "TLG1692",
        "names": {"name_authtab": "Speusippus Phil.", "name_idt": "Speusippus Phil."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Epistulae [Sp.]": ["Epistle", "section", "line"],
            "!Epistula ad Philippum regem [Sp.]": ["Page", "line"],
        },
    },
    "Ariphron Lyr.": {
        "tlg_id": "TLG0378",
        "names": {"name_authtab": "Ariphron Lyr.", "name_idt": "Ariphron Lyr."},
        "works": {"Fragmentum": ["line"]},
    },
    "Metrodorus Major Phil.": {
        "tlg_id": "TLG1811",
        "names": {
            "name_authtab": "Metrodorus Major Phil.",
            "name_idt": "Metrodorus Major Phil.",
        },
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Antiochus Hist.": {
        "tlg_id": "TLG1145",
        "names": {"name_authtab": "Antiochus Hist.", "name_idt": "Antiochus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Simylus Eleg.": {
        "tlg_id": "TLG1675",
        "names": {"name_authtab": "Simylus Eleg.", "name_idt": "Simylus Eleg."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Oracula Tiburtina": {
        "tlg_id": "TLG2960",
        "names": {"name_authtab": "Oracula Tiburtina", "name_idt": "Oracula Tiburtina"},
        "works": {"Prophetia": ["line"]},
    },
    "Carmina Popularia (PMG)": {
        "tlg_id": "TLG0295",
        "names": {
            "name_authtab": "Carmina Popularia (PMG)",
            "name_idt": "Carmina Popularia (PMG)",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Lasus Lyr.": {
        "tlg_id": "TLG0366",
        "names": {"name_authtab": "Lasus Lyr.", "name_idt": "Lasus Lyr."},
        "works": {"Fragmentum": ["Fragment", "line"], "Tituli": ["Fragment", "line"]},
    },
    "Dionysius Chalcus Eleg.": {
        "tlg_id": "TLG0246",
        "names": {
            "name_authtab": "Dionysius Chalcus Eleg.",
            "name_idt": "Dionysius Chalcus Eleg.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hippolytus Scr. Eccl.": {
        "tlg_id": "TLG2115",
        "names": {
            "name_authtab": "Hippolytus Scr. Eccl.",
            "name_idt": "Hippolytus Scr. Eccl.",
        },
        "works": {
            "": ["In canticum Mosis", "Fragment", "line", "", "", "4", ""],
            "Fragmentum in Danielem 1.18.3": ["line"],
            "De universo": ["line"],
            "&Chronicon (fragmentum) (P. Oxy. 6.870)": [
                "\x12Verso-recto+column",
                "line",
            ],
            '"Fragmentum in Matthaeum 6.11 [Sp.]': ["Fragment", "line"],
            "!Contra Beronem et Heliconem [Sp.]": ["Page", "line"],
            ",Fragmenta in Proverbia (e cod. Coislin. 193)": ["Fragment", "line"],
            "/De benedictione Balaam (fragmenta ap. Irenaeum)": ["Fragment", "line"],
            "Canon paschalis": ["line"],
            "(Fragmentum e traditione apostolica [Sp.]": ["line"],
            "!De benedictione Mosis (fragmenta)": ["Fragment", "line"],
            "EDe resurrectione ad Mammaeam imperatricem (cod. Achrid. Mus. nat. 86)": [
                "line"
            ],
            "PDe resurrectione ad Mammaeam imperatricem (fragmenta ap. Theodoretum, Eranistes)": [
                "Fragment",
                "line",
            ],
            " Fragmentum in Ecclesiasten [Sp.]": ["Fragment", "line"],
            "QFragmentum de resurrectione et incorruptione (ap. Anastasium Sinai+tam, Viae dux)": [
                "line"
            ],
            "In principium Isaiae": ["Fragment", "line"],
            "De theophania [Dub.]": ["Section", "line"],
            "Fragmenta in Proverbia [Dub.]": ["Fragment", "line"],
            "4Fragmenta in Proverbia (e Pseudo-Anastasio Sinai+ta)": [
                "Fragment",
                "line",
            ],
            "Commentarium in Danielem": ["Book", "chapter", "section", "line"],
            "Fragmenta in Proverbia [Sp.]": ["Fragment", "line"],
            "&Narratio de virgine Corinthiaca [Dub.]": ["Page", "line"],
            "-In Ecclesiasten (fragmentum e cod. Vat. 1694)": ["Fragment", "line"],
            "Traditio apostolica": ["Page", "line"],
            "8Fragmentum in Genesim 4.23 (e cod. Ath. Bibl. Nat. 2492)": [
                "Page",
                "line",
            ],
            "Ex interpretatione Ruth": ["line", "R", ""],
            "Fragmenta in Genesim": ["Fragment", "line"],
            "Fragmenta in Proverbia": ["Fragment", "section", "line"],
            ".De benedictione Balaam (fragmentum ex Leontio)": [
                "line",
                "",
                "",
                "",
                "K",
                "",
            ],
            "BDe universo (fragmentum ap. Joannem Philoponum, De opificio mundi)": [
                "Fragment",
                "line",
            ],
            "In Canticum canticorum": ["line"],
            "Fragmenta in Psalmos": ["Section", "line"],
            "Fragmentum in Helcanam et Annam": ["line"],
            "7In evangelium Joannis et de resurrectione Lazari [Dub.]": [
                "Page",
                "line",
            ],
            "Fragmentum in Ezechielem": ["Volume", "page", "line"],
            ",Syntagma (fragmentum ap. Chronicon paschale)": ["Volume", "page", "line"],
            "Fragmenta in Psalmos [Sp.]": ["Fragment", "line"],
            "$De duobus latronibus (Joh. 19.33-34)": ["Fragment", "line"],
            "#De benedictionibus Isaaci et Jacobi": ["Page", "line"],
            ".Refutatio omnium haeresium (%6 Philosophumena)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "!Fragmentum de engastrimytho [Sp.]": ["line"],
            "Fragmenta varia [Dub.]": ["Fragment", "line"],
            "#Demonstratio adversus Judaeos [Sp.]": ["Page", "line"],
            "In Helcanam et Annam": ["Fragment", "line", "", "", "D\x12"],
            "Chronicon": ["Section", "line"],
            "De consummatione mundi [Sp.]": ["Section", "line"],
            "5Fragmentum de distributione talentorum (Matth. 25.24)": [
                "Fragment",
                "line",
            ],
            "Contra haeresin Noeti": ["Chapter", "section", "line"],
            "De antichristo": ["Section", "line"],
            "Fragmenta in Genesim [Sp.]": ["Fragment", "line", "¶"],
            ",Demonstratio temporum paschatis (in catenis)": ["Fragment", "line"],
            "Commentarium in Danielem 1.18": ["Section", "line"],
            "De universo (fragmenta)": ["Fragment", "line"],
            "$In Canticum canticorum (paraphrasis)": ["Chapter", "section", "line"],
        },
    },
    "Evagrius Scholasticus Scr. Eccl.": {
        "tlg_id": "TLG2733",
        "names": {
            "name_authtab": "Evagrius Scholasticus Scr. Eccl.",
            "name_idt": "Evagrius Scholasticus Scr. Eccl.",
        },
        "works": {"Historia ecclesiastica": ["Page", "line"]},
    },
    "Polemon": {
        "tlg_id": "TLG2233",
        "names": {"name_authtab": "Pseudo-Polemon", "name_idt": "Polemon"},
        "works": {"Physiognomonica": ["Section", "line"]},
    },
    "Callimachus Philol.": {
        "tlg_id": "TLG0533",
        "names": {
            "name_authtab": "Callimachus Philol.",
            "name_idt": "Callimachus Philol.",
        },
        "works": {
            "In Cererem (hymn. 6)": ["line"],
            " Carmina epica et elegiaca minora": ["Fragment", "line"],
            "Fragmenta incertae sedis": ["Fragment", "line"],
            "Aetia": ["Fragment", "line"],
            "5Fragmenta incerti auctoris (fort. auctore Callimacho)": [
                "Fragment",
                "line",
            ],
            "Hecala": ["Fragment", "line", "\x8eù\x12"],
            "In Jovem (hymn. 1)": ["line"],
            "Lyrica": ["Fragment", "line", ""],
            "Iambi": ["Fragment", "line"],
            "In Apollinem (hymn. 2)": ["line"],
            "Fragmenta grammatica": ["Fragment", "line"],
            "Fragmenta et titulus": ["Fragment", "line"],
            "Epigrammatum fragmenta": ["Fragment", "line"],
            "In Delum (hymn. 4)": ["line"],
            "In Dianam (hymn. 3)": ["line"],
            "In lavacrum Palladis (hymn. 5)": ["line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Euclides Comic. vel Iamb.": {
        "tlg_id": "TLG0250",
        "names": {
            "name_authtab": "Euclides Comic. vel Iamb.",
            "name_idt": "Euclides Comic. vel Iamb.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Suetonius Tranquillus Gramm., Hist.": {
        "tlg_id": "TLG1760",
        "names": {
            "name_authtab": "Gaius Suetonius Tranquillus Gramm. et Hist.",
            "name_idt": "Suetonius Tranquillus Gramm., Hist.",
        },
        "works": {
            "%$*PERI\\ TW=N PAR' (/*ELLHSI PAIDIW=N&": ["Section", "line"],
            ")$*PERI\\ BLASFHMIW=N KAI\\ PO/QEN E(KA/STH&": ["Section", "line"],
        },
    },
    "Castorion Lyr.": {
        "tlg_id": "TLG0382",
        "names": {"name_authtab": "Castorion Lyr.", "name_idt": "Castorion Lyr."},
        "works": {"Fragmentum": ["line"], "Fragmenta": ["Fragment", "line"]},
    },
    "Hipparchus Parodius": {
        "tlg_id": "TLG2626",
        "names": {
            "name_authtab": "Hipparchus Parodius",
            "name_idt": "Hipparchus Parodius",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Evangelium Ebionitum": {
        "tlg_id": "TLG1368",
        "names": {
            "name_authtab": "Evangelium Ebionitum",
            "name_idt": "Evangelium Ebionitum",
        },
        "works": {"Evangelium Ebionitum": ["Fragment", "line"]},
    },
    "Apollodorus Trag.": {
        "tlg_id": "TLG0700",
        "names": {"name_authtab": "Apollodorus Trag.", "name_idt": "Apollodorus Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Attalus Astron., Math.": {
        "tlg_id": "TLG1207",
        "names": {
            "name_authtab": "Attalus Astron. et Math.",
            "name_idt": "Attalus Astron., Math.",
        },
        "works": {"Fragmenta Aratea": ["Fragment", "line"]},
    },
    "Anonymus Dialogus Cum Judaeis": {
        "tlg_id": "TLG3186",
        "names": {
            "name_authtab": "Anonymus Dialogus Cum Judaeis",
            "name_idt": "Anonymus Dialogus Cum Judaeis",
        },
        "works": {
            "WAnonymus dialogus cum Judaeis (e cod. Vatoped. 236) (olim sub auctore Joanne Damasceno)": [
                "Chapter",
                "line",
            ]
        },
    },
    "Biton Mech.": {
        "tlg_id": "TLG1226",
        "names": {"name_authtab": "Biton Mech.", "name_idt": "Biton Mech."},
        "works": {
            "6$*KATASKEUAI\\ POLEMIKW=N O)RGA/NWN KAI\\ KATAPALTIKW=N&": [
                "Section",
                "line",
            ]
        },
    },
    "Philiscus Rhet.": {
        "tlg_id": "TLG0257",
        "names": {"name_authtab": "Philiscus Rhet.", "name_idt": "Philiscus Rhet."},
        "works": {"Fragmentum": ["line"]},
    },
    "Hedyle Epigr.": {
        "tlg_id": "TLG0197",
        "names": {"name_authtab": "Hedyle Epigr.", "name_idt": "Hedyle Epigr."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Lycon Phil.": {
        "tlg_id": "TLG2246",
        "names": {"name_authtab": "Lycon Phil.", "name_idt": "Lycon Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Concilia Oecumenica (ACO)": {
        "tlg_id": "TLG5000",
        "names": {
            "name_authtab": "Concilia Oecumenica (ACO)",
            "name_idt": "Concilia Oecumenica (ACO)",
        },
        "works": {
            "7Synodus Constantinopolitana et Hierosolymitana anno 536": [
                "Tome",
                "page",
                "line",
            ],
            "+Concilium universale Chalcedonense anno 451": [
                "\x10Tome+volume+part",
                "page",
                "line",
            ],
            "'Concilium universale Ephesenum anno 431": [
                "\x10Tome+volume+part",
                "page",
                "line",
            ],
        },
    },
    "Amphicrates Rhet.": {
        "tlg_id": "TLG2699",
        "names": {"name_authtab": "Amphicrates Rhet.", "name_idt": "Amphicrates Rhet."},
        "works": {"Fragmenta": ["Fragment", " line"]},
    },
    "Antyllus Med.": {
        "tlg_id": "TLG0749",
        "names": {"name_authtab": "Antyllus Med.", "name_idt": "Antyllus Med."},
        "works": {
            "F$*)EK TOU= PERI\\ KLUSMW=N O(/TI DIA\\ TREI=S AI)TI/AS PARALAMBA/NONTAI&": [
                "Page",
                "line",
            ]
        },
    },
    "Melanippides Lyr.": {
        "tlg_id": "TLG0373",
        "names": {"name_authtab": "Melanippides Lyr.", "name_idt": "Melanippides Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sostratus Poeta": {
        "tlg_id": "TLG2694",
        "names": {"name_authtab": "Sostratus Poeta", "name_idt": "Sostratus Poeta"},
        "works": {"Tituli": ["Fragment", "line"]},
    },
    "Euanthes Epic.": {
        "tlg_id": "TLG2623",
        "names": {"name_authtab": "Euanthes Epic.", "name_idt": "Euanthes Epic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Socrates Phil.": {
        "tlg_id": "TLG0262",
        "names": {"name_authtab": "Socrates Phil.", "name_idt": "Socrates Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Eusebius Scr. Eccl., Theol.": {
        "tlg_id": "TLG2018",
        "names": {
            "name_authtab": "Eusebius Scr. Eccl. et Theol.",
            "name_idt": "Eusebius Scr. Eccl., Theol.",
        },
        "works": {
            "De solemnitate paschali": ["Volume", "page", "line"],
            ":Generalis elementaria introductio (%6 Eclogae propheticae)": [
                "Page",
                "line",
            ],
            "Commentarius in Isaiam": ["Book", "section", "line"],
            "-Generalis elementaria introductio (fragmenta)": ["Fragment", "line"],
            "Fragmenta in proverbia": ["Volume", "page", "line"],
            "Epistula ad Caesarienses": ["Section", "line"],
            " Epistula ad Constantiam Augustam": ["Volume", "page", "line"],
            "7Passio sanctorum decem martyrum Aegyptiorum (fragmenta)": [
                "Volume",
                "page",
                "line",
            ],
            "Commentaria in Psalmos": ["Volume", "page", "line"],
            "Onomasticon": ["Page", "line"],
            "Demonstratio evangelica": ["Book", "chapter", "section", "line"],
            "Fragmenta in Hebraeos": ["Volume", "page", "line"],
            "De theophania (fragmenta)": ["Fragment", "line"],
            ",Demonstratio evangelica (fragmenta libri xv)": ["Fragment", "line"],
            "2Constantini imperatoris oratio ad coetum sanctorum": [
                "Chapter",
                "section",
                "line",
            ],
            ",De martyribus Palaestinae (recensio brevior)": [
                "Chapter",
                "section",
                "line",
            ],
            "Contra Marcellum": ["Book", "chapter", "section", "line"],
            "Epistula ad Euphrationem": ["Section", "line"],
            " De vitis prophetarum (fragmenta)": ["Volume", "page", "line"],
            ".De martyribus Palaestinae (recensio prolixior)": [
                "Chapter",
                "section",
                "line",
            ],
            "7Epistula ad Carpianum ad canones evangeliorum praemissa": ["line"],
            ",Supplementa minora ad quaestiones ad Marinum": ["Volume", "page", "line"],
            "Contra Hieroclem": ["Page", "line"],
            "Fragmenta in Lucam": ["Volume", "page", "line"],
            "Epistula ad Flacillum": ["line"],
            "Praeparatio evangelica": ["Book", "chapter", "section", "line"],
            '"Quaestiones evangelicae ad Marinum': ["Volume", "page", "line"],
            "'Supplementa ad quaestiones ad Stephanum": ["Volume", "page", "line"],
            "%Supplementa ad quaestiones ad Marinum": ["Volume", "page", "line"],
            "Historia ecclesiastica": ["Book", "chapter", "section", "line"],
            "$Quaestiones evangelicae ad Stephanum": ["Volume", "page", "line"],
            "#Epistula ad Alexandrum Alexandrinum": ["Section", "line"],
            ",Antiquorum martyriorum collectio (fragmenta)": ["Volume", "page", "line"],
            "%De mensuris et ponderibus (fragmenta)": ["Section", "line"],
            "De laudibus Constantini": ["Chapter", "section", "line"],
            "#In cantica canticorum interpretatio": ["Volume", "page", "line"],
            "Fragmenta in Danielem": ["Volume", "page", "line"],
            "De ecclesiastica theologia": ["Book", "chapter", "section", "line"],
            "Vita Constantini": ["Book", "chapter", "section", "line"],
        },
    },
    "Hippocrates et Corpus Hippocraticum Med.": {
        "tlg_id": "TLG0627",
        "names": {
            "name_authtab": "Hippocrates Med. et Corpus Hippocraticum",
            "name_idt": "Hippocrates et Corpus Hippocraticum Med.",
        },
        "works": {
            "": ["De judicationibus", "Section", "line"],
            "De visu": ["Section", "line"],
            "De articulis": ["Section", "line"],
            "De natura muliebri": ["Section", "line"],
            "De morbis i-iii": ["Book", "section", "line"],
            "De ae+re aquis et locis": ["Section", "line"],
            "De carnibus": ["Section", "line"],
            "Lex": ["Section", "line"],
            "De affectionibus interioribus": ["Section", "line"],
            "Prognosticon": ["Section", "line", "´"],
            "Praeceptiones": ["Section", "line"],
            "De dentitione": ["Section", "line"],
            "Aphorismi": ["Chapter", "section", "line"],
            "De octimestri partu": ["Section", "line"],
            "De flatibus": ["Section", "line"],
            "De diaeta in morbis acutis": ["Section", "line", "\x8e\x8c\x92º", "_\x17"],
            "De medico": ["Section", "line"],
            "De mulierum affectibus i-iii": ["Section", "line"],
            "De corde": ["Section", "line"],
            "$De morbis popularibus (%6 Epidemiae)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "De virginum morbis": ["Section", "line"],
            "Epistulae": ["Epistle", "line"],
            "Prorrheticon": ["Book", "section", "line"],
            "Coa praesagia": ["Section", "line"],
            "De alimento": ["Section", "line"],
            "De humoribus": ["Section", "line"],
            "De exsectione foetus": ["Section", "line"],
            "(De semine, de natura pueri, de morbis iv": ["Section", "line"],
            "De affectionibus": ["Section", "line"],
            "Vectiarius": ["Section", "line"],
            "De ulceribus": ["Section", "line"],
            "De morbo sacro": ["Section", "line"],
            "De diaeta i-iv": ["Section", "line"],
            "De capitis vulneribus": ["Section", "line"],
            "De septimestri partu [Sp.]": ["Page", "line"],
            "De diaeta acutorum [Sp.]": ["Section", "line"],
            "Jusjurandum metricum": ["line"],
            "De fistulis": ["Section", "line"],
            '"De septimanis (%6 De hebdomadibus)': ["Section", "line"],
            "De officina medici": ["Section", "line"],
            "De arte": ["Section", "line"],
            "De anatome": ["Section", "line"],
            "De purgantibus (%6 De remediis)": ["line"],
            "De prisca medicina": ["Section", "line"],
            "De septimestri partu": ["Section", "line"],
            "De haemorrhoidibus": ["Section", "line"],
            "De diebus judicatoriis": ["Section", "line"],
            "De locis in homine": ["Section", "line"],
            "De ossium natura": ["Section", "line"],
            "De glandulis": ["Section", "line"],
            "De fracturis": ["Section", "line"],
            "De humidorum usu": ["Section", "line"],
            "Jusjurandum": ["line"],
        },
    },
    "Metrodorus Phil.": {
        "tlg_id": "TLG1508",
        "names": {"name_authtab": "Metrodorus Phil.", "name_idt": "Metrodorus Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Myrtilus Comic.": {
        "tlg_id": "TLG0477",
        "names": {"name_authtab": "Myrtilus Comic.", "name_idt": "Myrtilus Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Amyntas Epigr.": {
        "tlg_id": "TLG2649",
        "names": {"name_authtab": "Amyntas Epigr.", "name_idt": "Amyntas Epigr."},
        "works": {
            "-Fragmenta (P. Oxy. 4.662 %6 P. Lit. Lond. 61)": ["Fragment", "line"]
        },
    },
    "Melanthius Trag.": {
        "tlg_id": "TLG0344",
        "names": {"name_authtab": "Melanthius Trag.", "name_idt": "Melanthius Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Aratus Astron., Epic.": {
        "tlg_id": "TLG0653",
        "names": {
            "name_authtab": "Aratus Astron. et Epic.",
            "name_idt": "Aratus Astron., Epic.",
        },
        "works": {
            "Phaenomena": ["Book", "line"],
            "Fragmenta et tituli": ["Fragment", "line"],
            "!Fragmentum (e cod. Vat. gr. 2130)": ["Volume", "page", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            " Fragmentum (e cod. Matrit. 4616)": ["Volume", "page", "line"],
        },
    },
    "Scylax Perieg.": {
        "tlg_id": "TLG0065",
        "names": {"name_authtab": "Scylax Perieg.", "name_idt": "Scylax Perieg."},
        "works": {
            "": ["Periplus Scylacis", "Section", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Philocles Comic.": {
        "tlg_id": "TLG1794",
        "names": {"name_authtab": "Philocles Comic.", "name_idt": "Philocles Comic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Euripidis Epistulae": {
        "tlg_id": "TLG1367",
        "names": {
            "name_authtab": "Euripidis Epistulae",
            "name_idt": "Euripidis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Moeris Attic.": {
        "tlg_id": "TLG1515",
        "names": {"name_authtab": "Moeris Attic.", "name_idt": "Moeris Attic."},
        "works": {"Lexicon Atticum": ["Page", "line"]},
    },
    "Callicratidas Phil.": {
        "tlg_id": "TLG1237",
        "names": {
            "name_authtab": "Callicratidas Phil.",
            "name_idt": "Callicratidas Phil.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Demosthenes Orat.": {
        "tlg_id": "TLG0014",
        "names": {"name_authtab": "Demosthenes Orat.", "name_idt": "Demosthenes Orat."},
        "works": {
            "": ["Contra Phormionem", "Section", "line"],
            "Eroticus [Sp.]": ["Section", "line"],
            "In Dionysodorum [Sp.]": ["Section", "line"],
            "In Evergum et Mnesibulum [Sp.]": ["Section", "line"],
            "In Theocrinem [Sp.]": ["Section", "line"],
            "Contra Nicostratum": ["Section", "line"],
            "Epistulae": ["Epistle", "section", "line"],
            "Adversus Androtionem": ["Section", "line"],
            "De Chersoneso": ["Section", "line"],
            "In Stephanum 2 [Sp.]": ["Section", "line"],
            "Olynthiaca 3": ["Section", "line"],
            "De pace": ["Section", "line"],
            "Fragmenta": ["Oration", "fragment", "line"],
            "Contra Pantaenetum": ["Section", "line"],
            "!Contra Nausimachum et Xenopeithea": ["Section", "line"],
            "In Aristogitonem 2": ["Section", "line"],
            "De corona": ["Section", "line"],
            "Contra Aphobum": ["Section", "line"],
            "Contra Calliclem": ["Section", "line"],
            "In Stephanum 1": ["Section", "line"],
            "1$*PERI\\ TW=N PRO\\S *)ALE/CANDRON SUNQHKW=N& [Sp.]": ["Section", "line"],
            "In Aphobum 2": ["Section", "line"],
            "Epitaphius": ["Section", "line"],
            "In Olympiodorum [Sp.]": ["Section", "line"],
            "Contra Boeotum 1": ["Section", "line"],
            "De Rhodiorum libertate": ["Section", "line"],
            "Pro Megalopolitanis": ["Section", "line"],
            "Contra Polyclem [Sp.]": ["Section", "line"],
            "De corona trierarchiae": ["Section", "line"],
            "Contra Phaenippum [Sp.]": ["Section", "line"],
            "In Cononem": ["Section", "line"],
            "In Midiam": ["Section", "line"],
            "Pro Phormione": ["Section", "line"],
            "Philippica 4 [Sp.]": ["Section", "line"],
            "Contra Timotheum [Sp.]": ["Section", "line"],
            "De falsa legatione": ["Section", "line"],
            "Contra Lacritum [Sp.]": ["Section", "line"],
            "Philippica 3": ["Section", "line"],
            "In Timocratem": ["Section", "line"],
            "Contra Callippum [Sp.]": ["Section", "line"],
            "Contra Macartatum [Sp.]": ["Section", "line"],
            "In epistulam Philippi [Sp.]": ["Section", "line"],
            "De Halonneso": ["Section", "line"],
            "Exordia": ["Exordium", "section", "line"],
            "$*PERI\\ TW=N SUMMORIW=N&": ["Section", "line"],
            "Contra Eubulidem": ["Section", "line"],
            "Philippica 1": ["Section", "line"],
            "Contra Spudiam": ["Section", "line"],
            "In Aristogitonem 1": ["Section", "line"],
            "Contra Boeotum 2 [Sp.]": ["Section", "line"],
            "In Neaeram [Sp.]": ["Section", "line"],
            "Contra Leocharem [Sp.]": ["Section", "line"],
            "$*PERI\\ SUNTA/CEWS& [Sp.]": ["Section", "line"],
            "In Aphobum 1": ["Section", "line"],
            "Olynthiaca 2": ["Section", "line"],
            "[Philippi] epistula": ["Section", "line"],
            "Philippica 2": ["Section", "line"],
            "In Aristocratem": ["Section", "line"],
            "Olynthiaca 1": ["Section", "line"],
            "Contra Apatourium [Sp.]": ["Section", "line"],
        },
    },
    "Hipparchus Comic.": {
        "tlg_id": "TLG0468",
        "names": {"name_authtab": "Hipparchus Comic.", "name_idt": "Hipparchus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Acta Petri": {
        "tlg_id": "TLG0389",
        "names": {"name_authtab": "Acta Petri", "name_idt": "Acta Petri"},
        "works": {"Martyrium Petri": ["Section", "line"]},
    },
    "Novum Testamentum": {
        "tlg_id": "TLG0031",
        "names": {
            "name_authtab": "Novum Testamentum, New Testament",
            "name_idt": "Novum Testamentum",
        },
        "works": {
            "": ["Epistula Petri ii", "Chapter", "section", "line"],
            "Epistula Pauli ad Colossenses": ["Chapter", "section", "line"],
            "Epistula Petri i": ["Chapter", "section", "line"],
            "Epistula Pauli ad Ephesios": ["Chapter", "section", "line"],
            "Apocalypsis Joannis": ["Chapter", "section", "line"],
            "Acta apostolorum": ["Chapter", "section", "line"],
            "$Epistula Pauli ad Thessalonicenses i": ["Chapter", "section", "line"],
            "Evangelium secundum Joannem": ["Chapter", "section", "line"],
            "Epistula Pauli ad Corinthios ii": ["Chapter", "section", "line"],
            "Epistula Jacobi": ["Chapter", "section", "line"],
            "Epistula Pauli ad Timotheum ii": ["Chapter", "section", "line"],
            "Evangelium secundum Lucam": ["Chapter", "section", "line"],
            "Epistula Pauli ad Galatas": ["Chapter", "section", "line"],
            "Epistula Pauli ad Timotheum i": ["Chapter", "section", "line"],
            "Epistula Joannis ii": ["Section", "line"],
            "%Epistula Pauli ad Thessalonicenses ii": ["Chapter", "section", "line"],
            "Epistula Joannis iii": ["Section", "line"],
            "Epistula Pauli ad Romanos": ["Chapter", "section", "line"],
            "Epistula Joannis i": ["Chapter", "section", "line"],
            "Epistula Pauli ad Titum": ["Chapter", "section", "line"],
            "Epistula Juda": ["Section", "line"],
            "Epistula Pauli ad Corinthios i": ["Chapter", "section", "line"],
            "Epistula Pauli ad Philemonem": ["Section", "line"],
            "Evangelium secundum Matthaeum": ["Chapter", "section", "line", ""],
            "Evangelium secundum Marcum": [
                "Chapter",
                "section",
                "line",
                "¤\x92\x8eÈ",
                "³",
            ],
            "Epistula Pauli ad Philippenses": ["Chapter", "section", "line"],
            "Epistula Pauli ad Hebraeos": ["Chapter", "section", "line"],
        },
    },
    "Zenonis Epistula": {
        "tlg_id": "TLG0125",
        "names": {"name_authtab": "Zenonis Epistula", "name_idt": "Zenonis Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Minyas": {
        "tlg_id": "TLG1512",
        "names": {"name_authtab": "Minyas", "name_idt": "Minyas"},
        "works": {"Minyas (fragmenta)": ["Fragment", "line"]},
    },
    "Diotogenes Phil.": {
        "tlg_id": "TLG1332",
        "names": {"name_authtab": "Diotogenes Phil.", "name_idt": "Diotogenes Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Autesion Hist.": {
        "tlg_id": "TLG2205",
        "names": {"name_authtab": "Autesion Hist.", "name_idt": "Autesion Hist."},
        "works": {"Fragmenta": ["FGrH fragment", "line"]},
    },
    "Thallus Hist.": {
        "tlg_id": "TLG1706",
        "names": {"name_authtab": "Thallus Hist.", "name_idt": "Thallus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hedylus Epigr.": {
        "tlg_id": "TLG0198",
        "names": {"name_authtab": "Hedylus Epigr.", "name_idt": "Hedylus Epigr."},
        "works": {
            "Fragmentum et titulus": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Vitae Hesiodi Particula": {
        "tlg_id": "TLG1749",
        "names": {
            "name_authtab": "Vitae Hesiodi Particula",
            "name_idt": "Vitae Hesiodi Particula",
        },
        "works": {"Vitae Hesiodi particula": ["line"]},
    },
    "Phocylides Gnom.": {
        "tlg_id": "TLG1605",
        "names": {
            "name_authtab": "Pseudo-Phocylides Gnom.",
            "name_idt": "Phocylides Gnom.",
        },
        "works": {"Sententiae": ["line"]},
    },
    "Zonaras Gramm., Hist.": {
        "tlg_id": "TLG3135",
        "names": {
            "name_authtab": "Joannes Zonaras Gramm. et Hist.",
            "name_idt": "Zonaras Gramm., Hist.",
        },
        "works": {
            " Epitome historiarum (lib. 13-18)": ["Page", "line"],
            "Epitome historiarum (lib. 1-12)": ["Volume", "page", "line"],
            "4Epitome historiarum (lib. 12, clausula varia) [Dub.]": ["Page", "line"],
        },
    },
    "Hermas Scr. Eccl.": {
        "tlg_id": "TLG1419",
        "names": {
            "name_authtab": "Hermas Scr. Eccl., Pastor Hermae",
            "name_idt": "Hermas Scr. Eccl.",
        },
        "works": {
            "&Fragmentum in F (cod. Paris. gr. 1143)": ["Chapter", "section", "line"],
            "Pastor": ["Chapter", "section", "line"],
            "Fragmenta (P. Oxy. 3.404)": ["Chapter", "section", "line"],
            "Fragmenta (ap. Antiochum)": ["Chapter", "section", "line"],
        },
    },
    "Plotinus Phil.": {
        "tlg_id": "TLG2000",
        "names": {"name_authtab": "Plotinus Phil.", "name_idt": "Plotinus Phil."},
        "works": {"Enneades": ["Ennead", "chapter", "section", "line"]},
    },
    "Python Trag.": {
        "tlg_id": "TLG0337",
        "names": {"name_authtab": "Python Trag.", "name_idt": "Python Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Scholia In Callimachum": {
        "tlg_id": "TLG5016",
        "names": {
            "name_authtab": "Scholia In Callimachum",
            "name_idt": "Scholia In Callimachum",
        },
        "works": {
            ";Argumentum Hecalae (P. Oxy. 20.2258, olim inedita A, fr. 9)": ["line"],
            "#Scholia in Lyrica (P. Berol. 13417)": ["Fragment", "scholion", "line"],
            "LScholia in Epica et elegiaca minora (P. Oxy. 20.2258, olim inedita C, fr. 2)": [
                "Fragment",
                "scholion",
                "line",
            ],
            ",Diegeseis in Hymnos i et ii (scholia vetera)": ["Hymn", "column", "line"],
            "%Diegeseis in Hecalam (scholia vetera)": ["Fragment", "line"],
            "3Scholia in Iambos (scholia Florentina) (PSI 9.1094)": [
                "Fragment",
                "line",
            ],
            "CCommentarius ad Aetia i (P. Oxy. 20.2262, olim inedita a, frr. 1-2)": [
                "Fragment",
                "line",
            ],
            "9Scholia in Hymnos ii et iii (scholia vetera) (P. Ant. 20)": [
                "Hymn",
                "scholion",
                "line",
            ],
            "=Scholia in Hymnos (scholia vetera) (scholia $Y &ex archetypo)": [
                "Hymn",
                "scholion",
                "line",
            ],
            "8Scholia in Hymnum iii (scholia vetera) (P. Cair. 47993b)": [
                "Hymn",
                "scholion",
                "line",
            ],
            "$Diegeseis in Iambos (scholia vetera)": ["Fragment", "column", "line"],
            "5Scholia in Aetia i (scholia Florentina) (PSI 11.1219)": [
                "Fragment",
                "line",
            ],
            "OFragmenta scholiorum incertae sedis (P. Oxy. 20.2258, olim inedita, frr. 10-11)": [
                "Fragment",
                "column",
                "line",
            ],
            "UScholia in Aetia i (scholia Londinensia) (P. Lit. Lond. 181 [%6 Brit. Mus. inv. 131])": [
                "Fragment",
                "line",
            ],
            "@Scholia in Aetia i (commentarius Berolinensis) (P. Berol. 11521)": [
                "Fragment",
                "line",
            ],
            "#Diegeseis in Aetia (scholia vetera)": ["Fragment", "column", "line"],
            '"Scholia in Iambos (P. Oxy. 7.1011)': ["Fragment", "scholion", "line"],
            "$Diegeseis in Lyrica (scholia vetera)": ["Fragment", "column", "line"],
            "%Diegeseis fabularum (P. Oxy. 20.2263)": ["Fragment", "column", "line"],
            "SScholia in Hymnos (scholia vetera) (P. Oxy. 20.2258, olim inedita A, frr. 2, 4, 10)": [
                "Hymn",
                "scholion",
                "line",
            ],
            "hScholia in Aetia (P. Berol. 11629 %7 P. Oxy. 18.2169; 19.2208, 2212; 20.2258 addenda, fragmenta inedita)": [
                "Fragment",
                "scholion",
                "line",
            ],
            "3Scholia in Hymnum iii (scholia vetera) (P. Amh. 20)": [
                "Scholion",
                "line",
            ],
        },
    },
    "Hippocrates Math.": {
        "tlg_id": "TLG2235",
        "names": {"name_authtab": "Hippocrates Math.", "name_idt": "Hippocrates Math."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Comica Adespota (CGFPR)": {
        "tlg_id": "TLG0662",
        "names": {
            "name_authtab": "Comica Adespota (CGFPR)",
            "name_idt": "Comica Adespota (CGFPR)",
        },
        "works": {
            "": [
                "$*$*KWMW|DOU/MENOI& !!! TRANSLITERATE|$*KWMW|DOU/MENOI& !!! TRANSLITERATE",
                "Fragment",
                "line",
            ],
            "Adespota Doriensium comoediae": ["Fragment", "line"],
            "Argumenta comica": ["Fragment", "line"],
            "Adespota veteris comoediae": ["Fragment", "line"],
            '"Excerpta, florilegia et sententiae': ["Fragment", "line"],
            "Dubia": ["Fragment", "line"],
            "Adespota novae comoediae": ["Fragment", "line"],
            "$*LE/CEIS KWMIKAI/&": ["Fragment", "line"],
        },
    },
    "Papias Scr. Eccl.": {
        "tlg_id": "TLG1558",
        "names": {"name_authtab": "Papias Scr. Eccl.", "name_idt": "Papias Scr. Eccl."},
        "works": {"Fragmenta": ["Fragment", "section", "line"]},
    },
    "Terpander Lyr.": {
        "tlg_id": "TLG0299",
        "names": {"name_authtab": "Terpander Lyr.", "name_idt": "Terpander Lyr."},
        "works": {
            "$Fragmentum (fort. auctore Terpandro)": ["Fragment", "line"],
            "#Fragmenta (fort. auctore Terpandro)": ["Fragment", "line"],
        },
    },
    "Epinicus Comic.": {
        "tlg_id": "TLG0454",
        "names": {"name_authtab": "Epinicus Comic.", "name_idt": "Epinicus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Euphronius Lyr.": {
        "tlg_id": "TLG0210",
        "names": {"name_authtab": "Euphronius Lyr.", "name_idt": "Euphronius Lyr."},
        "works": {"Priapeia": ["line"]},
    },
    "Artemon Hist.": {
        "tlg_id": "TLG2307",
        "names": {"name_authtab": "Artemon Hist.", "name_idt": "Artemon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Athenagoras Apol.": {
        "tlg_id": "TLG1205",
        "names": {"name_authtab": "Athenagoras Apol.", "name_idt": "Athenagoras Apol."},
        "works": {
            "De resurrectione": ["Chapter", "section", "line"],
            "(Legatio sive Supplicatio pro Christianis": ["Chapter", "section", "line"],
        },
    },
    "Olympiodorus Phil.": {
        "tlg_id": "TLG4019",
        "names": {
            "name_authtab": "Olympiodorus Phil.",
            "name_idt": "Olympiodorus Phil.",
        },
        "works": {
            "LScholia in Aristotelis librum de interpretatione (e cod. Vat. Urbin. gr. 35)": [
                "Page",
                "line",
            ],
            "&In Aristotelis categorias commentarium": ["Page", "line"],
            "!In Platonis Phaedonem commentaria": ["Chapter", "section", "line"],
            '"In Aristotelis meteora commentaria': ["Page", "line"],
            "Prolegomena": ["Page", "line"],
            "In Platonis Gorgiam commentaria": ["Chapter", "section", "line"],
            '"In Platonis Alcibiadem commentarii': ["Section", "line"],
        },
    },
    "Isigonus Paradox.": {
        "tlg_id": "TLG1083",
        "names": {"name_authtab": "Isigonus Paradox.", "name_idt": "Isigonus Paradox."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Meletius Med.": {
        "tlg_id": "TLG0730",
        "names": {"name_authtab": "Meletius Med.", "name_idt": "Meletius Med."},
        "works": {
            "": ["De natura hominis", "Page", "line"],
            "<Hypothesis ad opus De natura hominis (e cod. Barocciano 131)": [
                "Page",
                "line",
            ],
        },
    },
    "Priscus Hist., Rhet.": {
        "tlg_id": "TLG2946",
        "names": {
            "name_authtab": "Priscus Hist. et Rhet.",
            "name_idt": "Priscus Hist., Rhet.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line", "´´", "¶"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Tyrannion Gramm.": {
        "tlg_id": "TLG1266",
        "names": {"name_authtab": "Tyrannion Gramm.", "name_idt": "Tyrannion Gramm."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Carmina Convivialia (PMG)": {
        "tlg_id": "TLG0296",
        "names": {
            "name_authtab": "Carmina Convivialia (PMG)",
            "name_idt": "Carmina Convivialia (PMG)",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Epica Adespota (GDRK)": {
        "tlg_id": "TLG1816",
        "names": {
            "name_authtab": "Epica Adespota (GDRK)",
            "name_idt": "Epica Adespota (GDRK)",
        },
        "works": {
            "*Fragmentum (sine titulo) (P. Berol. 5227r)": ["line"],
            "In Thebas (P. Berol. 5226v)": ["line"],
            "KFragmentum epicum historicum (P. Argent. 480 [%6 P. Strassb. inv. Gr. 480])": [
                "Fragment",
                "line",
            ],
            "FLaudatio professoris in universitate Beryti docentis (P. Berol. 10558)": [
                "line"
            ],
            "1Exercitationes ethopoeiacae (collectio C. Graves)": ["Fragment", "line"],
            "&Encomium ducis Romani (P. Flor. 2.114)": ["Fragment", "line"],
            "Encomium (PSI 2.149)": ["line"],
            "1Exercitatio ethopoeiaca (Tab. lignea Caironensis)": ["line"],
            "/$*LO/GOS E)PIBATH/RIOS &(P. Vindob. gr. 29788a)": ["Fragment", "line"],
            "Lusus verborum": ["line"],
            "'Exercitatio ethopoeiaca (P. Ryl. 3.487)": ["line"],
            "(Fragmentum epicum (Brit. Mus. inv. 1181)": ["Fragment", "line"],
            "VLaudatio professoris Smyrnaei in universitate Beryti docentis (P. Berol. 10559 A et B)": [
                "line"
            ],
            "#Encomium Heraclii ducis (PSI 3.253)": ["line"],
            "#Polyxena et Achilles (P. Flor. 390)": ["line"],
            "\\Mercurius mundi et Hermupolis magnae conditor (P. Argent. 481 [%6 P. Strassb. inv. Gr. 481])": [
                "Fragment",
                "line",
            ],
            ",Laudes Theonis gymnasiarchi (P. Oxy. 7.1015)": ["line"],
            "&Carmen in Nilum crescentem (PSI 7.845)": ["line"],
            "-Fragmentum epicum historicum (P. Berol. 5003)": ["line"],
            ")Encomium iambicum (P. Vindob. gr. 29788b)": ["Fragment", "line"],
            "Epithalamium (P. Ryl. 1.17)": ["line"],
        },
    },
    "Nicolaus Hist.": {
        "tlg_id": "TLG0577",
        "names": {"name_authtab": "Nicolaus Hist.", "name_idt": "Nicolaus Hist."},
        "works": {
            "": ["Nicolaus Hist. !!! AUTHOR NAME"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Demetrius Hist., Phil.": {
        "tlg_id": "TLG0624",
        "names": {
            "name_authtab": "Demetrius Hist. et Phil.",
            "name_idt": "Demetrius Hist., Phil.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollonius Biogr.": {
        "tlg_id": "TLG1167",
        "names": {"name_authtab": "Apollonius Biogr.", "name_idt": "Apollonius Biogr."},
        "works": {"Vita Aeschinis": ["line"]},
    },
    "Cleonides Mus.": {
        "tlg_id": "TLG0361",
        "names": {"name_authtab": "Cleonides Mus.", "name_idt": "Cleonides Mus."},
        "works": {"Introductio harmonica": ["Section", "line"]},
    },
    "Andronicus Rhodius Phil.": {
        "tlg_id": "TLG1124",
        "names": {
            "name_authtab": "Andronicus Rhodius Phil.",
            "name_idt": "Andronicus Rhodius Phil.",
        },
        "works": {
            "De passionibus (lib. 1) [Sp.]": ["Chapter", "section", "line"],
            "De passionibus (lib. 2) [Sp.]": ["Chapter", "section", "line"],
        },
    },
    "Apollodorus Carystius vel Apollodorus Gelous Comic.": {
        "tlg_id": "TLG0412",
        "names": {
            "name_authtab": "Apollodorus Carystius vel Apollodorus Gelous Comic.",
            "name_idt": "Apollodorus Carystius vel Apollodorus Gelous Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Eugenius Alchem.": {
        "tlg_id": "TLG4323",
        "names": {"name_authtab": "Eugenius Alchem.", "name_idt": "Eugenius Alchem."},
        "works": {
            "@$*EU)GENI/OU [2DI/PLWSIS]2 &(e cod. Venet. Marc. 299, fol. 185r)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Artemon Gramm.": {
        "tlg_id": "TLG1197",
        "names": {"name_authtab": "Artemon Gramm.", "name_idt": "Artemon Gramm."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Oppianus Epic.": {
        "tlg_id": "TLG0023",
        "names": {"name_authtab": "Oppianus Epic.", "name_idt": "Oppianus Epic."},
        "works": {"Halieutica": ["Book", "line"]},
    },
    "Scymnus Geogr.": {
        "tlg_id": "TLG0068",
        "names": {
            "name_authtab": "Pseudo-Scymnus Geogr.",
            "name_idt": "Scymnus Geogr.",
        },
        "works": {
            " Ad Nicomedem regem, vv. 722-1026": ["line"],
            ";Ad Nicomedem regem, vv. 1-980 (sub titulo Orbis descriptio)": ["line"],
        },
    },
    "Pamphilus Trag.": {
        "tlg_id": "TLG1399",
        "names": {"name_authtab": "Pamphilus Trag.", "name_idt": "Pamphilus Trag."},
        "works": {"Titulus": ["line"]},
    },
    "Philippus II Rex Macedonum Epist.": {
        "tlg_id": "TLG0048",
        "names": {
            "name_authtab": "Philippus II Rex Macedonum Epist.",
            "name_idt": "Philippus II Rex Macedonum Epist.",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Sphrantzes Hist.": {
        "tlg_id": "TLG3143",
        "names": {
            "name_authtab": "Georgius Sphrantzes Hist.",
            "name_idt": "Sphrantzes Hist.",
        },
        "works": {"Chronicon sive Minus [Sp.]": ["Chapter", "section", "line"]},
    },
    "Alcmaeon Phil.": {
        "tlg_id": "TLG0766",
        "names": {"name_authtab": "Alcmaeon Phil.", "name_idt": "Alcmaeon Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Olympiodorus Alchem.": {
        "tlg_id": "TLG2589",
        "names": {
            "name_authtab": "Olympiodorus Alchem.",
            "name_idt": "Olympiodorus Alchem.",
        },
        "works": {
            "q$*EI)S TO\\ KAT' E)NE/RGEIAN ZWSI/MOU O(/SA A)PO\\ *(ERMOU= KAI\\ TW=N FILOSO/FWN H)=SAN EI)RHME/NA &(%6 De arte sac": [
                "Volume",
                "page",
                "line",
            ],
            "KDe arte sacra (appendices e codd. Venet. Marc. 299 %7 Paris. B.N. gr. 2250)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Clidemus Hist.": {
        "tlg_id": "TLG1276",
        "names": {"name_authtab": "Clidemus Hist.", "name_idt": "Clidemus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hipponax Iamb.": {
        "tlg_id": "TLG0233",
        "names": {"name_authtab": "Hipponax Iamb.", "name_idt": "Hipponax Iamb."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Zosimus Alchem.": {
        "tlg_id": "TLG4319",
        "names": {"name_authtab": "Zosimus Alchem.", "name_idt": "Zosimus Alchem."},
        "works": {
            "q$*PERI\\ TH=S E)CATMI/SEWS TOU= QEI/OU U(/DATOS TOU= PH/SSONTOS TH\\N U(DRA/RGURON &(e codd. Venet. Marc. 299, fol.": [
                "line"
            ],
            "q$*PERI\\ TOU= O(/TI PA/NTWN TW=N U(GRW=N TO\\ QEI=ON U(/DWR KALOU=SIN: KAI\\ TOU=TO SUNQETO/N E)STIN KAI\\ OU)X A(PLO": [
                "Volume",
                "page",
                "line",
            ],
            "qExcerptum alchemicum (sine titulo) (e codd. Venet. Marc. 299, fol. 186v, 192v; Paris. B.N. gr. 2325, fol. 82v %7 ": [
                "line"
            ],
            "[$*PERI\\ LEUKW/SEWS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 118r)": [
                "Volume",
                "page",
                "line",
            ],
            "[$*KADMI/AS PLU/SIS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 137r)": [
                "Volume",
                "page",
                "line",
            ],
            "V$*PERI\\ I)OU= &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 136v)": [
                "Volume",
                "page",
                "line",
            ],
            "qExcerptum $PERI\\ XALKANQRW/PWN &(sine titulo) (fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 1": [
                "Volume",
                "page",
                "line",
            ],
            "N$*ZWSI/MOU PERI\\ O)RGA/NWN KAI\\ KAMI/NWN &(e cod. Venet. Marc. 299, fol. 186r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ SW/MATOS MAGNHSI/AS KAI\\ OI)KONOMI/AS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. ": [
                "Volume",
                "page",
                "line",
            ],
            "W$*PERI\\ QEI/WN &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 152r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ OI)KONOMI/AS TOU= TH=S MAGNHSI/AS SW/MATOS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, ": [
                "Volume",
                "page",
                "line",
                "¼¾\x92",
                "¼\x12",
            ],
            "q$*PERI\\ TOU= QEI/OU U(/DATOS &(%6 $*ZWSI/MOU TOU= *PANOPOLI/TOU GNH/SIA U(POMNH/MATA PERI\\ TOU= QEI/OU U(/DATOS&)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ O)RGA/NWN KAI\\ KAMI/NWN GNH/SIA U(POMNH/MATA PERI\\ TOU= W STOIXEI/OU &(e cod. Venet. Marc. 299, fol. 189r": [
                "line"
            ],
            "q$*ZWSI/MOU PERI\\ O)RGA/NWN KAI\\ KAMI/NWN GNH/SIA U(POMNH/MATA PERI\\ TOU= W STOIXEI/OU &(e cod. Venet. Marc. 299, ": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= LI/QOU TH=S FILOSOFI/AS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Paris. B.N. gr. 2327, fol. 136v)": [
                "Volume",
                "page",
                "line",
            ],
            "b$*TO\\ A)E/RION U(/DWR &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Paris. B.N. gr. 2327, fol. 111r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= O(/TI PA/NTA PERI\\ MIA=S BAFH=S H( TE/XNH LELA/LHKEN &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Ven": [
                "Volume",
                "page",
                "line",
            ],
            "q$*BI/BLOS A)LHQH\\S *SOFE\\ *AI)GUPTI/OU KAI\\ QEI/OU *(EBRAI/WN KURI/OU TW=N DUNA/MEWN *SABAW/Q &(e cod. Paris. B.N": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= QEI/OU U(/DATOS &(e codd. Venet. Marc. 299, fol. 113v; Paris. B.N. gr. 2325, fol. 86r %7 2327, fol. ": [
                "line"
            ],
            "qExcerptum de partibus alchimiae (sine titulo) (e codd. Paris. B.N. gr. 2327, fol. 238v %7 Venet. Marc. 299, fol. ": [
                "Volume",
                "page",
                "line",
            ],
            "e$*PERI\\ A)FORMW=N SUNQE/SEWS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 161v)": [
                "Volume",
                "page",
                "line",
            ],
            "][2$*PERI\\ AI)TIW=N&]2 (fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 136v)": [
                "Volume",
                "page",
                "line",
            ],
            "=$*(UDRARGU/ROU POI/HSIS &(e cod. Venet. Marc. 299, fol. 107r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*ZWSI/MOU PERI\\ O)RGA/NWN KAI\\ KAMI/NWN &(e codd. Venet. Marc. 299, fol. 186r, 195r %7 Paris. B.N. gr. 2327, fol": [
                "line"
            ],
            "`$*ZWSI/MOU TOU= QEI/OU PERI\\ A)RETH=S KAI\\ E(RMHNEI/AS &(e cod. Paris. B.N. gr. 2327, fol. 168v)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*BI/BLOS A)LHQH\\S *SOFE\\ *AI)GUPTI/OU KAI\\ QEI/OU *(EBRAI/WN KURI/OU TW=N DUNA/MEWN *SABAW/Q. *ZWSI/MOU *QHBAI/O": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= TROFH\\N EI)=NAI TA\\ D' SW/MATA TW=N BAFW=N: EI)SI\\N DE/ &(fort. pars operis $*XEIRO/MHKTA&) (e cod. ": [
                "Volume",
                "page",
                "line",
            ],
            "7$*PERI\\ AI)QALW=N &(e cod. Venet. Marc. 299, fol. 116v)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= E)N PANTI\\ KAIRW=| A)RKTE/ON TO\\ E)/RGON &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 29": [
                "Volume",
                "page",
                "line",
            ],
            "`$*PERI\\ QEI/OU U(/DATOS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 156r)": [
                "Volume",
                "page",
                "line",
                "¶",
            ],
            "JExcerptum de cerussa (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 265)": [
                "Volume",
                "page",
                "line",
            ],
            "c$*PERI\\ SKEUASI/AS W)/XRAS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 157r)": [
                "Volume",
                "page",
                "line",
                "º",
                "º¶",
                "",
            ],
            "q$*PERI\\ TOU= TI/ E)STIN KATA\\ TH\\N TE/XNHN, OU)SI/A KAI\\ A)NOUSI/A &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Ve": [
                "Volume",
                "page",
                "line",
            ],
            "q$*ZW/SIMOS LE/GEI PERI\\ TH=S A)SBE/STOU &(e codd. Venet. Marc. 299, fol. 95r %7 Paris. B.N. gr. 2327, fol. 8r %7 ": [
                "line"
            ],
            ">$*ZWSI/MOU PRA=CIS B# &(e cod. Paris. B.N. gr. 2327, fol. 87v)": [
                "Volume",
                "page",
                "line",
            ],
            "K$*ZWSI/MOU PRO\\S *QEO/DWRON KEFA/LAIA &(e cod. Venet. Marc. 299, fol. 179r)": [
                "Volume",
                "page",
                "line",
            ],
            "[$*PERI\\ CANQW/SEWS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 137v)": [
                "Volume",
                "page",
                "line",
            ],
            "O$*PERI\\ TH=S E)CATMI/SEWS U(/DATOS QEI/OU &(e cod. Venet. Marc. 299, fol. 112r)": [
                "Volume",
                "page",
                "line",
            ],
            "Y$*ZWSI/MOU TOU= QEI/OU PERI\\ A)RETH=S [2PRA=CIS A#]2 &(e cod. Venet. Marc. 299, fol. 92v)": [
                "Volume",
                "page",
                "line",
            ],
            "c$*(ERMHNEI/A PERI\\ PA/NTWN A(PLW=S KAI\\ PERI\\ TW=N FW/TWN &(e cod. Paris. B.N. gr. 2327, fol. 264r)": [
                "Volume",
                "page",
                "line",
            ],
            "n$*ZW/SIMOS LE/GEI PERI\\ TH=S A)SBE/STOU &(e codd. Venet. Marc. 299, fol. 95r %7 Paris. B.N. gr. 2327, fol. 8v)": [
                "Volume",
                "page",
                "line",
            ],
            "\\$*ZWSI/MOU PRA=CIS B# &(e codd. Paris. B.N. gr. 2327, fol. 87v %7 Laur. gr. 86.16, fol. 93v)": [
                "line"
            ],
            "B$*PERI\\ TOU= QEI/OU U(/DATOS &(e cod. Venet. Marc. 299, fol. 113v)": [
                "Volume",
                "page",
                "line",
            ],
            "G$*POI/HSIS E)K TOUTI/AS A)RGU/ROU &(e cod. Venet. Marc. 299, fol. 188r)": [
                "Volume",
                "page",
                "line",
            ],
            "n$*PERI\\ DIAFORA=S XALKOU= KEKAUME/NOU &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 144r)": [
                "Volume",
                "page",
                "line",
            ],
            ";$*PERI\\ LEUKW/SEWS &(e cod. Paris. B.N. gr. 2327, fol. 265)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TW=N U(POSTA/TWN KAI\\ TW=N D# SWMA/TWN KATA\\ TO\\N *DHMO/KRITON TO\\N EI)PO/NTA &(fort. pars operis $*XEIRO": [
                "Volume",
                "page",
                "line",
            ],
            "O$*PERI\\ TOU= TRIBI/KOU KAI\\ TOU= SWLH=NOS &(e cod. Venet. Marc. 299, fol. 194r)": [
                "Volume",
                "page",
                "line",
            ],
            "b$*PERI\\ KAU/SEWS SWMA/TWN &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 154r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*ZWSI/MOU TOU= QEI/OU PERI\\ A)RETH=S:PERI\\ SUNQE/SEWS U(DA/TWN [2PRA=CIS A#]2 &(e codd. Venet. Marc. 299, fol. 9": [
                "line"
            ],
            "qExcerptum de vinctione virginis (sine titulo) (fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 1": [
                "Volume",
                "page",
                "line",
            ],
            "UExcerptum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 186v %7 187r, 195r)": [
                "Column",
                "line",
            ],
            "q$*PERI\\ TOU TRIBI/KOU KAI\\ TOU= SWLH=NOS &(e codd. Venet. Marc. 299, fol. 187r %7`186v, 194r; Paris. B.N. gr. 232": [
                "line"
            ],
            "H$*(ERMHNEI/A PERI\\ TW=N FW/TWN &(e cod. Paris. B.N. gr. 2327, fol. 265v)": [
                "Volume",
                "page",
                "line",
            ],
            "O$*PERI\\ DIAFORA=S XALKOU= KEKAUME/NOU &(e cod. Paris. B.N. gr. 2327, fol. 249v)": [
                "Volume",
                "page",
                "line",
            ],
            "Y$*PERI\\ STAQMW=N &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 153r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TH=S KATA\\ PLA/TOS E)KDO/SEWS TO\\ E)/RGON &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, f": [
                "Volume",
                "page",
                "line",
            ],
            "W$*PERI\\ BAFH=S &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 137v)": [
                "Volume",
                "page",
                "line",
            ],
            "a$*PARAINE/SEIS SUSTATIKAI\\ TW=N E)GXEIROU/NTWN TH\\N TE/XNHN &(e cod. Venet. Marc. 299, fol. 115r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*ZWSI/MOU TOU= *PANOPOLI/TOU GNHSI/A GRAFH\\ PERI\\ TH=S I(ERA=S KAI\\ QEI/AS TE/XNHS, TH=S TOU XRUSOU= KAI\\ A)RGU/": [
                "Volume",
                "page",
                "line",
            ],
            "qDiagramma (e codd. Venet. Marc. 299, fol. 188v; Paris. B.N. gr. 2325, fol. 82r %7 2327, fol. 80r; Laur. gr. 86.16": [
                "line"
            ],
            "$*PERI\\ STAQMOU= CANQW/SEWS &": ["Volume", "page", "line"],
            "X$*PERI\\ CHRI/OU &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Marc. 299, fol. 136v)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= XRHSTE/ON STUPTHRI/A| STROGGU/LH| A)NTI/LOGOS &(fort. pars operis $*XEIRO/MHKTA&) (e cod. Venet. Mar": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= QEI/OU U(/DATOS &(e codd. Venet. Marc. 299, fol. 188r; Paris. B.N. gr. 2325, fol. 82r %7 2327, fol. ": [
                "line"
            ],
            "n$*POI/HMA TOU= *ZWSI/MOU &($PRA=CIS G#&) (e codd. Paris. B.N. gr. 2327, fol. 88r %7 Laur. gr. 86.16, fol. 95r)": [
                "line"
            ],
            "K$*POI/HMA *ZWSI/MOU &($PRA=CIS G#&) (e cod. Paris. B.N. gr. 2327, fol. 88r)": [
                "Volume",
                "page",
                "line",
            ],
            "n$*TO\\ PRW=TON BIBLI/ON TH=S TELEUTAI/AS A)POXH=S *ZWSI/MOU *QHBAI/OU &(e cod. Paris. B.N. gr. 2327, fol. 251v)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Paradoxographus Vaticanus": {
        "tlg_id": "TLG0582",
        "names": {
            "name_authtab": "Paradoxographus Vaticanus",
            "name_idt": "Paradoxographus Vaticanus",
        },
        "works": {"Admiranda": ["Section", "line"]},
    },
    "Sthenelus Trag.": {
        "tlg_id": "TLG0315",
        "names": {"name_authtab": "Sthenelus Trag.", "name_idt": "Sthenelus Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Demetrius Junior Comic.": {
        "tlg_id": "TLG0440",
        "names": {
            "name_authtab": "Demetrius Junior Comic.",
            "name_idt": "Demetrius Junior Comic.",
        },
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Joannes Gramm., Theol.": {
        "tlg_id": "TLG2816",
        "names": {
            "name_authtab": "Joannes Gramm. et Theol.",
            "name_idt": "Joannes Gramm., Theol.",
        },
        "works": {
            "2Apologia concilii Chalcedonensis (excerpta Graeca)": ["line"],
            "Adversus Manichaeos (homilia 1)": ["line"],
            "FIn evangelium secundum Joannem (excerpta duo) (e cod. Vallicell. E 40)": [
                "line"
            ],
            "Adversus Aphthartodocetas": ["line"],
            "!Capitula xvii contra monophysitas": ["line"],
            "Disputatio cum Manichaeo": ["line"],
            "Syllogismi sanctoruum patrum": ["line"],
            "Adversus Manichaeos (homilia 2)": ["line"],
        },
    },
    "Lexicon De Atticis Nominibus": {
        "tlg_id": "TLG4292",
        "names": {
            "name_authtab": "Lexicon De Atticis Nominibus",
            "name_idt": "Lexicon De Atticis Nominibus",
        },
        "works": {
            "qDe Atticis nominibus (%6 $*PERI\\ *)ATTIKW=N O)NOMA/TWN&) (sub nomine cuiusdam Theaeteti grammatici) (e codd. Laur": [
                "Entry",
                "line",
            ],
            "qDe Atticis nominibus (%6 $*PERI\\ *)ATTIKW=N O)NOMA/TWN&) (sub nomine cuiusdam Theaeteti grammatici) (e cod. Laur.": [
                "Entry",
                "line",
            ],
        },
    },
    "Fronto Rhet.": {
        "tlg_id": "TLG0186",
        "names": {
            "name_authtab": "Marcus Cornelius Fronto Rhet.",
            "name_idt": "Fronto Rhet.",
        },
        "works": {
            "+Additamentum epistularum variarum acephalum": [
                "Epistle",
                "section",
                "line",
            ],
            "&Ad Marcum Caesarem et invicem (lib. 2)": ["Epistle", "section", "line"],
            "&Ad Marcum Caesarem et invicem (lib. 1)": ["Epistle", "section", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Ad amicos (lib. 1)": ["Epistle", "section", "line"],
        },
    },
    "Ptolemaeus": {
        "tlg_id": "TLG1642",
        "names": {"name_authtab": "Pseudo-Ptolemaeus", "name_idt": "Ptolemaeus"},
        "works": {"Fructus sive centiloquium": ["Section", "line"]},
    },
    "Pediasimus Philol., Rhet.": {
        "tlg_id": "TLG2592",
        "names": {
            "name_authtab": "Joannes Pediasimus Philol. et Rhet.",
            "name_idt": "Pediasimus Philol., Rhet.",
        },
        "works": {
            "WScholia in Hesiodi scutum (scholia paraphrastica Pediasimi et exegesis Joannis Tzetzae)": [
                "Page",
                "line",
            ]
        },
    },
    "Aristocreon Hist.": {
        "tlg_id": "TLG2455",
        "names": {"name_authtab": "Aristocreon Hist.", "name_idt": "Aristocreon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dositheus Magister Gramm.": {
        "tlg_id": "TLG4096",
        "names": {
            "name_authtab": "Dositheus Magister Gramm.",
            "name_idt": "Dositheus Magister Gramm.",
        },
        "works": {"Ars grammatica": ["Paragraph", "line"]},
    },
    "Nicostratus Comic.": {
        "tlg_id": "TLG0484",
        "names": {
            "name_authtab": "Nicostratus Comic.",
            "name_idt": "Nicostratus Comic.",
        },
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["line"],
        },
    },
    "Thrasyalces Phil.": {
        "tlg_id": "TLG2231",
        "names": {"name_authtab": "Thrasyalces Phil.", "name_idt": "Thrasyalces Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Anonymus De Metrorum Ratione": {
        "tlg_id": "TLG2117",
        "names": {
            "name_authtab": "Anonymus De Metrorum Ratione",
            "name_idt": "Anonymus De Metrorum Ratione",
        },
        "works": {"Fragmentum (P. Berol. 9734r)": ["line"]},
    },
    "Conventus Avium": {
        "tlg_id": "TLG0271",
        "names": {"name_authtab": "Conventus Avium", "name_idt": "Conventus Avium"},
        "works": {" Fragmentum (P. Cairo inv. 67860)": ["line"]},
    },
    "Diagoras Lyr.": {
        "tlg_id": "TLG0371",
        "names": {"name_authtab": "Diagoras Lyr.", "name_idt": "Diagoras Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Syriani, Sopatri Et Marcellini Scholia Ad Hermogenis Status": {
        "tlg_id": "TLG2047",
        "names": {
            "name_authtab": "Syriani, Sopatri Et Marcellini Scholia Ad Hermogenis Status",
            "name_idt": "Syriani, Sopatri Et Marcellini Scholia Ad Hermogenis Status",
        },
        "works": {
            "-Scholia ad Hermogenis librum $PERI\\ STA/SEWN&": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Menecrates Poet. Phil.": {
        "tlg_id": "TLG1500",
        "names": {
            "name_authtab": "Menecrates Poet. Phil.",
            "name_idt": "Menecrates Poet. Phil.",
        },
        "works": {"Fragmentum et titulus": ["Fragment", "line"]},
    },
    "Euboeus Parodius": {
        "tlg_id": "TLG1800",
        "names": {"name_authtab": "Euboeus Parodius", "name_idt": "Euboeus Parodius"},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta et titulus": ["Fragment", "line"],
        },
    },
    "Crito Comic.": {
        "tlg_id": "TLG0436",
        "names": {"name_authtab": "Crito Comic.", "name_idt": "Crito Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Ctesias Hist., Med.": {
        "tlg_id": "TLG0845",
        "names": {
            "name_authtab": "Ctesias Hist. et Med.",
            "name_idt": "Ctesias Hist., Med.",
        },
        "works": {
            "Fragmentum (P. Oxy. 24.2389)": ["FGrH fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Milon Phil.": {
        "tlg_id": "TLG1509",
        "names": {"name_authtab": "Milon Phil.", "name_idt": "Milon Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Eustathius Scr. Eccl., Theol.": {
        "tlg_id": "TLG4117",
        "names": {
            "name_authtab": "Eustathius Scr. Eccl. et Theol.",
            "name_idt": "Eustathius Scr. Eccl., Theol.",
        },
        "works": {
            "9Homilia christologica in Lazarum, Mariam et Martham [Sp.]": [
                "Section",
                "line",
            ],
            "QDe anima contra philosophos (ap. Joannem Damascenum, Sacra parallela) (fragmenta)": [
                "Fragment",
                "line",
            ],
            "$Orationes contra Arianos (fragmenta)": ["Fragment", "line"],
            "%Sermo catecheticus [Sp.] (fragmentum)": [
                "Fragment",
                "line",
                "Ñ",
                "l",
                "",
            ],
            " De engastrimytho contra Origenem": ["Chapter", "section", "line"],
            "+Allocutio ad imperatorem Constantinum [Sp.]": ["Page", "line"],
            " Commentarius in hexaemeron [Sp.]": ["Page", "line", "ÉÍÑ¶Üüp#³"],
            ")In Genesim de creatione [Sp.] (fragmenta)": [
                "Fragment",
                "line",
                "×",
                "Q",
                "",
            ],
            ">Commentarius in evangelium secundum Joannem [Sp.] (fragmentum)": [
                "Fragment",
                "line",
                "Ò",
                "\\",
                "",
            ],
            "In Proverbia (fragmenta)": ["Fragment", "line", ""],
            "De hebraismo (fragmenta)": ["Fragment", "line"],
            "($*)EK TOU= PANEKKLHSIASTOU= &(fragmenta)": ["line", "S", ""],
            "&Commentarius in Psalmum 92 (fragmenta)": ["Fragment", "line"],
            "!Fragmenta varia [Sp.] (fragmenta)": ["Fragment", "line", "", "c", ""],
            '"De fide contra Arianos (fragmenta)': ["Fragment", "line"],
            ",Commentarius in Psalmum 15 [Sp.] (fragmenta)": [
                "Fragment",
                "line",
                "",
                "®",
                "",
            ],
            "De Melchisedech (fragmenta)": ["Fragment", "line"],
            "In Joseph (fragmenta)": ["Fragment", "line"],
            "%In Ecclesiasten (fragmenta e catenis)": [
                "Fragment",
                "line",
                "Ï",
                "G",
                "¶",
            ],
            "4Oratio in inscriptione psalmorum graduum (fragmenta)": [
                "Fragment",
                "line",
            ],
            "%In inscriptione titulorum (fragmenta)": ["Fragment", "line"],
            "EOratio in illud: Dominus creavit me initium viarum suarum (fragmenta)": [
                "Fragment",
                "line",
            ],
            "1In Samaritanum (fragmenta e cod. Paris. gr. 1115)": ["Fragment", "line"],
            "#De anima contra Arianos (fragmenta)": ["Fragment", "line"],
        },
    },
    "Testamentum XL Martyrum": {
        "tlg_id": "TLG2015",
        "names": {
            "name_authtab": "Testamentum XL Martyrum",
            "name_idt": "Testamentum XL Martyrum",
        },
        "works": {"Testamentum xl martyrum": ["Chapter", "section", "line"]},
    },
    "Eudemus Poet. Med.": {
        "tlg_id": "TLG0888",
        "names": {
            "name_authtab": "Eudemus Poet. Med.",
            "name_idt": "Eudemus Poet. Med.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Archelaus Paradox.": {
        "tlg_id": "TLG0570",
        "names": {
            "name_authtab": "Archelaus Paradox.",
            "name_idt": "Archelaus Paradox.",
        },
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Vita Sophoclis": {
        "tlg_id": "TLG4318",
        "names": {"name_authtab": "Vita Sophoclis", "name_idt": "Vita Sophoclis"},
        "works": {"Vita Sophoclis": ["line"]},
    },
    "Gregorius Thaumaturgus Scr. Eccl.": {
        "tlg_id": "TLG2063",
        "names": {
            "name_authtab": "Gregorius Thaumaturgus Scr. Eccl.",
            "name_idt": "Gregorius Thaumaturgus Scr. Eccl.",
        },
        "works": {
            "": ["Epistula canonica", "Section", "line"],
            "De fide capitula duodecim": ["line"],
            "In Origenem oratio panegyrica": ["Section", "line"],
            ">In annuntiationem sanctae virginis Mariae (homiliae 1-2) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "6Fragmentum in evangelium Matthaei 6.22-23 (in catenis)": [
                "Volume",
                "page",
                "line",
            ],
            "%Metaphrasis in Ecclesiasten Salamonis": ["Page", "line"],
            '"Sententiae (ap. Antonium Melissam)': ["Fragment", "line"],
            "Fragmentum in Job (in catenis)": ["Page", "line"],
            '"Fragmenta in Jeremiam (in catenis)': ["Page", "line"],
            "6$*EI)S TO\\ OU)DE\\N EI)/DWLON E)N KO/SMW| &(fragmentum)": [
                "Fragment",
                "line",
            ],
            "0Ad Tatianum de anima per capita disputatio [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "Sermo in omnes sanctos [Sp.]": ["Volume", "page", "line"],
        },
    },
    "Barlaam Math., Theol., Epist.": {
        "tlg_id": "TLG3159",
        "names": {
            "name_authtab": "Barlaam Math., Theol. et Epist.",
            "name_idt": "Barlaam Math., Theol., Epist.",
        },
        "works": {
            "3Paraphrasis in Euclidis elementorum librum secundum": ["Page", "line"]
        },
    },
    "Socraticorum Epistulae": {
        "tlg_id": "TLG0637",
        "names": {
            "name_authtab": "Socraticorum Epistulae",
            "name_idt": "Socraticorum Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Oenopides Phil.": {
        "tlg_id": "TLG2234",
        "names": {"name_authtab": "Oenopides Phil.", "name_idt": "Oenopides Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Chronographiae Anonymae": {
        "tlg_id": "TLG2738",
        "names": {
            "name_authtab": "Chronographiae Anonymae",
            "name_idt": "Chronographiae Anonymae",
        },
        "works": {
            "2Chronographia brevis (e cod. Paris. suppl. gr. 67)": ["Page", "line"],
            "*Chronographia brevis (e cod. Coislin. 193)": ["Page", "line"],
            ",Chronographia brevis (e cod. Monac. gr. 510)": ["Page", "line"],
        },
    },
    "Hesychius Scr. Eccl.": {
        "tlg_id": "TLG2797",
        "names": {
            "name_authtab": "Hesychius Scr. Eccl.",
            "name_idt": "Hesychius Scr. Eccl.",
        },
        "works": {
            "(In sanctos Petrum et Paulum (homilia 13)": [
                "Section",
                "line",
                "",
                "[\x13´",
            ],
            "CHomilia ii in sanctum pascha (homilia 4) (e cod. Sinaitico gr. 492)": [
                "Section",
                "line",
            ],
            ".Homilia ii de sancta Maria deipara (homilia 6)": ["Section", "line"],
            ":Homilia de jejunio (homilia 15) (e cod. Sinaitico gr. 491)": [
                "Section",
                "line",
            ],
            ">Homilia ii in sanctum Longinum centurionem (homilia 20) [Dub.]": [
                "Section",
                "line",
            ],
            "#Homilia ii de Hypapante (homilia 2)": ["Section", "line"],
            "TIn Lazarum et in ramos palmarum (homilia 18) (olim sub nomine Titi Bostrensis) [Sp.]": [
                "Section",
                "line",
            ],
            '"Homilia i de Hypapante (homilia 1)': ["Section", "line"],
            "HIn sanctos Jacobum et David (homilia 10) (e Photii Bibliotheca cod. 275)": [
                "Section",
                "line",
            ],
            "BHomilia i in sanctum pascha (homilia 3) (e cod. Sinaitico gr. 492)": [
                "Section",
                "line",
            ],
            "!In sanctum Procopium (homilia 14)": ["Section", "line"],
            "=Homilia i in sanctum Longinum centurionem (homilia 19) [Dub.]": [
                "Section",
                "line",
            ],
            "5In conceptionem venerabilis praecursoris (homilia 16)": [
                "Section",
                "line",
            ],
            "4In sanctos martyres (fragmentum) (homilia 17) [Dub.]": [
                "Section",
                "line",
            ],
            "-Homilia i de sancta Maria deipara (homilia 5)": ["Section", "line"],
            "$In sanctum Lucam (homilia 21) [Dub.]": ["Section", "line"],
            "*Homilia ii in sanctum Lazarum (homilia 12)": ["Section", "line", "´"],
            " In sanctum Stephanum (homilia 9)": ["Section", "line"],
            ")Homilia i in sanctum Lazarum (homilia 11)": ["Section", "line"],
            "In sanctum Antonium (homilia 8)": ["Section", "line"],
            "In sanctum Andream (homilia 7)": ["Section", "line"],
        },
    },
    "Philocles Trag.": {
        "tlg_id": "TLG0312",
        "names": {"name_authtab": "Philocles Trag.", "name_idt": "Philocles Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dionysius Thrax Gramm.": {
        "tlg_id": "TLG0063",
        "names": {
            "name_authtab": "Dionysius Thrax Gramm.",
            "name_idt": "Dionysius Thrax Gramm.",
        },
        "works": {
            "Fragmentum": ["line", "fragment", "line"],
            "Testimonium": ["line", "fragment", "line"],
            "Ars grammatica": ["Part", "volume", "page", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Timagetus Hist.": {
        "tlg_id": "TLG4396",
        "names": {"name_authtab": "Timagetus Hist.", "name_idt": "Timagetus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cedrenus Chronogr.": {
        "tlg_id": "TLG3018",
        "names": {
            "name_authtab": "Georgius Cedrenus Chronogr.",
            "name_idt": "Cedrenus Chronogr.",
        },
        "works": {"Compendium historiarum": ["Volume", "page", "line"]},
    },
    "Vettius Valens Astrol.": {
        "tlg_id": "TLG1764",
        "names": {
            "name_authtab": "Vettius Valens Astrol.",
            "name_idt": "Vettius Valens Astrol.",
        },
        "works": {"Anthologiarum libri ix": ["Page", "line"]},
    },
    "Polycharmus Hist.": {
        "tlg_id": "TLG1623",
        "names": {"name_authtab": "Polycharmus Hist.", "name_idt": "Polycharmus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "[Menyllus] Hist.": {
        "tlg_id": "TLG2202",
        "names": {"name_authtab": "[Menyllus] Hist.", "name_idt": "[Menyllus] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Euphro Comic.": {
        "tlg_id": "TLG0460",
        "names": {"name_authtab": "Euphro Comic.", "name_idt": "Euphro Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Martyrium Ptolemaei Et Lucii": {
        "tlg_id": "TLG1485",
        "names": {
            "name_authtab": "Martyrium Ptolemaei Et Lucii",
            "name_idt": "Martyrium Ptolemaei Et Lucii",
        },
        "works": {"Martyrium Ptolemaei et Lucii": ["Section", "line"]},
    },
    "Hipparchus Phil.": {
        "tlg_id": "TLG1432",
        "names": {"name_authtab": "Hipparchus Phil.", "name_idt": "Hipparchus Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Aethlius Hist.": {
        "tlg_id": "TLG0686",
        "names": {"name_authtab": "Aethlius Hist.", "name_idt": "Aethlius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Macarius Scr. Eccl.": {
        "tlg_id": "TLG2109",
        "names": {
            "name_authtab": "Pseudo-Macarius Scr. Eccl.",
            "name_idt": "Macarius Scr. Eccl.",
        },
        "works": {
            "Sermo 28 (recensio brevior)": ["Page", "line"],
            "Homiliae 7 (collectio HA)": ["Homily", "section", "line"],
            "Sermones 1-22, 24-27": ["Homily", "section", "line"],
            "Preces": ["Volume", "page", "line"],
            "%Homiliae spirituales 50 (collectio H)": ["Homily", "line"],
            "#Opusculum 1 (%6 De custodia cordis)": ["Volume", "page", "line"],
            "Sermo 23 (recensio excerpta)": ["Page", "line"],
            "Sermones 64 (collectio B)": ["Homily", "chapter", "section", "line"],
            "Epistula magna": ["Page", "line"],
            "Sermo 23 (recensio completa)": ["Page", "line"],
            "Sermo 28 (recensio expletior)": ["Page", "line"],
            "Apophthegmata": ["Volume", "page", "line"],
            "Sermo 17 (excerpta)": ["Page", "line"],
        },
    },
    "Maximus Soph.": {
        "tlg_id": "TLG0563",
        "names": {"name_authtab": "Maximus Soph.", "name_idt": "Maximus Soph."},
        "works": {"Dialexeis": ["Lecture", "chapter", "section", "line"]},
    },
    "Theocritus Bucol.": {
        "tlg_id": "TLG0005",
        "names": {"name_authtab": "Theocritus Bucol.", "name_idt": "Theocritus Bucol."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Idyllia": ["Idyll", "line"],
            "Syrinx": ["line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Scholia In Xenophontem": {
        "tlg_id": "TLG5040",
        "names": {
            "name_authtab": "Scholia In Xenophontem",
            "name_idt": "Scholia In Xenophontem",
        },
        "works": {")Scholia in anabasin Cyri (scholia vetera)": ["Scholion", "line"]},
    },
    "Timocles Comic.": {
        "tlg_id": "TLG0515",
        "names": {"name_authtab": "Timocles Comic.", "name_idt": "Timocles Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Lexicon Sabbaiticum": {
        "tlg_id": "TLG4300",
        "names": {
            "name_authtab": "Lexicon Sabbaiticum",
            "name_idt": "Lexicon Sabbaiticum",
        },
        "works": {
            "+Lexicon Sabbaiticum (e cod. Sabbaitico 137)": [
                "",
                "Alphabetic letter",
                "page",
                "line",
            ]
        },
    },
    "Hegesander Hist.": {
        "tlg_id": "TLG1392",
        "names": {"name_authtab": "Hegesander Hist.", "name_idt": "Hegesander Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Nicomachus Trag.": {
        "tlg_id": "TLG1843",
        "names": {"name_authtab": "Nicomachus Trag.", "name_idt": "Nicomachus Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Ptolemaei II Philadelphi Et Eleazari Epistulae": {
        "tlg_id": "TLG0050",
        "names": {
            "name_authtab": "Ptolemaei II Philadelphi Et Eleazari Epistulae",
            "name_idt": "Ptolemaei II Philadelphi Et Eleazari Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Parmenides Poet. Phil.": {
        "tlg_id": "TLG1562",
        "names": {
            "name_authtab": "Parmenides Poet. Phil.",
            "name_idt": "Parmenides Poet. Phil.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "[Pyrander] Hist.": {
        "tlg_id": "TLG2349",
        "names": {"name_authtab": "[Pyrander] Hist.", "name_idt": "[Pyrander] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diphilus Epic., Iamb.": {
        "tlg_id": "TLG0248",
        "names": {
            "name_authtab": "Diphilus Epic. et Iamb.",
            "name_idt": "Diphilus Epic., Iamb.",
        },
        "works": {"Fragmentum": ["line"]},
    },
    "Demonax Trag.": {
        "tlg_id": "TLG0349",
        "names": {"name_authtab": "Demonax Trag.", "name_idt": "Demonax Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Andromachus Poet. Med.": {
        "tlg_id": "TLG0280",
        "names": {
            "name_authtab": "Andromachus Poet. Med.",
            "name_idt": "Andromachus Poet. Med.",
        },
        "works": {"Fragmentum": ["line"]},
    },
    "Metagenes Comic.": {
        "tlg_id": "TLG0475",
        "names": {"name_authtab": "Metagenes Comic.", "name_idt": "Metagenes Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Thebaïs": {
        "tlg_id": "TLG1712",
        "names": {"name_authtab": "Thebaïs", "name_idt": "Thebaïs"},
        "works": {"Thebai+s (fragmenta)": ["Fragment", "line"]},
    },
    "Clidemus Phil.": {
        "tlg_id": "TLG2305",
        "names": {"name_authtab": "Clidemus Phil.", "name_idt": "Clidemus Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Phrynichus II Trag.": {
        "tlg_id": "TLG0876",
        "names": {
            "name_authtab": "Phrynichus II Trag.",
            "name_idt": "Phrynichus II Trag.",
        },
        "works": {"Tituli": ["line"]},
    },
    "Parmeno Iamb.": {
        "tlg_id": "TLG1566",
        "names": {"name_authtab": "Parmeno Iamb.", "name_idt": "Parmeno Iamb."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Horapollo Gramm.": {
        "tlg_id": "TLG2052",
        "names": {"name_authtab": "Horapollo Gramm.", "name_idt": "Horapollo Gramm."},
        "works": {
            "#Hieroglyphica (translatio Philippi)": ["Book", "section", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Theodorus Scutariota Hist.": {
        "tlg_id": "TLG3157",
        "names": {
            "name_authtab": "Theodorus Scutariota Hist.",
            "name_idt": "Theodorus Scutariota Hist.",
        },
        "works": {
            ",Additamenta ad Georgii Acropolitae historiam": ["Fragment", "line"]
        },
    },
    "Aristagoras Comic.": {
        "tlg_id": "TLG0418",
        "names": {
            "name_authtab": "Aristagoras Comic.",
            "name_idt": "Aristagoras Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Comica Adespota (FCG)": {
        "tlg_id": "TLG0602",
        "names": {
            "name_authtab": "Comica Adespota (FCG)",
            "name_idt": "Comica Adespota (FCG)",
        },
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Fragmenta comicorum anonymorum": ["Play", "fragment", "line"],
        },
    },
    "Harmodius Hist.": {
        "tlg_id": "TLG1388",
        "names": {"name_authtab": "Harmodius Hist.", "name_idt": "Harmodius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Vitae Oppiani": {
        "tlg_id": "TLG4172",
        "names": {"name_authtab": "Vitae Oppiani", "name_idt": "Vitae Oppiani"},
        "works": {
            "IVita Oppiani Anazarbensis (e cod. phil. gr. 135 in Bibl. nat. in Vindob.)": [
                "line"
            ],
            "Vita Oppiani (Vita $B&)": ["line"],
            "NVita Tzetziana (e codd. Laur. gr. 31.3, Ambros. gr. C 222 inf., Vat. gr. 1345)": [
                "line"
            ],
            "Vita Oppiani (Vita $A&)": ["line"],
        },
    },
    "Apollodorus Comic.": {
        "tlg_id": "TLG0413",
        "names": {
            "name_authtab": "Apollodorus Comic.",
            "name_idt": "Apollodorus Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Heraclides Hist.": {
        "tlg_id": "TLG1406",
        "names": {"name_authtab": "Heraclides Hist.", "name_idt": "Heraclides Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Lexica Syntactica": {
        "tlg_id": "TLG4286",
        "names": {"name_authtab": "Lexica Syntactica", "name_idt": "Lexica Syntactica"},
        "works": {
            "%Lexicon syntacticum (specimen tantum)": ["Page", "line"],
            "RLexicon syntacticum (%6$ *)ARXH\\ SU\\N QEW=| TH=S SUNTA/CEWS&) (e cod. Laur. 59,16)": [
                "",
                "Alphabetic letter",
                "page",
                "line",
            ],
            "(Lexicon syntacticum (e cod. Laur. 59,16)": ["Entry", "line"],
            "qLexicon syntacticum (%6 $*)ARXH\\ SU\\N QEW=| TW=N SUNTA/CEWN PW=S DEI= O)FEI/LEIN SUNTA/SSEIN TA\\S R(HMATIKA\\S LE/": [
                "",
                "Alphabetic letter",
                "page",
                "line",
            ],
        },
    },
    "Adrianus Rhet., Soph.": {
        "tlg_id": "TLG0666",
        "names": {
            "name_authtab": "Adrianus Rhet. et Soph.",
            "name_idt": "Adrianus Rhet., Soph.",
        },
        "works": {"Declamatio": ["Page", "line"]},
    },
    "Gennadius I Scr. Eccl.": {
        "tlg_id": "TLG2762",
        "names": {
            "name_authtab": "Gennadius I Scr. Eccl.",
            "name_idt": "Gennadius I Scr. Eccl.",
        },
        "works": {
            "3Fragmenta in epistulam i ad Corinthios (in catenis)": ["Page", "line"],
            "5Fragmentum in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Galatas (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            ";Fragmentum in epistulam ii ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "/Fragmenta in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
        },
    },
    "Xenagoras Geogr., Hist.": {
        "tlg_id": "TLG1752",
        "names": {
            "name_authtab": "Xenagoras Geogr. et Hist.",
            "name_idt": "Xenagoras Geogr., Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Acropolites Hist.": {
        "tlg_id": "TLG3141",
        "names": {
            "name_authtab": "Georgius Acropolites Hist.",
            "name_idt": "Acropolites Hist.",
        },
        "works": {
            "Laudatio Petri et Pauli": ["Section", "line"],
            "!Epitaphius in Irenam imperatricem": ["line"],
            "(Praefatio in epistulas Theodori Lascaris": ["line"],
            "Epitaphius in Joannem Ducam": ["Section", "line"],
            "In imaginem beatae virginis": ["line"],
            "Annales": ["Section", "line"],
            "!In Gregorii Nazianzeni sententias": ["Section", "line"],
            "Epistula ad Joannem Tornicem": ["Page", "line"],
            "Carmen in magnum sabbatum": ["line"],
            "Historia in brevius redacta": ["Section", "line"],
            "Contra Latinos": ["Oration", "section", "line"],
        },
    },
    "Danaïs vel Danaïdes": {
        "tlg_id": "TLG0364",
        "names": {
            "name_authtab": "Danaïs vel Danaïdes",
            "name_idt": "Danaïs vel Danaïdes",
        },
        "works": {'"Danai+s vel Danai+des (fragmentum)': ["Fragment", "line"]},
    },
    "Antimachus Eleg., Epic.": {
        "tlg_id": "TLG0239",
        "names": {
            "name_authtab": "Antimachus Eleg. et Epic.",
            "name_idt": "Antimachus Eleg., Epic.",
        },
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Antidotus Comic.": {
        "tlg_id": "TLG0409",
        "names": {"name_authtab": "Antidotus Comic.", "name_idt": "Antidotus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Sozomenus Scr. Eccl.": {
        "tlg_id": "TLG2048",
        "names": {
            "name_authtab": "Salaminius Hermias Sozomenus Scr. Eccl.",
            "name_idt": "Sozomenus Scr. Eccl.",
        },
        "works": {"Historia ecclesiastica": ["Book", "chapter", "section", "line"]},
    },
    "Joannes Philoponus Phil.": {
        "tlg_id": "TLG4015",
        "names": {
            "name_authtab": "Joannes Philoponus Phil.",
            "name_idt": "Joannes Philoponus Phil.",
        },
        "works": {
            "": ["De opificio mundi", "Page", "line"],
            "+In Aristotelis analytica priora commentaria": ["Volume", "page", "line"],
            "/In Aristotelis analytica posteriora commentaria": [
                "Volume",
                "page",
                "line",
            ],
            ".In libros de generatione animalium commentaria": [
                "Volume",
                "page",
                "line",
            ],
            "]De vocabulis quae diversum significatum exhibent secundum differentiam accentus (additamenta)": [
                "Page",
                "line",
            ],
            "'De usu astrolabii eiusque constructione": ["Page", "line"],
            "ODe vocabulis quae diversum significatum exhibent secundum differentiam accentus": [
                "Recensio",
                "",
                "alphabetic letter",
                "entry",
                "line",
            ],
            "?In Aristotelis libros de generatione et corruptione commentaria": [
                "Volume",
                "page",
                "line",
            ],
            ":In Aristotelis meteorologicorum librum primum commentarium": [
                "Volume",
                "page",
                "line",
            ],
            "GIn Aristotelis analytica posteriora commentaria (prooemium e codd. BRL)": [
                "Volume",
                "page",
                "line",
            ],
            "*In Aristotelis libros de anima commentaria": ["Volume", "page", "line"],
            "&In Aristotelis categorias commentarium": ["Volume", "page", "line"],
            "De aeternitate mundi": ["Page", "line"],
            ",In Aristotelis physicorum libros commentaria": ["Volume", "page", "line"],
        },
    },
    "Cincius Alimentus Hist.": {
        "tlg_id": "TLG2543",
        "names": {
            "name_authtab": "Lucius Cincius Alimentus Hist.",
            "name_idt": "Cincius Alimentus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philippus Comic.": {
        "tlg_id": "TLG1781",
        "names": {"name_authtab": "Philippus Comic.", "name_idt": "Philippus Comic."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Lyrica Adespota (SLG)": {
        "tlg_id": "TLG1471",
        "names": {
            "name_authtab": "Lyrica Adespota (SLG)",
            "name_idt": "Lyrica Adespota (SLG)",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymi De Astrologia Dialogus Astrol.": {
        "tlg_id": "TLG4374",
        "names": {
            "name_authtab": "Anonymi De Astrologia Dialogus Astrol.",
            "name_idt": "Anonymi De Astrologia Dialogus Astrol.",
        },
        "works": {
            "EDe astrologia dialogus (%6 Hermippus) (fort. auctore Joanne Catrario)": [
                "Page",
                "line",
            ]
        },
    },
    "Didymus Gramm.": {
        "tlg_id": "TLG1312",
        "names": {"name_authtab": "Didymus Gramm.", "name_idt": "Didymus Gramm."},
        "works": {
            "In Demosthenem (P. Berol. 9780)": ["Column", "line"],
            ")De dubiis apud Platonem lectionibus [Sp.]": ["Page", "line"],
        },
    },
    "Teucer Hist.": {
        "tlg_id": "TLG1704",
        "names": {"name_authtab": "Teucer Hist.", "name_idt": "Teucer Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Canon Librorum": {
        "tlg_id": "TLG1242",
        "names": {"name_authtab": "Canon Librorum", "name_idt": "Canon Librorum"},
        "works": {"Canon librorum": ["Section", "line"]},
    },
    "Teucer Astrol.": {
        "tlg_id": "TLG1703",
        "names": {"name_authtab": "Teucer Astrol.", "name_idt": "Teucer Astrol."},
        "works": {
            "CDe duodecim signis (Rhetorii Aegyptii excerpta) (e cod. Berol. 173)": [
                "Volume",
                "page",
                "line",
            ],
            ":De sideribus consurgentibus (fragmenta) (e cod. Danensi 2)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Chariclides Comic.": {
        "tlg_id": "TLG0430",
        "names": {
            "name_authtab": "Chariclides Comic.",
            "name_idt": "Chariclides Comic.",
        },
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Callicrates Comic.": {
        "tlg_id": "TLG1783",
        "names": {
            "name_authtab": "Callicrates Comic.",
            "name_idt": "Callicrates Comic.",
        },
        "works": {"Titulus": ["Page", "line"]},
    },
    "Nicolaus I Mysticus Theol., Epist.": {
        "tlg_id": "TLG3100",
        "names": {
            "name_authtab": "Nicolaus I Mysticus Theol. et Epist.",
            "name_idt": "Nicolaus I Mysticus Theol., Epist.",
        },
        "works": {
            "Epistulae": ["Epistle", "line"],
            "Opuscula diversa": ["Section", "line"],
        },
    },
    "Martyrium Marini": {
        "tlg_id": "TLG2009",
        "names": {"name_authtab": "Martyrium Marini", "name_idt": "Martyrium Marini"},
        "works": {"Martyrium Marini": ["Section", "line"]},
    },
    "Dionysius Scytobrachion Gramm.": {
        "tlg_id": "TLG1881",
        "names": {
            "name_authtab": "Dionysius Scytobrachion Gramm.",
            "name_idt": "Dionysius Scytobrachion Gramm.",
        },
        "works": {
            "Fragmentum (P. Mich. 1316)": ["FGrH fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Symeon Hist.": {
        "tlg_id": "TLG3182",
        "names": {"name_authtab": "Pseudo-Symeon Hist.", "name_idt": "Symeon Hist."},
        "works": {
            "3Chronographia (partim edita e cod. Paris. gr. 1712)": ["Page", "line"]
        },
    },
    "Matron Parodius": {
        "tlg_id": "TLG1486",
        "names": {"name_authtab": "Matron Parodius", "name_idt": "Matron Parodius"},
        "works": {"": ["Convivium Atticum", "line"], "Fragmenta": ["Fragment", "line"]},
    },
    "Dromo Comic.": {
        "tlg_id": "TLG0448",
        "names": {"name_authtab": "Dromo Comic.", "name_idt": "Dromo Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Neanthes Hist.": {
        "tlg_id": "TLG1525",
        "names": {"name_authtab": "Neanthes Hist.", "name_idt": "Neanthes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollodorus Lyr.": {
        "tlg_id": "TLG0365",
        "names": {"name_authtab": "Apollodorus Lyr.", "name_idt": "Apollodorus Lyr."},
        "works": {"Fragmentum": ["line"]},
    },
    "Apocalypsis Sophoniae": {
        "tlg_id": "TLG1160",
        "names": {
            "name_authtab": "Apocalypsis Sophoniae",
            "name_idt": "Apocalypsis Sophoniae",
        },
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Philodamus Lyr.": {
        "tlg_id": "TLG0205",
        "names": {"name_authtab": "Philodamus Lyr.", "name_idt": "Philodamus Lyr."},
        "works": {
            "": ["Paean in Dionysum", "line"],
            "-Paean in Dionysum (fragmenta incerti ordinis)": ["Fragment", "line"],
        },
    },
    "Apollonius Paradox.": {
        "tlg_id": "TLG0569",
        "names": {
            "name_authtab": "Apollonius Paradox.",
            "name_idt": "Apollonius Paradox.",
        },
        "works": {"Historiae mirabiles": ["Chapter", "section", "line"]},
    },
    "Evangelium Bartholomaei": {
        "tlg_id": "TLG1366",
        "names": {
            "name_authtab": "Evangelium Bartholomaei",
            "name_idt": "Evangelium Bartholomaei",
        },
        "works": {
            " Fragmenta evangelii Bartholomaei": ["Fragment", "section", "line"],
            "Evangelium Bartholomaei": ["Chapter", "section", "line"],
        },
    },
    "Dei(l)ochus Hist.": {
        "tlg_id": "TLG2326",
        "names": {"name_authtab": "Dei(l)ochus Hist.", "name_idt": "Dei(l)ochus Hist."},
        "works": {
            "Fragmentum": ["FGrH fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Diodorus Siculus Hist.": {
        "tlg_id": "TLG0060",
        "names": {
            "name_authtab": "Diodorus Siculus Hist.",
            "name_idt": "Diodorus Siculus Hist.",
        },
        "works": {
            "!Bibliotheca historica (lib. 1-20)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "Fragmenta sedis incertae": ["Fragment", "line"],
            '"Bibliotheca historica (lib. 21-40)': [
                "Book",
                "chapter",
                "section",
                "line",
            ],
        },
    },
    "Diogenis Sinopensis Epistulae": {
        "tlg_id": "TLG1325",
        "names": {
            "name_authtab": "Diogenis Sinopensis Epistulae",
            "name_idt": "Diogenis Sinopensis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Eutychianus Hist.": {
        "tlg_id": "TLG2158",
        "names": {"name_authtab": "Eutychianus Hist.", "name_idt": "Eutychianus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Ergias Hist.": {
        "tlg_id": "TLG1354",
        "names": {"name_authtab": "Ergias Hist.", "name_idt": "Ergias Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Dionysius Scr. Eccl.": {
        "tlg_id": "TLG1329",
        "names": {
            "name_authtab": "Dionysius Scr. Eccl.",
            "name_idt": "Dionysius Scr. Eccl.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Eutocius Math.": {
        "tlg_id": "TLG4072",
        "names": {"name_authtab": "Eutocius Math.", "name_idt": "Eutocius Math."},
        "works": {
            "": ["&1Eutocius& Math."],
            "#Commentarius in dimensionem circuli": ["Page", "line"],
            "Commentaria in conica": ["Page", "line"],
            ",Commentarii in libros de sphaera et cylindro": ["Page", "line"],
            "/Commentarius in libros de planorum aequilibriis": ["Page", "line"],
        },
    },
    "Herodianus et Pseudo-Herodianus Gramm., Rhet.": {
        "tlg_id": "TLG0087",
        "names": {
            "name_authtab": "Aelius Herodianus et Pseudo-Herodianus Gramm. et Rhet.",
            "name_idt": "Herodianus et Pseudo-Herodianus Gramm., Rhet.",
        },
        "works": {
            "": [
                "$*$*PERI\\ METOXW=N& !!! TRANSLITERATE",
                "Part+volume",
                "page",
                "line",
            ],
            "$*PERI\\ O)NOMA/TWN&": ["Part+volume", "page", "line"],
            "'$*PERI\\ SOLOIKISMOU= KAI\\ BARBARISMOU=&": ["Page", "line"],
            "$*PERI\\ A)NTWNUMIW=N&": ["Part+volume", "page", "line"],
            "XPhiletaerus [Sp.?] (fort. auctore Corneliano) (e codd. Vat. gr. 2226 %7 Paris. gr. 2552)": [
                "Section",
                "line",
            ],
            "&$*PAREKBOLAI\\ TOU= MEGA/LOU R(H/MATOS&": ["Page", "line"],
            "#$*PERI\\ *)ODUSSEIAKH=S PROSW|DI/AS&": ["Part+volume", "page", "line"],
            "jFragmentum grammaticum quod incipit a vocibus $ZHTOU=MEN KAI\\ TH\\N TOU= *)/ARHS& [Sp.] (e cod. Barocc. 76)": [
                "Page",
                "line",
            ],
            "!De enclisi (epitome ap. Arcadium)": ["Part+volume", "page", "line"],
            "$*MONO/BIBLON PERI\\ TOU= H)=N&": ["Part+volume", "page", "line"],
            "$*PERI\\ O)RQOGRAFI/AS&": ["Part+volume", "page", "line"],
            "Schematismi Homerici": ["Section", "line"],
            '"De figuris (%6 $*PERI\\ SXHMA/TWN&)': ["Part+volume", "page", "line"],
            "De versibus": ["line"],
            "1$*EI)S TO\\ PERI\\ GENW=N *)APOLLWNI/OU U(PO/MNHMA&": [
                "Part+volume",
                "page",
                "line",
            ],
            "$*PERI\\ PAQW=N&": ["Part+volume", "page", "line"],
            "$*PROTA/SEIS&": ["Part+volume", "page", "line"],
            "$*PERI\\ DIXRO/NWN&": ["Part+volume", "page", "line"],
            "$*PERI\\ *)ATTIKH=S PROSW|DI/AS&": ["Part+volume", "page", "line"],
            "&$*EI)S TH\\N *)APOLLWNI/OU EI)SAGWGH/N&": ["Part+volume", "page", "line"],
            "$*PERI\\ MONOSULLA/BWN&": ["Part+volume", "page", "line"],
            "$*SUMPO/SION&": ["Part+volume", "page", "line"],
            "$*PERI\\ SUZUGIW=N&": ["Part+volume", "page", "line"],
            "$*PERI\\ TOU= ZW/S&": ["Part+volume", "page", "line"],
            "qDe locutionum pravitatibus (prior pars operis) [Sp.] (fort. auctore Corneliano) (e codd. Barocc. 76 %7 Laur. VI-2": [
                "Page",
                "line",
            ],
            "*$*PERI\\ AU)QUPOTA/KTWN KAI\\ A)NUPOTA/KTWN&": ["Page", "line"],
            "3Excerpta e Herodiano [Sp.] (e cod. Paris. gr. 2552)": ["Page", "line"],
            "$*PERI\\ PNEUMA/TWN&": ["Part+volume", "page", "line"],
            "FPartitiones (%6$ *)EPIMERISMOI/&) [Sp.?] (e codd. Paris. 2543 %7 2570)": [
                "Page",
                "line",
            ],
            "$*PERI\\ KLI/SEWS O)NOMA/TWN&": ["Part+volume", "page", "line"],
            "A$*PERI\\ PARAGWGW=N GENIKW=N A)PO\\ DIALE/KTWN &(e cod. Barroc. 76)": [
                "Page",
                "line",
            ],
            "?$*PERI\\ KURI/WN KAI\\ E)PIQE/TWN KAI\\ PROSHGORIKW=N MONO/BIBLON&": [
                "Part+volume",
                "page",
                "line",
            ],
            " $*PERI\\ GA/MOU KAI\\ SUMBIW/SEWS&": ["Part+volume", "page", "line"],
            "(De figuris (%6 $*PERI\\ SXHMA/TWN&) [Sp.]": ["Page", "line"],
            "$*PERI\\ LE/CEWS TW=N STI/XWN&": ["line"],
            "$*PERI\\ *)ILIAKH=S PROSW|DI/AS&": ["Part+volume", "page", "line"],
            "PExcerpta e Herodiano [Sp.] (e codd. Paris. gr. 2650 %7 2662 %7 Paris. suppl. 70)": [
                "Fragment",
                "line",
            ],
            "#$*PERI\\ SUNTA/CEWS TW=N STOIXEI/WN&": ["Part+volume", "page", "line"],
            "$*PERI\\ PARWNU/MWN&": ["Part+volume", "page", "line"],
            '"$*PERI\\ A)RIQMW=N &(ap. Stephanum)': ["line"],
            "$*PERI\\ R(HMATIKW=N O)NOMA/TWN&": ["Part+volume", "page", "line"],
            "$*PERI\\ R(HMA/TWN&": ["Part+volume", "page", "line"],
            "De prosodia catholica": ["Part+volume", "page", "line"],
            "$*PERI\\ PAQW=N &(supplementum)": ["Part+volume", "page", "line"],
            "$*PERI\\ E)PIRRHMA/TWN&": ["Part+volume", "page", "line"],
            "$*PERI\\ TW=N EI)S <MI>&": ["Part+volume", "page", "line"],
            "qDe locutionum pravitatibus (posterior pars operis) [Sp.] (fort. auctore Corneliano) (e cod. Paris. suppl. gr. 123": [
                "Page",
                "line",
            ],
            " $*MONO/BIBLON PERI\\ TOU= U(/DWR&": ["Part+volume", "page", "line"],
            "X$*MONO/BIBLON PERI\\ TOU= MH\\ PA/NTA TA\\ R(H/MATA KLI/NESQAI EI)S PA/NTAS TOU\\S XRO/NOUS&": [
                "Part+volume",
                "page",
                "line",
            ],
            "$*PERI\\ MONH/ROUS LE/CEWS&": ["Part+volume", "page", "line"],
        },
    },
    "Vitae Homeri": {
        "tlg_id": "TLG1805",
        "names": {"name_authtab": "Vitae Homeri", "name_idt": "Vitae Homeri"},
        "works": {
            "[2Plutarchi]2 De Homero 1": ["line"],
            "*Vita septima (Eustathii vita, Od. 1713.17)": ["line"],
            "Tzetzae vita (Chil. 13.626-665)": ["Chiliad line"],
            "[2Plutarchi]2 De Homero 2": ["line"],
            "Vita sexta": ["line"],
            "Vita quarta": ["line"],
            "Vita quinta": ["line"],
            "Vita Herodotea": ["line"],
            "Vita Proculea (e Chrestomathia)": ["Page", "line"],
            "Sudae vita": ["line"],
            "[2Plutarchi]2 vita": ["Part", "line"],
            "Eustathii vita (Il. 4.17)": ["line"],
        },
    },
    "Anthemius Math., Mech.": {
        "tlg_id": "TLG4088",
        "names": {
            "name_authtab": "Anthemius Math. et Mech.",
            "name_idt": "Anthemius Math., Mech.",
        },
        "works": {
            " $*PERI\\ PARADO/CWN MHXANHMA/TWN&": ["Page", "line"],
            " Fragmentum mathematicum Bobiense": ["Page", "line"],
        },
    },
    "Zeno Hist.": {
        "tlg_id": "TLG2364",
        "names": {"name_authtab": "Zeno Hist.", "name_idt": "Zeno Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Plutarchus Biogr., Phil.": {
        "tlg_id": "TLG0007",
        "names": {
            "name_authtab": "Plutarchus Biogr. et Phil.",
            "name_idt": "Plutarchus Biogr., Phil.",
        },
        "works": {
            "": ["Agis et Cleomenes", "Chapter", "section", "line"],
            " Comparatio Pelopidae et Marcelli": ["Chapter", "section", "line"],
            "1Quomodo adulator ab amico internoscatur (48e-74e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "2De Alexandri magni fortuna aut virtute (326d-345b)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "#De tranquillitate animi (464e-477f)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "De Iside et Osiride (351c-384c)": ["Stephanus page", "section", "line"],
            "Cato Maior": ["Chapter", "section", "line"],
            "De vitioso pudore (528c-536d)": ["Stephanus page", "section", "line"],
            '"De vitando aere alieno (827d-832a)': [
                "Stephanus page",
                "section",
                "line",
            ],
            "Fragmenta": ["line", "fragment", "line"],
            "Theseus": ["Chapter", "section", "line"],
            "Antonius": ["Chapter", "section", "line"],
            "&Bruta animalia ratione uti (985d-992e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Lycurgus": ["Chapter", "section", "line"],
            ">Maxime cum principibus philosopho esse disserendum (776a-779c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "#De liberis educandis [Sp.] (1a-14c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Comparatio Eumenis et Sertorii": ["Chapter", "section", "line"],
            "Titus Flamininus": ["Chapter", "section", "line"],
            "De virtute et vitio (100b-101e)": ["Stephanus page", "section", "line"],
            "Nicias": ["Chapter", "section", "line"],
            "Publicola": ["Chapter", "section", "line"],
            "De invidia et odio (536e-538e)": ["Stephanus page", "section", "line"],
            "RDe unius in republica dominatione, populari statu, et paucorum imperio (826a-827c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Sertorius": ["Chapter", "section", "line"],
            '"De proverbiis Alexandrinorum [Sp.]': ["Fragment", "line"],
            '"De sollertia animalium (959a-985c)': [
                "Stephanus page",
                "section",
                "line",
            ],
            "De fortuna (97c-100a)": ["Stephanus page", "section", "line"],
            ".De animae procreatione in Timaeo (1012b-1030c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            ",$*PAROIMI/AI AI(=S *)ALECANDREI=S E)XRW=NTO&": [
                "Centuria",
                "section",
                "line",
            ],
            "De fraterno amore (478a-492d)": ["Stephanus page", "section", "line"],
            "*An seni respublica gerenda sit (783b-797f)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "(Comparatio Aemilii Paulli et Timoleontis": ["Chapter", "section", "line"],
            "Comparatio Dionis et Bruti": ["Chapter", "section", "line"],
            "Galba": ["Chapter", "section", "line"],
            "Comparatio Cimonis et Luculli": ["Chapter", "section", "line"],
            '"Aetia Romana et Graeca (263d-304f)': [
                "Stephanus page",
                "section",
                "line",
            ],
            "#Ad principem ineruditum (779d-782f)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Eumenes": ["Chapter", "section", "line"],
            "Alexander": ["Chapter", "section", "line"],
            "Agesilaus": ["Chapter", "section", "line"],
            "!De defectu oraculorum (409e-438d)": ["Stephanus page", "section", "line"],
            "Comparatio Agesilai et Pompeii": ["Chapter", "section", "line"],
            "Philopoemen": ["Chapter", "section", "line"],
            "De libidine et aegritudine": ["Section", "line"],
            "Alcibiades": ["Chapter", "section", "line"],
            "De garrulitate (502b-515a)": ["Stephanus page", "section", "line"],
            "Pericles": ["Chapter", "section", "line"],
            "*Comparatio Philopoemenis et Titi Flaminini": [
                "Chapter",
                "section",
                "line",
            ],
            "Comparatio Demetrii et Antonii": ["Chapter", "section", "line"],
            " Conjugalia praecepta (138a-146a)": ["Stephanus page", "section", "line"],
            "Fabius Maximus": ["Chapter", "section", "line"],
            "*Praecepta gerendae reipublicae (798a-825f)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Timoleon": ["Chapter", "section", "line"],
            "De cohibenda ira (452f-464d)": ["Stephanus page", "section", "line"],
            "*Consolatio ad Apollonium [Sp.] (101f-122a)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Aemilius Paullus": ["Chapter", "section", "line"],
            "Pompeius": ["Chapter", "section", "line"],
            "De E apud Delphos (384d-394c)": ["Stephanus page", "section", "line"],
            "(De tuenda sanitate praecepta (122b-137e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            ":Comparatio Agidis et Cleomenis cum Tiberio et Gaio Graccho": [
                "Chapter",
                "section",
                "line",
            ],
            "Crassus": ["Chapter", "section", "line"],
            "$De sera numinis vindicta (548a-568a)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "#Platonicae quaestiones (999c-1011e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "5Regum et imperatorum apophthegmata [Sp.?] (172b-208a)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Cicero": ["Chapter", "section", "line"],
            "De exilio (599a-607f)": ["Stephanus page", "section", "line"],
            "Comparatio Lysandri et Sullae": ["Chapter", "section", "line"],
            "Marcius Coriolanus": ["Chapter", "section", "line"],
            "Romulus": ["Chapter", "section", "line", "³"],
            "#De recta ratione audiendi (37b-48d)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Aratus": ["Chapter", "section", "line"],
            "Pyrrhus": ["Chapter", "section", "line"],
            "Demetrius": ["Chapter", "section", "line"],
            '"Quaestiones convivales (612c-748d)': [
                "Stephanus page",
                "section",
                "line",
            ],
            "&Vitae decem oratorum [Sp.] (832b-852e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Caesar": ["Chapter", "section", "line"],
            "7Non posse suaviter vivi secundum Epicurum (1086c-1107c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "<Epitome libri de animae procreatione in Timaeo (1030d-1032f)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Aetia physica (911c-919e)": ["Stephanus page", "section", "line"],
            "Cimon": ["Chapter", "section", "line"],
            "Cato Minor": ["Chapter", "section", "line"],
            "De laude ipsius (539a-547f)": ["Stephanus page", "section", "line"],
            "#An virtus doceri possit (439a-440c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "De superstitione (164e-171f)": ["Stephanus page", "section", "line"],
            "=Comparationis Aristophanis et Menandri compendium (853a-854d)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Comparatio Niciae et Crassi": ["Chapter", "section", "line"],
            "!De latenter vivendo (1128a-1130e)": ["Stephanus page", "section", "line"],
            "8Animine an corporis affectiones sint peiores (500b-502a)": [
                "Stephanus page",
                "section",
                "line",
            ],
            ")Comparatio Alcibiadis et Marcii Coriolani": [
                "Chapter",
                "section",
                "line",
            ],
            "+De capienda ex inimicis utilitate (86b-92f)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Marcellus": ["Chapter", "section", "line"],
            "Aristides": ["Chapter", "section", "line"],
            "$De cupiditate divitiarum (523c-528b)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "#Comparatio Demosthenis et Ciceronis": ["Chapter", "section", "line"],
            "Camillus": ["Chapter", "section", "line"],
            "Dion": ["Chapter", "section", "line"],
            "De virtute morali (440d-452d)": ["Stephanus page", "section", "line"],
            "De fato [Sp.] (568b-574f)": ["Stephanus page", "section", "line"],
            "Comparatio Aristidis et Catonis": ["Chapter", "section", "line"],
            "Mulierum virtutes (242e-263c)": ["Stephanus page", "section", "line"],
            "Comparatio Thesei et Romuli": ["Chapter", "section", "line", "\x92n\x12´"],
            '"De gloria Atheniensium (345c-351b)': [
                "Stephanus page",
                "section",
                "line",
            ],
            "4An vitiositas ad infelicitatem sufficiat (498a-500a)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Sulla": ["Chapter", "section", "line"],
            "Phocion": ["Chapter", "section", "line"],
            "Pelopidas": ["Chapter", "section", "line"],
            "Tiberius et Gaius Gracchus": ["Chapter", "section", "line"],
            "Amatorius (748e-771e)": ["Stephanus page", "section", "line"],
            "'De Stoicorum repugnantiis (1033a-1057b)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "De esu carnium ii (996d-999b)": ["Stephanus page", "section", "line"],
            "Brutus": ["Chapter", "section", "line"],
            "De genio Socratis (575a-598f)": ["Stephanus page", "section", "line"],
            "#Comparatio Periclis et Fabii Maximi": ["Chapter", "section", "line"],
            ".Stoicos absurdiora poetis dicere (1057c-1058e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Demosthenes": ["Chapter", "section", "line"],
            "#De Herodoti malignitate (854e-874c)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Solon": ["Chapter", "section", "line"],
            "De Pythiae oraculis (394d-409d)": ["Stephanus page", "section", "line"],
            "Otho": ["Chapter", "section", "line"],
            "De curiositate (515b-523b)": ["Stephanus page", "section", "line"],
            "Lysander": ["Chapter", "section", "line"],
            "Marius": ["Chapter", "section", "line"],
            "!$*)EKLOGH\\ PERI\\ TW=N A)DUNA/TWN&": ["line"],
            "De amore prolis (493a-497e)": ["Stephanus page", "section", "line"],
            "'Septem sapientium convivium (146b-164d)": [
                "Stephanus page",
                "section",
                "line",
            ],
            " De fortuna Romanorum (316c-326c)": ["Stephanus page", "section", "line"],
            ")Apophthegmata Laconica [Sp.?] (208b-242d)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Lucullus": ["Chapter", "section", "line"],
            "8Quomodo quis suos in virtute sentiat profectus (75a-86a)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Adversus Colotem (1107d-1127e)": ["Stephanus page", "section", "line"],
            "5De communibus notitiis adversus Stoicos (1058e-1086b)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Themistocles": ["Chapter", "section", "line"],
            ")Parsne an facultas animi sit vita passiva": ["Section", "line"],
            "Artaxerxes": ["Chapter", "section", "line"],
            '"De facie in orbe lunae (920b-945e)': [
                "Stephanus page",
                "section",
                "line",
            ],
            " Comparatio Solonis et Publicolae": ["Chapter", "section", "line"],
            "Numa": ["Chapter", "section", "line"],
            "!De amicorum multitudine (93a-97b)": ["Stephanus page", "section", "line"],
            " Consolatio ad uxorem (608a-612b)": ["Stephanus page", "section", "line"],
            "De primo frigido (945f-955c)": ["Stephanus page", "section", "line"],
            "1Quomodo adolescens poetas audire debeat (14d-37b)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "-Aquane an ignis sit utilior [Sp.] (955d-958e)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "De esu carnium i (993a-996c)": ["Stephanus page", "section", "line"],
            "Comparatio Lycurgi et Numae": ["Chapter", "section", "line"],
            '"Parallela minora [Sp.] (305a-316b)': [
                "Stephanus page",
                "section",
                "line",
            ],
            "'Amatoriae narrationes [Sp.] (771e-775e)": [
                "Stephanus page",
                "section",
                "line",
            ],
        },
    },
    "Protevangelium Jacobi": {
        "tlg_id": "TLG1637",
        "names": {
            "name_authtab": "Protevangelium Jacobi",
            "name_idt": "Protevangelium Jacobi",
        },
        "works": {"Protevangelium Jacobi": ["Section", "line"]},
    },
    "Eudocia Augusta Poeta": {
        "tlg_id": "TLG2766",
        "names": {
            "name_authtab": "Eudocia Augusta Poeta",
            "name_idt": "Eudocia Augusta Poeta",
        },
        "works": {
            "KHomerocentones (fort. conditore operis et auctore Patricio quodam episcopo)": [
                "Hypothesis-apologia-cento",
                "line",
            ],
            ">De martyrio sancti Cypriani (e cod. Florent. Laurent. VII, 10)": [
                "Book",
                "line",
            ],
        },
    },
    "Apollonius Geom.": {
        "tlg_id": "TLG0550",
        "names": {"name_authtab": "Apollonius Geom.", "name_idt": "Apollonius Geom."},
        "works": {"Conica": ["Book", "section", "line"]},
    },
    "Babrius Scr. Fab.": {
        "tlg_id": "TLG0614",
        "names": {
            "name_authtab": "Valerius Babrius Scr. Fab.",
            "name_idt": "Babrius Scr. Fab.",
        },
        "works": {"Mythiambi Aesopici": ["Section", "fable", "line"]},
    },
    "Alexander Theol.": {
        "tlg_id": "TLG2059",
        "names": {"name_authtab": "Alexander Theol.", "name_idt": "Alexander Theol."},
        "works": {'"Tractatus de placitis Manichaeorum': ["Section", "line"]},
    },
    "Theophilus Protospatharius, Damascius et Stephanus Atheniensis Med.": {
        "tlg_id": "TLG0728",
        "names": {
            "name_authtab": "Theophilus Protospatharius, Damascius et Stephanus Atheniensis Med.",
            "name_idt": "Theophilus Protospatharius, Damascius et Stephanus Atheniensis Med.",
        },
        "works": {"%Commentarii in Hippocratis aphorismos": ["Volume", "page", "line"]},
    },
    "Alciphron Rhet., Soph.": {
        "tlg_id": "TLG0640",
        "names": {
            "name_authtab": "Alciphron Rhet. et Soph.",
            "name_idt": "Alciphron Rhet., Soph.",
        },
        "works": {"Epistulae": ["Book", "epistle", "section", "line"]},
    },
    "Timotheus Lyr.": {
        "tlg_id": "TLG0376",
        "names": {"name_authtab": "Timotheus Lyr.", "name_idt": "Timotheus Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"], "Tituli": ["Fragment", "line"]},
    },
    "Rhianus Epic.": {
        "tlg_id": "TLG0219",
        "names": {"name_authtab": "Rhianus Epic.", "name_idt": "Rhianus Epic."},
        "works": {
            "Fragmentum et titulus": ["Fragment", "line"],
            "Fragmenta": ["FGrH fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Carneiscus Phil.": {
        "tlg_id": "TLG1244",
        "names": {"name_authtab": "Carneiscus Phil.", "name_idt": "Carneiscus Phil."},
        "works": {
            "#Philistas (lib. ii) (P. Herc. 1027)": ["Section", "fragment", "line"],
            "Fragmenta (P. Herc. 1027)": ["Fragment", "line"],
        },
    },
    "Choerilus Epic.": {
        "tlg_id": "TLG1262",
        "names": {"name_authtab": "Choerilus Epic.", "name_idt": "Choerilus Epic."},
        "works": {
            "Fragmentum": ["line"],
            "Fragmentum et titulus": ["Fragment", "line"],
        },
    },
    "Nicanor Gramm.": {
        "tlg_id": "TLG1530",
        "names": {"name_authtab": "Nicanor Gramm.", "name_idt": "Nicanor Gramm."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Asopodorus Iamb.": {
        "tlg_id": "TLG2609",
        "names": {"name_authtab": "Asopodorus Iamb.", "name_idt": "Asopodorus Iamb."},
        "works": {"Tituli": ["Fragment", "line"]},
    },
    "Comica Adespota (CAF)": {
        "tlg_id": "TLG0408",
        "names": {
            "name_authtab": "Comica Adespota (CAF)",
            "name_idt": "Comica Adespota (CAF)",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta incertorum poetarum": ["Fragment", "line"],
        },
    },
    "Epica Adespota (CA)": {
        "tlg_id": "TLG1344",
        "names": {
            "name_authtab": "Epica Adespota (CA)",
            "name_idt": "Epica Adespota (CA)",
        },
        "works": {"Epica adespota": ["Fragment", "line"]},
    },
    "Mnaseas Perieg.": {
        "tlg_id": "TLG1514",
        "names": {"name_authtab": "Mnaseas Perieg.", "name_idt": "Mnaseas Perieg."},
        "works": {"Fragmenta": ["FHG fragment", "line"]},
    },
    "Ecphantus Phil.": {
        "tlg_id": "TLG1341",
        "names": {"name_authtab": "Ecphantus Phil.", "name_idt": "Ecphantus Phil."},
        "works": {
            "Testimonia": ["Fragment", "line"],
            "%$*PERI\\ BASILEI/AS& (fragmenta) [Sp.]": ["Page", "line"],
        },
    },
    "Julius Africanus Hist.": {
        "tlg_id": "TLG2956",
        "names": {
            "name_authtab": "Sextus Julius Africanus Hist.",
            "name_idt": "Julius Africanus Hist.",
        },
        "works": {
            "": ["Cesti (fragmenta)", "Book", "chapter", "line"],
            "Epistula ad Origenem": ["Page", "line"],
            "Epistula ad Aristidem": ["Page", "line"],
        },
    },
    "Theagenes Hist.": {
        "tlg_id": "TLG1709",
        "names": {"name_authtab": "Theagenes Hist.", "name_idt": "Theagenes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Lyceas Hist.": {
        "tlg_id": "TLG1469",
        "names": {"name_authtab": "Lyceas Hist.", "name_idt": "Lyceas Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Niceratus Epic.": {
        "tlg_id": "TLG2633",
        "names": {"name_authtab": "Niceratus Epic.", "name_idt": "Niceratus Epic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Xenophanes Poet. Phil.": {
        "tlg_id": "TLG0267",
        "names": {
            "name_authtab": "Xenophanes Poet. Phil.",
            "name_idt": "Xenophanes Poet. Phil.",
        },
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta (Silli et De natura)": ["Fragment", "line"],
            "Testimonium": ["line", "fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Georgius Monachus Continuatus": {
        "tlg_id": "TLG3051",
        "names": {
            "name_authtab": "Georgius Monachus Continuatus",
            "name_idt": "Georgius Monachus Continuatus",
        },
        "works": {"$Chronicon (continuatio) (redactio A)": ["Page", "line"]},
    },
    "Eudemus Rhet.": {
        "tlg_id": "TLG1376",
        "names": {"name_authtab": "Eudemus Rhet.", "name_idt": "Eudemus Rhet."},
        "works": {"'$*PERI\\ LE/CEWN R(HTORIKW=N& (excerpta)": ["Folio", "line"]},
    },
    "Solonis Epistulae": {
        "tlg_id": "TLG1681",
        "names": {"name_authtab": "Solonis Epistulae", "name_idt": "Solonis Epistulae"},
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Andreas Hist.": {
        "tlg_id": "TLG2393",
        "names": {"name_authtab": "Andreas Hist.", "name_idt": "Andreas Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Vitae Aeschinis": {
        "tlg_id": "TLG4166",
        "names": {"name_authtab": "Vitae Aeschinis", "name_idt": "Vitae Aeschinis"},
        "works": {"Vitae Aeschinis": ["Vita", "line"]},
    },
    "Joannes Protospatharius Gramm.": {
        "tlg_id": "TLG3155",
        "names": {
            "name_authtab": "Joannes Protospatharius Gramm.",
            "name_idt": "Joannes Protospatharius Gramm.",
        },
        "works": {".$*)ECH/GHSIS FUSIKH\\ TW=N H(MERW=N *(HSIO/DOU&": ["Page", "line"]},
    },
    "Vita Et Sententiae Secundi": {
        "tlg_id": "TLG1521",
        "names": {
            "name_authtab": "Vita Et Sententiae Secundi",
            "name_idt": "Vita Et Sententiae Secundi",
        },
        "works": {
            "Sententiae": ["Sententia", "line"],
            "Vita Secundi": ["Page", "line"],
        },
    },
    "Acta Xanthippae Et Polyxenae": {
        "tlg_id": "TLG2248",
        "names": {
            "name_authtab": "Acta Xanthippae Et Polyxenae",
            "name_idt": "Acta Xanthippae Et Polyxenae",
        },
        "works": {
            "2Acta Xanthippae et Polyxenae (sub auctore Onesimo)": ["Section", "line"]
        },
    },
    "Callixenus Hist.": {
        "tlg_id": "TLG1240",
        "names": {"name_authtab": "Callixenus Hist.", "name_idt": "Callixenus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Paeanes (CA)": {
        "tlg_id": "TLG1203",
        "names": {"name_authtab": "Paeanes (CA)", "name_idt": "Paeanes (CA)"},
        "works": {
            ")Fragmentum Erythraeum paeanis in Seleucum": ["line"],
            "'Paean Erythraeus ad urbem Dium repertus": ["line"],
            "&Fragmentum paeanis in Titum Flamininum": ["line"],
            "*Fragmentum Erythraeum paeanis in Apollinem": ["line"],
            "Paean Erythraeus in Aesculapium": ["line"],
            "Paean Delphicus i in Apollinem": ["Fragment", "line"],
        },
    },
    "Sosicrates Hist.": {
        "tlg_id": "TLG1687",
        "names": {"name_authtab": "Sosicrates Hist.", "name_idt": "Sosicrates Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dexippus Phil.": {
        "tlg_id": "TLG2036",
        "names": {"name_authtab": "Dexippus Phil.", "name_idt": "Dexippus Phil."},
        "works": {"&In Aristotelis categorias commentarium": ["Page", "line"]},
    },
    "Dionysius Hist.": {
        "tlg_id": "TLG2466",
        "names": {"name_authtab": "Dionysius Hist.", "name_idt": "Dionysius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "[Chersias] Epic.": {
        "tlg_id": "TLG1260",
        "names": {"name_authtab": "[Chersias] Epic.", "name_idt": "[Chersias] Epic."},
        "works": {"1Fragmentum epicum [Dub.] (fort. auctore Callippo)": ["line"]},
    },
    "Ostanes Magus Alchem.": {
        "tlg_id": "TLG1016",
        "names": {
            "name_authtab": "Ostanes Magus Alchem.",
            "name_idt": "Ostanes Magus Alchem.",
        },
        "works": {
            "q$*)OSTA/NOU FILOSO/FOU PRO\\S *PETA/SION PERI\\ TH=S I(ERA=S TAU/THS KAI\\ QEI/AS TE/XNHS& (e cod. Venet. Marc. 299,": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Autocrates Comic.": {
        "tlg_id": "TLG0423",
        "names": {"name_authtab": "Autocrates Comic.", "name_idt": "Autocrates Comic."},
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Diogenes Hist.": {
        "tlg_id": "TLG2328",
        "names": {"name_authtab": "Diogenes Hist.", "name_idt": "Diogenes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Joannes Chortasmenus Phil.": {
        "tlg_id": "TLG4201",
        "names": {
            "name_authtab": "Joannes Chortasmenus Phil.",
            "name_idt": "Joannes Chortasmenus Phil.",
        },
        "works": {
            "qIn Aristotelis sophisticos elenchos (excerpta e codd. Bolon., B.U. gr. 3637; Lond., B.L. Harl. 5697; Flor. Laur. ": [
                "Page",
                "line",
            ]
        },
    },
    "Apocalypsis Sedrach": {
        "tlg_id": "TLG2243",
        "names": {
            "name_authtab": "Apocalypsis Sedrach",
            "name_idt": "Apocalypsis Sedrach",
        },
        "works": {"Apocalypsis Sedrach": ["Section", "line"]},
    },
    "Philochorus Hist.": {
        "tlg_id": "TLG0583",
        "names": {"name_authtab": "Philochorus Hist.", "name_idt": "Philochorus Hist."},
        "works": {
            "Fragmentum (P. Oslo 1662)": ["FGrH fragment", "line", ""],
            "Fragmenta": ["line", "fragment", "line", "³"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Sextus Empiricus Phil.": {
        "tlg_id": "TLG0544",
        "names": {
            "name_authtab": "Sextus Empiricus Phil.",
            "name_idt": "Sextus Empiricus Phil.",
        },
        "works": {
            "Pyrrhoniae hypotyposes": ["Book", "section", "line"],
            "Adversus mathematicos": ["Book", "section", "line"],
        },
    },
    "Diyllus Hist.": {
        "tlg_id": "TLG1911",
        "names": {"name_authtab": "Diyllus Hist.", "name_idt": "Diyllus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dio Chrysostomus Soph.": {
        "tlg_id": "TLG0612",
        "names": {
            "name_authtab": "Dio Chrysostomus Soph.",
            "name_idt": "Dio Chrysostomus Soph.",
        },
        "works": {
            "Encomium comae": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Orationes": ["Oration", "section", "line"],
        },
    },
    "Alexander Rhet., Soph.": {
        "tlg_id": "TLG0594",
        "names": {
            "name_authtab": "Alexander Rhet. et Soph.",
            "name_idt": "Alexander Rhet., Soph.",
        },
        "works": {
            "De figuris": ["Page", "line"],
            "*$*PERI\\ R(HTORIKW=N A)FORMW=N& (fragmenta)": ["Page", "line"],
        },
    },
    "Alexander Rhet.": {
        "tlg_id": "TLG0698",
        "names": {"name_authtab": "Alexander Rhet.", "name_idt": "Alexander Rhet."},
        "works": {"Fragmenta et titulus": ["Fragment", "line"]},
    },
    "Hierotheus Alchem., Poeta": {
        "tlg_id": "TLG4332",
        "names": {
            "name_authtab": "Hierotheus Alchem. et Poeta",
            "name_idt": "Hierotheus Alchem., Poeta",
        },
        "works": {
            "q$*(IEROQE/OU FILOSO/FOU PERI\\ TH=S QEI/AS KAI\\ I(ERA=S TE/XNHS DIA\\ STI/XWN [2I)A/MBWN]2& (fort. auctore Heliodor": [
                "line"
            ]
        },
    },
    "Apocalypsis Adam": {
        "tlg_id": "TLG1153",
        "names": {"name_authtab": "Apocalypsis Adam", "name_idt": "Apocalypsis Adam"},
        "works": {
            "1$*NUXQH/MERON& (fort. auctore Apollonio Tyanensi)": [
                "Fragment",
                "section",
                "line",
            ]
        },
    },
    "Theophrastus Phil.": {
        "tlg_id": "TLG0093",
        "names": {
            "name_authtab": "Theophrastus Phil.",
            "name_idt": "Theophrastus Phil.",
        },
        "works": {
            "Metaphysica (%6 fr. 12, Wimmer)": ["Usener page", "line"],
            "Historia plantarum": ["Book", "chapter", "section", "line"],
            "De igne (%6 fr. 3, Wimmer)": ["Fragment", "line"],
            "Physicorum opiniones": ["Section", "line"],
            "De causis plantarum (lib. 2-6)": ["Book", "chapter", "section", "line"],
            "+De sensu et sensibilibus (%6 fr. 1, Wimmer)": ["Section", "line"],
            "De pietate": ["Fragment", "line"],
            "&De eligendis magistratibus (fragmenta)": ["Folio", "line"],
            "Fragmenta": ["Fragment", "section", "line"],
            "Characteres": ["Chapter", "section", "line"],
            "De lapidibus (%6 fr. 2, Wimmer)": ["Section", "line"],
            "De causis plantarum (lib. 1)": ["Book", "chapter", "section", "line"],
        },
    },
    "Lyrica Adespota (CA)": {
        "tlg_id": "TLG0230",
        "names": {
            "name_authtab": "Lyrica Adespota (CA)",
            "name_idt": "Lyrica Adespota (CA)",
        },
        "works": {"Fragmenta lyrica": ["Fragment", "line"]},
    },
    "Parrhasius Epigr.": {
        "tlg_id": "TLG1567",
        "names": {"name_authtab": "Parrhasius Epigr.", "name_idt": "Parrhasius Epigr."},
        "works": {"Epigrammata": ["Epigram", "line"]},
    },
    "Uranius Hist.": {
        "tlg_id": "TLG2461",
        "names": {"name_authtab": "Uranius Hist.", "name_idt": "Uranius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Eunapius Hist., Soph.": {
        "tlg_id": "TLG2050",
        "names": {
            "name_authtab": "Eunapius Hist. et Soph.",
            "name_idt": "Eunapius Hist., Soph.",
        },
        "works": {
            "": [
                "Vitae sophistarum",
                "Book",
                "chapter",
                "section",
                "line",
                "\x8c",
                "",
                "",
                "\x12\x12\x12\x15¿\x15",
            ],
            "Fragmenta historica": ["Volume", "page", "line"],
        },
    },
    "Ephippus Comic.": {
        "tlg_id": "TLG0450",
        "names": {"name_authtab": "Ephippus Comic.", "name_idt": "Ephippus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Ninus": {
        "tlg_id": "TLG1804",
        "names": {"name_authtab": "Ninus", "name_idt": "Ninus"},
        "works": {
            "&Ninus (fragmenta A-B) (P. Berol. 6926)": ["Column", "line"],
            "!Ninus (fragmentum D) (P. Gen. 85)": ["line"],
            '"Ninus (fragmentum C) (PSI 13.1305)': ["line"],
        },
    },
    "Theophanes Confessor Chronogr.": {
        "tlg_id": "TLG4046",
        "names": {
            "name_authtab": "Theophanes Confessor Chronogr.",
            "name_idt": "Theophanes Confessor Chronogr.",
        },
        "works": {"Chronographia": ["Page", "line"]},
    },
    "Cleobuli Epistula": {
        "tlg_id": "TLG0622",
        "names": {"name_authtab": "Cleobuli Epistula", "name_idt": "Cleobuli Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Maximus Theol.": {
        "tlg_id": "TLG1488",
        "names": {"name_authtab": "Maximus Theol.", "name_idt": "Maximus Theol."},
        "works": {"Fragmentum ex libro de materia": ["Page", "line"]},
    },
    "Hipparchus Astron., Geogr.": {
        "tlg_id": "TLG1431",
        "names": {
            "name_authtab": "Hipparchus Astron. et Geogr.",
            "name_idt": "Hipparchus Astron., Geogr.",
        },
        "works": {
            "6In Arati et Eudoxi phaenomena commentariorum libri iii": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "Fragmenta geographica": ["Fragment", "line"],
        },
    },
    "Heliodorus Scr. Erot.": {
        "tlg_id": "TLG0658",
        "names": {
            "name_authtab": "Heliodorus Scr. Erot.",
            "name_idt": "Heliodorus Scr. Erot.",
        },
        "works": {
            "Aethiopica": ["Book", "chapter", "section", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Menetor Hist.": {
        "tlg_id": "TLG4395",
        "names": {"name_authtab": "Menetor Hist.", "name_idt": "Menetor Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Lysis Phil.": {
        "tlg_id": "TLG0633",
        "names": {"name_authtab": "Lysis Phil.", "name_idt": "Lysis Phil."},
        "works": {
            "Epistula ad Hipparchum": ["Page", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Eudoxus Hist.": {
        "tlg_id": "TLG1915",
        "names": {"name_authtab": "Eudoxus Hist.", "name_idt": "Eudoxus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Silenus Hist.": {
        "tlg_id": "TLG1970",
        "names": {"name_authtab": "Silenus Hist.", "name_idt": "Silenus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymi Aulodia": {
        "tlg_id": "TLG1836",
        "names": {"name_authtab": "Anonymi Aulodia", "name_idt": "Anonymi Aulodia"},
        "works": {"!Anonymi aulodia (P. Oxy. 15.1795)": ["Fragment", "line"]},
    },
    "Magnus Hist.": {
        "tlg_id": "TLG2157",
        "names": {"name_authtab": "Magnus Hist.", "name_idt": "Magnus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Ignatius Biogr., Poeta": {
        "tlg_id": "TLG9012",
        "names": {
            "name_authtab": "Ignatius Biogr. et Poeta",
            "name_idt": "Ignatius Biogr., Poeta",
        },
        "works": {"Vita Nicephori": ["Page", "line"]},
    },
    "Eunicus Comic.": {
        "tlg_id": "TLG0459",
        "names": {"name_authtab": "Eunicus Comic.", "name_idt": "Eunicus Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Anonymi In Aristotelis Librum Alterum Analyticorum Posteriorum Commentarium": {
        "tlg_id": "TLG9004",
        "names": {
            "name_authtab": "Anonymi In Aristotelis Librum Alterum Analyticorum Posteriorum Commentarium",
            "name_idt": "Anonymi In Aristotelis Librum Alterum Analyticorum Posteriorum Commentarium",
        },
        "works": {
            "?Anonymi in analyticorum posteriorum librum alterum commentarium": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Molpis Hist.": {
        "tlg_id": "TLG1516",
        "names": {"name_authtab": "Molpis Hist.", "name_idt": "Molpis Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Telestes Lyr.": {
        "tlg_id": "TLG0377",
        "names": {"name_authtab": "Telestes Lyr.", "name_idt": "Telestes Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Cyrillus Biogr.": {
        "tlg_id": "TLG2877",
        "names": {"name_authtab": "Cyrillus Biogr.", "name_idt": "Cyrillus Biogr."},
        "works": {
            "Vita Theodosii": ["Page", "line"],
            "Vita Cyriaci": ["Page", "line"],
            "Vita Euthymii": ["Page", "line"],
            "Vita Joannis Hesychastae": ["Page", "line"],
            "Vita Theognii": ["Page", "line"],
            "Vita Sabae": ["Page", "line"],
            "Vita Gerasimi [Sp.]": ["Page", "line"],
            "Vita Abramii": ["Page", "line"],
        },
    },
    "Onasander Tact.": {
        "tlg_id": "TLG0648",
        "names": {"name_authtab": "Onasander Tact.", "name_idt": "Onasander Tact."},
        "works": {"Strategicus": ["Chapter", "section", "line"]},
    },
    "Archimedes Geom.": {
        "tlg_id": "TLG0552",
        "names": {"name_authtab": "Archimedes Geom.", "name_idt": "Archimedes Geom."},
        "works": {
            "": ["Liber assumptorum", "Volume", "page", "line"],
            "Ad Eratosthenem methodus": ["Volume", "page", "line"],
            "De planorum aequilibriis": ["Volume", "page", "line"],
            "De lineis spiralibus": ["Volume", "page", "line"],
            "Stomachion": ["Volume", "page", "line"],
            "De conoidibus et sphaeroidibus": ["Volume", "page", "line"],
            "Problema bovinum": ["Volume", "page", "line"],
            "Dimensio circuli": ["Volume", "page", "line"],
            "Arenarius": ["Volume", "page", "line"],
            "Problema bovinum [Dub.]": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Quadratura parabolae": ["Volume", "page", "line"],
            "De corporibus fluitantibus": ["Volume", "page", "line"],
            "De sphaera et cylindro": ["Volume", "page", "line"],
        },
    },
    "Heracliti Epistulae": {
        "tlg_id": "TLG1412",
        "names": {
            "name_authtab": "Pseudo-Heracliti Epistulae",
            "name_idt": "Heracliti Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Themison Hist.": {
        "tlg_id": "TLG1713",
        "names": {"name_authtab": "Themison Hist.", "name_idt": "Themison Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Philostratus Soph.": {
        "tlg_id": "TLG0638",
        "names": {
            "name_authtab": "Flavius Philostratus Soph.",
            "name_idt": "Philostratus Soph.",
        },
        "works": {
            "": ["Vitae sophistarum", "Chapter", "Olearius page", "line"],
            "Nero": ["Olearius page", "line"],
            "Vita Apollonii": ["Chapter", "section", "line"],
            "Heroicus": ["Olearius page", "line"],
            "Epigramma": ["Book", "epigram", "line"],
            "De gymnastica": ["Section", "line"],
            "Epistulae et dialexeis": ["Section", "\x14epistle or discourse", "line"],
        },
    },
    "Arrianus Hist., Phil.": {
        "tlg_id": "TLG0074",
        "names": {
            "name_authtab": "Flavius Arrianus Hist. et Phil.",
            "name_idt": "Arrianus Hist., Phil.",
        },
        "works": {
            "Alexandri anabasis": ["Book", "chapter", "section", "line"],
            "EHistoria successorum Alexandri (fragmenta ap. Photium, Bibl. cod. 92)": [
                "Fragment",
                "line",
            ],
            "Parthicorum fragmenta": ["Fragment", "line"],
            "Periplus ponti Euxini": ["Chapter", "section", "line"],
            "Bithynicorum fragmenta": ["Fragment", "line"],
            "Cynegeticus": ["Chapter", "section", "line"],
            "Fragmenta de rebus physicis": ["Section", "line"],
            "Acies contra Alanos": ["Section", "line"],
            "6Parthicorum fragmenta (ap. Joannem Lydum et Syncellum)": ["line"],
            "Tactica": ["Chapter", "section", "line"],
            "Fragmentum (PSI 12.1284)": ["Column", "line"],
            "XFragmenta incerta (utrum e Parthicis an ex historia successorum Alexandri desumpta sint)": [
                "Fragment",
                "line",
            ],
            '"Fragmentum ex historia Alanica (?)': ["line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Epistula ad Lucium Gellium": ["Section", "line"],
            "EHistoria successorum Alexandri (fragmenta ap. Photium, Bibl. cod. 82)": [
                "Section",
                "line",
            ],
            "Historia Indica": ["Chapter", "section", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Idomeneus Hist.": {
        "tlg_id": "TLG1442",
        "names": {"name_authtab": "Idomeneus Hist.", "name_idt": "Idomeneus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Bion Hist.": {
        "tlg_id": "TLG1871",
        "names": {"name_authtab": "Bion Hist.", "name_idt": "Bion Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Herodes Atticus Soph.": {
        "tlg_id": "TLG1426",
        "names": {
            "name_authtab": "Herodes Atticus Soph.",
            "name_idt": "Herodes Atticus Soph.",
        },
        "works": {"$*PERI\\ POLITEI/AS& [Dub.]": ["Section", "line"]},
    },
    "Polyzelus Comic.": {
        "tlg_id": "TLG0499",
        "names": {"name_authtab": "Polyzelus Comic.", "name_idt": "Polyzelus Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Oechaliae Halosis": {
        "tlg_id": "TLG1546",
        "names": {"name_authtab": "Oechaliae Halosis", "name_idt": "Oechaliae Halosis"},
        "works": {
            "7Oechaliae halosis (fragmenta) (fort. auctore Creophylo)": [
                "Fragment",
                "line",
            ]
        },
    },
    "[Aristides] Hist.": {
        "tlg_id": "TLG2194",
        "names": {"name_authtab": "[Aristides] Hist.", "name_idt": "[Aristides] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Phrynichus Comic.": {
        "tlg_id": "TLG0496",
        "names": {"name_authtab": "Phrynichus Comic.", "name_idt": "Phrynichus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Diogenes Laertius Biogr.": {
        "tlg_id": "TLG0004",
        "names": {
            "name_authtab": "Diogenes Laertius Biogr.",
            "name_idt": "Diogenes Laertius Biogr.",
        },
        "works": {
            "Vitae philosophorum": [
                "Book",
                "section",
                "line",
                "¶¶´",
                "¶´\x15\x15¶\x16³\x17\x17´\x17\x17´´\x19\"#¶$¶$³%´%´'´¶(¶(¶¶¶)¶)³,³¶.¶´/¶´01¶´239³9´9³:´:¶:;;¶I¶¶´J¶¶¶J¶¶¶\x92J¶¶KKNRUU³U³UU´U¶VXX³X´XY³³³Y³´´[¶[\\¶\\¶`¶a´Fo",
            ],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Semonides Eleg., Iamb.": {
        "tlg_id": "TLG0260",
        "names": {
            "name_authtab": "Semonides Eleg. et Iamb.",
            "name_idt": "Semonides Eleg., Iamb.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Bryson Phil.": {
        "tlg_id": "TLG1231",
        "names": {"name_authtab": "Bryson Phil.", "name_idt": "Bryson Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Apollodorus Gramm.": {
        "tlg_id": "TLG0549",
        "names": {
            "name_authtab": "Apollodorus Gramm.",
            "name_idt": "Apollodorus Gramm.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hera[clides] Trag.": {
        "tlg_id": "TLG1844",
        "names": {
            "name_authtab": "Hera[clides] Trag.",
            "name_idt": "Hera[clides] Trag.",
        },
        "works": {"Titulus": ["line"]},
    },
    "Theon Rhet.": {
        "tlg_id": "TLG0607",
        "names": {"name_authtab": "Aelius Theon Rhet.", "name_idt": "Theon Rhet."},
        "works": {"Progymnasmata": ["Page", "line"]},
    },
    "Antigonus Paradox.": {
        "tlg_id": "TLG0568",
        "names": {
            "name_authtab": "Antigonus Paradox.",
            "name_idt": "Antigonus Paradox.",
        },
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
            " Historiarum mirabilium collectio": ["Chapter", "section", "line"],
            "Fragmentum et titulus": ["Fragment", "line"],
        },
    },
    "Apostolius Paroemiogr.": {
        "tlg_id": "TLG9009",
        "names": {
            "name_authtab": "Michael Apostolius Paroemiogr.",
            "name_idt": "Apostolius Paroemiogr.",
        },
        "works": {"Collectio paroemiarum": ["Centuria", "section", "line"]},
    },
    "Phaedimus Epic.": {
        "tlg_id": "TLG1576",
        "names": {"name_authtab": "Phaedimus Epic.", "name_idt": "Phaedimus Epic."},
        "works": {"Fragmentum": ["line"]},
    },
    "Timostratus Comic.": {
        "tlg_id": "TLG0516",
        "names": {
            "name_authtab": "Timostratus Comic.",
            "name_idt": "Timostratus Comic.",
        },
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Play", "fragment", "line"],
        },
    },
    "Araros Comic.": {
        "tlg_id": "TLG0415",
        "names": {"name_authtab": "Araros Comic.", "name_idt": "Araros Comic."},
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Euphanes Comic.": {
        "tlg_id": "TLG0396",
        "names": {"name_authtab": "Euphanes Comic.", "name_idt": "Euphanes Comic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Scythinus Poet. Phil.": {
        "tlg_id": "TLG0259",
        "names": {
            "name_authtab": "Scythinus Poet. Phil.",
            "name_idt": "Scythinus Poet. Phil.",
        },
        "works": {
            "Fragmentum": ["line", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Bolus Med., Phil.": {
        "tlg_id": "TLG1306",
        "names": {
            "name_authtab": "Bolus Med. et Phil.",
            "name_idt": "Bolus Med., Phil.",
        },
        "works": {
            "Testimonium": ["Fragment", "line"],
            ">$*PERI\\ SUMPAQEIW=N KAI\\ A)NTIPAQEIW=N& (sub nomine Democriti)": [
                "Section",
                "line",
            ],
            "iPhysica et mystica (fort. opus $*XEIRO/MHKTA&) (sub nomine Democriti) (e cod. Venet. Marc. 299, fol. 66v)": [
                "Volume",
                "page",
                "line",
            ],
            "Testimonia": ["line", "fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "RAd Leucippem (sub nomine Democriti) [Sp.] (e cod. Paris. B.N. gr. 2327, fol. 258r)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Polemon Soph.": {
        "tlg_id": "TLG1617",
        "names": {
            "name_authtab": "Marcus Antonius Polemon Soph.",
            "name_idt": "Polemon Soph.",
        },
        "works": {
            "Fragmentum physiognomonicum": ["Page", "line"],
            "Declamationes": ["Declamation", "section", "line"],
        },
    },
    "Anonymus Manichaeus Biogr.": {
        "tlg_id": "TLG4282",
        "names": {
            "name_authtab": "Anonymus Manichaeus Biogr.",
            "name_idt": "Anonymus Manichaeus Biogr.",
        },
        "works": {
            "N$*PERI\\ TH=S GE/NNHS TOU= SW/MATOS AU)TOU= &(%6 Codex Manichaicus Coloniensis)": [
                "Codex page",
                "line",
            ]
        },
    },
    "Callistratus Soph.": {
        "tlg_id": "TLG4091",
        "names": {
            "name_authtab": "Callistratus Soph.",
            "name_idt": "Callistratus Soph.",
        },
        "works": {"Statuarum descriptiones": ["Chapter", "section", "line"]},
    },
    "Dionysius Epic.": {
        "tlg_id": "TLG1326",
        "names": {"name_authtab": "Dionysius Epic.", "name_idt": "Dionysius Epic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Libanius Rhet., Soph.": {
        "tlg_id": "TLG2200",
        "names": {
            "name_authtab": "Libanius Rhet. et Soph.",
            "name_idt": "Libanius Rhet., Soph.",
        },
        "works": {
            "Orationes 1-64": ["Oration", "section", "line"],
            "5Epistularum Basilii et Libanii quod fertur commercium": [
                "Epistle",
                "section",
                "line",
            ],
            "Epistulae pseudepigraphae": ["Epistle", "section", "line"],
            "(Declamatio 3 (Legatio Menelai, Theorema)": ["Section", "line"],
            "Fragmenta de declamationibus": ["Fragment", "section", "line"],
            "Epistulae 1-1544": ["Epistle", "section", "line"],
            "Characteres epistolici [Sp.]": ["Section", "line"],
            "#Argumenta orationum Demosthenicarum": ["Oration", "section", "line"],
            "Epigramma": ["Book", "epigram", "line"],
            "Progymnasmata": ["Progymnasma", "section", "subsection", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Declamationes 1-51": ["Declamation", "(subdivision)", "section", "line"],
        },
    },
    "Proxenus Hist.": {
        "tlg_id": "TLG1638",
        "names": {"name_authtab": "Proxenus Hist.", "name_idt": "Proxenus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pappus Alchem.": {
        "tlg_id": "TLG4326",
        "names": {"name_authtab": "Pappus Alchem.", "name_idt": "Pappus Alchem."},
        "works": {
            "F$*PA/PPOU FILOSO/FOU [2O(/RKOS]2 &(e cod. Venet. Marc. 299, fol. 184v)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Theopompus Comic.": {
        "tlg_id": "TLG0513",
        "names": {"name_authtab": "Theopompus Comic.", "name_idt": "Theopompus Comic."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Prodromus Poeta, Polyhist.": {
        "tlg_id": "TLG2721",
        "names": {
            "name_authtab": "Theodorus Prodromus Poeta et Polyhist.",
            "name_idt": "Prodromus Poeta, Polyhist.",
        },
        "works": {
            ",Epithalamium fortunatissimis caesaris filiis": ["Page", "line"],
            "&Epitaphius in Theodoram nurum Bryennii": ["line"],
        },
    },
    "Mace(donius) Lyr.": {
        "tlg_id": "TLG0202",
        "names": {"name_authtab": "Mace(donius) Lyr.", "name_idt": "Mace(donius) Lyr."},
        "works": {"/Paean in Apollinem et Aesculapium (IG 3.1.171b)": ["line"]},
    },
    "Athanasius Soph.": {
        "tlg_id": "TLG4238",
        "names": {"name_authtab": "Athanasius Soph.", "name_idt": "Athanasius Soph."},
        "works": {
            ";Prolegomena in Hermogenis librum $PERI\\ STA/SEWN &(epitome)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Herodotus Hist.": {
        "tlg_id": "TLG0016",
        "names": {"name_authtab": "Herodotus Hist.", "name_idt": "Herodotus Hist."},
        "works": {"Historiae": ["Book", "section", "line"]},
    },
    "Phaenias Phil.": {
        "tlg_id": "TLG1578",
        "names": {"name_authtab": "Phaenias Phil.", "name_idt": "Phaenias Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymi De Barbarismo Et Soloecismo Gramm.": {
        "tlg_id": "TLG1129",
        "names": {
            "name_authtab": "Anonymi De Barbarismo Et Soloecismo Gramm.",
            "name_idt": "Anonymi De Barbarismo Et Soloecismo Gramm.",
        },
        "works": {"De barbarismo et soloecismo": ["Page", "line"]},
    },
    "Lexica In Opera Gregorii Nazianzeni": {
        "tlg_id": "TLG4303",
        "names": {
            "name_authtab": "Lexica In Opera Gregorii Nazianzeni",
            "name_idt": "Lexica In Opera Gregorii Nazianzeni",
        },
        "works": {
            "cLexicon in carmina Gregorii Nazianzeni (%6 Lexicon Casinense) (e cod. Casinensi Arch. Abbat. T 550)": [
                "",
                "Alphabetic letter",
                "line",
            ],
            "cLexicon in orationes Gregorii Nazianzeni (%6 $*LE/CEIS E)K TOU= *QEOLO/GOU&) (e cod. Barocciano 50)": [
                "",
                "Alphabetic letter",
                "page",
                "line",
            ],
            "XLexicon in carmina Gregorii Nazianzeni (ordine alphabetico) (e cod. Paris. Coislin. 394)": [
                "",
                "Alphabetic letter",
                "lemma",
                "line",
            ],
            "7Lexicon in carmina Gregorii Nazianzeni (ordine versuum)": [
                "Lemma",
                "line",
            ],
        },
    },
    "Leontius Mech.": {
        "tlg_id": "TLG4167",
        "names": {"name_authtab": "Leontius Mech.", "name_idt": "Leontius Mech."},
        "works": {"!De sphaerae Arateae constructione": ["Section", "line"]},
    },
    "Martyrium Cononis": {
        "tlg_id": "TLG2008",
        "names": {"name_authtab": "Martyrium Cononis", "name_idt": "Martyrium Cononis"},
        "works": {"": ["Martyrium Cononis", "Chapter", "section", "line"]},
    },
    "Philo Judaeus Phil.": {
        "tlg_id": "TLG0018",
        "names": {
            "name_authtab": "Philo Judaeus Phil.",
            "name_idt": "Philo Judaeus Phil.",
        },
        "works": {
            "": ["De opificio mundi", "Section", "line"],
            "De aeternitate mundi": ["Section", "line"],
            "&Quod deterius potiori insidiari soleat": ["Section", "line"],
            "In Flaccum": ["Section", "line"],
            "De sobrietate": ["Section", "line"],
            "De gigantibus": ["Section", "line"],
            "Legum allegoriarum libri i-iii": ["Book", "section", "line"],
            "De Josepho": ["Section", "line"],
            "Quod omnis probus liber sit": ["Section", "line"],
            "De providentia": ["Fragment", "section", "line"],
            "De agricultura": ["Section", "line"],
            "De confusione linguarum": ["Section", "line"],
            "Fragmenta": ["Fragment", "line"],
            "De vita Mosis (lib. i-ii)": ["Book", "section", "line"],
            "De mutatione nominum": ["Section", "line"],
            "3$*PERI\\ A)RIQMW=N &sive$ *)ARIQMHTIKA/ &(fragmenta)": [
                "Fragment",
                "line",
            ],
            '"De specialibus legibus (lib. i-iv)': ["Book", "section", "line"],
            "De ebrietate ii": ["Fragment", "line"],
            "Quod deus sit immutabilis": ["Section", "line"],
            "De Abrahamo": ["Section", "line"],
            "*Fragmenta incerti operis (P. Oxy. 18.2158)": ["line"],
            "De sacrificiis Abelis et Caini": ["Section", "line"],
            "%Hypothetica sive Apologia pro Judaeis": ["Page", "line"],
            "De fuga et inventione": ["Section", "line"],
            "De congressu eruditionis gratia": ["Section", "line"],
            "De deo (P. Berol. inv. 17027)": ["line"],
            "De plantatione": ["Section", "line"],
            "Quis rerum divinarum heres sit": ["Section", "line"],
            "De cherubim": ["Section", "line"],
            "Legatio ad Gaium": ["Section", "line"],
            "De migratione Abrahami": ["Section", "line"],
            "De virtutibus": ["Section", "line"],
            "De decalogo": ["Section", "line"],
            '"Quaestiones in Genesim (fragmenta)': ["Book", "fragment", "line"],
            "+De praemiis et poenis %7 De exsecrationibus": ["Section", "line"],
            "De posteritate Caini": ["Section", "line"],
            "De ebrietate": ["Section", "line"],
            "!Quaestiones in Exodum (fragmenta)": ["Book", "fragment", "line"],
            "De vita contemplativa": ["Section", "line"],
            "De somniis (lib. i-ii)": ["Book", "section", "line"],
        },
    },
    "Isis Prophetissa] Alchem.": {
        "tlg_id": "TLG4334",
        "names": {
            "name_authtab": "[Isis Prophetissa] Alchem.",
            "name_idt": "Isis Prophetissa] Alchem.",
        },
        "works": {
            "c$*)/ISIS PROFH=TIS TW=| UI(W=| (/*WRW| &(redactio secunda) (e cod. Paris. B.N. gr. 2250, fol. 217r)": [
                "Volume",
                "page",
                "line",
            ],
            "a$*)/ISIS PROFH=TIS TW=| UI(W=| (/*WRW| &(redactio prima) (e cod. Paris. B.N. gr. 2327, fol. 256r)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Pronomus Lyr.": {
        "tlg_id": "TLG0397",
        "names": {"name_authtab": "Pronomus Lyr.", "name_idt": "Pronomus Lyr."},
        "works": {"Titulus": ["line"]},
    },
    "Eubulides Comic.": {
        "tlg_id": "TLG0457",
        "names": {"name_authtab": "Eubulides Comic.", "name_idt": "Eubulides Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Euaretus Trag.": {
        "tlg_id": "TLG1096",
        "names": {"name_authtab": "Euaretus Trag.", "name_idt": "Euaretus Trag."},
        "works": {"Tituli": ["Fragment", "line"]},
    },
    "Erycius Poeta": {
        "tlg_id": "TLG2653",
        "names": {"name_authtab": "Erycius Poeta", "name_idt": "Erycius Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Origenes Theol.": {
        "tlg_id": "TLG2042",
        "names": {"name_authtab": "Origenes Theol.", "name_idt": "Origenes Theol."},
        "works": {
            "": ["Homiliae in Lucam", "Homily", "page", "line"],
            "0Commentarium in evangelium Matthaei (lib. 10-11)": [
                "Book",
                "section",
                "line",
            ],
            "-Scholia in Lucam (fragmenta e cod. Venet. 28)": [
                "Volume",
                "page",
                "line",
            ],
            " Homiliae in Genesim (in catenis)": ["Page", "line"],
            "Scholia in Canticum canticorum": ["Volume", "page", "line"],
            "<Commentarii in epistulam ad Romanos (e cod. Vindob. gr. 166)": [
                "Fragment",
                "line",
            ],
            "*Fragmentum ex homiliis in Acta apostolorum": ["Volume", "page", "line"],
            "Fragmenta de principiis": ["Fragment", "line"],
            "Dialogus cum Heraclide": ["Section", "line"],
            '"Fragmenta in Jeremiam (in catenis)': ["Fragment", "line"],
            "Excerpta in Psalmos [Dub.]": ["Volume", "page", "line"],
            "(Scholia in Apocalypsem (scholia 1, 3-39)": ["Scholion", "line"],
            "'Selecta in Exodum (fragmenta e catenis)": ["Volume", "page", "line"],
            "In Ruth (fragmentum)": ["Volume", "page", "line"],
            "/Adnotationes in Leviticum (fragmenta e catenis)": [
                "Volume",
                "page",
                "line",
            ],
            ">Commentariorum series in evangelium Matthaei (Mt. 22.34-27.63)": [
                "Page",
                "line",
                "î§\x8cà\x15",
            ],
            "RFragmenta ex commentariis in Exodum (%6 In illud: Induravit dominus cor Pharaonis)": [
                "Volume",
                "page",
                "line",
            ],
            "1Fragmentum in librum primum Regnorum (in catenis)": ["line"],
            "0In Jesu Nave homiliae xxvi (fragmenta e catenis)": ["Page", "line"],
            "Homiliae in Ezechielem": ["Page", "line", ""],
            "0Fragmenta ex commentariis in evangelium Matthaei": ["Fragment", "line"],
            "*Selecta in Jesu Nave (fragmenta e catenis)": ["Volume", "page", "line"],
            "=Commentarii in epistulam ad Romanos (I.1-XII.21) (in catenis)": [
                "Section",
                "line",
            ],
            "8De engastrimytho (%6 Homilia in i Reg. [i Sam.] 28.3-25)": [
                "Section",
                "line",
            ],
            "&Fragmenta ex commentariis in Proverbia": ["Volume", "page", "line"],
            '"Fragmentum ex commentariis in Osee': ["Volume", "page", "line"],
            "De oratione": ["Chapter", "section", "line"],
            "(Fragmentum in Lamentationes (in catenis)": ["line"],
            "(Selecta in Genesim (fragmenta e catenis)": ["Volume", "page", "line"],
            "Adnotationes in Genesim": ["Volume", "page", "line"],
            "0Commentarium in evangelium Matthaei (lib. 12-17)": [
                "Book",
                "chapter",
                "line",
            ],
            "'Fragmenta ex commentariis in Ezechielem": ["Volume", "page", "line"],
            "%De resurrectione libri ii (fragmenta)": ["Volume", "page", "line"],
            "'Fragmenta in Lamentationes (in catenis)": ["Fragment", "line"],
            "Adnotationes in Numeros": ["Volume", "page", "line"],
            "CFragmenta ex commentariis in epistulam i ad Corinthios (in catenis)": [
                "Section",
                "line",
            ],
            "LHomiliae in Job (fragmenta in catenis, typus II) (e codd. Marc. gr. 21, 538)": [
                "Volume",
                "page",
                "line",
            ],
            "GEpistula quibusdam qui ei obtrectabant (ad Alexandrum Hierosolymitanum)": [
                "line"
            ],
            ",Fragmenta in evangelium Joannis (in catenis)": ["Fragment", "line"],
            "$Fragmenta in Jeremiam (e Philocalia)": ["Fragment", "section", "line"],
            "IIn epistulam ad Hebraeos homiliae (fragmenta ap. Eusebium, HE 6.25.11-14)": [
                "Volume",
                "page",
                "line",
            ],
            "*Selecta in Leviticum (fragmenta e catenis)": ["Volume", "page", "line"],
            "Homiliae in Exodum": ["Page", "line"],
            "Epistula ad Africanum": ["Volume", "page", "line"],
            "@In Canticum canticorum (libri duo quos scripsit in adulescentia)": [
                "Volume",
                "page",
                "line",
            ],
            "Selecta in Numeros": ["Volume", "page", "line"],
            "&Scholia in Apocalypsem (scholia 28-38)": ["Scholion", "line"],
            "&Epistula ad ignotum (Fabianum Romanum)": ["line"],
            '"Commentarii in Genesim (fragmenta)': ["Volume", "page", "line"],
            "Adnotationes in Judices": ["Volume", "page", "line"],
            "+Selecta in Ezechielem (fragmenta e catenis)": ["Volume", "page", "line"],
            "Contra Celsum": ["Book", "section", "line"],
            "7Commentarii in evangelium Joannis (lib. 19, 20, 28, 32)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "De principiis": ["Book", "chapter", "section", "line"],
            "/Selecta in Psalmos [Dub.] (fragmenta e catenis)": [
                "Volume",
                "page",
                "line",
            ],
            "2Commentarii in Romanos (cod. Athon. Laura 184 B64)": [
                "Chapter",
                "section",
                "line",
            ],
            "In Jeremiam (homiliae 1-11)": ["Homily", "section", "line"],
            "6Adnotationes in Jesu filium Nave (fragmenta e catenis)": [
                "Volume",
                "page",
                "line",
            ],
            ">Commentarii in evangelium Joannis (lib. 1, 2, 4, 5, 6, 10, 13)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "@Homiliae in Job (fragmenta in catenis, typus I) (e codd. Paris.)": [
                "Volume",
                "page",
                "line",
            ],
            "Adnotationes in Exodum": ["Volume", "page", "line"],
            "BHomiliae in Job (fragmenta in catenis, typus I%7II) (e codd. Vat.)": [
                "Page",
                "line",
            ],
            "3Adnotationes in Deuteronomium (fragmenta e catenis)": [
                "Volume",
                "page",
                "line",
            ],
            "(Selecta in Judices (fragmenta e catenis)": ["Volume", "page", "line"],
            ".Selecta in Deuteronomium (fragmenta e catenis)": [
                "Volume",
                "page",
                "line",
            ],
            "*Libri x in Canticum canticorum (fragmenta)": ["Page", "line"],
            "!Fragmenta in Psalmos 1-150 [Dub.]": [
                "Psalm",
                "verse",
                "line",
                "©ö",
                "ö³¶¶¤Íö¶ù««««\x92\x8e«\x8e¶\x92«««»",
                "©ö",
                "m(´",
            ],
            "Scholia in Matthaeum": ["Volume", "page", "line"],
            " Fragmenta in evangelium Matthaei": ["Page", "line"],
            "Fragmenta alia de principiis": ["Fragment", "line"],
            "cPhilocalia sive Ecloga de operibus Origenis a Basilio et Gregorio Nazianzeno facta (cap. 23, 25-27)": [
                "Chapter",
                "section",
                "line",
            ],
            "?Fragmenta ex commentariis in epistulam ad Ephesios (in catenis)": [
                "Section",
                "line",
            ],
            "Fragmenta in Lucam (in catenis)": ["Fragment", "line"],
            "In Jeremiam (homiliae 12-20)": ["Homily", "section", "line"],
            "HCommentarii in Romanos (III.5-V.7) (P. Cair. 88748 %7 cod. Vat. gr. 762)": [
                "Page",
                "line",
            ],
            "1Epistula ad Gregorium Thaumaturgum (e Philocalia)": ["Section", "line"],
            "0Fragmenta in librum primum Regnorum (in catenis)": ["Fragment", "line"],
            "^Philocalia sive Ecloga de operibus Origenis a Basilio et Gregorio Nazianzeno facta (cap. 1-27)": [
                "Chapter",
                "section",
                "line",
            ],
            "Exhortatio ad martyrium": ["Section", "line"],
            ",Expositio in Proverbia (fragmenta e catenis)": ["Volume", "page", "line"],
            "Homiliae in Leviticum": ["Page", "line"],
        },
    },
    "Eustratius Phil.": {
        "tlg_id": "TLG4031",
        "names": {"name_authtab": "Eustratius Phil.", "name_idt": "Eustratius Phil."},
        "works": {
            "/In Aristotelis ethica Nicomachea vi commentaria": ["Page", "line"],
            "DIn Aristotelis analyticorum posteriorum librum secundum commentarium": [
                "Page",
                "line",
            ],
            ".In Aristotelis ethica Nicomachea i commentaria": ["Page", "line"],
        },
    },
    "Praecepta Salubria": {
        "tlg_id": "TLG0663",
        "names": {
            "name_authtab": "Praecepta Salubria",
            "name_idt": "Praecepta Salubria",
        },
        "works": {"Praecepta salubria": ["line"]},
    },
    "Scholia In Dionysium Periegetam": {
        "tlg_id": "TLG5019",
        "names": {
            "name_authtab": "Scholia In Dionysium Periegetam",
            "name_idt": "Scholia In Dionysium Periegetam",
        },
        "works": {
            "jScholia in Dionysii periegetae orbis descriptionem (scholia vetera) (olim sub auctore Demetrio Lampsaceno)": [
                "\x1eVita-verse of Orbis descriptio",
                "line",
            ],
            "CScholia in Dionysii periegetae orbis descriptionem (scholia vetera)": [
                "Vita-scholion",
                "line",
            ],
        },
    },
    "Anaximander Phil.": {
        "tlg_id": "TLG0725",
        "names": {"name_authtab": "Anaximander Phil.", "name_idt": "Anaximander Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Philes Poeta, Scr. Rerum Nat.": {
        "tlg_id": "TLG2718",
        "names": {
            "name_authtab": "Manuel Philes Poeta et Scr. Rerum Nat.",
            "name_idt": "Philes Poeta, Scr. Rerum Nat.",
        },
        "works": {
            "Carmina": ["Chapter", "poem", "line", "ù", "", "\x17¶u"],
            "Carmina inedita": ["Poem", "line"],
        },
    },
    "Parm(en)iscus Phil.": {
        "tlg_id": "TLG2225",
        "names": {
            "name_authtab": "Parm(en)iscus Phil.",
            "name_idt": "Parm(en)iscus Phil.",
        },
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Cleaenetus Trag.": {
        "tlg_id": "TLG0332",
        "names": {"name_authtab": "Cleaenetus Trag.", "name_idt": "Cleaenetus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymi De Terrae Motibus": {
        "tlg_id": "TLG2972",
        "names": {
            "name_authtab": "Anonymi De Terrae Motibus",
            "name_idt": "Anonymi De Terrae Motibus",
        },
        "works": {"": ["De terrae motibus", "Page", "line"]},
    },
    "Lysippus Comic.": {
        "tlg_id": "TLG0472",
        "names": {"name_authtab": "Lysippus Comic.", "name_idt": "Lysippus Comic."},
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Cosmas Indicopleustes Geogr.": {
        "tlg_id": "TLG4061",
        "names": {
            "name_authtab": "Cosmas Indicopleustes Geogr.",
            "name_idt": "Cosmas Indicopleustes Geogr.",
        },
        "works": {
            "Topographia Christiana": [
                "Book",
                "section",
                "line",
                "",
                "",
                "",
                "",
                "",
                "",
                "",
                "",
                "",
                "",
                '\x12\x12\x12\x12\x8e\x12\x8e\x12\x92\x12\x8c\x12\x12\x8e\x13\x13\x13\x13\x8e\x13\x13\x13\x8e\x13\x13\x13\x14\x14\x14\x14\x8c\x14\x14\x14\x14\x14\x15\x15\x15\x15\x15\x15\x92\x15\x15\x15\x15\x15\x16\x16\x16\x8e\x16\x16\x16\x16\x17\x17\x17\x17\x92\x17\x92\x17\x17\x17\x17\x18\x8e\x18\x18\x18\x18\x18\x18\x18\x18\x19\x19\x8c\x19\x19\x8e\x19\x19\x19\x19\x8c\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x1a\x8c\x1a\x1a\x1a\x1a\x1a\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x1b\x8e\x1b\x1b\x1b\x1b\x1b\x1b\x8c\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1e\x1f\x8e\x1f\x1f\x8e\x1f\x1f\x1f\x1f\x1f\x8c\x1f\x1f\x8c\x8e         \x8c \x8c\x8c\x8c\x8c\x8c""""""""\x92""###\x8c#######$$\x8e$$$$$\x8c$$$%%%\x8c%%\x8c%%%\x8c%%&&&&&\x8c&&&&\'\x8c\'\'\'\x8c\'\'\'\'\'((((\x8c((((((\x8e))))\x8c)\x8c)))\x8e)\x8e****\x8c*****+++\x8c+++\x8e++++\x8c++,,\x8e,,\x8e,,\x92,,\x8c,----\x8c-----\x8c.\x92..\x8c..\x8c...\x8c../\x8e/////////0000000\x8c000111111\x8e1112\x8c2222\x922\x922333333\x8e333\x8c3444\x924\x8c4444\x924\x9245\x9255\x8e5555\x8e5666666667777\x8e7777777\x928\x8c88\x8c88\x8c88\x8c88\x8c8\x8c8999999999::::::::::;;;;\x92;\x8c;;;;\x92<<<<<<\x8c<<<<<<===\x8e=\x8e=\x92===\x8c\x8c>>>\x92>>>>>????\x8e???\x8c???@@@\x8c@\x8c@@\x8c@@@AA\x8eAA\x8eA\x8cAA\x8eA\x8eABBBBB\x8cBBB\x8cBCC\x8cCC\x8eCCCC\x8eCCC\x8eD\x8cDDDDD\x8eDDD\x8eEEEEEEEEFFFFFFF\x8eF\x8eFFGGG\x8eG\x8cGG\x8cGGGGGH\x8eH\x8eHHHHHHHHHHI\x8cIIIIIIII\x8eIJ\x8eJ\x8eJJJJ\x8eJJ\x8eJJKKKK\x8eKKKKK\x8cKK\x8eKLLLLLL\x8cLLL\x8cL\x8eLM\x92MMMMMMMMNN\x8cNNNNNNNNNNNOOOOOOOOOO\x8cOO\x8ePPPPPPPPPPPPPPQQQQQQQQQQ\x8cQQQ\x8cR\x8cRR\x8cR\x8cRR\x8cRRRSS\x92SSSSS\x8eS\x8cSTT\x8cTTTTTT\x8cîùÍ\x8e\x8eÖ\x0eß\x0e\x0f\x8e\x10\x10',
                "",
                "",
                "\x8e\x13\x13\x92\x14\x15\x18Æ\x19Ï\x1a\x1a\x1a\x1a\x8e\x1b\x8c\x1e\x1e\x1f\x1f\x1f\x1f\x1f¤\x8c\x1f   \x92\x92\"\"\x92#Ë$Ò$%ß%&&&'î''ó(÷(ù)*\x8e*\x92**+\x92+,,,-§-©----\x8c-./Â00Ç0Ì1Ò1112Û2Ý33\x92355÷\x8e6\x8c68:CÒCCÛ\x8eD\x8cDG\x92GJJ\x92JJ\x8cJJ\x8eKKKK\x8cKKK\x8e\x92K\x8eKL\x8eLLLLLLMMMMMMNN\x92N\x8cN\x8eNNNO\x8eO\x8cO\x8cO¾OPPÃPPPÇ\x8cPPQ\x8cR",
            ]
        },
    },
    "Timotheus Comic.": {
        "tlg_id": "TLG0517",
        "names": {"name_authtab": "Timotheus Comic.", "name_idt": "Timotheus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Tragica Adespota": {
        "tlg_id": "TLG1738",
        "names": {"name_authtab": "Tragica Adespota", "name_idt": "Tragica Adespota"},
        "works": {"Fragmenta": ["Fragment", "line", "Ñ", "ÑÝÉÞ\x0eîî", "Ñ", "Ñ"]},
    },
    "Charondas Nomographus Phil.": {
        "tlg_id": "TLG1259",
        "names": {
            "name_authtab": "Charondas Nomographus Phil.",
            "name_idt": "Charondas Nomographus Phil.",
        },
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Theodoretus Scr. Eccl., Theol.": {
        "tlg_id": "TLG4089",
        "names": {
            "name_authtab": "Theodoretus Scr. Eccl. et Theol.",
            "name_idt": "Theodoretus Scr. Eccl., Theol.",
        },
        "works": {
            "De sancta trinitate": ["Volume", "page", "line"],
            "Interpretatio in Psalmos": ["Volume", "page", "line"],
            "Eranistes": ["Page", "line"],
            "Commentaria in Isaiam": ["Section", "line"],
            "Interpretatio in Danielem": ["Volume", "page", "line"],
            "/Epistulae: Collectio Patmensis (epistulae 1-52)": ["Epistle", "line"],
            "&Interpretatio in xii prophetas minores": ["Volume", "page", "line"],
            "Historia ecclesiastica": ["Page", "line"],
            "!Explanatio in Canticum canticorum": ["Volume", "page", "line"],
            "Interpretatio in Jeremiam": ["Volume", "page", "line"],
            "1Epistulae: Collectio Sirmondiana (epistulae 1-95)": ["Epistle", "line"],
            "Quaestiones in Octateuchum": ["Page", "line"],
            ",Libellus contra Nestorium ad Sporacium [Sp.]": ["Volume", "page", "line"],
            "Interpretatio in Ezechielem": ["Volume", "page", "line"],
            "Graecarum affectionum curatio": ["Book", "section", "line"],
            "qAd eos qui in Euphratesia et Osrhoena regione, Syria, Phoenicia et Cilicia vitam monasticam degunt (ex epistula 1": [
                "Volume",
                "page",
                "line",
            ],
            "+Interpretatio in xiv epistulas sancti Pauli": ["Volume", "page", "line"],
            '"Historia religiosa (%6 Philotheus)': ["Vita", "section", "line"],
            "3Epistulae: Collectio Sirmondiana (epistulae 96-147)": ["Epistle", "line"],
            "De providentia orationes decem": ["Volume", "page", "line"],
            "De incarnatione domini": ["Volume", "page", "line"],
            "/Quaestiones in libros Regnorum et Paralipomenon": [
                "Volume",
                "page",
                "line",
            ],
            "FQuod unicus filius sit dominus noster Jesus Christus (ex epistula 151)": [
                "Volume",
                "page",
                "line",
            ],
            "0Quaestiones et responsiones ad orthodoxos [Dub.]": ["Page", "line"],
            "!Haereticarum fabularum compendium": ["Volume", "page", "line"],
        },
    },
    "Aristides Apol.": {
        "tlg_id": "TLG1184",
        "names": {"name_authtab": "Aristides Apol.", "name_idt": "Aristides Apol."},
        "works": {
            "Fragmenta (P. Lond. 2486)": ["line"],
            "Fragmenta (P. Oxy. 15.1778)": ["Fragment", "line"],
            "Fragmenta": ["Chapter", "section", "line"],
        },
    },
    "Chaeremon Trag.": {
        "tlg_id": "TLG0328",
        "names": {"name_authtab": "Chaeremon Trag.", "name_idt": "Chaeremon Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philemon Comic.": {
        "tlg_id": "TLG0487",
        "names": {"name_authtab": "Philemon Comic.", "name_idt": "Philemon Comic."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Pythaenetus Hist.": {
        "tlg_id": "TLG1649",
        "names": {"name_authtab": "Pythaenetus Hist.", "name_idt": "Pythaenetus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Euthydemus Med.": {
        "tlg_id": "TLG0897",
        "names": {"name_authtab": "Euthydemus Med.", "name_idt": "Euthydemus Med."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Pausanias Perieg.": {
        "tlg_id": "TLG0525",
        "names": {"name_authtab": "Pausanias Perieg.", "name_idt": "Pausanias Perieg."},
        "works": {"Graeciae descriptio": ["Book", "chapter", "section", "line"]},
    },
    "Photius Lexicogr., Scr. Eccl., Theol.": {
        "tlg_id": "TLG4040",
        "names": {
            "name_authtab": "Photius Lexicogr., Scr. Eccl. et Theol.",
            "name_idt": "Photius Lexicogr., Scr. Eccl., Theol.",
        },
        "works": {
            "#Commentarii in Joannem (in catenis)": ["Fragment", "line"],
            "/Fragmenta in epistulam ad Ephesios (in catenis)": ["Page", "line"],
            "%Commentarii in Matthaeum (in catenis)": ["Fragment", "line"],
            "2Fragmentum in epistulam ad Philemonem (in catenis)": ["Page", "line"],
            "": ["Lexicon", "", "Alphabetic letter", "Page", "line"],
            "3Fragmenta in epistulam I ad Corinthios (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Galatas (in catenis)": ["Page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "4Fragmentum in epistulam ii ad Timotheum (in catenis)": ["Page", "line"],
            "3Fragmenta in epistulam ad Philippenses (in catenis)": ["Page", "line"],
            "2Fragmenta in epistulam i ad Timotheum (in catenis)": ["Page", "line"],
            "Bibliotheca": ["Codex", "Bekker page", "line"],
            ":Fragmenta in epistulam ii ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
            "4Fragmenta in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            "/Fragmenta in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
            "Epigramma": ["Book", "epigram", "line"],
            "2Fragmenta in epistulam ad Colossenses (in catenis)": ["Page", "line"],
            "9Fragmenta in epistulam I ad Thessalonicenses (in catenis)": [
                "Page",
                "line",
            ],
        },
    },
    "Carystius Hist.": {
        "tlg_id": "TLG1245",
        "names": {"name_authtab": "Carystius Hist.", "name_idt": "Carystius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diodorus Phil.": {
        "tlg_id": "TLG2681",
        "names": {"name_authtab": "Diodorus Phil.", "name_idt": "Diodorus Phil."},
        "works": {"Fragmentum": ["line"]},
    },
    "Philemon Junior Comic.": {
        "tlg_id": "TLG0488",
        "names": {
            "name_authtab": "Philemon Junior Comic.",
            "name_idt": "Philemon Junior Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Severus Phil.": {
        "tlg_id": "TLG2970",
        "names": {"name_authtab": "Severus Phil.", "name_idt": "Severus Phil."},
        "works": {"$*PERI\\ YUXH=S &(fragmentum)": ["Page+column", "line"]},
    },
    "Theophilus Apol.": {
        "tlg_id": "TLG1725",
        "names": {"name_authtab": "Theophilus Apol.", "name_idt": "Theophilus Apol."},
        "works": {"Ad Autolycum": ["Book", "section", "line"]},
    },
    "Eumachus Hist.": {
        "tlg_id": "TLG1972",
        "names": {"name_authtab": "Eumachus Hist.", "name_idt": "Eumachus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Epistula A Martyribus Lugdunensibus": {
        "tlg_id": "TLG1349",
        "names": {
            "name_authtab": "Epistula A Martyribus Lugdunensibus",
            "name_idt": "Epistula A Martyribus Lugdunensibus",
        },
        "works": {"/Fragmentum epistulae a martyribus Lugdunensibus": ["Page", "line"]},
    },
    "Aëtius Doxogr.": {
        "tlg_id": "TLG0528",
        "names": {"name_authtab": "Aëtius Doxogr.", "name_idt": "Aëtius Doxogr."},
        "works": {
            "(De placitis reliquiae (Stobaei excerpta)": ["Page", "line"],
            "6De placitis reliquiae (Theodoreti et Nemesii excerpta)": ["Page", "line"],
        },
    },
    "Zaleucus Nomographus Phil.": {
        "tlg_id": "TLG0601",
        "names": {
            "name_authtab": "Zaleucus Nomographus Phil.",
            "name_idt": "Zaleucus Nomographus Phil.",
        },
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Mamercus Eleg.": {
        "tlg_id": "TLG1476",
        "names": {"name_authtab": "Mamercus Eleg.", "name_idt": "Mamercus Eleg."},
        "works": {"Epigramma": ["Epigram", "line"]},
    },
    "Periplus Hannonis": {
        "tlg_id": "TLG0064",
        "names": {"name_authtab": "Periplus Hannonis", "name_idt": "Periplus Hannonis"},
        "works": {"": ["Periplus Hannonis", "Section", "line"]},
    },
    "[Hermes] Alchem.": {
        "tlg_id": "TLG4325",
        "names": {"name_authtab": "[Hermes] Alchem.", "name_idt": "[Hermes] Alchem."},
        "works": {
            "m$*AI)/NIGMA TOU= FILOSOFIKOU= LI/QOU *(ERMOU= KAI\\ *)AGAQODAI/MONOS &(e cod. Paris. B.N. gr. 2327, fol. 234r)": [
                "Volume",
                "page",
                "line",
            ],
            "8Aenigma (sine titulo) (e cod. Venet. Marc. 299, fol. 95)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Stephanus Med., Phil.": {
        "tlg_id": "TLG0724",
        "names": {
            "name_authtab": "Stephanus Med. et Phil.",
            "name_idt": "Stephanus Med., Phil.",
        },
        "works": {
            "?Commentarii in priorem Galeni librum therapeuticum ad Glauconem": [
                "Volume",
                "page",
                "line",
            ],
            "#Scholia in Hippocratis de fracturis": ["Page", "line"],
            "<Collyrium ophthalmicum (olim sub auctore Stephano Archiatro)": [
                "Page",
                "line",
            ],
            "#Scholia in Hippocratis prognosticon": ["Chapter", "section", "line"],
        },
    },
    "Philosophus Anonymus Alchem.": {
        "tlg_id": "TLG4329",
        "names": {
            "name_authtab": "Philosophus Anonymus Alchem.",
            "name_idt": "Philosophus Anonymus Alchem.",
        },
        "works": {
            "q$*)ANEPIGRA/FOU FILOSO/FOU KATA\\ A)KOLOUQI/AN XRH/SEWS E)MFAI=NON TO\\ TH=S XRUSOPOII/AS SUNEPTUGME/NON SU\\N QEW=|": [
                "Volume",
                "page",
                "line",
            ],
            "e$*)ANEPIGRA/FOU FILOSO/FOU PERI\\ QEI/OU U(/DATOS TH=S LEUKW/SEWS &(e cod. Venet. Marc. 299, fol. 78r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*)ANEPIGRA/FOU FILOSO/FOU PERI\\ TH=S QEI/AS KAI\\ I(ERA=S TE/XNHS FILOSO/FWN &(e codd. Venet. Marc. 299, fol. 181": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Cratinus Junior Comic.": {
        "tlg_id": "TLG0435",
        "names": {
            "name_authtab": "Cratinus Junior Comic.",
            "name_idt": "Cratinus Junior Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Pompeius Macer Trag.": {
        "tlg_id": "TLG0346",
        "names": {
            "name_authtab": "Pompeius Macer Trag.",
            "name_idt": "Pompeius Macer Trag.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Apollonius Rhodius Epic.": {
        "tlg_id": "TLG0001",
        "names": {
            "name_authtab": "Apollonius Rhodius Epic.",
            "name_idt": "Apollonius Rhodius Epic.",
        },
        "works": {
            "Argonautica": ["Book", "line", "Íßó×\x1bíÇÝó´\x8cÈÞ2'"],
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "[Timotheus] Hist.": {
        "tlg_id": "TLG2213",
        "names": {"name_authtab": "[Timotheus] Hist.", "name_idt": "[Timotheus] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Isidorus Scriptor Hymnorum": {
        "tlg_id": "TLG0359",
        "names": {
            "name_authtab": "Isidorus Scriptor Hymnorum",
            "name_idt": "Isidorus Scriptor Hymnorum",
        },
        "works": {"Hymni in Isim": ["Hymn", "line"]},
    },
    "Xenophilus Mus., Phil.": {
        "tlg_id": "TLG2241",
        "names": {
            "name_authtab": "Xenophilus Mus. et Phil.",
            "name_idt": "Xenophilus Mus., Phil.",
        },
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Mimnermus Eleg.": {
        "tlg_id": "TLG0255",
        "names": {"name_authtab": "Mimnermus Eleg.", "name_idt": "Mimnermus Eleg."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["line", "fragment", "line"],
        },
    },
    "Democritus Hist.": {
        "tlg_id": "TLG1305",
        "names": {"name_authtab": "Democritus Hist.", "name_idt": "Democritus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Martyrium Ignatii": {
        "tlg_id": "TLG2657",
        "names": {"name_authtab": "Martyrium Ignatii", "name_idt": "Martyrium Ignatii"},
        "works": {
            "4Martyrium Ignatii Antiocheni (martyrium Antiochenum)": [
                "Chapter",
                "section",
                "line",
            ],
            "0Martyrium Ignatii Antiocheni (martyrium Romanum)": [
                "Chapter",
                "section",
                "line",
            ],
        },
    },
    "Geminus Astron.": {
        "tlg_id": "TLG1383",
        "names": {"name_authtab": "Geminus Astron.", "name_idt": "Geminus Astron."},
        "works": {
            "Fragmenta optica [Dub.]": ["Page", "line"],
            "Calendarium [Sp.?]": ["Page", "line"],
            "Elementa astronomiae": ["Chapter", "section", "line"],
        },
    },
    "Asterius Scr. Eccl.": {
        "tlg_id": "TLG2060",
        "names": {
            "name_authtab": "Asterius Scr. Eccl.",
            "name_idt": "Asterius Scr. Eccl.",
        },
        "works": {
            '"Homilia 9 (ex Symeone Metaphraste)': ["Homily", "page", "line"],
            "Homiliae 1-14": ["Homily", "chapter", "section", "line"],
        },
    },
    "Achilles Tatius Scr. Erot.": {
        "tlg_id": "TLG0532",
        "names": {
            "name_authtab": "Achilles Tatius Scr. Erot.",
            "name_idt": "Achilles Tatius Scr. Erot.",
        },
        "works": {"Leucippe et Clitophon": ["Book", "chapter", "section", "line"]},
    },
    "Camaterus Astrol., Astron.": {
        "tlg_id": "TLG3014",
        "names": {
            "name_authtab": "Joannes Camaterus Astrol. et Astron.",
            "name_idt": "Camaterus Astrol., Astron.",
        },
        "works": {"De zodiaco": ["line"], "Introductio in astronomiam": ["line"]},
    },
    "Asius Eleg., Epic.": {
        "tlg_id": "TLG0242",
        "names": {
            "name_authtab": "Asius Eleg. et Epic.",
            "name_idt": "Asius Eleg., Epic.",
        },
        "works": {
            "Fragmenta epica": ["Fragment", "line"],
            "Fragmentum elegiacum": ["line"],
        },
    },
    "Semus Gramm.": {
        "tlg_id": "TLG1663",
        "names": {"name_authtab": "Semus Gramm.", "name_idt": "Semus Gramm."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Alexinus Phil.": {
        "tlg_id": "TLG2607",
        "names": {"name_authtab": "Alexinus Phil.", "name_idt": "Alexinus Phil."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Anatolius Math., Phil.": {
        "tlg_id": "TLG2577",
        "names": {
            "name_authtab": "Anatolius Math. et Phil.",
            "name_idt": "Anatolius Math., Phil.",
        },
        "works": {
            "5$*PERI\\ DEKA/DOS KAI\\ TW=N E)NTO\\S AU)TH=S A)RIQMW=N&": [
                "Page",
                "line",
            ]
        },
    },
    "Pamphilus Poeta": {
        "tlg_id": "TLG2634",
        "names": {"name_authtab": "Pamphilus Poeta", "name_idt": "Pamphilus Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Arius Didymus Doxogr.": {
        "tlg_id": "TLG0529",
        "names": {
            "name_authtab": "Arius Didymus Doxogr.",
            "name_idt": "Arius Didymus Doxogr.",
        },
        "works": {
            "Physica (fragmenta)": ["Fragment", "line"],
            "4Liber de philosophorum sectis (epitome ap. Stobaeum)": [
                "Page+column",
                "line",
            ],
        },
    },
    "Callinus Eleg.": {
        "tlg_id": "TLG0243",
        "names": {"name_authtab": "Callinus Eleg.", "name_idt": "Callinus Eleg."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Callias Comic.": {
        "tlg_id": "TLG0426",
        "names": {"name_authtab": "Callias Comic.", "name_idt": "Callias Comic."},
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Doctrina Patrum": {
        "tlg_id": "TLG7051",
        "names": {"name_authtab": "Doctrina Patrum", "name_idt": "Doctrina Patrum"},
        "works": {
            "MDoctrina patrum (fort. auctore Anastasio Sinai+ta vel Anastasio Apocrisiario)": [
                "Page",
                "line",
            ]
        },
    },
    "Scythinus Epigr.": {
        "tlg_id": "TLG2680",
        "names": {"name_authtab": "Scythinus Epigr.", "name_idt": "Scythinus Epigr."},
        "works": {"Epigrammata": ["Book", "epigram", "line"]},
    },
    "Cydias Lyr.": {
        "tlg_id": "TLG0368",
        "names": {"name_authtab": "Cydias Lyr.", "name_idt": "Cydias Lyr."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Epilycus Comic.": {
        "tlg_id": "TLG0453",
        "names": {"name_authtab": "Epilycus Comic.", "name_idt": "Epilycus Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Basilides Phil.": {
        "tlg_id": "TLG2398",
        "names": {"name_authtab": "Basilides Phil.", "name_idt": "Basilides Phil."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Antiochus Phil.": {
        "tlg_id": "TLG1143",
        "names": {"name_authtab": "Antiochus Phil.", "name_idt": "Antiochus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hippys Hist.": {
        "tlg_id": "TLG1438",
        "names": {"name_authtab": "Hippys Hist.", "name_idt": "Hippys Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Crito Hist.": {
        "tlg_id": "TLG1867",
        "names": {"name_authtab": "Crito Hist.", "name_idt": "Crito Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Serenus Geom.": {
        "tlg_id": "TLG2055",
        "names": {"name_authtab": "Serenus Geom.", "name_idt": "Serenus Geom."},
        "works": {
            "De sectione cylindri": ["Page", "line"],
            "De sectione coni": ["Page", "line"],
        },
    },
    "Artaxerxis Epistulae": {
        "tlg_id": "TLG0045",
        "names": {
            "name_authtab": "Artaxerxis Epistulae",
            "name_idt": "Artaxerxis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Melissa Phil.": {
        "tlg_id": "TLG0051",
        "names": {"name_authtab": "Melissa Phil.", "name_idt": "Melissa Phil."},
        "works": {"!Fragmentum epistulae ad Clearetam": ["Page", "line"]},
    },
    "Paraleipomena Jeremiou": {
        "tlg_id": "TLG1772",
        "names": {
            "name_authtab": "Paraleipomena Jeremiou",
            "name_idt": "Paraleipomena Jeremiou",
        },
        "works": {"Paraleipomena Jeremiou": ["Chapter", "section", "line"]},
    },
    "Tryphon I Gramm.": {
        "tlg_id": "TLG0609",
        "names": {"name_authtab": "Tryphon I Gramm.", "name_idt": "Tryphon I Gramm."},
        "works": {
            "$*PERI\\ PAQW=N&": ["Chapter", "section", "line"],
            "Fragmenta": ["Treatise", "fragment", "line"],
            "$*PERI\\ TRO/PWN&": ["Page", "line"],
        },
    },
    "Nicephorus I Scr. Eccl., Hist., Theol.": {
        "tlg_id": "TLG3086",
        "names": {
            "name_authtab": "Nicephorus I Scr. Eccl., Hist. et Theol.",
            "name_idt": "Nicephorus I Scr. Eccl., Hist., Theol.",
        },
        "works": {
            ".Chronographia brevis [Dub.] (recensiones duae)": [
                "Page",
                "line",
                "Ñßíüê\x18",
            ],
            "4Refutatio et eversio definitionis synodalis anni 815": [
                "Chapter",
                "line",
            ],
            "RBreviarium historicum de rebus gestis post imperium Mauricii (e cod. Vat. gr. 977)": [
                "Page",
                "line",
                "",
            ],
        },
    },
    "Callinicus Biogr.": {
        "tlg_id": "TLG2770",
        "names": {"name_authtab": "Callinicus Biogr.", "name_idt": "Callinicus Biogr."},
        "works": {
            "Vita sancti Hypatii": [
                "\x1bDedication-prologue-chapter",
                "section",
                "line",
            ]
        },
    },
    "Praelusio Mimi": {
        "tlg_id": "TLG0278",
        "names": {"name_authtab": "Praelusio Mimi", "name_idt": "Praelusio Mimi"},
        "works": {"Fragmentum (P. Giss. 1.1)": ["line"]},
    },
    "[Agathodaemon] Alchem.": {
        "tlg_id": "TLG4086",
        "names": {
            "name_authtab": "[Agathodaemon] Alchem.",
            "name_idt": "[Agathodaemon] Alchem.",
        },
        "works": {
            "q$*)AGAQODAI/MWN EI)S TO\\N XRHSMO/N&:$ *)ORFE/WS SUNAGWGH\\ KAI\\ U(PO/MNHMA &(e cod. Paris. B.N. gr. 2327, fol. 262": [
                "Volume",
                "page",
                "line",
            ],
            "GFragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 95v)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Thessalus Astrol., Med.": {
        "tlg_id": "TLG1004",
        "names": {
            "name_authtab": "Thessalus Astrol. et Med.",
            "name_idt": "Thessalus Astrol., Med.",
        },
        "works": {
            "_De virtutibus herbarum (e codd. Paris. gr. 2502 %7 Vindob. med. gr. 23 %7 Londin. reg. 16 C II)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "UDe virtutibus herbarum (e codd. Paris. gr. 2256 %7 Venet. App. cl. V 13 %7 Mosq. 415)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "*De virtutibus herbarum (e cod. Monac. 542)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "FDe virtutibus herbarum (e cod. Paris. gr. 2502 %7 Vindob. med. gr. 23)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "BDe virtutibus herbarum (e cod. Matrit. Bibl. Nat. 4631 [olim 110])": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
        },
    },
    "Cleanthes Phil.": {
        "tlg_id": "TLG1269",
        "names": {"name_authtab": "Cleanthes Phil.", "name_idt": "Cleanthes Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia et fragmenta": ["Fragment", "line"],
        },
    },
    "Josephus Hist.": {
        "tlg_id": "TLG0526",
        "names": {
            "name_authtab": "Flavius Josephus Hist.",
            "name_idt": "Josephus Hist.",
        },
        "works": {
            "Josephi vita": ["Section", "line"],
            "Antiquitates Judaicae": ["Book", "chapter", "line"],
            "De bello Judaico libri vii": ["Book", "section", "line"],
            "*Contra Apionem (%6 De Judaeorum vetustate)": ["Book", "section", "line"],
        },
    },
    "Sminthes Astron.": {
        "tlg_id": "TLG2644",
        "names": {"name_authtab": "Sminthes Astron.", "name_idt": "Sminthes Astron."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Longus Scr. Erot.": {
        "tlg_id": "TLG0561",
        "names": {"name_authtab": "Longus Scr. Erot.", "name_idt": "Longus Scr. Erot."},
        "works": {"Daphnis et Chloe": ["Book", "chapter", "section", "line"]},
    },
    "Didymarchus Poeta": {
        "tlg_id": "TLG2618",
        "names": {"name_authtab": "Didymarchus Poeta", "name_idt": "Didymarchus Poeta"},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Phocylides Eleg., Gnom.": {
        "tlg_id": "TLG1604",
        "names": {
            "name_authtab": "Phocylides Eleg. et Gnom.",
            "name_idt": "Phocylides Eleg., Gnom.",
        },
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Sententiae": ["Fragment", "line"],
        },
    },
    "Hypermenes Hist.": {
        "tlg_id": "TLG2277",
        "names": {"name_authtab": "Hypermenes Hist.", "name_idt": "Hypermenes Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Leo Magentinus Phil.": {
        "tlg_id": "TLG4187",
        "names": {
            "name_authtab": "Leo Magentinus Phil.",
            "name_idt": "Leo Magentinus Phil.",
        },
        "works": {
            "FCommentarium in Aristotelis categorias (excerptum e cod. Vat. gr. 244)": [
                "line"
            ],
            "OCommentarium in Aristotelis sophisticos elenchos (excerpta e cod. Vat. gr. 244)": [
                "\x10Bekker page+line",
                "line",
            ],
            "YCommentarium in Aristotelis sophisticos elenchos (excerpta praecipue e cod. Vat. gr. 244)": [
                "Scholion",
                "line",
            ],
        },
    },
    "Comarius Alchem.": {
        "tlg_id": "TLG2632",
        "names": {"name_authtab": "Comarius Alchem.", "name_idt": "Comarius Alchem."},
        "works": {
            "?De lapide philosophorum (e cod. Paris. B.N. gr. 2327, fol. 74r)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Damigeron Magus": {
        "tlg_id": "TLG2655",
        "names": {"name_authtab": "Damigeron Magus", "name_idt": "Damigeron Magus"},
        "works": {
            "6De lapidibus (e codd. Vat. gr. 578 %7 Ambros. 95 sup.)": ["Page", "line"]
        },
    },
    "Scholia In Oppianum": {
        "tlg_id": "TLG5032",
        "names": {
            "name_authtab": "Scholia In Oppianum",
            "name_idt": "Scholia In Oppianum",
        },
        "works": {
            "?Scholia et glossae in cynegetica (scholia vetera et recentiora)": [
                "Book",
                "scholion",
                "line",
            ],
            "?Scholia et glossae in halieutica (scholia vetera et recentiora)": [
                "\x0fHypothesis-book",
                "scholion",
                "line",
            ],
        },
    },
    "Myrsilus Hist.": {
        "tlg_id": "TLG2331",
        "names": {"name_authtab": "Myrsilus Hist.", "name_idt": "Myrsilus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Agathon Trag.": {
        "tlg_id": "TLG0318",
        "names": {"name_authtab": "Agathon Trag.", "name_idt": "Agathon Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Phoenicides Comic.": {
        "tlg_id": "TLG0495",
        "names": {
            "name_authtab": "Phoenicides Comic.",
            "name_idt": "Phoenicides Comic.",
        },
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Cercops Phil.": {
        "tlg_id": "TLG2286",
        "names": {"name_authtab": "Cercops Phil.", "name_idt": "Cercops Phil."},
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "Hesychius Lexicogr.": {
        "tlg_id": "TLG4085",
        "names": {
            "name_authtab": "Hesychius Lexicogr.",
            "name_idt": "Hesychius Lexicogr.",
        },
        "works": {
            "": ["Lexicon", "", "Alphabetic letter", "entry", "line"],
            "Epistula ad Eulogium": ["line"],
        },
    },
    "Demosthenes Epigr.": {
        "tlg_id": "TLG1819",
        "names": {
            "name_authtab": "Pseudo-Demosthenes Epigr.",
            "name_idt": "Demosthenes Epigr.",
        },
        "works": {"Epigramma": ["Epigram", "line"]},
    },
    "Echephylidas Hist.": {
        "tlg_id": "TLG2289",
        "names": {
            "name_authtab": "Echephylidas Hist.",
            "name_idt": "Echephylidas Hist.",
        },
        "works": {"Fragmenta": ["FGrH fragment", "line"]},
    },
    "Zenodorus Gramm.": {
        "tlg_id": "TLG0597",
        "names": {"name_authtab": "Zenodorus Gramm.", "name_idt": "Zenodorus Gramm."},
        "works": {
            "F$*PERI\\ SUNHQEI/AS& (e cod. Paris. suppl. gr. 1164 [olim cod. Athon.])": [
                "Page",
                "line",
            ]
        },
    },
    "Evangelium Philippi": {
        "tlg_id": "TLG1373",
        "names": {
            "name_authtab": "Evangelium Philippi",
            "name_idt": "Evangelium Philippi",
        },
        "works": {"Evangelium Philippi": ["line"]},
    },
    "Joannes Rhet.": {
        "tlg_id": "TLG4157",
        "names": {"name_authtab": "Joannes Rhet.", "name_idt": "Joannes Rhet."},
        "works": {
            "WProlegomena in Hermogenis librum $PERI\\ EU(RE/SEWS &(olim sub auctore Georgio Diaereta)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Charon Hist.": {
        "tlg_id": "TLG1258",
        "names": {"name_authtab": "Charon Hist.", "name_idt": "Charon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dicaeogenes Trag.": {
        "tlg_id": "TLG0322",
        "names": {"name_authtab": "Dicaeogenes Trag.", "name_idt": "Dicaeogenes Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philoxenus Lyr.": {
        "tlg_id": "TLG0380",
        "names": {"name_authtab": "Philoxenus Lyr.", "name_idt": "Philoxenus Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"], "Fragmentum [Sp.]": ["line"]},
    },
    "Anonyma De Musica Scripta Bellermanniana": {
        "tlg_id": "TLG1127",
        "names": {
            "name_authtab": "Anonyma De Musica Scripta Bellermanniana",
            "name_idt": "Anonyma De Musica Scripta Bellermanniana",
        },
        "works": {"(Anonyma de musica scripta Bellermanniana": ["Section", "line"]},
    },
    "Theodorides Trag.": {
        "tlg_id": "TLG1094",
        "names": {"name_authtab": "Theodorides Trag.", "name_idt": "Theodorides Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Harmodius Trag.": {
        "tlg_id": "TLG0720",
        "names": {"name_authtab": "Harmodius Trag.", "name_idt": "Harmodius Trag."},
        "works": {"Titulus": ["line"]},
    },
    "[Theophilus] Hist.": {
        "tlg_id": "TLG2203",
        "names": {
            "name_authtab": "[Theophilus] Hist.",
            "name_idt": "[Theophilus] Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollinarius Apol.": {
        "tlg_id": "TLG1163",
        "names": {
            "name_authtab": "Claudius Apollinarius Apol.",
            "name_idt": "Apollinarius Apol.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Porphyrius Phil.": {
        "tlg_id": "TLG2034",
        "names": {"name_authtab": "Porphyrius Phil.", "name_idt": "Porphyrius Phil."},
        "works": {
            "Vita Plotini": ["Section", "line"],
            ".$*EI)S TA\\ A(RMONIKA\\ *PTOLEMAI/OU U(PO/MNHMA&": ["Page", "line"],
            ":Quaestionum Homericarum ad Odysseam pertinentium reliquiae": [
                "Odyssey book",
                "section",
                "line",
            ],
            "De abstinentia": ["Book", "section", "line"],
            "!Historia philosophiae (fragmenta)": ["Fragment", "line"],
            "/Quaestionum Homericarum liber i (recensio $*X&)": ["Section", "line"],
            "De philosophia ex oraculis": ["Page", "line"],
            "Epistula ad Anebonem": ["Chapter", "section", "line"],
            "$*PERI\\ A)GALMA/TWN&": ["Section", "line"],
            "Contra Christianos (fragmenta)": ["Fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "GIn Aristotelis categorias expositio per interrogationem et responsionem": [
                "Volume",
                "page",
                "line",
            ],
            ".In Platonis Parmenidem commentaria (fragmenta)": ["Section", "line"],
            "Chronica": ["Fragment", "section", "line"],
            "%Sententiae ad intelligibilia ducentes": ["Sententia", "line"],
            "De antro nympharum": ["Section", "line"],
            "Isagoge sive quinque voces": ["Volume", "page", "line"],
            "+In Platonis Timaeum commentaria (fragmenta)": [
                "Book",
                "fragment",
                "line",
            ],
            ",Quaestionum Homericarum liber i (recensio V)": ["Section", "line"],
            ",Quaestionum Homericarum liber i (recensio T)": ["Page", "line"],
            "Vita Pythagorae": ["Section", "line"],
            "Testimonia": ["line", "fragment", "line"],
            ",Quaestionum Homericarum liber i (recensio B)": ["Page", "line"],
            "9Quaestionum Homericarum ad Iliadem pertinentium reliquiae": [
                "Iliad book",
                "section",
                "line",
            ],
            "6Commentarium in Platonis Timaeum (fragmentum incertum)": [
                "Fragment",
                "line",
            ],
            "Ad Marcellam": ["Section", "line"],
            "Zetemata codicis Vaticani": ["Page", "line"],
        },
    },
    "Agl(a)osthenes Hist.": {
        "tlg_id": "TLG2345",
        "names": {
            "name_authtab": "Agl(a)osthenes Hist.",
            "name_idt": "Agl(a)osthenes Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cameniates Hist.": {
        "tlg_id": "TLG3015",
        "names": {
            "name_authtab": "Joannes Cameniates Hist.",
            "name_idt": "Cameniates Hist.",
        },
        "works": {"De expugnatione Thessalonicae": ["Chapter", "section", "line"]},
    },
    "Critobulus Hist.": {
        "tlg_id": "TLG3147",
        "names": {
            "name_authtab": "Michael Critobulus Hist.",
            "name_idt": "Critobulus Hist.",
        },
        "works": {
            "Poema": ["line"],
            "Precatio": ["Page", "line"],
            "Epistula ad Mechemet II": ["Codex", "section", "line"],
            "Historiae": ["Book", "chapter", "section", "line"],
        },
    },
    "Alexander Comic.": {
        "tlg_id": "TLG0401",
        "names": {"name_authtab": "Alexander Comic.", "name_idt": "Alexander Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Callimachus Junior Epic.": {
        "tlg_id": "TLG2613",
        "names": {
            "name_authtab": "Callimachus Junior Epic.",
            "name_idt": "Callimachus Junior Epic.",
        },
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Pythocles Hist.": {
        "tlg_id": "TLG2560",
        "names": {"name_authtab": "Pythocles Hist.", "name_idt": "Pythocles Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Alcman Lyr.": {
        "tlg_id": "TLG0291",
        "names": {"name_authtab": "Alcman Lyr.", "name_idt": "Alcman Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollinaris Theol.": {
        "tlg_id": "TLG2074",
        "names": {
            "name_authtab": "Apollinaris Theol.",
            "name_idt": "Apollinaris Theol.",
        },
        "works": {
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "!Fragmenta in Joannem (in catenis)": ["Fragment", "line"],
            "#Fragmenta in Matthaeum (in catenis)": ["Fragment", "line"],
            "!Fragmenta in Psalmos (in catenis)": ["Fragment", "line"],
        },
    },
    "Lexicon Vindobonense": {
        "tlg_id": "TLG4294",
        "names": {
            "name_authtab": "Lexicon Vindobonense",
            "name_idt": "Lexicon Vindobonense",
        },
        "works": {
            "NLexicon Vindobonense (auctore Andrea Lopadiota) (e cod. phil. gr. Vindob. 169)": [
                "",
                "Alphabetic letter",
                "entry",
                "line",
            ]
        },
    },
    "Tiberius Rhet.": {
        "tlg_id": "TLG2601",
        "names": {"name_authtab": "Tiberius Rhet.", "name_idt": "Tiberius Rhet."},
        "works": {"De figuris Demosthenicis": ["Section", "line"]},
    },
    "Geographica Adespota (GGM)": {
        "tlg_id": "TLG2030",
        "names": {
            "name_authtab": "Geographica Adespota (GGM)",
            "name_idt": "Geographica Adespota (GGM)",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Lollianus Scr. Erot.": {
        "tlg_id": "TLG1466",
        "names": {
            "name_authtab": "Lollianus Scr. Erot.",
            "name_idt": "Lollianus Scr. Erot.",
        },
        "works": {
            "/$*FOINIKIKA/ &(fragmenta) (P. Colon. inv. 3328)": ["Fragment", "line"],
            ",$*FOINIKIKA/& (fragmentum) (P. Oxy. 11.1368)": ["Column", "line"],
        },
    },
    "Ananius Iamb.": {
        "tlg_id": "TLG0238",
        "names": {"name_authtab": "Ananius Iamb.", "name_idt": "Ananius Iamb."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pythagoristae (D-K) Phil.": {
        "tlg_id": "TLG2239",
        "names": {
            "name_authtab": "Pythagoristae (D-K) Phil.",
            "name_idt": "Pythagoristae (D-K) Phil.",
        },
        "works": {"Testimonia et fragmenta": ["Fragment", "line"]},
    },
    "Gregorius Nazianzenus Theol.": {
        "tlg_id": "TLG2022",
        "names": {
            "name_authtab": "Gregorius Nazianzenus Theol.",
            "name_idt": "Gregorius Nazianzenus Theol.",
        },
        "works": {
            "": ["Carmina dogmatica", "Page", "line"],
            "!In Machabaeorum laudem (orat. 15)": ["Volume", "page", "line"],
            "In theophania (orat. 38)": ["Volume", "page", "line"],
            "In sancta lumina (orat. 39)": ["Volume", "page", "line"],
            "De filio (orat. 29)": ["Section", "line"],
            "K$*(O PROTREPTIKO\\S EI)S U(POMONH\\N H)\\ PRO\\S TOU\\S NEWSTI\\ BEBAPTISME/NOUS&": [
                "line"
            ],
            "De theologia (orat. 28)": ["Section", "line"],
            "%In laudem sororis Gorgoniae (orat. 8)": ["Volume", "page", "line"],
            "In novam Dominicam (orat. 44)": ["Volume", "page", "line"],
            '"In Aegyptiorum adventum (orat. 34)': ["Volume", "page", "line"],
            "De pace 3 (orat. 23)": ["Volume", "page", "line"],
            "Ad patrem (orat. 12)": ["Volume", "page", "line"],
            "Supremum vale (orat. 42)": ["Volume", "page", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Carmina moralia": ["Page", "line"],
            "'Comparatio vitarum (%6 carmen morale 8)": ["line"],
            "De filio (orat. 30)": ["Section", "line"],
            "De vita sua": ["line"],
            "7In consecratione Eulalii Doarensium episcopi (orat. 13)": [
                "Volume",
                "page",
                "line",
            ],
            "In patrem tacentem (orat. 16)": ["Volume", "page", "line"],
            " Ad Gregorium Nyssenum (orat. 11)": ["Volume", "page", "line"],
            " Apologeticus ad patrem (orat. 9)": ["Volume", "page", "line"],
            "2In seipsum ad patrem et Basilium magnum (orat. 10)": [
                "Volume",
                "page",
                "line",
            ],
            ".Fragmentum ex oratione contra astronomos [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "In laudem Cypriani (orat. 24)": ["Volume", "page", "line"],
            "2De dogmate et constitutione episcoporum (orat. 20)": [
                "Volume",
                "page",
                "line",
            ],
            "De pauperum amore (orat. 14)": ["Volume", "page", "line"],
            "Ad cives Nazianzenos (orat. 17)": ["Volume", "page", "line"],
            " Significatio in Ezechielem [Sp.]": ["Volume", "page", "line"],
            "5Ad eos qui ipsum acciverant nec occurrerant (orat. 3)": [
                "Volume",
                "page",
                "line",
            ],
            "De pace 1 (orat. 6)": ["Volume", "page", "line"],
            "In sanctum pascha (orat. 45)": ["Volume", "page", "line"],
            "Testamentum": ["Page", "line"],
            "-Alphabeticum paraeneticum 1 (e cod. Patm. 33)": ["line"],
            "De spiritu sancto (orat. 31)": ["Section", "line"],
            "Adversus Eunomianos (orat. 27)": ["Section", "line"],
            "SIn seipsum, cum rure rediisset, post ea quae a Maximo perpetrata fuerant (orat. 26)": [
                "Volume",
                "page",
                "line",
            ],
            "'De moderatione in disputando (orat. 32)": ["Volume", "page", "line"],
            ",In sanctum pascha et in tarditatem (orat. 1)": ["Volume", "page", "line"],
            "ZDe seipso et ad eos qui ipsum cathedram Constantinopolitanam affectare dicebant (orat. 36)": [
                "Volume",
                "page",
                "line",
            ],
            "Carmina de se ipso": ["Page", "line"],
            "'In laudem Heronis philosophi (orat. 25)": ["Volume", "page", "line"],
            "In sanctum baptisma (orat. 40)": ["Volume", "page", "line"],
            "2De martyribus et adversus Arianos (orat. 35) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "Epistulae": ["Epistle", "section", "line"],
            "Liturgia sancti Gregorii [Sp.]": ["Volume", "page", "line"],
            "'Contra Julianum imperatorem 2 (orat. 5)": ["Volume", "page", "line"],
            "SFunebris oratio in laudem Basilii Magni Caesareae in Cappadocia episcopi (orat. 43)": [
                "Chapter",
                "section",
                "line",
            ],
            "4Funebris in laudem Caesarii fratris oratio (orat. 7)": [
                "Chapter",
                "section",
                "line",
            ],
            "CIn dictum evangelii: Cum consummasset Jesus hos sermones (orat. 37)": [
                "Volume",
                "page",
                "line",
            ],
            "[De testamentis et adventu Christi (%6 carmen dogmaticum 9, additamentum inter vv. 18 et 19)": [
                "line"
            ],
            "De pace 2 (orat. 22)": ["Volume", "page", "line"],
            "$Funebris oratio in patrem (orat. 18)": ["Volume", "page", "line"],
            "Carmina quae spectant ad alios": ["Page", "line"],
            "Apologetica (orat. 2)": ["Volume", "page", "line"],
            "In laudem Athanasii (orat. 21)": ["Volume", "page", "line"],
            "&Contra Arianos et de seipso (orat. 33)": ["Volume", "page", "line"],
            "'Contra Julianum imperatorem 1 (orat. 4)": ["Volume", "page", "line"],
            "7$*(ALA/TION SKEUASQE\\N U(PO\\ TH=S E)NERGEI/AS TOIA/SDE&": [
                "Section",
                "line",
            ],
            ".Ad Julianum tributorum exaequatorem (orat. 19)": [
                "Volume",
                "page",
                "line",
            ],
            "Alphabeticum A [Sp.]": ["line"],
            "In pentecosten (orat. 41)": ["Volume", "page", "line"],
            "Epistulae theologicae": ["Epistle", "section", "line"],
            ";Christus patiens [Dub.] (fort. auctore Constantino Manasse)": ["line"],
        },
    },
    "Homerica": {
        "tlg_id": "TLG1802",
        "names": {"name_authtab": "Homerica", "name_idt": "Homerica"},
        "works": {"-Ilias Homerica in cyclum inclusa (fragmentum)": ["line"]},
    },
    "Laon Comic.": {
        "tlg_id": "TLG0469",
        "names": {"name_authtab": "Laon Comic.", "name_idt": "Laon Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Parthax Hist.": {
        "tlg_id": "TLG1568",
        "names": {"name_authtab": "Parthax Hist.", "name_idt": "Parthax Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Marcellinus I Med.": {
        "tlg_id": "TLG0667",
        "names": {
            "name_authtab": "Marcellinus I Med.",
            "name_idt": "Marcellinus I Med.",
        },
        "works": {"De pulsibus": ["line"]},
    },
    "Hieronymus Phil.": {
        "tlg_id": "TLG1430",
        "names": {"name_authtab": "Hieronymus Phil.", "name_idt": "Hieronymus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Dionysius Soph.": {
        "tlg_id": "TLG4184",
        "names": {"name_authtab": "Dionysius Soph.", "name_idt": "Dionysius Soph."},
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Theognis Eleg.": {
        "tlg_id": "TLG0002",
        "names": {"name_authtab": "Theognis Eleg.", "name_idt": "Theognis Eleg."},
        "works": {
            "Fragmenta dubia": ["Fragment", "line"],
            "Elegiae": ["Book", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Fragmenta sedis incertae": ["line"],
        },
    },
    "Chronicon Paschale": {
        "tlg_id": "TLG2371",
        "names": {
            "name_authtab": "Chronicon Paschale",
            "name_idt": "Chronicon Paschale",
        },
        "works": {"Chronicon paschale": ["Page", "line"]},
    },
    "Anonymi Curetum Hymnus": {
        "tlg_id": "TLG0227",
        "names": {
            "name_authtab": "Anonymi Curetum Hymnus",
            "name_idt": "Anonymi Curetum Hymnus",
        },
        "works": {"Hymnus Curetum": ["line"]},
    },
    "Leo Phil.": {
        "tlg_id": "TLG0723",
        "names": {"name_authtab": "Leo Phil.", "name_idt": "Leo Phil."},
        "works": {
            "De natura hominum synopsis": ["Section", "line"],
            "Conspectus medicinae": ["Chapter", "section", "line"],
        },
    },
    "Martyrium Dasii": {
        "tlg_id": "TLG2010",
        "names": {"name_authtab": "Martyrium Dasii", "name_idt": "Martyrium Dasii"},
        "works": {"Martyrium Dasii": ["Chapter", "section", "line"]},
    },
    "Telesilla Lyr.": {
        "tlg_id": "TLG0369",
        "names": {"name_authtab": "Telesilla Lyr.", "name_idt": "Telesilla Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Alcimenes Comic.": {
        "tlg_id": "TLG1780",
        "names": {"name_authtab": "Alcimenes Comic.", "name_idt": "Alcimenes Comic."},
        "works": {"Titulus": ["Page", "line"]},
    },
    "Melito Apol.": {
        "tlg_id": "TLG1495",
        "names": {"name_authtab": "Melito Apol.", "name_idt": "Melito Apol."},
        "works": {
            ":De pascha (P. Beatty 8 %7 P. Bodmer 13 %7 P. Oxy. 13.1600)": ["line"],
            "Fragmenta": ["Fragment", "section", "line"],
            "Fragmentum (P. Bodmer 12)": ["line"],
        },
    },
    "Dius Phil.": {
        "tlg_id": "TLG1334",
        "names": {"name_authtab": "Dius Phil.", "name_idt": "Dius Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Menesthenes Hist.": {
        "tlg_id": "TLG1505",
        "names": {"name_authtab": "Menesthenes Hist.", "name_idt": "Menesthenes Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Galenus Gramm.": {
        "tlg_id": "TLG3039",
        "names": {
            "name_authtab": "Joannes Galenus Gramm.",
            "name_idt": "Galenus Gramm.",
        },
        "works": {
            " Allegoriae in Hesiodi theogoniam": ["Page", "line"],
            '"Allegoriae in Homeri Iliadem 4.1-4': ["Page", "line"],
        },
    },
    "Liber Jannes Et Jambres": {
        "tlg_id": "TLG1859",
        "names": {
            "name_authtab": "Liber Jannes Et Jambres",
            "name_idt": "Liber Jannes Et Jambres",
        },
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Cleophon Trag.": {
        "tlg_id": "TLG1087",
        "names": {"name_authtab": "Cleophon Trag.", "name_idt": "Cleophon Trag."},
        "works": {"Tituli": ["line"]},
    },
    "Thucydides Hist.": {
        "tlg_id": "TLG0003",
        "names": {"name_authtab": "Thucydides Hist.", "name_idt": "Thucydides Hist."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Historiae": ["Book", "chapter", "section", "line"],
        },
    },
    "Basilius Scr. Eccl.": {
        "tlg_id": "TLG2800",
        "names": {
            "name_authtab": "Basilius Scr. Eccl.",
            "name_idt": "Basilius Scr. Eccl.",
        },
        "works": {
            "Homilia in passionem domini": ["Volume", "page", "line"],
            "Sermones xli": ["Page", "line"],
            "3De vita et miraculis sanctae Theclae libri ii [Sp.]": [
                "Book",
                "section",
                "line",
            ],
            "Homilia in assumptionem domini": ["Volume", "page", "line"],
            "Homilia in sanctum Andream": ["Volume", "page", "line"],
            "Homilia in pentecosten": ["Volume", "page", "line"],
            "2Homilia in sanctum pascha et in recens illuminatos": [
                "Volume",
                "page",
                "line",
            ],
            "Homilia in sanctum pascha": ["Volume", "page", "line"],
            "+Homilia in feriam v et in proditionem Judae": ["Volume", "page", "line"],
        },
    },
    "Apollonides Trag.": {
        "tlg_id": "TLG0345",
        "names": {"name_authtab": "Apollonides Trag.", "name_idt": "Apollonides Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Antoninus Liberalis Myth.": {
        "tlg_id": "TLG0651",
        "names": {
            "name_authtab": "Antoninus Liberalis Myth.",
            "name_idt": "Antoninus Liberalis Myth.",
        },
        "works": {"Metamorphoseon synagoge": ["Chapter", "section", "line"]},
    },
    "Ion Phil., Poeta": {
        "tlg_id": "TLG0308",
        "names": {"name_authtab": "Ion Phil. et Poeta", "name_idt": "Ion Phil., Poeta"},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Tituli": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Thrasyllus Hist.": {
        "tlg_id": "TLG2428",
        "names": {"name_authtab": "Thrasyllus Hist.", "name_idt": "Thrasyllus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Simylus Iamb.": {
        "tlg_id": "TLG1676",
        "names": {"name_authtab": "Simylus Iamb.", "name_idt": "Simylus Iamb."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Chariton Scr. Erot.": {
        "tlg_id": "TLG0554",
        "names": {
            "name_authtab": "Chariton Scr. Erot.",
            "name_idt": "Chariton Scr. Erot.",
        },
        "works": {"De Chaerea et Callirhoe": ["Book", "chapter", "section", "line"]},
    },
    "Boïdas Phil.": {
        "tlg_id": "TLG2230",
        "names": {"name_authtab": "Boïdas Phil.", "name_idt": "Boïdas Phil."},
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "(H)agias-Dercylus Hist.": {
        "tlg_id": "TLG1387",
        "names": {
            "name_authtab": "(H)agias-Dercylus Hist.",
            "name_idt": "(H)agias-Dercylus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Anonymi Lexeis Rhetoricae": {
        "tlg_id": "TLG3178",
        "names": {
            "name_authtab": "Anonymi Lexeis Rhetoricae",
            "name_idt": "Anonymi Lexeis Rhetoricae",
        },
        "works": {"$*(RHTORIKAI\\ LE/CEIS&": ["Entry", "line"]},
    },
    "Polycritus Hist.": {
        "tlg_id": "TLG2385",
        "names": {"name_authtab": "Polycritus Hist.", "name_idt": "Polycritus Hist."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Ophelio Comic.": {
        "tlg_id": "TLG0485",
        "names": {"name_authtab": "Ophelio Comic.", "name_idt": "Ophelio Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Marcus Aurelius Antoninus Imperator Phil.": {
        "tlg_id": "TLG0562",
        "names": {
            "name_authtab": "Marcus Aurelius Antoninus Imperator Phil.",
            "name_idt": "Marcus Aurelius Antoninus Imperator Phil.",
        },
        "works": {"$*TA\\ EI)S E(AUTO/N&": ["Book", "chapter", "section", "line"]},
    },
    "Aegimius": {
        "tlg_id": "TLG0668",
        "names": {"name_authtab": "Aegimius", "name_idt": "Aegimius"},
        "works": {"Aegimius (fragmenta)": ["Fragment", "line"]},
    },
    "Fragmentum Lexici Graeci": {
        "tlg_id": "TLG4293",
        "names": {
            "name_authtab": "Fragmentum Lexici Graeci",
            "name_idt": "Fragmentum Lexici Graeci",
        },
        "works": {
            "OLexicon (fragmentum) (fort. auctore Nicephoro Gregora) (e cod. Paris. gr. 3027)": [
                "Entry",
                "line",
            ]
        },
    },
    "Aristagoras Hist.": {
        "tlg_id": "TLG1190",
        "names": {"name_authtab": "Aristagoras Hist.", "name_idt": "Aristagoras Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philo Mech.": {
        "tlg_id": "TLG1599",
        "names": {"name_authtab": "Philo Mech.", "name_idt": "Philo Mech."},
        "works": {
            "Belopoeica": ["Thevenot page", "line"],
            "Parasceuastica et poliorcetica": ["Thevenot page", "line"],
        },
    },
    "Titanomachia": {
        "tlg_id": "TLG1737",
        "names": {"name_authtab": "Titanomachia", "name_idt": "Titanomachia"},
        "works": {"Titanomachia (fragmenta)": ["Fragment", "line"]},
    },
    "Soranus Med.": {
        "tlg_id": "TLG0565",
        "names": {"name_authtab": "Soranus Med.", "name_idt": "Soranus Med."},
        "works": {
            "De signis fracturarum": ["Chapter", "section", "line"],
            "Vita Hippocratis": ["Section", "line"],
            "De fasciis": ["Section", "line"],
            "Gynaeciorum libri iv": ["Book", "chapter", "section", "line"],
        },
    },
    "Anonymi Grammatici Gramm.": {
        "tlg_id": "TLG0072",
        "names": {
            "name_authtab": "Anonymi Grammatici Gramm.",
            "name_idt": "Anonymi Grammatici Gramm.",
        },
        "works": {
            "0Fragmentum grammaticum (P. Iand. 83a [inv. 664])": ["line"],
            "+De participiis (P. Rain. 1.19 [inv. 29772])": ["line"],
            "L$*PERI\\ *AI)OLI/DOS &(?) (fragmentum) (P. Bouriant 8 [P. Sorbonne inv. 833])": [
                "line"
            ],
            "8Fragmentum grammaticum (P. Harr. 59 [inv. 172b %7 182h])": ["line"],
            "LCompendium Herodiani operis$ PERI\\ KLI/SEWS O)NOMA/TWN &(P. Flor. inv. 3005)": [
                "line"
            ],
            "%Fragmentum grammaticum (P. Oslo 2.13)": ["line"],
            "3Fragmentum grammaticum (P. Brooklyn inv. 47.218.36)": ["line"],
            ":Fragmentum grammaticum (P. Heid. Siegmann 197 [inv. 1893])": ["line"],
            ".Fragmentum grammaticum (P. Iand. 1.5 [inv. 2])": ["line"],
            "3Fragmentum grammaticum (PSI sine numero [inv. 505])": ["line"],
            "_Fragmentum grammaticum (P. Lit. Lond. 182 %6 P. Lond. 126) (fort. auctore Tryphone Alexandrino)": [
                "line"
            ],
            "%Supplementa artis Dionysianae vetusta": [
                "Part",
                "volume",
                "page",
                "line",
            ],
            '"Fragmentum grammaticum (PSI 7.849)': ["line"],
            ".Compendium catholicae Herodiani (P. Ant. 2.67)": ["line"],
            "NFragmentum grammaticum (P. Yale 1.25 [inv. 446]) (fort. epitome operis Comani)": [
                "line"
            ],
            "%Fragmentum grammaticum (P. Amh. 2.21)": ["line"],
            ":Fragmentum grammaticum (P. Heid. Siegmann 198 [inv. 201a])": ["line"],
            "1Fragmentum grammaticum (P. Iand. 5.83 [inv. 555])": ["line"],
            "&Fragmentum grammaticum (P. Oxy. 3.469)": ["line"],
            '"Fragmentum grammaticum (PSI 7.761)': ["line"],
            "%Fragmentum grammaticum (P. Ant. 2.68)": ["line"],
            "KCommentarium in anonymi opus$ PERI\\ KLI/SEWS O)NOMA/TWN &(P. Oxy. 15.1801v)": [
                "line"
            ],
        },
    },
    "Zenothemis Geogr.": {
        "tlg_id": "TLG2647",
        "names": {"name_authtab": "Zenothemis Geogr.", "name_idt": "Zenothemis Geogr."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Aristomenes Comic.": {
        "tlg_id": "TLG0419",
        "names": {
            "name_authtab": "Aristomenes Comic.",
            "name_idt": "Aristomenes Comic.",
        },
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Persaeus Phil.": {
        "tlg_id": "TLG1574",
        "names": {"name_authtab": "Persaeus Phil.", "name_idt": "Persaeus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diophilus vel Diophila Poeta": {
        "tlg_id": "TLG2621",
        "names": {
            "name_authtab": "Diophilus vel Diophila Poeta",
            "name_idt": "Diophilus vel Diophila Poeta",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Choeroboscus Gramm.": {
        "tlg_id": "TLG4093",
        "names": {
            "name_authtab": "Georgius Choeroboscus Gramm.",
            "name_idt": "Choeroboscus Gramm.",
        },
        "works": {
            "Epimerismi in Psalmos": ["Page", "line"],
            "-De orthographia (epitome) (e cod. Barocc. 50)": ["Page", "line"],
            "WProlegomena et scholia in Theodosii Alexandrini canones isagogicos de flexione verborum": [
                "Page",
                "line",
            ],
            "De spiritibus (excerpta)": ["Page", "line"],
            "kDe accentibus (excerpta e Choerobosco, Aetherio, Philopono et aliis) (e codd. Urbin. 151 et Laurent. 57.34)": [
                "Excerpt",
                "paragraph",
                "line",
            ],
            "Scholia in Hephaestionem": ["Page", "line"],
            "VProlegomena et scholia in Theodosii Alexandrini canones isagogicos de flexione nominum": [
                "Page",
                "line",
            ],
            '"$*PERI\\ TRO/PWN POIHTIKW=N& [Dub.]': ["Page", "line"],
        },
    },
    "Anonymi In Aristotelis Librum Primum Analyticorum Posteriorum Commentarium": {
        "tlg_id": "TLG4032",
        "names": {
            "name_authtab": "Anonymi In Aristotelis Librum Primum Analyticorum Posteriorum Commentarium",
            "name_idt": "Anonymi In Aristotelis Librum Primum Analyticorum Posteriorum Commentarium",
        },
        "works": {
            "6In primum librum analyticorum posteriorum commentarium": ["Page", "line"]
        },
    },
    "Scriptor Incertus De Leone Armenio Hist.": {
        "tlg_id": "TLG3177",
        "names": {
            "name_authtab": "Scriptor Incertus De Leone Armenio Hist.",
            "name_idt": "Scriptor Incertus De Leone Armenio Hist.",
        },
        "works": {
            "'De Leone Armenio (e cod. Vat. gr. 2014)": ["line"],
            ")De Leone Armenio (e cod. Paris. gr. 1711)": ["Page", "line"],
        },
    },
    "Demareta Poeta": {
        "tlg_id": "TLG2616",
        "names": {"name_authtab": "Demareta Poeta", "name_idt": "Demareta Poeta"},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Didymus Scriptor De Mensuris": {
        "tlg_id": "TLG0357",
        "names": {
            "name_authtab": "Didymus Scriptor De Mensuris",
            "name_idt": "Didymus Scriptor De Mensuris",
        },
        "works": {"Mensurae marmorum ac lignorum": ["Section", "line"]},
    },
    "Anonymus Epicureus Phil.": {
        "tlg_id": "TLG1779",
        "names": {
            "name_authtab": "Anonymus Epicureus Phil.",
            "name_idt": "Anonymus Epicureus Phil.",
        },
        "works": {
            "Fragmenta (P. Herc. 176)": ["Fragment", "line"],
            "'Fragmenta (ad P. Herc. 176 pertinentia)": ["Fragment", "line"],
        },
    },
    "Susarion Comic.": {
        "tlg_id": "TLG0264",
        "names": {"name_authtab": "Susarion Comic.", "name_idt": "Susarion Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Aphthonius Rhet.": {
        "tlg_id": "TLG4100",
        "names": {"name_authtab": "Aphthonius Rhet.", "name_idt": "Aphthonius Rhet."},
        "works": {"Progymnasmata": ["Volume", "page", "line"]},
    },
    "Justinus Martyr Apol.": {
        "tlg_id": "TLG0645",
        "names": {
            "name_authtab": "Justinus Martyr Apol.",
            "name_idt": "Justinus Martyr Apol.",
        },
        "works": {
            "Dialogus cum Tryphone": [
                "Chapter",
                "section",
                "line",
                "¤§\x92\x92\x92§«®\x92³\x92\x8eº¼\x92¾ÀÃÈÌ\x92ÎÑÖ\x8cÜß\x92\x92ú«\x92«««\x8c«\x8e",
                "JC´",
            ],
            "Apologia": ["Chapter", "section", "line"],
            "Fragmenta operum deperditorum": ["Fragment", "line"],
            "Apologia secunda": ["Chapter", "section", "line", "³"],
        },
    },
    "Iamblichus Alchem.": {
        "tlg_id": "TLG2140",
        "names": {
            "name_authtab": "Iamblichus Alchem.",
            "name_idt": "Iamblichus Alchem.",
        },
        "works": {
            "<Fragmenta alchemica (e cod. Paris. B.N. gr. 2327, fol. 266r)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Anthologiae Graecae Appendix": {
        "tlg_id": "TLG7052",
        "names": {
            "name_authtab": "Anthologiae Graecae Appendix",
            "name_idt": "Anthologiae Graecae Appendix",
        },
        "works": {
            ")Epigrammata exhortatoria et supplicatoria": ["Epigram", "line"],
            "Problemata et aenigmata": ["Epigram", "line"],
            "Epigrammata sepulcralia": ["Epigram", "line"],
            "Oracula": ["Epigram", "line"],
            "Epigrammata dedicatoria": ["Epigram", "line"],
            "Epigrammata irrisoria": ["Epigram", "line"],
            "Epigrammatis addenda": ["Epigram", "line"],
            "Epigrammata demonstrativa": ["Epigram", "line"],
        },
    },
    "Anonymus Lexicographus Lexicogr.": {
        "tlg_id": "TLG9003",
        "names": {
            "name_authtab": "Anonymus Lexicographus Lexicogr.",
            "name_idt": "Anonymus Lexicographus Lexicogr.",
        },
        "works": {'"Fragmenta quattuor apud Eustathium': ["Lexical entry", "line"]},
    },
    "Assumptio Mosis": {
        "tlg_id": "TLG1201",
        "names": {"name_authtab": "Assumptio Mosis", "name_idt": "Assumptio Mosis"},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Philogelos": {
        "tlg_id": "TLG2404",
        "names": {"name_authtab": "Philogelos", "name_idt": "Philogelos"},
        "works": {
            "?Philogelos sive Facetiae (sub auctoribus Hierocle et Philagrio)": [
                "Section",
                "line",
            ]
        },
    },
    "Heliodorus Trag.": {
        "tlg_id": "TLG0750",
        "names": {"name_authtab": "Heliodorus Trag.", "name_idt": "Heliodorus Trag."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "$*)ITALIKA\\ QAU/MATA&": ["line"],
        },
    },
    "Matthiae Traditiones": {
        "tlg_id": "TLG1560",
        "names": {
            "name_authtab": "Matthiae Traditiones",
            "name_idt": "Matthiae Traditiones",
        },
        "works": {"Matthiae traditiones": ["Fragment", "line"]},
    },
    "[Aristobulus] Hist.": {
        "tlg_id": "TLG2557",
        "names": {
            "name_authtab": "[Aristobulus] Hist.",
            "name_idt": "[Aristobulus] Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Menodotus Hist.": {
        "tlg_id": "TLG1506",
        "names": {"name_authtab": "Menodotus Hist.", "name_idt": "Menodotus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Acacius Theol.": {
        "tlg_id": "TLG2064",
        "names": {"name_authtab": "Acacius Theol.", "name_idt": "Acacius Theol."},
        "works": {".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"]},
    },
    "Arcadius Gramm.": {
        "tlg_id": "TLG2116",
        "names": {"name_authtab": "Arcadius Gramm.", "name_idt": "Arcadius Gramm."},
        "works": {"De accentibus [Sp.]": ["Page", "line"]},
    },
    "Joannes Gramm., Poeta": {
        "tlg_id": "TLG2578",
        "names": {
            "name_authtab": "Joannes Gramm. et Poeta",
            "name_idt": "Joannes Gramm., Poeta",
        },
        "works": {
            "%$*)/EKFRASIS TOU= KOSMIKOU= PI/NAKOS&": ["Section", "line"],
            "Anacreontea": ["Section", "line"],
        },
    },
    "Leo Hist.": {
        "tlg_id": "TLG2186",
        "names": {"name_authtab": "Leo Hist.", "name_idt": "Leo Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Quintus Epic.": {
        "tlg_id": "TLG2046",
        "names": {"name_authtab": "Quintus Epic.", "name_idt": "Quintus Epic."},
        "works": {"Posthomerica": ["Book", "line"]},
    },
    "Augeas Comic.": {
        "tlg_id": "TLG1782",
        "names": {"name_authtab": "Augeas Comic.", "name_idt": "Augeas Comic."},
        "works": {"Fragmentum": ["Page", "line"], "Tituli": ["Page", "line"]},
    },
    "Acta Philippi": {
        "tlg_id": "TLG2948",
        "names": {"name_authtab": "Acta Philippi", "name_idt": "Acta Philippi"},
        "works": {
            "Acta Philippi": ["Section", "line"],
            "Acta Philippi (epitome)": ["Section", "line"],
            "Acta Philippi (recensio)": ["Section", "line"],
        },
    },
    "Musaeus Epic.": {
        "tlg_id": "TLG0576",
        "names": {"name_authtab": "Musaeus Epic.", "name_idt": "Musaeus Epic."},
        "works": {"Tituli": ["Fragment", "line"]},
    },
    "Niciae Epistula": {
        "tlg_id": "TLG0046",
        "names": {"name_authtab": "Niciae Epistula", "name_idt": "Niciae Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Michael Phil.": {
        "tlg_id": "TLG4034",
        "names": {"name_authtab": "Michael Phil.", "name_idt": "Michael Phil."},
        "works": {
            "6In librum quintum ethicorum Nicomacheorum commentarium": ["Page", "line"],
            "dIn Aristotelis sophisticos elenchos commentarius (selecta) (%6 Pseudo-Alexander 2 %7 commentarium 5)": [
                "Scholion",
                "line",
            ],
            "+In libros de partibus animalium commentaria": ["Page", "line"],
            "+In librum de animalium incessu commentarium": ["Page", "line"],
            "%In ethica Nicomachea ix-x commentaria": ["Page", "line"],
            "qIn Aristotelis sophisticos elenchos commentarius (%6 Pseudo-Alexander 1) (olim sub auctore Alexandro Aphrodisiens": [
                "Page",
                "line",
            ],
            "+In libros de animalium motione commentarium": ["Page", "line"],
            "In parva naturalia commentaria": ["Page", "line"],
        },
    },
    "Theolytus Epic.": {
        "tlg_id": "TLG1723",
        "names": {"name_authtab": "Theolytus Epic.", "name_idt": "Theolytus Epic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Heliodorus Perieg.": {
        "tlg_id": "TLG1400",
        "names": {
            "name_authtab": "Heliodorus Perieg.",
            "name_idt": "Heliodorus Perieg.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heraclides Lembus Hist.": {
        "tlg_id": "TLG1407",
        "names": {
            "name_authtab": "Heraclides Lembus Hist.",
            "name_idt": "Heraclides Lembus Hist.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Excerpta politiarum": ["Section", "line"],
        },
    },
    "Oribasius Med.": {
        "tlg_id": "TLG0722",
        "names": {"name_authtab": "Oribasius Med.", "name_idt": "Oribasius Med."},
        "works": {
            "Libri ad Eunapium (lib. 1-4)": ["Book", "chapter", "section", "line"],
            "Testimonia": ["line", "fragment", "line"],
            ".Collectiones medicae (lib. 1-16, 24-25, 43-50)": [
                "Book",
                "chapter",
                "section",
                "line",
            ],
            "Synopsis ad Eustathium filium": ["Book", "chapter", "section", "line"],
            "Eclogae medicamentorum": ["Chapter", "section", "line"],
            "$Collectiones medicae (libri incerti)": ["Chapter", "section", "line"],
        },
    },
    "Alexander Scr. Eccl.": {
        "tlg_id": "TLG2860",
        "names": {
            "name_authtab": "Alexander Scr. Eccl.",
            "name_idt": "Alexander Scr. Eccl.",
        },
        "works": {
            ".Inventio crucis (fort. auctore Alexandro alio)": ["Page", "line"],
            ")Inventio crucis (epitome prioris libelli)": ["Page", "line"],
            "Laudatio Barnabae apostoli": ["line"],
        },
    },
    "Philiscus Comic.": {
        "tlg_id": "TLG0491",
        "names": {"name_authtab": "Philiscus Comic.", "name_idt": "Philiscus Comic."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
        },
    },
    "Bucolicum": {
        "tlg_id": "TLG1559",
        "names": {"name_authtab": "Bucolicum", "name_idt": "Bucolicum"},
        "works": {
            "4Fragmentum bucolicum: Pan et Echo (P. Vindob. 29801)": [
                "Fragment",
                "line",
            ]
        },
    },
    "Stesimbrotus Hist.": {
        "tlg_id": "TLG1923",
        "names": {
            "name_authtab": "Stesimbrotus Hist.",
            "name_idt": "Stesimbrotus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Pyrgion Hist.": {
        "tlg_id": "TLG1648",
        "names": {"name_authtab": "Pyrgion Hist.", "name_idt": "Pyrgion Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Erinna Lyr.": {
        "tlg_id": "TLG1355",
        "names": {"name_authtab": "Erinna Lyr.", "name_idt": "Erinna Lyr."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta et titulus": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Anonymi Hymnus In Dactylos Idaeos": {
        "tlg_id": "TLG0228",
        "names": {
            "name_authtab": "Anonymi Hymnus In Dactylos Idaeos",
            "name_idt": "Anonymi Hymnus In Dactylos Idaeos",
        },
        "works": {"'Hymnus in Dactylos Idaeos (IG 12.9.259)": ["line"]},
    },
    "Posidippus Epigr.": {
        "tlg_id": "TLG1632",
        "names": {"name_authtab": "Posidippus Epigr.", "name_idt": "Posidippus Epigr."},
        "works": {
            "Fragmenta et tituli": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Myron Hist.": {
        "tlg_id": "TLG1523",
        "names": {"name_authtab": "Myron Hist.", "name_idt": "Myron Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Ephorus Hist.": {
        "tlg_id": "TLG0536",
        "names": {"name_authtab": "Ephorus Hist.", "name_idt": "Ephorus Hist."},
        "works": {
            "Fragmenta": ["FGrH fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Fragmenta Alchemica": {
        "tlg_id": "TLG1379",
        "names": {
            "name_authtab": "Fragmenta Alchemica",
            "name_idt": "Fragmenta Alchemica",
        },
        "works": {
            "R$*LABU/RINQOS H(/NPER *SOLOMW\\N E)TEKTH/NATO& (e cod. Venet. Marc. 299, fol. 102v)": [
                "Volume",
                "page",
                "line",
            ],
            "?$*(/ORKOS TOU= FILOSO/FOU& (e cod. Venet. Marc. 299, fol. 128v)": [
                "Volume",
                "page",
                "line",
            ],
            "=$*POI/HSIS KRUSTALLI/WN& (e cod. Venet. Marc. 299, fol. 116r)": [
                "Volume",
                "page",
                "line",
            ],
            "k$*KATABAFH\\ LI/QWN KAI\\ SMARA/GDWN KAI\\ LIXNITW=N KAI\\ U(AKI/NQWN& (e cod. Paris. B.N. gr. 2327, fol. 147r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*DIA/GRAMMA TH=S MEGA/LHS H(LIOURGI/AS PARABALLO/MENON EI)S TH\\N OI)KONOMI/AN TOU= PANTO/S& (e cod. Venet. Marc.": [
                "Volume",
                "page",
                "line",
            ],
            " Fragmentum alchemicum (P. Flor.)": ["line"],
            "kLexicon alchemicum (%6 $*LECIKO\\N KATA\\ STOIXEI=ON TH=S XRUSOPOII/AS&) (e cod. Venet. Marc. 299, fol. 131r)": [
                "Volume",
                "page",
                "line",
            ],
            "B$*KINNABA/REWS SKEUASI/A& (e cod. Paris. B.N. gr. 2327, fol. 232r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*LEU/KWSIS U(/DATOS, DI' OU(= LEUKAI/NETAI OI)KONOMOU/MENON TO\\ A)RSENIKO\\N KAI\\ H( SANDARA/XH& (e cod. Paris. B": [
                "Volume",
                "page",
                "line",
            ],
            ":$*POI/HSIS A)RGU/ROU& (e cod. Venet. Marc. 299, fol. 194v)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*BAFH\\ TOU= PARA\\ *PE/RSAIS E)CEURHME/NOU XALKOU= GRAFEI=SA A)PO\\ A)RXH=S *FILI/PPOU& (e cod. Venet. Marc. 299, ": [
                "Volume",
                "page",
                "line",
            ],
            "P$*TI/S H( TOU= ME/LANOS CHRI/OU KATASKEUH/& (e cod. Venet. Marc. 299, fol. 128r)": [
                "Volume",
                "page",
                "line",
            ],
            "[$*XRH=SIS *)IOUSTINIANOU= BASILE/WS& (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 240v)": [
                "Volume",
                "page",
                "line",
            ],
            "@$*EU)XH\\ EI)S TO\\ MELI/SSION& (e cod. Venet. Marc. 299, fol. 3r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*)ONOMATOPOII/A TOU= W)OU=: AU)TO\\ GA/R E)STIN TO\\ MUSTH/RION TH=S TE/XNHS& (e cod. Paris. B.N. gr. 2327, fol. 2": [
                "Volume",
                "page",
                "line",
            ],
            ".Tractatus alchemicus (fragmenta) (P. Leid. 10)": ["Fragment", "line"],
            "GFragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 99v)": [
                "Volume",
                "page",
                "line",
            ],
            "@$*)EK TW=N METALLIKW=N& (e cod. Paris. B.N. gr. 2327, fol. 280r)": [
                "Volume",
                "page",
                "line",
            ],
            "=$*PERI\\ BAFH=S SIDH/ROU& (e cod. Venet. Marc. 299, fol. 104r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PERI\\ TOU= METALLIKOU= LIQOU= E)N OI(=S TOI=S TO/POIS E)KEI/NOIS KATASKEUA/ZETAI& (e cod. Paris. B.N. gr. 2327,": [
                "Volume",
                "page",
                "line",
            ],
            "9Dedicatio ad Theodorum (e cod. Venet. Marc. 299, fol. 5v)": [
                "Volume",
                "page",
                "line",
            ],
            "I$*PERI\\ TOU= XRUSW=SAI SI/DHRON& (e cod. Paris. B.N. gr. 2327, fol. 295r)": [
                "Volume",
                "page",
                "line",
            ],
            "`$*PERI\\ TH=S TIMIWTA/THS KAI\\ POLUFH/MOU XRUSOXOI+KH=S& (e cod. Paris. B.N. gr. 2327, fol. 280r)": [
                "Volume",
                "page",
                "line",
            ],
            "K$*(ERMOU= TRISMEGI/STOU O)/RGANON& (e cod. Paris. B.N. gr. 2327, fol. 293r)": [
                "Volume",
                "page",
                "line",
            ],
            ":$*POI/HSIS A)SBE/STOU& (e cod. Venet. Marc. 299, fol. 99v)": [
                "Volume",
                "page",
                "line",
            ],
            "V$*(O LI/QOS TH=S FILOSOFI/AS& (fort. auctore Zosimo) (e cod. B.N. gr. 2327, fol. 215v)": [
                "Volume",
                "page",
                "line",
            ],
            "h$*BAFH\\ TOU= I)NDIKOU= SIDH/ROU GRAFEI=SA A)PO\\ A)RXH=S *FILI/PPOU& (e cod. Venet. Marc. 299, fol. 118v)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*SKEUASI/A A)FRONI/TROU TOU= ZHTOUME/NOU EI)S TA\\S KOLLH/SEIS XRUSOU= KAI\\ A)RGU/ROU KAI\\ XALKOU=& (e cod. Paris": [
                "Volume",
                "page",
                "line",
            ],
            "C$*PERI\\ TOU= O)REIXA/LKOU& (e cod. Paris. B.N. gr. 2329, fol. 184v)": [
                "Volume",
                "page",
                "line",
            ],
            "D$*POI/HSIS MA=LLON TOU= PANTO/S& (e cod. Venet. Marc. 299, fol. 97r)": [
                "Volume",
                "page",
                "line",
            ],
            "D$*PERI\\ POIH/SEWS KINNABA/REWS& (e cod. Venet. Marc. 299, fol. 106r)": [
                "Volume",
                "page",
                "line",
            ],
            "%Fragmentum alchemicum (P. Oxy. 3.467)": ["line"],
            "K$*PERI\\ SUNA/CEWS TW=N FILOSO/FWN& (e cod. Paris. B.N. gr. 2327, fol. 233r)": [
                "Volume",
                "page",
                "line",
            ],
            "B$*SUMPE/RASMA TH=S POIH/SEWS& (e cod. Venet. Marc. 299, fol. 101r)": [
                "Volume",
                "page",
                "line",
            ],
            "0Fragmentum alchemicum (P. Iand. 3.85 [inv. 212])": ["line"],
            "b$*PERI\\ TH=S QEI/AS KAI\\ I(ERA=S TE/XNHS TW=N FILOSO/FWN& (e cod. Paris. B.N. gr. 2327, fol. 230r)": [
                "Volume",
                "page",
                "line",
            ],
            "I$*PERI\\ TOU= POIH=SAI TURO/KOLLAN& (e cod. Paris. B.N. gr. 2327, fol. 7r)": [
                "Volume",
                "page",
                "line",
            ],
            ">$*PERI\\ ZU/QWN POIH/SEWS& (e cod. Venet. Marc. 299, fol. 162r)": [
                "Volume",
                "page",
                "line",
            ],
            "HFragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 100v)": [
                "Volume",
                "page",
                "line",
            ],
            "[$*PERI\\ LEUKW/SEWS TOU= A)RSENIKOU= TOU= SXISTOU=& (e cod. Paris. B.N. gr. 2327, fol. 279v)": [
                "Volume",
                "page",
                "line",
            ],
            "9$*STA/KTHS POI/HSIS& (e cod. Venet. Marc. 299, fol. 162v)": [
                "Volume",
                "page",
                "line",
            ],
            "H$*TI/S H( TH=S KOMA/REWS SU/NQESIS& (e cod. Venet. Marc. 299, fol. 128r)": [
                "Volume",
                "page",
                "line",
            ],
            "HFragmentum alchemicum (sine titulo) (e cod. Venet. Marc. 299, fol. 100r)": [
                "Volume",
                "page",
                "line",
            ],
            "F$*PERI\\ TOU= LI/QOU TW=N FILOSO/FWN& (e cod. B.N. gr. 2327, fol. 216r)": [
                "Volume",
                "page",
                "line",
            ],
            "i$*POI=ON EI)=NAI XRH\\ TOI=S H)/QESI TO\\N METIO/NTA TH\\N E)PISTH/MHN& (e cod. Venet. Marc. 299, fol. 128r)": [
                "Volume",
                "page",
                "line",
            ],
            "<$*XRUSOU= POI/HSIS& (e cod. Paris. B.N. gr. 2327, fol. 232r)": [
                "Volume",
                "page",
                "line",
            ],
            "-$*(H A)GWGH/& (e cod. Venet. Marc. 299, 101r)": [
                "Volume",
                "page",
                "line",
            ],
            "@$*PERI\\ POIH/SEWS A)SH/MOU& (e cod. Venet. Marc. 299, fol. 106r)": [
                "Volume",
                "page",
                "line",
            ],
            "H$*PERI\\ TOU= QEI/OU A)KAU/STOU& (e cod. Paris. B.N. gr. 2327, fol. 279r)": [
                "Volume",
                "page",
                "line",
            ],
            "N$*PERI\\ TOU= POIH=SAI O)CUGGOSA/POUNON& (e cod. Paris. B.N. gr. 2327, fol. 7v)": [
                "Volume",
                "page",
                "line",
            ],
            "V$*)ONO/MATA TW=N XRUSOPOIHTW=N& (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 195v)": [
                "Volume",
                "page",
                "line",
            ],
            "n$*(/OTI SU/NQETON KAI\\ OU)X A(PLOU=N TO\\ EI)=DOS KAI\\ TI/S H( OI)KONOMI/A& (e cod. Venet. Marc. 299, fol. 96r)": [
                "Volume",
                "page",
                "line",
            ],
            "+Tractatus alchemicus (fragmenta) (P. Holm.)": ["Fragment", "line"],
            "qDe quattuor elementis (tractatus qui incipit a vocibus $A)RXH\\ TH=S KATA\\ PLA/TOS TOU= E)/RGOU E)CHGH/SEWS&) (e c": [
                "Volume",
                "page",
                "line",
            ],
            "q$*EI) QE/LEIS POIH=SAI FOU/RMAS KAI\\ TU/LOUS A)PO\\ BRONTHSI/OU, POI/EI OU(/TWS& (e cod. Venet. Marc. 299, fol. 12": [
                "Volume",
                "page",
                "line",
            ],
            "H$*TI/S H( TW=N A)RXAI/WN A)/SBESTOS& (e cod. Venet. Marc. 299, fol. 99r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*PO/SOS O( TW=N BAPTOME/NWN E)RI/WN STAQMO\\S W)/FEILEN KAI\\ PO/SOS O( TH=S KOMA/REWS KAI\\ PO/SOS O( TW=N BEBAMME": [
                "Volume",
                "page",
                "line",
            ],
            "qDe margaritis (collectio excerptorum quae incipit a vocibus $*SMH=CIS KAI\\ LA/MPRUNSIS MARGA/RWN H(=| POLLA/KIS O": [
                "Volume",
                "page",
                "line",
            ],
            "5$*(H OI)KONOMI/A& (e cod. Venet. Marc. 299, fol. 98v)": [
                "Volume",
                "page",
                "line",
            ],
            "[$*(O OU)ROBO/ROS DRA/KWN& (versio 2) (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 279r)": [
                "Volume",
                "page",
                "line",
            ],
            "S$*PERI\\ TOU= W)OU= OI( PALAIOI/ FASIN OU(/TWS& (e cod. Venet. Marc. 299, fol. 106v)": [
                "Volume",
                "page",
                "line",
            ],
            '"Fragmentum alchemicum (P. Leid. 5)': ["line"],
            "N$*TI/S H( META\\ TH\\N I)/WSIN OI)KONOMI/A& (e cod. Venet. Marc. 299, fol. 128r)": [
                "Volume",
                "page",
                "line",
            ],
            "B$*OI)KONOMI/A TH=S A)SBE/STOU& (e cod. Venet. Marc. 299, fol. 99v)": [
                "Volume",
                "page",
                "line",
            ],
            "LExcerptum de mensibus (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 240v)": [
                "Volume",
                "page",
                "line",
            ],
            "N$*DIAFORAI\\ MOLI/BDOU KAI\\ XRUSOPETA/LOU& (e cod. Venet. Marc. 299, fol. 130r)": [
                "Volume",
                "page",
                "line",
            ],
            "[$*(O OU)ROBO/ROS DRA/KWN& (versio 1) (sine titulo) (e cod. Paris. B.N. gr. 2327, fol. 196r)": [
                "Volume",
                "page",
                "line",
            ],
            "[Fragmentum $PERI\\ LEUKW/SEWS& ($XALKOU=&) (sine titulo) (e cod. Paris. gr. 2327, fol. 231v)": [
                "Volume",
                "page",
                "line",
            ],
            "3$*(H POI/HSIS& (e cod. Venet. Marc. 299, fol. 100v)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Socratis Epistulae": {
        "tlg_id": "TLG0636",
        "names": {
            "name_authtab": "Socratis Epistulae",
            "name_idt": "Socratis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Pherecydes Hist.": {
        "tlg_id": "TLG1584",
        "names": {"name_authtab": "Pherecydes Hist.", "name_idt": "Pherecydes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Barnabae Epistula": {
        "tlg_id": "TLG1216",
        "names": {"name_authtab": "Barnabae Epistula", "name_idt": "Barnabae Epistula"},
        "works": {"": ["Barnabae epistula", "Chapter", "section", "line"]},
    },
    "Theodorus Heracleensis vel Theodorus Mopsuestenus Scr. Eccl.": {
        "tlg_id": "TLG2967",
        "names": {
            "name_authtab": "Theodorus Heracleensis vel Theodorus Mopsuestenus Scr. Eccl.",
            "name_idt": "Theodorus Heracleensis vel Theodorus Mopsuestenus Scr. Eccl.",
        },
        "works": {"#Fragmenta in Matthaeum (in catenis)": ["Fragment", "line"]},
    },
    "Andron Geogr.": {
        "tlg_id": "TLG2536",
        "names": {"name_authtab": "Andron Geogr.", "name_idt": "Andron Geogr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aristophanes Gramm.": {
        "tlg_id": "TLG0644",
        "names": {
            "name_authtab": "Aristophanes Gramm.",
            "name_idt": "Aristophanes Gramm.",
        },
        "works": {
            "%Ceteri Aristophanis libri (fragmenta)": ["Treatise", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "3Argumenta fabularum Aristophani tributa (fragmenta)": [
                "Fragment",
                "line",
            ],
            "Nomina aetatum (fragmenta)": ["Page", "line"],
            "Paroemiae (fragmenta)": ["Fragment", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "%Nomina aetatum (fragmentum Parisinum)": ["Section", "line"],
            "WAristophanis historiae animalium epitome subjunctis Aeliani Timothei aliorumque eclogis": [
                "Chapter",
                "section",
                "line",
            ],
            ",De suspectis apud veteres verbis (fragmenta)": ["Page", "line"],
            "-Commentaria in Callimachi pinaces (fragmenta)": ["Fragment", "line"],
        },
    },
    "Cyrus Rhet.": {
        "tlg_id": "TLG4242",
        "names": {"name_authtab": "Cyrus Rhet.", "name_idt": "Cyrus Rhet."},
        "works": {"$*PERI\\ DIAFORA=S STA/SEWS&": ["Section", "line"]},
    },
    "Etymologicum Magnum": {
        "tlg_id": "TLG4099",
        "names": {
            "name_authtab": "Etymologicum Magnum",
            "name_idt": "Etymologicum Magnum",
        },
        "works": {"Etymologicum magnum": ["\x0fKallierges page", "line"]},
    },
    "Nicolaus Rhet., Soph.": {
        "tlg_id": "TLG2904",
        "names": {
            "name_authtab": "Nicolaus Rhet. et Soph.",
            "name_idt": "Nicolaus Rhet., Soph.",
        },
        "works": {
            "qProgymnasmata (capita $PERI\\ SUGKRI/SEWS, PERI\\ H)QOPOII/AS, PERI\\ E)KFRA/SEWS, PERI\\ QE/SEWS, PERI\\ NO/MOU EI)SF": [
                "Page",
                "line",
            ],
            "Progymnasmata": ["Page", "line"],
            "JProgymnasmata (caput $PERI\\ SUGKRI/SEWS&) (e cod. Brit. Mus. addit. 11889)": [
                "Page",
                "line",
            ],
        },
    },
    "Ptolemaeus Hist.": {
        "tlg_id": "TLG1646",
        "names": {"name_authtab": "Ptolemaeus Hist.", "name_idt": "Ptolemaeus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Aristoxenus Comic.": {
        "tlg_id": "TLG0241",
        "names": {
            "name_authtab": "Aristoxenus Comic.",
            "name_idt": "Aristoxenus Comic.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Isidorus Trag.": {
        "tlg_id": "TLG0352",
        "names": {"name_authtab": "Isidorus Trag.", "name_idt": "Isidorus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heraclides Comic.": {
        "tlg_id": "TLG0466",
        "names": {"name_authtab": "Heraclides Comic.", "name_idt": "Heraclides Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Nymphodorus Hist.": {
        "tlg_id": "TLG0578",
        "names": {"name_authtab": "Nymphodorus Hist.", "name_idt": "Nymphodorus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Antiphon Trag.": {
        "tlg_id": "TLG0323",
        "names": {"name_authtab": "Antiphon Trag.", "name_idt": "Antiphon Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Physiologus": {
        "tlg_id": "TLG2654",
        "names": {"name_authtab": "Physiologus", "name_idt": "Physiologus"},
        "works": {"Physiologus (redactio prima)": ["Section", "line"]},
    },
    "Sannyrion Comic.": {
        "tlg_id": "TLG0501",
        "names": {"name_authtab": "Sannyrion Comic.", "name_idt": "Sannyrion Comic."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Timolaus Hist.": {
        "tlg_id": "TLG2533",
        "names": {"name_authtab": "Timolaus Hist.", "name_idt": "Timolaus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Plato Comic.": {
        "tlg_id": "TLG0497",
        "names": {"name_authtab": "Plato Comic.", "name_idt": "Plato Comic."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Fragmentum": ["Fragment", "line"],
        },
    },
    "Menandri Et Philistionis Sententiae": {
        "tlg_id": "TLG1791",
        "names": {
            "name_authtab": "Menandri Et Philistionis Sententiae",
            "name_idt": "Menandri Et Philistionis Sententiae",
        },
        "works": {
            "#Sententiae Menandri et Philistionis": ["Sententia", "section", "line"],
            "#Comparatio Menandri et Philistionis": ["Section", "line"],
        },
    },
    "Simonides Lyr.": {
        "tlg_id": "TLG0261",
        "names": {"name_authtab": "Simonides Lyr.", "name_idt": "Simonides Lyr."},
        "works": {
            "": ["Simonides& Lyr. !!! AUTHOR NAME"],
            "Fragmenta": ["line", "fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
            "Testimonium": ["line", "fragment", "line"],
        },
    },
    "Anacreon Junior Eleg.": {
        "tlg_id": "TLG0217",
        "names": {
            "name_authtab": "Anacreon Junior Eleg.",
            "name_idt": "Anacreon Junior Eleg.",
        },
        "works": {"Fragmentum": ["line"]},
    },
    "Theotimus Hist.": {
        "tlg_id": "TLG1727",
        "names": {"name_authtab": "Theotimus Hist.", "name_idt": "Theotimus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Septuaginta": {
        "tlg_id": "TLG0527",
        "names": {"name_authtab": "Septuaginta", "name_idt": "Septuaginta"},
        "works": {
            "*Regnorum iii (Regum i in textu Masoretico)": [
                "Chapter",
                "section",
                "line",
            ],
            "": ["Epistula Jeremiae", "Section", "line"],
            "Ruth": ["Chapter", "section", "line"],
            "Judices (Cod. Alexandrinus)": ["Chapter", "section", "line"],
            "Genesis": ["Chapter", "section", "line"],
            "Numeri": ["Chapter", "section", "line"],
            "Sophonias": ["Chapter", "section", "line"],
            "Judith": ["Chapter", "section", "line"],
            '"Paralipomenon ii sive Chronicon ii': ["Chapter", "section", "line"],
            "Ezechiel": ["Chapter", "section", "line"],
            "Canticum": ["Chapter", "section", "line"],
            "Tobias (Cod. Sinaiticus)": ["Chapter", "section", "line"],
            "Abdias": ["Section", "line"],
            "Machabaeorum ii": ["Chapter", "section", "line"],
            "Josue (Cod. Alexandrinus)": ["Chapter", "section", "line"],
            "Joel": ["Chapter", "section", "line"],
            '"Bel et Draco (Theodotionis versio)': ["Section", "line"],
            "Aggaeus": ["Chapter", "section", "line"],
            "Esther": ["Chapter", "section", "line"],
            "Odae": ["Ode", "section", "line"],
            "Isaias": ["Chapter", "section", "line"],
            "Jeremias": ["Chapter", "section", "line"],
            "Osee": ["Chapter", "section", "line"],
            "Machabaeorum i": ["Chapter", "section", "line"],
            "Jonas": ["Chapter", "section", "line"],
            "Judices (Cod. Vaticanus)": ["Chapter", "section", "line"],
            "Nahum": ["Chapter", "section", "line"],
            "Habacuc": ["Chapter", "section", "line"],
            "Deuteronomium": ["Chapter", "section", "line"],
            "Esdras i (liber apocryphus)": ["Chapter", "section", "line"],
            "Exodus": ["Chapter", "section", "line"],
            "Susanna (Theodotionis versio)": ["Section", "line"],
            " Paralipomenon i sive Chronicon i": ["Chapter", "section", "line"],
            "0Esdras ii (Ezra et Nehemias in textu Masoretico)": [
                "Chapter",
                "section",
                "line",
            ],
            "-Regnorum ii (Samuelis ii in textu Masoretico)": [
                "Chapter",
                "section",
                "line",
            ],
            "*Regnorum iv (Regum ii in textu Masoretico)": [
                "Chapter",
                "section",
                "line",
            ],
            "Amos": ["Chapter", "section", "line"],
            "Threni seu Lamentationes": ["Chapter", "section", "line"],
            "+Josue (Cod. Vaticanus %7 Cod. Alexandrinus)": [
                "Chapter",
                "section",
                "line",
            ],
            "Susanna (translatio Graeca)": ["Section", "line"],
            "Job": ["Chapter", "section", "line"],
            "Zacharias": ["Chapter", "section", "line"],
            "Psalmi": ["Psalm", "section", "line"],
            "Psalmi Salomonis": ["Psalm", "section", "line"],
            "Proverbia": ["Proverb", "section", "line"],
            "+Regnorum i (Samuelis i in textu Masoretico)": [
                "Chapter",
                "section",
                "line",
            ],
            ";Ecclesiasticus sive Siracides (Sapientia Jesu filii Sirach)": [
                "Chapter",
                "section",
                "line",
            ],
            ",Tobias (Cod. Vaticanus %7 Cod. Alexandrinus)": [
                "Chapter",
                "section",
                "line",
            ],
            "Daniel (Theodotionis versio)": ["Chapter", "section", "line"],
            "Leviticus": ["Chapter", "section", "line"],
            " Bel et Draco (translatio Graeca)": ["Section", "line"],
            "Baruch": ["Chapter", "section", "line"],
            "Machabaeorum iv": ["Chapter", "section", "line"],
            "Daniel (translatio Graeca)": ["Chapter", "section", "line"],
            "Malachias": ["Chapter", "section", "line"],
            "Ecclesiastes": ["Chapter", "section", "line"],
            "Michaeas": ["Chapter", "section", "line"],
            "Machabaeorum iii": ["Chapter", "section", "line"],
            "Sapientia Salomonis": ["Chapter", "section", "line"],
        },
    },
    "Callippus Comic.": {
        "tlg_id": "TLG0427",
        "names": {"name_authtab": "Callippus Comic.", "name_idt": "Callippus Comic."},
        "works": {
            "Fragmentum": ["Play", "fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Sosicrates Comic.": {
        "tlg_id": "TLG0503",
        "names": {"name_authtab": "Sosicrates Comic.", "name_idt": "Sosicrates Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Promathidas Hist.": {
        "tlg_id": "TLG2300",
        "names": {"name_authtab": "Promathidas Hist.", "name_idt": "Promathidas Hist."},
        "works": {"Fragmenta": ["Fragment", "line"], "Titulus": ["Fragment", "line"]},
    },
    "Limenius Lyr.": {
        "tlg_id": "TLG0203",
        "names": {"name_authtab": "Limenius Lyr.", "name_idt": "Limenius Lyr."},
        "works": {",Paean Delphicus ii et prosodium in Apollinem": ["line"]},
    },
    "Calani Epistula": {
        "tlg_id": "TLG0040",
        "names": {"name_authtab": "Calani Epistula", "name_idt": "Calani Epistula"},
        "works": {"Epistula": ["line"]},
    },
    "Polycrates Scr. Eccl.": {
        "tlg_id": "TLG1626",
        "names": {
            "name_authtab": "Polycrates Scr. Eccl.",
            "name_idt": "Polycrates Scr. Eccl.",
        },
        "works": {"Fragmentum synodicae epistulae": ["Page", "line"]},
    },
    "Palladius Scr. Eccl.": {
        "tlg_id": "TLG2111",
        "names": {
            "name_authtab": "Palladius Scr. Eccl.",
            "name_idt": "Palladius Scr. Eccl.",
        },
        "works": {
            "Historia Lausiaca (recensio G)": ["Vita", "section", "line"],
            "$Dialogus de vita Joannis Chrysostomi": ["Page", "line"],
            "'De gentibus Indiae et Bragmanibus [Sp.]": ["Chapter", "section", "line"],
            "Epistula ad Lausum": ["Page", "line"],
            "&Prooemium ad historiam Lausiacam [Sp.]": ["Page", "line"],
        },
    },
    "Euphantus Phil.": {
        "tlg_id": "TLG1912",
        "names": {"name_authtab": "Euphantus Phil.", "name_idt": "Euphantus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Prorus Phil.": {
        "tlg_id": "TLG2729",
        "names": {"name_authtab": "Prorus Phil.", "name_idt": "Prorus Phil."},
        "works": {"Titulus": ["Page", "line"]},
    },
    "Menestor Phil.": {
        "tlg_id": "TLG2228",
        "names": {"name_authtab": "Menestor Phil.", "name_idt": "Menestor Phil."},
        "works": {"Testimonia": ["Fragment", "line"]},
    },
    "Tryphon II Gramm.": {
        "tlg_id": "TLG1763",
        "names": {"name_authtab": "Tryphon II Gramm.", "name_idt": "Tryphon II Gramm."},
        "works": {
            "/De tropis (olim sub auctore Gregorio Corinthio)": [
                "Chapter",
                "section",
                "line",
            ]
        },
    },
    "Evangelium Aegyptium": {
        "tlg_id": "TLG1364",
        "names": {
            "name_authtab": "Evangelium Aegyptium",
            "name_idt": "Evangelium Aegyptium",
        },
        "works": {"Evangelium Aegyptium": ["Fragment", "line"]},
    },
    "Martyrium Carpi, Papyli Et Agathonicae": {
        "tlg_id": "TLG0390",
        "names": {
            "name_authtab": "Martyrium Carpi, Papyli Et Agathonicae",
            "name_idt": "Martyrium Carpi, Papyli Et Agathonicae",
        },
        "works": {
            "0Martyrium sanctorum Carpi, Papyli et Agathonicae": ["Section", "line"]
        },
    },
    "Manasses Hist., Poeta": {
        "tlg_id": "TLG3074",
        "names": {
            "name_authtab": "Constantinus Manasses Hist. et Poeta",
            "name_idt": "Manasses Hist., Poeta",
        },
        "works": {"Vita Oppiani": ["line"], "Compendium chronicum": ["line"]},
    },
    "Theocles Lyr.": {
        "tlg_id": "TLG0206",
        "names": {"name_authtab": "Theocles Lyr.", "name_idt": "Theocles Lyr."},
        "works": {"Ithyphalli": ["line"]},
    },
    "Theodectas Trag.": {
        "tlg_id": "TLG0329",
        "names": {"name_authtab": "Theodectas Trag.", "name_idt": "Theodectas Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Arrianus Epic.": {
        "tlg_id": "TLG2650",
        "names": {"name_authtab": "Arrianus Epic.", "name_idt": "Arrianus Epic."},
        "works": {"Fragmentum et tituli": ["Fragment", "line"]},
    },
    "Scholia In Homerum": {
        "tlg_id": "TLG5026",
        "names": {
            "name_authtab": "Scholia In Homerum",
            "name_idt": "Scholia In Homerum",
        },
        "works": {
            "IScholia in Iliadem (scholia vetera et recentiora e cod. Genevensi gr. 44)": [
                "Book of Iliad",
                "verse",
                "line",
            ],
            "#Scholia in Iliadem (scholia vetera)": ["Book of Iliad", "verse", "line"],
            "'Inscriptiones et hypothesis in Odysseam": [
                "\x16Inscription-hypothesis",
                "line",
            ],
            "WScholia in Iliadem (scholia recentiora Theodori Meliteniotis) (e cod. Genevensi gr. 44)": [
                "Book of Iliad",
                "verse",
                "line",
            ],
            "$Hypotheses in Iliadem (e D scholiis)": [
                "Book of Iliad",
                "hypothesis",
                "line",
            ],
            "2Scholia in Iliadem (scholia vetera) (%6 D scholia)": [
                "Book of Iliad",
                "verse",
                "line",
            ],
            ",Scholia in Odysseam 1.1-309 (scholia vetera)": [
                "\x1bHypothesis-verse of Odyssey",
                "line",
            ],
            "$Scholia in Odysseam (scholia vetera)": [
                "Book",
                "\x10hypothesis-verse",
                "line",
            ],
        },
    },
    "Martyrium Pionii": {
        "tlg_id": "TLG2005",
        "names": {"name_authtab": "Martyrium Pionii", "name_idt": "Martyrium Pionii"},
        "works": {
            "'Martyrium Pionii presbyteri et sodalium": ["Chapter", "section", "line"]
        },
    },
    "Homerus Epic.": {
        "tlg_id": "TLG0012",
        "names": {"name_authtab": "Homerus Epic., Homer", "name_idt": "Homerus Epic."},
        "works": {
            "Ilias": [
                "Book",
                "line",
                "¶ÃÐ\x17³\x1b®¼Ì\x1f\x8e#´ÂÉ(®Ã,÷\x92¼Ð2ú×5Ðþ;>\x92ºÊêDîþ\x8e®¾Jêù\x8cùOÇÖS©ºV¼Ê÷Zíü\x8c^Òbû§¶hÌ¤",
                "\x17\x1b\x1f#(,25;>DJOSVZ^bhn",
            ],
            "Odyssea": ["Book", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Marcellus Hist.": {
        "tlg_id": "TLG2458",
        "names": {"name_authtab": "Marcellus Hist.", "name_idt": "Marcellus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Orus Gramm.": {
        "tlg_id": "TLG2995",
        "names": {"name_authtab": "Orus Gramm.", "name_idt": "Orus Gramm."},
        "works": {
            "qOrthographia ($PERI\\ TH=S <I> A)NEKFWNH/TOU&) (olim sub titulo Lexicon Messanense) (fragmenta e cod. S. Salvatore": [
                "Folio r %9 v",
                "line",
            ],
            "9Vocum Atticarum collectio (fragmenta ap. Zonarae lexicon)": [
                "Fragment",
                "line",
            ],
            "QVocum Atticarum collectio (fragmenta ap. alios auctores et in aliis Ori scriptis)": [
                "Fragment",
                "line",
            ],
        },
    },
    "Paulus Med.": {
        "tlg_id": "TLG0715",
        "names": {"name_authtab": "Paulus Med.", "name_idt": "Paulus Med."},
        "works": {
            "Epitomae medicae libri septem": ["Book", "chapter", "section", "line"]
        },
    },
    "Epigenes Comic.": {
        "tlg_id": "TLG0452",
        "names": {"name_authtab": "Epigenes Comic.", "name_idt": "Epigenes Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Himerius Soph.": {
        "tlg_id": "TLG2051",
        "names": {"name_authtab": "Himerius Soph.", "name_idt": "Himerius Soph."},
        "works": {
            "Declamationes et orationes": ["Oration", "line"],
            "Fragmenta (P. Oslo inv. 1478)": ["Fragment", "line"],
            "!Fragmenta ex incertis orationibus": ["Fragment", "line"],
        },
    },
    "Dionysius II Eleg.": {
        "tlg_id": "TLG0247",
        "names": {
            "name_authtab": "Dionysius II Eleg.",
            "name_idt": "Dionysius II Eleg.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Nicetas Choniates Hist., Scr. Eccl., Rhet.": {
        "tlg_id": "TLG3094",
        "names": {
            "name_authtab": "Nicetas Choniates Hist., Scr. Eccl. et Rhet.",
            "name_idt": "Nicetas Choniates Hist., Scr. Eccl., Rhet.",
        },
        "works": {"#Historia (%6$ *XRONIKH\\ DIH/GHSIS&)": ["Reign", "page", "line"]},
    },
    "Herodas Mimogr.": {
        "tlg_id": "TLG0650",
        "names": {"name_authtab": "Herodas Mimogr.", "name_idt": "Herodas Mimogr."},
        "works": {"Mimiambi": ["Mime", "line"]},
    },
    "Sophronius Gramm.": {
        "tlg_id": "TLG4149",
        "names": {"name_authtab": "Sophronius Gramm.", "name_idt": "Sophronius Gramm."},
        "works": {
            "JExcerpta ex Joannis Characis commentariis in Theodosii Alexandrini canones": [
                "Page",
                "line",
            ]
        },
    },
    "Procopius Hist.": {
        "tlg_id": "TLG4029",
        "names": {"name_authtab": "Procopius Hist.", "name_idt": "Procopius Hist."},
        "works": {
            "De aedificiis (lib. 1-6)": ["Book", "chapter", "section", "line"],
            "De bellis": ["Book", "chapter", "section", "line"],
            "Historia arcana (%6 Anecdota)": ["Chapter", "section", "line"],
        },
    },
    "Pancrates Epigr.": {
        "tlg_id": "TLG1556",
        "names": {"name_authtab": "Pancrates Epigr.", "name_idt": "Pancrates Epigr."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Menander Hist.": {
        "tlg_id": "TLG1498",
        "names": {"name_authtab": "Menander Hist.", "name_idt": "Menander Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Bion Bucol.": {
        "tlg_id": "TLG0036",
        "names": {"name_authtab": "Bion Bucol.", "name_idt": "Bion Bucol."},
        "works": {
            "": ["Epitaphius Adonis", "line"],
            ")Epithalamium Achillis et Deidameiae [Sp.]": ["line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Epigoni": {
        "tlg_id": "TLG1351",
        "names": {"name_authtab": "Epigoni", "name_idt": "Epigoni"},
        "works": {"Epigoni (fragmenta)": ["Fragment", "line"]},
    },
    "Athanis Hist.": {
        "tlg_id": "TLG2387",
        "names": {"name_authtab": "Athanis Hist.", "name_idt": "Athanis Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hermesianax Eleg.": {
        "tlg_id": "TLG0213",
        "names": {"name_authtab": "Hermesianax Eleg.", "name_idt": "Hermesianax Eleg."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Chrysippus Phil.": {
        "tlg_id": "TLG1264",
        "names": {"name_authtab": "Chrysippus Phil.", "name_idt": "Chrysippus Phil."},
        "works": {
            "": ["Fragmenta poetica", "Fragment", "line"],
            ">Fragmenta quae ad explicationem carminum Homericorum pertinent": [
                "Fragment",
                "line",
            ],
            "#Fragmenta ad singulos libros relata": ["Treatise", "fragment", "line"],
            "Fragmentum (P. Ant. 2.61)": ["line"],
            "Fragmenta logica et physica": ["Fragment", "line"],
        },
    },
    "Alcaeus Lyr.": {
        "tlg_id": "TLG0383",
        "names": {"name_authtab": "Alcaeus Lyr.", "name_idt": "Alcaeus Lyr."},
        "works": {
            "Fragmentis addenda": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Discipulorum Cantiuncula": {
        "tlg_id": "TLG0279",
        "names": {
            "name_authtab": "Discipulorum Cantiuncula",
            "name_idt": "Discipulorum Cantiuncula",
        },
        "works": {"Fragmentum (P. Med.)": ["line"]},
    },
    "Hermias Poeta": {
        "tlg_id": "TLG2624",
        "names": {"name_authtab": "Hermias Poeta", "name_idt": "Hermias Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Protagoras Soph.": {
        "tlg_id": "TLG1635",
        "names": {"name_authtab": "Protagoras Soph.", "name_idt": "Protagoras Soph."},
        "works": {
            "Fragmentum": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Theopompus Hist.": {
        "tlg_id": "TLG0566",
        "names": {"name_authtab": "Theopompus Hist.", "name_idt": "Theopompus Hist."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Fragmentum (P. Colon. 5861)": ["FGrH fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Apollonius Dyscolus Gramm.": {
        "tlg_id": "TLG0082",
        "names": {
            "name_authtab": "Apollonius Dyscolus Gramm.",
            "name_idt": "Apollonius Dyscolus Gramm.",
        },
        "works": {
            "De constructione": ["Part", "volume", "page", "line"],
            "De pronominibus": ["Part", "\x0fvolume+fascicle", "page", "line"],
            "De adverbiis": ["Part", "\x0fvolume+fascicle", "page", "line"],
            "De conjunctionibus": ["Part", "\x0fvolume+fascicle", "page", "line"],
        },
    },
    "Batrachomyomachia": {
        "tlg_id": "TLG1220",
        "names": {"name_authtab": "Batrachomyomachia", "name_idt": "Batrachomyomachia"},
        "works": {
            "": ["Batrachomyomachia", "line"],
            "&Batrachomyomachia (prosodia Byzantina)": ["line"],
        },
    },
    "Xuthus Phil.": {
        "tlg_id": "TLG2229",
        "names": {"name_authtab": "Xuthus Phil.", "name_idt": "Xuthus Phil."},
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "Damastes Hist.": {
        "tlg_id": "TLG1868",
        "names": {"name_authtab": "Damastes Hist.", "name_idt": "Damastes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Synesius Phil.": {
        "tlg_id": "TLG2006",
        "names": {"name_authtab": "Synesius Phil.", "name_idt": "Synesius Phil."},
        "works": {
            "": ["Calvitii encomium", "Section", "line"],
            "Dion": ["Section", "line"],
            "Aegyptii sive de providentia": ["Chapter", "section", "line"],
            "De insomniis": ["Section", "line"],
            "Oratio de regno": ["Section", "line"],
            "Hymni": ["Hymn", "line"],
            "Catastases": ["Oration", "section", "line"],
            "Epistulae": ["Epistle", "line"],
            "Ad Paeonium de dono astrolabii": ["Section", "line"],
            "Homiliae": ["Homily", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Hegemon Epic.": {
        "tlg_id": "TLG1391",
        "names": {"name_authtab": "Hegemon Epic.", "name_idt": "Hegemon Epic."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Testimonium": ["line", "fragment", "line"],
            "Fragmentum": ["line", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Aristonymus Comic.": {
        "tlg_id": "TLG0420",
        "names": {
            "name_authtab": "Aristonymus Comic.",
            "name_idt": "Aristonymus Comic.",
        },
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Anaxandridas Hist.": {
        "tlg_id": "TLG2284",
        "names": {
            "name_authtab": "Anaxandridas Hist.",
            "name_idt": "Anaxandridas Hist.",
        },
        "works": {"Fragmenta": ["Fragment", " line"]},
    },
    "Archedemus Phil.": {
        "tlg_id": "TLG1173",
        "names": {"name_authtab": "Archedemus Phil.", "name_idt": "Archedemus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sappho et Alcaeus Lyr.": {
        "tlg_id": "TLG1815",
        "names": {
            "name_authtab": "Sappho et Alcaeus Lyr.",
            "name_idt": "Sappho et Alcaeus Lyr.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Onatas Phil.": {
        "tlg_id": "TLG1549",
        "names": {"name_authtab": "Onatas Phil.", "name_idt": "Onatas Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Irenaeus Theol.": {
        "tlg_id": "TLG1447",
        "names": {"name_authtab": "Irenaeus Theol.", "name_idt": "Irenaeus Theol."},
        "works": {
            "Adversus haereses (liber 3)": ["Section", "line"],
            "Adversus haereses (liber 4)": ["Fragment", "line"],
            '"Adversus haereses 5.3-13 (P. Jena)': ["Fragment", "section", "line"],
            "%Adversus haereses 3.9 (P. Oxy. 3.405)": ["Section", "line"],
            "Adversus haereses (libri 1-2)": ["Book", "chapter", "section", "line"],
            "Fragmenta deperditorum operum": ["Fragment", "line"],
            "Adversus haereses (liber 5)": ["Fragment", "line"],
        },
    },
    "Evangelium Mariae": {
        "tlg_id": "TLG1369",
        "names": {"name_authtab": "Evangelium Mariae", "name_idt": "Evangelium Mariae"},
        "works": {"": ["Evangelium Mariae", "Section", "line"]},
    },
    "Diphilus Comic.": {
        "tlg_id": "TLG0447",
        "names": {"name_authtab": "Diphilus Comic.", "name_idt": "Diphilus Comic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Euenus Eleg.": {
        "tlg_id": "TLG0251",
        "names": {"name_authtab": "Euenus Eleg.", "name_idt": "Euenus Eleg."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scholia In Apollonium Rhodium": {
        "tlg_id": "TLG5012",
        "names": {
            "name_authtab": "Scholia In Apollonium Rhodium",
            "name_idt": "Scholia In Apollonium Rhodium",
        },
        "works": {
            "8Scholia in Apollonii Rhodii Argonautica (scholia vetera)": [
                "Page",
                "line",
            ]
        },
    },
    "Alexander Lyr., Trag.": {
        "tlg_id": "TLG0216",
        "names": {
            "name_authtab": "Alexander Lyr. et Trag.",
            "name_idt": "Alexander Lyr., Trag.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Triphiodorus Epic., Gramm.": {
        "tlg_id": "TLG0647",
        "names": {
            "name_authtab": "Triphiodorus Epic. et Gramm.",
            "name_idt": "Triphiodorus Epic., Gramm.",
        },
        "works": {"$*(/ALWSIS *)ILI/OU&": ["line"]},
    },
    "Socrates Hist.": {
        "tlg_id": "TLG1678",
        "names": {"name_authtab": "Socrates Hist.", "name_idt": "Socrates Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Menecrates Hist.": {
        "tlg_id": "TLG4344",
        "names": {"name_authtab": "Menecrates Hist.", "name_idt": "Menecrates Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Eriphus Comic.": {
        "tlg_id": "TLG0455",
        "names": {"name_authtab": "Eriphus Comic.", "name_idt": "Eriphus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Aelius Dius Hist.": {
        "tlg_id": "TLG2434",
        "names": {"name_authtab": "Aelius Dius Hist.", "name_idt": "Aelius Dius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Acta Alexandrinorum": {
        "tlg_id": "TLG0300",
        "names": {
            "name_authtab": "Acta Alexandrinorum",
            "name_idt": "Acta Alexandrinorum",
        },
        "works": {"Acta Alexandrinorum": ["Chapter", "column or fragment", "line"]},
    },
    "Xeno Comic.": {
        "tlg_id": "TLG0519",
        "names": {"name_authtab": "Xeno Comic.", "name_idt": "Xeno Comic."},
        "works": {"Fragmentum": ["Play", "fragment", "line"]},
    },
    "Sostratus Gramm.": {
        "tlg_id": "TLG1688",
        "names": {"name_authtab": "Sostratus Gramm.", "name_idt": "Sostratus Gramm."},
        "works": {
            "Fragmenta": ["line", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Menelaus Epic.": {
        "tlg_id": "TLG1504",
        "names": {"name_authtab": "Menelaus Epic.", "name_idt": "Menelaus Epic."},
        "works": {"Fragmenta et titulus": ["Fragment", "line"]},
    },
    "Conon Hist.": {
        "tlg_id": "TLG1285",
        "names": {"name_authtab": "Conon Hist.", "name_idt": "Conon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Priscianus Phil.": {
        "tlg_id": "TLG4014",
        "names": {"name_authtab": "Priscianus Phil.", "name_idt": "Priscianus Phil."},
        "works": {"Metaphrasis in Theophrastum": ["Page", "line"]},
    },
    "Philostratus Major Soph.": {
        "tlg_id": "TLG1600",
        "names": {
            "name_authtab": "Philostratus Major Soph.",
            "name_idt": "Philostratus Major Soph.",
        },
        "works": {"Imagines": ["Book", "chapter", "section", "line"]},
    },
    "Plutarchus": {
        "tlg_id": "TLG0094",
        "names": {"name_authtab": "Pseudo-Plutarchus", "name_idt": "Plutarchus"},
        "works": {
            "De fluviis": ["Chapter", "section", "line"],
            "De musica (1131b-1147a)": ["Stephanus page", "section", "line"],
            "!Placita philosophorum (874d-911c)": ["Stephanus page", "section", "line"],
        },
    },
    "Scamon Hist.": {
        "tlg_id": "TLG2330",
        "names": {"name_authtab": "Scamon Hist.", "name_idt": "Scamon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Polyaenus Rhet.": {
        "tlg_id": "TLG0616",
        "names": {"name_authtab": "Polyaenus Rhet.", "name_idt": "Polyaenus Rhet."},
        "works": {
            "": ["Excerpta Polyaeni", "Excerpt", "section", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "Strategemata": ["Book", "chapter", "section", "line"],
        },
    },
    "Apocalypsis Esdrae": {
        "tlg_id": "TLG1157",
        "names": {
            "name_authtab": "Apocalypsis Esdrae",
            "name_idt": "Apocalypsis Esdrae",
        },
        "works": {
            "Apocalypsis Esdrae": ["Page", "line"],
            "Apocalypsis Esdrae quarta": ["Page", "line"],
        },
    },
    "Polybius Rhet.": {
        "tlg_id": "TLG0605",
        "names": {"name_authtab": "Polybius Rhet.", "name_idt": "Polybius Rhet."},
        "works": {
            "Fragmenta de figuris": ["Page", "line"],
            "De barbarismo et soloecismo": ["Page", "line"],
        },
    },
    "Aristides Rhet.": {
        "tlg_id": "TLG0284",
        "names": {
            "name_authtab": "Aelius Aristides Rhet.",
            "name_idt": "Aristides Rhet.",
        },
        "works": {
            "": ["Fragmenta poetica", "Fragment", "line"],
            "$*MONW|DI/A E)PI\\ *SMU/RNH|&": ["Jebb page", "line"],
            "$*EI)S TO\\ E)NANTI/ON&": ["Jebb page", "line"],
            "$*EI)S *)ETEWNE/A E)PIKH/DEIOS&": ["Jebb page", "line"],
            "5$*PERI\\ TOU= PE/MPEIN BOH/QEIAN TOI=S E)N *SIKELI/A|&": [
                "Jebb page",
                "line",
            ],
            "1$*LEUKTRIKO\\S E# &($U(PE\\R MHDETE/ROIS BOHQEI=N&)": [
                "Jebb page",
                "line",
            ],
            "2$*SUMBOULEUTIKO\\S PERI\\ TOU= MH\\ DEI=N KWMW|DEI=N&": [
                "Jebb page",
                "line",
            ],
            "$*(RODIAKO/S& [Sp.]": ["Jebb page", "line"],
            "<$*SUMMAXIKO\\S B# &($PRO\\S *QHBAI/OUS PERI\\ TH=S SUMMAXI/AS&)": [
                "Jebb page",
                "line",
            ],
            "$*EI)S BASILE/A& [Sp.]": ["Jebb page", "line"],
            "$$*EI)S TO\\ FRE/AR TOU= *)ASKLHPIOU=&": ["Jebb page", "line"],
            "$*EI)S *DI/A&": ["Jebb page", "line"],
            "$*(IEROI\\ LO/GOI G#&": ["Jebb page", "line"],
            "$*)APELLA= GENEQLIAKO/S&": ["Jebb page", "line"],
            "$*PRO\\S *KAPI/TWNA&": ["Jebb page", "line"],
            ".$*LEUKTRIKO\\S B# &($U(PE\\R *QHBAI/WN PRW=TOS&)": ["Jebb page", "line"],
            "%$*PRO\\S *LEPTI/NHN U(PE\\R A)TELEI/AS&": ["Jebb page", "line"],
            "!$*PRESBEUTIKO\\S PRO\\S *)AXILLE/A&": ["Jebb page", "line"],
            "%$*PRO\\S *DHMOSQE/NH PERI\\ A)TELEI/AS&": ["Jebb page", "line"],
            "$*LALIA\\ EI)S *)ASKLHPIO/N&": ["Jebb page", "line"],
            "$*AI)GU/PTIOS&": ["Jebb page", "line"],
            "$*EI)S TO\\N *SA/RAPIN&": ["Jebb page", "line"],
            '"$*PERI\\ O(MONOI/AS TAI=S PO/LESIN&': ["Jebb page", "line"],
            "($*PRO\\S *PLA/TWNA U(PE\\R TW=N TETTA/RWN&": ["Jebb page", "line"],
            "$*(IEROI\\ LO/GOI B#&": ["Jebb page", "line"],
            "$*(IEROI\\ LO/GOI D#&": ["Jebb page", "line"],
            "/$*(UPE\\R TH=S PRO\\S *LAKEDAIMONI/OUS EI)RH/NHS&": ["Jebb page", "line"],
            "6$*LEUKTRIKO\\S G# &($U(PE\\R *LAKEDAIMONI/WN DEU/TEROS&)": [
                "Jebb page",
                "line",
            ],
            "$*)AQHNA=&": ["Jebb page", "line"],
            "$*)ASKLHPIA/DAI&": ["Jebb page", "line"],
            "0$*PRO\\S TOU\\S AI)TIWME/NOUS O(/TI MH\\ MELETW/|H&": [
                "Jebb page",
                "line",
            ],
            "$*PROSFWNHTIKO/S *SMURNAI+KO/S&": ["Jebb page", "line"],
            '"$*)EPI\\ *)ALECA/NDRW| E)PITA/FIOS&': ["Jebb page", "line"],
            "$*SMURNAI+KO\\S POLITIKO/S&": ["Jebb page", "line"],
            ".$*PANHGURIKO\\S E)N *KUZI/KW| PERI\\ TOU= NAOU=&": ["Jebb page", "line"],
            "Ars rhetorica [Sp.]": ["Book", "chapter", "section", "subsection", "line"],
            "$$*PRO\\S *PLA/TWNA PERI\\ R(HTORIKH=S&": ["Jebb page", "line"],
            "$*)ELEUSI/NIOS&": ["Jebb page", "line"],
            "$*)EPISTOLH\\ PERI\\ *SMU/RNHS&": ["Jebb page", "line"],
            "$*KATA\\ TW=N E)CORXOUME/NWN&": ["Jebb page", "line"],
            "$*(IEROI\\ LO/GOI S#&": ["Jebb page", "line"],
            "$*(IEROI\\ LO/GOI A#&": ["Jebb page", "line"],
            "$*(HRAKLH=S&": ["Jebb page", "line"],
            "$*(RW/MHS E)GKW/MION&": ["Jebb page", "line"],
            "$*EI)S TO\\ *AI)GAI=ON PE/LAGOS&": ["Jebb page", "line"],
            "0$*LEUKTRIKO\\S D# &($U(PE\\R *QHBAI/WN DEU/TEROS&)": [
                "Jebb page",
                "line",
            ],
            "$*PERI\\ TOU= PARAFQE/GMATOS&": ["Jebb page", "line"],
            "$*)ISQMIKO\\S EI)S *POSEIDW=NA&": ["Jebb page", "line"],
            "$*(IEROI\\ LO/GOI E#&": ["Jebb page", "line"],
            "4$*LEUKTRIKO\\S A# &($U(PE\\R *LAKEDAIMONI/WN PRW=TOS&)": [
                "Jebb page",
                "line",
            ],
            "=$*PALINW|DI/A E)PI\\ *SMU/RNH| KAI\\ TW=| TAU/THS A)NOIKISMW=|&": [
                "Jebb page",
                "line",
            ],
            "+$*(UPE\\R TH=S PRO\\S *)AQHNAI/OUS EI)RH/NHS&": ["Jebb page", "line"],
            "$*(RODI/OIS PERI\\ O(MONOI/AS&": ["Jebb page", "line"],
            "1$*PANHGURIKO\\S E)PI\\ TW=| U(/DATI E)N *PERGA/MW|&": ["line"],
            "$*DIO/NUSOS&": ["Jebb page", "line"],
        },
    },
    "Archimelus Epigr.": {
        "tlg_id": "TLG0131",
        "names": {"name_authtab": "Archimelus Epigr.", "name_idt": "Archimelus Epigr."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "!Fragmentum de Hieronis II navigio": ["Fragment", "line"],
        },
    },
    "Epictetus Phil.": {
        "tlg_id": "TLG0557",
        "names": {"name_authtab": "Epictetus Phil.", "name_idt": "Epictetus Phil."},
        "works": {
            '"Dissertationes ab Arriano digestae': [
                "Book",
                "chapter",
                "section",
                "line",
                "\x92\x92¤\x92$\x92\x92\x8c\x8eÍ\x92½à§8Âà\x92",
                "$8SH",
            ],
            "Enchiridion": ["Chapter", "section", "line"],
            "NDissertationum Epictetearum sive ab Arriano sive ab aliis digestarum fragmenta": [
                "Fragment",
                "line",
            ],
            "-Gnomologium Epicteteum (e Stobaei libris 1-2)": ["Sententia", "line"],
            "-Gnomologium Epicteteum (e Stobaei libris 3-4)": ["Sententia", "line"],
            '"Arriani epistula ad Lucium Gellium': ["Section", "line"],
        },
    },
    "Aristarchus Trag.": {
        "tlg_id": "TLG0306",
        "names": {"name_authtab": "Aristarchus Trag.", "name_idt": "Aristarchus Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Harpocrationis Epistula": {
        "tlg_id": "TLG0691",
        "names": {
            "name_authtab": "Harpocrationis Epistula",
            "name_idt": "Harpocrationis Epistula",
        },
        "works": {"Epistula": ["Section", "line"]},
    },
    "Hecataeus Hist.": {
        "tlg_id": "TLG0538",
        "names": {"name_authtab": "Hecataeus Hist.", "name_idt": "Hecataeus Hist."},
        "works": {
            "Fragmenta": ["FGrH fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Aresas Phil.": {
        "tlg_id": "TLG1178",
        "names": {"name_authtab": "Aresas Phil.", "name_idt": "Aresas Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Anonymus De Philosophia Platonica Phil.": {
        "tlg_id": "TLG4227",
        "names": {
            "name_authtab": "Anonymus De Philosophia Platonica Phil.",
            "name_idt": "Anonymus De Philosophia Platonica Phil.",
        },
        "works": {
            "VProlegomena philosophiae Platonicae (fort. auctore Elia, olim sub auctore Olympiodoro)": [
                "Section",
                "line",
            ]
        },
    },
    "Anaxarchus Phil.": {
        "tlg_id": "TLG0714",
        "names": {"name_authtab": "Anaxarchus Phil.", "name_idt": "Anaxarchus Phil."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Aristarchus Astron.": {
        "tlg_id": "TLG1181",
        "names": {
            "name_authtab": "Aristarchus Astron.",
            "name_idt": "Aristarchus Astron.",
        },
        "works": {
            ".De magnitudinibus et distantiis solis et lunae": ["Section", "line"]
        },
    },
    "Scholia In Hesiodum": {
        "tlg_id": "TLG5025",
        "names": {
            "name_authtab": "Scholia In Hesiodum",
            "name_idt": "Scholia In Hesiodum",
        },
        "works": {
            "Glossae in theogoniam": ["Verse", "line"],
            "&Scholia in theogoniam (scholia vetera)": ["Verse", "line"],
            "qScholia in opera et dies (scholia vetera partim Procli et recentiora partim Moschopuli, Tzetzae et Joannis Galeni": [
                "Prolegomenon-scholion",
                "page-verse",
                "line",
            ],
            ")Scholia in opera et dies (scholia vetera)": [
                "Prolegomenon-scholion",
                "section-verse",
                "line",
            ],
        },
    },
    "Aristaeus Phil.": {
        "tlg_id": "TLG1180",
        "names": {"name_authtab": "Aristaeus Phil.", "name_idt": "Aristaeus Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Mauricius Tact.": {
        "tlg_id": "TLG3075",
        "names": {
            "name_authtab": "Pseudo-Mauricius Tact.",
            "name_idt": "Mauricius Tact.",
        },
        "works": {
            "9Strategicon (sub nomine Mauricii Imperatoris vel Urbicii)": [
                "Book",
                "chapter",
                "section",
                "line",
                "",
                "©",
                "©",
                "",
                "",
                "©\x12©\x12\x12\x12©\x12©\x12©\x12©\x12©\x12©\x12©\x12©\x12©\x12©\x12©\x12©\x12\x12©\x12©\x12\x12\x12©\x12©\x12\x12\x12\x13\x8c\x13©\x8c\x13©\x13©\x8e\x13©\x13©\x13\x13\x13\x13©\x8c\x13\x13\x13\x13©\x13\x13\x13\x13©\x8e\x13©\x13",
            ]
        },
    },
    "Teleclides Comic.": {
        "tlg_id": "TLG0510",
        "names": {"name_authtab": "Teleclides Comic.", "name_idt": "Teleclides Comic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Phlegon Paradox.": {
        "tlg_id": "TLG0585",
        "names": {
            "name_authtab": "Publius Aelius Phlegon Paradox.",
            "name_idt": "Phlegon Paradox.",
        },
        "works": {
            "De mirabilibus": ["Chapter", "section", "line"],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line"],
        },
    },
    "Florilegium Cyrillianum": {
        "tlg_id": "TLG4147",
        "names": {
            "name_authtab": "Florilegium Cyrillianum",
            "name_idt": "Florilegium Cyrillianum",
        },
        "works": {"Florilegium Cyrillianum": ["Page", "line"]},
    },
    "Hieronymus Hist.": {
        "tlg_id": "TLG1953",
        "names": {"name_authtab": "Hieronymus Hist.", "name_idt": "Hieronymus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Liber Enoch": {
        "tlg_id": "TLG1463",
        "names": {"name_authtab": "Liber Enoch", "name_idt": "Liber Enoch"},
        "works": {
            "+Apocalypsis Enochi (recensio ap. Syncellum)": [
                "Chapter",
                "section",
                "line",
            ],
            "Apocalypsis Enochi": ["Chapter", "section", "line"],
        },
    },
    "Joannes Damascenus Scr. Eccl., Theol.": {
        "tlg_id": "TLG2934",
        "names": {
            "name_authtab": "Joannes Damascenus Scr. Eccl. et Theol., John of Damascus",
            "name_idt": "Joannes Damascenus Scr. Eccl., Theol.",
        },
        "works": {
            "7Fragmenta philosophica (e cod. Oxon. Bodl. Auct. T.1.6)": [
                "Section",
                "line",
            ],
            "": ["Contra Manichaeos", "Section", "line"],
            "De haeresibus": ["Section", "line"],
            "&De partibus animae (fragmentum) [Dub.]": ["Volume", "page", "line"],
            "#Homilia in transfigurationem domini": ["Volume", "page", "line"],
            "Contra Jacobitas": ["Section", "line"],
            ")De virtutibus et vitiis (fragmenta) [Sp.]": ["Volume", "page", "line"],
            "$Sermo in annuntiationem Mariae [Sp.]": ["Volume", "page", "line"],
            "(Disputatio Christiani et Saraceni [Dub.]": ["Section", "line"],
            ".Qua ratione homo imago dei (fragmentum) [Dub.]": [
                "Volume",
                "page",
                "line",
            ],
            "%Commentarii in epistulas Pauli [Dub.]": ["Volume", "page", "line"],
            "LEpistula ad Theophilum imperatorem de sanctis et venerandis imaginibus [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "!De duabus in Christo voluntatibus": ["Section", "line"],
            "De animato (fragmentum) [Dub.]": ["Volume", "page", "line"],
            "qSacra parallela (recensiones secundum alphabeti litteras dispositae, quae tres libros conflant) (fragmenta e cod.": [
                "Volume",
                "page",
                "line",
            ],
            "0Fragmenta in Matthaeum (e catena Nicetae) [Dub.]": [
                "Volume",
                "page",
                "line",
            ],
            "/De octo spiritibus nequitiae (fragmentum) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            '"Quid est homo? (fragmentum) [Dub.]': ["Volume", "page", "line"],
            "Expositio fidei": ["Section", "line"],
            "Homilia in ficum arefactam": ["Volume", "page", "line"],
            "De sacris jejuniis": ["Volume", "page", "line"],
            "*De mensibus Macedonicis (fragmenta) [Dub.]": ["Volume", "page", "line"],
            "Contra Nestorianos": ["Section", "line"],
            "De unione (fragmentum) [Dub.]": ["Volume", "page", "line"],
            "%Contra Severianos (fragmentum) [Dub.]": ["Volume", "page", "line"],
            "De fide contra Nestorianos": ["Section", "line"],
            "Deprecationes i-iii [Dub.]": ["Volume", "page", "line"],
            " De theologia (fragmentum) [Dub.]": ["Volume", "page", "line"],
            "Vita Barlaam et Joasaph [Sp.]": ["Page", "line"],
            "'De sancta trinitate (fragmentum) [Dub.]": ["Volume", "page", "line"],
            "De immaculato corpore [Sp.]": ["Volume", "page", "line"],
            "De azymis (fragmenta duo) [Sp.]": ["Volume", "page", "line"],
            "5Dialectica sive Capita philosophica (recensio fusior)": [
                "Section",
                "line",
            ],
            "&Fragmenta in Lucam (in catenis) [Dub.]": ["Volume", "page", "line"],
            "(Encomium in sanctum Joannem Chrysostomum": ["Volume", "page", "line"],
            "Passio sancti Artemii [Dub.]": ["Volume", "page", "line"],
            "MDialectica sive Capita philosophica (recensio brevior, $E(/TERON KEFA/LAION&)": [
                "Section",
                "line",
            ],
            "=Ex thesauro orthodoxiae Nicetae Choniatae (fragmentum) [Dub.]": [
                "Volume",
                "page",
                "line",
            ],
            "Epistula de hymno trisagio": ["Section", "line"],
            "Orationes de imaginibus tres": ["Section", "line"],
            "6Dialectica sive Capita philosophica (recensio brevior)": [
                "Section",
                "line",
            ],
            "Institutio elementaris": ["Section", "line"],
            "Laudatio sanctae Barbarae": ["Volume", "page", "line"],
            ")De natura composita sive Contra acephalos": ["Section", "line"],
            "Homilia in sabbatum sanctum": ["Volume", "page", "line"],
            "*Oratio de his qui in fide dormierunt [Sp.]": ["Volume", "page", "line"],
        },
    },
    "Anonymi Exegesis In Hesiodi Theogoniam": {
        "tlg_id": "TLG3156",
        "names": {
            "name_authtab": "Anonymi Exegesis In Hesiodi Theogoniam",
            "name_idt": "Anonymi Exegesis In Hesiodi Theogoniam",
        },
        "works": {"Exegesis in Hesiodi theogoniam": ["Page", "line"]},
    },
    "De Arboribus Avibusque Fabulae": {
        "tlg_id": "TLG0272",
        "names": {
            "name_authtab": "De Arboribus Avibusque Fabulae",
            "name_idt": "De Arboribus Avibusque Fabulae",
        },
        "works": {"Fragmenta (P. Heidelb. 222)": ["Fragment", "column", "line"]},
    },
    "Thrasymachus Rhet., Soph.": {
        "tlg_id": "TLG1729",
        "names": {
            "name_authtab": "Thrasymachus Rhet. et Soph.",
            "name_idt": "Thrasymachus Rhet., Soph.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Nonnus": {
        "tlg_id": "TLG3127",
        "names": {"name_authtab": "Pseudo-Nonnus", "name_idt": "Nonnus"},
        "works": {"Scholia mythologica": ["Oration", "historia", "line"]},
    },
    "Paradoxographus Florentinus": {
        "tlg_id": "TLG0580",
        "names": {
            "name_authtab": "Paradoxographus Florentinus",
            "name_idt": "Paradoxographus Florentinus",
        },
        "works": {"Mirabilia de aquis": ["Section", "line"]},
    },
    "Hierotheus Alchem.": {
        "tlg_id": "TLG4331",
        "names": {
            "name_authtab": "Hierotheus Alchem.",
            "name_idt": "Hierotheus Alchem.",
        },
        "works": {
            "P$*(IEROQE/OU PERI\\ TH=S I(ERA=S TE/XNHS &(e cod. Paris. B.N. gr. 2249, fol. 94r)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Pamphila Hist.": {
        "tlg_id": "TLG1828",
        "names": {"name_authtab": "Pamphila Hist.", "name_idt": "Pamphila Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Thespis Trag.": {
        "tlg_id": "TLG0301",
        "names": {"name_authtab": "Thespis Trag.", "name_idt": "Thespis Trag."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hestiaeus Hist.": {
        "tlg_id": "TLG1428",
        "names": {"name_authtab": "Hestiaeus Hist.", "name_idt": "Hestiaeus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Laetus Hist.": {
        "tlg_id": "TLG2525",
        "names": {"name_authtab": "Laetus Hist.", "name_idt": "Laetus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Achilles Tatius Astron.": {
        "tlg_id": "TLG2133",
        "names": {
            "name_authtab": "Achilles Tatius Astron.",
            "name_idt": "Achilles Tatius Astron.",
        },
        "works": {"Isagoga excerpta": ["Section", "line"]},
    },
    "Aeschylus Trag.": {
        "tlg_id": "TLG0321",
        "names": {"name_authtab": "Aeschylus Trag.", "name_idt": "Aeschylus Trag."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Testimonium": ["line", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Testamentum Salomonis": {
        "tlg_id": "TLG2679",
        "names": {
            "name_authtab": "Testamentum Salomonis",
            "name_idt": "Testamentum Salomonis",
        },
        "works": {
            "UNarratio de propheta et sapientissimo rege Salomone (cod. Monasterii sancti Saba 290)": [
                "Page",
                "line",
            ],
            "*Testamentum Salomonis (recensio A) (ms. L)": ["Page", "line"],
            "Sigilla anuli Salomonis": ["Page", "line"],
            "Conspectus titulorum": ["Page", "line"],
            ",Testamentum Salomonis (recensio A) (mss. HI)": ["Page", "line"],
            "3Testamentum Salomonis (recensio C, I.1-3) (mss. VW)": ["Page", "line"],
            "7Testamentum Salomonis (recensiones A et B) (mss. HILPQ)": [
                "Page",
                "line",
            ],
            "/Testamentum Salomonis (recensio C) (mss. VWSTU)": ["Page", "line"],
            "6Testamentum Salomonis (recensiones A et B) (mss. HIPQ)": ["Page", "line"],
            "BVita Salomonis (cod. 132 Monasterii sancti Dionysii in Monte Atho)": [
                "Page",
                "line",
            ],
        },
    },
    "Diogenianus Gramm.": {
        "tlg_id": "TLG0097",
        "names": {
            "name_authtab": "Diogenianus Gramm.",
            "name_idt": "Diogenianus Gramm.",
        },
        "works": {
            "CParoemiae (epitome operis sub nomine Diogeniani) (e cod. Mazarinco)": [
                "Centuria",
                "section",
                "line",
            ],
            "EParoemiae (epitome operis sub nomine Diogeniani) (e cod. Vindob. 133)": [
                "Centuria",
                "section",
                "line",
            ],
        },
    },
    "Agathon Epigr.": {
        "tlg_id": "TLG1775",
        "names": {
            "name_authtab": "Pseudo-Agathon Epigr.",
            "name_idt": "Agathon Epigr.",
        },
        "works": {"Epigramma": ["Epigram", "line"]},
    },
    "Hegesianax Astron., Epic.": {
        "tlg_id": "TLG1393",
        "names": {
            "name_authtab": "Hegesianax Astron. et Epic.",
            "name_idt": "Hegesianax Astron., Epic.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta et titulus": ["Fragment", "line"],
        },
    },
    "Creophylus Hist.": {
        "tlg_id": "TLG1291",
        "names": {"name_authtab": "Creophylus Hist.", "name_idt": "Creophylus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Psellus Polyhist.": {
        "tlg_id": "TLG2702",
        "names": {
            "name_authtab": "Michael Psellus Polyhist.",
            "name_idt": "Psellus Polyhist.",
        },
        "works": {
            "&De Euripide et Georgio Piside judicium": ["line"],
            "Orationes forenses et acta": ["oration", "line"],
            "Chronographia": ["Chapter", "section", "line"],
            "Poemata": ["Poem", "line"],
            "Oratoria minora": ["Oration", "line"],
            "0Opuscula psychologica, theologica, daemonologica": ["Page", "line"],
            "In Mariam Sclerenam": ["line"],
            "Encomium in matrem": ["line"],
            "Orationes panegyricae": ["Oration", "line"],
            "&De Heliodoro et Achille Tatio judicium": ["line"],
            "*Opuscula logica, physica, allegorica, alia": ["Opusculum", "line"],
            "Theologica": ["Opusculum", "line"],
        },
    },
    "Theano Phil.": {
        "tlg_id": "TLG0054",
        "names": {"name_authtab": "Theano Phil.", "name_idt": "Theano Phil."},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Xenophontis Epistulae": {
        "tlg_id": "TLG1754",
        "names": {
            "name_authtab": "Xenophontis Epistulae",
            "name_idt": "Xenophontis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Pherecydes Myth., Phil.": {
        "tlg_id": "TLG0630",
        "names": {
            "name_authtab": "Pherecydes Myth. et Phil.",
            "name_idt": "Pherecydes Myth., Phil.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Poliochus Comic.": {
        "tlg_id": "TLG0498",
        "names": {"name_authtab": "Poliochus Comic.", "name_idt": "Poliochus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Amphiarai Exilium (?)": {
        "tlg_id": "TLG0710",
        "names": {
            "name_authtab": "Amphiarai Exilium (?)",
            "name_idt": "Amphiarai Exilium (?)",
        },
        "works": {"Fragmentum": ["line"]},
    },
    "Apocalypsis Eliae": {
        "tlg_id": "TLG1156",
        "names": {"name_authtab": "Apocalypsis Eliae", "name_idt": "Apocalypsis Eliae"},
        "works": {"Fragmenta": ["Page", "line"]},
    },
    "Evangelium Thomae": {
        "tlg_id": "TLG1375",
        "names": {"name_authtab": "Evangelium Thomae", "name_idt": "Evangelium Thomae"},
        "works": {"": ["Evangelium Thomae", "line"]},
    },
    "Dorotheus Astrol.": {
        "tlg_id": "TLG1337",
        "names": {"name_authtab": "Dorotheus Astrol.", "name_idt": "Dorotheus Astrol."},
        "works": {
            "Fragmenta Graeca": ["Page", "line"],
            "<Fragmenta e Hephaestionis $*)APOTELESMATIKW=N& libris hausta": [
                "Fragment",
                "section",
                "line",
            ],
            "Fragmenta alia antiqua": ["Fragment", "line"],
        },
    },
    "Apollodorus Hist.": {
        "tlg_id": "TLG1164",
        "names": {"name_authtab": "Apollodorus Hist.", "name_idt": "Apollodorus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Timagoras Hist.": {
        "tlg_id": "TLG2268",
        "names": {"name_authtab": "Timagoras Hist.", "name_idt": "Timagoras Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Eupolis Comic.": {
        "tlg_id": "TLG0461",
        "names": {"name_authtab": "Eupolis Comic.", "name_idt": "Eupolis Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Jusjurandum Medicum": {
        "tlg_id": "TLG0740",
        "names": {
            "name_authtab": "Jusjurandum Medicum",
            "name_idt": "Jusjurandum Medicum",
        },
        "works": {"Jusjurandum medicum": ["line"]},
    },
    "Nicocrates Hist.": {
        "tlg_id": "TLG1535",
        "names": {"name_authtab": "Nicocrates Hist.", "name_idt": "Nicocrates Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heraclides Ponticus Junior Gramm.": {
        "tlg_id": "TLG0283",
        "names": {
            "name_authtab": "Heraclides Ponticus Junior Gramm.",
            "name_idt": "Heraclides Ponticus Junior Gramm.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmenta et titulus": ["Fragment", "line"],
        },
    },
    "Sophocles Junior Trag.": {
        "tlg_id": "TLG0326",
        "names": {
            "name_authtab": "Sophocles Junior Trag.",
            "name_idt": "Sophocles Junior Trag.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Oracula Chaldaica": {
        "tlg_id": "TLG1550",
        "names": {"name_authtab": "Oracula Chaldaica", "name_idt": "Oracula Chaldaica"},
        "works": {
            "6Oracula (fragmenta) (olim sub auctore Juliano Theurgo)": [
                "Oracle",
                "line",
            ]
        },
    },
    "Scholia In Sophoclem": {
        "tlg_id": "TLG5037",
        "names": {
            "name_authtab": "Scholia In Sophoclem",
            "name_idt": "Scholia In Sophoclem",
        },
        "works": {
            "HArgumenta et excerpta interpretationum allegoricarum in Sophoclis Ajacem": [
                "\x12Argumentum-excerpt",
                "line",
            ],
            ",Scholia in Sophoclis Ajacem (scholia vetera)": [
                "Hypothesis-scholion",
                "line",
            ],
            ":Scholia in Sophoclis Oedipum tyrannum (scholia recentiora)": [
                "\x12Source of scholion",
                "scholion",
                "line",
            ],
            "6Scholia in Sophoclis Oedipum Coloneum (scholia vetera)": [
                "Hypothesis-scholion",
                "line",
            ],
            "FScholia et glossae in Sophoclis Ajacem (glossae et scholia recentiora)": [
                "Scholion",
                "line",
            ],
            "%Scholia in Sophoclem (scholia vetera)": ["Play", "verse", "line"],
        },
    },
    "Agamestor Eleg.": {
        "tlg_id": "TLG2605",
        "names": {"name_authtab": "Agamestor Eleg.", "name_idt": "Agamestor Eleg."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Archestratus Trag.": {
        "tlg_id": "TLG1115",
        "names": {
            "name_authtab": "Archestratus Trag.",
            "name_idt": "Archestratus Trag.",
        },
        "works": {"Titulus": ["line"]},
    },
    "[Longinus] Rhet.": {
        "tlg_id": "TLG0560",
        "names": {
            "name_authtab": "[Longinus] Rhet., Pseudo-Longinus",
            "name_idt": "[Longinus] Rhet.",
        },
        "works": {"De sublimitate": ["Chapter", "section", "line"]},
    },
    "Salmanas Alchem.": {
        "tlg_id": "TLG4340",
        "names": {"name_authtab": "Salmanas Alchem.", "name_idt": "Salmanas Alchem."},
        "works": {
            "q$*ME/QODOS DI' H(=S A)POTELEI=TAI H( SFAIROEIDH\\S XA/LAZA KATASKEUASQEI=SA PARA\\ TOU= E)N TEXNOURGI/A| PERIBOH/TO": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Anonymi Geographiae Expositio Compendiaria": {
        "tlg_id": "TLG0092",
        "names": {
            "name_authtab": "Anonymi Geographiae Expositio Compendiaria",
            "name_idt": "Anonymi Geographiae Expositio Compendiaria",
        },
        "works": {'"Geographiae expositio compendiaria': ["Section", "line"]},
    },
    "Demonax Phil.": {
        "tlg_id": "TLG2969",
        "names": {"name_authtab": "Demonax Phil.", "name_idt": "Demonax Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Echembrotus Eleg., Lyr.": {
        "tlg_id": "TLG0249",
        "names": {
            "name_authtab": "Echembrotus Eleg. et Lyr.",
            "name_idt": "Echembrotus Eleg., Lyr.",
        },
        "works": {"Fragmentum": ["line"]},
    },
    "Phanocles Eleg.": {
        "tlg_id": "TLG0214",
        "names": {"name_authtab": "Phanocles Eleg.", "name_idt": "Phanocles Eleg."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Clitarchus Gnom.": {
        "tlg_id": "TLG1278",
        "names": {"name_authtab": "Clitarchus Gnom.", "name_idt": "Clitarchus Gnom."},
        "works": {"Sententiae": ["Sententia", "line"]},
    },
    "Theudo[tus] Trag.": {
        "tlg_id": "TLG0816",
        "names": {"name_authtab": "Theudo[tus] Trag.", "name_idt": "Theudo[tus] Trag."},
        "works": {"Titulus": ["line"]},
    },
    "Theodosius Astron., Math.": {
        "tlg_id": "TLG1719",
        "names": {
            "name_authtab": "Theodosius Astron. et Math.",
            "name_idt": "Theodosius Astron., Math.",
        },
        "works": {
            "Sphaerica": ["Chapter", "section", "line"],
            "": ["De habitationibus", "Section", "line"],
            "De diebus et noctibus": ["Page", "line"],
        },
    },
    "Erotianus Gramm., Med.": {
        "tlg_id": "TLG0716",
        "names": {
            "name_authtab": "Erotianus Gramm. et Med.",
            "name_idt": "Erotianus Gramm., Med.",
        },
        "works": {
            "Vocum Hippocraticarum collectio": ["Klein page", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Pollux Gramm.": {
        "tlg_id": "TLG0542",
        "names": {"name_authtab": "Julius Pollux Gramm.", "name_idt": "Pollux Gramm."},
        "works": {"Onomasticon": ["Book", "section", "line"]},
    },
    "Peirazomene": {
        "tlg_id": "TLG0275",
        "names": {"name_authtab": "Peirazomene", "name_idt": "Peirazomene"},
        "works": {"!Fragmentum (Brit. Mus. inv. 2208)": ["line"]},
    },
    "Dinon Hist.": {
        "tlg_id": "TLG1316",
        "names": {"name_authtab": "Dinon Hist.", "name_idt": "Dinon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Sententiae Sexti": {
        "tlg_id": "TLG1666",
        "names": {"name_authtab": "Sententiae Sexti", "name_idt": "Sententiae Sexti"},
        "works": {"Sententiae Sexti": ["Sententia", "line"]},
    },
    "Apocalypsis Baruch": {
        "tlg_id": "TLG1154",
        "names": {
            "name_authtab": "Apocalypsis Baruch",
            "name_idt": "Apocalypsis Baruch",
        },
        "works": {
            "'Apocalypsis Baruchi Graece (iii Baruch)": ["Chapter", "section", "line"]
        },
    },
    "Posidonius Hist.": {
        "tlg_id": "TLG2187",
        "names": {"name_authtab": "Posidonius Hist.", "name_idt": "Posidonius Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Timotheus Gramm.": {
        "tlg_id": "TLG2449",
        "names": {"name_authtab": "Timotheus Gramm.", "name_idt": "Timotheus Gramm."},
        "works": {
            "9Excerpta ex libris de animalibus (e cod. Paris. gr. 2422)": [
                "Section",
                "line",
            ],
            "=$*KANO/NES KAQOLIKOI\\ PERI\\ SUNTA/CEWS &(e cod. Coislin. 387)": [
                "Page",
                "line",
            ],
        },
    },
    "Philicus Lyr.": {
        "tlg_id": "TLG1588",
        "names": {"name_authtab": "Philicus Lyr.", "name_idt": "Philicus Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Plato Phil.": {
        "tlg_id": "TLG0059",
        "names": {"name_authtab": "Plato Phil.", "name_idt": "Plato Phil."},
        "works": {
            "": ["Fragmenta tragica", "Fragment", "line"],
            "Respublica": ["Stephanus page", "section", "line"],
            "Meno": ["Stephanus page", "section", "line"],
            "Philebus": ["Stephanus page", "section", "line"],
            "Cratylus": ["Stephanus page", "section", "line"],
            "Alcibiades ii [Sp.]": ["Stephanus page", "section", "line"],
            "Timaeus": ["Stephanus page", "section", "line"],
            "Ion": ["Stephanus page", "section", "line"],
            "Theaetetus": ["Stephanus page", "section", "line"],
            "Minos [Sp.]": ["Stephanus page", "section", "line"],
            "Euthydemus": ["Stephanus page", "section", "line"],
            "Charmides": ["Stephanus page", "section", "line"],
            "Hippias major [Dub.]": ["Stephanus page", "section", "line"],
            "Hipparchus [Sp.]": ["Stephanus page", "section", "line"],
            "Amatores [Sp.]": ["Stephanus page", "section", "line"],
            "Epigrammata": ["Epigram", "line"],
            "Lysis": ["Stephanus page", "section", "line"],
            "0Epinomis [Dub.] (fort. auctore Philippo Opuntio)": [
                "Stephanus page",
                "section",
                "line",
            ],
            "Protagoras": ["Stephanus page", "section", "line"],
            "Clitophon [Dub.]": ["Stephanus page", "section", "line"],
            "Crito": ["Stephanus page", "section", "line", "´"],
            "Symposium": ["Stephanus page", "section", "line"],
            "Epistulae [Dub.]": ["Stephanus page", "section", "line"],
            "Phaedrus": ["Stephanus page", "section", "line"],
            "Laches": ["Stephanus page", "section", "line"],
            "Hippias minor": ["Stephanus page", "section", "line"],
            "Spuria": ["Stephanus page", "section", "line"],
            "Parmenides": ["Stephanus page", "section", "line"],
            "Gorgias": ["Stephanus page", "section", "line"],
            "Leges": ["Stephanus page", "section", "line"],
            "Politicus": ["Stephanus page", "section", "line"],
            "Definitiones [Sp.]": ["Stephanus page", "section", "line"],
            "Theages [Sp.]": ["Stephanus page", "section", "line"],
            "Sophista": ["Stephanus page", "section", "line"],
            "Phaedo": ["Stephanus page", "section", "line", "¼¿ÂÇÊÍÐÓÖÜßëîöÝ%"],
            "Menexenus": ["Stephanus page", "section", "line"],
            "Critias": ["Stephanus page", "section", "line"],
            "Euthyphro": ["Stephanus page", "section", "line"],
            "Alcibiades i [Sp.]": ["Stephanus page", "section", "line"],
        },
    },
    "Carmen Naupactium": {
        "tlg_id": "TLG1241",
        "names": {"name_authtab": "Carmen Naupactium", "name_idt": "Carmen Naupactium"},
        "works": {"Carmen Naupactium (fragmenta)": ["Fragment", "line"]},
    },
    "Panteleius Epic.": {
        "tlg_id": "TLG2120",
        "names": {"name_authtab": "Panteleius Epic.", "name_idt": "Panteleius Epic."},
        "works": {"Fragmentum": ["line"]},
    },
    "Dicaearchus Phil.": {
        "tlg_id": "TLG0066",
        "names": {"name_authtab": "Dicaearchus Phil.", "name_idt": "Dicaearchus Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Joannes Actuarius Med.": {
        "tlg_id": "TLG3188",
        "names": {
            "name_authtab": "Joannes Actuarius Med.",
            "name_idt": "Joannes Actuarius Med.",
        },
        "works": {
            "De spiritu animali": ["Book", "chapter", "setion", "line"],
            "De diagnosi": ["Book", "chapter", "line"],
            "De urinis": ["Book", "chapter", "section", "line"],
        },
    },
    "Apollophanes Comic.": {
        "tlg_id": "TLG0414",
        "names": {
            "name_authtab": "Apollophanes Comic.",
            "name_idt": "Apollophanes Comic.",
        },
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Glossae In Herodotum": {
        "tlg_id": "TLG4304",
        "names": {
            "name_authtab": "Glossae In Herodotum",
            "name_idt": "Glossae In Herodotum",
        },
        "works": {
            "/Glossae in Herodotum (%6$ *(HRODO/TOU LE/CEIS&)": [
                "\x0eHerodotus book",
                "entry",
                "line",
            ],
            "CGlossae in Herodotum (%6 $*(HRODO/TOU LE/CEIS&) (litterarum ordine)": [
                "",
                "Alphabetic letter",
                "entry",
                "line",
            ],
        },
    },
    "Polyidus Trag.": {
        "tlg_id": "TLG0331",
        "names": {"name_authtab": "Polyidus Trag.", "name_idt": "Polyidus Trag."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Ammonius Epigr.": {
        "tlg_id": "TLG0289",
        "names": {"name_authtab": "Ammonius Epigr.", "name_idt": "Ammonius Epigr."},
        "works": {"Fragmentum": ["line"], "Epigramma": ["Book", "epigram", "line"]},
    },
    "Nicocles Hist.": {
        "tlg_id": "TLG1534",
        "names": {"name_authtab": "Nicocles Hist.", "name_idt": "Nicocles Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Hesiodus Epic.": {
        "tlg_id": "TLG0020",
        "names": {"name_authtab": "Hesiodus Epic.", "name_idt": "Hesiodus Epic."},
        "works": {
            "": ["Hesiodus Epic. !!! AUTHOR NAME"],
            "Fragmentum (ap. Maximum Tyrium)": ["line"],
            "Testimonia": ["Fragment", "line"],
            "Scutum": ["line"],
            "Fragmenta astronomica": ["Fragment", "line"],
            "Opera et dies": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Theogonia": ["line"],
        },
    },
    "Megasthenes Hist.": {
        "tlg_id": "TLG1489",
        "names": {"name_authtab": "Megasthenes Hist.", "name_idt": "Megasthenes Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Machon Comic.": {
        "tlg_id": "TLG0473",
        "names": {"name_authtab": "Machon Comic.", "name_idt": "Machon Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Doxapatres Rhet.": {
        "tlg_id": "TLG3027",
        "names": {
            "name_authtab": "Joannes Doxapatres Rhet.",
            "name_idt": "Doxapatres Rhet.",
        },
        "works": {
            "0Prolegomena in Hermogenis librum $PERI\\ I)DEW=N&": [
                "Volume",
                "page",
                "line",
            ],
            "3Prolegomena in Hermogenis librum $PERI\\ EU(RE/SEWS&": [
                "Volume",
                "page",
                "line",
                "\x8eí",
                "\x8ey\x14´",
            ],
            "1Prolegomena in Hermogenis librum $PERI\\ STA/SEWN&": [
                "Volume",
                "page",
                "line",
                "³",
            ],
            "&Prolegomena in Aphthonii progymnasmata": ["Volume", "page", "line"],
        },
    },
    "Demetrius Comic.": {
        "tlg_id": "TLG0439",
        "names": {"name_authtab": "Demetrius Comic.", "name_idt": "Demetrius Comic."},
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Tituli": ["Fragment", "line"],
        },
    },
    "Bruti Epistulae": {
        "tlg_id": "TLG1803",
        "names": {"name_authtab": "Bruti Epistulae", "name_idt": "Bruti Epistulae"},
        "works": {"Epistulae": ["Epistle", "line"]},
    },
    "Elegiaca Adespota (IEG)": {
        "tlg_id": "TLG0234",
        "names": {
            "name_authtab": "Elegiaca Adespota (IEG)",
            "name_idt": "Elegiaca Adespota (IEG)",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Diodorus Eleg.": {
        "tlg_id": "TLG2652",
        "names": {"name_authtab": "Diodorus Eleg.", "name_idt": "Diodorus Eleg."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Ignatius Scr. Eccl.": {
        "tlg_id": "TLG1443",
        "names": {
            "name_authtab": "Ignatius Scr. Eccl.",
            "name_idt": "Ignatius Scr. Eccl.",
        },
        "works": {
            "+Fragmenta (e cod. Florent. Laur. 6.4) [Sp.]": ["line"],
            "JEpistulae interpolatae et epistulae suppositiciae (recensio longior) [Sp.]": [
                "Epistle",
                "chapter",
                "section",
                "line",
            ],
            "'Epistulae vii genuinae (recensio media)": [
                "Epistle",
                "chapter",
                "section",
                "line",
            ],
        },
    },
    "Gryllus": {
        "tlg_id": "TLG2118",
        "names": {"name_authtab": "Gryllus", "name_idt": "Gryllus"},
        "works": {"Fragmentum (P. Oxy. 22.2331)": ["line"]},
    },
    "Sosigenes Phil.": {
        "tlg_id": "TLG1748",
        "names": {"name_authtab": "Sosigenes Phil.", "name_idt": "Sosigenes Phil."},
        "works": {"Testimonium": ["Fragment", "line"]},
    },
    "Solon Nomographus, Poeta": {
        "tlg_id": "TLG0263",
        "names": {
            "name_authtab": "Solon Nomographus et Poeta",
            "name_idt": "Solon Nomographus, Poeta",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Phalaridis Epistulae": {
        "tlg_id": "TLG0053",
        "names": {
            "name_authtab": "Phalaridis Epistulae",
            "name_idt": "Phalaridis Epistulae",
        },
        "works": {"Epistulae": ["Epistle", "section", "line"]},
    },
    "Marcus Diaconus Scr. Eccl.": {
        "tlg_id": "TLG2806",
        "names": {
            "name_authtab": "Marcus Diaconus Scr. Eccl.",
            "name_idt": "Marcus Diaconus Scr. Eccl.",
        },
        "works": {" Vita Porphyrii episcopi Gazensis": ["Chapter", "line"]},
    },
    "Acusilaus Hist.": {
        "tlg_id": "TLG0392",
        "names": {"name_authtab": "Acusilaus Hist.", "name_idt": "Acusilaus Hist."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Philosophus Christianus Alchem.": {
        "tlg_id": "TLG4328",
        "names": {
            "name_authtab": "Philosophus Christianus Alchem.",
            "name_idt": "Philosophus Christianus Alchem.",
        },
        "works": {
            "l$*PO/SAI EI)SI\\N AI( KAT' EI)=DOS KAI\\ GE/NOS DIAFORAI\\ TW=N POIH/SEWN &(e cod. Venet. Marc. 299, fol. 122r)": [
                "Volume",
                "page",
                "line",
            ],
            "H$*TI/S H( TW=N A)RXAI/WN DIAFWNI/A &(e cod. Venet. Marc. 299, fol. 101v)": [
                "Volume",
                "page",
                "line",
            ],
            "m$*PW=S DEI= NOEI=N DIAFORA\\S TW=N POIH/SEWN KAI\\ SXH/MASI GEWMETRIKOI=S &(e cod. Venet. Marc. 299, fol. 124r)": [
                "Volume",
                "page",
                "line",
            ],
            "p$*TOU= *XRISTIANOU= SU/NOYIS. TI/S H( AI)TI/A TH=S PROKEIME/NHS SUGGRAFH=S &(e cod. Venet. Marc. 299, fol. 121r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*(/OTI TETRAXW=S DIAIROUME/NHS TH=S U(/LHS, DIA/FOROI A)POGI/NONTAI TW=N POIH/SEWN AI( TA/CEIS &(e cod. Venet. M": [
                "Volume",
                "page",
                "line",
            ],
            "b$*TI/S H( E)N A)POKRU/FOIS TW=N PALAIW=N E)KDIDOME/NH TA/CIS &(e cod. Venet. Marc. 299, fol. 124v)": [
                "Volume",
                "page",
                "line",
            ],
            "T$*TOU= *XRISTIANOU= PERI\\ TOU= QEI/OU U(/DATOS &(e cod. Venet. Marc. 299, fol. 101r)": [
                "Volume",
                "page",
                "line",
            ],
            "R$*TI/S H( KAQO/LOU TOU= U(/DATOS OI)KONOMI/A &(e cod. Venet. Marc. 299, fol. 102r)": [
                "Volume",
                "page",
                "line",
            ],
            "J$*(H TOU= MUQIKOU= U(/DATOS POI/HSIS &(e cod. Venet. Marc. 299, fol. 102r)": [
                "Volume",
                "page",
                "line",
            ],
            "q$*)APORI/A. *TO\\ E(\\N A)BU/SSAION U(/DWR E)N TW=| A)RIQMW=| DEIKNU/EIN E)QE/LOUSA H( TOU/TOU E)PI/LUSIS &(e cod. ": [
                "Volume",
                "page",
                "line",
            ],
            "q$*)ANTI/QESIS LE/GOUSA O(/TI TO\\ QEI=ON U(/DWR E(/N E)STI TW=| EI)/DEI KAI\\ H( LU/SIS AU)TH=S &(e cod. Venet. Mar": [
                "Volume",
                "page",
                "line",
            ],
            "Y$*TOU= *XRISTIANOU= PERI\\ EU)STAQEI/AS TOU= XRUSOU= &(e cod. Venet. Marc. 299, fol. 110r)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Basilius Med., Scr. Eccl.": {
        "tlg_id": "TLG2084",
        "names": {
            "name_authtab": "Basilius Med. et Scr. Eccl.",
            "name_idt": "Basilius Med., Scr. Eccl.",
        },
        "works": {"De virginitate": ["MPG page", "line"]},
    },
    "Clemens Alexandrinus Theol.": {
        "tlg_id": "TLG0555",
        "names": {
            "name_authtab": "Clemens Alexandrinus Theol.",
            "name_idt": "Clemens Alexandrinus Theol.",
        },
        "works": {
            "Eclogae propheticae": ["Chapter", "section", "line"],
            "Excerpta ex Theodoto": ["Section", "extract", "excerpt", "line"],
            "Quis dives salvetur": ["Chapter", "section", "line"],
            "Paedagogus": ["Book", "chapter", "subchapter", "section", "line"],
            "Protrepticus": ["Chapter", "section", "subsection", "line"],
            "Hymnus Christi servatoris": ["line"],
            "Fragmenta": ["Fragment", "line"],
            "Stromata": ["Book", "chapter", "section", "subsection", "line"],
        },
    },
    "Abydenus Hist.": {
        "tlg_id": "TLG0116",
        "names": {"name_authtab": "Abydenus Hist.", "name_idt": "Abydenus Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Philonides Comic.": {
        "tlg_id": "TLG0492",
        "names": {"name_authtab": "Philonides Comic.", "name_idt": "Philonides Comic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Julianus Scriptor Legis De Medicis": {
        "tlg_id": "TLG0737",
        "names": {
            "name_authtab": "Julianus Scriptor Legis De Medicis",
            "name_idt": "Julianus Scriptor Legis De Medicis",
        },
        "works": {"Lex de medicis": ["line"]},
    },
    "Lexicon Rhetoricum Cantabrigiense": {
        "tlg_id": "TLG4301",
        "names": {
            "name_authtab": "Lexicon Rhetoricum Cantabrigiense",
            "name_idt": "Lexicon Rhetoricum Cantabrigiense",
        },
        "works": {
            "PLexicon rhetoricum Cantabrigiense (e cod. Cantabr. Univ. D d 4,63 in marginibus)": [
                "Page",
                "line",
            ]
        },
    },
    "Theognetus Comic.": {
        "tlg_id": "TLG0511",
        "names": {"name_authtab": "Theognetus Comic.", "name_idt": "Theognetus Comic."},
        "works": {
            "Fragmenta": ["Play", "fragment", "line"],
            "Titulus": ["Fragment", "line"],
        },
    },
    "Demodocus Eleg.": {
        "tlg_id": "TLG0245",
        "names": {"name_authtab": "Demodocus Eleg.", "name_idt": "Demodocus Eleg."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Hymni Homerici": {
        "tlg_id": "TLG0013",
        "names": {
            "name_authtab": "Hymni Homerici, Homeric Hymns",
            "name_idt": "Hymni Homerici",
        },
        "works": {
            "In Minervam": ["line"],
            "In Herculem": ["line"],
            "In Neptunum": ["line"],
            "In Pana": ["line"],
            "In Martem": ["line"],
            "In Cererem": ["line"],
            "Fragmenta hymni in Bacchum": ["line"],
            "In Volcanum": ["line"],
            "In Lunam": ["line"],
            "In Tellurem matrem omnium": ["line"],
            "In Mercurium": ["line"],
            "In Vestam": ["line"],
            "*In Apollinem (fort. auctore Cynaetho Chio)": ["line"],
            "In Apollinem": ["line"],
            "In Dioscuros": ["line"],
            "In Solem": ["line"],
            "In Jovem": ["line"],
            "In Bacchum": ["line"],
            "In Venerem": ["line"],
            "In Aesculapium": ["line"],
            "In Dianam": ["line"],
            "In Junonem": ["line"],
            "In matrem deorum": ["line"],
            "In Musas et Apollinem": ["line"],
            "$*EI)S CE/NOUS&": ["line"],
        },
    },
    "Aristocles Paradox.": {
        "tlg_id": "TLG0571",
        "names": {
            "name_authtab": "Aristocles Paradox.",
            "name_idt": "Aristocles Paradox.",
        },
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Fragmenta": ["Fragment", "line"],
        },
    },
    "Protagorides Hist.": {
        "tlg_id": "TLG1636",
        "names": {
            "name_authtab": "Protagorides Hist.",
            "name_idt": "Protagorides Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Joannes Scylitzes Hist.": {
        "tlg_id": "TLG3063",
        "names": {
            "name_authtab": "Joannes Scylitzes Hist.",
            "name_idt": "Joannes Scylitzes Hist.",
        },
        "works": {"Synopsis historiarum": ["Emperor life", "section", "line"]},
    },
    "Lexicon Patmense": {
        "tlg_id": "TLG4302",
        "names": {"name_authtab": "Lexicon Patmense", "name_idt": "Lexicon Patmense"},
        "works": {
            "qLexicon Patmense (%6 $*LE/CEIS MEQ' I(STORIW=N E)K TW=N *DHMOSQE/NOUS KAI\\ *AI)SXI/NOU LO/GWN &%6 Lexicon in Demo": [
                "Page",
                "line",
            ]
        },
    },
    "Diophantus Math.": {
        "tlg_id": "TLG2039",
        "names": {"name_authtab": "Diophantus Math.", "name_idt": "Diophantus Math."},
        "works": {
            ")Fragmentum [Sp.] (e cod. Paris. gr. 2448)": ["Volume", "page", "line"],
            "Arithmeticorum libri sex": ["Page", "line"],
            "De polygonis numeris": ["Volume", "page", "line"],
            ":Fragmentum [Sp.] (e cod. Paris. suppl. gr. 387, fol. 181r)": [
                "Volume",
                "page",
                "line",
            ],
            "$Fragmentum [Sp.] (e cod. Paris. 453)": ["Volume", "page", "line"],
        },
    },
    "Anaximenes Hist., Rhet.": {
        "tlg_id": "TLG0547",
        "names": {
            "name_authtab": "Anaximenes Hist. et Rhet.",
            "name_idt": "Anaximenes Hist., Rhet.",
        },
        "works": {
            "+Ars rhetorica vulgo Rhetorica ad Alexandrum": [
                "Chapter",
                "section",
                "line",
                "",
            ],
            "Fragmenta": ["line", "fragment", "line"],
            "Testimonia": ["line", "fragment", "line", "`\x13³"],
        },
    },
    "Phoronis": {
        "tlg_id": "TLG1607",
        "names": {"name_authtab": "Phoronis", "name_idt": "Phoronis"},
        "works": {"Phoronis (fragmenta)": ["Fragment", "line"]},
    },
    "Philo Judaeus Senior Epic.": {
        "tlg_id": "TLG1594",
        "names": {
            "name_authtab": "Philo Judaeus Senior Epic.",
            "name_idt": "Philo Judaeus Senior Epic.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Archelaus Alchem., Poeta": {
        "tlg_id": "TLG4339",
        "names": {
            "name_authtab": "Archelaus Alchem. et Poeta",
            "name_idt": "Archelaus Alchem., Poeta",
        },
        "works": {
            "q$*)ARXELA/OU FILOSO/FOU PERI\\ TH=S QEI/AS TE/XNHS DIA\\ STI/XWN I)A/MBWN &(fort. auctore Heliodoro alchemista et p": [
                "line"
            ]
        },
    },
    "Timon Phil.": {
        "tlg_id": "TLG1735",
        "names": {"name_authtab": "Timon Phil.", "name_idt": "Timon Phil."},
        "works": {
            "Fragmenta et tituli": ["Fragment", "line"],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Philostratus Junior Soph.": {
        "tlg_id": "TLG0652",
        "names": {
            "name_authtab": "Philostratus Junior Soph.",
            "name_idt": "Philostratus Junior Soph.",
        },
        "works": {"Imagines": ["Olearius page", "line"]},
    },
    "Anagnostes Hist., Poeta": {
        "tlg_id": "TLG3145",
        "names": {
            "name_authtab": "Joannes Anagnostes Hist. et Poeta",
            "name_idt": "Anagnostes Hist., Poeta",
        },
        "works": {
            "+De extremo Thessalonicensi excidio narratio": ["Section", "line"],
            "Pro viribus acta monodia": ["Page", "line"],
        },
    },
    "[Chrysermus] Hist.": {
        "tlg_id": "TLG2195",
        "names": {
            "name_authtab": "[Chrysermus] Hist.",
            "name_idt": "[Chrysermus] Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Agesilaus Hist.": {
        "tlg_id": "TLG2555",
        "names": {"name_authtab": "Agesilaus Hist.", "name_idt": "Agesilaus Hist."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Megillus Phil.": {
        "tlg_id": "TLG1490",
        "names": {"name_authtab": "Megillus Phil.", "name_idt": "Megillus Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Xenarchus Comic.": {
        "tlg_id": "TLG0518",
        "names": {"name_authtab": "Xenarchus Comic.", "name_idt": "Xenarchus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Didymus Caecus Scr. Eccl.": {
        "tlg_id": "TLG2102",
        "names": {
            "name_authtab": "Didymus Caecus Scr. Eccl., Didymus the Blind",
            "name_idt": "Didymus Caecus Scr. Eccl.",
        },
        "works": {
            "": ["Contra Manichaeos", "Volume", "page", "line"],
            "In Genesim": ["Codex page", "line"],
            " De trinitate (lib. 2.8-27) [Sp.]": ["Volume", "page", "line"],
            "3Fragmenta in epistulam i ad Corinthios (in catenis)": ["Page", "line"],
            "Commentarii in Psalmos 20-21": ["Codex page", "line"],
            "Fragmenta in Proverbia": ["Volume", "page", "line"],
            "4Fragmenta in epistulam ii ad Corinthios (in catenis)": ["Page", "line"],
            "Commentarii in Psalmos 35-39": ["Codex page", "line"],
            "7De incorporeo (ap. Joannem Damascenum, Sacra parallela)": [
                "Volume",
                "page",
                "line",
            ],
            "5In epistulas catholicas brevis enarratio (in catenis)": ["Page", "line"],
            "De trinitate (lib. 2.1-7) [Sp.]": ["Chapter", "section", "line"],
            "0Fragmenta (ap. Antonium Melissam, Loci communes)": [
                "Volume",
                "page",
                "line",
            ],
            "0Commentarii in Octateuchum et Reges (in catenis)": [
                "Volume",
                "page",
                "line",
            ],
            "8Fragmenta (ap. Maximum Confessorem, Loci communes [Sp.])": [
                "Volume",
                "page",
                "line",
            ],
            "Commentarii in Psalmos 22-26.10": ["Codex page", "line"],
            "#Commentarii in Ecclesiasten (7-8.8)": ["Codex page", "line"],
            "Commentarii in Psalmos 29-34": ["Codex page", "line"],
            "'Commentarii in Ecclesiasten (9.8-10.20)": ["Codex page", "line"],
            "!Fragmenta in Joannem (in catenis)": ["Fragment", "line"],
            "Commentarii in Job (7.20c-11)": ["Codex page", "line"],
            "#Commentarii in Ecclesiasten (11-12)": ["Codex page", "line"],
            "Commentarii in Job (in catenis)": ["Volume", "page", "line"],
            "#Commentarii in Ecclesiasten (1.1-8)": ["Codex page", "line"],
            "$Commentarii in Ecclesiasten (3-4.12)": ["Codex page", "line"],
            "'Dialexis Montanistae et orthodoxi [Sp.]": ["Page", "line"],
            "Commentarii in Psalmos 40-44.4": ["Codex page", "line"],
            "De trinitate (lib. 1) [Sp.]": ["Chapter", "section", "line"],
            "Commentarii in Job (1-4)": ["Codex page", "line"],
            ".Fragmenta in epistulam ad Romanos (in catenis)": ["Page", "line"],
            "3Commentarii in Job (12.1-16.8a) (partim in catenis)": [
                "\x1fPapyrus page or catena fragment",
                "line",
            ],
            "!Commentarii in Ecclesiasten (5-6)": ["Codex page", "line"],
            "0Fragmentum in epistulam ad Hebraeos (in catenis)": ["Page", "line"],
            "Commentarii in Job (5.1-6.29)": ["Codex page", "line"],
            "8Ad philosophum (ap. Joannem Damascenum, Sacra parallela)": [
                "Volume",
                "page",
                "line",
            ],
            "Commentarii in Psalmos 36.15-19": ["Codex page", "line"],
            "De trinitate (lib. 3) [Sp.]": ["Volume", "page", "line"],
            "+Fragmenta in Psalmos (e commentario altero)": ["Fragment", "line"],
            "Commentarii in Zacchariam": ["Book", "section", "line"],
        },
    },
    "Pythagoras Phil.": {
        "tlg_id": "TLG0632",
        "names": {"name_authtab": "Pythagoras Phil.", "name_idt": "Pythagoras Phil."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Fragmenta": ["Page", "line"],
            "Fragmenta astrologica": ["Volume", "page", "line"],
            "Carmen aureum": ["line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Ister Hist.": {
        "tlg_id": "TLG1450",
        "names": {"name_authtab": "Ister Hist.", "name_idt": "Ister Hist."},
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Fragmentum (P. Oxy. 26.2442)": ["FGrH fragment", "line"],
        },
    },
    "Nymphis Hist.": {
        "tlg_id": "TLG1544",
        "names": {"name_authtab": "Nymphis Hist.", "name_idt": "Nymphis Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Theon Phil.": {
        "tlg_id": "TLG1724",
        "names": {"name_authtab": "Theon Phil.", "name_idt": "Theon Phil."},
        "works": {"De utilitate mathematicae": ["Page", "line"]},
    },
    "Joannes Archiereus Alchem.": {
        "tlg_id": "TLG4327",
        "names": {
            "name_authtab": "Joannes Archiereus Alchem.",
            "name_idt": "Joannes Archiereus Alchem.",
        },
        "works": {
            "p$*)IWA/NNOU A)RXIERE/WS TOU= E)N *)EBEIGI/A| PERI\\ TH=S QEI/AS TE/XNHS &(e cod. Paris. B.N. gr. 2327, fol. 243r)": [
                "Volume",
                "page",
                "line",
            ]
        },
    },
    "Liber Eldad Et Modad": {
        "tlg_id": "TLG1462",
        "names": {
            "name_authtab": "Liber Eldad Et Modad",
            "name_idt": "Liber Eldad Et Modad",
        },
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Philumenus Med.": {
        "tlg_id": "TLG0671",
        "names": {"name_authtab": "Philumenus Med.", "name_idt": "Philumenus Med."},
        "works": {
            ")De venenatis animalibus eorumque remediis": ["Chapter", "section", "line"]
        },
    },
    "Aelianus Soph.": {
        "tlg_id": "TLG0545",
        "names": {
            "name_authtab": "Claudius Aelianus Soph.",
            "name_idt": "Aelianus Soph.",
        },
        "works": {
            "Epistulae rusticae": ["Epistle", "line"],
            "De natura animalium": [
                "Book",
                "section",
                "line",
                "¤«´¼\x17§¶\x92\x1e\x92»\x8c%\x8c\x8e\x92,\x8c0¿\x8eÂ6\x8e«Î<\x92¤AG\x8eL¤\x92\x8e¤RW\x92«\x8c]\x8c®bÎbVb",
            ],
            "Varia historia": ["Book", "section", "line"],
            "Fragmenta": ["Fragment", "line"],
            "Titulus": ["line"],
        },
    },
    "[Sosthenes] Hist.": {
        "tlg_id": "TLG2568",
        "names": {"name_authtab": "[Sosthenes] Hist.", "name_idt": "[Sosthenes] Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Ptolemaeus VIII Euergetes II Hist.": {
        "tlg_id": "TLG1645",
        "names": {
            "name_authtab": "Ptolemaeus VIII Euergetes II Hist.",
            "name_idt": "Ptolemaeus VIII Euergetes II Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Periplus Maris Magni": {
        "tlg_id": "TLG0077",
        "names": {
            "name_authtab": "Periplus Maris Magni",
            "name_idt": "Periplus Maris Magni",
        },
        "works": {"$Stadiasmus sive periplus Maris Magni": ["Section", "line"]},
    },
    "Nonnus Epic.": {
        "tlg_id": "TLG2045",
        "names": {"name_authtab": "Nonnus Epic.", "name_idt": "Nonnus Epic."},
        "works": {
            "Epigramma": ["Book", "epigram", "line"],
            "Dionysiaca": ["Book", "line"],
            "?Paraphrasis sancti evangelii Joannei (fort. auctore Nonno alio)": [
                "Demonstratio",
                "line",
            ],
        },
    },
    "Chaerion Comic.": {
        "tlg_id": "TLG1795",
        "names": {"name_authtab": "Chaerion Comic.", "name_idt": "Chaerion Comic."},
        "works": {"Titulus": ["Fragment", "line"]},
    },
    "Leuco Comic.": {
        "tlg_id": "TLG0470",
        "names": {"name_authtab": "Leuco Comic.", "name_idt": "Leuco Comic."},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Athanasius Theol.": {
        "tlg_id": "TLG2035",
        "names": {"name_authtab": "Athanasius Theol.", "name_idt": "Athanasius Theol."},
        "works": {
            "2De fallacia diaboli (%6 Homilia in diabolum) [Sp.]": ["Section", "line"],
            "#Apologia ad Constantium imperatorem": ["Section", "line"],
            "Epistula ad Amun": ["Page", "line"],
            "'Fragmentum sermonis de imaginibus [Sp.]": ["Volume", "page", "line"],
            "&In illud: Qui dixerit verbum in filium": ["Volume", "page", "line"],
            "4De synodis Arimini in Italia et Seleuciae in Isauria": [
                "Chapter",
                "section",
                "line",
            ],
            "!Sermo contra omnes haereses [Sp.]": ["Volume", "page", "line"],
            "De corpore et anima [Sp.]": ["Volume", "page", "line"],
            "&Commentarius de templo Athenarum [Sp.]": ["Page", "line"],
            ":Epistula ad Epiphanium (fragmentum ap. Chronicon paschale)": [
                "Volume",
                "page",
                "line",
            ],
            "+Didascalia cccxviii patrum Nicaenorum [Sp.]": ["Volume", "page", "line"],
            "Expositiones in Psalmos": ["Volume", "page", "line"],
            "!Vitae monasticae institutio [Sp.]": ["Volume", "page", "line"],
            "Epistula ad Maximum": ["Volume", "page", "line"],
            "Epistula ad Epictetum": ["Section", "line"],
            "Historia Arianorum": ["Chapter", "section", "line"],
            "-Apologia contra Arianos sive Apologia secunda": [
                "Chapter",
                "section",
                "line",
            ],
            "Fragmenta varia": ["Volume", "page", "line"],
            ";De non participando divinis mysteriis sine discrimine [Sp.]": [
                "Page",
                "line",
            ],
            ",Homilia in sanctos patres et prophetas [Sp.]": ["Volume", "page", "line"],
            "4Epistula ad Marcellinum de interpretatione Psalmorum": [
                "Volume",
                "page",
                "line",
            ],
            "De decretis Nicaenae synodi": ["Chapter", "section", "line"],
            " Synopsis scripturae sacrae [Sp.]": ["Volume", "page", "line"],
            "$Epistula ad episcopum Persarum [Sp.]": ["Volume", "page", "line"],
            "$Quaestiones ad Antiochum ducem [Sp.]": ["Volume", "page", "line"],
            "Argumentum in Psalmos [Sp.]": ["Volume", "page", "line"],
            "'Epistula ad episcopos Aegypti et Libyae": ["Volume", "page", "line"],
            "Epistula catholica [Sp.]": ["Volume", "page", "line"],
            "Quaestiones aliae [Sp.]": ["Page", "line"],
            "Vita sanctae Syncleticae [Sp.]": ["Volume", "page", "line"],
            "!Doctrina ad Antiochum ducem [Sp.]": ["Chapter", "section", "line"],
            '"De sabbatis et circumcisione [Sp.]': ["Volume", "page", "line"],
            "Epistula ad monachos": ["Section", "line"],
            ")Homilia in illud: Euntem autem illo [Sp.]": [
                "Chapter",
                "section",
                "line",
            ],
            " Epistulae quattuor ad Serapionem": ["Volume", "page", "line"],
            "Petitiones Arianorum": ["Volume", "page", "line"],
            "De incarnatione verbi": ["Chapter", "section", "line"],
            ">Commentarius de templo Athenarum (cod. Bodleianus Roe 5) [Sp.]": [
                "Folio",
                "line",
            ],
            "IQuaestio 136 e quaestionibus ad Antiochum ducem (e cod. Paris. 635) [Sp.]": [
                "line"
            ],
            "8Homilia in illud: Nunc anima mea turbata est (fragmenta)": [
                "Volume",
                "page",
                "line",
            ],
            "Epistula ad Afros episcopos": ["Volume", "page", "line"],
            '"De morbo et valetudine (fragmenta)': ["Page", "line"],
            "!In nativitatem praecursoris [Sp.]": ["Volume", "page", "line"],
            "2De incarnatione contra Apollinarium libri ii [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "-Narratio de cruce seu imagine Berytensi [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "=In illud: Profecti in pagum invenietis pullum alligatum [Sp.]": [
                "Chapter",
                "section",
                "line",
            ],
            "6Sermo major (collatio cod. Laurentiani gr. 4.23) [Sp.]": [
                "Fragment",
                "line",
            ],
            "Apologia de fuga sua": ["Section", "line"],
            "Historia de Melchisedech [Sp.]": ["Volume", "page", "line"],
            "De azymis [Sp.]": ["Volume", "page", "line"],
            "&Sermo in annuntiationem deiparae [Sp.]": ["Volume", "page", "line"],
            "Homilia de semente [Sp.]": ["Volume", "page", "line"],
            ")Homilia de passione et cruce domini [Sp.]": ["Volume", "page", "line"],
            "Tomus ad Antiochenos": ["Volume", "page", "line"],
            "Epistula ad Jovianum": ["Volume", "page", "line"],
            "Contra gentes": ["Section", "line"],
            ",Sermo pro iis qui saeculo renuntiarunt [Sp.]": ["Volume", "page", "line"],
            "Sermo contra Latinos [Sp.]": ["Volume", "page", "line"],
            "6Oratio in resurrectionem et in recens baptizatos [Sp.]": [
                "Section",
                "line",
            ],
            "Epistula ad Palladium": ["Volume", "page", "line"],
            "Sermo in ramos palmarum [Sp.]": ["Chapter", "section", "line"],
            "Doctrina ad monachos [Sp.]": ["Volume", "page", "line"],
            "Scholia in cantica canticorum": ["Volume", "page", "line"],
            'Symbolum "quicumque" [Sp.]': ["Volume", "page", "line"],
            "0Syntagma ad monachos (e cod. Vat. gr. 733) [Sp.]": ["Page", "line"],
            '"Sermo in nativitatem Christi [Sp.]': ["Volume", "page", "line"],
            "De virginitate [Sp.]": ["Section", "line"],
            "Epistula encyclica": ["Chapter", "section", "line"],
            "$Dialogus Athanasii et Zacchaei [Sp.]": ["Section", "line"],
            "Sermo ad Antiochum ducem [Sp.]": ["Volume", "page", "line"],
            "$Sermo de descriptione deiparae [Sp.]": ["Volume", "page", "line"],
            "!In illud: Omnia mihi tradita sunt": ["Volume", "page", "line"],
            ",Epistula ad Joannem et Antiochum presbyteros": ["Volume", "page", "line"],
            "Quaestiones in evangelia [Sp.]": ["Volume", "page", "line"],
            " Homilia in occursum domini [Sp.]": ["Volume", "page", "line"],
            "&Quaestiones in scripturam sacram [Sp.]": ["Volume", "page", "line"],
            "1Sermo exhortatorius [Sp.] (e cod. Paris. gr. 769)": ["Section", "line"],
            "/Homilia de jejunio et de passione Christi [Sp.]": ["Page", "line"],
            "Epistula ad Dracontium": ["Volume", "page", "line"],
            "3Scholia in Acta (fort. ex libris Contra Novatianos)": [
                "Volume",
                "page",
                "line",
            ],
            "WQuaestio 136 e quaestionibus ad Antiochum ducem (e cod. Guelferbytano-Gudiano 51) [Sp.]": [
                "line"
            ],
            '"Epistula ad Eupsychium (fragmenta)': ["Volume", "page", "line"],
            "%Dialogi duo contra Macedonianos [Sp.]": ["Volume", "page", "line"],
            "$Homilia in Canticum canticorum [Sp.]": ["Volume", "page", "line"],
            "#Scholia in Job (e cod. Vat. Pii II)": ["Page", "line"],
            "Epistulae ad Castorem [Sp.]": ["Volume", "page", "line"],
            "+De sancta trinitate (dialogi 1, 3, 5) [Sp.]": ["Volume", "page", "line"],
            "Scholia in Job": ["Volume", "page", "line"],
            "$Epistula ad Serapionem de morte Arii": ["Chapter", "section", "line"],
            "Liber de definitionibus [Sp.]": ["Volume", "page", "line"],
            "Epistula ad Adelphium": ["Volume", "page", "line"],
            "&Epistula ad imperatorem Jovianum [Sp.]": ["Volume", "page", "line"],
            "De sententia Dionysii": ["Chapter", "section", "line"],
            "1Homilia de passione et cruce domini (additamenta)": [
                "Volume",
                "page",
                "line",
            ],
            "Contra Sabellianos [Sp.]": ["Volume", "page", "line"],
            "Disputatio contra Arium [Sp.]": ["Volume", "page", "line"],
            ".Refutatio hypocriseos Meletii et Eusebii [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "Epistula ad Liberium [Sp.]": ["line"],
            "9Syntagma ad monachos (e cod. Vossiano gr., fol. 46) [Sp.]": [
                "Chapter",
                "section",
                "line",
            ],
            '"Oratio quarta contra Arianos [Sp.]': ["Section", "line"],
            "Sermo de patientia [Sp.]": ["Volume", "page", "line"],
            "Sermo major de fide [Sp.]": ["Fragment", "line"],
            "De trinitate [Sp.]": ["Volume", "page", "line"],
            "+De sancta trinitate (dialogi 2 and 4) [Sp.]": ["Volume", "page", "line"],
            "Epistula ad Rufinianum": ["Page", "line"],
            "Orationes tres contra Arianos": ["Volume", "page", "line"],
            "(Homilia in illud: Ite in castellum [Sp.]": ["Chapter", "section", "line"],
            "Vita Antonii": ["Volume", "page", "line"],
            "In caecum a nativitate [Sp.]": ["Volume", "page", "line"],
            "#Syntagma ad quendam politicum [Sp.]": ["Volume", "page", "line"],
            "UTestimonia e scriptura (de communi essentia patris et filii et spiritus sancti) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "7Quaestio cxii ad Antiochum ducem in collectione canonum": [
                "Page",
                "line",
            ],
            ";Epistula festalis xxxix (fragmentum in collectione canonum)": [
                "Page",
                "line",
            ],
        },
    },
    "Epiphanius Scr. Eccl.": {
        "tlg_id": "TLG2021",
        "names": {
            "name_authtab": "Epiphanius Scr. Eccl.",
            "name_idt": "Epiphanius Scr. Eccl.",
        },
        "works": {
            "(Fragmenta precationis et exorcismi [Sp.]": ["Volume", "page", "line"],
            "ODe xii gemmis (fragmenta ap. Anastasium Sinai+tam, Quaestiones et responsiones)": [
                "Volume",
                "page",
                "line",
            ],
            "FHomilia in Christi resurrectionem (inc. $*(O TH=S DIKAIOSU/NHS&) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            "NEpistula ad Eusebium, Marcellum, Vivianum, Carpum et ad Aegyptios (fragmentum)": [
                "Page",
                "line",
            ],
            " Testamentum ad cives (fragmenta)": ["Fragment", "line"],
            "Index apostolorum [Sp.]": ["Page", "line"],
            "1Epistula ad Joannem Hierosolymitanum (fragmentum)": ["Page", "line"],
            "'Homilia in laudes Mariae deiparae [Sp.]": ["Volume", "page", "line"],
            "&Tractatus de numerorum mysteriis [Sp.]": ["Volume", "page", "line"],
            "%Homilia in assumptionem Christi [Sp.]": ["Volume", "page", "line"],
            "Anacephalaeosis [Sp.]": ["Volume", "page", "line"],
            "HDe mensuris et ponderibus (ap. Chronicon paschale) (excerptum Graecum 7)": [
                "Volume",
                "page",
                "line",
            ],
            "/De mensuris et ponderibus (excerptum Graecum 4)": [
                "Excerpt",
                "section",
                "line",
            ],
            "4Enumeratio lxxii prophetarum et prophetissarum [Sp.]": ["Page", "line"],
            "MTestimonia ex divinis et sacris scripturis (%6 De divina inhumanatione) [Sp.]": [
                "Section",
                "subsection",
                "line",
            ],
            "Liturgia praesanctificatorum": ["Section", "line"],
            "BHomilia in Christi resurrectionem (inc. $*NU=N TO\\ PE/NQOS&) [Sp.]": [
                "Section",
                "line",
            ],
            "Nomina apostolorum [Sp.]": ["line"],
            "De fide (fragmentum) [Sp.]": ["Page", "line"],
            "1Appendices ad indices apostolorum discipulorumque": ["Page", "line"],
            "De xii gemmis": ["Chapter", "section", "line"],
            ".Apophthegmata (ap. Apophthegmata patrum) [Sp.]": [
                "Volume",
                "page",
                "line",
            ],
            ".Epistula ad Theodosium imperatorem (fragmenta)": ["Fragment", "line"],
            "/De mensuris et ponderibus (excerptum Graecum 2)": ["line"],
            "<De mensuris et ponderibus (ap. Cosmam) (excerptum Graecum 6)": [
                "Section",
                "line",
            ],
            "5Tractatus contra eos qui imagines faciunt (fragmenta)": [
                "Fragment",
                "line",
            ],
            "+Homilia in divini corporis sepulturam [Sp.]": ["Volume", "page", "line"],
            "De mensuris et ponderibus": ["line"],
            "4De prophetarum vita et obitu (recensio altera) [Sp.]": ["Page", "line"],
            ",Homilia in festo palmarum (fragmentum) [Sp.]": ["Volume", "page", "line"],
            "!Anaphora Graeca (fragmenta) [Sp.]": ["Page", "line"],
            "/De mensuris et ponderibus (excerptum Graecum 3)": ["Page", "line"],
            "De trinitate (fragmentum) [Sp.]": ["Page", "line"],
            "Index discipulorum [Sp.]": ["Page", "line"],
            "Ancoratus": ["Chapter", "section", "line"],
            "Notitiae episcopatuum [Sp.]": ["line"],
            "3De prophetarum vita et obitu (recensio prior) [Sp.]": ["Page", "line"],
            "Panarion (%6 Adversus haereses)": ["Volume", "page", "line"],
            "Homilia in festo palmarum [Sp.]": ["Volume", "page", "line"],
            "HDe mensuris et ponderibus (ap. Joannem Damascenum) (excerptum Graecum 8)": [
                "line"
            ],
            "TDe xii gemmis (fragmenta alia ap. Anastasium Sinai+tam, Quaestiones et responsiones)": [
                "Volume",
                "page",
                "line",
            ],
        },
    },
    "Sopater Comic.": {
        "tlg_id": "TLG1682",
        "names": {"name_authtab": "Sopater Comic.", "name_idt": "Sopater Comic."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Euripides II Trag.": {
        "tlg_id": "TLG1840",
        "names": {
            "name_authtab": "Euripides II Trag.",
            "name_idt": "Euripides II Trag.",
        },
        "works": {"Tituli": ["line"]},
    },
    "Stephanus Phil.": {
        "tlg_id": "TLG9019",
        "names": {"name_authtab": "Stephanus Phil.", "name_idt": "Stephanus Phil."},
        "works": {
            "5In Aristotelis librum de interpretatione commentarium": ["Page", "line"]
        },
    },
    "Theophilus Comic.": {
        "tlg_id": "TLG0512",
        "names": {"name_authtab": "Theophilus Comic.", "name_idt": "Theophilus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Gorgon Hist.": {
        "tlg_id": "TLG2357",
        "names": {"name_authtab": "Gorgon Hist.", "name_idt": "Gorgon Hist."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Heraclides Criticus Perieg.": {
        "tlg_id": "TLG1405",
        "names": {
            "name_authtab": "Heraclides Criticus Perieg.",
            "name_idt": "Heraclides Criticus Perieg.",
        },
        "works": {
            "9Descriptio Graeciae (sub auctore Dicaearcho vel Athenaeo)": [
                "Fragment",
                "section",
                "line",
            ]
        },
    },
    "Mantissa Proverbiorum": {
        "tlg_id": "TLG0200",
        "names": {
            "name_authtab": "Mantissa Proverbiorum",
            "name_idt": "Mantissa Proverbiorum",
        },
        "works": {"Mantissa proverbiorum": ["Centuria", "section", "line"]},
    },
    "Ibycus Lyr.": {
        "tlg_id": "TLG0293",
        "names": {"name_authtab": "Ibycus Lyr.", "name_idt": "Ibycus Lyr."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Scholia In Aristotelem": {
        "tlg_id": "TLG5015",
        "names": {
            "name_authtab": "Scholia In Aristotelem",
            "name_idt": "Scholia In Aristotelem",
        },
        "works": {
            "`Scholia in Aristotelis ethica Nicomachea (scholia vetera et recentiora) (e cod. Paris. gr. 1854)": [
                "Bekker page",
                "line",
            ],
            "ZScholia in Aristotelis sophisticos elenchos (scholia recentiora) (e cod. Vat. Urb. gr. 35)": [
                "Bekker page",
                "line",
                "line",
            ],
            "@Scholia in Aristotelis sophisticos elenchos (scholia recentiora)": [
                "Scholion",
                "line",
            ],
        },
    },
    "Ion Eleg.": {
        "tlg_id": "TLG1446",
        "names": {"name_authtab": "Ion Eleg.", "name_idt": "Ion Eleg."},
        "works": {
            "Fragmentum": ["Fragment", "line"],
            "Epigramma": ["Book", "epigram", "line"],
        },
    },
    "Crito Phil.": {
        "tlg_id": "TLG1292",
        "names": {"name_authtab": "Crito Phil.", "name_idt": "Crito Phil."},
        "works": {"Fragmentum": ["Page", "line"]},
    },
    "Eutropius Hist.": {
        "tlg_id": "TLG2236",
        "names": {"name_authtab": "Eutropius Hist.", "name_idt": "Eutropius Hist."},
        "works": {
            "/Breviarium ab urbe condita (Paeanii translatio)": [
                "Book",
                "chapter",
                "line",
                "\x14\x17\x8e\x0e",
                "\x14\x17",
            ]
        },
    },
    "Theophilus Protospatharius Med.": {
        "tlg_id": "TLG0729",
        "names": {
            "name_authtab": "Theophilus Protospatharius Med.",
            "name_idt": "Theophilus Protospatharius Med.",
        },
        "works": {
            "De pulsibus": ["Page", "line"],
            "De excrementis": ["Chapter", "section", "line"],
            "(De corporis humani fabrica libri quinque": ["Book", "section", "line"],
            "De urinis": ["Chapter", "section", "line"],
        },
    },
    "Theon Math.": {
        "tlg_id": "TLG2033",
        "names": {"name_authtab": "Theon Math.", "name_idt": "Theon Math."},
        "works": {
            "8$*EI)S TOU\\S PROXEI/ROUS KANO/NAS &(commentarium parvum)": [
                "Page",
                "line",
            ],
            "3Commentaria in Ptolemaei syntaxin mathematicam i-iv": ["Page", "line"],
            "Testimonia": ["line", "fragment", "line"],
            "[$*(UPO/MNHMA EI)S TOU\\S PROXEI/ROUS *PTOLEMAI/OU KANO/NAS &(commentarium magnum) (lib. 1-3)": [
                "ST number",
                "page",
                "line",
            ],
            "Epigrammata": ["Book", "epigram", "line"],
        },
    },
    "Elegiaca Adespota (CA)": {
        "tlg_id": "TLG0231",
        "names": {
            "name_authtab": "Elegiaca Adespota (CA)",
            "name_idt": "Elegiaca Adespota (CA)",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Cleostratus Poet. Phil.": {
        "tlg_id": "TLG1275",
        "names": {
            "name_authtab": "Cleostratus Poet. Phil.",
            "name_idt": "Cleostratus Poet. Phil.",
        },
        "works": {
            "Fragmenta": ["Fragment", "line"],
            "Astrologia (fragmentum)": ["Fragment", "line"],
            "Testimonia": ["Fragment", "line"],
        },
    },
    "Daphitas Gramm. vel Soph.": {
        "tlg_id": "TLG2615",
        "names": {
            "name_authtab": "Daphitas Gramm. vel Soph.",
            "name_idt": "Daphitas Gramm. vel Soph.",
        },
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Anacreontea": {
        "tlg_id": "TLG4150",
        "names": {"name_authtab": "Anacreontea", "name_idt": "Anacreontea"},
        "works": {"Anacreontea": ["Fragment", "line"]},
    },
    "Adamantius Theol.": {
        "tlg_id": "TLG2950",
        "names": {"name_authtab": "Adamantius Theol.", "name_idt": "Adamantius Theol."},
        "works": {
            ":De recta in deum fide (olim sub auctore Origene Adamantio)": [
                "Page",
                "line",
            ]
        },
    },
    "Damoxenus Comic.": {
        "tlg_id": "TLG0438",
        "names": {"name_authtab": "Damoxenus Comic.", "name_idt": "Damoxenus Comic."},
        "works": {"Fragmenta": ["Play", "fragment", "line"]},
    },
    "Eusebius Phil.": {
        "tlg_id": "TLG2640",
        "names": {"name_authtab": "Eusebius Phil.", "name_idt": "Eusebius Phil."},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Demetrius Poeta": {
        "tlg_id": "TLG2617",
        "names": {"name_authtab": "Demetrius Poeta", "name_idt": "Demetrius Poeta"},
        "works": {"Fragmentum": ["Fragment", "line"]},
    },
    "Phoebammon Soph.": {
        "tlg_id": "TLG2596",
        "names": {"name_authtab": "Phoebammon Soph.", "name_idt": "Phoebammon Soph."},
        "works": {
            "+De figuris (fort. auctore Phoebammone alio)": [
                "Chapter",
                "section",
                "line",
            ]
        },
    },
    "Dorieus Poeta": {
        "tlg_id": "TLG2622",
        "names": {"name_authtab": "Dorieus Poeta", "name_idt": "Dorieus Poeta"},
        "works": {"Epigramma": ["Fragment", "line"]},
    },
    "Antonius Hagiographus Scr. Eccl.": {
        "tlg_id": "TLG2807",
        "names": {
            "name_authtab": "Antonius Hagiographus Scr. Eccl.",
            "name_idt": "Antonius Hagiographus Scr. Eccl.",
        },
        "works": {"Vita Symeonis Stylitae senioris": ["Section", "line"]},
    },
    "Suda": {
        "tlg_id": "TLG9010",
        "names": {"name_authtab": "Suda, Suidas", "name_idt": "Suda"},
        "works": {
            "Lexicon": ["", "Alphabetic letter", "entry", "line"],
            "Onomasticon tacticon": ["Section", "line"],
        },
    },
    "Claudius Iolaus Hist.": {
        "tlg_id": "TLG1268",
        "names": {
            "name_authtab": "Claudius Iolaus Hist.",
            "name_idt": "Claudius Iolaus Hist.",
        },
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Demetrius Rhet.": {
        "tlg_id": "TLG0613",
        "names": {"name_authtab": "Demetrius Rhet.", "name_idt": "Demetrius Rhet."},
        "works": {"De elocutione": ["Section", "line"]},
    },
    "Cleomachus Poeta": {
        "tlg_id": "TLG2614",
        "names": {"name_authtab": "Cleomachus Poeta", "name_idt": "Cleomachus Poeta"},
        "works": {"Fragmenta": ["Fragment", "line"]},
    },
    "Apollonius Scr. Eccl.": {
        "tlg_id": "TLG1171",
        "names": {
            "name_authtab": "Apollonius Scr. Eccl.",
            "name_idt": "Apoll