import pandas as pd
import csv
from datetime import datetime
from pathlib import Path
from colored import Fore,Style,Back
from barcode import Code39,UPCA,EAN8,EAN13
import barcode,qrcode,os,sys,argparse
from datetime import datetime,timedelta
import zipfile,tarfile
import base64,json
from ast import literal_eval
import sqlalchemy
from sqlalchemy import *
from sqlalchemy.orm import *
from sqlalchemy.ext.declarative import declarative_base as dbase
from sqlalchemy.ext.automap import automap_base
from pathlib import Path
import upcean
from radboy.ExtractPkg.ExtractPkg2 import *
from radboy.Lookup.Lookup import *
from radboy.DayLog.DayLogger import *
from radboy.DB.db import *
from radboy.DB.Prompt import *
from radboy.DB.SMLabelImporter import *
from radboy.DB.ResetTools import *

from radboy.ConvertCode.ConvertCode import *
from radboy.setCode.setCode import *
from radboy.Locator.Locator import *
from radboy.ListMode2.ListMode2 import *
from radboy.TasksMode.Tasks import *
from radboy.ExportList.ExportListCurrent import *
from radboy.TouchStampC.TouchStampC import *
from radboy.EntryExtras.Extras import *
from radboy import VERSION
import radboy.possibleCode as pc
from radboy.Unified.clearalll import *
from dataclasses import dataclass
def format_bytes(size):
    """
    Auto-convert bytes to a human-readable format.

    this was generated by Google's AI Console.
    """
    power = 2**10
    n = 0
    power_labels = {0 : '', 1: 'K', 2: 'M', 3: 'G', 4: 'T'}
    while size > power:
        size /= power
        n += 1
    return f"{size:.2f} {power_labels[n]}B"
@dataclass
class BACKUP:
    def daemon(self,limit=None):
        bus=[]
        backup_dir=Path(detectGetOrSet("Backup Directory",f"RadBoy Backups/{VERSION}",setValue=False,literal=True))
        now=datetime.now()
        if limit is None:
            limit=timedelta(days=-7)
        for root,dirs,fnames in backup_dir.walk(top_down=True):
            for file in fnames:
                fx=root/Path(file)
                #print(f"{Fore.dark_goldenrod}Checking for age limited backups to delete({fx} >= {limit})){Style.reset}")
                ctime=datetime.fromtimestamp(fx.stat().st_ctime)
                age=ctime-now
                
                if age >= limit:
                    bus.append(fx)
        if len(bus) <= 0:
            print(f"{Fore.orange_red_1}A Backup needs to be made!{Style.reset}")
            __class__(dtbf=True)
                    
    def __init__(self,dtbf=False):
        self.backup_dir=Path(detectGetOrSet("Backup Directory",f"RadBoy Backups/{VERSION}",setValue=False,literal=True))
        self.limit=timedelta(days=-90)
        limit=self.limit
        self.now=datetime.now()

        #check for older than 6-months
        for root,dirs,fnames in self.backup_dir.walk(top_down=True):
            cta=len(fnames)
            for num,file in enumerate(fnames):
                fx=root/Path(file)
                ctime=datetime.fromtimestamp(fx.stat().st_ctime)
                age=ctime-self.now
                print(std_colorize(f"{Fore.light_magenta}Checking for age limited backups to delete ({fx} AGE({age}) <= {limit}){Style.reset}",num,cta))
                
                
                if age <= limit:
                    print(f"{Fore.light_red}Deleting {Fore.light_steel_blue}{fx}{Fore.light_red} because it is {Fore.spring_green_3b}{age}{Fore.light_red}, which is >= {Fore.light_yellow}{limit}{Style.reset}")
                    fx.unlink()

        self.backup(dtbf=dtbf)






    def backup(self,dtbf=False):
        backup_dir=self.backup_dir
        if backup_dir == None:
            backup_dir=Path('.')
        else:
            backup_dir=Path(backup_dir)
            if not backup_dir.exists():
                backup_dir.mkdir(parents=True)
        startTime=datetime.now()
        self.startTime=startTime
        print(f"{Fore.orange_red_1}Backing {Fore.light_yellow}Files {Fore.light_green}up!{Style.reset}")
        backup=''
        while True:
            try:
                def mkBool(text,data):
                    try:
                        if text.lower() in ['','true','y','yes','1']:
                            return True
                        elif text.lower() in ['n','false','no','0']:
                            return False
                        else:
                            return bool(eval(text))
                    except Exception as e:
                        print(e)
                        return False
                if not dtbf:
                    date_file=Prompt.__init2__(None,func=mkBool,ptext="Date and Time restore File?",helpText="y/n?",data=self)
                    if date_file in [None,]:
                        return True
                    elif isinstance(date_file,bool):
                        if date_file:
                            d=datetime.now().strftime("%m-%d-%Y-%H-%M-%S")
                            backup=backup_dir/Path(f"codesAndBarcodes-{d}.tgz")
                        else:
                            backup=backup_dir/Path(f"codesAndBarcodes.tgz")
                    else:
                        backup=backup_dir/Path(f"codesAndBarcodes-{d}.tgz")
                else:
                    d=datetime.now().strftime("%m-%d-%Y-%H-%M-%S")
                    backup=backup_dir/Path(f"codesAndBarcodes-{d}.tgz")
                break
            except Exception as e:
                print(e)
                return True
        if backup.exists():
            backup.unlink()

        with tarfile.open(backup,"w:gz") as gzf:
            #gzf.add("codesAndBarcodes.db")
            #gzf.add("Images")
            #gzf.add("LCL_IMG")
            with open("Run.py","wb") as runner:
                lines=f'''#!/usr/bin/env python3
from pathlib import Path
ROOTDIR=str(Path().cwd())
from radboy import RecordMyCodes as rmc
rmc.quikRn(rootdir=ROOTDIR)'''.encode()
                runner.write(lines)
            '''
            try:
                print("adding module...")
                m=Path("module")
                if m.exists():
                    shutil.rmtree(m)
                    m.mkdir()
                else:
                    m.mkdir()
                os.system(f"pip download MobileInventoryCLI=={VERSION} -d {m}")
                gzf.add(m)
                print("added module code!")
            except Exception as e:
                print("could not finish adding modules/")
            '''
            #shutil.rmtree(m)
            print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{Path('Run.py')}{Style.reset}")
            gzf.add("Run.py")
            
            while True:
                try:
                    def mkBool(text,self):
                        if text.lower() in ['','n','no','-']:
                            return False
                        elif text.lower() in ['y','yes','+']:
                            return True
                        else:
                            try:
                                return bool(eval(text))
                            except Exception as e:
                                print(e)
                                return False
                    if not dtbf:
                        rmRunner=Prompt.__init2__(None,func=mkBool,ptext="Delete 'Run.py'",helpText="default == 'No'",data=self)
                        if rmRunner:
                            Path("Run.py").unlink()
                    else:
                        pass
                    break
                except Exception as e:
                    print(e)

            with open("version.txt","w+") as version_txt:
                version_txt.write(VERSION)

            if Path("version.txt").exists():
                print(f'{Fore.spring_green_3b}Adding {Fore.green_yellow}{Path("version.txt")}{Style.reset}')
                gzf.add("version.txt")
                Path("version.txt").unlink()

            api_key_file=Path("./api_key")
            if api_key_file.exists():
                print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{api_key_file}{Style.reset}")
                gzf.add(api_key_file)

            msg=f'''
        {Fore.orange_red_1}Getting system settings files, testing for existance, if not found leaving alone!!!{Style.reset}
            '''
            print(msg)
            #from ExportUtility/ExportTableClass.py
            import_odf=detectGetOrSet("ImportODF",value="ImportExcel.xlsx.ods",literal=True)
            if import_odf:
                import_odf=Path(import_odf)
                if import_odf.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{import_odf}{Style.reset}")
                    gzf.add(import_odf)
            
            import_excel=detectGetOrSet("ImportExcel",value="ImportExcel.xlsx",literal=True)
            if import_excel:
                import_excel=Path(import_excel)
                if import_excel.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{import_excel}{Style.reset}")
                    gzf.add(import_excel)

            export_folder=Path(detectGetOrSet("ExportTablesFolder",value="ExportedTables",literal=True))
            if export_folder:
                export_folder=Path(export_folder)
                if export_folder.exists() and export_folder.is_dir():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{export_folder}{Style.reset}")
                    gzf.add(export_folder)

            defFile=db.detectGetOrSet("currency_definitions_file","currency_definitions.txt",setValue=False,literal=True)
            if defFile:
                defFile=Path(defFile)
                if defFile.exists() and defFile.is_file():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{defFile}{Style.reset}")
                    gzf.add(defFile)

            bootable="__bootable__.py"
            if bootable:
                bootable=Path(bootable)
                if bootable.exists() and bootable.is_file():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{bootable}{Style.reset}")
                    gzf.add(bootable)

            pay_ws=Path("EstimatedPayCalendarWorkSheet.txt")
            pay_ws=Path(detectGetOrSet("EstimatedPayCalendarExportFile",pay_ws,setValue=False,literal=True))
            if pay_ws:
                if pay_ws.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{pay_ws}{Style.reset}")
                    gzf.add(pay_ws)

            combinations_receipt=Path(detectGetOrSet("combinations_receipt","combos.json.csv",setValue=False,literal=True))
            if combinations_receipt:
                if combinations_receipt.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{combinations_receipt}{Style.reset}")
                    gzf.add(combinations_receipt)

            WebArchiveStore_folder=Path(detectGetOrSet("WebArchiveDownloadsFilePath","WebArchiveDownloads",literal=True))
            if WebArchiveStore_folder:
                WebArchiveStore_folder=Path(WebArchiveStore_folder)
                if WebArchiveStore_folder.exists() and WebArchiveStore_folder.is_dir():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{WebArchiveStore_folder}{Style.reset}")
                    gzf.add(WebArchiveStore_folder)
            #from DB/Prompt.py
            scanout=detectGetOrSet('CMD_TO_FILE',str(Path('./SCANNER.TXT')))
            if scanout:
                scanout=Path(scanout)
                if scanout.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{scanout}{Style.reset}")
                    gzf.add(scanout)

            #from TouchStampC/TouchStampC.py
            ts_outfile=detectGetOrSet("TouchStampSearchExport",value="TS_NOTE.txt",literal=True)
            if ts_outfile:
                ts_outfile=Path(ts_outfile)
                if ts_outfile.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{ts_outfile}{Style.reset}")
                    gzf.add(ts_outfile)

            #from Roster/Roster.py
            src_t="Downloads/Roster.xlsx"
            lcl_e_src=detectGetOrSet("localEXCEL",src_t,literal=True,setValue=False)
            if lcl_e_src:
                lcl_e_src=Path(lcl_e_src)
                if lcl_e_src.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{lcl_e_src}{Style.reset}")
                    gzf.add(lcl_e_src)
            #from TasksMode/Tasks.py
            bcd_final_out=detectGetOrSet("IMG_GEN_OUT_QR","GENERATED_QR.png",literal=True)
            if bcd_final_out:
                bcd_final_out=Path(bcd_final_out)
                if bcd_final_out.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{bcd_final_out}{Style.reset}")
                    gzf.add(bcd_final_out)

            qr_final_out=detectGetOrSet("IMG_GEN_OUT","GENERATED_BCD",literal=True)
            if qr_final_out:
                qr_final_out=Path(qr_final_out+".png")
                if qr_final_out.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{qr_final_out}{Style.reset}")
                    gzf.add(qr_final_out)


            EMSGFILE=detectGetOrSet("OBFUSCATED MSG FILE","MSG.txt",literal=True)
            if EMSGFILE:
                EMSGFILE=Path(EMSGFILE)
                if EMSGFILE.exists():
                   print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{EMSGFILE}{Style.reset}") 
                   gzf.add(EMSGFILE)
                   
            dbf=Path("codesAndBarcodes.db")
            if dbf.exists():
                print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{dbf}{Style.reset}")
                gzf.add(dbf)

            password_file=Path('Password.txt')
            if password_file:
                password_file=Path(password_file)
                if password_file.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{password_file}{Style.reset}")
                    gzf.add(password_file)

            bld_list=Path('BLD.txt')
            if bld_list:
                bld_list=Path(bld_list)
                if bld_list.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{bld_list}{Style.reset}")
                    gzf.add(bld_list)

            EntryTXT=Path('EntryTXT.txt')
            if EntryTXT:
                EntryTXT=Path(EntryTXT)
                if EntryTXT.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{EntryTXT}{Style.reset}")
                    gzf.add(EntryTXT)
            
            ExtraTXT=Path('ExtraTXT.txt')
            if ExtraTXT:
                ExtraTXT=Path(ExtraTXT)
                if ExtraTXT.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{ExtraTXT}{Style.reset}")
                    gzf.add(ExtraTXT)

            extra_drugs=detectGetOrSet("extra_drugs","extra_drugs.csv",setValue=False,literal=True)
            if extra_drugs:
                extra_drugs=Path(extra_drugs)
                if extra_drugs.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{extra_drugs}{Style.reset}")
                    gzf.add(extra_drugs)

            generated_string=Path('GeneratedString.txt')
            if generated_string:
                generated_string=Path(generated_string)
                if generated_string.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{generated_string}{Style.reset}")
                    gzf.add(generated_string)
            
            holidays_file=Path('Holidays.txt')
            if holidays_file:
                holidays_file=Path(holidays_file)
                if holidays_file.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{holidays_file}{Style.reset}")
                    gzf.add(holidays_file)

            cost_report_xlsx_file=Path(detectGetOrSet("xlsx_cr_export","cost_report.xlsx",setValue=False,literal=True))
            if cost_report_xlsx_file:
                cost_report_xlsx_file=Path(cost_report_xlsx_file)
                if cost_report_xlsx_file.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{cost_report_xlsx_file}{Style.reset}")
                    gzf.add(cost_report_xlsx_file)

            cost_report_txt_file=Path(detectGetOrSet("text_cr_export","cost_report.txt",setValue=False,literal=True))
            if cost_report_txt_file:
                cost_report_txt_file=Path(cost_report_txt_file)
                if cost_report_txt_file.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{cost_report_txt_file}{Style.reset}")
                    gzf.add(cost_report_txt_file)

            bootable_directory=Path("RadBoy_Boot_Directory")
            if bootable_directory.exists():
                print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{bootable_directory}{Style.reset}")
                gzf.add(bootable_directory)

            try:
                recieptidFile=Path(detectGetOrSet("NanoIdFile","nanoid.txt",setValue=False,literal=True))
                if recieptidFile.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{recieptidFile}{Style.reset}")
                    gzf.add(recieptidFile)
            except Exception as e:
                print(e)
                pass
            try:
                recieptidFile=Path(detectGetOrSet("RecieptIdFile","reciept_id.txt",setValue=False,literal=True))
                if recieptidFile.exists():
                    print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{recieptidFile}{Style.reset}")
                    gzf.add(recieptidFile)
            except Exception as e:
                print(e)
                pass

            receiptsDirectory=detectGetOrSet("ReceiptsDirectory","Receipts",setValue=False,literal=True)
            if receiptsDirectory:
                receiptsDirectory=Path(receiptsDirectory)
                if not receiptsDirectory.exists():
                    receiptsDirectory.mkdir(parents=True)
                print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{receiptsDirectory}{Style.reset}")
                gzf.add(receiptsDirectory)

            with Session(ENGINE) as session:
                files=session.query(SystemPreference).filter(SystemPreference.name.icontains('ClipBoordImport_')).all()
                for num,i in enumerate(files):
                    #print(num,json.loads(i.value_4_Json2DictString)[i.name],"Being Added from SystemPreference!")
                    try:
                        print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{json.loads(i.value_4_Json2DictString)[i.name]}{Style.reset}")
                        gzf.add(json.loads(i.value_4_Json2DictString)[i.name])
                    except Exception as e:
                        print(e,"couldn't not add!")

            imd=Path("Images")
            if imd.exists():
                print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{imd}{Style.reset}")
                gzf.add(imd)
            lclimg=Path("LCL_IMG")
            if lclimg.exists():
                print(f"{Fore.spring_green_3b}Adding {Fore.green_yellow}{lclimg}{Style.reset}")
                gzf.add(lclimg)
            
        print(backup.absolute())

        endTime=datetime.now()
        msg=f'''{Fore.light_red}{backup}{Fore.light_steel_blue} Took {Fore.green_yellow}{endTime-startTime}{Fore.light_steel_blue} to backup'''
        print(msg)
        msg2=f"{Fore.orange_red_1}{format_bytes(os.stat(backup.absolute()).st_size)}{Fore.light_steel_blue} of Data, on {Fore.spring_green_3b}{datetime.fromtimestamp(os.stat(backup.absolute()).st_ctime)}{Style.reset}"
        print(msg2)
        return True