DROP TABLE IF EXISTS transientBucket;
CREATE TABLE `transientBucket` (
  `primaryKeyId` bigint(20) NOT NULL AUTO_INCREMENT COMMENT 'The primary key for this table',
  `transientBucketId` bigint(20) NOT NULL COMMENT 'This is set to the primaryKeyId of the **first** entry of this object into the database (i.e. earliest dateCreated)',
  `masterIDFlag` int(11) NOT NULL DEFAULT '0' COMMENT 'If this flag is set (=1) then the transient is assigned this name as it''s master ID. If not set (=0) then there is another entry in this table where the master ID has been set.',
  `name` varchar(40) NOT NULL COMMENT 'the name of the transient given by the reporting survey.',
  `survey` varchar(45) NOT NULL COMMENT 'the survey reporting observation of this transient',
  `raDeg` double DEFAULT NULL COMMENT 'RA is decimal degreed',
  `decDeg` double DEFAULT NULL COMMENT 'DEC in decimal degrees',
  `raDegErr` double DEFAULT NULL,
  `decDegErr` double DEFAULT NULL,
  `observationDate` datetime DEFAULT NULL COMMENT 'the survey observation date',
  `observationMJD` double NOT NULL COMMENT 'the survey observation MJD',
  `magnitude` float DEFAULT NULL COMMENT 'the survey discovery magnitude',
  `magnitudeError` float DEFAULT NULL,
  `filter` varchar(20) DEFAULT NULL COMMENT 'survey discovery filter',
  `transientRedshift` float DEFAULT NULL COMMENT 'redshift as measured from a spectrum of the transient',
  `transientRedshiftNotes` varchar(40) DEFAULT NULL COMMENT 'transient redshift notes',
  `spectralType` varchar(100) DEFAULT NULL COMMENT 'the spectral classification given by the reporting survey (if any)',
  `discoveryPhase` varchar(20) DEFAULT NULL COMMENT 'the discovery phase given by the reporting survey (if any)',
  `dateCreated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `dateLastModified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `surveyObjectUrl` varchar(200) DEFAULT NULL COMMENT 'the url for dedicated webpage of transients supplied by the reporting survey (if any)',
  `transientTypePrediction` varchar(40) DEFAULT NULL COMMENT 'an attempt at predicting the transient type by the reporting survey.',
  `transientTypePredicationSource` varchar(40) DEFAULT NULL COMMENT 'the name of the source/catalogue that was used to predict the transient type',
  `hostRedshift` float DEFAULT NULL COMMENT 'redshift measure for the host',
  `hostRedshiftType` varchar(10) DEFAULT NULL COMMENT 'type of redshift measure for the host galaxy\n',
  `referenceImageUrl` varchar(500) DEFAULT NULL COMMENT 'true or false',
  `targetImageUrl` varchar(500) DEFAULT NULL COMMENT 'true or false',
  `subtractedImageUrl` varchar(500) DEFAULT NULL,
  `tripletImageUrl` varchar(500) DEFAULT NULL,
  `htm20ID` bigint(20) unsigned DEFAULT NULL COMMENT 'HTM Level 20',
  `htm16ID` bigint(20) unsigned DEFAULT NULL COMMENT 'HTM Level 16',
  `cx` double DEFAULT NULL COMMENT 'Cartesian coordinate x',
  `cy` double DEFAULT NULL COMMENT 'Cartesian coordinate y',
  `cz` double DEFAULT NULL COMMENT 'Cartesian coordinate z',
  `telescope` varchar(100) DEFAULT NULL,
  `instrument` varchar(100) DEFAULT NULL,
  `reducer` varchar(100) DEFAULT NULL,
  `lastNonDetectionDate` datetime DEFAULT NULL,
  `lastNonDetectionMJD` double DEFAULT NULL,
  `dateLastRead` datetime DEFAULT NULL,
  `finderImageUrl` varchar(450) DEFAULT NULL,
  `lightcurveURL` varchar(450) DEFAULT NULL,
  `classificationWRTMax` varchar(45) DEFAULT NULL,
  `classificationPhase` int(11) DEFAULT NULL,
  `limitingMag` tinyint(4) DEFAULT '0',
  `sherlockClassification` varchar(200) DEFAULT NULL,
  `tmpFlag` int(11) DEFAULT NULL,
  `replacedByRowId` bigint(20) DEFAULT '0',
  `dateDeleted` datetime DEFAULT NULL,
  `updated` tinyint(4) DEFAULT '0',
  `htm13ID` int(11) DEFAULT NULL,
  `htm10ID` int(11) DEFAULT NULL,
  PRIMARY KEY (`primaryKeyId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `primaryKey_UNIQUE` (`primaryKeyId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `name_observationmjd_magnitude_filter_survey` (`name`,`observationMJD`,`magnitude`,`filter`,`survey`,`replacedByRowId`) KEY_BLOCK_SIZE=1024,
  UNIQUE KEY `name_observationmjd_magnitude_filter` (`name`,`observationMJD`,`magnitude`,`filter`,`replacedByRowId`),
  UNIQUE KEY `name_survey_obsmjd_decDeg_classification` (`name`,`survey`,`decDeg`,`observationMJD`,`replacedByRowId`,`spectralType`) KEY_BLOCK_SIZE=1024,
  KEY `idx_htm20ID` (`htm20ID`) KEY_BLOCK_SIZE=1024,
  KEY `idx_htm16ID` (`htm16ID`) KEY_BLOCK_SIZE=1024,
  KEY `idx_name` (`name`) KEY_BLOCK_SIZE=1024,
  KEY `tbi` (`transientBucketId`),
  KEY `masterflag` (`masterIDFlag`),
  KEY `name` (`name`),
  KEY `idx_htm10ID` (`htm13ID`),
  KEY `idx_htm13ID` (`htm13ID`),
  KEY `i_htm10ID` (`htm10ID`),
  KEY `i_htm13ID` (`htm13ID`),
  KEY `i_htm16ID` (`htm16ID`)
) ENGINE=InnoDB AUTO_INCREMENT=0 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPRESSED KEY_BLOCK_SIZE=8;



INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1164032,1438424,1,'AT2016evq','bright sn list',300.571166667,56.3843055556,NULL,NULL,'2016-07-29 10:10:33',57598.4239931,17.6,NULL,NULL,NULL,NULL,NULL,NULL,'2016-08-10 15:26:39','2016-08-10 15:26:39','http://www.rochesterastronomy.org/supernova.html#2016evq','SN',NULL,NULL,NULL,NULL,NULL,NULL,NULL,13571633086217,53014191743,0.281575506881,-0.476665486759,0.832769624601,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,828346745,12942917);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1238895,1661424,1,'SN2016eob','iPTF',0.779666666667,-1.91169444444,NULL,NULL,'2016-08-28 06:28:59',57628.2701273,16.53,NULL,'Clear-',0.024,NULL,'II',NULL,'2016-09-12 07:22:33','2016-09-12 07:22:33','http://wis-tns.weizmann.ac.il/object/2016eob',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8796476101444,34361234771,0.999350895457,0.0135997569854,-0.0333591720416,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,536894293,8388973);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1420704,1420021,1,'AT2016gva','Pan-STARRS1',24.0809583333,2.54296666667,NULL,NULL,'2016-09-30 11:35:31',57661.4829977,20.94,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-03 19:24:19','2016-10-03 19:24:19','http://wis-tns.weizmann.ac.il/object/2016gva',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17149176996428,66988972642,0.912070766032,0.40762525394,0.0443685710841,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046702697,16354729);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1420705,1420027,1,'AT2016gvb','Pan-STARRS1',35.6257916667,15.6397194444,NULL,NULL,'2016-09-30 13:50:52',57661.5769907,20.1,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-03 19:24:20','2016-10-03 19:24:20','http://wis-tns.weizmann.ac.il/object/2016gvb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17428301014470,68079300837,0.78274402607,0.560922805994,0.269587454025,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1063739075,16620923);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1428023,1428023,1,'AT2016gvf','PTSS',46.2516666667,2.21154722222,NULL,NULL,'2016-10-03 18:40:07',57664.7778588,18.7,NULL,'r-Sloan',NULL,NULL,NULL,NULL,'2016-10-04 06:25:19','2016-10-04 06:25:19','http://wis-tns.weizmann.ac.il/object/2016gvf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17386454610037,67915838320,0.69097699153,0.721846016174,0.0385891968041,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1061184973,16581015);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1428025,1428025,1,'AT2016gvh','PTSS',27.140125,7.88881944444,NULL,NULL,'2016-10-03 17:34:26',57664.7322454,19,NULL,'r-Sloan',NULL,NULL,NULL,NULL,'2016-10-04 06:25:20','2016-10-04 06:25:20','http://wis-tns.weizmann.ac.il/object/2016gvh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17156727969208,67018468629,0.881471845273,0.451851168199,0.137251257874,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1047163572,16361930);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1429493,1429493,1,'SMT16aaaq','skymapper',5.188444,-30.58364,NULL,NULL,'2016-10-01 10:00:29',57662.417,19.89,0.08,'r',NULL,NULL,NULL,NULL,'2016-10-04 09:21:51','2016-10-04 09:21:51','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ00204523-3035011','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00204523-3035011/SMTJ00204523-3035011_sub20160928_162437_1939_r_0893422089_2016-10-01T19:58:31_32_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00204523-3035011/SMTJ00204523-3035011_sub20160928_162437_1939_r_0893422089_2016-10-01T19:58:31_32_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00204523-3035011/SMTJ00204523-3035011_sub20160928_162437_1939_r_0893422089_2016-10-01T19:58:31_32_diff.png',NULL,8923252573616,34856455365,0.857359991691,0.0778515214543,-0.508795622283,NULL,NULL,NULL,NULL,57650.716,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,544632115,8509876);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1429494,1429494,1,'SMT16aahr','skymapper',349.32832,-5.40649,NULL,NULL,'2016-10-01 10:58:05',57662.457,19.32,0.06,'r',NULL,NULL,NULL,NULL,'2016-10-04 09:21:51','2016-10-04 09:21:51','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ23171880-0524234','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23171880-0524234/SMTJ23171880-0524234_sub20160928_162437_0461_r_0893393955_2016-10-01T20:55:02_29_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23171880-0524234/SMTJ23171880-0524234_sub20160928_162437_0461_r_0893393955_2016-10-01T20:55:02_29_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23171880-0524234/SMTJ23171880-0524234_sub20160928_162437_0461_r_0893393955_2016-10-01T20:55:02_29_diff.png',NULL,12705705446511,49631661900,0.978332688437,-0.18435709497,-0.0942210818784,NULL,NULL,NULL,NULL,57650.655,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,775494717,12117104);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1429496,1429496,1,'SMT16abgg','skymapper',343.465048,-12.08766,NULL,NULL,'2016-10-01 10:03:22',57662.419,19.61,0.08,'g',NULL,NULL,NULL,NULL,'2016-10-04 09:21:51','2016-10-04 09:21:51','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ22535161-1205156','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22535161-1205156/SMTJ22535161-1205156_sub20160928_162437_0918_g_0893401098_2016-10-01T20:00:57_18_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22535161-1205156/SMTJ22535161-1205156_sub20160928_162437_0918_g_0893401098_2016-10-01T20:00:57_18_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22535161-1205156/SMTJ22535161-1205156_sub20160928_162437_0918_g_0893401098_2016-10-01T20:00:57_18_diff.png',NULL,12903299061647,50403511959,0.937391539049,-0.278290145181,-0.209407969319,NULL,NULL,NULL,NULL,57656.699,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,787554874,12305544);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1429497,1429497,1,'SMT16abgq','skymapper',343.710163,-16.17322,NULL,NULL,'2016-09-29 11:32:38',57660.481,19.3,0.08,'r',NULL,NULL,NULL,NULL,'2016-10-04 09:21:52','2016-10-04 09:21:52','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ22545044-1610236','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22545044-1610236/SMTJ22545044-1610236_sub20160928_162437_1069_r_0893399051_2016-09-29T21:31:07_08_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22545044-1610236/SMTJ22545044-1610236_sub20160928_162437_1069_r_0893399051_2016-09-29T21:31:07_08_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22545044-1610236/SMTJ22545044-1610236_sub20160928_162437_1069_r_0893399051_2016-09-29T21:31:07_08_diff.png',NULL,12919242755615,50465792014,0.921867818785,-0.269395523256,-0.278542235106,NULL,NULL,NULL,NULL,57650.539,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,788528000,12320750);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1429499,1429499,1,'SMT16zvh','skymapper',346.763193,-16.88166,NULL,NULL,'2016-10-01 11:08:10',57662.464,18.97,0.08,'i',NULL,NULL,NULL,NULL,'2016-10-04 09:21:52','2016-10-04 09:21:52','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ23070317-1652540','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23070317-1652540/SMTJ23070317-1652540_sub20160928_162437_1220_i_0893413416_2016-10-01T21:05:28_20_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23070317-1652540/SMTJ23070317-1652540_sub20160928_162437_1220_i_0893413416_2016-10-01T21:05:28_20_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23070317-1652540/SMTJ23070317-1652540_sub20160928_162437_1220_i_0893413416_2016-10-01T21:05:28_20_diff.png',NULL,12916141559382,50453677966,0.931483500948,-0.219108885011,-0.290395909012,NULL,NULL,NULL,NULL,-99,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,788338718,12317792);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1429500,1429500,1,'SMT16zyr','skymapper',0.381716,-30.31323,NULL,NULL,'2016-09-27 12:36:00',57658.525,20.28,0.1,'r',NULL,NULL,NULL,NULL,'2016-10-04 09:21:52','2016-10-04 09:21:52','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ00013161-3018476','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00013161-3018476/SMTJ00013161-3018476_sub20160928_162437_1800_r_1698820156_2016-09-27T22:35:10_08_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00013161-3018476/SMTJ00013161-3018476_sub20160928_162437_1800_r_1698820156_2016-09-27T22:35:10_08_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00013161-3018476/SMTJ00013161-3018476_sub20160928_162437_1800_r_1698820156_2016-09-27T22:35:10_08_diff.png',NULL,8905925936050,34788773187,0.863259870385,0.00575129586877,-0.504726974491,NULL,NULL,NULL,NULL,57650.678,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,543574581,8493352);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430313,1430313,1,'MASTERJ200130.53-100736.8','MASTER',300.377208333,-10.1268888889,NULL,NULL,'2016-05-16 22:39:21',57524.9439931,16.3,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:16:58','2016-10-04 11:16:58','http://observ.pereplet.ru/sn_e.html','PSN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/200130.53-100736.8.png',12299271280090,48044028437,0.497812355564,-0.849274463901,-0.175828733755,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,750687944,11729499);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430316,1430316,1,'MASTERJ164244.87+272054.3','MASTER',250.686958333,27.3484166667,NULL,NULL,'2016-05-03 01:43:40',57511.0719907,18.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:16:59','2016-10-04 11:16:59','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/164244.87272054.3.png',14395912830912,56234034495,-0.293763390714,-0.838244854134,0.459400299079,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,878656788,13729012);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430317,1430317,1,'MASTERJ051233.07-462122.7','MASTER',78.1377916667,-46.3563055556,NULL,NULL,'2016-04-27 18:34:33',57505.7739931,18.1,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:00','2016-10-04 11:17:00','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/051233.07-462122.7.png',9635482620736,37638603987,0.141870796455,0.67543284033,-0.723645738824,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,588103187,9189112);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430323,1430323,1,'MASTERJ135748.95-272623.4','MASTER',209.453958333,-27.4398333333,NULL,NULL,'2016-03-30 00:34:33',57477.0239931,17.7,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:01','2016-10-04 11:17:01','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/135748.95-272623.4.png',12029929975947,46991913968,-0.77278746125,-0.436402705783,-0.460816903033,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,734248655,11472635);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430324,1430324,1,'MASTERJ184401.22-615906.5','MASTER',281.005083333,-61.9851388889,NULL,NULL,'2016-03-23 00:23:02',57470.0159954,17.4,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:01','2016-10-04 11:17:01','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/184401.22-615906.5.png',12537833784637,48975913221,0.0896639985919,-0.461062886293,-0.882825793823,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,765248644,11957010);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430327,1430327,1,'MASTERJ163355.46+860830.4','MASTER',248.481083333,86.1417777778,NULL,NULL,'2016-02-13 21:14:23',57431.8849884,17,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:02','2016-10-04 11:17:02','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/163355.46860830.4.png',14571297854713,56919132244,-0.0246817302109,-0.0625976070741,0.997733607624,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,889361441,13896272);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430328,1430328,1,'MASTERJ083537.30-585738.0','MASTER',128.905416667,-58.9605555556,NULL,NULL,'2016-02-11 22:45:07',57429.9479977,15.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:02','2016-10-04 11:17:02','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/083537.30-585738.0.png',10377961939203,40538913825,-0.323833306788,0.401253389687,-0.856812527149,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,633420528,9897195);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430330,1430330,1,'MASTERJ032415.60+074424.6','MASTER',51.065,7.74016666667,NULL,NULL,'2015-12-17 22:26:23',57373.9349884,17.5,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:03','2016-10-04 11:17:03','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/032415.60074424.6.png',16640399140324,65001559141,0.622712657032,0.770772346106,0.134680871877,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1015649361,15869521);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430331,1430331,1,'MASTERJ002543.46+260619.4','MASTER',6.43108333333,26.1053888889,NULL,NULL,'2015-12-10 22:55:12',57366.955,18.7,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:04','2016-10-04 11:17:04','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/002543.46260619.4.png',17212356432348,67235767313,0.892335436364,0.100581674721,0.440023630865,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1050558864,16414982);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430332,1430332,1,'MASTERJ073857.06+182648.2','MASTER',114.73775,18.4467222222,NULL,NULL,'2015-12-17 00:17:16',57373.0119907,17.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:04','2016-10-04 11:17:04','http://observ.pereplet.ru/sn_e.html','DN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/073857.06182648.2.png',16163077659180,63137022106,-0.396964091498,0.861566123717,0.31642269913,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,986515970,15414312);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430338,1430338,1,'MASTERJ055250.71-395431.6','MASTER',88.2112916667,-39.9087777778,NULL,NULL,'2015-10-17 01:53:45',57312.0789931,17.9,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','SN?',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/055250.71-395431.6.png',9485317467997,37052021359,0.023943055785,0.76669310432,-0.641567154604,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,578937833,9045903);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430340,1430340,1,'MASTERJ001858.94-402211.9','MASTER',4.74558333333,-40.3699722222,NULL,NULL,'2015-10-13 20:44:09',57308.8639931,17,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/001858.94-402211.9.png',8866378280320,34634290157,0.759266065334,0.0630312127964,-0.647720702344,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,541160783,8455637);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430341,1430341,1,'MASTERJ054404.79-314655.2','MASTER',86.0199583333,-31.782,NULL,NULL,'2015-10-11 01:06:14',57306.0459954,17.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/054404.79-314655.2.png',9547226565811,37293853772,0.0590016720507,0.84800810405,-0.526688767833,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,582716465,9104944);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430342,1430342,1,'MASTERJ022011.63-531848.9','MASTER',35.0484583333,-53.3135833333,NULL,NULL,'2015-10-06 00:43:12',57301.03,18.1,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/022011.63-531848.9.png',9778514725680,38197323147,0.489100147974,0.343088449754,-0.801917303029,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,596833174,9325518);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430343,1430343,1,'MASTERJ041227.87+342902.0','MASTER',63.116125,34.4838888889,NULL,NULL,'2015-10-06 01:06:14',57301.0459954,17.6,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/041227.87342902.0.png',17503610922439,68373480165,0.372728440664,0.735200633317,0.566174476898,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1068335627,16692744);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430344,1430344,1,'MASTERJ163304.91+244143.8','MASTER',248.270458333,24.6955,NULL,NULL,'2015-09-30 21:48:57',57295.9089931,17,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/163304.91244143.8.png',14381247826111,56176749320,-0.336365287473,-0.843981712498,0.417795718447,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,877761708,13715026);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430347,1430347,1,'MASTERJ233023.63+744535.6','MASTER',352.598458333,74.7598888889,NULL,NULL,'2015-09-12 16:37:55',57277.6929977,16.5,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:05','2016-10-04 11:17:05','http://observ.pereplet.ru/sn_e.html','DN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/233023.63744535.6.png',13518840680822,52807971409,0.260674425943,-0.0338628291508,0.964832706982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,825124553,12892571);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430353,1430353,1,'MASTERJ203309.21+255107.7','MASTER',308.288375,25.8521388889,NULL,NULL,'2015-06-20 15:48:57',57193.6589931,16.9,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','DN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/203309.21255107.7.png',14266706812269,55729323485,0.557609693587,-0.706350938583,0.436050204886,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,870770679,13605791);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430359,1430359,1,'MASTERJ080658.36+250049.7','MASTER',121.743166667,25.0138055556,NULL,NULL,'2015-05-25 18:37:26',57167.7759954,16.6,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/080658.36250049.7.png',16459978818585,64296792260,-0.476766270315,0.770651095356,0.422836626507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1004637379,15697459);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430360,1430360,1,'MASTERJ074610.09-712224.9','MASTER',116.542041667,-71.3735833333,NULL,NULL,'2015-04-26 18:02:52',57138.7519907,16.3,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/074610.09-712224.9.png',10401008693581,40628940209,-0.142723609076,0.285734031622,-0.947621250598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,634827190,9919174);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430361,1430361,1,'MASTERJ123253.56-511846.1','MASTER',188.223166667,-51.3128055556,NULL,NULL,'2015-04-08 23:31:12',57120.98,18,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','Anti',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/123253.56-511846.1.png',11424190814765,44625745370,-0.618641563982,-0.0894029585306,-0.780570129021,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,697277271,10894957);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430362,1430362,1,'MASTERJ164710.25-692460.0','MASTER',251.792708333,-69.4166666667,NULL,NULL,'2015-04-09 23:57:07',57121.9979977,16.9,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','DN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/164710.25-692460.0.png',11524763882149,45018608914,-0.109849885413,-0.333967074584,-0.936161842722,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,703415764,10990871);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430363,1430363,1,'MASTERJ062210.50-542849.8','MASTER',95.54375,-54.4805,NULL,NULL,'2015-04-08 19:47:59',57120.8249884,17.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/062210.50-542849.8.png',10314022822472,40289151650,-0.0561260320246,0.578262592622,-0.813917835229,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,629517994,9836218);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430364,1430364,1,'MASTERJ061701.22-475148.0','MASTER',94.2550833333,-47.8633333333,NULL,NULL,'2015-04-08 19:33:35',57120.8149884,17.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/061701.22-475148.0.png',10311568637001,40279564988,-0.0497788424068,0.669052043879,-0.741546646834,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,629368202,9833878);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430365,1430365,1,'MASTERJ172624.20+335044.4','MASTER',261.600833333,33.8456666667,NULL,NULL,'2015-04-01 23:22:33',57113.9739931,17.6,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:06','2016-10-04 11:17:06','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/172624.20335044.4.png',14426908665428,56355111974,-0.121315968041,-0.821632818214,0.556957761353,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,880548624,13758572);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430368,1430368,1,'MASTERJ192024.77-512215.1','MASTER',290.103208333,-51.3708611111,NULL,NULL,'2015-03-22 01:33:36',57103.065,18.1,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:07','2016-10-04 11:17:07','http://observ.pereplet.ru/sn_e.html','PSN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/192024.77-512215.1.png',13116869180531,51237770236,0.214571661638,-0.586242903325,-0.781203085198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,800590159,12509221);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430369,1430369,1,'MASTERJ113003.04+280647.6','MASTER',172.512666667,28.1132222222,NULL,NULL,'2015-03-25 19:13:26',57106.8009954,18.4,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:08','2016-10-04 11:17:08','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/113003.04280647.6.png',15507246734918,60575182558,-0.874497789206,0.114933143304,0.47121543825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,946487227,14788862);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430370,1430370,1,'MASTERJ132723.53+674411.9','MASTER',201.848041667,67.7366388889,NULL,NULL,'2015-03-22 17:57:07',57103.7479977,19.3,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:08','2016-10-04 11:17:08','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/132723.53674411.9.png',14824586259160,57908540074,-0.351652164859,-0.140992971301,0.925452179745,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,904820938,14137827);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430371,1430371,1,'MASTERJ053934.36-275536.9','MASTER',84.8931666667,-27.9269166667,NULL,NULL,'2015-03-18 19:26:23',57099.8099884,18.7,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:17:09','2016-10-04 11:17:08','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/053934.36-275536.9.png',9513718612097,37162963328,0.0786471319296,0.880038433236,-0.468344941967,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580671302,9072989);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430444,1430444,1,'MASTERJ054231.15-262533.9','MASTER',85.6297916667,-26.4260833333,NULL,NULL,'2016-09-20 01:32:09',57651.0639931,17.3,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:54:20','2016-10-04 11:54:20','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/054231.15-262533.9.png',9516660681972,37174455788,0.0682383311484,0.892905566131,-0.44504289696,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580850871,9075794);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430447,1430447,1,'MASTERJ003841.98+121311.1','MASTER',9.67491666667,12.21975,NULL,NULL,'2016-09-07 03:07:11',57638.1299884,16.7,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:54:20','2016-10-04 11:54:20','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/003841.98121311.1.png',17086435373777,66743888178,0.963442376594,0.164250147792,0.211661701623,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1042873252,16294894);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430450,1430450,1,'MASTERJ042032.78-215212.3','MASTER',65.1365833333,-21.8700833333,NULL,NULL,'2016-08-16 00:51:50',57616.0359954,17.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:54:21','2016-10-04 11:54:21','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/042032.78-215212.3.png',9555585149178,37326504488,0.390196690607,0.842014167626,-0.372503267309,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,583226632,9112916);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1430451,1430451,1,'MASTERJ001706.60-382224.8','MASTER',4.2775,-38.3735555556,NULL,NULL,'2016-08-19 00:28:47',57619.0199884,18.6,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-04 11:54:21','2016-10-04 11:54:21','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/001706.60-382224.8.png',8881802804987,34694542206,0.781796284121,0.0584748205913,-0.620786006198,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,542102221,8470347);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434167,1434167,1,'AT2016gvu','Gaia',89.6670416667,-75.3108611111,NULL,NULL,'2016-10-01 23:11:02',57662.9659954,18.49,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-04 18:25:14','2016-10-04 18:25:14','http://wis-tns.weizmann.ac.il/object/2016gvu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9098586765589,35541354553,0.00147356918659,0.253570301044,-0.967315838298,NULL,NULL,NULL,'2016-08-28 05:36:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,555333664,8677088);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434168,1434168,1,'AT2016gvv','Gaia',129.469791667,-55.7825694444,NULL,NULL,'2016-10-02 14:58:33',57663.6239931,19,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-04 18:25:14','2016-10-04 18:25:14','http://wis-tns.weizmann.ac.il/object/2016gvv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10346322505151,40415322285,-0.357460201896,0.434100010272,-0.82690953867,NULL,NULL,NULL,'2016-08-23 11:51:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,631489410,9867022);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434169,1434169,1,'AT2016gvw','Gaia',139.437625,-19.1023,NULL,NULL,'2016-10-02 04:04:48',57663.17,18.74,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-04 18:25:14','2016-10-04 18:25:14','http://wis-tns.weizmann.ac.il/object/2016gvw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10834063334440,42320559900,-0.717866286063,0.614468564006,-0.327255831396,NULL,NULL,NULL,'2016-06-25 13:24:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,661258748,10332167);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434544,1434544,1,'AT2016gbk','Pan-STARRS1',7.41333333333,-3.61908055556,NULL,NULL,'2016-09-26 09:31:40',57657.3969907,20.23,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-04 19:24:45','2016-10-04 19:24:45','http://wis-tns.weizmann.ac.il/object/2016gbk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8807284005069,34403453144,0.989663595621,0.128769056253,-0.0631228774231,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,537553955,8399280);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434545,1434545,1,'AT2016gqq','Pan-STARRS1',5.94091666667,-4.09881388889,NULL,NULL,'2016-09-26 09:37:26',57657.4009954,20.36,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-04 19:24:45','2016-10-04 19:24:45','http://wis-tns.weizmann.ac.il/object/2016gqq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8807716281877,34405141726,0.992085156223,0.10323812508,-0.0714767957529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,537580339,8399692);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434546,1434546,1,'AT2016gvx','Pan-STARRS1',35.0907083333,3.43291944444,NULL,NULL,'2016-09-27 11:18:14',57658.4709954,21.51,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-04 19:24:45','2016-10-04 19:24:45','http://wis-tns.weizmann.ac.il/object/2016gvx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17122395029928,66884355585,0.816774690821,0.573841007071,0.0598799051374,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045068056,16329188);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434547,1434547,1,'AT2016gvy','Pan-STARRS1',314.696375,-24.1283611111,NULL,NULL,'2016-09-27 06:51:50',57658.2859954,20.56,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-04 19:24:45','2016-10-04 19:24:45','http://wis-tns.weizmann.ac.il/object/2016gvy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13039747998197,50936515617,0.641899431754,-0.648738918723,-0.40878225848,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,795883056,12435672);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1434548,1434548,1,'AT2016gvz','Pan-STARRS1',340.69775,-17.7146416667,NULL,NULL,'2016-09-30 09:01:26',57661.3759954,19.54,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-04 19:24:45','2016-10-04 19:24:45','http://wis-tns.weizmann.ac.il/object/2016gvz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12907459830073,50419764961,0.899037090776,-0.314877946947,-0.304276499152,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,787808827,12309512);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437284,1436876,1,'AT2016gwa','Pan-STARRS1',36.8773333333,-1.19376388889,NULL,NULL,'2016-09-25 12:23:02',57656.5159954,20.1,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:56','http://wis-tns.weizmann.ac.il/object/2016gwa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8940322448240,34923134563,0.79974850938,0.599973568361,-0.0208336029587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,545673977,8526155);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437285,1436871,1,'AT2016gwb','Pan-STARRS1',30.0425833333,-4.86084444444,NULL,NULL,'2016-09-25 12:15:50',57656.5109954,21.39,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:57','http://wis-tns.weizmann.ac.il/object/2016gwb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8961525740172,35005959922,0.862540177301,0.498842912727,-0.0847360074797,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546968123,8546376);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437286,1436890,1,'AT2016gwc','Pan-STARRS1',309.358708333,-12.5373222222,NULL,NULL,'2016-09-30 05:45:36',57661.24,18.98,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:57','http://wis-tns.weizmann.ac.il/object/2016gwc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13048889557428,50972224833,0.619051473007,-0.754753927516,-0.217075522957,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,796441013,12444390);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437287,1436885,1,'AT2016gwd','Pan-STARRS1',324.560958333,-4.57528888889,NULL,NULL,'2016-09-26 07:13:26',57657.3009954,19.99,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:57','http://wis-tns.weizmann.ac.il/object/2016gwd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12724730357024,49705977957,0.812136632707,-0.577988748959,-0.0797690158709,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,776655905,12135248);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437288,1436900,1,'AT2016gwe','Pan-STARRS1',21.044375,3.91125555556,NULL,NULL,'2016-09-30 11:31:12',57661.48,20.76,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:57','http://wis-tns.weizmann.ac.il/object/2016gwe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17287242491760,67528290983,0.931128837452,0.358254531329,0.0682112809399,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1055129546,16486399);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437289,1436909,1,'AT2016gwf','Pan-STARRS1',2.66,-9.92393333333,NULL,NULL,'2016-10-02 10:55:12',57663.455,20.81,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:57','http://wis-tns.weizmann.ac.il/object/2016gwf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8857035148227,34597793547,0.983976062718,0.0457146831168,-0.172340580671,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,540590524,8446726);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1437290,1436905,1,'AT2016gwg','Pan-STARRS1',30.133625,14.1011472222,NULL,NULL,'2016-09-30 14:02:24',57661.585,20.42,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 00:52:57','2016-10-05 00:52:57','http://wis-tns.weizmann.ac.il/object/2016gwg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17142183449063,66961654097,0.838796335688,0.486891128615,0.243634431295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046275845,16348060);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1441948,1441948,1,'AT2016gsu','PTSS',17.1024583333,21.1515972222,NULL,NULL,'2016-10-04 16:32:06',57665.6889583,18.6,NULL,'r-Sloan',NULL,NULL,NULL,NULL,'2016-10-05 09:24:53','2016-10-05 09:24:53','http://wis-tns.weizmann.ac.il/object/2016gsu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17256758262480,67409211962,0.891388482742,0.274268770229,0.360836825326,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1053268936,16457327);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1442325,1442325,1,'ATLAS16ddb','ATLAS',333.515696,37.58135,NULL,NULL,'2016-09-25 08:46:10',57656.36539,17.32,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-05 11:13:13','2016-10-05 11:13:13',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57656/1221403781373453100_57656.419_02a57656o0375c_3498_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57656/1221403781373453100_57656.419_02a57656o0375c_3498_target.jpeg',NULL,NULL,14202291661746,55477701803,0.70932176951,-0.353412201217,0.609887238209,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,866839090,13544360);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1442331,1442331,1,'ATLAS16ddf','ATLAS',325.056193333,43.9302166667,NULL,NULL,'2016-09-25 08:40:15',57656.36129,18.04,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-05 11:13:14','2016-10-05 11:13:14',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57656/1214013491435549000_57656.390_02a57656o0320c_3754_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57656/1214013491435549000_57656.390_02a57656o0320c_3754_target.jpeg',NULL,NULL,14181420033203,55396172004,0.59034613056,-0.412502543626,0.693781736308,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,865565187,13524456);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1444210,1444210,1,'OGLE16eha','OGLE',50.2695416667,-64.9721944444,NULL,NULL,'2016-09-07 07:21:16',57638.30644,21.289,0.209,'I',NULL,NULL,NULL,NULL,'2016-10-05 14:18:39','2016-10-05 14:18:39','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR211.20.I.1557.66.2575.84.7666.75037.gif',NULL,NULL,9334886252606,36464399424,0.270408859397,0.325356966207,-0.906102584314,NULL,NULL,NULL,'2016-09-02 08:49:32',57633.36773,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,569756241,8902441);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1444239,1444239,1,'OGLE16egv','OGLE',52.7381666667,-78.7278611111,NULL,NULL,'2016-10-05 05:13:36',57666.21778,20.113,0.073,'I',NULL,NULL,NULL,NULL,'2016-10-05 14:18:41','2016-10-05 14:18:41','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR169.27.I.518.43.3186.86.7666.71778.gif',NULL,NULL,9137333276817,35692708112,0.118348512086,0.155569498599,-0.98070982497,NULL,NULL,NULL,'2016-09-21 06:30:33',57652.27122,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,557698564,8714040);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445024,1445024,1,'AT2016gwq','Gaia',140.460291667,-29.96025,NULL,NULL,'2016-10-03 04:16:19',57664.1779977,17.06,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10967151100713,42840433987,-0.668131913009,0.551543585774,-0.49939905868,NULL,NULL,NULL,'2016-06-26 01:14:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,669381781,10459090);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445025,1445025,1,'AT2016gwr','Gaia',141.233333333,-25.16495,NULL,NULL,'2016-10-03 04:11:59',57664.1749884,18.71,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10967630643829,42842307202,-0.705698756402,0.566720719214,-0.425225694928,NULL,NULL,NULL,'2016-06-26 01:19:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,669411050,10459547);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445026,1445026,1,'AT2016gws','Gaia',347.6895,-76.25405,NULL,NULL,'2016-10-03 15:48:57',57664.6589931,18.06,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gws',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12398111042892,48430121261,0.23215358411,-0.0506622358517,-0.971358868412,NULL,NULL,NULL,'2016-09-03 05:47:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,756720644,11823760);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445027,1445027,1,'AT2016gwt','Gaia',0.20425,-77.31605,NULL,NULL,'2016-10-03 03:46:04',57664.1569907,16.4,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9110229961094,35586835785,0.21957152861,0.000782739585277,-0.975596090164,NULL,NULL,NULL,'2015-12-16 03:18:43',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556044309,8688192);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445028,1445028,1,'AT2016gwu','Gaia',321.600541667,25.6407805556,NULL,NULL,'2016-10-03 11:35:31',57664.4829977,16.52,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14235228371978,55606360828,0.706524349055,-0.559973423442,0.432727523081,NULL,NULL,NULL,'2016-06-26 04:22:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,868849387,13575771);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445029,1445029,1,'AT2016gwv','Gaia',289.721958333,79.53795,NULL,NULL,'2016-08-29 01:03:21',57629.0439931,20.64,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13533194297287,52864040223,0.0612766946521,-0.170932727104,0.98337539602,NULL,NULL,NULL,'2016-08-28 20:44:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,826000628,12906259);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445030,1445030,1,'AT2016gwy','Gaia',315.26075,52.4524194444,NULL,NULL,'2016-10-03 06:01:26',57664.2509954,14.9,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14243176573842,55637408491,0.432881696843,-0.428959477101,0.79284752856,NULL,NULL,NULL,'2016-08-23 01:10:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,869334507,13583351);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445031,1445031,1,'AT2016gwz','Gaia',162.943791667,77.1821611111,NULL,NULL,'2016-10-04 00:46:04',57665.0319907,18.76,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gwz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15708822033509,61362586068,-0.212094481237,0.0650713761163,0.975080328506,NULL,NULL,NULL,'2016-09-03 08:51:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,958790407,14981100);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445032,1445032,1,'AT2016gxa','Gaia',148.355541667,52.2632611111,NULL,NULL,'2016-10-04 08:57:07',57665.3729977,18.85,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 15:26:54','2016-10-05 15:26:54','http://wis-tns.weizmann.ac.il/object/2016gxa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16386563525538,64010013771,-0.521037062415,0.321101717782,0.790831250285,NULL,NULL,NULL,'2016-09-13 07:10:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1000156465,15627444);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1445427,1445427,1,'AT2016gxb','Gaia',326.952875,-31.0806694444,NULL,NULL,'2016-09-24 12:20:09',57655.5139931,20.71,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-05 16:23:35','2016-10-05 16:23:35','http://wis-tns.weizmann.ac.il/object/2016gxb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13174575821216,51463186801,0.717888222718,-0.467041977023,-0.516244410509,NULL,NULL,NULL,'2016-09-24 10:29:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,804112293,12564254);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447002,1444644,1,'AT2016gxd','Pan-STARRS1',312.131083333,-11.3498222222,NULL,NULL,'2016-09-30 05:48:28',57661.2419907,20.04,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:28','2016-10-05 19:26:28','http://wis-tns.weizmann.ac.il/object/2016gxd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12994185582494,50758537431,0.657710247438,-0.727108982565,-0.196798775119,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793102147,12392221);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447003,1446176,1,'AT2016gxe','Pan-STARRS1',32.8057083333,-0.231913888889,NULL,NULL,'2016-09-25 12:59:02',57656.5409954,22.03,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:28','2016-10-05 19:26:28','http://wis-tns.weizmann.ac.il/object/2016gxe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8959414143071,34997711496,0.840505744078,0.541787514347,-0.00404764988971,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546839242,8544363);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447004,1446171,1,'AT2016gxf','Pan-STARRS1',12.7422916667,-4.630375,NULL,NULL,'2016-09-26 09:34:33',57657.3989931,19.87,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:28','2016-10-05 19:26:28','http://wis-tns.weizmann.ac.il/object/2016gxf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8843482718515,34544854369,0.97218860514,0.219846335284,-0.0807273491369,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,539763349,8433802);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447005,1446214,1,'AT2016gxg','Pan-STARRS1',35.6996666667,-2.03015277778,NULL,NULL,'2016-09-25 12:23:02',57656.5159954,21.47,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:28','http://wis-tns.weizmann.ac.il/object/2016gxg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8941886417222,34929243817,0.811577192878,0.583170213958,-0.0354254365097,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,545769434,8527647);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447006,1446181,1,'AT2016gxh','Pan-STARRS1',33.2109583333,0.394738888889,NULL,NULL,'2016-09-25 12:21:36',57656.515,19.98,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17149827177541,66991512412,0.836639715768,0.547710253357,0.00688943879514,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046742381,16355349);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447007,1444617,1,'AT2016gxi','Pan-STARRS1',315.049208333,-16.8675027778,NULL,NULL,'2016-09-27 06:48:57',57658.2839931,20.6,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13056639125532,51002496584,0.677266773877,-0.676104434207,-0.290159457967,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,796914009,12451781);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447008,1446219,1,'AT2016gxj','Pan-STARRS1',39.6935416667,0.414222222222,NULL,NULL,'2016-09-25 12:31:40',57656.5219907,20.69,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17113341599595,66848990623,0.769451442927,0.638664396704,0.007229478636,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1044515478,16320554);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447009,1444624,1,'AT2016gxk','Pan-STARRS1',38.7284166667,5.85230833333,NULL,NULL,'2016-09-27 11:03:50',57658.4609954,21.14,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17126608106771,66900812917,0.776054253725,0.622368885066,0.101964533915,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045325201,16333206);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447010,1446228,1,'AT2016gxl','Pan-STARRS1',36.4769166667,2.494375,NULL,NULL,'2016-09-27 11:29:45',57658.4789931,21.49,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17123173297796,66887395694,0.803334555571,0.593935592269,0.0435213058255,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045115557,16329930);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447011,1444635,1,'AT2016gxm','Pan-STARRS1',307.965375,-9.60466666667,NULL,NULL,'2016-09-30 05:42:43',57661.2379977,19.86,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12240972335342,47816298184,0.606561763879,-0.7773314735,-0.166849054257,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,747129659,11673900);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447012,1444629,1,'AT2016gxn','Pan-STARRS1',40.9892916667,4.1777,NULL,NULL,'2016-09-27 11:05:16',57658.4619907,21.36,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-05 19:26:29','2016-10-05 19:26:29','http://wis-tns.weizmann.ac.il/object/2016gxn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17113288919170,66848784840,0.752826522034,0.654175130286,0.0728500283951,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1044512263,16320504);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1447027,1428024,1,'SN2016gvg','PESSTO',48.3035833333,2.14376944444,NULL,NULL,'2016-10-05 08:50:54',57666.3686806,17.9,NULL,'r-Sloan',0.048,NULL,'SN Ia',NULL,'2016-10-05 19:26:30','2016-10-05 19:26:30','http://wis-tns.weizmann.ac.il/object/2016gvg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16634402028893,64978132925,0.664718102022,0.746157190731,0.0374071058033,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1015283326,15863801);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1448159,1448159,1,'ATLAS16dei','ATLAS',269.998536667,7.45185333333,NULL,NULL,'2016-10-05 05:36:43',57666.23383,16.71,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-05 23:15:03','2016-10-05 23:15:03',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57666/1175959651072706800_57666.251_02a57666o0055c_9231_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57666/1175959651072706800_57666.251_02a57666o0055c_9231_target.jpeg',NULL,NULL,14300521727323,55861412997,-0.0000253242732142,-0.991554194481,0.129693017412,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,872834578,13638040);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1454305,1454305,1,'SMT16acdn','skymapper',348.240992,-17.69303,NULL,NULL,'2016-10-05 11:13:55',57666.468,20.28,0.13,'i',NULL,NULL,NULL,NULL,'2016-10-06 09:22:44','2016-10-06 09:22:44','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ23125784-1741349','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23125784-1741349/SMTJ23125784-1741349_sub20161004_191335_1220_i_0893409321_2016-10-05T22:11:45_07_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23125784-1741349/SMTJ23125784-1741349_sub20161004_191335_1220_i_0893409321_2016-10-05T22:11:45_07_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ23125784-1741349/SMTJ23125784-1741349_sub20161004_191335_1220_i_0893409321_2016-10-05T22:11:45_07_diff.png',NULL,12880655918989,50315062183,0.932704600065,-0.194155824159,-0.303917167932,NULL,NULL,NULL,NULL,-99,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,786172846,12283950);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1456719,1456719,1,'OGLE16ehw','OGLE',11.8001666667,-63.1332222222,NULL,NULL,'2016-09-22 04:09:05',57653.17298,21.429,0.198,'I',NULL,NULL,NULL,NULL,'2016-10-06 14:18:32','2016-10-06 14:18:32','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC798.20.I.601.79.2302.52.7667.62181.gif',NULL,NULL,9242007560945,36101592034,0.442367069509,0.0924166386511,-0.892059718132,NULL,NULL,NULL,'2016-09-19 04:09:18',57650.17312,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,564087375,8813865);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1459475,1459475,1,'AT2016gxv','Pan-STARRS1',359.333958333,-11.3536805556,NULL,NULL,'2016-10-02 10:53:45',57663.4539931,20.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-06 19:23:43','2016-10-06 19:23:43','http://wis-tns.weizmann.ac.il/object/2016gxv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12683274056428,49544039282,0.980364402839,-0.011396877053,-0.196864798375,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,774125613,12095712);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1459476,1458722,1,'AT2016gxw','Pan-STARRS1',48.4614166667,-2.43981388889,NULL,NULL,'2016-09-30 12:33:07',57661.5229977,20.8,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-06 19:23:43','2016-10-06 19:23:43','http://wis-tns.weizmann.ac.il/object/2016gxw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9418715202766,36791856260,0.662523120722,0.747830807492,-0.0425699174815,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,574872754,8982386);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1462293,1462293,1,'ATLAS16dfg','ATLAS',288.588122,-14.844054,NULL,NULL,'2016-10-06 06:06:24',57667.25445,17.89,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-07 00:30:53','2016-10-07 00:30:53',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57667/1191421140145038500_57667.310_02a57667o0195c_10695_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57667/1191421140145038500_57667.310_02a57667o0195c_10695_target.jpeg',NULL,NULL,12362258416436,48290071939,0.308124651177,-0.916202141753,-0.256189060626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,754532374,11789568);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1462299,1462299,1,'ATLAS16dfh','ATLAS',355.07006,22.915862,NULL,NULL,'2016-09-26 10:01:19',57657.41758,18.32,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-07 00:30:53','2016-10-07 00:30:53',NULL,'sn',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57657/1234016801225457200_57657.483_02a57657o0495c_1020_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57657/1234016801225457200_57657.483_02a57657o0495c_1020_target.jpeg',NULL,NULL,13436613410436,52486771134,0.917670140252,-0.0791551590509,0.389378959994,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,820105798,12814153);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1462305,1462305,1,'ATLAS16dfl','ATLAS',11.228175,16.8076525,NULL,NULL,'2016-09-26 10:40:30',57657.44479,18.14,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-07 00:30:54','2016-10-07 00:30:54',NULL,'sn',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57657/1004454751164827500_57657.492_02a57657o0511c_297_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57657/1004454751164827500_57657.492_02a57657o0511c_297_target.jpeg',NULL,NULL,17272118969349,67469214724,0.938958072449,0.186398583615,0.289159655223,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1054206480,16471976);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1466519,1466519,1,'AT2016gya','ISSP',66.063375,31.4040555556,NULL,NULL,'2016-09-29 02:24:00',57660.1,18.5,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-07 08:23:35','2016-10-07 08:23:35','http://wis-tns.weizmann.ac.il/object/2016gya',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17504892611692,68378486764,0.346292718739,0.78010727391,0.521070047249,NULL,NULL,NULL,'2016-09-03 01:40:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1068413855,16693966);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1467669,1448190,1,'AT2016gyg','Gaia',326.057666667,33.1073888889,NULL,NULL,'2016-10-04 23:45:36',57665.99,18.74,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 10:24:53','2016-10-07 10:24:53','http://wis-tns.weizmann.ac.il/object/2016gyg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14232130764627,55594260799,0.694912987371,-0.467707801782,0.546209989047,NULL,NULL,NULL,'2016-08-17 09:07:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,868660324,13572817);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1467670,1467670,1,'AT2016gyh','Gaia',330.614083333,51.8252305556,NULL,NULL,'2016-10-05 18:04:19',57666.7529977,18.02,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 10:24:53','2016-10-07 10:24:53','http://wis-tns.weizmann.ac.il/object/2016gyh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14183526392294,55404399969,0.538538954925,-0.303276728438,0.786129136985,NULL,NULL,NULL,'2016-08-24 01:20:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,865693749,13526464);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1467671,1467671,1,'AT2016gyj','Gaia',326.666541667,9.35523055556,NULL,NULL,'2016-10-05 11:22:33',57666.4739931,17.79,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 10:24:53','2016-10-07 10:24:53','http://wis-tns.weizmann.ac.il/object/2016gyj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13390868126968,52308078620,0.824374205432,-0.542202020933,0.162555030418,NULL,NULL,NULL,'2016-06-27 10:39:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,817313728,12770527);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1467672,1467672,1,'AT2016gyk','Gaia',326.667958333,-45.68545,NULL,NULL,'2016-10-04 16:23:31',57665.6829977,18.55,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 10:24:53','2016-10-07 10:24:53','http://wis-tns.weizmann.ac.il/object/2016gyk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12965694284079,50647243297,0.583677940867,-0.383872170695,-0.715515351275,NULL,NULL,NULL,'2016-09-16 12:02:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,791363176,12365049);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1468638,1468638,1,'AT2016gym','Gaia',324.5,50.6833194444,NULL,NULL,'2016-10-04 18:01:26',57665.7509954,19.71,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 14:23:50','2016-10-07 14:23:50','http://wis-tns.weizmann.ac.il/object/2016gym',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14189498647361,55427729091,0.515828586508,-0.367936954979,0.773655780371,NULL,NULL,NULL,'2016-08-23 03:02:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,866058267,13532160);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1470711,1470711,1,'MASTERJ235631.58-505643.2','MASTER',359.131583333,-50.9453333333,NULL,NULL,'2016-10-04 21:27:21',57665.8939931,17.4,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-07 18:19:02','2016-10-07 18:19:01','http://observ.pereplet.ru/sn_e.html','PSN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/235631.58-505643.2.png',12452225059442,48641504138,0.629989220283,-0.00954930784342,-0.776545164847,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,760023502,11875367);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1471484,1471484,1,'AT2016gyn','Gaia',149.874875,-44.9938194444,NULL,NULL,'2016-10-05 20:47:02',57666.8659954,18.01,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 19:24:18','2016-10-07 19:24:18','http://wis-tns.weizmann.ac.il/object/2016gyn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10766297835499,42055850919,-0.611664841129,0.354928152125,-0.707030500725,NULL,NULL,NULL,'2016-08-22 06:08:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,657122670,10267541);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1471485,1471485,1,'AT2016gyo','Gaia',147.6095,-12.048,NULL,NULL,'2016-10-06 10:00:28',57667.4169907,18.87,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-07 19:24:18','2016-10-07 19:24:18','http://wis-tns.weizmann.ac.il/object/2016gyo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10575937272130,41312254969,-0.825816855135,0.523887261442,-0.208731068779,NULL,NULL,NULL,'2016-06-27 13:35:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,645503983,10085999);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1473027,1473027,1,'ATLAS16dfn','ATLAS',19.30157,58.4678825,NULL,NULL,'2016-10-07 10:17:07',57668.42855,16.08,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-08 00:15:24','2016-10-08 00:15:22',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1011712371582804400_57668.474_02a57668o0537c_16258_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1011712371582804400_57668.474_02a57668o0537c_16258_target.jpeg',NULL,NULL,16902196411368,66024204731,0.493580920661,0.172864763911,0.85234714064,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1031628198,16119190);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1473038,1473038,1,'ATLAS16dfr','ATLAS',272.171115,46.326159,NULL,NULL,'2016-05-07 11:27:01',57515.4771,18.93,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-08 00:15:26','2016-10-08 00:15:26',NULL,'orphan',NULL,NULL,NULL,NULL,NULL,NULL,NULL,13538684151658,52885484967,0.0261609077186,-0.690056542379,0.723282500291,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,826335702,12911495);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1473049,1473049,1,'ATLAS16dfs','ATLAS',1.76044111111,55.4744955556,NULL,NULL,'2016-07-12 12:59:55',57581.54161,17.85,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-08 00:15:27','2016-10-08 00:15:27',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1000702561552828200_57668.440_02a57668o0473c_12680_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1000702561552828200_57668.440_02a57668o0473c_12680_target.jpeg',NULL,NULL,16845765350749,65803770901,0.566505517786,0.0174116412371,0.823873978875,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1028183920,16065373);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1473059,1473059,1,'ATLAS16dfu','ATLAS',325.215042727,40.7294836364,NULL,NULL,'2016-06-07 13:03:28',57546.54407,18.89,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-08 00:15:28','2016-10-08 00:15:28',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1214051601404346900_57668.382_02a57668o0357c_8970_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1214051601404346900_57668.382_02a57668o0357c_8970_target.jpeg',NULL,NULL,14250944057690,55667750225,0.622379308113,-0.432322597526,0.652488443193,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,869808597,13590759);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1480817,1480817,1,'ATLAS16dfw','ATLAS',19.716092,53.408708,NULL,NULL,'2016-10-07 10:10:44',57668.42412,18.18,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-08 14:13:07','2016-10-08 14:13:07',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1011851851532431500_57668.473_02a57668o0536c_9482_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1011851851532431500_57668.473_02a57668o0536c_9482_target.jpeg',NULL,NULL,16897393293473,66005442552,0.561156819232,0.201101058891,0.802908082126,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1031335039,16114609);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1480823,1480823,1,'ATLAS16dfx','ATLAS',302.954434286,50.3475242857,NULL,NULL,'2016-04-14 13:38:22',57492.56831,17.36,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-08 14:13:08','2016-10-08 14:13:08',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1201149151502051600_57668.332_02a57668o0256c_13414_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1201149151502051600_57668.332_02a57668o0256c_13414_target.jpeg',NULL,NULL,14069322031314,54958289184,0.347124465315,-0.535456586764,0.76992911964,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,858723268,13417551);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1480831,1480831,1,'ATLAS16dgc','ATLAS',17.326355,17.797117,NULL,NULL,'2016-09-26 11:13:22',57657.46761,18.52,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-08 14:13:08','2016-10-08 14:13:08',NULL,'sn',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57661/1010918361174749400_57661.515_02a57661o0555c_3190_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57661/1010918361174749400_57661.515_02a57661o0555c_3190_target.jpeg',NULL,NULL,17313417944442,67630538845,0.908940168011,0.283562057781,0.305647395479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1056727169,16511362);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1483883,1482973,1,'AT2016gzl','Pan-STARRS1',356.529625,13.8991611111,NULL,NULL,'2016-10-06 10:07:40',57667.4219907,21.03,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-08 19:24:34','2016-10-08 19:24:34','http://wis-tns.weizmann.ac.il/object/2016gzl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13224538593900,51658353882,0.968939921896,-0.0587600520377,0.240213829829,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,807161779,12611902);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1483884,1482968,1,'AT2016gzm','Pan-STARRS1',356.081291667,23.3771416667,NULL,NULL,'2016-10-07 06:21:36',57668.265,20.98,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-08 19:24:35','2016-10-08 19:24:35','http://wis-tns.weizmann.ac.il/object/2016gzm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13299895810699,51952718010,0.915766931224,-0.0627311406286,0.396781717915,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,811761218,12683769);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1483885,1482982,1,'AT2016gzn','Pan-STARRS1',358.408166667,12.3524972222,NULL,NULL,'2016-10-06 10:04:48',57667.42,19.31,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-08 19:24:35','2016-10-08 19:24:35','http://wis-tns.weizmann.ac.il/object/2016gzn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13220636631383,51643111841,0.976472994035,-0.027136070575,0.213925514126,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,806923622,12608181);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485434,1481302,1,'AT2016gzo','ATLAS',17.8653333333,26.3118611111,NULL,NULL,'2016-09-30 11:11:02',57661.4659954,18.22,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-08 23:46:19','2016-10-08 23:46:18','http://wis-tns.weizmann.ac.il/object/2016gzo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17228973440264,67300677501,0.853170711538,0.274996681283,0.443256767863,NULL,NULL,NULL,'2016-09-26 12:57:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1051573085,16430829);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485435,1485435,1,'AT2016gzp','ATLAS',93.9803333333,54.56065,NULL,NULL,'2016-09-21 13:55:12',57652.58,17.81,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-08 23:46:19','2016-10-08 23:46:19','http://wis-tns.weizmann.ac.il/object/2016gzp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15749051152390,61519731064,-0.0402491065533,0.578442241229,0.814729760708,NULL,NULL,NULL,'2016-09-21 13:46:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,961245797,15019465);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485436,1485436,1,'AT2016gzq','ATLAS',91.19225,42.6427333333,NULL,NULL,'2016-10-07 13:09:07',57668.5479977,17.15,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-08 23:46:19','2016-10-08 23:46:19','http://wis-tns.weizmann.ac.il/object/2016gzq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16080747362923,62815419386,-0.0153056007102,0.735432792559,0.677424790081,NULL,NULL,NULL,'2016-09-29 15:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,981490927,15335795);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485437,1480912,1,'AT2016gzr','ATLAS',40.64425,37.0704861111,NULL,NULL,'2016-10-07 11:12:28',57668.4669907,18.79,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-08 23:46:20','2016-10-08 23:46:20','http://wis-tns.weizmann.ac.il/object/2016gzr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17578434734567,68665760681,0.605417232645,0.519716921099,0.602797060659,NULL,NULL,NULL,'2016-09-29 13:32:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072902510,16764101);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485438,1485438,1,'AT2016gzs','ATLAS',118.179958333,58.6938861111,NULL,NULL,'2016-10-07 13:55:12',57668.58,17.39,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-08 23:46:20','2016-10-08 23:46:20','http://wis-tns.weizmann.ac.il/object/2016gzs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15759844283269,61561891731,-0.245382040841,0.458020199809,0.854403388687,NULL,NULL,NULL,'2016-09-25 15:34:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,961904558,15029758);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485444,1485444,1,'ATLAS16dhx','ATLAS',320.287186667,30.5706911111,NULL,NULL,'2016-05-24 14:02:21',57532.58496,17.52,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-09 00:15:08','2016-10-09 00:15:04',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1212108921303414500_57669.383_02a57669o0332c_14072_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1212108921303414500_57669.383_02a57669o0332c_14072_target.jpeg',NULL,NULL,14236573818423,55611616478,0.662331781052,-0.550128699188,0.508601048109,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,868931507,13577054);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485454,1485454,1,'ATLAS16dia','ATLAS',85.9663123077,43.1526530769,NULL,NULL,'2016-09-25 13:55:52',57656.58046,15.53,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-09 00:15:09','2016-10-09 00:15:09',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1054351911430909500_57668.585_02a57668o0749c_10165_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57668/1054351911430909500_57668.585_02a57668o0749c_10165_target.jpeg',NULL,NULL,17455295463669,68184747904,0.0513176075361,0.727726905326,0.683944481973,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1065386686,16646666);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485468,1485468,1,'ATLAS16dib','ATLAS',312.36251,23.2242833333,NULL,NULL,'2016-10-08 07:21:57',57669.30691,17.46,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-09 00:15:10','2016-10-09 00:15:10',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1204927001231327200_57669.364_02a57669o0299c_12885_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1204927001231327200_57669.364_02a57669o0299c_12885_target.jpeg',NULL,NULL,14131163875101,55199858887,0.619218347185,-0.679022359749,0.394331425924,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,862497795,13476528);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1485478,1485478,1,'ATLAS16did','ATLAS',286.76464,21.0793433333,NULL,NULL,'2016-04-09 15:09:56',57487.6319,15.75,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-09 00:15:11','2016-10-09 00:15:11',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1190703501210445900_57669.310_02a57669o0196c_11984_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1190703501210445900_57669.310_02a57669o0196c_11984_target.jpeg',NULL,NULL,13958137721853,54523975475,0.269139407534,-0.893425069298,0.359660429935,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,851937116,13311517);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1493587,1491182,1,'SN2016geu','iPTF',316.066083333,-6.34013888889,NULL,NULL,'2016-10-02 05:30:53',57663.2297801,NULL,NULL,NULL,0.409,NULL,'SN Ia',NULL,'2016-10-09 13:24:36','2016-10-09 13:24:36','http://wis-tns.weizmann.ac.il/object/2016geu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13002441543223,50790787278,0.715736023905,-0.689584675467,-0.110430609188,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793606051,12400094);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498067,1498067,1,'AT2016gxx','Gaia',336.190958333,38.8852388889,NULL,NULL,'2016-10-08 05:55:40',57669.2469907,18.92,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:25','2016-10-09 21:41:24','http://wis-tns.weizmann.ac.il/object/2016gxx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14223039692594,55558748799,0.712159513744,-0.314234025563,0.627762538037,NULL,NULL,NULL,'2016-08-21 07:29:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,868105449,13564147);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498068,1498068,1,'AT2016hab','Gaia',67.020375,82.0968388889,NULL,NULL,'2016-10-06 18:41:45',57667.7789931,18.95,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:25','2016-10-09 21:41:25','http://wis-tns.weizmann.ac.il/object/2016hab',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16778691955230,65541765450,0.0536802026553,0.126587772702,0.990501878668,NULL,NULL,NULL,'2016-09-02 01:22:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1024090085,16001407);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498069,1498069,1,'AT2016hac','Gaia',337.139333333,50.6711305556,NULL,NULL,'2016-10-07 06:05:45',57668.2539931,17.72,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:25','2016-10-09 21:41:25','http://wis-tns.weizmann.ac.il/object/2016hac',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14182645486648,55400958932,0.583989486509,-0.24621451158,0.773520971878,NULL,NULL,NULL,'2016-08-24 09:11:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,865639983,13525624);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498070,1498070,1,'AT2016had','Gaia',163.312666667,-64.7482805556,NULL,NULL,'2016-10-06 21:10:04',57667.8819907,18.94,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:25','2016-10-09 21:41:25','http://wis-tns.weizmann.ac.il/object/2016had',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10284121871862,40172351061,-0.40863022325,0.122496479575,-0.904442343734,NULL,NULL,NULL,'2016-08-02 18:17:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,627692985,9807702);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498071,1498071,1,'AT2016hae','Gaia',222.386458333,-80.76945,NULL,NULL,'2016-10-07 03:34:33',57668.1489931,19,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:25','2016-10-09 21:41:25','http://wis-tns.weizmann.ac.il/object/2016hae',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11335355492396,44278732392,-0.11847933878,-0.108135163829,-0.987050876412,NULL,NULL,NULL,'2016-09-01 10:23:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,691855193,10810237);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498072,1498072,1,'AT2016haf','Gaia',296.465833333,-73.9303305556,NULL,NULL,'2016-10-06 21:51:50',57667.9109954,18.79,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:25','2016-10-09 21:41:25','http://wis-tns.weizmann.ac.il/object/2016haf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12413868499998,48491673828,0.123362491264,-0.247796816338,-0.960925821051,NULL,NULL,NULL,'2016-09-05 06:05:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,757682403,11838787);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498073,1498073,1,'AT2016hag','Gaia',307.493208333,-58.2853194444,NULL,NULL,'2016-09-10 04:19:12',57641.18,18.35,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:26','2016-10-09 21:41:26','http://wis-tns.weizmann.ac.il/object/2016hag',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12543716262938,48998891652,0.319970132649,-0.417095556776,-0.850676443033,NULL,NULL,NULL,'2016-05-10 10:23:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,765607682,11962620);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498074,1498074,1,'AT2016hah','Gaia',190.158041667,-75.0500388889,NULL,NULL,'2016-10-07 11:11:02',57668.4659954,18.5,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:26','2016-10-09 21:41:26','http://wis-tns.weizmann.ac.il/object/2016hah',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11319707850679,44217608791,-0.253931604294,-0.0454975552108,-0.966151495787,NULL,NULL,NULL,'2016-08-30 18:10:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,690900137,10795314);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498075,1498075,1,'AT2016hai','Gaia',168.01525,-58.2517694444,NULL,NULL,'2016-10-08 04:52:19',57669.2029977,17.96,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 21:41:26','2016-10-09 21:41:26','http://wis-tns.weizmann.ac.il/object/2016hai',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10306274209386,40258883630,-0.514718299522,0.109263571607,-0.85036847546,NULL,NULL,NULL,'2016-08-27 00:15:50',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,629045056,9828829);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498501,1498096,1,'AT2016haj','Gaia',143.543541667,6.39011944444,NULL,NULL,'2016-10-01 07:50:52',57662.3269907,20.45,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 22:44:41','2016-10-09 22:44:40','http://wis-tns.weizmann.ac.il/object/2016haj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15541950804781,60710745331,-0.799311593761,0.590519965688,0.111297557035,NULL,NULL,NULL,'2016-10-01 03:44:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,948605395,14821959);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498502,1498097,1,'AT2016hak','Gaia',313.976458333,-38.3511,NULL,NULL,'2016-09-17 16:30:43',57648.6879977,20.29,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 22:44:41','2016-10-09 22:44:41','http://wis-tns.weizmann.ac.il/object/2016hak',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13191806382996,51530493683,0.544535447275,-0.564346818435,-0.620478698413,NULL,NULL,NULL,'2016-05-08 05:49:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,805163963,12580686);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498503,1498098,1,'AT2016hal','Gaia',346.658125,61.0064611111,NULL,NULL,'2016-10-07 18:15:50',57668.7609954,19.76,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-09 22:44:41','2016-10-09 22:44:41','http://wis-tns.weizmann.ac.il/object/2016hal',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13629250343221,53239259153,0.471628871191,-0.111852358408,0.874674372426,NULL,NULL,NULL,'2016-08-03 19:29:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,831863424,12997866);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498507,1498507,1,'ATLAS16din','ATLAS',94.5383366667,27.64016,NULL,NULL,'2016-10-08 14:26:04',57669.60144,17.01,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-10 00:16:01','2016-10-10 00:15:55',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1061809201273824300_57669.636_02a57669o0759c_10600_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1061809201273824300_57669.636_02a57669o0759c_10600_target.jpeg',NULL,NULL,16114375394969,62946778886,-0.0700961354289,0.883101054277,0.463917082821,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,983543420,15367865);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1498516,1498516,1,'ATLAS16div','ATLAS',78.118048,29.213018,NULL,NULL,'2016-10-08 13:14:24',57669.55167,17.72,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-10 00:16:03','2016-10-10 00:16:03',NULL,'sn',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1051228331291246800_57669.631_02a57669o0751c_2711_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57669/1051228331291246800_57669.631_02a57669o0751c_2711_target.jpeg',NULL,NULL,16615750773508,64905276459,0.179708291217,0.854110260868,0.488057980518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1014144944,15846014);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1504753,1504753,1,'SMT16aecn','skymapper',5.555906,-32.42947,NULL,NULL,'2016-10-09 11:31:12',57670.48,19.65,0.07,'r',NULL,NULL,NULL,NULL,'2016-10-10 09:22:12','2016-10-10 09:22:12','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ00221342-3225461','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00221342-3225461/SMTJ00221342-3225461_sub20161004_191335_1939_r_0893398031_2016-10-09T22:28:48_04_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00221342-3225461/SMTJ00221342-3225461_sub20161004_191335_1939_r_0893398031_2016-10-09T22:28:48_04_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00221342-3225461/SMTJ00221342-3225461_sub20161004_191335_1939_r_0893398031_2016-10-09T22:28:48_04_diff.png',NULL,8924038784213,34859526500,0.840087026694,0.0817185678905,-0.53626100291,NULL,NULL,NULL,NULL,57664.678,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,544680101,8510626);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1505979,1505979,1,'MASTERJ105440.86-391319.0','MASTER',163.67025,-39.2219444444,NULL,NULL,'2016-10-08 02:55:40',57669.1219907,16.5,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-10 12:19:03','2016-10-10 12:19:03','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/105440.86-391319.0.png',10780914788114,42112948391,-0.743450428356,0.217819217746,-0.632326062216,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,658014818,10281481);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1506798,1442706,1,'SN2016gwl','PESSTO',140.86675,-23.16965,NULL,NULL,'2016-10-10 08:56:17',57671.372419,15.95,NULL,'G-Gaia',0.009,NULL,'SN Ia',NULL,'2016-10-10 13:23:45','2016-10-10 13:23:45','http://wis-tns.weizmann.ac.il/object/2016gwl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10835270897021,42325276941,-0.713116922821,0.580221881608,-0.393454981529,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,661332452,10333319);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1508026,1467285,1,'SN2016gye','TNS',267.051583333,17.6254388889,NULL,NULL,'2016-10-09 20:09:36',57670.84,16.2,NULL,'V-Johnson',0.021171,NULL,'SN Ia',NULL,'2016-10-10 15:25:49','2016-10-10 15:25:49','http://wis-tns.weizmann.ac.il/object/2016gye',NULL,NULL,0.021171,NULL,NULL,NULL,NULL,NULL,14314089155594,55914410764,-0.0490222342198,-0.951794713749,0.302793070317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,873662668,13650979);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1508027,1471872,1,'SN2016gyt','TNS',285.135125,54.5693611111,NULL,NULL,'2016-10-09 20:24:00',57670.85,17.1,NULL,'V-Johnson',0.026,NULL,'SN II',NULL,'2016-10-10 15:25:49','2016-10-10 15:25:49','http://wis-tns.weizmann.ac.il/object/2016gyt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13600375159391,53126465466,0.151361981168,-0.559608189733,0.814817908886,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,830101022,12970328);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1508441,1508441,1,'OGLE16eks','OGLE',80.1815416667,-64.3330833333,NULL,NULL,'2016-10-10 08:46:12',57671.36542,19.681,0.04,'I',NULL,NULL,NULL,NULL,'2016-10-10 16:18:24','2016-10-10 16:18:24','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC573.20.I.738.08.867.40.7663.88168.gif',NULL,NULL,9188486814334,35892526618,0.0738618237726,0.42679454142,-0.90132727153,NULL,NULL,NULL,'2016-10-02 09:09:37',57663.38168,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,560820728,8762823);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1508469,1508469,1,'OGLE16ekf','OGLE',69.40275,-71.8048333333,NULL,NULL,'2016-01-29 03:47:50',57416.15822,21.307,0.293,'I',NULL,NULL,NULL,NULL,'2016-10-10 16:18:26','2016-10-10 16:18:26','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC536.27.I.914.04.3614.36.7664.79290.gif',NULL,NULL,9321180942479,36410863056,0.109850207543,0.292294337221,-0.949998395962,NULL,NULL,NULL,'2016-01-23 04:32:41',57410.18936,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,568919735,8889370);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1508497,1508497,1,'OGLE16eke','OGLE',68.8334166667,-71.8426388889,NULL,NULL,'2016-01-23 04:32:41',57410.18936,21.153,0.295,'I',NULL,NULL,NULL,NULL,'2016-10-10 16:18:27','2016-10-10 16:18:27','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC536.28.I.1239.34.3115.85.7664.79290.gif',NULL,NULL,9321177297890,36410848819,0.112522825788,0.290603759641,-0.950204224659,NULL,NULL,NULL,'2016-01-21 04:29:12',57408.18694,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,568919512,8889367);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1509912,1509912,1,'AT2016hay','Gaia',179.025375,-60.5713611111,NULL,NULL,'2016-10-09 09:11:31',57670.3829977,16.59,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-10 18:27:06','2016-10-10 18:27:06','http://wis-tns.weizmann.ac.il/object/2016hay',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10281010391093,40160196840,-0.491268078498,0.00835748010696,-0.870968327539,NULL,NULL,NULL,'2016-08-28 12:18:43',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,627503075,9804735);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1509913,1509913,1,'AT2016haz','Gaia',159.932125,-40.4449305556,NULL,NULL,'2016-10-09 10:33:36',57670.44,17.61,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-10 18:27:06','2016-10-10 18:27:06','http://wis-tns.weizmann.ac.il/object/2016haz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10783616615931,42123502405,-0.714825263111,0.261134525667,-0.6487168895,NULL,NULL,NULL,'2016-08-22 10:32:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,658179725,10284058);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1509914,1509914,1,'AT2016hba','Gaia',283.782791667,-66.4004611111,NULL,NULL,'2016-10-08 17:42:43',57669.7379977,18.61,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-10 18:27:06','2016-10-10 18:27:06','http://wis-tns.weizmann.ac.il/object/2016hba',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12595237048414,49200144720,0.0953781068846,-0.388814171103,-0.916365951504,NULL,NULL,NULL,'2016-09-07 00:15:50',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,768752261,12011754);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510396,1509385,1,'AT2016gpb','Pan-STARRS1',4.700875,12.0300972222,NULL,NULL,'2016-10-06 11:00:57',57667.4589931,18.92,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016gpb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17082372536345,66728017720,0.974748262404,0.0801538816493,0.208425478762,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1042625276,16291019);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510397,1429495,1,'AT2016hbc','Pan-STARRS1',343.322208333,-13.9065111111,NULL,NULL,'2016-10-06 08:44:09',57667.3639931,20.59,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12917749207547,50459957841,0.929855976809,-0.278577346972,-0.240338353464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,788436841,12319325);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510399,1509436,1,'AT2016hbe','Pan-STARRS1',34.090625,24.8875861111,NULL,NULL,'2016-10-08 09:31:40',57669.3969907,21.15,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17559060269687,68590079178,0.751245895889,0.508452459906,0.420839280397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1071719987,16745624);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510400,1509446,1,'AT2016hbf','Pan-STARRS1',350.515875,3.86350833333,NULL,NULL,'2016-10-08 07:30:43',57669.3129977,20.71,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13254263515596,51774466857,0.984089752554,-0.164399861476,0.0673798520626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,808976044,12640250);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510401,1509441,1,'AT2016hbg','Pan-STARRS1',269.250666667,25.8853083333,NULL,NULL,'2016-10-08 05:54:14',57669.2459954,20.24,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14398550274399,56244337009,-0.0117658459751,-0.899592813275,0.436571111243,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,878817765,13731527);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510402,1509496,1,'AT2016hbh','Pan-STARRS1',6.7055,21.1774916667,NULL,NULL,'2016-10-09 07:16:19',57670.3029977,20.44,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17280183452849,67500716612,0.926087208321,0.108880369706,0.361258283886,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1054698697,16479667);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510403,1509460,1,'AT2016hbi','Pan-STARRS1',28.4791666667,-8.83252222222,NULL,NULL,'2016-10-08 11:32:38',57669.4809954,20.13,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8987900140429,35108984923,0.86856694333,0.47118452927,-0.153546749662,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,548577889,8571529);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510405,1509465,1,'AT2016hbk','Pan-STARRS1',1.523875,14.0501361111,NULL,NULL,'2016-10-06 10:55:12',57667.455,20.7,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:18','2016-10-10 19:28:18','http://wis-tns.weizmann.ac.il/object/2016hbk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17085246492095,66739244109,0.969740574264,0.0257979204764,0.242770850651,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1042800689,16293760);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510406,1509404,1,'AT2016hbl','Pan-STARRS1',21.9782083333,14.2906638889,NULL,NULL,'2016-10-06 12:24:28',57667.5169907,20.77,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:19','2016-10-10 19:28:19','http://wis-tns.weizmann.ac.il/object/2016hbl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17304935389749,67597403866,0.89863104857,0.362672998459,0.246841112325,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1056209435,16503272);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510407,1509412,1,'AT2016hbm','Pan-STARRS1',326.00325,4.65728055556,NULL,NULL,'2016-10-06 06:24:28',57667.2669907,20.87,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:19','2016-10-10 19:28:19','http://wis-tns.weizmann.ac.il/object/2016hbm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13394815820554,52323499299,0.826331871713,-0.557299690577,0.0811953981109,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,817554676,12774291);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510408,1509409,1,'AT2016hbn','Pan-STARRS1',30.604,9.70791388889,NULL,NULL,'2016-10-06 12:20:09',57667.5139931,20.31,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:19','2016-10-10 19:28:19','http://wis-tns.weizmann.ac.il/object/2016hbn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17177001434216,67097661852,0.848381331476,0.501811267462,0.168625526689,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1048400966,16381265);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510409,1509421,1,'AT2016hbo','Pan-STARRS1',335.356416667,-12.2899472222,NULL,NULL,'2016-10-06 08:35:31',57667.3579977,19.34,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:19','2016-10-10 19:28:19','http://wis-tns.weizmann.ac.il/object/2016hbo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12734633805973,49744663304,0.888089433704,-0.407416522044,-0.212858956373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777260364,12144693);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510410,1509486,1,'AT2016hbp','Pan-STARRS1',330.950416667,-9.40988333333,NULL,NULL,'2016-10-06 08:29:45',57667.3539931,18.82,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-10 19:28:19','2016-10-10 19:28:19','http://wis-tns.weizmann.ac.il/object/2016hbp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12768086916602,49875339517,0.862436573262,-0.479032534615,-0.163496140261,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779302179,12176596);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1510428,1510411,1,'SN2016hbb','LCOGT SN-KP',278.946541667,22.4751,NULL,NULL,'2016-10-10 05:42:20',57671.2377315,18.6,NULL,'Clear-',0.013,NULL,'SN II',NULL,'2016-10-10 19:28:20','2016-10-10 19:28:20','http://wis-tns.weizmann.ac.il/object/2016hbb',NULL,NULL,0.013323,NULL,NULL,NULL,NULL,NULL,13977724186972,54600485105,0.143700998268,-0.912803691659,0.38228189022,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,853132579,13330196);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1511650,1511650,1,'AT2016hbq','LOSS',10.6214166667,40.88415,NULL,NULL,'2016-10-07 07:43:19',57668.3217477,19.2,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-10 21:39:58','2016-10-10 21:39:56','http://wis-tns.weizmann.ac.il/object/2016hbq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17324677883817,67674522983,0.743081061979,0.139351346207,0.65453169338,NULL,NULL,NULL,'2016-09-23 10:16:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057414421,16522100);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1512085,1511667,1,'AT2016gta','ATLAS',19.3140416667,6.96463055556,NULL,NULL,'2016-10-09 10:32:09',57670.4389931,18.05,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-10 22:42:22','2016-10-10 22:42:21','http://wis-tns.weizmann.ac.il/object/2016gta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17297280550849,67567502151,0.936756396829,0.32830517501,0.121256608323,NULL,NULL,NULL,'2016-09-19 13:13:26',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1055742221,16495972);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1518406,1518406,1,'SMT16aftf','skymapper',342.573887,-31.95327,NULL,NULL,'2016-10-08 13:00:29',57669.542,18.92,0.03,'g',NULL,NULL,NULL,NULL,'2016-10-11 09:22:44','2016-10-11 09:22:44','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ22501773-3157118','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22501773-3157118/SMTJ22501773-3157118_sub20161004_191335_2064_g_1698799172_2016-10-08T23:59:33_15_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22501773-3157118/SMTJ22501773-3157118_sub20161004_191335_2064_g_1698799172_2016-10-08T23:59:33_15_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22501773-3157118/SMTJ22501773-3157118_sub20161004_191335_2064_g_1698799172_2016-10-08T23:59:33_15_diff.png',NULL,12824174366378,50094431118,0.809538121958,-0.254099114761,-0.529227426513,NULL,NULL,NULL,NULL,57658.565,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,782725486,12230085);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1522454,1420024,1,'SN2016gvc','PESSTO',33.8424166667,-5.30743611111,NULL,NULL,'2016-10-11 02:06:37',57672.0879282,18.36,NULL,'z-Sloan',0.045,NULL,'SN Ia',NULL,'2016-10-11 16:24:13','2016-10-11 16:24:13','http://wis-tns.weizmann.ac.il/object/2016gvc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8996825776923,35143850691,0.827011498283,0.554523007341,-0.0924998164222,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,549122667,8580041);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1522455,1508942,1,'SN2016hax','PESSTO',324.0095,1.88568055556,NULL,NULL,'2016-10-11 01:02:27',57672.0433681,19.26,NULL,'G-Gaia',0.089,NULL,'SN Ia',NULL,'2016-10-11 16:24:13','2016-10-11 16:24:13','http://wis-tns.weizmann.ac.il/object/2016hax',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13340125974377,52109867087,0.808676282739,-0.587332873954,0.032905393306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,814216673,12722135);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1522456,1509470,1,'SN2016hbj','PESSTO',4.59925,16.6924861111,NULL,NULL,'2016-10-11 01:32:05',57672.0639468,20.73,NULL,'w-PS1',0.205,NULL,'SN Ia',NULL,'2016-10-11 16:24:13','2016-10-11 16:24:13','http://wis-tns.weizmann.ac.il/object/2016hbj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17091696006430,66764437525,0.954775793117,0.0768068574462,0.287234906525,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1043194336,16299911);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1522457,1522457,1,'ATLAS16dju','ATLAS',274.456046,-11.1538,NULL,NULL,'2016-10-10 05:29:10',57671.22859,16.92,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-11 17:13:09','2016-10-11 17:13:09',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57671/1181749490110913700_57671.269_02a57671o0121o_7008_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57671/1181749490110913700_57671.269_02a57671o0121o_7008_target.jpeg',NULL,NULL,12156717934192,47487179430,0.0762267634015,-0.978145781149,-0.193443302707,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,741987178,11593549);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1524186,1514652,1,'AT2016hcg','Pan-STARRS1',21.20525,8.8142,NULL,NULL,'2016-10-06 12:15:50',57667.5109954,20.54,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-11 19:24:23','2016-10-11 19:24:23','http://wis-tns.weizmann.ac.il/object/2016hcg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17289985982527,67539007744,0.921280715096,0.357438359682,0.153230750897,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1055296996,16489015);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1524187,1514662,1,'AT2016hch','Pan-STARRS1',10.553625,-21.3909027778,NULL,NULL,'2016-10-09 09:50:24',57670.41,18.78,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-11 19:24:23','2016-10-11 19:24:23','http://wis-tns.weizmann.ac.il/object/2016hch',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9045136394830,35332564042,0.915362940453,0.170538794112,-0.364728949974,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,552071313,8626114);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1524188,1514657,1,'AT2016hci','Pan-STARRS1',22.095125,9.11153055556,NULL,NULL,'2016-10-06 12:15:50',57667.5109954,20.14,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-11 19:24:23','2016-10-11 19:24:23','http://wis-tns.weizmann.ac.il/object/2016hci',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17290548146948,67541203699,0.914869257481,0.371399209481,0.158356777286,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1055331307,16489551);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535534,1535534,1,'AT2016hcs','Gaia',118.270833333,45.38605,NULL,NULL,'2016-09-13 13:24:57',57644.5589931,20.26,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hcs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16270446758031,63556432648,-0.332649827729,0.618551899567,0.711855069276,NULL,NULL,NULL,'2016-05-06 14:57:07',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,993069260,15516707);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535535,1535535,1,'AT2016hct','Gaia',348.479208333,48.3250194444,NULL,NULL,'2016-10-10 12:10:04',57671.5069907,18.65,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hct',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14162827470165,55323544805,0.651507959274,-0.132797017934,0.746928598349,NULL,NULL,NULL,'2016-08-25 13:33:35',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,864430387,13506724);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535536,1535536,1,'AT2016hcu','Gaia',172.0225,-52.74905,NULL,NULL,'2016-10-10 03:02:52',57671.1269907,17.45,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hcu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10252943801354,40050561724,-0.599449413971,0.0840070813822,-0.795991966271,NULL,NULL,NULL,'2016-08-26 18:21:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,625790026,9777969);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535537,1535537,1,'AT2016hcv','Gaia',245.531083333,-69.8647,NULL,NULL,'2016-10-09 17:28:19',57670.7279977,18.36,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hcv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11527406423462,45028931341,-0.142583300477,-0.313320834293,-0.938882344718,NULL,NULL,NULL,'2016-09-03 22:35:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,703577052,10993391);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535538,1535538,1,'AT2016hcw','Gaia',246.437916667,-68.3528,NULL,NULL,'2016-10-10 03:43:12',57671.155,18.98,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hcw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11527143209103,45027903160,-0.147461168509,-0.338135048885,-0.929472911116,NULL,NULL,NULL,'2016-09-04 06:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,703560986,10993140);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535539,1535539,1,'AT2016hcx','Gaia',309.188541667,-30.2637194444,NULL,NULL,'2016-10-10 00:25:55',57671.0179977,16.7,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hcx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13137068116097,51316672328,0.545759228112,-0.669440221783,-0.503980807561,NULL,NULL,NULL,'2016-09-19 12:24:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,801823005,12528484);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1535540,1535540,1,'AT2016hcy','Gaia',313.337333333,-26.2478194444,NULL,NULL,'2016-10-09 12:31:40',57670.5219907,18.08,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 15:26:29','2016-10-12 15:26:29','http://wis-tns.weizmann.ac.il/object/2016hcy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13134181612184,51305396922,0.615528512654,-0.652330864726,-0.442254556828,NULL,NULL,NULL,'2016-09-21 18:25:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,801646826,12525731);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1536438,1536438,1,'AT2016hdc','Gaia',181.776333333,-59.0594694444,NULL,NULL,'2016-10-10 03:11:31',57671.1329977,17.86,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-12 17:50:03','2016-10-12 17:50:03','http://wis-tns.weizmann.ac.il/object/2016hdc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11437181462786,44676490089,-0.513901037415,-0.0159375112142,-0.857701416275,NULL,NULL,NULL,'2016-05-19 11:28:19',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,698070157,10907346);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1538943,1538943,1,'ATLAS16djx','ATLAS',307.822224,33.442018,NULL,NULL,'2016-06-22 11:49:41',57561.49283,16.58,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-13 00:15:25','2016-10-13 00:15:24',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57673/1203117341332631300_57673.358_02a57673o0280o_12660_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57673/1203117341332631300_57673.358_02a57673o0280o_12660_target.jpeg',NULL,NULL,14270196730234,55742955977,0.511692285826,-0.659141637018,0.551092829726,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,870983687,13609120);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540050,1539598,1,'AT2016hdd','Pan-STARRS1',276.757583333,28.7003972222,NULL,NULL,'2016-10-08 05:58:33',57669.2489931,19.6,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-13 00:52:41','2016-10-13 00:52:37','http://wis-tns.weizmann.ac.il/object/2016hdd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13911455396780,54341622643,0.103212373817,-0.871049228107,0.480229578541,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,849087853,13266997);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540051,1539593,1,'AT2016hde','Pan-STARRS1',332.56925,-12.4554583333,NULL,NULL,'2016-10-06 08:32:38',57667.3559954,19.46,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-13 00:52:41','2016-10-13 00:52:41','http://wis-tns.weizmann.ac.il/object/2016hde',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12738340963359,49759144388,0.866678441489,-0.449833711078,-0.215680577328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777486631,12148228);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540052,1539612,1,'AT2016hdf','Pan-STARRS1',16.048625,42.7532222222,NULL,NULL,'2016-10-10 08:42:43',57671.3629977,19.57,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-13 00:52:42','2016-10-13 00:52:42','http://wis-tns.weizmann.ac.il/object/2016hdf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17322936023403,67667718841,0.705667382831,0.202995141327,0.678842041573,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057308106,16520439);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540053,1539607,1,'AT2016hdg','Pan-STARRS1',51.708625,-2.17070833333,NULL,NULL,'2016-10-09 12:04:19',57670.5029977,20.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-13 00:52:42','2016-10-13 00:52:42','http://wis-tns.weizmann.ac.il/object/2016hdg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9429164432734,36832673565,0.619216226936,0.784306446069,-0.0378769448901,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,575510524,8992351);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540054,1539622,1,'AT2016hdh','Pan-STARRS1',308.311416667,82.1900722222,NULL,NULL,'2016-10-11 05:57:07',57672.2479977,18.47,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-13 00:52:42','2016-10-13 00:52:42','http://wis-tns.weizmann.ac.il/object/2016hdh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13474610134917,52635195839,0.084241309296,-0.10662431107,0.990724309834,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,822424934,12850389);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540055,1539617,1,'AT2016hdi','Pan-STARRS1',303.941875,75.7949138889,NULL,NULL,'2016-10-11 05:58:33',57672.2489931,16.31,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-13 00:52:42','2016-10-13 00:52:42','http://wis-tns.weizmann.ac.il/object/2016hdi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13492346604920,52704478925,0.137015816037,-0.203579486988,0.96942357029,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,823507483,12867304);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1540056,1539627,1,'AT2016hdj','Pan-STARRS1',316.535791667,30.7559472222,NULL,NULL,'2016-10-11 07:29:16',57672.3119907,20.04,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-13 00:52:42','2016-10-13 00:52:42','http://wis-tns.weizmann.ac.il/object/2016hdj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14282525019524,55791113357,0.623722287988,-0.591150287543,0.511382288512,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,871736146,13620877);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1547844,1547844,1,'AT2016hdw','Gaia',123.654041667,30.0669805556,NULL,NULL,'2016-10-11 07:35:02',57672.3159954,18.43,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-13 14:26:10','2016-10-13 14:26:10','http://wis-tns.weizmann.ac.il/object/2016hdw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16474559781206,64353749145,-0.479607036649,0.720391558293,0.501012068854,NULL,NULL,NULL,'2016-09-18 13:40:47',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1005527330,15711364);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1547845,1547845,1,'AT2016hdx','Gaia',105.763333333,49.4236194444,NULL,NULL,'2016-10-11 07:13:26',57672.3009954,17.95,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-13 14:26:10','2016-10-13 14:26:10','http://wis-tns.weizmann.ac.il/object/2016hdx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16230343217646,63399778193,-0.176707151767,0.625998646997,0.75953951607,NULL,NULL,NULL,'2016-09-11 09:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,990621534,15478461);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1547846,1547846,1,'AT2016hdy','Gaia',211.523458333,-67.3285305556,NULL,NULL,'2016-10-10 05:15:21',57671.2189931,17.93,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-13 14:26:10','2016-10-13 14:26:10','http://wis-tns.weizmann.ac.il/object/2016hdy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11504144669007,44938065113,-0.328564781054,-0.201529842522,-0.922730137811,NULL,NULL,NULL,'2016-09-01 06:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,702157267,10971207);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1547847,1547847,1,'AT2016hdz','Gaia',197.608583333,-62.5946611111,NULL,NULL,'2016-10-10 21:21:36',57671.89,18.52,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-13 14:26:11','2016-10-13 14:26:11','http://wis-tns.weizmann.ac.il/object/2016hdz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11432795605122,44659357832,-0.438716139081,-0.139241296904,-0.887772499319,NULL,NULL,NULL,'2016-08-30 18:24:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,697802466,10903163);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1548692,1548692,1,'AT2016hek','Gaia',316.420375,-8.83406944444,NULL,NULL,'2016-09-27 04:59:31',57658.2079977,19.38,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-13 15:24:44','2016-10-13 15:24:44','http://wis-tns.weizmann.ac.il/object/2016hek',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13004645170428,50799395196,0.715823464531,-0.681184239505,-0.153573433496,NULL,NULL,NULL,'2016-06-22 10:53:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793740549,12402196);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1548694,1447399,1,'SN2016gxp','TNS',3.644375,48.25225,NULL,NULL,'2016-10-12 23:21:07',57673.9729977,18.6,NULL,'Clear-',0.0186,NULL,'SN Ia',NULL,'2016-10-13 15:24:44','2016-10-13 15:24:44','http://wis-tns.weizmann.ac.il/object/2016gxp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16840410131109,65782852074,0.664505880217,0.0423238818146,0.746083523598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1027857063,16060266);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1550839,1550839,1,'ATLAS16dkd','ATLAS',353.176824,55.11022,NULL,NULL,'2016-10-13 08:35:23',57674.35791,17.42,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-13 20:13:09','2016-10-13 20:13:09',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1233242441550636200_57674.406_02a57674o0432o_11280_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1233242441550636200_57674.406_02a57674o0432o_11280_target.jpeg',NULL,NULL,13612476818263,53173737571,0.567948403456,-0.0679567584234,0.820253918001,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,830839649,12981869);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1550850,1550850,1,'ATLAS16dke','ATLAS',42.07555,36.351449,NULL,NULL,'2016-10-07 11:12:41',57668.46714,18.04,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-13 20:13:10','2016-10-13 20:13:10',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1024818151362105400_57674.486_02a57674o0584o_4232_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1024818151362105400_57674.486_02a57674o0584o_4232_target.jpeg',NULL,NULL,17576351183191,68657621809,0.597815002933,0.53970409799,0.59273662691,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072775340,16762114);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1559706,1559706,1,'AT2016het','Gaia',69.7819583333,65.44955,NULL,NULL,'2016-10-10 18:51:50',57671.7859954,18.67,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-14 11:25:41','2016-10-14 11:25:41','http://wis-tns.weizmann.ac.il/object/2016het',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17001176280253,66410844844,0.143592219516,0.389893324046,0.909595773055,NULL,NULL,NULL,'2016-09-04 21:21:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1037669450,16213585);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1559707,1559707,1,'AT2016heu','Gaia',30.1805833333,63.7760805556,NULL,NULL,'2016-10-11 06:36:00',57672.275,18.27,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-14 11:25:41','2016-10-14 11:25:41','http://wis-tns.weizmann.ac.il/object/2016heu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17029632968503,66522003783,0.381981394874,0.222145218047,0.897073974692,NULL,NULL,NULL,'2016-09-01 03:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1039406309,16240723);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1559708,1559708,1,'AT2016hev','Gaia',188.893291667,-60.0678388889,NULL,NULL,'2016-10-10 17:02:24',57671.71,18.48,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-14 11:25:41','2016-10-14 11:25:41','http://wis-tns.weizmann.ac.il/object/2016hev',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11436361019426,44673285232,-0.49297558317,-0.0771387830575,-0.866616802599,NULL,NULL,NULL,'2016-08-29 16:36:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,698020081,10906563);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1559709,1559709,1,'AT2016hew','Gaia',180.737708333,-55.4779388889,NULL,NULL,'2016-10-10 22:55:12',57671.955,18.75,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-14 11:25:41','2016-10-14 11:25:41','http://wis-tns.weizmann.ac.il/object/2016hew',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11411933828221,44577866516,-0.56667654148,-0.00729661263752,-0.823908039032,NULL,NULL,NULL,'2016-08-28 06:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,696529164,10883268);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1559710,1559710,1,'AT2016hex','Gaia',241.699916667,-61.8182888889,NULL,NULL,'2016-10-11 23:29:45',57672.9789931,16.98,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-14 11:25:41','2016-10-14 11:25:41','http://wis-tns.weizmann.ac.il/object/2016hex',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11361081195878,44379223421,-0.22389797189,-0.415822210083,-0.881454245996,NULL,NULL,NULL,'2016-09-04 16:42:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,693425365,10834771);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1560598,1560143,1,'AT2016hey','Pan-STARRS1',4.072375,28.8781722222,NULL,NULL,'2016-10-10 07:36:28',57671.3169907,20.08,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-14 12:26:35','2016-10-14 12:26:35','http://wis-tns.weizmann.ac.il/object/2016hey',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17208567836608,67220968111,0.873437687214,0.0621855171578,0.482948825456,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1050327626,16411369);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1560599,1560138,1,'AT2016hez','Pan-STARRS1',26.0267916667,11.4347555556,NULL,NULL,'2016-10-06 12:17:16',57667.5119907,21.18,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-14 12:26:35','2016-10-14 12:26:35','http://wis-tns.weizmann.ac.il/object/2016hez',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17163584410079,67045251601,0.880752957981,0.430081849336,0.198251935373,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1047582056,16368469);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1560600,1560156,1,'AT2016hfa','Pan-STARRS1',9.86070833333,25.429775,NULL,NULL,'2016-10-10 07:49:26',57671.3259954,20.38,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-14 12:26:35','2016-10-14 12:26:35','http://wis-tns.weizmann.ac.il/object/2016hfa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17205297870936,67208194808,0.889770586239,0.154661138616,0.429404513327,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1050128043,16408250);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1562448,1560642,1,'AT2016hfc','ATLAS',5.047625,47.4822972222,NULL,NULL,'2016-10-07 09:18:43',57668.3879977,18.33,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-14 15:25:25','2016-10-14 15:25:25','http://wis-tns.weizmann.ac.il/object/2016hfc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16837946534261,65773228649,0.673197089618,0.0594610081072,0.737068563327,NULL,NULL,NULL,'2016-09-29 12:08:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1027706697,16057917);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1562449,1561075,1,'AT2016hfd','ATLAS',94.1880833333,50.0442972222,NULL,NULL,'2016-09-21 14:12:28',57652.5919907,18.31,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-14 15:25:25','2016-10-14 15:25:25','http://wis-tns.weizmann.ac.il/object/2016hfd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15751042638059,61527510304,-0.0469000066814,0.640480302492,0.766541174037,NULL,NULL,NULL,'2016-09-21 13:55:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,961367348,15021364);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1562916,1562916,1,'ATLAS16dkl','ATLAS',34.2693025,57.87792,NULL,NULL,'2016-03-15 05:22:59',57462.22429,16.34,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-14 17:13:16','2016-10-14 17:13:16',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1021704511575239800_57674.470_02a57674o0553o_8952_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1021704511575239800_57674.470_02a57674o0553o_8952_target.jpeg',NULL,NULL,16869392310779,65896063713,0.439417587229,0.29940550032,0.846917074105,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1029625995,16087906);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1562925,1562925,1,'ATLAS16dkm','ATLAS',33.261944,53.171848,NULL,NULL,'2016-10-13 10:06:44',57674.42134,16.03,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-14 17:13:18','2016-10-14 17:13:18',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1021302871531018500_57674.478_02a57674o0569o_2319_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57674/1021302871531018500_57674.478_02a57674o0569o_2319_target.jpeg',NULL,NULL,17352846417956,67784556320,0.501215583309,0.328760753324,0.800436947,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1059133692,16548963);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1563382,1562931,1,'AT2016hff','ATLAS',291.463208333,-31.3546138889,NULL,NULL,'2016-10-06 06:15:50',57667.2609954,17.38,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-14 17:24:31','2016-10-14 17:24:31','http://wis-tns.weizmann.ac.il/object/2016hff',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13097699889408,51162890193,0.312468306661,-0.794743212258,-0.520333339219,NULL,NULL,NULL,'2016-09-28 07:03:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,799420159,12490939);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1564254,1563385,1,'AT2016hfg','ATLAS',44.91825,32.8020388889,NULL,NULL,'2016-09-26 13:37:55',57657.5679977,19.24,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-14 18:25:04','2016-10-14 18:25:04','http://wis-tns.weizmann.ac.il/object/2016hfg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17590307470504,68712138556,0.595204141038,0.593508077373,0.541738121775,NULL,NULL,NULL,'2016-09-26 13:35:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1073627164,16775424);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1564721,1564256,1,'AT2016hfh','ATLAS',290.338041667,47.240925,NULL,NULL,'2016-10-07 06:25:55',57668.2679977,18.07,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-14 19:24:48','2016-10-14 19:24:48','http://wis-tns.weizmann.ac.il/object/2016hfh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14078455599020,54993967183,0.235963246393,-0.636592256334,0.734214985905,NULL,NULL,NULL,'2016-09-29 07:43:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,859280737,13426261);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1564722,1563400,1,'AT2016hfi','ATLAS',266.286166667,14.8324555556,NULL,NULL,'2016-09-22 05:47:02',57653.2409954,18.95,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-14 19:24:48','2016-10-14 19:24:48','http://wis-tns.weizmann.ac.il/object/2016hfi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14327675780104,55967483516,-0.0626149010458,-0.964648518113,0.255993380129,NULL,NULL,NULL,'2016-09-22 05:45:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,874491929,13663936);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1568712,1564291,1,'AT2016hfj','ATLAS',259.394791667,23.0006,NULL,NULL,'2016-09-30 06:25:55',57661.2679977,19.09,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-15 02:40:38','2016-10-15 02:40:36','http://wis-tns.weizmann.ac.il/object/2016hfj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14539035447384,56793107216,-0.169409605626,-0.904777341541,0.390740767972,NULL,NULL,NULL,'2016-09-30 06:05:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,887392300,13865504);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1568713,1564267,1,'AT2016hfk','ATLAS',267.612875,47.4251666667,NULL,NULL,'2016-09-21 05:57:07',57652.2479977,18.74,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-15 02:40:38','2016-10-15 02:40:38','http://wis-tns.weizmann.ac.il/object/2016hfk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14706643017971,57447824288,-0.0281791853182,-0.675965477916,0.736394327912,NULL,NULL,NULL,'2016-09-09 07:27:50',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,897622254,14025347);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1575329,1470712,1,'SN2016hbd','TNS',44.0258333333,27.7015416667,NULL,NULL,'2016-10-12 01:55:12',57673.08,17.45,NULL,'w-PS1',0.022,NULL,'SN IIP',NULL,'2016-10-15 13:23:58','2016-10-15 13:23:58','http://wis-tns.weizmann.ac.il/object/2016hbd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17579933935128,68671616934,0.636612505765,0.615324500859,0.464865868984,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072994014,16765531);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1575764,1496462,1,'SN2016haa','TNS',135.89375,41.7126305556,NULL,NULL,'2016-10-12 05:16:48',57673.22,17.3,NULL,'V-Johnson',0.04,NULL,'SN Ia',NULL,'2016-10-15 14:24:38','2016-10-15 14:24:38','http://wis-tns.weizmann.ac.il/object/2016haa',NULL,NULL,0.040476,NULL,NULL,NULL,NULL,NULL,16454144947422,64274003700,-0.53601851875,0.519551473276,0.66539493098,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1004281307,15691895);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1593053,1593053,1,'ATLAS16dlq','ATLAS',74.6432942857,-8.30106714286,NULL,NULL,'2016-10-10 14:43:49',57671.61376,16.43,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-16 21:16:16','2016-10-16 21:16:14',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57676/1045834380081803800_57676.612_02a57676o0843o_772_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57676/1045834380081803800_57676.612_02a57676o0843o_772_target.jpeg',NULL,NULL,9596790933754,37487464584,0.262052972786,0.954192960236,-0.144374631049,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,585741634,9152213);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601295,1462288,1,'AT2016hfl','Gaia',286.934958333,-27.9643305556,NULL,NULL,'2016-10-14 10:32:09',57675.4389931,17.48,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-17 16:22:37','2016-10-17 16:22:37','http://wis-tns.weizmann.ac.il/object/2016hfl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12194136491975,47633345671,0.257275292827,-0.844938918085,-0.468921793486,NULL,NULL,NULL,'2016-09-16 06:38:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,744271026,11629234);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601296,1601296,1,'AT2016hfm','Gaia',77.0650833333,50.0268111111,NULL,NULL,'2016-10-14 07:04:48',57675.295,18.15,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-17 16:22:37','2016-10-17 16:22:37','http://wis-tns.weizmann.ac.il/object/2016hfm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17461625568464,68209474876,0.14380396097,0.626127412748,0.766345146663,NULL,NULL,NULL,'2016-09-08 03:33:07',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1065773044,16652703);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601297,1601297,1,'AT2016hfn','Gaia',181.192166667,-50.6543,NULL,NULL,'2016-10-13 16:55:12',57674.705,18.99,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-17 16:22:37','2016-10-17 16:22:37','http://wis-tns.weizmann.ac.il/object/2016hfn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11422508735159,44619174746,-0.633860661127,-0.0131907904941,-0.773334769244,NULL,NULL,NULL,'2016-08-27 18:27:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,697174605,10893353);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601298,1601298,1,'AT2016hfo','Gaia',252.5815,-53.8028111111,NULL,NULL,'2016-10-13 15:53:16',57674.6619907,16.05,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-17 16:22:37','2016-10-17 16:22:37','http://wis-tns.weizmann.ac.il/object/2016hfo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11399547602384,44529482821,-0.176785297469,-0.563484913214,-0.806989288144,NULL,NULL,NULL,'2016-09-06 22:48:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,695773169,10871455);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601336,1601336,1,'ATLAS16dlr','ATLAS',342.540066667,50.2366233333,NULL,NULL,'2016-10-17 07:55:35',57678.33027,16.59,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-17 17:14:00','2016-10-17 17:14:00',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1225009591501411700_57678.367_02a57678o0376o_3949_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1225009591501411700_57678.367_02a57678o0376o_3949_target.jpeg',NULL,NULL,14161560066439,55318594009,0.610149341052,-0.191910359921,0.768692523295,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,864353031,13505516);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601353,1601353,1,'AT2016hfp','Gaia',210.716083333,-58.2012,NULL,NULL,'2016-10-13 09:27:21',57674.3939931,18.98,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-17 17:21:51','2016-10-17 17:21:51','http://wis-tns.weizmann.ac.il/object/2016hfp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,11458464789058,44759628082,-0.453013297293,-0.269151636322,-0.849903729337,NULL,NULL,NULL,'2016-03-09 07:00:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,699369188,10927643);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601371,1601290,1,'AT2016gzt','Pan-STARRS1',329.12175,10.1931083333,NULL,NULL,'2016-10-16 08:44:09',57677.3639931,18.99,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016gzt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13399220714794,52340705917,0.844713789622,-0.505115354989,0.176966357752,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,817823529,12778492);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601373,1601281,1,'AT2016hfq','Pan-STARRS1',314.50725,8.49843055556,NULL,NULL,'2016-10-15 05:48:28',57676.2419907,18.49,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hfq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14104421817043,55095397722,0.693302474342,-0.705331173969,0.147782319978,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,860865589,13451024);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601374,1601228,1,'AT2016hfr','Pan-STARRS1',49.092375,-0.363675,NULL,NULL,'2016-10-09 12:00:00',57670.5,20.53,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hfr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9417173878890,36785835464,0.654828206663,0.755751104366,-0.00634728353652,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,574778679,8980916);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601375,1601243,1,'AT2016hfs','Pan-STARRS1',293.128166667,62.2652083333,NULL,NULL,'2016-10-12 05:19:40',57673.2219907,19.98,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hfs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13589681432655,53084693096,0.182796104847,-0.427976346506,0.885111196904,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,829448329,12960130);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601376,1601238,1,'AT2016hft','Pan-STARRS1',49.38225,7.82595,NULL,NULL,'2016-10-12 13:47:59',57673.5749884,20.59,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hft',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17393478108245,67943273860,0.644946080365,0.751999894945,0.136164281017,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1061613654,16587713);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601377,1601248,1,'AT2016hfu','Pan-STARRS1',293.911166667,79.7163777778,NULL,NULL,'2016-10-12 05:32:38',57673.2309954,19.55,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hfu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13533258852268,52864292391,0.0723580764154,-0.163199402013,0.983936107661,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,826004568,12906321);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601378,1601263,1,'AT2016hfv','Pan-STARRS1',275.241125,49.005,NULL,NULL,'2016-10-14 05:25:26',57675.2259954,18.75,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hfv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13539197124165,52887488766,0.0599232500294,-0.653250516643,0.7547668293,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,826367011,12911984);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601380,1430448,1,'AT2016hfx','Pan-STARRS1',76.8657916667,-13.40415,NULL,NULL,'2016-10-15 13:23:31',57676.5579977,18.79,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:05','2016-10-17 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hfx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9604222625824,37516494632,0.22104274979,0.947312171211,-0.231818362175,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,586195228,9159300);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601381,1601268,1,'AT2016hfy','Pan-STARRS1',59.6507083333,34.47745,NULL,NULL,'2016-10-14 12:12:57',57675.5089931,20.22,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-17 19:25:06','2016-10-17 19:25:06','http://wis-tns.weizmann.ac.il/object/2016hfy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17499402976195,68357042875,0.416519022183,0.711381229906,0.566081840282,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1068078794,16688731);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601394,1601394,1,'ATLAS16dlx','ATLAS',49.149866,46.504268,NULL,NULL,'2016-10-17 10:25:57',57678.43469,16.9,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-17 20:13:58','2016-10-17 20:13:58',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1031635991463015200_57678.491_02a57678o0615o_4489_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1031635991463015200_57678.491_02a57678o0615o_4489_target.jpeg',NULL,NULL,17554776803306,68573346887,0.450205494305,0.520646373752,0.725425644981,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1071458545,16741539);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601407,1601407,1,'ATLAS16dma','ATLAS',302.098747692,41.5130607692,NULL,NULL,'2016-09-21 07:50:48',57652.32695,18.53,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-17 20:13:59','2016-10-17 20:13:59',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1200823791413047500_57678.310_02a57678o0262o_6147_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1200823791413047500_57678.310_02a57678o0262o_6147_target.jpeg',NULL,NULL,14070717536121,54963740375,0.397899865353,-0.634337534941,0.66279075802,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,858808443,13418881);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601423,1601422,1,'AT2016hga','Gaia',277.675875,-37.0713694444,NULL,NULL,'2016-10-14 10:19:12',57675.43,16.93,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-17 22:39:31','2016-10-17 22:39:30','http://wis-tns.weizmann.ac.il/object/2016hga',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12169025290695,47535255041,0.10657266284,-0.790735822432,-0.602809361787,NULL,NULL,NULL,'2016-05-01 06:05:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,742738360,11605286);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601425,1601400,1,'AT2016hgb','ATLAS',10.9025416667,41.9422638889,NULL,NULL,'2016-10-16 12:30:14',57677.5209954,17.67,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-18 02:37:05','2016-10-18 02:37:05','http://wis-tns.weizmann.ac.il/object/2016hgb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17332765091002,67706113636,0.730393033704,0.140685131273,0.668381410689,NULL,NULL,NULL,'2016-10-16 11:52:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057908025,16529812);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601526,1601526,1,'ATLAS16dmd','ATLAS',10.7184255556,41.3115422222,NULL,NULL,'2016-10-16 10:42:12',57677.44597,17.16,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-18 12:13:58','2016-10-18 12:13:58',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1004252491411841500_57678.416_02a57678o0470o_2329_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57678/1004252491411841500_57678.416_02a57678o0470o_2329_target.jpeg',NULL,NULL,17324365879065,67673304215,0.738026204123,0.139697326952,0.660152996563,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057395378,16521802);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601538,1601538,1,'AT2016ern','Gaia',315.4185,21.9588194444,NULL,NULL,'2016-10-16 05:35:31',57677.2329977,17.62,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-18 12:22:11','2016-10-18 12:22:11','http://wis-tns.weizmann.ac.il/object/2016ern',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,14142600724961,55244534081,0.66058082497,-0.651000597739,0.373940096039,NULL,NULL,NULL,'2016-10-01 07:10:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,863195845,13487435);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601539,1601539,1,'AT2016hgc','Gaia',107.562208333,19.9402388889,NULL,NULL,'2016-09-17 21:37:26',57648.9009954,19.09,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-18 12:22:11','2016-10-18 12:22:11','http://wis-tns.weizmann.ac.il/object/2016hgc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16155109238414,63105895462,-0.283651383179,0.896233075758,0.341039831601,NULL,NULL,NULL,'2016-04-30 08:35:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,986029616,15406712);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601618,1601618,1,'AT2016hge','Pan-STARRS1',45.8857083333,0.239472222222,NULL,NULL,'2016-10-09 11:54:14',57670.4959954,20.25,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-19 00:52:35','2016-10-19 00:52:32','http://wis-tns.weizmann.ac.il/object/2016hge',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16630224085297,64961812833,0.696085821988,0.71794641837,0.00417956657609,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1015028325,15859817);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601659,1601659,1,'TCPJ01375892+4951055','tocp',24.4955,49.8515277778,NULL,NULL,'2016-10-19 13:49:35',57680.5760995,13.2,NULL,'U',NULL,NULL,NULL,NULL,'2016-10-19 15:18:17','2016-10-19 15:18:17','http://www.cbat.eps.harvard.edu/unconf/followups/J01375892+4951055.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,NULL,17359761381161,67811567895,0.586737202479,0.267335897373,0.764376198741,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1059555748,16555558);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601702,1601702,1,'AT2016hgg','Gaia',123.917916667,-4.36446944444,NULL,NULL,'2016-09-25 20:05:16',57656.8369907,18.06,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-19 17:23:32','2016-10-19 17:23:32','http://wis-tns.weizmann.ac.il/object/2016hgg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10095804241380,39436735317,-0.556386492969,0.827431417993,-0.0761007158981,NULL,NULL,NULL,'2016-06-18 07:24:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,616198989,9628109);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601703,1601703,1,'AT2016hgh','Gaia',101.223791667,23.9124111111,NULL,NULL,'2016-10-16 01:36:28',57677.0669907,18.73,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-19 17:23:32','2016-10-19 17:23:32','http://wis-tns.weizmann.ac.il/object/2016hgh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16102441925941,62900163773,-0.177934830015,0.896682212499,0.405339618168,NULL,NULL,NULL,'2016-09-16 03:44:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,982815058,15356485);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601704,1601704,1,'AT2016hgi','Gaia',98.923125,27.7465388889,NULL,NULL,'2016-10-15 19:32:09',57676.8139931,18.38,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-19 17:23:32','2016-10-19 17:23:32','http://wis-tns.weizmann.ac.il/object/2016hgi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16134456119345,63025219216,-0.137274017529,0.874304720417,0.465561059333,NULL,NULL,NULL,'2016-09-15 03:41:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,984769050,15387016);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601705,1601705,1,'AT2016hgj','Gaia',274.87175,-31.5112694444,NULL,NULL,'2016-10-15 22:22:04',57676.9319907,18.67,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-19 17:23:32','2016-10-19 17:23:32','http://wis-tns.weizmann.ac.il/object/2016hgj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12221703015300,47741027403,0.0724022988633,-0.84945740819,-0.522666259472,NULL,NULL,NULL,'2016-09-13 18:43:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,745953553,11655524);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601706,1601706,1,'AT2016hgk','Gaia',272.837916667,-31.7935805556,NULL,NULL,'2016-10-16 04:20:38',57677.1809954,17.44,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-19 17:23:32','2016-10-19 17:23:32','http://wis-tns.weizmann.ac.il/object/2016hgk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12202320208188,47665313313,0.0420817387359,-0.848909339809,-0.526860569837,NULL,NULL,NULL,'2016-09-13 10:58:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,744770520,11637039);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601707,1601707,1,'AT2016hgl','Gaia',291.454166667,-7.05143055556,NULL,NULL,'2016-10-16 16:53:45',57677.7039931,17.25,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-19 17:23:33','2016-10-19 17:23:33','http://wis-tns.weizmann.ac.il/object/2016hgl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12332982954229,48175714664,0.362990375172,-0.923670889448,-0.122760235902,NULL,NULL,NULL,'2016-04-29 15:43:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,752745541,11761649);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601734,1601734,1,'OGLE16eqx','OGLE',87.2939166667,-63.7902222222,NULL,NULL,'2016-10-19 08:30:43',57680.35467,18.963,0.038,'I',NULL,NULL,NULL,NULL,'2016-10-19 23:33:51','2016-10-19 23:33:51','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC600.13.I.1452.35.4136.16.7664.82097.gif',NULL,NULL,9175972146343,35843641196,0.0208518269928,0.441166459348,-0.897183011686,NULL,NULL,NULL,'2016-10-03 07:42:12',57664.32097,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,560056893,8750888);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601762,1601762,1,'OGLE16eqv','OGLE',85.7826666667,-70.1972777778,NULL,NULL,'2016-10-19 08:18:09',57680.34594,20.559,0.174,'I',NULL,NULL,NULL,NULL,'2016-10-19 23:33:53','2016-10-19 23:33:53','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC552.31.I.1524.53.395.76.7664.81208.gif',NULL,NULL,9091707613088,35514482863,0.0249140419173,0.337865292668,-0.940864673864,NULL,NULL,NULL,'2016-10-03 07:29:24',57664.31208,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,554913794,8670528);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601793,1601793,1,'TCPJ18102829-2729590','tocp',272.617875,-27.4997222222,NULL,NULL,'2016-10-20 09:11:13',57681.3827894,10.7,NULL,'U',NULL,NULL,NULL,NULL,'2016-10-20 11:02:11','2016-10-20 11:02:11','http://www.cbat.eps.harvard.edu/unconf/followups/J18102829-2729590.html','unknown',NULL,NULL,NULL,NULL,NULL,NULL,NULL,12213590803788,47709339077,0.0405140048237,-0.886087357396,-0.461744312879,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,745458423,11647787);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601950,1601950,1,'OGLE16erd','OGLE',10.182,-72.9779722222,NULL,NULL,'2016-10-01 04:27:18',57662.18562,21.1,0.204,'I',NULL,NULL,NULL,NULL,'2016-10-20 13:17:20','2016-10-20 13:17:20','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC713.18.I.1131.03.2367.55.7671.65949.gif',NULL,NULL,9121451763041,35630670949,0.288129045783,0.0517491543994,-0.95619228087,NULL,NULL,NULL,'2016-09-30 04:18:03',57661.1792,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556729233,8698894);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1601984,1601983,1,'SN2016gyp','iPTF',31.71725,42.5369833333,NULL,NULL,'2016-10-19 03:36:13',57680.1501505,NULL,NULL,NULL,0.07,NULL,'SN II',NULL,'2016-10-20 13:21:19','2016-10-20 13:21:19','http://wis-tns.weizmann.ac.il/object/2016gyp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17360818116771,67815695768,0.626795996851,0.387377837371,0.676065965306,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1059620246,16556566);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1602565,1602565,1,'ATLAS16bwx','ATLAS FP',21.19836,-16.86393,NULL,NULL,'2016-07-06 14:42:23',57575.6127703,19.96,0.64,'c',NULL,NULL,NULL,NULL,'2016-10-20 14:34:02','2016-10-20 14:34:02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9008672501984,35190126960,0.892240429792,0.346047874057,-0.290099783359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,0,NULL,0,549845733,8591339);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1609381,1560171,1,'SN2016hfb','TNS',43.4945833333,5.98985,NULL,NULL,'2016-10-19 22:43:37',57680.946956,18.46,NULL,'i-Sloan',0.026,NULL,'SN II',NULL,'2016-10-20 22:41:19','2016-10-20 22:41:16','http://wis-tns.weizmann.ac.il/object/2016hfb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17388818753227,67925073254,0.721478832587,0.684528228451,0.104352281161,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1061329269,16583269);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1616985,1616985,1,'MASTERJ033333.26-623314.7','MASTER',53.3885833333,-62.5540833333,NULL,NULL,'2016-10-20 00:00:00',57681,15.9,NULL,NULL,NULL,NULL,NULL,NULL,'2016-10-21 12:15:10','2016-10-21 12:15:10','http://master.sai.msu.ru/static/OT/033333.26-623314.7.png','SN',NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/033333.26-623314.7.png',NULL,NULL,9289900961888,36288675632,0.274880406216,0.369972744405,-0.887446297348,NULL,NULL,'kate.maguire',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,567010556,8859539);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1617438,1617438,1,'MASTERJ100629.13+222643.8','master',151.621375,22.4455,NULL,NULL,'2016-10-10 00:56:09',57671.0389931,16.8,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-21 12:23:14','2016-10-21 12:23:14','http://observ.pereplet.ru/sn_e.html','PSN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/100629.13222643.8.png',NULL,63688919698,-0.813173085183,0.439289070033,0.381804461058,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,995139370,15549052);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1617887,1617887,1,'OGLE16etc','OGLE',76.5146666667,-66.1233055556,NULL,NULL,'2016-10-12 08:48:23',57673.36693,21.593,0.287,'I',NULL,NULL,NULL,NULL,'2016-10-21 13:21:17','2016-10-21 13:21:17','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC512.22.I.483.63.1655.39.7673.86693.gif',NULL,NULL,NULL,36377342604,0.0943908496436,0.393610029489,-0.914418674454,NULL,NULL,NULL,'2016-10-06 07:32:23',57667.31416,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,568395978,8881187);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1617914,1617914,1,'OGLE16esv','OGLE',46.9831666667,-66.1637222222,NULL,NULL,'2016-01-17 03:48:46',57404.15886,20.581,0.135,'I',NULL,NULL,NULL,NULL,'2016-10-21 13:21:19','2016-10-21 13:21:19','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR204.02.I.1213.88.2814.82.7672.74563.gif',NULL,NULL,NULL,36493430384,0.275699093936,0.295476989495,-0.914703973033,NULL,NULL,NULL,'2016-01-09 03:24:51',57396.14226,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,570209849,8909528);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1617945,1617945,1,'OGLE16esg','OGLE',11.9717083333,-65.8495555556,NULL,NULL,'2016-10-21 03:26:41',57682.14353,20.085,0.07,'I',NULL,NULL,NULL,NULL,'2016-10-21 13:21:21','2016-10-21 13:21:21','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC796.10.I.761.78.2637.57.7682.64353.gif',NULL,NULL,NULL,36042461171,0.400235376097,0.0848661187937,-0.912474320516,NULL,NULL,NULL,'2016-10-13 05:01:26',57674.20933,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,563163455,8799428);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618422,1618422,1,'OGLE16etv','OGLE',349.967,-73.7272777778,NULL,NULL,'2016-08-10 06:52:04',57610.28616,21.379,0.233,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:19:50','2016-10-21 14:19:50','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC746.07.I.117.7637.72736.gif',NULL,NULL,NULL,48441476192,0.275924640192,-0.0488168376044,-0.959938804977,NULL,NULL,NULL,'2016-08-07 06:33:37',57607.27334,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,756898065,11826532);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618442,1618442,1,'OGLE16etu','OGLE',15.72775,-72.0673055556,NULL,NULL,'2016-08-11 07:39:00',57611.31875,21.266,0.241,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:19:52','2016-10-21 14:19:52','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC725.14.I.14646.7636.77541.gif',NULL,NULL,NULL,35576703806,0.296371988689,0.0834613127798,-0.951418863377,NULL,NULL,NULL,'2016-08-04 07:43:34',57604.32192,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,555885996,8685718);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618470,1618470,1,'OGLE16ett','OGLE',1.09854166667,-75.3815833333,NULL,NULL,'2016-09-20 04:25:36',57651.18444,19.582,0.067,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:19:54','2016-10-21 14:19:54','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC709.06.I.1800.7655.67342.gif',NULL,NULL,NULL,35594816345,0.252334009989,0.00483863555699,-0.967628097468,NULL,NULL,NULL,'2016-09-16 04:48:00',57647.2,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556169005,8690140);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618497,1618497,1,'OGLE16ets','OGLE',56.1982083333,-69.5789166667,NULL,NULL,'2016-08-03 09:05:37',57603.3789,20.733,0.107,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:19:55','2016-10-21 14:19:55','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR219.32.I.826.7617.86192.gif',NULL,NULL,NULL,36415742936,0.194110018673,0.289938470757,-0.937153660733,NULL,NULL,NULL,'2016-07-30 10:06:32',57599.4212,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,568995983,8890562);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618524,1618524,1,'OGLE16etr','OGLE',58.4712916667,-71.77525,NULL,NULL,'2016-09-18 07:22:38',57649.30738,20.927,0.185,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:19:57','2016-10-21 14:19:57','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR141.02.I.694.7656.78479.gif',NULL,NULL,NULL,36422714847,0.163542533482,0.26657724918,-0.949837043899,NULL,NULL,NULL,'2016-09-15 07:16:28',57646.3031,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,569104919,8892264);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618552,1618552,1,'OGLE16etq','OGLE',57.6867916667,-73.9228333333,NULL,NULL,'2016-09-12 07:07:08',57643.29662,20.246,0.122,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:19:59','2016-10-21 14:19:59','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR139.26.I.633.7643.79662.gif',NULL,NULL,NULL,35531402469,0.14803308659,0.234045714444,-0.960889592422,NULL,NULL,NULL,'2016-09-05 08:45:36',57636.365,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,555178163,8674658);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618580,1618580,1,'OGLE16etp','OGLE',49.567875,-75.1948333333,NULL,NULL,'2016-08-03 09:52:04',57603.41116,19.845,0.057,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:01','2016-10-21 14:20:01','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR130.29.I.713.7618.87945.gif',NULL,NULL,NULL,35637847681,0.165725066739,0.194505233735,-0.966800349764,NULL,NULL,NULL,'2016-03-23 00:00:20',57470.00023,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556841370,8700646);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618608,1618608,1,'OGLE16eto','OGLE',46.5328333333,-76.7608333333,NULL,NULL,'2016-01-02 02:54:14',57389.121,21.384,0.218,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:04','2016-10-21 14:20:04','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR125.03.I.487.7629.89110.gif',NULL,NULL,NULL,35651217333,0.157549225135,0.166212896494,-0.97342257766,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,557050270,8703910);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618634,1618634,1,'OGLE16etn','OGLE',74.731375,-65.4405833333,NULL,NULL,'2016-03-25 00:56:22',57472.03914,20.642,0.188,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:06','2016-10-21 14:20:06','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC534.19.I.8912.7652.82163.gif',NULL,NULL,NULL,35874133573,0.10945576323,0.400965425726,-0.909530737946,NULL,NULL,NULL,'2016-03-19 01:08:14',57466.04739,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,560533337,8758333);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618657,1618657,1,'OGLE16etm','OGLE',81.9135,-65.0683611111,NULL,NULL,'2016-01-02 05:40:50',57389.23669,20.312,0.104,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:07','2016-10-21 14:20:07','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC520.14.I.15119.7458.64357.gif',NULL,NULL,NULL,35847320632,0.0592966962573,0.417345210798,-0.906811378864,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,560114384,8751787);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618681,1618681,1,'OGLE16etl','OGLE',83.9761666667,-69.6537222222,NULL,NULL,'2016-09-06 09:39:37',57637.40251,18.86,0.041,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:09','2016-10-21 14:20:09','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC516.19.I.68681.7645.85423.gif',NULL,NULL,NULL,35502521194,0.0364876568714,0.345773223953,-0.937608408928,NULL,NULL,NULL,'2016-04-28 23:44:05',57506.98895,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,554726893,8667607);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618708,1618708,1,'OGLE16etk','OGLE',77.6357916667,-69.3585,NULL,NULL,'2016-09-06 09:16:55',57637.38675,16.723,0.006,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:11','2016-10-21 14:20:11','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC509.26.I.73538.7637.88675.gif',NULL,NULL,NULL,36389273356,0.0754833114824,0.344343297093,-0.935804447219,NULL,NULL,NULL,'2016-04-21 00:05:47',57499.00402,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,568582396,8884099);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618734,1618734,1,'OGLE16etj','OGLE',78.4515416667,-67.0909444444,NULL,NULL,'2016-03-16 02:08:40',57463.08935,21.643,0.282,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:13','2016-10-21 14:20:12','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC505.15.I.3145.7639.87036.gif',NULL,NULL,NULL,36379627410,0.0779304541943,0.381389063145,-0.921123893308,NULL,NULL,NULL,'2016-03-11 03:20:31',57458.13925,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,568431678,8881744);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618758,1618758,1,'OGLE16eti','OGLE',0.623291666667,-69.0580277778,NULL,NULL,'2016-09-04 04:45:20',57635.19815,16.819,0.007,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:14','2016-10-21 14:20:14','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC777.28.I.67.7638.66917.gif',NULL,NULL,NULL,35571429090,0.357401109521,0.00388813841073,-0.933942894021,NULL,NULL,NULL,'2016-08-31 04:51:52',57631.20268,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,555803579,8684430);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618783,1618783,1,'OGLE16eth','OGLE',41.8146666667,-69.4460555556,NULL,NULL,'2016-08-29 08:18:08',57629.34593,21.106,0.205,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:16','2016-10-21 14:20:16','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR195.31.I.4969.7649.76478.gif',NULL,NULL,NULL,36451288074,0.261668594153,0.234079282071,-0.936342051036,NULL,NULL,NULL,'2016-08-24 09:59:19',57624.41619,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,569551376,8899240);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618812,1618812,1,'OGLE16etg','OGLE',33.6464583333,-69.5465833333,NULL,NULL,'2016-08-30 08:32:41',57630.35603,21.705,0.208,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:18','2016-10-21 14:20:18','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR183.32.I.10444.7643.78019.gif',NULL,NULL,NULL,36327713693,0.290903864924,0.193616251991,-0.936956609634,NULL,NULL,NULL,'2016-08-25 07:03:42',57625.29424,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,567620526,8869070);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618843,1618843,1,'OGLE16etf','OGLE',42.410875,-73.6600833333,NULL,NULL,'2016-09-01 08:02:08',57632.33482,19.12,0.033,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:20','2016-10-21 14:20:20','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR123.24.I.560.7661.75461.gif',NULL,NULL,NULL,35601354804,0.207717555443,0.189744503958,-0.959609524952,NULL,NULL,NULL,'2016-08-29 09:17:22',57629.38706,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556271168,8691737);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1618874,1618874,1,'OGLE16ete','OGLE',69.64275,-64.6774166667,NULL,NULL,'2016-08-31 10:01:49',57631.41793,18.398,0.031,'I',NULL,NULL,NULL,NULL,'2016-10-21 14:20:22','2016-10-21 14:20:22','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC589.10.I.451.7631.91793.gif',NULL,NULL,NULL,35876093073,0.148790050592,0.400999923294,-0.90391403483,NULL,NULL,NULL,'2016-04-17 00:03:50',57495.00266,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,560563954,8758811);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1622337,1622337,1,'AT2016hhn','Pan-STARRS1',355.430916667,15.4214916667,NULL,NULL,'2016-10-19 09:10:04',57680.3819907,20.37,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-21 19:25:46','2016-10-21 19:25:46','http://wis-tns.weizmann.ac.il/object/2016hhn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13227842176342,51671258501,0.960932155987,-0.0767929147887,0.265917731316,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,807363414,12615053);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1622338,1622338,1,'AT2016hho','Pan-STARRS1',350.120416667,12.0678222222,NULL,NULL,'2016-10-19 08:58:33',57680.3739931,19.97,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-21 19:25:46','2016-10-21 19:25:46','http://wis-tns.weizmann.ac.il/object/2016hho',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13216576693246,51627252707,0.963399053911,-0.167786320655,0.209069398823,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,806675823,12604309);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1625025,1454307,1,'AT2016hhp','Pan-STARRS1',353.655208333,-1.03026944444,NULL,NULL,'2016-10-17 08:58:33',57678.3739931,19.41,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-22 00:54:52','2016-10-22 00:54:50','http://wis-tns.weizmann.ac.il/object/2016hhp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12651841300436,49421255079,0.993714191323,-0.110493452693,-0.0179806249826,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,772207110,12065736);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1625026,1625026,1,'AT2016hhq','Pan-STARRS1',79.58325,76.6454083333,NULL,NULL,'2016-10-17 12:38:52',57678.5269907,19.14,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-22 00:54:52','2016-10-22 00:54:52','http://wis-tns.weizmann.ac.il/object/2016hhq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16810329417975,65665349288,0.0417621625354,0.227170072071,0.972959238682,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1026021082,16031579);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1625028,1625028,1,'AT2016hhs','Pan-STARRS1',327.792125,-10.8761166667,NULL,NULL,'2016-10-19 05:44:09',57680.2389931,21.12,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-22 00:54:53','2016-10-22 00:54:53','http://wis-tns.weizmann.ac.il/object/2016hhs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12775345224990,49903692285,0.830921446196,-0.523418670236,-0.188686104152,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779745191,12183518);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1633421,1562952,1,'SN2016hfe','PESSTO',301.689875,-31.0123638889,NULL,NULL,'2016-10-21 00:54:30',57682.0378472,17.44,NULL,'orange-ATLAS',0.035,NULL,'SN Ia',NULL,'2016-10-22 14:24:57','2016-10-22 14:24:57','http://wis-tns.weizmann.ac.il/object/2016hfe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13140635043499,51330605638,0.4502298391,-0.729272459207,-0.515223031537,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,802040713,12531886);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1633422,1601258,1,'SN2016hfw','PESSTO',70.0271666667,6.34534444444,NULL,NULL,'2016-10-21 07:43:09',57682.3216319,19.73,NULL,'i-Sloan',0.035,NULL,'SN II',NULL,'2016-10-22 14:24:57','2016-10-22 14:24:57','http://wis-tns.weizmann.ac.il/object/2016hfw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16732144554852,65359939667,0.339481997494,0.934096944895,0.110520907138,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1021249057,15957016);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1633423,1601722,1,'SN2016hgm','PESSTO',20.548875,0.952161111111,NULL,NULL,'2016-10-21 04:11:19',57682.1745255,17.9,NULL,'V-crts-CRTS',0.008,NULL,'SN II',NULL,'2016-10-22 14:24:57','2016-10-22 14:24:57','http://wis-tns.weizmann.ac.il/object/2016hgm',NULL,NULL,0.0078,NULL,NULL,NULL,NULL,NULL,17060661237992,66643207960,0.936243815366,0.350957795431,0.0166175814957,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1041300124,16270314);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1633424,1601790,1,'SN2016hgn','PESSTO',355.343375,-5.18668055556,NULL,NULL,'2016-10-21 03:47:26',57682.1579398,19.79,NULL,'i-Sloan',0.025,NULL,'SN Ia',NULL,'2016-10-22 14:24:57','2016-10-22 14:24:57','http://wis-tns.weizmann.ac.il/object/2016hgn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12658250055773,49446289280,0.992618088166,-0.0808515816176,-0.0904010663372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,772598270,12071847);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1637055,1637055,1,'AT2016hif','Gaia',295.623375,-2.69988055556,NULL,NULL,'2016-10-16 11:00:57',57677.4589931,18.3,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-22 20:25:31','2016-10-22 20:25:31','http://wis-tns.weizmann.ac.il/object/2016hif',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12252530695823,47861448030,0.431973598952,-0.900655310478,-0.0471043683251,NULL,NULL,NULL,'2016-09-22 18:53:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,747835125,11684923);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1637056,1637056,1,'AT2016hig','Gaia',156.77425,-43.7281888889,NULL,NULL,'2016-10-17 04:42:14',57678.1959954,15.54,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-22 20:25:31','2016-10-22 20:25:31','http://wis-tns.weizmann.ac.il/object/2016hig',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10788340350379,42141954493,-0.664064146929,0.284971594148,-0.691238019275,NULL,NULL,NULL,'2016-10-07 20:48:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,658468038,10288563);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1639779,1639779,1,'AT2016hih','Yamakami',72.92375,-6.23211111111,NULL,NULL,'2016-10-22 19:25:18',57683.8092361,16.5,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-23 01:45:14','2016-10-23 01:45:12','http://wis-tns.weizmann.ac.il/object/2016hih',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9596091251180,37484731449,0.291908754367,0.950265628279,-0.10855650527,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,585698928,9151545);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648841,1648841,1,'AT2016grm','Pan-STARRS1',345.088708333,25.3998694444,NULL,NULL,'2016-10-07 06:25:55',57668.2679977,19.25,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:04','2016-10-23 16:30:04','http://wis-tns.weizmann.ac.il/object/2016grm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13284671392157,51893247625,0.872916769719,-0.232449414454,0.42893307504,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,810831994,12669249);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648842,1648842,1,'AT2016gtl','Pan-STARRS1',5.49541666667,23.14975,NULL,NULL,'2016-10-09 07:13:26',57670.3009954,18.81,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:04','2016-10-23 16:30:04','http://wis-tns.weizmann.ac.il/object/2016gtl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17268023685402,67453217521,0.915254424863,0.08805508408,0.393135650807,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1053956523,16468070);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648843,1648843,1,'AT2016gwi','Pan-STARRS1',350.787958333,22.6445138889,NULL,NULL,'2016-10-07 06:23:02',57668.2659954,20.88,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016gwi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13441466798165,52505729680,0.911008255337,-0.147747633524,0.385012461481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,820402026,12818781);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648844,1648844,1,'AT2016hin','Pan-STARRS1',357.691291667,6.92039166667,NULL,NULL,'2016-10-08 07:37:55',57669.3179977,20.8,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hin',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13201826462442,51569634618,0.991908719866,-0.0399901730052,0.120490155267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,805775540,12590242);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648845,1648845,1,'AT2016hio','Pan-STARRS1',14.3499166667,14.4372916667,NULL,NULL,'2016-10-06 11:26:52',57667.4769907,21.14,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hio',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17303461995487,67591648419,0.938206525077,0.240016519959,0.249320248774,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1056119506,16501867);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648846,1648846,1,'AT2016hip','Pan-STARRS1',38.44825,28.0423888889,NULL,NULL,'2016-10-08 09:37:26',57669.4009954,21.26,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hip',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17565360877791,68614690928,0.691225947121,0.548807336533,0.470124661547,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072104545,16751633);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648847,1648847,1,'AT2016hiq','Pan-STARRS1',25.331625,15.2292,NULL,NULL,'2016-10-06 12:23:02',57667.5159954,21,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hiq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17135101144545,66933988845,0.872105921145,0.412831660411,0.262680951853,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045843575,16341305);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648848,1648848,1,'AT2016hir','Pan-STARRS1',333.463458333,-8.61576944444,NULL,NULL,'2016-10-06 08:51:21',57667.3689931,21.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hir',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12759587309793,49842137928,0.884553653603,-0.441726788015,-0.149807471936,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,778783405,12168490);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648849,1648849,1,'AT2016his','Pan-STARRS1',353.96575,-0.503738888889,NULL,NULL,'2016-10-08 07:35:02',57669.3159954,20.21,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016his',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12651092455760,49418329905,0.994420798772,-0.105118882303,-0.00879178891648,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,772161404,12065021);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648850,1648850,1,'AT2016hit','Pan-STARRS1',344.058083333,-26.9291083333,NULL,NULL,'2016-10-06 07:43:40',57667.3219907,20.84,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hit',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12827623583883,50107904624,0.857278432841,-0.244880389036,-0.452887716383,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,782936009,12233375);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648851,1648851,1,'AT2016hiu','Pan-STARRS1',333.522708333,-10.28905,NULL,NULL,'2016-10-06 08:51:21',57667.3689931,20.97,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hiu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12765125441934,49863771257,0.88071702444,-0.438673566844,-0.178614178087,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779121425,12173772);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648852,1648852,1,'AT2016hiv','Pan-STARRS1',335.41,-8.41782777778,NULL,NULL,'2016-10-06 08:35:31',57667.3579977,20.86,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hiv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12760048977309,49843941317,0.899512612922,-0.41163914057,-0.146390836956,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,778811583,12168930);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648853,1648853,1,'AT2016hiw','Pan-STARRS1',5.878125,16.9647444444,NULL,NULL,'2016-10-09 07:17:45',57670.3039931,19.14,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hiw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17090764787796,66760799952,0.951455273598,0.0979562162644,0.291783210684,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1043137499,16299023);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648854,1648854,1,'AT2016hix','Pan-STARRS1',348.201583333,26.5484111111,NULL,NULL,'2016-10-09 06:12:57',57670.2589931,20.9,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hix',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13314737643457,52010693919,0.875657763679,-0.182909183582,0.446953813575,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,812667092,12697923);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648855,1648855,1,'AT2016hiy','Pan-STARRS1',344.227791667,-26.3175194444,NULL,NULL,'2016-10-06 07:43:40',57667.3219907,21.08,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hiy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12828973498724,50113177729,0.862603254514,-0.243640264846,-0.443345290545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,783018402,12234662);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1648856,1648856,1,'AT2016hiz','Pan-STARRS1',8.50141666667,13.5388611111,NULL,NULL,'2016-10-06 11:05:16',57667.4619907,21,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-23 16:30:05','2016-10-23 16:30:05','http://wis-tns.weizmann.ac.il/object/2016hiz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17089322659851,66755166640,0.961528905588,0.14372576315,0.234104824228,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1043049478,16297648);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1652158,1652158,1,'OGLE16eut','OGLE',82.5162916667,-72.31275,NULL,NULL,'2016-10-23 06:53:51',57684.2874,18.805,0.038,'I',NULL,NULL,NULL,NULL,'2016-10-23 22:33:15','2016-10-23 22:33:15','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC514.23.I.1659.16.1074.20.7684.78740.gif',NULL,NULL,9090870585742,35511213225,0.0395709538472,0.301233090776,-0.952729113984,NULL,NULL,NULL,'2016-10-10 07:56:58',57671.33123,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,554862706,8669729);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1652187,1652187,1,'OGLE16euo','OGLE',42.5797916667,-75.3915,NULL,NULL,'2016-09-17 05:59:45',57648.24983,21.178,0.266,'I',NULL,NULL,NULL,NULL,'2016-10-23 22:33:17','2016-10-23 22:33:17','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR120.18.I.1588.05.2945.95.7684.72511.gif',NULL,NULL,9122869956185,35636210766,0.185713394906,0.170651372586,-0.967671764591,NULL,NULL,NULL,'2016-09-14 06:21:43',57645.26508,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556815793,8700246);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1652219,1652219,1,'OGLE16eun','OGLE',43.8105,-68.1288611111,NULL,NULL,'2016-10-23 05:09:36',57684.215,20.194,0.09,'I',NULL,NULL,NULL,NULL,'2016-10-23 22:33:19','2016-10-23 22:33:19','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR197.01.I.712.75.1499.87.7684.71500.gif',NULL,NULL,9344928078732,36503625307,0.268823127407,0.257886696009,-0.928024018112,NULL,NULL,NULL,'2016-10-19 06:13:45',57680.25955,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,570369145,8912017);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653715,1653715,1,'AT2016gxs','Pan-STARRS1',1.30929166667,6.27562222222,NULL,NULL,'2016-10-09 08:29:45',57670.3539931,19.26,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:20','2016-10-24 01:08:18','http://wis-tns.weizmann.ac.il/object/2016gxs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17053051667104,66613483074,0.993748035911,0.0227125375532,0.109311398132,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1040835673,16263057);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653716,1653716,1,'AT2016hha','Pan-STARRS1',6.57641666667,11.2280666667,NULL,NULL,'2016-10-19 10:07:40',57680.4219907,20.01,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:20','2016-10-24 01:08:20','http://wis-tns.weizmann.ac.il/object/2016hha',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,17095267994712,66778390604,0.974405823314,0.112336178336,0.194714854414,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1043412353,16303318);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653717,1653717,1,'AT2016hjb','Pan-STARRS1',82.4643333333,-25.6768166667,NULL,NULL,'2016-10-19 13:14:52',57680.5519907,20.43,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:20','2016-10-24 01:08:20','http://wis-tns.weizmann.ac.il/object/2016hjb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9508001900054,37140632422,0.118193254031,0.893468675438,-0.43329445036,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580322381,9067537);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653718,1653718,1,'AT2016hjc','Pan-STARRS1',77.4072083333,-27.2008,NULL,NULL,'2016-10-19 13:12:00',57680.55,19.74,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:20','2016-10-24 01:08:20','http://wis-tns.weizmann.ac.il/object/2016hjc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9538825641861,37261037663,0.193909575714,0.868014520837,-0.457110345609,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,582203713,9096933);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653719,1653719,1,'AT2016hjd','Pan-STARRS1',333.631583333,-25.3649805556,NULL,NULL,'2016-10-19 06:54:43',57680.2879977,19.59,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:20','2016-10-24 01:08:20','http://wis-tns.weizmann.ac.il/object/2016hjd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12936705792398,50534007001,0.809584066886,-0.401324934925,-0.428382930626,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,789593859,12337404);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653720,1653720,1,'AT2016hje','Pan-STARRS1',319.676708333,-12.5843305556,NULL,NULL,'2016-10-19 05:35:31',57680.2329977,21.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:20','http://wis-tns.weizmann.ac.il/object/2016hje',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13044092283134,50953485480,0.744089603078,-0.631554086924,-0.217876336211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,796148210,12439815);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653721,1653721,1,'AT2016hjf','Pan-STARRS1',336.574416667,-25.2128027778,NULL,NULL,'2016-10-19 06:56:09',57680.2889931,20.04,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hjf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12819793854019,50077319742,0.830161355794,-0.359683075406,-0.425981465105,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,782458120,12225908);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653722,1653722,1,'AT2016hjg','Pan-STARRS1',33.710125,-24.8514805556,NULL,NULL,'2016-10-20 10:35:02',57681.4409954,19.15,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hjg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,9829113647848,38394975186,0.7548263821,0.503599359039,-0.420267555803,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,599921487,9373773);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653723,1653723,1,'AT2016hjh','Pan-STARRS1',341.947458333,-26.2249361111,NULL,NULL,'2016-10-19 07:04:48',57680.295,19.47,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hjh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,12830919593954,50120779663,0.852906026041,-0.277990933402,-0.441896313278,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,783137182,12236518);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653724,1653724,1,'AT2016hji','Pan-STARRS1',21.3394583333,-25.523375,NULL,NULL,'2016-10-10 10:12:00',57671.425,20.1,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hji',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8883912754570,34702784197,0.840541134244,0.328380327773,-0.430879289333,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,542231003,8472359);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653725,1653725,1,'AT2016hjj','Pan-STARRS1',333.902583333,79.7784472222,NULL,NULL,'2016-10-12 08:11:02',57673.3409954,17.89,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hjj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,13528289239935,52844879843,0.159362958025,-0.0780621980015,0.984128924914,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,825701247,12901581);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653727,1653727,1,'AT2016hjl','Pan-STARRS1',79.4227083333,3.86407222222,NULL,NULL,'2016-10-13 14:05:16',57674.5869907,21.52,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hjl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,16551036633209,64652486848,0.183144479269,0.980773537521,0.0673896714107,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1010195107,15784298);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1653728,1653728,1,'AT2016hjm','Pan-STARRS1',100.672666667,57.3157722222,NULL,NULL,'2016-10-16 14:26:52',57677.6019907,19.87,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-24 01:08:21','2016-10-24 01:08:21','http://wis-tns.weizmann.ac.il/object/2016hjm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,15795827962970,61702452980,-0.100008431639,0.530667181057,0.841659465907,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,964100827,15064075);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1659634,1601537,1,'SN2016gvd','TNS',20.0942916667,-0.0722777777778,NULL,NULL,'2016-10-23 16:19:12',57684.68,18.6,NULL,'Clear-',0.077,NULL,'SN Ia',NULL,'2016-10-24 10:25:15','2016-10-24 10:25:15','http://wis-tns.weizmann.ac.il/object/2016gvd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,8830762993453,34495167943,0.93912773874,0.343565858295,-0.00126148486367,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,538986999,8421671);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661903,1661903,1,'ATLAS16dni','ATLAS',344.13504,35.710719,NULL,NULL,'2016-10-25 07:47:32',57686.32468,16.83,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:39','2016-10-31 10:24:39',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1225632431354238700_57686.356_02a57686o0359c_4648_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1225632431354238700_57686.356_02a57686o0359c_4648_target.jpeg',NULL,NULL,NULL,55515949444,0.781045162603,-0.221970239456,0.583693127226,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,867436710,13553698);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661925,1661925,1,'ATLAS16dnk','ATLAS',293.79819,54.03898,NULL,NULL,'2016-10-25 05:39:35',57686.23582,17.38,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:40','2016-10-31 10:24:40',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1193511561540220400_57686.290_02a57686o0226c_13516_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1193511561540220400_57686.290_02a57686o0226c_13516_target.jpeg',NULL,NULL,NULL,52996342001,0.236958834879,-0.537303568719,0.809416694672,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,828067843,12938560);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661935,1661935,1,'ATLAS16dnl','ATLAS',86.177205,33.8814541667,NULL,NULL,'2016-02-24 07:57:22',57442.33151,17.63,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-31 10:24:40','2016-10-31 10:24:40',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57685/1054442481335252700_57685.595_02a57685o0730c_4787_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57685/1054442481335252700_57685.595_02a57685o0730c_4787_target.jpeg',NULL,NULL,NULL,64925955762,0.055349673192,0.828345615483,0.557476416531,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1014468058,15851063);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661948,1661948,1,'ATLAS16dno','ATLAS',339.593619,42.5991625,NULL,NULL,'2015-12-28 06:26:51',57384.26865,18.34,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-31 10:24:41','2016-10-31 10:24:41',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1223822681423557700_57686.357_02a57686o0361c_11013_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1223822681423557700_57686.357_02a57686o0361c_11013_target.jpeg',NULL,NULL,NULL,55552129567,0.689911235498,-0.256663154057,0.676865209982,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,868002024,13562531);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661969,1661969,1,'ATLAS16dnp','ATLAS',292.96196,45.88977,NULL,NULL,'2016-10-25 05:25:58',57686.22636,18.31,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:42','2016-10-31 10:24:42',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1193150801455323400_57686.272_02a57686o0189c_2675_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1193150801455323400_57686.272_02a57686o0189c_2675_target.jpeg',NULL,NULL,NULL,54990278885,0.271539445739,-0.640889545824,0.718002033048,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,859223107,13425361);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661974,1661974,1,'ATLAS16dnq','ATLAS',326.811315556,58.87214,NULL,NULL,'2016-10-25 07:04:03',57686.29448,17.95,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:42','2016-10-31 10:24:42',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1214714701585219700_57686.341_02a57686o0327c_9631_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1214714701585219700_57686.341_02a57686o0327c_9631_target.jpeg',NULL,NULL,NULL,53323767349,0.432620894016,-0.282977169521,0.856015819708,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,833183864,13018497);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1661984,1661984,1,'ATLAS16dnr','ATLAS',286.754246667,35.8311366667,NULL,NULL,'2016-10-25 05:09:07',57686.21467,17.84,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:43','2016-10-31 10:24:43',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1190701001354952100_57686.257_02a57686o0159c_10431_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57686/1190701001354952100_57686.257_02a57686o0159c_10431_target.jpeg',NULL,NULL,NULL,54862039992,0.233711458141,-0.776329649713,0.585398350964,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,857219374,13394052);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1662034,1662034,1,'ATLAS16dom','ATLAS',291.110006,-18.779154,NULL,NULL,'2016-10-26 04:49:07',57687.20077,17.82,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:46','2016-10-31 10:24:46',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57687/1192426390184645400_57687.241_02a57687o0108c_5330_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57687/1192426390184645400_57687.241_02a57687o0108c_5330_target.jpeg',NULL,NULL,NULL,48103180076,0.34098714958,-0.88322956842,-0.321921253244,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,751612188,11743940);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1662040,1662040,1,'ATLAS16doo','ATLAS',32.174462,-19.706012,NULL,NULL,'2016-10-26 10:25:34',57687.43442,18.56,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:46','2016-10-31 10:24:46',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57687/1020841870194221200_57687.487_02a57687o0603c_2619_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57687/1020841870194221200_57687.487_02a57687o0603c_2619_target.jpeg',NULL,NULL,NULL,37925462759,0.796859531557,0.501313338588,-0.337194044313,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,592585355,9259146);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1662164,1662164,1,'ATLAS16dpq','ATLAS',308.99872,22.3245142857,NULL,NULL,'2016-10-20 07:46:19',57681.32383,15.54,NULL,'o',NULL,NULL,NULL,NULL,'2016-10-31 10:24:53','2016-10-31 10:24:53',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57689/1203559681221928200_57689.314_02a57689o0257c_5902_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57689/1203559681221928200_57689.314_02a57689o0257c_5902_target.jpeg',NULL,NULL,NULL,55210606797,0.582135056475,-0.718909764169,0.379851980389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,862665731,13479152);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1662172,1662172,1,'ATLAS16dpt','ATLAS',284.718766667,21.21383,NULL,NULL,'2016-10-28 05:13:46',57689.21789,17.49,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:53','2016-10-31 10:24:53',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57689/1185852491211249500_57689.243_02a57689o0123c_14903_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57689/1185852491211249500_57689.243_02a57689o0123c_14903_target.jpeg',NULL,NULL,NULL,54730124232,0.236857751959,-0.901644758301,0.361849602965,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,855158191,13361846);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1662182,1662182,1,'ATLAS16dpz','ATLAS',285.269294,45.087796,NULL,NULL,'2016-10-29 05:04:15',57690.21129,17.27,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:54','2016-10-31 10:24:54',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57690/1190104611450516200_57690.254_02a57690o0145c_2535_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57690/1190104611450516200_57690.254_02a57690o0145c_2535_target.jpeg',NULL,NULL,NULL,54812740737,0.185935303864,-0.681098917857,0.708189471026,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,856449074,13382016);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1662188,1662188,1,'ATLAS16dqa','ATLAS',306.662464,47.474002,NULL,NULL,'2016-10-29 05:57:10',57690.24803,17.02,NULL,'c',NULL,NULL,NULL,NULL,'2016-10-31 10:24:54','2016-10-31 10:24:54',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57690/1202639001472826100_57690.296_02a57690o0227c_4675_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57690/1202639001472826100_57690.296_02a57690o0227c_4675_target.jpeg',NULL,NULL,NULL,54950187131,0.403594459096,-0.542204466171,0.736970711393,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,858596673,13415573);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1666352,1666352,1,'OGLE16exl','OGLE',19.5540416667,-65.4887222222,NULL,NULL,'2016-10-26 04:18:15',57687.17934,20.69,0.154,'I',NULL,NULL,NULL,NULL,'2016-10-31 10:35:44','2016-10-31 10:35:44','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC810.05.I.456.89.4105.92.7687.67934.gif',NULL,NULL,NULL,36347213564,0.3909450913,0.138856037971,-0.909879627373,NULL,NULL,NULL,'2016-10-23 03:33:37',57684.14835,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,567925211,8873831);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1666388,1666388,1,'OGLE16evm','OGLE',3.97529166667,-65.4717777778,NULL,NULL,'2016-10-21 01:47:47',57682.07485,20.304,0.086,'I',NULL,NULL,NULL,NULL,'2016-10-31 10:35:46','2016-10-31 10:35:46','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC787.24.I.1033.18.3986.03.7687.62769.gif',NULL,NULL,NULL,36053414144,0.414142598711,0.0287802081421,-0.909756894754,NULL,NULL,NULL,'2016-10-14 01:57:08',57675.08134,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,563334596,8802103);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1666419,1666419,1,'OGLE16evl','OGLE',66.807875,-73.7651666667,NULL,NULL,'2016-10-19 06:58:48',57680.29083,19.657,0.083,'I',NULL,NULL,NULL,NULL,'2016-10-31 10:35:48','2016-10-31 10:35:48','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC535.13.I.2052.24.2193.69.7686.80191.gif',NULL,NULL,NULL,35528694872,0.110100938786,0.256982279205,-0.960123893804,NULL,NULL,NULL,'2016-10-10 07:15:36',57671.3025,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,555135857,8673997);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1666448,1666448,1,'OGLE16euz','OGLE',355.033,-74.30575,NULL,NULL,'2016-07-01 09:48:55',57570.40897,20.529,0.167,'I',NULL,NULL,NULL,NULL,'2016-10-31 10:35:50','2016-10-31 10:35:50','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC760.05.I.1750.27.1072.90.7686.53797.gif',NULL,NULL,NULL,48440548169,0.269488017638,-0.0234207523582,-0.962718898074,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,756883565,11826305);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1667864,1667864,1,'DES16E1ciy','DES',8.957245,-43.393555,NULL,NULL,'2016-10-09 23:51:22',57670.994,22.2876,0.130037,'g',NULL,NULL,NULL,NULL,'2016-10-31 12:16:15','2016-10-31 12:16:15','https://portal.nersc.gov//des-sn/transients/DES16E1ciy','SN',NULL,NULL,NULL,'http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161009-r2594/D_SN-E1_g_s1/p01/ccd50/stamps/temp13396334.gif','http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161009-r2594/D_SN-E1_g_s1/p01/ccd50/stamps/srch13396334.gif','http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161009-r2594/D_SN-E1_g_s1/p01/ccd50/stamps/diff13396334.gif',NULL,NULL,38174296657,0.717790288086,0.113137815056,-0.687005776638,NULL,NULL,NULL,'2016-10-05 00:57:36',57666.04,NULL,'http://portal.nersc.gov/project/dessn/finders/DES16E1ciy',NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,596473385,9319896);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1668013,1668013,1,'MASTERJ110533.80+194118.7','master',166.390833333,19.6885277778,NULL,NULL,'2016-10-23 01:30:43',57684.0629977,16.7,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-10-31 12:19:35','2016-10-31 12:19:35','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/110533.80194118.7.png',NULL,61162825642,-0.915102805406,0.221541648807,0.336906742856,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,955669150,14932330);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1668514,1668514,1,'SMT16ahvu','skymapper',5.092287,-31.44402,NULL,NULL,'2016-10-24 10:39:22',57685.444,20.27,0.1,'r',NULL,NULL,NULL,NULL,'2016-10-31 12:23:44','2016-10-31 12:23:44','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ00202215-3126385','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00202215-3126385/SMTJ00202215-3126385_sub20161014_104944_1939_r_0893394449_2016-10-24T21:36:25_31_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00202215-3126385/SMTJ00202215-3126385_sub20161014_104944_1939_r_0893394449_2016-10-24T21:36:25_31_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ00202215-3126385/SMTJ00202215-3126385_sub20161014_104944_1939_r_0893394449_2016-10-24T21:36:25_31_diff.png',NULL,NULL,34856194227,0.849782892495,0.0757257974593,-0.521665255909,NULL,NULL,NULL,NULL,57681.418,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,544628034,8509813);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675055,1667961,1,'AT2016fnm','Pan-STARRS1',18.1595833333,38.5024861111,NULL,NULL,'2016-10-10 08:44:09',57671.3639931,20.85,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:31','2016-10-31 21:45:26','http://wis-tns.weizmann.ac.il/object/2016fnm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67896592652,0.743602450586,0.243902938709,0.622548594065,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1060884260,16576316);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675056,1667929,1,'AT2016gmv','Pan-STARRS1',12.0141666667,39.7012472222,NULL,NULL,'2016-10-13 08:29:45',57674.3539931,20.48,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:31','2016-10-31 21:45:31','http://wis-tns.weizmann.ac.il/object/2016gmv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67676693454,0.7525331527,0.160150343861,0.638784565757,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057448335,16522630);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675057,1667899,1,'AT2016gve','Pan-STARRS1',10.3019583333,31.8094277778,NULL,NULL,'2016-10-10 07:43:40',57671.3219907,19.88,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:31','2016-10-31 21:45:31','http://wis-tns.weizmann.ac.il/object/2016gve',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67375104931,0.83610618817,0.151975768083,0.527095634605,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1052736014,16449000);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675058,1667901,1,'AT2016gvs','Pan-STARRS1',28.2247083333,36.5242277778,NULL,NULL,'2016-10-10 08:52:48',57671.37,19.31,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:32','2016-10-31 21:45:32','http://wis-tns.weizmann.ac.il/object/2016gvs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67742944623,0.708056266935,0.380049661522,0.595162648048,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1058483509,16538804);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675062,1667956,1,'AT2016hie','Pan-STARRS1',52.8744166667,18.9991722222,NULL,NULL,'2016-10-25 13:29:16',57686.5619907,19.39,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hie',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68033553360,0.570683868716,0.75387942893,0.325554494093,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1063024271,16609754);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675063,1668520,1,'AT2016hjn','Gaia',55.0749166667,49.3589305556,NULL,NULL,'2016-10-17 12:57:36',57678.54,13.71,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68311171089,0.372882895073,0.534016728152,0.758804639295,NULL,NULL,NULL,'2016-09-05 07:50:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1067362048,16677532);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675064,1668521,1,'AT2016hjo','Gaia',305.214416667,-12.6653194444,NULL,NULL,'2016-10-13 04:56:38',57674.2059954,18.5,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47933506576,0.562606827721,-0.797120130787,-0.219255682927,NULL,NULL,NULL,'2016-09-23 00:40:19',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,748961040,11702516);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675065,1668522,1,'AT2016hjp','Gaia',300.236791667,-22.7772388889,NULL,NULL,'2016-09-19 18:36:00',57650.775,18.78,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50817148724,0.464304560075,-0.796578096673,-0.387149339912,NULL,NULL,NULL,'2016-09-19 16:49:26',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,794017948,12406530);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675066,1668523,1,'AT2016hjq','Gaia',272.651833333,-50.1480194444,NULL,NULL,'2016-10-12 16:06:14',57673.6709954,18.93,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48861082806,0.0296479999597,-0.64012022224,-0.767702479596,NULL,NULL,NULL,'2016-09-09 18:30:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,763454418,11928975);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675067,1668524,1,'AT2016hjr','Gaia',261.582791667,-54.5460388889,NULL,NULL,'2016-10-12 17:42:43',57673.7379977,18.48,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44334626863,-0.0849075967548,-0.573800558202,-0.814581867844,NULL,NULL,NULL,'2016-09-07 18:31:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,692728544,10823883);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675068,1662062,1,'AT2016hjs','Gaia',323.135583333,15.4070111111,NULL,NULL,'2016-10-12 19:19:12',57673.805,18.8,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55132656371,0.771305651852,-0.578363959709,0.265674088935,NULL,NULL,NULL,'2016-10-03 13:06:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,861447755,13460121);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675069,1668526,1,'AT2016hjt','Gaia',248.320958333,-59.8437194444,NULL,NULL,'2016-10-12 05:34:04',57673.2319907,18.17,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44507389813,-0.185575348935,-0.46682724625,-0.864658378799,NULL,NULL,NULL,'2016-07-29 23:09:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,695427965,10866061);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675070,1667910,1,'AT2016hju','Pan-STARRS1',10.9845833333,40.7626388889,NULL,NULL,'2016-10-13 08:26:52',57674.3519907,20.23,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hju',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67673334021,0.743543876981,0.144322673728,0.65292684801,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057395844,16521810);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675071,1667909,1,'AT2016hjv','Pan-STARRS1',9.942,38.9427194444,NULL,NULL,'2016-10-13 08:31:12',57674.355,20.2,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67149032525,0.766094907118,0.134283721815,0.628543137218,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1049203633,16393806);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675072,1667912,1,'AT2016hjw','Pan-STARRS1',77.8984583333,7.06182777778,NULL,NULL,'2016-10-13 14:09:36',57674.59,20.77,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64604469582,0.208054519778,0.97036023866,0.122940327098,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1009444837,15772575);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675073,1667914,1,'AT2016hjx','Pan-STARRS1',80.7685416667,-24.6661166667,NULL,NULL,'2016-10-14 14:35:31',57675.6079977,18.28,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37142428137,0.145785363355,0.896985241456,-0.417329731079,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580350439,9067975);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675074,1667913,1,'AT2016hjy','Pan-STARRS1',44.505375,37.2393194444,NULL,NULL,'2016-10-14 11:58:33',57675.4989931,19.32,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:33','2016-10-31 21:45:33','http://wis-tns.weizmann.ac.il/object/2016hjy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68710228064,0.56777690474,0.558057520669,0.605145594108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1073597313,16774958);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675075,1667900,1,'AT2016hjz','Pan-STARRS1',15.198875,39.8111555556,NULL,NULL,'2016-10-10 08:41:16',57671.3619907,20.9,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hjz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67677284589,0.741289942929,0.201388390375,0.640259273056,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057457571,16522774);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675076,1667902,1,'AT2016hka','Pan-STARRS1',28.651625,-28.8738583333,NULL,NULL,'2016-10-10 10:16:19',57671.4279977,19.47,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hka',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38392634165,0.768458459734,0.419875821224,-0.482882895135,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,599884908,9373201);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675077,1667906,1,'AT2016hkb','Pan-STARRS1',287.722416667,72.8179472222,NULL,NULL,'2016-10-12 05:26:52',57673.2269907,19.82,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52739512755,0.0899241424833,-0.281389429845,0.955370942289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,824054886,12875857);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675078,1667905,1,'AT2016hkc','Pan-STARRS1',58.3689583333,10.9622305556,NULL,NULL,'2016-10-12 13:56:38',57673.5809954,20.81,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65191298147,0.514877557358,0.835906433962,0.190161864186,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1018614033,15915844);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675079,1667907,1,'AT2016hkd','Pan-STARRS1',290.641458333,66.9942305556,NULL,NULL,'2016-10-12 05:24:00',57673.225,20.17,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53613280702,0.137772772199,-0.36573476667,0.920465503802,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,837707510,13089179);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675080,1668527,1,'AT2016hke','Gaia',109.942208333,32.7592694444,NULL,NULL,'2016-10-13 07:30:43',57674.3129977,18.57,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hke',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63458472870,-0.286825124886,0.790525611578,0.541110529534,NULL,NULL,NULL,'2016-09-15 19:46:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,991538638,15492791);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675081,1668528,1,'AT2016hkf','Gaia',252.658333333,-58.6914694444,NULL,NULL,'2016-10-12 09:50:24',57673.41,18.77,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44556340071,-0.154890520763,-0.496025430716,-0.854381471394,NULL,NULL,NULL,'2016-09-06 06:30:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,696192813,10878012);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675082,1668529,1,'AT2016hkg','Gaia',189.7155,-55.6822694444,NULL,NULL,'2016-10-12 11:00:57',57673.4589931,16.5,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44807039380,-0.555695823586,-0.0951415563599,-0.825923868103,NULL,NULL,NULL,'2016-08-29 12:27:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,700109990,10939218);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675083,1668530,1,'AT2016hkh','Gaia',88.3485416667,50.3817611111,NULL,NULL,'2016-10-13 01:09:07',57674.0479977,18.32,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66039728275,0.018377241227,0.637404368409,0.770310293413,NULL,NULL,NULL,'2016-09-09 09:30:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1031870754,16122980);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675084,1668531,1,'AT2016hki','Gaia',249.633708333,-59.6905194444,NULL,NULL,'2016-10-12 05:34:04',57673.2319907,17.69,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hki',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44506283753,-0.175635705179,-0.473121963931,-0.863312056161,NULL,NULL,NULL,'2016-09-05 18:30:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,695410683,10865791);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675085,1668532,1,'AT2016hkj','Gaia',187.6415,-54.60705,NULL,NULL,'2016-10-12 16:59:31',57673.7079977,17.96,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44584772216,-0.57403744581,-0.0770161733388,-0.815199067622,NULL,NULL,NULL,'2016-08-29 00:27:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,696637065,10884954);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675086,1668533,1,'AT2016hkk','Gaia',173.81775,-53.0343,NULL,NULL,'2016-10-18 15:10:04',57679.6319907,18.01,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40048456569,-0.597839663851,0.064758783266,-0.798995642238,NULL,NULL,NULL,'2016-10-10 15:08:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,625757133,9777455);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675087,1668534,1,'AT2016hkl','Gaia',279.917,-7.50273055556,NULL,NULL,'2016-10-18 22:48:00',57679.95,17.62,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47451783385,0.170746931245,-0.97662483167,-0.130573441543,NULL,NULL,NULL,'2016-09-18 23:11:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,741434115,11584908);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675088,1668535,1,'AT2016hkm','Gaia',98.142375,18.4062,NULL,NULL,'2016-09-16 15:46:04',57647.6569907,18.57,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63209619827,-0.134387695576,0.939276744514,0.315751713365,NULL,NULL,NULL,'2016-04-28 00:48:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,987650309,15432036);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675090,1666476,1,'AT2016hko','ASASSN',91.4635,-50.7808694444,NULL,NULL,'2016-10-25 06:01:26',57686.2509954,16.8,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hko',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40325030293,-0.0161487093396,0.632081760965,-0.7747334165,NULL,NULL,NULL,'2016-10-19 08:09:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,630078598,9844978);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675091,1668536,1,'AT2016hkp','Gaia',304.989666667,19.9803111111,NULL,NULL,'2016-10-17 23:26:52',57678.9769907,18.78,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:34','2016-10-31 21:45:34','http://wis-tns.weizmann.ac.il/object/2016hkp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55227978869,0.538914074283,-0.76994456719,0.341697210984,NULL,NULL,NULL,'2016-09-28 07:09:07',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,862937169,13483393);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675092,1668537,1,'AT2016hkq','Gaia',87.4588333333,20.1159111111,NULL,NULL,'2016-10-19 19:37:55',57680.8179977,20.37,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64492888760,0.0416325636828,0.938075391768,0.343920469004,NULL,NULL,NULL,'2016-09-14 15:53:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1007701386,15745334);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675093,1675093,1,'AT2016hkr','POSS',258.615541667,20.3053055556,NULL,NULL,'2016-10-25 02:10:52',57686.0908796,18.1,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56798240139,-0.18512489706,-0.919404240981,0.347022498051,NULL,NULL,NULL,'2016-09-30 03:06:54',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,887472502,13866757);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675094,1668538,1,'AT2016hks','Gaia',234.338958333,-48.5857805556,NULL,NULL,'2016-10-18 11:34:04',57679.4819907,18.67,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hks',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46363691371,-0.385645993631,-0.537453977288,-0.749946924717,NULL,NULL,NULL,'2016-09-05 06:43:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,724432677,11319260);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675095,1668539,1,'AT2016hkt','Gaia',336.220666667,53.5004194444,NULL,NULL,'2016-10-20 06:12:57',57681.2589931,17.79,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53304032139,0.544320020796,-0.239839241595,0.803861215106,NULL,NULL,NULL,'2016-10-06 19:46:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,832875502,13013679);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675096,1668540,1,'AT2016hku','Gaia',49.6576666667,50.4236694444,NULL,NULL,'2016-10-18 00:54:43',57679.0379977,18.81,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hku',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68256969095,0.41243230706,0.485595690258,0.770776503077,NULL,NULL,NULL,'2016-09-04 09:37:26',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1066515142,16664299);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675097,1668541,1,'AT2016hkv','Gaia',85.4135,20.7700888889,NULL,NULL,'2016-10-20 07:36:28',57681.3169907,17.92,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65380429318,0.0747672717496,0.932016790297,0.354618890754,NULL,NULL,NULL,'2016-09-14 03:53:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1021569208,15962018);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675098,1668542,1,'AT2016hkw','Gaia',291.641125,16.0389611111,NULL,NULL,'2016-10-19 19:03:21',57680.7939931,17.7,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54536335278,0.354436244858,-0.893329871581,0.276290949674,NULL,NULL,NULL,'2016-09-24 23:24:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,852130238,13314534);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675099,1671525,1,'AT2016hkx','POSS',258.740041667,29.1531944444,NULL,NULL,'2016-10-25 02:11:40',57686.0914352,17.9,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56314920612,-0.170525212124,-0.856510093445,0.487146396739,NULL,NULL,NULL,'2016-10-03 02:55:50',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,879920634,13748759);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675100,1668543,1,'AT2016hky','Gaia',7.44629166667,53.9656888889,NULL,NULL,'2016-10-13 00:24:28',57674.0169907,18.79,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hky',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65812285093,0.583308612606,0.0762378410291,0.808664858922,NULL,NULL,NULL,'2016-08-29 01:39:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1028316954,16067452);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675101,1667916,1,'AT2016hkz','Pan-STARRS1',29.8516666667,39.864025,NULL,NULL,'2016-10-10 08:55:40',57671.3719907,20.69,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hkz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67850182543,0.665724526527,0.382061662388,0.640967815817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1060159102,16564985);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675102,1667915,1,'AT2016hla','Pan-STARRS1',13.5168333333,25.9275694444,NULL,NULL,'2016-10-10 07:49:26',57671.3259954,20.51,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hla',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67279128491,0.874436732705,0.210205419379,0.437234584817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1051236382,16425568);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675103,1667918,1,'AT2016hlb','Pan-STARRS1',56.0285,13.3322444444,NULL,NULL,'2016-10-12 13:53:45',57673.5789931,20.97,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hlb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65115674676,0.543720904827,0.806964947681,0.230597378278,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1017432416,15897381);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675104,1667917,1,'AT2016hlc','Pan-STARRS1',44.690875,-26.4409916667,NULL,NULL,'2016-10-12 11:02:24',57673.46,20.14,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hlc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38605321129,0.636545469946,0.629713620502,-0.445275892955,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,603208142,9425127);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675105,1667920,1,'AT2016hld','Pan-STARRS1',291.153125,73.1253083333,NULL,NULL,'2016-10-12 05:26:52',57673.2269907,19.13,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hld',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52706196714,0.104750761902,-0.27072030214,0.956941897865,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,823534323,12867723);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675106,1667919,1,'AT2016hle','Pan-STARRS1',57.5814583333,-23.0154916667,NULL,NULL,'2016-10-12 12:46:04',57673.5319907,19.98,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:35','2016-10-31 21:45:35','http://wis-tns.weizmann.ac.il/object/2016hle',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37996465125,0.493425999338,0.776959086511,-0.39098000085,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,593694767,9276480);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675107,1667922,1,'AT2016hlf','Pan-STARRS1',75.6730416667,1.70633888889,NULL,NULL,'2016-10-13 13:03:21',57674.5439931,20.19,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hlf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64586766477,0.247345190116,0.968469771,0.0297768296907,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1009168226,15768253);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675108,1667921,1,'AT2016hlg','Pan-STARRS1',66.7164166667,1.70235833333,NULL,NULL,'2016-10-13 12:56:09',57674.5389931,21.02,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hlg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65030230270,0.395107866061,0.918154260109,0.029707386625,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1016097347,15876521);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675109,1661914,1,'AT2016hlh','ATLAS',280.306916667,43.1237888889,NULL,NULL,'2016-10-25 05:02:24',57686.21,17.96,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hlh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54822750669,0.130590585623,-0.718100798044,0.683576874094,NULL,NULL,NULL,'2016-10-17 06:02:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,856605479,13384460);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675112,1668545,1,'AT2016hlw','Gaia',256.04725,-30.1566805556,NULL,NULL,'2016-10-21 00:01:26',57682.0009954,17.95,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hlw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45860648327,-0.208487002,-0.839143144552,-0.50236635332,NULL,NULL,NULL,'2016-08-02 19:29:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,716572630,11196447);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675113,1662027,1,'AT2016hly','ATLAS',151.331833333,50.0544,NULL,NULL,'2016-10-25 14:36:57',57686.6089931,17.79,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hly',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64001006148,-0.563351680422,0.308019346369,0.766654398297,NULL,NULL,NULL,'2016-10-17 15:36:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1000015721,15625245);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675114,1667934,1,'AT2016hmb','Pan-STARRS1',351.562083333,-1.78013888889,NULL,NULL,'2016-10-17 08:54:14',57678.3709954,19.85,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49424334931,0.988698055535,-0.14666685068,-0.0310642864627,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,772255233,12066488);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675115,1667933,1,'AT2016hmc','Pan-STARRS1',345.798166667,-3.22699444444,NULL,NULL,'2016-10-17 08:48:28',57678.3669907,20.09,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49524457484,0.967900314965,-0.244949385792,-0.0562919060941,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,773819648,12090932);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675116,1667936,1,'AT2016hmd','Pan-STARRS1',326.993708333,-13.7775694444,NULL,NULL,'2016-10-19 05:45:36',57680.24,21.32,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49777143730,0.814481901942,-0.529057898138,-0.238153252817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777767870,12152622);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675117,1667935,1,'AT2016hme','Pan-STARRS1',88.654375,-29.7689277778,NULL,NULL,'2016-10-19 13:20:38',57680.5559954,20.05,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hme',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37151607519,0.0203844335204,0.867795459788,-0.496503287845,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580493867,9070216);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675118,1667937,1,'AT2016hmf','Pan-STARRS1',353.949,10.9915611111,NULL,NULL,'2016-10-19 09:05:45',57680.3789931,20.68,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51795709021,0.976185943492,-0.103479878977,0.190664412977,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,809307953,12645436);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675119,1667925,1,'AT2016hmg','Pan-STARRS1',40.0245833333,27.5531,NULL,NULL,'2016-10-08 09:54:43',57669.4129977,21.62,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68618795555,0.678917033887,0.570175605984,0.4625704697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072168680,16752635);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675120,1667923,1,'AT2016hmh','Pan-STARRS1',30.3627083333,32.4730638889,NULL,NULL,'2016-10-08 09:28:48',57669.395,20.4,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68623261871,0.727932145796,0.426438630289,0.536903050572,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072238466,16753726);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675121,1667927,1,'AT2016hmi','Pan-STARRS1',30.1550416667,28.4572916667,NULL,NULL,'2016-10-10 11:26:52',57671.4769907,21.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68595021700,0.760193455546,0.441644960026,0.476503556576,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1071797214,16746831);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675122,1667926,1,'AT2016hmj','Pan-STARRS1',17.281,41.4844611111,NULL,NULL,'2016-10-10 08:42:43',57671.3629977,20.93,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:36','2016-10-31 21:45:36','http://wis-tns.weizmann.ac.il/object/2016hmj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67892935869,0.715318947793,0.222536848428,0.662416903483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1060827122,16575423);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675123,1667928,1,'AT2016hmk','Pan-STARRS1',50.20975,-29.9809,NULL,NULL,'2016-10-12 12:38:52',57673.5269907,20.69,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38545509339,0.554344670291,0.665575410703,-0.499711275825,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,602273583,9410524);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675124,1667924,1,'AT2016hml','Pan-STARRS1',277.917875,86.8388944444,NULL,NULL,'2016-10-11 06:15:50',57672.2609954,20.1,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hml',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52620510512,0.00759624277423,-0.054618003884,0.998478427783,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,822195476,12846804);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675125,1667930,1,'AT2016hmm','Pan-STARRS1',12.4447083333,34.7922694444,NULL,NULL,'2016-10-13 08:32:38',57674.3559954,20.5,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67328910363,0.801931019583,0.176972084382,0.570602770043,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1052014224,16437722);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675126,1667932,1,'AT2016hmn','Pan-STARRS1',334.717458333,10.9025444444,NULL,NULL,'2016-10-16 08:48:28',57677.3669907,19.84,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52160842396,0.887891970336,-0.419373662231,0.189139050542,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,815013162,12734580);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675128,1662046,1,'AT2016hmp','ATLAS',73.556875,-20.4840055556,NULL,NULL,'2016-10-10 15:02:52',57671.6269907,18.96,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37557070325,0.265165302263,0.898457142213,-0.349945890221,NULL,NULL,NULL,'2016-10-06 15:28:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,586829223,9169206);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675129,1667938,1,'AT2016hmq','Pan-STARRS1',66.2705,-7.56561666667,NULL,NULL,'2016-10-24 13:43:40',57685.5719907,17.69,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36949987111,0.398916004612,0.90748623201,-0.131661535679,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,577343548,9020992);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675130,1667941,1,'AT2016hmr','Pan-STARRS1',20.908,23.4706611111,NULL,NULL,'2016-10-25 10:49:26',57686.4509954,21.25,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67382442919,0.856866564255,0.327342617656,0.398279426694,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1052850670,16450791);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675131,1667940,1,'AT2016hms','Pan-STARRS1',19.254125,24.7562166667,NULL,NULL,'2016-10-25 10:48:00',57686.45,20.11,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hms',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67297740639,0.857303552093,0.299453053169,0.41875826979,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1051527197,16430112);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675132,1667942,1,'AT2016hmt','Pan-STARRS1',34.3037083333,26.2131222222,NULL,NULL,'2016-10-25 12:04:19',57686.5029977,20.86,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68589956130,0.741107333993,0.505619436474,0.441711336691,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1071718064,16745594);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675133,1667944,1,'AT2016hmu','Pan-STARRS1',55.6007916667,24.7716333333,NULL,NULL,'2016-10-25 13:36:28',57686.5669907,20.75,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67986075841,0.512971232352,0.749197796116,0.419002597933,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1062282435,16598163);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675134,1668546,1,'AT2016hmw','Gaia',120.458291667,-11.5594694444,NULL,NULL,'2016-10-17 14:13:55',57678.5929977,18.82,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39451826965,-0.496629455943,0.844514691584,-0.200384927549,NULL,NULL,NULL,'2016-09-26 04:03:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,616434796,9631793);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675135,1668547,1,'AT2016hmx','Gaia',272.459458333,-21.7620111111,NULL,NULL,'2016-10-18 04:29:16',57679.1869907,16.47,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48187486814,0.0398541724995,-0.927876336821,-0.370752138904,NULL,NULL,NULL,'2016-04-06 11:47:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,752929481,11764523);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675136,1668548,1,'AT2016hmy','Gaia',182.00125,-57.7065305556,NULL,NULL,'2016-10-20 03:17:16',57681.1369907,17.62,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hmy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44664452478,-0.533930142006,-0.0186569141762,-0.84532273305,NULL,NULL,NULL,'2016-10-10 17:02:24',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,697882069,10904407);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675137,1668549,1,'AT2016hnd','Gaia',147.0675,-47.42465,NULL,NULL,'2016-10-19 14:55:40',57680.6219907,18.39,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hnd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42075409271,-0.567844017921,0.367811841001,-0.736388227045,NULL,NULL,NULL,'2016-10-05 08:51:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,657428269,10272316);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675138,1498522,1,'AT2016hne','Gaia',75.5630833333,33.3119111111,NULL,NULL,'2016-10-19 19:22:04',57680.8069907,18.58,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:37','2016-10-31 21:45:37','http://wis-tns.weizmann.ac.il/object/2016hne',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64929521754,0.208349941637,0.809304293642,0.549196560543,NULL,NULL,NULL,'2016-09-10 14:00:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1014523777,15851934);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675139,1668551,1,'AT2016hnf','Gaia',109.822416667,-9.93161111111,NULL,NULL,'2016-10-19 08:11:02',57680.3409954,18.22,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39579138678,-0.33402427469,0.926650416413,-0.172472576602,NULL,NULL,NULL,'2016-09-23 16:06:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,618424041,9662875);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675140,1668552,1,'AT2016hng','Gaia',263.9835,-17.3958,NULL,NULL,'2016-10-21 18:17:16',57682.7619907,17.33,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hng',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45973785329,-0.100020864444,-0.949005933764,-0.298970841983,NULL,NULL,NULL,'2016-10-21 16:35:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,718340395,11224068);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675141,1668553,1,'AT2016hnh','Gaia',156.649166667,-49.7391611111,NULL,NULL,'2016-10-19 03:00:00',57680.125,18.33,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42028110435,-0.593335799787,0.256155053727,-0.763110226076,NULL,NULL,NULL,'2016-10-07 04:43:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,656689225,10260769);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675142,1668554,1,'AT2016hni','Gaia',244.760166667,-42.7278305556,NULL,NULL,'2016-10-19 05:44:09',57680.2389931,18.43,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hni',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46433228241,-0.313233144463,-0.664454867024,-0.678516563466,NULL,NULL,NULL,'2016-09-07 12:46:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,725519191,11336237);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675143,1668555,1,'AT2016hnj','Gaia',107.172416667,-24.2792194444,NULL,NULL,'2016-10-21 20:24:00',57682.85,17.45,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39017344642,-0.269134157796,0.870916016545,-0.411183775498,NULL,NULL,NULL,'2016-08-13 21:37:26',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,609646010,9525718);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675146,1662154,1,'AT2016hnm','ATLAS',49.0036666667,15.8948416667,NULL,NULL,'2016-10-27 12:27:21',57688.5189931,18.4,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68154791734,0.630928795894,0.725894369653,0.273872632108,NULL,NULL,NULL,'2016-10-24 11:58:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1064918620,16639353);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675147,1662089,1,'AT2016hnn','ATLAS',271.895041667,10.591075,NULL,NULL,'2016-10-27 04:42:14',57688.1959954,16.27,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53909276911,0.0325053281781,-0.982426390176,0.183798235917,NULL,NULL,NULL,'2016-10-19 06:05:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,842332451,13161444);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675148,1662120,1,'AT2016hno','ATLAS',97.6735,-39.3471416667,NULL,NULL,'2016-10-26 14:19:40',57687.5969907,17.72,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hno',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38982371630,-0.103259582865,0.76639379592,-0.634017356326,NULL,NULL,NULL,'2016-10-14 15:23:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,609099556,9517180);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675149,1662095,1,'AT2016hnp','ATLAS',358.271416667,6.71450833333,NULL,NULL,'2016-10-27 09:07:12',57688.38,17.46,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51567414949,0.992689131837,-0.0299579953111,0.116922222226,NULL,NULL,NULL,'2016-10-19 11:05:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,805740858,12589700);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675150,1662111,1,'AT2016hnq','ATLAS',302.805375,1.04182222222,NULL,NULL,'2016-10-27 06:01:26',57688.2509954,17.64,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54107009090,0.541697499668,-0.84037683542,0.0181822260286,NULL,NULL,NULL,'2016-10-19 07:17:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,845422017,13209719);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675151,1668556,1,'AT2016hnr','Gaia',267.300291667,-2.22333888889,NULL,NULL,'2016-10-23 10:48:00',57684.45,18.04,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45110598053,-0.0470659077425,-0.998138146874,-0.0387948461024,NULL,NULL,NULL,'2016-09-17 13:07:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,704853094,11013329);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675152,1662176,1,'AT2016hns','ATLAS',324.921041667,24.4067,NULL,NULL,'2016-10-28 07:07:40',57689.2969907,17.78,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hns',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55100663950,0.745228299459,-0.52334646034,0.41321091967,NULL,NULL,NULL,'2016-10-24 08:13:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,860947874,13452310);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675153,1667955,1,'AT2016hnt','Pan-STARRS1',38.2119166667,20.6428111111,NULL,NULL,'2016-10-25 12:07:12',57686.505,20.89,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68100578969,0.735281658219,0.578857277985,0.352540968983,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1064071546,16626117);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675154,1667945,1,'AT2016hnu','Pan-STARRS1',53.5602083333,-0.355866666667,NULL,NULL,'2016-10-09 12:04:19',57670.5029977,21.55,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:38','2016-10-31 21:45:38','http://wis-tns.weizmann.ac.il/object/2016hnu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36823933583,0.593966281722,0.804465959251,-0.00621100509752,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,575373962,8990218);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675156,1667950,1,'AT2016hnw','Pan-STARRS1',72.2481666667,-2.45958055556,NULL,NULL,'2016-10-24 13:47:59',57685.5749884,19.35,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hnw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36587866617,0.304613887328,0.951508653208,-0.042914595617,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,571685415,8932584);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675157,1667949,1,'AT2016hnx','Pan-STARRS1',69.7896666667,-6.82902222222,NULL,NULL,'2016-10-24 13:45:07',57685.5729977,19.43,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hnx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37510639124,0.34301649965,0.931772946901,-0.118906923225,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,586103736,9157870);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675158,1667952,1,'AT2016hny','Pan-STARRS1',341.684791667,-11.6395555556,NULL,NULL,'2016-10-25 06:14:24',57686.26,21.42,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hny',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50352647163,0.929820015604,-0.307782395045,-0.201754147126,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,786760111,12293126);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675159,1667951,1,'AT2016hnz','Pan-STARRS1',328.877791667,-13.4945611111,NULL,NULL,'2016-10-25 06:02:52',57686.2519907,21.52,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hnz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49773274085,0.832432580343,-0.502595611787,-0.233353059113,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777707407,12151678);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675160,1667954,1,'AT2016hoa','Pan-STARRS1',27.0279583333,17.6137388889,NULL,NULL,'2016-10-25 11:02:24',57686.46,21.53,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hoa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66969773581,0.84902323027,0.433120923773,0.302598446546,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046402712,16350042);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675161,1667953,1,'AT2016hob','Pan-STARRS1',16.033875,15.6000833333,NULL,NULL,'2016-10-25 10:52:19',57686.4529977,21.04,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hob',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67642204532,0.925693782769,0.266030819987,0.268921221478,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1056909445,16514210);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675162,1675162,1,'AT2016hoc','ASASSN',145.996041667,-5.09683055556,NULL,NULL,'2016-10-27 14:38:24',57688.61,16.1,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hoc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,41296895072,-0.825721060882,0.557038891307,-0.0888391984869,NULL,NULL,NULL,'2016-10-20 14:24:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,645263985,10082249);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675163,1667981,1,'AT2016hod','Pan-STARRS1',21.5833333333,-7.48035833333,NULL,NULL,'2016-10-27 09:44:38',57688.4059954,19.15,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hod',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35289144731,0.921969801454,0.364723472018,-0.130186305605,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,551392886,8615513);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675164,1667982,1,'AT2016hoe','Pan-STARRS1',22.203375,-5.17415555556,NULL,NULL,'2016-10-27 09:44:38',57688.4059954,20.81,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hoe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35244688946,0.922075660338,0.376355468637,-0.0901833567709,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,550698264,8604660);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675165,1667983,1,'AT2016hof','Pan-STARRS1',23.0169583333,-0.097475,NULL,NULL,'2016-10-27 09:41:45',57688.4039931,21.6,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hof',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34963911049,0.920387833089,0.39100299541,-0.00170125886773,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546311110,8536111);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675166,1667984,1,'AT2016hog','Pan-STARRS1',24.835375,-6.21380277778,NULL,NULL,'2016-10-27 09:46:04',57688.4069907,19.4,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hog',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34992302238,0.9021865866,0.417544865692,-0.108238847432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546754722,8543042);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675167,1667977,1,'AT2016hoh','Pan-STARRS1',14.5818333333,-2.64183888889,NULL,NULL,'2016-10-27 09:33:07',57688.3979977,20.48,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hoh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34553973228,0.96676045771,0.251494937134,-0.0460924506194,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,539905831,8436028);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675168,1667978,1,'AT2016hoi','Pan-STARRS1',16.6771666667,-1.35020833333,NULL,NULL,'2016-10-27 09:34:33',57688.3989931,21.29,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hoi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34553246735,0.957670960376,0.286899107416,-0.0235633999267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,539894480,8435851);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675169,1667979,1,'AT2016hoj','Pan-STARRS1',18.402125,-1.76731111111,NULL,NULL,'2016-10-27 09:36:00',57688.4,20.36,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:39','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hoj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34510176995,0.948412946865,0.315534063709,-0.0308405067785,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,539221515,8425336);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675170,1667980,1,'AT2016hok','Pan-STARRS1',19.0792916667,-8.97849166667,NULL,NULL,'2016-10-27 09:38:52',57688.4019907,21.12,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:39','http://wis-tns.weizmann.ac.il/object/2016hok',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35285116777,0.933487204362,0.322871128593,-0.156063684482,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,551329949,8614530);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675171,1667985,1,'AT2016hol','Pan-STARRS1',25.1513333333,0.256225,NULL,NULL,'2016-10-27 09:48:57',57688.4089931,20.68,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hol',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66989367161,0.905179329016,0.425006334001,0.00447195497048,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046708861,16354825);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675172,1667986,1,'AT2016hom','Pan-STARRS1',28.2529166667,-3.73805,NULL,NULL,'2016-10-27 09:47:31',57688.4079977,20.17,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hom',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35015221735,0.878992636139,0.472357445806,-0.0651950075211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,547112839,8548638);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675173,1667958,1,'AT2016hon','Pan-STARRS1',37.5990833333,25.8571583333,NULL,NULL,'2016-10-08 09:38:52',57669.4019907,20.17,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hon',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68614231199,0.712977665762,0.549048547169,0.436129041657,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1072097362,16751521);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675174,1667957,1,'AT2016hoo','Pan-STARRS1',351.558625,22.6355111111,NULL,NULL,'2016-10-07 06:38:52',57668.2769907,21.09,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hoo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52508292107,0.912972921009,-0.135489844829,0.384867441405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,820442064,12819407);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675175,1667960,1,'AT2016hop','Pan-STARRS1',11.4973333333,-21.6429388889,NULL,NULL,'2016-10-09 09:53:16',57670.4119907,20.87,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hop',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35331498045,0.910848972986,0.185270170803,-0.368821246975,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,552054656,8625854);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675176,1667959,1,'AT2016hoq','Pan-STARRS1',10.888875,-18.8651472222,NULL,NULL,'2016-10-09 09:50:24',57670.41,20.31,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hoq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35353031676,0.929244798362,0.17875722972,-0.323341858625,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,552391119,8631111);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675177,1667962,1,'AT2016hor','Pan-STARRS1',28.8151666667,-23.3767305556,NULL,NULL,'2016-10-10 10:29:16',57671.4369907,20.76,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hor',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37920678310,0.804258700325,0.442422239327,-0.396775131656,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,592510598,9257978);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675178,1667964,1,'AT2016hos','Pan-STARRS1',315.453916667,-15.7784444444,NULL,NULL,'2016-10-19 05:29:45',57680.2289931,21.8,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hos',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51000070222,0.685832704362,-0.675051094144,-0.271918226536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,796876097,12451189);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675180,1667967,1,'AT2016hou','Pan-STARRS1',27.8007916667,18.3922055556,NULL,NULL,'2016-10-25 10:59:31',57686.4579977,20.02,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hou',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66912950780,0.839389529254,0.442574715993,0.31551995015,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045514855,16336169);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675181,1667970,1,'AT2016hov','Pan-STARRS1',36.5315,22.8094666667,NULL,NULL,'2016-10-25 12:04:19',57686.5029977,20.25,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hov',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68106477727,0.740692980689,0.548714416727,0.387667895543,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1064163714,16627558);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675182,1667972,1,'AT2016how','Pan-STARRS1',38.6012083333,23.2272388889,NULL,NULL,'2016-10-25 12:07:12',57686.505,21.24,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016how',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68087699393,0.718164546705,0.573328023562,0.394378829622,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1063870303,16622973);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675183,1667971,1,'AT2016hox','Pan-STARRS1',37.3528333333,18.806875,NULL,NULL,'2016-10-25 12:07:12',57686.505,21.35,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hox',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68101265593,0.752474338534,0.574329146009,0.322379282667,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1064082274,16626285);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675184,1667974,1,'AT2016hoy','Pan-STARRS1',128.890708333,-27.8068916667,NULL,NULL,'2016-10-26 15:21:36',57687.64,17.47,NULL,'z-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hoy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42727995617,-0.555337301145,0.688465488582,-0.466493036378,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,667624931,10431639);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675185,1667973,1,'AT2016hoz','Pan-STARRS1',10.9579583333,14.1770472222,NULL,NULL,'2016-10-26 10:04:48',57687.42,20.26,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hoz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67462748331,0.951865785629,0.184299232738,0.2449190049,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1054105442,16470397);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675186,1667976,1,'AT2016hpa','Pan-STARRS1',332.404458333,-26.4389361111,NULL,NULL,'2016-10-26 06:23:02',57687.2659954,21.13,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:40','2016-10-31 21:45:40','http://wis-tns.weizmann.ac.il/object/2016hpa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51407796219,0.793547288667,-0.414777876111,-0.445243769343,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,803246815,12550731);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675187,1667975,1,'AT2016hpb','Pan-STARRS1',317.129375,-11.8812666667,NULL,NULL,'2016-10-27 05:39:50',57688.2359954,21.14,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50780133375,0.717190586335,-0.66576973608,-0.205884242701,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793439583,12397493);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675188,1667988,1,'AT2016hpc','Pan-STARRS1',30.7125,-3.25142777778,NULL,NULL,'2016-10-27 09:50:24',57688.41,20.53,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35007683795,0.858356906531,0.509908351837,-0.0567176668904,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546995059,8546797);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675189,1667987,1,'AT2016hpd','Pan-STARRS1',28.5743333333,-1.92308333333,NULL,NULL,'2016-10-27 09:48:57',57688.4089931,19.44,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35003149660,0.877702705186,0.478029113195,-0.0335578343587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546924213,8545690);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675191,1668557,1,'AT2016hpf','Gaia',358.027625,71.5618611111,NULL,NULL,'2016-10-07 12:27:21',57668.5189931,18.15,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52754654628,0.316093201143,-0.0108856310686,0.948665689918,NULL,NULL,NULL,'2016-08-29 15:07:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,824291478,12879554);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675192,1668558,1,'AT2016hpg','Gaia',107.235083333,-18.6288194444,NULL,NULL,'2016-09-24 10:13:26',57655.4259954,16.04,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39686155077,-0.28076950827,0.905057529067,-0.319435990936,NULL,NULL,NULL,'2016-08-11 05:19:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,620096173,9689002);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675193,1668559,1,'AT2016hph','Gaia',283.729125,9.64748055556,NULL,NULL,'2016-10-20 12:53:16',57681.5369907,18.6,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hph',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54661840236,0.233975512372,-0.95769017284,0.167585776413,NULL,NULL,NULL,'2016-09-22 11:22:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,854091253,13345175);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675194,1668560,1,'AT2016hpi','Gaia',227.599,-59.2377388889,NULL,NULL,'2016-10-13 03:36:00',57674.15,18.61,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44839622219,-0.344896743986,-0.377696891326,-0.859296976761,NULL,NULL,NULL,'2016-09-03 10:46:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,700619097,10947173);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675195,1667989,1,'AT2016hpj','Pan-STARRS1',319.477125,-23.0368555556,NULL,NULL,'2016-10-28 05:12:28',57689.2169907,17.64,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50918797214,0.699527451469,-0.597936055671,-0.391323163089,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,795606206,12431346);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675196,1666479,1,'AT2016hpk','ASASSN',68.70075,-21.4509305556,NULL,NULL,'2016-10-29 04:19:12',57690.18,16.6,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37374094575,0.338077868789,0.867158433086,-0.365704261068,NULL,NULL,NULL,'2016-10-26 05:16:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,583970227,9124534);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675197,1668011,1,'AT2016hpl','Pan-STARRS1',68.970625,10.5855222222,NULL,NULL,'2016-10-28 13:40:47',57689.5699884,20.97,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65340188372,0.35273961784,0.917511841965,0.183702971831,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1020940443,15952194);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675198,1668012,1,'AT2016hpm','Pan-STARRS1',328.972583333,-21.9033611111,NULL,NULL,'2016-10-28 05:08:09',57689.2139931,19.75,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50884673519,0.795063388504,-0.478240229391,-0.373042211087,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,795073023,12423015);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675199,1448163,1,'AT2016hpn','Pan-STARRS1',278.844958333,26.5726583333,NULL,NULL,'2016-10-08 06:04:19',57669.2529977,18.75,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54314872603,0.137519087931,-0.883732014776,0.447332344587,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,848669884,13260466);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675200,1667996,1,'AT2016hpo','Pan-STARRS1',301.6065,59.5705694444,NULL,NULL,'2016-10-11 06:04:19',57672.2529977,18.24,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52976727050,0.265435608256,-0.431349767798,0.862253626081,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,827761360,12933771);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675201,1441947,1,'AT2016hpp','Pan-STARRS1',331.718291667,-13.7504777778,NULL,NULL,'2016-10-25 06:02:52',57686.2519907,20.4,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49750022880,0.855389921069,-0.460227822968,-0.237693992141,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777344107,12146001);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675202,1668009,1,'AT2016hpq','Pan-STARRS1',126.351666667,7.13177222222,NULL,NULL,'2016-10-27 14:42:43',57688.6129977,20.04,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:41','2016-10-31 21:45:41','http://wis-tns.weizmann.ac.il/object/2016hpq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62570456642,-0.588153804642,0.799162967533,0.124151735427,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,977663385,15275990);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675203,1668008,1,'AT2016hpr','Pan-STARRS1',123.332833333,7.79472222222,NULL,NULL,'2016-10-27 14:41:16',57688.6119907,20.44,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hpr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62798914458,-0.544424476991,0.827772937176,0.135624309518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,981233038,15331766);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675204,1662194,1,'AT2016hps','ATLAS',130.936583333,52.5429583333,NULL,NULL,'2016-10-17 13:50:52',57678.5769907,18.07,NULL,'orange-ATLAS',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hps',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63487808525,-0.398484810508,0.459430367143,0.79380954488,NULL,NULL,NULL,'2016-10-13 15:05:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,991997008,15499953);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675205,1675205,1,'AT2016hpt','ASASSN',328.652416667,-42.85055,NULL,NULL,'2016-10-30 01:55:12',57691.08,17,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hpt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50635776066,0.626112987938,-0.381395224736,-0.680088383141,NULL,NULL,NULL,'2016-10-20 05:02:24',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,791184001,12362250);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675206,1668561,1,'AT2016hpu','Gaia',278.33125,26.8775388889,NULL,NULL,'2016-10-23 23:22:33',57684.9739931,18.1,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hpu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54315318365,0.129243479032,-0.882561732118,0.452085071783,NULL,NULL,NULL,'2016-09-24 07:23:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,848676849,13260575);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675207,1675207,1,'AT2016hpv','Grzegorzek',258.161666667,23.2745277778,NULL,NULL,'2016-10-30 17:18:14',57691.7209954,16.8,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hpv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56794519299,-0.188456168196,-0.899083371296,0.395137145973,NULL,NULL,NULL,'2016-09-14 21:31:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,887414364,13865849);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675210,1668563,1,'AT2016hpy','Gaia',96.3095416667,-4.11453888889,NULL,NULL,'2016-10-21 14:02:24',57682.585,18.89,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hpy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38700181960,-0.10961658243,0.991380887589,-0.0717505441037,NULL,NULL,NULL,'2016-09-20 04:07:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,604690343,9448286);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675211,1668564,1,'AT2016hpz','Gaia',284.813041667,18.2427388889,NULL,NULL,'2016-10-21 11:15:21',57682.4689931,18.81,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hpz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54733518452,0.242815750301,-0.918174444684,0.313043448318,NULL,NULL,NULL,'2016-09-24 01:14:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,855211225,13362675);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675212,1668566,1,'AT2016hqa','Gaia',243.565583333,-52.4817194444,NULL,NULL,'2016-10-25 09:54:43',57686.4129977,17.28,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hqa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46335699801,-0.271116906365,-0.54533871234,-0.793159070998,NULL,NULL,NULL,'2016-08-01 07:03:21',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,723995309,11312426);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675213,1675213,1,'AT2016hqb','Emmanouilidi',89.3274166667,68.5407777778,NULL,NULL,'2016-10-30 03:55:26',57691.1634954,14.818,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016hqb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65632934273,0.00429440931453,0.365813743861,0.930678173619,NULL,NULL,NULL,'2016-10-14 01:33:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1025514598,16023665);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675214,1675214,1,'SN2016geh','iPTF',19.8249583333,44.123475,NULL,NULL,'2016-09-29 05:35:26',57660.2329398,NULL,NULL,NULL,0.1033,NULL,'SN Ia',NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016geh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67900863178,0.67529691056,0.243454190821,0.696206966038,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1060950987,16577359);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675215,1509390,1,'SN2016gmh','iPTF',14.0274583333,14.3457388889,NULL,NULL,'2016-09-29 08:35:52',57660.3582407,19.08,NULL,'w-PS1',0.08389,NULL,'SN Ia',NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016gmh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67591487776,0.93992777142,0.234828822628,0.247772493583,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1056116996,16501828);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675216,1675216,1,'SN2016gmt','iPTF',15.3806666667,38.5451444444,NULL,NULL,'2016-10-10 10:01:54',57671.4179861,NULL,NULL,NULL,0.15,NULL,'SN Ia',NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016gmt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67664434340,0.754105852861,0.207441619837,0.623131075328,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057256786,16519637);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675218,1675218,1,'SN2016gwm','iPTF',357.175333333,30.5582194444,NULL,NULL,'2016-10-26 07:39:40',57687.319213,NULL,NULL,NULL,0.05,NULL,'SN II',NULL,'2016-10-31 21:45:42','2016-10-31 21:45:42','http://wis-tns.weizmann.ac.il/object/2016gwm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51974051253,0.860066755305,-0.042435446767,0.508413620271,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,812094550,12688977);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675219,1601701,1,'SN2016hgf','PTSS',72.9415416667,44.60085,NULL,NULL,'2016-10-23 18:48:57',57684.7839931,17.84,NULL,'G-Gaia',0.017179,NULL,'SN IIn',NULL,'2016-10-31 21:45:43','2016-10-31 21:45:43','http://wis-tns.weizmann.ac.il/object/2016hgf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68203747364,0.208867834583,0.680691181073,0.702163616037,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1065683552,16651305);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675220,1625916,1,'SN2016hht','TNS',156.022166667,16.7410194444,NULL,NULL,'2016-10-23 19:12:00',57684.8,15.5,NULL,'V-Johnson',0.019,NULL,'SN Ia',NULL,'2016-10-31 21:45:43','2016-10-31 21:45:43','http://wis-tns.weizmann.ac.il/object/2016hht',NULL,NULL,0.018596,NULL,NULL,NULL,NULL,NULL,NULL,60963383943,-0.874976846846,0.389159246038,0.288046174607,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,952552874,14883638);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675221,1649326,1,'SN2016hhz','iPTF',17.9282916667,35.2755277778,NULL,NULL,'2016-10-26 05:48:08',57687.2417593,20,NULL,'Clear-',0.0167,NULL,'SN II',NULL,'2016-10-31 21:45:43','2016-10-31 21:45:43','http://wis-tns.weizmann.ac.il/object/2016hhz',NULL,NULL,0.0161,NULL,NULL,NULL,NULL,NULL,NULL,67750462986,0.776742765256,0.251304699487,0.577508982301,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1058600984,16540640);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1675222,1653726,1,'SN2016hjk','Pan-STARRS1',37.9308333333,-25.0016194444,NULL,NULL,'2016-10-12 10:42:14',57673.4459954,19.42,NULL,'i-Sloan',0.085,NULL,'SN Ia-91T-like',NULL,'2016-10-31 21:45:43','2016-10-31 21:45:43','http://wis-tns.weizmann.ac.il/object/2016hjk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37941951160,0.714843923867,0.557108891395,-0.422643878032,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,592842986,9263171);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702494,1702494,1,'OGLE16fcd','OGLE',35.1685833333,-67.5540277778,NULL,NULL,'2016-01-07 03:19:57',57394.13885,19.422,0.087,'I',NULL,NULL,NULL,NULL,'2016-11-02 15:22:25','2016-11-02 15:22:25','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR185.21.I.305.01.986.32.7693.80031.gif',NULL,NULL,NULL,36478221642,0.312116425205,0.219917712809,-0.924239977879,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,569972213,8905815);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702546,1702546,1,'OGLE16fbw','OGLE',96.979,-70.4153333333,NULL,NULL,'2016-10-23 08:35:25',57684.35793,19.571,0.14,'I',NULL,NULL,NULL,NULL,'2016-11-02 15:22:28','2016-11-02 15:22:28','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC611.02.I.1702.09.1961.57.7692.81588.gif',NULL,NULL,NULL,39877304342,-0.0407285925192,0.332715871317,-0.942147191645,NULL,NULL,NULL,'2016-10-03 08:53:17',57664.37034,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,623082880,9735670);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702590,1702590,1,'OGLE16exz','OGLE',356.1995,-66.09375,NULL,NULL,'2016-10-29 01:24:20',57690.05856,19.966,0.068,'I',NULL,NULL,NULL,NULL,'2016-11-02 15:22:30','2016-11-02 15:22:29','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameSMC766.23.I.1445.49.3621.13.7690.55856.gif',NULL,NULL,NULL,48723704421,0.404350143741,-0.026860451104,-0.914209755704,NULL,NULL,NULL,'2016-10-25 01:13:38',57686.05114,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,761307881,11895435);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702807,1672130,1,'AT2016hqc','Pan-STARRS1',31.9795,5.54075277778,NULL,NULL,'2016-10-29 09:46:04',57690.4069907,20.37,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:03','2016-11-02 15:50:03','http://wis-tns.weizmann.ac.il/object/2016hqc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67071221759,0.844274485344,0.527141320532,0.096553723821,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1047987839,16374809);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702808,1672129,1,'AT2016hqd','Pan-STARRS1',60.6585416667,14.1153138889,NULL,NULL,'2016-10-28 13:32:09',57689.5639931,20.49,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:03','2016-11-02 15:50:03','http://wis-tns.weizmann.ac.il/object/2016hqd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65149716084,0.475218301765,0.845395130355,0.243874228323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1017964313,15905692);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702811,1672133,1,'AT2016hqg','Pan-STARRS1',351.083708333,3.15067777778,NULL,NULL,'2016-10-29 06:08:38',57690.2559954,19.18,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51773262922,0.986422548182,-0.154757022231,0.0549619914893,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,808957233,12639956);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702813,1671506,1,'AT2016hqi','ATLAS',106.919333333,-38.6714444444,NULL,NULL,'2016-10-26 14:44:09',57687.6139931,16.85,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42632350327,-0.227215445758,0.746947851793,-0.624853621187,NULL,NULL,NULL,'2016-04-03 06:44:38',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,666130473,10408288);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702814,1671496,1,'AT2016hqj','ATLAS',292.410333333,46.12695,NULL,NULL,'2016-10-25 05:25:26',57686.2259954,18.26,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54992499602,0.264221271695,-0.640720847225,0.720877184766,NULL,NULL,NULL,'2016-10-17 06:56:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,859257806,13425903);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702816,1674554,1,'AT2016hql','Pan-STARRS1',330.92175,-13.0610472222,NULL,NULL,'2016-10-19 05:45:36',57680.24,20.71,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hql',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49749022361,0.851347368786,-0.473430657342,-0.225989093432,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777328474,12145757);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702817,1674553,1,'AT2016hqm','Pan-STARRS1',329.712291667,-11.4350138889,NULL,NULL,'2016-10-19 05:45:36',57680.24,19.68,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49916484497,0.84636339145,-0.494331293221,-0.198256354643,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779945070,12186641);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702818,1674556,1,'AT2016hqn','Pan-STARRS1',350.57875,13.0648694444,NULL,NULL,'2016-10-19 08:58:33',57680.3739931,20.76,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51626435255,0.960975425715,-0.159454649433,0.226054077483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,806663050,12604110);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702819,1674555,1,'AT2016hqo','Pan-STARRS1',336.593083333,-30.827575,NULL,NULL,'2016-10-19 06:59:02',57680.2909954,19.98,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50589107946,0.788046987033,-0.341131335703,-0.512456201084,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,790454811,12350856);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702820,1674558,1,'AT2016hqp','Pan-STARRS1',356.15025,11.2417666667,NULL,NULL,'2016-10-19 09:07:12',57680.38,20.46,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51781228214,0.978600144845,-0.065852067753,0.19494938236,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,809081690,12641901);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702821,1674557,1,'AT2016hqq','Pan-STARRS1',352.421125,12.8082472222,NULL,NULL,'2016-10-19 09:02:52',57680.3769907,19.46,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51638496913,0.966599058215,-0.128609137475,0.221688859474,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,806851514,12607054);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702822,1674559,1,'AT2016hqr','Pan-STARRS1',357.079291667,14.6601972222,NULL,NULL,'2016-10-19 09:10:04',57680.3819907,20.72,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51663497875,0.966187098865,-0.0492950371761,0.253085932633,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,807242154,12613158);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702823,1674544,1,'AT2016hqs','Pan-STARRS1',358.02075,-7.64386111111,NULL,NULL,'2016-10-17 09:20:09',57678.3889931,20.12,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49442310282,0.990522706722,-0.0342306586323,-0.133015147546,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,772536098,12070876);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702824,1674543,1,'AT2016hqt','Pan-STARRS1',62.3710416667,62.1931583333,NULL,NULL,'2016-10-16 12:56:09',57677.5389931,19.65,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:04','2016-11-02 15:50:04','http://wis-tns.weizmann.ac.il/object/2016hqt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66203931269,0.216332932442,0.413297828647,0.884525277862,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1034436426,16163069);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702825,1674546,1,'AT2016hqu','Pan-STARRS1',83.276125,-29.6051166667,NULL,NULL,'2016-10-19 13:17:45',57680.5539931,19.77,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hqu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37283261408,0.101799282322,0.86347068685,-0.494019512843,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,582550959,9102358);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702826,1674545,1,'AT2016hqv','Pan-STARRS1',5.836375,11.8004138889,NULL,NULL,'2016-10-19 10:09:07',57680.4229977,20.3,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hqv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66756641360,0.973791814585,0.0995388093689,0.204503122904,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1043072521,16298008);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702827,1674548,1,'AT2016hqw','Pan-STARRS1',316.1125,-8.98046388889,NULL,NULL,'2016-10-19 05:32:38',57680.2309954,20.48,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hqw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50800230012,0.71186772965,-0.684746557794,-0.156097684391,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793753593,12402399);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702828,1674547,1,'AT2016hqx','Pan-STARRS1',87.055,-25.7224722222,NULL,NULL,'2016-10-19 13:22:04',57680.5569907,19.84,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hqx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37121721281,0.0462861773437,0.899717049255,-0.434012466487,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580026895,9062920);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702829,1674550,1,'AT2016hqy','Pan-STARRS1',322.898875,-13.1379222222,NULL,NULL,'2016-10-19 05:36:57',57680.2339931,21.19,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hqy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50953016710,0.776696226227,-0.587434716025,-0.227295900917,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,796140886,12439701);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702830,1674549,1,'AT2016hqz','Pan-STARRS1',320.449916667,-12.0808972222,NULL,NULL,'2016-10-19 05:35:31',57680.2329977,19.92,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hqz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50770925218,0.753991485778,-0.62265035695,-0.209292552101,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793295706,12395245);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702831,1674552,1,'AT2016hra','Pan-STARRS1',328.305625,-15.5670611111,NULL,NULL,'2016-10-19 05:45:36',57680.24,21.41,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hra',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49767401127,0.81965050358,-0.506115311874,-0.268366061691,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,777615642,12150244);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702832,1674551,1,'AT2016hrb','Pan-STARRS1',323.107458333,-8.40914166667,NULL,NULL,'2016-10-19 05:41:16',57680.2369907,21.15,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hrb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49693131024,0.791164569926,-0.593862132179,-0.146240867262,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,776455172,12132112);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702833,1675379,1,'AT2016hrc','ATLAS',102.211416667,-38.6002972222,NULL,NULL,'2016-10-30 14:45:36',57691.615,17.27,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hrc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,42461122288,-0.165306174562,0.763834444669,-0.623883650843,NULL,NULL,NULL,'2016-10-26 14:58:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,663455035,10366484);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702834,1685038,1,'AT2016hrd','Gaia',298.921,37.1748194444,NULL,NULL,'2016-10-21 11:39:50',57682.4859954,18.24,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hrd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54859740345,0.385332899084,-0.69742505644,0.604248994648,NULL,NULL,NULL,'2016-04-25 21:01:26',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,857183442,13393491);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702835,1685039,1,'AT2016hre','Gaia',280.524833333,57.3622805556,NULL,NULL,'2016-09-29 12:08:38',57660.5059954,18.04,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hre',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53112720640,0.0985140582648,-0.530251578499,0.842097526314,NULL,NULL,NULL,'2016-08-23 12:50:24',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,829886260,12966972);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702836,1685040,1,'AT2016hrf','Gaia',284.456041667,21.1261111111,NULL,NULL,'2016-10-21 23:18:14',57682.9709954,18.72,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hrf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54730483224,0.232858882441,-0.903256754986,0.360421940841,NULL,NULL,NULL,'2016-08-13 06:41:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,855163800,13361934);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702837,1685041,1,'AT2016hrg','Gaia',95.1476666667,-40.0174,NULL,NULL,'2016-10-25 20:38:24',57686.86,18.95,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hrg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38984365391,-0.0687142210268,0.762760352318,-0.643020218003,NULL,NULL,NULL,'2016-09-25 22:36:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,609130709,9517667);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702838,1685042,1,'AT2016hrh','Gaia',218.757541667,-57.7624888889,NULL,NULL,'2016-10-22 03:37:26',57683.1509954,18.77,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hrh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44706792509,-0.415969951035,-0.333941212437,-0.845844114759,NULL,NULL,NULL,'2016-10-13 23:26:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,698543632,10914744);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702839,1685043,1,'AT2016hri','Gaia',245.13475,-56.5888,NULL,NULL,'2016-10-26 09:51:50',57687.4109954,14.97,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:05','2016-11-02 15:50:05','http://wis-tns.weizmann.ac.il/object/2016hri',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44404330352,-0.231537846982,-0.499598794407,-0.834740241058,NULL,NULL,NULL,'2016-05-01 12:28:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,693817661,10840900);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702840,1685044,1,'AT2016hrj','Gaia',79.334875,21.3468611111,NULL,NULL,'2016-10-22 19:36:28',57683.8169907,18.86,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65396925419,0.172371639224,0.915304575332,0.364013121148,NULL,NULL,NULL,'2016-09-13 02:09:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1021826959,15966046);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702841,1685045,1,'AT2016hrl','Gaia',274.302875,7.39246944444,NULL,NULL,'2016-10-22 12:46:04',57683.5319907,18.17,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53912830838,0.074405130757,-0.988892880001,0.12866525716,NULL,NULL,NULL,'2016-08-09 14:12:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,842387981,13162312);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702842,1685046,1,'AT2016hrm','Gaia',152.141416667,-61.7304388889,NULL,NULL,'2016-10-22 15:08:38',57683.6309954,18.41,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40084586042,-0.418729505294,0.221318473025,-0.880729092794,NULL,NULL,NULL,'2016-10-05 21:05:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,626321656,9786275);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702843,1691397,1,'AT2016hrn','Gaia',256.59625,-26.17275,NULL,NULL,'2016-10-22 22:20:38',57683.9309954,19.76,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45836544078,-0.208043524832,-0.873021849881,-0.441079064801,NULL,NULL,NULL,'2016-10-22 18:11:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,716196001,11190562);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702844,1691398,1,'AT2016hro','Gaia',260.3355,-19.9933611111,NULL,NULL,'2016-10-22 16:27:50',57683.6859954,18.53,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hro',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46021186237,-0.15776094617,-0.926395258645,-0.341911258404,NULL,NULL,NULL,'2016-09-13 11:12:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,719081034,11235641);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702845,1691399,1,'AT2016hrq','Gaia',149.566791667,-61.1238611111,NULL,NULL,'2016-10-22 15:07:12',57683.63,18.89,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40083781875,-0.416381453242,0.244614060279,-0.875665716418,NULL,NULL,NULL,'2016-10-05 10:50:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,626309091,9786079);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702846,1691400,1,'AT2016hrr','Gaia',260.982541667,-17.2801388889,NULL,NULL,'2016-10-23 04:30:43',57684.1879977,18.54,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45996893206,-0.149660974716,-0.943062307781,-0.297043896233,NULL,NULL,NULL,'2016-09-14 01:00:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,718701456,11229710);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702847,1691401,1,'AT2016hrs','Gaia',68.214875,54.2295888889,NULL,NULL,'2016-10-26 19:06:14',57687.7959954,16.54,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66188036813,0.216937977178,0.542792278823,0.811365796733,NULL,NULL,NULL,'2016-04-30 09:17:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1034188075,16159188);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702848,1691402,1,'AT2016hrt','ATLAS',278.649875,31.5336472222,NULL,NULL,'2016-11-01 04:55:12',57693.205,16.83,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54490995030,0.128187485456,-0.842638602324,0.52299919163,NULL,NULL,NULL,'2016-10-28 05:08:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,851421797,13303465);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702849,1691406,1,'AT2016hru','ATLAS',273.500333333,31.2883222222,NULL,NULL,'2016-10-28 04:52:19',57689.2029977,17.7,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hru',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54338269134,0.0521748891597,-0.852970459571,0.519344948989,NULL,NULL,NULL,'2016-10-24 06:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,849035455,13266178);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702850,1702850,1,'AT2016hrv','ISSP',128.341833333,52.5309444444,NULL,NULL,'2016-10-31 03:36:00',57692.15,17.4,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63501688845,-0.377380420568,0.477129847777,0.793682005927,NULL,NULL,NULL,'2015-10-30 04:33:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,992213888,15503342);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702851,1702800,1,'AT2016hrz','Gaia',177.952625,-71.5514694444,NULL,NULL,'2016-10-24 15:21:36',57685.64,18.51,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hrz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39805795787,-0.316250624401,0.0113055333989,-0.948608310885,NULL,NULL,NULL,'2016-10-07 11:08:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,621965559,9718211);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702852,1702801,1,'AT2016hsa','Gaia',136.358458333,-66.7304305556,NULL,NULL,'2016-10-24 15:07:12',57685.63,18.13,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hsa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40799511337,-0.285892027672,0.272646829183,-0.918656331307,NULL,NULL,NULL,'2016-10-04 03:07:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,637492364,9960818);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702853,1702802,1,'AT2016hsb','Gaia',253.633708333,-60.5915805556,NULL,NULL,'2016-10-28 03:51:50',57689.1609954,17.06,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:06','2016-11-02 15:50:06','http://wis-tns.weizmann.ac.il/object/2016hsb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44500943101,-0.138361470554,-0.471135122017,-0.871141664868,NULL,NULL,NULL,'2016-10-11 21:57:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,695327235,10864488);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702855,1702804,1,'AT2016hsd','Gaia',274.610583333,23.3837111111,NULL,NULL,'2016-09-22 23:39:50',57653.9859954,19.84,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hsd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54298707199,0.0737809814351,-0.914897320114,0.396886961774,NULL,NULL,NULL,'2016-08-15 02:22:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,848417299,13256520);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702856,1702805,1,'AT2016hse','Gaia',285.749833333,40.2303888889,NULL,NULL,'2016-09-27 11:51:21',57658.4939931,19.38,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hse',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54784099739,0.207230045618,-0.734790498085,0.645862703767,NULL,NULL,NULL,'2016-08-19 02:35:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,856001558,13375024);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702858,1702858,1,'SN2016gyd','iPTF',349.166708333,29.8954805556,NULL,NULL,'2016-10-22 04:38:46',57683.193588,NULL,NULL,NULL,0.117,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016gyd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52065917741,0.851485711555,-0.162942402383,0.498419358094,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,813529964,12711405);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702859,1601233,1,'SN2016gzy','iPTF',10.7447916667,31.0367083333,NULL,NULL,'2016-10-22 11:05:29',57683.4621412,19.79,NULL,'i-Sloan',0.116,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016gzy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67370256950,0.841814522997,0.159744200897,0.515587140211,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1052660264,16447816);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702860,1661988,1,'SN2016hdv','iPTF',32.5994166667,44.1768416667,NULL,NULL,'2016-10-13 18:48:36',57674.78375,17.91,NULL,'orange-ATLAS',0.039,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hdv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67827797504,0.604204336259,0.38639612625,0.696875278415,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1059809336,16559520);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702861,1601607,1,'SN2016hgd','ASASSN',149.781083333,50.9848944444,NULL,NULL,'2016-10-27 11:16:48',57688.47,17.74,NULL,'orange-ATLAS',0.026,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hgd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63993677022,-0.543978238264,0.3168433774,0.776980019365,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,999901203,15623456);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702862,1662128,1,'SN2016hgw','iPTF',44.39175,5.97813888889,NULL,NULL,'2016-10-22 09:04:51',57683.3783681,17.16,NULL,'cyan-ATLAS',0.023,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hgw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67924893638,0.710687355935,0.695756040895,0.104148997463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1061326463,16583225);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702863,1675061,1,'SN2016hhh','iPTF',23.9777083333,29.3241666667,NULL,NULL,'2016-10-22 10:19:33',57683.4302431,17.9,NULL,'Clear-',0.07,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hhh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67724495282,0.796624190348,0.354308629904,0.489750236476,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1058195238,16534300);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702864,1672683,1,'SN2016hid','iPTF',59.5486666667,15.8006472222,NULL,NULL,'2016-10-23 05:09:59',57684.2152662,18.44,NULL,'cyan-ATLAS',0.04,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hid',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65155440919,0.487656599293,0.829486943297,0.27229111639,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1018053764,15907090);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702865,1662007,1,'SN2016hli','ASASSN',55.9102083333,46.1591027778,NULL,NULL,'2016-10-30 07:40:48',57691.32,18.04,NULL,'cyan-ATLAS',0.017,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hli',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68277884427,0.388228990341,0.573631946769,0.721265998578,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1066841944,16669405);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702866,1666477,1,'SN2016hmo','LCOGT SN-KP',299.672125,-52.3565694444,NULL,NULL,'2016-11-01 10:35:35',57693.4413773,16.8,NULL,'V-Johnson',0.019,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hmo',NULL,NULL,0.018913,NULL,NULL,NULL,NULL,NULL,NULL,51111346362,0.302341040585,-0.53065998607,-0.791826921973,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,798614786,12478356);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702867,1608929,1,'SN2016hnv','ASASSN',30.3769583333,14.2594833333,NULL,NULL,'2016-10-27 09:21:36',57688.39,17.75,NULL,'i-Sloan',0.048,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hnv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66959642739,0.836136921594,0.490106726628,0.246313712289,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046244417,16347569);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702868,1661884,1,'SN2016hot','ASASSN',28.3310416667,17.3148388889,NULL,NULL,'2016-10-27 09:36:00',57688.4,17.94,NULL,'w-PS1',0.074,NULL,'SN Ia',NULL,'2016-11-02 15:50:07','2016-11-02 15:50:07','http://wis-tns.weizmann.ac.il/object/2016hot',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66968954083,0.840332087628,0.453059650765,0.297622135185,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1046389907,16349842);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1702869,1666478,1,'SN2016hpe','ASASSN',140.3295,17.0327194444,NULL,NULL,'2016-11-01 05:56:12',57693.2473611,16.4,NULL,'V-Johnson',0.028,NULL,'SN Ia-91T-like',NULL,'2016-11-02 15:50:08','2016-11-02 15:50:08','http://wis-tns.weizmann.ac.il/object/2016hpe',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63861749629,-0.735966233586,0.610371104471,0.292917766359,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,997839837,15591247);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1703426,1694481,1,'AT2016hsg','Pan-STARRS1',121.064333333,-0.0197083333333,NULL,NULL,'2016-10-28 14:45:36',57689.615,20.02,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 16:26:40','2016-11-02 16:26:40','http://wis-tns.weizmann.ac.il/object/2016hsg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39293300430,-0.516000171373,0.856588410396,-0.000343975299963,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,613957819,9593090);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1703427,1694480,1,'AT2016hsh','Pan-STARRS1',125.639583333,6.28452222222,NULL,NULL,'2016-10-27 14:42:43',57688.6129977,20.47,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 16:26:40','2016-11-02 16:26:40','http://wis-tns.weizmann.ac.il/object/2016hsh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62567355476,-0.579182963134,0.807814541701,0.109465800284,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,977614929,15275233);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1703428,1694483,1,'AT2016hsi','Pan-STARRS1',348.895333333,1.02863333333,NULL,NULL,'2016-10-29 06:02:52',57690.2519907,20.29,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 16:26:40','2016-11-02 16:26:40','http://wis-tns.weizmann.ac.il/object/2016hsi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51758325255,0.981118845848,-0.192570852826,0.0179520740659,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,808723832,12636309);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1703429,1694482,1,'AT2016hsj','Pan-STARRS1',29.9764166667,5.75816944444,NULL,NULL,'2016-10-29 09:46:04',57690.4069907,20.21,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 16:26:40','2016-11-02 16:26:40','http://wis-tns.weizmann.ac.il/object/2016hsj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67067823906,0.861860324652,0.497122406014,0.100329926889,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1047934748,16373980);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1703430,1694484,1,'AT2016hsk','Pan-STARRS1',359.4195,-3.86788055556,NULL,NULL,'2016-10-31 05:44:09',57692.2389931,18.78,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 16:26:40','2016-11-02 16:26:40','http://wis-tns.weizmann.ac.il/object/2016hsk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49404270887,0.997671043079,-0.0101083860412,-0.0674559881181,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,771941732,12061589);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1703958,1662133,1,'SN2016hnk','NUTS',33.3192916667,-7.66133333333,NULL,NULL,'2016-11-01 02:09:36',57693.09,17.91,NULL,'cyan-ATLAS',0.016,NULL,'SN Ia',NULL,'2016-11-02 17:25:01','2016-11-02 17:25:01','http://wis-tns.weizmann.ac.il/object/2016hnk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35150732393,0.828163185586,0.544400784708,-0.133317379397,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,549230193,8581721);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1706066,1706066,1,'AT2016hsq','Pan-STARRS1',9.88391666667,4.04569722222,NULL,NULL,'2016-11-01 08:31:12',57693.355,20.23,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-02 19:25:05','2016-11-02 19:25:05','http://wis-tns.weizmann.ac.il/object/2016hsq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66822911635,0.982702632529,0.171224824851,0.0705520756269,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1044107994,16314187);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1706601,1706601,1,'AT2016hsr','LOSS',45.5006666667,42.5909305556,NULL,NULL,'2016-11-02 08:00:47',57694.3338773,18.5,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-11-02 20:24:31','2016-11-02 20:24:31','http://wis-tns.weizmann.ac.il/object/2016hsr',NULL,NULL,0.0142,NULL,NULL,NULL,NULL,NULL,NULL,68572235616,0.516006249594,0.525103995854,0.676759443169,NULL,NULL,NULL,'2016-10-05 12:47:19',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1071441181,16741268);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1719902,1719902,1,'ATLAS16drt','ATLAS',10.7674525,53.2877625,NULL,NULL,'2016-11-02 09:37:26',57694.40099,15.15,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 00:18:41','2016-11-03 00:18:40',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57694/1004304181531715900_57694.436_02a57694o0471c_7551_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57694/1004304181531715900_57694.436_02a57694o0471c_7551_target.jpeg',NULL,NULL,NULL,65791373976,0.587271300032,0.111682283693,0.801647982389,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1027990218,16062347);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1719907,1719907,1,'ATLAS16dru','ATLAS',29.6874266667,53.04702,NULL,NULL,'2016-07-12 13:54:52',57581.57977,17.31,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 00:18:41','2016-11-03 00:18:41',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57694/1015844981530249000_57694.458_02a57694o0514c_5355_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57694/1015844981530249000_57694.458_02a57694o0514c_5355_target.jpeg',NULL,NULL,NULL,67808977700,0.522251364422,0.297735045572,0.799129122857,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1059515276,16554926);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1721011,1721011,1,'SN2016gyi','iPTF',13.5659166667,-2.447125,NULL,NULL,'2016-10-08 10:03:21',57669.4189931,NULL,NULL,NULL,0.075,NULL,'SN Ia',NULL,'2016-11-03 00:55:43','2016-11-03 00:55:39','http://wis-tns.weizmann.ac.il/object/2016gyi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34524347526,0.971214199499,0.23434997407,-0.0426974044221,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,539442930,8428795);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1721012,1721012,1,'SN2016hgx','iPTF',113.631833333,58.1271027778,NULL,NULL,'2016-10-22 10:17:18',57683.4286806,NULL,NULL,NULL,0.036,NULL,'SN Ia',NULL,'2016-11-03 00:55:43','2016-11-03 00:55:43','http://wis-tns.weizmann.ac.il/object/2016hgx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,61559946038,-0.211667781256,0.483755610076,0.849221561254,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,961874156,15029283);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1726089,1662208,1,'SN2016hpw','PESSTO',317.282833333,-18.1039472222,NULL,NULL,'2016-11-01 23:51:17',57693.9939468,17.56,NULL,'cyan-ATLAS',0.02,NULL,'SN Ia',NULL,'2016-11-03 08:28:13','2016-11-03 08:28:13','http://wis-tns.weizmann.ac.il/object/2016hpw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50997966091,0.698338993794,-0.644796180176,-0.310741911846,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,796843220,12450675);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1726090,1662214,1,'SN2016hpx','PESSTO',90.8194166667,-26.8985611111,NULL,NULL,'2016-11-02 08:57:09',57694.3730208,18.03,NULL,'cyan-ATLAS',0.033,NULL,'SN Ia',NULL,'2016-11-03 08:28:13','2016-11-03 08:28:13','http://wis-tns.weizmann.ac.il/object/2016hpx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39062343042,-0.0127537868362,0.891717690659,-0.452412313147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,610349110,9536704);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1728570,1728570,1,'AT2016hst','Gaia',219.934083333,-60.9277305556,NULL,NULL,'2016-10-23 09:37:26',57684.4009954,18.59,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 11:26:08','2016-11-03 11:26:08','http://wis-tns.weizmann.ac.il/object/2016hst',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44889095091,-0.372589601886,-0.311910043411,-0.874007501904,NULL,NULL,NULL,'2016-10-12 15:40:19',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,701392110,10959251);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1728571,1728571,1,'AT2016hsu','Gaia',240.409333333,-49.2937194444,NULL,NULL,'2016-10-23 15:54:43',57684.6629977,18.9,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 11:26:08','2016-11-03 11:26:08','http://wis-tns.weizmann.ac.il/object/2016hsu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46357661747,-0.322047371109,-0.567120978915,-0.75806285098,NULL,NULL,NULL,'2016-10-16 21:57:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,724338464,11317788);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1730692,1730692,1,'AT2016hsy','Gaia',56.7733333333,62.3245611111,NULL,NULL,'2016-10-26 00:54:43',57687.0379977,18.9,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 14:26:05','2016-11-03 14:26:05','http://wis-tns.weizmann.ac.il/object/2016hsy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66322992412,0.254503417758,0.388527201735,0.885592809287,NULL,NULL,NULL,'2016-10-12 02:38:24',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1036296756,16192136);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1731706,1731706,1,'AT2016hsz','Gaia',13.8280833333,71.0887111111,NULL,NULL,'2016-10-24 18:34:33',57685.7739931,18.48,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 14:55:18','2016-11-03 14:55:18','http://wis-tns.weizmann.ac.il/object/2016hsz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66446436337,0.314710396557,0.0774638677377,0.946021519573,NULL,NULL,NULL,'2016-10-08 14:16:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1038225567,16222274);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1731707,1729660,1,'AT2016hta','ATLAS',6.58679166667,51.519425,NULL,NULL,'2016-10-29 08:38:24',57690.36,18.23,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-03 14:55:18','2016-11-03 14:55:18','http://wis-tns.weizmann.ac.il/object/2016hta',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65833791615,0.618141952174,0.0713770606522,0.782819163138,NULL,NULL,NULL,'2016-10-25 09:36:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1028652993,16072703);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1731708,1731708,1,'AT2016htb','Gaia',284.823291667,51.52555,NULL,NULL,'2016-10-25 07:36:28',57686.3169907,18.77,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 14:55:18','2016-11-03 14:55:18','http://wis-tns.weizmann.ac.il/object/2016htb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52912611396,0.159174075685,-0.601459582036,0.782885677993,NULL,NULL,NULL,'2016-09-29 01:40:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,826759553,12918118);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1731709,1731709,1,'AT2016htc','Gaia',88.149875,-18.9621,NULL,NULL,'2016-10-25 20:18:14',57686.8459954,18.89,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 14:55:18','2016-11-03 14:55:18','http://wis-tns.weizmann.ac.il/object/2016htc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36658129578,0.0305331661105,0.945240712874,-0.32494264185,NULL,NULL,NULL,'2016-09-21 08:36:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,572783274,8949738);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1732222,1732220,1,'AT2016htd','Gaia',83.71775,1.05345,NULL,NULL,'2016-10-25 07:59:31',57686.3329977,18.58,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 15:11:25','2016-11-03 15:11:25','http://wis-tns.weizmann.ac.il/object/2016htd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64466094507,0.109407885416,0.993826897108,0.0183851351112,NULL,NULL,NULL,'2016-09-17 04:10:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1007282726,15738792);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1732223,1732221,1,'AT2016hte','Gaia',276.39,32.8033805556,NULL,NULL,'2016-10-24 23:28:19',57685.9779977,18.25,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 15:11:25','2016-11-03 15:11:25','http://wis-tns.weizmann.ac.il/object/2016hte',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,54470344998,0.0935477106886,-0.835312700311,0.541757804304,NULL,NULL,NULL,'2016-09-24 23:42:43',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,851099140,13298424);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1732224,1732224,1,'AT2016htf','Gaia',146.806083333,-72.8062305556,NULL,NULL,'2016-10-25 09:14:24',57686.385,18.39,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 15:11:25','2016-11-03 15:11:25','http://wis-tns.weizmann.ac.il/object/2016htf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,40702642763,-0.24736820268,0.161835707783,-0.955310512864,NULL,NULL,NULL,'2016-10-05 03:15:50',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,635978793,9937168);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1733655,1733143,1,'AT2016htg','Gaia',223.131625,-70.0488888889,NULL,NULL,'2016-10-25 21:36:00',57686.9,18.71,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 16:11:50','2016-11-03 16:11:50','http://wis-tns.weizmann.ac.il/object/2016htg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45042922630,-0.249015936711,-0.233282933338,-0.939984114907,NULL,NULL,NULL,'2016-10-09 21:41:45',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,703795666,10996807);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1733656,1733144,1,'AT2016hth','Gaia',203.515416667,-70.4311305556,NULL,NULL,'2016-10-24 21:30:14',57685.8959954,18.47,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 16:11:50','2016-11-03 16:11:50','http://wis-tns.weizmann.ac.il/object/2016hth',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44956427144,-0.307123852608,-0.133639525313,-0.942239574861,NULL,NULL,NULL,'2016-10-09 05:18:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,702444174,10975690);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1733657,1733145,1,'AT2016hti','Gaia',210.652875,-72.0511305556,NULL,NULL,'2016-10-25 15:31:40',57686.6469907,18.77,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 16:11:50','2016-11-03 16:11:50','http://wis-tns.weizmann.ac.il/object/2016hti',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44926986016,-0.265108400108,-0.157115072586,-0.951331903259,NULL,NULL,NULL,'2016-10-08 23:22:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,701984156,10968502);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1733658,1733658,1,'AT2016htj','Gaia',258.332666667,-54.8681194444,NULL,NULL,'2016-10-28 21:57:36',57689.915,17.59,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 16:11:50','2016-11-03 16:11:50','http://wis-tns.weizmann.ac.il/object/2016htj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44535308566,-0.116374762185,-0.563570390343,-0.817829645987,NULL,NULL,NULL,'2016-10-12 23:49:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,695864196,10872878);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1733659,1733659,1,'AT2016htk','Gaia',250.075166667,-40.2474194444,NULL,NULL,'2016-10-19 04:01:55',57680.1679977,18.09,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-03 16:11:50','2016-11-03 16:11:50','http://wis-tns.weizmann.ac.il/object/2016htk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46418446506,-0.260109667283,-0.717573121771,-0.646089603614,NULL,NULL,NULL,'2016-10-18 23:55:40',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,725288226,11332628);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1734203,1734203,1,'ATLAS16dsa','ATLAS',289.156433333,-18.5516866667,NULL,NULL,'2016-11-03 04:54:15',57695.20434,17.55,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 17:57:23','2016-11-03 17:57:23',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1191637540183306500_57695.226_02a57695o0094c_7992_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1191637540183306500_57695.226_02a57695o0094c_7992_target.jpeg',NULL,NULL,NULL,48100400029,0.311096895657,-0.895540578682,-0.318160012332,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,751568750,11743261);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1734207,1734207,1,'ATLAS16dsb','ATLAS',300.0977,-17.2651342857,NULL,NULL,'2016-10-30 05:51:14',57691.24391,16.64,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 17:57:24','2016-11-03 17:57:24',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1200023430171554500_57695.246_02a57695o0133c_3067_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1200023430171554500_57695.246_02a57695o0133c_3067_target.jpeg',NULL,NULL,NULL,47978568618,0.478880291658,-0.826188290144,-0.296793826571,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,749665134,11713517);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1734220,1734220,1,'ATLAS16dsd','ATLAS',300.2414425,-11.189865,NULL,NULL,'2016-11-03 04:52:46',57695.20331,15.54,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 17:57:25','2016-11-03 17:57:25',NULL,'nt',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1200057940111123400_57695.250_02a57695o0141c_4831_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1200057940111123400_57695.250_02a57695o0141c_4831_target.jpeg',NULL,NULL,NULL,48042210056,0.494070408542,-0.847487360662,-0.194060827888,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,750659532,11729055);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1734232,1734232,1,'ATLAS16dsf','ATLAS',294.15639,-14.1416455556,NULL,NULL,'2016-11-03 04:43:49',57695.1971,17.62,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 17:57:25','2016-11-03 17:57:25',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1193637530140830400_57695.235_02a57695o0113c_5989_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1193637530140830400_57695.235_02a57695o0113c_5989_target.jpeg',NULL,NULL,NULL,48070267683,0.396826863013,-0.884780326884,-0.244319900848,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,751097932,11735905);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1736584,1448142,1,'SN2016gxq','PESSTO',124.361791667,21.6904305556,NULL,NULL,'2016-11-03 08:18:28',57695.3461574,18.9,NULL,'V-crts-CRTS',0.015,NULL,'SN Ia',NULL,'2016-11-03 21:18:25','2016-11-03 21:18:23','http://wis-tns.weizmann.ac.il/object/2016gxq',NULL,NULL,0.0119,NULL,NULL,NULL,NULL,NULL,NULL,63809100998,-0.52445273362,0.767040677937,0.369591569963,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,997017203,15578393);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1736585,1699508,1,'SN2016hhv','PESSTO',353.952,20.7087833333,NULL,NULL,'2016-11-03 00:32:00',57695.0222222,19.08,NULL,'cyan-ATLAS',0.062,NULL,'SN Ia',NULL,'2016-11-03 21:18:26','2016-11-03 21:18:26','http://wis-tns.weizmann.ac.il/object/2016hhv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52484633263,0.930183431331,-0.0985541649236,0.353618241404,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,820072394,12813631);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1736586,1671511,1,'SN2016hqh','PESSTO',119.274208333,23.1487111111,NULL,NULL,'2016-11-03 08:52:00',57695.3694444,17.35,NULL,'cyan-ATLAS',0.054,NULL,'SN Ia',NULL,'2016-11-03 21:18:26','2016-11-03 21:18:26','http://wis-tns.weizmann.ac.il/object/2016hqh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63756764681,-0.44962010084,0.802059370316,0.393118978693,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,996199448,15565616);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1737620,1737620,1,'ATLAS16dsi','ATLAS',41.8884733333,-26.4893166667,NULL,NULL,'2016-11-03 10:42:54',57695.44646,17.98,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-03 23:59:55','2016-11-03 23:59:55',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1024733240262921800_57695.473_02a57695o0573c_1349_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57695/1024733240262921800_57695.473_02a57695o0573c_1349_target.jpeg',NULL,NULL,NULL,38423129089,0.666292127102,0.59758782205,-0.446030936483,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,600361392,9380646);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738741,1738154,1,'AT2016hto','Pan-STARRS1',37.227375,20.7259666667,NULL,NULL,'2016-10-25 12:07:12',57686.505,21.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:31','2016-11-04 00:33:31','http://wis-tns.weizmann.ac.il/object/2016hto',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68114159824,0.744711221353,0.5658275961,0.353898754281,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1064283747,16629433);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738742,1738153,1,'AT2016htp','Pan-STARRS1',35.7918333333,16.8887083333,NULL,NULL,'2016-10-25 12:08:38',57686.5059954,20.69,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:31','2016-11-04 00:33:31','http://wis-tns.weizmann.ac.il/object/2016htp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68081607204,0.776163104054,0.559618326365,0.290513622231,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1063775112,16621486);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738743,1738156,1,'AT2016htq','Pan-STARRS1',36.5275416667,5.70971666667,NULL,NULL,'2016-10-29 09:51:50',57690.4109954,20.9,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:31','2016-11-04 00:33:31','http://wis-tns.weizmann.ac.il/object/2016htq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66894388599,0.799584094563,0.592256122435,0.0994884976252,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045224821,16331637);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738744,1738155,1,'AT2016htr','Pan-STARRS1',75.2703333333,13.6413666667,NULL,NULL,'2016-10-28 13:45:07',57689.5729977,20.38,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:31','2016-11-04 00:33:31','http://wis-tns.weizmann.ac.il/object/2016htr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65444088304,0.247086353012,0.939854265119,0.235843792567,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1022563879,15977560);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738745,1738158,1,'AT2016hts','Pan-STARRS1',341.501208333,-5.52406111111,NULL,NULL,'2016-10-30 05:54:14',57691.2459954,18.6,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016hts',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50340784347,0.943926168424,-0.31581114259,-0.0962637563208,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,786574755,12290230);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738746,1738157,1,'AT2016htt','Pan-STARRS1',332.276291667,-6.04635,NULL,NULL,'2016-10-30 05:49:55',57691.2429977,21.1,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016htt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49846681602,0.880276838773,-0.462620422356,-0.105332957518,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,778854400,12169600);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738747,1738144,1,'AT2016htu','Pan-STARRS1',337.734666667,-12.2221194444,NULL,NULL,'2016-10-25 06:05:45',57686.2539931,21.56,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016htu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50418095083,0.904463354771,-0.370308321072,-0.211702119076,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,787782735,12309105);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738748,1738143,1,'AT2016htv','Pan-STARRS1',62.26525,-0.373055555556,NULL,NULL,'2016-10-24 13:39:21',57685.5689931,19.42,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016htv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36914305129,0.465369088584,0.885092773808,-0.00651100173279,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,576786017,9012281);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738749,1738146,1,'AT2016htw','Pan-STARRS1',345.211916667,-8.30155277778,NULL,NULL,'2016-10-25 06:12:57',57686.2589931,19.59,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016htw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50371510777,0.956745445253,-0.252570182427,-0.14438301817,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,787054855,12297732);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738750,1738145,1,'AT2016htx','Pan-STARRS1',339.038125,-15.6895638889,NULL,NULL,'2016-10-25 06:08:38',57686.2559954,18.97,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016htx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50422797378,0.899025547648,-0.344417383465,-0.270425092481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,787856209,12310253);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738751,1738148,1,'AT2016hty','Pan-STARRS1',6.87870833333,16.7329833333,NULL,NULL,'2016-10-25 09:41:45',57686.4039931,21.09,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016hty',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67470559801,0.950763618399,0.114696569048,0.287911859739,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1054227496,16472304);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738752,1738147,1,'AT2016htz','Pan-STARRS1',5.33879166667,18.9880055556,NULL,NULL,'2016-10-25 09:43:12',57686.405,20.19,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016htz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67452635501,0.941484689924,0.0879818449794,0.325370210058,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1053947429,16467928);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738753,1738150,1,'AT2016hua','Pan-STARRS1',23.0612083333,21.875325,NULL,NULL,'2016-10-25 10:55:12',57686.455,21.21,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016hua',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67390771204,0.853837711997,0.36350958735,0.372588166045,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1052980800,16452825);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738754,1738149,1,'AT2016hub','Pan-STARRS1',7.76845833333,23.9520694444,NULL,NULL,'2016-10-25 09:44:38',57686.4059954,21.31,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016hub',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67204962219,0.90549811964,0.123530015751,0.405972278041,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1050077534,16407461);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738755,1738152,1,'AT2016huc','Pan-STARRS1',32.808875,21.3978472222,NULL,NULL,'2016-10-25 11:58:33',57686.4989931,21.43,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016huc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68053760585,0.782547813062,0.504489227018,0.364841801463,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1063340009,16614687);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1738756,1738151,1,'AT2016hud','Pan-STARRS1',23.0725833333,16.7526111111,NULL,NULL,'2016-10-25 10:53:45',57686.4539931,21.29,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 00:33:32','2016-11-04 00:33:32','http://wis-tns.weizmann.ac.il/object/2016hud',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67424182948,0.880962310106,0.375264126096,0.288239906742,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1053502858,16460982);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1746515,1746515,1,'DES16C1csh','DES',53.196552,-27.119713,NULL,NULL,'2016-10-25 03:53:17',57686.162,22.3172,0.14808,'g',NULL,NULL,NULL,NULL,'2016-11-04 12:16:16','2016-11-04 12:16:16','https://portal.nersc.gov//des-sn/transients/DES16C1csh','SN',NULL,NULL,NULL,'http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161024-r2686/D_SN-C1_g_s1/p01/ccd32/stamps/temp13832837.gif','http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161024-r2686/D_SN-C1_g_s1/p01/ccd32/stamps/srch13832837.gif','http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161024-r2686/D_SN-C1_g_s1/p01/ccd32/stamps/diff13832837.gif',NULL,NULL,38580785251,0.533207447475,0.712663689437,-0.455851163994,NULL,NULL,NULL,'2016-10-25 03:56:10',57686.164,NULL,'http://portal.nersc.gov/project/dessn/finders/DES16C1csh',NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,602824769,9419137);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1750507,1749473,1,'AT2016hui','Pan-STARRS1',15.3381666667,0.488088888889,NULL,NULL,'2016-11-01 08:35:31',57693.3579977,20.18,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 16:10:43','2016-11-04 16:10:43','http://wis-tns.weizmann.ac.il/object/2016hui',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66680495882,0.964346437655,0.264505918076,0.00851865512059,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1041882748,16279417);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1750508,1749472,1,'AT2016huj','Pan-STARRS1',8.648625,2.39985833333,NULL,NULL,'2016-11-01 08:28:19',57693.3529977,20.67,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 16:10:43','2016-11-04 16:10:43','http://wis-tns.weizmann.ac.il/object/2016huj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66590065834,0.987762026032,0.15024252542,0.0418731833481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1040469778,16257340);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1750509,1749474,1,'AT2016huk','Pan-STARRS1',52.124875,-1.46045277778,NULL,NULL,'2016-11-01 10:50:52',57693.4519907,20.31,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-04 16:10:43','2016-11-04 16:10:43','http://wis-tns.weizmann.ac.il/object/2016huk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36817188298,0.613743124642,0.789094286106,-0.0254869494137,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,575268567,8988571);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1750552,1750552,1,'ATLAS16dso','ATLAS',305.369268333,9.68522833333,NULL,NULL,'2016-11-04 05:54:30',57696.24618,17.32,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-04 16:57:12','2016-11-04 16:57:12',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57696/1202128631094107200_57696.302_02a57696o0243c_10648_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57696/1202128631094107200_57696.302_02a57696o0243c_10648_target.jpeg',NULL,NULL,NULL,54192762406,0.57059354593,-0.803815841771,0.168235245598,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,846761912,13230654);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1752763,1752763,1,'AT2016hul','LOSS',23.29275,30.53635,NULL,NULL,'2016-11-03 09:02:57',57695.3770486,19,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-11-04 19:10:50','2016-11-04 19:10:50','http://wis-tns.weizmann.ac.il/object/2016hul',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67771045946,0.791107391893,0.340586005456,0.508084901744,NULL,NULL,NULL,'2016-10-09 11:18:47',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1058922592,16545665);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1756399,1756399,1,'AT2016hsw','ATLAS',57.6518333333,13.9141555556,NULL,NULL,'2016-11-04 12:41:45',57696.5289931,18.05,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-04 23:36:43','2016-11-04 23:36:41','http://wis-tns.weizmann.ac.il/object/2016hsw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65128612848,0.51936245207,0.820023079567,0.240467861379,NULL,NULL,NULL,'2016-10-27 14:26:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1017634575,15900540);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1763166,1662100,1,'SN2016hnl','PESSTO',91.2460416667,-33.4111138889,NULL,NULL,'2016-11-04 08:58:07',57696.3736921,18.13,NULL,'orange-ATLAS',0.027,NULL,'SN Ia',NULL,'2016-11-05 09:11:18','2016-11-05 09:11:18','http://wis-tns.weizmann.ac.il/object/2016hnl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39142283273,-0.0181521252472,0.834543678911,-0.550642668469,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,611598176,9556221);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1763167,1662139,1,'SN2016hqf','PESSTO',338.344458333,-1.35705277778,NULL,NULL,'2016-11-04 00:32:51',57696.0228125,18.1,NULL,'w-PS1',0.055,NULL,'SN Ia',NULL,'2016-11-05 09:11:19','2016-11-05 09:11:19','http://wis-tns.weizmann.ac.il/object/2016hqf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50332326115,0.929158513577,-0.368922187546,-0.0236828246813,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,786442595,12288165);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1763168,1737616,1,'SN2016htm','PESSTO',38.0109166667,-26.6659138889,NULL,NULL,'2016-11-04 07:58:15',57696.3321181,17.55,NULL,'cyan-ATLAS',0.041,NULL,'SN Ia',NULL,'2016-11-05 09:11:19','2016-11-05 09:11:19','http://wis-tns.weizmann.ac.il/object/2016htm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38428074261,0.704091937484,0.550312981833,-0.448787439213,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,600438660,9381854);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1763169,1737624,1,'SN2016htn','PESSTO',32.871125,-16.510325,NULL,NULL,'2016-11-04 07:42:16',57696.3210185,18.08,NULL,'cyan-ATLAS',0.053,NULL,'SN Ia',NULL,'2016-11-05 09:11:19','2016-11-05 09:11:19','http://wis-tns.weizmann.ac.il/object/2016htn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35057624056,0.805263461523,0.520372815839,-0.284188124437,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,547775375,8558990);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1765838,1765838,1,'ATLAS16dta','ATLAS',271.308464,8.607594,NULL,NULL,'2016-10-31 05:28:28',57692.2281,18.28,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-05 12:57:37','2016-11-05 12:57:37',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57696/1180514031083627600_57696.229_02a57696o0102c_7753_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57696/1180514031083627600_57696.229_02a57696o0102c_7753_target.jpeg',NULL,NULL,NULL,53723803049,0.0225778189302,-0.988478736816,0.149666392201,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,839434422,13116162);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768143,1767607,1,'AT2016hux','Pan-STARRS1',8.09945833333,6.31690833333,NULL,NULL,'2016-11-01 08:26:52',57693.3519907,20.32,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hux',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66838524452,0.984014081632,0.14003645145,0.110027630237,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1044351944,16317999);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768144,1767604,1,'AT2016hvc','Pan-STARRS1',2.58783333333,0.994022222222,NULL,NULL,'2016-11-01 08:22:33',57693.3489931,19.31,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hvc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66587115321,0.998829844055,0.0451440625862,0.0173480903286,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1040423676,16256619);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768145,1767603,1,'AT2016hvd','Pan-STARRS1',2.01495833333,-0.703313888889,NULL,NULL,'2016-11-01 08:22:33',57693.3489931,20,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hvd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,34362696742,0.999306389634,0.0351577597025,-0.0122748347704,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,536917136,8389330);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768146,1767606,1,'AT2016hve','Pan-STARRS1',7.91454166667,6.05753888889,NULL,NULL,'2016-11-01 08:26:52',57693.3519907,21.12,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hve',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66824783575,0.984944155935,0.136927096878,0.105527152102,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1044137243,16314644);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768147,1767605,1,'AT2016hvf','Pan-STARRS1',7.068,2.87289444444,NULL,NULL,'2016-11-01 08:28:19',57693.3529977,20.76,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hvf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66595588376,0.991153546001,0.122892586558,0.0501204590908,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1040556068,16258688);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768148,1767608,1,'AT2016hvg','Pan-STARRS1',9.24470833333,0.232119444444,NULL,NULL,'2016-11-01 08:29:45',57693.3539931,20.85,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hvg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66591303633,0.987003108347,0.160650090536,0.00405123748153,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1040489119,16257642);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768149,1767610,1,'AT2016hvh','Pan-STARRS1',314.460208333,-8.06761944444,NULL,NULL,'2016-11-03 05:05:16',57695.2119907,21.06,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:39','2016-11-05 16:14:39','http://wis-tns.weizmann.ac.il/object/2016hvh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50801090606,0.693481841908,-0.706673292344,-0.140341700261,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793767040,12402610);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768150,1767609,1,'AT2016hvi','Pan-STARRS1',113.882875,36.3366722222,NULL,NULL,'2016-11-01 14:38:24',57693.61,19.82,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:40','2016-11-05 16:14:40','http://wis-tns.weizmann.ac.il/object/2016hvi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63468677542,-0.326141342226,0.736574053427,0.592528892721,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,991698086,15495282);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768151,1767612,1,'AT2016hvj','Pan-STARRS1',327.539583333,-10.383525,NULL,NULL,'2016-11-03 05:16:48',57695.22,19.96,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:40','2016-11-05 16:14:40','http://wis-tns.weizmann.ac.il/object/2016hvj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49901029612,0.829944430006,-0.527927184867,-0.180236318706,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779703587,12182868);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768152,1767611,1,'AT2016hvk','Pan-STARRS1',324.922958333,-7.70761944444,NULL,NULL,'2016-11-03 05:16:48',57695.22,20.75,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 16:14:40','2016-11-05 16:14:40','http://wis-tns.weizmann.ac.il/object/2016hvk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49907553649,0.810986296838,-0.569485378732,-0.134117969532,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779805525,12184461);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768153,1671516,1,'SN2016hqk','PESSTO',327.843333333,-25.3103388889,NULL,NULL,'2016-11-05 02:37:20',57697.1092593,18.91,NULL,'cyan-ATLAS',0.059,NULL,'SN Ia',NULL,'2016-11-05 16:14:40','2016-11-05 16:14:40','http://wis-tns.weizmann.ac.il/object/2016hqk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51412726490,0.765327320704,-0.481144354806,-0.427520996002,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,803323851,12551935);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768154,1734225,1,'SN2016htl','PESSTO',298.480625,-23.6732166667,NULL,NULL,'2016-11-05 00:23:13',57697.0161227,18.3,NULL,'cyan-ATLAS',0.032,NULL,'SN Ia',NULL,'2016-11-05 16:14:40','2016-11-05 16:14:40','http://wis-tns.weizmann.ac.il/object/2016htl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50805215578,0.436733838968,-0.805012723364,-0.401519699545,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,793831493,12403617);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768155,1748702,1,'SN2016huh','PESSTO',134.271416667,-20.0350388889,NULL,NULL,'2016-11-05 08:58:15',57697.3737847,16.8,NULL,'V-Johnson',0.019,NULL,'SN Ia',NULL,'2016-11-05 16:14:40','2016-11-05 16:14:40','http://wis-tns.weizmann.ac.il/object/2016huh',NULL,NULL,0.018556,NULL,NULL,NULL,NULL,NULL,NULL,42358753317,-0.655813971733,0.672708612072,-0.342594742697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,661855520,10341492);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1768739,1767614,1,'AT2016hvm','ATLAS',88.400625,12.5471361111,NULL,NULL,'2016-11-04 14:31:12',57696.605,17.43,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-05 17:11:01','2016-11-05 17:11:01','http://wis-tns.weizmann.ac.il/object/2016hvm',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64527801879,0.0272441597881,0.975737339814,0.21724272013,NULL,NULL,NULL,'2016-10-27 15:33:07',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1008246904,15753857);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1770434,1770434,1,'AT2016hvn','Pan-STARRS1',66.3852916667,13.0238611111,NULL,NULL,'2016-10-28 13:36:28',57689.5669907,19.79,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 19:10:13','2016-11-05 19:10:13','http://wis-tns.weizmann.ac.il/object/2016hvn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65247011394,0.390279747832,0.892690329222,0.225356816063,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1019484553,15929446);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1770435,1770435,1,'AT2016hvo','Pan-STARRS1',26.0525,-3.89408611111,NULL,NULL,'2016-10-27 09:47:31',57688.4079977,20.83,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-05 19:10:14','2016-11-05 19:10:14','http://wis-tns.weizmann.ac.il/object/2016hvo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,35027087682,0.896317867379,0.438180554599,-0.0679123124918,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,547298245,8551535);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1772539,1772539,1,'ATLAS16dtn','ATLAS',91.98449,19.5686666667,NULL,NULL,'2016-11-05 12:39:53',57697.5277,18.65,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-05 23:59:20','2016-11-05 23:59:18',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57697/1060756291193407300_57697.575_02a57697o0491c_5895_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57697/1060756291193407300_57697.575_02a57697o0491c_5895_target.jpeg',NULL,NULL,NULL,62425386055,-0.0326288173744,0.941675639782,0.334936336814,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,975396657,15240572);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1773622,1773622,1,'AT2016hvp','ASASSN',71.315,75.1641194444,NULL,NULL,'2016-11-05 13:26:24',57697.56,15.8,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-11-06 00:32:57','2016-11-06 00:32:55','http://wis-tns.weizmann.ac.il/object/2016hvp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65684357858,0.0820298317147,0.242555779095,0.96666323026,NULL,NULL,NULL,'2016-10-27 11:31:12',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1026318091,16036220);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1774672,1734215,1,'AT2016hvq','ASASSN',326.89325,-25.7924194444,NULL,NULL,'2016-11-02 03:36:00',57694.15,16.8,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-11-06 03:21:13','2016-11-06 03:21:12','http://wis-tns.weizmann.ac.il/object/2016hvq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51413676834,0.754204185976,-0.491786144779,-0.435111978299,NULL,NULL,NULL,'2016-10-30 01:40:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,803338700,12552167);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1776244,1776244,1,'AT2016hvr','TNTS',353.223833333,24.3695555556,NULL,NULL,'2016-11-03 14:24:00',57695.6,19.5,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-11-06 09:11:21','2016-11-06 09:11:21','http://wis-tns.weizmann.ac.il/object/2016hvr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51980491463,0.904540083644,-0.107478282053,0.41262047449,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,812195179,12690549);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1778016,1778016,1,'AT2016hvs','Gaia',220.332125,-65.6752388889,NULL,NULL,'2016-10-24 21:37:26',57685.9009954,18.66,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-06 11:20:36','2016-11-06 11:20:36','http://wis-tns.weizmann.ac.il/object/2016hvs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45075077187,-0.31399990847,-0.266594108102,-0.911225350287,NULL,NULL,NULL,'2016-10-11 03:40:19',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,704298081,11004657);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1778541,1767619,1,'SN2016hvl','PESSTO',101.009,12.3966222222,NULL,NULL,'2016-11-06 08:48:24',57698.3669444,17.37,NULL,'cyan-ATLAS',0.013,NULL,'SN Ia',NULL,'2016-11-06 12:09:53','2016-11-06 12:09:53','http://wis-tns.weizmann.ac.il/object/2016hvl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63166833517,-0.186510867741,0.958711197613,0.214677748697,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,986981773,15421590);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1781760,1781760,1,'AT2016hvt','DLT40',95.4715416667,-27.1673722222,NULL,NULL,'2016-11-06 07:04:48',57698.295,19.1467,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-11-06 16:10:43','2016-11-06 16:10:43','http://wis-tns.weizmann.ac.il/object/2016hvt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39109047649,-0.0848318454481,0.885622879283,-0.45659136401,NULL,NULL,NULL,'2016-10-30 06:33:07',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,611078869,9548107);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1782325,1782325,1,'ATLAS16dts','ATLAS',329.537674,57.5966,NULL,NULL,'2016-11-06 06:38:02',57698.27641,17.68,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-06 17:58:25','2016-11-06 17:58:25',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1215809101573547200_57698.326_02a57698o0288c_6389_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1215809101573547200_57698.326_02a57698o0288c_6389_target.jpeg',NULL,NULL,NULL,53350299415,0.461905896636,-0.271674422587,0.844296127413,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,833598428,13024975);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1782331,1782331,1,'ATLAS16dtt','ATLAS',350.34555,44.397334,NULL,NULL,'2016-11-06 07:39:48',57698.31931,17.41,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-06 17:58:26','2016-11-06 17:58:26',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1232122951442350400_57698.363_02a57698o0361c_5445_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1232122951442350400_57698.363_02a57698o0361c_5445_target.jpeg',NULL,NULL,NULL,55360790455,0.704385772782,-0.119826596677,0.699630095001,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,865012350,13515817);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1782337,1782337,1,'ATLAS16dtu','ATLAS',300.327058,48.37271,NULL,NULL,'2016-11-06 05:29:38',57698.22891,17.61,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-06 17:58:26','2016-11-06 17:58:26',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1200118501482221600_57698.274_02a57698o0189c_4038_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1200118501482221600_57698.274_02a57698o0189c_4038_target.jpeg',NULL,NULL,NULL,54948140013,0.335419594141,-0.573380055744,0.747481777398,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,858564687,13415073);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1784975,1784975,1,'ATLAS16dtv','ATLAS',10.67434,41.228556,NULL,NULL,'2016-11-06 08:10:16',57698.34046,16.35,NULL,'c',NULL,NULL,NULL,NULL,'2016-11-06 21:58:19','2016-11-06 21:58:19',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1004241821411343000_57698.399_02a57698o0430c_3733_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57698/1004241821411343000_57698.399_02a57698o0430c_3733_target.jpeg',NULL,NULL,NULL,67673313087,0.739072308343,0.139306379318,0.659064379042,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1057395516,16521804);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1790213,1790213,1,'AT2016hvu','SNHunt',338.9815,20.3201611111,NULL,NULL,'2016-11-06 02:40:36',57698.1115278,17.6,NULL,'V-crts-CRTS',NULL,NULL,NULL,NULL,'2016-11-07 06:09:10','2016-11-07 06:09:10','http://wis-tns.weizmann.ac.il/object/2016hvu',NULL,NULL,0.01852,NULL,NULL,NULL,NULL,NULL,NULL,52411895130,0.875372170394,-0.33634822728,0.347265652354,NULL,NULL,NULL,'2016-10-21 03:37:52',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,818935861,12795872);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1790737,1790737,1,'SMT16ajno','skymapper',341.912413,-31.62724,NULL,NULL,'2016-10-24 11:54:14',57685.496,21.02,0.09,'g',NULL,NULL,NULL,NULL,'2016-11-07 06:21:35','2016-11-07 06:21:35','http://www.mso.anu.edu.au/skymapper/smt/transients/SMTJ22473898-3137381','Cand',NULL,NULL,NULL,'http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22473898-3137381/SMTJ22473898-3137381_sub20161014_104944_2064_g_0893387300_2016-10-24T22:53:15_11_ref.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22473898-3137381/SMTJ22473898-3137381_sub20161014_104944_2064_g_0893387300_2016-10-24T22:53:15_11_new.png','http://www.mso.anu.edu.au/~skymap/smt/dbi/media/thumbs/SMTJ22473898-3137381/SMTJ22473898-3137381_sub20161014_104944_2064_g_0893387300_2016-10-24T22:53:15_11_diff.png',NULL,NULL,50089885258,0.809400260159,-0.264358709595,-0.524390781303,NULL,NULL,NULL,NULL,57672.563,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,782654457,12228975);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1793903,1793372,1,'AT2016hwc','ATLAS',141.318875,55.5831972222,NULL,NULL,'2016-10-29 14:29:45',57690.6039931,19.06,NULL,'cyan-ATLAS',NULL,NULL,NULL,NULL,'2016-11-07 11:18:49','2016-11-07 11:18:49','http://wis-tns.weizmann.ac.il/object/2016hwc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,61889751054,-0.441222649568,0.353247415234,0.824947778431,NULL,NULL,NULL,'2016-10-25 14:58:33',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,967027360,15109802);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1796085,1796085,1,'AT2016hwn','ASASSN',181.071125,21.8009111111,NULL,NULL,'2016-11-06 15:07:12',57698.63,17.1,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-11-07 14:09:27','2016-11-07 14:09:27','http://wis-tns.weizmann.ac.il/object/2016hwn',NULL,NULL,0.02145,NULL,NULL,NULL,NULL,NULL,NULL,58854905736,-0.928317678706,-0.0173566035077,0.371382600181,NULL,NULL,NULL,'2016-06-20 06:14:24',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,919607902,14368873);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1796615,1796615,1,'AT2016hwp','ASASSN',62.2926666667,21.4404111111,NULL,NULL,'2016-11-06 07:55:12',57698.33,16.9,NULL,'V-Johnson',NULL,NULL,NULL,NULL,'2016-11-07 15:11:21','2016-11-07 15:11:21','http://wis-tns.weizmann.ac.il/object/2016hwp',NULL,NULL,0.021191,NULL,NULL,NULL,NULL,NULL,NULL,65097140405,0.432779631935,0.824067438335,0.365533373659,NULL,NULL,NULL,'2016-10-29 11:45:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1017142818,15892856);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1796616,1796616,1,'AT2016hwq','Gaia',61.8009166667,59.5716694444,NULL,NULL,'2016-10-26 06:59:02',57687.2909954,18.7,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 15:11:21','2016-11-07 15:11:21','http://wis-tns.weizmann.ac.il/object/2016hwq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66219191041,0.239321005351,0.446348935669,0.862263349578,NULL,NULL,NULL,'2016-10-12 18:51:50',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1034674860,16166794);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1796617,1796617,1,'AT2016hwr','Gaia',88.39675,-22.2668888889,NULL,NULL,'2016-10-26 02:22:33',57687.0989931,18.85,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 15:11:21','2016-11-07 15:11:21','http://wis-tns.weizmann.ac.il/object/2016hwr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37380311950,0.0258919628149,0.925066572823,-0.378921419436,NULL,NULL,NULL,'2016-09-21 22:24:57',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,584067374,9126052);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1797672,1797672,1,'AT2016hws','Gaia',158.523041667,-77.9499888889,NULL,NULL,'2016-10-26 09:20:09',57687.3889931,18.43,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 16:09:58','2016-11-07 16:09:58','http://wis-tns.weizmann.ac.il/object/2016hws',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,39970985021,-0.19426974616,0.0764346537639,-0.977965750643,NULL,NULL,NULL,'2016-10-05 15:21:36',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,624546640,9758541);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1797673,1797673,1,'AT2016hwt','Gaia',252.664083333,-53.9598611111,NULL,NULL,'2016-10-27 15:57:36',57688.665,18.12,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 16:09:58','2016-11-07 16:09:58','http://wis-tns.weizmann.ac.il/object/2016hwt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44540814441,-0.175313160408,-0.561625514173,-0.808605019535,NULL,NULL,NULL,'2016-10-13 17:47:02',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,695950225,10874222);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1797674,1797674,1,'AT2016hwu','Gaia',253.42925,-52.2155694444,NULL,NULL,'2016-10-27 15:59:02',57688.6659954,18.91,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 16:09:58','2016-11-07 16:09:58','http://wis-tns.weizmann.ac.il/object/2016hwu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44312689163,-0.174739295878,-0.587246159931,-0.790321533379,NULL,NULL,NULL,'2016-10-14 04:01:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,692385768,10818527);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1798213,1798213,1,'AT2016hwv','Gaia',265.595458333,-51.9684388889,NULL,NULL,'2016-10-30 04:01:55',57691.1679977,17.86,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 17:09:49','2016-11-07 17:09:48','http://wis-tns.weizmann.ac.il/object/2016hwv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44349346109,-0.0473149364423,-0.614275919382,-0.787671499838,NULL,NULL,NULL,'2016-10-12 23:54:14',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,692958532,10827477);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801382,1800853,1,'AT2016hww','Gaia',82.6967083333,-6.72368055556,NULL,NULL,'2016-10-27 02:08:09',57688.0889931,18.72,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:53','http://wis-tns.weizmann.ac.il/object/2016hww',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36760431858,0.126247294592,0.985065282759,-0.11708120819,NULL,NULL,NULL,'2016-09-18 04:16:19',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,574381747,8974714);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801383,1800854,1,'AT2016hwx','Gaia',248.4645,56.1336694444,NULL,NULL,'2016-10-30 23:54:14',57691.9959954,17.22,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:54','http://wis-tns.weizmann.ac.il/object/2016hwx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,57675589590,-0.204556678136,-0.51835530437,0.830339896586,NULL,NULL,NULL,'2016-09-26 13:58:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,901181087,14080954);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801384,1800855,1,'AT2016hwy','Gaia',259.539833333,77.4933694444,NULL,NULL,'2016-10-29 06:15:50',57690.2609954,18.55,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:54','http://wis-tns.weizmann.ac.il/object/2016hwy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,57075013779,-0.039315535015,-0.212953785678,0.976270953103,NULL,NULL,NULL,'2016-10-02 06:20:09',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,891797090,13934329);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801386,1800857,1,'AT2016hxa','Gaia',86.2441666667,-40.1640305556,NULL,NULL,'2016-10-27 20:39:50',57688.8609954,18.29,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:54','http://wis-tns.weizmann.ac.il/object/2016hxa',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,37056731232,0.0500587795804,0.762559781139,-0.644978060694,NULL,NULL,NULL,'2016-09-24 20:52:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,579011425,9047053);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801387,1800858,1,'AT2016hxb','Gaia',254.709625,-52.4684111111,NULL,NULL,'2016-10-27 23:45:36',57688.99,18.09,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:54','http://wis-tns.weizmann.ac.il/object/2016hxb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44310098465,-0.160652415334,-0.587634156138,-0.793017591222,NULL,NULL,NULL,'2016-10-13 23:49:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,692345288,10817895);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801388,1801388,1,'AT2016hxc','Gaia',301.638708333,-79.3664694444,NULL,NULL,'2016-10-30 21:36:00',57691.9,17.77,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:54','http://wis-tns.weizmann.ac.il/object/2016hxc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48547205747,0.0967954695921,-0.15710087567,-0.982827529086,NULL,NULL,NULL,'2016-10-06 03:54:43',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,758550089,11852345);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1801389,1801389,1,'AT2016hxd','Gaia',258.7675,-42.2347888889,NULL,NULL,'2016-10-28 16:10:33',57689.6739931,18.24,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-07 22:21:54','2016-11-07 22:21:54','http://wis-tns.weizmann.ac.il/object/2016hxd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,46231661177,-0.144222409129,-0.726214174974,-0.672170267694,NULL,NULL,NULL,'2016-04-27 16:23:31',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,722369705,11287026);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1808202,1808202,1,'MASTERJ220101.36-401526.7','master',330.255666667,-40.2574166667,NULL,NULL,'2016-10-31 01:56:38',57692.0809954,16.9,NULL,'unfiltered',NULL,NULL,NULL,NULL,'2016-11-08 09:17:54','2016-11-08 09:17:54','http://observ.pereplet.ru/sn_e.html','SN',NULL,NULL,NULL,NULL,NULL,NULL,'http://master.sai.msu.ru/static/OT/220101.36-401526.7.png',NULL,50670063846,0.662602355421,-0.378621511232,-0.64622277105,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,791719747,12370621);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1809774,1730184,1,'SN2016hsx','ASASSN',15.1726666667,-0.444119444444,NULL,NULL,'2016-11-04 03:12:14',57696.1334954,17.15,NULL,'V-Johnson',0.0436,NULL,'SN Ia',NULL,'2016-11-08 11:20:57','2016-11-08 11:20:57','http://wis-tns.weizmann.ac.il/object/2016hsx',NULL,NULL,0.0436,NULL,NULL,NULL,NULL,NULL,NULL,34523036119,0.965112469419,0.261720918541,-0.00775126895673,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,539422439,8428475);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1811407,1810839,1,'AT2016hxo','Gaia',244.076291667,47.98125,NULL,NULL,'2016-11-01 13:35:02',57693.5659954,18.23,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 13:11:03','2016-11-08 13:11:03','http://wis-tns.weizmann.ac.il/object/2016hxo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59703359536,-0.292632790953,-0.602019339993,0.74292581321,NULL,NULL,NULL,'2016-09-24 06:10:04',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,932864992,14576015);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1811408,1810840,1,'AT2016hxp','Gaia',80.863,2.61066944444,NULL,NULL,'2016-10-27 13:59:31',57688.5829977,19.13,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 13:11:03','2016-11-08 13:11:03','http://wis-tns.weizmann.ac.il/object/2016hxp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64643759679,0.158630865024,0.986286741326,0.0455490125792,NULL,NULL,NULL,'2016-09-16 08:23:59',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1010058744,15782167);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1811409,1811409,1,'AT2016hxr','Gaia',271.391166667,-27.2620111111,NULL,NULL,'2016-11-02 16:27:50',57694.6859954,18.91,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 13:11:03','2016-11-08 13:11:03','http://wis-tns.weizmann.ac.il/object/2016hxr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47706560542,0.0215812745833,-0.888659121989,-0.458060272772,NULL,NULL,NULL,'2016-10-17 10:29:16',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,745415008,11647109);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1811942,1811942,1,'ATLAS16dum','ATLAS',88.3459158333,-25.1661225,NULL,NULL,'2016-02-20 07:52:07',57438.32786,16.57,NULL,'o',NULL,NULL,NULL,NULL,'2016-11-08 14:58:39','2016-11-08 14:58:39',NULL,'orphan',NULL,NULL,NULL,'http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57699/1055323000250958100_57699.627_02a57699o0860c_5878_ref.jpeg','http://psweb.mp.qub.ac.uk/sne/atlas3/site_media/images/data/atlas3//57699/1055323000250958100_57699.627_02a57699o0860c_5878_target.jpeg',NULL,NULL,NULL,37125505734,0.0261252805769,0.904701512113,-0.425244216533,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,580086027,9063844);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1813911,1813911,1,'AT2016hxs','Gaia',252.114958333,23.3987305556,NULL,NULL,'2016-11-02 19:09:07',57694.7979977,18.37,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 15:15:49','2016-11-08 15:15:49','http://wis-tns.weizmann.ac.il/object/2016hxs',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56680573928,-0.281852648154,-0.873412152637,0.39712755678,NULL,NULL,NULL,'2016-09-19 11:48:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,885633967,13838030);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815068,1815068,1,'AT2016hxw','Pan-STARRS1',128.836875,34.6918305556,NULL,NULL,'2016-11-06 14:52:48',57698.62,21.05,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:15','2016-11-08 16:21:15','http://wis-tns.weizmann.ac.il/object/2016hxw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64365052146,-0.51562174604,0.640459599735,0.569162293303,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1005703939,15714124);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815069,1813922,1,'AT2016hxx','Pan-STARRS1',289.161791667,78.7091583333,NULL,NULL,'2016-11-07 04:42:14',57699.1959954,18.22,NULL,'z-Sloan',NULL,NULL,NULL,NULL,'2016-11-08 16:21:15','2016-11-08 16:21:15','http://wis-tns.weizmann.ac.il/object/2016hxx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52855383916,0.0642652863519,-0.184941777482,0.980645966652,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,825865373,12904146);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815070,1813923,1,'AT2016hxy','Pan-STARRS1',299.68025,80.6148944444,NULL,NULL,'2016-11-07 04:43:40',57699.1969907,18.44,NULL,'z-Sloan',NULL,NULL,NULL,NULL,'2016-11-08 16:21:15','2016-11-08 16:21:15','http://wis-tns.weizmann.ac.il/object/2016hxy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,52859388140,0.0807453615417,-0.141675139858,0.986614586014,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,825927939,12905124);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815071,1813924,1,'AT2016hxz','Pan-STARRS1',124.741291667,0.0216888888889,NULL,NULL,'2016-11-07 14:34:04',57699.6069907,21.1,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:15','2016-11-08 16:21:15','http://wis-tns.weizmann.ac.il/object/2016hxz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62579428111,-0.569871833819,0.821733502862,0.00037854251317,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,977803564,15278180);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815072,1813913,1,'AT2016hya','Pan-STARRS1',331.490916667,-11.3946055556,NULL,NULL,'2016-10-06 08:31:12',57667.355,20.45,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:15','2016-11-08 16:21:15','http://wis-tns.weizmann.ac.il/object/2016hya',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49871675491,0.861421268176,-0.467890426558,-0.197565046172,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,779244929,12175702);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815073,1815073,1,'AT2016hyb','Pan-STARRS1',27.5957083333,14.6876888889,NULL,NULL,'2016-10-06 12:23:02',57667.5159954,21.3,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyb',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66937077147,0.857278011077,0.4480923535,0.253550102464,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1045891830,16342059);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815074,1813915,1,'AT2016hyc','Pan-STARRS1',35.0079583333,23.6019333333,NULL,NULL,'2016-10-25 12:04:19',57686.5029977,21.88,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyc',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,68103403579,0.75055632478,0.525700576773,0.400379953186,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1064115680,16626807);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815075,1813914,1,'AT2016hyd','Pan-STARRS1',2.857125,19.6123416667,NULL,NULL,'2016-10-25 09:36:00',57686.4,21.73,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyd',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66720088913,0.940814226605,0.0469537920452,0.335654483703,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1042501389,16289084);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815076,1815076,1,'AT2016hye','Pan-STARRS1',7.41045833333,16.4591027778,NULL,NULL,'2016-11-06 09:11:31',57698.3829977,19.93,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hye',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67470370795,0.95101211607,0.123691431266,0.283330875337,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1054224543,16472258);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815077,1815077,1,'AT2016hyf','Pan-STARRS1',4.96345833333,16.5949555556,NULL,NULL,'2016-11-06 09:11:31',57698.3829977,21,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyf',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,66764567633,0.954753997048,0.0829166087999,0.285603993505,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1043196369,16299943);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815078,1813917,1,'AT2016hyg','Pan-STARRS1',47.58625,6.1293,NULL,NULL,'2016-11-05 09:47:31',57697.4079977,21.47,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyg',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67973433350,0.670623903727,0.734073023426,0.10677254342,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1062084896,16595076);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815079,1813916,1,'AT2016hyh','Pan-STARRS1',11.463625,16.7685333333,NULL,NULL,'2016-11-06 09:18:43',57698.3879977,21.67,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyh',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,67469327472,0.938377433361,0.190294725553,0.288505996445,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1054208241,16472003);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815080,1813919,1,'AT2016hyi','Pan-STARRS1',48.2344583333,-0.586519444444,NULL,NULL,'2016-11-05 09:48:57',57697.4089931,20.73,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyi',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36785168496,0.666049112848,0.745837645203,-0.0102365166497,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,574768257,8980754);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815081,1813918,1,'AT2016hyj','Pan-STARRS1',47.7447083333,-1.15653888889,NULL,NULL,'2016-11-05 09:48:57',57697.4089931,20.29,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyj',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36789772326,0.672298181412,0.740005243067,-0.0201840408059,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,574840192,8981878);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815082,1815082,1,'AT2016hyk','Pan-STARRS1',344.383833333,44.300325,NULL,NULL,'2016-11-06 07:14:52',57698.3019907,20.58,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyk',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55348771411,0.689270301651,-0.192657389454,0.698419345058,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,864824553,13512883);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815083,1813920,1,'AT2016hyl','Pan-STARRS1',50.848375,4.22632222222,NULL,NULL,'2016-11-05 09:50:24',57697.41,21.6,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyl',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65024835910,0.629657908232,0.773369099703,0.0736963650725,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1016013061,15875204);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815084,1813921,1,'AT2016hym','Pan-STARRS1',354.641333333,46.0566222222,NULL,NULL,'2016-11-06 06:33:07',57698.2729977,19.81,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hym',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,55313324948,0.690914318261,-0.0648077850445,0.720025941074,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,864270702,13504229);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815085,1815085,1,'AT2016hyn','Pan-STARRS1',349.257958333,52.1974611111,NULL,NULL,'2016-11-06 06:24:28',57698.2669907,18.24,NULL,'i-Sloan',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyn',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,53194442486,0.602201051203,-0.11424478397,0.790127852481,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,831163163,12986924);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815086,1815086,1,'AT2016hyo','Pan-STARRS1',120.181625,37.40675,NULL,NULL,'2016-11-06 14:45:36',57698.615,20.92,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:16','2016-11-08 16:21:16','http://wis-tns.weizmann.ac.il/object/2016hyo',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63449860381,-0.399350209914,0.686658799693,0.607469425276,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,991404068,15490688);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815087,1815087,1,'AT2016hyp','Pan-STARRS1',119.583666667,41.1965666667,NULL,NULL,'2016-11-06 14:44:09',57698.6139931,21.95,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyp',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63567336107,-0.37148219614,0.654361191686,0.658644372,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,993239626,15519369);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815088,1815088,1,'AT2016hyq','Pan-STARRS1',121.928208333,34.356125,NULL,NULL,'2016-11-06 14:47:02',57698.6159954,21.6,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyq',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64330989462,-0.436595096724,0.70065022193,0.56433499628,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1005171710,15705807);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815089,1815089,1,'AT2016hyr','Pan-STARRS1',121.006666667,37.4910138889,NULL,NULL,'2016-11-06 14:45:36',57698.615,21.32,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyr',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63437438084,-0.408735478694,0.680070818199,0.608636994185,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,991209970,15487655);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815090,1815090,1,'AT2016hys','Pan-STARRS1',123.675458333,38.4023583333,NULL,NULL,'2016-11-06 14:48:28',57698.6169907,20.21,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hys',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64324848781,-0.434534459093,0.652161916519,0.621180037108,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1005075762,15704308);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815091,1815091,1,'AT2016hyt','Gaia',272.169625,-48.7391305556,NULL,NULL,'2016-10-31 16:06:14',57692.6709954,17.98,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyt',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48870205628,0.0249669465426,-0.659015663533,-0.751714711043,NULL,NULL,NULL,'2016-10-13 00:00:00',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,763596962,11931202);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815092,1815092,1,'AT2016hyu','Gaia',257.277375,29.61915,NULL,NULL,'2016-10-30 07:10:33',57691.2989931,18.45,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyu',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56359347725,-0.191453722912,-0.847985705422,0.49423245076,NULL,NULL,NULL,'2016-09-21 13:36:28',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,880614808,13759606);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815093,1815093,1,'AT2016hyv','Gaia',266.600208333,-57.9929194444,NULL,NULL,'2016-10-30 03:56:09',57691.1639931,18.61,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyv',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,44444583025,-0.0314318811468,-0.52909124187,-0.847982602784,NULL,NULL,NULL,'2016-10-11 16:04:48',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,694446609,10850728);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815094,1815094,1,'AT2016hyw','Gaia',270.659375,-57.9587,NULL,NULL,'2016-10-11 09:59:02',57672.4159954,18.43,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 16:21:17','2016-11-08 16:21:17','http://wis-tns.weizmann.ac.il/object/2016hyw',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48957702515,0.00610534973622,-0.530495285994,-0.84766589895,NULL,NULL,NULL,'2016-09-08 00:25:55',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,764964101,11952564);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1815798,1815798,1,'AT2016hyx','Gaia',266.369875,-28.15615,NULL,NULL,'2016-10-31 22:26:24',57692.935,15.94,NULL,'G-Gaia',NULL,NULL,NULL,NULL,'2016-11-08 17:10:25','2016-11-08 17:10:25','http://wis-tns.weizmann.ac.il/object/2016hyx',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45766383588,-0.0558228336881,-0.879895856615,-0.471876141324,NULL,NULL,NULL,'2016-10-18 10:26:24',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,715099743,11173433);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1817506,1816346,1,'AT2016hyy','Pan-STARRS1',48.0011666667,1.8819,NULL,NULL,'2016-11-05 09:47:31',57697.4079977,20.03,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 19:10:38','2016-11-08 19:10:38','http://wis-tns.weizmann.ac.il/object/2016hyy',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64977312364,0.668754580016,0.742757620295,0.0328394458241,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1015270505,15863601);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1817507,1816345,1,'AT2016hyz','Pan-STARRS1',72.6324583333,9.82153888889,NULL,NULL,'2016-10-28 13:45:07',57689.5729977,20.52,NULL,'w-PS1',NULL,NULL,NULL,NULL,'2016-11-08 19:10:38','2016-11-08 19:10:38','http://wis-tns.weizmann.ac.il/object/2016hyz',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,65319831566,0.294125297319,0.940421606663,0.17057992613,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1020622368,15947224);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1818043,1818043,1,'AT2016hza','LOSS',98.1816666667,71.6022305556,NULL,NULL,'2016-11-03 13:20:14',57695.5557176,19,NULL,'Clear-',NULL,NULL,NULL,NULL,'2016-11-08 20:11:23','2016-11-08 20:11:22','http://wis-tns.weizmann.ac.il/object/2016hza',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,61283757585,-0.0449154583423,0.312399739163,0.948888299313,NULL,NULL,NULL,'2011-11-16 12:31:23',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,957558712,14961854);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819663,1819663,1,'OGLE16fht','OGLE',96.1369583333,-72.8109722222,NULL,NULL,'2016-09-25 08:41:20',57656.36204,21.387,0.172,'I',NULL,NULL,NULL,NULL,'2016-11-08 23:17:16','2016-11-08 23:17:16','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC565.19.I.1498.94.2691.75.7680.86062.gif',NULL,NULL,NULL,39868539361,-0.0315932420914,0.293831509887,-0.955334973112,NULL,NULL,NULL,'2016-09-20 09:24:34',57651.39206,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,622945927,9733530);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819693,1819693,1,'OGLE16fgn','OGLE',32.9741666667,-75.6618888889,NULL,NULL,'2016-10-31 03:40:50',57692.15336,21.19,0.295,'I',NULL,NULL,NULL,NULL,'2016-11-08 23:17:18','2016-11-08 23:17:18','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR110.10.I.363.17.3344.04.7699.64737.gif',NULL,NULL,NULL,35611660023,0.207752116987,0.134782666934,-0.968851222109,NULL,NULL,NULL,'2016-10-26 05:13:32',57687.21773,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,556432187,8694252);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819726,1819726,1,'OGLE16fgf','OGLE',65.7074583333,-77.533,NULL,NULL,'2016-09-16 07:37:44',57647.31787,20.805,0.202,'I',NULL,NULL,NULL,NULL,'2016-11-08 23:17:20','2016-11-08 23:17:20','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameLMC626.13.I.1507.36.1387.32.7698.83701.gif',NULL,NULL,NULL,35672689359,0.0888109847486,0.196762815406,-0.976420505449,NULL,NULL,NULL,'2016-02-19 02:22:20',57437.09884,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,557385771,8709152);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819730,1819730,1,'OGLE16ffy','OGLE',55.6810833333,-72.4105277778,NULL,NULL,'2016-10-30 04:43:53',57691.19714,20.677,0.108,'I',NULL,NULL,NULL,NULL,'2016-11-08 23:17:21','2016-11-08 23:17:21','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR137.01.I.402.50.1759.12.7698.69239.gif',NULL,NULL,NULL,36421794364,0.170377021324,0.249586323396,-0.953246210472,NULL,NULL,NULL,'2016-10-25 05:45:34',57686.23998,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,569090536,8892039);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819766,1819766,1,'OGLE16fdx','OGLE',48.7385833333,-68.9308611111,NULL,NULL,'2016-10-21 06:26:33',57682.26844,20.692,0.156,'I',NULL,NULL,NULL,NULL,'2016-11-08 23:17:23','2016-11-08 23:17:23','http://ogle.astrouw.edu.pl/ogle4/transients/transients.html','SN',NULL,NULL,NULL,NULL,'http://ogle.astrouw.edu.pl/ogle4/transients/imagesSELECTED/frameMBR208.15.I.996.65.2987.81.7700.69273.gif',NULL,NULL,NULL,36445989367,0.237084874649,0.27023484517,-0.933147303842,NULL,NULL,NULL,'2016-10-15 05:09:57',57676.21524,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,569468583,8897946);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819801,1819801,1,'DES16X3dfk','DES',36.573231,-5.373161,NULL,NULL,'2016-11-02 01:48:00',57694.075,24.0337,0.169941,'g',NULL,NULL,NULL,NULL,'2016-11-30 09:52:23','2016-11-30 09:52:23','https://portal.nersc.gov//des-sn/transients/DES16X3dfk','SN',NULL,NULL,NULL,'http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161101-r2703/D_SN-X3_g_s1/p03/ccd58/stamps/temp14014930.gif','http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161101-r2703/D_SN-X3_g_s1/p03/ccd58/stamps/srch14014930.gif','http://dessne.cosmology.illinois.edu/SNWG/stamps/stamps/20161101-r2703/D_SN-X3_g_s1/p03/ccd58/stamps/diff14014930.gif',NULL,NULL,34950808485,0.799567095066,0.593231527422,-0.0936419529969,NULL,NULL,NULL,'2016-10-26 02:42:43',57687.113,NULL,'http://portal.nersc.gov/project/dessn/finders/DES16X3dfk',NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,546106382,8532912);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819856,1819856,1,'Gaia16bsg','Gaia',228.78149,43.15013,NULL,NULL,'2016-11-05 19:41:05',57697.8201968,15.63,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:51','2017-01-04 10:23:51','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsg/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59974423847,-0.48073354867,-0.548779687225,0.683912355549,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,937100372,14642193);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819857,1819857,1,'Gaia16bsh','Gaia',247.42883,27.71768,NULL,NULL,'2016-11-04 13:17:22',57696.5537269,17.44,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:51','2017-01-04 10:23:51','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsh/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56180265844,-0.339786213561,-0.817443055443,0.46511523323,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,877816653,13715885);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819858,1819858,1,'Gaia16bsi','Gaia',213.07859,57.95975,NULL,NULL,'2016-11-04 06:12:04',57696.2583796,18.93,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:51','2017-01-04 10:23:51','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsi/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,57305907424,-0.444530475232,-0.289549128248,0.847675621285,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,895404803,13990700);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819859,1819859,1,'Gaia16bsj','Gaia',87.48184,11.81223,NULL,NULL,'2016-11-03 21:43:42',57695.9053472,18.52,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:51','2017-01-04 10:23:51','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsj/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,64538916404,0.0430056333326,0.977878511127,0.204704990114,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,1008420568,15756571);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819861,1819861,1,'Gaia16bsl','Gaia',269.37302,-14.96588,NULL,NULL,'2016-11-03 22:42:18',57695.9460417,18.41,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsl/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45260330112,-0.010571469996,-0.966021941727,-0.25824378429,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,707192658,11049885);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819862,1819862,1,'Gaia16bsm','Gaia',254.28244,16.13067,NULL,NULL,'2016-11-04 11:17:06',57696.4702083,18.92,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsm/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56907829608,-0.26023047882,-0.924711411134,0.277828911405,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,889184837,13893513);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819863,1819863,1,'Gaia16bsn','Gaia',337.23716,-61.03386,NULL,NULL,'2016-11-04 21:42:21',57696.9044097,18.19,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsn/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48790827024,0.44657318333,-0.187381363275,-0.874906061602,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,762356672,11911823);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819864,1819864,1,'Gaia16bso','Gaia',320.47807,-59.05156,NULL,NULL,'2016-11-04 15:49:38',57696.6594676,18.63,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bso/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,49132693472,0.396695448439,-0.327265585021,-0.857630432091,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,767698335,11995286);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819865,1819865,1,'Gaia16bsp','Gaia',184.77244,61.03368,NULL,NULL,'2016-11-05 00:28:16',57697.0196296,18.29,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsp/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,57338400248,-0.48261635647,-0.040292655626,0.874904540147,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,895912503,13998632);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819866,1819866,1,'Gaia16bsq','Gaia',281.12048,-28.23986,NULL,NULL,'2016-11-05 04:27:34',57697.1858102,16.96,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsq/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47727817680,0.169915938221,-0.864433124888,-0.473163762914,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,745747151,11652299);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819867,1819867,1,'Gaia16bsr','Gaia',274.91285,-16.71739,NULL,NULL,'2016-11-05 16:40:12',57697.6945833,18.33,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsr/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47371210547,0.0820208056074,-0.954216623339,-0.287651217955,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,740175164,11565236);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819868,1819868,1,'Gaia16bss','Gaia',104.4766,24.63871,NULL,NULL,'2016-11-06 13:38:56',57698.5687037,18.12,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bss/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62985503915,-0.227224652142,0.880095178181,0.416894992536,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,984148498,15377320);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819869,1819869,1,'Gaia16bst','Gaia',100.91481,21.16628,NULL,NULL,'2016-11-06 09:30:22',57698.396088,18.23,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bst/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63199505626,-0.176575086336,0.915666695454,0.3610758116,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,987492275,15429566);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819871,1819871,1,'Gaia16bsv','Gaia',268.75867,-0.86139,NULL,NULL,'2016-11-07 10:57:55',57699.4568866,17.54,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:52','2017-01-04 10:23:52','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsv/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,45101158599,-0.0216611525495,-0.999652333358,-0.0150335253061,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,704705603,11011025);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819872,1819872,1,'Gaia16bsw','Gaia',283.50992,-21.98281,NULL,NULL,'2016-11-06 22:33:05',57698.9396412,17.75,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsw/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48271681199,0.216629109276,-0.901637442259,-0.374328400915,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,754245018,11785078);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819873,1819873,1,'Gaia16bsx','Gaia',280.99542,-22.66433,NULL,NULL,'2016-11-06 04:33:04',57698.1896296,18.22,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsx/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48203674632,0.176001965058,-0.905838197871,-0.385331633238,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,753182416,11768475);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819874,1819874,1,'Gaia16bsy','Gaia',277.95528,-21.97893,NULL,NULL,'2016-11-05 10:34:17',57697.4404745,18.43,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bsy/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48243162289,0.128341435397,-0.918397372113,-0.374265604693,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,753799410,11778115);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819876,1819876,1,'Gaia16bta','Gaia',56.67202,-36.94397,NULL,NULL,'2016-11-05 20:55:01',57697.8715394,18.67,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bta/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,38555878616,0.439118178737,0.6677826475,-0.601033743479,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,602435603,9413056);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819877,1819877,1,'Gaia16btb','Gaia',336.01364,-59.77697,NULL,NULL,'2016-11-05 03:43:29',57697.1551968,18.47,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btb/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48797745862,0.45989763852,-0.204628447334,-0.864072543613,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,762464779,11913512);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819878,1819878,1,'Gaia16btc','Gaia',299.26989,-40.29811,NULL,NULL,'2016-11-06 04:11:29',57698.1746412,18.46,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btc/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51219383645,0.372897354517,-0.665314277406,-0.64676462123,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,800302869,12504732);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819879,1819879,1,'Gaia16btd','Gaia',283.54794,-28.12148,NULL,NULL,'2016-11-05 16:27:07',57697.6854977,18.7,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:53','2017-01-04 10:23:53','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btd/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47724402994,0.206604666658,-0.857409300133,-0.471342554584,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,745693796,11651465);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819881,1819881,1,'Gaia16btf','Gaia',115.44473,24.83635,NULL,NULL,'2016-11-08 13:32:47',57700.5644329,18.73,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:54','2017-01-04 10:23:54','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btf/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62948459049,-0.389903308068,0.819482739018,0.420027916702,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,983569672,15368276);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819882,1819882,1,'Gaia16btg','Gaia',246.62049,24.02539,NULL,NULL,'2016-11-07 13:17:15',57699.5536458,19.14,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:54','2017-01-04 10:23:54','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btg/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,56641990583,-0.3624412389,-0.838374739387,0.407141430836,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,885031102,13828610);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819883,1819883,1,'Gaia16bth','Gaia',290.81099,-18.95919,NULL,NULL,'2016-11-08 22:33:09',57700.9396875,18.61,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:54','2017-01-04 10:23:54','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bth/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48103036634,0.336012067345,-0.884047161624,-0.324894608484,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,751609947,11743905);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819884,1819884,1,'Gaia16bti','Gaia',285.84081,-13.26342,NULL,NULL,'2016-11-09 04:40:17',57701.1946412,18.7,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:54','2017-01-04 10:23:54','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bti/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48262414812,0.265684329675,-0.936362354434,-0.229428372624,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,754100231,11782816);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819885,1819885,1,'Gaia16btj','Gaia',336.67196,-46.9515,NULL,NULL,'2016-11-08 03:50:08',57700.1598148,18.95,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:54','2017-01-04 10:23:54','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btj/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50694989524,0.626815079446,-0.270312951188,-0.730776138499,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,792109211,12376706);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819886,1819886,1,'Gaia16btk','Gaia',353.47506,-48.78246,NULL,NULL,'2016-11-08 03:39:55',57700.1527199,18.95,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btk/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48594973163,0.654651604497,-0.0748768023771,-0.752213228543,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,759296455,11864007);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819887,1819887,1,'Gaia16btl','Gaia',282.99825,-10.30753,NULL,NULL,'2016-11-09 04:44:05',57701.1972801,17.76,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btl/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48134421481,0.221291408395,-0.958651982778,-0.178931518983,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,752100335,11751567);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819888,1819888,1,'Gaia16btm','Gaia',217.86263,37.23892,NULL,NULL,'2016-11-10 00:01:51',57702.0012847,18.82,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btm/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60078002777,-0.628523700206,-0.488634306581,0.605140043884,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,938718793,14667481);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819889,1819889,1,'Gaia16btn','Gaia',196.47,41.72509,NULL,NULL,'2016-11-10 00:20:10',57702.0140046,18.89,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btn/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59077305678,-0.715722936185,-0.211599222252,0.665557246043,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,923082901,14423170);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819890,1819890,1,'Gaia16bto','Gaia',80.66956,-12.91345,NULL,NULL,'2016-10-29 02:17:28',57690.095463,20.17,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bto/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,36676410989,0.158027672722,0.961813090805,-0.223478931914,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,573068921,8954201);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819891,1819891,1,'Gaia16btp','Gaia',289.15016,-12.14467,NULL,NULL,'2016-11-10 04:39:53',57702.1943634,18.75,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btp/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,48289808000,0.32070322807,-0.923520087216,-0.210380816651,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,754528250,11789503);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819892,1819892,1,'Gaia16btq','Gaia',284.5498,-6.97394,NULL,NULL,'2016-11-10 10:46:30',57702.4489583,18.39,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:55','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btq/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47417942752,0.249362731346,-0.960768403219,-0.121417888267,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,740905355,11576646);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819893,1819893,1,'Gaia16btr','Gaia',203.19554,37.70599,NULL,NULL,'2016-11-11 02:01:18',57703.0842361,18.57,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:55','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btr/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,59295064460,-0.727207002841,-0.311614316128,0.611609755484,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,926485382,14476334);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819894,1819894,1,'Gaia16bts','Gaia',299.37363,-16.19677,NULL,NULL,'2016-11-10 22:31:21',57702.9384375,18.29,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bts/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47982405581,0.471034389492,-0.83685170177,-0.27893696987,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,749725087,11714454);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819895,1819895,1,'Gaia16btt','Gaia',119.24889,12.13223,NULL,NULL,'2016-11-11 19:40:31',57703.8198032,18.46,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btt/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,62755652155,-0.477691442354,0.853018209458,0.210168551963,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,980557064,15321204);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819896,1819896,1,'Gaia16btu','Gaia',112.09675,9.2206,NULL,NULL,'2016-11-11 07:48:12',57703.3251389,18.93,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btu/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63246204455,-0.371311086136,0.914577756518,0.160236090177,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,988221944,15440967);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819897,1819897,1,'Gaia16btv','Gaia',309.15743,-28.50733,NULL,NULL,'2016-11-09 16:16:43',57701.6782755,18.32,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btv/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51317736486,0.554893462998,-0.681399633095,-0.477271185743,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,801839632,12528744);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819898,1819898,1,'Gaia16btw','Gaia',305.81143,-20.66544,NULL,NULL,'2016-10-12 00:36:36',57673.0254167,19.7,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btw/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,50868475721,0.547471163676,-0.75876839725,-0.352910532964,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,794819933,12419061);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819899,1819899,1,'Gaia16btx','Gaia',111.78282,9.05818,NULL,NULL,'2016-11-11 07:48:34',57703.3253935,16.58,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btx/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63246361635,-0.366461552161,0.917016587962,0.157437315117,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,988224400,15441006);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819900,1819900,1,'Gaia16bty','Gaia',282.22498,-8.11345,NULL,NULL,'2016-11-09 16:46:32',57701.6989815,16.09,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:56','2017-01-04 10:23:56','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bty/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,47426230755,0.20963140405,-0.967541199171,-0.141133632923,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,741034855,11578669);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819901,1819901,1,'Gaia16btz','Gaia',225.4868,31.07268,NULL,NULL,'2016-11-11 23:55:02',57703.9965509,17.97,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:57','2017-01-04 10:23:57','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16btz/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,60092469465,-0.600478822127,-0.610770159422,0.516124981507,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,938944835,14671013);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819902,1819902,1,'Gaia16bua','Gaia',186.30602,34.48216,NULL,NULL,'2016-11-12 06:30:14',57704.2709954,18.47,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:57','2017-01-04 10:23:57','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bua/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,58762644482,-0.819315000718,-0.0905403528871,0.566149603989,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,918166320,14346348);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819906,1819906,1,'Gaia16bue','Gaia',329.18761,-25.22244,NULL,NULL,'2016-11-12 10:07:27',57704.4218403,18.99,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:57','2017-01-04 10:23:57','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16bue/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,51420225496,0.776966665504,-0.463392840755,-0.426133636121,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,0,NULL,0,803441023,12553765);
INSERT INTO `transientBucket` (`primaryKeyId`,`transientBucketId`,`masterIDFlag`,`name`,`survey`,`raDeg`,`decDeg`,`raDegErr`,`decDegErr`,`observationDate`,`observationMJD`,`magnitude`,`magnitudeError`,`filter`,`transientRedshift`,`transientRedshiftNotes`,`spectralType`,`discoveryPhase`,`dateCreated`,`dateLastModified`,`surveyObjectUrl`,`transientTypePrediction`,`transientTypePredicationSource`,`hostRedshift`,`hostRedshiftType`,`referenceImageUrl`,`targetImageUrl`,`subtractedImageUrl`,`tripletImageUrl`,`htm20ID`,`htm16ID`,`cx`,`cy`,`cz`,`telescope`,`instrument`,`reducer`,`lastNonDetectionDate`,`lastNonDetectionMJD`,`dateLastRead`,`finderImageUrl`,`lightcurveURL`,`classificationWRTMax`,`classificationPhase`,`limitingMag`,`sherlockClassification`,`tmpFlag`,`replacedByRowId`,`dateDeleted`,`updated`,`htm13ID`,`htm10ID`) VALUES (1819909,1819909,1,'Gaia16buh','Gaia',142.63448,20.60813,NULL,NULL,'2016-11-12 19:15:16',57704.8022685,18.89,NULL,'G',NULL,NULL,NULL,NULL,'2017-01-04 10:23:58','2017-01-04 10:23:58','http://gsaweb.ast.cam.ac.uk/alerts/alert/Gaia16buh/',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,63739495175,-0.743921700982,0.568062036393,0.35