import cdk = require('@aws-cdk/cdk');
/**
 * Properties for defining a `AWS::Cloud9::EnvironmentEC2`
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export interface CfnEnvironmentEC2Props {
    /**
     * `AWS::Cloud9::EnvironmentEC2.InstanceType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-instancetype
     */
    readonly instanceType: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.AutomaticStopTimeMinutes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-automaticstoptimeminutes
     */
    readonly automaticStopTimeMinutes?: number | cdk.Token;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Description`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-description
     */
    readonly description?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-name
     */
    readonly name?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.OwnerArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-ownerarn
     */
    readonly ownerArn?: string;
    /**
     * `AWS::Cloud9::EnvironmentEC2.Repositories`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-repositories
     */
    readonly repositories?: Array<CfnEnvironmentEC2.RepositoryProperty | cdk.Token> | cdk.Token;
    /**
     * `AWS::Cloud9::EnvironmentEC2.SubnetId`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html#cfn-cloud9-environmentec2-subnetid
     */
    readonly subnetId?: string;
}
/**
 * A CloudFormation `AWS::Cloud9::EnvironmentEC2`
 *
 * @cloudformationResource AWS::Cloud9::EnvironmentEC2
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloud9-environmentec2.html
 */
export declare class CfnEnvironmentEC2 extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly resourceTypeName = "AWS::Cloud9::EnvironmentEC2";
    /**
     * @cloudformationAttribute Arn
     */
    readonly environmentEc2Arn: string;
    /**
     * @cloudformationAttribute Name
     */
    readonly environmentEc2Name: string;
    readonly environmentEc2Id: string;
    /**
     * Create a new `AWS::Cloud9::EnvironmentEC2`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentEC2Props);
    readonly propertyOverrides: CfnEnvironmentEC2Props;
    protected renderProperties(properties: any): {
        [key: string]: any;
    };
}
export declare namespace CfnEnvironmentEC2 {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html
     */
    interface RepositoryProperty {
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.PathComponent`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-pathcomponent
         */
        readonly pathComponent: string;
        /**
         * `CfnEnvironmentEC2.RepositoryProperty.RepositoryUrl`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloud9-environmentec2-repository.html#cfn-cloud9-environmentec2-repository-repositoryurl
         */
        readonly repositoryUrl: string;
    }
}
