/*
 * Decompiled with CFR 0.152.
 */
package nz.msl.examples;

import java.util.Random;

public class Matrix {
    private double[][] m;
    private Matrix L;
    private Matrix U;
    private Matrix Q;
    private Matrix R;
    private static boolean calculatingInverse = false;

    public Matrix(Matrix matrix) {
        this.m = new double[matrix.getNumberOfRows()][matrix.getNumberOfColumns()];
        for (int i = 0; i < matrix.getNumberOfRows(); ++i) {
            for (int j = 0; j < matrix.getNumberOfColumns(); ++j) {
                this.m[i][j] = matrix.getValue(i, j);
            }
        }
    }

    public Matrix(int n) {
        this.m = new double[n][n];
        for (int i = 0; i < n; ++i) {
            this.m[i][i] = 1.0;
        }
    }

    public Matrix(int n, int n2) {
        this.m = new double[n][n2];
    }

    public Matrix(int n, int n2, double d) {
        this.m = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m[i][j] = d;
            }
        }
    }

    public Matrix(int n, int n2, double d, double d2) {
        Random random = new Random();
        this.m = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.m[i][j] = (d2 - d) * random.nextDouble() + d;
            }
        }
    }

    public Matrix(Double[][] doubleArray) {
        this.m = new double[doubleArray.length][doubleArray[0].length];
        for (int i = 0; i < doubleArray.length; ++i) {
            for (int j = 0; j < doubleArray[0].length; ++j) {
                this.m[i][j] = doubleArray[i][j];
            }
        }
    }

    public Matrix(Double[] doubleArray) {
        this.m = new double[1][doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            this.m[0][i] = doubleArray[i];
        }
    }

    public static Matrix multiply(Matrix matrix, Matrix matrix2) {
        if (matrix.getNumberOfColumns() != matrix2.getNumberOfRows()) {
            throw new IllegalArgumentException(String.format("ERROR! Cannot multiply a %dx%d matrix with a %dx%d matrix", matrix.getNumberOfRows(), matrix.getNumberOfColumns(), matrix2.getNumberOfRows(), matrix2.getNumberOfColumns()));
        }
        Matrix matrix3 = new Matrix(matrix.getNumberOfRows(), matrix2.getNumberOfColumns());
        double d = 0.0;
        for (int i = 0; i < matrix.getNumberOfRows(); ++i) {
            for (int j = 0; j < matrix2.getNumberOfColumns(); ++j) {
                for (int k = 0; k < matrix2.getNumberOfRows(); ++k) {
                    d += matrix.getValue(i, k) * matrix2.getValue(k, j);
                }
                matrix3.setValue(i, j, d);
                d = 0.0;
            }
        }
        return matrix3;
    }

    public static Matrix solve(Matrix matrix, Matrix matrix2) {
        if (matrix2.getNumberOfColumns() > 1) {
            matrix2 = matrix2.transpose();
        }
        if (matrix2.getNumberOfRows() != matrix.getNumberOfRows()) {
            throw new IllegalArgumentException(String.format("ERROR! Dimension mismatch when solving the system of equations using b=Ax, b has dimension  %dx%d and A is %dx%d.", matrix2.getNumberOfRows(), matrix2.getNumberOfColumns(), matrix.getNumberOfRows(), matrix.getNumberOfColumns()));
        }
        if (matrix.getNumberOfRows() < matrix.getNumberOfColumns()) {
            Matrix matrix3 = matrix.transpose();
            return Matrix.multiply(Matrix.multiply(matrix3, Matrix.multiply(matrix, matrix3).getInverse()), matrix2);
        }
        Double[] doubleArray = new Double[matrix.getNumberOfColumns()];
        if (matrix.isSquare()) {
            int n;
            if (!calculatingInverse) {
                matrix.makeLU();
            }
            double[] dArray = new double[matrix2.getNumberOfRows()];
            dArray[0] = matrix2.getValue(0, 0);
            for (n = 1; n < dArray.length; ++n) {
                dArray[n] = matrix2.getValue(n, 0);
                for (int i = 0; i < n; ++i) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] - matrix.getL().getValue(n, i) * dArray[i];
                }
            }
            for (n = doubleArray.length - 1; n > -1; --n) {
                doubleArray[n] = dArray[n];
                for (int i = n + 1; i < doubleArray.length; ++i) {
                    Double[] doubleArray2 = doubleArray;
                    int n3 = n;
                    Double.valueOf(doubleArray2[n3] - matrix.getU().getValue(n, i) * doubleArray[i]);
                }
                Double[] doubleArray3 = doubleArray;
                int n4 = n;
                Double.valueOf(doubleArray3[n4] / matrix.getU().getValue(n, n));
            }
        } else {
            matrix.makeQR();
            Matrix matrix4 = Matrix.multiply(matrix.getQ().transpose(), matrix2);
            for (int i = doubleArray.length - 1; i > -1; --i) {
                doubleArray[i] = matrix4.getValue(i, 0);
                for (int j = i + 1; j < doubleArray.length; ++j) {
                    Double[] doubleArray4 = doubleArray;
                    int n = i;
                    Double.valueOf(doubleArray4[n] - matrix.getR().getValue(i, j) * doubleArray[j]);
                }
                Double[] doubleArray5 = doubleArray;
                int n = i;
                Double.valueOf(doubleArray5[n] / matrix.getR().getValue(i, i));
            }
        }
        return new Matrix(doubleArray).transpose();
    }

    public double[][] primitive() {
        return this.m;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m.length; ++i) {
            for (int j = 0; j < this.m[0].length; ++j) {
                stringBuffer.append(String.format("%+.6e\t", this.m[i][j]));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getNumberOfRows() {
        return this.m.length;
    }

    public int getNumberOfColumns() {
        try {
            return this.m[0].length;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public double getValue(int n, int n2) {
        return this.m[n][n2];
    }

    public void setValue(int n, int n2, double d) {
        this.m[n][n2] = d;
    }

    public Matrix transpose() {
        Matrix matrix = new Matrix(this.m[0].length, this.m.length);
        for (int i = 0; i < this.m.length; ++i) {
            for (int j = 0; j < this.m[0].length; ++j) {
                matrix.setValue(j, i, this.m[i][j]);
            }
        }
        return matrix;
    }

    public boolean isSquare() {
        return this.m.length == this.m[0].length;
    }

    public double getDeterminant() {
        if (this.isSquare()) {
            int n;
            this.makeLU();
            double d = 1.0;
            for (n = 0; n < this.m.length; ++n) {
                d *= this.U.getValue(n, n);
            }
            n = 0;
            return Math.pow(-1.0, n) * d;
        }
        return Double.NaN;
    }

    public Matrix getL() {
        if (this.L == null) {
            this.makeLU();
        }
        return this.L;
    }

    public Matrix getU() {
        if (this.U == null) {
            this.makeLU();
        }
        return this.U;
    }

    public Matrix getQ() {
        if (this.Q == null) {
            this.makeQR();
        }
        return this.Q;
    }

    public Matrix getR() {
        if (this.R == null) {
            this.makeQR();
        }
        return this.R;
    }

    public Matrix getInverse() {
        if (this.isSquare()) {
            Matrix matrix = new Matrix(this.m.length);
            Matrix matrix2 = new Matrix(this.m.length);
            for (int i = 0; i < this.m.length; ++i) {
                matrix.setColumn(i, Matrix.solve(this, matrix2.getColumn(i)));
                calculatingInverse = true;
            }
            calculatingInverse = false;
            return matrix;
        }
        throw new IllegalArgumentException(String.format("ERROR! Cannot calculate the inverse of a %dx%d matrix, it must be a square Matrix", this.m.length, this.m[0].length));
    }

    private void makeLU() {
        this.L = new Matrix(this.m.length);
        this.U = new Matrix(this);
        for (int i = 0; i < this.m[0].length; ++i) {
            for (int j = i + 1; j < this.m.length; ++j) {
                double d = this.U.getValue(j, i) / this.U.getValue(i, i);
                this.L.setValue(j, i, d);
                for (int k = i; k < this.m[0].length; ++k) {
                    this.U.setValue(j, k, this.U.getValue(j, k) - d * this.U.getValue(i, k));
                }
            }
        }
    }

    private void makeQR() {
        this.Q = new Matrix(this.m.length, this.m[0].length);
        this.R = new Matrix(this.m[0].length, this.m[0].length);
        Matrix matrix = new Matrix(this);
        for (int i = 0; i < this.m[0].length; ++i) {
            int n;
            double d = 0.0;
            for (n = 0; n < this.m.length; ++n) {
                d += Math.pow(matrix.getValue(n, i), 2.0);
            }
            d = Math.sqrt(d);
            this.R.setValue(i, i, d);
            for (n = 0; n < this.m.length; ++n) {
                this.Q.setValue(n, i, matrix.getValue(n, i) / d);
            }
            for (n = i + 1; n < this.m[0].length; ++n) {
                int n2;
                d = 0.0;
                for (n2 = 0; n2 < this.m.length; ++n2) {
                    d += matrix.getValue(n2, n) * this.Q.getValue(n2, i);
                }
                this.R.setValue(i, n, d);
                for (n2 = 0; n2 < this.m.length; ++n2) {
                    matrix.setValue(n2, n, matrix.getValue(n2, n) - this.R.getValue(i, n) * this.Q.getValue(n2, i));
                }
            }
        }
    }

    private Matrix getColumn(int n) {
        if (n < this.m[0].length) {
            Matrix matrix = new Matrix(this.m.length, 1);
            for (int i = 0; i < this.m.length; ++i) {
                matrix.setValue(i, 0, this.m[i][n]);
            }
            return matrix;
        }
        throw new IllegalArgumentException(String.format("ERROR! Cannot get column %d in the Matrix since it is > the number of columns in the Matrix, %d.", n, this.m[0].length));
    }

    private void setColumn(int n, Matrix matrix) {
        if (matrix.getNumberOfColumns() != 1 && matrix.getNumberOfRows() != 1) {
            throw new IllegalArgumentException(String.format("ERROR! Require a 1D vector to replace the values in a column of a matrix. Got a %dx%d vector.", matrix.getNumberOfRows(), matrix.getNumberOfColumns()));
        }
        if (matrix.getNumberOfColumns() != 1) {
            matrix = matrix.transpose();
        }
        if (matrix.getNumberOfRows() != this.m.length) {
            throw new IllegalArgumentException(String.format("ERROR! Cannot replace a Matrix column of length %d, with a column vector of length %d.", this.m.length, matrix.getNumberOfRows()));
        }
        if (n >= this.m[0].length) {
            throw new IllegalArgumentException(String.format("ERROR! Cannot replace column %d in the Matrix since it is > the number of columns in the matrix.", n));
        }
        for (int i = 0; i < this.m.length; ++i) {
            this.m[i][n] = matrix.getValue(i, 0);
        }
    }
}

