# Libro

📚 Libro: A simple command-line tool to track your reading history, with your data stored locally in a SQLite database.

## Usage

Add new book: `libro add`

Show books read by year: `libro show --year 2024`

Show book details by id: `libro show 123`

Show books by author: `libro show --author "Stephen King"`

Show books read by year: `libro report`

Show books read grouped by author: `libro report --author`

See: `libro --help` for more information.

### Examples

#### Books Read in Year

```
❯ libro
                                 Books Read in 2025
┏━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━━━━━━━━━━━━━━━┳━━━━━━━━┳━━━━━━━━━━━━━━┓
┃ id         ┃ Title                        ┃ Author               ┃ Rating ┃ Date Read    ┃
┡━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━━━━━━━━━━━━━━━╇━━━━━━━━╇━━━━━━━━━━━━━━┩
│ Fiction    │                              │                      │        │              │
│ 1          │ Cujo                         │ Stephen King         │ 3      │ Jan 05, 2025 │
│ 585        │ The Midnight Library         │ Matt Haig            │ 5      │ Jan 13, 2025 │
│ 587        │ The Maid                     │ Nita Prose           │ 4      │ Jan 20, 2025 │
│ 589        │ Into the Water               │ Paula Hawkins        │ 2      │ Feb 02, 2025 │
│ 584        │ Salem's Lot                  │ Stephen King         │ 3      │ Mar 12, 2025 │
│ 595        │ The Thursday Murder Club     │ Richard Osman        │ 3      │ Mar 20, 2025 │
│ 596        │ Remarkably Bright Creatures  │ Shelby Van Pelt      │ 5      │ Mar 27, 2025 │
│ 598        │ Colorless Tsukuru Tazaki     │ Haruki Murakami      │ 3      │ Apr 09, 2025 │
│ 599        │ Ten                          │ Gretchen McNeil      │ 3      │ Apr 16, 2025 │
│            │                              │                      │        │              │
│ Nonfiction │                              │                      │        │              │
│ 586        │ The Art Thief                │ Michael Finkel       │ 4      │ Jan 14, 2025 │
│ 588        │ All the Pieces Matter        │ Jonathan Abrams      │ 3      │ Jan 27, 2025 │
│ 590        │ Supercommunicators           │ Charles Duhigg       │ 4      │ Feb 04, 2025 │
│ 593        │ Leonardo da Vinci            │ Walter Isaacson      │ 3      │ Mar 02, 2025 │
│ 594        │ The Leap to Leader           │ Adam Bryant          │ 3      │ Mar 08, 2025 │
│ 597        │ Team of Rivals               │ Doris Kearns Goodwin │ 3      │ Apr 06, 2025 │
└────────────┴──────────────────────────────┴──────────────────────┴────────┴──────────────┘
```


#### Books by Year

```
❯ libro report

                         Books Read by Year

  Year   Count   Bar
 ───────────────────────────────────────────────────────────────────
  2013   3       ▄▄▄▄
  2014   4       ▄▄▄▄▄▄
  2015   11      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2016   30      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2017   21      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2018   27      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2019   29      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2020   27      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2021   28      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2022   27      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2023   32      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2024   30      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
  2025   17      ▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄▄
```

#### Author Report

```
❯ libro report --author

         Most Read Authors

  Author                Books Read
 ──────────────────────────────────
  Stephen King          15
  George R.R. Martin    5
  Timothy Zahn          4
  Grady Hendrix         4
  Andy Weir             4
  William Zinsser       3
  Roald Dahl            3
  Riley Sager           3
  Philip K. Dick        3
  Neil Gaiman           3
  Natalie D. Richards   3
  Lucy Foley            3
  Cory Doctorow         3
```


## Install

Libro is packaged as `libro-book` on PyPI.

```
pip install libro-book
```

You can also clone this repository and install it locally:

```
git clone https://github.com/mkaz/libro.git
cd libro
pip install -e .
```

## Setup

On first run, libro will create a `libro.db` database file based on database location. It will prompt for confirmation to proceed which also shows the location where the file will be created.

**Database locations:**

The following order is used to determine the database location:

1. Using the `--db` flag on command-line.

2. `libro.db` in current directory

3. Environment variable `LIBRO_DB` to specify custom file/location

4. Finally, the user's platform-specific data directory
    * Linux: `~/.local/share/libro/libro.db`
    * macOS: `~/Library/Application Support/libro/libro.db`
    * Windows: `%APPDATA%\libro\libro.db`


For example, if you want to create a new database file in the current directory, you can use the following command:

```
libro --db ./libro.db
```

### Import from Goodreads

Libro can import your reading history from a Goodreads export CSV file.

```
libro import goodreads_library_export.csv
```

There is a `genre` field for fiction and nonfiction, but this data is not available in the Goodreads export. I still need to build the edit book functionality to change the genre.

# Database Schema

## Books table

| Field | Type | Description |
|-------|------|-------------|
| id | primary key | Unique identifier |
| title | string | Book title |
| author | string | Book author |
| pages | int | Number of pages in book |
| pub_year | int | Year book was published |
| genre | string | Fiction or nonfiction |

## Reviews table

| Field | Type | Description |
|-------|------|-------------|
| id | primary key | Unique identifier |
| book_id | foreign key | Book identifier |
| date_read | date | Date book was read |
| rating | float | Number between 0 and 5 |
| review | text | Review of book |

# Changelog

See [GitHub Releases](https://github.com/mkaz/libro/releases) for the changelog.

# Packaging

Notes to self, I forget how to do this stuff.

Libro is packaged as `libro-book` on PyPI.

Packaging is done with `hatchling`, [see Guide](https://packaging.python.org/en/latest/tutorials/packaging-projects/)

```
# install tools
py -m pip install --upgrade build twine
```

```
# build
py -m build
```

```
# upload
py -m twine upload dist/*
```
