# deploy to cloud in 15 minutes ☁️

this guide gets your agent email layer live on the internet where **anyone can register agent addresses**.

## option 1: automated deployment (recommended)

run one command:

```bash
cd /Users/dorsa/Desktop/PROJECTS/synq_2/synqed-python
bash deploy_to_cloud.sh
```

this script will:
1. ✅ install fly.io cli (if needed)
2. ✅ create a fly.io app
3. ✅ provision postgres database
4. ✅ build and deploy docker container
5. ✅ give you a public https url

**cost**: $0-5/month (fly.io free tier + small postgres)

---

## option 2: manual deployment (step by step)

### step 1: install fly.io cli

```bash
curl -L https://fly.io/install.sh | sh
export FLYCTL_INSTALL="$HOME/.fly"
export PATH="$FLYCTL_INSTALL/bin:$PATH"
```

### step 2: login and create app

```bash
flyctl auth login
flyctl apps create agent-email-layer
```

### step 3: create postgres database

```bash
flyctl postgres create --name agent-email-layer-db --region sjc
flyctl postgres attach agent-email-layer-db --app agent-email-layer
```

### step 4: deploy

```bash
flyctl deploy
```

that's it! your service is now live.

---

## what you get after deployment

### 1. public api endpoint

```
https://agent-email-layer.fly.dev
```

### 2. automatic https

fly.io provides free ssl certificates.

### 3. persistent postgres database

all agent registrations are saved to postgres.

### 4. api documentation

```
https://agent-email-layer.fly.dev/docs
```

### 5. example usage

anyone can now register their agents:

```bash
# register an agent
curl -X POST https://agent-email-layer.fly.dev/v1/agents \
  -H "Content-Type: application/json" \
  -d '{
    "email_like": "my-agent@mycompany",
    "inbox_url": "https://myagent.example.com/inbox",
    "capabilities": ["a2a/1.0"]
  }'

# lookup an agent
curl https://agent-email-layer.fly.dev/v1/agents/by-email/my-agent@mycompany
```

---

## monitoring & management

### view logs
```bash
flyctl logs --app agent-email-layer
```

### scale up (if needed)
```bash
flyctl scale vm shared-cpu-2x --app agent-email-layer
```

### add custom domain
```bash
flyctl certs add agentmail.io --app agent-email-layer
```

### database access
```bash
flyctl postgres connect --app agent-email-layer-db
```

---

## cost breakdown

| service | cost |
|---------|------|
| fly.io app (shared cpu, 256mb) | $0 (free tier) |
| postgres database (1gb storage) | ~$5/month |
| bandwidth (first 160gb) | free |
| https/ssl | free |
| **total** | **~$5/month** |

for high traffic:
- upgrade to dedicated cpu: +$15/month
- add more memory: +$5/512mb
- add replicas for HA: +$5/replica

---

## next steps after deployment

### 1. test it works

```bash
# health check
curl https://agent-email-layer.fly.dev/health

# register test agent
curl -X POST https://agent-email-layer.fly.dev/v1/agents \
  -H "Content-Type: application/json" \
  -d '{
    "email_like": "test@myorg",
    "inbox_url": "https://example.com/inbox"
  }'

# verify registration
curl https://agent-email-layer.fly.dev/v1/agents/by-email/test@myorg
```

### 2. add authentication (optional but recommended)

see `DEPLOYMENT.md` section on api keys.

quick version:

```bash
# set api key secret
flyctl secrets set AGENT_REGISTRY_API_KEY="your-secret-key-here" --app agent-email-layer

# update api to require auth (see DEPLOYMENT.md for code)
```

### 3. add rate limiting (recommended for public api)

```bash
pip install slowapi
```

then add to `src/synqed/agent_email/main.py` (see DEPLOYMENT.md for code).

### 4. setup monitoring

```bash
# add sentry for error tracking
flyctl secrets set SENTRY_DSN="your-sentry-dsn" --app agent-email-layer
```

### 5. custom domain (optional)

```bash
# point your domain to fly.io
flyctl certs add yourdomain.com --app agent-email-layer

# then update dns:
# add CNAME record: yourdomain.com -> agent-email-layer.fly.dev
```

---

## alternative: deploy to google cloud run

if you prefer google cloud:

```bash
# 1. build image
gcloud builds submit --tag gcr.io/YOUR_PROJECT/agent-email-layer

# 2. create cloud sql postgres
gcloud sql instances create agent-db --database-version=POSTGRES_15 --tier=db-f1-micro --region=us-central1

# 3. deploy
gcloud run deploy agent-email-layer \
  --image gcr.io/YOUR_PROJECT/agent-email-layer \
  --platform managed \
  --region us-central1 \
  --allow-unauthenticated \
  --add-cloudsql-instances YOUR_PROJECT:us-central1:agent-db
```

**cost**: ~$10-30/month (includes cloud sql)

---

## troubleshooting

### deployment fails

```bash
# check logs
flyctl logs --app agent-email-layer

# common issues:
# - out of memory: increase vm size
# - database connection: check DATABASE_URL is set
# - port binding: ensure PORT=8080 in dockerfile
```

### database not connecting

```bash
# verify database is attached
flyctl postgres list
flyctl postgres attach agent-email-layer-db --app agent-email-layer

# check connection string
flyctl config show --app agent-email-layer
```

### app won't start

```bash
# test locally first
docker build -t agent-email-test .
docker run -p 8080:8080 agent-email-test

# curl localhost:8080/health should work
```

---

## what users can do once it's deployed

anyone in the world can:

1. **register their agent**
```python
import httpx

async with httpx.AsyncClient() as client:
    response = await client.post(
        "https://agent-email-layer.fly.dev/v1/agents",
        json={
            "email_like": "my-agent@mycompany",
            "inbox_url": "https://my-agent-server.com/inbox",
            "capabilities": ["a2a/1.0", "code-generation"],
        }
    )
    print(response.json())
```

2. **discover other agents**
```python
# find an agent by email-like address
response = await client.get(
    "https://agent-email-layer.fly.dev/v1/agents/by-email/gemini@google"
)
agent = response.json()
print(agent["inbox_url"])  # where to send messages
```

3. **send messages to agents**
```python
# send a2a message via inbox api
response = await client.post(
    agent["inbox_url"],
    json={
        "sender": "agent://mycompany/my-agent",
        "recipient": agent["agent_id"],
        "message": {
            "thread_id": "abc123",
            "role": "user",
            "content": "help me with this task...",
        }
    }
)
print(response.json()["response_envelope"])
```

---

## ready to deploy?

```bash
cd /Users/dorsa/Desktop/PROJECTS/synq_2/synqed-python
bash deploy_to_cloud.sh
```

or manually:

```bash
flyctl auth login
flyctl apps create agent-email-layer
flyctl postgres create --name agent-email-layer-db
flyctl postgres attach agent-email-layer-db
flyctl deploy
```

**that's it! 🎉**

your agent email layer is now a public internet service.

