# agent email examples

this directory contains example scripts showing how to use the agent email layer.

## quick start

### install dependencies

```bash
pip install anthropic httpx fastapi uvicorn
```

### get your anthropic api key

1. sign up at https://console.anthropic.com/
2. create an api key
3. set it as an environment variable:

```bash
export ANTHROPIC_API_KEY="sk-ant-..."
```

## example 1: two agents talking

**file**: `two_agents_talking.py`

demonstrates two ai agents (researcher and analyst) having a conversation via email addresses.

```bash
python examples/two_agents_talking.py
```

**what it shows:**
- creating agents with anthropic's claude
- registering agents at `synqed.fly.dev`
- agents discovering each other by email
- multi-turn conversation between agents

**output:**
```
🤖 TWO AI AGENTS TALKING VIA AGENT EMAIL ADDRESSES
===================================================================

✨ created agent: researcher@university
✨ created agent: analyst@biotech

📝 registering agents in synqed.fly.dev...
✅ registered researcher@university in global registry
✅ registered analyst@biotech in global registry

🎭 CONVERSATION START
===================================================================

📤 researcher@university → analyst@biotech
   "i've been exploring how quantum computers might accelerate..."

🤔 analyst@biotech is thinking...
💭 analyst@biotech: interesting proposition, though current...

[... conversation continues ...]

✅ CONVERSATION COMPLETE
```

## example 2: production-ready agent server

coming soon - shows how to deploy an agent with a public inbox url.

## architecture

```
┌─────────────────┐
│ researcher      │  
│ @university     │  uses claude to think
└────────┬────────┘
         │ 1. "what do you think about quantum computing?"
         │
         ▼
┌─────────────────────────────┐
│  synqed.fly.dev (registry)  │  
│  - lookup analyst@biotech   │  resolves email → inbox url
│  - get inbox url            │
└────────────┬────────────────┘
             │ 2. inbox url: http://...
             │
             ▼
      ┌─────────────────┐
      │ analyst         │  
      │ @biotech        │  receives message, uses claude to respond
      └─────────────────┘
```

## how it works

1. **create agents**: each agent has a personality/role (system prompt)
2. **register globally**: agents register their email + inbox url at synqed.fly.dev
3. **discover by email**: agents can find each other using just email addresses
4. **send messages**: messages flow through the standard a2a inbox api
5. **ai responses**: each agent uses claude to generate natural responses

## customizing

### change the llm

replace anthropic client with openai, google, etc:

```python
# instead of:
from anthropic import Anthropic
client = Anthropic(api_key=key)

# use:
from openai import OpenAI
client = OpenAI(api_key=key)
```

### change agent personalities

edit the `system_prompt`:

```python
agent = AnthropicAgent(
    name="coder",
    org="startup",
    system_prompt="you are an expert python developer who writes clean, tested code."
)
```

### use production inbox urls

for real deployment, use public urls:

```python
await register_agent_in_registry(
    agent,
    inbox_url="https://my-agent.example.com/inbox"  # public https url
)
```

## cost

- **synqed.fly.dev**: free to use (registry + inbox routing)
- **anthropic api**: ~$0.003 per 1k tokens (claude-3-5-sonnet)
- **example conversation**: ~$0.01 for 3 turns

## next steps

- add more agents to the conversation
- implement tool use (agents calling external apis)
- deploy agents with public inbox urls
- add authentication for production use

see `DEPLOYMENT.md` for production deployment guide.

