var $;

document.addEventListener("DOMContentLoaded", function () {
  if (typeof $ == "undefined") {
    $ = jQuery.noConflict();
  }
  $(document).ready(daReadyFunction);
});

var daAudioContext = null;
var daSocket;
var daSoundBuffer = Object();
var daShowingNotif = false;
var daUpdatedSessions = Object();
var daSessions = Object();
var daAvailRoles = Object();
var daChatPartners = Object();
var daPhonePartners = Object();
var daNewPhonePartners = Object();
var daTermPhonePartners = Object();
var daFirstTime = 1;
var daUpdateMonitorInterval = null;
var daNotificationsEnabled = false;
var daControlling = Object();
window.daGotConfirmation = function (key) {
  //console.log("Got confirmation in parent for key " + key);
  // daControlling[key] = 2;
  // var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, '\\$1');
  // $("#listelement" + skey).find("a").each(function(){
  //     if ($(this).data('name') == "stopcontrolling"){
  //         $(this).removeClass('dainvisible');
  //         console.log("Found it");
  //     }
  // });
};
function daFaviconRegular() {
  var link =
    document.querySelector("link[rel*='shortcut icon'") ||
    document.createElement("link");
  link.type = "image/x-icon";
  link.rel = "shortcut icon";
  link.href = daFaviconIcoUrl;
  document.getElementsByTagName("head")[0].appendChild(link);
}
function daFaviconAlert() {
  var link =
    document.querySelector("link[rel*='shortcut icon'") ||
    document.createElement("link");
  link.type = "image/x-icon";
  link.rel = "shortcut icon";
  link.href = daChatIcoUrl;
  document.getElementsByTagName("head")[0].appendChild(link);
}
function daTopMessage(message) {
  var newDiv = document.createElement("div");
  $(newDiv).addClass(
    "datop-alert col-xs-10 col-sm-7 col-md-6 col-lg-5 dacol-centered",
  );
  $(newDiv).html(message);
  $(newDiv).css("display", "none");
  $(newDiv).appendTo($(daTargetDiv));
  $(newDiv).slideDown();
  setTimeout(function () {
    $(newDiv).slideUp(300, function () {
      $(newDiv).remove();
    });
  }, 2000);
}
window.daAbortControlling = function (key) {
  daTopMessage(daAlreadyControlled);
  daStopControlling(key);
};
window.daStopControlling = function (key) {
  //console.log("Got daStopControlling in parent for key " + key);
  // if (daControlling.hasOwnProperty(key)){
  //   delete daControlling[key];
  // }
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  $("#listelement" + skey)
    .find("a")
    .each(function () {
      if ($(this).data("name") == "stopcontrolling") {
        $(this).click();
        //console.log("Found it");
      }
    });
};
function daOnError() {
  console.log("daOnError");
}
function daLoadSoundBuffer(key, url_a, url_b) {
  //console.log("daLoadSoundBuffer");
  var pos = 0;
  if (daAudioContext == null) {
    return;
  }
  var request = new XMLHttpRequest();
  request.open("GET", url_a, true);
  request.responseType = "arraybuffer";
  request.onload = function () {
    daAudioContext.decodeAudioData(
      request.response,
      function (buffer) {
        if (!buffer) {
          if (pos == 1) {
            console.error("daLoadSoundBuffer: error decoding file data");
            return;
          } else {
            pos = 1;
            console.info(
              "daLoadSoundBuffer: error decoding file data, trying next source",
            );
            request.open("GET", url_b, true);
            return request.send();
          }
        }
        daSoundBuffer[key] = buffer;
      },
      function (error) {
        if (pos == 1) {
          console.error("daLoadSoundBuffer: decodeAudioData error");
          return;
        } else {
          pos = 1;
          console.info(
            "daLoadSoundBuffer: decodeAudioData error, trying next source",
          );
          request.open("GET", url_b, true);
          return request.send();
        }
      },
    );
  };
  request.send();
}
function daPlaySound(key) {
  //console.log("daPlaySound");
  var buffer = daSoundBuffer[key];
  if (!daAudioContext || !buffer) {
    return;
  }
  var source = daAudioContext.createBufferSource();
  source.buffer = buffer;
  source.connect(daAudioContext.destination);
  source.start(0);
}
function daCheckNotifications() {
  //console.log("daCheckNotifications");
  if (daNotificationsEnabled) {
    return;
  }
  if (!("Notification" in window)) {
    daNotificationsEnabled = false;
    return;
  }
  if (Notification.permission === "granted") {
    daNotificationsEnabled = true;
    return;
  }
  if (Notification.permission !== "denied") {
    Notification.requestPermission(function (permission) {
      if (permission === "granted") {
        daNotificationsEnabled = true;
      }
    });
  }
}
function daNotifyOperator(key, mode, message) {
  //console.log("daNotifyOperator: " + key + " " + mode + " " + message);
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  if (mode == "chat") {
    daPlaySound("newmessage");
  } else {
    daPlaySound("newconversation");
  }
  if (
    $("#listelement" + skey).offset().top >
    $(window).scrollTop() + $(window).height()
  ) {
    if (mode == "chat") {
      $("#chat-message-below").html(daNewMessageBelow);
    } else {
      $("#chat-message-below").html(daNewConversationBelow);
    }
    //$("#chat-message-below").data('key', key);
    $("#chat-message-below").slideDown();
    daShowingNotif = true;
    daMarkAsUpdated(key);
  } else if (
    $("#listelement" + skey).offset().top + $("#listelement" + skey).height() <
    $(window).scrollTop() + 32
  ) {
    if (mode == "chat") {
      $("#chat-message-above").html(daNewMessageAbove);
    } else {
      $("#chat-message-above").html(daNewConversationAbove);
    }
    //$("#chat-message-above").data('key', key);
    $("#chat-message-above").slideDown();
    daShowingNotif = true;
    daMarkAsUpdated(key);
  } else {
    //console.log("It is visible");
  }
  if (!daNotificationsEnabled) {
    //console.log("Browser will not enable notifications")
    return;
  }
  if (!("Notification" in window)) {
    return;
  }
  if (Notification.permission === "granted") {
    var notification = new Notification(message);
  } else if (Notification.permission !== "denied") {
    Notification.requestPermission(function (permission) {
      if (permission === "granted") {
        var notification = new Notification(message);
        daNotificationsEnabled = true;
      }
    });
  }
}
function daPhoneNumberOk() {
  //console.log("daPhoneNumberOk");
  var phoneNumber = $("#daPhoneNumber").val();
  if (phoneNumber == "" || phoneNumber.match(/^\+?[1-9]\d{1,14}$/)) {
    return true;
  } else {
    return false;
  }
}
function daCheckPhone() {
  //console.log("daCheckPhone");
  $("#daPhoneNumber").val($("#daPhoneNumber").val().replace(/ \-/g, ""));
  var the_number = $("#daPhoneNumber").val();
  if (the_number != "" && the_number[0] != "+") {
    $("#daPhoneNumber").val("+" + the_number);
  }
  if (daPhoneNumberOk()) {
    $("#daPhoneNumber").removeClass("is-invalid");
    $("#daPhoneError").addClass("dainvisible");
    daPhoneNumber = $("#daPhoneNumber").val();
    if (daPhoneNumber == "") {
      daPhoneNumber = null;
    } else {
      $(".phone").removeClass("dainvisible");
    }
    $("#daPhoneSaved").removeClass("dainvisible");
    setTimeout(function () {
      $("#daPhoneSaved").addClass("dainvisible");
    }, 2000);
  } else {
    $("#daPhoneNumber").addClass("is-invalid");
    $("#daPhoneError").removeClass("dainvisible");
    daPhoneNumber = null;
    $(".phone").addClass("dainvisible");
  }
}
function daAllSessions(uid, yaml_filename) {
  //console.log("daAllSessions");
  var prefix = "da:session:uid:" + uid + ":i:" + yaml_filename + ":userid:";
  var output = Array();
  for (var key in daSessions) {
    if (daSessions.hasOwnProperty(key) && key.indexOf(prefix) == 0) {
      output.push(key);
    }
  }
  return output;
}
function daScrollChat(key) {
  var chatScroller = $(key).find("ul").first();
  if (chatScroller.length) {
    var height = chatScroller[0].scrollHeight;
    chatScroller.animate({ scrollTop: height }, 800);
  } else {
    console.log("daScrollChat: error");
  }
}
function daScrollChatFast(key) {
  var chatScroller = $(key).find("ul").first();
  if (chatScroller.length) {
    var height = chatScroller[0].scrollHeight;
    //console.log("Scrolling to " + height + " where there are " + chatScroller[0].childElementCount + " children");
    chatScroller.scrollTop(height);
  } else {
    console.log("daScrollChatFast: error");
  }
}
function daDoUpdateMonitor() {
  //console.log("daDoUpdateMonitor with " + daAvailableForChat);
  if (daPhoneNumberOk()) {
    daPhoneNumber = $("#daPhoneNumber").val();
    if (daPhoneNumber == "") {
      daPhoneNumber = null;
    }
  } else {
    daPhoneNumber = null;
  }
  daSocket.emit("updatemonitor", {
    available_for_chat: daAvailableForChat,
    phone_number: daPhoneNumber,
    subscribed_roles: daSubscribedRoles,
    phone_partners_to_add: daNewPhonePartners,
    phone_partners_to_terminate: daTermPhonePartners,
  });
}
function daUpdateMonitor() {
  //console.log("daUpdateMonitor with " + daAvailableForChat);
  if (daUpdateMonitorInterval != null) {
    clearInterval(daUpdateMonitorInterval);
  }
  daDoUpdateMonitor();
  daUpdateMonitorInterval = setInterval(daDoUpdateMonitor, daCheckinInterval);
  //console.log("daUpdateMonitor");
}
function daIsHidden(ref) {
  if ($(ref).length) {
    if ($(ref).offset().top + $(ref).height() < $(window).scrollTop() + 32) {
      return -1;
    } else if (
      $(ref).offset().top >
      $(window).scrollTop() + $(window).height()
    ) {
      return 1;
    } else {
      return 0;
    }
  } else {
    return 0;
  }
}
function daMarkAsUpdated(key) {
  //console.log("daMarkAsUpdated with " + key);
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  if (daIsHidden("#listelement" + skey)) {
    daUpdatedSessions["#listelement" + skey] = 1;
  }
}
function daActivateChatArea(key) {
  //console.log("daActivateChatArea with " + key);
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  if (
    !$("#chatarea" + skey)
      .find("input")
      .first()
      .is(":focus")
  ) {
    $("#listelement" + skey).addClass("da-new-message");
    if (daBrowserTitle == document.title) {
      document.title = "* " + daBrowserTitle;
      daFaviconAlert();
    }
  }
  daMarkAsUpdated(key);
  $("#chatarea" + skey).removeClass("dainvisible");
  $("#chatarea" + skey)
    .find("input, button")
    .prop("disabled", false);
  $("#chatarea" + skey)
    .find("ul")
    .html("");
  daSocket.emit("chat_log", { key: key });
}
function daDeActivateChatArea(key) {
  //console.log("daActivateChatArea with " + key);
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  $("#chatarea" + skey)
    .find("input, button")
    .prop("disabled", true);
  $("#listelement" + skey).removeClass("da-new-message");
  if (document.title != daBrowserTitle) {
    document.title = daBrowserTitle;
    daFaviconRegular();
  }
}
function daUndrawSession(key) {
  //console.log("Undrawing...");
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  var xButton = document.createElement("a");
  var xButtonIcon = document.createElement("i");
  $(xButton).addClass("dacorner-remove");
  $(xButtonIcon).addClass("fa-solid fa-times-circle");
  $(xButtonIcon).appendTo($(xButton));
  $("#listelement" + skey).addClass("list-group-item-danger");
  $("#session" + skey)
    .find("a")
    .remove();
  $("#session" + skey)
    .find("span")
    .first()
    .html(daOfflineWord);
  $("#session" + skey)
    .find("span")
    .first()
    .removeClass(daButtonStyle + "info");
  $("#session" + skey)
    .find("span")
    .first()
    .addClass(daButtonStyle + "danger");
  $(xButton).click(function () {
    $("#listelement" + skey).slideUp(300, function () {
      $("#listelement" + skey).remove();
      daCheckIfEmpty();
    });
  });
  $(xButton).appendTo($("#session" + skey));
  $("#chatarea" + skey)
    .find("input, button")
    .prop("disabled", true);
  var theIframe = $("#iframe" + skey).find("iframe")[0];
  if (theIframe) {
    $(theIframe).contents().find("body").addClass("dainactive");
    if (theIframe.contentWindow && theIframe.contentWindow.daTurnOffControl) {
      theIframe.contentWindow.daTurnOffControl();
    }
  }
  if (daControlling.hasOwnProperty(key)) {
    delete daControlling[key];
  }
  delete daSessions[key];
}
function daPublishChatLog(uid, yaml_filename, userid, mode, messages, scroll) {
  //console.log("daPublishChatLog with " + uid + " " + yaml_filename + " " + userid + " " + mode + " " + messages);
  //console.log("daPublishChatLog: scroll is " + scroll);
  var keys;
  //if (mode == 'peer' || mode == 'peerhelp'){
  //    keys = daAllSessions(uid, yaml_filename);
  //}
  //else{
  keys = [
    "da:session:uid:" + uid + ":i:" + yaml_filename + ":userid:" + userid,
  ];
  //}
  for (var i = 0; i < keys.length; ++i) {
    key = keys[i];
    var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
    var chatArea = $("#chatarea" + skey)
      .find("ul")
      .first();
    if (messages.length > 0) {
      $(chatArea).removeClass("dainvisible");
    }
    for (var i = 0; i < messages.length; ++i) {
      var message = messages[i];
      var newLi = document.createElement("li");
      $(newLi).addClass("list-group-item");
      if (message.is_self) {
        $(newLi).addClass("list-group-item-primary dalistright");
      } else {
        $(newLi).addClass("list-group-item-secondary dalistleft");
      }
      $(newLi).html(message.message);
      $(newLi).appendTo(chatArea);
    }
    if (messages.length > 0 && scroll) {
      daScrollChatFast("#chatarea" + skey);
    }
  }
}
function daCheckIfEmpty() {
  if ($("#monitorsessions").find("li").length > 0) {
    $("#emptylist").addClass("dainvisible");
  } else {
    $("#emptylist").removeClass("dainvisible");
  }
}
function daDrawSession(key, obj) {
  //console.log("daDrawSession with " + key);
  var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
  var the_html;
  var wants_to_chat;
  if (obj.chatstatus != "off") {
    wants_to_chat = true;
  }
  if (wants_to_chat) {
    the_html = obj.browser_title + " &mdash; ";
    if (obj.hasOwnProperty("first_name")) {
      the_html += obj.first_name + " " + obj.last_name;
    } else {
      the_html += daAnonymousVisitor + " " + obj.temp_user_id;
    }
  }
  var theListElement;
  var sessionDiv;
  var theIframeContainer;
  var theChatArea;
  if ($("#session" + skey).length && !(key in daSessions)) {
    $("#listelement" + skey).removeClass("list-group-item-danger");
    $("#iframe" + skey)
      .find("iframe")
      .first()
      .contents()
      .find("body")
      .removeClass("dainactive");
  }
  daSessions[key] = 1;
  if ($("#session" + skey).length) {
    theListElement = $("#listelement" + skey).first();
    sessionDiv = $("#session" + skey).first();
    //controlDiv = $("#control" + skey).first();
    theIframeContainer = $("#iframe" + skey).first();
    theChatArea = $("#chatarea" + skey).first();
    $(sessionDiv).empty();
    if (
      obj.chatstatus == "on" &&
      key in daChatPartners &&
      $("#chatarea" + skey)
        .find("button")
        .first()
        .prop("disabled") == true
    ) {
      daActivateChatArea(key);
    }
  } else {
    var theListElement = document.createElement("li");
    $(theListElement).addClass("list-group-item");
    $(theListElement).attr("id", "listelement" + key);
    var sessionDiv = document.createElement("div");
    $(sessionDiv).attr("id", "session" + key);
    $(sessionDiv).addClass("da-chat-session");
    $(sessionDiv).addClass("p-1");
    $(sessionDiv).appendTo($(theListElement));
    $(theListElement).appendTo("#monitorsessions");
    // controlDiv = document.createElement('div');
    // $(controlDiv).attr('id', "control" + key);
    // $(controlDiv).addClass("dachatcontrol dainvisible da-chat-session");
    // $(controlDiv).appendTo($(theListElement));
    theIframeContainer = document.createElement("div");
    $(theIframeContainer).addClass("daobserver-container dainvisible");
    $(theIframeContainer).attr("id", "iframe" + key);
    var theIframe = document.createElement("iframe");
    $(theIframe).addClass("daobserver");
    $(theIframe).attr("name", "iframe" + key);
    $(theIframe).appendTo($(theIframeContainer));
    $(theIframeContainer).appendTo($(theListElement));
    var theChatArea = document.createElement("div");
    $(theChatArea).addClass("monitor-chat-area dainvisible");
    $(theChatArea).html(
      '<div class="row"><div class="col-md-12"><ul class="list-group dachatbox" id="daCorrespondence"></ul></div></div><form autocomplete="off"><div class="row"><div class="col-md-12"><div class="input-group"><input type="text" class="form-control daChatMessage" disabled=""><button role="button" class="btn " + daButtonStyle + "secondary daChatButton" type="button" disabled="">' +
        daSendWord +
        "</button></div></div></div></form>",
    );
    $(theChatArea).attr("id", "chatarea" + key);
    var submitter = function () {
      //console.log("I am the submitter and I am submitting " + key);
      var input = $(theChatArea).find("input").first();
      var message = input.val().trim();
      if (message == null || message == "") {
        //console.log("Message was blank");
        return false;
      }
      daSocket.emit("chatmessage", { key: key, data: input.val() });
      input.val("");
      return false;
    };
    $(theChatArea).find("button").click(submitter);
    $(theChatArea)
      .find("input")
      .bind("keypress keydown keyup", function (e) {
        var theCode = e.which || e.keyCode;
        if (theCode == 13) {
          submitter();
          e.preventDefault();
        }
      });
    $(theChatArea)
      .find("input")
      .focus(function () {
        $(theListElement).removeClass("da-new-message");
        if (document.title != daBrowserTitle) {
          document.title = daBrowserTitle;
          daFaviconRegular();
        }
      });
    $(theChatArea).appendTo($(theListElement));
    if (obj.chatstatus == "on" && key in daChatPartners) {
      daActivateChatArea(key);
    }
  }
  var theText = document.createElement("span");
  $(theText).addClass("da-chat-title-label");
  theText.innerHTML = the_html;
  var statusLabel = document.createElement("span");
  $(statusLabel).addClass("badge bg-info da-chat-status-label");
  $(statusLabel).html(obj.chatstatus == "observeonly" ? "off" : obj.chatstatus);
  $(statusLabel).appendTo($(sessionDiv));
  if (daUsePhone) {
    var phoneButton = document.createElement("a");
    var phoneIcon = document.createElement("i");
    $(phoneIcon).addClass("fa-solid fa-phone");
    $(phoneIcon).appendTo($(phoneButton));
    $(phoneButton).addClass("btn phone");
    $(phoneButton).data("name", "phone");
    if (key in daPhonePartners) {
      $(phoneButton).addClass("phone-on " + daButtonStyle + "success");
      $(phoneButton).attr("title", daPhoneOnMessage);
    } else {
      $(phoneButton).addClass("phone-off " + daButtonStyle + "secondary");
      $(phoneButton).attr("title", daPhoneOffMessage);
    }
    $(phoneButton).attr("tabindex", 0);
    $(phoneButton).addClass("daobservebutton");
    $(phoneButton).appendTo($(sessionDiv));
    $(phoneButton).attr("href", "#");
    if (daPhoneNumber == null) {
      $(phoneButton).addClass("dainvisible");
    }
    $(phoneButton).click(function (e) {
      e.preventDefault();
      if ($(this).hasClass("phone-off") && daPhoneNumber != null) {
        $(this).removeClass("phone-off");
        $(this).removeClass(daButtonStyle + "secondary");
        $(this).addClass("phone-on");
        $(this).addClass(daButtonStyle + "success");
        $(this).attr("title", daPhoneOnMessage);
        daPhonePartners[key] = 1;
        daNewPhonePartners[key] = 1;
        if (key in daTermPhonePartners) {
          delete daTermPhonePartners[key];
        }
      } else {
        $(this).removeClass("phone-on");
        $(this).removeClass(daButtonStyle + "success");
        $(this).addClass("phone-off");
        $(this).addClass(daButtonStyle + "secondary");
        $(this).attr("title", daPhoneOffMessage);
        if (key in daPhonePartners) {
          delete daPhonePartners[key];
        }
        if (key in daNewPhonePartners) {
          delete daNewPhonePartners[key];
        }
        daTermPhonePartners[key] = 1;
      }
      daUpdateMonitor();
      return false;
    });
  }
  var unblockButton = document.createElement("a");
  $(unblockButton).addClass("btn " + daButtonStyle + "info daobservebutton");
  $(unblockButton).data("name", "unblock");
  if (!obj.blocked) {
    $(unblockButton).addClass("dainvisible");
  }
  $(unblockButton).html(daUnblockWord);
  $(unblockButton).attr("href", "#");
  $(unblockButton).appendTo($(sessionDiv));
  var blockButton = document.createElement("a");
  $(blockButton).addClass("btn " + daButtonStyle + "danger daobservebutton");
  if (obj.blocked) {
    $(blockButton).addClass("dainvisible");
  }
  $(blockButton).html(daBlockWord);
  $(blockButton).attr("href", "#");
  $(blockButton).data("name", "block");
  $(blockButton).appendTo($(sessionDiv));
  $(blockButton).click(function (e) {
    $(unblockButton).removeClass("dainvisible");
    $(this).addClass("dainvisible");
    daDeActivateChatArea(key);
    daSocket.emit("block", { key: key });
    e.preventDefault();
    return false;
  });
  $(unblockButton).click(function (e) {
    $(blockButton).removeClass("dainvisible");
    $(this).addClass("dainvisible");
    daSocket.emit("unblock", { key: key });
    e.preventDefault();
    return false;
  });
  var joinButton = document.createElement("a");
  $(joinButton).addClass("btn " + daButtonStyle + "warning daobservebutton");
  $(joinButton).html(daJoinWord);
  $(joinButton).attr(
    "href",
    daVisitInterviewUrl +
      "?" +
      $.param({ i: obj.i, uid: obj.uid, userid: obj.userid }),
  );
  $(joinButton).data("name", "join");
  $(joinButton).attr("target", "_blank");
  $(joinButton).appendTo($(sessionDiv));
  if (wants_to_chat) {
    var openButton = document.createElement("a");
    $(openButton).addClass("btn " + daButtonStyle + "primary daobservebutton");
    $(openButton).attr(
      "href",
      daObserverUrl +
        "?" +
        $.param({ i: obj.i, uid: obj.uid, userid: obj.userid }),
    );
    //$(openButton).attr('href', 'about:blank');
    $(openButton).attr("id", "observe" + key);
    $(openButton).attr("target", "iframe" + key);
    $(openButton).html(daObserveWord);
    $(openButton).data("name", "open");
    $(openButton).appendTo($(sessionDiv));
    var stopObservingButton = document.createElement("a");
    $(stopObservingButton).addClass(
      "btn " + daButtonStyle + "secondary daobservebutton dainvisible",
    );
    $(stopObservingButton).html(daStopObservingWord);
    $(stopObservingButton).attr("href", "#");
    $(stopObservingButton).data("name", "stopObserving");
    $(stopObservingButton).appendTo($(sessionDiv));
    var controlButton = document.createElement("a");
    $(controlButton).addClass("btn " + daButtonStyle + "info daobservebutton");
    $(controlButton).html(daControlWord);
    $(controlButton).attr("href", "#");
    $(controlButton).data("name", "control");
    $(controlButton).appendTo($(sessionDiv));
    var stopControllingButton = document.createElement("a");
    $(stopControllingButton).addClass(
      "btn " + daButtonStyle + "secondary daobservebutton dainvisible",
    );
    $(stopControllingButton).html(daStopControllingWord);
    $(stopControllingButton).attr("href", "#");
    $(stopControllingButton).data("name", "stopcontrolling");
    $(stopControllingButton).appendTo($(sessionDiv));
    $(controlButton).click(function (event) {
      event.preventDefault();
      //console.log("Controlling...");
      $(this).addClass("dainvisible");
      $(stopControllingButton).removeClass("dainvisible");
      $(stopObservingButton).addClass("dainvisible");
      var theIframe = $("#iframe" + skey).find("iframe")[0];
      if (theIframe != null && theIframe.contentWindow) {
        theIframe.contentWindow.daTurnOnControl();
      } else {
        console.log("Cannot turn on control");
      }
      daControlling[key] = 1;
      return false;
    });
    $(stopControllingButton).click(function (event) {
      //console.log("Got click on stopControllingButton");
      event.preventDefault();
      var theIframe = $("#iframe" + skey).find("iframe")[0];
      if (
        theIframe != null &&
        theIframe.contentWindow &&
        theIframe.contentWindow.daTurnOffControl
      ) {
        theIframe.contentWindow.daTurnOffControl();
      } else {
        console.log("Cannot turn off control");
        return false;
      }
      //console.log("Stop controlling...");
      $(this).addClass("dainvisible");
      $(controlButton).removeClass("dainvisible");
      $(stopObservingButton).removeClass("dainvisible");
      if (daControlling.hasOwnProperty(key)) {
        delete daControlling[key];
      }
      return false;
    });
    $(openButton).click(function (event) {
      //console.log("Observing..");
      $(this).addClass("dainvisible");
      $(stopObservingButton).removeClass("dainvisible");
      $("#iframe" + skey).removeClass("dainvisible");
      $(controlButton).removeClass("dainvisible");
      return true;
    });
    $(stopObservingButton).click(function (e) {
      //console.log("Unobserving...");
      $(this).addClass("dainvisible");
      $(openButton).removeClass("dainvisible");
      $(controlButton).addClass("dainvisible");
      $(stopObservingButton).addClass("dainvisible");
      $(stopControllingButton).addClass("dainvisible");
      var theIframe = $("#iframe" + skey).find("iframe")[0];
      if (daControlling.hasOwnProperty(key)) {
        delete daControlling[key];
        if (
          theIframe != null &&
          theIframe.contentWindow &&
          theIframe.contentWindow.daTurnOffControl
        ) {
          //console.log("Calling daTurnOffControl in iframe");
          theIframe.contentWindow.daTurnOffControl();
        }
      }
      if (theIframe != null && theIframe.contentWindow) {
        //console.log("Deleting the iframe");
        theIframe.contentWindow.document.open();
        theIframe.contentWindow.document.write("");
        theIframe.contentWindow.document.close();
      }
      $("#iframe" + skey).slideUp(400, function () {
        $(this).css("display", "").addClass("dainvisible");
      });
      e.preventDefault();
      return false;
    });
    if ($(theIframeContainer).hasClass("dainvisible")) {
      $(openButton).removeClass("dainvisible");
      $(stopObservingButton).addClass("dainvisible");
      $(controlButton).addClass("dainvisible");
      $(stopControllingButton).addClass("dainvisible");
      if (daControlling.hasOwnProperty(key)) {
        delete daControlling[key];
      }
    } else {
      $(openButton).addClass("dainvisible");
      if (daControlling.hasOwnProperty(key)) {
        $(stopObservingButton).addClass("dainvisible");
        $(controlButton).addClass("dainvisible");
        $(stopControllingButton).removeClass("dainvisible");
      } else {
        $(stopObservingButton).removeClass("dainvisible");
        $(controlButton).removeClass("dainvisible");
        $(stopControllingButton).addClass("dainvisible");
      }
    }
  }
  $(theText).appendTo($(sessionDiv));
  if (
    obj.chatstatus == "on" &&
    key in daChatPartners &&
    $("#chatarea" + skey).hasClass("dainvisible")
  ) {
    daActivateChatArea(key);
  }
  if (
    (obj.chatstatus != "on" || !(key in daChatPartners)) &&
    $("#chatarea" + skey)
      .find("button")
      .first()
      .prop("disabled") == false
  ) {
    daDeActivateChatArea(key);
  } else if (obj.blocked) {
    daDeActivateChatArea(key);
  }
}
function daOnScrollResize() {
  if (document.title != daBrowserTitle) {
    document.title = daBrowserTitle;
    daFaviconRegular();
  }
  if (!daShowingNotif) {
    return true;
  }
  var obj = Array();
  for (var key in daUpdatedSessions) {
    if (daUpdatedSessions.hasOwnProperty(key)) {
      obj.push(key);
    }
  }
  var somethingAbove = false;
  var somethingBelow = false;
  var firstElement = -1;
  var lastElement = -1;
  for (var i = 0; i < obj.length; ++i) {
    var result = daIsHidden(obj[i]);
    if (result == 0) {
      delete daUpdatedSessions[obj[i]];
    } else if (result < 0) {
      var top = $(obj[i]).offset().top;
      somethingAbove = true;
      if (firstElement == -1 || top < firstElement) {
        firstElement = top;
      }
    } else if (result > 0) {
      var top = $(obj[i]).offset().top;
      somethingBelow = true;
      if (lastElement == -1 || top > lastElement) {
        lastElement = top;
      }
    }
  }
  if ($("#chat-message-above").is(":visible") && !somethingAbove) {
    $("#chat-message-above").hide();
  }
  if ($("#chat-message-below").is(":visible") && !somethingBelow) {
    $("#chat-message-below").hide();
  }
  if (!(somethingAbove || somethingBelow)) {
    daShowingNotif = false;
  }
  return true;
}
function daReadyFunction() {
  //console.log("document ready");
  try {
    window.AudioContext = window.AudioContext || window.webkitAudioContext;
    daAudioContext = new AudioContext();
  } catch (e) {
    console.log("Web Audio API is not supported in this browser");
  }
  daLoadSoundBuffer(
    "newmessage",
    daNotificationClickOnMp3,
    daNotificationClickOnOgg,
  );
  daLoadSoundBuffer(
    "newconversation",
    daNotificationStaplerMp3,
    daNotificationStaplerOgg,
  );
  daLoadSoundBuffer("signinout", daNotificationSnapMp3, daNotificationSnapOgg);
  if (location.protocol === "http:" || document.location.protocol === "http:") {
    daSocket = io.connect("http://" + document.domain + "/monitor", {
      path: daRootUrl + "ws/socket.io",
    });
  }
  if (
    location.protocol === "https:" ||
    document.location.protocol === "https:"
  ) {
    daSocket = io.connect("https://" + document.domain + "/monitor", {
      path: daRootUrl + "ws/socket.io",
    });
  }
  //console.log("socket is " + daSocket)
  if (typeof daSocket !== "undefined") {
    daSocket.on("connect", function () {
      //console.log("Connected!");
      daUpdateMonitor();
    });
    daSocket.on("terminate", function () {
      console.log("monitor: terminating socket");
      daSocket.disconnect();
    });
    daSocket.on("disconnect", function () {
      //console.log("monitor: disconnected socket");
      //daSocket = null;
    });
    daSocket.on("refreshsessions", function (data) {
      daUpdateMonitor();
    });
    // daSocket.on('abortcontroller', function(data) {
    //     console.log("Got abortcontroller message for " + data.key);
    // });
    daSocket.on("chatready", function (data) {
      var key =
        "da:session:uid:" +
        data.uid +
        ":i:" +
        data.i +
        ":userid:" +
        data.userid;
      //console.log('chatready: ' + key);
      daActivateChatArea(key);
      daNotifyOperator(key, "chatready", daNewChatConnection + " " + data.name);
    });
    daSocket.on("chatstop", function (data) {
      var key =
        "da:session:uid:" +
        data.uid +
        ":i:" +
        data.i +
        ":userid:" +
        data.userid;
      //console.log('chatstop: ' + key);
      if (key in daChatPartners) {
        delete daChatPartners[key];
      }
      daDeActivateChatArea(key);
    });
    daSocket.on("chat_log", function (arg) {
      //console.log('chat_log: ' + arg.userid);
      daPublishChatLog(
        arg.uid,
        arg.i,
        arg.userid,
        arg.mode,
        arg.data,
        arg.scroll,
      );
    });
    daSocket.on("block", function (arg) {
      //console.log("back from blocking " + arg.key);
      daUpdateMonitor();
    });
    daSocket.on("unblock", function (arg) {
      //console.log("back from unblocking " + arg.key);
      daUpdateMonitor();
    });
    daSocket.on("chatmessage", function (data) {
      //console.log("chatmessage");
      var keys;
      if (data.data.mode == "peer" || data.data.mode == "peerhelp") {
        keys = daAllSessions(data.uid, data.i);
      } else {
        keys = [
          "da:session:uid:" +
            data.uid +
            ":i:" +
            data.i +
            ":userid:" +
            data.userid,
        ];
      }
      for (var i = 0; i < keys.length; ++i) {
        key = keys[i];
        var skey = key.replace(/(:|\.|\[|\]|,|=|\/)/g, "\\$1");
        //console.log("Received chat message for #chatarea" + skey);
        var chatArea = $("#chatarea" + skey)
          .find("ul")
          .first();
        var newLi = document.createElement("li");
        $(newLi).addClass("list-group-item");
        if (data.data.is_self) {
          $(newLi).addClass("list-group-item-primary dalistright");
        } else {
          $(newLi).addClass("list-group-item-secondary dalistleft");
        }
        $(newLi).html(data.data.message);
        $(newLi).appendTo(chatArea);
        daScrollChat("#chatarea" + skey);
        if (data.data.is_self) {
          $("#listelement" + skey).removeClass("da-new-message");
          if (document.title != daBrowserTitle) {
            document.title = daBrowserTitle;
            daFaviconRegular();
          }
        } else {
          if (
            !$("#chatarea" + skey)
              .find("input")
              .first()
              .is(":focus")
          ) {
            $("#listelement" + skey).addClass("da-new-message");
            if (daBrowserTitle == document.title) {
              document.title = "* " + daBrowserTitle;
              daFaviconAlert();
            }
          }
          if (data.data.hasOwnProperty("temp_user_id")) {
            daNotifyOperator(
              key,
              "chat",
              daAnonymousVisitor +
                " " +
                data.data.temp_user_id +
                ": " +
                data.data.message,
            );
          } else {
            if (data.data.first_name && data.data.first_name != "") {
              daNotifyOperator(
                key,
                "chat",
                data.data.first_name +
                  " " +
                  data.data.last_name +
                  ": " +
                  data.data.message,
              );
            } else {
              daNotifyOperator(
                key,
                "chat",
                data.data.email + ": " + data.data.message,
              );
            }
          }
        }
      }
    });
    daSocket.on("sessionupdate", function (data) {
      //console.log("Got session update: " + data.session.chatstatus);
      daDrawSession(data.key, data.session);
      daCheckIfEmpty();
    });
    daSocket.on("updatemonitor", function (data) {
      //console.log("Got update monitor response");
      //console.log("updatemonitor: chat partners are: " + data.chatPartners);
      daChatPartners = data.chatPartners;
      daNewPhonePartners = Object();
      daTermPhonePartners = Object();
      daPhonePartners = data.phonePartners;
      var newSubscribedRoles = Object();
      for (var key in data.subscribedRoles) {
        if (data.subscribedRoles.hasOwnProperty(key)) {
          newSubscribedRoles[key] = 1;
        }
      }
      for (var i = 0; i < data.availRoles.length; ++i) {
        var key = data.availRoles[i];
        var skey = key.replace(/(:|\.|\[|\]|,|=|\/| )/g, "\\$1");
        if ($("#role" + skey).length == 0) {
          var div = document.createElement("div");
          $(div).addClass("form-check form-check-inline");
          var label = document.createElement("label");
          $(label).addClass("form-check-label");
          $(label).attr("for", "role" + key);
          var input = document.createElement("input");
          $(input).addClass("form-check-input");
          var text = document.createTextNode(key);
          $(input).attr("type", "checkbox");
          $(input).attr("id", "role" + key);
          if (key in newSubscribedRoles) {
            $(input).prop("checked", true);
          } else {
            $(input).prop("checked", false);
          }
          $(input).val(key);
          $(text).appendTo($(label));
          $(input).appendTo($(div));
          $(label).appendTo($(div));
          $(div).appendTo($("#monitorroles"));
          $(input).change(function () {
            var key = $(this).val();
            //console.log("change to " + key);
            if ($(this).is(":checked")) {
              //console.log("it is checked");
              daSubscribedRoles[key] = 1;
            } else {
              //console.log("it is not checked");
              if (key in daSubscribedRoles) {
                delete daSubscribedRoles[key];
              }
            }
            daUpdateMonitor();
          });
        } else {
          var input = $("#role" + skey).first();
          if (key in newSubscribedRoles) {
            $(input).prop("checked", true);
          } else {
            $(input).prop("checked", false);
          }
        }
      }
      daSubscribedRoles = newSubscribedRoles;
      newDaSessions = Object();
      for (var key in data.sessions) {
        if (data.sessions.hasOwnProperty(key)) {
          var user_id = key.replace(/^.*:userid:/, "");
          if (true || user_id != daUserid) {
            var obj = data.sessions[key];
            newDaSessions[key] = obj;
            daDrawSession(key, obj);
          }
        }
      }
      var toDelete = Array();
      var numSessions = 0;
      for (var key in daSessions) {
        if (daSessions.hasOwnProperty(key)) {
          numSessions++;
          if (!(key in newDaSessions)) {
            toDelete.push(key);
          }
        }
      }
      for (var i = 0; i < toDelete.length; ++i) {
        var key = toDelete[i];
        daUndrawSession(key);
      }
      if ($("#monitorsessions").find("li").length > 0) {
        $("#emptylist").addClass("dainvisible");
      } else {
        $("#emptylist").removeClass("dainvisible");
      }
    });
  }
  if (daAvailableForChat) {
    $("#daNotAvailable").addClass("dainvisible");
    daCheckNotifications();
  } else {
    $("#daAvailable").addClass("dainvisible");
  }
  $("#daAvailable").click(function (event) {
    $("#daAvailable").addClass("dainvisible");
    $("#daNotAvailable").removeClass("dainvisible");
    daAvailableForChat = false;
    //console.log("daAvailableForChat: " + daAvailableForChat);
    daUpdateMonitor();
    daPlaySound("signinout");
  });
  $("#daNotAvailable").click(function (event) {
    daCheckNotifications();
    $("#daNotAvailable").addClass("dainvisible");
    $("#daAvailable").removeClass("dainvisible");
    daAvailableForChat = true;
    //console.log("daAvailableForChat: " + daAvailableForChat);
    daUpdateMonitor();
    daPlaySound("signinout");
  });
  $(window).bind("unload", function () {
    if (typeof daSocket !== "undefined") {
      daSocket.emit("terminate");
    }
  });
  if (daUsePhone) {
    $("#daPhoneInfo").removeClass("dainvisible");
    $("#daPhoneNumber").val(daPhoneNumber);
    $("#daPhoneNumber").change(daCheckPhone);
    $("#daPhoneNumber").bind("keypress keydown keyup", function (e) {
      var theCode = e.which || e.keyCode;
      if (theCode == 13) {
        $(this).blur();
        e.preventDefault();
      }
    });
  }
  $(window).on("scroll", daOnScrollResize);
  $(window).on("resize", daOnScrollResize);
  $(".da-chat-notifier").click(function (e) {
    //var key = $(this).data('key');
    var direction = 0;
    if ($(this).attr("id") == "chat-message-above") {
      direction = -1;
    } else {
      direction = 1;
    }
    var target = -1;
    var targetElement = null;
    for (var key in daUpdatedSessions) {
      if (daUpdatedSessions.hasOwnProperty(key)) {
        var top = $(key).offset().top;
        if (direction == -1) {
          if (target == -1 || top < target) {
            target = top;
            targetElement = key;
          }
        } else {
          if (target == -1 || top > target) {
            target = top;
            targetElement = key;
          }
        }
      }
    }
    if (target >= 0) {
      $("html, body").animate({ scrollTop: target - 60 }, 500, function () {
        $(targetElement).find("input").first().focus();
      });
    }
    e.preventDefault();
    return false;
  });
}
