/*!
 * bootstrap-fileinput v5.1.3
 * http://plugins.krajee.com/file-input
 *
 * Author: Kartik Visweswaran
 * Copyright: 2014 - 2020, Kartik Visweswaran, Krajee.com
 *
 * Licensed under the BSD-3-Clause
 * https://github.com/kartik-v/bootstrap-fileinput/blob/master/LICENSE.md
 */(function(e){"use strict";typeof define=="function"&&define.amd?define(["jquery"],e):typeof module=="object"&&module.exports?module.exports=e(require("jquery")):e(window.jQuery)})(function(e){"use strict";e.fn.fileinputLocales={},e.fn.fileinputThemes={},String.prototype.setTokens=function(e){var t,s,n=this.toString();for(t in e)e.hasOwnProperty(t)&&(s=new RegExp("{"+t+"}","g"),n=n.replace(s,e[t]));return n},Array.prototype.flatMap||(Array.prototype.flatMap=function(e){return[].concat(this.map(e))}),t={FRAMES:".kv-preview-thumb",SORT_CSS:"file-sortable",INIT_FLAG:"init-",OBJECT_PARAMS:`<param name="controller" value="true" />
<param name="allowFullScreen" value="true" />
<param name="allowScriptAccess" value="always" />
<param name="autoPlay" value="false" />
<param name="autoStart" value="false" />
<param name="quality" value="high" />
`,DEFAULT_PREVIEW:`<div class="file-preview-other">
<span class="{previewFileIconClass}">{previewFileIcon}</span>
</div>`,MODAL_ID:"kvFileinputModal",MODAL_EVENTS:["show","shown","hide","hidden","loaded"],logMessages:{ajaxError:"{status}: {error}. Error Details: {text}.",badDroppedFiles:"Error scanning dropped files!",badExifParser:"Error loading the piexif.js library. {details}",badInputType:'The input "type" must be set to "file" for initializing the "bootstrap-fileinput" plugin.',exifWarning:'To avoid this warning, either set "autoOrientImage" to "false" OR ensure you have loaded the "piexif.js" library correctly on your page before the "fileinput.js" script.',invalidChunkSize:'Invalid upload chunk size: "{chunkSize}". Resumable uploads are disabled.',invalidThumb:'Invalid thumb frame with id: "{id}".',noResumableSupport:"The browser does not support resumable or chunk uploads.",noUploadUrl:'The "uploadUrl" is not set. Ajax uploads and resumable uploads have been disabled.',retryStatus:"Retrying upload for chunk # {chunk} for {filename}... retry # {retry}.",chunkQueueError:"Could not push task to ajax pool for chunk index # {index}.",resumableMaxRetriesReached:"Maximum resumable ajax retries ({n}) reached.",resumableRetryError:"Could not retry the resumable request (try # {n})... aborting.",resumableAborting:"Aborting / cancelling the resumable request."},objUrl:window.URL||window.webkitURL,now:function(){return(new Date).getTime()},round:function(e){return e=parseFloat(e),isNaN(e)?0:Math.floor(Math.round(e))},getArray:function(e){var t,n=[],s=e&&e.length||0;for(t=0;t<s;t++)n.push(e[t]);return n},getFileRelativePath:function(e){return String(e.newPath||e.relativePath||e.webkitRelativePath||t.getFileName(e)||null)},getFileId:function(e,n){var s=t.getFileRelativePath(e);return typeof n=="function"?n(e):e?s?e.size+"_"+encodeURIComponent(s).replace(/%/g,"_"):null:null},getFrameSelector:function(e,t){return t=t||"",'[id="'+e+'"]'+t},getZoomSelector:function(e,n){return t.getFrameSelector("zoom-"+e,n)},getFrameElement:function(e,n,s){return e.find(t.getFrameSelector(n,s))},getZoomElement:function(e,n,s){return e.find(t.getZoomSelector(n,s))},getElapsed:function(n){var a=n,s="",o={},i={year:31536e3,month:2592e3,week:604800,day:86400,hour:3600,minute:60,second:1};return t.getObjectKeys(i).forEach(function(e){o[e]=Math.floor(a/i[e]),a-=o[e]*i[e]}),e.each(o,function(e,t){t>0&&(s+=(s?" ":"")+t+e.substring(0,1))}),s},debounce:function(e,t){var n;return function(){var s=arguments,o=this;clearTimeout(n),n=setTimeout(function(){e.apply(o,s)},t)}},stopEvent:function(e){e.stopPropagation(),e.preventDefault()},getFileName:function(e){return e?e.fileName||e.name||"":""},createObjectURL:function(e){return t.objUrl&&t.objUrl.createObjectURL&&e?t.objUrl.createObjectURL(e):""},revokeObjectURL:function(e){t.objUrl&&t.objUrl.revokeObjectURL&&e&&t.objUrl.revokeObjectURL(e)},compare:function(e,t,n){return e!==void 0&&(n?e===t:e.match(t))},isIE:function(e){var t,n;return navigator.appName==="Microsoft Internet Explorer"&&(e===10?new RegExp("msie\\s"+e,"i").test(navigator.userAgent):(t=document.createElement("div"),t.innerHTML="<!--[if IE "+e+"]> <i></i> <![endif]-->",n=t.getElementsByTagName("i").length,document.body.appendChild(t),t.parentNode.removeChild(t),n))},canOrientImage:function(t){var n=e(document.createElement("img")).css({width:"1px",height:"1px"}).insertAfter(t),s=n.css("image-orientation");return n.remove(),!!s},canAssignFilesToInput:function(){var e=document.createElement("input");try{return e.type="file",e.files=null,!0}catch{return!1}},getDragDropFolders:function(e){var t,n,s=e?e.length:0,o=0;if(s>0&&e[0].webkitGetAsEntry())for(t=0;t<s;t++)n=e[t].webkitGetAsEntry(),n&&n.isDirectory&&o++;return o},initModal:function(t){var n=e("body");n.length&&t.appendTo(n)},isFunction:function(e){return typeof e=="function"},isEmpty:function(n,s){return n==null||!t.isFunction(n)&&(n.length===0||s&&e.trim(n)==="")},isArray:function(e){return Array.isArray(e)||Object.prototype.toString.call(e)==="[object Array]"},ifSet:function(e,t,n){return n=n||"",t&&typeof t=="object"&&e in t?t[e]:n},cleanArray:function(e){return e instanceof Array||(e=[]),e.filter(function(e){return e!=null})},spliceArray:function(t,n,s){var o,i,r=0,a=[];if(!(t instanceof Array))return[];i=e.extend(!0,[],t),s&&i.reverse();for(o=0;o<i.length;o++)o!==n&&(a[r]=i[o],r++);return s&&a.reverse(),a},getNum:function(e,t){return t=t||0,typeof e=="number"?e:(typeof e=="string"&&(e=parseFloat(e)),isNaN(e)?t:e)},hasFileAPISupport:function(){return!!(window.File&&window.FileReader)},hasDragDropSupport:function(){var e=document.createElement("div");return!t.isIE(9)&&(e.draggable!==void 0||e.ondragstart!==void 0&&e.ondrop!==void 0)},hasFileUploadSupport:function(){return t.hasFileAPISupport()&&window.FormData},hasBlobSupport:function(){try{return!!window.Blob&&Boolean(new Blob)}catch{return!1}},hasArrayBufferViewSupport:function(){try{return new Blob([new Uint8Array(100)]).size===100}catch{return!1}},hasResumableUploadSupport:function(){return t.hasFileUploadSupport()&&t.hasBlobSupport()&&t.hasArrayBufferViewSupport()&&(!!Blob.prototype.webkitSlice||!!Blob.prototype.mozSlice||!!Blob.prototype.slice||!1)},dataURI2Blob:function(e){var n,s,o,i,a,r,c=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,l=t.hasBlobSupport(),d=(l||c)&&window.atob&&window.ArrayBuffer&&window.Uint8Array;if(!d)return null;e.split(",")[0].indexOf("base64")>=0?n=atob(e.split(",")[1]):n=decodeURIComponent(e.split(",")[1]),o=new ArrayBuffer(n.length),i=new Uint8Array(o);for(s=0;s<n.length;s+=1)i[s]=n.charCodeAt(s);return a=e.split(",")[0].split(":")[1].split(";")[0],l?new Blob([t.hasArrayBufferViewSupport()?i:o],{type:a}):(r=new c,r.append(o),r.getBlob(a))},arrayBuffer2String:function(e){if(window.TextDecoder)return new TextDecoder("utf-8").decode(e);for(var s,i,a,t=Array.prototype.slice.apply(new Uint8Array(e)),o="",n=0,r=t.length;n<r;)switch(s=t[n++],s>>4){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:o+=String.fromCharCode(s);break;case 12:case 13:i=t[n++],o+=String.fromCharCode((s&31)<<6|i&63);break;case 14:i=t[n++],a=t[n++],o+=String.fromCharCode((s&15)<<12|(i&63)<<6|(a&63)<<0);break}return o},isHtml:function(e){t=document.createElement("div"),t.innerHTML=e;for(var t,n=t.childNodes,s=n.length;s--;)if(n[s].nodeType===1)return!0;return!1},isSvg:function(e){return e.match(/^\s*<\?xml/i)&&(e.match(/<!DOCTYPE svg/i)||e.match(/<svg/i))},getMimeType:function(e,t,n){switch(e){case"ffd8ffe0":case"ffd8ffe1":case"ffd8ffe2":return"image/jpeg";case"89504e47":return"image/png";case"47494638":return"image/gif";case"49492a00":return"image/tiff";case"52494646":return"image/webp";case"66747970":return"video/3gp";case"4f676753":return"video/ogg";case"1a45dfa3":return"video/mkv";case"000001ba":case"000001b3":return"video/mpeg";case"3026b275":return"video/wmv";case"25504446":return"application/pdf";case"25215053":return"application/ps";case"504b0304":case"504b0506":case"504b0508":return"application/zip";case"377abcaf":return"application/7z";case"75737461":return"application/tar";case"7801730d":return"application/dmg";default:switch(e.substring(0,6)){case"435753":return"application/x-shockwave-flash";case"494433":return"audio/mp3";case"425a68":return"application/bzip";default:switch(e.substring(0,4)){case"424d":return"image/bmp";case"fffb":return"audio/mp3";case"4d5a":return"application/exe";case"1f9d":case"1fa0":return"application/zip";case"1f8b":return"application/gzip";default:return t&&!t.match(/[^\u0000-\u007f]/)?"application/text-plain":n}}}},addCss:function(e,t){e.removeClass(t).addClass(t)},getElement:function(n,s,o){return t.isEmpty(n)||t.isEmpty(n[s])?o:e(n[s])},createElement:function(t,n){return n=n||"div",e(e.parseHTML("<"+n+">"+t+"</"+n+">"))},uniqId:function(){return((new Date).getTime()+Math.floor(Math.random()*Math.pow(10,15))).toString(36)},cspBuffer:{CSP_ATTRIB:"data-csp-01928735",domElementsStyles:{},stash:function(n){var a,o=this,s=e.parseHTML("<div>"+n+"</div>"),i=e(s);return i.find("[style]").each(function(n,s){var a=e(s),i=a.attr("style"),r=t.uniqId(),c={};i&&i.length&&(i.indexOf(";")===-1&&(i+=";"),i.slice(0,i.length-1).split(";").map(function(e){e=e.split(":"),e[0]&&(c[e[0]]=e[1]?e[1]:"")}),o.domElementsStyles[r]=c,a.removeAttr("style").attr(o.CSP_ATTRIB,r))}),i.filter("*").removeAttr("style"),a=Object.values?Object.values(s):Object.keys(s).map(function(e){return s[e]}),a.flatMap(function(e){return e.innerHTML}).join("")},apply:function(t){var n=this,s=e(t);s.find("["+n.CSP_ATTRIB+"]").each(function(t,s){var o=e(s),a=o.attr(n.CSP_ATTRIB),i=n.domElementsStyles[a];i&&o.css(i),o.removeAttr(n.CSP_ATTRIB)}),n.domElementsStyles={}}},setHtml:function(e,n){var s=t.cspBuffer;return e.html(s.stash(n)),s.apply(e),e},htmlEncode:function(e,t){return e===void 0?t||null:e.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&apos;")},replaceTags:function(t,n){var s=t;return n?(e.each(n,function(e,t){typeof t=="function"&&(t=t()),s=s.split(e).join(t)}),s):s},cleanMemory:function(e){var n=e.is("img")?e.attr("src"):e.find("source").attr("src");t.revokeObjectURL(n)},findFileName:function(e){var t=e.lastIndexOf("/");return t===-1&&(t=e.lastIndexOf("\\")),e.split(e.substring(t,t+1)).pop()},checkFullScreen:function(){return document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement},toggleFullScreen:function(e){var n=document,s=n.documentElement,o=t.checkFullScreen();s&&e&&!o?s.requestFullscreen?s.requestFullscreen():s.msRequestFullscreen?s.msRequestFullscreen():s.mozRequestFullScreen?s.mozRequestFullScreen():s.webkitRequestFullscreen&&s.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT):o&&(n.exitFullscreen?n.exitFullscreen():n.msExitFullscreen?n.msExitFullscreen():n.mozCancelFullScreen?n.mozCancelFullScreen():n.webkitExitFullscreen&&n.webkitExitFullscreen())},moveArray:function(t,n,s,o){var a,i=e.extend(!0,[],t);if(o&&i.reverse(),s>=i.length)for(a=s-i.length;a--+1;)i.push(void 0);return i.splice(s,0,i.splice(n,1)[0]),o&&i.reverse(),i},closeButton:function(e){return e=e?"btn-close "+e:"btn-close",'<button type="button" class="'+e+'" aria-label="Close"></button>'},getRotation:function(e){switch(e){case 2:return"rotateY(180deg)";case 3:return"rotate(180deg)";case 4:return"rotate(180deg) rotateY(180deg)";case 5:return"rotate(270deg) rotateY(180deg)";case 6:return"rotate(90deg)";case 7:return"rotate(90deg) rotateY(180deg)";case 8:return"rotate(270deg)";default:return""}},setTransform:function(e,t){if(!e)return;e.style.transform=t,e.style.webkitTransform=t,e.style["-moz-transform"]=t,e.style["-ms-transform"]=t,e.style["-o-transform"]=t},getObjectKeys:function(t){var n=[];return t&&e.each(t,function(e){n.push(e)}),n},getObjectSize:function(e){return t.getObjectKeys(e).length},whenAll:function(n){var s,a,l,h,d=[].slice,o=arguments.length===1&&t.isArray(n)?n:d.call(arguments),i=e.Deferred(),u=0,r=o.length,c=r,f=h=l=Array(r),m=function(e,t,n){return function(){n!==o&&u++,i.notifyWith(t[e]=this,n[e]=d.call(arguments)),--c||i[(u?"reject":"resolve")+"With"](t,n)}};for(s=0;s<r;s++)(a=o[s])&&e.isFunction(a.promise)?a.promise().done(m(s,l,o)).fail(m(s,f,h)):(i.notifyWith(this,a),--c);return c||i.resolveWith(l,o),i.promise()}},n=function(n,s){var o=this;if(o.$element=e(n),o.$parent=o.$element.parent(),!o._validate())return;o.isPreviewable=t.hasFileAPISupport(),o.isIE9=t.isIE(9),o.isIE10=t.isIE(10),(o.isPreviewable||o.isIE9)&&(o._init(s),o._listen()),o.$element.removeClass("file-loading")},n.prototype={constructor:n,_cleanup:function(){var e=this;e.reader=null,e.clearFileStack(),e.fileBatchCompleted=!0,e.isError=!1,e.isDuplicateError=!1,e.isPersistentError=!1,e.cancelling=!1,e.paused=!1,e.lastProgress=0,e._initAjax()},_isAborted:function(){var e=this;return e.cancelling||e.paused},_initAjax:function(){var s=this,n=s.taskManager={pool:{},addPool:function(e){return n.pool[e]=new n.TasksPool(e)},getPool:function(e){return n.pool[e]},addTask:function(e,t){return new n.Task(e,t)},TasksPool:function(s){var o=this;o.id=s,o.cancelled=!1,o.cancelledDeferrer=e.Deferred(),o.tasks={},o.addTask=function(e,t){return o.tasks[e]=new n.Task(e,t)},o.size=function(){return t.getObjectSize(o.tasks)},o.run=function(n){var i,c,l,u,h=0,d=!1,r=t.getObjectKeys(o.tasks).map(function(e){return o.tasks[e]}),a=[],s=e.Deferred();if(o.cancelled)return o.cancelledDeferrer.resolve(),s.reject();if(!n)return u=t.getObjectKeys(o.tasks).map(function(e){return o.tasks[e].deferred}),t.whenAll(u).done(function(){var e=t.getArray(arguments);o.cancelled?(s.reject.apply(null,e),o.cancelledDeferrer.resolve()):(s.resolve.apply(null,e),o.cancelledDeferrer.reject())}).fail(function(){var e=t.getArray(arguments);s.reject.apply(null,e),o.cancelled?o.cancelledDeferrer.resolve():o.cancelledDeferrer.reject()}),e.each(o.tasks,function(e){i=o.tasks[e],i.run()}),s;for(c=function(t){e.when(t.deferred).fail(function(){d=!0,l.apply(null,arguments)}).always(l)},l=function(){var e=t.getArray(arguments);if(s.notify(e),a.push(e),o.cancelled){s.reject.apply(null,a),o.cancelledDeferrer.resolve();return}a.length===o.size()&&(d?s.reject.apply(null,a):s.resolve.apply(null,a)),r.length&&(i=r.shift(),c(i),i.run())};r.length&&h++<n;)i=r.shift(),c(i),i.run();return s},o.cancel=function(){return o.cancelled=!0,o.cancelledDeferrer}},Task:function(n,s){var o=this;o.id=n,o.deferred=e.Deferred(),o.logic=s,o.context=null,o.run=function(){var e=t.getArray(arguments);return e.unshift(o.deferred),s.apply(o.context,e),o.deferred},o.runWithContext=function(e){return o.context=e,o.run()}}};s.ajaxQueue=[],s.ajaxRequests=[],s.ajaxAborted=!1},_init:function(n,s){var a,r,c,l,d,o=this,i=o.$element;o.options=n,o.canOrientImage=t.canOrientImage(i),e.each(n,function(e,n){switch(e){case"minFileCount":case"maxFileCount":case"maxTotalFileCount":case"minFileSize":case"maxFileSize":case"maxFilePreviewSize":case"resizeImageQuality":case"resizeIfSizeMoreThan":case"progressUploadThreshold":case"initialPreviewCount":case"zoomModalHeight":case"minImageHeight":case"maxImageHeight":case"minImageWidth":case"maxImageWidth":o[e]=t.getNum(n);break;default:o[e]=n;break}}),o.maxTotalFileCount>0&&o.maxTotalFileCount<o.maxFileCount&&(o.maxTotalFileCount=o.maxFileCount),o.rtl&&(d=o.previewZoomButtonIcons.prev,o.previewZoomButtonIcons.prev=o.previewZoomButtonIcons.next,o.previewZoomButtonIcons.next=d),!isNaN(o.maxAjaxThreads)&&o.maxAjaxThreads<o.resumableUploadOptions.maxThreads&&(o.resumableUploadOptions.maxThreads=o.maxAjaxThreads),o._initFileManager(),typeof o.autoOrientImage=="function"&&(o.autoOrientImage=o.autoOrientImage()),typeof o.autoOrientImageInitial=="function"&&(o.autoOrientImageInitial=o.autoOrientImageInitial()),s||o._cleanup(),o.duplicateErrors=[],o.$form=i.closest("form"),o._initTemplateDefaults(),o.uploadFileAttr=t.isEmpty(i.attr("name"))?"file_data":i.attr("name"),r=o._getLayoutTemplate("progress"),o.progressTemplate=r.replace("{class}",o.progressClass),o.progressInfoTemplate=r.replace("{class}",o.progressInfoClass),o.progressPauseTemplate=r.replace("{class}",o.progressPauseClass),o.progressCompleteTemplate=r.replace("{class}",o.progressCompleteClass),o.progressErrorTemplate=r.replace("{class}",o.progressErrorClass),o.isDisabled=i.attr("disabled")||i.attr("readonly"),o.isDisabled&&i.attr("disabled",!0),o.isClickable=o.browseOnZoneClick&&o.showPreview&&(o.dropZoneEnabled||!t.isEmpty(o.defaultPreviewContent)),o.isAjaxUpload=t.hasFileUploadSupport()&&!t.isEmpty(o.uploadUrl),o.dropZoneEnabled=t.hasDragDropSupport()&&o.dropZoneEnabled,o.isAjaxUpload||(o.dropZoneEnabled=o.dropZoneEnabled&&t.canAssignFilesToInput()),o.slug=typeof n.slugCallback=="function"?n.slugCallback:o._slugDefault,o.mainTemplate=o.showCaption?o._getLayoutTemplate("main1"):o._getLayoutTemplate("main2"),o.captionTemplate=o._getLayoutTemplate("caption"),o.previewGenericTemplate=o._getPreviewTemplate("generic"),!o.imageCanvas&&o.resizeImage&&(o.maxImageWidth||o.maxImageHeight)&&(o.imageCanvas=document.createElement("canvas"),o.imageCanvasContext=o.imageCanvas.getContext("2d")),t.isEmpty(i.attr("id"))&&i.attr("id",t.uniqId()),o.namespace=".fileinput_"+i.attr("id").replace(/-/g,"_"),o.$container===void 0?o.$container=o._createContainer():o._refreshContainer(),a=o.$container,o.$dropZone=a.find(".file-drop-zone"),o.$progress=a.find(".kv-upload-progress"),o.$btnUpload=a.find(".fileinput-upload"),o.$captionContainer=t.getElement(n,"elCaptionContainer",a.find(".file-caption")),o.$caption=t.getElement(n,"elCaptionText",a.find(".file-caption-name")),o.$captionLabel=t.getElement(n,"elCaptionLabelText",a.find(".file-caption-label")),t.isEmpty(o.msgPlaceholder)||(l=i.attr("multiple")?o.filePlural:o.fileSingle,o.$caption.attr("placeholder",o.msgPlaceholder.replace("{files}",l))),o.$caption.attr("id","fileinput-"+i.attr("id")),c=document.querySelector('label[for="'+i.attr("id")+'"]'),c!==null&&o.$captionLabel.html(c.innerHTML),o.$captionLabel.attr("for","fileinput-"+i.attr("id")),o.$captionIcon=o.$captionContainer.find(".file-caption-icon"),o.$previewContainer=t.getElement(n,"elPreviewContainer",a.find(".file-preview")),o.$preview=t.getElement(n,"elPreviewImage",a.find(".file-preview-thumbnails")),o.$previewStatus=t.getElement(n,"elPreviewStatus",a.find(".file-preview-status")),o.$errorContainer=t.getElement(n,"elErrorContainer",o.$previewContainer.find(".kv-fileinput-error")),o._validateDisabled(),t.isEmpty(o.msgErrorClass)||t.addCss(o.$errorContainer,o.msgErrorClass),s?o._errorsExist()||o.$errorContainer.hide():(o._resetErrors(),o.$errorContainer.hide(),o.previewInitId="thumb-"+i.attr("id"),o._initPreviewCache(),o._initPreview(!0),o._initPreviewActions(),o.$parent.hasClass("file-loading")&&(o.$container.insertBefore(o.$parent),o.$parent.remove())),o._setFileDropZoneTitle(),i.attr("disabled")&&o.disable(),o._initZoom(),o.hideThumbnailContent&&t.addCss(o.$preview,"hide-content")},_initFileManager:function(){var n=this;n.uploadStartTime=t.now(),n.fileManager={stack:{},filesProcessed:[],errors:[],loadedImages:{},totalImages:0,totalFiles:null,totalSize:null,uploadedSize:0,stats:{},initStats:function(e){var s={started:t.now()};e?n.fileManager.stats[e]=s:n.fileManager.stats=s},getUploadStats:function(e,s,o){var i=n.fileManager,c=e?i.stats[e]&&i.stats[e].started||t.now():n.uploadStartTime,a=(t.now()-c)/1e3,d=["B/s","KB/s","MB/s","GB/s","TB/s","PB/s","EB/s","ZB/s","YB/s"],l=a?s/a:0,u=n._getSize(l,d),h=o-s,r={fileId:e,started:c,elapsed:a,loaded:s,total:o,bps:l,bitrate:u,pendingBytes:h};return e?i.stats[e]=r:i.stats=r,r},exists:function(t){return e.inArray(t,n.fileManager.getIdList())!==-1},count:function(){return n.fileManager.getIdList().length},total:function(){var e=n.fileManager;return e.totalFiles||(e.totalFiles=e.count()),e.totalFiles},getTotalSize:function(){var t=n.fileManager;return t.totalSize?t.totalSize:(t.totalSize=0,e.each(n.fileManager.stack,function(e,n){var s=parseFloat(n.size);t.totalSize+=isNaN(s)?0:s}),t.totalSize)},add:function(e,s){if(s||(s=n.fileManager.getId(e)),!s)return;n.fileManager.stack[s]={file:e,name:t.getFileName(e),relativePath:t.getFileRelativePath(e),size:e.size,nameFmt:n._getFileName(e,""),sizeFmt:n._getSize(e.size)}},remove:function(e){var t=e.attr("data-fileid");t&&n.fileManager.removeFile(t)},removeFile:function(e){delete n.fileManager.stack[e],delete n.fileManager.loadedImages[e]},move:function(t,s){var o={},i=n.fileManager.stack;if(!t&&!s||t===s)return;e.each(i,function(e,n){e!==t&&(o[e]=n),e===s&&(o[t]=i[t])}),n.fileManager.stack=o},list:function(){var t=[];return e.each(n.fileManager.stack,function(e,n){n&&n.file&&t.push(n.file)}),t},isPending:function(t){return e.inArray(t,n.fileManager.filesProcessed)===-1&&n.fileManager.exists(t)},isProcessed:function(){var t=!0,s=n.fileManager;return e.each(s.stack,function(e){s.isPending(e)&&(t=!1)}),t},clear:function(){var e=n.fileManager;n.isDuplicateError=!1,n.isPersistentError=!1,e.totalFiles=null,e.totalSize=null,e.uploadedSize=0,e.stack={},e.errors=[],e.filesProcessed=[],e.stats={},e.clearImages()},clearImages:function(){n.fileManager.loadedImages={},n.fileManager.totalImages=0},addImage:function(e,t){n.fileManager.loadedImages[e]=t},removeImage:function(e){delete n.fileManager.loadedImages[e]},getImageIdList:function(){return t.getObjectKeys(n.fileManager.loadedImages)},getImageCount:function(){return n.fileManager.getImageIdList().length},getId:function(e){return n._getFileId(e)},getIndex:function(e){return n.fileManager.getIdList().indexOf(e)},getThumb:function(t){var s=null;return n._getThumbs().each(function(){var n=e(this);n.attr("data-fileid")===t&&(s=n)}),s},getThumbIndex:function(e){var t=e.attr("data-fileid");return n.fileManager.getIndex(t)},getIdList:function(){return t.getObjectKeys(n.fileManager.stack)},getFile:function(e){return n.fileManager.stack[e]||null},getFileName:function(e,t){var s=n.fileManager.getFile(e);return s?t?s.nameFmt||"":s.name||"":""},getFirstFile:function(){var e=n.fileManager.getIdList(),t=e&&e.length?e[0]:null;return n.fileManager.getFile(t)},setFile:function(e,t){n.fileManager.getFile(e)?n.fileManager.stack[e].file=t:n.fileManager.add(t,e)},setProcessed:function(e){n.fileManager.filesProcessed.push(e)},getProgress:function(){var e=n.fileManager.total(),t=n.fileManager.filesProcessed.length;return e?Math.ceil(t/e*100):0},setProgress:function(e,t){var s=n.fileManager.getFile(e);!isNaN(t)&&s&&(s.progress=t)}}},_setUploadData:function(n,s){var o=this;e.each(s,function(e,s){var i=o.uploadParamNames[e]||e;t.isArray(s)?n.append(i,s[0],s[1]):n.append(i,s)})},_initResumableUpload:function(){var n,s=this,i=s.resumableUploadOptions,a=t.logMessages,o=s.fileManager;if(!s.enableResumableUpload)return;if(i.fallback!==!1&&typeof i.fallback!="function"&&(i.fallback=function(e){e._log(a.noResumableSupport),e.enableResumableUpload=!1}),!t.hasResumableUploadSupport()&&i.fallback!==!1){i.fallback(s);return}if(!s.uploadUrl&&s.enableResumableUpload){s._log(a.noUploadUrl),s.enableResumableUpload=!1;return}if(i.chunkSize=parseFloat(i.chunkSize),i.chunkSize<=0||isNaN(i.chunkSize)){s._log(a.invalidChunkSize,{chunkSize:i.chunkSize}),s.enableResumableUpload=!1;return}n=s.resumableManager={init:function(e,t,a){n.logs=[],n.stack=[],n.error="",n.id=e,n.file=t.file,n.fileName=t.name,n.fileIndex=a,n.completed=!1,n.lastProgress=0,s.showPreview&&(n.$thumb=o.getThumb(e)||null,n.$progress=n.$btnDelete=null,n.$thumb&&n.$thumb.length&&(n.$progress=n.$thumb.find(".file-thumb-progress"),n.$btnDelete=n.$thumb.find(".kv-file-remove"))),n.chunkSize=i.chunkSize*1024,n.chunkCount=n.getTotalChunks()},setAjaxError:function(e,t,o,r){e.responseJSON&&e.responseJSON.error&&(o=e.responseJSON.error.toString()),r||(n.error=o),i.showErrorLog&&s._log(a.ajaxError,{status:e.status,error:o,text:e.responseText||""})},reset:function(){n.stack=[],n.chunksProcessed={}},setProcessed:function(e){var c,a=n.id,t=n.$thumb,l=n.$progress,d=t&&t.length,r={id:d?t.attr("id"):"",index:o.getIndex(a),fileId:a};n.completed=!0,n.lastProgress=0,d&&t.removeClass("file-uploading"),e==="success"?(o.uploadedSize+=n.file.size,s.showPreview&&(s._setProgress(101,l),s._setThumbStatus(t,"Success"),s._initUploadSuccess(n.chunksProcessed[a].data,t)),o.removeFile(a),delete n.chunksProcessed[a],s._raise("fileuploaded",[r.id,r.index,r.fileId]),o.isProcessed()&&s._setProgress(101)):e!=="cancel"&&(s.showPreview&&(s._setThumbStatus(t,"Error"),s._setPreviewError(t,!0),s._setProgress(101,l,s.msgProgressError),s._setProgress(101,s.$progress,s.msgProgressError),s.cancelling=!0),s.$errorContainer.find('li[data-file-id="'+r.fileId+'"]').length||(c=s.msgResumableUploadRetriesExceeded.setTokens({file:n.fileName,max:i.maxRetries,error:n.error}),s._showFileError(c,r))),o.isProcessed()&&n.reset()},check:function(){var t=!0;e.each(n.logs,function(e,n){if(!n)return t=!1,!1})},processedResumables:function(){var t,e=n.logs,s=0;if(!e||!e.length)return 0;for(t=0;t<e.length;t++)e[t]===!0&&s++;return s},getUploadedSize:function(){var e=n.processedResumables()*n.chunkSize;return e>n.file.size?n.file.size:e},getTotalChunks:function(){var e=parseFloat(n.chunkSize);return!isNaN(e)&&e>0?Math.ceil(n.file.size/e):0},getProgress:function(){var t=n.processedResumables(),e=n.chunkCount;return e===0?0:Math.ceil(t/e*100)},checkAborted:function(e){s._isAborted()&&(clearInterval(e),s.unlock())},upload:function(){var a=o.getIdList(),e="new",i=setInterval(function(){if(n.checkAborted(i),e==="new"&&(s.lock(),e="processing",r=a.shift(),o.initStats(r),o.stack[r]&&(n.init(r,o.stack[r],o.getIndex(r)),n.processUpload())),!o.isPending(r)&&n.completed&&(e="new"),o.isProcessed()){var r,c=s.$preview.find(".file-preview-initial");c.length&&(t.addCss(c,t.SORT_CSS),s._initSortable()),clearInterval(i),s._clearFileInput(),s.unlock(),setTimeout(function(){var e=s.previewCache.data;e&&(s.initialPreview=e.content,s.initialPreviewConfig=e.config,s.initialPreviewThumbTags=e.tags),s._raise("filebatchuploadcomplete",[s.initialPreview,s.initialPreviewConfig,s.initialPreviewThumbTags,s._getExtraData()])},s.processDelay)}},s.processDelay)},uploadResumable:function(){var e,o=s.taskManager,a=n.chunkCount,t=o.addPool(n.id);for(e=0;e<a;e++)n.logs[e]=!!(n.chunksProcessed[n.id]&&n.chunksProcessed[n.id][e]),n.logs[e]||n.pushAjax(e,0);t.run(i.maxThreads).done(function(){n.setProcessed("success")}).fail(function(){n.setProcessed(t.cancelled?"cancel":"error")})},processUpload:function(){var r,c,l,d,u,h,m,a=n.id;if(!i.testUrl){n.uploadResumable();return}r=new FormData,l=o.stack[a],s._setUploadData(r,{fileId:a,fileName:l.fileName,fileSize:l.size,fileRelativePath:l.relativePath,chunkSize:n.chunkSize,chunkCount:n.chunkCount}),d=function(e){c=s._getOutData(r,e),s._raise("filetestbeforesend",[a,o,n,c])},u=function(i,l,d){c=s._getOutData(r,d,i);var m=s.uploadParamNames,u=m.chunksUploaded||"chunksUploaded",h=[a,o,n,c];!i[u]||!t.isArray(i[u])?s._raise("filetesterror",h):(n.chunksProcessed[a]||(n.chunksProcessed[a]={}),e.each(i[u],function(e,t){n.logs[t]=!0,n.chunksProcessed[a][t]=!0}),n.chunksProcessed[a].data=i,s._raise("filetestsuccess",h)),n.uploadResumable()},h=function(e,t,i){c=s._getOutData(r,e),s._raise("filetestajaxerror",[a,o,n,c]),n.setAjaxError(e,t,i,!0),n.uploadResumable()},m=function(){s._raise("filetestcomplete",[a,o,n,s._getOutData(r)])},s._ajaxSubmit(d,u,m,h,r,a,n.fileIndex,i.testUrl)},pushAjax:function(e,t){var i=s.taskManager,o=i.getPool(n.id);o.addTask(o.size()+1,function(e){var o=n.stack.shift(),t=o[0];!n.chunksProcessed[n.id]||!n.chunksProcessed[n.id][t]?n.sendAjax(t,o[1],e):s._log(a.chunkQueueError,{index:t})}),n.stack.push([e,t])},sendAjax:function(e,r,c){var d,u,v,b,j,y,_,w,O,f=n.chunkSize,l=n.id,h=n.file,g=n.$thumb,p=t.logMessages,x=n.$btnDelete,m=function(e,t){t&&(e=e.setTokens(t)),e="Error processing resumable ajax request. "+e,s._log(e),c.reject(e)};if(n.chunksProcessed[l]&&n.chunksProcessed[l][e])return;if(r>i.maxRetries){m(p.resumableMaxRetriesReached,{n:i.maxRetries}),n.setProcessed("error");return}w=h.slice?"slice":h.mozSlice?"mozSlice":h.webkitSlice?"webkitSlice":"slice",O=h[w](f*e,f*(e+1)),d=new FormData,v=o.stack[l],s._setUploadData(d,{chunkCount:n.chunkCount,chunkIndex:e,chunkSize:f,chunkSizeStart:f*e,fileBlob:[O,n.fileName],fileId:l,fileName:n.fileName,fileRelativePath:v.relativePath,fileSize:h.size,retryCount:r}),n.$progress&&n.$progress.length&&n.$progress.show(),b=function(i){u=s._getOutData(d,i),s.showPreview&&(g.hasClass("file-preview-success")||(s._setThumbStatus(g,"Loading"),t.addCss(g,"file-uploading")),x.attr("disabled",!0)),s._raise("filechunkbeforesend",[l,e,r,o,n,u])},j=function(t,h,f){if(s._isAborted()){m(p.resumableAborting);return}u=s._getOutData(d,f,t);var b=s.uploadParamNames,g=b.chunkIndex||"chunkIndex",v=[l,e,r,o,n,u];t.error?(i.showErrorLog&&s._log(a.retryStatus,{retry:r+1,filename:n.fileName,chunk:e}),n.pushAjax(e,r+1),n.error=t.error,s._raise("filechunkerror",v)):(n.logs[t[g]]=!0,n.chunksProcessed[l]||(n.chunksProcessed[l]={}),n.chunksProcessed[l][t[g]]=!0,n.chunksProcessed[l].data=t,c.resolve.call(null,t),s._raise("filechunksuccess",v),n.check())},y=function(t,i,a){if(s._isAborted()){m(p.resumableAborting);return}u=s._getOutData(d,t),n.setAjaxError(t,i,a),s._raise("filechunkajaxerror",[l,e,r,o,n,u]),n.pushAjax(e,r+1),m(p.resumableRetryError,{n:r-1})},_=function(){s._isAborted()||s._raise("filechunkcomplete",[l,e,r,o,n,s._getOutData(d)])},s._ajaxSubmit(b,j,_,y,d,l,n.fileIndex)}},n.reset()},_initTemplateDefaults:function(){var n=this,o=function(e,n){return'<object class="kv-preview-data file-preview-'+e+'" title="{caption}" data="{data}" type="'+n+'"'+s+`>
`+t.DEFAULT_PREVIEW+`
</object>
`},U=`{preview}
<div class="kv-upload-progress kv-hidden"></div><div class="clearfix"></div>
<div class="input-group {class}">
  {caption}
  {remove}
  {cancel}
  {pause}
  {upload}
  {browse}
</div>`,W=`{preview}
<div class="kv-upload-progress kv-hidden"></div>
<div class="clearfix"></div>
{remove}
{cancel}
{upload}
{browse}
`,V=`<div class="file-preview {class}">
  {close}  <div class="{dropClass} clearfix">
    <div class="file-preview-thumbnails clearfix">
    </div>
    <div class="file-preview-status text-center text-success"></div>
    <div class="kv-fileinput-error"></div>
  </div>
</div>`,P=t.closeButton("fileinput-remove"),I='<i class="glyphicon glyphicon-file"></i>',x=`<div class="file-caption form-control {class}">
  <span class="file-caption-icon"></span>
  <label class="visually-hidden file-caption-label"></label>
  <input class="file-caption-name">
</div>`,m='<button type="{type}" tabindex="0" title="{title}" class="{css}" {status}>{icon} {label}</button>',A='<a href="{href}" tabindex="0" title="{title}" class="{css}" {status}>{icon} {label}</a>',u='<div tabindex="0" class="{css}" {status}>{icon} {label}</div>',a=t.MODAL_ID+"Label",h='<div id="'+t.MODAL_ID+'" class="file-zoom-dialog modal fade" tabindex="-1" aria-labelledby="'+a+'"></div>',l=`<div class="modal-dialog modal-lg{rtl}" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="`+a+`">{heading}</h5>
      <span class="kv-zoom-title"></span>
      <div class="kv-zoom-actions">{toggleheader}{fullscreen}{borderless}{close}</div>
    </div>
    <div class="modal-body">
      <div class="floating-buttons"></div>
      <div class="kv-zoom-body file-zoom-content {zoomFrameClass}"></div>
{prev} {next}
    </div>
  </div>
</div>
`,f=`<div class="progress">
    <div class="{class}" role="progressbar" aria-valuenow="{percent}" aria-valuemin="0" aria-valuemax="100" style="width:{percent}%;">
        {status}
     </div>
</div>{stats}`,$='<div class="text-info file-upload-stats"><span class="pending-time">{pendingTime}</span> <span class="upload-speed">{uploadSpeed}</span></div>',p=" <samp>({sizeText})</samp>",g=`<div class="file-thumbnail-footer">
    <div class="file-footer-caption" title="{caption}">
        <div class="file-caption-info">{caption}</div>
        <div class="file-size-info">{size}</div>
    </div>
    {progress}
{indicator}
{actions}
</div>`,v=`<div class="file-actions">
    <div class="file-footer-buttons">
        {download} {upload} {delete} {zoom} {other}    </div>
</div>
{drag}
<div class="clearfix"></div>`,b=`<button type="button" class="kv-file-remove {removeClass}" title="{removeTitle}" {dataUrl}{dataKey}>{removeIcon}</button>
`,j='<button type="button" class="kv-file-upload {uploadClass}" title="{uploadTitle}">{uploadIcon}</button>',y='<a class="kv-file-download {downloadClass}" title="{downloadTitle}" href="{downloadUrl}" download="{caption}" target="_blank">{downloadIcon}</a>',_='<button type="button" class="kv-file-zoom {zoomClass}" title="{zoomTitle}">{zoomIcon}</button>',w='<span class="file-drag-handle {dragClass}" title="{dragTitle}">{dragIcon}</span>',O='<div class="file-upload-indicator" title="{indicatorTitle}">{indicator}</div>',c='<div class="file-preview-frame {frameClass}" id="{previewId}" data-fileindex="{fileindex}" data-fileid="{fileid}" data-template="{template}"',C=c+`><div class="kv-file-content">
`,E=c+` title="{caption}"><div class="kv-file-content">
`,k=`</div>{footer}
{zoomCache}</div>
`,d=`{content}
`,s=" {style}",S=o("html","text/html"),F=o("text","text/plain;charset=UTF-8"),r=o("pdf","application/pdf"),M='<img src="{data}" class="file-preview-image kv-preview-data" title="{title}" alt="{alt}"'+s+`>
`,T='<iframe class="kv-preview-data file-preview-office" src="https://view.officeapps.live.com/op/embed.aspx?src={data}"'+s+"></iframe>",z='<iframe class="kv-preview-data file-preview-gdocs" src="https://docs.google.com/gview?url={data}&embedded=true"'+s+"></iframe>",D='<video class="kv-preview-data file-preview-video" controls'+s+`>
<source src="{data}" type="{type}">
`+t.DEFAULT_PREVIEW+`
</video>
`,N='<!--suppress ALL --><audio class="kv-preview-data file-preview-audio" controls'+s+`>
<source src="{data}" type="{type}">
`+t.DEFAULT_PREVIEW+`
</audio>
`,L='<embed class="kv-preview-data file-preview-flash" src="{data}" type="application/x-shockwave-flash"'+s+`>
`,R='<object class="kv-preview-data file-preview-object file-object {typeCss}" data="{data}" type="{type}"'+s+`>
<param name="movie" value="{caption}" />
`+t.OBJECT_PARAMS+" "+t.DEFAULT_PREVIEW+`
</object>
`,H='<div class="kv-preview-data file-preview-other-frame"'+s+`>
`+t.DEFAULT_PREVIEW+`
</div>
`,B='<div class="kv-zoom-cache">{zoomContent}</div>',i={width:"100%",height:"100%","min-height":"480px"};n._isPdfRendered()&&(r=n.pdfRendererTemplate.replace("{renderer}",n._encodeURI(n.pdfRendererUrl))),n.defaults={layoutTemplates:{main1:U,main2:W,preview:V,close:P,fileIcon:I,caption:x,modalMain:h,modal:l,progress:f,stats:$,size:p,footer:g,indicator:O,actions:v,actionDelete:b,actionUpload:j,actionDownload:y,actionZoom:_,actionDrag:w,btnDefault:m,btnLink:A,btnBrowse:u,zoomCache:B},previewMarkupTags:{tagBefore1:C,tagBefore2:E,tagAfter:k},previewContentTemplates:{generic:d,html:S,image:M,text:F,office:T,gdocs:z,video:D,audio:N,flash:L,object:R,pdf:r,other:H},allowedPreviewTypes:["image","html","text","video","audio","flash","pdf","object"],previewTemplates:{},previewSettings:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:{width:"213px",height:"160px"},text:{width:"213px",height:"160px"},office:{width:"213px",height:"160px"},gdocs:{width:"213px",height:"160px"},video:{width:"213px",height:"160px"},audio:{width:"100%",height:"30px"},flash:{width:"213px",height:"160px"},object:{width:"213px",height:"160px"},pdf:{width:"100%",height:"160px",position:"relative"},other:{width:"213px",height:"160px"}},previewSettingsSmall:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:{width:"100%",height:"160px"},text:{width:"100%",height:"160px"},office:{width:"100%",height:"160px"},gdocs:{width:"100%",height:"160px"},video:{width:"100%",height:"auto"},audio:{width:"100%",height:"30px"},flash:{width:"100%",height:"auto"},object:{width:"100%",height:"auto"},pdf:{width:"100%",height:"160px"},other:{width:"100%",height:"160px"}},previewZoomSettings:{image:{width:"auto",height:"auto","max-width":"100%","max-height":"100%"},html:i,text:i,office:{width:"100%",height:"100%","max-width":"100%","min-height":"480px"},gdocs:{width:"100%",height:"100%","max-width":"100%","min-height":"480px"},video:{width:"auto",height:"100%","max-width":"100%"},audio:{width:"100%",height:"30px"},flash:{width:"auto",height:"480px"},object:{width:"auto",height:"100%","max-width":"100%","min-height":"480px"},pdf:i,other:{width:"auto",height:"100%","min-height":"480px"}},mimeTypeAliases:{"video/quicktime":"video/mp4"},fileTypeSettings:{image:function(e,n){return t.compare(e,"image.*")&&!t.compare(e,/(tiff?|wmf)$/i)||t.compare(n,/\.(gif|png|jpe?g)$/i)},html:function(e,n){return t.compare(e,"text/html")||t.compare(n,/\.(htm|html)$/i)},office:function(e,n){return t.compare(e,/(word|excel|powerpoint|office)$/i)||t.compare(n,/\.(docx?|xlsx?|pptx?|pps|potx?)$/i)},gdocs:function(e,n){return t.compare(e,/(word|excel|powerpoint|office|iwork-pages|tiff?)$/i)||t.compare(n,/\.(docx?|xlsx?|pptx?|pps|potx?|rtf|ods|odt|pages|ai|dxf|ttf|tiff?|wmf|e?ps)$/i)},text:function(e,n){return t.compare(e,"text.*")||t.compare(n,/\.(xml|javascript)$/i)||t.compare(n,/\.(txt|md|nfo|ini|json|php|js|css)$/i)},video:function(e,n){return t.compare(e,"video.*")&&(t.compare(e,/(ogg|mp4|mp?g|mov|webm|3gp)$/i)||t.compare(n,/\.(og?|mp4|webm|mp?g|mov|3gp)$/i))},audio:function(e,n){return t.compare(e,"audio.*")&&(t.compare(n,/(ogg|mp3|mp?g|wav)$/i)||t.compare(n,/\.(og?|mp3|mp?g|wav)$/i))},flash:function(e,n){return t.compare(e,"application/x-shockwave-flash",!0)||t.compare(n,/\.(swf)$/i)},pdf:function(e,n){return t.compare(e,"application/pdf",!0)||t.compare(n,/\.(pdf)$/i)},object:function(){return!0},other:function(){return!0}},fileActionSettings:{showRemove:!0,showUpload:!0,showDownload:!0,showZoom:!0,showDrag:!0,removeIcon:'<i class="glyphicon glyphicon-trash"></i>',removeClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",removeErrorClass:"btn btn-sm btn-kv btn-danger",removeTitle:"Remove file",uploadIcon:'<i class="glyphicon glyphicon-upload"></i>',uploadClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",uploadTitle:"Upload file",uploadRetryIcon:'<i class="glyphicon glyphicon-repeat"></i>',uploadRetryTitle:"Retry upload",downloadIcon:'<i class="glyphicon glyphicon-download"></i>',downloadClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",downloadTitle:"Download file",zoomIcon:'<i class="glyphicon glyphicon-zoom-in"></i>',zoomClass:"btn btn-sm btn-kv btn-default btn-outline-secondary",zoomTitle:"View Details",dragIcon:'<i class="glyphicon glyphicon-move"></i>',dragClass:"text-info",dragTitle:"Move / Rearrange",dragSettings:{},indicatorNew:'<i class="glyphicon glyphicon-plus-sign text-warning"></i>',indicatorSuccess:'<i class="glyphicon glyphicon-ok-sign text-success"></i>',indicatorError:'<i class="glyphicon glyphicon-exclamation-sign text-danger"></i>',indicatorLoading:'<i class="glyphicon glyphicon-hourglass text-body-secondary"></i>',indicatorPaused:'<i class="glyphicon glyphicon-pause text-primary"></i>',indicatorNewTitle:"Not uploaded yet",indicatorSuccessTitle:"Uploaded",indicatorErrorTitle:"Upload Error",indicatorLoadingTitle:"Uploading &hellip;",indicatorPausedTitle:"Upload Paused"}},e.each(n.defaults,function(t,s){if(t==="allowedPreviewTypes"){n.allowedPreviewTypes===void 0&&(n.allowedPreviewTypes=s);return}n[t]=e.extend(!0,{},s,n[t])}),n._initPreviewTemplates()},_initPreviewTemplates:function(){var s,n=this,o=n.previewMarkupTags,i=o.tagAfter;e.each(n.previewContentTemplates,function(e,a){t.isEmpty(n.previewTemplates[e])&&(s=o.tagBefore2,(e==="generic"||e==="image")&&(s=o.tagBefore1),n._isPdfRendered()&&e==="pdf"&&(s=s.replace("kv-file-content","kv-file-content kv-pdf-rendered")),n.previewTemplates[e]=s+a+i)})},_initPreviewCache:function(){var n=this;n.previewCache={data:{},init:function(){var e=n.initialPreview;e.length>0&&!t.isArray(e)&&(e=e.split(n.initialPreviewDelimiter)),n.previewCache.data={content:e,config:n.initialPreviewConfig,tags:n.initialPreviewThumbTags}},count:function(e){if(!n.previewCache.data||!n.previewCache.data.content)return 0;if(e){var t=n.previewCache.data.content.filter(function(e){return e!==null});return t.length}return n.previewCache.data.content.length},get:function(e,s){var i,r,l,d,u,h,m,f=t.INIT_FLAG+e,a=n.previewCache.data,o=a.config[e],c=a.content[e],g=t.ifSet("previewAsData",o,n.initialPreviewAsData),v=o?{title:o.title||null,alt:o.alt||null}:{title:null,alt:null},p=function(e,s,i,a,r,c,l,d){var h=" file-preview-initial "+t.SORT_CSS+(l?" "+l:""),u=n.previewInitId+"-"+c,m=o&&o.fileId||u;return n._generatePreviewTemplate(e,s,i,a,u,m,!1,null,h,r,c,d,v,o&&o.zoomData||s)};return!c||!c.length?"":(s=s===void 0||s,r=t.ifSet("type",o,n.initialPreviewFileType||"generic"),u=t.ifSet("filename",o,t.ifSet("caption",o)),h=t.ifSet("filetype",o,r),d=n.previewCache.footer(e,s,o&&o.size||null),m=t.ifSet("frameClass",o),g?i=p(r,c,u,h,d,f,m):i=p("generic",c,u,h,d,f,m,r).setTokens({content:a.content[e]}),a.tags.length&&a.tags[e]&&(i=t.replaceTags(i,a.tags[e])),!t.isEmpty(o)&&!t.isEmpty(o.frameAttr)&&(l=t.createElement(i),l.find(".file-preview-initial").attr(o.frameAttr),i=l.html(),l.remove()),i)},clean:function(e){e.content=t.cleanArray(e.content),e.config=t.cleanArray(e.config),e.tags=t.cleanArray(e.tags),n.previewCache.data=e},add:function(e,s,o,i){var r,a=n.previewCache.data;return!e||!e.length?0:(r=e.length-1,t.isArray(e)||(e=e.split(n.initialPreviewDelimiter)),i&&a.content?(r=a.content.push(e[0])-1,a.config[r]=s,a.tags[r]=o):(a.content=e,a.config=s,a.tags=o),n.previewCache.clean(a),r)},set:function(e,s,o,i){var a,c,r=n.previewCache.data;if(!e||!e.length)return;if(t.isArray(e)||(e=e.split(n.initialPreviewDelimiter)),c=e.filter(function(e){return e!==null}),!c.length)return;if(r.content===void 0&&(r.content=[]),r.config===void 0&&(r.config=[]),r.tags===void 0&&(r.tags=[]),i){for(a=0;a<e.length;a++)e[a]&&r.content.push(e[a]);for(a=0;a<s.length;a++)s[a]&&r.config.push(s[a]);for(a=0;a<o.length;a++)o[a]&&r.tags.push(o[a])}else r.content=e,r.config=s,r.tags=o;n.previewCache.clean(r)},unset:function(s){var a,i=n.previewCache.count(),o=n.reversePreviewOrder;if(!i)return;if(i===1){n.previewCache.data.content=[],n.previewCache.data.config=[],n.previewCache.data.tags=[],n.initialPreview=[],n.initialPreviewConfig=[],n.initialPreviewThumbTags=[];return}n.previewCache.data.content=t.spliceArray(n.previewCache.data.content,s,o),n.previewCache.data.config=t.spliceArray(n.previewCache.data.config,s,o),n.previewCache.data.tags=t.spliceArray(n.previewCache.data.tags,s,o),a=e.extend(!0,{},n.previewCache.data),n.previewCache.clean(a)},out:function(){var t,o,i,e="",s=n.previewCache.count();if(s===0)return{content:"",caption:""};for(t=0;t<s;t++)o=n.previewCache.get(t),e=n.reversePreviewOrder?o+e:e+o;return i=n._getMsgSelected(s),{content:e,caption:i}},footer:function(e,s,o){if(a=n.previewCache.data||{},t.isEmpty(a.content))return"";(t.isEmpty(a.config)||t.isEmpty(a.config[e]))&&(a.config[e]={}),s=s===void 0||s;var a,i=a.config[e],y=t.ifSet("caption",i),m=t.ifSet("width",i,"auto"),d=t.ifSet("url",i,!1),u=t.ifSet("key",i,null),h=t.ifSet("fileId",i,null),r=n.fileActionSettings,f=n.initialPreviewShowDelete||!1,p=n.initialPreviewDownloadUrl?n.initialPreviewDownloadUrl+"?key="+u+(h?"&fileId="+h:""):"",l=i.downloadUrl||p,v=i.filename||i.caption||"",b=!!l,j=t.ifSet("showRemove",i,f),c=t.ifSet("showDownload",i,t.ifSet("showDownload",r,b)),_=t.ifSet("showZoom",i,t.ifSet("showZoom",r,!0)),w=t.ifSet("showDrag",i,t.ifSet("showDrag",r,!0)),O=d===!1&&s,c=c&&i.downloadUrl!==!1&&!!l,g=n._renderFileActions(i,!1,c,j,_,w,O,d,u,!0,l,v);return n._getLayoutTemplate("footer").setTokens({progress:n._renderThumbProgress(),actions:g,caption:y,size:n._getSize(o),width:m,indicator:""})}},n.previewCache.init()},_isPdfRendered:function(){var t=this,e=t.usePdfRenderer,n=typeof e=="function"?e():!!e;return n&&t.pdfRendererUrl},_handler:function(e,t,n){var i=this,s=i.namespace,o=t.split(" ").join(s+" ")+s;if(!e||!e.length)return;e.off(o).on(o,n)},_encodeURI:function(e){var t=this;return t.encodeUrl?encodeURI(e):e},_log:function(e,t){var n=this,s=n.$element.attr("id");if(!n.showConsoleLogs)return;s&&(e='"'+s+'": '+e),e="bootstrap-fileinput: "+e,typeof t=="object"&&(e=e.setTokens(t)),window.console&&typeof window.console.log!="undefined"?window.console.log(e):window.alert(e)},_validate:function(){var e=this,n=e.$element.attr("type")==="file";return n||e._log(t.logMessages.badInputType),n},_errorsExist:function(){var n,s=this,o=s.$errorContainer.find("li");return!!o.length||(n=t.createElement(s.$errorContainer.html()),n.find(".kv-error-close").remove(),n.find("ul").remove(),!!e.trim(n.text()).length)},_errorHandler:function(e,t){var s=this,n=e.target.error,o=function(e){s._showError(e.replace("{name}",t))};n.code===n.NOT_FOUND_ERR?o(s.msgFileNotFound):n.code===n.SECURITY_ERR?o(s.msgFileSecured):n.code===n.NOT_READABLE_ERR?o(s.msgFileNotReadable):o(n.code===n.ABORT_ERR?s.msgFilePreviewAborted:s.msgFilePreviewError)},_addError:function(e){var n=this,s=n.$errorContainer;e&&s.length&&(t.setHtml(s,n.errorCloseButton+e),n._handler(s.find(".kv-error-close"),"click",function(){setTimeout(function(){n.showPreview&&!n.getFrames().length&&n.clear(),s.fadeOut("slow")},n.processDelay)}))},_setValidationError:function(e){var n=this;e=(e?e+" ":"")+"has-error",n.$container.removeClass(e).addClass("has-error"),t.addCss(n.$captionContainer,"is-invalid")},_resetErrors:function(e){var t=this,n=t.$errorContainer;if(t.isPersistentError)return;t.isError=!1,t.$container.removeClass("has-error"),t.$captionContainer.removeClass("is-invalid"),n.html(""),e?n.fadeOut("slow"):n.hide()},_showFolderError:function(e){var n,t=this,s=t.$errorContainer;if(!e)return;t.isAjaxUpload||t._clearFileInput(),n=t.msgFoldersNotAllowed.replace("{n}",e),t._addError(n),t._setValidationError(),s.fadeIn(t.fadeDelay),t._raise("filefoldererror",[e,n])},_showFileError:function(e,t,n){var s=this,o=s.$errorContainer,a=n||"fileuploaderror",r=t&&t.fileId||"",i=t&&t.id?'<li data-thumb-id="'+t.id+'" data-file-id="'+r+'">'+e+"</li>":"<li>"+e+"</li>";return o.find("ul").length===0?s._addError("<ul>"+i+"</ul>"):o.find("ul").append(i),o.fadeIn(s.fadeDelay),s._raise(a,[t,e]),s._setValidationError("file-input-new"),!0},_showError:function(e,t,n){var s=this,o=s.$errorContainer,i=n||"fileerror";return t=t||{},t.reader=s.reader,s._addError(e),o.fadeIn(s.fadeDelay),s._raise(i,[t,e]),s.isAjaxUpload||s._clearFileInput(),s._setValidationError("file-input-new"),s.$btnUpload.attr("disabled",!0),!0},_noFilesError:function(e){var t=this,o=t.minFileCount>1?t.filePlural:t.fileSingle,n=t.msgFilesTooLess.replace("{n}",t.minFileCount).replace("{files}",o),s=t.$errorContainer,n="<li>"+n+"</li>";s.find("ul").length===0?t._addError("<ul>"+n+"</ul>"):s.find("ul").append(n),t.isError=!0,t._updateFileDetails(0),s.fadeIn(t.fadeDelay),t._raise("fileerror",[e,n]),t._clearFileInput(),t._setValidationError()},_parseError:function(t,n,s,o){var l,a=this,i=e.trim(s+""),c=n.responseJSON&&n.responseJSON.error?n.responseJSON.error.toString():"",r=c||n.responseText;return a.cancelling&&a.msgUploadAborted&&(i=a.msgUploadAborted),a.showAjaxErrorDetails&&r&&(c?i=e.trim(c+""):(r=e.trim(r.replace(/\n\s*\n/g,`
`)),l=r.length?"<pre>"+r+"</pre>":"",i+=i?l:r)),i||(i=a.msgAjaxError.replace("{operation}",t)),a.cancelling=!1,o?"<b>"+o+": </b>"+i:i},_parseFileType:function(e,n){var s,o,i,r,a=this,c=a.allowedPreviewTypes||[];if(e==="application/text-plain")return"text";for(s=0;s<c.length;s++)if(i=c[s],r=a.fileTypeSettings[i],o=r(e,n)?i:"",!t.isEmpty(o))return o;return"other"},_getPreviewIcon:function(t){var s,n=this,o=null;return t&&t.indexOf(".")>-1&&(s=t.split(".").pop(),n.previewFileIconSettings&&(o=n.previewFileIconSettings[s]||n.previewFileIconSettings[s.toLowerCase()]||null),n.previewFileExtSettings&&e.each(n.previewFileExtSettings,function(e,t){if(n.previewFileIconSettings[e]&&t(s)){o=n.previewFileIconSettings[e];return}})),o||n.previewFileIcon},_parseFilePreviewIcon:function(e,t){var s=this,o=s._getPreviewIcon(t),n=e;return n.indexOf("{previewFileIcon}")>-1&&(n=n.setTokens({previewFileIconClass:s.previewFileIconClass,previewFileIcon:o})),n},_raise:function(t,n){var o=this,s=e.Event(t);if(n!==void 0?o.$element.trigger(s,n):o.$element.trigger(s),s.isDefaultPrevented()||s.result===!1)return!1;switch(t){case"filebatchuploadcomplete":case"filebatchuploadsuccess":case"fileuploaded":case"fileclear":case"filecleared":case"filereset":case"fileerror":case"filefoldererror":case"fileuploaderror":case"filebatchuploaderror":case"filedeleteerror":case"filecustomerror":case"filesuccessremove":break;default:o.ajaxAborted||(o.ajaxAborted=s.result);break}return!0},_listenFullScreen:function(e){var n,s,o=this,t=o.$modal;if(!t||!t.length)return;if(s=t&&t.find(".btn-fullscreen"),n=t&&t.find(".btn-borderless"),!s.length||!n.length)return;s.removeClass("active").attr("aria-pressed","false"),n.removeClass("active").attr("aria-pressed","false"),e?s.addClass("active").attr("aria-pressed","true"):n.addClass("active").attr("aria-pressed","true"),t.hasClass("file-zoom-fullscreen")?o._maximizeZoomDialog():e?o._maximizeZoomDialog():n.removeClass("active").attr("aria-pressed","false")},_listen:function(){var i,r,c,l,n=this,s=n.$element,a=n.$form,o=n.$container;n._handler(s,"click",function(e){s.hasClass("file-no-browse")&&(s.data("zoneClicked")?s.data("zoneClicked",!1):e.preventDefault())}),n._handler(s,"change",e.proxy(n._change,n)),n.showBrowse&&n._handler(n.$btnFile,"click",e.proxy(n._browse,n)),i=o.find(".file-caption-name"),c=function(e){return daIgnoreAllButTab(e)},l=function(){return!1},n._handler(o.find(".fileinput-remove:not([disabled])"),"click",e.proxy(n.clear,n)),n._handler(o.find(".fileinput-cancel"),"click",e.proxy(n.cancel,n)),n._handler(o.find(".fileinput-pause"),"click",e.proxy(n.pause,n)),n._handler(i,"keydown",c),n._handler(i,"paste",l),n._initDragDrop(),n._handler(a,"reset",e.proxy(n.clear,n)),n.isAjaxUpload||n._handler(a,"submit",e.proxy(n._submitForm,n)),n._handler(n.$container.find(".fileinput-upload"),"click",e.proxy(n._uploadClick,n)),n._handler(e(window),"resize",function(){n._listenFullScreen(screen.width===window.innerWidth&&screen.height===window.innerHeight)}),r="webkitfullscreenchange mozfullscreenchange fullscreenchange MSFullscreenChange",n._handler(e(document),r,function(){n._listenFullScreen(t.checkFullScreen())}),n._autoFitContent(),n._initClickable(),n._refreshPreview()},_autoFitContent:function(){var n,s=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,t=this,o=s<400?t.previewSettingsSmall||t.defaults.previewSettingsSmall:t.previewSettings||t.defaults.previewSettings;e.each(o,function(e,s){n=".file-preview-frame .file-preview-"+e,t.$preview.find(n+".kv-preview-data,"+n+" .kv-preview-data").css(s)})},_scanDroppedItems:function(e,n,s){s=s||"";var o,a,r,i=this,c=function(e){i._log(t.logMessages.badDroppedFiles),i._log(e)};e.isFile?e.file(function(e){s&&(e.newPath=s+e.name),n.push(e)},c):e.isDirectory&&(r=e.createReader(),a=function(){r.readEntries(function(t){if(t&&t.length>0){for(o=0;o<t.length;o++)i._scanDroppedItems(t[o],n,s+e.name+"/");a()}return null},c)},a())},_initDragDrop:function(){var t=this,n=t.$dropZone;t.dropZoneEnabled&&t.showPreview&&(t._handler(n,"dragenter dragover",e.proxy(t._zoneDragEnter,t)),t._handler(n,"dragleave",e.proxy(t._zoneDragLeave,t)),t._handler(n,"drop",e.proxy(t._zoneDrop,t)),t._handler(e(document),"dragenter dragover drop",t._zoneDragDropInit))},_zoneDragDropInit:function(e){e.stopPropagation(),e.preventDefault()},_zoneDragEnter:function(n){var o=this,s=n.originalEvent.dataTransfer,i=e.inArray("Files",s.types)>-1;if(o._zoneDragDropInit(n),o.isDisabled||!i){s.effectAllowed="none",s.dropEffect="none";return}s.dropEffect="copy",o._raise("fileDragEnter",{sourceEvent:n,files:s.types.Files})&&t.addCss(o.$dropZone,"file-highlighted")},_zoneDragLeave:function(e){var t=this;if(t._zoneDragDropInit(e),t.isDisabled)return;t._raise("fileDragLeave",{sourceEvent:e})&&t.$dropZone.removeClass("file-highlighted")},_zoneDrop:function(e){var o,a,n=this,r=n.$element,c=e.originalEvent.dataTransfer,s=c.files,i=c.items,l=t.getDragDropFolders(i),d=function(){n.isAjaxUpload?n._change(e,s):(n.changeTriggered=!0,r.get(0).files=s,setTimeout(function(){n.changeTriggered=!1,r.trigger("change"+n.namespace)},n.processDelay)),n.$dropZone.removeClass("file-highlighted")};if(e.preventDefault(),n.isDisabled||t.isEmpty(s))return;if(!n._raise("fileDragDrop",{sourceEvent:e,files:s}))return;if(l>0){if(!n.isAjaxUpload){n._showFolderError(l);return}s=[];for(o=0;o<i.length;o++)a=i[o].webkitGetAsEntry(),a&&n._scanDroppedItems(a,s);setTimeout(function(){d()},500)}else d()},_uploadClick:function(e){var o,s=this,n=s.$container.find(".fileinput-upload"),i=!n.hasClass("disabled")&&t.isEmpty(n.attr("disabled"));if(e&&e.isDefaultPrevented())return;if(!s.isAjaxUpload){i&&n.attr("type")!=="submit"&&(o=n.closest("form"),o.length&&o.trigger("submit"),e.preventDefault());return}e.preventDefault(),i&&s.upload()},_submitForm:function(){var e=this;return e._isFileSelectionValid()&&!e._abort({})},_clearPreview:function(){var t=this,n=t.showUploadedThumbs?t.getFrames(":not(.file-preview-success)"):t.getFrames();n.each(function(){var t=e(this);t.remove()}),(!t.getFrames().length||!t.showPreview)&&t._resetUpload(),t._validateDefaultPreview()},_initSortable:function(){var s,o,i,a,n=this,r=n.$preview,c="."+t.SORT_CSS,l=e("body"),d=e("html"),u=n.reversePreviewOrder,h=window.Sortable;if(!h||r.find(c).length===0)return;o=l.length?l:d.length?d:n.$container,i=function(){o.addClass("file-grabbing")},a=function(){o.removeClass("file-grabbing")},s={handle:".drag-handle-init",dataIdAttr:"data-fileid",animation:600,draggable:c,scroll:!1,forceFallback:!0,onChoose:i,onStart:i,onUnchoose:a,onEnd:a,onSort:function(s){var c,i=s.oldIndex,o=s.newIndex,l=0,a=n.initialPreviewConfig.length,d=a>0&&o>=a,r=e(s.item);d&&(o=a-1),n.initialPreview=t.moveArray(n.initialPreview,i,o,u),n.initialPreviewConfig=t.moveArray(n.initialPreviewConfig,i,o,u),n.previewCache.init(),n.getFrames(".file-preview-initial").each(function(){e(this).attr("data-fileindex",t.INIT_FLAG+l),l++}),d&&(c=n.getFrames(":not(.file-preview-initial):first"),c.length&&r.slideUp(function(){r.insertBefore(c).slideDown()})),n._raise("filesorted",{previewId:r.attr("id"),oldIndex:i,newIndex:o,stack:n.initialPreviewConfig})}},e.extend(!0,s,n.fileActionSettings.dragSettings),n.sortable&&n.sortable.destroy(),n.sortable=h.create(r[0],s)},_setPreviewContent:function(e){var n=this;t.setHtml(n.$preview,e),n._autoFitContent()},_initPreviewImageOrientations:function(){var t=this,n=0,s=t.canOrientImage;if(!t.autoOrientImageInitial&&!s)return;t.getFrames(".file-preview-initial").each(function(){var a,r,c,i=e(this),o=t.initialPreviewConfig[n];o&&o.exif&&o.exif.Orientation&&(c=i.attr("id"),a=i.find(">.kv-file-content img"),r=t._getZoom(c," >.kv-file-content img"),s?a.css("image-orientation",t.autoOrientImageInitial?"from-image":"none"):t.setImageOrientation(a,r,o.exif.Orientation,i)),n++})},_initPreview:function(e){var s,n=this,o=n.initialCaption||"";if(!n.previewCache.count(!0)){n._clearPreview(),e?n._setCaption(o):n._initCaption();return}s=n.previewCache.out(),o=e&&n.initialCaption?n.initialCaption:s.caption,n._setPreviewContent(s.content),n._setInitThumbAttr(),n._setCaption(o),n._initSortable(),t.isEmpty(s.content)||n.$container.removeClass("file-input-new"),n._initPreviewImageOrientations()},_getZoomButton:function(e){var t=this,s=t.previewZoomButtonIcons[e],o=t.previewZoomButtonClasses[e],i=' title="'+(t.previewZoomButtonTitles[e]||"")+'" ',n=i+(e==="close"?' data-dismiss="modal" aria-hidden="true"':"");return(e==="fullscreen"||e==="borderless"||e==="toggleheader")&&(n+=' data-toggle="button" aria-pressed="false" autocomplete="off"'),'<button type="button" class="'+o+" btn-"+e+'"'+n+">"+s+"</button>"},_getModalContent:function(){var e=this;return e._getLayoutTemplate("modal").setTokens({rtl:e.rtl?" kv-rtl":"",zoomFrameClass:e.frameClass,heading:e.msgZoomModalHeading,prev:e._getZoomButton("prev"),next:e._getZoomButton("next"),toggleheader:e._getZoomButton("toggleheader"),fullscreen:e._getZoomButton("fullscreen"),borderless:e._getZoomButton("borderless"),close:e._getZoomButton("close")})},_listenModalEvent:function(e){var s=this,n=s.$modal,o=function(e){return{sourceEvent:e,previewId:n.data("previewId"),modal:n}};n.on(e+".bs.modal",function(i){var a=n.find(".btn-fullscreen"),r=n.find(".btn-borderless");n.data("fileinputPluginId")===s.$element.attr("id")&&s._raise("filezoom"+e,o(i)),e==="shown"&&(r.removeClass("active").attr("aria-pressed","false"),a.removeClass("active").attr("aria-pressed","false"),n.hasClass("file-zoom-fullscreen")&&(s._maximizeZoomDialog(),t.checkFullScreen()?a.addClass("active").attr("aria-pressed","true"):r.addClass("active").attr("aria-pressed","true")))})},_initZoom:function(){var s,n=this,i=n._getLayoutTemplate("modalMain"),o="#"+t.MODAL_ID;if(!n.showPreview)return;n.$modal=e(o),(!n.$modal||!n.$modal.length)&&(s=t.createElement(t.cspBuffer.stash(i)).insertAfter(n.$container),n.$modal=e(o).insertBefore(s),t.cspBuffer.apply(n.$modal),s.remove()),t.initModal(n.$modal),n.$modal.html(t.cspBuffer.stash(n._getModalContent())),t.cspBuffer.apply(n.$modal),e.each(t.MODAL_EVENTS,function(e,t){n._listenModalEvent(t)})},_initZoomButtons:function(){var i,a,t=this,r=t.$modal.data("previewId")||"",n=t.getFrames().toArray(),c=n.length,s=t.$modal.find(".btn-prev"),o=t.$modal.find(".btn-next");if(n.length<2){s.hide(),o.hide();return}if(s.show(),o.show(),!c)return;i=e(n[0]),a=e(n[c-1]),s.removeAttr("disabled"),o.removeAttr("disabled"),i.length&&i.attr("id")===r&&s.attr("disabled",!0),a.length&&a.attr("id")===r&&o.attr("disabled",!0)},_maximizeZoomDialog:function(){var r=this,t=r.$modal,o=t.find(".modal-header:visible"),i=t.find(".modal-footer:visible"),n=t.find(".modal-body"),s=e(window).height(),a=0;t.addClass("file-zoom-fullscreen"),o&&o.length&&(s-=o.outerHeight(!0)),i&&i.length&&(s-=i.outerHeight(!0)),n&&n.length&&(a=n.outerHeight(!0)-n.height(),s-=a),t.find(".kv-zoom-body").height(s)},_resizeZoomDialog:function(e){var s=this,n=s.$modal,o=n.find(".btn-fullscreen"),i=n.find(".btn-borderless");if(n.hasClass("file-zoom-fullscreen"))t.toggleFullScreen(!1),e?o.hasClass("active")||(n.removeClass("file-zoom-fullscreen"),s._resizeZoomDialog(!0),i.hasClass("active")&&i.removeClass("active").attr("aria-pressed","false")):o.hasClass("active")?o.removeClass("active").attr("aria-pressed","false"):(n.removeClass("file-zoom-fullscreen"),s.$modal.find(".kv-zoom-body").css("height",s.zoomModalHeight));else{if(!e){s._maximizeZoomDialog();return}t.toggleFullScreen(!0)}n.focus()},_setZoomContent:function(n,s){var a,r,l,d,o=this,c=n.attr("id"),m=o._getZoom(c),i=o.$modal,g=i.find(".btn-fullscreen"),v=i.find(".btn-borderless"),y=i.find(".btn-toggleheader"),p=m.attr("data-template")||"generic",f=m.find(".kv-file-content"),h=f.length?f.html():"",b=n.data("caption")||"",j=n.data("size")||"",u=b+" "+j;i.find(".kv-zoom-title").attr("title",e("<div/>").html(u).text()).html(u),a=i.find(".kv-zoom-body"),i.removeClass("kv-single-content"),s?(d=a.addClass("file-thumb-loading").clone().insertAfter(a),t.setHtml(a,h).hide(),d.fadeOut("fast",function(){a.fadeIn("fast",function(){a.removeClass("file-thumb-loading")}),d.remove()})):t.setHtml(a,h),l=o.previewZoomSettings[p],l&&(r=a.find(".kv-preview-data"),t.addCss(r,"file-zoom-detail"),e.each(l,function(e,t){r.css(e,t),(r.attr("width")&&e==="width"||r.attr("height")&&e==="height")&&r.removeAttr(e)})),i.data("previewId",c),o._handler(i.find(".btn-prev"),"click",function(){o._zoomSlideShow("prev",c)}),o._handler(i.find(".btn-next"),"click",function(){o._zoomSlideShow("next",c)}),o._handler(g,"click",function(){o._resizeZoomDialog(!0)}),o._handler(v,"click",function(){o._resizeZoomDialog(!1)}),o._handler(y,"click",function(){var n,e=i.find(".modal-header"),t=i.find(".modal-body .floating-buttons"),s=e.find(".kv-zoom-actions"),a=function(t){var s=o.$modal.find(".kv-zoom-body"),n=o.zoomModalHeight;i.hasClass("file-zoom-fullscreen")&&(n=s.outerHeight(!0),t||(n=n-e.outerHeight(!0))),s.css("height",t?n+t:n)};e.is(":visible")?(n=e.outerHeight(!0),e.slideUp("slow",function(){s.find(".btn").appendTo(t),a(n)})):(t.find(".btn").appendTo(s),e.slideDown("slow",function(){a()})),i.focus()}),o._handler(i,"keydown",function(t){var n=t.which||t.keyCode,s=e(this).find(".btn-prev"),i=e(this).find(".btn-next"),a=e(this).data("previewId"),r=o.rtl?39:37,c=o.rtl?37:39;n===r&&s.length&&!s.attr("disabled")&&o._zoomSlideShow("prev",a),n===c&&i.length&&!i.attr("disabled")&&o._zoomSlideShow("next",a)})},_showModal:function(e){var n=this,s=n.$modal;if(!e||!e.length)return;t.initModal(s),t.setHtml(s,n._getModalContent()),n._setZoomContent(e),s.data("fileinputPluginId",n.$element.attr("id")),s.modal("show"),n._initZoomButtons()},_zoomPreview:function(e){var n,s=this;if(!e.length)throw"Cannot zoom to detailed preview!";n=e.closest(t.FRAMES),s._showModal(n)},_zoomSlideShow:function(t,n){var s,a,r,l,o=this,u=o.$modal.find(".kv-zoom-actions .btn-"+t),d=o.getFrames().toArray(),i=[],c=d.length;if(u.attr("disabled"))return;for(s=0;s<c;s++)r=e(d[s]),r&&r.length&&r.find(".kv-file-zoom:visible").length&&i.push(d[s]);c=i.length;for(s=0;s<c;s++)if(e(i[s]).attr("id")===n){a=t==="prev"?s-1:s+1;break}if(a<0||a>=c||!i[a])return;l=e(i[a]),l.length&&o._setZoomContent(l,!0),o._initZoomButtons(),o._raise("filezoom"+t,{previewId:n,modal:o.$modal})},_initZoomButton:function(){var t=this;t.$preview.find(".kv-file-zoom").each(function(){var n=e(this);t._handler(n,"click",function(){t._zoomPreview(n)})})},_inputFileCount:function(){return this.$element[0].files.length},_refreshPreview:function(){var n,t=this;if(!t._inputFileCount()&&!t.isAjaxUpload||!t.showPreview||!t.isPreviewable)return;t.isAjaxUpload?t.fileManager.count()>0?(n=e.extend(!0,{},t.fileManager.stack),t.fileManager.clear(),t._clearFileInput()):n=t.$element[0].files:n=t.$element[0].files,n&&n.length&&(t.readFiles(n),t._setFileDropZoneTitle())},_clearObjects:function(t){t.find("video audio").each(function(){this.pause(),e(this).remove()}),t.find("img object div").each(function(){e(this).remove()})},_clearFileInput:function(){var t,s,o,i=this,n=i.$element;if(!i._inputFileCount())return;o=n.closest("form"),t=e(document.createElement("form")),s=e(document.createElement("div")),n.before(s),o.length?o.after(t):s.after(t),t.append(n).trigger("reset"),s.before(n).remove(),t.remove()},_resetUpload:function(){var e=this;e.uploadStartTime=t.now(),e.uploadCache=[],e.$btnUpload.removeAttr("disabled"),e._setProgress(0),e._hideProgress(),e._resetErrors(!1),e._initAjax(),e.fileManager.clearImages(),e._resetCanvas(),e.overwriteInitial&&(e.initialPreview=[],e.initialPreviewConfig=[],e.initialPreviewThumbTags=[],e.previewCache.data={content:[],config:[],tags:[]})},_resetCanvas:function(){var e=this;e.canvas&&e.imageCanvasContext&&e.imageCanvasContext.clearRect(0,0,e.canvas.width,e.canvas.height)},_hasInitialPreview:function(){var e=this;return!e.overwriteInitial&&e.previewCache.count(!0)},_resetPreview:function(){var s,o,i,n=this,a=n.showUploadedThumbs,r=!n.removeFromPreviewOnError,c=(a||r)&&n.isDuplicateError;n.previewCache.count(!0)?(o=n.previewCache.out(),c&&(s=t.createElement("").insertAfter(n.$container),n.getFrames().each(function(){var t=e(this);(a&&t.hasClass("file-preview-success")||r&&t.hasClass("file-preview-error"))&&s.append(t)})),n._setPreviewContent(o.content),n._setInitThumbAttr(),i=n.initialCaption?n.initialCaption:o.caption,n._setCaption(i),c&&(s.contents().appendTo(n.$preview),s.remove())):(n._clearPreview(),n._initCaption()),n.showPreview&&(n._initZoom(),n._initSortable()),n.isDuplicateError=!1},_clearDefaultPreview:function(){var e=this;e.$preview.find(".file-default-preview").remove()},_validateDefaultPreview:function(){var e=this;if(!e.showPreview||t.isEmpty(e.defaultPreviewContent))return;e._setPreviewContent('<div class="file-default-preview">'+e.defaultPreviewContent+"</div>"),e.$container.removeClass("file-input-new"),e._initClickable()},_resetPreviewThumbs:function(e){var n,t=this;if(e){t._clearPreview(),t.clearFileStack();return}t._hasInitialPreview()?(n=t.previewCache.out(),t._setPreviewContent(n.content),t._setInitThumbAttr(),t._setCaption(n.caption),t._initPreviewActions()):t._clearPreview()},_getLayoutTemplate:function(e){var n=this,s=n.layoutTemplates[e];return t.isEmpty(n.customLayoutTags)?s:t.replaceTags(s,n.customLayoutTags)},_getPreviewTemplate:function(e){var n=this,s=n.previewTemplates,o=s[e]||s.other;return t.isEmpty(n.customPreviewTags)?o:t.replaceTags(o,n.customPreviewTags)},_getOutData:function(e,t,n,s){var o=this;return t=t||{},n=n||{},s=s||o.fileManager.list(),{formdata:e,files:s,filenames:o.filenames,filescount:o.getFilesCount(),extra:o._getExtraData(),response:n,reader:o.reader,jqXHR:t}},_getMsgSelected:function(e){var t=this,n=e===1?t.fileSingle:t.filePlural;return e>0?t.msgSelected.replace("{n}",e).replace("{files}",n):t.msgNoFilesSelected},_getFrame:function(e,n){var s=this,o=t.getFrameElement(s.$preview,e);return s.showPreview&&!n&&!o.length&&s._log(t.logMessages.invalidThumb,{id:e}),o},_getZoom:function(e,n){var s=this,o=t.getZoomElement(s.$preview,e,n);return s.showPreview&&!o.length&&s._log(t.logMessages.invalidThumb,{id:e}),o},_getThumbs:function(e){return e=e||"",this.getFrames(":not(.file-preview-initial)"+e)},_getThumbId:function(e){var t=this;return t.previewInitId+"-"+e},_getExtraData:function(e,t){var n=this,s=n.uploadExtraData;return typeof n.uploadExtraData=="function"&&(s=n.uploadExtraData(e,t)),s},_initXhr:function(e,n){var s=this,i=s.fileManager,o=function(e){var o=0,r=e.total,c=e.loaded||e.position,a=i.getUploadStats(n,c,r);e.lengthComputable&&!s.enableResumableUpload&&(o=t.round(c/r*100)),n?s._setFileUploadStats(n,o,a):s._setProgress(o,null,null,s._getStats(a)),s._raise("fileajaxprogress",[a])};return e.upload&&(s.progressDelay&&(o=t.debounce(o,s.progressDelay)),e.upload.addEventListener("progress",o,!1)),e},_initAjaxSettings:function(){var t=this;t._ajaxSettings=e.extend(!0,{},t.ajaxSettings),t._ajaxDeleteSettings=e.extend(!0,{},t.ajaxDeleteSettings)},_mergeAjaxCallback:function(e,t,n){var i,o=this,s=o._ajaxSettings,a=o.mergeAjaxCallbacks;n==="delete"&&(s=o._ajaxDeleteSettings,a=o.mergeAjaxDeleteCallbacks),i=s[e],a&&typeof i=="function"?a==="before"?s[e]=function(){i.apply(this,arguments),t.apply(this,arguments)}:s[e]=function(){t.apply(this,arguments),i.apply(this,arguments)}:s[e]=t},_ajaxSubmit:function(t,n,s,o,i,a,r,c){var d,u,h,m,l=this;if(!l._raise("filepreajax",[i,a,r]))return;i.append("initialPreview",JSON.stringify(l.initialPreview)),i.append("initialPreviewConfig",JSON.stringify(l.initialPreviewConfig)),i.append("initialPreviewThumbTags",JSON.stringify(l.initialPreviewThumbTags)),l._initAjaxSettings(),l._mergeAjaxCallback("beforeSend",t),l._mergeAjaxCallback("success",n),l._mergeAjaxCallback("complete",s),l._mergeAjaxCallback("error",o),c=c||l.uploadUrlThumb||l.uploadUrl,typeof c=="function"&&(c=c()),d=l._getExtraData(a,r)||{},typeof d=="object"&&e.each(d,function(e,t){i.append(e,t)}),h={xhr:function(){var t=e.ajaxSettings.xhr();return l._initXhr(t,a)},url:l._encodeURI(c),type:"POST",dataType:"json",data:i,cache:!1,processData:!1,contentType:!1},u=e.extend(!0,{},h,l._ajaxSettings),m=l.taskManager.addTask(a+"-"+r,function(){var t=this.self,n=t.ajaxQueue.shift(),s=e.ajax(n);t.ajaxRequests.push(s)}),l.ajaxQueue.push(u),m.runWithContext({self:l})},_mergeArray:function(e,n){var s=this,o=t.cleanArray(s[e]),i=t.cleanArray(n);s[e]=o.concat(i)},_initUploadSuccess:function(n,s,o){var a,r,c,l,d,u,h,m,f,p,i=this;if(!i.showPreview||typeof n!="object"||e.isEmptyObject(n)){i._resetCaption();return}n.initialPreview!==void 0&&n.initialPreview.length>0&&(i.hasInitData=!0,a=n.initialPreview||[],r=n.initialPreviewConfig||[],c=n.initialPreviewThumbTags||[],l=n.append===void 0||n.append,a.length>0&&!t.isArray(a)&&(a=a.split(i.initialPreviewDelimiter)),a.length&&(i._mergeArray("initialPreview",a),i._mergeArray("initialPreviewConfig",r),i._mergeArray("initialPreviewThumbTags",c)),s!==void 0?o?(h=s.attr("id"),m=i._getUploadCacheIndex(h),m!==null&&(i.uploadCache[m]={id:h,content:a[0],config:r[0]||[],tags:c[0]||[],append:l})):(p=i.previewCache.add(a[0],r[0],c[0],l),f=i.previewCache.get(p,!1),d=t.createElement(f).hide().appendTo(s),u=d.find(".kv-zoom-cache"),u&&u.length&&u.appendTo(s),s.fadeOut("slow",function(){var e=d.find(".file-preview-frame");e&&e.length&&e.insertBefore(s).fadeIn("slow").css("display:inline-block"),i._initPreviewActions(),i._clearFileInput(),s.remove(),d.remove(),i._initSortable()})):(i.previewCache.set(a,r,c,l),i._initPreview(),i._initPreviewActions())),i._resetCaption()},_getUploadCacheIndex:function(e){var t,s,n=this,o=n.uploadCache.length;for(t=0;t<o;t++)if(s=n.uploadCache[t],s.id===e)return t;return null},_initSuccessThumbs:function(){var n=this;if(!n.showPreview)return;n._getThumbs(t.FRAMES+".file-preview-success").each(function(){var s=e(this),o=s.find(".kv-file-remove");o.removeAttr("disabled"),n._handler(o,"click",function(){var e=s.attr("id"),o=n._raise("filesuccessremove",[e,s.attr("data-fileindex")]);if(t.cleanMemory(s),o===!1)return;s.fadeOut("slow",function(){s.remove(),n.getFrames().length||n.reset()})})})},_updateInitialPreview:function(){var t=this,n=t.uploadCache;t.showPreview&&(e.each(n,function(e,n){t.previewCache.add(n.content,n.config,n.tags,n.append)}),t.hasInitData&&(t._initPreview(),t._initPreviewActions()))},_uploadSingle:function(n,s,o){var a,c,u,h,m,f,g,b,j,y,_,w,O,i=this,r=i.fileManager,x=r.count(),d=new FormData,p=i._getThumbId(s),C=x>0||!e.isEmptyObject(i.uploadExtraData),v=i.ajaxOperations.uploadThumb,E=r.getFile(s),l={id:p,index:n,fileId:s},k=i.fileManager.getFileName(s,!0);if(i.enableResumableUpload)return;if(i.showPreview&&(a=i.fileManager.getThumb(s),j=a.find(".file-thumb-progress"),c=a.find(".kv-file-upload"),h=a.find(".kv-file-remove"),j.show()),x===0||!C||i.showPreview&&c&&c.hasClass("disabled")||i._abort(l))return;m=function(){b?r.errors.push(s):r.removeFile(s),r.setProcessed(s),r.isProcessed()&&(i.fileBatchCompleted=!0,g())},g=function(){var e;if(!i.fileBatchCompleted)return;setTimeout(function(){var n=r.count()===0,s=r.errors.length;i._updateInitialPreview(),i.unlock(n),n&&i._clearFileInput(),e=i.$preview.find(".file-preview-initial"),i.uploadAsync&&e.length&&(t.addCss(e,t.SORT_CSS),i._initSortable()),i._raise("filebatchuploadcomplete",[r.stack,i._getExtraData()]),(!i.retryErrorUploads||s===0)&&r.clear(),i._setProgress(101),i.ajaxAborted=!1},i.processDelay)},O=function(m){u=i._getOutData(d,m),r.initStats(s),i.fileBatchCompleted=!1,o||(i.ajaxAborted=!1),i.showPreview&&(a.hasClass("file-preview-success")||(i._setThumbStatus(a,"Loading"),t.addCss(a,"file-uploading")),c.attr("disabled",!0),h.attr("disabled",!0)),o||i.lock(),r.errors.indexOf(s)!==-1&&delete r.errors[s],i._raise("filepreupload",[u,p,n]),e.extend(!0,l,u),i._abort(l)&&(m.abort(),o||(i._setThumbStatus(a,"New"),a.removeClass("file-uploading"),c.removeAttr("disabled"),h.removeAttr("disabled"),i.unlock()),i._setProgressCancelled())},y=function(r,h,g){var y=i.showPreview&&a.attr("id")?a.attr("id"):p;u=i._getOutData(d,g,r),e.extend(!0,l,u),setTimeout(function(){t.isEmpty(r)||t.isEmpty(r.error)?(i.showPreview&&(i._setThumbStatus(a,"Success"),c.hide(),i._initUploadSuccess(r,a,o),i._setProgress(101,j)),i._raise("fileuploaded",[u,y,n]),o?m():i.fileManager.remove(a)):(b=!0,f=i._parseError(v,g,i.msgUploadError,i.fileManager.getFileName(s)),i._showFileError(f,l),i._setPreviewError(a,!0),i.retryErrorUploads||c.hide(),o&&m(),i._setProgress(101,i._getFrame(y).find(".file-thumb-progress"),i.msgUploadError))},i.processDelay)},_=function(){i.showPreview&&(c.removeAttr("disabled"),h.removeAttr("disabled"),a.removeClass("file-uploading")),o?g():(i.unlock(!1),i._clearFileInput()),i._initSuccessThumbs()},w=function(t,n,r){f=i._parseError(v,t,r,i.fileManager.getFileName(s)),b=!0,setTimeout(function(){var n;o&&m(),i.fileManager.setProgress(s,100),i._setPreviewError(a,!0),i.retryErrorUploads||c.hide(),e.extend(!0,l,i._getOutData(d,t)),i._setProgress(101,i.$progress,i.msgAjaxProgressError.replace("{operation}",v)),n=i.showPreview&&a?a.find(".file-thumb-progress"):"",i._setProgress(101,n,i.msgUploadError),i._showFileError(f,l)},i.processDelay)},i._setFileData(d,E.file,k,s),i._setUploadData(d,{fileId:s}),i._ajaxSubmit(O,y,_,w,d,s,n)},_setFileData:function(e,t,n,s){var o=this,i=o.preProcessUpload;i&&typeof i=="function"?e.append(o.uploadFileAttr,i(s,t)):e.append(o.uploadFileAttr,t,n)},_uploadBatch:function(){var o,i,c,l,d,u,h,n=this,m=n.fileManager,a=m.total(),p={},f=a>0||!e.isEmptyObject(n.uploadExtraData),s=new FormData,r=n.ajaxOperations.uploadBatch;if(a===0||!f||n._abort(p))return;u=function(){n.fileManager.clear(),n._clearFileInput()},h=function(o){n.lock(),m.initStats();var i=n._getOutData(s,o);n.ajaxAborted=!1,n.showPreview&&n._getThumbs().each(function(){var s=e(this),o=s.find(".kv-file-upload"),i=s.find(".kv-file-remove");s.hasClass("file-preview-success")||(n._setThumbStatus(s,"Loading"),t.addCss(s,"file-uploading")),o.attr("disabled",!0),i.attr("disabled",!0)}),n._raise("filebatchpreupload",[i]),n._abort(i)&&(o.abort(),n._getThumbs().each(function(){var t=e(this),s=t.find(".kv-file-upload"),o=t.find(".kv-file-remove");t.hasClass("file-preview-loading")&&(n._setThumbStatus(t,"New"),t.removeClass("file-uploading")),s.removeAttr("disabled"),o.removeAttr("disabled")}),n._setProgressCancelled())},d=function(i,a,c){var l=n._getOutData(s,c,i),d=0,h=n._getThumbs(":not(.file-preview-success)"),m=t.isEmpty(i)||t.isEmpty(i.errorkeys)?[]:i.errorkeys;t.isEmpty(i)||t.isEmpty(i.error)?(n._raise("filebatchuploadsuccess",[l]),u(),n.showPreview?(h.each(function(){var t=e(this);n._setThumbStatus(t,"Success"),t.removeClass("file-uploading"),t.find(".kv-file-upload").hide().removeAttr("disabled")}),n._initUploadSuccess(i)):n.reset(),n._setProgress(101)):(n.showPreview&&(h.each(function(){var t=e(this);t.removeClass("file-uploading"),t.find(".kv-file-upload").removeAttr("disabled"),t.find(".kv-file-remove").removeAttr("disabled"),m.length===0||e.inArray(d,m)!==-1?(n._setPreviewError(t,!0),n.retryErrorUploads||(t.find(".kv-file-upload").hide(),n.fileManager.remove(t))):(t.find(".kv-file-upload").hide(),n._setThumbStatus(t,"Success"),n.fileManager.remove(t)),(!t.hasClass("file-preview-error")||n.retryErrorUploads)&&d++}),n._initUploadSuccess(i)),o=n._parseError(r,c,n.msgUploadError),n._showFileError(o,l,"filebatchuploaderror"),n._setProgress(101,n.$progress,n.msgUploadError))},l=function(){n.unlock(),n._initSuccessThumbs(),n._clearFileInput(),n._raise("filebatchuploadcomplete",[n.fileManager.stack,n._getExtraData()])},c=function(t,i,c){var l=n._getOutData(s,t);if(o=n._parseError(r,t,c),n._showFileError(o,l,"filebatchuploaderror"),n.uploadFileCount=a-1,!n.showPreview)return;n._getThumbs().each(function(){var t=e(this);t.removeClass("file-uploading"),n.fileManager.getFile(t.attr("data-fileid"))&&n._setPreviewError(t)}),n._getThumbs().removeClass("file-uploading"),n._getThumbs(" .kv-file-upload").removeAttr("disabled"),n._getThumbs(" .kv-file-delete").removeAttr("disabled"),n._setProgress(101,n.$progress,n.msgAjaxProgressError.replace("{operation}",r))},i=0,e.each(n.fileManager.stack,function(e,o){t.isEmpty(o.file)||n._setFileData(s,o.file,o.nameFmt||"untitled_"+i,e),i++}),n._ajaxSubmit(h,d,l,c,s)},_uploadExtraOnly:function(){var o,a,r,c,l,e=this,n={},s=new FormData,i=e.ajaxOperations.uploadExtra;if(e._abort(n))return;a=function(t){e.lock();var o=e._getOutData(s,t);e._raise("filebatchpreupload",[o]),e._setProgress(50),n.data=o,n.xhr=t,e._abort(n)&&(t.abort(),e._setProgressCancelled())},r=function(n,a,r){var c=e._getOutData(s,r,n);t.isEmpty(n)||t.isEmpty(n.error)?(e._raise("filebatchuploadsuccess",[c]),e._clearFileInput(),e._initUploadSuccess(n),e._setProgress(101)):(o=e._parseError(i,r,e.msgUploadError),e._showFileError(o,c,"filebatchuploaderror"))},c=function(){e.unlock(),e._clearFileInput(),e._raise("filebatchuploadcomplete",[e.fileManager.stack,e._getExtraData()])},l=function(t,a,r){var c=e._getOutData(s,t);o=e._parseError(i,t,r),n.data=c,e._showFileError(o,c,"filebatchuploaderror"),e._setProgress(101,e.$progress,e.msgAjaxProgressError.replace("{operation}",i))},e._ajaxSubmit(a,r,c,l,s)},_deleteFileIndex:function(n){var s=this,o=n.attr("data-fileindex"),i=s.reversePreviewOrder;o.substring(0,5)===t.INIT_FLAG&&(o=parseInt(o.replace(t.INIT_FLAG,"")),s.initialPreview=t.spliceArray(s.initialPreview,o,i),s.initialPreviewConfig=t.spliceArray(s.initialPreviewConfig,o,i),s.initialPreviewThumbTags=t.spliceArray(s.initialPreviewThumbTags,o,i),s.getFrames().each(function(){var s=e(this),n=s.attr("data-fileindex");n.substring(0,5)===t.INIT_FLAG&&(n=parseInt(n.replace(t.INIT_FLAG,"")),n>o&&(n--,s.attr("data-fileindex",t.INIT_FLAG+n)))}))},_resetCaption:function(){var e=this;setTimeout(function(){var t,n,s,o=e.previewCache.count(!0),i=e.fileManager.count(),a=":not(.file-preview-success):not(.file-preview-error)",r=e.showPreview&&e.getFrames(a).length;i===0&&o===0&&!r?e.reset():(n=o+i,n>1?t=e._getMsgSelected(n):(s=e.fileManager.getFirstFile(),t=s?s.nameFmt:"_"),e._setCaption(t))},e.processDelay)},_initFileActions:function(){var n=this;if(!n.showPreview)return;n._initZoomButton(),n.getFrames(" .kv-file-remove").each(function(){var a,c,i=e(this),s=i.closest(t.FRAMES),o=s.attr("id"),r=s.attr("data-fileindex");n._handler(i,"click",function(){if(c=n._raise("filepreremove",[o,r]),c===!1||!n._validateMinCount())return!1;a=s.hasClass("file-preview-error"),t.cleanMemory(s),s.fadeOut("slow",function(){n.fileManager.remove(s),n._clearObjects(s),s.remove(),o&&a&&n.$errorContainer.find('li[data-thumb-id="'+o+'"]').fadeOut("fast",function(){e(this).remove(),n._errorsExist()||n._resetErrors()}),n._clearFileInput(),n._resetCaption(),n._raise("fileremoved",[o,r])})})}),n.getFrames(" .kv-file-upload").each(function(){var s=e(this);n._handler(s,"click",function(){var e=s.closest(t.FRAMES),o=e.attr("data-fileid");if(n._hideProgress(),e.hasClass("file-preview-error")&&!n.retryErrorUploads)return;n._uploadSingle(n.fileManager.getIndex(o),o,!1)})})},_initPreviewActions:function(){var n=this,r=n.$preview,c=n.deleteExtraData||{},l=t.FRAMES+" .kv-file-remove",a=n.fileActionSettings,s=a.removeClass,o=a.removeErrorClass,i=function(){var e=n.isAjaxUpload?n.previewCache.count(!0):n._inputFileCount();!n.getFrames().length&&!e&&(n._setCaption(""),n.reset(),n.initialCaption="")};n._initZoomButton(),r.find(l).each(function(){var v,b,y,_,r=e(this),f=r.data("url")||n.deleteUrl,h=r.data("key"),j=n.ajaxOperations.deleteThumb;if(t.isEmpty(f)||h===void 0)return;typeof f=="function"&&(f=f());var d,g,a=r.closest(t.FRAMES),p=n.previewCache.data,m=a.attr("data-fileindex"),m=parseInt(m.replace(t.INIT_FLAG,"")),u=t.isEmpty(p.config)&&t.isEmpty(p.config[m])?null:p.config[m],l=t.isEmpty(u)||t.isEmpty(u.extra)?c:u.extra,w=u&&(u.filename||u.caption)||"";typeof l=="function"&&(l=l()),d={id:r.attr("id"),key:h,extra:l},y=function(e){n.ajaxAborted=!1,n._raise("filepredelete",[h,e,l]),n._abort()?e.abort():(r.removeClass(o),t.addCss(a,"file-uploading"),t.addCss(r,"disabled "+s))},v=function(e,c,u){var f,p;if(!t.isEmpty(e)&&!t.isEmpty(e.error)){d.jqXHR=u,d.response=e,_=n._parseError(j,u,n.msgDeleteError,w),n._showFileError(_,d,"filedeleteerror"),a.removeClass("file-uploading"),r.removeClass("disabled "+s).addClass(o),i();return}a.removeClass("file-uploading").addClass("file-deleted"),a.fadeOut("slow",function(){m=parseInt(a.attr("data-fileindex").replace(t.INIT_FLAG,"")),n.previewCache.unset(m),n._deleteFileIndex(a),f=n.previewCache.count(!0),p=f>0?n._getMsgSelected(f):"",n._setCaption(p),n._raise("filedeleted",[h,u,l]),n._clearObjects(a),a.remove(),i()})},b=function(e,t,c){var l=n._parseError(j,e,c,w);d.jqXHR=e,d.response={},n._showFileError(l,d,"filedeleteerror"),a.removeClass("file-uploading"),r.removeClass("disabled "+s).addClass(o),i()},n._initAjaxSettings(),n._mergeAjaxCallback("beforeSend",y,"delete"),n._mergeAjaxCallback("success",v,"delete"),n._mergeAjaxCallback("error",b,"delete"),g=e.extend(!0,{},{url:n._encodeURI(f),type:"POST",dataType:"json",data:e.extend(!0,{},{key:h},l)},n._ajaxDeleteSettings),n._handler(r,"click",function(){if(!n._validateMinCount())return!1;n.ajaxAborted=!1,n._raise("filebeforedelete",[h,l]),n.ajaxAborted instanceof Promise?n.ajaxAborted.then(function(t){t||e.ajax(g)}):n.ajaxAborted||e.ajax(g)})})},_hideFileIcon:function(){var e=this;e.overwriteInitial&&e.$captionContainer.removeClass("icon-visible")},_showFileIcon:function(){var e=this;t.addCss(e.$captionContainer,"icon-visible")},_getSize:function(t,n){var o,i,a=this,s=parseFloat(t),r=a.fileSizeGetter;return!e.isNumeric(t)||!e.isNumeric(s)?"":(typeof r=="function"?o=r(s):s===0?o="0.00 B":(i=Math.floor(Math.log(s)/Math.log(1024)),n||(n=["B","KB","MB","GB","TB","PB","EB","ZB","YB"]),o=(s/Math.pow(1024,i)).toFixed(2)*1+" "+n[i]),a._getLayoutTemplate("size").replace("{sizeText}",o))},_getFileType:function(e){var t=this;return t.mimeTypeAliases[e]||e},_generatePreviewTemplate:function(n,s,o,i,a,r,c,l,d,u,h,m,f,p){var w,E,g=this,b=g.slug(o),v="",_="",A=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth,y=b,k=b,x="type-default",S=u||g._renderFileFooter(n,b,l,"auto",c),C=g.preferIconicPreview,M=g.preferIconicZoomPreview,j=C?"other":n,O=A<400?g.previewSettingsSmall[j]||g.defaults.previewSettingsSmall[j]:g.previewSettings[j]||g.defaults.previewSettings[j];return O&&e.each(O,function(e,t){_+=e+":"+t+";"}),w=function(s,c,l,u){var j=l?"zoom-"+a:a,v=g._getPreviewTemplate(s),p=(d||"")+" "+u;return g.frameClass&&(p=g.frameClass+" "+p),l&&(p=p.replace(" "+t.SORT_CSS,"")),v=g._parseFilePreviewIcon(v,o),n==="object"&&!i&&e.each(g.defaults.fileTypeSettings,function(e,t){if(e==="object"||e==="other")return;t(o,i)&&(x="type-"+e)}),t.isEmpty(f)||(f.title!==void 0&&f.title!==null&&(y=f.title),f.alt!==void 0&&f.alt!==null&&(y=f.alt)),v.setTokens({previewId:j,caption:b,title:y,alt:k,frameClass:p,type:g._getFileType(i),fileindex:h,fileid:r||"",typeCss:x,footer:S,data:c,template:m||n,style:_?'style="'+_+'"':""})},h=h||a.slice(a.lastIndexOf("-")+1),g.fileActionSettings.showZoom&&(v=w(M?"other":n,p||s,!0,"kv-zoom-thumb")),v=`
`+g._getLayoutTemplate("zoomCache").replace("{zoomContent}",v),typeof g.sanitizeZoomCache=="function"&&(v=g.sanitizeZoomCache(v)),E=w(C?"other":n,s,!1,"kv-preview-thumb"),E.setTokens({zoomCache:v})},_addToPreview:function(e,n){var s,o=this;return n=t.cspBuffer.stash(n),s=o.reversePreviewOrder?e.prepend(n):e.append(n),t.cspBuffer.apply(e),s},_previewDefault:function(e,n){if(s=this,i=s.$preview,!s.showPreview)return;var s,i,a,l=t.getFileName(e),d=e?e.type:"",r=e.size||0,u=s._getFileName(e,""),h=n===!0&&!s.isAjaxUpload,m=t.createObjectURL(e),c=s.fileManager.getId(e),o=s._getThumbId(c);s._clearDefaultPreview(),a=s._generatePreviewTemplate("other",m,l,d,o,c,h,r),s._addToPreview(i,a),s._setThumbAttr(o,u,r),n===!0&&s.isAjaxUpload&&s._setThumbStatus(s._getFrame(o),"Error")},_previewFile:function(e,n,s,o,i){if(!this.showPreview)return;var p,a=this,u=t.getFileName(n),c=i.type,h=i.name,m=a._parseFileType(c,u),v=a.$preview,l=n.size||0,f=m==="image"?s.target.result:o,d=a.fileManager.getId(n),r=a._getThumbId(d),g=a._generatePreviewTemplate(m,f,u,c,r,d,!1,l);a._clearDefaultPreview(),a._addToPreview(v,g),p=a._getFrame(r),a._validateImageOrientation(p.find("img"),n,r,d,h,c,l,f),a._setThumbAttr(r,h,l),a._initSortable()},_setThumbAttr:function(e,t,n){var s=this,o=s._getFrame(e);o.length&&(n=n&&n>0?s._getSize(n):"",o.data({caption:t,size:n}))},_setInitThumbAttr:function(){var e,s,i,a,r,n=this,c=n.previewCache.data,o=n.previewCache.count(!0);if(o===0)return;for(e=0;e<o;e++)s=c.config[e],r=n.previewInitId+"-"+t.INIT_FLAG+e,i=t.ifSet("caption",s,t.ifSet("filename",s)),a=t.ifSet("size",s),n._setThumbAttr(r,i,a)},_slugDefault:function(e){return t.isEmpty(e,!0)?"":String(e).replace(/[[\]/{}:;#%=()*+?\\^$|<>&"']/g,"_")},_updateFileDetails:function(e,n){var o,a,c,l,d,s=this,i=s.$element,r=t.isIE(9)&&t.findFileName(i.val())||i[0].files[0]&&i[0].files[0].name;!r&&s.fileManager.count()>0?(d=s.fileManager.getFirstFile(),o=d.nameFmt):o=r?s.slug(r):"_",a=s.isAjaxUpload?s.fileManager.count():e,l=s.previewCache.count(!0)+a,c=a===1?o:s._getMsgSelected(l),s.isError?(s.$previewContainer.removeClass("file-thumb-loading"),s.$previewStatus.html(""),s.$captionContainer.removeClass("icon-visible")):s._showFileIcon(),s._setCaption(c,s.isError),s.$container.removeClass("file-input-new file-input-ajax-new"),n||s._raise("fileselect",[e,o]),s.previewCache.count(!0)&&s._initPreviewActions()},_setThumbStatus:function(e,n){if(s=this,!s.showPreview)return;var s,o="indicator"+n,r=o+"Title",c="file-preview-"+n.toLowerCase(),i=e.find(".file-upload-indicator"),a=s.fileActionSettings;e.removeClass("file-preview-success file-preview-error file-preview-paused file-preview-loading"),n==="Success"&&e.find(".file-drag-handle").remove(),t.setHtml(i,a[o]),i.attr("title",a[r]),e.addClass(c),n==="Error"&&!s.retryErrorUploads&&e.find(".kv-file-upload").attr("disabled",!0)},_setProgressCancelled:function(){var e=this;e._setProgress(101,e.$progress,e.msgCancelled)},_setProgress:function(e,n,s,o){if(i=this,n=n||i.$progress,!n.length)return;var i,a,r=Math.min(e,100),c=i.progressUploadThreshold,d=e<=100?i.progressTemplate:i.progressCompleteTemplate,l=r<100?i.progressTemplate:s?i.paused?i.progressPauseTemplate:i.progressErrorTemplate:d;e>=100&&(o=""),t.isEmpty(l)||(c&&r>c&&e<=100?a=l.setTokens({percent:c,status:i.msgUploadThreshold}):a=l.setTokens({percent:r,status:e>100?i.msgUploadEnd:r+"%"}),o=o||"",a=a.setTokens({stats:o}),t.setHtml(n,a),s&&t.setHtml(n.find('[role="progressbar"]'),s))},_hasFiles:function(){var e=this.$element[0];return!!(e&&e.files&&e.files.length)},_setFileDropZoneTitle:function(){var o,e=this,n=e.$container.find(".file-drop-zone"),s=e.dropZoneTitle;if(e.isClickable&&(o=t.isEmpty(e.$element.attr("multiple"))?e.fileSingle:e.filePlural,s+=e.dropZoneClickTitle.replace("{files}",o)),n.find("."+e.dropZoneTitleClass).remove(),!e.showPreview||n.length===0||e.fileManager.count()>0||!e.dropZoneEnabled||e.previewCache.count()>0||!e.isAjaxUpload&&e._hasFiles())return;n.find(t.FRAMES).length===0&&t.isEmpty(e.defaultPreviewContent)&&n.prepend('<div class="'+e.dropZoneTitleClass+' text-body-secondary">'+s+"</div>"),e.$container.removeClass("file-input-new"),t.addCss(e.$container,"file-input-ajax-new")},_getStats:function(e){var s,o,n=this;return!n.showUploadStats||!e||!e.bitrate?"":(o=n._getLayoutTemplate("stats"),s=!e.elapsed||!e.bps?n.msgCalculatingTime:n.msgPendingTime.setTokens({time:t.getElapsed(Math.ceil(e.pendingBytes/e.bps))}),o.setTokens({uploadSpeed:e.bitrate,pendingTime:s}))},_setResumableProgress:function(e,t,n){var o=this,i=o.resumableManager,s=n?i:o,a=n?n.find(".file-thumb-progress"):null;s.lastProgress===0&&(s.lastProgress=e),e<s.lastProgress&&(e=s.lastProgress),o._setProgress(e,a,null,o._getStats(t)),s.lastProgress=e},_toggleResumableProgress:function(e,n){var o=this,s=o.$progress;s&&s.length&&t.setHtml(s,e.setTokens({percent:101,status:n,stats:""}))},_setFileUploadStats:function(n,s,o){if(i=this,a=i.$progress,!i.showPreview&&(!a||!a.length))return;var i,a,d,r=i.fileManager,p=i.resumableManager,l=r.getThumb(n),m=0,c=r.getTotalSize(),u=e.extend(!0,{},o);if(i.enableResumableUpload){var f,h=o.loaded,g=p.getUploadedSize(),v=p.file.size;h+=g,f=r.uploadedSize+h,s=t.round(100*h/v),o.pendingBytes=v-g,i._setResumableProgress(s,o,l),d=Math.floor(100*f/c),u.pendingBytes=c-f,i._setResumableProgress(d,u)}else r.setProgress(n,s),a=l&&l.length?l.find(".file-thumb-progress"):null,i._setProgress(s,a,null,i._getStats(o)),e.each(r.stats,function(e,t){m+=t.loaded}),u.pendingBytes=c-m,d=t.round(m/c*100),i._setProgress(d,null,null,i._getStats(u))},_validateMinCount:function(){var e=this,t=e.isAjaxUpload?e.fileManager.count():e._inputFileCount();return!(e.validateInitialCount&&e.minFileCount>0&&e._getFileCount(t-1)<e.minFileCount)||(e._noFilesError({}),!1)},_getFileCount:function(e,t){var n=this,s=0;return t===void 0&&(t=n.validateInitialCount&&!n.overwriteInitial),t&&(s=n.previewCache.count(!0),e+=s),e},_getFileId:function(e){return t.getFileId(e,this.generateFileId)},_getFileName:function(e,n){var o=this,s=t.getFileName(e);return s?o.slug(s):n},_getFileNames:function(e){var t=this;return t.filenames.filter(function(t){return e?t!==void 0:t!=null})},_setPreviewError:function(e,t){var n=this,s=n.removeFromPreviewOnError&&!n.retryErrorUploads;if((!t||s)&&n.fileManager.remove(e),!n.showPreview)return;if(s){e.remove();return}n._setThumbStatus(e,"Error"),n._refreshUploadButton(e)},_refreshUploadButton:function(e){var o=this,s=e.find(".kv-file-upload"),n=o.fileActionSettings,i=n.uploadIcon,a=n.uploadTitle;if(!s.length)return;o.retryErrorUploads&&(i=n.uploadRetryIcon,a=n.uploadRetryTitle),s.attr("title",a),t.setHtml(s,i)},_checkDimensions:function(e,n,s,o,i,a,r){var c,u,h,m,l=this,f=n==="Small"?"min":"max",d=l[f+"Image"+a];if(t.isEmpty(d)||!s.length)return;if(c=s[0],u=a==="Width"?c.naturalWidth||c.width:c.naturalHeight||c.height,m=n==="Small"?u>=d:u<=d,m)return;h=l["msgImage"+a+n].setTokens({name:i,size:d}),l._showFileError(h,r),l._setPreviewError(o)},_getExifObj:function(e){var n,o=this,s=t.logMessages.exifWarning;if(e.slice(0,23)!=="data:image/jpeg;base64,"&&e.slice(0,22)!=="data:image/jpg;base64,"){n=null;return}try{n=window.piexif?window.piexif.load(e):null}catch(e){n=null,s=e&&e.message||""}return n||o._log(t.logMessages.badExifParser,{details:s}),n},setImageOrientation:function(n,s,o,i){var r,l,d,a=this,u=!n||!n.length,m=!s||!s.length,c=!1,h=u&&i&&i.attr("data-template")==="image";if(u&&m)return;d="load.fileinputimageorient",h?(n=s,s=null,n.css(a.previewSettings.image),l=e(document.createElement("div")).appendTo(i.find(".kv-file-content")),r=e(document.createElement("span")).insertBefore(n),n.css("visibility","hidden").removeClass("file-zoom-detail").appendTo(l)):c=!n.is(":visible"),n.off(d).on(d,function(){c&&(a.$preview.removeClass("hide-content"),i.find(".kv-file-content").css("visibility","hidden"));var e=n[0],u=s&&s.length?s[0]:null,m=e.offsetHeight,f=e.offsetWidth,d=t.getRotation(o);if(c&&(i.find(".kv-file-content").css("visibility","visible"),a.$preview.addClass("hide-content")),n.data("orientation",o),u&&s.data("orientation",o),o<5){t.setTransform(e,d),t.setTransform(u,d);return}var v=Math.atan(f/m),p=Math.sqrt(Math.pow(m,2)+Math.pow(f,2)),b=p?m/Math.cos(Math.PI/2+v)/p:1,g=" scale("+Math.abs(b)+")";t.setTransform(e,d+g),t.setTransform(u,d+g),h&&(n.css("visibility","visible").insertAfter(r).addClass("file-zoom-detail"),r.remove(),l.remove())})},_validateImageOrientation:function(n,s,o,i,a,r,c,l){var u,h,f,d=this,m=d.autoOrientImage;if(d.canOrientImage){n.css("image-orientation",m?"from-image":"none");return}if(f=t.getZoomSelector(o," img"),u=m?d._getExifObj(l):null,h=u?u["0th"][piexif.ImageIFD.Orientation]:null,!h){d._validateImage(o,i,a,r,c,l,u);return}d.setImageOrientation(n,e(f),h,d._getFrame(o)),d._raise("fileimageoriented",{$img:n,file:s}),d._validateImage(o,i,a,r,c,l,u)},_validateImage:function(t,n,s,o,i,a,r){var h,m,f,c=this,p=c.$preview,l=c._getFrame(t),u=l.attr("data-fileindex"),d=l.find("img");s=s||"Untitled",d.one("load",function(){m=l.width(),f=p.width(),m>f&&d.css("width","100%"),h={ind:u,id:t,fileId:n},c._checkDimensions(u,"Small",d,l,s,"Width",h),c._checkDimensions(u,"Small",d,l,s,"Height",h),c.resizeImage||(c._checkDimensions(u,"Large",d,l,s,"Width",h),c._checkDimensions(u,"Large",d,l,s,"Height",h)),c._raise("fileimageloaded",[t]),c.fileManager.addImage(n,{ind:u,img:d,thumb:l,pid:t,typ:o,siz:i,validated:!1,imgData:a,exifObj:r}),l.data("exif",r),c._validateAllImages()}).one("error",function(){c._raise("fileimageloaderror",[t])}).each(function(){this.complete?e(this).trigger("load"):this.error&&e(this).trigger("error")})},_validateAllImages:function(){var n,t=this,o={val:0},s=t.fileManager.getImageCount(),i=t.resizeIfSizeMoreThan;if(s!==t.fileManager.totalImages)return;if(t._raise("fileimagesloaded"),!t.resizeImage)return;e.each(t.fileManager.loadedImages,function(e,a){a.validated||(n=a.siz,n&&n>i*1e3&&t._getResizedImage(e,a,o,s),a.validated=!0)})},_getResizedImage:function(n,s,o,i){var l,p,g,y,x,E,a=this,b=e(s.img)[0],c=b.naturalWidth,r=b.naturalHeight,u=1,h=a.maxImageWidth||c,d=a.maxImageHeight||r,f=!!(c&&r),v=a.imageCanvas,M=a.imageCanvasContext,m=s.typ,O=s.pid,w=s.ind,S=s.thumb,C=s.exifObj,_=function(e,t,n){a.isAjaxUpload?a._showFileError(e,t,n):a._showError(e,t,n),a._setPreviewError(S)},k=a.fileManager.getFile(n),j={id:O,index:w,fileId:n},A=[n,O,w];if((!k||!f||c<=h&&r<=d)&&(f&&k&&a._raise("fileimageresized",A),o.val++,o.val===i&&a._raise("fileimagesresized"),!f)){_(a.msgImageResizeError,j,"fileimageresizeerror");return}m=m||a.resizeDefaultImageType,p=c>h,g=r>d,a.resizePreference==="width"?u=p?h/c:g?d/r:1:u=g?d/r:p?h/c:1,a._resetCanvas(),c*=u,r*=u,v.width=c,v.height=r;try{M.drawImage(b,0,0,c,r),l=v.toDataURL(m,a.resizeQuality),C&&(E=window.piexif.dump(C),l=window.piexif.insert(E,l)),y=t.dataURI2Blob(l),a.fileManager.setFile(n,y),a._raise("fileimageresized",A),o.val++,o.val===i&&a._raise("fileimagesresized",[void 0,void 0]),y instanceof Blob||_(a.msgImageResizeError,j,"fileimageresizeerror")}catch(e){o.val++,o.val===i&&a._raise("fileimagesresized",[void 0,void 0]),x=a.msgImageResizeException.replace("{errors}",e.message),_(x,j,"fileimageresizeexception")}},_showProgress:function(){var e=this;e.$progress&&e.$progress.length&&e.$progress.show()},_hideProgress:function(){var e=this;e.$progress&&e.$progress.length&&e.$progress.hide()},_initBrowse:function(e){var n=this,s=n.$element;n.showBrowse?n.$btnFile=e.find(".btn-file").append(s):(s.appendTo(e).attr("tabindex",-1),t.addCss(s,"file-no-browse"))},_initClickable:function(){var s,o,n=this;if(!n.isClickable)return;s=n.$dropZone,n.isAjaxUpload||(o=n.$preview.find(".file-default-preview"),o.length&&(s=o)),t.addCss(s,"clickable"),s.attr("tabindex",-1),n._handler(s,"click",function(t){var o=e(t.target);!e(n.elErrorContainer+":visible").length&&(!o.parents(".file-preview-thumbnails").length||o.parents(".file-default-preview").length)&&(n.$element.data("zoneClicked",!0).trigger("click"),s.blur())})},_initCaption:function(){var e=this,n=e.initialCaption||"";return e.overwriteInitial||t.isEmpty(n)?(e.$caption.val(""),!1):(e._setCaption(n),!0)},_setCaption:function(n,s){var i,a,r,c,l,d,o=this;if(!o.$caption.length)return;if(o.$captionContainer.removeClass("icon-visible"),s)i=e("<div>"+o.msgValidationError+"</div>").text(),a=o.fileManager.count(),a?(d=o.fileManager.getFirstFile(),l=a===1&&d?d.nameFmt:o._getMsgSelected(a)):l=o._getMsgSelected(o.msgNo),r=t.isEmpty(n)?l:n,c='<span class="'+o.msgValidationErrorClass+'">'+o.msgValidationErrorIcon+"</span>";else{if(t.isEmpty(n))return;i=e("<div>"+n+"</div>").text(),r=i,c=o._getLayoutTemplate("fileIcon")}o.$captionContainer.addClass("icon-visible"),o.$caption.attr("title",i).val(r),t.setHtml(o.$captionIcon,c)},_createContainer:function(){var e=this,s={class:"file-input file-input-new"+(e.rtl?" kv-rtl":"")},n=t.createElement(t.cspBuffer.stash(e._renderMain()));return t.cspBuffer.apply(n),n.insertBefore(e.$element).attr(s),e._initBrowse(n),e.theme&&n.addClass("theme-"+e.theme),n},_refreshContainer:function(){var e=this,n=e.$container,s=e.$element;s.insertAfter(n),t.setHtml(n,e._renderMain()),e._initBrowse(n),e._validateDisabled()},_validateDisabled:function(){var e=this;e.$caption.attr({readonly:e.isDisabled})},_renderMain:function(){var e=this,t=e.dropZoneEnabled?" file-drop-zone":"file-drop-disabled",n=e.showClose?e._getLayoutTemplate("close"):"",s=e.showPreview?e._getLayoutTemplate("preview").setTokens({class:e.previewClass,dropClass:t}):"",o=e.isDisabled?e.captionClass+" file-caption-disabled":e.captionClass,i=e.captionTemplate.setTokens({class:o+" kv-fileinput-caption"});return e.mainTemplate.setTokens({class:e.mainClass+(!e.showBrowse&&e.showCaption?" no-browse":""),preview:s,close:n,caption:i,upload:e._renderButton("upload"),remove:e._renderButton("remove"),cancel:e._renderButton("cancel"),pause:e._renderButton("pause"),browse:e._renderButton("browse")})},_renderButton:function(e){var n=this,i=n._getLayoutTemplate("btnDefault"),s=n[e+"Class"],r=n[e+"Title"],c=n[e+"Icon"],o=n[e+"Label"],l=n.isDisabled?" disabled":"",a="button";switch(e){case"remove":if(!n.showRemove)return"";break;case"cancel":if(!n.showCancel)return"";s+=" kv-hidden";break;case"pause":if(!n.showPause)return"";s+=" kv-hidden";break;case"upload":if(!n.showUpload)return"";n.isAjaxUpload&&!n.isDisabled?i=n._getLayoutTemplate("btnLink").replace("{href}",n.uploadUrl):a="submit";break;case"browse":if(!n.showBrowse)return"";i=n._getLayoutTemplate("btnBrowse");break;default:return""}return s+=e==="browse"?" btn-file":" fileinput-"+e+" fileinput-"+e+"-button",t.isEmpty(o)||(o=' <span class="'+n.buttonLabelClass+'">'+o+"</span>"),i.setTokens({type:a,css:s,title:r,status:l,icon:c,label:o})},_renderThumbProgress:function(){var e=this;return'<div class="file-thumb-progress kv-hidden">'+e.progressInfoTemplate.setTokens({percent:101,status:e.msgUploadBegin,stats:""})+"</div>"},_renderFileFooter:function(e,n,s,o,i){var c,l,a=this,r=a.fileActionSettings,m=r.showRemove,d=r.showDrag,h=r.showUpload,u=r.showZoom,f=a._getLayoutTemplate("footer"),p=a._getLayoutTemplate("indicator"),g=i?r.indicatorError:r.indicatorNew,v=i?r.indicatorErrorTitle:r.indicatorNewTitle,b=p.setTokens({indicator:g,indicatorTitle:v});return s=a._getSize(s),c={type:e,caption:n,size:s,width:o,progress:"",indicator:b},a.isAjaxUpload?(c.progress=a._renderThumbProgress(),c.actions=a._renderFileActions(c,h,!1,m,u,d,!1,!1,!1)):c.actions=a._renderFileActions(c,!1,!1,!1,u,d,!1,!1,!1),l=f.setTokens(c),l=t.replaceTags(l,a.previewThumbTags),l},_renderFileActions:function(e,t,n,s,o,i,a,r,c,l,d,u){if(m=this,!e.type&&l&&(e.type="image"),m.enableResumableUpload?t=!1:typeof t=="function"&&(t=t(e)),typeof n=="function"&&(n=n(e)),typeof s=="function"&&(s=s(e)),typeof o=="function"&&(o=o(e)),typeof i=="function"&&(i=i(e)),!t&&!n&&!s&&!o&&!i)return"";var m,g,w=r===!1?"":' data-url="'+r+'"',y="",b="",v=c===!1?"":' data-key="'+c+'"',p="",j="",f="",_=m._getLayoutTemplate("actions"),h=m.fileActionSettings,O=m.otherActionButtons.setTokens({dataKey:v,key:c}),x=a?h.removeClass+" disabled":h.removeClass;return s&&(p=m._getLayoutTemplate("actionDelete").setTokens({removeClass:x,removeIcon:h.removeIcon,removeTitle:h.removeTitle,dataUrl:w,dataKey:v,key:c})),t&&(j=m._getLayoutTemplate("actionUpload").setTokens({uploadClass:h.uploadClass,uploadIcon:h.uploadIcon,uploadTitle:h.uploadTitle})),n&&(f=m._getLayoutTemplate("actionDownload").setTokens({downloadClass:h.downloadClass,downloadIcon:h.downloadIcon,downloadTitle:h.downloadTitle,downloadUrl:d||m.initialPreviewDownloadUrl}),f=f.setTokens({filename:u,key:c})),o&&(y=m._getLayoutTemplate("actionZoom").setTokens({zoomClass:h.zoomClass,zoomIcon:h.zoomIcon,zoomTitle:h.zoomTitle})),i&&l&&(g="drag-handle-init "+h.dragClass,b=m._getLayoutTemplate("actionDrag").setTokens({dragClass:g,dragTitle:h.dragTitle,dragIcon:h.dragIcon})),_.setTokens({delete:p,upload:j,download:f,zoom:y,drag:b,other:O})},_browse:function(e){var t=this;if(e&&e.isDefaultPrevented()||!t._raise("filebrowse"))return;t.isError&&!t.isAjaxUpload&&t.clear(),t.focusCaptionOnBrowse&&t.$captionContainer.focus()},_change:function(n){if(s=this,s.changeTriggered)return;var s,a,r,l,u,f=s.$element,b=arguments.length>1,i=s.isAjaxUpload,d=b?arguments[1]:f[0].files,h=s.fileManager.count(),m=t.isEmpty(f.attr("multiple")),o=!i&&m?1:s.maxFileCount,c=s.maxTotalFileCount,p=c>0&&c>o,g=m&&h>0,j=function(t,n,o,a){var r=e.extend(!0,{},s._getOutData(null,{},{},d),{id:o,index:a}),c={id:o,index:a,file:n,files:d};return s.isPersistentError=!0,i?s._showFileError(t,r):s._showError(t,c)},v=function(e,t,n){var o=n?s.msgTotalFilesTooMany:s.msgFilesTooMany,o=o.replace("{m}",t).replace("{n}",e);s.isError=j(o,null,null,null),s.$captionContainer.removeClass("icon-visible"),s._setCaption("",!0),s.$container.removeClass("file-input-new file-input-ajax-new")};if(s.reader=null,s._resetUpload(),s._hideFileIcon(),s.dropZoneEnabled&&s.$container.find(".file-drop-zone ."+s.dropZoneTitleClass).remove(),i||(n.target&&n.target.files===void 0?d=n.target.value?[{name:n.target.value.replace(/^.+\\/,"")}]:[]:d=n.target.files||{}),l=d,t.isEmpty(l)||l.length===0){i||s.clear(),s._raise("fileselectnone");return}if(s._resetErrors(),a=l.length,u=i?s.fileManager.count()+a:a,r=s._getFileCount(u,!p&&void 0),o>0&&r>o){if(!s.autoReplace||a>o){v(s.autoReplace&&a>o?a:r,o);return}r>o&&s._resetPreviewThumbs(i)}else{if(p&&(r=s._getFileCount(u,!0),c>0&&r>c)){if(!s.autoReplace||a>o){v(s.autoReplace&&a>c?a:r,c,!0);return}r>o&&s._resetPreviewThumbs(i)}!i||g?(s._resetPreviewThumbs(!1),g&&s.clearFileStack()):i&&h===0&&(!s.previewCache.count(!0)||s.overwriteInitial)&&s._resetPreviewThumbs(!0)}s.readFiles(l)},_abort:function(t){var s,n=this;return n.ajaxAborted&&typeof n.ajaxAborted=="object"&&n.ajaxAborted.message!==void 0?(s=e.extend(!0,{},n._getOutData(null),t),s.abortData=n.ajaxAborted.data||{},s.abortMessage=n.ajaxAborted.message,n._setProgress(101,n.$progress,n.msgCancelled),n._showFileError(n.ajaxAborted.message,s,"filecustomerror"),n.cancel(),!0):!!n.ajaxAborted},_resetFileStack:function(){var t=this,n=0;t._getThumbs().each(function(){var s=e(this),o=s.attr("data-fileindex"),i=s.attr("id");if(o==="-1"||o===-1)return;t.fileManager.getFile(s.attr("data-fileid"))?s.attr({"data-fileindex":"-1"}):(s.attr({"data-fileindex":n}),n++),t._getZoom(i).attr({"data-fileindex":s.attr("data-fileindex")})})},_isFileSelectionValid:function(e){var t=this;return e=e||0,t.required&&!t.getFilesCount()?(t.$errorContainer.html(""),t._showFileError(t.msgFileRequired),!1):!(t.minFileCount>0&&t._getFileCount(e)<t.minFileCount)||(t._noFilesError({}),!1)},_canPreview:function(e){if(n=this,!e||!n.showPreview||!n.$preview||!n.$preview.length)return!1;var n,s=e.name||"",o=e.type||"",v=(e.size||0)/1e3,l=n._parseFileType(o,s),u=n.allowedPreviewTypes,h=n.allowedPreviewMimeTypes,d=n.allowedPreviewExtensions||[],a=n.disabledPreviewTypes,c=n.disabledPreviewMimeTypes,r=n.disabledPreviewExtensions||[],i=n.maxFilePreviewSize&&parseFloat(n.maxFilePreviewSize)||0,b=new RegExp("\\.("+d.join("|")+")$","i"),j=new RegExp("\\.("+r.join("|")+")$","i"),g=!u||u.indexOf(l)!==-1,p=!h||h.indexOf(o)!==-1,f=!d.length||t.compare(s,b),m=a&&a.indexOf(l)!==-1||c&&c.indexOf(o)!==-1||r.length&&t.compare(s,j)||i&&!isNaN(i)&&v>i;return!m&&(g||p||f)},addToStack:function(e,t){this.fileManager.add(e,t)},clearFileStack:function(){var e=this;return e.fileManager.clear(),e._initResumableUpload(),e.enableResumableUpload?(e.showPause===null&&(e.showPause=!0),e.showCancel===null&&(e.showCancel=!1)):(e.showPause=!1,e.showCancel===null&&(e.showCancel=!0)),e.$element},getFileStack:function(){return this.fileManager.stack},getFileList:function(){return this.fileManager.list()},getFilesCount:function(e){var t=this,n=t.isAjaxUpload?t.fileManager.count():t._inputFileCount();return e&&(n+=t.previewCache.count(!0)),t._getFileCount(n)},readFiles:function(n){this.reader=new FileReader;var r,s=this,i=s.reader,u=s.$previewContainer,c=s.$previewStatus,g=s.msgLoading,m=s.msgProgress,p=s.previewInitId,o=n.length,d=s.fileTypeSettings,a=s.allowedFileTypes,f=a?a.length:0,l=s.allowedFileExtensions,v=t.isEmpty(l)?"":l.join(", "),h=function(t,i,a,c,l){var d,u=e.extend(!0,{},s._getOutData(null,{},{},n),{id:a,index:c,fileId:l}),h={id:a,index:c,fileId:l,file:i,files:n};s._previewDefault(i,!0),d=s._getFrame(a,!0),s.isAjaxUpload?setTimeout(function(){r(c+1)},s.processDelay):(s.unlock(),o=0),s.removeFromPreviewOnError&&d.length?d.remove():(s._initFileActions(),d.find(".kv-file-upload").remove()),s.isPersistentError=!0,s.isError=s.isAjaxUpload?s._showFileError(t,u):s._showError(t,h),s._updateFileDetails(o)};s.fileManager.clearImages(),e.each(n,function(e,t){var n=s.fileTypeSettings.image;n&&n(t.type)&&s.fileManager.totalImages++}),r=function(b){if(E=s.$errorContainer,C=s.fileManager,b>=o){s.unlock(),s.duplicateErrors.length&&(N="<li>"+s.duplicateErrors.join("</li><li>")+"</li>",E.find("ul").length===0?t.setHtml(E,s.errorCloseButton+"<ul>"+N+"</ul>"):E.find("ul").append(N),E.fadeIn(s.fadeDelay),s._handler(E.find(".kv-error-close"),"click",function(){E.fadeOut(s.fadeDelay)}),s.duplicateErrors=[]),s.isAjaxUpload?(s._raise("filebatchselected",[C.stack]),C.count()===0&&!s.isError&&s.reset()):s._raise("filebatchselected",[n]),u.removeClass("file-thumb-loading"),c.html("");return}s.lock(!0);var _,w,x,C,E,k,S,M,F,T,z,D,N,W,K,q,j=n[b],P=s._getFileId(j),O=p+"-"+P,Y=d.text,I=d.image,G=d.html,y=s._getFileName(j,""),L=(j&&j.size||0)/1e3,R="",V=t.createObjectURL(j),A=0,B="",H=!1,$=0,U=function(){var e=m.setTokens({index:b+1,files:o,percent:50,name:y});setTimeout(function(){c.html(e),s._updateFileDetails(o),r(b+1)},s.processDelay),s._raise("fileloaded",[j,O,P,b,i])&&s.isAjaxUpload&&C.add(j)};if(!j)return;if(x=C.getId(j),f>0)for(w=0;w<f;w++)T=a[w],D=s.msgFileTypes[T]||T,B+=w===0?D:", "+D;if(y===!1){r(b+1);return}if(y.length===0){_=s.msgInvalidFileName.replace("{name}",t.htmlEncode(t.getFileName(j),"[unknown]")),h(_,j,O,b,x);return}if(t.isEmpty(l)||(R=new RegExp("\\.("+l.join("|")+")$","i")),k=L.toFixed(2),s.isAjaxUpload&&C.exists(x)||s._getFrame(O,!0).length){K={id:O,index:b,fileId:x,file:j,files:n},_=s.msgDuplicateFile.setTokens({name:y,size:k}),s.isAjaxUpload?(s.duplicateErrors.push(_),s.isDuplicateError=!0,s._raise("fileduplicateerror",[j,x,y,k,O,b]),r(b+1),s._updateFileDetails(o)):(s._showError(_,K),s.unlock(),o=0,s._clearFileInput(),s.reset(),s._updateFileDetails(o));return}if(s.maxFileSize>0&&L>s.maxFileSize){_=s.msgSizeTooLarge.setTokens({name:y,size:k,maxSize:s.maxFileSize}),h(_,j,O,b,x);return}if(s.minFileSize!==null&&L<=t.getNum(s.minFileSize)){_=s.msgSizeTooSmall.setTokens({name:y,size:k,minSize:s.minFileSize}),h(_,j,O,b,x);return}if(!t.isEmpty(a)&&t.isArray(a)){for(w=0;w<a.length;w+=1)W=a[w],M=d[W],A+=!M||typeof M!="function"?0:M(j.type,t.getFileName(j))?1:0;if(A===0){_=s.msgInvalidFileType.setTokens({name:y,types:B}),h(_,j,O,b,x);return}}if(A===0&&!t.isEmpty(l)&&t.isArray(l)&&!t.isEmpty(R)&&(z=t.compare(y,R),A+=t.isEmpty(z)?0:z.length,A===0)){_=s.msgInvalidFileExtension.setTokens({name:y,extensions:v}),h(_,j,O,b,x);return}if(!s._canPreview(j)){S=s.isAjaxUpload&&s._raise("filebeforeload",[j,b,i]),s.isAjaxUpload&&S&&C.add(j),s.showPreview&&S&&(u.addClass("file-thumb-loading"),s._previewDefault(j),s._initFileActions()),setTimeout(function(){S&&s._updateFileDetails(o),r(b+1),s._raise("fileloaded",[j,O,P,b])},10);return}F=I(j.type,y),c.html(g.replace("{index}",b+1).replace("{files}",o)),u.addClass("file-thumb-loading"),i.onerror=function(e){s._errorHandler(e,y)},i.onload=function(n){var o,a,l,h,m,f=[],p=function(){var e=new FileReader;e.onerror=function(e){s._errorHandler(e,y)},e.onload=function(e){if(s.isAjaxUpload&&!s._raise("filebeforeload",[j,b,i])){H=!0,s._resetCaption(),i.abort(),c.html(""),u.removeClass("file-thumb-loading"),s.enable();return}s._previewFile(b,j,e,V,r),s._initFileActions(),U()},e.readAsDataURL(j)},r={name:y,type:j.type};if(e.each(d,function(e,t){e!=="object"&&e!=="other"&&typeof t=="function"&&t(j.type,y)&&$++}),$===0){l=new Uint8Array(n.target.result);for(w=0;w<l.length;w++)m=l[w].toString(16),f.push(m);if(a=f.join("").toLowerCase().substring(0,8),o=t.getMimeType(a,"",""),t.isEmpty(o)&&(h=t.arrayBuffer2String(i.result),o=t.isSvg(h)?"image/svg+xml":t.getMimeType(a,h,j.type)),r={name:y,type:o},F=I(o,""),F){p(q);return}}if(s.isAjaxUpload&&!s._raise("filebeforeload",[j,b,i])){H=!0,s._resetCaption(),i.abort(),c.html(""),u.removeClass("file-thumb-loading"),s.enable();return}s._previewFile(b,j,n,V,r),s._initFileActions(),U()},i.onprogress=function(e){if(e.lengthComputable){var t=e.loaded/e.total*100,n=Math.ceil(t);_=m.setTokens({index:b+1,files:o,percent:n,name:y}),setTimeout(function(){H||c.html(_)},s.processDelay)}},F?i.readAsDataURL(j):i.readAsArrayBuffer(j)},r(0),s._updateFileDetails(o,!0)},lock:function(e){var t=this,n=t.$container;return t._resetErrors(),t.disable(),!e&&t.showCancel&&n.find(".fileinput-cancel").show(),!e&&t.showPause&&n.find(".fileinput-pause").show(),t._raise("filelock",[t.fileManager.stack,t._getExtraData()]),t.$element},unlock:function(e){var t=this,n=t.$container;return e===void 0&&(e=!0),t.enable(),n.removeClass("is-locked"),t.showCancel&&n.find(".fileinput-cancel").hide(),t.showPause&&n.find(".fileinput-pause").hide(),e&&t._resetFileStack(),t._raise("fileunlock",[t.fileManager.stack,t._getExtraData()]),t.$element},resume:function(){var e=this,t=!1,n=e.resumableManager;return e.enableResumableUpload?(e.paused?e._toggleResumableProgress(e.progressPauseTemplate,e.msgUploadResume):t=!0,e.paused=!1,t&&e._toggleResumableProgress(e.progressInfoTemplate,e.msgUploadBegin),setTimeout(function(){n.upload()},e.processDelay),e.$element):e.$element},pause:function(){var n,t=this,s=t.resumableManager,o=t.ajaxRequests,i=o.length,a=s.getProgress(),c=t.fileActionSettings,l=t.taskManager,r=l.getPool(s.id);if(!t.enableResumableUpload)return t.$element;if(r&&r.cancel(),t._raise("fileuploadpaused",[t.fileManager,s]),i>0)for(n=0;n<i;n+=1)t.paused=!0,o[n].abort();return t.showPreview&&t._getThumbs().each(function(){var s,n=e(this),o=n.attr("data-fileid"),i=t._getLayoutTemplate("stats"),r=n.find(".file-upload-indicator");n.removeClass("file-uploading"),r.attr("title")===c.indicatorLoadingTitle&&(t._setThumbStatus(n,"Paused"),s=i.setTokens({pendingTime:t.msgPaused,uploadSpeed:""}),t.paused=!0,t._setProgress(a,n.find(".file-thumb-progress"),a+"%",s)),t.fileManager.getFile(o)||n.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")}),t._setProgress(101,t.$progress,t.msgPaused),t.$element},cancel:function(){var s,t=this,o=t.ajaxRequests,n=t.resumableManager,r=t.taskManager,i=n?r.getPool(n.id):void 0,a=o.length;if(t.enableResumableUpload&&i?(i.cancel().done(function(){t._setProgressCancelled()}),n.reset(),t._raise("fileuploadcancelled",[t.fileManager,n])):t._raise("fileuploadcancelled",[t.fileManager]),t._initAjax(),a>0)for(s=0;s<a;s+=1)t.cancelling=!0,o[s].abort();return t._getThumbs().each(function(){var n=e(this),o=n.attr("data-fileid"),s=n.find(".file-thumb-progress");n.removeClass("file-uploading"),t._setProgress(0,s),s.hide(),t.fileManager.getFile(o)||(n.find(".kv-file-upload").removeClass("disabled").removeAttr("disabled"),n.find(".kv-file-remove").removeClass("disabled").removeAttr("disabled")),t.unlock()}),setTimeout(function(){t._setProgressCancelled()},t.processDelay),t.$element},clear:function(){var s,n=this;if(!n._raise("fileclear"))return;return n.$btnUpload.removeAttr("disabled"),n._getThumbs().find("video,audio,img").each(function(){t.cleanMemory(e(this))}),n._clearFileInput(),n._resetUpload(),n.clearFileStack(),n.isDuplicateError=!1,n.isPersistentError=!1,n._resetErrors(!0),n._hasInitialPreview()?(n._showFileIcon(),n._resetPreview(),n._initPreviewActions(),n.$container.removeClass("file-input-new")):(n._getThumbs().each(function(){n._clearObjects(e(this))}),n.isAjaxUpload&&(n.previewCache.data={}),n.$preview.html(""),s=!n.overwriteInitial&&n.initialCaption.length>0?n.initialCaption:"",n.$caption.attr("title","").val(s),t.addCss(n.$container,"file-input-new"),n._validateDefaultPreview()),n.$container.find(t.FRAMES).length===0&&(n._initCaption()||n.$captionContainer.removeClass("icon-visible")),n._hideFileIcon(),n.focusCaptionOnClear&&n.$captionContainer.focus(),n._setFileDropZoneTitle(),n._raise("filecleared"),n.$element},reset:function(){var e=this;if(!e._raise("filereset"))return;return e.lastProgress=0,e._resetPreview(),e.$container.find(".fileinput-filename").text(""),t.addCss(e.$container,"file-input-new"),e.getFrames().length&&e.$container.removeClass("file-input-new"),e.clearFileStack(),e._setFileDropZoneTitle(),e.$element},disable:function(){var e=this,n=e.$container;return e.isDisabled=!0,e._raise("filedisabled"),e.$element.attr("disabled","disabled"),n.addClass("is-locked"),t.addCss(n.find(".btn-file"),"disabled"),n.find(".kv-fileinput-caption").addClass("file-caption-disabled"),n.find(".fileinput-remove, .fileinput-upload, .file-preview-frame button").attr("disabled",!0),e._initDragDrop(),e.$element},enable:function(){var e=this,t=e.$container;return e.isDisabled=!1,e._raise("fileenabled"),e.$element.removeAttr("disabled"),t.removeClass("is-locked"),t.find(".kv-fileinput-caption").removeClass("file-caption-disabled"),t.find(".fileinput-remove, .fileinput-upload, .file-preview-frame button").removeAttr("disabled"),t.find(".btn-file").removeClass("disabled"),e._initDragDrop(),e.$element},upload:function(){var o,a,n=this,i=n.fileManager,s=i.count(),r=!e.isEmptyObject(n._getExtraData());if(!n.isAjaxUpload||n.isDisabled||!n._isFileSelectionValid(s))return;if(n.lastProgress=0,n._resetUpload(),s===0&&!r){n._showFileError(n.msgUploadEmpty);return}if(n.cancelling=!1,n._showProgress(),n.lock(),s===0&&r){n._setProgress(2),n._uploadExtraOnly();return}if(n.enableResumableUpload)return n.resume();if((n.uploadAsync||n.enableResumableUpload)&&(a=n._getOutData(null),n._raise("filebatchpreupload",[a]),n.fileBatchCompleted=!1,n.uploadCache=[],e.each(n.getFileStack(),function(e){var t=n._getThumbId(e);n.uploadCache.push({id:t,content:null,config:null,tags:null,append:!0})}),n.$preview.find(".file-preview-initial").removeClass(t.SORT_CSS),n._initSortable()),n._setProgress(2),n.hasInitData=!1,n.uploadAsync){o=0,e.each(i.stack,function(e){n._uploadSingle(o,e,!0),o++});return}return n._uploadBatch(),n.$element},destroy:function(){var t=this,s=t.$form,o=t.$container,i=t.$element,n=t.namespace;return e(document).off(n),e(window).off(n),s&&s.length&&s.off(n),t.isAjaxUpload&&t._clearFileInput(),t._cleanup(),t._initPreviewCache(),i.insertBefore(o).off(n).removeData(),o.off().remove(),i},refresh:function(n){var s=this,o=s.$element;return typeof n!="object"||t.isEmpty(n)?n=s.options:n=e.extend(!0,{},s.options,n),s._init(n,!0),s._listen(),o},zoom:function(e){var t=this,n=t._getFrame(e);t._showModal(n)},getExif:function(e){var n=this,t=n._getFrame(e);return t&&t.data("exif")||null},getFrames:function(n){var s,o=this;return n=n||"",s=o.$preview.find(t.FRAMES+n),o.reversePreviewOrder&&(s=e(s.get().reverse())),s},getPreview:function(){var e=this;return{content:e.initialPreview,config:e.initialPreviewConfig,tags:e.initialPreviewThumbTags}}},e.fn.fileinput=function(s){if(!t.hasFileAPISupport()&&!t.isIE(9))return;var i=Array.apply(null,arguments),o=[];switch(i.shift(),this.each(function(){var m,a=e(this),r=a.data("fileinput"),c=typeof s=="object"&&s,d=c.theme||a.data("theme"),u={},h={},l=c.language||a.data("language")||e.fn.fileinput.defaults.language||"en";r||(d&&(h=e.fn.fileinputThemes[d]||{}),l!=="en"&&!t.isEmpty(e.fn.fileinputLocales[l])&&(u=e.fn.fileinputLocales[l]||{}),m=e.extend(!0,{},e.fn.fileinput.defaults,h,e.fn.fileinputLocales.en,u,c,a.data()),r=new n(this,m),a.data("fileinput",r)),typeof s=="string"&&o.push(r[s].apply(r,i))}),o.length){case 0:return this;case 1:return o[0];default:return o}};var t,n,s='class="kv-preview-data file-preview-pdf" src="{renderer}?file={data}" {style}';e.fn.fileinput.defaults={language:"en",showCaption:!0,showBrowse:!0,showPreview:!0,showRemove:!0,showUpload:!0,showUploadStats:!0,showCancel:null,showPause:null,showClose:!0,showUploadedThumbs:!0,showConsoleLogs:!1,browseOnZoneClick:!1,autoReplace:!1,autoOrientImage:function(){var e=window.navigator.userAgent,t=!!e.match(/WebKit/i),n=!!e.match(/iP(od|ad|hone)/i),s=n&&t&&!e.match(/CriOS/i);return!s},autoOrientImageInitial:!0,required:!1,rtl:!1,hideThumbnailContent:!1,encodeUrl:!0,focusCaptionOnBrowse:!0,focusCaptionOnClear:!0,generateFileId:null,previewClass:"",captionClass:"",frameClass:"krajee-default",mainClass:"file-caption-main",mainTemplate:null,fileSizeGetter:null,initialCaption:"",initialPreview:[],initialPreviewDelimiter:"*$$*",initialPreviewAsData:!1,initialPreviewFileType:"image",initialPreviewConfig:[],initialPreviewThumbTags:[],previewThumbTags:{},initialPreviewShowDelete:!0,initialPreviewDownloadUrl:"",removeFromPreviewOnError:!1,deleteUrl:"",deleteExtraData:{},overwriteInitial:!0,sanitizeZoomCache:function(e){var n=t.createElement(e);return n.find("input,textarea,select,datalist,form,.file-thumbnail-footer").remove(),n.html()},previewZoomButtonIcons:{prev:'<i class="glyphicon glyphicon-triangle-left"></i>',next:'<i class="glyphicon glyphicon-triangle-right"></i>',toggleheader:'<i class="glyphicon glyphicon-resize-vertical"></i>',fullscreen:'<i class="glyphicon glyphicon-fullscreen"></i>',borderless:'<i class="glyphicon glyphicon-resize-full"></i>',close:'<i class="glyphicon glyphicon-remove"></i>'},previewZoomButtonClasses:{prev:"btn btn-navigate",next:"btn btn-navigate",toggleheader:"btn btn-sm btn-kv btn-default btn-outline-secondary",fullscreen:"btn btn-sm btn-kv btn-default btn-outline-secondary",borderless:"btn btn-sm btn-kv btn-default btn-outline-secondary",close:"btn btn-sm btn-kv btn-default btn-outline-secondary"},previewTemplates:{},previewContentTemplates:{},preferIconicPreview:!1,preferIconicZoomPreview:!1,allowedFileTypes:null,allowedFileExtensions:null,allowedPreviewTypes:void 0,allowedPreviewMimeTypes:null,allowedPreviewExtensions:null,disabledPreviewTypes:void 0,disabledPreviewExtensions:["msi","exe","com","zip","rar","app","vb","scr"],disabledPreviewMimeTypes:null,defaultPreviewContent:null,customLayoutTags:{},customPreviewTags:{},previewFileIcon:'<i class="glyphicon glyphicon-file"></i>',previewFileIconClass:"file-other-icon",previewFileIconSettings:{},previewFileExtSettings:{},buttonLabelClass:"hidden-xs",browseIcon:'<i class="glyphicon glyphicon-folder-open"></i>&nbsp;',browseClass:"btn btn-primary",removeIcon:'<i class="glyphicon glyphicon-trash"></i>',removeClass:"btn btn-default btn-secondary",cancelIcon:'<i class="glyphicon glyphicon-ban-circle"></i>',cancelClass:"btn btn-default btn-secondary",pauseIcon:'<i class="glyphicon glyphicon-pause"></i>',pauseClass:"btn btn-default btn-secondary",uploadIcon:'<i class="glyphicon glyphicon-upload"></i>',uploadClass:"btn btn-default btn-secondary",uploadUrl:null,uploadUrlThumb:null,uploadAsync:!0,uploadParamNames:{chunkCount:"chunkCount",chunkIndex:"chunkIndex",chunkSize:"chunkSize",chunkSizeStart:"chunkSizeStart",chunksUploaded:"chunksUploaded",fileBlob:"fileBlob",fileId:"fileId",fileName:"fileName",fileRelativePath:"fileRelativePath",fileSize:"fileSize",retryCount:"retryCount"},maxAjaxThreads:5,fadeDelay:800,processDelay:100,queueDelay:10,progressDelay:0,enableResumableUpload:!1,resumableUploadOptions:{fallback:null,testUrl:null,chunkSize:2*1024,maxThreads:4,maxRetries:3,showErrorLog:!0},uploadExtraData:{},zoomModalHeight:480,minImageWidth:null,minImageHeight:null,maxImageWidth:null,maxImageHeight:null,resizeImage:!1,resizePreference:"width",resizeQuality:.92,resizeDefaultImageType:"image/jpeg",resizeIfSizeMoreThan:0,minFileSize:-1,maxFileSize:0,maxFilePreviewSize:25600,minFileCount:0,maxFileCount:0,maxTotalFileCount:0,validateInitialCount:!1,msgValidationErrorClass:"text-danger",msgValidationErrorIcon:'<i class="glyphicon glyphicon-exclamation-sign"></i> ',msgErrorClass:"file-error-message",progressThumbClass:"progress-bar progress-bar-striped active progress-bar-animated",progressClass:"progress-bar bg-success progress-bar-success progress-bar-striped active progress-bar-animated",progressInfoClass:"progress-bar bg-info progress-bar-info progress-bar-striped active progress-bar-animated",progressCompleteClass:"progress-bar bg-success progress-bar-success",progressPauseClass:"progress-bar bg-primary progress-bar-primary progress-bar-striped active progress-bar-animated",progressErrorClass:"progress-bar bg-danger progress-bar-danger",progressUploadThreshold:99,previewFileType:"image",elCaptionContainer:null,elCaptionText:null,elCaptionLabelText:null,elPreviewContainer:null,elPreviewImage:null,elPreviewStatus:null,elErrorContainer:null,errorCloseButton:t.closeButton("kv-error-close"),slugCallback:null,dropZoneEnabled:!0,dropZoneTitleClass:"file-drop-zone-title",fileActionSettings:{},otherActionButtons:"",textEncoding:"UTF-8",preProcessUpload:null,ajaxSettings:{},ajaxDeleteSettings:{},showAjaxErrorDetails:!0,mergeAjaxCallbacks:!1,mergeAjaxDeleteCallbacks:!1,retryErrorUploads:!0,reversePreviewOrder:!1,usePdfRenderer:function(){var e=!!window.MSInputMethodContext&&!!document.documentMode;return!!navigator.userAgent.match(/(iPod|iPhone|iPad|Android)/i)||e},pdfRendererUrl:"",pdfRendererTemplate:"<iframe "+s+"></iframe>"},e.fn.fileinputLocales.en={fileSingle:"file",filePlural:"files",browseLabel:"Browse &hellip;",removeLabel:"Remove",removeTitle:"Clear all unprocessed files",cancelLabel:"Cancel",cancelTitle:"Abort ongoing upload",pauseLabel:"Pause",pauseTitle:"Pause ongoing upload",uploadLabel:"Upload",uploadTitle:"Upload selected files",msgNo:"No",msgNoFilesSelected:"No files selected",msgCancelled:"Cancelled",msgPaused:"Paused",msgPlaceholder:"Select {files} ...",msgZoomModalHeading:"Detailed Preview",msgFileRequired:"You must select a file to upload.",msgSizeTooSmall:'File "{name}" (<b>{size} KB</b>) is too small and must be larger than <b>{minSize} KB</b>.',msgSizeTooLarge:'File "{name}" (<b>{size} KB</b>) exceeds maximum allowed upload size of <b>{maxSize} KB</b>.',msgFilesTooLess:"You must select at least <b>{n}</b> {files} to upload.",msgFilesTooMany:"Number of files selected for upload <b>({n})</b> exceeds maximum allowed limit of <b>{m}</b>.",msgTotalFilesTooMany:"You can upload a maximum of <b>{m}</b> files (<b>{n}</b> files detected).",msgFileNotFound:'File "{name}" not found!',msgFileSecured:'Security restrictions prevent reading the file "{name}".',msgFileNotReadable:'File "{name}" is not readable.',msgFilePreviewAborted:'File preview aborted for "{name}".',msgFilePreviewError:'An error occurred while reading the file "{name}".',msgInvalidFileName:'Invalid or unsupported characters in file name "{name}".',msgInvalidFileType:'Invalid type for file "{name}". Only "{types}" files are supported.',msgInvalidFileExtension:'Invalid extension for file "{name}". Only "{extensions}" files are supported.',msgFileTypes:{image:"image",html:"HTML",text:"text",video:"video",audio:"audio",flash:"flash",pdf:"PDF",object:"object"},msgUploadAborted:"The file upload was aborted",msgUploadThreshold:"Processing &hellip;",msgUploadBegin:"Initializing &hellip;",msgUploadEnd:"Done",msgUploadResume:"Resuming upload &hellip;",msgUploadEmpty:"No valid data available for upload.",msgUploadError:"Upload Error",msgDeleteError:"Delete Error",msgProgressError:"Error",msgValidationError:"Validation Error",msgLoading:"Loading file {index} of {files} &hellip;",msgProgress:"Loading file {index} of {files} - {name} - {percent}% completed.",msgSelected:"{n} {files} selected",msgFoldersNotAllowed:"Drag & drop files only! {n} folder(s) dropped were skipped.",msgImageWidthSmall:'Width of image file "{name}" must be at least {size} px.',msgImageHeightSmall:'Height of image file "{name}" must be at least {size} px.',msgImageWidthLarge:'Width of image file "{name}" cannot exceed {size} px.',msgImageHeightLarge:'Height of image file "{name}" cannot exceed {size} px.',msgImageResizeError:"Could not get the image dimensions to resize.",msgImageResizeException:"Error while resizing the image.<pre>{errors}</pre>",msgAjaxError:"Something went wrong with the {operation} operation. Please try again later!",msgAjaxProgressError:"{operation} failed",msgDuplicateFile:'File "{name}" of same size "{size} KB" has already been selected earlier. Skipping duplicate selection.',msgResumableUploadRetriesExceeded:"Upload aborted beyond <b>{max}</b> retries for file <b>{file}</b>! Error Details: <pre>{error}</pre>",msgPendingTime:"{time} remaining",msgCalculatingTime:"calculating time remaining",ajaxOperations:{deleteThumb:"file delete",uploadThumb:"file upload",uploadBatch:"batch file upload",uploadExtra:"form data upload"},dropZoneTitle:"Drag & drop files here &hellip;",dropZoneClickTitle:"<br>(or click to select {files})",previewZoomButtonTitles:{prev:"View previous file",next:"View next file",toggleheader:"Toggle header",fullscreen:"Toggle full screen",borderless:"Toggle borderless mode",close:"Close detailed preview"}},e.fn.fileinput.Constructor=n,e(document).ready(function(){var t=e("input.file[type=file]");t.length&&t.fileinput()})});
