"""Add WebMonitorGroupJob model

Revision ID: 30369bb8ae01
Revises: 67d0e389b003
Create Date: 2025-09-04 13:18:41.306744

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "30369bb8ae01"
down_revision = "67d0e389b003"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "web_monitor_group_job",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column("group_id", sa.String(), nullable=False, unique=True),
        sa.Column(
            "raw_experiences_data",
            postgresql.JSONB(astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column(
            "processed_experiences_data",
            postgresql.JSONB(astext_type=sa.Text()),
            nullable=True,
        ),
        sa.Column("is_test_run", sa.Boolean(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("group_id"),
    )
    op.create_index(
        op.f("ix_web_monitor_group_job_id"),
        "web_monitor_group_job",
        ["id"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_web_monitor_group_job_id"), table_name="web_monitor_group_job"
    )
    op.drop_table("web_monitor_group_job")
    # ### end Alembic commands ###
