"""adds auto_subdomain_cookie_deletion on experience config, migrate to write initial val of false

Revision ID: 36ad82edb38e
Revises: 5dafbc1818ae
Create Date: 2024-10-07 19:30:03.559747

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "36ad82edb38e"
down_revision = "5dafbc1818ae"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "experienceconfigtemplate",
        sa.Column(
            "auto_subdomain_cookie_deletion",
            sa.Boolean(),
            server_default="t",
            nullable=False,
        ),
    )
    op.add_column(
        "privacyexperienceconfig",
        sa.Column(
            "auto_subdomain_cookie_deletion",
            sa.Boolean(),
            server_default="t",
            nullable=False,
        ),
    )
    op.add_column(
        "privacyexperienceconfighistory",
        sa.Column(
            "auto_subdomain_cookie_deletion",
            sa.Boolean(),
            nullable=True,
        ),
    )

    # Updates all existing privacy experience configs to be False. Moving forward this will be set to True by default.
    op.execute(
        "UPDATE privacyexperienceconfig SET auto_subdomain_cookie_deletion = FALSE"
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("privacyexperienceconfig", "auto_subdomain_cookie_deletion")
    op.drop_column("experienceconfigtemplate", "auto_subdomain_cookie_deletion")
    op.drop_column("privacyexperienceconfighistory", "auto_subdomain_cookie_deletion")
    # ### end Alembic commands ###
