"""add_system_foreign_key_to_connection_config

Revision ID: 5b4b9c2d1c93
Revises: a08024ba7e2b
Create Date: 2023-01-13 19:39:11.936347

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "5b4b9c2d1c93"
down_revision = "a08024ba7e2b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "connectionconfig", sa.Column("system_id", sa.String(), nullable=True)
    )
    op.create_index(
        op.f("ix_connectionconfig_system_id"),
        "connectionconfig",
        ["system_id"],
        unique=False,
    )
    op.create_foreign_key(
        "connectionconfig_system_id_fkey",
        "connectionconfig",
        "ctl_systems",
        ["system_id"],
        ["id"],
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(
        "connectionconfig_system_id_fkey", "connectionconfig", type_="foreignkey"
    )
    op.drop_index(op.f("ix_connectionconfig_system_id"), table_name="connectionconfig")
    op.drop_column("connectionconfig", "system_id")
    # ### end Alembic commands ###
