"""Add classification benchmark table

Revision ID: a8e0c016afd
Revises: 4d8c0fcc5771
Create Date: 2024-12-19 12:00:00.000000

"""

import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "a8e0c016afd"
down_revision = "4d8c0fcc5771"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "classification_benchmark",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column(
            "created_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "updated_at",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "monitor_config_key",
            sa.String(),
            sa.ForeignKey("monitorconfig.key", ondelete="CASCADE"),
            nullable=False,
        ),
        sa.Column(
            "dataset_fides_key",
            sa.String(),
            sa.ForeignKey("ctl_datasets.fides_key", ondelete="CASCADE"),
            nullable=False,
        ),
        sa.Column(
            "resource_urns",
            postgresql.ARRAY(sa.String()),
            nullable=False,
            server_default="{}",
        ),
        sa.Column(
            "overall_metrics",
            postgresql.JSONB(astext_type=sa.Text()),
            nullable=True,
            server_default=None,
        ),
        sa.Column(
            "field_accuracy_details",
            postgresql.ARRAY(postgresql.JSONB(astext_type=sa.Text())),
            nullable=False,
            server_default="{}",
        ),
        sa.Column(
            "status",
            sa.String(length=50),
            nullable=False,
            server_default="pending",
        ),
        sa.Column(
            "messages",
            postgresql.ARRAY(sa.String()),
            nullable=False,
            server_default="{}",
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_classification_benchmark_id"),
        "classification_benchmark",
        ["id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_classification_benchmark_monitor_config_key"),
        "classification_benchmark",
        ["monitor_config_key"],
        unique=False,
    )
    op.create_index(
        op.f("ix_classification_benchmark_dataset_fides_key"),
        "classification_benchmark",
        ["dataset_fides_key"],
        unique=False,
    )
    op.create_index(
        op.f("ix_classification_benchmark_status"),
        "classification_benchmark",
        ["status"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_classification_benchmark_status"),
        table_name="classification_benchmark",
    )
    op.drop_index(
        op.f("ix_classification_benchmark_dataset_fides_key"),
        table_name="classification_benchmark",
    )
    op.drop_index(
        op.f("ix_classification_benchmark_monitor_config_key"),
        table_name="classification_benchmark",
    )
    op.drop_index(
        op.f("ix_classification_benchmark_id"), table_name="classification_benchmark"
    )
    op.drop_table("classification_benchmark")
    # ### end Alembic commands ###
