# 키움증권 API 문서

## 국내주식 REST API

### 계좌 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### TR 목록
- **일자별종목별실현손익요청_일자** (ka10072)
- **일자별종목별실현손익요청_기간** (ka10073)
- **일자별실현손익요청** (ka10074)
- **미체결요청** (ka10075)
- **체결요청** (ka10076)
- **당일실현손익상세요청** (ka10077)
- **계좌수익률요청** (ka10085)
- **미체결 분할주문 상세** (ka10088)
- **당일매매일지요청** (ka10170)
- **예수금상세현황요청** (kt00001)
- **일별추정예탁자산현황요청** (kt00002)
- **추정자산조회요청** (kt00003)
- **계좌평가현황요청** (kt00004)
- **체결잔고요청** (kt00005)
- **계좌별주문체결내역상세요청** (kt00007)
- **계좌별익일결제예정내역요청** (kt00008)
- **계좌별주문체결현황요청** (kt00009)
- **주문인출가능금액요청** (kt00010)
- **증거금율별주문가능수량조회요청** (kt00011)
- **신용보증금율별주문가능수량조회요청** (kt00012)
- **증거금세부내역조회요청** (kt00013)
- **위탁종합거래내역요청** (kt00015)
- **일별계좌수익률상세현황요청** (kt00016)
- **계좌별당일현황요청** (kt00017)
- **계좌평가잔고내역요청** (kt00018)

--

#### 일자별종목별실현손익요청_일자 (ka10072)

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_cd | 종목코드 | String | Y | 6 | |
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| dt_stk_div_rlzt_pl | 일자별종목별실현손익 | LIST | N | - | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cntr_qty | 체결량 | String | N | 20 | |
| - buy_uv | 매입단가 | String | N | 20 | |
| - cntr_pric | 체결가 | String | N | 20 | |
| - tdy_sel_pl | 당일매도손익 | String | N | 20 | |
| - pl_rt | 손익율 | String | N | 20 | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |
| - wthd_alowa | 인출가능금액 | String | N | 20 | |
| - loan_dt | 대출일 | String | N | 20 | |
| - crd_tp | 신용구분 | String | N | 20 | |
| - stk_cd_1 | 종목코드1 | String | N | 20 | |
| - tdy_sel_pl_1 | 당일매도손익1 | String | N | 20 | |

---

## 일자별종목별실현손익요청_기간 (ka10073)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_cd | 종목코드 | String | Y | 6 | |
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료일자 | String | Y | 8 | YYYYMMDD |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| dt_stk_rlzt_pl | 일자별종목별실현손익 | LIST | N | - | |
| - dt | 일자 | String | N | 20 | |
| - tdy_htssel_cmsn | 당일hts매도수수료 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cntr_qty | 체결량 | String | N | 20 | |
| - buy_uv | 매입단가 | String | N | 20 | |
| - cntr_pric | 체결가 | String | N | 20 | |
| - tdy_sel_pl | 당일매도손익 | String | N | 20 | |
| - pl_rt | 손익율 | String | N | 20 | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |
| - wthd_alowa | 인출가능금액 | String | N | 20 | |
| - loan_dt | 대출일 | String | N | 20 | |
| - crd_tp | 신용구분 | String | N | 20 | |

### Python 예제 코드

```python
import requests
import json

# 일자별종목별실현손익요청_기간
def fn_ka10073(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10073', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'stk_cd': '005930', # 종목코드 
        'strt_dt': '20241128', # 시작일자 YYYYMMDD
        'end_dt': '20241128', # 종료일자 YYYYMMDD
    }

    # 3. API 실행
    fn_ka10073(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10073(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "stk_cd" : "005930",
    "strt_dt" : "20241128",
    "end_dt" : "20241128"
}
```

#### Response
```json
{
    "dt_stk_rlzt_pl": [
        {
            "dt":"20241128",
            "tdy_htssel_cmsn":"현금",
            "stk_nm":"삼성전자",
            "cntr_qty":"1",
            "buy_uv":"97602.96",
            "cntr_pric":"158200",
            "tdy_sel_pl":"59813.04",
            "pl_rt":"+61.28",
            "stk_cd":"A005930",
            "tdy_trde_cmsn":"500",
            "tdy_trde_tax":"284",
            "wthd_alowa":"0",
            "loan_dt":"",
            "crd_tp":"현금잔고"
        },
        {
            "dt":"20241128",
            "tdy_htssel_cmsn":"현금",
            "stk_nm":"삼성전자",
            "cntr_qty":"1",
            "buy_uv":"97602.96",
            "cntr_pric":"158200",
            "tdy_sel_pl":"59813.04",
            "pl_rt":"+61.28",
            "stk_cd":"A005930",
            "tdy_trde_cmsn":"500",
            "tdy_trde_tax":"284",
            "wthd_alowa":"0",
            "loan_dt":"",
            "crd_tp":"현금잔고"
        },
        {
            "dt":"20241128",
            "tdy_htssel_cmsn":"현금",
            "stk_nm":"삼성전자",
            "cntr_qty":"1",
            "buy_uv":"97602.96",
            "cntr_pric":"158200",
            "tdy_sel_pl":"59813.04",
            "pl_rt":"+61.28",
            "stk_cd":"A005930",
            "tdy_trde_cmsn":"500",
            "tdy_trde_tax":"284",
            "wthd_alowa":"0",
            "loan_dt":"",
            "crd_tp":"현금잔고"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 일자별실현손익요청 (ka10074)

**⚠️ 주의사항:** 실현손익이 발생한 일자에대해서만 데이터가 채워짐.

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료일자 | String | Y | 8 | YYYYMMDD |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| tot_buy_amt | 총매수금액 | String | N | - | |
| tot_sell_amt | 총매도금액 | String | N | - | |
| rlzt_pl | 실현손익 | String | N | - | |
| trde_cmsn | 매매수수료 | String | N | - | |
| trde_tax | 매매세금 | String | N | - | |
| dt_rlzt_pl | 일자별실현손익 | LIST | N | - | |
| - dt | 일자 | String | N | 20 | |
| - buy_amt | 매수금액 | String | N | 20 | |
| - sell_amt | 매도금액 | String | N | 20 | |
| - tdy_sel_pl | 당일매도손익 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |

### Python 예제 코드

```python
import requests
import json

# 일자별실현손익요청
def fn_ka10074(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10074', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'strt_dt': '20241128', # 시작일자 
        'end_dt': '20241128', # 종료일자 
    }

    # 3. API 실행
    fn_ka10074(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10074(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "strt_dt" : "20241128",
    "end_dt" : "20241128"
}
```

#### Response
```json
{
    "tot_buy_amt":"0",
    "tot_sell_amt":"474600",
    "rlzt_pl":"179419",
    "trde_cmsn":"940",
    "trde_tax":"852",
    "dt_rlzt_pl": [
        {
            "dt":"20241128",
            "buy_amt":"0",
            "sell_amt":"474600",
            "tdy_sel_pl":"179419",
            "tdy_trde_cmsn":"940",
            "tdy_trde_tax":"852"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 미체결요청 (ka10075)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| all_stk_tp | 전체종목구분 | String | Y | 1 | 0:전체, 1:종목 |
| trde_tp | 매매구분 | String | Y | 1 | 0:전체, 1:매도, 2:매수 |
| stk_cd | 종목코드 | String | N | 6 | |
| stex_tp | 거래소구분 | String | Y | 1 | 0:통합, 1:KRX, 2:NXT |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| oso | 미체결 | LIST | N | - | |
| - acnt_no | 계좌번호 | String | N | 20 | |
| - ord_no | 주문번호 | String | N | 20 | |
| - mang_empno | 관리사번 | String | N | 20 | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - tsk_tp | 업무구분 | String | N | 20 | |
| - ord_stt | 주문상태 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - ord_qty | 주문수량 | String | N | 20 | |
| - ord_pric | 주문가격 | String | N | 20 | |
| - oso_qty | 미체결수량 | String | N | 20 | |
| - cntr_tot_amt | 체결누계금액 | String | N | 20 | |
| - orig_ord_no | 원주문번호 | String | N | 20 | |
| - io_tp_nm | 주문구분 | String | N | 20 | |
| - trde_tp | 매매구분 | String | N | 20 | |
| - tm | 시간 | String | N | 20 | |
| - cntr_no | 체결번호 | String | N | 20 | |
| - cntr_pric | 체결가 | String | N | 20 | |
| - cntr_qty | 체결량 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - sel_bid | 매도호가 | String | N | 20 | |
| - buy_bid | 매수호가 | String | N | 20 | |
| - unit_cntr_pric | 단위체결가 | String | N | 20 | |
| - unit_cntr_qty | 단위체결량 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |
| - ind_invsr | 개인투자자 | String | N | 20 | |
| - stex_tp | 거래소구분 | String | N | 20 | 0:통합, 1:KRX, 2:NXT |
| - stex_tp_txt | 거래소구분텍스트 | String | N | 20 | 통합,KRX,NXT |
| - sor_yn | SOR 여부값 | String | N | 20 | Y,N |
| - stop_pric | 스톱가 | String | N | 20 | 스톱지정가주문 스톱가 |

### Python 예제 코드

```python
import requests
import json

# 미체결요청
def fn_ka10075(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10075', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'all_stk_tp': '1', # 전체종목구분 0:전체, 1:종목
        'trde_tp': '0', # 매매구분 0:전체, 1:매도, 2:매수
        'stk_cd': '005930', # 종목코드 
        'stex_tp': '0', # 거래소구분 0 : 통합, 1 : KRX, 2 : NXT
    }

    # 3. API 실행
    fn_ka10075(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10075(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "all_stk_tp" : "1",
    "trde_tp" : "0",
    "stk_cd" : "005930",
    "stex_tp" : "0"
}
```

#### Response
```json
{
    "oso": [
        {
            "acnt_no":"1234567890",
            "ord_no":"0000069",
            "mang_empno":"",
            "stk_cd":"005930",
            "tsk_tp":"",
            "ord_stt":"접수",
            "stk_nm":"삼성전자",
            "ord_qty":"1",
            "ord_pric":"0",
            "oso_qty":"1",
            "cntr_tot_amt":"0",
            "orig_ord_no":"0000000",
            "io_tp_nm":"+매수",
            "trde_tp":"시장가",
            "tm":"154113",
            "cntr_no":"",
            "cntr_pric":"0",
            "cntr_qty":"0",
            "cur_prc":"+74100",
            "sel_bid":"0",
            "buy_bid":"+74100",
            "unit_cntr_pric":"",
            "unit_cntr_qty":"",
            "tdy_trde_cmsn":"0",
            "tdy_trde_tax":"0",
            "ind_invsr":"",
            "stex_tp":"1",
            "stex_tp_txt":"KRX",
            "sor_yn":"N"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 체결요청 (ka10076)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_cd | 종목코드 | String | N | 6 | |
| qry_tp | 조회구분 | String | Y | 1 | 0:전체, 1:종목 |
| sell_tp | 매도수구분 | String | Y | 1 | 0:전체, 1:매도, 2:매수 |
| ord_no | 주문번호 | String | N | 10 | 검색 기준 값으로 입력한 주문번호 보다 과거에 체결된 내역이 조회됩니다. |
| stex_tp | 거래소구분 | String | Y | 1 | 0:통합, 1:KRX, 2:NXT |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cntr | 체결 | LIST | N | - | |
| - ord_no | 주문번호 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - io_tp_nm | 주문구분 | String | N | 20 | |
| - ord_pric | 주문가격 | String | N | 20 | |
| - ord_qty | 주문수량 | String | N | 20 | |
| - cntr_pric | 체결가 | String | N | 20 | |
| - cntr_qty | 체결량 | String | N | 20 | |
| - oso_qty | 미체결수량 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |
| - ord_stt | 주문상태 | String | N | 20 | |
| - trde_tp | 매매구분 | String | N | 20 | |
| - orig_ord_no | 원주문번호 | String | N | 20 | |
| - ord_tm | 주문시간 | String | N | 20 | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stex_tp | 거래소구분 | String | N | 20 | 0:통합, 1:KRX, 2:NXT |
| - stex_tp_txt | 거래소구분텍스트 | String | N | 20 | 통합,KRX,NXT |
| - sor_yn | SOR 여부값 | String | N | 20 | Y,N |
| - stop_pric | 스톱가 | String | N | 20 | 스톱지정가주문 스톱가 |

### Python 예제 코드

```python
import requests
import json

# 체결요청
def fn_ka10076(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10076', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'stk_cd': '005930', # 종목코드 
        'qry_tp': '1', # 조회구분 0:전체, 1:종목
        'sell_tp': '0', # 매도수구분 0:전체, 1:매도, 2:매수
        'ord_no': '', # 주문번호 검색 기준 값으로 입력한 주문번호 보다 과거에 체결된 내역이 조회됩니다. 
        'stex_tp': '0', # 거래소구분  0 : 통합, 1 : KRX, 2 : NXT
    }

    # 3. API 실행
    fn_ka10076(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10076(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "stk_cd" : "005930",
    "qry_tp" : "1",
    "sell_tp" : "0",
    "ord_no" : "",
    "stex_tp" : "0"
}
```

#### Response
```json
{
    "cntr": [
        {
            "ord_no":"0000037",
            "stk_nm":"삼성전자",
            "io_tp_nm":"-매도",
            "ord_pric":"158200",
            "ord_qty":"1",
            "cntr_pric":"158200",
            "cntr_qty":"1",
            "oso_qty":"0",
            "tdy_trde_cmsn":"310",
            "tdy_trde_tax":"284",
            "ord_stt":"체결",
            "trde_tp":"보통",
            "orig_ord_no":"0000000",
            "ord_tm":"153815",
            "stk_cd":"005930",
            "stex_tp":"0",
            "stex_tp_txt":"SOR",
            "sor_yn":"Y"
        },
        {
            "ord_no":"0000036",
            "stk_nm":"삼성전자",
            "io_tp_nm":"-매도",
            "ord_pric":"158200",
            "ord_qty":"1",
            "cntr_pric":"158200",
            "cntr_qty":"1",
            "oso_qty":"0",
            "tdy_trde_cmsn":"310",
            "tdy_trde_tax":"284",
            "ord_stt":"체결",
            "trde_tp":"보통",
            "orig_ord_no":"0000000",
            "ord_tm":"153806",
            "stk_cd":"005930",
            "stex_tp":"0",
            "stex_tp_txt":"SOR",
            "sor_yn":"Y"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 당일실현손익상세요청 (ka10077)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_cd | 종목코드 | String | Y | 6 | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| tdy_rlzt_pl | 당일실현손익 | String | N | - | |
| tdy_rlzt_pl_dtl | 당일실현손익상세 | LIST | N | - | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cntr_qty | 체결량 | String | N | 20 | |
| - buy_uv | 매입단가 | String | N | 20 | |
| - cntr_pric | 체결가 | String | N | 20 | |
| - tdy_sel_pl | 당일매도손익 | String | N | 20 | |
| - pl_rt | 손익율 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |
| - stk_cd | 종목코드 | String | N | 20 | |

### Python 예제 코드

```python
import requests
import json

# 당일실현손익상세요청
def fn_ka10077(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10077', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'stk_cd': '005930', # 종목코드 
    }

    # 3. API 실행
    fn_ka10077(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10077(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "stk_cd" : "005930"
}
```

#### Response
```json
{
    "tdy_rlzt_pl":"179439",
    "tdy_rlzt_pl_dtl": [
        {
            "stk_nm":"삼성전자",
            "cntr_qty":"1",
            "buy_uv":"97602.9573459",
            "cntr_pric":"158200",
            "tdy_sel_pl":"59813.0426541",
            "pl_rt":"+61.28",
            "tdy_trde_cmsn":"500",
            "tdy_trde_tax":"284",
            "stk_cd":"A005930"
        },
        {
            "stk_nm":"삼성전자",
            "cntr_qty":"1",
            "buy_uv":"97602.9573459",
            "cntr_pric":"158200",
            "tdy_sel_pl":"59813.0426541",
            "pl_rt":"+61.28",
            "tdy_trde_cmsn":"500",
            "tdy_trde_tax":"284",
            "stk_cd":"A005930"
        },
        {
            "stk_nm":"삼성전자",
            "cntr_qty":"1",
            "buy_uv":"97602.9573459",
            "cntr_pric":"158200",
            "tdy_sel_pl":"59813.0426541",
            "pl_rt":"+61.28",
            "tdy_trde_cmsn":"500",
            "tdy_trde_tax":"284",
            "stk_cd":"A005930"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 계좌수익률요청 (ka10085)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stex_tp | 거래소구분 | String | Y | 1 | 0:통합, 1:KRX, 2:NXT |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| acnt_prft_rt | 계좌수익률 | LIST | N | - | |
| - dt | 일자 | String | N | 20 | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pur_pric | 매입가 | String | N | 20 | |
| - pur_amt | 매입금액 | String | N | 20 | |
| - rmnd_qty | 보유수량 | String | N | 20 | |
| - tdy_sel_pl | 당일매도손익 | String | N | 20 | |
| - tdy_trde_cmsn | 당일매매수수료 | String | N | 20 | |
| - tdy_trde_tax | 당일매매세금 | String | N | 20 | |
| - crd_tp | 신용구분 | String | N | 20 | |
| - loan_dt | 대출일 | String | N | 20 | |
| - setl_remn | 결제잔고 | String | N | 20 | |
| - clrn_alow_qty | 청산가능수량 | String | N | 20 | |
| - crd_amt | 신용금액 | String | N | 20 | |
| - crd_int | 신용이자 | String | N | 20 | |
| - expr_dt | 만기일 | String | N | 20 | |

### Python 예제 코드

```python
import requests
import json

# 계좌수익률요청
def fn_ka10085(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10085', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'stex_tp': '0', # 거래소구분  0 : 통합, 1 : KRX, 2 : NXT
    }

    # 3. API 실행
    fn_ka10085(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10085(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "stex_tp" : "0"
}
```

#### Response
```json
{
    "acnt_prft_rt": [
        {
            "dt":"",
            "stk_cd":"005930",
            "stk_nm":"삼성전자",
            "cur_prc":"-63000",
            "pur_pric":"124500",
            "pur_amt":"373500",
            "rmnd_qty":"3",
            "tdy_sel_pl":"0",
            "tdy_trde_cmsn":"0",
            "tdy_trde_tax":"0",
            "crd_tp":"00",
            "loan_dt":"00000000",
            "setl_remn":"3",
            "clrn_alow_qty":"3",
            "crd_amt":"0",
            "crd_int":"0",
            "expr_dt":"00000000"
        },
        {
            "dt":"",
            "stk_cd":"005930",
            "stk_nm":"삼성전자",
            "cur_prc":"+256500",
            "pur_pric":"209179",
            "pur_amt":"1673429",
            "rmnd_qty":"8",
            "tdy_sel_pl":"0",
            "tdy_trde_cmsn":"0",
            "tdy_trde_tax":"0",
            "crd_tp":"00",
            "loan_dt":"00000000",
            "setl_remn":"8",
            "clrn_alow_qty":"8",
            "crd_amt":"0",
            "crd_int":"0",
            "expr_dt":"00000000"
        },
        {
            "dt":"",
            "stk_cd":"005930",
            "stk_nm":"삼성전자",
            "cur_prc":"+156600",
            "pur_pric":"97603",
            "pur_amt":"3513706",
            "rmnd_qty":"36",
            "tdy_sel_pl":"0",
            "tdy_trde_cmsn":"0",
            "tdy_trde_tax":"0",
            "crd_tp":"00",
            "loan_dt":"00000000",
            "setl_remn":"39",
            "clrn_alow_qty":"36",
            "crd_amt":"0",
            "crd_int":"0",
            "expr_dt":"00000000"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 미체결 분할주문 상세 (ka10088)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| ord_no | 주문번호 | String | Y | 20 | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| osop | 미체결분할주문리스트 | LIST | N | - | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - ord_no | 주문번호 | String | N | 20 | |
| - ord_qty | 주문수량 | String | N | 20 | |
| - ord_pric | 주문가격 | String | N | 20 | |
| - osop_qty | 미체결수량 | String | N | 20 | |
| - io_tp_nm | 주문구분 | String | N | 20 | |
| - trde_tp | 매매구분 | String | N | 20 | |
| - sell_tp | 매도/수 구분 | String | N | 20 | |
| - cntr_qty | 체결량 | String | N | 20 | |
| - ord_stt | 주문상태 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - stex_tp | 거래소구분 | String | N | 20 | 0:통합, 1:KRX, 2:NXT |
| - stex_tp_txt | 거래소구분텍스트 | String | N | 20 | 통합,KRX,NXT |

### Python 예제 코드

```python
import requests
import json

# 미체결 분할주문 상세
def fn_ka10088(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10088', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'ord_no': '8', # 주문번호 
    }

    # 3. API 실행
    fn_ka10088(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10088(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "ord_no" : "8"
}
```

#### Response
```json
{
    "osop": [
        {
            "stk_cd": "005930",
            "acnt_no": "1234567890",
            "stk_nm": "삼성전자",
            "ord_no": "0000008",
            "ord_qty": "1",
            "ord_pric": "5150",
            "osop_qty": "1",
            "io_tp_nm": "+매수정정",
            "trde_tp": "보통",
            "sell_tp": "2",
            "cntr_qty": "0",
            "ord_stt": "접수",
            "cur_prc": "5250",
            "stex_tp": "1",
            "stex_tp_txt": "S-KRX"
        }
    ],
    "return_code": 0,
    "return_msg": " 조회가 완료되었습니다."
}
```

---

## 당일매매일지요청 (ka10170)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| base_dt | 기준일자 | String | N | 8 | YYYYMMDD (공백입력시 금일데이터, 최근 2개월까지 제공) |
| ottks_tp | 단주구분 | String | Y | 1 | 1:당일매수에 대한 당일매도, 2:당일매도 전체 |
| ch_crd_tp | 현금신용구분 | String | Y | 1 | 0:전체, 1:현금매매만, 2:신용매매만 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| tot_sell_amt | 총매도금액 | String | N | - | |
| tot_buy_amt | 총매수금액 | String | N | - | |
| tot_cmsn_tax | 총수수료_세금 | String | N | - | |
| tot_exct_amt | 총정산금액 | String | N | - | |
| tot_pl_amt | 총손익금액 | String | N | - | |
| tot_prft_rt | 총수익률 | String | N | - | |
| tdy_trde_diary | 당일매매일지 | LIST | N | - | |
| - stk_nm | 종목명 | String | N | 20 | |
| - buy_avg_pric | 매수평균가 | String | N | - | |
| - buy_qty | 매수수량 | String | N | - | |
| - sel_avg_pric | 매도평균가 | String | N | - | |
| - sell_qty | 매도수량 | String | N | - | |
| - cmsn_alm_tax | 수수료_제세금 | String | N | - | |
| - pl_amt | 손익금액 | String | N | - | |
| - sell_amt | 매도금액 | String | N | - | |
| - buy_amt | 매수금액 | String | N | - | |
| - prft_rt | 수익률 | String | N | - | |
| - stk_cd | 종목코드 | String | N | 6 | |

### Python 예제 코드

```python
import requests
import json

# 당일매매일지요청
def fn_ka10170(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'ka10170', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'base_dt': '20241120', # 기준일자 YYYYMMDD(공백입력시 금일데이터,최근 2개월까지 제공)
        'ottks_tp': '1', # 단주구분 1:당일매수에 대한 당일매도,2:당일매도 전체
        'ch_crd_tp': '0', # 현금신용구분 0:전체, 1:현금매매만, 2:신용매매만
    }

    # 3. API 실행
    fn_ka10170(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_ka10170(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "base_dt" : "20241120",
    "ottks_tp" : "1",
    "ch_crd_tp" : "0"
}
```

#### Response
```json
{
    "tot_sell_amt":"48240",
    "tot_buy_amt":"48240",
    "tot_cmsn_tax":"174",
    "tot_exct_amt":"-174",
    "tot_pl_amt":"-174",
    "tot_prft_rt":"-0.36",
    "tdy_trde_diary": [
        {
            "stk_nm":"삼성전자",
            "buy_avg_pric":"16080",
            "buy_qty":"3",
            "sel_avg_pric":"16080",
            "sell_qty":"3",
            "cmsn_alm_tax":"174",
            "pl_amt":"-174",
            "sell_amt":"48240",
            "buy_amt":"48240",
            "prft_rt":"-0.36",
            "stk_cd":"005930"
        }
    ],
    "return_code":0,
    "return_msg":" 조회가 완료되었습니다."
}
```

---

## 예수금상세현황요청 (kt00001)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| qry_tp | 조회구분 | String | Y | 1 | 3:추정조회, 2:일반조회 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| entr | 예수금 | String | N | 15 | |
| profa_ch | 주식증거금현금 | String | N | 15 | |
| bncr_profa_ch | 수익증권증거금현금 | String | N | 15 | |
| nxdy_bncr_sell_exct | 익일수익증권매도정산대금 | String | N | 15 | |
| fc_stk_krw_repl_set_amt | 해외주식원화대용설정금 | String | N | 15 | |
| crd_grnta_ch | 신용보증금현금 | String | N | 15 | |
| crd_grnt_ch | 신용담보금현금 | String | N | 15 | |
| add_grnt_ch | 추가담보금현금 | String | N | 15 | |
| etc_profa | 기타증거금 | String | N | 15 | |
| uncl_stk_amt | 미수확보금 | String | N | 15 | |
| shrts_prica | 공매도대금 | String | N | 15 | |
| crd_set_grnta | 신용설정평가금 | String | N | 15 | |
| chck_ina_amt | 수표입금액 | String | N | 15 | |
| etc_chck_ina_amt | 기타수표입금액 | String | N | 15 | |
| crd_grnt_ruse | 신용담보재사용 | String | N | 15 | |
| knx_asset_evltv | 코넥스기본예탁금 | String | N | 15 | |
| elwdpst_evlta | ELW예탁평가금 | String | N | 15 | |
| crd_ls_rght_frcs_amt | 신용대주권리예정금액 | String | N | 15 | |
| lvlh_join_amt | 생계형가입금액 | String | N | 15 | |
| lvlh_trns_alowa | 생계형입금가능금액 | String | N | 15 | |
| repl_amt | 대용금평가금액(합계) | String | N | 15 | |
| remn_repl_evlta | 잔고대용평가금액 | String | N | 15 | |
| trst_remn_repl_evlta | 위탁대용잔고평가금액 | String | N | 15 | |
| bncr_remn_repl_evlta | 수익증권대용평가금액 | String | N | 15 | |
| profa_repl | 위탁증거금대용 | String | N | 15 | |
| crd_grnta_repl | 신용보증금대용 | String | N | 15 | |
| crd_grnt_repl | 신용담보금대용 | String | N | 15 | |
| add_grnt_repl | 추가담보금대용 | String | N | 15 | |
| rght_repl_amt | 권리대용금 | String | N | 15 | |
| pymn_alow_amt | 출금가능금액 | String | N | 15 | |
| wrap_pymn_alow_amt | 랩출금가능금액 | String | N | 15 | |
| ord_alow_amt | 주문가능금액 | String | N | 15 | |
| bncr_buy_alowa | 수익증권매수가능금액 | String | N | 15 | |
| 20stk_ord_alow_amt | 20%종목주문가능금액 | String | N | 15 | |
| 30stk_ord_alow_amt | 30%종목주문가능금액 | String | N | 15 | |
| 40stk_ord_alow_amt | 40%종목주문가능금액 | String | N | 15 | |
| 100stk_ord_alow_amt | 100%종목주문가능금액 | String | N | 15 | |
| ch_uncla | 현금미수금 | String | N | 15 | |
| ch_uncla_dlfe | 현금미수연체료 | String | N | 15 | |
| ch_uncla_tot | 현금미수금합계 | String | N | 15 | |
| crd_int_npay | 신용이자미납 | String | N | 15 | |
| int_npay_amt_dlfe | 신용이자미납연체료 | String | N | 15 | |
| int_npay_amt_tot | 신용이자미납합계 | String | N | 15 | |
| etc_loana | 기타대여금 | String | N | 15 | |
| etc_loana_dlfe | 기타대여금연체료 | String | N | 15 | |
| etc_loan_tot | 기타대여금합계 | String | N | 15 | |
| nrpy_loan | 미상환융자금 | String | N | 15 | |
| loan_sum | 융자금합계 | String | N | 15 | |
| ls_sum | 대주금합계 | String | N | 15 | |
| crd_grnt_rt | 신용담보비율 | String | N | 15 | |
| mdstrm_usfe | 중도이용료 | String | N | 15 | |
| min_ord_alow_yn | 최소주문가능금액 | String | N | 15 | |
| loan_remn_evlt_amt | 대출총평가금액 | String | N | 15 | |
| dpst_grntl_remn | 예탁담보대출잔고 | String | N | 15 | |
| sell_grntl_remn | 매도담보대출잔고 | String | N | 15 | |
| d1_entra | d+1추정예수금 | String | N | 15 | |
| d1_slby_exct_amt | d+1매도매수정산금 | String | N | 15 | |
| d1_buy_exct_amt | d+1매수정산금 | String | N | 15 | |
| d1_out_rep_mor | d+1미수변제소요금 | String | N | 15 | |
| d1_sel_exct_amt | d+1매도정산금 | String | N | 15 | |
| d1_pymn_alow_amt | d+1출금가능금액 | String | N | 15 | |
| d2_entra | d+2추정예수금 | String | N | 15 | |
| d2_slby_exct_amt | d+2매도매수정산금 | String | N | 15 | |
| d2_buy_exct_amt | d+2매수정산금 | String | N | 15 | |
| d2_out_rep_mor | d+2미수변제소요금 | String | N | 15 | |
| d2_sel_exct_amt | d+2매도정산금 | String | N | 15 | |
| d2_pymn_alow_amt | d+2출금가능금액 | String | N | 15 | |
| 50stk_ord_alow_amt | 50%종목주문가능금액 | String | N | 15 | |
| 60stk_ord_alow_amt | 60%종목주문가능금액 | String | N | 15 | |
| stk_entr_prst | 종목별예수금 | LIST | N | - | |
| - crnc_cd | 통화코드 | String | N | 3 | |
| - fx_entr | 외화예수금 | String | N | 15 | |
| - fc_krw_repl_evlta | 원화대용평가금 | String | N | 15 | |
| - fc_trst_profa | 해외주식증거금 | String | N | 15 | |
| - pymn_alow_amt | 출금가능금액 | String | N | 15 | |
| - pymn_alow_amt_entr | 출금가능금액(예수금) | String | N | 15 | |
| - ord_alow_amt_entr | 주문가능금액(예수금) | String | N | 15 | |
| - fc_uncla | 외화미수(합계) | String | N | 15 | |
| - fc_ch_uncla | 외화현금미수금 | String | N | 15 | |
| - dly_amt | 연체료 | String | N | 15 | |
| - d1_fx_entr | d+1외화예수금 | String | N | 15 | |
| - d2_fx_entr | d+2외화예수금 | String | N | 15 | |
| - d3_fx_entr | d+3외화예수금 | String | N | 15 | |
| - d4_fx_entr | d+4외화예수금 | String | N | 15 | |

### Python 예제 코드

```python
import requests
import json

# 예수금상세현황요청
def fn_kt00001(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00001', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'qry_tp': '3', # 조회구분 3:추정조회, 2:일반조회
    }

    # 3. API 실행
    fn_kt00001(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00001(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "qry_tp" : "3"
}
```

#### Response
```json
{
    "entr":"000000000017534",
    "profa_ch":"000000000032193",
    "bncr_profa_ch":"000000000000000",
    "nxdy_bncr_sell_exct":"000000000000000",
    "fc_stk_krw_repl_set_amt":"000000000000000",
    "crd_grnta_ch":"000000000000000",
    "crd_grnt_ch":"000000000000000",
    "add_grnt_ch":"000000000000000",
    "etc_profa":"000000000000000",
    "uncl_stk_amt":"000000000000000",
    "shrts_prica":"000000000000000",
    "crd_set_grnta":"000000000000000",
    "chck_ina_amt":"000000000000000",
    "etc_chck_ina_amt":"000000000000000",
    "crd_grnt_ruse":"000000000000000",
    "knx_asset_evltv":"000000000000000",
    "elwdpst_evlta":"000000000031269",
    "crd_ls_rght_frcs_amt":"000000000000000",
    "lvlh_join_amt":"000000000000000",
    "lvlh_trns_alowa":"000000000000000",
    "repl_amt":"000000003915500",
    "remn_repl_evlta":"000000003915500",
    "trst_remn_repl_evlta":"000000000000000",
    "bncr_remn_repl_evlta":"000000000000000",
    "profa_repl":"000000000000000",
    "crd_grnta_repl":"000000000000000",
    "crd_grnt_repl":"000000000000000",
    "add_grnt_repl":"000000000000000",
    "rght_repl_amt":"000000000000000",
    "pymn_alow_amt":"000000000085341",
    "wrap_pymn_alow_amt":"000000000000000",
    "ord_alow_amt":"000000000085341",
    "bncr_buy_alowa":"000000000085341",
    "20stk_ord_alow_amt":"000000000012550",
    "30stk_ord_alow_amt":"000000000012550",
    "40stk_ord_alow_amt":"000000000012550",
    "100stk_ord_alow_amt":"000000000012550",
    "ch_uncla":"000000000000000",
    "ch_uncla_dlfe":"000000000000000",
    "ch_uncla_tot":"000000000000000",
    "crd_int_npay":"000000000000000",
    "int_npay_amt_dlfe":"000000000000000",
    "int_npay_amt_tot":"000000000000000",
    "etc_loana":"000000000000000",
    "etc_loana_dlfe":"000000000000000",
    "etc_loan_tot":"000000000000000",
    "nrpy_loan":"000000000000000",
    "loan_sum":"000000000000000",
    "ls_sum":"000000000000000",
    "crd_grnt_rt":"0.00",
    "mdstrm_usfe":"000000000388388",
    "min_ord_alow_yn":"000000000000000",
    "loan_remn_evlt_amt":"000000000000000",
    "dpst_grntl_remn":"000000000000000",
    "sell_grntl_remn":"000000000000000",
    "d1_entra":"000000000017450",
    "d1_slby_exct_amt":"-00000000000084",
    "d1_buy_exct_amt":"000000000048240",
    "d1_out_rep_mor":"000000000000000",
    "d1_sel_exct_amt":"000000000048156",
    "d1_pymn_alow_amt":"000000000012550",
    "d2_entra":"000000000012550",
    "d2_slby_exct_amt":"-00000000004900",
    "d2_buy_exct_amt":"000000000004900",
    "d2_out_rep_mor":"000000000000000",
    "d2_sel_exct_amt":"000000000000000",
    "d2_pymn_alow_amt":"000000000012550",
    "50stk_ord_alow_amt":"000000000012550",
    "60stk_ord_alow_amt":"000000000012550",
    "stk_entr_prst": [],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다."
}
```

---

## 일별추정예탁자산현황요청 (kt00002)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| start_dt | 시작조회기간 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료조회기간 | String | Y | 8 | YYYYMMDD |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| daly_prsm_dpst_aset_amt_prst | 일별추정예탁자산현황 | LIST | N | - | |
| - dt | 일자 | String | N | 8 | |
| - entr | 예수금 | String | N | 12 | |
| - grnt_use_amt | 담보대출금 | String | N | 12 | |
| - crd_loan | 신용융자금 | String | N | 12 | |
| - ls_grnt | 대주담보금 | String | N | 12 | |
| - repl_amt | 대용금 | String | N | 12 | |
| - prsm_dpst_aset_amt | 추정예탁자산 | String | N | 12 | |
| - prsm_dpst_aset_amt_bncr_skip | 추정예탁자산수익증권제외 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 일별추정예탁자산현황요청
def fn_kt00002(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00002', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'start_dt': '20241111', # 시작조회기간 YYYYMMDD
        'end_dt': '20241125', # 종료조회기간 YYYYMMDD
    }

    # 3. API 실행
    fn_kt00002(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00002(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "start_dt" : "20241111",
    "end_dt" : "20241125"
}
```

#### Response
```json
{
    "daly_prsm_dpst_aset_amt_prst": [
        {
            "dt":"20241111",
            "entr":"000000100000",
            "grnt_use_amt":"000000000000",
            "crd_loan":"000000000000",
            "ls_grnt":"000000000000",
            "repl_amt":"000000000000",
            "prsm_dpst_aset_amt":"000000000000",
            "prsm_dpst_aset_amt_bncr_skip":"000000000000"
        },
        {
            "dt":"20241112",
            "entr":"000000100000",
            "grnt_use_amt":"000000000000",
            "crd_loan":"000000000000",
            "ls_grnt":"000000000000",
            "repl_amt":"000000000000",
            "prsm_dpst_aset_amt":"000000000000",
            "prsm_dpst_aset_amt_bncr_skip":"000000000000"
        },
        {
            "dt":"20241113",
            "entr":"000000100000",
            "grnt_use_amt":"000000000000",
            "crd_loan":"000000000000",
            "ls_grnt":"000000000000",
            "repl_amt":"000000000000",
            "prsm_dpst_aset_amt":"000000000000",
            "prsm_dpst_aset_amt_bncr_skip":"000000000000"
        },
        {
            "dt":"20241114",
            "entr":"000000999748",
            "grnt_use_amt":"000000000000",
            "crd_loan":"000000000000",
            "ls_grnt":"000000000000",
            "repl_amt":"000000000165",
            "prsm_dpst_aset_amt":"000000000000",
            "prsm_dpst_aset_amt_bncr_skip":"000000000000"
        }
    ],
    "return_code":0,
    "return_msg":"일자별 계좌별 추정예탁자산 내역이 조회 되었습니다."
}
```

---

## 추정자산조회요청 (kt00003)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| qry_tp | 상장폐지조회구분 | String | Y | 1 | 0:전체, 1:상장폐지종목제외 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| prsm_dpst_aset_amt | 추정예탁자산 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 추정자산조회요청
def fn_kt00003(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00003', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'qry_tp': '0', # 상장폐지조회구분 0:전체, 1:상장폐지종목제외
    }

    # 3. API 실행
    fn_kt00003(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00003(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "qry_tp" : "0"
}
```

#### Response
```json
{
    "prsm_dpst_aset_amt":"00000530218",
    "return_code":0,
    "return_msg":"조회가 완료되었습니다.."
}
```

---

## 계좌평가현황요청 (kt00004)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| qry_tp | 상장폐지조회구분 | String | Y | 1 | 0:전체, 1:상장폐지종목제외 |
| dmst_stex_tp | 국내거래소구분 | String | Y | 6 | KRX:한국거래소, NXT:넥스트트레이드 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| acnt_nm | 계좌명 | String | N | 30 | |
| brch_nm | 지점명 | String | N | 30 | |
| entr | 예수금 | String | N | 12 | |
| d2_entra | D+2추정예수금 | String | N | 12 | |
| tot_est_amt | 유가잔고평가액 | String | N | 12 | |
| aset_evlt_amt | 예탁자산평가액 | String | N | 12 | |
| tot_pur_amt | 총매입금액 | String | N | 12 | |
| prsm_dpst_aset_amt | 추정예탁자산 | String | N | 12 | |
| tot_grnt_sella | 매도담보대출금 | String | N | 12 | |
| tdy_lspft_amt | 당일투자원금 | String | N | 12 | |
| invt_bsamt | 당월투자원금 | String | N | 12 | |
| lspft_amt | 누적투자원금 | String | N | 12 | |
| tdy_lspft | 당일투자손익 | String | N | 12 | |
| lspft2 | 당월투자손익 | String | N | 12 | |
| lspft | 누적투자손익 | String | N | 12 | |
| tdy_lspft_rt | 당일손익율 | String | N | 12 | |
| lspft_ratio | 당월손익율 | String | N | 12 | |
| lspft_rt | 누적손익율 | String | N | 12 | |
| stk_acnt_evlt_prst | 종목별계좌평가현황 | LIST | N | - | |
| - stk_cd | 종목코드 | String | N | 12 | |
| - stk_nm | 종목명 | String | N | 30 | |
| - rmnd_qty | 보유수량 | String | N | 12 | |
| - avg_prc | 평균단가 | String | N | 12 | |
| - cur_prc | 현재가 | String | N | 12 | |
| - evlt_amt | 평가금액 | String | N | 12 | |
| - pl_amt | 손익금액 | String | N | 12 | |
| - pl_rt | 손익율 | String | N | 12 | |
| - loan_dt | 대출일 | String | N | 10 | |
| - pur_amt | 매입금액 | String | N | 12 | |
| - setl_remn | 결제잔고 | String | N | 12 | |
| - pred_buyq | 전일매수수량 | String | N | 12 | |
| - pred_sellq | 전일매도수량 | String | N | 12 | |
| - tdy_buyq | 금일매수수량 | String | N | 12 | |
| - tdy_sellq | 금일매도수량 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 계좌평가현황요청
def fn_kt00004(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00004', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'qry_tp': '0', # 상장폐지조회구분 0:전체, 1:상장폐지종목제외
        'dmst_stex_tp': 'KRX', # 국내거래소구분 KRX:한국거래소,NXT:넥스트트레이드
    }

    # 3. API 실행
    fn_kt00004(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00004(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..)
```

### 요청/응답 예제

#### Request
```json
{
    "qry_tp" : "0",
    "dmst_stex_tp" : "KRX"
}
```

#### Response
```json
{
    "acnt_nm":"김키움",
    "brch_nm":"키움은행",
    "entr":"000000017534",
    "d2_entra":"000000012550",
    "tot_est_amt":"000000000342",
    "aset_evlt_amt":"000000761950",
    "tot_pur_amt":"000000002786",
    "prsm_dpst_aset_amt":"000000749792",
    "tot_grnt_sella":"000000000000",
    "tdy_lspft_amt":"000000000000",
    "invt_bsamt":"000000000000",
    "lspft_amt":"000000000000",
    "tdy_lspft":"000000000000",
    "lspft2":"000000000000",
    "lspft":"000000000000",
    "tdy_lspft_rt":"0.00",
    "lspft_ratio":"0.00",
    "lspft_rt":"0.00",
    "stk_acnt_evlt_prst": [
        {
            "stk_cd":"A005930",
            "stk_nm":"삼성전자",
            "rmnd_qty":"000000000003",
            "avg_prc":"000000124500",
            "cur_prc":"000000070000",
            "evlt_amt":"000000209542",
            "pl_amt":"-00000163958",
            "pl_rt":"-43.8977",
            "loan_dt":"",
            "pur_amt":"000000373500",
            "setl_remn":"000000000003",
            "pred_buyq":"000000000000",
            "pred_sellq":"000000000000",
            "tdy_buyq":"000000000000",
            "tdy_sellq":"000000000000"
        }
    ],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다."
}
```

---

## 체결잔고요청 (kt00005)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| dmst_stex_tp | 국내거래소구분 | String | Y | 6 | KRX:한국거래소, NXT:넥스트트레이드 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| entr | 예수금 | String | N | 12 | |
| entr_d1 | 예수금D+1 | String | N | 12 | |
| entr_d2 | 예수금D+2 | String | N | 12 | |
| pymn_alow_amt | 출금가능금액 | String | N | 12 | |
| uncl_stk_amt | 미수확보금 | String | N | 12 | |
| repl_amt | 대용금 | String | N | 12 | |
| rght_repl_amt | 권리대용금 | String | N | 12 | |
| ord_alowa | 주문가능현금 | String | N | 12 | |
| ch_uncla | 현금미수금 | String | N | 12 | |
| crd_int_npay_gold | 신용이자미납금 | String | N | 12 | |
| etc_loana | 기타대여금 | String | N | 12 | |
| nrpy_loan | 미상환융자금 | String | N | 12 | |
| profa_ch | 증거금현금 | String | N | 12 | |
| repl_profa | 증거금대용 | String | N | 12 | |
| stk_buy_tot_amt | 주식매수총액 | String | N | 12 | |
| evlt_amt_tot | 평가금액합계 | String | N | 12 | |
| tot_pl_tot | 총손익합계 | String | N | 12 | |
| tot_pl_rt | 총손익률 | String | N | 12 | |
| tot_re_buy_alowa | 총재매수가능금액 | String | N | 12 | |
| 20ord_alow_amt | 20%주문가능금액 | String | N | 12 | |
| 30ord_alow_amt | 30%주문가능금액 | String | N | 12 | |
| 40ord_alow_amt | 40%주문가능금액 | String | N | 12 | |
| 50ord_alow_amt | 50%주문가능금액 | String | N | 12 | |
| 60ord_alow_amt | 60%주문가능금액 | String | N | 12 | |
| 100ord_alow_amt | 100%주문가능금액 | String | N | 12 | |
| crd_loan_tot | 신용융자합계 | String | N | 12 | |
| crd_loan_ls_tot | 신용융자대주합계 | String | N | 12 | |
| crd_grnt_rt | 신용담보비율 | String | N | 12 | |
| dpst_grnt_use_amt_amt | 예탁담보대출금액 | String | N | 12 | |
| grnt_loan_amt | 매도담보대출금액 | String | N | 12 | |
| stk_cntr_remn | 종목별체결잔고 | LIST | N | - | |
| - crd_tp | 신용구분 | String | N | 2 | |
| - loan_dt | 대출일 | String | N | 8 | |
| - expr_dt | 만기일 | String | N | 8 | |
| - stk_cd | 종목번호 | String | N | 12 | |
| - stk_nm | 종목명 | String | N | 30 | |
| - setl_remn | 결제잔고 | String | N | 12 | |
| - cur_qty | 현재잔고 | String | N | 12 | |
| - cur_prc | 현재가 | String | N | 12 | |
| - buy_uv | 매입단가 | String | N | 12 | |
| - pur_amt | 매입금액 | String | N | 12 | |
| - evlt_amt | 평가금액 | String | N | 12 | |
| - evltv_prft | 평가손익 | String | N | 12 | |
| - pl_rt | 손익률 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 체결잔고요청
def fn_kt00005(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00005', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'dmst_stex_tp': 'KRX', # 국내거래소구분 KRX:한국거래소,NXT:넥스트트레이드
    }

    # 3. API 실행
    fn_kt00005(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00005(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "dmst_stex_tp" : "KRX"
}
```

#### Response
```json
{
    "entr":"000000017534",
    "entr_d1":"000000017450",
    "entr_d2":"000000012550",
    "pymn_alow_amt":"000000085341",
    "uncl_stk_amt":"000000000000",
    "repl_amt":"000003915500",
    "rght_repl_amt":"000000000000",
    "ord_alowa":"000000085341",
    "ch_uncla":"000000000000",
    "crd_int_npay_gold":"000000000000",
    "etc_loana":"000000000000",
    "nrpy_loan":"000000000000",
    "profa_ch":"000000032193",
    "repl_profa":"000000000000",
    "stk_buy_tot_amt":"000006122786",
    "evlt_amt_tot":"000006236342",
    "tot_pl_tot":"000000113556",
    "tot_pl_rt":"1.8546",
    "tot_re_buy_alowa":"000000135970",
    "20ord_alow_amt":"000000012550",
    "30ord_alow_amt":"000000012550",
    "40ord_alow_amt":"000000012550",
    "50ord_alow_amt":"000000012550",
    "60ord_alow_amt":"000000012550",
    "100ord_alow_amt":"000000012550",
    "crd_loan_tot":"000000000000",
    "crd_loan_ls_tot":"000000000000",
    "crd_grnt_rt":"0.00",
    "dpst_grnt_use_amt_amt":"000000000000",
    "grnt_loan_amt":"000000000000",
    "stk_cntr_remn": [
        {
            "crd_tp":"00",
            "loan_dt":"",
            "expr_dt":"",
            "stk_cd":"A005930",
            "stk_nm":"삼성전자",
            "setl_remn":"000000000003",
            "cur_qty":"000000000003",
            "cur_prc":"000000070000",
            "buy_uv":"000000124500",
            "pur_amt":"000000373500",
            "evlt_amt":"000000209542",
            "evltv_prft":"-00000163958",
            "pl_rt":"-43.8977"
        }
    ],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다."
}
```

---

## 계좌별주문체결내역상세요청 (kt00007)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| ord_dt | 주문일자 | String | N | 8 | YYYYMMDD |
| qry_tp | 조회구분 | String | Y | 1 | 1:주문순, 2:역순, 3:미체결, 4:체결내역만 |
| stk_bond_tp | 주식채권구분 | String | Y | 1 | 0:전체, 1:주식, 2:채권 |
| sell_tp | 매도수구분 | String | Y | 1 | 0:전체, 1:매도, 2:매수 |
| stk_cd | 종목코드 | String | N | 12 | 공백허용 (공백일때 전체종목) |
| fr_ord_no | 시작주문번호 | String | N | 7 | 공백허용 (공백일때 전체주문) |
| dmst_stex_tp | 국내거래소구분 | String | Y | 6 | %:(전체), KRX:한국거래소, NXT:넥스트트레이드, SOR:최선주문집행 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| acnt_ord_cntr_prps_dtl | 계좌별주문체결내역상세 | LIST | N | - | |
| - ord_no | 주문번호 | String | N | 7 | |
| - stk_cd | 종목번호 | String | N | 12 | |
| - trde_tp | 매매구분 | String | N | 20 | |
| - crd_tp | 신용구분 | String | N | 20 | |
| - ord_qty | 주문수량 | String | N | 10 | |
| - ord_uv | 주문단가 | String | N | 10 | |
| - cnfm_qty | 확인수량 | String | N | 10 | |
| - acpt_tp | 접수구분 | String | N | 20 | |
| - rsrv_tp | 반대여부 | String | N | 20 | |
| - ord_tm | 주문시간 | String | N | 8 | |
| - ori_ord | 원주문 | String | N | 7 | |
| - stk_nm | 종목명 | String | N | 40 | |
| - io_tp_nm | 주문구분 | String | N | 20 | |
| - loan_dt | 대출일 | String | N | 8 | |
| - cntr_qty | 체결수량 | String | N | 10 | |
| - cntr_uv | 체결단가 | String | N | 10 | |
| - ord_remnq | 주문잔량 | String | N | 10 | |
| - comm_ord_tp | 통신구분 | String | N | 20 | |
| - mdfy_cncl | 정정취소 | String | N | 20 | |
| - cnfm_tm | 확인시간 | String | N | 8 | |
| - dmst_stex_tp | 국내거래소구분 | String | N | 8 | |
| - cond_uv | 스톱가 | String | N | 10 | |

### Python 예제 코드

```python
import requests
import json

# 계좌별주문체결내역상세요청
def fn_kt00007(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00007', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'ord_dt': '', # 주문일자 YYYYMMDD
        'qry_tp': '1', # 조회구분 1:주문순, 2:역순, 3:미체결, 4:체결내역만
        'stk_bond_tp': '0', # 주식채권구분 0:전체, 1:주식, 2:채권
        'sell_tp': '0', # 매도수구분 0:전체, 1:매도, 2:매수
        'stk_cd': '005930', # 종목코드 공백허용 (공백일때 전체종목)
        'fr_ord_no': '', # 시작주문번호 공백허용 (공백일때 전체주문)
        'dmst_stex_tp': '%', # 국내거래소구분 %:(전체),KRX:한국거래소,NXT:넥스트트레이드,SOR:최선주문집행
    }

    # 3. API 실행
    fn_kt00007(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00007(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "ord_dt" : "",
    "qry_tp" : "1",
    "stk_bond_tp" : "0",
    "sell_tp" : "0",
    "stk_cd" : "005930",
    "fr_ord_no" : "",
    "dmst_stex_tp" : "%"
}
```

#### Response
```json
{
    "acnt_ord_cntr_prps_dtl": [
        {
            "ord_no":"0000050",
            "stk_cd":"A069500",
            "trde_tp":"시장가",
            "crd_tp":"보통매매",
            "ord_qty":"0000000001",
            "ord_uv":"0000000000",
            "cnfm_qty":"0000000000",
            "acpt_tp":"접수",
            "rsrv_tp":"",
            "ord_tm":"13:05:43",
            "ori_ord":"0000000",
            "stk_nm":"KODEX 200",
            "io_tp_nm":"현금매수",
            "loan_dt":"",
            "cntr_qty":"0000000001",
            "cntr_uv":"0000004900",
            "ord_remnq":"0000000000",
            "comm_ord_tp":"영웅문4",
            "mdfy_cncl":"",
            "cnfm_tm":"",
            "dmst_stex_tp":"KRX",
            "cond_uv":"0000000000"
        }
    ],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다"
}
```

---

## 주문인출가능금액요청 (kt00010)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| io_amt | 입출금액 | String | N | 12 | |
| stk_cd | 종목번호 | String | Y | 12 | |
| trde_tp | 매매구분 | String | Y | 1 | 1:매도, 2:매수 |
| trde_qty | 매매수량 | String | N | 10 | |
| uv | 매수가격 | String | Y | 10 | |
| exp_buy_unp | 예상매수단가 | String | N | 10 | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| profa_20ord_alow_amt | 증거금20%주문가능금액 | String | N | 12 | |
| profa_20ord_alowq | 증거금20%주문가능수량 | String | N | 10 | |
| profa_30ord_alow_amt | 증거금30%주문가능금액 | String | N | 12 | |
| profa_30ord_alowq | 증거금30%주문가능수량 | String | N | 10 | |
| profa_40ord_alow_amt | 증거금40%주문가능금액 | String | N | 12 | |
| profa_40ord_alowq | 증거금40%주문가능수량 | String | N | 10 | |
| profa_50ord_alow_amt | 증거금50%주문가능금액 | String | N | 12 | |
| profa_50ord_alowq | 증거금50%주문가능수량 | String | N | 10 | |
| profa_60ord_alow_amt | 증거금60%주문가능금액 | String | N | 12 | |
| profa_60ord_alowq | 증거금60%주문가능수량 | String | N | 10 | |
| profa_rdex_60ord_alow_amt | 증거금감면60%주문가능금 | String | N | 12 | |
| profa_rdex_60ord_alowq | 증거금감면60%주문가능수 | String | N | 10 | |
| profa_100ord_alow_amt | 증거금100%주문가능금액 | String | N | 12 | |
| profa_100ord_alowq | 증거금100%주문가능수량 | String | N | 10 | |
| pred_reu_alowa | 전일재사용가능금액 | String | N | 12 | |
| tdy_reu_alowa | 금일재사용가능금액 | String | N | 12 | |
| entr | 예수금 | String | N | 12 | |
| repl_amt | 대용금 | String | N | 12 | |
| uncla | 미수금 | String | N | 12 | |
| ord_pos_repl | 주문가능대용 | String | N | 12 | |
| ord_alowa | 주문가능현금 | String | N | 12 | |
| wthd_alowa | 인출가능금액 | String | N | 12 | |
| nxdy_wthd_alowa | 익일인출가능금액 | String | N | 12 | |
| pur_amt | 매입금액 | String | N | 12 | |
| cmsn | 수수료 | String | N | 12 | |
| pur_exct_amt | 매입정산금 | String | N | 12 | |
| d2entra | D2추정예수금 | String | N | 12 | |
| profa_rdex_aplc_tp | 증거금감면적용구분 | String | N | 1 | 0:일반, 1:60%감면 |

### Python 예제 코드

```python
import requests
import json

# 주문인출가능금액요청
def fn_kt00010(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00010', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'io_amt': '', # 입출금액 
        'stk_cd': '005930', # 종목번호 
        'trde_tp': '2', # 매매구분 1:매도, 2:매수
        'trde_qty': '', # 매매수량 
        'uv': '267000', # 매수가격 
        'exp_buy_unp': '', # 예상매수단가 
    }

    # 3. API 실행
    fn_kt00010(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00010(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "io_amt" : "",
    "stk_cd" : "005930",
    "trde_tp" : "2",
    "trde_qty" : "",
    "uv" : "267000",
    "exp_buy_unp" : ""
}
```

#### Response
```json
{
    "profa_20ord_alow_amt":"000000012550",
    "profa_20ord_alowq":"0000000000",
    "profa_30ord_alow_amt":"000000012550",
    "profa_30ord_alowq":"0000000000",
    "profa_40ord_alow_amt":"000000012550",
    "profa_40ord_alowq":"0000000000",
    "profa_50ord_alow_amt":"000000012550",
    "profa_50ord_alowq":"0000000000",
    "profa_60ord_alow_amt":"000000012550",
    "profa_60ord_alowq":"0000000000",
    "profa_rdex_60ord_alow_amt":"000000012550",
    "profa_rdex_60ord_alowq":"0000000000",
    "profa_100ord_alow_amt":"000000012550",
    "profa_100ord_alowq":"0000000000",
    "pred_reu_alowa":"000000027194",
    "tdy_reu_alowa":"000000000000",
    "entr":"000000017534",
    "repl_amt":"000003915500",
    "uncla":"000000000000",
    "ord_pos_repl":"000003915500",
    "ord_alowa":"000000085341",
    "wthd_alowa":"000000085341",
    "nxdy_wthd_alowa":"000000012550",
    "pur_amt":"000000000000",
    "cmsn":"000000000000",
    "pur_exct_amt":"000000000000",
    "d2entra":"000000012550",
    "profa_rdex_aplc_tp":"0",
    "return_code":0,
    "return_msg":"주문/인출가능금액 시뮬레이션 조회완료하였습니다."
}
```

---

## 계좌별주문체결현황요청 (kt00009)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| ord_dt | 주문일자 | String | N | 8 | YYYYMMDD |
| stk_bond_tp | 주식채권구분 | String | Y | 1 | 0:전체, 1:주식, 2:채권 |
| mrkt_tp | 시장구분 | String | Y | 1 | 0:전체, 1:코스피, 2:코스닥, 3:OTCBB, 4:ECN |
| sell_tp | 매도수구분 | String | Y | 1 | 0:전체, 1:매도, 2:매수 |
| qry_tp | 조회구분 | String | Y | 1 | 0:전체, 1:체결 |
| stk_cd | 종목코드 | String | N | 12 | 전문 조회할 종목코드 |
| fr_ord_no | 시작주문번호 | String | N | 7 | |
| dmst_stex_tp | 국내거래소구분 | String | Y | 6 | %:(전체), KRX:한국거래소, NXT:넥스트트레이드, SOR:최선주문집행 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| sell_grntl_engg_amt | 매도약정금액 | String | N | 12 | |
| buy_engg_amt | 매수약정금액 | String | N | 12 | |
| engg_amt | 약정금액 | String | N | 12 | |
| acnt_ord_cntr_prst_array | 계좌별주문체결현황배열 | LIST | N | - | |
| - stk_bond_tp | 주식채권구분 | String | N | 1 | |
| - ord_no | 주문번호 | String | N | 7 | |
| - stk_cd | 종목번호 | String | N | 12 | |
| - trde_tp | 매매구분 | String | N | 15 | |
| - io_tp_nm | 주문유형구분 | String | N | 20 | |
| - ord_qty | 주문수량 | String | N | 10 | |
| - ord_uv | 주문단가 | String | N | 10 | |
| - cnfm_qty | 확인수량 | String | N | 10 | |
| - rsrv_oppo | 예약/반대 | String | N | 4 | |
| - cntr_no | 체결번호 | String | N | 7 | |
| - acpt_tp | 접수구분 | String | N | 8 | |
| - orig_ord_no | 원주문번호 | String | N | 7 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - setl_tp | 결제구분 | String | N | 8 | |
| - crd_deal_tp | 신용거래구분 | String | N | 20 | |
| - cntr_qty | 체결수량 | String | N | 10 | |
| - cntr_uv | 체결단가 | String | N | 10 | |
| - comm_ord_tp | 통신구분 | String | N | 8 | |
| - mdfy_cncl_tp | 정정/취소구분 | String | N | 12 | |
| - cntr_tm | 체결시간 | String | N | 8 | |
| - dmst_stex_tp | 국내거래소구분 | String | N | 6 | |
| - cond_uv | 스톱가 | String | N | 10 | |

### Python 예제 코드

```python
import requests
import json

# 계좌별주문체결현황요청
def fn_kt00009(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00009', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'ord_dt': '', # 주문일자 YYYYMMDD
        'stk_bond_tp': '0', # 주식채권구분 0:전체, 1:주식, 2:채권
        'mrkt_tp': '0', # 시장구분 0:전체, 1:코스피, 2:코스닥, 3:OTCBB, 4:ECN
        'sell_tp': '0', # 매도수구분 0:전체, 1:매도, 2:매수
        'qry_tp': '0', # 조회구분 0:전체, 1:체결
        'stk_cd': '', # 종목코드 전문 조회할 종목코드
        'fr_ord_no': '', # 시작주문번호 
        'dmst_stex_tp': 'KRX', # 국내거래소구분 %:(전체),KRX:한국거래소,NXT:넥스트트레이드,SOR:최선주문집행
    }

    # 3. API 실행
    fn_kt00009(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00009(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "ord_dt" : "",
    "stk_bond_tp" : "0",
    "mrkt_tp" : "0",
    "sell_tp" : "0",
    "qry_tp" : "0",
    "stk_cd" : "",
    "fr_ord_no" : "",
    "dmst_stex_tp" : "KRX"
}
```

#### Response
```json
{
    "sell_grntl_engg_amt":"000000000000",
    "buy_engg_amt":"000000004900",
    "engg_amt":"000000004900",
    "acnt_ord_cntr_prst_array": [
        {
            "stk_bond_tp":"1",
            "ord_no":"0000050",
            "stk_cd":"A069500",
            "trde_tp":"시장가",
            "io_tp_nm":"현금매수",
            "ord_qty":"0000000001",
            "ord_uv":"0000000000",
            "cnfm_qty":"0000000000",
            "rsrv_oppo":"",
            "cntr_no":"0000001",
            "acpt_tp":"접수",
            "orig_ord_no":"0000000",
            "stk_nm":"KODEX 200",
            "setl_tp":"삼일결제",
            "crd_deal_tp":"보통매매",
            "cntr_qty":"0000000001",
            "cntr_uv":"0000004900",
            "comm_ord_tp":"영웅문4",
            "mdfy_cncl_tp":"",
            "cntr_tm":"13:07:47",
            "dmst_stex_tp":"KRX",
            "cond_uv":"0000000000"
        }
    ],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다"
}
```

---

## 계좌별익일결제예정내역요청 (kt00008)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| strt_dcd_seq | 시작결제번호 | String | N | 7 | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| trde_dt | 매매일자 | String | N | 8 | |
| setl_dt | 결제일자 | String | N | 8 | |
| sell_amt_sum | 매도정산합 | String | N | 12 | |
| buy_amt_sum | 매수정산합 | String | N | 12 | |
| acnt_nxdy_setl_frcs_prps_array | 계좌별익일결제예정내역배열 | LIST | N | - | |
| - seq | 일련번호 | String | N | 7 | |
| - stk_cd | 종목번호 | String | N | 12 | |
| - loan_dt | 대출일 | String | N | 8 | |
| - qty | 수량 | String | N | 12 | |
| - engg_amt | 약정금액 | String | N | 12 | |
| - cmsn | 수수료 | String | N | 12 | |
| - incm_tax | 소득세 | String | N | 12 | |
| - rstx | 농특세 | String | N | 12 | |
| - stk_nm | 종목명 | String | N | 40 | |
| - sell_tp | 매도수구분 | String | N | 10 | |
| - unp | 단가 | String | N | 12 | |
| - exct_amt | 정산금액 | String | N | 12 | |
| - trde_tax | 거래세 | String | N | 12 | |
| - resi_tax | 주민세 | String | N | 12 | |
| - crd_tp | 신용구분 | String | N | 20 | |

### Python 예제 코드

```python
import requests
import json

# 계좌별익일결제예정내역요청
def fn_kt00008(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00008', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'strt_dcd_seq': '', # 시작결제번호 
    }

    # 3. API 실행
    fn_kt00008(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00008(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "strt_dcd_seq" : ""
}
```

#### Response
```json
{
    "trde_dt":"20241122",
    "setl_dt":"20241126",
    "sell_amt_sum":"000000048156",
    "buy_amt_sum":"000000048240",
    "acnt_nxdy_setl_frcs_prps_array": [
        {
            "seq":"0010006",
            "stk_cd":"A005930",
            "loan_dt":"",
            "qty":"000000000001",
            "engg_amt":"000000016080",
            "cmsn":"000000000000",
            "incm_tax":"000000000000",
            "rstx":"000000000000",
            "stk_nm":"삼성전자",
            "sell_tp":"매도",
            "unp":"000000016080",
            "exct_amt":"000000016052",
            "trde_tax":"000000000028",
            "resi_tax":"000000000000",
            "crd_tp":"현금매도 K"
        },
        {
            "seq":"0010007",
            "stk_cd":"A005930",
            "loan_dt":"",
            "qty":"000000000002",
            "engg_amt":"000000032160",
            "cmsn":"000000000000",
            "incm_tax":"000000000000",
            "rstx":"000000000000",
            "stk_nm":"삼성전자",
            "sell_tp":"매도",
            "unp":"000000016080",
            "exct_amt":"000000032104",
            "trde_tax":"000000000056",
            "resi_tax":"000000000000",
            "crd_tp":"프로그램매도 K"
        }
    ],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다"
}
```

---

## 증거금율별주문가능수량조회요청 (kt00011)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_cd | 종목번호 | String | Y | 12 | |
| uv | 매수가격 | String | N | 10 | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_profa_rt | 종목증거금율 | String | N | 15 | |
| profa_rt | 계좌증거금율 | String | N | 15 | |
| aplc_rt | 적용증거금율 | String | N | 15 | |
| profa_20ord_alow_amt | 증거금20%주문가능금액 | String | N | 12 | |
| profa_20ord_alowq | 증거금20%주문가능수량 | String | N | 12 | |
| profa_20pred_reu_amt | 증거금20%전일재사용금액 | String | N | 12 | |
| profa_20tdy_reu_amt | 증거금20%금일재사용금액 | String | N | 12 | |
| profa_30ord_alow_amt | 증거금30%주문가능금액 | String | N | 12 | |
| profa_30ord_alowq | 증거금30%주문가능수량 | String | N | 12 | |
| profa_30pred_reu_amt | 증거금30%전일재사용금액 | String | N | 12 | |
| profa_30tdy_reu_amt | 증거금30%금일재사용금액 | String | N | 12 | |
| profa_40ord_alow_amt | 증거금40%주문가능금액 | String | N | 12 | |
| profa_40ord_alowq | 증거금40%주문가능수량 | String | N | 12 | |
| profa_40pred_reu_amt | 증거금40전일재사용금액 | String | N | 12 | |
| profa_40tdy_reu_amt | 증거금40%금일재사용금액 | String | N | 12 | |
| profa_50ord_alow_amt | 증거금50%주문가능금액 | String | N | 12 | |
| profa_50ord_alowq | 증거금50%주문가능수량 | String | N | 12 | |
| profa_50pred_reu_amt | 증거금50%전일재사용금액 | String | N | 12 | |
| profa_50tdy_reu_amt | 증거금50%금일재사용금액 | String | N | 12 | |
| profa_60ord_alow_amt | 증거금60%주문가능금액 | String | N | 12 | |
| profa_60ord_alowq | 증거금60%주문가능수량 | String | N | 12 | |
| profa_60pred_reu_amt | 증거금60%전일재사용금액 | String | N | 12 | |
| profa_60tdy_reu_amt | 증거금60%금일재사용금액 | String | N | 12 | |
| profa_100ord_alow_amt | 증거금100%주문가능금액 | String | N | 12 | |
| profa_100ord_alowq | 증거금100%주문가능수량 | String | N | 12 | |
| profa_100pred_reu_amt | 증거금100%전일재사용금액 | String | N | 12 | |
| profa_100tdy_reu_amt | 증거금100%금일재사용금액 | String | N | 12 | |
| min_ord_alow_amt | 미수불가주문가능금액 | String | N | 12 | |
| min_ord_alowq | 미수불가주문가능수량 | String | N | 12 | |
| min_pred_reu_amt | 미수불가전일재사용금액 | String | N | 12 | |
| min_tdy_reu_amt | 미수불가금일재사용금액 | String | N | 12 | |
| entr | 예수금 | String | N | 12 | |
| repl_amt | 대용금 | String | N | 12 | |
| uncla | 미수금 | String | N | 12 | |
| ord_pos_repl | 주문가능대용 | String | N | 12 | |
| ord_alowa | 주문가능현금 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 증거금율별주문가능수량조회요청
def fn_kt00011(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00011', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'stk_cd': '005930', # 종목번호 
        'uv': '', # 매수가격 
    }

    # 3. API 실행
    fn_kt00011(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00011(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "stk_cd" : "005930",
    "uv" : ""
}
```

#### Response
```json
{
    "stk_profa_rt":"20%",
    "profa_rt":"100%",
    "aplc_rt":"100%",
    "profa_20ord_alow_amt":"",
    "profa_20ord_alowq":"",
    "profa_20pred_reu_amt":"",
    "profa_20tdy_reu_amt":"",
    "profa_30ord_alow_amt":"",
    "profa_30ord_alowq":"",
    "profa_30pred_reu_amt":"",
    "profa_30tdy_reu_amt":"",
    "profa_40ord_alow_amt":"",
    "profa_40ord_alowq":"",
    "profa_40pred_reu_amt":"",
    "profa_40tdy_reu_amt":"",
    "profa_50ord_alow_amt":"",
    "profa_50ord_alowq":"",
    "profa_50pred_reu_amt":"",
    "profa_50tdy_reu_amt":"",
    "profa_60ord_alow_amt":"",
    "profa_60ord_alowq":"",
    "profa_60pred_reu_amt":"",
    "profa_60tdy_reu_amt":"",
    "profa_100ord_alow_amt":"",
    "profa_100ord_alowq":"",
    "profa_100pred_reu_amt":"",
    "profa_100tdy_reu_amt":"",
    "min_ord_alow_amt":"000000063380",
    "min_ord_alowq":"000000000000",
    "min_pred_reu_amt":"000000027194",
    "min_tdy_reu_amt":"000000000000",
    "entr":"000000017534",
    "repl_amt":"000003915500",
    "uncla":"000000000000",
    "ord_pos_repl":"000003915500",
    "ord_alowa":"000000085341",
    "return_code":0,
    "return_msg":"자료를 조회하였습니다."
}
```

---

## 신용보증금율별주문가능수량조회요청 (kt00012)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_cd | 종목번호 | String | Y | 12 | |
| uv | 매수가격 | String | N | 10 | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| stk_assr_rt | 종목보증금율 | String | N | 1 | |
| stk_assr_rt_nm | 종목보증금율명 | String | N | 4 | |
| assr_30ord_alow_amt | 보증금30%주문가능금액 | String | N | 12 | |
| assr_30ord_alowq | 보증금30%주문가능수량 | String | N | 12 | |
| assr_30pred_reu_amt | 보증금30%전일재사용금액 | String | N | 12 | |
| assr_30tdy_reu_amt | 보증금30%금일재사용금액 | String | N | 12 | |
| assr_40ord_alow_amt | 보증금40%주문가능금액 | String | N | 12 | |
| assr_40ord_alowq | 보증금40%주문가능수량 | String | N | 12 | |
| assr_40pred_reu_amt | 보증금40%전일재사용금액 | String | N | 12 | |
| assr_40tdy_reu_amt | 보증금40%금일재사용금액 | String | N | 12 | |
| assr_50ord_alow_amt | 보증금50%주문가능금액 | String | N | 12 | |
| assr_50ord_alowq | 보증금50%주문가능수량 | String | N | 12 | |
| assr_50pred_reu_amt | 보증금50%전일재사용금액 | String | N | 12 | |
| assr_50tdy_reu_amt | 보증금50%금일재사용금액 | String | N | 12 | |
| assr_60ord_alow_amt | 보증금60%주문가능금액 | String | N | 12 | |
| assr_60ord_alowq | 보증금60%주문가능수량 | String | N | 12 | |
| assr_60pred_reu_amt | 보증금60%전일재사용금액 | String | N | 12 | |
| assr_60tdy_reu_amt | 보증금60%금일재사용금액 | String | N | 12 | |
| entr | 예수금 | String | N | 12 | |
| repl_amt | 대용금 | String | N | 12 | |
| uncla | 미수금 | String | N | 12 | |
| ord_pos_repl | 주문가능대용 | String | N | 12 | |
| ord_alowa | 주문가능현금 | String | N | 12 | |
| out_alowa | 미수가능금액 | String | N | 12 | |
| out_pos_qty | 미수가능수량 | String | N | 12 | |
| min_amt | 미수불가금액 | String | N | 12 | |
| min_qty | 미수불가수량 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 신용보증금율별주문가능수량조회요청
def fn_kt00012(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00012', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'stk_cd': '005930', # 종목번호 
        'uv': '', # 매수가격 
    }

    # 3. API 실행
    fn_kt00012(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00012(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "stk_cd" : "005930",
    "uv" : ""
}
```

#### Response
```json
{
    "stk_assr_rt": "B",
    "stk_assr_rt_nm": "45%",
    "assr_30ord_alow_amt": "003312045139",
    "assr_30ord_alowq": "000000000000",
    "assr_30pred_reu_amt": "000000000000",
    "assr_30tdy_reu_amt": "000000048994",
    "assr_40ord_alow_amt": "002208030092",
    "assr_40ord_alowq": "000000000000",
    "assr_40pred_reu_amt": "000000000000",
    "assr_40tdy_reu_amt": "000000048994",
    "assr_50ord_alow_amt": "001987227084",
    "assr_50ord_alowq": "000000000000",
    "assr_50pred_reu_amt": "000000000000",
    "assr_50tdy_reu_amt": "000000048994",
    "assr_60ord_alow_amt": "001656022569",
    "assr_60ord_alowq": "000000000000",
    "assr_60pred_reu_amt": "000000000000",
    "assr_60tdy_reu_amt": "000000048994",
    "entr": "000994946131",
    "repl_amt": "000001643660",
    "uncla": "000000000000",
    "ord_pos_repl": "000002420949",
    "ord_alowa": "000993564548",
    "out_alowa": "002208030092",
    "out_pos_qty": "000000000000",
    "min_amt": "002207294240",
    "min_qty": "000000000000",
    "return_code": 0,
    "return_msg": "신용보증금율별 주문가능수량 조회(한도정상)"
}
```

---

## 증거금세부내역조회요청 (kt00013)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| | (입력 파라미터 없음) | | | | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| tdy_reu_objt_amt | 금일재사용대상금액 | String | N | 15 | |
| tdy_reu_use_amt | 금일재사용사용금액 | String | N | 15 | |
| tdy_reu_alowa | 금일재사용가능금액 | String | N | 15 | |
| tdy_reu_lmtt_amt | 금일재사용제한금액 | String | N | 15 | |
| tdy_reu_alowa_fin | 금일재사용가능금액최종 | String | N | 15 | |
| pred_reu_objt_amt | 전일재사용대상금액 | String | N | 15 | |
| pred_reu_use_amt | 전일재사용사용금액 | String | N | 15 | |
| pred_reu_alowa | 전일재사용가능금액 | String | N | 15 | |
| pred_reu_lmtt_amt | 전일재사용제한금액 | String | N | 15 | |
| pred_reu_alowa_fin | 전일재사용가능금액최종 | String | N | 15 | |
| ch_amt | 현금금액 | String | N | 15 | |
| ch_profa | 현금증거금 | String | N | 15 | |
| use_pos_ch | 사용가능현금 | String | N | 15 | |
| ch_use_lmtt_amt | 현금사용제한금액 | String | N | 15 | |
| use_pos_ch_fin | 사용가능현금최종 | String | N | 15 | |
| repl_amt_amt | 대용금액 | String | N | 15 | |
| repl_profa | 대용증거금 | String | N | 15 | |
| use_pos_repl | 사용가능대용 | String | N | 15 | |
| repl_use_lmtt_amt | 대용사용제한금액 | String | N | 15 | |
| use_pos_repl_fin | 사용가능대용최종 | String | N | 15 | |
| crd_grnta_ch | 신용보증금현금 | String | N | 15 | |
| crd_grnta_repl | 신용보증금대용 | String | N | 15 | |
| crd_grnt_ch | 신용담보금현금 | String | N | 15 | |
| crd_grnt_repl | 신용담보금대용 | String | N | 15 | |
| uncla | 미수금 | String | N | 12 | |
| ls_grnt_reu_gold | 대주담보금재사용금 | String | N | 15 | |
| 20ord_alow_amt | 20%주문가능금액 | String | N | 15 | |
| 30ord_alow_amt | 30%주문가능금액 | String | N | 15 | |
| 40ord_alow_amt | 40%주문가능금액 | String | N | 15 | |
| 50ord_alow_amt | 50%주문가능금액 | String | N | 15 | |
| 60ord_alow_amt | 60%주문가능금액 | String | N | 15 | |
| 100ord_alow_amt | 100%주문가능금액 | String | N | 15 | |
| tdy_crd_rpya_loss_amt | 금일신용상환손실금액 | String | N | 15 | |
| pred_crd_rpya_loss_amt | 전일신용상환손실금액 | String | N | 15 | |
| tdy_ls_rpya_loss_repl_profa | 금일대주상환손실대용증거금 | String | N | 15 | |
| pred_ls_rpya_loss_repl_profa | 전일대주상환손실대용증거금 | String | N | 15 | |
| evlt_repl_amt_spg_use_skip | 평가대용금(현물사용제외) | String | N | 15 | |
| evlt_repl_rt | 평가대용비율 | String | N | 15 | |
| crd_repl_profa | 신용대용증거금 | String | N | 15 | |
| ch_ord_repl_profa | 현금주문대용증거금 | String | N | 15 | |
| crd_ord_repl_profa | 신용주문대용증거금 | String | N | 15 | |
| crd_repl_conv_gold | 신용대용환산금 | String | N | 15 | |
| repl_alowa | 대용가능금액(현금제한) | String | N | 15 | |
| repl_alowa_2 | 대용가능금액2(신용제한) | String | N | 15 | |
| ch_repl_lck_gold | 현금대용부족금 | String | N | 15 | |
| crd_repl_lck_gold | 신용대용부족금 | String | N | 15 | |
| ch_ord_alow_repla | 현금주문가능대용금 | String | N | 15 | |
| crd_ord_alow_repla | 신용주문가능대용금 | String | N | 15 | |
| d2vexct_entr | D2가정산예수금 | String | N | 15 | |
| d2ch_ord_alow_amt | D2현금주문가능금액 | String | N | 15 | |

### Python 예제 코드

```python
import requests
import json

# 증거금세부내역조회요청
def fn_kt00013(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00013', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {}

    # 3. API 실행
    fn_kt00013(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00013(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{}
```

#### Response
```json
{
    "tdy_reu_objt_amt":"000000000000000",
    "tdy_reu_use_amt":"000000000000000",
    "tdy_reu_alowa":"000000000000000",
    "tdy_reu_lmtt_amt":"000000000000000",
    "tdy_reu_alowa_fin":"000000000000000",
    "pred_reu_objt_amt":"000000000048141",
    "pred_reu_use_amt":"000000000020947",
    "pred_reu_alowa":"000000000027194",
    "pred_reu_lmtt_amt":"000000000000000",
    "pred_reu_alowa_fin":"000000000027194",
    "ch_amt":"000000000017534",
    "ch_profa":"000000000032193",
    "use_pos_ch":"000000000085341",
    "ch_use_lmtt_amt":"000000000000000",
    "use_pos_ch_fin":"000000000085341",
    "repl_amt_amt":"000000003915500",
    "repl_profa":"000000000000000",
    "use_pos_repl":"000000003915500",
    "repl_use_lmtt_amt":"000000000000000",
    "use_pos_repl_fin":"000000003915500",
    "crd_grnta_ch":"000000000000000",
    "crd_grnta_repl":"000000000000000",
    "crd_grnt_ch":"000000000000000",
    "crd_grnt_repl":"000000000000000",
    "uncla":"000000000000",
    "ls_grnt_reu_gold":"000000000000000",
    "20ord_alow_amt":"000000000012550",
    "30ord_alow_amt":"000000000012550",
    "40ord_alow_amt":"000000000012550",
    "50ord_alow_amt":"000000000012550",
    "60ord_alow_amt":"000000000012550",
    "100ord_alow_amt":"000000000012550",
    "tdy_crd_rpya_loss_amt":"000000000000000",
    "pred_crd_rpya_loss_amt":"000000000000000",
    "tdy_ls_rpya_loss_repl_profa":"000000000000000",
    "pred_ls_rpya_loss_repl_profa":"000000000000000",
    "evlt_repl_amt_spg_use_skip":"000000006193400",
    "evlt_repl_rt":"0.6322053",
    "crd_repl_profa":"000000000000000",
    "ch_ord_repl_profa":"000000000000000",
    "crd_ord_repl_profa":"000000000000000",
    "crd_repl_conv_gold":"000000000000000",
    "repl_alowa":"000000003915500",
    "repl_alowa_2":"000000003915500",
    "ch_repl_lck_gold":"000000000000000",
    "crd_repl_lck_gold":"000000000000000",
    "ch_ord_alow_repla":"000000003915500",
    "crd_ord_alow_repla":"000000006193400",
    "d2vexct_entr":"000000000012550",
    "d2ch_ord_alow_amt":"000000000012550",
    "return_code":0,
    "return_msg":"조회가 완료되었습니다."
}
```

---

## 위탁종합거래내역요청 (kt00015)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료일자 | String | Y | 8 | YYYYMMDD |
| tp | 구분 | String | Y | 1 | 0:전체, 1:입출금, 2:입출고, 3:매매, 4:매수, 5:매도, 6:입금, 7:출금, A:예탁담보대출입금, B:매도담보대출입금, C:현금상환(융자,담보상환), F:환전, M:입출금+환전, G:외화매수, H:외화매도, I:환전정산입금, J:환전정산출금 |
| stk_cd | 종목코드 | String | N | 12 | |
| crnc_cd | 통화코드 | String | N | 3 | |
| gds_tp | 상품구분 | String | Y | 1 | 0:전체, 1:국내주식, 2:수익증권, 3:해외주식, 4:금융상품 |
| frgn_stex_code | 해외거래소코드 | String | N | 10 | |
| dmst_stex_tp | 국내거래소구분 | String | Y | 6 | %:(전체), KRX:한국거래소, NXT:넥스트트레이드 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| trst_ovrl_trde_prps_array | 위탁종합거래내역배열 | LIST | N | - | |
| - trde_dt | 거래일자 | String | N | 8 | |
| - trde_no | 거래번호 | String | N | 9 | |
| - rmrk_nm | 적요명 | String | N | 60 | |
| - crd_deal_tp_nm | 신용거래구분명 | String | N | 20 | |
| - exct_amt | 정산금액 | String | N | 15 | |
| - loan_amt_rpya | 대출금상환 | String | N | 15 | |
| - fc_trde_amt | 거래금액(외) | String | N | 15 | |
| - fc_exct_amt | 정산금액(외) | String | N | 15 | |
| - entra_remn | 예수금잔고 | String | N | 15 | |
| - crnc_cd | 통화코드 | String | N | 3 | |
| - trde_ocr_tp | 거래종류구분 | String | N | 2 | 1:입출금, 2:펀드, 3:ELS, 4:채권, 5:해외채권, 6:외화RP, 7:외화발행어음 |
| - trde_kind_nm | 거래종류명 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 40 | |
| - trde_amt | 거래금액 | String | N | 15 | |
| - trde_agri_tax | 거래및농특세 | String | N | 15 | |
| - rpy_diffa | 상환차금 | String | N | 15 | |
| - fc_trde_tax | 거래세(외) | String | N | 15 | |
| - dly_sum | 연체합 | String | N | 15 | |
| - fc_entra | 외화예수금잔고 | String | N | 15 | |
| - mdia_tp_nm | 매체구분명 | String | N | 20 | |
| - io_tp | 입출구분 | String | N | 1 | |
| - io_tp_nm | 입출구분명 | String | N | 10 | |
| - orig_deal_no | 원거래번호 | String | N | 9 | |
| - stk_cd | 종목코드 | String | N | 12 | |
| - trde_qty_jwa_cnt | 거래수량/좌수 | String | N | 30 | |
| - cmsn | 수수료 | String | N | 15 | |
| - int_ls_usfe | 이자/대주이용 | String | N | 15 | |
| - fc_cmsn | 수수료(외) | String | N | 15 | |
| - fc_dly_sum | 연체합(외) | String | N | 15 | |
| - vlbl_nowrm | 유가금잔 | String | N | 30 | |
| - proc_tm | 처리시간 | String | N | 111 | |
| - isin_cd | ISIN코드 | String | N | 12 | |
| - stex_cd | 거래소코드 | String | N | 10 | |
| - stex_nm | 거래소명 | String | N | 20 | |
| - trde_unit | 거래단가/환율 | String | N | 20 | |
| - incm_resi_tax | 소득/주민세 | String | N | 15 | |
| - loan_dt | 대출일 | String | N | 8 | |
| - uncl_ocr | 미수(원/주) | String | N | 30 | |
| - rpym_sum | 변제합 | String | N | 30 | |
| - cntr_dt | 체결일 | String | N | 8 | |
| - rcpy_no | 출납번호 | String | N | 20 | |
| - prcsr | 처리자 | String | N | 20 | |
| - proc_brch | 처리점 | String | N | 20 | |
| - trde_stle | 매매형태 | String | N | 40 | |
| - txon_base_pric | 과세기준가 | String | N | 15 | |
| - tax_sum_cmsn | 세금수수료합 | String | N | 15 | |
| - frgn_pay_txam | 외국납부세액(외) | String | N | 15 | |
| - fc_uncl_ocr | 미수(외) | String | N | 15 | |
| - rpym_sum_fr | 변제합(외) | String | N | 30 | |
| - rcpmnyer | 입금자 | String | N | 20 | |
| - trde_prtc_tp | 거래내역구분 | String | N | 2 | |

### Python 예제 코드

```python
import requests
import json

# 위탁종합거래내역요청
def fn_kt00015(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00015', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'strt_dt': '20241121', # 시작일자 
        'end_dt': '20241125', # 종료일자 
        'tp': '0', # 구분 0:전체,1:입출금,2:입출고,3:매매,4:매수,5:매도,6:입금,7:출금,A:예탁담보대출입금,B:매도담보대출입금,C:현금상환(융자,담보상환),F:환전,M:입출금+환전,G:외화매수,H:외화매도,I:환전정산입금,J:환전정산출금
        'stk_cd': '', # 종목코드 
        'crnc_cd': '', # 통화코드 
        'gds_tp': '0', # 상품구분 0:전체, 1:국내주식, 2:수익증권, 3:해외주식, 4:금융상품
        'frgn_stex_code': '', # 해외거래소코드 
        'dmst_stex_tp': '%', # 국내거래소구분 %:(전체),KRX:한국거래소,NXT:넥스트트레이드
    }

    # 3. API 실행
    fn_kt00015(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00015(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "strt_dt" : "20241121",
    "end_dt" : "20241125",
    "tp" : "0",
    "stk_cd" : "",
    "crnc_cd" : "",
    "gds_tp" : "0",
    "frgn_stex_code" : "",
    "dmst_stex_tp" : "%"
}
```

#### Response
```json
{
    "acnt_no":"6081-2***-11 [김키움]",
    "trst_ovrl_trde_prps_array": [
        {
            "trde_dt":"20241121",
            "trde_no":"000000001",
            "rmrk_nm":"장내매도",
            "crd_deal_tp_nm":"보통매매",
            "exct_amt":"000000000056798",
            "loan_amt_rpya":"000000000000000",
            "fc_trde_amt":"0.00",
            "fc_exct_amt":"0.00",
            "entra_remn":"000000994658290",
            "crnc_cd":"KRW",
            "trde_ocr_tp":"9",
            "trde_kind_nm":"매매",
            "stk_nm":"삼성전자",
            "trde_amt":"000000000056900",
            "trde_agri_tax":"000000000000102",
            "rpy_diffa":"000000000000000",
            "fc_trde_tax":"0.00",
            "dly_sum":"000000000000000",
            "fc_entra":"0.00",
            "mdia_tp_nm":"REST API",
            "io_tp":"1",
            "io_tp_nm":"매도",
            "orig_deal_no":"000000000",
            "stk_cd":"A005930",
            "trde_qty_jwa_cnt":"1",
            "cmsn":"000000000000000",
            "int_ls_usfe":"000000000000000",
            "fc_cmsn":"0.00",
            "fc_dly_sum":"0.00",
            "vlbl_nowrm":"21",
            "proc_tm":"08:12:35",
            "isin_cd":"KR7005930003",
            "stex_cd":"",
            "stex_nm":"",
            "trde_unit":"56,900",
            "incm_resi_tax":"000000000000000",
            "loan_dt":"",
            "uncl_ocr":"",
            "rpym_sum":"",
            "cntr_dt":"20241119",
            "rcpy_no":"",
            "prcsr":"DAILY",
            "proc_brch":"키움은행",
            "trde_stle":"",
            "txon_base_pric":"0.00",
            "tax_sum_cmsn":"000000000000102",
            "frgn_pay_txam":"0.00",
            "fc_uncl_ocr":"0.00",
            "rpym_sum_fr":"",
            "rcpmnyer":"",
            "trde_prtc_tp":"11"
        }
    ],
    "return_code":0,
    "return_msg":"조회가 완료되었습니다"
}
```

---

## 일별계좌수익률상세현황요청 (kt00016)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| fr_dt | 평가시작일 | String | Y | 8 | YYYYMMDD |
| to_dt | 평가종료일 | String | Y | 8 | YYYYMMDD |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| mang_empno | 관리사원번호 | String | N | 8 | |
| mngr_nm | 관리자명 | String | N | 8 | |
| dept_nm | 관리자지점 | String | N | 30 | |
| entr_fr | 예수금_초 | String | N | 30 | |
| entr_to | 예수금_말 | String | N | 12 | |
| scrt_evlt_amt_fr | 유가증권평가금액_초 | String | N | 12 | |
| scrt_evlt_amt_to | 유가증권평가금액_말 | String | N | 12 | |
| ls_grnt_fr | 대주담보금_초 | String | N | 12 | |
| ls_grnt_to | 대주담보금_말 | String | N | 12 | |
| crd_loan_fr | 신용융자금_초 | String | N | 12 | |
| crd_loan_to | 신용융자금_말 | String | N | 12 | |
| ch_uncla_fr | 현금미수금_초 | String | N | 12 | |
| ch_uncla_to | 현금미수금_말 | String | N | 12 | |
| krw_asgna_fr | 원화대용금_초 | String | N | 12 | |
| krw_asgna_to | 원화대용금_말 | String | N | 12 | |
| ls_evlta_fr | 대주평가금_초 | String | N | 12 | |
| ls_evlta_to | 대주평가금_말 | String | N | 12 | |
| rght_evlta_fr | 권리평가금_초 | String | N | 12 | |
| rght_evlta_to | 권리평가금_말 | String | N | 12 | |
| loan_amt_fr | 대출금_초 | String | N | 12 | |
| loan_amt_to | 대출금_말 | String | N | 12 | |
| etc_loana_fr | 기타대여금_초 | String | N | 12 | |
| etc_loana_to | 기타대여금_말 | String | N | 12 | |
| crd_int_npay_gold_fr | 신용이자미납금_초 | String | N | 12 | |
| crd_int_npay_gold_to | 신용이자미납금_말 | String | N | 12 | |
| crd_int_fr | 신용이자_초 | String | N | 12 | |
| crd_int_to | 신용이자_말 | String | N | 12 | |
| tot_amt_fr | 순자산액계_초 | String | N | 12 | |
| tot_amt_to | 순자산액계_말 | String | N | 12 | |
| invt_bsamt | 투자원금평잔 | String | N | 12 | |
| evltv_prft | 평가손익 | String | N | 12 | |
| prft_rt | 수익률 | String | N | 12 | |
| tern_rt | 회전율 | String | N | 12 | |
| termin_tot_trns | 기간내총입금 | String | N | 12 | |
| termin_tot_pymn | 기간내총출금 | String | N | 12 | |
| termin_tot_inq | 기간내총입고 | String | N | 12 | |
| termin_tot_outq | 기간내총출고 | String | N | 12 | |
| futr_repl_sella | 선물대용매도금액 | String | N | 12 | |
| trst_repl_sella | 위탁대용매도금액 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 일별계좌수익률상세현황요청
def fn_kt00016(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00016', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'fr_dt': '20241111', # 평가시작일 
        'to_dt': '20241125', # 평가종료일 
    }

    # 3. API 실행
    fn_kt00016(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00016(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "fr_dt" : "20241111",
    "to_dt" : "20241125"
}
```

#### Response
```json
{
    "mang_empno":"081",
    "mngr_nm":"키움은행",
    "dept_nm":"키움은행",
    "entr_fr":"000000000000",
    "entr_to":"000000017534",
    "scrt_evlt_amt_fr":"000000000000",
    "scrt_evlt_amt_to":"000000000000",
    "ls_grnt_fr":"000000000000",
    "ls_grnt_to":"000000000000",
    "crd_loan_fr":"000000000000",
    "crd_loan_to":"000000000000",
    "ch_uncla_fr":"000000000000",
    "ch_uncla_to":"000000000000",
    "krw_asgna_fr":"000000000000",
    "krw_asgna_to":"000000000000",
    "ls_evlta_fr":"000000000000",
    "ls_evlta_to":"000000000000",
    "rght_evlta_fr":"000000000000",
    "rght_evlta_to":"000000000000",
    "loan_amt_fr":"000000000000",
    "loan_amt_to":"000000000000",
    "etc_loana_fr":"000000000000",
    "etc_loana_to":"000000000000",
    "crd_int_npay_gold_fr":"000000000000",
    "crd_int_npay_gold_to":"000000000000",
    "crd_int_fr":"000000000000",
    "crd_int_to":"000000000000",
    "tot_amt_fr":"000000000000",
    "tot_amt_to":"000000017534",
    "invt_bsamt":"000000000000",
    "evltv_prft":"-00005482466",
    "prft_rt":"-0.91",
    "tern_rt":"0.84",
    "termin_tot_trns":"000000000000",
    "termin_tot_pymn":"000000000000",
    "termin_tot_inq":"000000000000",
    "termin_tot_outq":"000000000000",
    "futr_repl_sella":"000000000000",
    "trst_repl_sella":"000000000000",
    "return_code":0,
    "return_msg":"조회가 완료되었습니다."
}
```

---

## 계좌별당일현황요청 (kt00017)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| | (입력 파라미터 없음) | | | | |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| d2_entra | D+2추정예수금 | String | N | 12 | |
| crd_int_npay_gold | 신용이자미납금 | String | N | 12 | |
| etc_loana | 기타대여금 | String | N | 12 | |
| gnrl_stk_evlt_amt_d2 | 일반주식평가금액D+2 | String | N | 12 | |
| dpst_grnt_use_amt_d2 | 예탁담보대출금D+2 | String | N | 12 | |
| crd_stk_evlt_amt_d2 | 예탁담보주식평가금액D+2 | String | N | 12 | |
| crd_loan_d2 | 신용융자금D+2 | String | N | 12 | |
| crd_loan_evlta_d2 | 신용융자평가금D+2 | String | N | 12 | |
| crd_ls_grnt_d2 | 신용대주담보금D+2 | String | N | 12 | |
| crd_ls_evlta_d2 | 신용대주평가금D+2 | String | N | 12 | |
| ina_amt | 입금금액 | String | N | 12 | |
| outa | 출금금액 | String | N | 12 | |
| inq_amt | 입고금액 | String | N | 12 | |
| outq_amt | 출고금액 | String | N | 12 | |
| sell_amt | 매도금액 | String | N | 12 | |
| buy_amt | 매수금액 | String | N | 12 | |
| cmsn | 수수료 | String | N | 12 | |
| tax | 세금 | String | N | 12 | |
| stk_pur_cptal_loan_amt | 주식매입자금대출금 | String | N | 12 | |
| rp_evlt_amt | RP평가금액 | String | N | 12 | |
| bd_evlt_amt | 채권평가금액 | String | N | 12 | |
| elsevlt_amt | ELS평가금액 | String | N | 12 | |
| crd_int_amt | 신용이자금액 | String | N | 12 | |
| sel_prica_grnt_loan_int_amt_amt | 매도대금담보대출이자금액 | String | N | 12 | |
| dvida_amt | 배당금액 | String | N | 12 | |

### Python 예제 코드

```python
import requests
import json

# 계좌별당일현황요청
def fn_kt00017(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00017', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {}

    # 3. API 실행
    fn_kt00017(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00017(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{}
```

#### Response
```json
{
    "d2_entra":"000000012550",
    "crd_int_npay_gold":"000000000000",
    "etc_loana":"000000000000",
    "gnrl_stk_evlt_amt_d2":"000005724100",
    "dpst_grnt_use_amt_d2":"000000000000",
    "crd_stk_evlt_amt_d2":"000000000000",
    "crd_loan_d2":"000000000000",
    "crd_loan_evlta_d2":"000000000000",
    "crd_ls_grnt_d2":"000000000000",
    "crd_ls_evlta_d2":"000000000000",
    "ina_amt":"000000000000",
    "outa":"000000000000",
    "inq_amt":"000000000000",
    "outq_amt":"000000000000",
    "sell_amt":"000000000000",
    "buy_amt":"000000000000",
    "cmsn":"000000000000",
    "tax":"000000000000",
    "stk_pur_cptal_loan_amt":"000000000000",
    "rp_evlt_amt":"000000000000",
    "bd_evlt_amt":"000000000000",
    "elsevlt_amt":"000000000000",
    "crd_int_amt":"000000000000",
    "sel_prica_grnt_loan_int_amt_amt":"000000000000",
    "dvida_amt":"000000000000",
    "return_code":0,
    "return_msg":"조회가 완료되었습니다.."
}
```

---

## 계좌평가잔고내역요청 (kt00018)

### 기본 정보

**Method:** POST  
**운영 도메인:** https://api.kiwoom.com  
**모의투자 도메인:** https://mockapi.kiwoom.com (KRX만 지원가능)  
**URL:** /api/dostk/acnt  
**Format:** JSON  
**Content-Type:** application/json;charset=UTF-8

### 요청 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출 예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| qry_tp | 조회구분 | String | Y | 1 | 1:합산, 2:개별 |
| dmst_stex_tp | 국내거래소구분 | String | Y | 6 | KRX:한국거래소, NXT:넥스트트레이드 |

### 응답 사양

#### Header

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

#### Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|---------|-------------|
| tot_pur_amt | 총매입금액 | String | N | 15 | |
| tot_evlt_amt | 총평가금액 | String | N | 15 | |
| tot_evlt_pl | 총평가손익금액 | String | N | 15 | |
| tot_prft_rt | 총수익률(%) | String | N | 12 | |
| prsm_dpst_aset_amt | 추정예탁자산 | String | N | 15 | |
| tot_loan_amt | 총대출금 | String | N | 15 | |
| tot_crd_loan_amt | 총융자금액 | String | N | 15 | |
| tot_crd_ls_amt | 총대주금액 | String | N | 15 | |
| acnt_evlt_remn_indv_tot | 계좌평가잔고개별합산 | LIST | N | - | |
| - stk_cd | 종목번호 | String | N | 12 | |
| - stk_nm | 종목명 | String | N | 40 | |
| - evltv_prft | 평가손익 | String | N | 15 | |
| - prft_rt | 수익률(%) | String | N | 12 | |
| - pur_pric | 매입가 | String | N | 15 | |
| - pred_close_pric | 전일종가 | String | N | 12 | |
| - rmnd_qty | 보유수량 | String | N | 15 | |
| - trde_able_qty | 매매가능수량 | String | N | 15 | |
| - cur_prc | 현재가 | String | N | 12 | |
| - pred_buyq | 전일매수수량 | String | N | 15 | |
| - pred_sellq | 전일매도수량 | String | N | 15 | |
| - tdy_buyq | 금일매수수량 | String | N | 15 | |
| - tdy_sellq | 금일매도수량 | String | N | 15 | |
| - pur_amt | 매입금액 | String | N | 15 | |
| - pur_cmsn | 매입수수료 | String | N | 15 | |
| - evlt_amt | 평가금액 | String | N | 15 | |
| - sell_cmsn | 평가수수료 | String | N | 15 | |
| - tax | 세금 | String | N | 15 | |
| - sum_cmsn | 수수료합 | String | N | 15 | 매입수수료 + 평가수수료 |
| - poss_rt | 보유비중(%) | String | N | 12 | |
| - crd_tp | 신용구분 | String | N | 2 | |
| - crd_tp_nm | 신용구분명 | String | N | 4 | |
| - crd_loan_dt | 대출일 | String | N | 8 | |

### Python 예제 코드

```python
import requests
import json

# 계좌평가잔고내역요청
def fn_kt00018(token, data, cont_yn='N', next_key=''):
    # 1. 요청할 API URL
    #host = 'https://mockapi.kiwoom.com' # 모의투자
    host = 'https://api.kiwoom.com' # 실전투자
    endpoint = '/api/dostk/acnt'
    url =  host + endpoint

    # 2. header 데이터
    headers = {
        'Content-Type': 'application/json;charset=UTF-8', # 컨텐츠타입
        'authorization': f'Bearer {token}', # 접근토큰
        'cont-yn': cont_yn, # 연속조회여부
        'next-key': next_key, # 연속조회키
        'api-id': 'kt00018', # TR명
    }

    # 3. http POST 요청
    response = requests.post(url, headers=headers, json=data)

    # 4. 응답 상태 코드와 데이터 출력
    print('Code:', response.status_code)
    print('Header:', json.dumps({key: response.headers.get(key) for key in ['next-key', 'cont-yn', 'api-id']}, indent=4, ensure_ascii=False))
    print('Body:', json.dumps(response.json(), indent=4, ensure_ascii=False))  # JSON 응답을 파싱하여 출력

# 실행 구간
if __name__ == '__main__':
    # 1. 토큰 설정
    MY_ACCESS_TOKEN = '사용자 AccessToken' # 접근토큰

    # 2. 요청 데이터
    params = {
        'qry_tp': '1', # 조회구분 1:합산, 2:개별
        'dmst_stex_tp': 'KRX', # 국내거래소구분 KRX:한국거래소,NXT:넥스트트레이드
    }

    # 3. API 실행
    fn_kt00018(token=MY_ACCESS_TOKEN, data=params)

    # next-key, cont-yn 값이 있을 경우
    # fn_kt00018(token=MY_ACCESS_TOKEN, data=params, cont_yn='Y', next_key='nextkey..')
```

### 요청/응답 예제

#### Request
```json
{
    "qry_tp" : "1",
    "dmst_stex_tp" : "KRX"
}
```

#### Response
```json
{
    "tot_pur_amt": "000005500000000",
    "tot_evlt_amt": "000005724100000",
    "tot_evlt_pl": "000000224100000",
    "tot_prft_rt": "4.08",
    "prsm_dpst_aset_amt": "000005736650000",
    "tot_loan_amt": "000000000000000",
    "tot_crd_loan_amt": "000000000000000",
    "tot_crd_ls_amt": "000000000000000",
    "acnt_evlt_remn_indv_tot": [
        {
            "stk_cd": "A005930",
            "stk_nm": "삼성전자",
            "evltv_prft": "000000113556000",
            "prft_rt": "1.85",
            "pur_pric": "000000124500",
            "pred_close_pric": "000000070000",
            "rmnd_qty": "000000000047",
            "trde_able_qty": "000000000047",
            "cur_prc": "000000070000",
            "pred_buyq": "000000000000",
            "pred_sellq": "000000000000",
            "tdy_buyq": "000000000000",
            "tdy_sellq": "000000000000",
            "pur_amt": "000006122786000",
            "pur_cmsn": "000000002500000",
            "evlt_amt": "000006236342000",
            "sell_cmsn": "000000003119000",
            "tax": "000000005602000",
            "sum_cmsn": "000000005619000",
            "poss_rt": "100.00",
            "crd_tp": "00",
            "crd_tp_nm": "보통",
            "crd_loan_dt": ""
        }
    ],
    "return_code": 0,
    "return_msg": "조회가 완료되었습니다."
}
```

---