# 키움증권 API 문서

## 국내주식 REST API

### 공매도

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 공매도추이요청 | ka10014 | 공매도 추이 정보 조회 |

---

### 공매도추이요청 (ka10014)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/shsa
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명       | Type   | Required | Length | Description                                                                |
| -------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------------------- |
| stk_cd   | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)           |
| tm_tp    | 시간구분     | String | N        | 1      | 0:시작일, 1:기간                                                          |
| strt_dt  | 시작일자     | String | Y        | 8      | YYYYMMDD                                                                   |
| end_dt   | 종료일자     | String | Y        | 8      | YYYYMMDD                                                                   |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명           | Type   | Required | Length | Description                      |
| -------------------- | ---------------- | ------ | -------- | ------ | -------------------------------- |
| shrts_trnsn          | 공매도추이       | LIST   | N        |        |                                  |
| - dt                 | 일자             | String | N        | 20     |                                  |
| - close_pric         | 종가             | String | N        | 20     |                                  |
| - pred_pre_sig       | 전일대비기호     | String | N        | 20     |                                  |
| - pred_pre           | 전일대비         | String | N        | 20     |                                  |
| - flu_rt             | 등락율           | String | N        | 20     |                                  |
| - trde_qty           | 거래량           | String | N        | 20     |                                  |
| - shrts_qty          | 공매도량         | String | N        | 20     |                                  |
| - ovr_shrts_qty      | 누적공매도량     | String | N        | 20     | 설정 기간의 공매도량 합산데이터  |
| - trde_wght          | 매매비중         | String | N        | 20     |                                  |
| - shrts_trde_prica   | 공매도거래대금   | String | N        | 20     |                                  |
| - shrts_avg_pric     | 공매도평균가     | String | N        | 20     |                                  |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"tm_tp": "1",
	"strt_dt": "20250501",
	"end_dt": "20250519"
}
```

#### 응답 예시

```json
{
	"shrts_trnsn": [
		{
			"dt": "20250519",
			"close_pric": "-55800",
			"pred_pre_sig": "5",
			"pred_pre": "-1000",
			"flu_rt": "-1.76",
			"trde_qty": "9802105",
			"shrts_qty": "841407",
			"ovr_shrts_qty": "6424755",
			"trde_wght": "+8.58",
			"shrts_trde_prica": "46985302",
			"shrts_avg_pric": "55841"
		},
		{
			"dt": "20250516",
			"close_pric": "-56800",
			"pred_pre_sig": "5",
			"pred_pre": "-500",
			"flu_rt": "-0.87",
			"trde_qty": "10385352",
			"shrts_qty": "487354",
			"ovr_shrts_qty": "5583348",
			"trde_wght": "+4.69",
			"shrts_trde_prica": "27725268",
			"shrts_avg_pric": "56889"
		},
		{
			"dt": "20250515",
			"close_pric": "-57300",
			"pred_pre_sig": "5",
			"pred_pre": "-100",
			"flu_rt": "-0.17",
			"trde_qty": "13139736",
			"shrts_qty": "404120",
			"ovr_shrts_qty": "5095994",
			"trde_wght": "+3.08",
			"shrts_trde_prica": "23278677",
			"shrts_avg_pric": "57603"
		},
		{
			"dt": "20250514",
			"close_pric": "+57400",
			"pred_pre_sig": "2",
			"pred_pre": "+500",
			"flu_rt": "+0.88",
			"trde_qty": "12468089",
			"shrts_qty": "607315",
			"ovr_shrts_qty": "4691874",
			"trde_wght": "+4.87",
			"shrts_trde_prica": "34862170",
			"shrts_avg_pric": "57404"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---
