# 키움증권 API 문서

## 국내주식 REST API

### 기관/외국인

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 주식외국인종목별매매동향 | ka10008 | 주식 외국인 종목별 매매 동향 조회 |
| 주식기관요청 | ka10009 | 주식 기관 정보 조회 |
| 기관외국인연속매매현황요청 | ka10131 | 기관/외국인 연속매매현황 조회 |

---

### 주식외국인종목별매매동향 (ka10008)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/frgnistt
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명           | Type   | Required | Length | Description |
| --------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| stk_frgnr             | 주식외국인       | LIST   | N        |        |             |
| - dt                  | 일자             | String | N        | 20     |             |
| - close_pric          | 종가             | String | N        | 20     |             |
| - pred_pre            | 전일대비         | String | N        | 20     |             |
| - trde_qty            | 거래량           | String | N        | 20     |             |
| - chg_qty             | 변동수량         | String | N        | 20     |             |
| - poss_stkcnt         | 보유주식수       | String | N        | 20     |             |
| - wght                | 비중             | String | N        | 20     |             |
| - gain_pos_stkcnt     | 취득가능주식수   | String | N        | 20     |             |
| - frgnr_limit         | 외국인한도       | String | N        | 20     |             |
| - frgnr_limit_irds    | 외국인한도증감   | String | N        | 20     |             |
| - limit_exh_rt        | 한도소진률       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd": "005930"
}
```

#### 응답 예시

```json
{
	"stk_frgnr": [
		{
			"dt": "20241105",
			"close_pric": "135300",
			"pred_pre": "0",
			"trde_qty": "0",
			"chg_qty": "0",
			"poss_stkcnt": "6663509",
			"wght": "+26.10",
			"gain_pos_stkcnt": "18863197",
			"frgnr_limit": "25526706",
			"frgnr_limit_irds": "0",
			"limit_exh_rt": "+26.10"
		},
		{
			"dt": "20241101",
			"close_pric": "65100",
			"pred_pre": "0",
			"trde_qty": "0",
			"chg_qty": "-3441",
			"poss_stkcnt": "6642402",
			"wght": "+26.02",
			"gain_pos_stkcnt": "18884304",
			"frgnr_limit": "25526706",
			"frgnr_limit_irds": "0",
			"limit_exh_rt": "+26.02"
		},
		{
			"dt": "20241031",
			"close_pric": "65100",
			"pred_pre": "0",
			"trde_qty": "0",
			"chg_qty": "4627",
			"poss_stkcnt": "6645843",
			"wght": "+26.03",
			"gain_pos_stkcnt": "18880863",
			"frgnr_limit": "25526706",
			"frgnr_limit_irds": "0",
			"limit_exh_rt": "+26.03"
		},
		{
			"dt": "20241030",
			"close_pric": "+65100",
			"pred_pre": "+100",
			"trde_qty": "1",
			"chg_qty": "-10245",
			"poss_stkcnt": "6641216",
			"wght": "+26.02",
			"gain_pos_stkcnt": "18885490",
			"frgnr_limit": "25526706",
			"frgnr_limit_irds": "0",
			"limit_exh_rt": "+26.02"
		},
		{
			"dt": "20241029",
			"close_pric": "-65000",
			"pred_pre": "-27300",
			"trde_qty": "4",
			"chg_qty": "249",
			"poss_stkcnt": "6651461",
			"wght": "+26.06",
			"gain_pos_stkcnt": "18875245",
			"frgnr_limit": "25526706",
			"frgnr_limit_irds": "0",
			"limit_exh_rt": "+26.06"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식기관요청 (ka10009)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/frgnistt
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명               | Type   | Required | Length | Description |
| ---------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| date                   | 날짜                 | String | N        | 20     |             |
| close_pric             | 종가                 | String | N        | 20     |             |
| pre                    | 대비                 | String | N        | 20     |             |
| orgn_dt_acc            | 기관기간누적         | String | N        | 20     |             |
| orgn_daly_nettrde      | 기관일별순매매       | String | N        | 20     |             |
| frgnr_daly_nettrde     | 외국인일별순매매     | String | N        | 20     |             |
| frgnr_qota_rt          | 외국인지분율         | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd": "005930"
}
```

#### 응답 예시

```json
{
	"date": "20241105",
	"close_pric": "135300",
	"pre": "0",
	"orgn_dt_acc": "",
	"orgn_daly_nettrde": "",
	"frgnr_daly_nettrde": "",
	"frgnr_qota_rt": "",
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 기관외국인연속매매현황요청 (ka10131)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/frgnistt
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                                                                                          |
| ------------ | -------------- | ------ | -------- | ------ | ---------------------------------------------------------------------------------------------------- |
| dt           | 기간           | String | Y        | 3      | 1:최근일, 3:3일, 5:5일, 10:10일, 20:20일, 120:120일, 0:시작일자/종료일자로 조회                     |
| strt_dt      | 시작일자       | String | N        | 8      | YYYYMMDD                                                                                             |
| end_dt       | 종료일자       | String | N        | 8      | YYYYMMDD                                                                                             |
| mrkt_tp      | 장구분         | String | Y        | 3      | 001:코스피, 101:코스닥                                                                               |
| netslmt_tp   | 순매도수구분   | String | Y        | 1      | 2:순매수(고정값)                                                                                     |
| stk_inds_tp  | 종목업종구분   | String | Y        | 1      | 0:종목(주식),1:업종                                                                                  |
| amt_qty_tp   | 금액수량구분   | String | Y        | 1      | 0:금액, 1:수량                                                                                       |
| stex_tp      | 거래소구분     | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                          | 한글명                   | Type   | Required | Length | Description |
| -------------------------------- | ------------------------ | ------ | -------- | ------ | ----------- |
| orgn_frgnr_cont_trde_prst        | 기관외국인연속매매현황   | LIST   | N        |        |             |
| - rank                           | 순위                     | String | N        |        |             |
| - stk_cd                         | 종목코드                 | String | N        | 6      |             |
| - stk_nm                         | 종목명                   | String | N        | 20     |             |
| - prid_stkpc_flu_rt              | 기간중주가등락률         | String | N        |        |             |
| - orgn_nettrde_amt               | 기관순매매금액           | String | N        |        |             |
| - orgn_nettrde_qty               | 기관순매매량             | String | N        |        |             |
| - orgn_cont_netprps_dys          | 기관계연속순매수일수     | String | N        |        |             |
| - orgn_cont_netprps_qty          | 기관계연속순매수량       | String | N        |        |             |
| - orgn_cont_netprps_amt          | 기관계연속순매수금액     | String | N        |        |             |
| - frgnr_nettrde_qty              | 외국인순매매량           | String | N        |        |             |
| - frgnr_nettrde_amt              | 외국인순매매액           | String | N        |        |             |
| - frgnr_cont_netprps_dys         | 외국인연속순매수일수     | String | N        |        |             |
| - frgnr_cont_netprps_qty         | 외국인연속순매수량       | String | N        |        |             |
| - frgnr_cont_netprps_amt         | 외국인연속순매수금액     | String | N        |        |             |
| - nettrde_qty                    | 순매매량                 | String | N        |        |             |
| - nettrde_amt                    | 순매매액                 | String | N        |        |             |
| - tot_cont_netprps_dys           | 합계연속순매수일수       | String | N        |        |             |
| - tot_cont_nettrde_qty           | 합계연속순매매수량       | String | N        |        |             |
| - tot_cont_netprps_amt           | 합계연속순매수금액       | String | N        |        |             |

#### 요청 예시

```json
{
	"dt": "1",
	"strt_dt": "",
	"end_dt": "",
	"mrkt_tp": "001",
	"netslmt_tp": "2",
	"stk_inds_tp": "0",
	"amt_qty_tp": "0",
	"stex_tp": "1"
}
```

#### 응답 예시

```json
{
	"orgn_frgnr_cont_trde_prst": [
		{
			"rank": "1",
			"stk_cd": "005930",
			"stk_nm": "삼성전자",
			"prid_stkpc_flu_rt": "-5.80",
			"orgn_nettrde_amt": "+48",
			"orgn_nettrde_qty": "+173",
			"orgn_cont_netprps_dys": "+1",
			"orgn_cont_netprps_qty": "+173",
			"orgn_cont_netprps_amt": "+48",
			"frgnr_nettrde_qty": "+0",
			"frgnr_nettrde_amt": "+0",
			"frgnr_cont_netprps_dys": "+1",
			"frgnr_cont_netprps_qty": "+1",
			"frgnr_cont_netprps_amt": "+0",
			"nettrde_qty": "+173",
			"nettrde_amt": "+48",
			"tot_cont_netprps_dys": "+2",
			"tot_cont_nettrde_qty": "+174",
			"tot_cont_netprps_amt": "+48"
		},
		{
			"rank": "2",
			"stk_cd": "005930",
			"stk_nm": "삼성전자",
			"prid_stkpc_flu_rt": "-4.21",
			"orgn_nettrde_amt": "+41",
			"orgn_nettrde_qty": "+159",
			"orgn_cont_netprps_dys": "+1",
			"orgn_cont_netprps_qty": "+159",
			"orgn_cont_netprps_amt": "+41",
			"frgnr_nettrde_qty": "+0",
			"frgnr_nettrde_amt": "+0",
			"frgnr_cont_netprps_dys": "+1",
			"frgnr_cont_netprps_qty": "+1",
			"frgnr_cont_netprps_amt": "+0",
			"nettrde_qty": "+159",
			"nettrde_amt": "+41",
			"tot_cont_netprps_dys": "+2",
			"tot_cont_nettrde_qty": "+160",
			"tot_cont_netprps_amt": "+42"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---
