# 키움증권 API 문서

## 국내주식 REST API

### 대차거래

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 대차거래추이요청 | ka10068 | 대차거래 추이 정보 조회 |
| 대차거래상위10종목요청 | ka10069 | 대차거래 상위 10종목 조회 |
| 대차거래추이요청(종목별) | ka20068 | 대차거래 추이 정보 조회 (종목별) |
| 대차거래내역요청 | ka90012 | 대차거래 내역 조회 |

---

### 대차거래추이요청 (ka10068)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/slb
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description      |
| ------- | -------- | ------ | -------- | ------ | ---------------- |
| strt_dt | 시작일자 | String | N        | 8      | YYYYMMDD         |
| end_dt  | 종료일자 | String | N        | 8      | YYYYMMDD         |
| all_tp  | 전체구분 | String | Y        | 6      | 1: 전체표시      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description |
| ------------------------ | ---------------- | ------ | -------- | ------ | ----------- |
| dbrt_trde_trnsn          | 대차거래추이     | LIST   | N        |        |             |
| - dt                     | 일자             | String | N        | 8      |             |
| - dbrt_trde_cntrcnt      | 대차거래체결주수 | String | N        | 12     |             |
| - dbrt_trde_rpy          | 대차거래상환주수 | String | N        | 18     |             |
| - dbrt_trde_irds         | 대차거래증감     | String | N        | 60     |             |
| - rmnd                   | 잔고주수         | String | N        | 18     |             |
| - remn_amt               | 잔고금액         | String | N        | 18     |             |

#### 요청 예시

```json
{
	"strt_dt": "20250401",
	"end_dt": "20250430",
	"all_tp": "1"
}
```

#### 응답 예시

```json
{
	"dbrt_trde_trnsn": [
		{
			"dt": "20250430",
			"dbrt_trde_cntrcnt": "35330036",
			"dbrt_trde_rpy": "25217364",
			"dbrt_trde_irds": "10112672",
			"rmnd": "2460259444",
			"remn_amt": "73956254"
		},
		{
			"dt": "20250429",
			"dbrt_trde_cntrcnt": "23721553",
			"dbrt_trde_rpy": "13986586",
			"dbrt_trde_irds": "9734967",
			"rmnd": "2125919149",
			"remn_amt": "66422682"
		},
		{
			"dt": "20250428",
			"dbrt_trde_cntrcnt": "17165250",
			"dbrt_trde_rpy": "30883228",
			"dbrt_trde_irds": "-13717978",
			"rmnd": "2276180199",
			"remn_amt": "68480718"
		},
		{
			"dt": "20250425",
			"dbrt_trde_cntrcnt": "62932490",
			"dbrt_trde_rpy": "85148199",
			"dbrt_trde_irds": "-22215709",
			"rmnd": "2355269107",
			"remn_amt": "69882489"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 대차거래상위10종목요청 (ka10069)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/slb
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                 |
| ------- | -------- | ------ | -------- | ------ | ----------------------------------------------------------- |
| strt_dt | 시작일자 | String | Y        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)          |
| end_dt  | 종료일자 | String | N        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)          |
| mrkt_tp | 시장구분 | String | Y        | 3      | 001:코스피, 101:코스닥                                      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명               | Type   | Required | Length | Description |
| ------------------------ | -------------------- | ------ | -------- | ------ | ----------- |
| dbrt_trde_cntrcnt_sum    | 대차거래체결주수합   | String | N        |        |             |
| dbrt_trde_rpy_sum        | 대차거래상환주수합   | String | N        |        |             |
| rmnd_sum                 | 잔고주수합           | String | N        |        |             |
| remn_amt_sum             | 잔고금액합           | String | N        |        |             |
| dbrt_trde_cntrcnt_rt     | 대차거래체결주수비율 | String | N        |        |             |
| dbrt_trde_rpy_rt         | 대차거래상환주수비율 | String | N        |        |             |
| rmnd_rt                  | 잔고주수비율         | String | N        |        |             |
| remn_amt_rt              | 잔고금액비율         | String | N        |        |             |
| dbrt_trde_upper_10stk    | 대차거래상위10종목   | LIST   | N        |        |             |
| - stk_nm                 | 종목명               | String | N        | 20     |             |
| - stk_cd                 | 종목코드             | String | N        | 20     |             |
| - dbrt_trde_cntrcnt      | 대차거래체결주수     | String | N        | 20     |             |
| - dbrt_trde_rpy          | 대차거래상환주수     | String | N        | 20     |             |
| - rmnd                   | 잔고주수             | String | N        | 20     |             |
| - remn_amt               | 잔고금액             | String | N        | 20     |             |

#### 요청 예시

```json
{
	"strt_dt": "20241110",
	"end_dt": "20241125",
	"mrkt_tp": "001"
}
```

#### 응답 예시

```json
{
	"dbrt_trde_cntrcnt_sum": "3383301",
	"dbrt_trde_rpy_sum": "764254",
	"rmnd_sum": "173782689",
	"remn_amt_sum": "14218184",
	"dbrt_trde_cntrcnt_rt": "7061",
	"dbrt_trde_rpy_rt": "3196",
	"rmnd_rt": "2225",
	"remn_amt_rt": "3728",
	"dbrt_trde_upper_10stk": [
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "1209600",
			"dbrt_trde_rpy": "0",
			"rmnd": "1505173",
			"remn_amt": "1203"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "681807",
			"dbrt_trde_rpy": "304467",
			"rmnd": "122704705",
			"remn_amt": "9546426"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "297431",
			"dbrt_trde_rpy": "208222",
			"rmnd": "13731939",
			"remn_amt": "1691775"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "230866",
			"dbrt_trde_rpy": "301",
			"rmnd": "3012573",
			"remn_amt": "104838"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 대차거래추이요청(종목별) (ka20068)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/slb
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                           |
| ------- | -------- | ------ | -------- | ------ | ------------------------------------- |
| strt_dt | 시작일자 | String | N        | 8      | YYYYMMDD                              |
| end_dt  | 종료일자 | String | N        | 8      | YYYYMMDD                              |
| all_tp  | 전체구분 | String | N        | 1      | 0:종목코드 입력종목만 표시            |
| stk_cd  | 종목코드 | String | Y        | 6      |                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description |
| ------------------------ | ---------------- | ------ | -------- | ------ | ----------- |
| dbrt_trde_trnsn          | 대차거래추이     | LIST   | N        |        |             |
| - dt                     | 일자             | String | N        | 20     |             |
| - dbrt_trde_cntrcnt      | 대차거래체결주수 | String | N        | 20     |             |
| - dbrt_trde_rpy          | 대차거래상환주수 | String | N        | 20     |             |
| - dbrt_trde_irds         | 대차거래증감     | String | N        | 20     |             |
| - rmnd                   | 잔고주수         | String | N        | 20     |             |
| - remn_amt               | 잔고금액         | String | N        | 20     |             |

#### 요청 예시

```json
{
	"strt_dt": "20250401",
	"end_dt": "20250430",
	"all_tp": "0",
	"stk_cd": "005930"
}
```

#### 응답 예시

```json
{
	"dbrt_trde_trnsn": [
		{
			"dt": "20250430",
			"dbrt_trde_cntrcnt": "1210354",
			"dbrt_trde_rpy": "2693108",
			"dbrt_trde_irds": "-1482754",
			"rmnd": "98242435",
			"remn_amt": "5452455"
		},
		{
			"dt": "20250429",
			"dbrt_trde_cntrcnt": "502018",
			"dbrt_trde_rpy": "1022714",
			"dbrt_trde_irds": "-520696",
			"rmnd": "99725189",
			"remn_amt": "5564666"
		},
		{
			"dt": "20250428",
			"dbrt_trde_cntrcnt": "958772",
			"dbrt_trde_rpy": "3122807",
			"dbrt_trde_irds": "-2164035",
			"rmnd": "100245885",
			"remn_amt": "5593720"
		},
		{
			"dt": "20250425",
			"dbrt_trde_cntrcnt": "1504273",
			"dbrt_trde_rpy": "5217540",
			"dbrt_trde_irds": "-3713267",
			"rmnd": "102409920",
			"remn_amt": "5704233"
		},
		{
			"dt": "20250424",
			"dbrt_trde_cntrcnt": "1803312",
			"dbrt_trde_rpy": "6076301",
			"dbrt_trde_irds": "-4272989",
			"rmnd": "106123187",
			"remn_amt": "5911062"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 대차거래내역요청 (ka90012)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/slb
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                 |
| ------- | -------- | ------ | -------- | ------ | --------------------------- |
| dt      | 일자     | String | Y        | 8      | YYYYMMDD                    |
| mrkt_tp | 시장구분 | String | Y        | 3      | 001:코스피, 101:코스닥      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description |
| ------------------------ | ---------------- | ------ | -------- | ------ | ----------- |
| dbrt_trde_prps           | 대차거래내역     | LIST   | N        |        |             |
| - stk_nm                 | 종목명           | String | N        | 20     |             |
| - stk_cd                 | 종목코드         | String | N        | 20     |             |
| - dbrt_trde_cntrcnt      | 대차거래체결주수 | String | N        | 20     |             |
| - dbrt_trde_rpy          | 대차거래상환주수 | String | N        | 20     |             |
| - rmnd                   | 잔고주수         | String | N        | 20     |             |
| - remn_amt               | 잔고금액         | String | N        | 20     |             |

#### 요청 예시

```json
{
	"dt": "20241101",
	"mrkt_tp": "101"
}
```

#### 응답 예시

```json
{
	"dbrt_trde_prps": [
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "20262",
			"dbrt_trde_rpy": "3493",
			"rmnd": "12812813",
			"remn_amt": "1026306"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "336116",
			"dbrt_trde_rpy": "145001",
			"rmnd": "9689378",
			"remn_amt": "1644287"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "55055",
			"dbrt_trde_rpy": "68866",
			"rmnd": "9341419",
			"remn_amt": "595983"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "6704",
			"dbrt_trde_rpy": "16000",
			"rmnd": "7167500",
			"remn_amt": "25803"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "0",
			"dbrt_trde_rpy": "6500",
			"rmnd": "6730107",
			"remn_amt": "13595"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "13550",
			"dbrt_trde_rpy": "1198",
			"rmnd": "5584633",
			"remn_amt": "27784"
		},
		{
			"stk_nm": "삼성전자",
			"stk_cd": "005930",
			"dbrt_trde_cntrcnt": "5000",
			"dbrt_trde_rpy": "0",
			"rmnd": "5568717",
			"remn_amt": "6755"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---
