# 키움증권 API 문서

## 국내주식 REST API

### 순위정보

#### TR 목록

| TR명                           | 코드    | 설명                           |
| ------------------------------ | ------- | ------------------------------ |
| 호가잔량상위요청               | ka10020 | 호가잔량상위요청               |
| 호가잔량급증요청               | ka10021 | 호가잔량급증요청               |
| 잔량율급증요청                 | ka10022 | 잔량율급증요청                 |
| 거래량급증요청                 | ka10023 | 거래량급증요청                 |
| 전일대비등락률상위요청         | ka10027 | 전일대비등락률상위요청         |
| 예상체결등락률상위요청         | ka10029 | 예상체결등락률상위요청         |
| 당일거래량상위요청             | ka10030 | 당일거래량상위요청             |
| 전일거래량상위요청             | ka10031 | 전일거래량상위요청             |
| 거래대금상위요청               | ka10032 | 거래대금상위요청               |
| 신용비율상위요청               | ka10033 | 신용비율상위요청               |
| 외인기간별매매상위요청         | ka10034 | 외인기간별매매상위요청         |
| 외인연속순매매상위요청         | ka10035 | 외인연속순매매상위요청         |
| 외인한도소진율증가상위         | ka10036 | 외인한도소진율증가상위         |
| 외국계창구매매상위요청         | ka10037 | 외국계창구매매상위요청         |
| 종목별증권사순위요청           | ka10038 | 종목별증권사순위요청           |
| 증권사별매매상위요청           | ka10039 | 증권사별매매상위요청           |
| 당일주요거래원요청             | ka10040 | 당일주요거래원요청             |
| 순매수거래원순위요청           | ka10042 | 순매수거래원순위요청           |
| 당일상위이탈원요청             | ka10053 | 당일상위이탈원요청             |
| 동일순매매순위요청             | ka10062 | 동일순매매순위요청             |
| 장중투자자별매매상위요청       | ka10065 | 장중투자자별매매상위요청       |
| 시간외단일가등락율순위요청     | ka10098 | 시간외단일가등락율순위요청     |
| 외국인기관매매상위요청         | ka90009 | 외국인기관매매상위요청         |

---

### 호가잔량상위요청 (ka10020)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명       | Type   | Required | Length | Description                                                                                                                                      |
| ----------- | ------------ | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| mrkt_tp     | 시장구분     | String | Y        | 3      | 001:코스피, 101:코스닥                                                                                                                           |
| sort_tp     | 정렬구분     | String | Y        | 1      | 1:순매수잔량순, 2:순매도잔량순, 3:매수비율순, 4:매도비율순                                                                                       |
| trde_qty_tp | 거래량구분   | String | Y        | 4      | 0000:장시작전(0주이상), 0010:만주이상, 0050:5만주이상, 00100:10만주이상                                                                          |
| stk_cnd     | 종목조건     | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기                                                  |
| crd_cnd     | 신용조건     | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                           |
| stex_tp     | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| bid_req_upper  | 호가잔량상위 | LIST   | N        |        |             |
| - stk_cd       | 종목코드     | String | N        | 20     |             |
| - stk_nm       | 종목명       | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - trde_qty     | 거래량       | String | N        | 20     |             |
| - tot_sel_req  | 총매도잔량   | String | N        | 20     |             |
| - tot_buy_req  | 총매수잔량   | String | N        | 20     |             |
| - netprps_req  | 순매수잔량   | String | N        | 20     |             |
| - buy_rt       | 매수비율     | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "001",
	"sort_tp" : "1",
	"trde_qty_tp" : "0000",
	"stk_cnd" : "0",
	"crd_cnd" : "0",
	"stex_tp" : "1"
}
```

#### 응답 예시

```json
{
	"bid_req_upper":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+65000",
				"pred_pre_sig":"2",
				"pred_pre":"+6300",
				"trde_qty":"214670",
				"tot_sel_req":"1",
				"tot_buy_req":"22287",
				"netprps_req":"22286",
				"buy_rt":"2228700.00"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+13335",
				"pred_pre_sig":"2",
				"pred_pre":"+385",
				"trde_qty":"0",
				"tot_sel_req":"0",
				"tot_buy_req":"9946",
				"netprps_req":"9946",
				"buy_rt":"0.00"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+10435",
				"pred_pre_sig":"2",
				"pred_pre":"+360",
				"trde_qty":"0",
				"tot_sel_req":"0",
				"tot_buy_req":"8013",
				"netprps_req":"8013",
				"buy_rt":"0.00"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+9530",
				"pred_pre_sig":"2",
				"pred_pre":"+275",
				"trde_qty":"0",
				"tot_sel_req":"0",
				"tot_buy_req":"5432",
				"netprps_req":"5432",
				"buy_rt":"0.00"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+13120",
				"pred_pre_sig":"2",
				"pred_pre":"+55",
				"trde_qty":"0",
				"tot_sel_req":"0",
				"tot_buy_req":"5335",
				"netprps_req":"5335",
				"buy_rt":"0.00"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 호가잔량급증요청 (ka10021)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명       | Type   | Required | Length | Description                                                                                                                 |
| ----------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp     | 시장구분     | String | Y        | 3      | 001:코스피, 101:코스닥                                                                                                      |
| trde_tp     | 매매구분     | String | Y        | 1      | 1:매수잔량, 2:매도잔량                                                                                                      |
| sort_tp     | 정렬구분     | String | Y        | 1      | 1:급증량, 2:급증률                                                                                                          |
| tm_tp       | 시간구분     | String | Y        | 2      | 분 입력                                                                                                                     |
| trde_qty_tp | 거래량구분   | String | Y        | 4      | 1:천주이상, 5:5천주이상, 10:만주이상, 50:5만주이상, 100:10만주이상                                                          |
| stk_cnd     | 종목조건     | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기                             |
| stex_tp     | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| bid_req_sdnin  | 호가잔량급증 | LIST   | N        |        |             |
| - stk_cd       | 종목코드     | String | N        | 20     |             |
| - stk_nm       | 종목명       | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - int          | 기준률       | String | N        | 20     |             |
| - now          | 현재         | String | N        | 20     |             |
| - sdnin_qty    | 급증수량     | String | N        | 20     |             |
| - sdnin_rt     | 급증률       | String | N        | 20     |             |
| - tot_buy_qty  | 총매수량     | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "001",
	"trde_tp" : "1",
	"sort_tp" : "1",
	"tm_tp" : "30",
	"trde_qty_tp" : "1",
	"stk_cnd" : "0",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"bid_req_sdnin":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"8680",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"int":"5000",
				"now":"10000",
				"sdnin_qty":"5000",
				"sdnin_rt":"+100.00",
				"tot_buy_qty":"0"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 잔량율급증요청 (ka10022)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명       | Type   | Required | Length | Description                                                                                                                 |
| ----------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp     | 시장구분     | String | Y        | 3      | 001:코스피, 101:코스닥                                                                                                      |
| rt_tp       | 비율구분     | String | Y        | 1      | 1:매수/매도비율, 2:매도/매수비율                                                                                            |
| tm_tp       | 시간구분     | String | Y        | 2      | 분 입력                                                                                                                     |
| trde_qty_tp | 거래량구분   | String | Y        | 1      | 5:5천주이상, 10:만주이상, 50:5만주이상, 100:10만주이상                                                                      |
| stk_cnd     | 종목조건     | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기                             |
| stex_tp     | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| req_rt_sdnin   | 잔량율급증   | LIST   | N        |        |             |
| - stk_cd       | 종목코드     | String | N        | 20     |             |
| - stk_nm       | 종목명       | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - int          | 기준률       | String | N        | 20     |             |
| - now_rt       | 현재비율     | String | N        | 20     |             |
| - sdnin_rt     | 급증률       | String | N        | 20     |             |
| - tot_sel_req  | 총매도잔량   | String | N        | 20     |             |
| - tot_buy_req  | 총매수잔량   | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "001",
	"rt_tp" : "1",
	"tm_tp" : "1",
	"trde_qty_tp" : "5",
	"stk_cnd" : "0",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"req_rt_sdnin":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+74300",
				"pred_pre_sig":"2",
				"pred_pre":"+17000",
				"int":"+12600.00",
				"now_rt":"-21474836.00",
				"sdnin_rt":"-21474836.00",
				"tot_sel_req":"74",
				"tot_buy_req":"74337920"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 거래량급증요청 (ka10023)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명       | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                      |
| ----------- | ------------ | ------ | -------- | ------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp     | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                                                                                                                                                                                                                                                                 |
| sort_tp     | 정렬구분     | String | Y        | 1      | 1:급증량, 2:급증률, 3:급감량, 4:급감률                                                                                                                                                                                                                                                                                                                                                                           |
| tm_tp       | 시간구분     | String | Y        | 1      | 1:분, 2:전일                                                                                                                                                                                                                                                                                                                                                                                                     |
| trde_qty_tp | 거래량구분   | String | Y        | 1      | 5:5천주이상, 10:만주이상, 50:5만주이상, 100:10만주이상, 200:20만주이상, 300:30만주이상, 500:50만주이상, 1000:백만주이상                                                                                                                                                                                                                                                                                        |
| tm          | 시간         | String | N        | 2      | 분 입력                                                                                                                                                                                                                                                                                                                                                                                                          |
| stk_cnd     | 종목조건     | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 3:우선주제외, 11:정리매매종목제외, 4:관리종목,우선주제외, 5:증100제외, 6:증100만보기, 13:증60만보기, 12:증50만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기, 17:ETN제외, 14:ETF제외, 18:ETF+ETN제외, 15:스팩제외, 20:ETF+ETN+스팩제외                                                                                                                                                   |
| pric_tp     | 가격구분     | String | Y        | 1      | 0:전체조회, 2:5만원이상, 5:1만원이상, 6:5천원이상, 8:1천원이상, 9:10만원이상                                                                                                                                                                                                                                                                                                                                    |
| stex_tp     | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                                                                                                                                                                                                                                                                                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element         | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| trde_qty_sdnin         | 거래량급증       | LIST   | N        |        |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - cur_prc              | 현재가           | String | N        | 20     |             |
| - pred_pre_sig         | 전일대비기호     | String | N        | 20     |             |
| - pred_pre             | 전일대비         | String | N        | 20     |             |
| - flu_rt               | 등락률           | String | N        | 20     |             |
| - prev_trde_qty        | 이전거래량       | String | N        | 20     |             |
| - now_trde_qty         | 현재거래량       | String | N        | 20     |             |
| - sdnin_qty            | 급증량           | String | N        | 20     |             |
| - sdnin_rt             | 급증률           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"sort_tp" : "1",
	"tm_tp" : "2",
	"trde_qty_tp" : "5",
	"tm" : "",
	"stk_cnd" : "0",
	"pric_tp" : "0",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"trde_qty_sdnin":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-152000",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.07",
				"prev_trde_qty":"22532511",
				"now_trde_qty":"31103523",
				"sdnin_qty":"+8571012",
				"sdnin_rt":"+38.04"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-94400",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.11",
				"prev_trde_qty":"25027263",
				"now_trde_qty":"30535372",
				"sdnin_qty":"+5508109",
				"sdnin_rt":"+22.01"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-42900",
				"pred_pre_sig":"5",
				"pred_pre":"-150",
				"flu_rt":"-0.35",
				"prev_trde_qty":"25717492",
				"now_trde_qty":"31033221",
				"sdnin_qty":"+5315729",
				"sdnin_rt":"+20.67"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-22350",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.45",
				"prev_trde_qty":"25548474",
				"now_trde_qty":"30673438",
				"sdnin_qty":"+5124964",
				"sdnin_rt":"+20.06"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-56400",
				"pred_pre_sig":"5",
				"pred_pre":"-300",
				"flu_rt":"-0.53",
				"prev_trde_qty":"26185726",
				"now_trde_qty":"30990416",
				"sdnin_qty":"+4804690",
				"sdnin_rt":"+18.35"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 예상체결등락률상위요청 (ka10029)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| ------------ | ------------ | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp      | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| sort_tp      | 정렬구분     | String | Y        | 1      | 1:상승률, 2:상승폭, 3:보합, 4:하락률, 5:하락폭, 6:체결량, 7:상한, 8:하한                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| trde_qty_cnd | 거래량조건   | String | Y        | 5      | 0:전체조회, 1;천주이상, 3:3천주, 5:5천주, 10:만주이상, 50:5만주이상, 100:10만주이상                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| stk_cnd      | 종목조건     | String | Y        | 2      | 0:전체조회, 1:관리종목제외, 3:우선주제외, 11:정리매매종목제외, 4:관리종목,우선주제외, 5:증100제외, 6:증100만보기, 13:증60만보기, 12:증50만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기, 17:ETN제외, 14:ETF제외, 18:ETF+ETN제외, 15:스팩제외, 20:ETF+ETN+스팩제외                                                                                                                                                   |
| crd_cnd      | 신용조건     | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 5:신용한도초과제외, 8:신용대주                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| pric_cnd     | 가격조건     | String | Y        | 2      | 0:전체조회, 1:1천원미만, 2:1천원~2천원, 3:2천원~5천원, 4:5천원~1만원, 5:1만원이상, 8:1천원이상, 10:1만원미만                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| stex_tp      | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명               | Type   | Required | Length | Description |
| ---------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| exp_cntr_flu_rt_upper  | 예상체결등락률상위   | LIST   | N        |        |             |
| - stk_cd               | 종목코드             | String | N        | 20     |             |
| - stk_nm               | 종목명               | String | N        | 20     |             |
| - exp_cntr_pric        | 예상체결가           | String | N        | 20     |             |
| - base_pric            | 기준가               | String | N        | 20     |             |
| - pred_pre_sig         | 전일대비기호         | String | N        | 20     |             |
| - pred_pre             | 전일대비             | String | N        | 20     |             |
| - flu_rt               | 등락률               | String | N        | 20     |             |
| - exp_cntr_qty         | 예상체결량           | String | N        | 20     |             |
| - sel_req              | 매도잔량             | String | N        | 20     |             |
| - sel_bid              | 매도호가             | String | N        | 20     |             |
| - buy_bid              | 매수호가             | String | N        | 20     |             |
| - buy_req              | 매수잔량             | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"sort_tp" : "1",
	"trde_qty_cnd" : "0",
	"stk_cnd" : "0",
	"crd_cnd" : "0",
	"pric_cnd" : "0",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"exp_cntr_flu_rt_upper":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"exp_cntr_pric":"+48100",
				"base_pric":"37000",
				"pred_pre_sig":"1",
				"pred_pre":"+11100",
				"flu_rt":"+30.00",
				"exp_cntr_qty":"1",
				"sel_req":"0",
				"sel_bid":"0",
				"buy_bid":"0",
				"buy_req":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"exp_cntr_pric":"+40000",
				"base_pric":"34135",
				"pred_pre_sig":"2",
				"pred_pre":"+5865",
				"flu_rt":"+17.18",
				"exp_cntr_qty":"1",
				"sel_req":"1",
				"sel_bid":"+40000",
				"buy_bid":"+35370",
				"buy_req":"1"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"exp_cntr_pric":"+37750",
				"base_pric":"36550",
				"pred_pre_sig":"2",
				"pred_pre":"+1200",
				"flu_rt":"+3.28",
				"exp_cntr_qty":"2",
				"sel_req":"0",
				"sel_bid":"0",
				"buy_bid":"+37850",
				"buy_req":"3"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 당일거래량상위요청 (ka10030)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명       | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| -------------- | ------------ | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp        | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| sort_tp        | 정렬구분     | String | Y        | 1      | 1:거래량, 2:거래회전율, 3:거래대금                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| mang_stk_incls | 관리종목포함 | String | Y        | 1      | 0:관리종목 포함, 1:관리종목 미포함, 3:우선주제외, 11:정리매매종목제외, 4:관리종목, 우선주제외, 5:증100제외, 6:증100만보기, 13:증60만보기, 12:증50만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기, 14:ETF제외, 15:스팩제외, 16:ETF+ETN제외                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| crd_tp         | 신용구분     | String | Y        | 1      | 0:전체조회, 9:신용융자전체, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 8:신용대주                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| trde_qty_tp    | 거래량구분   | String | Y        | 1      | 0:전체조회, 5:5천주이상, 10:1만주이상, 50:5만주이상, 100:10만주이상, 200:20만주이상, 300:30만주이상, 500:50만주이상, 1000:백만주이상                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| pric_tp        | 가격구분     | String | Y        | 1      | 0:전체조회, 1:1천원미만, 2:1천원이상, 3:1천원~2천원, 4:2천원~5천원, 5:5천원이상, 6:5천원~1만원, 10:1만원미만, 7:1만원이상, 8:5만원이상, 9:10만원이상                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| trde_prica_tp  | 거래대금구분 | String | Y        | 1      | 0:전체조회, 1:1천만원이상, 3:3천만원이상, 4:5천만원이상, 10:1억원이상, 30:3억원이상, 50:5억원이상, 100:10억원이상, 300:30억원이상, 500:50억원이상, 1000:100억원이상, 3000:300억원이상, 5000:500억원이상                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| mrkt_open_tp   | 장운영구분   | String | Y        | 1      | 0:전체조회, 1:장중, 2:장전시간외, 3:장후시간외                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| stex_tp        | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| tdy_trde_qty_upper     | 당일거래량상위   | LIST   | N        |        |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - cur_prc              | 현재가           | String | N        | 20     |             |
| - pred_pre_sig         | 전일대비기호     | String | N        | 20     |             |
| - pred_pre             | 전일대비         | String | N        | 20     |             |
| - flu_rt               | 등락률           | String | N        | 20     |             |
| - trde_qty             | 거래량           | String | N        | 20     |             |
| - pred_rt              | 전일비           | String | N        | 20     |             |
| - trde_tern_rt         | 거래회전율       | String | N        | 20     |             |
| - trde_amt             | 거래금액         | String | N        | 20     |             |
| - opmr_trde_qty        | 장중거래량       | String | N        | 20     |             |
| - opmr_pred_rt         | 장중전일비       | String | N        | 20     |             |
| - opmr_trde_rt         | 장중거래회전율   | String | N        | 20     |             |
| - opmr_trde_amt        | 장중거래금액     | String | N        | 20     |             |
| - af_mkrt_trde_qty     | 장후거래량       | String | N        | 20     |             |
| - af_mkrt_pred_rt      | 장후전일비       | String | N        | 20     |             |
| - af_mkrt_trde_rt      | 장후거래회전율   | String | N        | 20     |             |
| - af_mkrt_trde_amt     | 장후거래금액     | String | N        | 20     |             |
| - bf_mkrt_trde_qty     | 장전거래량       | String | N        | 20     |             |
| - bf_mkrt_pred_rt      | 장전전일비       | String | N        | 20     |             |
| - bf_mkrt_trde_rt      | 장전거래회전율   | String | N        | 20     |             |
| - bf_mkrt_trde_amt     | 장전거래금액     | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"sort_tp" : "1",
	"mang_stk_incls" : "1",
	"crd_tp" : "0",
	"trde_qty_tp" : "0",
	"pric_tp" : "0",
	"trde_prica_tp" : "0",
	"mrkt_open_tp" : "0",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"tdy_trde_qty_upper":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-152000",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.07",
				"trde_qty":"34954641",
				"pred_rt":"+155.13",
				"trde_tern_rt":"+48.21",
				"trde_amt":"5308092",
				"opmr_trde_qty":"0",
				"opmr_pred_rt":"0.00",
				"opmr_trde_rt":"+0.00",
				"opmr_trde_amt":"0",
				"af_mkrt_trde_qty":"0",
				"af_mkrt_pred_rt":"0.00",
				"af_mkrt_trde_rt":"+0.00",
				"af_mkrt_trde_amt":"0",
				"bf_mkrt_trde_qty":"0",
				"bf_mkrt_pred_rt":"0.00",
				"bf_mkrt_trde_rt":"+0.00",
				"bf_mkrt_trde_amt":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-53700",
				"pred_pre_sig":"4",
				"pred_pre":"-23000",
				"flu_rt":"-29.99",
				"trde_qty":"31821639",
				"pred_rt":"+135.53",
				"trde_tern_rt":"+13.83",
				"trde_amt":"2436091",
				"opmr_trde_qty":"0",
				"opmr_pred_rt":"0.00",
				"opmr_trde_rt":"+0.00",
				"opmr_trde_amt":"0",
				"af_mkrt_trde_qty":"0",
				"af_mkrt_pred_rt":"0.00",
				"af_mkrt_trde_rt":"+0.00",
				"af_mkrt_trde_amt":"0",
				"bf_mkrt_trde_qty":"0",
				"bf_mkrt_pred_rt":"0.00",
				"bf_mkrt_trde_rt":"+0.00",
				"bf_mkrt_trde_amt":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-42950",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.23",
				"trde_qty":"34854261",
				"pred_rt":"+135.53",
				"trde_tern_rt":"+13.83",
				"trde_amt":"1501908",
				"opmr_trde_qty":"0",
				"opmr_pred_rt":"0.00",
				"opmr_trde_rt":"+0.00",
				"opmr_trde_amt":"0",
				"af_mkrt_trde_qty":"0",
				"af_mkrt_pred_rt":"0.00",
				"af_mkrt_trde_rt":"+0.00",
				"af_mkrt_trde_amt":"0",
				"bf_mkrt_trde_qty":"0",
				"bf_mkrt_pred_rt":"0.00",
				"bf_mkrt_trde_rt":"+0.00",
				"bf_mkrt_trde_amt":"0"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 전일거래량상위요청 (ka10031)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명     | Type   | Required | Length | Description                                                          |
| ---------- | ---------- | ------ | -------- | ------ | -------------------------------------------------------------------- |
| mrkt_tp    | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                     |
| qry_tp     | 조회구분   | String | Y        | 1      | 1:전일거래량 상위100종목, 2:전일거래대금 상위100종목                 |
| rank_strt  | 순위시작   | String | Y        | 3      | 0 ~ 100 값 중에 조회를 원하는 순위 시작값                           |
| rank_end   | 순위끝     | String | Y        | 3      | 0 ~ 100 값 중에 조회를 원하는 순위 끝값                             |
| stex_tp    | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                  |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| pred_trde_qty_upper    | 전일거래량상위   | LIST   | N        |        |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - cur_prc              | 현재가           | String | N        | 20     |             |
| - pred_pre_sig         | 전일대비기호     | String | N        | 20     |             |
| - pred_pre             | 전일대비         | String | N        | 20     |             |
| - trde_qty             | 거래량           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "101",
	"qry_tp" : "1",
	"rank_strt" : "0",
	"rank_end" : "10",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"pred_trde_qty_upper":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"81",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"2050",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"2375",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-43750",
				"pred_pre_sig":"5",
				"pred_pre":"-50",
				"trde_qty":"34605668"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"70",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-56600",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"trde_qty":"33014975"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"11260",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-65300",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"trde_qty":"28117804"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-94400",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"trde_qty":"34289700"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-18610",
				"pred_pre_sig":"5",
				"pred_pre":"-20",
				"trde_qty":"33030086"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 거래대금상위요청 (ka10032)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명       | Type   | Required | Length | Description                              |
| -------------- | ------------ | ------ | -------- | ------ | ---------------------------------------- |
| mrkt_tp        | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥         |
| mang_stk_incls | 관리종목포함 | String | Y        | 1      | 0:관리종목 포함, 1:관리종목 미포함       |
| stex_tp        | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명       | Type   | Required | Length | Description |
| -------------------- | ------------ | ------ | -------- | ------ | ----------- |
| trde_prica_upper     | 거래대금상위 | LIST   | N        |        |             |
| - stk_cd             | 종목코드     | String | N        | 20     |             |
| - now_rank           | 현재순위     | String | N        | 20     |             |
| - pred_rank          | 전일순위     | String | N        | 20     |             |
| - stk_nm             | 종목명       | String | N        | 20     |             |
| - cur_prc            | 현재가       | String | N        | 20     |             |
| - pred_pre_sig       | 전일대비기호 | String | N        | 20     |             |
| - pred_pre           | 전일대비     | String | N        | 20     |             |
| - flu_rt             | 등락률       | String | N        | 20     |             |
| - sel_bid            | 매도호가     | String | N        | 20     |             |
| - buy_bid            | 매수호가     | String | N        | 20     |             |
| - now_trde_qty       | 현재거래량   | String | N        | 20     |             |
| - pred_trde_qty      | 전일거래량   | String | N        | 20     |             |
| - trde_prica         | 거래대금     | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "001",
	"mang_stk_incls" : "1",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"trde_prica_upper":
		[
			{
				"stk_cd":"005930",
				"now_rank":"1",
				"pred_rank":"1",
				"stk_nm":"삼성전자",
				"cur_prc":"-152000",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.07",
				"sel_bid":"-152000",
				"buy_bid":"-150000",
				"now_trde_qty":"34954641",
				"pred_trde_qty":"22532511",
				"trde_prica":"5308092"
			},
			{
				"stk_cd":"005930",
				"now_rank":"2",
				"pred_rank":"2",
				"stk_nm":"삼성전자",
				"cur_prc":"-53700",
				"pred_pre_sig":"4",
				"pred_pre":"-23000",
				"flu_rt":"-29.99",
				"sel_bid":"-76500",
				"buy_bid":"+85100",
				"now_trde_qty":"31821639",
				"pred_trde_qty":"30279412",
				"trde_prica":"2436091"
			},
			{
				"stk_cd":"005930",
				"now_rank":"3",
				"pred_rank":"3",
				"stk_nm":"삼성전자",
				"cur_prc":"-42950",
				"pred_pre_sig":"5",
				"pred_pre":"-100",
				"flu_rt":"-0.23",
				"sel_bid":"-42950",
				"buy_bid":"+45250",
				"now_trde_qty":"34854261",
				"pred_trde_qty":"25717492",
				"trde_prica":"1501908"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 신용비율상위요청 (ka10033)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                                                                                                      |
| ------------ | ------------ | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------ |
| mrkt_tp      | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                 |
| trde_qty_tp  | 거래량구분   | String | Y        | 3      | 0:전체조회, 10:만주이상, 50:5만주이상, 100:10만주이상, 200:20만주이상, 300:30만주이상, 500:50만주이상, 1000:백만주이상                          |
| stk_cnd      | 종목조건     | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기                                                  |
| updown_incls | 상하한포함   | String | Y        | 1      | 0:상하한 미포함, 1:상하한포함                                                                                                                    |
| crd_cnd      | 신용조건     | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                           |
| stex_tp      | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명       | Type   | Required | Length | Description |
| -------------------- | ------------ | ------ | -------- | ------ | ----------- |
| crd_rt_upper         | 신용비율상위 | LIST   | N        |        |             |
| - stk_infr           | 종목정보     | String | N        | 20     |             |
| - stk_cd             | 종목코드     | String | N        | 20     |             |
| - stk_nm             | 종목명       | String | N        | 20     |             |
| - cur_prc            | 현재가       | String | N        | 20     |             |
| - pred_pre_sig       | 전일대비기호 | String | N        | 20     |             |
| - pred_pre           | 전일대비     | String | N        | 20     |             |
| - flu_rt             | 등락률       | String | N        | 20     |             |
| - crd_rt             | 신용비율     | String | N        | 20     |             |
| - sel_req            | 매도잔량     | String | N        | 20     |             |
| - buy_req            | 매수잔량     | String | N        | 20     |             |
| - now_trde_qty       | 현재거래량   | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"trde_qty_tp" : "0",
	"stk_cnd" : "0",
	"updown_incls" : "1",
	"crd_cnd" : "0",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"crd_rt_upper":
		[
			{
				"stk_infr":"0",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"16420",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"crd_rt":"+9.49",
				"sel_req":"0",
				"buy_req":"0",
				"now_trde_qty":"0"
			},
			{
				"stk_infr":"0",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"3415",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"crd_rt":"+9.48",
				"sel_req":"1828",
				"buy_req":"0",
				"now_trde_qty":"0"
			},
			{
				"stk_infr":"0",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"3660",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"crd_rt":"+8.92",
				"sel_req":"0",
				"buy_req":"0",
				"now_trde_qty":"0"
			},
			{
				"stk_infr":"0",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"11050",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"crd_rt":"+8.73",
				"sel_req":"0",
				"buy_req":"0",
				"now_trde_qty":"0"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 외인기간별매매상위요청 (ka10034)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                                                |
| ------- | ---------- | ------ | -------- | ------ | ---------------------------------------------------------- |
| mrkt_tp | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                           |
| trde_tp | 매매구분   | String | Y        | 1      | 1:순매도, 2:순매수, 3:순매매                               |
| dt      | 기간       | String | Y        | 2      | 0:당일, 1:전일, 5:5일, 10:10일, 20:20일, 60:60일           |
| stex_tp | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명               | Type   | Required | Length | Description |
| --------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| for_dt_trde_upper     | 외인기간별매매상위   | LIST   | N        |        |             |
| - rank                | 순위                 | String | N        | 20     |             |
| - stk_cd              | 종목코드             | String | N        | 20     |             |
| - stk_nm              | 종목명               | String | N        | 20     |             |
| - cur_prc             | 현재가               | String | N        | 20     |             |
| - pred_pre_sig        | 전일대비기호         | String | N        | 20     |             |
| - pred_pre            | 전일대비             | String | N        | 20     |             |
| - sel_bid             | 매도호가             | String | N        | 20     |             |
| - buy_bid             | 매수호가             | String | N        | 20     |             |
| - trde_qty            | 거래량               | String | N        | 20     |             |
| - netprps_qty         | 순매수량             | String | N        | 20     |             |
| - gain_pos_stkcnt     | 취득가능주식수       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "001",
	"trde_tp" : "2",
	"dt" : "0",
	"stex_tp" : "1"
}
```

#### 응답 예시

```json
{
	"for_dt_trde_upper":
		[
			{
				"rank":"1",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+74800",
				"pred_pre_sig":"1",
				"pred_pre":"+17200",
				"sel_bid":"0",
				"buy_bid":"+74800",
				"trde_qty":"435771",
				"netprps_qty":"+290232191",
				"gain_pos_stkcnt":"2548278006"
			},
			{
				"rank":"2",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-183500",
				"pred_pre_sig":"5",
				"pred_pre":"-900",
				"sel_bid":"+184900",
				"buy_bid":"0",
				"trde_qty":"135",
				"netprps_qty":"+167189864",
				"gain_pos_stkcnt":"0"
			},
			{
				"rank":"3",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"4115",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"sel_bid":"0",
				"buy_bid":"0",
				"trde_qty":"0",
				"netprps_qty":"+59255646",
				"gain_pos_stkcnt":"430439234"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 외인연속순매매상위요청 (ka10035)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명       | Type   | Required | Length | Description                                      |
| ----------- | ------------ | ------ | -------- | ------ | ------------------------------------------------ |
| mrkt_tp     | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                 |
| trde_tp     | 매매구분     | String | Y        | 1      | 1:연속순매도, 2:연속순매수                       |
| base_dt_tp  | 기준일구분   | String | Y        | 1      | 0:당일기준, 1:전일기준                           |
| stex_tp     | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                     | 한글명               | Type   | Required | Length | Description |
| --------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| for_cont_nettrde_upper      | 외인연속순매매상위   | LIST   | N        |        |             |
| - stk_cd                    | 종목코드             | String | N        | 20     |             |
| - stk_nm                    | 종목명               | String | N        | 20     |             |
| - cur_prc                   | 현재가               | String | N        | 20     |             |
| - pred_pre_sig              | 전일대비기호         | String | N        | 20     |             |
| - pred_pre                  | 전일대비             | String | N        | 20     |             |
| - dm1                       | D-1                  | String | N        | 20     |             |
| - dm2                       | D-2                  | String | N        | 20     |             |
| - dm3                       | D-3                  | String | N        | 20     |             |
| - tot                       | 합계                 | String | N        | 20     |             |
| - limit_exh_rt              | 한도소진율           | String | N        | 20     |             |
| - pred_pre_1                | 전일대비1            | String | N        | 20     |             |
| - pred_pre_2                | 전일대비2            | String | N        | 20     |             |
| - pred_pre_3                | 전일대비3            | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"trde_tp" : "2",
	"base_dt_tp" : "1",
	"stex_tp" : "1"
}
```

#### 응답 예시

```json
{
	"for_cont_nettrde_upper":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"10200",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"dm1":"+33928250",
				"dm2":"+234840",
				"dm3":"+233891",
				"tot":"+34396981",
				"limit_exh_rt":"+71.53",
				"pred_pre_1":"",
				"pred_pre_2":"",
				"pred_pre_3":""
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"-8540",
				"pred_pre_sig":"5",
				"pred_pre":"-140",
				"dm1":"+4033818",
				"dm2":"+12474308",
				"dm3":"+13173262",
				"tot":"+29681388",
				"limit_exh_rt":"+0.10",
				"pred_pre_1":"",
				"pred_pre_2":"",
				"pred_pre_3":""
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"23000",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"dm1":"+24595310",
				"dm2":"+247863",
				"dm3":"+247188",
				"tot":"+25090361",
				"limit_exh_rt":"+38.85",
				"pred_pre_1":"",
				"pred_pre_2":"",
				"pred_pre_3":""
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"195800",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"dm1":"+21220444",
				"dm2":"+213984",
				"dm3":"+104034",
				"tot":"+21538462",
				"limit_exh_rt":"+54.76",
				"pred_pre_1":"",
				"pred_pre_2":"",
				"pred_pre_3":""
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 외인한도소진율증가상위요청 (ka10036)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                                         |
| ------- | ---------- | ------ | -------- | ------ | --------------------------------------------------- |
| mrkt_tp | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                    |
| dt      | 기간       | String | Y        | 2      | 0:당일, 1:전일, 5:5일, 10;10일, 20:20일, 60:60일    |
| stex_tp | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                            | 한글명                | Type   | Required | Length | Description |
| ---------------------------------- | --------------------- | ------ | -------- | ------ | ----------- |
| for_limit_exh_rt_incrs_upper       | 외인한도소진율증가상위 | LIST   | N        |        |             |
| - rank                             | 순위                  | String | N        | 20     |             |
| - stk_cd                           | 종목코드              | String | N        | 20     |             |
| - stk_nm                           | 종목명                | String | N        | 20     |             |
| - cur_prc                          | 현재가                | String | N        | 20     |             |
| - pred_pre_sig                     | 전일대비기호          | String | N        | 20     |             |
| - pred_pre                         | 전일대비              | String | N        | 20     |             |
| - trde_qty                         | 거래량                | String | N        | 20     |             |
| - poss_stkcnt                      | 보유주식수            | String | N        | 20     |             |
| - gain_pos_stkcnt                  | 취득가능주식수        | String | N        | 20     |             |
| - base_limit_exh_rt                | 기준한도소진율        | String | N        | 20     |             |
| - limit_exh_rt                     | 한도소진율            | String | N        | 20     |             |
| - exh_rt_incrs                     | 소진율증가            | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"dt" : "1",
	"stex_tp" : "1"
}
```

#### 응답 예시

```json
{
	"for_limit_exh_rt_incrs_upper":
		[
			{
				"rank":"1",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"14255",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0",
				"poss_stkcnt":"0",
				"gain_pos_stkcnt":"600000",
				"base_limit_exh_rt":"-283.33",
				"limit_exh_rt":"0.00",
				"exh_rt_incrs":"+283.33"
			},
			{
				"rank":"2",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"1590",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"trde_qty":"0",
				"poss_stkcnt":"519785",
				"gain_pos_stkcnt":"31404714",
				"base_limit_exh_rt":"-101.25",
				"limit_exh_rt":"+1.63",
				"exh_rt_incrs":"+102.87"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 외국계창구매매상위요청 (ka10037)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                                         |
| ------- | ---------- | ------ | -------- | ------ | --------------------------------------------------- |
| mrkt_tp | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                    |
| dt      | 기간       | String | Y        | 2      | 0:당일, 1:전일, 5:5일, 10;10일, 20:20일, 60:60일    |
| trde_tp | 매매구분   | String | Y        | 1      | 1:순매수, 2:순매도, 3:매수, 4:매도                  |
| sort_tp | 정렬구분   | String | Y        | 1      | 1:금액, 2:수량                                      |
| stex_tp | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                   | 한글명               | Type   | Required | Length | Description |
| ------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| frgn_wicket_trde_upper    | 외국계창구매매상위   | LIST   | N        |        |             |
| - rank                    | 순위                 | String | N        | 20     |             |
| - stk_cd                  | 종목코드             | String | N        | 20     |             |
| - stk_nm                  | 종목명               | String | N        | 20     |             |
| - cur_prc                 | 현재가               | String | N        | 20     |             |
| - pred_pre_sig            | 전일대비기호         | String | N        | 20     |             |
| - pred_pre                | 전일대비             | String | N        | 20     |             |
| - flu_rt                  | 등락율               | String | N        | 20     |             |
| - sel_trde_qty            | 매도거래량           | String | N        | 20     |             |
| - buy_trde_qty            | 매수거래량           | String | N        | 20     |             |
| - netprps_trde_qty        | 순매수거래량         | String | N        | 20     |             |
| - netprps_prica           | 순매수대금           | String | N        | 20     |             |
| - trde_qty                | 거래량               | String | N        | 20     |             |
| - trde_prica              | 거래대금             | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp" : "000",
	"dt" : "0",
	"trde_tp" : "1",
	"sort_tp" : "2",
	"stex_tp" : "1"
}
```

#### 응답 예시

```json
{
	"frgn_wicket_trde_upper":
		[
			{
				"rank":"1",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"69",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"sel_trde_qty":"-0",
				"buy_trde_qty":"+0",
				"netprps_trde_qty":"0",
				"netprps_prica":"0",
				"trde_qty":"0",
				"trde_prica":"0"
			},
			{
				"rank":"2",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"316",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"sel_trde_qty":"-0",
				"buy_trde_qty":"+0",
				"netprps_trde_qty":"0",
				"netprps_prica":"0",
				"trde_qty":"0",
				"trde_prica":"0"
			},
			{
				"rank":"3",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"675",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"sel_trde_qty":"-0",
				"buy_trde_qty":"+0",
				"netprps_trde_qty":"0",
				"netprps_prica":"0",
				"trde_qty":"0",
				"trde_prica":"0"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 종목별증권사순위요청 (ka10038)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                                                                                      |
| ------- | ---------- | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------ |
| stk_cd  | 종목코드   | String | Y        | 6      | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)                                   |
| strt_dt | 시작일자   | String | Y        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                                |
| end_dt  | 종료일자   | String | Y        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                                |
| qry_tp  | 조회구분   | String | Y        | 1      | 1:순매도순위정렬, 2:순매수순위정렬                                                               |
| dt      | 기간       | String | Y        | 2      | 1:전일, 4:5일, 9:10일, 19:20일, 39:40일, 59:60일, 119:120일                                      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명               | Type   | Required | Length | Description |
| -------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| rank_1               | 순위1                | String | N        | 20     |             |
| rank_2               | 순위2                | String | N        | 20     |             |
| rank_3               | 순위3                | String | N        | 20     |             |
| prid_trde_qty        | 기간중거래량         | String | N        | 20     |             |
| stk_sec_rank         | 종목별증권사순위     | LIST   | N        |        |             |
| - rank               | 순위                 | String | N        | 20     |             |
| - mmcm_nm            | 회원사명             | String | N        | 20     |             |
| - buy_qty            | 매수수량             | String | N        | 20     |             |
| - sell_qty           | 매도수량             | String | N        | 20     |             |
| - acc_netprps_qty    | 누적순매수수량       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd" : "005930",
	"strt_dt" : "20241106",
	"end_dt" : "20241107",
	"qry_tp" : "2",
	"dt" : "1"
}
```

#### 응답 예시

```json
{
	"rank_1":"+34881",
	"rank_2":"-13253",
	"rank_3":"+21628",
	"prid_trde_qty":"43",
	"stk_sec_rank":
		[
			{
				"rank":"1",
				"mmcm_nm":"키움증권",
				"buy_qty":"+9800",
				"sell_qty":"-2813",
				"acc_netprps_qty":"+6987"
			},
			{
				"rank":"2",
				"mmcm_nm":"키움증권",
				"buy_qty":"+3459",
				"sell_qty":"-117",
                "acc_netprps_qty":"+3342"
			},
			{
				"rank":"3",
				"mmcm_nm":"키움증권",
				"buy_qty":"+3321",
				"sell_qty":"-125",
				"acc_netprps_qty":"+3196"
			},
			{
				"rank":"4",
				"mmcm_nm":"키움증권",
				"buy_qty":"+3941",
				"sell_qty":"-985",
				"acc_netprps_qty":"+2956"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 증권사별매매상위요청 (ka10039)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명     | Type   | Required | Length | Description                                                                                      |
| ----------- | ---------- | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------ |
| mmcm_cd     | 회원사코드 | String | Y        | 3      | 회원사 코드는 ka10102 조회                                                                       |
| trde_qty_tp | 거래량구분 | String | Y        | 4      | 0:전체, 5:5000주, 10:1만주, 50:5만주, 100:10만주, 500:50만주, 1000: 100만주                      |
| trde_tp     | 매매구분   | String | Y        | 2      | 1:순매수, 2:순매도                                                                               |
| dt          | 기간       | String | Y        | 2      | 1:전일, 5:5일, 10:10일, 60:60일                                                                  |
| stex_tp     | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명               | Type   | Required | Length | Description |
| -------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| sec_trde_upper       | 증권사별매매상위     | LIST   | N        |        |             |
| - rank               | 순위                 | String | N        | 20     |             |
| - stk_cd             | 종목코드             | String | N        | 20     |             |
| - stk_nm             | 종목명               | String | N        | 20     |             |
| - prid_stkpc_flu     | 기간중주가등락       | String | N        | 20     |             |
| - flu_rt             | 등락율               | String | N        | 20     |             |
| - prid_trde_qty      | 기간중거래량         | String | N        | 20     |             |
| - netprps            | 순매수               | String | N        | 20     |             |
| - buy_trde_qty       | 매수거래량           | String | N        | 20     |             |
| - sel_trde_qty       | 매도거래량           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mmcm_cd" : "001",
	"trde_qty_tp" : "0",
	"trde_tp" : "1",
	"dt" : "1",
	"stex_tp" : "3"
}
```

#### 응답 예시

```json
{
	"sec_trde_upper":
		[
			{
				"rank":"1",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"prid_stkpc_flu":"+1800",
				"flu_rt":"+0.93",
				"prid_trde_qty":"241",
				"netprps":"+27401",
				"buy_trde_qty":"+33131",
				"sel_trde_qty":"-5730"
			},
			{
				"rank":"2",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"prid_stkpc_flu":"0",
				"flu_rt":"0.00",
				"prid_trde_qty":"0",
				"netprps":"+154140",
				"buy_trde_qty":"+302708",
				"sel_trde_qty":"-148568"
			},
			{
				"rank":"3",
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"prid_stkpc_flu":"0",
				"flu_rt":"0.00",
				"prid_trde_qty":"0",
				"netprps":"+6724",
				"buy_trde_qty":"+12018",
				"sel_trde_qty":"-5294"
			}
		],
	"returnCode":0,
	"returnMsg":"정상적으로 처리되었습니다"
}
```

---

### 당일주요거래원요청 (ka10040)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description |
| ------- | -------- | ------ | -------- | ------ | ----------- |
| stk_cd  | 종목코드 | String | Y        | 6      |             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                   | 한글명                | Type   | Required | Length | Description |
| ------------------------- | --------------------- | ------ | -------- | ------ | ----------- |
| sel_trde_ori_irds_1       | 매도거래원별증감1     | String | N        |        |             |
| sel_trde_ori_qty_1        | 매도거래원수량1       | String | N        |        |             |
| sel_trde_ori_1            | 매도거래원1           | String | N        |        |             |
| sel_trde_ori_cd_1         | 매도거래원코드1       | String | N        |        |             |
| buy_trde_ori_1            | 매수거래원1           | String | N        |        |             |
| buy_trde_ori_cd_1         | 매수거래원코드1       | String | N        |        |             |
| buy_trde_ori_qty_1        | 매수거래원수량1       | String | N        |        |             |
| buy_trde_ori_irds_1       | 매수거래원별증감1     | String | N        |        |             |
| sel_trde_ori_irds_2       | 매도거래원별증감2     | String | N        |        |             |
| sel_trde_ori_qty_2        | 매도거래원수량2       | String | N        |        |             |
| sel_trde_ori_2            | 매도거래원2           | String | N        |        |             |
| sel_trde_ori_cd_2         | 매도거래원코드2       | String | N        |        |             |
| buy_trde_ori_2            | 매수거래원2           | String | N        |        |             |
| buy_trde_ori_cd_2         | 매수거래원코드2       | String | N        |        |             |
| buy_trde_ori_qty_2        | 매수거래원수량2       | String | N        |        |             |
| buy_trde_ori_irds_2       | 매수거래원별증감2     | String | N        |        |             |
| sel_trde_ori_irds_3       | 매도거래원별증감3     | String | N        |        |             |
| sel_trde_ori_qty_3        | 매도거래원수량3       | String | N        |        |             |
| sel_trde_ori_3            | 매도거래원3           | String | N        |        |             |
| sel_trde_ori_cd_3         | 매도거래원코드3       | String | N        |        |             |
| buy_trde_ori_3            | 매수거래원3           | String | N        |        |             |
| buy_trde_ori_cd_3         | 매수거래원코드3       | String | N        |        |             |
| buy_trde_ori_qty_3        | 매수거래원수량3       | String | N        |        |             |
| buy_trde_ori_irds_3       | 매수거래원별증감3     | String | N        |        |             |
| sel_trde_ori_irds_4       | 매도거래원별증감4     | String | N        |        |             |
| sel_trde_ori_qty_4        | 매도거래원수량4       | String | N        |        |             |
| sel_trde_ori_4            | 매도거래원4           | String | N        |        |             |
| sel_trde_ori_cd_4         | 매도거래원코드4       | String | N        |        |             |
| buy_trde_ori_4            | 매수거래원4           | String | N        |        |             |
| buy_trde_ori_cd_4         | 매수거래원코드4       | String | N        |        |             |
| buy_trde_ori_qty_4        | 매수거래원수량4       | String | N        |        |             |
| buy_trde_ori_irds_4       | 매수거래원별증감4     | String | N        |        |             |
| sel_trde_ori_irds_5       | 매도거래원별증감5     | String | N        |        |             |
| sel_trde_ori_qty_5        | 매도거래원수량5       | String | N        |        |             |
| sel_trde_ori_5            | 매도거래원5           | String | N        |        |             |
| sel_trde_ori_cd_5         | 매도거래원코드5       | String | N        |        |             |
| buy_trde_ori_5            | 매수거래원5           | String | N        |        |             |
| buy_trde_ori_cd_5         | 매수거래원코드5       | String | N        |        |             |
| buy_trde_ori_qty_5        | 매수거래원수량5       | String | N        |        |             |
| buy_trde_ori_irds_5       | 매수거래원별증감5     | String | N        |        |             |
| frgn_sel_prsm_sum_chang   | 외국계매도추정합변동  | String | N        |        |             |
| frgn_sel_prsm_sum         | 외국계매도추정합      | String | N        |        |             |
| frgn_buy_prsm_sum         | 외국계매수추정합      | String | N        |        |             |
| frgn_buy_prsm_sum_chang   | 외국계매수추정합변동  | String | N        |        |             |
| tdy_main_trde_ori         | 당일주요거래원        | LIST   | N        |        |             |
| - sel_scesn_tm            | 매도이탈시간          | String | N        | 20     |             |
| - sell_qty                | 매도수량              | String | N        | 20     |             |
| - sel_upper_scesn_ori     | 매도상위이탈원        | String | N        | 20     |             |
| - buy_scesn_tm            | 매수이탈시간          | String | N        | 20     |             |
| - buy_qty                 | 매수수량              | String | N        | 20     |             |
| - buy_upper_scesn_ori     | 매수상위이탈원        | String | N        | 20     |             |
| - qry_dt                  | 조회일자              | String | N        | 20     |             |
| - qry_tm                  | 조회시간              | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd" : "005930"
}
```

#### 응답 예시

```json
{
	"sel_trde_ori_irds_1":"0",
	"sel_trde_ori_qty_1":"-5689",
	"sel_trde_ori_1":"모건스탠리",
	"sel_trde_ori_cd_1":"036",
	"buy_trde_ori_1":"모건스탠리",
	"buy_trde_ori_cd_1":"036",
	"buy_trde_ori_qty_1":"+6305",
	"buy_trde_ori_irds_1":"+615",
	"sel_trde_ori_irds_2":"+615",
	"sel_trde_ori_qty_2":"-615",
	"sel_trde_ori_2":"신  영",
	"sel_trde_ori_cd_2":"006",
	"buy_trde_ori_2":"키움증권",
	"buy_trde_ori_cd_2":"050",
	"buy_trde_ori_qty_2":"+7",
	"buy_trde_ori_irds_2":"0",
	"sel_trde_ori_irds_3":"0",
	"sel_trde_ori_qty_3":"-8",
	"sel_trde_ori_3":"키움증권",
	"sel_trde_ori_cd_3":"050",
	"buy_trde_ori_3":"",
	"buy_trde_ori_cd_3":"000",
	"buy_trde_ori_qty_3":"0",
	"buy_trde_ori_irds_3":"0",
	"sel_trde_ori_irds_4":"0",
	"sel_trde_ori_qty_4":"0",
	"sel_trde_ori_4":"",
	"sel_trde_ori_cd_4":"000",
	"buy_trde_ori_4":"",
    "buy_trde_ori_cd_4":"000",
	"buy_trde_ori_qty_4":"0",
	"buy_trde_ori_irds_4":"0",
	"sel_trde_ori_irds_5":"0",
	"sel_trde_ori_qty_5":"0",
	"sel_trde_ori_5":"",
	"sel_trde_ori_cd_5":"000",
	"buy_trde_ori_5":"",
	"buy_trde_ori_cd_5":"000",
	"buy_trde_ori_qty_5":"0",
	"buy_trde_ori_irds_5":"0",
	"frgn_sel_prsm_sum_chang":"0",
	"frgn_sel_prsm_sum":"-5689",
	"frgn_buy_prsm_sum":"+6305",
	"frgn_buy_prsm_sum_chang":"+615",
	"tdy_main_trde_ori":
		[
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 순매수거래원순위요청 (ka10042)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명         | Type   | Required | Length | Description                                                                             |
| ---------- | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| stk_cd     | 종목코드       | String | Y        | 6      | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)                         |
| strt_dt    | 시작일자       | String | N        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                       |
| end_dt     | 종료일자       | String | N        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                       |
| qry_dt_tp  | 조회기간구분   | String | Y        | 1      | 0:기간으로 조회, 1:시작일자, 종료일자로 조회                                            |
| pot_tp     | 시점구분       | String | Y        | 1      | 0:당일, 1:전일                                                                          |
| dt         | 기간           | String | N        | 4      | 5:5일, 10:10일, 20:20일, 40:40일, 60:60일, 120:120일                                    |
| sort_base  | 정렬기준       | String | Y        | 1      | 1:종가순, 2:날짜순                                                                      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                   | 한글명             | Type   | Required | Length | Description |
| ------------------------- | ------------------ | ------ | -------- | ------ | ----------- |
| netprps_trde_ori_rank     | 순매수거래원순위   | LIST   | N        |        |             |
| - rank                    | 순위               | String | N        | 20     |             |
| - mmcm_cd                 | 회원사코드         | String | N        | 20     |             |
| - mmcm_nm                 | 회원사명           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"strt_dt": "20241031",
	"end_dt": "20241107",
	"qry_dt_tp": "0",
	"pot_tp": "0",
	"dt": "5",
	"sort_base": "1"
}
```

#### 응답 예시

```json
{
	"netprps_trde_ori_rank":
		[
			{
				"rank":"1",
				"mmcm_cd":"36",
				"mmcm_nm":"키움증권"
			},
			{
				"rank":"2",
				"mmcm_cd":"50",
				"mmcm_nm":"키움증권"
			},
			{
				"rank":"3",
				"mmcm_cd":"45",
				"mmcm_nm":"키움증권"
			},
			{
				"rank":"4",
				"mmcm_cd":"6",
				"mmcm_nm":"키움증권"
			},
			{
				"rank":"5",
				"mmcm_cd":"64",
				"mmcm_nm":"키움증권"
			},
			{
				"rank":"6",
				"mmcm_cd":"31",
				"mmcm_nm":"키움증권"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 당일상위이탈원요청 (ka10053)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                             |
| ------- | -------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 6      | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                   | 한글명             | Type   | Required | Length | Description |
| ------------------------- | ------------------ | ------ | -------- | ------ | ----------- |
| tdy_upper_scesn_ori       | 당일상위이탈원     | LIST   | N        |        |             |
| - sel_scesn_tm            | 매도이탈시간       | String | N        | 20     |             |
| - sell_qty                | 매도수량           | String | N        | 20     |             |
| - sel_upper_scesn_ori     | 매도상위이탈원     | String | N        | 20     |             |
| - buy_scesn_tm            | 매수이탈시간       | String | N        | 20     |             |
| - buy_qty                 | 매수수량           | String | N        | 20     |             |
| - buy_upper_scesn_ori     | 매수상위이탈원     | String | N        | 20     |             |
| - qry_dt                  | 조회일자           | String | N        | 20     |             |
| - qry_tm                  | 조회시간           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd": "005930"
}
```

#### 응답 예시

```json
{
	"tdy_upper_scesn_ori":
		[
			{
				"sel_scesn_tm":"154706",
				"sell_qty":"32",
				"sel_upper_scesn_ori":"키움증권",
				"buy_scesn_tm":"151615",
				"buy_qty":"48",
				"buy_upper_scesn_ori":"키움증권",
				"qry_dt":"012",
				"qry_tm":"012"
			},
			{
				"sel_scesn_tm":"145127",
				"sell_qty":"14",
				"sel_upper_scesn_ori":"키움증권",
				"buy_scesn_tm":"144055",
				"buy_qty":"21",
				"buy_upper_scesn_ori":"키움증권",
				"qry_dt":"017",
				"qry_tm":"046"
			},
			{
				"sel_scesn_tm":"145117",
				"sell_qty":"10",
				"sel_upper_scesn_ori":"키움증권",
				"buy_scesn_tm":"140901",
				"buy_qty":"3",
				"buy_upper_scesn_ori":"키움증권",
				"qry_dt":"050",
				"qry_tm":"056"
			},
			{
				"sel_scesn_tm":"",
				"sell_qty":"",
				"sel_upper_scesn_ori":"",
				"buy_scesn_tm":"135548",
				"buy_qty":"2",
				"buy_upper_scesn_ori":"키움증권",
				"qry_dt":"",
				"qry_tm":"001"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 동일순매매순위요청 (ka10062)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element   | 한글명     | Type   | Required | Length | Description                                                                             |
| --------- | ---------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| strt_dt   | 시작일자   | String | Y        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                       |
| end_dt    | 종료일자   | String | N        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                       |
| mrkt_tp   | 시장구분   | String | Y        | 3      | 000:전체, 001: 코스피, 101:코스닥                                                      |
| trde_tp   | 매매구분   | String | Y        | 1      | 1:순매수, 2:순매도                                                                      |
| sort_cnd  | 정렬조건   | String | Y        | 1      | 1:수량, 2:금액                                                                          |
| unit_tp   | 단위구분   | String | Y        | 1      | 1:단주, 1000:천주                                                                       |
| stex_tp   | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                     |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명               | Type   | Required | Length | Description |
| -------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| eql_nettrde_rank           | 동일순매매순위       | LIST   | N        |        |             |
| - stk_cd                   | 종목코드             | String | N        | 20     |             |
| - rank                     | 순위                 | String | N        | 20     |             |
| - stk_nm                   | 종목명               | String | N        | 20     |             |
| - cur_prc                  | 현재가               | String | N        | 20     |             |
| - pre_sig                  | 대비기호             | String | N        | 20     |             |
| - pred_pre                 | 전일대비             | String | N        | 20     |             |
| - flu_rt                   | 등락율               | String | N        | 20     |             |
| - acc_trde_qty             | 누적거래량           | String | N        | 20     |             |
| - orgn_nettrde_qty         | 기관순매매수량       | String | N        | 20     |             |
| - orgn_nettrde_amt         | 기관순매매금액       | String | N        | 20     |             |
| - orgn_nettrde_avg_pric    | 기관순매매평균가     | String | N        | 20     |             |
| - for_nettrde_qty          | 외인순매매수량       | String | N        | 20     |             |
| - for_nettrde_amt          | 외인순매매금액       | String | N        | 20     |             |
| - for_nettrde_avg_pric     | 외인순매매평균가     | String | N        | 20     |             |
| - nettrde_qty              | 순매매수량           | String | N        | 20     |             |
| - nettrde_amt              | 순매매금액           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"strt_dt": "20241106",
	"end_dt": "20241107",
	"mrkt_tp": "000",
	"trde_tp": "1",
	"sort_cnd": "1",
	"unit_tp": "1",
	"stex_tp": "3"
}
```

#### 응답 예시

```json
{
	"eql_nettrde_rank":
		[
			{
				"stk_cd":"005930",
				"rank":"1",
				"stk_nm":"삼성전자",
				"cur_prc":"-206000",
				"pre_sig":"5",
				"pred_pre":"-500",
				"flu_rt":"-0.24",
				"acc_trde_qty":"85",
				"orgn_nettrde_qty":"+2",
				"orgn_nettrde_amt":"0",
				"orgn_nettrde_avg_pric":"206000",
				"for_nettrde_qty":"+275",
				"for_nettrde_amt":"+59",
				"for_nettrde_avg_pric":"213342",
				"nettrde_qty":"+277",
				"nettrde_amt":"+59"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 장중투자자별매매상위요청 (ka10065)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명     | Type   | Required | Length | Description                                                                                                                                                                                                                                                           |
| -------- | ---------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| trde_tp  | 매매구분   | String | Y        | 1      | 1:순매수, 2:순매도                                                                                                                                                                                                                                                   |
| mrkt_tp  | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                                                                                                                     |
| orgn_tp  | 기관구분   | String | Y        | 4      | 9000:외국인, 9100:외국계, 1000:금융투자, 3000:투신, 5000:기타금융, 4000:은행, 2000:보험, 6000:연기금, 7000:국가, 7100:기타법인, 9999:기관계                                                                                                                           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명               | Type   | Required | Length | Description |
| -------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| opmr_invsr_trde_upper      | 장중투자자별매매상위 | LIST   | N        |        |             |
| - stk_cd                   | 종목코드             | String | N        | 20     |             |
| - stk_nm                   | 종목명               | String | N        | 20     |             |
| - sel_qty                  | 매도량               | String | N        | 20     |             |
| - buy_qty                  | 매수량               | String | N        | 20     |             |
| - netslmt                  | 순매도               | String | N        | 20     |             |

#### 요청 예시

```json
{
	"trde_tp": "1",
	"mrkt_tp": "000",
	"orgn_tp": "9000"
}
```

#### 응답 예시

```json
{
	"opmr_invsr_trde_upper":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-39420",
				"buy_qty":"+73452",
				"netslmt":"+34033"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-13970",
				"buy_qty":"+25646",
				"netslmt":"+11676"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-10063",
				"buy_qty":"+21167",
				"netslmt":"+11104"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-37542",
				"buy_qty":"+47604",
				"netslmt":"+10061"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-2310",
				"buy_qty":"+10874",
				"netslmt":"+8564"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-24912",
				"buy_qty":"+33114",
				"netslmt":"+8203"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"sel_qty":"-27306",
				"buy_qty":"+34853",
				"netslmt":"+7547"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 시간외단일가등락율순위요청 (ka10098)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명       | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         |
| -------------- | ------------ | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp        | 시장구분     | String | Y        | 3      | 000:전체,001:코스피,101:코스닥                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |
| sort_base      | 정렬기준     | String | Y        | 1      | 1:상승률, 2:상승폭, 3:하락률, 4:하락폭, 5:보합                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| stk_cnd        | 종목조건     | String | Y        | 2      | 0:전체조회,1:관리종목제외,2:정리매매종목제외,3:우선주제외,4:관리종목우선주제외,5:증100제외,6:증100만보기,7:증40만보기,8:증30만보기,9:증20만보기,12:증50만보기,13:증60만보기,14:ETF제외,15:스팩제외,16:ETF+ETN제외,17:ETN제외                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |
| trde_qty_cnd   | 거래량조건   | String | Y        | 5      | 0:전체조회, 10:백주이상,50:5백주이상,100;천주이상, 500:5천주이상, 1000:만주이상, 5000:5만주이상, 10000:10만주이상                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  |
| crd_cnd        | 신용조건     | String | Y        | 1      | 0:전체조회, 9:신용융자전체, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 8:신용대주, 5:신용한도초과제외                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               |
| trde_prica     | 거래대금     | String | Y        | 5      | 0:전체조회, 5:5백만원이상,10:1천만원이상, 30:3천만원이상, 50:5천만원이상, 100:1억원이상, 300:3억원이상, 500:5억원이상, 1000:10억원이상, 3000:30억원이상, 5000:50억원이상, 10000:100억원이상                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                        | 한글명                   | Type   | Required | Length | Description |
| ------------------------------ | ------------------------ | ------ | -------- | ------ | ----------- |
| ovt_sigpric_flu_rt_rank        | 시간외단일가등락율순위   | LIST   | N        |        |             |
| - rank                         | 순위                     | String | N        | 20     |             |
| - stk_cd                       | 종목코드                 | String | N        | 20     |             |
| - stk_nm                       | 종목명                   | String | N        | 20     |             |
| - cur_prc                      | 현재가                   | String | N        | 20     |             |
| - pred_pre_sig                 | 전일대비기호             | String | N        | 20     |             |
| - pred_pre                     | 전일대비                 | String | N        | 20     |             |
| - flu_rt                       | 등락률                   | String | N        | 20     |             |
| - sel_tot_req                  | 매도총잔량               | String | N        | 20     |             |
| - buy_tot_req                  | 매수총잔량               | String | N        | 20     |             |
| - acc_trde_qty                 | 누적거래량               | String | N        | 20     |             |
| - acc_trde_prica               | 누적거래대금             | String | N        | 20     |             |
| - tdy_close_pric               | 당일종가                 | String | N        | 20     |             |
| - tdy_close_pric_flu_rt        | 당일종가등락률           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "000",
	"sort_base": "5",
	"stk_cnd": "0",
	"trde_qty_cnd": "0",
	"crd_cnd": "0",
	"trde_prica": "0"
}
```

#### 응답 예시

```json
{
	"ovt_sigpric_flu_rt_rank":
		[
			{
				"rank":"1",
				"stk_cd":"069500",
				"stk_nm":"KODEX 200",
				"cur_prc":"17140",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"sel_tot_req":"0",
				"buy_tot_req":"24",
				"acc_trde_qty":"42",
				"acc_trde_prica":"1",
				"tdy_close_pric":"17140",
				"tdy_close_pric_flu_rt":"-0.26"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 외국인기관매매상위요청 (ka90009)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/rkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명         | Type   | Required | Length | Description                                                                             |
| ----------- | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| mrkt_tp     | 시장구분       | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                      |
| amt_qty_tp  | 금액수량구분   | String | Y        | 1      | 1:금액(천만), 2:수량(천)                                                               |
| qry_dt_tp   | 조회일자구분   | String | Y        | 1      | 0:조회일자 미포함, 1:조회일자 포함                                                     |
| date        | 날짜           | String | N        | 8      | YYYYMMDD<br/>(연도4자리, 월 2자리, 일 2자리 형식)                                       |
| stex_tp     | 거래소구분     | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                   |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                        | 한글명                   | Type   | Required | Length | Description |
| ------------------------------ | ------------------------ | ------ | -------- | ------ | ----------- |
| frgnr_orgn_trde_upper          | 외국인기관매매상위       | LIST   | N        |        |             |
| - for_netslmt_stk_cd           | 외인순매도종목코드       | String | N        | 20     |             |
| - for_netslmt_stk_nm           | 외인순매도종목명         | String | N        | 20     |             |
| - for_netslmt_amt              | 외인순매도금액           | String | N        | 20     |             |
| - for_netslmt_qty              | 외인순매도수량           | String | N        | 20     |             |
| - for_netprps_stk_cd           | 외인순매수종목코드       | String | N        | 20     |             |
| - for_netprps_stk_nm           | 외인순매수종목명         | String | N        | 20     |             |
| - for_netprps_amt              | 외인순매수금액           | String | N        | 20     |             |
| - for_netprps_qty              | 외인순매수수량           | String | N        | 20     |             |
| - orgn_netslmt_stk_cd          | 기관순매도종목코드       | String | N        | 20     |             |
| - orgn_netslmt_stk_nm          | 기관순매도종목명         | String | N        | 20     |             |
| - orgn_netslmt_amt             | 기관순매도금액           | String | N        | 20     |             |
| - orgn_netslmt_qty             | 기관순매도수량           | String | N        | 20     |             |
| - orgn_netprps_stk_cd          | 기관순매수종목코드       | String | N        | 20     |             |
| - orgn_netprps_stk_nm          | 기관순매수종목명         | String | N        | 20     |             |
| - orgn_netprps_amt             | 기관순매수금액           | String | N        | 20     |             |
| - orgn_netprps_qty             | 기관순매수수량           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "000",
	"amt_qty_tp": "1",
	"qry_dt_tp": "1",
	"date": "20241101",
	"stex_tp": "1"
}
```

#### 응답 예시

```json
{
	"frgnr_orgn_trde_upper":
		[
			{
				"for_netslmt_stk_cd":"069500",
				"for_netslmt_stk_nm":"KODEX 200",
				"for_netslmt_amt":"-130811",
				"for_netslmt_qty":"-50312",
				"for_netprps_stk_cd":"069500",
				"for_netprps_stk_nm":"KODEX 200",
				"for_netprps_amt":"-130811",
				"for_netprps_qty":"-50312",
				"orgn_netslmt_stk_cd":"069500",
				"orgn_netslmt_stk_nm":"KODEX 200",
				"orgn_netslmt_amt":"-130811",
				"orgn_netslmt_qty":"-50312",
				"orgn_netprps_stk_cd":"069500",
				"orgn_netprps_stk_nm":"KODEX 200",
				"orgn_netprps_amt":"-130811",
				"orgn_netprps_qty":"-50312"
			},
			{
				"for_netslmt_stk_cd":"069500",
				"for_netslmt_stk_nm":"KODEX 200",
				"for_netslmt_amt":"-130811",
				"for_netslmt_qty":"-50312",
				"for_netprps_stk_cd":"069500",
				"for_netprps_stk_nm":"KODEX 200",
				"for_netprps_amt":"-130811",
				"for_netprps_qty":"-50312",
				"orgn_netslmt_stk_cd":"069500",
				"orgn_netslmt_stk_nm":"KODEX 200",
				"orgn_netslmt_amt":"-130811",
				"orgn_netslmt_qty":"-50312",
				"orgn_netprps_stk_cd":"069500",
				"orgn_netprps_stk_nm":"KODEX 200",
				"orgn_netprps_amt":"-130811",
				"orgn_netprps_qty":"-50312"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```