# 키움증권 API 문서

## 국내주식 REST API

### 시세

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 주식호가요청 | ka10004 | 주식호가 정보 조회 |
| 주식일주월시분요청 | ka10005 | 주식 일/주/월/시분 정보 조회 |
| 주식시분요청 | ka10006 | 주식 시분 정보 조회 |
| 시세표성정보요청 | ka10007 | 시세표성 정보 조회 |
| 신주인수권전체시세요청 | ka10011 | 신주인수권 전체시세 조회 |
| 일별기관매매종목요청 | ka10044 | 일별 기관매매종목 조회 |
| 종목별기관매매추이요청 | ka10045 | 종목별 기관매매추이 조회 |
| 체결강도추이시간별요청 | ka10046 | 체결강도추이 시간별 조회 |
| 체결강도추이일별요청 | ka10047 | 체결강도추이 일별 조회 |
| 장중투자자별매매요청 | ka10063 | 장중 투자자별매매 조회 |
| 장마감후투자자별매매요청 | ka10066 | 장마감후 투자자별매매 조회 |
| 증권사별종목매매동향요청 | ka10078 | 증권사별 종목매매동향 조회 |
| 일별주가요청 | ka10086 | 일별 주가 조회 |
| 시간외단일가요청 | ka10087 | 시간외 단일가 조회 |
| 프로그램매매추이요청 시간대별 | ka90005 | 프로그램매매추이 시간대별 조회 |
| 프로그램매매차익잔고추이요청 | ka90006 | 프로그램매매 차익잔고추이 조회 |
| 프로그램매매누적추이요청 | ka90007 | 프로그램매매 누적추이 조회 |
| 종목시간별프로그램매매추이요청 | ka90008 | 종목 시간별 프로그램매매추이 조회 |
| 프로그램매매추이요청 일자별 | ka90010 | 프로그램매매추이 일자별 조회 |
| 종목일별프로그램매매추이요청 | ka90013 | 종목 일별 프로그램매매추이 조회 |

---

### 주식호가요청 (ka10004)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명           | Type   | Required | Length | Description    |
| -------------------- | ---------------- | ------ | -------- | ------ | -------------- |
| bid_req_base_tm      | 호가잔량기준시간 | String | N        | 20     | 호가시간       |
| sel_10th_pre_req_pre | 매도10차선잔량대비 | String | N        | 20     | 매도호가직전대비10 |
| sel_10th_pre_req     | 매도10차선잔량   | String | N        | 20     | 매도호가수량10 |
| sel_10th_pre_bid     | 매도10차선호가   | String | N        | 20     | 매도호가10     |
| sel_9th_pre_req_pre  | 매도9차선잔량대비 | String | N        | 20     | 매도호가직전대비9 |
| sel_9th_pre_req      | 매도9차선잔량    | String | N        | 20     | 매도호가수량9  |
| sel_9th_pre_bid      | 매도9차선호가    | String | N        | 20     | 매도호가9      |
| sel_8th_pre_req_pre  | 매도8차선잔량대비 | String | N        | 20     | 매도호가직전대비8 |
| sel_8th_pre_req      | 매도8차선잔량    | String | N        | 20     | 매도호가수량8  |
| sel_8th_pre_bid      | 매도8차선호가    | String | N        | 20     | 매도호가8      |
| sel_7th_pre_req_pre  | 매도7차선잔량대비 | String | N        | 20     | 매도호가직전대비7 |
| sel_7th_pre_req      | 매도7차선잔량    | String | N        | 20     | 매도호가수량7  |
| sel_7th_pre_bid      | 매도7차선호가    | String | N        | 20     | 매도호가7      |
| sel_6th_pre_req_pre  | 매도6차선잔량대비 | String | N        | 20     | 매도호가직전대비6 |
| sel_6th_pre_req      | 매도6차선잔량    | String | N        | 20     | 매도호가수량6  |
| sel_6th_pre_bid      | 매도6차선호가    | String | N        | 20     | 매도호가6      |
| sel_5th_pre_req_pre  | 매도5차선잔량대비 | String | N        | 20     | 매도호가직전대비5 |
| sel_5th_pre_req      | 매도5차선잔량    | String | N        | 20     | 매도호가수량5  |
| sel_5th_pre_bid      | 매도5차선호가    | String | N        | 20     | 매도호가5      |
| sel_4th_pre_req_pre  | 매도4차선잔량대비 | String | N        | 20     | 매도호가직전대비4 |
| sel_4th_pre_req      | 매도4차선잔량    | String | N        | 20     | 매도호가수량4  |
| sel_4th_pre_bid      | 매도4차선호가    | String | N        | 20     | 매도호가4      |
| sel_3th_pre_req_pre  | 매도3차선잔량대비 | String | N        | 20     | 매도호가직전대비3 |
| sel_3th_pre_req      | 매도3차선잔량    | String | N        | 20     | 매도호가수량3  |
| sel_3th_pre_bid      | 매도3차선호가    | String | N        | 20     | 매도호가3      |
| sel_2th_pre_req_pre  | 매도2차선잔량대비 | String | N        | 20     | 매도호가직전대비2 |
| sel_2th_pre_req      | 매도2차선잔량    | String | N        | 20     | 매도호가수량2  |
| sel_2th_pre_bid      | 매도2차선호가    | String | N        | 20     | 매도호가2      |
| sel_1th_pre_req_pre  | 매도1차선잔량대비 | String | N        | 20     | 매도호가직전대비1 |
| sel_fpr_req          | 매도최우선잔량   | String | N        | 20     | 매도호가수량1  |
| sel_fpr_bid          | 매도최우선호가   | String | N        | 20     | 매도호가1      |
| buy_fpr_bid          | 매수최우선호가   | String | N        | 20     | 매수호가1      |
| buy_fpr_req          | 매수최우선잔량   | String | N        | 20     | 매수호가수량1  |
| buy_1th_pre_req_pre  | 매수1차선잔량대비 | String | N        | 20     | 매수호가직전대비1 |
| buy_2th_pre_bid      | 매수2차선호가    | String | N        | 20     | 매수호가2      |
| buy_2th_pre_req      | 매수2차선잔량    | String | N        | 20     | 매수호가수량2  |
| buy_2th_pre_req_pre  | 매수2차선잔량대비 | String | N        | 20     | 매수호가직전대비2 |
| buy_3th_pre_bid      | 매수3차선호가    | String | N        | 20     | 매수호가3      |
| buy_3th_pre_req      | 매수3차선잔량    | String | N        | 20     | 매수호가수량3  |
| buy_3th_pre_req_pre  | 매수3차선잔량대비 | String | N        | 20     | 매수호가직전대비3 |
| buy_4th_pre_bid      | 매수4차선호가    | String | N        | 20     | 매수호가4      |
| buy_4th_pre_req      | 매수4차선잔량    | String | N        | 20     | 매수호가수량4  |
| buy_4th_pre_req_pre  | 매수4차선잔량대비 | String | N        | 20     | 매수호가직전대비4 |
| buy_5th_pre_bid      | 매수5차선호가    | String | N        | 20     | 매수호가5      |
| buy_5th_pre_req      | 매수5차선잔량    | String | N        | 20     | 매수호가수량5  |
| buy_5th_pre_req_pre  | 매수5차선잔량대비 | String | N        | 20     | 매수호가직전대비5 |
| buy_6th_pre_bid      | 매수6차선호가    | String | N        | 20     | 매수호가6      |
| buy_6th_pre_req      | 매수6차선잔량    | String | N        | 20     | 매수호가수량6  |
| buy_6th_pre_req_pre  | 매수6차선잔량대비 | String | N        | 20     | 매수호가직전대비6 |
| buy_7th_pre_bid      | 매수7차선호가    | String | N        | 20     | 매수호가7      |
| buy_7th_pre_req      | 매수7차선잔량    | String | N        | 20     | 매수호가수량7  |
| buy_7th_pre_req_pre  | 매수7차선잔량대비 | String | N        | 20     | 매수호가직전대비7 |
| buy_8th_pre_bid      | 매수8차선호가    | String | N        | 20     | 매수호가8      |
| buy_8th_pre_req      | 매수8차선잔량    | String | N        | 20     | 매수호가수량8  |
| buy_8th_pre_req_pre  | 매수8차선잔량대비 | String | N        | 20     | 매수호가직전대비8 |
| buy_9th_pre_bid      | 매수9차선호가    | String | N        | 20     | 매수호가9      |
| buy_9th_pre_req      | 매수9차선잔량    | String | N        | 20     | 매수호가수량9  |
| buy_9th_pre_req_pre  | 매수9차선잔량대비 | String | N        | 20     | 매수호가직전대비9 |
| buy_10th_pre_bid     | 매수10차선호가   | String | N        | 20     | 매수호가10     |
| buy_10th_pre_req     | 매수10차선잔량   | String | N        | 20     | 매수호가수량10 |
| buy_10th_pre_req_pre | 매수10차선잔량대비 | String | N        | 20     | 매수호가직전대비10 |
| tot_sel_req_jub_pre  | 총매도잔량직전대비 | String | N        | 20     | 매도호가총잔량직전대비 |
| tot_sel_req          | 총매도잔량       | String | N        | 20     | 매도호가총잔량 |
| tot_buy_req          | 총매수잔량       | String | N        | 20     | 매수호가총잔량 |
| tot_buy_req_jub_pre  | 총매수잔량직전대비 | String | N        | 20     | 매수호가총잔량직전대비 |
| ovt_sel_req_pre      | 시간외매도잔량대비 | String | N        | 20     | 시간외 매도호가 총잔량 직전대비 |
| ovt_sel_req          | 시간외매도잔량   | String | N        | 20     | 시간외 매도호가 총잔량 |
| ovt_buy_req          | 시간외매수잔량   | String | N        | 20     | 시간외 매수호가 총잔량 |
| ovt_buy_req_pre      | 시간외매수잔량대비 | String | N        | 20     | 시간외 매수호가 총잔량 직전대비 |

#### 요청 예시

```json
{
    "stk_cd": "005930"
}
```

#### 응답 예시

```json
{
    "bid_req_base_tm": "162000",
    "sel_10th_pre_req_pre": "0",
    "sel_10th_pre_req": "0",
    "sel_10th_pre_bid": "0",
    "sel_9th_pre_req_pre": "0",
    "sel_9th_pre_req": "0",
    "sel_9th_pre_bid": "0",
    "sel_8th_pre_req_pre": "0",
    "sel_8th_pre_req": "0",
    "sel_8th_pre_bid": "0",
    "sel_7th_pre_req_pre": "0",
    "sel_7th_pre_req": "0",
    "sel_7th_pre_bid": "0",
    "sel_6th_pre_req_pre": "0",
    "sel_6th_pre_req": "0",
    "sel_6th_pre_bid": "0",
    "sel_5th_pre_req_pre": "0",
    "sel_5th_pre_req": "0",
    "sel_5th_pre_bid": "0",
    "sel_4th_pre_req_pre": "0",
    "sel_4th_pre_req": "0",
    "sel_4th_pre_bid": "0",
    "sel_3th_pre_req_pre": "0",
    "sel_3th_pre_req": "0",
    "sel_3th_pre_bid": "0",
    "sel_2th_pre_req_pre": "0",
    "sel_2th_pre_req": "0",
    "sel_2th_pre_bid": "0",
    "sel_1th_pre_req_pre": "0",
    "sel_fpr_req": "0",
    "sel_fpr_bid": "0",
    "buy_fpr_bid": "0",
    "buy_fpr_req": "0",
    "buy_1th_pre_req_pre": "0",
    "buy_2th_pre_bid": "0",
    "buy_2th_pre_req": "0",
    "buy_2th_pre_req_pre": "0",
    "buy_3th_pre_bid": "0",
    "buy_3th_pre_req": "0",
    "buy_3th_pre_req_pre": "0",
    "buy_4th_pre_bid": "0",
    "buy_4th_pre_req": "0",
    "buy_4th_pre_req_pre": "0",
    "buy_5th_pre_bid": "0",
    "buy_5th_pre_req": "0",
    "buy_5th_pre_req_pre": "0",
    "buy_6th_pre_bid": "0",
    "buy_6th_pre_req": "0",
    "buy_6th_pre_req_pre": "0",
    "buy_7th_pre_bid": "0",
    "buy_7th_pre_req": "0",
    "buy_7th_pre_req_pre": "0",
    "buy_8th_pre_bid": "0",
    "buy_8th_pre_req": "0",
    "buy_8th_pre_req_pre": "0",
    "buy_9th_pre_bid": "0",
    "buy_9th_pre_req": "0",
    "buy_9th_pre_req_pre": "0",
    "buy_10th_pre_bid": "0",
    "buy_10th_pre_req": "0",
    "buy_10th_pre_req_pre": "0",
    "tot_sel_req_jub_pre": "0",
    "tot_sel_req": "0",
    "tot_buy_req": "0",
    "tot_buy_req_jub_pre": "0",
    "ovt_sel_req_pre": "0",
    "ovt_sel_req": "0",
    "ovt_buy_req": "0",
    "ovt_buy_req_pre": "0",
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 주식일주월시분요청 (ka10005)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명         | Type   | Required | Length | Description |
| -------------- | -------------- | ------ | -------- | ------ | ----------- |
| stk_ddwkmm     | 주식일주월시분 | LIST   | N        |        |             |
| - date         | 날짜           | String | N        | 20     |             |
| - open_pric    | 시가           | String | N        | 20     |             |
| - high_pric    | 고가           | String | N        | 20     |             |
| - low_pric     | 저가           | String | N        | 20     |             |
| - close_pric   | 종가           | String | N        | 20     |             |
| - pre          | 대비           | String | N        | 20     |             |
| - flu_rt       | 등락률         | String | N        | 20     |             |
| - trde_qty     | 거래량         | String | N        | 20     |             |
| - trde_prica   | 거래대금       | String | N        | 20     |             |
| - for_poss     | 외인보유       | String | N        | 20     |             |
| - for_wght     | 외인비중       | String | N        | 20     |             |
| - for_netprps  | 외인순매수     | String | N        | 20     |             |
| - orgn_netprps | 기관순매수     | String | N        | 20     |             |
| - ind_netprps  | 개인순매수     | String | N        | 20     |             |
| - crd_remn_rt  | 신용잔고율     | String | N        | 20     |             |
| - frgn         | 외국계         | String | N        | 20     |             |
| - prm          | 프로그램       | String | N        | 20     |             |

#### 요청 예시
```json
{
    "stk_cd": "005930"
}
```

#### 응답 예시
```json
{
    "stk_ddwkmm": [
        {
            "date": "20241028",
            "open_pric": "95400",
            "high_pric": "95400",
            "low_pric": "95400",
            "close_pric": "95400",
            "pre": "0",
            "flu_rt": "0.00",
            "trde_qty": "0",
            "trde_prica": "0",
            "cntr_str": "0.00",
            "for_poss": "+26.07",
            "for_wght": "+26.07",
            "for_netprps": "0",
            "orgn_netprps": "",
            "ind_netprps": "",
            "frgn": "",
            "crd_remn_rt": "",
            "prm": ""
        },
        {
            "date": "20241025",
            "open_pric": "95400",
            "high_pric": "95400",
            "low_pric": "95400",
            "close_pric": "95400",
            "pre": "",
            "flu_rt": "",
            "trde_qty": "0",
            "trde_prica": "",
            "cntr_str": "",
            "for_poss": "",
            "for_wght": "",
            "for_netprps": "",
            "orgn_netprps": "",
            "ind_netprps": "",
            "frgn": "",
            "crd_remn_rt": "",
            "prm": ""
        },
        {
            "date": "20241024",
            "open_pric": "94300",
            "high_pric": "95400",
            "low_pric": "94300",
            "close_pric": "+95400",
            "pre": "",
            "flu_rt": "",
            "trde_qty": "70",
            "trde_prica": "",
            "cntr_str": "",
            "for_poss": "",
            "for_wght": "",
            "for_netprps": "",
            "orgn_netprps": "",
            "ind_netprps": "",
            "frgn": "",
            "crd_remn_rt": "",
            "prm": ""
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```---

### 주식시분요청 (ka10006)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 20 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| date | 날짜 | String | N | 20 | |
| open_pric | 시가 | String | N | 20 | |
| high_pric | 고가 | String | N | 20 | |
| low_pric | 저가 | String | N | 20 | |
| close_pric | 종가 | String | N | 20 | |
| pre | 대비 | String | N | 20 | |
| flu_rt | 등락률 | String | N | 20 | |
| trde_qty | 거래량 | String | N | 20 | |
| trde_prica | 거래대금 | String | N | 20 | |
| cntr_str | 체결강도 | String | N | 20 | |

#### 요청 예시
```json
{
    "stk_cd": "005930"
}
```

#### 응답 예시
```json
{
    "date": "20241105",
    "open_pric": "0",
    "high_pric": "0",
    "low_pric": "0",
    "close_pric": "135300",
    "pre": "0",
    "flu_rt": "0.00",
    "trde_qty": "0",
    "trde_prica": "0",
    "cntr_str": "0.00",
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 시세표성정보요청 (ka10007)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 20 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_nm | 종목명 | String | N | 20 | |
| stk_cd | 종목코드 | String | N | 6 | |
| date | 날짜 | String | N | 20 | |
| tm | 시간 | String | N | 20 | |
| pred_close_pric | 전일종가 | String | N | 20 | |
| pred_trde_qty | 전일거래량 | String | N | 20 | |
| upl_pric | 상한가 | String | N | 20 | |
| lst_pric | 하한가 | String | N | 20 | |
| pred_trde_prica | 전일거래대금 | String | N | 20 | |
| flo_stkcnt | 상장주식수 | String | N | 20 | |
| cur_prc | 현재가 | String | N | 20 | |
| smbol | 부호 | String | N | 20 | |
| flu_rt | 등락률 | String | N | 20 | |
| pred_rt | 전일비 | String | N | 20 | |
| open_pric | 시가 | String | N | 20 | |
| high_pric | 고가 | String | N | 20 | |
| low_pric | 저가 | String | N | 20 | |
| cntr_qty | 체결량 | String | N | 20 | |
| trde_qty | 거래량 | String | N | 20 | |
| trde_prica | 거래대금 | String | N | 20 | |
| exp_cntr_pric | 예상체결가 | String | N | 20 | |
| exp_cntr_qty | 예상체결량 | String | N | 20 | |
| exp_sel_pri_bid | 예상매도우선호가 | String | N | 20 | |
| exp_buy_pri_bid | 예상매수우선호가 | String | N | 20 | |
| trde_strt_dt | 거래시작일 | String | N | 20 | |
| exec_pric | 행사가격 | String | N | 20 | |
| hgst_pric | 최고가 | String | N | 20 | |
| lwst_pric | 최저가 | String | N | 20 | |
| hgst_pric_dt | 최고가일 | String | N | 20 | |
| lwst_pric_dt | 최저가일 | String | N | 20 | |
| sel_1bid | 매도1호가 | String | N | 20 | |
| sel_2bid | 매도2호가 | String | N | 20 | |
| sel_3bid | 매도3호가 | String | N | 20 | |
| sel_4bid | 매도4호가 | String | N | 20 | |
| sel_5bid | 매도5호가 | String | N | 20 | |
| sel_6bid | 매도6호가 | String | N | 20 | |
| sel_7bid | 매도7호가 | String | N | 20 | |
| sel_8bid | 매도8호가 | String | N | 20 | |
| sel_9bid | 매도9호가 | String | N | 20 | |
| sel_10bid | 매도10호가 | String | N | 20 | |
| buy_1bid | 매수1호가 | String | N | 20 | |
| buy_2bid | 매수2호가 | String | N | 20 | |
| buy_3bid | 매수3호가 | String | N | 20 | |
| buy_4bid | 매수4호가 | String | N | 20 | |
| buy_5bid | 매수5호가 | String | N | 20 | |
| buy_6bid | 매수6호가 | String | N | 20 | |
| buy_7bid | 매수7호가 | String | N | 20 | |
| buy_8bid | 매수8호가 | String | N | 20 | |
| buy_9bid | 매수9호가 | String | N | 20 | |
| buy_10bid | 매수10호가 | String | N | 20 | |
| sel_1bid_req | 매도1호가잔량 | String | N | 20 | |
| sel_2bid_req | 매도2호가잔량 | String | N | 20 | |
| sel_3bid_req | 매도3호가잔량 | String | N | 20 | |
| sel_4bid_req | 매도4호가잔량 | String | N | 20 | |
| sel_5bid_req | 매도5호가잔량 | String | N | 20 | |
| sel_6bid_req | 매도6호가잔량 | String | N | 20 | |
| sel_7bid_req | 매도7호가잔량 | String | N | 20 | |
| sel_8bid_req | 매도8호가잔량 | String | N | 20 | |
| sel_9bid_req | 매도9호가잔량 | String | N | 20 | |
| sel_10bid_req | 매도10호가잔량 | String | N | 20 | |
| buy_1bid_req | 매수1호가잔량 | String | N | 20 | |
| buy_2bid_req | 매수2호가잔량 | String | N | 20 | |
| buy_3bid_req | 매수3호가잔량 | String | N | 20 | |
| buy_4bid_req | 매수4호가잔량 | String | N | 20 | |
| buy_5bid_req | 매수5호가잔량 | String | N | 20 | |
| buy_6bid_req | 매수6호가잔량 | String | N | 20 | |
| buy_7bid_req | 매수7호가잔량 | String | N | 20 | |
| buy_8bid_req | 매수8호가잔량 | String | N | 20 | |
| buy_9bid_req | 매수9호가잔량 | String | N | 20 | |
| buy_10bid_req | 매수10호가잔량 | String | N | 20 | |
| sel_1bid_jub_pre | 매도1호가직전대비 | String | N | 20 | |
| sel_2bid_jub_pre | 매도2호가직전대비 | String | N | 20 | |
| sel_3bid_jub_pre | 매도3호가직전대비 | String | N | 20 | |
| sel_4bid_jub_pre | 매도4호가직전대비 | String | N | 20 | |
| sel_5bid_jub_pre | 매도5호가직전대비 | String | N | 20 | |
| sel_6bid_jub_pre | 매도6호가직전대비 | String | N | 20 | |
| sel_7bid_jub_pre | 매도7호가직전대비 | String | N | 20 | |
| sel_8bid_jub_pre | 매도8호가직전대비 | String | N | 20 | |
| sel_9bid_jub_pre | 매도9호가직전대비 | String | N | 20 | |
| sel_10bid_jub_pre | 매도10호가직전대비 | String | N | 20 | |
| buy_1bid_jub_pre | 매수1호가직전대비 | String | N | 20 | |
| buy_2bid_jub_pre | 매수2호가직전대비 | String | N | 20 | |
| buy_3bid_jub_pre | 매수3호가직전대비 | String | N | 20 | |
| buy_4bid_jub_pre | 매수4호가직전대비 | String | N | 20 | |
| buy_5bid_jub_pre | 매수5호가직전대비 | String | N | 20 | |
| buy_6bid_jub_pre | 매수6호가직전대비 | String | N | 20 | |
| buy_7bid_jub_pre | 매수7호가직전대비 | String | N | 20 | |
| buy_8bid_jub_pre | 매수8호가직전대비 | String | N | 20 | |
| buy_9bid_jub_pre | 매수9호가직전대비 | String | N | 20 | |
| buy_10bid_jub_pre | 매수10호가직전대비 | String | N | 20 | |
| sel_1bid_cnt | 매도1호가건수 | String | N | 20 | |
| sel_2bid_cnt | 매도2호가건수 | String | N | 20 | |
| sel_3bid_cnt | 매도3호가건수 | String | N | 20 | |
| sel_4bid_cnt | 매도4호가건수 | String | N | 20 | |
| sel_5bid_cnt | 매도5호가건수 | String | N | 20 | |
| buy_1bid_cnt | 매수1호가건수 | String | N | 20 | |
| buy_2bid_cnt | 매수2호가건수 | String | N | 20 | |
| buy_3bid_cnt | 매수3호가건수 | String | N | 20 | |
| buy_4bid_cnt | 매수4호가건수 | String | N | 20 | |
| buy_5bid_cnt | 매수5호가건수 | String | N | 20 | |
| lpsel_1bid_req | LP매도1호가잔량 | String | N | 20 | |
| lpsel_2bid_req | LP매도2호가잔량 | String | N | 20 | |
| lpsel_3bid_req | LP매도3호가잔량 | String | N | 20 | |
| lpsel_4bid_req | LP매도4호가잔량 | String | N | 20 | |
| lpsel_5bid_req | LP매도5호가잔량 | String | N | 20 | |
| lpsel_6bid_req | LP매도6호가잔량 | String | N | 20 | |
| lpsel_7bid_req | LP매도7호가잔량 | String | N | 20 | |
| lpsel_8bid_req | LP매도8호가잔량 | String | N | 20 | |
| lpsel_9bid_req | LP매도9호가잔량 | String | N | 20 | |
| lpsel_10bid_req | LP매도10호가잔량 | String | N | 20 | |
| lpbuy_1bid_req | LP매수1호가잔량 | String | N | 20 | |
| lpbuy_2bid_req | LP매수2호가잔량 | String | N | 20 | |
| lpbuy_3bid_req | LP매수3호가잔량 | String | N | 20 | |
| lpbuy_4bid_req | LP매수4호가잔량 | String | N | 20 | |
| lpbuy_5bid_req | LP매수5호가잔량 | String | N | 20 | |
| lpbuy_6bid_req | LP매수6호가잔량 | String | N | 20 | |
| lpbuy_7bid_req | LP매수7호가잔량 | String | N | 20 | |
| lpbuy_8bid_req | LP매수8호가잔량 | String | N | 20 | |
| lpbuy_9bid_req | LP매수9호가잔량 | String | N | 20 | |
| lpbuy_10bid_req | LP매수10호가잔량 | String | N | 20 | |
| tot_buy_req | 총매수잔량 | String | N | 20 | |
| tot_sel_req | 총매도잔량 | String | N | 20 | |
| tot_buy_cnt | 총매수건수 | String | N | 20 | |
| tot_sel_cnt | 총매도건수 | String | N | 20 | |

#### 요청 예시
```json
{
    "stk_cd": "005930"
}
```

#### 응답 예시
```json
{
    "stk_nm": "삼성전자",
    "stk_cd": "005930",
    "date": "20241105",
    "tm": "104000",
    "pred_close_pric": "135300",
    "pred_trde_qty": "88862",
    "upl_pric": "+175800",
    "lst_pric": "-94800",
    "pred_trde_prica": "11963",
    "flo_stkcnt": "25527",
    "cur_prc": "135300",
    "smbol": "3",
    "flu_rt": "0.00",
    "pred_rt": "0.00",
    "open_pric": "0",
    "high_pric": "0",
    "low_pric": "0",
    "cntr_qty": "",
    "trde_qty": "0",
    "trde_prica": "0",
    "exp_cntr_pric": "-0",
    "exp_cntr_qty": "0",
    "exp_sel_pri_bid": "0",
    "exp_buy_pri_bid": "0",
    "trde_strt_dt": "00000000",
    "exec_pric": "0",
    "hgst_pric": "",
    "lwst_pric": "",
    "hgst_pric_dt": "",
    "lwst_pric_dt": "",
    "sel_1bid": "0",
    "sel_2bid": "0",
    "sel_3bid": "0",
    "sel_4bid": "0",
    "sel_5bid": "0",
    "sel_6bid": "0",
    "sel_7bid": "0",
    "sel_8bid": "0",
    "sel_9bid": "0",
    "sel_10bid": "0",
    "buy_1bid": "0",
    "buy_2bid": "0",
    "buy_3bid": "0",
    "buy_4bid": "0",
    "buy_5bid": "0",
    "buy_6bid": "0",
    "buy_7bid": "0",
    "buy_8bid": "0",
    "buy_9bid": "0",
    "buy_10bid": "0",
    "sel_1bid_req": "0",
    "sel_2bid_req": "0",
    "sel_3bid_req": "0",
    "sel_4bid_req": "0",
    "sel_5bid_req": "0",
    "sel_6bid_req": "0",
    "sel_7bid_req": "0",
    "sel_8bid_req": "0",
    "sel_9bid_req": "0",
    "sel_10bid_req": "0",
    "buy_1bid_req": "0",
    "buy_2bid_req": "0",
    "buy_3bid_req": "0",
    "buy_4bid_req": "0",
    "buy_5bid_req": "0",
    "buy_6bid_req": "0",
    "buy_7bid_req": "0",
    "buy_8bid_req": "0",
    "buy_9bid_req": "0",
    "buy_10bid_req": "0",
    "sel_1bid_jub_pre": "0",
    "sel_2bid_jub_pre": "0",
    "sel_3bid_jub_pre": "0",
    "sel_4bid_jub_pre": "0",
    "sel_5bid_jub_pre": "0",
    "sel_6bid_jub_pre": "0",
    "sel_7bid_jub_pre": "0",
    "sel_8bid_jub_pre": "0",
    "sel_9bid_jub_pre": "0",
    "sel_10bid_jub_pre": "0",
    "buy_1bid_jub_pre": "0",
    "buy_2bid_jub_pre": "0",
    "buy_3bid_jub_pre": "0",
    "buy_4bid_jub_pre": "0",
    "buy_5bid_jub_pre": "0",
    "buy_6bid_jub_pre": "0",
    "buy_7bid_jub_pre": "0",
    "buy_8bid_jub_pre": "0",
    "buy_9bid_jub_pre": "0",
    "buy_10bid_jub_pre": "0",
    "sel_1bid_cnt": "",
    "sel_2bid_cnt": "",
    "sel_3bid_cnt": "",
    "sel_4bid_cnt": "",
    "sel_5bid_cnt": "",
    "buy_1bid_cnt": "",
    "buy_2bid_cnt": "",
    "buy_3bid_cnt": "",
    "buy_4bid_cnt": "",
    "buy_5bid_cnt": "",
    "lpsel_1bid_req": "0",
    "lpsel_2bid_req": "0",
    "lpsel_3bid_req": "0",
    "lpsel_4bid_req": "0",
    "lpsel_5bid_req": "0",
    "lpsel_6bid_req": "0",
    "lpsel_7bid_req": "0",
    "lpsel_8bid_req": "0",
    "lpsel_9bid_req": "0",
    "lpsel_10bid_req": "0",
    "lpbuy_1bid_req": "0",
    "lpbuy_2bid_req": "0",
    "lpbuy_3bid_req": "0",
    "lpbuy_4bid_req": "0",
    "lpbuy_5bid_req": "0",
    "lpbuy_6bid_req": "0",
    "lpbuy_7bid_req": "0",
    "lpbuy_8bid_req": "0",
    "lpbuy_9bid_req": "0",
    "lpbuy_10bid_req": "0",
    "tot_buy_req": "0",
    "tot_sel_req": "0",
    "tot_buy_cnt": "",
    "tot_sel_cnt": "0",
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 신주인수권전체시세요청 (ka10011)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| newstk_recvrht_tp | 신주인수권구분 | String | Y | 20 | 00:전체, 05:신주인수권증권, 07:신주인수권증서 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| newstk_recvrht_mrpr | 신주인수권시세 | LIST | N | | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pred_pre_sig | 전일대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - fpr_sel_bid | 최우선매도호가 | String | N | 20 | |
| - fpr_buy_bid | 최우선매수호가 | String | N | 20 | |
| - acc_trde_qty | 누적거래량 | String | N | 20 | |
| - open_pric | 시가 | String | N | 20 | |
| - high_pric | 고가 | String | N | 20 | |
| - low_pric | 저가 | String | N | 20 | |

#### 요청 예시
```json
{
    "newstk_recvrht_tp": "00"
}
```

#### 응답 예시
```json
{
    "newstk_recvrht_mrpr": [
        {
            "stk_cd": "J0036221D",
            "stk_nm": "KG모빌리티 122WR",
            "cur_prc": "988",
            "pred_pre_sig": "3",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "fpr_sel_bid": "-0",
            "fpr_buy_bid": "-0",
            "acc_trde_qty": "0",
            "open_pric": "-0",
            "high_pric": "-0",
            "low_pric": "-0"
        },
        {
            "stk_cd": "J00532219",
            "stk_nm": "온타이드 9WR",
            "cur_prc": "12",
            "pred_pre_sig": "3",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "fpr_sel_bid": "-0",
            "fpr_buy_bid": "-0",
            "acc_trde_qty": "0",
            "open_pric": "-0",
            "high_pric": "-0",
            "low_pric": "-0"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 일별기관매매종목요청 (ka10044)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료일자 | String | Y | 8 | YYYYMMDD |
| trde_tp | 매매구분 | String | Y | 1 | 1:순매도, 2:순매수 |
| mrkt_tp | 시장구분 | String | Y | 3 | 001:코스피, 101:코스닥 |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| daly_orgn_trde_stk | 일별기관매매종목 | LIST | N | | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - netprps_qty | 순매수수량 | String | N | 20 | |
| - netprps_amt | 순매수금액 | String | N | 20 | |

#### 요청 예시
```json
{
    "strt_dt": "20241106",
    "end_dt": "20241107",
    "trde_tp": "1",
    "mrkt_tp": "001",
    "stex_tp": "3"
}
```

#### 응답 예시
```json
{
    "daly_orgn_trde_stk": [
        {
            "stk_cd": "005930",
            "stk_nm": "삼성전자",
            "netprps_qty": "-0",
            "netprps_amt": "-1",
            "prsm_avg_pric": "140000",
            "cur_prc": "-95100",
            "avg_pric_pre": "--44900",
            "pre_rt": "-32.07"
        },
        {
            "stk_cd": "005930",
            "stk_nm": "삼성전자",
            "netprps_qty": "-0",
            "netprps_amt": "-0",
            "prsm_avg_pric": "12000",
            "cur_prc": "9920",
            "avg_pric_pre": "--2080",
            "pre_rt": "-17.33"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 종목별기관매매추이요청 (ka10045)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 20 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료일자 | String | Y | 8 | YYYYMMDD |
| orgn_prsm_unp_tp | 기관추정단가구분 | String | Y | 1 | 1:매수단가, 2:매도단가 |
| for_prsm_unp_tp | 외인추정단가구분 | String | Y | 1 | 1:매수단가, 2:매도단가 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| orgn_prsm_avg_pric | 기관추정평균가 | String | N | | |
| for_prsm_avg_pric | 외인추정평균가 | String | N | | |
| stk_orgn_trde_trnsn | 종목별기관매매추이 | LIST | N | | |
| - dt | 일자 | String | N | 20 | |
| - close_pric | 종가 | String | N | 20 | |
| - pre_sig | 대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - orgn_dt_acc | 기관기간누적 | String | N | 20 | |
| - orgn_daly_nettrde_qty | 기관일별순매매수량 | String | N | 20 | |
| - for_dt_acc | 외인기간누적 | String | N | 20 | |
| - for_daly_nettrde_qty | 외인일별순매매수량 | String | N | 20 | |
| - limit_exh_rt | 한도소진율 | String | N | 20 | |

#### 요청 예시
```json
{
    "stk_cd": "005930",
    "strt_dt": "20241007",
    "end_dt": "20241107",
    "orgn_prsm_unp_tp": "1",
    "for_prsm_unp_tp": "1"
}
```

#### 응답 예시
```json
{
    "orgn_prsm_avg_pric": "117052",
    "for_prsm_avg_pric": "0",
    "stk_orgn_trde_trnsn": [
        {
            "dt": "20241107",
            "close_pric": "133600",
            "pre_sig": "0",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "trde_qty": "0",
            "orgn_dt_acc": "158",
            "orgn_daly_nettrde_qty": "0",
            "for_dt_acc": "28315",
            "for_daly_nettrde_qty": "0",
            "limit_exh_rt": "+26.14"
        },
        {
            "dt": "20241106",
            "close_pric": "-132500",
            "pre_sig": "5",
            "pred_pre": "-600",
            "flu_rt": "-0.45",
            "trde_qty": "43",
            "orgn_dt_acc": "158",
            "orgn_daly_nettrde_qty": "0",
            "for_dt_acc": "28315",
            "for_daly_nettrde_qty": "11243",
            "limit_exh_rt": "+26.14"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 체결강도추이시간별요청 (ka10046)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 6 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cntr_str_tm | 체결강도시간별 | LIST | N | | |
| - cntr_tm | 체결시간 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - pred_pre_sig | 전일대비기호 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - acc_trde_prica | 누적거래대금 | String | N | 20 | |
| - acc_trde_qty | 누적거래량 | String | N | 20 | |
| - cntr_str | 체결강도 | String | N | 20 | |
| - cntr_str_5min | 체결강도5분 | String | N | 20 | |
| - cntr_str_20min | 체결강도20분 | String | N | 20 | |
| - cntr_str_60min | 체결강도60분 | String | N | 20 | |
| - stex_tp | 거래소구분 | String | N | 20 | |
---

### 체결강도추이일별요청 (ka10047)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 6 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cntr_str_daly | 체결강도일별 | LIST | N | | |
| - dt | 일자 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - pred_pre_sig | 전일대비기호 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - acc_trde_prica | 누적거래대금 | String | N | 20 | |
| - acc_trde_qty | 누적거래량 | String | N | 20 | |
| - cntr_str | 체결강도 | String | N | 20 | |
| - cntr_str_5min | 체결강도5일 | String | N | 20 | |
| - cntr_str_20min | 체결강도20일 | String | N | 20 | |
| - cntr_str_60min | 체결강도60일 | String | N | 20 | |

#### 요청 예시
```json
{
    "stk_cd": "005930"
}
```

#### 응답 예시
```json
{
    "cntr_str_daly": [
        {
            "dt": "20241128",
            "cur_prc": "+219000",
            "pred_pre": "+14000",
            "pred_pre_sig": "2",
            "flu_rt": "+6.83",
            "trde_qty": "",
            "acc_trde_prica": "2",
            "acc_trde_qty": "8",
            "cntr_str": "0.00",
            "cntr_str_5min": "201.54",
            "cntr_str_20min": "139.37",
            "cntr_str_60min": "172.06"
        },
        {
            "dt": "20241127",
            "cur_prc": "+205000",
            "pred_pre": "+40300",
            "pred_pre_sig": "2",
            "flu_rt": "+24.47",
            "trde_qty": "",
            "acc_trde_prica": "9",
            "acc_trde_qty": "58",
            "cntr_str": "0.00",
            "cntr_str_5min": "209.54",
            "cntr_str_20min": "139.37",
            "cntr_str_60min": "180.40"
        },
        {
            "dt": "20241126",
            "cur_prc": "+164700",
            "pred_pre": "+38000",
            "pred_pre_sig": "1",
            "flu_rt": "+29.99",
            "trde_qty": "",
            "acc_trde_prica": "2",
            "acc_trde_qty": "15",
            "cntr_str": "7.69",
            "cntr_str_5min": "309.54",
            "cntr_str_20min": "164.37",
            "cntr_str_60min": "188.73"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 장중투자자별매매요청 (ka10063)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| mrkt_tp | 시장구분 | String | Y | 3 | 000:전체, 001:코스피, 101:코스닥 |
| amt_qty_tp | 금액수량구분 | String | Y | 1 | 1:금액, 2:수량 |
| invsr | 투자자별 | String | Y | 1 | 6:외국인, 7:기관계, 1:투신, 0:보험, 2:은행, 3:연기금, 4:국가, 5:기타법인 |
| frgn_all | 외국계전체 | String | Y | 1 | 1:체크, 0:미체크 |
| smtm_netprps_tp | 동시순매수구분 | String | Y | 1 | 1:체크, 0:미체크 |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| opmr_invsr_trde | 장중투자자별매매 | LIST | N | | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pre_sig | 대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - acc_trde_qty | 누적거래량 | String | N | 20 | |
| - netprps_qty | 순매수수량 | String | N | 20 | |
| - prev_pot_netprps_qty | 이전시점순매수수량 | String | N | 20 | |
| - netprps_irds | 순매수증감 | String | N | 20 | |
| - buy_qty | 매수수량 | String | N | 20 | |
| - buy_qty_irds | 매수수량증감 | String | N | 20 | |
| - sell_qty | 매도수량 | String | N | 20 | |
| - sell_qty_irds | 매도수량증감 | String | N | 20 | |
---

### 장마감후투자자별매매요청 (ka10066)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| mrkt_tp | 시장구분 | String | Y | 3 | 000:전체, 001:코스피, 101:코스닥 |
| amt_qty_tp | 금액수량구분 | String | Y | 1 | 1:금액, 2:수량 |
| trde_tp | 매매구분 | String | Y | 1 | 0:순매수, 1:매수, 2:매도 |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| opaf_invsr_trde | 장중투자자별매매차트 | LIST | N | | |
| - stk_cd | 종목코드 | String | N | 20 | |
| - stk_nm | 종목명 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pre_sig | 대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - ind_invsr | 개인투자자 | String | N | 20 | |
| - frgnr_invsr | 외국인투자자 | String | N | 20 | |
| - orgn | 기관계 | String | N | 20 | |
| - fnnc_invt | 금융투자 | String | N | 20 | |
| - insrnc | 보험 | String | N | 20 | |
| - invtrt | 투신 | String | N | 20 | |
| - etc_fnnc | 기타금융 | String | N | 20 | |
| - bank | 은행 | String | N | 20 | |
| - penfnd_etc | 연기금등 | String | N | 20 | |
| - samo_fund | 사모펀드 | String | N | 20 | |
| - natn | 국가 | String | N | 20 | |
| - etc_corp | 기타법인 | String | N | 20 | |

#### 요청 예시
```json
{
    "mrkt_tp": "000",
    "amt_qty_tp": "1",
    "trde_tp": "0",
    "stex_tp": "3"
}
```

#### 응답 예시
```json
{
    "opaf_invsr_trde": [
        {
            "stk_cd": "005930",
            "stk_nm": "삼성전자",
            "cur_prc": "-7410",
            "pre_sig": "5",
            "pred_pre": "-50",
            "flu_rt": "-0.67",
            "trde_qty": "8",
            "ind_invsr": "0",
            "frgnr_invsr": "0",
            "orgn": "0",
            "fnnc_invt": "0",
            "insrnc": "0",
            "invtrt": "0",
            "etc_fnnc": "0",
            "bank": "0",
            "penfnd_etc": "0",
            "samo_fund": "0",
            "natn": "0",
            "etc_corp": "0"
        },
        {
            "stk_cd": "005930",
            "stk_nm": "삼성전자",
            "cur_prc": "542",
            "pre_sig": "3",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "trde_qty": "0",
            "ind_invsr": "0",
            "frgnr_invsr": "0",
            "orgn": "0",
            "fnnc_invt": "0",
            "insrnc": "0",
            "invtrt": "0",
            "etc_fnnc": "0",
            "bank": "0",
            "penfnd_etc": "0",
            "samo_fund": "0",
            "natn": "0",
            "etc_corp": "0"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 증권사별종목매매동향요청 (ka10078)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| mmcm_cd | 회원사코드 | String | Y | 3 | 회원사 코드는 ka10102 조회 |
| stk_cd | 종목코드 | String | Y | 20 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| strt_dt | 시작일자 | String | Y | 8 | YYYYMMDD |
| end_dt | 종료일자 | String | Y | 8 | YYYYMMDD |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| sec_stk_trde_trend | 증권사별종목매매동향 | LIST | N | | |
| - dt | 일자 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pre_sig | 대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - acc_trde_qty | 누적거래량 | String | N | 20 | |
| - netprps_qty | 순매수수량 | String | N | 20 | |
| - buy_qty | 매수수량 | String | N | 20 | |
| - sell_qty | 매도수량 | String | N | 20 | |

#### 요청 예시
```json
{
    "mmcm_cd": "001",
    "stk_cd": "005930",
    "strt_dt": "20241106",
    "end_dt": "20241107"
}
```

#### 응답 예시
```json
{
    "sec_stk_trde_trend": [
        {
            "dt": "20241107",
            "cur_prc": "10050",
            "pre_sig": "0",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "acc_trde_qty": "0",
            "netprps_qty": "0",
            "buy_qty": "0",
            "sell_qty": "0"
        },
        {
            "dt": "20241106",
            "cur_prc": "10240",
            "pre_sig": "0",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "acc_trde_qty": "0",
            "netprps_qty": "-1016",
            "buy_qty": "951",
            "sell_qty": "1967"
        },
        {
            "dt": "20241105",
            "cur_prc": "10040",
            "pre_sig": "0",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "acc_trde_qty": "0",
            "netprps_qty": "2016",
            "buy_qty": "5002",
            "sell_qty": "2986"
        },
        {
            "dt": "20241101",
            "cur_prc": "-5880",
            "pre_sig": "4",
            "pred_pre": "-2520",
            "flu_rt": "-30.00",
            "acc_trde_qty": "16139969",
            "netprps_qty": "-532",
            "buy_qty": "2454",
            "sell_qty": "2986"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 일별주가요청 (ka10086)

> **주의사항**: 외국인순매수 데이터는 거래소로부터 금액데이터가 제공되지 않고 수량으로만 조회됩니다.

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 20 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| qry_dt | 조회일자 | String | Y | 8 | YYYYMMDD |
| indc_tp | 표시구분 | String | Y | 1 | 0:수량, 1:금액(백만원) |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| daly_stkpc | 일별주가 | LIST | N | | |
| - date | 날짜 | String | N | 20 | |
| - open_pric | 시가 | String | N | 20 | |
| - high_pric | 고가 | String | N | 20 | |
| - low_pric | 저가 | String | N | 20 | |
| - close_pric | 종가 | String | N | 20 | |
| - pred_rt | 전일비 | String | N | 20 | |
| - flu_rt | 등락률 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - amt_mn | 금액(백만) | String | N | 20 | |
| - crd_rt | 신용비 | String | N | 20 | |
| - ind | 개인 | String | N | 20 | |
| - orgn | 기관 | String | N | 20 | |
| - for_qty | 외인수량 | String | N | 20 | |
| - frgn | 외국계 | String | N | 20 | |
| - prm | 프로그램 | String | N | 20 | |
| - for_rt | 외인비 | String | N | 20 | |
| - for_poss | 외인보유 | String | N | 20 | |
| - for_wght | 외인비중 | String | N | 20 | |
| - for_netprps | 외인순매수 | String | N | 20 | |
| - orgn_netprps | 기관순매수 | String | N | 20 | |
| - ind_netprps | 개인순매수 | String | N | 20 | |
| - crd_remn_rt | 신용잔고율 | String | N | 20 | |

#### 요청 예시
```json
{
    "stk_cd": "005930",
    "qry_dt": "20241125",
    "indc_tp": "0"
}
```

#### 응답 예시
```json
{
    "daly_stkpc": [
        {
            "date": "20241125",
            "open_pric": "+78800",
            "high_pric": "+101100",
            "low_pric": "-54500",
            "close_pric": "-55000",
            "pred_rt": "-22800",
            "flu_rt": "-29.31",
            "trde_qty": "20278",
            "amt_mn": "1179",
            "crd_rt": "0.00",
            "ind": "--714",
            "orgn": "+693",
            "for_qty": "--266783",
            "frgn": "0",
            "prm": "0",
            "for_rt": "+51.56",
            "for_poss": "+51.56",
            "for_wght": "+51.56",
            "for_netprps": "--266783",
            "orgn_netprps": "+693",
            "ind_netprps": "--714",
            "crd_remn_rt": "0.00"
        },
        {
            "date": "20241122",
            "open_pric": "-54500",
            "high_pric": "77800",
            "low_pric": "-54500",
            "close_pric": "77800",
            "pred_rt": "0",
            "flu_rt": "0.00",
            "trde_qty": "209653",
            "amt_mn": "11447",
            "crd_rt": "0.00",
            "ind": "--196415",
            "orgn": "+196104",
            "for_qty": "--2965929",
            "frgn": "0",
            "prm": "--6",
            "for_rt": "+51.56",
            "for_poss": "+51.56",
            "for_wght": "+51.56",
            "for_netprps": "--2965929",
            "orgn_netprps": "+196104",
            "ind_netprps": "--196415",
            "crd_remn_rt": "0.00"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 시간외단일가요청 (ka10087)

> **주의사항**: 호가잔량기준시간은 시간외거래에 대한 시간이 아닌 정규장시간 값입니다.

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_cd | 종목코드 | String | Y | 6 | |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| bid_req_base_tm | 호가잔량기준시간 | String | N | | |
| ovt_sigpric_sel_bid_jub_pre_5 | 시간외단일가_매도호가직전대비5 | String | N | | |
| ovt_sigpric_sel_bid_jub_pre_4 | 시간외단일가_매도호가직전대비4 | String | N | | |
| ovt_sigpric_sel_bid_jub_pre_3 | 시간외단일가_매도호가직전대비3 | String | N | | |
| ovt_sigpric_sel_bid_jub_pre_2 | 시간외단일가_매도호가직전대비2 | String | N | | |
| ovt_sigpric_sel_bid_jub_pre_1 | 시간외단일가_매도호가직전대비1 | String | N | | |
| ovt_sigpric_sel_bid_qty_5 | 시간외단일가_매도호가수량5 | String | N | | |
| ovt_sigpric_sel_bid_qty_4 | 시간외단일가_매도호가수량4 | String | N | | |
| ovt_sigpric_sel_bid_qty_3 | 시간외단일가_매도호가수량3 | String | N | | |
| ovt_sigpric_sel_bid_qty_2 | 시간외단일가_매도호가수량2 | String | N | | |
| ovt_sigpric_sel_bid_qty_1 | 시간외단일가_매도호가수량1 | String | N | | |
| ovt_sigpric_sel_bid_5 | 시간외단일가_매도호가5 | String | N | | |
| ovt_sigpric_sel_bid_4 | 시간외단일가_매도호가4 | String | N | | |
| ovt_sigpric_sel_bid_3 | 시간외단일가_매도호가3 | String | N | | |
| ovt_sigpric_sel_bid_2 | 시간외단일가_매도호가2 | String | N | | |
| ovt_sigpric_sel_bid_1 | 시간외단일가_매도호가1 | String | N | | |
| ovt_sigpric_buy_bid_1 | 시간외단일가_매수호가1 | String | N | | |
| ovt_sigpric_buy_bid_2 | 시간외단일가_매수호가2 | String | N | | |
| ovt_sigpric_buy_bid_3 | 시간외단일가_매수호가3 | String | N | | |
| ovt_sigpric_buy_bid_4 | 시간외단일가_매수호가4 | String | N | | |
| ovt_sigpric_buy_bid_5 | 시간외단일가_매수호가5 | String | N | | |
| ovt_sigpric_buy_bid_qty_1 | 시간외단일가_매수호가수량1 | String | N | | |
| ovt_sigpric_buy_bid_qty_2 | 시간외단일가_매수호가수량2 | String | N | | |
| ovt_sigpric_buy_bid_qty_3 | 시간외단일가_매수호가수량3 | String | N | | |
| ovt_sigpric_buy_bid_qty_4 | 시간외단일가_매수호가수량4 | String | N | | |
| ovt_sigpric_buy_bid_qty_5 | 시간외단일가_매수호가수량5 | String | N | | |
| ovt_sigpric_buy_bid_jub_pre_1 | 시간외단일가_매수호가직전대비1 | String | N | | |
| ovt_sigpric_buy_bid_jub_pre_2 | 시간외단일가_매수호가직전대비2 | String | N | | |
| ovt_sigpric_buy_bid_jub_pre_3 | 시간외단일가_매수호가직전대비3 | String | N | | |
| ovt_sigpric_buy_bid_jub_pre_4 | 시간외단일가_매수호가직전대비4 | String | N | | |
| ovt_sigpric_buy_bid_jub_pre_5 | 시간외단일가_매수호가직전대비5 | String | N | | |
| ovt_sigpric_sel_bid_tot_req | 시간외단일가_매도호가총잔량 | String | N | | |
| ovt_sigpric_buy_bid_tot_req | 시간외단일가_매수호가총잔량 | String | N | | |
| sel_bid_tot_req_jub_pre | 매도호가총잔량직전대비 | String | N | | |
| sel_bid_tot_req | 매도호가총잔량 | String | N | | |
| buy_bid_tot_req | 매수호가총잔량 | String | N | | |
| buy_bid_tot_req_jub_pre | 매수호가총잔량직전대비 | String | N | | |
| ovt_sel_bid_tot_req_jub_pre | 시간외매도호가총잔량직전대비 | String | N | | |
| ovt_sel_bid_tot_req | 시간외매도호가총잔량 | String | N | | |
| ovt_buy_bid_tot_req | 시간외매수호가총잔량 | String | N | | |
| ovt_buy_bid_tot_req_jub_pre | 시간외매수호가총잔량직전대비 | String | N | | |
| ovt_sigpric_cur_prc | 시간외단일가_현재가 | String | N | | |
| ovt_sigpric_pred_pre_sig | 시간외단일가_전일대비기호 | String | N | | |
| ovt_sigpric_pred_pre | 시간외단일가_전일대비 | String | N | | |
| ovt_sigpric_flu_rt | 시간외단일가_등락률 | String | N | | |
| ovt_sigpric_acc_trde_qty | 시간외단일가_누적거래량 | String | N | | |

#### 요청 예시
```json
{
    "stk_cd": "005930"
}
```

#### 응답 예시
```json
{
    "bid_req_base_tm": "164000",
    "ovt_sigpric_sel_bid_jub_pre_5": "0",
    "ovt_sigpric_sel_bid_jub_pre_4": "0",
    "ovt_sigpric_sel_bid_jub_pre_3": "0",
    "ovt_sigpric_sel_bid_jub_pre_2": "0",
    "ovt_sigpric_sel_bid_jub_pre_1": "0",
    "ovt_sigpric_sel_bid_qty_5": "0",
    "ovt_sigpric_sel_bid_qty_4": "0",
    "ovt_sigpric_sel_bid_qty_3": "0",
    "ovt_sigpric_sel_bid_qty_2": "0",
    "ovt_sigpric_sel_bid_qty_1": "0",
    "ovt_sigpric_sel_bid_5": "-0",
    "ovt_sigpric_sel_bid_4": "-0",
    "ovt_sigpric_sel_bid_3": "-0",
    "ovt_sigpric_sel_bid_2": "-0",
    "ovt_sigpric_sel_bid_1": "-0",
    "ovt_sigpric_buy_bid_1": "-0",
    "ovt_sigpric_buy_bid_2": "-0",
    "ovt_sigpric_buy_bid_3": "-0",
    "ovt_sigpric_buy_bid_4": "-0",
    "ovt_sigpric_buy_bid_5": "-0",
    "ovt_sigpric_buy_bid_qty_1": "0",
    "ovt_sigpric_buy_bid_qty_2": "0",
    "ovt_sigpric_buy_bid_qty_3": "0",
    "ovt_sigpric_buy_bid_qty_4": "0",
    "ovt_sigpric_buy_bid_qty_5": "0",
    "ovt_sigpric_buy_bid_jub_pre_1": "0",
    "ovt_sigpric_buy_bid_jub_pre_2": "0",
    "ovt_sigpric_buy_bid_jub_pre_3": "0",
    "ovt_sigpric_buy_bid_jub_pre_4": "0",
    "ovt_sigpric_buy_bid_jub_pre_5": "0",
    "ovt_sigpric_sel_bid_tot_req": "0",
    "ovt_sigpric_buy_bid_tot_req": "0",
    "sel_bid_tot_req_jub_pre": "0",
    "sel_bid_tot_req": "24028",
    "buy_bid_tot_req": "26579",
    "buy_bid_tot_req_jub_pre": "0",
    "ovt_sel_bid_tot_req_jub_pre": "0",
    "ovt_sel_bid_tot_req": "0",
    "ovt_buy_bid_tot_req": "11",
    "ovt_buy_bid_tot_req_jub_pre": "0",
    "ovt_sigpric_cur_prc": "156600",
    "ovt_sigpric_pred_pre_sig": "0",
    "ovt_sigpric_pred_pre": "0",
    "ovt_sigpric_flu_rt": "0.00",
    "ovt_sigpric_acc_trde_qty": "0",
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 프로그램매매추이요청 시간대별 (ka90005)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| date | 날짜 | String | Y | 8 | YYYYMMDD |
| amt_qty_tp | 금액수량구분 | String | Y | 1 | 1:금액(백만원), 2:수량(천주) |
| mrkt_tp | 시장구분 | String | Y | 10 | 코스피- 거래소구분값 1일경우:P00101, 2일경우:P001_NX01, 3일경우:P001_AL01<br/>코스닥- 거래소구분값 1일경우:P10102, 2일경우:P101_NX02, 3일경우:P001_AL02 |
| min_tic_tp | 분틱구분 | String | Y | 1 | 0:틱, 1:분 |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| prm_trde_trnsn | 프로그램매매추이 | LIST | N | | |
| - cntr_tm | 체결시간 | String | N | 20 | |
| - dfrt_trde_sel | 차익거래매도 | String | N | 20 | |
| - dfrt_trde_buy | 차익거래매수 | String | N | 20 | |
| - dfrt_trde_netprps | 차익거래순매수 | String | N | 20 | |
| - ndiffpro_trde_sel | 비차익거래매도 | String | N | 20 | |
| - ndiffpro_trde_buy | 비차익거래매수 | String | N | 20 | |
| - ndiffpro_trde_netprps | 비차익거래순매수 | String | N | 20 | |
| - dfrt_trde_sell_qty | 차익거래매도수량 | String | N | 20 | |
| - dfrt_trde_buy_qty | 차익거래매수수량 | String | N | 20 | |
| - dfrt_trde_netprps_qty | 차익거래순매수수량 | String | N | 20 | |
| - ndiffpro_trde_sell_qty | 비차익거래매도수량 | String | N | 20 | |
| - ndiffpro_trde_buy_qty | 비차익거래매수수량 | String | N | 20 | |
| - ndiffpro_trde_netprps_qty | 비차익거래순매수수량 | String | N | 20 | |
| - all_sel | 전체매도 | String | N | 20 | |
| - all_buy | 전체매수 | String | N | 20 | |
| - all_netprps | 전체순매수 | String | N | 20 | |
| - kospi200 | KOSPI200 | String | N | 20 | |
| - basis | BASIS | String | N | 20 | |

#### 요청 예시
```json
{
    "date": "20241101",
    "amt_qty_tp": "1",
    "mrkt_tp": "P00101",
    "min_tic_tp": "1",
    "stex_tp": "1"
}
```

#### 응답 예시
```json
{
    "prm_trde_trnsn": [
        {
            "cntr_tm": "170500",
            "dfrt_trde_sel": "0",
            "dfrt_trde_buy": "0",
            "dfrt_trde_netprps": "0",
            "ndiffpro_trde_sel": "1",
            "ndiffpro_trde_buy": "17",
            "ndiffpro_trde_netprps": "+17",
            "dfrt_trde_sell_qty": "0",
            "dfrt_trde_buy_qty": "0",
            "dfrt_trde_netprps_qty": "0",
            "ndiffpro_trde_sell_qty": "0",
            "ndiffpro_trde_buy_qty": "0",
            "ndiffpro_trde_netprps_qty": "+0",
            "all_sel": "1",
            "all_buy": "17",
            "all_netprps": "+17",
            "kospi200": "+47839",
            "basis": "-146.59"
        },
        {
            "cntr_tm": "170400",
            "dfrt_trde_sel": "0",
            "dfrt_trde_buy": "0",
            "dfrt_trde_netprps": "0",
            "ndiffpro_trde_sel": "1",
            "ndiffpro_trde_buy": "17",
            "ndiffpro_trde_netprps": "+17",
            "dfrt_trde_sell_qty": "0",
            "dfrt_trde_buy_qty": "0",
            "dfrt_trde_netprps_qty": "0",
            "ndiffpro_trde_sell_qty": "0",
            "ndiffpro_trde_buy_qty": "0",
            "ndiffpro_trde_netprps_qty": "+0",
            "all_sel": "1",
            "all_buy": "17",
            "all_netprps": "+17",
            "kospi200": "+47839",
            "basis": "-146.59"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 프로그램매매차익잔고추이요청 (ka90006)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| date | 날짜 | String | Y | 8 | YYYYMMDD |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| prm_trde_dfrt_remn_trnsn | 프로그램매매차익잔고추이 | LIST | N | | |
| - dt | 일자 | String | N | 20 | |
| - buy_dfrt_trde_qty | 매수차익거래수량 | String | N | 20 | |
| - buy_dfrt_trde_amt | 매수차익거래금액 | String | N | 20 | |
| - buy_dfrt_trde_irds_amt | 매수차익거래증감액 | String | N | 20 | |
| - sel_dfrt_trde_qty | 매도차익거래수량 | String | N | 20 | |
| - sel_dfrt_trde_amt | 매도차익거래금액 | String | N | 20 | |
| - sel_dfrt_trde_irds_amt | 매도차익거래증감액 | String | N | 20 | |

#### 요청 예시
```json
{
    "date": "20241125",
    "stex_tp": "1"
}
```

#### 응답 예시
```json
{
    "prm_trde_dfrt_remn_trnsn": [
        {
            "dt": "20241125",
            "buy_dfrt_trde_qty": "0",
            "buy_dfrt_trde_amt": "0",
            "buy_dfrt_trde_irds_amt": "0",
            "sel_dfrt_trde_qty": "0",
            "sel_dfrt_trde_amt": "0",
            "sel_dfrt_trde_irds_amt": "0"
        },
        {
            "dt": "20241122",
            "buy_dfrt_trde_qty": "0",
            "buy_dfrt_trde_amt": "0",
            "buy_dfrt_trde_irds_amt": "-25",
            "sel_dfrt_trde_qty": "0",
            "sel_dfrt_trde_amt": "0",
            "sel_dfrt_trde_irds_amt": "0"
        },
        {
            "dt": "20241121",
            "buy_dfrt_trde_qty": "0",
            "buy_dfrt_trde_amt": "25",
            "buy_dfrt_trde_irds_amt": "25",
            "sel_dfrt_trde_qty": "0",
            "sel_dfrt_trde_amt": "0",
            "sel_dfrt_trde_irds_amt": "0"
        },
        {
            "dt": "20241120",
            "buy_dfrt_trde_qty": "0",
            "buy_dfrt_trde_amt": "0",
            "buy_dfrt_trde_irds_amt": "-48",
            "sel_dfrt_trde_qty": "0",
            "sel_dfrt_trde_amt": "0",
            "sel_dfrt_trde_irds_amt": "0"
        },
        {
            "dt": "20241119",
            "buy_dfrt_trde_qty": "0",
            "buy_dfrt_trde_amt": "48",
            "buy_dfrt_trde_irds_amt": "43",
            "sel_dfrt_trde_qty": "0",
            "sel_dfrt_trde_amt": "0",
            "sel_dfrt_trde_irds_amt": "0"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 프로그램매매누적추이요청 (ka90007)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| date | 날짜 | String | Y | 8 | YYYYMMDD (종료일기준 1년간 데이터만 조회가능) |
| amt_qty_tp | 금액수량구분 | String | Y | 1 | 1:금액, 2:수량 |
| mrkt_tp | 시장구분 | String | Y | 5 | 0:코스피, 1:코스닥 |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| prm_trde_acc_trnsn | 프로그램매매누적추이 | LIST | N | | |
| - dt | 일자 | String | N | 20 | |
| - kospi200 | KOSPI200 | String | N | 20 | |
| - basis | BASIS | String | N | 20 | |
| - dfrt_trde_tdy | 차익거래당일 | String | N | 20 | |
| - dfrt_trde_acc | 차익거래누적 | String | N | 20 | |
| - ndiffpro_trde_tdy | 비차익거래당일 | String | N | 20 | |
| - ndiffpro_trde_acc | 비차익거래누적 | String | N | 20 | |
| - all_tdy | 전체당일 | String | N | 20 | |
| - all_acc | 전체누적 | String | N | 20 | |
---

### 종목시간별프로그램매매추이요청 (ka90008)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| amt_qty_tp | 금액수량구분 | String | Y | 1 | 1:금액, 2:수량 |
| stk_cd | 종목코드 | String | Y | 6 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| date | 날짜 | String | Y | 8 | YYYYMMDD |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_tm_prm_trde_trnsn | 종목시간별프로그램매매추이 | LIST | N | | |
| - tm | 시간 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pre_sig | 대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - prm_sell_amt | 프로그램매도금액 | String | N | 20 | |
| - prm_buy_amt | 프로그램매수금액 | String | N | 20 | |
| - prm_netprps_amt | 프로그램순매수금액 | String | N | 20 | |
| - prm_netprps_amt_irds | 프로그램순매수금액증감 | String | N | 20 | |
| - prm_sell_qty | 프로그램매도수량 | String | N | 20 | |
| - prm_buy_qty | 프로그램매수수량 | String | N | 20 | |
| - prm_netprps_qty | 프로그램순매수수량 | String | N | 20 | |
| - prm_netprps_qty_irds | 프로그램순매수수량증감 | String | N | 20 | |
| - base_pric_tm | 기준가시간 | String | N | 20 | |
| - dbrt_trde_rpy_sum | 대차거래상환주수합 | String | N | 20 | |
| - remn_rcvord_sum | 잔고수주합 | String | N | 20 | |
| - stex_tp | 거래소구분 | String | N | 20 | KRX, NXT, 통합 |

#### 요청 예시
```json
{
    "amt_qty_tp": "1",
    "stk_cd": "005930",
    "date": "20241125"
}
```

#### 응답 예시
```json
{
    "stk_tm_prm_trde_trnsn": [
        {
            "tm": "153029",
            "cur_prc": "+245500",
            "pre_sig": "2",
            "pred_pre": "+40000",
            "flu_rt": "+19.46",
            "trde_qty": "104006",
            "prm_sell_amt": "14245",
            "prm_buy_amt": "10773",
            "prm_netprps_amt": "--3472",
            "prm_netprps_amt_irds": "+771",
            "prm_sell_qty": "58173",
            "prm_buy_qty": "43933",
            "prm_netprps_qty": "--14240",
            "prm_netprps_qty_irds": "+3142",
            "base_pric_tm": "",
            "dbrt_trde_rpy_sum": "",
            "remn_rcvord_sum": "",
            "stex_tp": "KRX"
        },
        {
            "tm": "153001",
            "cur_prc": "+245500",
            "pre_sig": "2",
            "pred_pre": "+40000",
            "flu_rt": "+19.46",
            "trde_qty": "94024",
            "prm_sell_amt": "12596",
            "prm_buy_amt": "8353",
            "prm_netprps_amt": "--4243",
            "prm_netprps_amt_irds": "0",
            "prm_sell_qty": "51455",
            "prm_buy_qty": "34073",
            "prm_netprps_qty": "--17382",
            "prm_netprps_qty_irds": "0",
            "base_pric_tm": "",
            "dbrt_trde_rpy_sum": "",
            "remn_rcvord_sum": "",
            "stex_tp": "KRX"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 프로그램매매추이요청 일자별 (ka90010)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| date | 날짜 | String | Y | 8 | YYYYMMDD |
| amt_qty_tp | 금액수량구분 | String | Y | 1 | 1:금액(백만원), 2:수량(천주) |
| mrkt_tp | 시장구분 | String | Y | 10 | 코스피- 거래소구분값 1일경우:P00101, 2일경우:P001_NX01, 3일경우:P001_AL01<br/>코스닥- 거래소구분값 1일경우:P10102, 2일경우:P101_NX02, 3일경우:P001_AL02 |
| min_tic_tp | 분틱구분 | String | Y | 1 | 0:틱, 1:분 |
| stex_tp | 거래소구분 | String | Y | 1 | 1:KRX, 2:NXT, 3:통합 |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| prm_trde_trnsn | 프로그램매매추이 | LIST | N | | |
| - cntr_tm | 체결시간 | String | N | 20 | |
| - dfrt_trde_sel | 차익거래매도 | String | N | 20 | |
| - dfrt_trde_buy | 차익거래매수 | String | N | 20 | |
| - dfrt_trde_netprps | 차익거래순매수 | String | N | 20 | |
| - ndiffpro_trde_sel | 비차익거래매도 | String | N | 20 | |
| - ndiffpro_trde_buy | 비차익거래매수 | String | N | 20 | |
| - ndiffpro_trde_netprps | 비차익거래순매수 | String | N | 20 | |
| - dfrt_trde_sell_qty | 차익거래매도수량 | String | N | 20 | |
| - dfrt_trde_buy_qty | 차익거래매수수량 | String | N | 20 | |
| - dfrt_trde_netprps_qty | 차익거래순매수수량 | String | N | 20 | |
| - ndiffpro_trde_sell_qty | 비차익거래매도수량 | String | N | 20 | |
| - ndiffpro_trde_buy_qty | 비차익거래매수수량 | String | N | 20 | |
| - ndiffpro_trde_netprps_qty | 비차익거래순매수수량 | String | N | 20 | |
| - all_sel | 전체매도 | String | N | 20 | |
| - all_buy | 전체매수 | String | N | 20 | |
| - all_netprps | 전체순매수 | String | N | 20 | |
| - kospi200 | KOSPI200 | String | N | 20 | |
| - basis | BASIS | String | N | 20 | |

#### 요청 예시
```json
{
    "date": "20241125",
    "amt_qty_tp": "1",
    "mrkt_tp": "P00101",
    "min_tic_tp": "0",
    "stex_tp": "1"
}
```

#### 응답 예시
```json
{
    "prm_trde_trnsn": [
        {
            "cntr_tm": "20241125000000",
            "dfrt_trde_sel": "0",
            "dfrt_trde_buy": "0",
            "dfrt_trde_netprps": "0",
            "ndiffpro_trde_sel": "0",
            "ndiffpro_trde_buy": "0",
            "ndiffpro_trde_netprps": "0",
            "dfrt_trde_sell_qty": "0",
            "dfrt_trde_buy_qty": "0",
            "dfrt_trde_netprps_qty": "0",
            "ndiffpro_trde_sell_qty": "0",
            "ndiffpro_trde_buy_qty": "0",
            "ndiffpro_trde_netprps_qty": "0",
            "all_sel": "0",
            "all_buy": "0",
            "all_netprps": "0",
            "kospi200": "0.00",
            "basis": ""
        },
        {
            "cntr_tm": "20241122000000",
            "dfrt_trde_sel": "0",
            "dfrt_trde_buy": "0",
            "dfrt_trde_netprps": "-0",
            "ndiffpro_trde_sel": "96",
            "ndiffpro_trde_buy": "608",
            "ndiffpro_trde_netprps": "+512",
            "dfrt_trde_sell_qty": "0",
            "dfrt_trde_buy_qty": "0",
            "dfrt_trde_netprps_qty": "-0",
            "ndiffpro_trde_sell_qty": "1",
            "ndiffpro_trde_buy_qty": "7",
            "ndiffpro_trde_netprps_qty": "+6",
            "all_sel": "96",
            "all_buy": "608",
            "all_netprps": "512",
            "kospi200": "+341.13",
            "basis": "-8.48"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
---

### 종목일별프로그램매매추이요청 (ka90013)

#### 기본 정보
- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/mrkcond
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 (Request)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| authorization | 접근토큰 | String | Y | 1000 | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx... |
| cont-yn | 연속조회여부 | String | N | 1 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅 |
| next-key | 연속조회키 | String | N | 50 | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| amt_qty_tp | 금액수량구분 | String | N | 1 | 1:금액, 2:수량 |
| stk_cd | 종목코드 | String | Y | 20 | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| date | 날짜 | String | N | 8 | YYYYMMDD |

#### 응답 (Response)

##### Header
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| cont-yn | 연속조회여부 | String | N | 1 | 다음 데이터가 있을시 Y값 전달 |
| next-key | 연속조회키 | String | N | 50 | 다음 데이터가 있을시 다음 키값 전달 |
| api-id | TR명 | String | Y | 10 | |

##### Body
| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| stk_daly_prm_trde_trnsn | 종목일별프로그램매매추이 | LIST | N | | |
| - dt | 일자 | String | N | 20 | |
| - cur_prc | 현재가 | String | N | 20 | |
| - pre_sig | 대비기호 | String | N | 20 | |
| - pred_pre | 전일대비 | String | N | 20 | |
| - flu_rt | 등락율 | String | N | 20 | |
| - trde_qty | 거래량 | String | N | 20 | |
| - prm_sell_amt | 프로그램매도금액 | String | N | 20 | |
| - prm_buy_amt | 프로그램매수금액 | String | N | 20 | |
| - prm_netprps_amt | 프로그램순매수금액 | String | N | 20 | |
| - prm_netprps_amt_irds | 프로그램순매수금액증감 | String | N | 20 | |
| - prm_sell_qty | 프로그램매도수량 | String | N | 20 | |
| - prm_buy_qty | 프로그램매수수량 | String | N | 20 | |
| - prm_netprps_qty | 프로그램순매수수량 | String | N | 20 | |
| - prm_netprps_qty_irds | 프로그램순매수수량증감 | String | N | 20 | |
| - base_pric_tm | 기준가시간 | String | N | 20 | |
| - dbrt_trde_rpy_sum | 대차거래상환주수합 | String | N | 20 | |
| - remn_rcvord_sum | 잔고수주합 | String | N | 20 | |
| - stex_tp | 거래소구분 | String | N | 20 | KRX, NXT, 통합 |

#### 요청 예시
```json
{
    "amt_qty_tp": "",
    "stk_cd": "005930",
    "date": ""
}
```

#### 응답 예시
```json
{
    "stk_daly_prm_trde_trnsn": [
        {
            "dt": "20241125",
            "cur_prc": "+267000",
            "pre_sig": "2",
            "pred_pre": "+60000",
            "flu_rt": "+28.99",
            "trde_qty": "3",
            "prm_sell_amt": "0",
            "prm_buy_amt": "0",
            "prm_netprps_amt": "0",
            "prm_netprps_amt_irds": "0",
            "prm_sell_qty": "0",
            "prm_buy_qty": "0",
            "prm_netprps_qty": "0",
            "prm_netprps_qty_irds": "0",
            "base_pric_tm": "",
            "dbrt_trde_rpy_sum": "",
            "remn_rcvord_sum": "",
            "stex_tp": "통합"
        },
        {
            "dt": "20241122",
            "cur_prc": "0",
            "pre_sig": "0",
            "pred_pre": "0",
            "flu_rt": "0.00",
            "trde_qty": "0",
            "prm_sell_amt": "0",
            "prm_buy_amt": "0",
            "prm_netprps_amt": "0",
            "prm_netprps_amt_irds": "--6",
            "prm_sell_qty": "0",
            "prm_buy_qty": "0",
            "prm_netprps_qty": "0",
            "prm_netprps_qty_irds": "--19",
            "base_pric_tm": "",
            "dbrt_trde_rpy_sum": "",
            "remn_rcvord_sum": "",
            "stex_tp": "KRX"
        }
    ],
    "return_code": 0,
    "return_msg": "정상적으로 처리되었습니다"
}
```
