# 홈페이지 내용 정리

## 1. 국내주식 WEBSOCKET 실시간시세

### 기본 정보

**※ 00 (주문체결)**
실시간 항목 00(주문체결)은 종목코드(item) 등록과 상관 없이 ACCESS TOKEN을 발급한 계좌에 주문 접수, 체결, 정정, 취소 등 매매가 발생할 경우 데이터가 수신됩니다.

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### TR 목록

| TR명 | 코드 |
|------|------|
| 주문체결 | 00 |
| 잔고 | 04 |
| 주식기세 | 0A |
| 주식체결 | 0B |
| 주식우선호가 | 0C |
| 주식호가잔량 | 0D |
| 주식시간외호가 | 0E |
| 주식당일거래원 | 0F |
| ETF NAV | 0G |
| 주식예상체결 | 0H |
| 업종지수 | 0J |
| 업종등락 | 0U |
| 주식종목정보 | 0g |
| ELW 이론가 | 0m |
| 장시작시간 | 0s |
| ELW 지표 | 0u |
| 종목프로그램매매 | 0w |
| VI발동/해제 | 1h |

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 9201 | 계좌번호 | String | N | |
| 9203 | 주문번호 | String | N | |
| 9205 | 관리자사번 | String | N | |
| 9001 | 종목코드,업종코드 | String | N | |
| 912 | 주문업무분류 | String | N | |
| 913 | 주문상태 | String | N | |
| 302 | 종목명 | String | N | |
| 900 | 주문수량 | String | N | |
| 901 | 주문가격 | String | N | |
| 902 | 미체결수량 | String | N | |
| 903 | 체결누계금액 | String | N | |
| 904 | 원주문번호 | String | N | |
| 905 | 주문구분 | String | N | |
| 906 | 매매구분 | String | N | |
| 907 | 매도수구분 | String | N | |
| 908 | 주문/체결시간 | String | N | |
| 909 | 체결번호 | String | N | |
| 910 | 체결가 | String | N | |
| 911 | 체결량 | String | N | |
| 10 | 현재가 | String | N | |
| 27 | (최우선)매도호가 | String | N | |
| 28 | (최우선)매수호가 | String | N | |
| 914 | 단위체결가 | String | N | |
| 915 | 단위체결량 | String | N | |
| 938 | 당일매매수수료 | String | N | |
| 939 | 당일매매세금 | String | N | |
| 919 | 거부사유 | String | N | |
| 920 | 화면번호 | String | N | |
| 921 | 터미널번호 | String | N | |
| 922 | 신용구분 | String | N | 실시간 체결용 |
| 923 | 대출일 | String | N | 실시간 체결용 |
| 10010 | 시간외단일가_현재가 | String | N | |
| 2134 | 거래소구분 | String | N | 0:통합,1:KRX,2:NXT |
| 2135 | 거래소구분명 | String | N | 통합,KRX,NXT |
| 2136 | SOR여부 | String | N | Y,N |

### 요청 예시

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "" ],
		"type" : [ "00" ]
	}]
}
```

### 응답 예시

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data':[
		{
			'values': {
				'9201':'1111111111',
				'9203':'0000018',
				'9205':'',
				'9001':'005930',
				'912':'JJ',
				'913':'접수',
				'302':'삼성전자',
				'900':'1',
				'901':'0',
				'902':'1',
				'903':'0',
				'904':'0000000',
				'905':'+매수',
				'906':'시장가',
				'907':'2',
				'908':'094022',
				'909':'',
				'910':'',
				'911':'',
				'10':'+60700',
				'27':'+60700',
				'28':'-60000',
				'914':'',
				'915':'',
				'938':'0',
				'939':'0',
				'919':'0',
				'920':'',
				'921':'0701002',
				'922':'00',
				'923':'00000000',
				'10010':'',
				'2134':'1',
				'2135':'KRX',
				'2136':'Y'
			},
			'type':'00',
			'name':'주문체결',
			'item':'005930'
		}
	],
	'trnm': 'REAL'
}
```

---

## 2. 국내주식 WEBSOCKET 실시간시세 - 잔고(04)

### 기본 정보

**※ 04 (잔고)**
실시간 항목 04(잔고)는 종목코드(item) 등록과 상관 없이 ACCESS TOKEN을 발급한 계좌에 주문 체결이 발생할 경우 데이터가 수신됩니다.

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 104 | |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (잔고 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 9201 | 계좌번호 | String | N | |
| 9001 | 종목코드,업종코드 | String | N | |
| 917 | 신용구분 | String | N | |
| 916 | 대출일 | String | N | |
| 302 | 종목명 | String | N | |
| 10 | 현재가 | String | N | |
| 930 | 보유수량 | String | N | |
| 931 | 매입단가 | String | N | |
| 932 | 총매입가(당일누적) | String | N | |
| 933 | 주문가능수량 | String | N | |
| 945 | 당일순매수량 | String | N | |
| 946 | 매도/매수구분 | String | N | 계약,주 |
| 950 | 당일총매도손익 | String | N | |
| 951 | Extra Item | String | N | |
| 27 | (최우선)매도호가 | String | N | |
| 28 | (최우선)매수호가 | String | N | |
| 307 | 기준가 | String | N | |
| 8019 | 손익률(실현손익) | String | N | |
| 957 | 신용금액 | String | N | |
| 958 | 신용이자 | String | N | |
| 918 | 만기일 | String | N | |
| 990 | 당일실현손익(유가) | String | N | |
| 991 | 당일실현손익율(유가) | String | N | |
| 992 | 당일실현손익(신용) | String | N | |
| 993 | 당일실현손익율(신용) | String | N | |
| 959 | 담보대출수량 | String | N | |
| 924 | Extra Item | String | N | |

### 요청 예시 (잔고)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "" ],
		"type" : [ "04" ]
	}]
}
```

### 응답 예시 (잔고)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'9201': '1111111111',
				'9001': '005930',
				'917': '00',
				'916': '00000000',
				'302': '삼성전자',
				'10': '-60150',
				'930': '102',
				'931': '154116',
				'932': '15719834',
				'933': '102',
				'945': '4',
				'946': '2',
				'950': '0',
				'951': '0',
				'27': '-60200',
				'28': '-60100',
				'307': '60300',
				'8019': '0.00',
				'957': '0',
				'958': '0',
				'918': '00000000',
				'990': '0',
				'991': '0.00',
				'992': '0',
				'993': '0.00',
				'959': '0',
				'924': '0'
			},
			'type': '04',
			'name': '현물잔고',
			'item': '005930'
		}
	],
	'trnm': 'REAL'
}
```

---

## 3. 국내주식 WEBSOCKET 실시간시세 - 주식기세(0A)

### 기본 정보

**※ 0A (주식기세)**
특정 종목이 기세일때 발생하는 데이터로 시장에서 체결없이 현재가가 변경되는 대량매매나 거래소에서 종목 종가데이터 보정시 발생하는 실시간입니다.

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지(등록,해지시에만 값 전송,데이터 실시간 수신시 미전송) |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식기세 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 10 | 현재가 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 27 | (최우선)매도호가 | String | N | |
| 28 | (최우선)매수호가 | String | N | |
| 13 | 누적거래량 | String | N | |
| 14 | 누적거래대금 | String | N | |
| 16 | 시가 | String | N | |
| 17 | 고가 | String | N | |
| 18 | 저가 | String | N | |
| 25 | 전일대비기호 | String | N | |
| 26 | 전일거래량대비(계약,주) | String | N | |
| 29 | 거래대금증감 | String | N | |
| 30 | 전일거래량대비(비율) | String | N | |
| 31 | 거래회전율 | String | N | |
| 32 | 거래비용 | String | N | |
| 311 | 시가총액(억) | String | N | |
| 567 | 상한가발생시간 | String | N | |
| 568 | 하한가발생시간 | String | N | |

### 요청 예시 (주식기세)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0A" ]
	}]
}
```

### 응답 예시 (주식기세)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'10': '+86800',
				'11': '+19500',
				'12': '+28.97',
				'27': '+85200',
				'28': '+85100',
				'13': '367090',
				'14': '31642',
				'16': '+87400',
				'17': '+87400',
				'18': ' 67300',
				'25': '2',
				'26': '+131995',
				'29': '+15843118000',
				'30': '+156.15',
				'31': '0.01',
				'32': '157',
				'311': '5181771',
				'567': '154912',
				'568': '000000'
			},
			'type': '0A',
			'name': '주식기세',
			'item': '005930'
		}
	],
	'trnm': 'REAL'
}
```

---

## 4. 국내주식 WEBSOCKET 실시간시세 - 주식체결(0B)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0B,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식체결 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 10 | 현재가 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 27 | (최우선)매도호가 | String | N | |
| 28 | (최우선)매수호가 | String | N | |
| 15 | 거래량 | String | N | +는 매수체결,-는 매도체결 |
| 13 | 누적거래량 | String | N | |
| 14 | 누적거래대금 | String | N | |
| 16 | 시가 | String | N | |
| 17 | 고가 | String | N | |
| 18 | 저가 | String | N | |
| 25 | 전일대비기호 | String | N | |
| 26 | 전일거래량대비(계약,주) | String | N | |
| 29 | 거래대금증감 | String | N | |
| 30 | 전일거래량대비(비율) | String | N | |
| 31 | 거래회전율 | String | N | |
| 32 | 거래비용 | String | N | |
| 228 | 체결강도 | String | N | |
| 311 | 시가총액(억) | String | N | |
| 290 | 장구분 | String | N | 1: 장전 시간외, 2: 장중, 3: 장후 시간외 |
| 691 | K.O 접근도 | String | N | |
| 567 | 상한가발생시간 | String | N | |
| 568 | 하한가발생시간 | String | N | |
| 851 | 전일 동시간 거래량 비율 | String | N | |
| 1890 | 시가시간 | String | N | |
| 1891 | 고가시간 | String | N | |
| 1892 | 저가시간 | String | N | |
| 1030 | 매도체결량 | String | N | |
| 1031 | 매수체결량 | String | N | |
| 1032 | 매수비율 | String | N | |
| 1071 | 매도체결건수 | String | N | |
| 1072 | 매수체결건수 | String | N | |
| 1313 | 순간거래대금 | String | N | |
| 1315 | 매도체결량_단건 | String | N | |
| 1316 | 매수체결량_단건 | String | N | |
| 1314 | 순매수체결량 | String | N | |
| 1497 | CFD증거금 | String | N | |
| 1498 | 유지증거금 | String | N | |
| 620 | 당일거래평균가 | String | N | |
| 732 | CFD거래비용 | String | N | |
| 852 | 대주거래비용 | String | N | |
| 9081 | 거래소구분 | String | N | |

### 요청 예시 (주식체결)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0B" ]
	}]
}
```

### 응답 예시 (주식체결)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'trnm': 'REAL',
	'data': [
		{
			'type': '0B',
			'name': '주식체결',
			'item': '005930',
			'values': {
				'20': '165208',
				'10': '-20800',
				'11': '-50',
				'12': '-0.24',
				'27': '-20800',
				'28': '-20700',
				'15': '+82',
				'13': '30379732',
				'14': '632640',
				'16': '20850',
				'17': '+21150',
				'18': '-20450',
				'25': '5',
				'26': '-1057122',
				'29': '-22041267850',
				'30': '-96.64',
				'31': '36.67',
				'32': '44',
				'228': '98.92',
				'311': '17230',
				'290': '2',
				'691': '0',
				'567': '000000',
				'568': '000000',
				'851': '',
				'1890': '',
				'1891': '',
				'1892': '',
				'1030': '',
				'1031': '',
				'1032': '',
				'1071': '',
				'1072': '',
				'1313': '',
				'1315': '',
				'1316': '',
				'1314': '',
				'1497': '',
				'1498': '',
				'620': '',
				'732': '',
				'852': '',
				'9081': '1'
			}
		}
	]
}
```

---

## 5. 국내주식 WEBSOCKET 실시간시세 - 주식우선호가(0C)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식우선호가 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 27 | (최우선)매도호가 | String | N | |
| 28 | (최우선)매수호가 | String | N | |

### 요청 예시 (주식우선호가)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0C" ]
	}]
}
```

### 응답 예시 (주식우선호가)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'trnm': 'REAL',
	'data': [
		{
			'type': '0C',
			'name': '주식우선호가',
			'item': '005930',
			'values': {
				'27': '-20800',
				'28': '-20700'
			}
		}
	]
}
```

---

## 6. 국내주식 WEBSOCKET 실시간시세 - 주식호가잔량(0D)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식호가잔량 전용)

#### 기본 호가 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 21 | 호가시간 | String | N | |
| 41-50 | 매도호가1-10 | String | N | |
| 61-70 | 매도호가수량1-10 | String | N | |
| 81-90 | 매도호가직전대비1-10 | String | N | |
| 51-60 | 매수호가1-10 | String | N | |
| 71-80 | 매수호가수량1-10 | String | N | |
| 91-100 | 매수호가직전대비1-10 | String | N | |

#### 호가 총계 및 예상체결 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 121 | 매도호가총잔량 | String | N | |
| 122 | 매도호가총잔량직전대비 | String | N | |
| 125 | 매수호가총잔량 | String | N | |
| 126 | 매수호가총잔량직전대비 | String | N | |
| 23 | 예상체결가 | String | N | |
| 24 | 예상체결수량 | String | N | |
| 128 | 순매수잔량 | String | N | |
| 129 | 매수비율 | String | N | |
| 138 | 순매도잔량 | String | N | |
| 139 | 매도비율 | String | N | |
| 200 | 예상체결가전일종가대비 | String | N | |
| 201 | 예상체결가전일종가대비등락율 | String | N | |
| 238 | 예상체결가전일종가대비기호 | String | N | |

#### 예상체결 시간 전용 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 291 | 예상체결가 | String | N | 예상체결 시간동안에만 유효한 값 |
| 292 | 예상체결량 | String | N | |
| 293 | 예상체결가전일대비기호 | String | N | |
| 294 | 예상체결가전일대비 | String | N | |
| 295 | 예상체결가전일대비등락율 | String | N | |

#### LP 호가 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 621-630 | LP매도호가수량1-10 | String | N | |
| 631-640 | LP매수호가수량1-10 | String | N | |

#### 기타 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 13 | 누적거래량 | String | N | |
| 299 | 전일거래량대비예상체결율 | String | N | |
| 215 | 장운영구분 | String | N | |
| 216 | 투자자별ticker | String | N | |

#### KRX 거래소별 호가 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 6044-6053 | KRX 매도호가잔량1-10 | String | N | |
| 6054-6063 | KRX 매수호가잔량1-10 | String | N | |
| 6064 | KRX 매도호가총잔량 | String | N | |
| 6065 | KRX 매수호가총잔량 | String | N | |

#### NXT 거래소별 호가 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 6066-6075 | NXT 매도호가잔량1-10 | String | N | |
| 6076-6085 | NXT 매수호가잔량1-10 | String | N | |
| 6086 | NXT 매도호가총잔량 | String | N | |
| 6087 | NXT 매수호가총잔량 | String | N | |

#### 중간가 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 6100 | KRX 중간가 매도 총잔량 증감 | String | N | |
| 6101 | KRX 중간가 매도 총잔량 | String | N | |
| 6102 | KRX 중간가 | String | N | |
| 6103 | KRX 중간가 매수 총잔량 | String | N | |
| 6104 | KRX 중간가 매수 총잔량 증감 | String | N | |
| 6105 | NXT중간가 매도 총잔량 증감 | String | N | |
| 6106 | NXT중간가 매도 총잔량 | String | N | |
| 6107 | NXT중간가 | String | N | |
| 6108 | NXT중간가 매수 총잔량 | String | N | |
| 6109 | NXT중간가 매수 총잔량 증감 | String | N | |
| 6110 | KRX중간가대비 | String | N | 기준가대비 |
| 6111 | KRX중간가대비 기호 | String | N | 기준가대비 |
| 6112 | KRX중간가대비등락율 | String | N | 기준가대비 |
| 6113 | NXT중간가대비 | String | N | 기준가대비 |
| 6114 | NXT중간가대비 기호 | String | N | 기준가대비 |
| 6115 | NXT중간가대비등락율 | String | N | 기준가대비 |

### 요청 예시 (주식호가잔량)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0D" ]
	}]
}
```

### 응답 예시 (주식호가잔량)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답 (일부 필드만 표시):**
```json
{
	'trnm': 'REAL',
	'data': [
		{
			'type': '0D',
			'name': '주식호가잔량',
			'item': '005930',
			'values': {
				'21': '165207',
				'41': '-20800',
				'61': '82',
				'51': '-20700',
				'71': '23847',
				'42': '+20900',
				'62': '393',
				'52': '-20650',
				'72': '834748',
				'121': '12622527',
				'122': '-1036021',
				'125': '14453430',
				'126': '+1062126',
				'23': '20850',
				'24': '332941',
				'128': '+1830903',
				'129': '114.51',
				...
			}
		}
	]
}
```

---

## 7. 국내주식 WEBSOCKET 실시간시세 - 주식시간외호가(0E)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 거래소별 종목코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식시간외호가 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 21 | 호가시간 | String | N | |
| 131 | 시간외매도호가총잔량 | String | N | |
| 132 | 시간외매도호가총잔량직전대비 | String | N | |
| 135 | 시간외매수호가총잔량 | String | N | |
| 136 | 시간외매수호가총잔량직전대비 | String | N | |

### 요청 예시 (주식시간외호가)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0E" ]
	}]
}
```

### 응답 예시 (주식시간외호가)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'trnm': 'REAL',
	'data': [
		{
			'type': '0E',
			'name': '주식시간외호가',
			'item': '005930',
			'values': {
				'21': '165208',
				'131': '43955',
				'132': '+156',
				'135': '0',
				'136': '0'
			}
		}
	]
}
```

---

## 8. 국내주식 WEBSOCKET 실시간시세 - 주식당일거래원(0F)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식당일거래원 전용)

#### 매도 거래원 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 141-145 | 매도거래원1-5 | String | N | |
| 161-165 | 매도거래원수량1-5 | String | N | |
| 166-170 | 매도거래원별증감1-5 | String | N | |
| 146-150 | 매도거래원코드1-5 | String | N | |
| 271-275 | 매도거래원색깔1-5 | String | N | |

#### 매수 거래원 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 151-155 | 매수거래원1-5 | String | N | |
| 171-175 | 매수거래원수량1-5 | String | N | |
| 176-180 | 매수거래원별증감1-5 | String | N | |
| 156-160 | 매수거래원코드1-5 | String | N | |
| 281-285 | 매수거래원색깔1-5 | String | N | |

#### 외국계 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 261 | 외국계매도추정합 | String | N | |
| 262 | 외국계매도추정합변동 | String | N | |
| 263 | 외국계매수추정합 | String | N | |
| 264 | 외국계매수추정합변동 | String | N | |
| 267 | 외국계순매수추정합 | String | N | |
| 268 | 외국계순매수변동 | String | N | |
| 337 | 거래소구분 | String | N | |

### 요청 예시 (주식당일거래원)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0F" ]
	}]
}
```

### 응답 예시 (주식당일거래원)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'trnm': 'REAL',
	'data': [
		{
			'type': '0F',
			'name': '주식당일거래원',
			'item': '005930',
			'values': {
				'141': '',
				'161': '9350409',
				'166': '+8593585',
				'146': '993',
				'271': '!!!!',
				'151': '',
				'171': '9321128',
				'176': '+8557163',
				'156': '993',
				'281': '!!!!',
				'145': '미래에셋',
				'165': '100',
				'170': '0',
				'150': '005',
				'275': '!!!!',
				'155': '미래에셋',
				'175': '50100',
				'180': '0',
				'160': '005',
				'285': '!!!!',
				'261': '0',
				'262': '0',
				'263': '0',
				'264': '0',
				'267': '0',
				'268': '0',
				'337': '2'
			}
		}
	]
}
```

---

## 9. 국내주식 WEBSOCKET 실시간시세 - ETF NAV(0G)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (ETF NAV 전용)

#### NAV 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 36 | NAV | String | N | |
| 37 | NAV전일대비 | String | N | |
| 38 | NAV등락율 | String | N | |
| 39 | 추적오차율 | String | N | |

#### 기본 시세 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 10 | 현재가 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 13 | 누적거래량 | String | N | |
| 25 | 전일대비기호 | String | N | |

#### ELW 관련 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 667 | ELW기어링비율 | String | N | |
| 668 | ELW손익분기율 | String | N | |
| 669 | ELW자본지지점 | String | N | |

#### 괴리율 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 265 | NAV/지수괴리율 | String | N | |
| 266 | NAV/ETF괴리율 | String | N | |

### 요청 예시 (ETF NAV)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "069500" ],
		"type" : [ "0G" ]
	}]
}
```

### 응답 예시 (ETF NAV)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'36': '+7488.27',
				'37': '+9.57',
				'38': '+0.13',
				'39': '1.82',
				'20': '105732',
				'10': '+7485',
				'11': '+45',
				'12': '+0.60',
				'13': '16874',
				'25': '2',
				'265': '+10.04',
				'266': '-0.04'
			},
			'type': '0G',
			'name': 'ETF NAV',
			'item': '069500'
		}
	],
	'trnm': 'REAL'
}
```

---

## 10. 국내주식 WEBSOCKET 실시간시세 - 주식예상체결(0H)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식예상체결 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 10 | 현재가 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 15 | 거래량 | String | N | +는 매수체결, -는 매도체결 |
| 13 | 누적거래량 | String | N | |
| 25 | 전일대비기호 | String | N | |

### 요청 예시 (주식예상체결)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0H" ]
	}]
}
```

### 응답 예시 (주식예상체결)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'20': '110206',
				'10': '+60500',
				'11': '+200',
				'12': '+0.33',
				'15': '-7805',
				'13': '768293',
				'25': '2'
			},
			'type': '0H',
			'name': '주식예상체결',
			'item': '005930'
		}
	],
	'trnm': 'REAL'
}
```

---

## 11. 국내주식 WEBSOCKET 실시간시세 - 업종지수(0J)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (업종지수 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 10 | 현재가 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 15 | 거래량 | String | N | +는 매수체결,-는 매도체결 |
| 13 | 누적거래량 | String | N | |
| 14 | 누적거래대금 | String | N | |
| 16 | 시가 | String | N | |
| 17 | 고가 | String | N | |
| 18 | 저가 | String | N | |
| 25 | 전일대비기호 | String | N | |
| 26 | 전일거래량대비 | String | N | 계약,주 |

### 요청 예시 (업종지수)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "001" ],
		"type" : [ "0J" ]
	}]
}
```

### 응답 예시 (업종지수)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'20': '110430',
				'10': '-1762.61',
				'11': '-189.51',
				'12': '-9.71',
				'15': '2800',
				'13': '725277',
				'14': '60711859',
				'16': '-1949.04',
				'17': '+1961.28',
				'18': '-1756.13',
				'25': '5',
				'26': '-1482363'
			},
			'type': '0J',
			'name': '업종지수',
			'item': '001'
		}
	],
	'trnm': 'REAL'
}
```

---

## 12. 국내주식 WEBSOCKET 실시간시세 - 업종등락(0U)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (업종등락 전용)

#### 등락 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 252 | 상승종목수 | String | N | |
| 251 | 상한종목수 | String | N | |
| 253 | 보합종목수 | String | N | |
| 255 | 하락종목수 | String | N | |
| 254 | 하한종목수 | String | N | |

#### 거래 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 13 | 누적거래량 | String | N | |
| 14 | 누적거래대금 | String | N | |
| 10 | 현재가 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 256 | 거래형성종목수 | String | N | 계약,주 |
| 257 | 거래형성비율 | String | N | |
| 25 | 전일대비기호 | String | N | |

### 요청 예시 (업종등락)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "001" ],
		"type" : [ "0U" ]
	}]
}
```

### 응답 예시 (업종등락)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'20': '110710',
				'252': '46',
				'251': '1',
				'253': '166',
				'255': '204',
				'254': '16',
				'13': '741784',
				'14': '62093941',
				'10': '-1757.42',
				'11': '-194.70',
				'12': '-9.97',
				'256': '416',
				'257': '43.20',
				'25': '5'
			},
			'type': '0U',
			'name': '업종등락',
			'item': '001'
		}
	],
	'trnm': 'REAL'
}
```

---

## 13. 국내주식 WEBSOCKET 실시간시세 - 주식종목정보(0g)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (주식종목정보 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 297 | 임의연장 | String | N | |
| 592 | 장전임의연장 | String | N | |
| 593 | 장후임의연장 | String | N | |
| 305 | 상한가 | String | N | |
| 306 | 하한가 | String | N | |
| 307 | 기준가 | String | N | |
| 689 | 조기종료ELW발생 | String | N | |
| 594 | 통화단위 | String | N | |
| 382 | 증거금율표시 | String | N | |
| 370 | 종목정보 | String | N | |

### 요청 예시 (주식종목정보)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0g" ]
	}]
}
```

### 응답 예시 (주식종목정보)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'297': '동정적VI',
				'592': ' ',
				'593': ' ',
				'305': '+78300',
				'306': '-42300',
				'307': '60300',
				'689': '',
				'594': '',
				'382': '',
				'370': ''
			},
			'type': '0g',
			'name': '주식종목정보',
			'item': '005930'
		}
	],
	'trnm': 'REAL'
}
```

---

## 14. 국내주식 WEBSOCKET 실시간시세 - ELW 이론가(0m)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (ELW 이론가 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 10 | 현재가 | String | N | |
| 670 | ELW이론가 | String | N | |
| 671 | ELW내재변동성 | String | N | |
| 672 | ELW델타 | String | N | |
| 673 | ELW감마 | String | N | |
| 674 | ELW쎄타 | String | N | |
| 675 | ELW베가 | String | N | |
| 676 | ELW로 | String | N | |
| 706 | LP호가내재변동성 | String | N | |

### 요청 예시 (ELW 이론가)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "57JBHH" ],
		"type" : [ "0m" ]
	}]
}
```

### 응답 예시 (ELW 이론가)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'20': '140000',
				'10': ' 450',
				'670': '0',
				'671': '0.00',
				'672': '0',
				'673': '0',
				'674': '0.000000',
				'675': '0.000000',
				'676': '0.000000',
				'706': ' 0.00'
			},
			'type': '0m',
			'name': 'ELW 이론가',
			'item': '57JBHH'
		}
	],
	'trnm': 'REAL'
}
```

---

## 15. 국내주식 WEBSOCKET 실시간시세 - 장시작시간(0s)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (장시작시간 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 215 | 장운영구분 | String | N | 0:KRX장전, 3:KRX장시작, P:NXT프리마켓개시, Q:NXT프리마켓종료, R:NXT메인마켓개시, S:NXT메인마켓종료, T:NXT애프터마켓단일가개시, U:NXT애프터마켓개시, V:NXT종가매매종료, W:NXT애프터마켓종료 |
| 20 | 체결시간 | String | N | |
| 214 | 장시작예상잔여시간 | String | N | |

### 요청 예시 (장시작시간)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "" ],
		"type" : [ "0s" ]
	}]
}
```

### 응답 예시 (장시작시간)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data':[
		{
			'values': {
				'215':'b',
				'20':'170000',
				'214':'000000'
			},
			'type':'0s',
			'name':'장시작시간',
			'item':''
		}
	],
	'trnm': 'REAL'
}
```

---

## 16. 국내주식 WEBSOCKET 실시간시세 - ELW 지표(0u)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (ELW 지표 전용)

| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 666 | ELW패리티 | String | N | |
| 1211 | ELW프리미엄 | String | N | |
| 667 | ELW기어링비율 | String | N | |
| 668 | ELW손익분기율 | String | N | |
| 669 | ELW자본지지점 | String | N | |

### 요청 예시 (ELW 지표)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "57JBHH" ],
		"type" : [ "0u" ]
	}]
}
```

### 응답 예시 (ELW 지표)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'20': '111847',
				'666': '69.13',
				'1211': '0',
				'667': '1037.04',
				'668': '+44.73',
				'669': '+44.78'
			},
			'type': '0u',
			'name': 'ELW 지표',
			'item': '57JBHH'
		}
	],
	'trnm': 'REAL'
}
```

---

## 17. 국내주식 WEBSOCKET 실시간시세 - 종목프로그램매매(0w)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (종목프로그램매매 전용)

#### 기본 시세 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 20 | 체결시간 | String | N | |
| 10 | 현재가 | String | N | |
| 25 | 전일대비기호 | String | N | |
| 11 | 전일대비 | String | N | |
| 12 | 등락율 | String | N | |
| 13 | 누적거래량 | String | N | |

#### 프로그램매매 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 202 | 매도수량 | String | N | |
| 204 | 매도금액 | String | N | |
| 206 | 매수수량 | String | N | |
| 208 | 매수금액 | String | N | |
| 210 | 순매수수량 | String | N | |
| 211 | 순매수수량증감 | String | N | 계약,주 |
| 212 | 순매수금액 | String | N | |
| 213 | 순매수금액증감 | String | N | |

#### 기타 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 214 | 장시작예상잔여시간 | String | N | |
| 215 | 장운영구분 | String | N | |
| 216 | 투자자별ticker | String | N | |

### 요청 예시 (종목프로그램매매)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "005930" ],
		"type" : [ "0w" ]
	}]
}
```

### 응답 예시 (종목프로그램매매)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'20': '113442',
				'10': '-60200',
				'25': '5',
				'11': '-100',
				'12': '-0.17',
				'13': '128152628',
				'202': '0',
				'204': '0',
				'206': '8043',
				'208': '483',
				'210': '8043',
				'212': '483',
				'213': '0',
				'211': '0'
			},
			'type': '0w',
			'name': '종목별프로그램매매',
			'item': '005930'
		}
	],
	'trnm': 'REAL'
}
```

---

## 18. 국내주식 WEBSOCKET 실시간시세 - VI발동/해제(1h)

### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

### 요청 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| trnm | 서비스명 | String | Y | 10 | REG : 등록, REMOVE : 해지 |
| grp_no | 그룹번호 | String | Y | 4 | |
| refresh | 기존등록유지여부 | String | Y | 1 | 등록(REG)시 0:기존유지안함 1:기존유지(Default) 0일경우 기존등록한 item/type은 해지, 1일경우 기존등록한 item/type 유지 해지(REMOVE)시 값 불필요 |
| data | 실시간 등록 리스트 | LIST | | | |
| - item | 실시간 등록 요소 | String[] | N | 100 | 거래소별 종목코드, 업종코드 (KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| - type | 실시간 항목 | String[] | Y | 2 | TR 명(0A,0B....) |

### 응답 Body

| Element | 한글명 | Type | Required | Length | Description |
|---------|--------|------|----------|--------|-------------|
| return_code | 결과코드 | int | N | | 통신결과에대한 코드 (등록,해지요청시에만 값 전송 0:정상,1:오류, 데이터 실시간 수신시 미전송) |
| return_msg | 결과메시지 | String | N | | 통신결과에대한메시지 |
| trnm | 서비스명 | String | N | | 등록,해지요청시 요청값 반환, 실시간수신시 REAL 반환 |
| data | 실시간 등록리스트 | LIST | N | | |
| - type | 실시간항목 | String | N | | TR 명(0A,0B....) |
| - name | 실시간 항목명 | String | N | | |
| - item | 실시간 등록 요소 | String | N | | 종목코드 |
| - values | 실시간 값 리스트 | LIST | N | | |

### 실시간 값 리스트 필드 (VI발동/해제 전용)

#### 종목 기본 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 9001 | 종목코드 | String | N | |
| 302 | 종목명 | String | N | |
| 13 | 누적거래량 | String | N | |
| 14 | 누적거래대금 | String | N | |

#### VI 발동 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 9068 | VI발동구분 | String | N | |
| 9008 | KOSPI,KOSDAQ,전체구분 | String | N | |
| 9075 | 장전구분 | String | N | |
| 1221 | VI발동가격 | String | N | |
| 1223 | 매매체결처리시각 | String | N | |
| 1224 | VI해제시각 | String | N | |
| 1225 | VI적용구분 | String | N | 정적/동적/동적+정적 |

#### VI 기준가격 및 괴리율
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 1236 | 기준가격 정적 | String | N | 계약,주 |
| 1237 | 기준가격 동적 | String | N | |
| 1238 | 괴리율 정적 | String | N | |
| 1239 | 괴리율 동적 | String | N | |

#### 기타 VI 정보
| 필드 | 한글명 | Type | Required | Description |
|------|--------|------|----------|-------------|
| 1489 | VI발동가 등락율 | String | N | |
| 1490 | VI발동횟수 | String | N | |
| 9069 | 발동방향구분 | String | N | |
| 1279 | Extra Item | String | N | |

### 요청 예시 (VI발동/해제)

```json
{
	"trnm" : "REG",
	"grp_no" : "1",
	"refresh" : "1",
	"data" : [{
		"item" : [ "" ],
		"type" : [ "1h" ]
	}]
}
```

### 응답 예시 (VI발동/해제)

**요청 응답:**
```json
{
	'trnm': 'REG',
	'return_code': 0,
	'return_msg': ''
}
```

**실시간 수신 응답:**
```json
{
	'data': [
		{
			'values': {
				'9001':'005930',
				'302':'삼성전자',
				'13':'1077818',
				'14':'4201',
				'9068':'1',
				'9008':'101',
				'9075':'1',
				'1221':'4125',
				'1223':'111454',
				'1224':'111703',
				'1225':'정적',
				'1236':'3750',
				'1237':'0',
				'1238':'+10.00',
				'1239':'0.00',
				'1489':'+10.00',
				'1490':'1',
				'9069':'1',
				'1279':'+정적'
			},
			'type':'1h',
			'name':'VI발동/해제',
			'item':'005930'
		}
	],
	'trnm':'REAL'
}
```

---