# 키움증권 API 문서

## 국내주식 REST API

### 업종

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 업종프로그램요청 | ka10010 | 업종 프로그램 매매 정보 조회 |
| 업종별투자자순매수요청 | ka10051 | 업종별 투자자 순매수 정보 조회 |
| 업종현재가요청 | ka20001 | 업종 현재가 정보 조회 |
| 업종별주가요청 | ka20002 | 업종별 주가 정보 조회 |
| 전업종지수요청 | ka20003 | 전 업종 지수 정보 조회 |
| 업종현재가일별요청 | ka20009 | 업종 현재가 일별 정보 조회 |

### 업종프로그램요청 (ka10010)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/sect
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                 |
| ------- | -------- | ------ | -------- | ------ | --------------------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명                   | Type   | Required | Length | Description |
| -------------------------- | ------------------------ | ------ | -------- | ------ | ----------- |
| dfrt_trst_sell_qty         | 차익위탁매도수량         | String | N        | 20     |             |
| dfrt_trst_sell_amt         | 차익위탁매도금액         | String | N        | 20     |             |
| dfrt_trst_buy_qty          | 차익위탁매수수량         | String | N        | 20     |             |
| dfrt_trst_buy_amt          | 차익위탁매수금액         | String | N        | 20     |             |
| dfrt_trst_netprps_qty      | 차익위탁순매수수량       | String | N        | 20     |             |
| dfrt_trst_netprps_amt      | 차익위탁순매수금액       | String | N        | 20     |             |
| ndiffpro_trst_sell_qty     | 비차익위탁매도수량       | String | N        | 20     |             |
| ndiffpro_trst_sell_amt     | 비차익위탁매도금액       | String | N        | 20     |             |
| ndiffpro_trst_buy_qty      | 비차익위탁매수수량       | String | N        | 20     |             |
| ndiffpro_trst_buy_amt      | 비차익위탁매수금액       | String | N        | 20     |             |
| ndiffpro_trst_netprps_qty  | 비차익위탁순매수수량     | String | N        | 20     |             |
| ndiffpro_trst_netprps_amt  | 비차익위탁순매수금액     | String | N        | 20     |             |
| all_dfrt_trst_sell_qty     | 전체차익위탁매도수량     | String | N        | 20     |             |
| all_dfrt_trst_sell_amt     | 전체차익위탁매도금액     | String | N        | 20     |             |
| all_dfrt_trst_buy_qty      | 전체차익위탁매수수량     | String | N        | 20     |             |
| all_dfrt_trst_buy_amt      | 전체차익위탁매수금액     | String | N        | 20     |             |
| all_dfrt_trst_netprps_qty  | 전체차익위탁순매수수량   | String | N        | 20     |             |
| all_dfrt_trst_netprps_amt  | 전체차익위탁순매수금액   | String | N        | 20     |             |

#### 요청 예시

```json
{
	"stk_cd": "005930"
}
```

#### 응답 예시

```json
{
	"dfrt_trst_sell_qty":"",
	"dfrt_trst_sell_amt":"",
	"dfrt_trst_buy_qty":"",
	"dfrt_trst_buy_amt":"",
	"dfrt_trst_netprps_qty":"",
	"dfrt_trst_netprps_amt":"",
	"ndiffpro_trst_sell_qty":"",
	"ndiffpro_trst_sell_amt":"",
	"ndiffpro_trst_buy_qty":"",
	"ndiffpro_trst_buy_amt":"",
	"ndiffpro_trst_netprps_qty":"",
	"ndiffpro_trst_netprps_amt":"",
	"all_dfrt_trst_sell_qty":"40242",
	"all_dfrt_trst_sell_amt":"",
	"all_dfrt_trst_buy_qty":"69219",
	"all_dfrt_trst_buy_amt":"",
	"all_dfrt_trst_netprps_qty":"346871946",
	"all_dfrt_trst_netprps_amt":"",
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

### 업종별투자자순매수요청 (ka10051)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/sect
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명         | Type   | Required | Length | Description                           |
| ---------- | -------------- | ------ | -------- | ------ | ------------------------------------- |
| mrkt_tp    | 시장구분       | String | Y        | 1      | 코스피:0, 코스닥:1                    |
| amt_qty_tp | 금액수량구분   | String | Y        | 1      | 금액:0, 수량:1                        |
| base_dt    | 기준일자       | String | N        | 8      | YYYYMMDD                              |
| stex_tp    | 거래소구분     | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                  |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                         | 한글명                   | Type   | Required | Length | Description |
| ------------------------------- | ------------------------ | ------ | -------- | ------ | ----------- |
| inds_netprps                    | 업종별순매수             | LIST   | N        |        |             |
| - inds_cd                       | 업종코드                 | String | N        | 20     |             |
| - inds_nm                       | 업종명                   | String | N        | 20     |             |
| - cur_prc                       | 현재가                   | String | N        | 20     |             |
| - pre_smbol                     | 대비부호                 | String | N        | 20     |             |
| - pred_pre                      | 전일대비                 | String | N        | 20     |             |
| - flu_rt                        | 등락율                   | String | N        | 20     |             |
| - trde_qty                      | 거래량                   | String | N        | 20     |             |
| - sc_netprps                    | 증권순매수               | String | N        | 20     |             |
| - insrnc_netprps                | 보험순매수               | String | N        | 20     |             |
| - invtrt_netprps                | 투신순매수               | String | N        | 20     |             |
| - bank_netprps                  | 은행순매수               | String | N        | 20     |             |
| - jnsinkm_netprps               | 종신금순매수             | String | N        | 20     |             |
| - endw_netprps                  | 기금순매수               | String | N        | 20     |             |
| - etc_corp_netprps              | 기타법인순매수           | String | N        | 20     |             |
| - ind_netprps                   | 개인순매수               | String | N        | 20     |             |
| - frgnr_netprps                 | 외국인순매수             | String | N        | 20     |             |
| - native_trmt_frgnr_netprps     | 내국인대우외국인순매수   | String | N        | 20     |             |
| - natn_netprps                  | 국가순매수               | String | N        | 20     |             |
| - samo_fund_netprps             | 사모펀드순매수           | String | N        | 20     |             |
| - orgn_netprps                  | 기관계순매수             | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "0",
	"amt_qty_tp": "0",
	"base_dt": "20241107",
	"stex_tp": "3"
}
```

#### 응답 예시

```json
{
	"inds_netprps":
		[
			{
				"inds_cd":"001_AL",
				"inds_nm":"종합(KOSPI)",
				"cur_prc":"+265381",
				"pre_smbol":"2",
				"pred_pre":"+9030",
				"flu_rt":"352",
				"trde_qty":"1164",
				"sc_netprps":"+255",
				"insrnc_netprps":"+0",
				"invtrt_netprps":"+0",
				"bank_netprps":"+0",
				"jnsinkm_netprps":"+0",
				"endw_netprps":"+0",
				"etc_corp_netprps":"+0",
				"ind_netprps":"-0",
				"frgnr_netprps":"-622",
				"native_trmt_frgnr_netprps":"+4",
				"natn_netprps":"+0",
				"samo_fund_netprps":"+1",
				"orgn_netprps":"+601"
			},
			{
				"inds_cd":"002_AL",
				"inds_nm":"대형주",
				"cur_prc":"+265964",
				"pre_smbol":"2",
				"pred_pre":"+10690",
				"flu_rt":"419",
				"trde_qty":"1145",
				"sc_netprps":"+255",
				"insrnc_netprps":"+0",
				"invtrt_netprps":"+0",
				"bank_netprps":"+0",
				"jnsinkm_netprps":"+0",
				"endw_netprps":"+0",
				"etc_corp_netprps":"+0",
				"ind_netprps":"+16",
				"frgnr_netprps":"-622",
				"native_trmt_frgnr_netprps":"+4",
				"natn_netprps":"+0",
				"samo_fund_netprps":"+1",
				"orgn_netprps":"+602"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

### 업종현재가요청 (ka20001)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/sect
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명     | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| -------- | ---------- | ------ | -------- | ------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp  | 시장구분   | String | Y        | 1      | 0:코스피, 1:코스닥, 2:코스피200                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| inds_cd  | 업종코드   | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주, 101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701:KRX100                                                                                                                                                                                                                                                                                                                                                                                               |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명               | Type   | Required | Length | Description |
| -------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| cur_prc                    | 현재가               | String | N        | 20     |             |
| pred_pre_sig               | 전일대비기호         | String | N        | 20     |             |
| pred_pre                   | 전일대비             | String | N        | 20     |             |
| flu_rt                     | 등락률               | String | N        | 20     |             |
| trde_qty                   | 거래량               | String | N        | 20     |             |
| trde_prica                 | 거래대금             | String | N        | 20     |             |
| trde_frmatn_stk_num        | 거래형성종목수       | String | N        | 20     |             |
| trde_frmatn_rt             | 거래형성비율         | String | N        | 20     |             |
| open_pric                  | 시가                 | String | N        | 20     |             |
| high_pric                  | 고가                 | String | N        | 20     |             |
| low_pric                   | 저가                 | String | N        | 20     |             |
| upl                        | 상한                 | String | N        | 20     |             |
| rising                     | 상승                 | String | N        | 20     |             |
| stdns                      | 보합                 | String | N        | 20     |             |
| fall                       | 하락                 | String | N        | 20     |             |
| lst                        | 하한                 | String | N        | 20     |             |
| 52wk_hgst_pric             | 52주최고가           | String | N        | 20     |             |
| 52wk_hgst_pric_dt          | 52주최고가일         | String | N        | 20     |             |
| 52wk_hgst_pric_pre_rt      | 52주최고가대비율     | String | N        | 20     |             |
| 52wk_lwst_pric             | 52주최저가           | String | N        | 20     |             |
| 52wk_lwst_pric_dt          | 52주최저가일         | String | N        | 20     |             |
| 52wk_lwst_pric_pre_rt      | 52주최저가대비율     | String | N        | 20     |             |
| inds_cur_prc_tm            | 업종현재가시간별     | LIST   | N        |        |             |
| - tm_n                     | 시간n                | String | N        | 20     |             |
| - cur_prc_n                | 현재가n              | String | N        | 20     |             |
| - pred_pre_sig_n           | 전일대비기호n        | String | N        | 20     |             |
| - pred_pre_n               | 전일대비n            | String | N        | 20     |             |
| - flu_rt_n                 | 등락률n              | String | N        | 20     |             |
| - trde_qty_n               | 거래량n              | String | N        | 20     |             |
| - acc_trde_qty_n           | 누적거래량n          | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "0",
	"inds_cd": "001"
}
```

#### 응답 예시

```json
{
	"cur_prc":"-2394.49",
	"pred_pre_sig":"5",
	"pred_pre":"-278.47",
	"flu_rt":"-10.42",
	"trde_qty":"890",
	"trde_prica":"41867",
	"trde_frmatn_stk_num":"330",
	"trde_frmatn_rt":"+34.38",
	"open_pric":"-2669.53",
	"high_pric":"-2669.53",
	"low_pric":"-2375.21",
	"upl":"0",
	"rising":"17",
	"stdns":"183",
	"fall":"130",
	"lst":"3",
	"52wk_hgst_pric":"+3001.91",
	"52wk_hgst_pric_dt":"20241004",
	"52wk_hgst_pric_pre_rt":"-20.23",
	"52wk_lwst_pric":"-1608.07",
	"52wk_lwst_pric_dt":"20241031",
	"52wk_lwst_pric_pre_rt":"+48.90",
	"inds_cur_prc_tm":
		[
			{
				"tm_n":"143000",
				"cur_prc_n":"-2394.49",
				"pred_pre_sig_n":"5",
				"pred_pre_n":"-278.47",
				"flu_rt_n":"-10.42",
				"trde_qty_n":"14",
				"acc_trde_qty_n":"890"
			},
			{
				"tm_n":"142950",
				"cur_prc_n":"-2394.49",
				"pred_pre_sig_n":"5",
				"pred_pre_n":"-278.47",
				"flu_rt_n":"-10.42",
				"trde_qty_n":"14",
				"acc_trde_qty_n":"876"
			},
			{
				"tm_n":"142940",
				"cur_prc_n":"-2394.49",
				"pred_pre_sig_n":"5",
				"pred_pre_n":"-278.47",
				"flu_rt_n":"-10.42",
				"trde_qty_n":"14",
				"acc_trde_qty_n":"862"
			},
			{
				"tm_n":"142930",
				"cur_prc_n":"-2395.62",
				"pred_pre_sig_n":"5",
				"pred_pre_n":"-277.34",
				"flu_rt_n":"-10.38",
				"trde_qty_n":"14",
				"acc_trde_qty_n":"848"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

### 업종별주가요청 (ka20002)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/sect
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명     | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| -------- | ---------- | ------ | -------- | ------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp  | 시장구분   | String | Y        | 1      | 0:코스피, 1:코스닥, 2:코스피200                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| inds_cd  | 업종코드   | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주, 101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701:KRX100                                                                                                                                                                                                                                                                                                                                                                                               |
| stex_tp  | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명               | Type   | Required | Length | Description |
| -------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| inds_stkpc                 | 업종별주가           | LIST   | N        |        |             |
| - stk_cd                   | 종목코드             | String | N        | 20     |             |
| - stk_nm                   | 종목명               | String | N        | 20     |             |
| - cur_prc                  | 현재가               | String | N        | 20     |             |
| - pred_pre_sig             | 전일대비기호         | String | N        | 20     |             |
| - pred_pre                 | 전일대비             | String | N        | 20     |             |
| - flu_rt                   | 등락률               | String | N        | 20     |             |
| - now_trde_qty             | 현재거래량           | String | N        | 20     |             |
| - sel_bid                  | 매도호가             | String | N        | 20     |             |
| - buy_bid                  | 매수호가             | String | N        | 20     |             |
| - open_pric                | 시가                 | String | N        | 20     |             |
| - high_pric                | 고가                 | String | N        | 20     |             |
| - low_pric                 | 저가                 | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "0",
	"inds_cd": "001",
	"stex_tp": "1"
}
```

#### 응답 예시

```json
{
	"inds_stkpc":
		[
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"6200",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"now_trde_qty":"116",
				"sel_bid":"+6990",
				"buy_bid":"0",
				"open_pric":"6200",
				"high_pric":"6200",
				"low_pric":"6200"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"465",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"now_trde_qty":"0",
				"sel_bid":"0",
				"buy_bid":"0",
				"open_pric":"0",
				"high_pric":"0",
				"low_pric":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"6090",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"now_trde_qty":"0",
				"sel_bid":"0",
				"buy_bid":"-5000",
				"open_pric":"0",
				"high_pric":"0",
				"low_pric":"0"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"+68100",
				"pred_pre_sig":"2",
				"pred_pre":"+600",
				"flu_rt":"+0.89",
				"now_trde_qty":"3",
				"sel_bid":"0",
				"buy_bid":"+68100",
				"open_pric":"67500",
				"high_pric":"+68100",
				"low_pric":"-66000"
			},
			{
				"stk_cd":"005930",
				"stk_nm":"삼성전자",
				"cur_prc":"55300",
				"pred_pre_sig":"3",
				"pred_pre":"0",
				"flu_rt":"0.00",
				"now_trde_qty":"0",
				"sel_bid":"+55400",
				"buy_bid":"-55000",
				"open_pric":"0",
				"high_pric":"0",
				"low_pric":"0"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

### 전업종지수요청 (ka20003)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/sect
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명     | Type   | Required | Length | Description                                      |
| -------- | ---------- | ------ | -------- | ------ | ------------------------------------------------ |
| inds_cd  | 업종코드   | String | Y        | 3      | 001:종합(KOSPI), 101:종합(KOSDAQ)                |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명               | Type   | Required | Length | Description |
| -------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| all_inds_idex              | 전업종지수           | LIST   | N        |        |             |
| - stk_cd                   | 종목코드             | String | N        | 20     |             |
| - stk_nm                   | 종목명               | String | N        | 20     |             |
| - cur_prc                  | 현재가               | String | N        | 20     |             |
| - pre_sig                  | 대비기호             | String | N        | 20     |             |
| - pred_pre                 | 전일대비             | String | N        | 20     |             |
| - flu_rt                   | 등락률               | String | N        | 20     |             |
| - trde_qty                 | 거래량               | String | N        | 20     |             |
| - wght                     | 비중                 | String | N        | 20     |             |
| - trde_prica               | 거래대금             | String | N        | 20     |             |
| - upl                      | 상한                 | String | N        | 20     |             |
| - rising                   | 상승                 | String | N        | 20     |             |
| - stdns                    | 보합                 | String | N        | 20     |             |
| - fall                     | 하락                 | String | N        | 20     |             |
| - lst                      | 하한                 | String | N        | 20     |             |
| - flo_stk_num              | 상장종목수           | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "001"
}
```

#### 응답 예시

```json
{
	"all_inds_idex":
		[
			{
				"stk_cd":"001",
				"stk_nm":"종합(KOSPI)",
				"cur_prc":"-2393.33",
				"pre_sig":"5",
				"pred_pre":"-279.63",
				"flu_rt":"-10.46",
				"trde_qty":"993",
				"wght":"",
				"trde_prica":"46494",
				"upl":"0",
				"rising":"17",
				"stdns":"184",
				"fall":"129",
				"lst":"4",
				"flo_stk_num":"960"
			},
			{
				"stk_cd":"002",
				"stk_nm":"대형주",
				"cur_prc":"-2379.14",
				"pre_sig":"5",
				"pred_pre":"-326.94",
				"flu_rt":"-12.08",
				"trde_qty":"957",
				"wght":"",
				"trde_prica":"44563",
				"upl":"0",
				"rising":"6",
				"stdns":"32",
				"fall":"56",
				"lst":"2",
				"flo_stk_num":"100"
			},
			{
				"stk_cd":"003",
				"stk_nm":"중형주",
				"cur_prc":"-2691.27",
				"pre_sig":"5",
				"pred_pre":"-58.55",
				"flu_rt":"-2.13",
				"trde_qty":"26",
				"wght":"",
				"trde_prica":"1823",
				"upl":"0",
				"rising":"5",
				"stdns":"75",
				"fall":"49",
				"lst":"2",
				"flo_stk_num":"200"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

### 업종현재가일별요청 (ka20009)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/sect
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명     | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| -------- | ---------- | ------ | -------- | ------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp  | 시장구분   | String | Y        | 1      | 0:코스피, 1:코스닥, 2:코스피200                                                                                                                                                                                                                                                                                                                                                                                                                                                                          |
| inds_cd  | 업종코드   | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주, 101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701:KRX100                                                                                                                                                                                                                                                                                                                                                                                               |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                    | 한글명               | Type   | Required | Length | Description |
| -------------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| cur_prc                    | 현재가               | String | N        | 20     |             |
| pred_pre_sig               | 전일대비기호         | String | N        | 20     |             |
| pred_pre                   | 전일대비             | String | N        | 20     |             |
| flu_rt                     | 등락률               | String | N        | 20     |             |
| trde_qty                   | 거래량               | String | N        | 20     |             |
| trde_prica                 | 거래대금             | String | N        | 20     |             |
| trde_frmatn_stk_num        | 거래형성종목수       | String | N        | 20     |             |
| trde_frmatn_rt             | 거래형성비율         | String | N        | 20     |             |
| open_pric                  | 시가                 | String | N        | 20     |             |
| high_pric                  | 고가                 | String | N        | 20     |             |
| low_pric                   | 저가                 | String | N        | 20     |             |
| upl                        | 상한                 | String | N        | 20     |             |
| rising                     | 상승                 | String | N        | 20     |             |
| stdns                      | 보합                 | String | N        | 20     |             |
| fall                       | 하락                 | String | N        | 20     |             |
| lst                        | 하한                 | String | N        | 20     |             |
| 52wk_hgst_pric             | 52주최고가           | String | N        | 20     |             |
| 52wk_hgst_pric_dt          | 52주최고가일         | String | N        | 20     |             |
| 52wk_hgst_pric_pre_rt      | 52주최고가대비율     | String | N        | 20     |             |
| 52wk_lwst_pric             | 52주최저가           | String | N        | 20     |             |
| 52wk_lwst_pric_dt          | 52주최저가일         | String | N        | 20     |             |
| 52wk_lwst_pric_pre_rt      | 52주최저가대비율     | String | N        | 20     |             |
| inds_cur_prc_daly_rept     | 업종현재가일별반복   | LIST   | N        |        |             |
| - dt_n                     | 일자n                | String | N        | 20     |             |
| - cur_prc_n                | 현재가n              | String | N        | 20     |             |
| - pred_pre_sig_n           | 전일대비기호n        | String | N        | 20     |             |
| - pred_pre_n               | 전일대비n            | String | N        | 20     |             |
| - flu_rt_n                 | 등락률n              | String | N        | 20     |             |
| - acc_trde_qty_n           | 누적거래량n          | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "0",
	"inds_cd": "001"
}
```

#### 응답 예시

```json
{
	"cur_prc":"-2384.71",
	"pred_pre_sig":"5",
	"pred_pre":"-288.25",
	"flu_rt":"-10.78",
	"trde_qty":"1103",
	"trde_prica":"48151",
	"trde_frmatn_stk_num":"333",
	"trde_frmatn_rt":"+34.69",
	"open_pric":"-2669.53",
	"high_pric":"-2669.53",
	"low_pric":"-2375.21",
	"upl":"0",
	"rising":"18",
	"stdns":"183",
	"fall":"132",
	"lst":"4",
	"52wk_hgst_pric":"+3001.91",
	"52wk_hgst_pric_dt":"20241004",
	"52wk_hgst_pric_pre_rt":"-20.56",
	"52wk_lwst_pric":"-1608.07",
	"52wk_lwst_pric_dt":"20241031",
	"52wk_lwst_pric_pre_rt":"+48.30",
	"inds_cur_prc_daly_rept":
		[
			{
				"dt_n":"20241122",
				"cur_prc_n":"-2384.71",
				"pred_pre_sig_n":"5",
				"pred_pre_n":"-288.25",
				"flu_rt_n":"-10.78",
				"acc_trde_qty_n":"1103"
			},
			{
				"dt_n":"20241121",
				"cur_prc_n":"+2672.96",
				"pred_pre_sig_n":"2",
				"pred_pre_n":"+25.56",
				"flu_rt_n":"+0.97",
				"acc_trde_qty_n":"444"
			},
			{
				"dt_n":"20241120",
				"cur_prc_n":"+2647.40",
				"pred_pre_sig_n":"2",
				"pred_pre_n":"+83.56",
				"flu_rt_n":"+3.26",
				"acc_trde_qty_n":"195"
			}
		],
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---
