# 키움증권 API 문서

## 국내주식 REST API

### 조건검색

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 조건검색 목록조회 | ka10171 | 조건검색 목록 조회 |
| 조건검색 요청 일반 | ka10172 | 조건검색 요청 일반 |
| 조건검색 요청 실시간 | ka10173 | 조건검색 요청 실시간 |

### 조건검색 목록조회 (ka10171)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Body

| Element | 한글명 | Type   | Required | Length | Description    |
| ------- | ------ | ------ | -------- | ------ | -------------- |
| trnm    | TR명   | String | Y        | 7      | CNSRLST고정값  |

#### 응답 Body

| Element     | 한글명          | Type   | Required | Length | Description                    |
| ----------- | --------------- | ------ | -------- | ------ | ------------------------------ |
| return_code | 결과코드        | int    | N        |        | 정상 : 0                       |
| return_msg  | 결과메시지      | String | N        |        | 정상인 경우는 메시지 없음      |
| trnm        | 서비스명        | String | N        | 7      | CNSRLST 고정값                 |
| data        | 조건검색식 목록 | LIST   | N        |        |                                |
| - seq       | 조건검색식 일련번호 | String | N        |        |                            |
| - name      | 조건검색식 명   | String | N        |        |                                |

#### 요청 예시

```json
{
	"trnm": "CNSRLST"
}
```

#### 응답 예시

```json
{
	"trnm": "CNSRLST",
	"return_code": 0,
	"return_msg": "",
	"data": [
		["0","조건1"],
		["1","조건2"],
		["2","조건3"],
		["3","조건4"],
		["4","조건5"]
	]
}
```

---

### 조건검색 요청 일반 (ka10172)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Body

| Element     | 한글명               | Type   | Required | Length | Description                         |
| ----------- | -------------------- | ------ | -------- | ------ | ----------------------------------- |
| trnm        | 서비스명             | String | Y        | 7      | CNSRREQ 고정값                      |
| seq         | 조건검색식 일련번호  | String | Y        | 3      |                                     |
| search_type | 조회타입             | String | Y        |        | 0:조건검색                          |
| stex_tp     | 거래소구분           | String | Y        | 1      | K:KRX                               |
| cont_yn     | 연속조회여부         | String | N        | 1      | Y:연속조회요청, N:연속조회미요청    |
| next_key    | 연속조회키           | String | N        | 20     |                                     |

#### 응답 Body

| Element     | 한글명               | Type   | Required | Length | Description                                        |
| ----------- | -------------------- | ------ | -------- | ------ | -------------------------------------------------- |
| return_code | 결과코드             | int    | N        |        | 정상:0 나머지:에러                                 |
| return_msg  | 결과메시지           | String | N        |        | 정상인 경우는 메시지 없음                          |
| trnm        | 서비스명             | String | N        |        | CNSRREQ                                            |
| seq         | 조건검색식 일련번호  | String | N        |        |                                                    |
| cont_yn     | 연속조회여부         | String | N        |        | 연속 데이터가 존재하는경우 Y, 없으면 N             |
| next_key    | 연속조회키           | String | N        |        | 연속조회여부가Y일경우 다음 조회시 필요한 조회값    |
| data        | 검색결과데이터       | LIST   | N        |        |                                                    |
| - 9001      | 종목코드             | String | N        |        |                                                    |
| - 302       | 종목명               | String | N        |        |                                                    |
| - 10        | 현재가               | String | N        |        |                                                    |
| - 25        | 전일대비기호         | String | N        |        |                                                    |
| - 11        | 전일대비             | String | N        |        |                                                    |
| - 12        | 등락율               | String | N        |        |                                                    |
| - 13        | 누적거래량           | String | N        |        |                                                    |
| - 16        | 시가                 | String | N        |        |                                                    |
| - 17        | 고가                 | String | N        |        |                                                    |
| - 18        | 저가                 | String | N        |        |                                                    |

#### 요청 예시

```json
{
	"trnm": "CNSRREQ",
	"seq": "4",
	"search_type": "0",
	"stex_tp": "K",
	"cont_yn": "N",
	"next_key": ""
}
```

#### 응답 예시

```json
{
	"trnm": "CNSRREQ",
	"seq": "2  ",
	"cont_yn": "N",
	"next_key": "",
	"return_code": 0,
	"data": [
		{
			"9001": "A005930",
			"302": "삼성전자",
			"10": "000021850",
			"25": "3",
			"11": "000000000",
			"12": "000000000",
			"13": "000000000",
			"16": "000000000",
			"17": "000000000",
			"18": "000000000"
		},
		{
			"9001": "A005930",
			"302": "삼성전자",
			"10": "000044350",
			"25": "3",
			"11": "000000000",
			"12": "000000000",
			"13": "000000000",
			"16": "000000000",
			"17": "000000000",
			"18": "000000000"
		},
		{
			"9001": "A005930",
			"302": "삼성전자",
			"10": "000003855",
			"25": "3",
			"11": "000000000",
			"12": "000000000",
			"13": "000000000",
			"16": "000000000",
			"17": "000000000",
			"18": "000000000"
		},
		{
			"9001": "A005930",
			"302": "삼성전자",
			"10": "000075000",
			"25": "5",
			"11": "-00000100",
			"12": "-00000130",
			"13": "010386116",
			"16": "000075100",
			"17": "000075600",
			"18": "000074700"
		},
		{
			"9001": "A005930",
			"302": "삼성전자",
			"10": "000002900",
			"25": "3",
			"11": "000000000",
			"12": "000000000",
			"13": "000000000",
			"16": "000000000",
			"17": "000000000",
			"18": "000000000"
		}
	]
}
```

---

### 조건검색 요청 실시간 (ka10173)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Body

| Element     | 한글명               | Type   | Required | Length | Description                         |
| ----------- | -------------------- | ------ | -------- | ------ | ----------------------------------- |
| trnm        | 서비스명             | String | Y        | 7      | CNSRREQ 고정값                      |
| seq         | 조건검색식 일련번호  | String | Y        | 3      |                                     |
| search_type | 조회타입             | String | Y        | 1      | 1:조건검색+실시간조건검색           |
| stex_tp     | 거래소구분           | String | Y        | 1      | K:KRX                               |

#### 응답 Body (조회 데이터)

| Element     | 한글명               | Type   | Required | Length | Description                                        |
| ----------- | -------------------- | ------ | -------- | ------ | -------------------------------------------------- |
| return_code | 결과코드             | int    | N        |        | 정상:0 나머지:에러                                 |
| return_msg  | 결과메시지           | String | N        |        | 정상인 경우는 메시지 없음                          |
| trnm        | 서비스명             | String | N        |        | CNSRREQ                                            |
| seq         | 조건검색식 일련번호  | String | N        |        |                                                    |
| data        | 검색결과데이터       | LIST   | N        |        |                                                    |
| - jmcode    | 종목코드             | String | N        |        |                                                    |

#### 응답 Body (실시간 데이터)

| Element     | 한글명               | Type   | Required | Length | Description                                        |
| ----------- | -------------------- | ------ | -------- | ------ | -------------------------------------------------- |
| data        | 검색결과데이터       | LIST   | Y        |        |                                                    |
| trnm        | 서비스명             | String | Y        |        | REAL                                               |
| - type      | 실시간 항목          | String | Y        | 2      | TR 명(0A,0B....)                                   |
| - name      | 실시간 항목명        | String | Y        |        | 종목코드                                           |
| - values    | 실시간 수신 값       | Object | Y        |        |                                                    |
| - - 841     | 일련번호             | String | Y        |        |                                                    |
| - - 9001    | 종목코드             | String | Y        |        |                                                    |
| - - 843     | 삽입삭제 구분        | String | Y        |        | I:삽입, D:삭제                                     |
| - - 20      | 체결시간             | String | Y        |        |                                                    |
| - - 907     | 매도/매수 구분       | String | Y        |        |                                                    |

#### 요청 예시

```json
{
	"trnm": "CNSRREQ",
	"seq": "4",
	"search_type": "1",
	"stex_tp": "K"
}
```

#### 응답 예시 (조회 데이터)

```json
{
	"trnm": "CNSRREQ",
	"seq": "4",
	"return_code": 0,
	"data": [
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"},
		{"jmcode": "A005930"}
	]
}
```

#### 응답 예시 (실시간 데이터)

```json
{
	"data": [
		{
			"values": {
				"841": "4",
				"9001": "005930",
				"843": "I",
				"20": "152028",
				"907": "2"
			},
			"type": "02",
			"name": "조건검색",
			"item": "005930"
		}
	],
	"trnm": "REAL"
}
```

---

### 조건검색 실시간 해제 (ka10174)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: wss://api.kiwoom.com:10000
- **모의투자 도메인**: wss://mockapi.kiwoom.com:10000(KRX만 지원가능)
- **URL**: /api/dostk/websocket
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Body

| Element | 한글명               | Type   | Required | Length | Description     |
| ------- | -------------------- | ------ | -------- | ------ | --------------- |
| trnm    | 서비스명             | String | Y        | 7      | CNSRCLR 고정값  |
| seq     | 조건검색식 일련번호  | String | Y        |        |                 |

#### 응답 Body

| Element     | 한글명               | Type   | Required | Length | Description                |
| ----------- | -------------------- | ------ | -------- | ------ | -------------------------- |
| return_code | 결과코드             | int    | Y        |        | 정상:0 나머지:에러         |
| return_msg  | 결과메시지           | String | Y        |        | 정상인 경우는 메시지 없음  |
| trnm        | 서비스명             | String | Y        |        | CNSRCLR 고정값             |
| seq         | 조건검색식 일련번호  | String | Y        |        |                            |

#### 요청 예시

```json
{
	"trnm": "CNSRCLR",
	"seq": "1"
}
```

#### 응답 예시

```json
{
	"trnm": "CNSRCLR",
	"seq": "1",
	"return_code": 0,
	"return_msg": ""
}
```

---
