# 키움증권 API 문서

## 국내주식 REST API

### 종목정보

#### TR 목록

| TR명                       | 코드    | 설명                       |
| -------------------------- | ------- | -------------------------- |
| 주식기본정보요청           | ka10001 | 주식기본정보요청           |
| 주식거래원요청             | ka10002 | 주식거래원요청             |
| 체결정보요청               | ka10003 | 체결정보요청               |
| 신용매매동향요청           | ka10013 | 신용매매동향요청           |
| 일별거래상세요청           | ka10015 | 일별거래상세요청           |
| 신고저가요청               | ka10016 | 신고저가요청               |
| 상하한가요청               | ka10017 | 상하한가요청               |
| 고저가근접요청             | ka10018 | 고저가근접요청             |
| 가격급등락요청             | ka10019 | 가격급등락요청             |
| 거래량갱신요청             | ka10024 | 거래량갱신요청             |
| 매물대집중요청             | ka10025 | 매물대집중요청             |
| 고저PER요청                | ka10026 | 고저PER요청                |
| 시가대비등락률요청         | ka10028 | 시가대비등락률요청         |
| 거래원매물대분석요청       | ka10043 | 거래원매물대분석요청       |
| 거래원순간거래량요청       | ka10052 | 거래원순간거래량요청       |
| 변동성완화장치발동종목요청 | ka10054 | 변동성완화장치발동종목요청 |
| 당일전일체결량요청         | ka10055 | 당일전일체결량요청         |
| 투자자별일별매매종목요청   | ka10058 | 투자자별일별매매종목요청   |
| 종목별투자자기관별요청     | ka10059 | 종목별투자자기관별요청     |
| 종목별투자자기관별합계요청 | ka10061 | 종목별투자자기관별합계요청 |
| 당일전일체결요청           | ka10084 | 당일전일체결요청           |
| 관심종목정보요청           | ka10095 | 관심종목정보요청           |
| 종목정보 리스트            | ka10099 | 종목정보 리스트            |
| 종목정보 조회              | ka10100 | 종목정보 조회              |
| 업종코드 리스트            | ka10101 | 업종코드 리스트            |
| 회원사 리스트              | ka10102 | 회원사 리스트              |
| 프로그램순매수상위50요청   | ka90003 | 프로그램순매수상위50요청   |
| 종목별프로그램매매현황요청 | ka90004 | 종목별프로그램매매현황요청 |

---

### 주식기본정보요청 (ka10001)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                    |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element             | 한글명          | Type   | Required | Length | Description                                                                                                  |
| ------------------- | --------------- | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------------ |
| stk_cd              | 종목코드        | String | N        | 20     |                                                                                                              |
| stk_nm              | 종목명          | String | N        | 20     |                                                                                                              |
| setl_mm             | 결산월          | String | N        | 20     |                                                                                                              |
| fav                 | 액면가          | String | N        | 20     |                                                                                                              |
| cap                 | 자본금          | String | N        | 20     |                                                                                                              |
| flo_stk             | 상장주식        | String | N        | 20     |                                                                                                              |
| crd_rt              | 신용비율        | String | N        | 20     |                                                                                                              |
| oyr_hgst            | 연중최고        | String | N        | 20     |                                                                                                              |
| oyr_lwst            | 연중최저        | String | N        | 20     |                                                                                                              |
| mac                 | 시가총액        | String | N        | 20     |                                                                                                              |
| mac_wght            | 시가총액비중    | String | N        | 20     |                                                                                                              |
| for_exh_rt          | 외인소진률      | String | N        | 20     |                                                                                                              |
| repl_pric           | 대용가          | String | N        | 20     |                                                                                                              |
| per                 | PER             | String | N        | 20     | **[주의]** PER, ROE 값들은 외부벤더사에서 제공되는 데이터이며 일주일에 한번 또는 실적발표 시즌에 업데이트 됨 |
| eps                 | EPS             | String | N        | 20     |                                                                                                              |
| roe                 | ROE             | String | N        | 20     | **[주의]** PER, ROE 값들은 외부벤더사에서 제공되는 데이터이며 일주일에 한번 또는 실적발표 시즌에 업데이트 됨 |
| pbr                 | PBR             | String | N        | 20     |                                                                                                              |
| ev                  | EV              | String | N        | 20     |                                                                                                              |
| bps                 | BPS             | String | N        | 20     |                                                                                                              |
| sale_amt            | 매출액          | String | N        | 20     |                                                                                                              |
| bus_pro             | 영업이익        | String | N        | 20     |                                                                                                              |
| cup_nga             | 당기순이익      | String | N        | 20     |                                                                                                              |
| 250hgst             | 250최고         | String | N        | 20     |                                                                                                              |
| 250lwst             | 250최저         | String | N        | 20     |                                                                                                              |
| high_pric           | 고가            | String | N        | 20     |                                                                                                              |
| open_pric           | 시가            | String | N        | 20     |                                                                                                              |
| low_pric            | 저가            | String | N        | 20     |                                                                                                              |
| upl_pric            | 상한가          | String | N        | 20     |                                                                                                              |
| lst_pric            | 하한가          | String | N        | 20     |                                                                                                              |
| base_pric           | 기준가          | String | N        | 20     |                                                                                                              |
| exp_cntr_pric       | 예상체결가      | String | N        | 20     |                                                                                                              |
| exp_cntr_qty        | 예상체결수량    | String | N        | 20     |                                                                                                              |
| 250hgst_pric_dt     | 250최고가일     | String | N        | 20     |                                                                                                              |
| 250hgst_pric_pre_rt | 250최고가대비율 | String | N        | 20     |                                                                                                              |
| 250lwst_pric_dt     | 250최저가일     | String | N        | 20     |                                                                                                              |
| 250lwst_pric_pre_rt | 250최저가대비율 | String | N        | 20     |                                                                                                              |
| cur_prc             | 현재가          | String | N        | 20     |                                                                                                              |
| pre_sig             | 대비기호        | String | N        | 20     |                                                                                                              |
| pred_pre            | 전일대비        | String | N        | 20     |                                                                                                              |
| flu_rt              | 등락율          | String | N        | 20     |                                                                                                              |
| trde_qty            | 거래량          | String | N        | 20     |                                                                                                              |
| trde_pre            | 거래대비        | String | N        | 20     |                                                                                                              |
| fav_unit            | 액면가단위      | String | N        | 20     |                                                                                                              |
| dstr_stk            | 유통주식        | String | N        | 20     |                                                                                                              |
| dstr_rt             | 유통비율        | String | N        | 20     |                                                                                                              |

#### 요청 예시

```json
{
  "stk_cd": "005930"
}
```

#### 응답 예시

```json
{
  "stk_cd": "005930",
  "stk_nm": "삼성전자",
  "setl_mm": "12",
  "fav": "5000",
  "cap": "1311",
  "flo_stk": "25527",
  "crd_rt": "+0.08",
  "oyr_hgst": "+181400",
  "oyr_lwst": "-91200",
  "mac": "24352",
  "mac_wght": "",
  "for_exh_rt": "0.00",
  "repl_pric": "66780",
  "per": "",
  "eps": "",
  "roe": "",
  "pbr": "",
  "ev": "",
  "bps": "-75300",
  "sale_amt": "0",
  "bus_pro": "0",
  "cup_nga": "0",
  "250hgst": "+124000",
  "250lwst": "-66800",
  "high_pric": "95400",
  "open_pric": "-0",
  "low_pric": "0",
  "upl_pric": "20241016",
  "lst_pric": "-47.41",
  "base_pric": "20231024",
  "exp_cntr_pric": "+26.69",
  "exp_cntr_qty": "95400",
  "250hgst_pric_dt": "3",
  "250hgst_pric_pre_rt": "0",
  "250lwst_pric_dt": "0.00",
  "250lwst_pric_pre_rt": "0",
  "cur_prc": "0.00",
  "pre_sig": "",
  "pred_pre": "",
  "flu_rt": "0",
  "trde_qty": "0",
  "trde_pre": "0",
  "fav_unit": "0",
  "dstr_stk": "0",
  "dstr_rt": "0",
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식거래원요청 (ka10002)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                    |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element           | 한글명        | Type   | Required | Length | Description |
| ----------------- | ------------- | ------ | -------- | ------ | ----------- |
| stk_cd            | 종목코드      | String | N        | 20     |             |
| stk_nm            | 종목명        | String | N        | 20     |             |
| cur_prc           | 현재가        | String | N        | 20     |             |
| flu_smbol         | 등락부호      | String | N        | 20     |             |
| base_pric         | 기준가        | String | N        | 20     |             |
| pred_pre          | 전일대비      | String | N        | 20     |             |
| flu_rt            | 등락율        | String | N        | 20     |             |
| sel_trde_ori_nm_1 | 매도거래원명1 | String | N        | 20     |             |
| sel_trde_ori_1    | 매도거래원1   | String | N        | 20     |             |
| sel_trde_qty_1    | 매도거래량1   | String | N        | 20     |             |
| buy_trde_ori_nm_1 | 매수거래원명1 | String | N        | 20     |             |
| buy_trde_ori_1    | 매수거래원1   | String | N        | 20     |             |
| buy_trde_qty_1    | 매수거래량1   | String | N        | 20     |             |
| sel_trde_ori_nm_2 | 매도거래원명2 | String | N        | 20     |             |
| sel_trde_ori_2    | 매도거래원2   | String | N        | 20     |             |
| sel_trde_qty_2    | 매도거래량2   | String | N        | 20     |             |
| buy_trde_ori_nm_2 | 매수거래원명2 | String | N        | 20     |             |
| buy_trde_ori_2    | 매수거래원2   | String | N        | 20     |             |
| buy_trde_qty_2    | 매수거래량2   | String | N        | 20     |             |
| sel_trde_ori_nm_3 | 매도거래원명3 | String | N        | 20     |             |
| sel_trde_ori_3    | 매도거래원3   | String | N        | 20     |             |
| sel_trde_qty_3    | 매도거래량3   | String | N        | 20     |             |
| buy_trde_ori_nm_3 | 매수거래원명3 | String | N        | 20     |             |
| buy_trde_ori_3    | 매수거래원3   | String | N        | 20     |             |
| buy_trde_qty_3    | 매수거래량3   | String | N        | 20     |             |
| sel_trde_ori_nm_4 | 매도거래원명4 | String | N        | 20     |             |
| sel_trde_ori_4    | 매도거래원4   | String | N        | 20     |             |
| sel_trde_qty_4    | 매도거래량4   | String | N        | 20     |             |
| buy_trde_ori_nm_4 | 매수거래원명4 | String | N        | 20     |             |
| buy_trde_ori_4    | 매수거래원4   | String | N        | 20     |             |
| buy_trde_qty_4    | 매수거래량4   | String | N        | 20     |             |
| sel_trde_ori_nm_5 | 매도거래원명5 | String | N        | 20     |             |
| sel_trde_ori_5    | 매도거래원5   | String | N        | 20     |             |
| sel_trde_qty_5    | 매도거래량5   | String | N        | 20     |             |
| buy_trde_ori_nm_5 | 매수거래원명5 | String | N        | 20     |             |
| buy_trde_ori_5    | 매수거래원5   | String | N        | 20     |             |
| buy_trde_qty_5    | 매수거래량5   | String | N        | 20     |             |

#### 요청 예시

```json
{
  "stk_cd": "005930"
}
```

#### 응답 예시

```json
{
  "stk_cd": "005930",
  "stk_nm": "삼성전자",
  "cur_prc": "95400",
  "flu_smbol": "3",
  "base_pric": "95400",
  "pred_pre": "0",
  "flu_rt": "0.00",
  "sel_trde_ori_nm_1": "",
  "sel_trde_ori_1": "000",
  "sel_trde_qty_1": "0",
  "buy_trde_ori_nm_1": "",
  "buy_trde_ori_1": "000",
  "buy_trde_qty_1": "0",
  "sel_trde_ori_nm_2": "",
  "sel_trde_ori_2": "000",
  "sel_trde_qty_2": "0",
  "buy_trde_ori_nm_2": "",
  "buy_trde_ori_2": "000",
  "buy_trde_qty_2": "0",
  "sel_trde_ori_nm_3": "",
  "sel_trde_ori_3": "000",
  "sel_trde_qty_3": "0",
  "buy_trde_ori_nm_3": "",
  "buy_trde_ori_3": "000",
  "buy_trde_qty_3": "0",
  "sel_trde_ori_nm_4": "",
  "sel_trde_ori_4": "000",
  "sel_trde_qty_4": "0",
  "buy_trde_ori_nm_4": "",
  "buy_trde_ori_4": "000",
  "buy_trde_qty_4": "0",
  "sel_trde_ori_nm_5": "",
  "sel_trde_ori_5": "000",
  "sel_trde_qty_5": "0",
  "buy_trde_ori_nm_5": "",
  "buy_trde_ori_5": "000",
  "buy_trde_qty_5": "0",
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 체결정보요청 (ka10003)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                    |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element            | 한글명           | Type   | Required | Length | Description    |
| ------------------ | ---------------- | ------ | -------- | ------ | -------------- |
| cntr_infr          | 체결정보         | LIST   | N        |        |                |
| - tm               | 시간             | String | N        | 20     |                |
| - cur_prc          | 현재가           | String | N        | 20     |                |
| - pred_pre         | 전일대비         | String | N        | 20     |                |
| - pre_rt           | 대비율           | String | N        | 20     |                |
| - pri_sel_bid_unit | 우선매도호가단위 | String | N        | 20     |                |
| - pri_buy_bid_unit | 우선매수호가단위 | String | N        | 20     |                |
| - cntr_trde_qty    | 체결거래량       | String | N        | 20     |                |
| - sign             | sign             | String | N        | 20     |                |
| - acc_trde_qty     | 누적거래량       | String | N        | 20     |                |
| - acc_trde_prica   | 누적거래대금     | String | N        | 20     |                |
| - cntr_str         | 체결강도         | String | N        | 20     |                |
| - stex_tp          | 거래소구분       | String | N        | 20     | KRX, NXT, 통합 |

#### 요청 예시

```json
{
  "stk_cd": "005930"
}
```

#### 응답 예시

```json
{
  "cntr_infr": [
    {
      "tm": "130429",
      "cur_prc": "+53500",
      "pred_pre": "+500",
      "pre_rt": "+0.94",
      "pri_sel_bid_unit": "+68900",
      "pri_buy_bid_unit": "+53500",
      "cntr_trde_qty": "1010",
      "sign": "2",
      "acc_trde_qty": "8735",
      "acc_trde_prica": "524269500",
      "cntr_str": "12.99",
      "stex_tp": "KRX"
    },
    {
      "tm": "130153",
      "cur_prc": "+68900",
      "pred_pre": "+15900",
      "pre_rt": "+30.00",
      "pri_sel_bid_unit": "+68900",
      "pri_buy_bid_unit": "+55000",
      "cntr_trde_qty": "456",
      "sign": "1",
      "acc_trde_qty": "7725",
      "acc_trde_prica": "470234500",
      "cntr_str": "12.99",
      "stex_tp": "KRX"
    },
    {
      "tm": "125947",
      "cur_prc": "+55000",
      "pred_pre": "+2000",
      "pre_rt": "+3.77",
      "pri_sel_bid_unit": "+68900",
      "pri_buy_bid_unit": "+55000",
      "cntr_trde_qty": "1000",
      "sign": "2",
      "acc_trde_qty": "7269",
      "acc_trde_prica": "438816100",
      "cntr_str": "12.99",
      "stex_tp": "KRX"
    },
    {
      "tm": "125153",
      "cur_prc": "+68900",
      "pred_pre": "+15900",
      "pre_rt": "+30.00",
      "pri_sel_bid_unit": "+68900",
      "pri_buy_bid_unit": "+60100",
      "cntr_trde_qty": "2",
      "sign": "1",
      "acc_trde_qty": "6269",
      "acc_trde_prica": "383816100",
      "cntr_str": "12.99",
      "stex_tp": "KRX"
    },
    {
      "tm": "124721",
      "cur_prc": "+68900",
      "pred_pre": "+15900",
      "pre_rt": "+30.00",
      "pri_sel_bid_unit": "+68900",
      "pri_buy_bid_unit": "+60100",
      "cntr_trde_qty": "2",
      "sign": "1",
      "acc_trde_qty": "6267",
      "acc_trde_prica": "383678300",
      "cntr_str": "12.99",
      "stex_tp": "KRX"
    },
    {
      "tm": "124507",
      "cur_prc": "+67100",
      "pred_pre": "+14100",
      "pre_rt": "+26.60",
      "pri_sel_bid_unit": "+68900",
      "pri_buy_bid_unit": "+67500",
      "cntr_trde_qty": "-5",
      "sign": "2",
      "acc_trde_qty": "6265",
      "acc_trde_prica": "383540500",
      "cntr_str": "12.99",
      "stex_tp": "KRX"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 신용매매동향요청 (ka10013)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                    |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| dt      | 일자     | String | Y        | 8      | YYYYMMDD                                                       |
| qry_tp  | 조회구분 | String | Y        | 1      | 1:융자, 2:대주                                                 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| crd_trde_trend | 신용매매동향 | LIST   | N        |        |             |
| - dt           | 일자         | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - trde_qty     | 거래량       | String | N        | 20     |             |
| - new          | 신규         | String | N        | 20     |             |
| - rpya         | 상환         | String | N        | 20     |             |
| - remn         | 잔고         | String | N        | 20     |             |
| - amt          | 금액         | String | N        | 20     |             |
| - pre          | 대비         | String | N        | 20     |             |
| - shr_rt       | 공여율       | String | N        | 20     |             |
| - remn_rt      | 잔고율       | String | N        | 20     |             |

#### 요청 예시

```json
{
  "stk_cd": "005930",
  "dt": "20241104",
  "qry_tp": "1"
}
```

#### 응답 예시

```json
{
  "crd_trde_trend": [
    {
      "dt": "20241101",
      "cur_prc": "65100",
      "pred_pre_sig": "0",
      "pred_pre": "0",
      "trde_qty": "0",
      "new": "",
      "rpya": "",
      "remn": "",
      "amt": "",
      "pre": "",
      "shr_rt": "",
      "remn_rt": ""
    },
    {
      "dt": "20241031",
      "cur_prc": "65100",
      "pred_pre_sig": "0",
      "pred_pre": "0",
      "trde_qty": "0",
      "new": "",
      "rpya": "",
      "remn": "",
      "amt": "",
      "pre": "",
      "shr_rt": "",
      "remn_rt": ""
    },
    {
      "dt": "20241030",
      "cur_prc": "+65100",
      "pred_pre_sig": "2",
      "pred_pre": "+100",
      "trde_qty": "1",
      "new": "",
      "rpya": "",
      "remn": "",
      "amt": "",
      "pre": "",
      "shr_rt": "",
      "remn_rt": ""
    },
    {
      "dt": "20241029",
      "cur_prc": "-65000",
      "pred_pre_sig": "5",
      "pred_pre": "-27300",
      "trde_qty": "4",
      "new": "",
      "rpya": "",
      "remn": "",
      "amt": "",
      "pre": "",
      "shr_rt": "",
      "remn_rt": ""
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 일별거래상세요청 (ka10015)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                    |
| ------- | -------- | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| strt_dt | 시작일자 | String | Y        | 8      | YYYYMMDD                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                   | 한글명           | Type   | Required | Length | Description |
| ------------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| daly_trde_dtl             | 일별거래상세     | LIST   | N        |        |             |
| - dt                      | 일자             | String | N        | 20     |             |
| - close_pric              | 종가             | String | N        | 20     |             |
| - pred_pre_sig            | 전일대비기호     | String | N        | 20     |             |
| - pred_pre                | 전일대비         | String | N        | 20     |             |
| - flu_rt                  | 등락율           | String | N        | 20     |             |
| - trde_qty                | 거래량           | String | N        | 20     |             |
| - trde_prica              | 거래대금         | String | N        | 20     |             |
| - bf_mkrt_trde_qty        | 장전거래량       | String | N        | 20     |             |
| - bf_mkrt_trde_wght       | 장전거래비중     | String | N        | 20     |             |
| - opmr_trde_qty           | 장중거래량       | String | N        | 20     |             |
| - opmr_trde_wght          | 장중거래비중     | String | N        | 20     |             |
| - af_mkrt_trde_qty        | 장후거래량       | String | N        | 20     |             |
| - af_mkrt_trde_wght       | 장후거래비중     | String | N        | 20     |             |
| - tot_3                   | 합계3            | String | N        | 20     |             |
| - prid_trde_qty           | 기간중거래량     | String | N        | 20     |             |
| - cntr_str                | 체결강도         | String | N        | 20     |             |
| - for_poss                | 외인보유         | String | N        | 20     |             |
| - for_wght                | 외인비중         | String | N        | 20     |             |
| - for_netprps             | 외인순매수       | String | N        | 20     |             |
| - orgn_netprps            | 기관순매수       | String | N        | 20     |             |
| - ind_netprps             | 개인순매수       | String | N        | 20     |             |
| - frgn                    | 외국계           | String | N        | 20     |             |
| - crd_remn_rt             | 신용잔고율       | String | N        | 20     |             |
| - prm                     | 프로그램         | String | N        | 20     |             |
| - bf_mkrt_trde_prica      | 장전거래대금     | String | N        | 20     |             |
| - bf_mkrt_trde_prica_wght | 장전거래대금비중 | String | N        | 20     |             |
| - opmr_trde_prica         | 장중거래대금     | String | N        | 20     |             |
| - opmr_trde_prica_wght    | 장중거래대금비중 | String | N        | 20     |             |
| - af_mkrt_trde_prica      | 장후거래대금     | String | N        | 20     |             |
| - af_mkrt_trde_prica_wght | 장후거래대금비중 | String | N        | 20     |             |

#### 요청 예시

```json
{
  "stk_cd": "005930",
  "strt_dt": "20241105"
}
```

#### 응답 예시

```json
{
  "daly_trde_dtl": [
    {
      "dt": "20241105",
      "close_pric": "135300",
      "pred_pre_sig": "0",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "trde_qty": "0",
      "trde_prica": "0",
      "bf_mkrt_trde_qty": "",
      "bf_mkrt_trde_wght": "",
      "opmr_trde_qty": "",
      "opmr_trde_wght": "",
      "af_mkrt_trde_qty": "",
      "af_mkrt_trde_wght": "",
      "tot_3": "0",
      "prid_trde_qty": "0",
      "cntr_str": "",
      "for_poss": "",
      "for_wght": "",
      "for_netprps": "",
      "orgn_netprps": "",
      "ind_netprps": "",
      "frgn": "",
      "crd_remn_rt": "",
      "prm": "",
      "bf_mkrt_trde_prica": "",
      "bf_mkrt_trde_prica_wght": "",
      "opmr_trde_prica": "",
      "opmr_trde_prica_wght": "",
      "af_mkrt_trde_prica": "",
      "af_mkrt_trde_prica_wght": ""
    },
    {
      "dt": "20241101",
      "close_pric": "65100",
      "pred_pre_sig": "0",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "trde_qty": "0",
      "trde_prica": "0",
      "bf_mkrt_trde_qty": "",
      "bf_mkrt_trde_wght": "",
      "opmr_trde_qty": "",
      "opmr_trde_wght": "",
      "af_mkrt_trde_qty": "",
      "af_mkrt_trde_wght": "",
      "tot_3": "0",
      "prid_trde_qty": "0",
      "cntr_str": "",
      "for_poss": "",
      "for_wght": "",
      "for_netprps": "",
      "orgn_netprps": "",
      "ind_netprps": "",
      "frgn": "",
      "crd_remn_rt": "",
      "prm": "",
      "bf_mkrt_trde_prica": "",
      "bf_mkrt_trde_prica_wght": "",
      "opmr_trde_prica": "",
      "opmr_trde_prica_wght": "",
      "af_mkrt_trde_prica": "",
      "af_mkrt_trde_prica_wght": ""
    },
    {
      "dt": "20241031",
      "close_pric": "65100",
      "pred_pre_sig": "0",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "trde_qty": "0",
      "trde_prica": "0",
      "bf_mkrt_trde_qty": "",
      "bf_mkrt_trde_wght": "",
      "opmr_trde_qty": "",
      "opmr_trde_wght": "",
      "af_mkrt_trde_qty": "",
      "af_mkrt_trde_wght": "",
      "tot_3": "0",
      "prid_trde_qty": "0",
      "cntr_str": "",
      "for_poss": "",
      "for_wght": "",
      "for_netprps": "",
      "orgn_netprps": "",
      "ind_netprps": "",
      "frgn": "",
      "crd_remn_rt": "",
      "prm": "",
      "bf_mkrt_trde_prica": "",
      "bf_mkrt_trde_prica_wght": "",
      "opmr_trde_prica": "",
      "opmr_trde_prica_wght": "",
      "af_mkrt_trde_prica": "",
      "af_mkrt_trde_prica_wght": ""
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 신고저가요청 (ka10016)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element           | 한글명     | Type   | Required | Length | Description                                                                                                                                                 |
| ----------------- | ---------- | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp           | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                            |
| ntl_tp            | 신고저구분 | String | Y        | 1      | 1:신고가, 2:신저가                                                                                                                                          |
| high_low_close_tp | 고저종구분 | String | Y        | 1      | 1:고저기준, 2:종가기준                                                                                                                                      |
| stk_cnd           | 종목조건   | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 3:우선주제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기                                                            |
| trde_qty_tp       | 거래량구분 | String | Y        | 5      | 00000:전체조회, 00010:만주이상, 00050:5만주이상, 00100:10만주이상, 00150:15만주이상, 00200:20만주이상, 00300:30만주이상, 00500:50만주이상, 01000:백만주이상 |
| crd_cnd           | 신용조건   | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                                      |
| updown_incls      | 상하한포함 | String | Y        | 1      | 0:미포함, 1:포함                                                                                                                                            |
| dt                | 기간       | String | Y        | 3      | 5:5일, 10:10일, 20:20일, 60:60일, 250:250일, 250일까지 입력가능                                                                                             |
| stex_tp           | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                        |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| ntl_pric               | 신고저가         | LIST   | N        |        |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - cur_prc              | 현재가           | String | N        | 20     |             |
| - pred_pre_sig         | 전일대비기호     | String | N        | 20     |             |
| - pred_pre             | 전일대비         | String | N        | 20     |             |
| - flu_rt               | 등락률           | String | N        | 20     |             |
| - trde_qty             | 거래량           | String | N        | 20     |             |
| - pred_trde_qty_pre_rt | 전일거래량대비율 | String | N        | 20     |             |
| - sel_bid              | 매도호가         | String | N        | 20     |             |
| - buy_bid              | 매수호가         | String | N        | 20     |             |
| - high_pric            | 고가             | String | N        | 20     |             |
| - low_pric             | 저가             | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mrkt_tp": "000",
  "ntl_tp": "1",
  "high_low_close_tp": "1",
  "stk_cnd": "0",
  "trde_qty_tp": "00000",
  "crd_cnd": "0",
  "updown_incls": "0",
  "dt": "5",
  "stex_tp": "1"
}
```

#### 응답 예시

```json
{
  "ntl_pric": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "334",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "trde_qty": "3",
      "pred_trde_qty_pre_rt": "-0.00",
      "sel_bid": "0",
      "buy_bid": "0",
      "high_pric": "334",
      "low_pric": "320"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-6230",
      "pred_pre_sig": "5",
      "pred_pre": "-60",
      "flu_rt": "-0.95",
      "trde_qty": "77",
      "pred_trde_qty_pre_rt": "-6.16",
      "sel_bid": "+6300",
      "buy_bid": "-6270",
      "high_pric": "6340",
      "low_pric": "6150"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-140000",
      "pred_pre_sig": "5",
      "pred_pre": "-800",
      "flu_rt": "-0.57",
      "trde_qty": "7",
      "pred_trde_qty_pre_rt": "-0.00",
      "sel_bid": "-140000",
      "buy_bid": "0",
      "high_pric": "140800",
      "low_pric": "70000"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+214000",
      "pred_pre_sig": "2",
      "pred_pre": "+20900",
      "flu_rt": "+10.82",
      "trde_qty": "45",
      "pred_trde_qty_pre_rt": "-0.05",
      "sel_bid": "0",
      "buy_bid": "+214000",
      "high_pric": "214000",
      "low_pric": "89800"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-89000",
      "pred_pre_sig": "5",
      "pred_pre": "-8400",
      "flu_rt": "-8.62",
      "trde_qty": "130",
      "pred_trde_qty_pre_rt": "-0.01",
      "sel_bid": "0",
      "buy_bid": "-89000",
      "high_pric": "97500",
      "low_pric": "58800"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+40300",
      "pred_pre_sig": "2",
      "pred_pre": "+1150",
      "flu_rt": "+2.94",
      "trde_qty": "86",
      "pred_trde_qty_pre_rt": "-0.13",
      "sel_bid": "+40550",
      "buy_bid": "+40300",
      "high_pric": "40300",
      "low_pric": "14000"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-190000",
      "pred_pre_sig": "5",
      "pred_pre": "-4000",
      "flu_rt": "-2.06",
      "trde_qty": "137",
      "pred_trde_qty_pre_rt": "-0.00",
      "sel_bid": "0",
      "buy_bid": "-182000",
      "high_pric": "195000",
      "low_pric": "67300"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 상하한가요청 (ka10017)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명     | Type   | Required | Length | Description                                                                                                                                                                |
| ------------ | ---------- | ------ | -------- | ------ | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp      | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                           |
| updown_tp    | 상하한구분 | String | Y        | 1      | 1:상한, 2:상승, 3:보합, 4:하한, 5:하락, 6:전일상한, 7:전일하한                                                                                                             |
| sort_tp      | 정렬구분   | String | Y        | 1      | 1:종목코드순, 2:연속횟수순(상위100개), 3:등락률순                                                                                                                          |
| stk_cnd      | 종목조건   | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 3:우선주제외, 4:우선주+관리종목제외, 5:증100제외, 6:증100만 보기, 7:증40만 보기, 8:증30만 보기, 9:증20만 보기, 10:우선주+관리종목+환기종목제외 |
| trde_qty_tp  | 거래량구분 | String | Y        | 5      | 00000:전체조회, 00010:만주이상, 00050:5만주이상, 00100:10만주이상, 00150:15만주이상, 00200:20만주이상, 00300:30만주이상, 00500:50만주이상, 01000:백만주이상                |
| crd_cnd      | 신용조건   | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                                                     |
| trde_gold_tp | 매매금구분 | String | Y        | 1      | 0:전체조회, 1:1천원미만, 2:1천원~2천원, 3:2천원~3천원, 4:5천원~1만원, 5:1만원이상, 8:1천원이상                                                                             |
| stex_tp      | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element         | 한글명       | Type   | Required | Length | Description |
| --------------- | ------------ | ------ | -------- | ------ | ----------- |
| updown_pric     | 상하한가     | LIST   | N        |        |             |
| - stk_cd        | 종목코드     | String | N        | 20     |             |
| - stk_infr      | 종목정보     | String | N        | 20     |             |
| - stk_nm        | 종목명       | String | N        | 20     |             |
| - cur_prc       | 현재가       | String | N        | 20     |             |
| - pred_pre_sig  | 전일대비기호 | String | N        | 20     |             |
| - pred_pre      | 전일대비     | String | N        | 20     |             |
| - flu_rt        | 등락률       | String | N        | 20     |             |
| - trde_qty      | 거래량       | String | N        | 20     |             |
| - pred_trde_qty | 전일거래량   | String | N        | 20     |             |
| - sel_req       | 매도잔량     | String | N        | 20     |             |
| - sel_bid       | 매도호가     | String | N        | 20     |             |
| - buy_bid       | 매수호가     | String | N        | 20     |             |
| - buy_req       | 매수잔량     | String | N        | 20     |             |
| - cnt           | 횟수         | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mrkt_tp": "000",
  "updown_tp": "1",
  "sort_tp": "1",
  "stk_cnd": "0",
  "trde_qty_tp": "0000",
  "crd_cnd": "0",
  "trde_gold_tp": "0",
  "stex_tp": "1"
}
```

#### 응답 예시

```json
{
  "updown_pric": [
    {
      "stk_cd": "005930",
      "stk_infr": "",
      "stk_nm": "삼성전자",
      "cur_prc": "+235500",
      "pred_pre_sig": "1",
      "pred_pre": "+54200",
      "flu_rt": "+29.90",
      "trde_qty": "0",
      "pred_trde_qty": "96197",
      "sel_req": "0",
      "sel_bid": "0",
      "buy_bid": "+235500",
      "buy_req": "4",
      "cnt": "1"
    },
    {
      "stk_cd": "005930",
      "stk_infr": "",
      "stk_nm": "삼성전자",
      "cur_prc": "+13715",
      "pred_pre_sig": "1",
      "pred_pre": "+3165",
      "flu_rt": "+30.00",
      "trde_qty": "0",
      "pred_trde_qty": "929670",
      "sel_req": "0",
      "sel_bid": "0",
      "buy_bid": "+13715",
      "buy_req": "4",
      "cnt": "1"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 고저가근접요청 (ka10018)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명     | Type   | Required | Length | Description                                                                                                                                                 |
| ----------- | ---------- | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------- |
| high_low_tp | 고저구분   | String | Y        | 1      | 1:고가, 2:저가                                                                                                                                              |
| alacc_rt    | 근접율     | String | Y        | 2      | 05:0.5, 10:1.0, 15:1.5, 20:2.0, 25:2.5, 30:3.0                                                                                                              |
| mrkt_tp     | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                            |
| trde_qty_tp | 거래량구분 | String | Y        | 5      | 00000:전체조회, 00010:만주이상, 00050:5만주이상, 00100:10만주이상, 00150:15만주이상, 00200:20만주이상, 00300:30만주이상, 00500:50만주이상, 01000:백만주이상 |
| stk_cnd     | 종목조건   | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 3:우선주제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기                                                            |
| crd_cnd     | 신용조건   | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                                      |
| stex_tp     | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                        |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element             | 한글명       | Type   | Required | Length | Description |
| ------------------- | ------------ | ------ | -------- | ------ | ----------- |
| high_low_pric_alacc | 고저가근접   | LIST   | N        |        |             |
| - stk_cd            | 종목코드     | String | N        | 20     |             |
| - stk_nm            | 종목명       | String | N        | 20     |             |
| - cur_prc           | 현재가       | String | N        | 20     |             |
| - pred_pre_sig      | 전일대비기호 | String | N        | 20     |             |
| - pred_pre          | 전일대비     | String | N        | 20     |             |
| - flu_rt            | 등락율       | String | N        | 20     |             |
| - flu_rt            | 등락률       | String | N        | 20     |             |
| - trde_qty          | 거래량       | String | N        | 20     |             |
| - sel_bid           | 매도호가     | String | N        | 20     |             |
| - buy_bid           | 매수호가     | String | N        | 20     |             |
| - tdy_high_pric     | 당일고가     | String | N        | 20     |             |
| - tdy_low_pric      | 당일저가     | String | N        | 20     |             |

#### 요청 예시

```json
{
  "high_low_tp": "1",
  "alacc_rt": "05",
  "mrkt_tp": "000",
  "trde_qty_tp": "0000",
  "stk_cnd": "0",
  "crd_cnd": "0",
  "stex_tp": "1"
}
```

#### 응답 예시

```json
{
  "high_low_pric_alacc": [
    {
      "stk_cd": "004930",
      "stk_nm": "삼성전자",
      "cur_prc": "334",
      "pred_pre_sig": "0",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "trde_qty": "3",
      "sel_bid": "0",
      "buy_bid": "0",
      "tdy_high_pric": "334",
      "tdy_low_pric": "334"
    },
    {
      "stk_cd": "004930",
      "stk_nm": "삼성전자",
      "cur_prc": "+7470",
      "pred_pre_sig": "2",
      "pred_pre": "+90",
      "flu_rt": "+1.22",
      "trde_qty": "2",
      "sel_bid": "0",
      "buy_bid": "-7320",
      "tdy_high_pric": "+7470",
      "tdy_low_pric": "+7470"
    },
    {
      "stk_cd": "004930",
      "stk_nm": "삼성전자",
      "cur_prc": "+214000",
      "pred_pre_sig": "60",
      "pred_pre": "+20900",
      "flu_rt": "+10.82",
      "trde_qty": "45",
      "sel_bid": "0",
      "buy_bid": "+214000",
      "tdy_high_pric": "+214000",
      "tdy_low_pric": "193100"
    },
    {
      "stk_cd": "004930",
      "stk_nm": "삼성전자",
      "cur_prc": "+40300",
      "pred_pre_sig": "114",
      "pred_pre": "+1150",
      "flu_rt": "+2.94",
      "trde_qty": "86",
      "sel_bid": "+40550",
      "buy_bid": "+40300",
      "tdy_high_pric": "+40300",
      "tdy_low_pric": "39150"
    },
    {
      "stk_cd": "004930",
      "stk_nm": "삼성전자",
      "cur_prc": "-10060",
      "pred_pre_sig": "0",
      "pred_pre": "-1790",
      "flu_rt": "-15.11",
      "trde_qty": "1",
      "sel_bid": "-10060",
      "buy_bid": "0",
      "tdy_high_pric": "-10060",
      "tdy_low_pric": "-10060"
    },
    {
      "stk_cd": "008370",
      "stk_nm": "원풍",
      "cur_prc": "+4970",
      "pred_pre_sig": "0",
      "pred_pre": "+15",
      "flu_rt": "+0.30",
      "trde_qty": "500",
      "sel_bid": "0",
      "buy_bid": "0",
      "tdy_high_pric": "+4970",
      "tdy_low_pric": "+4970"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 가격급등락요청 (ka10019)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명     | Type   | Required | Length | Description                                                                                                                                                 |
| ------------ | ---------- | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp      | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥, 201:코스피200                                                                                                             |
| flu_tp       | 등락구분   | String | Y        | 1      | 1:급등, 2:급락                                                                                                                                              |
| tm_tp        | 시간구분   | String | Y        | 1      | 1:분전, 2:일전                                                                                                                                              |
| tm           | 시간       | String | Y        | 2      | 분 혹은 일 입력                                                                                                                                             |
| trde_qty_tp  | 거래량구분 | String | Y        | 4      | 00000:전체조회, 00010:만주이상, 00050:5만주이상, 00100:10만주이상, 00150:15만주이상, 00200:20만주이상, 00300:30만주이상, 00500:50만주이상, 01000:백만주이상 |
| stk_cnd      | 종목조건   | String | Y        | 1      | 0:전체조회, 1:관리종목제외, 3:우선주제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기                                                            |
| crd_cnd      | 신용조건   | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                                      |
| pric_cnd     | 가격조건   | String | Y        | 1      | 0:전체조회, 1:1천원미만, 2:1천원~2천원, 3:2천원~3천원, 4:5천원~1만원, 5:1만원이상, 8:1천원이상                                                              |
| updown_incls | 상하한포함 | String | Y        | 1      | 0:미포함, 1:포함                                                                                                                                            |
| stex_tp      | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                        |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| pric_jmpflu    | 가격급등락   | LIST   | N        |        |             |
| - stk_cd       | 종목코드     | String | N        | 20     |             |
| - stk_cls      | 종목분류     | String | N        | 20     |             |
| - stk_nm       | 종목명       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - flu_rt       | 등락률       | String | N        | 20     |             |
| - base_pric    | 기준가       | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - base_pre     | 기준대비     | String | N        | 20     |             |
| - trde_qty     | 거래량       | String | N        | 20     |             |
| - jmp_rt       | 급등률       | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mrkt_tp": "000",
  "flu_tp": "1",
  "tm_tp": "1",
  "tm": "60",
  "trde_qty_tp": "0000",
  "stk_cnd": "0",
  "crd_cnd": "0",
  "pric_cnd": "0",
  "updown_incls": "1",
  "stex_tp": "1"
}
```

#### 응답 예시

```json
{
  "pric_jmpflu": [
    {
      "stk_cd": "005930",
      "stk_cls": "",
      "stk_nm": "삼성전자",
      "pred_pre_sig": "2",
      "pred_pre": "+300",
      "flu_rt": "+0.57",
      "base_pric": "51600",
      "cur_prc": "+52700",
      "base_pre": "1100",
      "trde_qty": "2400",
      "jmp_rt": "+2.13"
    },
    {
      "stk_cd": "005930",
      "stk_cls": "",
      "stk_nm": "삼성전자",
      "pred_pre_sig": "5",
      "pred_pre": "-24200",
      "flu_rt": "-26.68",
      "base_pric": "66000",
      "cur_prc": "-66500",
      "base_pre": "500",
      "trde_qty": "577",
      "jmp_rt": "+0.76"
    },
    {
      "stk_cd": "005930",
      "stk_cls": "",
      "stk_nm": "삼성전자",
      "pred_pre_sig": "2",
      "pred_pre": "+10",
      "flu_rt": "+0.06",
      "base_pric": "16370",
      "cur_prc": "+16380",
      "base_pre": "10",
      "trde_qty": "102",
      "jmp_rt": "+0.06"
    },
    {
      "stk_cd": "005930",
      "stk_cls": "",
      "stk_nm": "삼성전자",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "base_pric": "334",
      "cur_prc": "334",
      "base_pre": "0",
      "trde_qty": "3",
      "jmp_rt": "0.00"
    },
    {
      "stk_cd": "005930",
      "stk_cls": "",
      "stk_nm": "삼성전자",
      "pred_pre_sig": "2",
      "pred_pre": "+90",
      "flu_rt": "+1.22",
      "base_pric": "7470",
      "cur_prc": "+7470",
      "base_pre": "0",
      "trde_qty": "2",
      "jmp_rt": "0.00"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 거래량갱신요청 (ka10024)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element     | 한글명     | Type   | Required | Length | Description                                                                                                             |
| ----------- | ---------- | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp     | 시장구분   | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                        |
| cycle_tp    | 주기구분   | String | Y        | 1      | 5:5일, 10:10일, 20:20일, 60:60일, 250:250일                                                                             |
| trde_qty_tp | 거래량구분 | String | Y        | 1      | 5:5천주이상, 10:만주이상, 50:5만주이상, 100:10만주이상, 200:20만주이상, 300:30만주이상, 500:50만주이상, 1000:백만주이상 |
| stex_tp     | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                    |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element         | 한글명       | Type   | Required | Length | Description |
| --------------- | ------------ | ------ | -------- | ------ | ----------- |
| trde_qty_updt   | 거래량갱신   | LIST   | N        |        |             |
| - stk_cd        | 종목코드     | String | N        | 20     |             |
| - stk_nm        | 종목명       | String | N        | 20     |             |
| - cur_prc       | 현재가       | String | N        | 20     |             |
| - pred_pre_sig  | 전일대비기호 | String | N        | 20     |             |
| - pred_pre      | 전일대비     | String | N        | 20     |             |
| - flu_rt        | 등락률       | String | N        | 20     |             |
| - prev_trde_qty | 이전거래량   | String | N        | 20     |             |
| - now_trde_qty  | 현재거래량   | String | N        | 20     |             |
| - sel_bid       | 매도호가     | String | N        | 20     |             |
| - buy_bid       | 매수호가     | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mrkt_tp": "000",
  "cycle_tp": "5",
  "trde_qty_tp": "5",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "trde_qty_updt": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+74800",
      "pred_pre_sig": "1",
      "pred_pre": "+17200",
      "flu_rt": "+29.86",
      "prev_trde_qty": "243520",
      "now_trde_qty": "435771",
      "sel_bid": "0",
      "buy_bid": "+74800"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-42900",
      "pred_pre_sig": "5",
      "pred_pre": "-150",
      "flu_rt": "-0.35",
      "prev_trde_qty": "25377975",
      "now_trde_qty": "31399114",
      "sel_bid": "-42900",
      "buy_bid": "+45250"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-152000",
      "pred_pre_sig": "5",
      "pred_pre": "-100",
      "flu_rt": "-0.07",
      "prev_trde_qty": "22435675",
      "now_trde_qty": "31491771",
      "sel_bid": "-152000",
      "buy_bid": "-151900"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-65300",
      "pred_pre_sig": "5",
      "pred_pre": "-100",
      "flu_rt": "-0.15",
      "prev_trde_qty": "25114462",
      "now_trde_qty": "26395169",
      "sel_bid": "-65300",
      "buy_bid": "+74900"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 매물대집중요청 (ka10025)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element       | 한글명       | Type   | Required | Length | Description                                                    |
| ------------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| mrkt_tp       | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                               |
| prps_cnctr_rt | 매물집중비율 | String | Y        | 3      | 0~100 입력                                                     |
| cur_prc_entry | 현재가진입   | String | Y        | 1      | 0:현재가 매물대 진입 포함안함, 1:현재가 매물대 진입포함        |
| prpscnt       | 매물대수     | String | Y        | 2      | 숫자입력                                                       |
| cycle_tp      | 주기구분     | String | Y        | 2      | 50:50일, 100:100일, 150:150일, 200:200일, 250:250일, 300:300일 |
| stex_tp       | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| prps_cnctr     | 매물대집중   | LIST   | N        |        |             |
| - stk_cd       | 종목코드     | String | N        | 20     |             |
| - stk_nm       | 종목명       | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - flu_rt       | 등락률       | String | N        | 20     |             |
| - now_trde_qty | 현재거래량   | String | N        | 20     |             |
| - pric_strt    | 가격대시작   | String | N        | 20     |             |
| - pric_end     | 가격대끝     | String | N        | 20     |             |
| - prps_qty     | 매물량       | String | N        | 20     |             |
| - prps_rt      | 매물비       | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mrkt_tp": "000",
  "prps_cnctr_rt": "50",
  "cur_prc_entry": "0",
  "prpscnt": "10",
  "cycle_tp": "50",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "prps_cnctr": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "30000",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "pric_strt": "31350",
      "pric_end": "31799",
      "prps_qty": "4",
      "prps_rt": "+50.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "30000",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "pric_strt": "32700",
      "pric_end": "33149",
      "prps_qty": "4",
      "prps_rt": "+50.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "109",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "1",
      "pric_strt": "109",
      "pric_end": "326",
      "prps_qty": "8",
      "prps_rt": "+50.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "2555",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "pric_strt": "2669",
      "pric_end": "2685",
      "prps_qty": "4",
      "prps_rt": "+50.00"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 고저PER요청 (ka10026)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                                          |
| ------- | ---------- | ------ | -------- | ------ | ---------------------------------------------------- |
| pertp   | PER구분    | String | Y        | 1      | 1:저PBR, 2:고PBR, 3:저PER, 4:고PER, 5:저ROE, 6:고ROE |
| stex_tp | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element        | 한글명       | Type   | Required | Length | Description |
| -------------- | ------------ | ------ | -------- | ------ | ----------- |
| high_low_per   | 고저PER      | LIST   | N        |        |             |
| - stk_cd       | 종목코드     | String | N        | 20     |             |
| - stk_nm       | 종목명       | String | N        | 20     |             |
| - per          | PER          | String | N        | 20     |             |
| - cur_prc      | 현재가       | String | N        | 20     |             |
| - pred_pre_sig | 전일대비기호 | String | N        | 20     |             |
| - pred_pre     | 전일대비     | String | N        | 20     |             |
| - flu_rt       | 등락율       | String | N        | 20     |             |
| - now_trde_qty | 현재거래량   | String | N        | 20     |             |
| - sel_bid      | 매도호가     | String | N        | 20     |             |

#### 요청 예시

```json
{
  "pertp": "1",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "high_low_per": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "per": "0.44",
      "cur_prc": "4930",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "sel_bid": "0"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "per": "0.54",
      "cur_prc": "5980",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "sel_bid": "0"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "per": "0.71",
      "cur_prc": "3445",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "sel_bid": "0"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "per": "0.71",
      "cur_prc": "83",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "sel_bid": "0"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "per": "0.82",
      "cur_prc": "7820",
      "pred_pre_sig": "3",
      "pred_pre": "0",
      "flu_rt": "0.00",
      "now_trde_qty": "0",
      "sel_bid": "7820"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 시가대비등락률요청 (ka10028)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명       | Type   | Required | Length | Description                                                                                                                                                                              |
| -------------- | ------------ | ------ | -------- | ------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| sort_tp        | 정렬구분     | String | Y        | 1      | 1:시가, 2:고가, 3:저가, 4:기준가                                                                                                                                                         |
| trde_qty_cnd   | 거래량조건   | String | Y        | 4      | 0000:전체조회, 0010:만주이상, 0050:5만주이상, 0100:10만주이상, 0500:50만주이상, 1000:백만주이상                                                                                          |
| mrkt_tp        | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                                         |
| updown_incls   | 상하한포함   | String | Y        | 1      | 0:불 포함, 1:포함                                                                                                                                                                        |
| stk_cnd        | 종목조건     | String | Y        | 2      | 0:전체조회, 1:관리종목제외, 4:우선주+관리주제외, 3:우선주제외, 5:증100제외, 6:증100만보기, 7:증40만보기, 8:증30만보기, 9:증20만보기                                                      |
| crd_cnd        | 신용조건     | String | Y        | 1      | 0:전체조회, 1:신용융자A군, 2:신용융자B군, 3:신용융자C군, 4:신용융자D군, 9:신용융자전체                                                                                                   |
| trde_prica_cnd | 거래대금조건 | String | Y        | 4      | 0:전체조회, 3:3천만원이상, 5:5천만원이상, 10:1억원이상, 30:3억원이상, 50:5억원이상, 100:10억원이상, 300:30억원이상, 500:50억원이상, 1000:100억원이상, 3000:300억원이상, 5000:500억원이상 |
| flu_cnd        | 등락조건     | String | Y        | 1      | 1:상위, 2:하위                                                                                                                                                                           |
| stex_tp        | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                                                     |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명         | Type   | Required | Length | Description |
| -------------------- | -------------- | ------ | -------- | ------ | ----------- |
| open_pric_pre_flu_rt | 시가대비등락률 | LIST   | N        |        |             |
| - stk_cd             | 종목코드       | String | N        | 20     |             |
| - stk_nm             | 종목명         | String | N        | 20     |             |
| - cur_prc            | 현재가         | String | N        | 20     |             |
| - pred_pre_sig       | 전일대비기호   | String | N        | 20     |             |
| - pred_pre           | 전일대비       | String | N        | 20     |             |
| - flu_rt             | 등락률         | String | N        | 20     |             |
| - open_pric          | 시가           | String | N        | 20     |             |
| - high_pric          | 고가           | String | N        | 20     |             |
| - low_pric           | 저가           | String | N        | 20     |             |
| - open_pric_pre      | 시가대비       | String | N        | 20     |             |
| - now_trde_qty       | 현재거래량     | String | N        | 20     |             |
| - cntr_str           | 체결강도       | String | N        | 20     |             |

#### 요청 예시

```json
{
  "sort_tp": "1",
  "trde_qty_cnd": "0000",
  "mrkt_tp": "000",
  "updown_incls": "1",
  "stk_cnd": "0",
  "crd_cnd": "0",
  "trde_prica_cnd": "0",
  "flu_cnd": "1",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "open_pric_pre_flu_rt": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+74800",
      "pred_pre_sig": "1",
      "pred_pre": "+17200",
      "flu_rt": "+29.86",
      "open_pric": "+65000",
      "high_pric": "+74800",
      "low_pric": "-57000",
      "open_pric_pre": "+15.08",
      "now_trde_qty": "448203",
      "cntr_str": "346.54"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-200000",
      "pred_pre_sig": "5",
      "pred_pre": "-15000",
      "flu_rt": "-6.98",
      "open_pric": "-180000",
      "high_pric": "215000",
      "low_pric": "-180000",
      "open_pric_pre": "+11.11",
      "now_trde_qty": "619",
      "cntr_str": "385.07"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+200000",
      "pred_pre_sig": "2",
      "pred_pre": "+15600",
      "flu_rt": "+8.46",
      "open_pric": "184400",
      "high_pric": "+200000",
      "low_pric": "-183500",
      "open_pric_pre": "+8.46",
      "now_trde_qty": "143",
      "cntr_str": "500.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+140100",
      "pred_pre_sig": "2",
      "pred_pre": "+4100",
      "flu_rt": "+3.01",
      "open_pric": "+136100",
      "high_pric": "+150000",
      "low_pric": "-129000",
      "open_pric_pre": "+2.94",
      "now_trde_qty": "135",
      "cntr_str": "136.36"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 거래원매물대분석요청 (ka10043)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element   | 한글명       | Type   | Required | Length | Description                                                    |
| --------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd    | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| strt_dt   | 시작일자     | String | Y        | 8      | YYYYMMDD                                                       |
| end_dt    | 종료일자     | String | Y        | 8      | YYYYMMDD                                                       |
| qry_dt_tp | 조회기간구분 | String | Y        | 1      | 0:기간으로 조회, 1:시작일자, 종료일자로 조회                   |
| pot_tp    | 시점구분     | String | Y        | 1      | 0:당일, 1:전일                                                 |
| dt        | 기간         | String | Y        | 4      | 5:5일, 10:10일, 20:20일, 40:40일, 60:60일, 120:120일           |
| sort_base | 정렬기준     | String | Y        | 1      | 1:종가순, 2:날짜순                                             |
| mmcm_cd   | 회원사코드   | String | Y        | 3      | 회원사 코드는 ka10102 조회                                     |
| stex_tp   | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                           |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element            | 한글명           | Type   | Required | Length | Description |
| ------------------ | ---------------- | ------ | -------- | ------ | ----------- |
| trde_ori_prps_anly | 거래원매물대분석 | LIST   | N        |        |             |
| - dt               | 일자             | String | N        | 20     |             |
| - close_pric       | 종가             | String | N        | 20     |             |
| - pre_sig          | 대비기호         | String | N        | 20     |             |
| - pred_pre         | 전일대비         | String | N        | 20     |             |
| - sel_qty          | 매도량           | String | N        | 20     |             |
| - buy_qty          | 매수량           | String | N        | 20     |             |
| - netprps_qty      | 순매수수량       | String | N        | 20     |             |
| - trde_qty_sum     | 거래량합         | String | N        | 20     |             |
| - trde_wght        | 거래비중         | String | N        | 20     |             |

#### 요청 예시

```json
{
  "stk_cd": "005930",
  "strt_dt": "20241031",
  "end_dt": "20241107",
  "qry_dt_tp": "0",
  "pot_tp": "0",
  "dt": "5",
  "sort_base": "1",
  "mmcm_cd": "36",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "trde_ori_prps_anly": [
    {
      "dt": "20241105",
      "close_pric": "135300",
      "pre_sig": "2",
      "pred_pre": "+1700",
      "sel_qty": "43",
      "buy_qty": "1090",
      "netprps_qty": "1047",
      "trde_qty_sum": "1133",
      "trde_wght": "+1317.44"
    },
    {
      "dt": "20241107",
      "close_pric": "133600",
      "pre_sig": "3",
      "pred_pre": "0",
      "sel_qty": "0",
      "buy_qty": "0",
      "netprps_qty": "0",
      "trde_qty_sum": "0",
      "trde_wght": "0.00"
    },
    {
      "dt": "20241106",
      "close_pric": "132500",
      "pre_sig": "5",
      "pred_pre": "--1100",
      "sel_qty": "117",
      "buy_qty": "3459",
      "netprps_qty": "3342",
      "trde_qty_sum": "3576",
      "trde_wght": "+4158.14"
    },
    {
      "dt": "20241101",
      "close_pric": "65100",
      "pre_sig": "5",
      "pred_pre": "--68500",
      "sel_qty": "3728",
      "buy_qty": "12680",
      "netprps_qty": "8952",
      "trde_qty_sum": "16408",
      "trde_wght": "+19079.07"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 거래원순간거래량요청 (ka10052)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                                                                                   |
| ------- | ---------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------- |
| mmcm_cd | 회원사코드 | String | Y        | 3      | 회원사 코드는 ka10102 조회                                                                    |
| stk_cd  | 종목코드   | String | N        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)                                |
| mrkt_tp | 시장구분   | String | Y        | 1      | 0:전체, 1:코스피, 2:코스닥, 3:종목                                                            |
| qty_tp  | 수량구분   | String | Y        | 3      | 0:전체, 1:1000주, 2:2000주, 3:, 5:, 10:10000주, 30:30000주, 50:50000주, 100:100000주          |
| pric_tp | 가격구분   | String | Y        | 1      | 0:전체, 1:1천원 미만, 8:1천원 이상, 2:1천원~2천원, 3:2천원~5천원, 4:5천원~1만원, 5:1만원 이상 |
| stex_tp | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                          |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| trde_ori_mont_trde_qty | 거래원순간거래량 | LIST   | N        |        |             |
| - tm                   | 시간             | String | N        | 20     |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - trde_ori_nm          | 거래원명         | String | N        | 20     |             |
| - tp                   | 구분             | String | N        | 20     |             |
| - mont_trde_qty        | 순간거래량       | String | N        | 20     |             |
| - acc_netprps          | 누적순매수       | String | N        | 20     |             |
| - cur_prc              | 현재가           | String | N        | 20     |             |
| - pred_pre_sig         | 전일대비기호     | String | N        | 20     |             |
| - pred_pre             | 전일대비         | String | N        | 20     |             |
| - flu_rt               | 등락율           | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mmcm_cd": "888",
  "stk_cd": "",
  "mrkt_tp": "0",
  "qty_tp": "0",
  "pric_tp": "0",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "trde_ori_mont_trde_qty": [
    {
      "tm": "161437",
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "trde_ori_nm": "다이와",
      "tp": "-매도",
      "mont_trde_qty": "-399928",
      "acc_netprps": "-1073004",
      "cur_prc": "+57700",
      "pred_pre_sig": "2",
      "pred_pre": "400",
      "flu_rt": "+0.70"
    },
    {
      "tm": "161423",
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "trde_ori_nm": "다이와",
      "tp": "-매도",
      "mont_trde_qty": "-100000",
      "acc_netprps": "-673076",
      "cur_prc": "+57700",
      "pred_pre_sig": "2",
      "pred_pre": "400",
      "flu_rt": "+0.70"
    },
    {
      "tm": "161417",
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "trde_ori_nm": "다이와",
      "tp": "-매도",
      "mont_trde_qty": "-100000",
      "acc_netprps": "-573076",
      "cur_prc": "+57700",
      "pred_pre_sig": "2",
      "pred_pre": "400",
      "flu_rt": "+0.70"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 변동성완화장치발동종목요청 (ka10054)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명       | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                               |
| -------------- | ------------ | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| mrkt_tp        | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                                                                                                                                                                                                                                                                                          |
| bf_mkrt_tp     | 장전구분     | String | Y        | 1      | 0:전체, 1:정규시장, 2:시간외단일가                                                                                                                                                                                                                                                                                        |
| stk_cd         | 종목코드     | String | N        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)<br/>공백입력시 시장구분으로 설정한 전체종목조회                                                                                                                                                                                                            |
| motn_tp        | 발동구분     | String | Y        | 1      | 0:전체, 1:정적VI, 2:동적VI, 3:동적VI + 정적VI                                                                                                                                                                                                                                                                             |
| skip_stk       | 제외종목     | String | Y        | 9      | 전종목포함 조회시 9개 0으로 설정(000000000), 전종목제외 조회시 9개 1으로 설정(111111111), 9개 종목조회여부를 조회포함(0), 조회제외(1)로 설정하며 종목순서는 우선주, 관리종목, 투자경고/위험, 투자주의, 환기종목, 단기과열종목, 증거금100%, ETF, ETN가 됨. 우선주만 조회시 "011111111", 관리종목만 조회시 "101111111" 설정 |
| trde_qty_tp    | 거래량구분   | String | Y        | 1      | 0:사용안함, 1:사용                                                                                                                                                                                                                                                                                                        |
| min_trde_qty   | 최소거래량   | String | Y        | 12     | 0주 이상, 거래량구분이 1일때만 입력(공백허용)                                                                                                                                                                                                                                                                             |
| max_trde_qty   | 최대거래량   | String | Y        | 12     | 100000000주 이하, 거래량구분이 1일때만 입력(공백허용)                                                                                                                                                                                                                                                                     |
| trde_prica_tp  | 거래대금구분 | String | Y        | 1      | 0:사용안함, 1:사용                                                                                                                                                                                                                                                                                                        |
| min_trde_prica | 최소거래대금 | String | Y        | 10     | 0백만원 이상, 거래대금구분 1일때만 입력(공백허용)                                                                                                                                                                                                                                                                         |
| max_trde_prica | 최대거래대금 | String | Y        | 10     | 100000000백만원 이하, 거래대금구분 1일때만 입력(공백허용)                                                                                                                                                                                                                                                                 |
| motn_drc       | 발동방향     | String | Y        | 1      | 0:전체, 1:상승, 2:하락                                                                                                                                                                                                                                                                                                    |
| stex_tp        | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                                                                                                                                                                                                                                                      |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| motn_stk               | 발동종목         | LIST   | N        |        |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - acc_trde_qty         | 누적거래량       | String | N        | 20     |             |
| - motn_pric            | 발동가격         | String | N        | 20     |             |
| - dynm_dispty_rt       | 동적괴리율       | String | N        | 20     |             |
| - trde_cntr_proc_time  | 매매체결처리시각 | String | N        | 20     |             |
| - virelis_time         | VI해제시각       | String | N        | 20     |             |
| - viaplc_tp            | VI적용구분       | String | N        | 20     |             |
| - dynm_stdpc           | 동적기준가격     | String | N        | 20     |             |
| - static_stdpc         | 정적기준가격     | String | N        | 20     |             |
| - static_dispty_rt     | 정적괴리율       | String | N        | 20     |             |
| - open_pric_pre_flu_rt | 시가대비등락률   | String | N        | 20     |             |
| - vimotn_cnt           | VI발동횟수       | String | N        | 20     |             |
| - stex_tp              | 거래소구분       | String | N        | 20     |             |

#### 요청 예시

```json
{
  "mrkt_tp": "000",
  "bf_mkrt_tp": "0",
  "stk_cd": "",
  "motn_tp": "0",
  "skip_stk": "000000000",
  "trde_qty_tp": "0",
  "min_trde_qty": "0",
  "max_trde_qty": "0",
  "trde_prica_tp": "0",
  "min_trde_prica": "0",
  "max_trde_prica": "0",
  "motn_drc": "0",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "motn_stk": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "acc_trde_qty": "1105968",
      "motn_pric": "67000",
      "dynm_dispty_rt": "+9.30",
      "trde_cntr_proc_time": "172311",
      "virelis_time": "172511",
      "viaplc_tp": "동적",
      "dynm_stdpc": "61300",
      "static_stdpc": "0",
      "static_dispty_rt": "0.00",
      "open_pric_pre_flu_rt": "+16.93",
      "vimotn_cnt": "23",
      "stex_tp": "NXT"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "acc_trde_qty": "1105968",
      "motn_pric": "65000",
      "dynm_dispty_rt": "-3.13",
      "trde_cntr_proc_time": "170120",
      "virelis_time": "170320",
      "viaplc_tp": "동적",
      "dynm_stdpc": "67100",
      "static_stdpc": "0",
      "static_dispty_rt": "0.00",
      "open_pric_pre_flu_rt": "+13.44",
      "vimotn_cnt": "22",
      "stex_tp": "NXT"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "acc_trde_qty": "14",
      "motn_pric": "95100",
      "dynm_dispty_rt": "-1.96",
      "trde_cntr_proc_time": "163030",
      "virelis_time": "163224",
      "viaplc_tp": "동적",
      "dynm_stdpc": "97000",
      "static_stdpc": "0",
      "static_dispty_rt": "0.00",
      "open_pric_pre_flu_rt": "+0.11",
      "vimotn_cnt": "2",
      "stex_tp": "KRX"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "acc_trde_qty": "153",
      "motn_pric": "250000",
      "dynm_dispty_rt": "+22.55",
      "trde_cntr_proc_time": "163030",
      "virelis_time": "163224",
      "viaplc_tp": "동적+정적",
      "dynm_stdpc": "204000",
      "static_stdpc": "203500",
      "static_dispty_rt": "+22.85",
      "open_pric_pre_flu_rt": "+27.62",
      "vimotn_cnt": "3",
      "stex_tp": "KRX"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 당일전일체결량요청 (ka10055)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명   | Type   | Required | Length | Description                                                     |
| -------- | -------- | ------ | -------- | ------ | --------------------------------------------------------------- |
| stk_cd   | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)  |
| tdy_pred | 당일전일 | String | Y        | 1      | 당일 : 1, 전일 : 2                                              |
| tic_min  | 틱분     | String | Y        | 1      | 0:틱, 1:분                                                      |
| tm       | 시간     | String | N        | 4      | 조회시간 4자리, 오전 9시일 경우 0900, 오후 2시 30분일 경우 1430 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element            | 한글명           | Type   | Required | Length | Description      |
| ------------------ | ---------------- | ------ | -------- | ------ | ---------------- |
| tdy_pred_cntr      | 당일전일체결     | LIST   | N        |        |                  |
| - tm               | 시간             | String | N        | 20     |                  |
| - cur_prc          | 현재가           | String | N        | 20     |                  |
| - pred_pre         | 전일대비         | String | N        | 20     |                  |
| - pre_rt           | 대비율           | String | N        | 20     |                  |
| - pri_sel_bid_unit | 우선매도호가단위 | String | N        | 20     |                  |
| - pri_buy_bid_unit | 우선매수호가단위 | String | N        | 20     |                  |
| - cntr_trde_qty    | 체결거래량       | String | N        | 20     |                  |
| - sign             | 전일대비기호     | String | N        | 20     |                  |
| - acc_trde_qty     | 누적거래량       | String | N        | 20     |                  |
| - acc_trde_prica   | 누적거래대금     | String | N        | 20     |                  |
| - cntr_str         | 체결강도         | String | N        | 20     |                  |
| - stex_tp          | 거래소구분       | String | N        | 20     | KRX , NXT , 통합 |

#### 요청 예시

```json
{
  "stk_cd": "005930",
  "tdy_pred": "2",
  "tic_min": "0",
  "tm": ""
}
```

#### 응답 예시

```json
{
  "tdy_pred_cntr": [
    {
      "tm": "112711",
      "cur_prc": "+128300",
      "pred_pre": "+700",
      "pre_rt": "+0.55",
      "pri_sel_bid_unit": "-0",
      "pri_buy_bid_unit": "+128300",
      "cntr_trde_qty": "-1",
      "sign": "2",
      "acc_trde_qty": "2",
      "acc_trde_prica": "0",
      "cntr_str": "0.00"
    },
    {
      "tm": "111554",
      "cur_prc": "+128300",
      "pred_pre": "+700",
      "pre_rt": "+0.55",
      "pri_sel_bid_unit": "-0",
      "pri_buy_bid_unit": "+128300",
      "cntr_trde_qty": "-1",
      "sign": "2",
      "acc_trde_qty": "1",
      "acc_trde_prica": "0",
      "cntr_str": "0.00"
    }
  ],
  "returnCode": 0,
  "returnMsg": "정상적으로 처리되었습니다"
}
```

---

### 투자자별일별매매종목요청 (ka10058)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명     | Type   | Required | Length | Description                                                                                                                               |
| -------- | ---------- | ------ | -------- | ------ | ----------------------------------------------------------------------------------------------------------------------------------------- |
| strt_dt  | 시작일자   | String | Y        | 8      | YYYYMMDD                                                                                                                                  |
| end_dt   | 종료일자   | String | Y        | 8      | YYYYMMDD                                                                                                                                  |
| trde_tp  | 매매구분   | String | Y        | 1      | 순매도:1, 순매수:2                                                                                                                        |
| mrkt_tp  | 시장구분   | String | Y        | 3      | 001:코스피, 101:코스닥                                                                                                                    |
| invsr_tp | 투자자구분 | String | Y        | 4      | 8000:개인, 9000:외국인, 1000:금융투자, 3000:투신, 5000:기타금융, 4000:은행, 2000:보험, 6000:연기금, 7000:국가, 7100:기타법인, 9999:기관계 |
| stex_tp  | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT 3.통합                                                                                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element             | 한글명               | Type   | Required | Length | Description |
| ------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| invsr_daly_trde_stk | 투자자별일별매매종목 | LIST   | N        |        |             |
| - stk_cd            | 종목코드             | String | N        | 20     |             |
| - stk_nm            | 종목명               | String | N        | 20     |             |
| - netslmt_qty       | 순매도수량           | String | N        | 20     |             |
| - netslmt_amt       | 순매도금액           | String | N        | 20     |             |
| - prsm_avg_pric     | 추정평균가           | String | N        | 20     |             |
| - cur_prc           | 현재가               | String | N        | 20     |             |
| - pre_sig           | 대비기호             | String | N        | 20     |             |
| - pred_pre          | 전일대비             | String | N        | 20     |             |
| - avg_pric_pre      | 평균가대비           | String | N        | 20     |             |
| - pre_rt            | 대비율               | String | N        | 20     |             |
| - dt_trde_qty       | 기간거래량           | String | N        | 20     |             |

#### 요청 예시

```json
{
  "strt_dt": "20241106",
  "end_dt": "20241107",
  "trde_tp": "2",
  "mrkt_tp": "101",
  "invsr_tp": "8000",
  "stex_tp": "3"
}
```

#### 응답 예시

```json
{
  "invsr_daly_trde_stk": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "netslmt_qty": "+4464",
      "netslmt_amt": "+25467",
      "prsm_avg_pric": "57056",
      "cur_prc": "+61300",
      "pre_sig": "2",
      "pred_pre": "+4000",
      "avg_pric_pre": "+4244",
      "pre_rt": "+7.43",
      "dt_trde_qty": "1554171"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "netslmt_qty": "+12",
      "netslmt_amt": "+106",
      "prsm_avg_pric": "86658",
      "cur_prc": "+100200",
      "pre_sig": "2",
      "pred_pre": "+5200",
      "avg_pric_pre": "+13542",
      "pre_rt": "+15.62",
      "dt_trde_qty": "12868"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "netslmt_qty": "+46",
      "netslmt_amt": "+75",
      "prsm_avg_pric": "16320",
      "cur_prc": "15985",
      "pre_sig": "3",
      "pred_pre": "0",
      "avg_pric_pre": "--335",
      "pre_rt": "-2.05",
      "dt_trde_qty": "4770"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 종목별투자자기관별요청 (ka10059)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명       | Type   | Required | Length | Description                                                    |
| ---------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| dt         | 일자         | String | Y        | 8      | YYYYMMDD                                                       |
| stk_cd     | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| amt_qty_tp | 금액수량구분 | String | Y        | 1      | 1:금액, 2:수량                                                 |
| trde_tp    | 매매구분     | String | Y        | 1      | 0:순매수, 1:매수, 2:매도                                       |
| unit_tp    | 단위구분     | String | Y        | 4      | 1000:천주, 1:단주                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element          | 한글명             | Type   | Required | Length | Description             |
| ---------------- | ------------------ | ------ | -------- | ------ | ----------------------- |
| stk_invsr_orgn   | 종목별투자자기관별 | LIST   | N        |        |                         |
| - dt             | 일자               | String | N        | 20     |                         |
| - cur_prc        | 현재가             | String | N        | 20     |                         |
| - pre_sig        | 대비기호           | String | N        | 20     |                         |
| - pred_pre       | 전일대비           | String | N        | 20     |                         |
| - flu_rt         | 등락율             | String | N        | 20     | 우측 2자리 소수점자리수 |
| - acc_trde_qty   | 누적거래량         | String | N        | 20     |                         |
| - acc_trde_prica | 누적거래대금       | String | N        | 20     |                         |
| - ind_invsr      | 개인투자자         | String | N        | 20     |                         |
| - frgnr_invsr    | 외국인투자자       | String | N        | 20     |                         |
| - orgn           | 기관계             | String | N        | 20     |                         |
| - fnnc_invt      | 금융투자           | String | N        | 20     |                         |
| - insrnc         | 보험               | String | N        | 20     |                         |
| - invtrt         | 투신               | String | N        | 20     |                         |
| - etc_fnnc       | 기타금융           | String | N        | 20     |                         |
| - bank           | 은행               | String | N        | 20     |                         |
| - penfnd_etc     | 연기금등           | String | N        | 20     |                         |
| - samo_fund      | 사모펀드           | String | N        | 20     |                         |
| - natn           | 국가               | String | N        | 20     |                         |
| - etc_corp       | 기타법인           | String | N        | 20     |                         |
| - natfor         | 내외국인           | String | N        | 20     |                         |

#### 요청 예시

```json
{
  "dt": "20241107",
  "stk_cd": "005930",
  "amt_qty_tp": "1",
  "trde_tp": "0",
  "unit_tp": "1000"
}
```

#### 응답 예시

```json
{
  "stk_invsr_orgn": [
    {
      "dt": "20241107",
      "cur_prc": "+61300",
      "pre_sig": "2",
      "pred_pre": "+4000",
      "flu_rt": "+698",
      "acc_trde_qty": "1105968",
      "acc_trde_prica": "64215",
      "ind_invsr": "1584",
      "frgnr_invsr": "-61779",
      "orgn": "60195",
      "fnnc_invt": "25514",
      "insrnc": "0",
      "invtrt": "0",
      "etc_fnnc": "34619",
      "bank": "4",
      "penfnd_etc": "-1",
      "samo_fund": "58",
      "natn": "0",
      "etc_corp": "0",
      "natfor": "1"
    },
    {
      "dt": "20241106",
      "cur_prc": "+74800",
      "pre_sig": "1",
      "pred_pre": "+17200",
      "flu_rt": "+2986",
      "acc_trde_qty": "448203",
      "acc_trde_prica": "33340",
      "ind_invsr": "-639",
      "frgnr_invsr": "-7",
      "orgn": "646",
      "fnnc_invt": "-47",
      "insrnc": "15",
      "invtrt": "-2",
      "etc_fnnc": "730",
      "bank": "-51",
      "penfnd_etc": "1",
      "samo_fund": "0",
      "natn": "0",
      "etc_corp": "0",
      "natfor": "0"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 종목별투자자기관별합계요청 (ka10061)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명       | Type   | Required | Length | Description                                                    |
| ---------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd     | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| strt_dt    | 시작일자     | String | Y        | 8      | YYYYMMDD                                                       |
| end_dt     | 종료일자     | String | Y        | 8      | YYYYMMDD                                                       |
| amt_qty_tp | 금액수량구분 | String | Y        | 1      | 1:금액, 2:수량                                                 |
| trde_tp    | 매매구분     | String | Y        | 1      | 0:순매수, 1:매수, 2:매도                                       |
| unit_tp    | 단위구분     | String | Y        | 4      | 1000:천주, 1:단주                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element            | 한글명                 | Type   | Required | Length | Description |
| ------------------ | ---------------------- | ------ | -------- | ------ | ----------- |
| stk_invsr_orgn_tot | 종목별투자자기관별합계 | LIST   | N        |        |             |
| - ind_invsr        | 개인투자자             | String | N        | 20     |             |
| - frgnr_invsr      | 외국인투자자           | String | N        | 20     |             |
| - orgn             | 기관계                 | String | N        | 20     |             |
| - fnnc_invt        | 금융투자               | String | N        | 20     |             |
| - insrnc           | 보험                   | String | N        | 20     |             |
| - invtrt           | 투신                   | String | N        | 20     |             |
| - etc_fnnc         | 기타금융               | String | N        | 20     |             |
| - bank             | 은행                   | String | N        | 20     |             |
| - penfnd_etc       | 연기금등               | String | N        | 20     |             |
| - samo_fund        | 사모펀드               | String | N        | 20     |             |
| - natn             | 국가                   | String | N        | 20     |             |
| - etc_corp         | 기타법인               | String | N        | 20     |             |
| - natfor           | 내외국인               | String | N        | 20     |             |

#### 요청 예시

```json
{
  "stk_cd": "005930",
  "strt_dt": "20241007",
  "end_dt": "20241107",
  "amt_qty_tp": "1",
  "trde_tp": "0",
  "unit_tp": "1000"
}
```

#### 응답 예시

```json
{
  "stk_invsr_orgn_tot": [
    {
      "ind_invsr": "--28837",
      "frgnr_invsr": "--40142",
      "orgn": "+64891",
      "fnnc_invt": "+72584",
      "insrnc": "--9071",
      "invtrt": "--7790",
      "etc_fnnc": "+35307",
      "bank": "+526",
      "penfnd_etc": "--22783",
      "samo_fund": "--3881",
      "natn": "0",
      "etc_corp": "+1974",
      "natfor": "+2114"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 당일전일체결요청 (ka10084)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element  | 한글명   | Type   | Required | Length | Description                                                     |
| -------- | -------- | ------ | -------- | ------ | --------------------------------------------------------------- |
| stk_cd   | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)  |
| tdy_pred | 당일전일 | String | Y        | 1      | 당일 : 1, 전일 : 2                                              |
| tic_min  | 틱분     | String | Y        | 1      | 0:틱, 1:분                                                      |
| tm       | 시간     | String | N        | 4      | 조회시간 4자리, 오전 9시일 경우 0900, 오후 2시 30분일 경우 1430 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element            | 한글명           | Type   | Required | Length | Description      |
| ------------------ | ---------------- | ------ | -------- | ------ | ---------------- |
| tdy_pred_cntr      | 당일전일체결     | LIST   | N        |        |                  |
| - tm               | 시간             | String | N        | 20     |                  |
| - cur_prc          | 현재가           | String | N        | 20     |                  |
| - pred_pre         | 전일대비         | String | N        | 20     |                  |
| - pre_rt           | 대비율           | String | N        | 20     |                  |
| - pri_sel_bid_unit | 우선매도호가단위 | String | N        | 20     |                  |
| - pri_buy_bid_unit | 우선매수호가단위 | String | N        | 20     |                  |
| - cntr_trde_qty    | 체결거래량       | String | N        | 20     |                  |
| - sign             | 전일대비기호     | String | N        | 20     |                  |
| - acc_trde_qty     | 누적거래량       | String | N        | 20     |                  |
| - acc_trde_prica   | 누적거래대금     | String | N        | 20     |                  |
| - cntr_str         | 체결강도         | String | N        | 20     |                  |
| - stex_tp          | 거래소구분       | String | N        | 20     | KRX , NXT , 통합 |

#### 요청 예시

```json
{
  "stk_cd": "005930",
  "tdy_pred": "1",
  "tic_min": "0",
  "tm": ""
}
```

#### 응답 예시

```json
{
  "tdy_pred_cntr": [
    {
      "tm": "112711",
      "cur_prc": "+128300",
      "pred_pre": "+700",
      "pre_rt": "+0.55",
      "pri_sel_bid_unit": "-0",
      "pri_buy_bid_unit": "+128300",
      "cntr_trde_qty": "-1",
      "sign": "2",
      "acc_trde_qty": "2",
      "acc_trde_prica": "0",
      "cntr_str": "0.00"
    },
    {
      "tm": "111554",
      "cur_prc": "+128300",
      "pred_pre": "+700",
      "pre_rt": "+0.55",
      "pri_sel_bid_unit": "-0",
      "pri_buy_bid_unit": "+128300",
      "cntr_trde_qty": "-1",
      "sign": "2",
      "acc_trde_qty": "1",
      "acc_trde_prica": "0",
      "cntr_str": "0.00"
    }
  ],
  "returnCode": 0,
  "returnMsg": "정상적으로 처리되었습니다"
}
```

---

### 관심종목정보요청 (ka10095)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                                            |
| ------- | -------- | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------ |
| stk_cd  | 종목코드 | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL)<br/>여러개의 종목코드 입력시 \| 로 구분 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element             | 한글명         | Type   | Required | Length | Description |
| ------------------- | -------------- | ------ | -------- | ------ | ----------- |
| atn_stk_infr        | 관심종목정보   | LIST   | N        |        |             |
| - stk_cd            | 종목코드       | String | N        | 20     |             |
| - stk_nm            | 종목명         | String | N        | 20     |             |
| - cur_prc           | 현재가         | String | N        | 20     |             |
| - base_pric         | 기준가         | String | N        | 20     |             |
| - pred_pre          | 전일대비       | String | N        | 20     |             |
| - pred_pre_sig      | 전일대비기호   | String | N        | 20     |             |
| - flu_rt            | 등락율         | String | N        | 20     |             |
| - trde_qty          | 거래량         | String | N        | 20     |             |
| - trde_prica        | 거래대금       | String | N        | 20     |             |
| - cntr_qty          | 체결량         | String | N        | 20     |             |
| - cntr_str          | 체결강도       | String | N        | 20     |             |
| - pred_trde_qty_pre | 전일거래량대비 | String | N        | 20     |             |
| - sel_bid           | 매도호가       | String | N        | 20     |             |
| - buy_bid           | 매수호가       | String | N        | 20     |             |
| - sel_1th_bid       | 매도1차호가    | String | N        | 20     |             |
| - sel_2th_bid       | 매도2차호가    | String | N        | 20     |             |
| - sel_3th_bid       | 매도3차호가    | String | N        | 20     |             |
| - sel_4th_bid       | 매도4차호가    | String | N        | 20     |             |
| - sel_5th_bid       | 매도5차호가    | String | N        | 20     |             |
| - buy_1th_bid       | 매수1차호가    | String | N        | 20     |             |
| - buy_2th_bid       | 매수2차호가    | String | N        | 20     |             |
| - buy_3th_bid       | 매수3차호가    | String | N        | 20     |             |
| - buy_4th_bid       | 매수4차호가    | String | N        | 20     |             |
| - buy_5th_bid       | 매수5차호가    | String | N        | 20     |             |
| - upl_pric          | 상한가         | String | N        | 20     |             |
| - lst_pric          | 하한가         | String | N        | 20     |             |
| - open_pric         | 시가           | String | N        | 20     |             |
| - high_pric         | 고가           | String | N        | 20     |             |
| - low_pric          | 저가           | String | N        | 20     |             |
| - close_pric        | 종가           | String | N        | 20     |             |
| - cntr_tm           | 체결시간       | String | N        | 20     |             |
| - exp_cntr_pric     | 예상체결가     | String | N        | 20     |             |
| - exp_cntr_qty      | 예상체결량     | String | N        | 20     |             |
| - cap               | 자본금         | String | N        | 20     |             |
| - fav               | 액면가         | String | N        | 20     |             |
| - mac               | 시가총액       | String | N        | 20     |             |
| - stkcnt            | 주식수         | String | N        | 20     |             |
| - bid_tm            | 호가시간       | String | N        | 20     |             |
| - dt                | 일자           | String | N        | 20     |             |
| - pri_sel_req       | 우선매도잔량   | String | N        | 20     |             |
| - pri_buy_req       | 우선매수잔량   | String | N        | 20     |             |
| - pri_sel_cnt       | 우선매도건수   | String | N        | 20     |             |
| - pri_buy_cnt       | 우선매수건수   | String | N        | 20     |             |
| - tot_sel_req       | 총매도잔량     | String | N        | 20     |             |
| - tot_buy_req       | 총매수잔량     | String | N        | 20     |             |
| - tot_sel_cnt       | 총매도건수     | String | N        | 20     |             |
| - tot_buy_cnt       | 총매수건수     | String | N        | 20     |             |
| - prty              | 패리티         | String | N        | 20     |             |
| - gear              | 기어링         | String | N        | 20     |             |
| - pl_qutr           | 손익분기       | String | N        | 20     |             |
| - cap_support       | 자본지지       | String | N        | 20     |             |
| - elwexec_pric      | ELW행사가      | String | N        | 20     |             |
| - cnvt_rt           | 전환비율       | String | N        | 20     |             |
| - elwexpr_dt        | ELW만기일      | String | N        | 20     |             |
| - cntr_engg         | 미결제약정     | String | N        | 20     |             |
| - cntr_pred_pre     | 미결제전일대비 | String | N        | 20     |             |
| - theory_pric       | 이론가         | String | N        | 20     |             |
| - innr_vltl         | 내재변동성     | String | N        | 20     |             |
| - delta             | 델타           | String | N        | 20     |             |
| - gam               | 감마           | String | N        | 20     |             |
| - theta             | 쎄타           | String | N        | 20     |             |
| - vega              | 베가           | String | N        | 20     |             |
| - law               | 로             | String | N        | 20     |             |

#### 요청 예시

```json
{
  "stk_cd": "005930"
}
```

#### 응답 예시

```json
{
  "atn_stk_infr": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+156600",
      "base_pric": "121700",
      "pred_pre": "+34900",
      "pred_pre_sig": "2",
      "flu_rt": "+28.68",
      "trde_qty": "118636",
      "trde_prica": "14889",
      "cntr_qty": "-1",
      "cntr_str": "172.01",
      "pred_trde_qty_pre": "+1995.22",
      "sel_bid": "+156700",
      "buy_bid": "+156600",
      "sel_1th_bid": "+156700",
      "sel_2th_bid": "+156800",
      "sel_3th_bid": "+156900",
      "sel_4th_bid": "+158000",
      "sel_5th_bid": "+158100",
      "buy_1th_bid": "+156600",
      "buy_2th_bid": "+156500",
      "buy_3th_bid": "+156400",
      "buy_4th_bid": "+130000",
      "buy_5th_bid": "121700",
      "upl_pric": "+158200",
      "lst_pric": "-85200",
      "open_pric": "121700",
      "high_pric": "+158200",
      "low_pric": "-85200",
      "close_pric": "+156600",
      "cntr_tm": "163713",
      "exp_cntr_pric": "+156600",
      "exp_cntr_qty": "823",
      "cap": "7780",
      "fav": "100",
      "mac": "9348679",
      "stkcnt": "5969783",
      "bid_tm": "164000",
      "dt": "20241128",
      "pri_sel_req": "8003",
      "pri_buy_req": "7705",
      "pri_sel_cnt": "",
      "pri_buy_cnt": "",
      "tot_sel_req": "24028",
      "tot_buy_req": "26579",
      "tot_sel_cnt": "-11",
      "tot_buy_cnt": "",
      "prty": "0.00",
      "gear": "0.00",
      "pl_qutr": "0.00",
      "cap_support": "0.00",
      "elwexec_pric": "0",
      "cnvt_rt": "0.0000",
      "elwexpr_dt": "00000000",
      "cntr_engg": "",
      "cntr_pred_pre": "",
      "theory_pric": "",
      "innr_vltl": "",
      "delta": "",
      "gam": "",
      "theta": "",
      "vega": "",
      "law": ""
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 종목정보 리스트 (ka10099)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                                                   |
| ------- | -------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------- |
| mrkt_tp | 시장구분 | String | Y        | 2      | 0:코스피,10:코스닥,3:ELW,8:ETF,30:K-OTC,50:코넥스,5:신주인수권,4:뮤추얼펀드,6:리츠,9:하이일드 |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element            | 한글명           | Type   | Required | Length | Description                                                                                            |
| ------------------ | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------ |
| list               | 종목리스트       | LIST   | N        |        |                                                                                                        |
| - code             | 종목코드         | String | N        | 20     | 단축코드                                                                                               |
| - name             | 종목명           | String | N        | 20     |                                                                                                        |
| - listCount        | 상장주식수       | String | N        | 20     |                                                                                                        |
| - auditInfo        | 감리구분         | String | N        | 20     |                                                                                                        |
| - regDay           | 상장일           | String | N        | 20     |                                                                                                        |
| - lastPrice        | 전일종가         | String | N        | 20     |                                                                                                        |
| - state            | 종목상태         | String | N        | 20     |                                                                                                        |
| - marketCode       | 시장구분코드     | String | N        | 20     |                                                                                                        |
| - marketName       | 시장명           | String | N        | 20     |                                                                                                        |
| - upName           | 업종명           | String | N        | 20     |                                                                                                        |
| - upSizeName       | 회사크기분류     | String | N        | 20     |                                                                                                        |
| - companyClassName | 회사분류         | String | N        | 20     | 코스닥만 존재함                                                                                        |
| - orderWarning     | 투자유의종목여부 | String | N        | 20     | 0: 해당없음, 2: 정리매매, 3: 단기과열, 4: 투자위험, 5: 투자경과, 1: ETF투자주의요망(ETF인 경우만 전달) |
| - nxtEnable        | NXT가능여부      | String | N        | 20     | Y: 가능                                                                                                |

#### 요청 예시

```json
{
  "mrkt_tp": "0"
}
```

#### 응답 예시

```json
{
  "return_msg": "정상적으로 처리되었습니다",
  "return_code": 0,
  "list": [
    {
      "code": "005930",
      "name": "삼성전자",
      "listCount": "0000000123759593",
      "auditInfo": "투자주의환기종목",
      "regDay": "20091204",
      "lastPrice": "00000197",
      "state": "관리종목",
      "marketCode": "10",
      "marketName": "코스닥",
      "upName": "",
      "upSizeName": "",
      "companyClassName": "",
      "orderWarning": "0",
      "nxtEnable": "Y"
    },
    {
      "code": "005930",
      "name": "삼성전자",
      "listCount": "0000000136637536",
      "auditInfo": "정상",
      "regDay": "20100423",
      "lastPrice": "00000213",
      "state": "증거금100%",
      "marketCode": "10",
      "marketName": "코스닥",
      "upName": "",
      "upSizeName": "",
      "companyClassName": "외국기업",
      "orderWarning": "0",
      "nxtEnable": "Y"
    },
    {
      "code": "005930",
      "name": "삼성전자",
      "listCount": "0000000080000000",
      "auditInfo": "정상",
      "regDay": "20160818",
      "lastPrice": "00000614",
      "state": "증거금100%",
      "marketCode": "10",
      "marketName": "코스닥",
      "upName": "",
      "upSizeName": "",
      "companyClassName": "외국기업",
      "orderWarning": "0",
      "nxtEnable": "Y"
    },
    {
      "code": "005930",
      "name": "삼성전자",
      "listCount": "0000000141781250",
      "auditInfo": "정상",
      "regDay": "20160630",
      "lastPrice": "00000336",
      "state": "증거금100%",
      "marketCode": "10",
      "marketName": "코스닥",
      "upName": "",
      "upSizeName": "",
      "companyClassName": "외국기업",
      "orderWarning": "0",
      "nxtEnable": "Y"
    },
    {
      "code": "005930",
      "name": "삼성전자",
      "listCount": "0000000141781250",
      "auditInfo": "정상",
      "regDay": "20160630",
      "lastPrice": "00000336",
      "state": "증거금100%",
      "marketCode": "10",
      "marketName": "코스닥",
      "upName": "",
      "upSizeName": "",
      "companyClassName": "외국기업",
      "orderWarning": "0",
      "nxtEnable": "Y"
    }
  ]
}
```

---

### 종목정보 조회 (ka10100)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description |
| ------- | -------- | ------ | -------- | ------ | ----------- |
| stk_cd  | 종목코드 | String | Y        | 6      |             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element          | 한글명           | Type   | Required | Length | Description                                                                                            |
| ---------------- | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------------------------------------ |
| code             | 종목코드         | String | N        |        | 단축코드                                                                                               |
| name             | 종목명           | String | N        |        |                                                                                                        |
| listCount        | 상장주식수       | String | N        |        |                                                                                                        |
| auditInfo        | 감리구분         | String | N        |        |                                                                                                        |
| regDay           | 상장일           | String | N        |        |                                                                                                        |
| lastPrice        | 전일종가         | String | N        |        |                                                                                                        |
| state            | 종목상태         | String | N        |        |                                                                                                        |
| marketCode       | 시장구분코드     | String | N        |        |                                                                                                        |
| marketName       | 시장명           | String | N        |        |                                                                                                        |
| upName           | 업종명           | String | N        |        |                                                                                                        |
| upSizeName       | 회사크기분류     | String | N        |        |                                                                                                        |
| companyClassName | 회사분류         | String | N        |        | 코스닥만 존재함                                                                                        |
| orderWarning     | 투자유의종목여부 | String | N        |        | 0: 해당없음, 2: 정리매매, 3: 단기과열, 4: 투자위험, 5: 투자경과, 1: ETF투자주의요망(ETF인 경우만 전달) |
| nxtEnable        | NXT가능여부      | String | N        |        | Y: 가능                                                                                                |

#### 요청 예시

```json
{
  "stk_cd": "005930"
}
```

#### 응답 예시

```json
{
  "code": "005930",
  "name": "삼성전자",
  "listCount": "0000000026034239",
  "auditInfo": "정상",
  "regDay": "20090803",
  "lastPrice": "00136000",
  "state": "증거금20%|담보대출|신용가능",
  "marketCode": "0",
  "marketName": "거래소",
  "upName": "금융업",
  "upSizeName": "대형주",
  "companyClassName": "",
  "orderWarning": "0",
  "nxtEnable": "Y",
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 업종코드 리스트 (ka10101)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명   | Type   | Required | Length | Description                                                        |
| ------- | -------- | ------ | -------- | ------ | ------------------------------------------------------------------ |
| mrkt_tp | 시장구분 | String | Y        | 1      | 0:코스피(거래소),1:코스닥,2:KOSPI200,4:KOSPI100,7:KRX100(통합지수) |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element      | 한글명         | Type   | Required | Length | Description |
| ------------ | -------------- | ------ | -------- | ------ | ----------- |
| list         | 업종코드리스트 | LIST   | N        |        |             |
| - marketCode | 시장구분코드   | String | N        |        |             |
| - code       | 코드           | String | N        |        |             |
| - name       | 업종명         | String | N        |        |             |
| - group      | 그룹           | String | N        |        |             |

#### 요청 예시

```json
{
  "mrkt_tp": "0"
}
```

#### 응답 예시

```json
{
  "return_msg": "정상적으로 처리되었습니다",
  "list": [
    {
      "marketCode": "0",
      "code": "001",
      "name": "종합(KOSPI)",
      "group": "1"
    },
    {
      "marketCode": "0",
      "code": "002",
      "name": "대형주",
      "group": "2"
    },
    {
      "marketCode": "0",
      "code": "003",
      "name": "중형주",
      "group": "3"
    },
    {
      "marketCode": "0",
      "code": "004",
      "name": "소형주",
      "group": "4"
    },
    {
      "marketCode": "0",
      "code": "005",
      "name": "음식료업",
      "group": "5"
    },
    {
      "marketCode": "0",
      "code": "006",
      "name": "섬유의복",
      "group": "6"
    },
    {
      "marketCode": "0",
      "code": "007",
      "name": "종이목재",
      "group": "7"
    },
    {
      "marketCode": "0",
      "code": "008",
      "name": "화학",
      "group": "8"
    },
    {
      "marketCode": "0",
      "code": "009",
      "name": "의약품",
      "group": "9"
    },
    {
      "marketCode": "0",
      "code": "010",
      "name": "비금속광물",
      "group": "10"
    },
    {
      "marketCode": "0",
      "code": "011",
      "name": "철강금속",
      "group": "11"
    }
  ],
  "return_code": 0
}
```

---

### 회원사 리스트 (ka10102)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

요청 Body 없음

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element | 한글명           | Type   | Required | Length | Description |
| ------- | ---------------- | ------ | -------- | ------ | ----------- |
| list    | 회원사코드리스트 | LIST   | N        |        |             |
| - code  | 코드             | String | N        |        |             |
| - name  | 업종명           | String | N        |        |             |
| - gb    | 구분             | String | N        |        |             |

#### 요청 예시

```json
{}
```

#### 응답 예시

```json
{
  "return_msg": "정상적으로 처리되었습니다",
  "list": [
    {
      "code": "001",
      "name": "교  보",
      "gb": "0"
    },
    {
      "code": "002",
      "name": "신한금융투자",
      "gb": "0"
    },
    {
      "code": "003",
      "name": "한국투자증권",
      "gb": "0"
    },
    {
      "code": "004",
      "name": "대  신",
      "gb": "0"
    },
    {
      "code": "005",
      "name": "미래대우",
      "gb": "0"
    },
    {
      "code": "006",
      "name": "신  영",
      "gb": "0"
    },
    {
      "code": "008",
      "name": "유진투자증권",
      "gb": "0"
    },
    {
      "code": "009",
      "name": "한  양",
      "gb": "0"
    },
    {
      "code": "010",
      "name": "메리츠",
      "gb": "0"
    },
    {
      "code": "012",
      "name": "NH투자증권",
      "gb": "0"
    }
  ],
  "return_code": 0
}
```

---

### 프로그램순매수상위50요청 (ka90003)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element       | 한글명       | Type   | Required | Length | Description                  |
| ------------- | ------------ | ------ | -------- | ------ | ---------------------------- |
| trde_upper_tp | 매매상위구분 | String | Y        | 1      | 1:순매도상위, 2:순매수상위   |
| amt_qty_tp    | 금액수량구분 | String | Y        | 2      | 1:금액, 2:수량               |
| mrkt_tp       | 시장구분     | String | Y        | 10     | P00101:코스피, P10102:코스닥 |
| stex_tp       | 거래소구분   | String | Y        | 1      | 1:KRX, 2:NXT 3.통합          |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element              | 한글명               | Type   | Required | Length | Description |
| -------------------- | -------------------- | ------ | -------- | ------ | ----------- |
| prm_netprps_upper_50 | 프로그램순매수상위50 | LIST   | N        |        |             |
| - rank               | 순위                 | String | N        | 20     |             |
| - stk_cd             | 종목코드             | String | N        | 20     |             |
| - stk_nm             | 종목명               | String | N        | 20     |             |
| - cur_prc            | 현재가               | String | N        | 20     |             |
| - flu_sig            | 등락기호             | String | N        | 20     |             |
| - pred_pre           | 전일대비             | String | N        | 20     |             |
| - flu_rt             | 등락률               | String | N        | 20     |             |
| - acc_trde_qty       | 누적거래량           | String | N        | 20     |             |
| - prm_sell_amt       | 프로그램매도금액     | String | N        | 20     |             |
| - prm_buy_amt        | 프로그램매수금액     | String | N        | 20     |             |
| - prm_netprps_amt    | 프로그램순매수금액   | String | N        | 20     |             |

#### 요청 예시

```json
{
  "trde_upper_tp": "1",
  "amt_qty_tp": "1",
  "mrkt_tp": "P00101",
  "stex_tp": "1"
}
```

#### 응답 예시

```json
{
  "prm_trde_trnsn": [
    {
      "cntr_tm": "170500",
      "dfrt_trde_sel": "0",
      "dfrt_trde_buy": "0",
      "dfrt_trde_netprps": "0",
      "ndiffpro_trde_sel": "1",
      "ndiffpro_trde_buy": "17",
      "ndiffpro_trde_netprps": "+17",
      "dfrt_trde_sell_qty": "0",
      "dfrt_trde_buy_qty": "0",
      "dfrt_trde_netprps_qty": "0",
      "ndiffpro_trde_sell_qty": "0",
      "ndiffpro_trde_buy_qty": "0",
      "ndiffpro_trde_netprps_qty": "+0",
      "all_sel": "1",
      "all_buy": "17",
      "all_netprps": "+17",
      "kospi200": "+47839",
      "basis": "-146.59"
    },
    {
      "cntr_tm": "170400",
      "dfrt_trde_sel": "0",
      "dfrt_trde_buy": "0",
      "dfrt_trde_netprps": "0",
      "ndiffpro_trde_sel": "1",
      "ndiffpro_trde_buy": "17",
      "ndiffpro_trde_netprps": "+17",
      "dfrt_trde_sell_qty": "0",
      "dfrt_trde_buy_qty": "0",
      "dfrt_trde_netprps_qty": "0",
      "ndiffpro_trde_sell_qty": "0",
      "ndiffpro_trde_buy_qty": "0",
      "ndiffpro_trde_netprps_qty": "+0",
      "all_sel": "1",
      "all_buy": "17",
      "all_netprps": "+17",
      "kospi200": "+47839",
      "basis": "-146.59"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---

### 종목별프로그램매매현황요청 (ka90004)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/stkinfo
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element | 한글명     | Type   | Required | Length | Description                  |
| ------- | ---------- | ------ | -------- | ------ | ---------------------------- |
| dt      | 일자       | String | Y        | 8      | YYYYMMDD                     |
| mrkt_tp | 시장구분   | String | Y        | 10     | P00101:코스피, P10102:코스닥 |
| stex_tp | 거래소구분 | String | Y        | 1      | 1:KRX, 2:NXT 3.통합          |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element           | 한글명                 | Type   | Required | Length | Description |
| ----------------- | ---------------------- | ------ | -------- | ------ | ----------- |
| tot_1             | 매수체결수량합계       | String | N        | 20     |             |
| tot_2             | 매수체결금액합계       | String | N        | 20     |             |
| tot_3             | 매도체결수량합계       | String | N        | 20     |             |
| tot_4             | 매도체결금액합계       | String | N        | 20     |             |
| tot_5             | 순매수대금합계         | String | N        | 20     |             |
| tot_6             | 합계6                  | String | N        | 20     |             |
| stk_prm_trde_prst | 종목별프로그램매매현황 | LIST   | N        |        |             |
| - stk_cd          | 종목코드               | String | N        | 20     |             |
| - stk_nm          | 종목명                 | String | N        | 20     |             |
| - cur_prc         | 현재가                 | String | N        | 20     |             |
| - flu_sig         | 등락기호               | String | N        | 20     |             |
| - pred_pre        | 전일대비               | String | N        | 20     |             |
| - buy_cntr_qty    | 매수체결수량           | String | N        | 20     |             |
| - buy_cntr_amt    | 매수체결금액           | String | N        | 20     |             |
| - sel_cntr_qty    | 매도체결수량           | String | N        | 20     |             |
| - sel_cntr_amt    | 매도체결금액           | String | N        | 20     |             |
| - netprps_prica   | 순매수대금             | String | N        | 20     |             |
| - all_trde_rt     | 전체거래비율           | String | N        | 20     |             |

#### 요청 예시

```json
{
  "dt": "20241125",
  "mrkt_tp": "P00101",
  "stex_tp": "1"
}
```

#### 응답 예시

```json
{
  "tot_1": "0",
  "tot_2": "2",
  "tot_3": "0",
  "tot_4": "2",
  "tot_5": "0",
  "tot_6": "",
  "stk_prm_trde_prst": [
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "-75000",
      "flu_sig": "5",
      "pred_pre": "-2800",
      "buy_cntr_qty": "0",
      "buy_cntr_amt": "0",
      "sel_cntr_qty": "0",
      "sel_cntr_amt": "0",
      "netprps_prica": "0",
      "all_trde_rt": "+0.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "+130000",
      "flu_sig": "2",
      "pred_pre": "+6800",
      "buy_cntr_qty": "0",
      "buy_cntr_amt": "0",
      "sel_cntr_qty": "0",
      "sel_cntr_amt": "0",
      "netprps_prica": "0",
      "all_trde_rt": "+0.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "360000",
      "flu_sig": "3",
      "pred_pre": "0",
      "buy_cntr_qty": "0",
      "buy_cntr_amt": "0",
      "sel_cntr_qty": "0",
      "sel_cntr_amt": "0",
      "netprps_prica": "0",
      "all_trde_rt": "+0.00"
    },
    {
      "stk_cd": "005930",
      "stk_nm": "삼성전자",
      "cur_prc": "1000000",
      "flu_sig": "3",
      "pred_pre": "0",
      "buy_cntr_qty": "0",
      "buy_cntr_amt": "0",
      "sel_cntr_qty": "0",
      "sel_cntr_amt": "0",
      "netprps_prica": "0",
      "all_trde_rt": "+0.00"
    }
  ],
  "return_code": 0,
  "return_msg": "정상적으로 처리되었습니다"
}
```

---
