# 키움증권 API 문서

## 국내주식 REST API

### 주문

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 주식 매수주문 | kt10000 | 주식 매수주문 처리 |
| 주식 매도주문 | kt10001 | 주식 매도주문 처리 |
| 주식 정정주문 | kt10002 | 주식 정정주문 처리 |
| 주식 취소주문 | kt10003 | 주식 취소주문 처리 |
| 신용 매수주문 | kt10006 | 신용 매수주문 처리 |
| 신용 매도주문 | kt10007 | 신용 매도주문 처리 |
| 신용 정정주문 | kt10008 | 신용 정정주문 처리 |
| 신용 취소주문 | kt10009 | 신용 취소주문 처리 |

---

### 주식 매수주문 (kt10000)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/ordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                 |
| ------------ | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| dmst_stex_tp | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR                                                                                                                                                                                                                                                                                                                                                                                                                 |
| stk_cd       | 종목코드       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_qty      | 주문수량       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_uv       | 주문단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| trde_tp      | 매매구분       | String | Y        | 20     | 0:보통, 3:시장가, 5:조건부지정가, 81:장마감후시간외, 61:장시작전시간외, 62:시간외단일가, 6:최유리지정가, 7:최우선지정가, 10:보통(IOC), 13:시장가(IOC), 16:최유리(IOC), 20:보통(FOK), 23:시장가(FOK), 26:최유리(FOK), 28:스톱지정가, 29:중간가, 30:중간가(IOC), 31:중간가(FOK)                                                                                                                                                     |
| cond_uv      | 조건단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element      | 한글명         | Type   | Required | Length | Description |
| ------------ | -------------- | ------ | -------- | ------ | ----------- |
| ord_no       | 주문번호       | String | N        | 7      |             |
| dmst_stex_tp | 국내거래소구분 | String | N        | 6      |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"stk_cd": "005930",
	"ord_qty": "1",
	"ord_uv": "",
	"trde_tp": "3",
	"cond_uv": ""
}
```

#### 응답 예시

```json
{
	"ord_no": "00024",
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식 매도주문 (kt10001)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/ordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                 |
| ------------ | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| dmst_stex_tp | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR                                                                                                                                                                                                                                                                                                                                                                                                                 |
| stk_cd       | 종목코드       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_qty      | 주문수량       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_uv       | 주문단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| trde_tp      | 매매구분       | String | Y        | 20     | 0:보통, 3:시장가, 5:조건부지정가, 81:장마감후시간외, 61:장시작전시간외, 62:시간외단일가, 6:최유리지정가, 7:최우선지정가, 10:보통(IOC), 13:시장가(IOC), 16:최유리(IOC), 20:보통(FOK), 23:시장가(FOK), 26:최유리(FOK), 28:스톱지정가, 29:중간가, 30:중간가(IOC), 31:중간가(FOK)                                                                                                                                                     |
| cond_uv      | 조건단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element      | 한글명         | Type   | Required | Length | Description |
| ------------ | -------------- | ------ | -------- | ------ | ----------- |
| ord_no       | 주문번호       | String | N        | 7      |             |
| dmst_stex_tp | 국내거래소구분 | String | N        | 6      |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"stk_cd": "005930",
	"ord_qty": "1",
	"ord_uv": "",
	"trde_tp": "3",
	"cond_uv": ""
}
```

#### 응답 예시

```json
{
	"ord_no": "0000138",
	"dmst_stex_tp": "KRX",
	"return_code": 0,
	"return_msg": "매도주문이 완료되었습니다."
}
```

---

### 주식 정정주문 (kt10002)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/ordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명         | Type   | Required | Length | Description         |
| -------------- | -------------- | ------ | -------- | ------ | ------------------- |
| dmst_stex_tp   | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR         |
| orig_ord_no    | 원주문번호     | String | Y        | 7      |                     |
| stk_cd         | 종목코드       | String | Y        | 12     |                     |
| mdfy_qty       | 정정수량       | String | Y        | 12     |                     |
| mdfy_uv        | 정정단가       | String | Y        | 12     |                     |
| mdfy_cond_uv   | 정정조건단가   | String | N        | 12     |                     |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element          | 한글명         | Type   | Required | Length | Description |
| ---------------- | -------------- | ------ | -------- | ------ | ----------- |
| ord_no           | 주문번호       | String | N        | 7      |             |
| base_orig_ord_no | 모주문번호     | String | N        | 7      |             |
| mdfy_qty         | 정정수량       | String | N        | 12     |             |
| dmst_stex_tp     | 국내거래소구분 | String | N        | 6      |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"orig_ord_no": "0000139",
	"stk_cd": "005930",
	"mdfy_qty": "1",
	"mdfy_uv": "199700",
	"mdfy_cond_uv": ""
}
```

#### 응답 예시

```json
{
	"ord_no": "0000140",
	"base_orig_ord_no": "0000139",
	"mdfy_qty": "000000000001",
	"dmst_stex_tp": "KRX",
	"return_code": 0,
	"return_msg": "매수정정 주문입력이 완료되었습니다"
}
```

---

### 주식 취소주문 (kt10003)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/ordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                     |
| ------------ | -------------- | ------ | -------- | ------ | ------------------------------- |
| dmst_stex_tp | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR                     |
| orig_ord_no  | 원주문번호     | String | Y        | 7      |                                 |
| stk_cd       | 종목코드       | String | Y        | 12     |                                 |
| cncl_qty     | 취소수량       | String | Y        | 12     | '0' 입력시 잔량 전부 취소       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element          | 한글명         | Type   | Required | Length | Description |
| ---------------- | -------------- | ------ | -------- | ------ | ----------- |
| ord_no           | 주문번호       | String | N        | 7      |             |
| base_orig_ord_no | 모주문번호     | String | N        | 7      |             |
| cncl_qty         | 취소수량       | String | N        | 12     |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"orig_ord_no": "0000140",
	"stk_cd": "005930",
	"cncl_qty": "1"
}
```

#### 응답 예시

```json
{
	"ord_no": "0000141",
	"base_orig_ord_no": "0000139",
	"cncl_qty": "000000000001",
	"return_code": 0,
	"return_msg": "매수취소 주문입력이 완료되었습니다"
}
```

---

### 신용 매수주문 (kt10006)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/crdordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                 |
| ------------ | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| dmst_stex_tp | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR                                                                                                                                                                                                                                                                                                                                                                                                                 |
| stk_cd       | 종목코드       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_qty      | 주문수량       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_uv       | 주문단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| trde_tp      | 매매구분       | String | Y        | 20     | 0:보통, 3:시장가, 5:조건부지정가, 81:장마감후시간외, 61:장시작전시간외, 62:시간외단일가, 6:최유리지정가, 7:최우선지정가, 10:보통(IOC), 13:시장가(IOC), 16:최유리(IOC), 20:보통(FOK), 23:시장가(FOK), 26:최유리(FOK), 28:스톱지정가, 29:중간가, 30:중간가(IOC), 31:중간가(FOK)                                                                                                                                                     |
| cond_uv      | 조건단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element      | 한글명         | Type   | Required | Length | Description |
| ------------ | -------------- | ------ | -------- | ------ | ----------- |
| ord_no       | 주문번호       | String | N        | 7      |             |
| dmst_stex_tp | 국내거래소구분 | String | N        | 6      |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"stk_cd": "005930",
	"ord_qty": "1",
	"ord_uv": "2580",
	"trde_tp": "0",
	"cond_uv": ""
}
```

#### 응답 예시

```json
{
	"ord_no": "0001615",
	"dmst_stex_tp": "KRX",
	"return_code": 0,
	"return_msg": "신용 매수주문이 완료되었습니다."
}
```

---

### 신용 매도주문 (kt10007)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/crdordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                                                                                                                                                                                                                                                                                                                                                                                                                 |
| ------------ | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| dmst_stex_tp | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR                                                                                                                                                                                                                                                                                                                                                                                                                 |
| stk_cd       | 종목코드       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_qty      | 주문수량       | String | Y        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| ord_uv       | 주문단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |
| trde_tp      | 매매구분       | String | Y        | 20     | 0:보통, 3:시장가, 5:조건부지정가, 81:장마감후시간외, 61:장시작전시간외, 62:시간외단일가, 6:최유리지정가, 7:최우선지정가, 10:보통(IOC), 13:시장가(IOC), 16:최유리(IOC), 20:보통(FOK), 23:시장가(FOK), 26:최유리(FOK), 28:스톱지정가, 29:중간가, 30:중간가(IOC), 31:중간가(FOK)                                                                                                                                                     |
| crd_deal_tp  | 신용거래구분   | String | Y        | 2      | 33:융자, 99:융자합                                                                                                                                                                                                                                                                                                                                                                                                          |
| crd_loan_dt  | 대출일         | String | N        | 8      | YYYYMMDD(융자일경우필수)                                                                                                                                                                                                                                                                                                                                                                                                     |
| cond_uv      | 조건단가       | String | N        | 12     |                                                                                                                                                                                                                                                                                                                                                                                                                             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element      | 한글명         | Type   | Required | Length | Description |
| ------------ | -------------- | ------ | -------- | ------ | ----------- |
| ord_no       | 주문번호       | String | N        | 7      |             |
| dmst_stex_tp | 국내거래소구분 | String | N        | 6      |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"stk_cd": "005930",
	"ord_qty": "3",
	"ord_uv": "6450",
	"trde_tp": "0",
	"crd_deal_tp": "99",
	"crd_loan_dt": "",
	"cond_uv": ""
}
```

#### 응답 예시

```json
{
	"ord_no": "0001614",
	"dmst_stex_tp": "KRX",
	"return_code": 0,
	"return_msg": "신용 매도주문이 완료되었습니다."
}
```

---

### 신용 정정주문 (kt10008)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/crdordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명         | Type   | Required | Length | Description         |
| -------------- | -------------- | ------ | -------- | ------ | ------------------- |
| dmst_stex_tp   | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR         |
| orig_ord_no    | 원주문번호     | String | Y        | 7      |                     |
| stk_cd         | 종목코드       | String | Y        | 12     |                     |
| mdfy_qty       | 정정수량       | String | Y        | 12     |                     |
| mdfy_uv        | 정정단가       | String | Y        | 12     |                     |
| mdfy_cond_uv   | 정정조건단가   | String | N        | 12     |                     |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element          | 한글명         | Type   | Required | Length | Description |
| ---------------- | -------------- | ------ | -------- | ------ | ----------- |
| ord_no           | 주문번호       | String | N        | 7      |             |
| base_orig_ord_no | 모주문번호     | String | N        | 7      |             |
| mdfy_qty         | 정정수량       | String | N        | 12     |             |
| dmst_stex_tp     | 국내거래소구분 | String | N        | 6      |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"orig_ord_no": "0001615",
	"stk_cd": "005930",
	"mdfy_qty": "2",
	"mdfy_uv": "2600",
	"mdfy_cond_uv": ""
}
```

#### 응답 예시

```json
{
	"ord_no": "0001616",
	"base_orig_ord_no": "0001615",
	"mdfy_qty": "000000000002",
	"dmst_stex_tp": "KRX",
	"return_code": 0,
	"return_msg": "신용 정정주문이 완료되었습니다."
}
```

---

### 신용 취소주문 (kt10009)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/crdordr
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명         | Type   | Required | Length | Description                 |
| ------------ | -------------- | ------ | -------- | ------ | --------------------------- |
| dmst_stex_tp | 국내거래소구분 | String | Y        | 3      | KRX,NXT,SOR                 |
| orig_ord_no  | 원주문번호     | String | Y        | 7      |                             |
| stk_cd       | 종목코드       | String | Y        | 12     |                             |
| cncl_qty     | 취소수량       | String | Y        | 12     | '0' 입력시 잔량 전부 취소   |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element          | 한글명         | Type   | Required | Length | Description |
| ---------------- | -------------- | ------ | -------- | ------ | ----------- |
| ord_no           | 주문번호       | String | N        | 7      |             |
| base_orig_ord_no | 모주문번호     | String | N        | 7      |             |
| cncl_qty         | 취소수량       | String | N        | 12     |             |

#### 요청 예시

```json
{
	"dmst_stex_tp": "KRX",
	"orig_ord_no": "0001616",
	"stk_cd": "005930",
	"cncl_qty": "2"
}
```

#### 응답 예시

```json
{
	"ord_no": "0001617",
	"base_orig_ord_no": "0001615",
	"cncl_qty": "000000000002",
	"return_code": 0,
	"return_msg": "신용 취소주문이 완료되었습니다."
}
```

--- 