# 키움증권 API 문서

## 국내주식 REST API

### 차트

#### TR 목록

| TR명                           | 코드    | 설명                           |
| ------------------------------ | ------- | ------------------------------ |
| 종목별투자자기관별차트요청     | ka10060 | 종목별투자자기관별차트요청     |
| 장중투자자별매매차트요청       | ka10064 | 장중투자자별매매차트요청       |
| 주식틱차트조회요청             | ka10079 | 주식틱차트조회요청             |
| 주식분봉차트조회요청           | ka10080 | 주식분봉차트조회요청           |
| 주식일봉차트조회요청           | ka10081 | 주식일봉차트조회요청           |
| 주식주봉차트조회요청           | ka10082 | 주식주봉차트조회요청           |
| 주식월봉차트조회요청           | ka10083 | 주식월봉차트조회요청           |
| 주식년봉차트조회요청           | ka10094 | 주식년봉차트조회요청           |
| 업종틱차트조회요청             | ka20004 | 업종틱차트조회요청             |
| 업종분봉조회요청               | ka20005 | 업종분봉조회요청               |
| 업종일봉조회요청               | ka20006 | 업종일봉조회요청               |
| 업종주봉조회요청               | ka20007 | 업종주봉조회요청               |
| 업종월봉조회요청               | ka20008 | 업종월봉조회요청               |
| 업종년봉조회요청               | ka20019 | 업종년봉조회요청               |

---

### 종목별투자자기관별차트요청 (ka10060)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명       | Type   | Required | Length | Description                                                    |
| ---------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| dt         | 일자         | String | Y        | 8      | YYYYMMDD                                                       |
| stk_cd     | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| amt_qty_tp | 금액수량구분 | String | Y        | 1      | 1:금액, 2:수량                                                 |
| trde_tp    | 매매구분     | String | Y        | 1      | 0:순매수, 1:매수, 2:매도                                       |
| unit_tp    | 단위구분     | String | Y        | 4      | 1000:천주, 1:단주                                              |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명                     | Type   | Required | Length | Description |
| ---------------------- | -------------------------- | ------ | -------- | ------ | ----------- |
| stk_invsr_orgn_chart   | 종목별투자자기관별차트     | LIST   | N        |        |             |
| - dt                   | 일자                       | String | N        | 20     |             |
| - cur_prc              | 현재가                     | String | N        | 20     |             |
| - pred_pre             | 전일대비                   | String | N        | 20     |             |
| - acc_trde_prica       | 누적거래대금               | String | N        | 20     |             |
| - ind_invsr            | 개인투자자                 | String | N        | 20     |             |
| - frgnr_invsr          | 외국인투자자               | String | N        | 20     |             |
| - orgn                 | 기관계                     | String | N        | 20     |             |
| - fnnc_invt            | 금융투자                   | String | N        | 20     |             |
| - insrnc               | 보험                       | String | N        | 20     |             |
| - invtrt               | 투신                       | String | N        | 20     |             |
| - etc_fnnc             | 기타금융                   | String | N        | 20     |             |
| - bank                 | 은행                       | String | N        | 20     |             |
| - penfnd_etc           | 연기금등                   | String | N        | 20     |             |
| - samo_fund            | 사모펀드                   | String | N        | 20     |             |
| - natn                 | 국가                       | String | N        | 20     |             |
| - etc_corp             | 기타법인                   | String | N        | 20     |             |
| - natfor               | 내외국인                   | String | N        | 20     |             |


#### 요청 예시

```json
{
	"dt": "20241107",
	"stk_cd": "005930",
	"amt_qty_tp": "1",
	"trde_tp": "0",
	"unit_tp": "1000"
}
```

#### 응답 예시

```json
{
	"stk_invsr_orgn_chart": [
		{
			"dt": "20241107",
			"cur_prc": "+61300",
			"pred_pre": "+4000",
			"acc_trde_prica": "1105968",
			"ind_invsr": "1584",
			"frgnr_invsr": "-61779",
			"orgn": "60195",
			"fnnc_invt": "25514",
			"insrnc": "0",
			"invtrt": "0",
			"etc_fnnc": "34619",
			"bank": "4",
			"penfnd_etc": "-1",
			"samo_fund": "58",
			"natn": "0",
			"etc_corp": "0",
			"natfor": "1"
		},
		{
			"dt": "20241106",
			"cur_prc": "+74800",
			"pred_pre": "+17200",
			"acc_trde_prica": "448203",
			"ind_invsr": "-639",
			"frgnr_invsr": "-7",
			"orgn": "646",
			"fnnc_invt": "-47",
			"insrnc": "15",
			"invtrt": "-2",
			"etc_fnnc": "730",
			"bank": "-51",
			"penfnd_etc": "1",
			"samo_fund": "0",
			"natn": "0",
			"etc_corp": "0",
			"natfor": "0"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 장중투자자별매매차트요청 (ka10064)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element    | 한글명       | Type   | Required | Length | Description                                                    |
| ---------- | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| mrkt_tp    | 시장구분     | String | Y        | 3      | 000:전체, 001:코스피, 101:코스닥                               |
| amt_qty_tp | 금액수량구분 | String | Y        | 1      | 1:금액, 2:수량                                                 |
| trde_tp    | 매매구분     | String | Y        | 1      | 0:순매수, 1:매수, 2:매도                                       |
| stk_cd     | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명               | Type   | Required | Length | Description |
| ------------------------ | -------------------- | ------ | -------- | ------ | ----------- |
| opmr_invsr_trde_chart    | 장중투자자별매매차트 | LIST   | N        |        |             |
| - tm                     | 시간                 | String | N        | 20     |             |
| - frgnr_invsr            | 외국인투자자         | String | N        | 20     |             |
| - orgn                   | 기관계               | String | N        | 20     |             |
| - invtrt                 | 투신                 | String | N        | 20     |             |
| - insrnc                 | 보험                 | String | N        | 20     |             |
| - bank                   | 은행                 | String | N        | 20     |             |
| - penfnd_etc             | 연기금등             | String | N        | 20     |             |
| - etc_corp               | 기타법인             | String | N        | 20     |             |
| - natn                   | 국가                 | String | N        | 20     |             |

#### 요청 예시

```json
{
	"mrkt_tp": "000",
	"amt_qty_tp": "1",
	"trde_tp": "0",
	"stk_cd": "005930"
}
```

#### 응답 예시

```json
{
	"opmr_invsr_trde_chart": [
		{
			"tm": "090000",
			"frgnr_invsr": "0",
			"orgn": "0",
			"invtrt": "0",
			"insrnc": "0",
			"bank": "0",
			"penfnd_etc": "0",
			"etc_corp": "0",
			"natn": "0"
		},
		{
			"tm": "092200",
			"frgnr_invsr": "3",
			"orgn": "0",
			"invtrt": "0",
			"insrnc": "0",
			"bank": "0",
			"penfnd_etc": "0",
			"etc_corp": "0",
			"natn": "0"
		},
		{
			"tm": "095200",
			"frgnr_invsr": "-68",
			"orgn": "0",
			"invtrt": "0",
			"insrnc": "0",
			"bank": "0",
			"penfnd_etc": "0",
			"etc_corp": "0",
			"natn": "0"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식틱차트조회요청 (ka10079)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd       | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| tic_scope    | 틱범위       | String | Y        | 2      | 1:1틱, 3:3틱, 5:5틱, 10:10틱, 30:30틱                          |
| upd_stkpc_tp | 수정주가구분 | String | Y        | 1      | 0 or 1                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description                                                               |
| --------------------- | -------------- | ------ | -------- | ------ | ------------------------------------------------------------------------- |
| stk_cd                | 종목코드       | String | N        | 6      |                                                                           |
| last_tic_cnt          | 마지막틱갯수   | String | N        |        |                                                                           |
| stk_tic_chart_qry     | 주식틱차트조회 | LIST   | N        |        |                                                                           |
| - cur_prc             | 현재가         | String | N        | 20     |                                                                           |
| - trde_qty            | 거래량         | String | N        | 20     |                                                                           |
| - cntr_tm             | 체결시간       | String | N        | 20     |                                                                           |
| - open_pric           | 시가           | String | N        | 20     |                                                                           |
| - high_pric           | 고가           | String | N        | 20     |                                                                           |
| - low_pric            | 저가           | String | N        | 20     |                                                                           |
| - upd_stkpc_tp        | 수정주가구분   | String | N        | 20     | 1:유상증자, 2:무상증자, 4:배당락, 8:액면분할, 16:액면병합, 32:기업합병, 64:감자, 256:권리락 |
| - upd_rt              | 수정비율       | String | N        | 20     |                                                                           |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |                                                                           |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |                                                                           |
| - stk_infr            | 종목정보       | String | N        | 20     |                                                                           |
| - upd_stkpc_event     | 수정주가이벤트 | String | N        | 20     |                                                                           |
| - pred_close_pric     | 전일종가       | String | N        | 20     |                                                                           |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"tic_scope": "1",
	"upd_stkpc_tp": "1"
}
```

#### 응답 예시

```json
{
	"stk_cd": "005930",
	"last_tic_cnt": "",
	"stk_tic_chart_qry": [
		{
			"cur_prc": "132500",
			"trde_qty": "1",
			"cntr_tm": "20241106141853",
			"open_pric": "132500",
			"high_pric": "132500",
			"low_pric": "132500",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "132600",
			"trde_qty": "10",
			"cntr_tm": "20241106111111",
			"open_pric": "132600",
			"high_pric": "132600",
			"low_pric": "132600",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "132600",
			"trde_qty": "10",
			"cntr_tm": "20241106110519",
			"open_pric": "132600",
			"high_pric": "132600",
			"low_pric": "132600",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식분봉차트조회요청 (ka10080)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd       | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| tic_scope    | 틱범위       | String | Y        | 2      | 1:1분, 3:3분, 5:5분, 10:10분, 15:15분, 30:30분, 45:45분, 60:60분 |
| upd_stkpc_tp | 수정주가구분 | String | Y        | 1      | 0 or 1                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description                                                               |
| ------------------------ | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------- |
| stk_cd                   | 종목코드         | String | N        | 6      |                                                                           |
| stk_min_pole_chart_qry   | 주식분봉차트조회 | LIST   | N        |        |                                                                           |
| - cur_prc                | 현재가           | String | N        | 20     |                                                                           |
| - trde_qty               | 거래량           | String | N        | 20     |                                                                           |
| - cntr_tm                | 체결시간         | String | N        | 20     |                                                                           |
| - open_pric              | 시가             | String | N        | 20     |                                                                           |
| - high_pric              | 고가             | String | N        | 20     |                                                                           |
| - low_pric               | 저가             | String | N        | 20     |                                                                           |
| - upd_stkpc_tp           | 수정주가구분     | String | N        | 20     | 1:유상증자, 2:무상증자, 4:배당락, 8:액면분할, 16:액면병합, 32:기업합병, 64:감자, 256:권리락 |
| - upd_rt                 | 수정비율         | String | N        | 20     |                                                                           |
| - bic_inds_tp            | 대업종구분       | String | N        | 20     |                                                                           |
| - sm_inds_tp             | 소업종구분       | String | N        | 20     |                                                                           |
| - stk_infr               | 종목정보         | String | N        | 20     |                                                                           |
| - upd_stkpc_event        | 수정주가이벤트   | String | N        | 20     |                                                                           |
| - pred_close_pric        | 전일종가         | String | N        | 20     |                                                                           |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"tic_scope": "1",
	"upd_stkpc_tp": "1"
}
```

#### 응답 예시

```json
{
	"stk_cd": "005930",
	"stk_min_pole_chart_qry": [
		{
			"cur_prc": "-132500",
			"trde_qty": "1",
			"cntr_tm": "20241106141800",
			"open_pric": "-132500",
			"high_pric": "-132500",
			"low_pric": "-132500",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "-132600",
			"trde_qty": "10",
			"cntr_tm": "20241106111100",
			"open_pric": "-132600",
			"high_pric": "-132600",
			"low_pric": "-132600",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "-132600",
			"trde_qty": "20",
			"cntr_tm": "20241106110500",
			"open_pric": "133100",
			"high_pric": "133100",
			"low_pric": "-132600",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식일봉차트조회요청 (ka10081)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd       | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |
| upd_stkpc_tp | 수정주가구분 | String | Y        | 1      | 0 or 1                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description                                                               |
| ------------------------ | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------- |
| stk_cd                   | 종목코드         | String | N        | 6      |                                                                           |
| stk_dt_pole_chart_qry    | 주식일봉차트조회 | LIST   | N        |        |                                                                           |
| - cur_prc                | 현재가           | String | N        | 20     |                                                                           |
| - trde_qty               | 거래량           | String | N        | 20     |                                                                           |
| - trde_prica             | 거래대금         | String | N        | 20     |                                                                           |
| - dt                     | 일자             | String | N        | 20     |                                                                           |
| - open_pric              | 시가             | String | N        | 20     |                                                                           |
| - high_pric              | 고가             | String | N        | 20     |                                                                           |
| - low_pric               | 저가             | String | N        | 20     |                                                                           |
| - upd_stkpc_tp           | 수정주가구분     | String | N        | 20     | 1:유상증자, 2:무상증자, 4:배당락, 8:액면분할, 16:액면병합, 32:기업합병, 64:감자, 256:권리락 |
| - upd_rt                 | 수정비율         | String | N        | 20     |                                                                           |
| - bic_inds_tp            | 대업종구분       | String | N        | 20     |                                                                           |
| - sm_inds_tp             | 소업종구분       | String | N        | 20     |                                                                           |
| - stk_infr               | 종목정보         | String | N        | 20     |                                                                           |
| - upd_stkpc_event        | 수정주가이벤트   | String | N        | 20     |                                                                           |
| - pred_close_pric        | 전일종가         | String | N        | 20     |                                                                           |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"base_dt": "20241108",
	"upd_stkpc_tp": "1"
}
```

#### 응답 예시

```json
{
	"stk_cd": "005930",
	"stk_dt_pole_chart_qry": [
		{
			"cur_prc": "133600",
			"trde_qty": "0",
			"trde_prica": "0",
			"dt": "20241107",
			"open_pric": "133600",
			"high_pric": "133600",
			"low_pric": "133600",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "133600",
			"trde_qty": "53",
			"trde_prica": "7",
			"dt": "20241106",
			"open_pric": "134205",
			"high_pric": "134205",
			"low_pric": "133600",
			"upd_stkpc_tp": "",
			"upd_rt": "-1.63",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "134204",
			"trde_qty": "0",
			"trde_prica": "0",
			"dt": "20241105",
			"open_pric": "134204",
			"high_pric": "134204",
			"low_pric": "134204",
			"upd_stkpc_tp": "",
			"upd_rt": "+107.83",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "134204",
			"trde_qty": "0",
			"trde_prica": "0",
			"dt": "20241101",
			"open_pric": "134204",
			"high_pric": "134204",
			"low_pric": "134204",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식주봉차트조회요청 (ka10082)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd       | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |
| upd_stkpc_tp | 수정주가구분 | String | Y        | 1      | 0 or 1                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description                                                               |
| ------------------------ | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------- |
| stk_cd                   | 종목코드         | String | N        | 6      |                                                                           |
| stk_wk_pole_chart_qry    | 주식주봉차트조회 | LIST   | N        |        |                                                                           |
| - cur_prc                | 현재가           | String | N        | 20     |                                                                           |
| - trde_qty               | 거래량           | String | N        | 20     |                                                                           |
| - trde_prica             | 거래대금         | String | N        | 20     |                                                                           |
| - dt                     | 일자             | String | N        | 20     |                                                                           |
| - open_pric              | 시가             | String | N        | 20     |                                                                           |
| - high_pric              | 고가             | String | N        | 20     |                                                                           |
| - low_pric               | 저가             | String | N        | 20     |                                                                           |
| - upd_stkpc_tp           | 수정주가구분     | String | N        | 20     | 1:유상증자, 2:무상증자, 4:배당락, 8:액면분할, 16:액면병합, 32:기업합병, 64:감자, 256:권리락 |
| - upd_rt                 | 수정비율         | String | N        | 20     |                                                                           |
| - bic_inds_tp            | 대업종구분       | String | N        | 20     |                                                                           |
| - sm_inds_tp             | 소업종구분       | String | N        | 20     |                                                                           |
| - stk_infr               | 종목정보         | String | N        | 20     |                                                                           |
| - upd_stkpc_event        | 수정주가이벤트   | String | N        | 20     |                                                                           |
| - pred_close_pric        | 전일종가         | String | N        | 20     |                                                                           |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"base_dt": "20241108",
	"upd_stkpc_tp": "1"
}
```

#### 응답 예시

```json
{
	"stk_cd": "005930",
	"stk_wk_pole_chart_qry": [
		{
			"cur_prc": "133600",
			"trde_qty": "53",
			"trde_prica": "7",
			"dt": "20241107",
			"open_pric": "134205",
			"high_pric": "134205",
			"low_pric": "133600",
			"upd_stkpc_tp": "",
			"upd_rt": "-0.45",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "134204",
			"trde_qty": "2694",
			"trde_prica": "361",
			"dt": "20241101",
			"open_pric": "134204",
			"high_pric": "134204",
			"low_pric": "134204",
			"upd_stkpc_tp": "",
			"upd_rt": "+2.45",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "130990",
			"trde_qty": "2694",
			"trde_prica": "361",
			"dt": "20241025",
			"open_pric": "130990",
			"high_pric": "130990",
			"low_pric": "130990",
			"upd_stkpc_tp": "",
			"upd_rt": "-0.83",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식월봉차트조회요청 (ka10083)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd       | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |
| upd_stkpc_tp | 수정주가구분 | String | Y        | 1      | 0 or 1                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description                                                               |
| ------------------------ | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------- |
| stk_cd                   | 종목코드         | String | N        | 6      |                                                                           |
| stk_mth_pole_chart_qry   | 주식월봉차트조회 | LIST   | N        |        |                                                                           |
| - cur_prc                | 현재가           | String | N        | 20     |                                                                           |
| - trde_qty               | 거래량           | String | N        | 20     |                                                                           |
| - trde_prica             | 거래대금         | String | N        | 20     |                                                                           |
| - dt                     | 일자             | String | N        | 20     |                                                                           |
| - open_pric              | 시가             | String | N        | 20     |                                                                           |
| - high_pric              | 고가             | String | N        | 20     |                                                                           |
| - low_pric               | 저가             | String | N        | 20     |                                                                           |
| - upd_stkpc_tp           | 수정주가구분     | String | N        | 20     | 1:유상증자, 2:무상증자, 4:배당락, 8:액면분할, 16:액면병합, 32:기업합병, 64:감자, 256:권리락 |
| - upd_rt                 | 수정비율         | String | N        | 20     |                                                                           |
| - bic_inds_tp            | 대업종구분       | String | N        | 20     |                                                                           |
| - sm_inds_tp             | 소업종구분       | String | N        | 20     |                                                                           |
| - stk_infr               | 종목정보         | String | N        | 20     |                                                                           |
| - upd_stkpc_event        | 수정주가이벤트   | String | N        | 20     |                                                                           |
| - pred_close_pric        | 전일종가         | String | N        | 20     |                                                                           |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"base_dt": "20241108",
	"upd_stkpc_tp": "1"
}
```

#### 응답 예시

```json
{
	"stk_cd": "005930",
	"stk_mth_pole_chart_qry": [
		{
			"cur_prc": "127600",
			"trde_qty": "55",
			"trde_prica": "7043700",
			"dt": "20241101",
			"open_pric": "128171",
			"high_pric": "128179",
			"low_pric": "127600",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "128169",
			"trde_qty": "455",
			"trde_prica": "87853100",
			"dt": "20241002",
			"open_pric": "264016",
			"high_pric": "274844",
			"low_pric": "127972",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "264016",
			"trde_qty": "5101",
			"trde_prica": "1354698100",
			"dt": "20240902",
			"open_pric": "265788",
			"high_pric": "269529",
			"low_pric": "188808",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 주식년봉차트조회요청 (ka10094)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| stk_cd       | 종목코드     | String | Y        | 20     | 거래소별 종목코드<br/>(KRX:039490,NXT:039490_NX,SOR:039490_AL) |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |
| upd_stkpc_tp | 수정주가구분 | String | Y        | 1      | 0 or 1                                                         |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                  | 한글명           | Type   | Required | Length | Description                                                               |
| ------------------------ | ---------------- | ------ | -------- | ------ | ------------------------------------------------------------------------- |
| stk_cd                   | 종목코드         | String | N        | 6      |                                                                           |
| stk_yr_pole_chart_qry    | 주식년봉차트조회 | LIST   | N        |        |                                                                           |
| - cur_prc                | 현재가           | String | N        | 20     |                                                                           |
| - trde_qty               | 거래량           | String | N        | 20     |                                                                           |
| - trde_prica             | 거래대금         | String | N        | 20     |                                                                           |
| - dt                     | 일자             | String | N        | 20     |                                                                           |
| - open_pric              | 시가             | String | N        | 20     |                                                                           |
| - high_pric              | 고가             | String | N        | 20     |                                                                           |
| - low_pric               | 저가             | String | N        | 20     |                                                                           |
| - upd_stkpc_tp           | 수정주가구분     | String | N        | 20     | 1:유상증자, 2:무상증자, 4:배당락, 8:액면분할, 16:액면병합, 32:기업합병, 64:감자, 256:권리락 |
| - upd_rt                 | 수정비율         | String | N        | 20     |                                                                           |
| - bic_inds_tp            | 대업종구분       | String | N        | 20     |                                                                           |
| - sm_inds_tp             | 소업종구분       | String | N        | 20     |                                                                           |
| - stk_infr               | 종목정보         | String | N        | 20     |                                                                           |
| - upd_stkpc_event        | 수정주가이벤트   | String | N        | 20     |                                                                           |
| - pred_close_pric        | 전일종가         | String | N        | 20     |                                                                           |

#### 요청 예시

```json
{
	"stk_cd": "005930",
	"base_dt": "20241212",
	"upd_stkpc_tp": "1"
}
```

#### 응답 예시

```json
{
	"stk_cd": "005930",
	"stk_yr_pole_chart_qry": [
		{
			"cur_prc": "11510",
			"trde_qty": "83955682",
			"trde_prica": "1473889778085",
			"dt": "20240102",
			"open_pric": "38950",
			"high_pric": "39100",
			"low_pric": "10500",
			"upd_stkpc_tp": "",
			"upd_rt": "",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "39000",
			"trde_qty": "337617963",
			"trde_prica": "16721059332050",
			"dt": "20230102",
			"open_pric": "20369",
			"high_pric": "93086",
			"low_pric": "20369",
			"upd_stkpc_tp": "1,4,256",
			"upd_rt": "-1.60",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "20221",
			"trde_qty": "284497691",
			"trde_prica": "5829021315600",
			"dt": "20220103",
			"open_pric": "13942",
			"high_pric": "30160",
			"low_pric": "9940",
			"upd_stkpc_tp": "1,2,4,256",
			"upd_rt": "-12.54",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"upd_stkpc_event": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

### 업종틱차트조회요청 (ka20004)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| inds_cd      | 업종코드     | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주<br/>101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701: KRX100<br/>나머지 ※ 업종코드 참고 |
| tic_scope    | 틱범위       | String | Y        | 2      | 1:1틱, 3:3틱, 5:5틱, 10:10틱, 30:30틱                          |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description |
| --------------------- | -------------- | ------ | -------- | ------ | ----------- |
| inds_cd               | 업종코드       | String | N        | 20     |             |
| inds_tic_chart_qry    | 업종틱차트조회 | LIST   | N        |        |             |
| - cur_prc             | 현재가         | String | N        | 20     |             |
| - trde_qty            | 거래량         | String | N        | 20     |             |
| - cntr_tm             | 체결시간       | String | N        | 20     |             |
| - open_pric           | 시가           | String | N        | 20     |             |
| - high_pric           | 고가           | String | N        | 20     |             |
| - low_pric            | 저가           | String | N        | 20     |             |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |             |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |             |
| - stk_infr            | 종목정보       | String | N        | 20     |             |
| - pred_close_pric     | 전일종가       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "001",
	"tic_scope": "1"
}
```

#### 응답 예시

```json
{
	"inds_cd": "001",
	"inds_tic_chart_qry": [
		{
			"cur_prc": "239326",
			"trde_qty": "0",
			"cntr_tm": "20241122144300",
			"open_pric": "239326",
			"high_pric": "239326",
			"low_pric": "239326",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "239326",
			"trde_qty": "0",
			"cntr_tm": "20241122144250",
			"open_pric": "239326",
			"high_pric": "239326",
			"low_pric": "239326",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "239326",
			"trde_qty": "0",
			"cntr_tm": "20241122144240",
			"open_pric": "239326",
			"high_pric": "239326",
			"low_pric": "239326",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "239329",
			"trde_qty": "1",
			"cntr_tm": "20241122144230",
			"open_pric": "239329",
			"high_pric": "239329",
			"low_pric": "239329",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "239337",
			"trde_qty": "0",
			"cntr_tm": "20241122144220",
			"open_pric": "239337",
			"high_pric": "239337",
			"low_pric": "239337",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

### 업종분봉조회요청 (ka20005)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| inds_cd      | 업종코드     | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주<br/>101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701: KRX100<br/>나머지 ※ 업종코드 참고 |
| tic_scope    | 틱범위       | String | Y        | 2      | 1:1틱, 3:3틱, 5:5틱, 10:10틱, 30:30틱                          |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description |
| --------------------- | -------------- | ------ | -------- | ------ | ----------- |
| inds_cd               | 업종코드       | String | N        | 20     |             |
| inds_min_pole_qry     | 업종분봉조회   | LIST   | N        |        |             |
| - cur_prc             | 현재가         | String | N        | 20     |             |
| - trde_qty            | 거래량         | String | N        | 20     |             |
| - cntr_tm             | 체결시간       | String | N        | 20     |             |
| - open_pric           | 시가           | String | N        | 20     |             |
| - high_pric           | 고가           | String | N        | 20     |             |
| - low_pric            | 저가           | String | N        | 20     |             |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |             |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |             |
| - stk_infr            | 종목정보       | String | N        | 20     |             |
| - pred_close_pric     | 전일종가       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "001",
	"tic_scope": "5"
}
```

#### 응답 예시

```json
{
	"inds_cd": "001",
	"inds_min_pole_qry": [
		{
			"cur_prc": "-239417",
			"trde_qty": "2",
			"cntr_tm": "20241122144500",
			"open_pric": "+239252",
			"high_pric": "+239417",
			"low_pric": "+239250",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "-239326",
			"trde_qty": "1",
			"cntr_tm": "20241122144000",
			"open_pric": "+239329",
			"high_pric": "+239329",
			"low_pric": "+239326",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "-239116",
			"trde_qty": "5",
			"cntr_tm": "20241122143500",
			"open_pric": "+239405",
			"high_pric": "+239405",
			"low_pric": "+239111",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "-238846",
			"trde_qty": "112",
			"cntr_tm": "20241122143000",
			"open_pric": "+239449",
			"high_pric": "+239449",
			"low_pric": "+238846",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

### 업종일봉조회요청 (ka20006)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| inds_cd      | 업종코드     | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주<br/>101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701: KRX100<br/>나머지 ※ 업종코드 참고 |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description |
| --------------------- | -------------- | ------ | -------- | ------ | ----------- |
| inds_cd               | 업종코드       | String | N        | 20     |             |
| inds_dt_pole_qry      | 업종일봉조회   | LIST   | N        |        |             |
| - cur_prc             | 현재가         | String | N        | 20     |             |
| - trde_qty            | 거래량         | String | N        | 20     |             |
| - dt                  | 일자           | String | N        | 20     |             |
| - open_pric           | 시가           | String | N        | 20     |             |
| - high_pric           | 고가           | String | N        | 20     |             |
| - low_pric            | 저가           | String | N        | 20     |             |
| - trde_prica          | 거래대금       | String | N        | 20     |             |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |             |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |             |
| - stk_infr            | 종목정보       | String | N        | 20     |             |
| - pred_close_pric     | 전일종가       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "001",
	"base_dt": "20241122"
}
```

#### 응답 예시

```json
{
	"inds_cd": "001",
	"inds_dt_pole_qry": [
		{
			"cur_prc": "239260",
			"trde_qty": "996",
			"dt": "20241122",
			"open_pric": "266953",
			"high_pric": "266953",
			"low_pric": "237521",
			"trde_prica": "46668",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "267296",
			"trde_qty": "444",
			"dt": "20241121",
			"open_pric": "264741",
			"high_pric": "278714",
			"low_pric": "254751",
			"trde_prica": "8961",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "264740",
			"trde_qty": "195",
			"dt": "20241120",
			"open_pric": "256331",
			"high_pric": "279354",
			"low_pric": "256331",
			"trde_prica": "15465",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "256384",
			"trde_qty": "169",
			"dt": "20241119",
			"open_pric": "246075",
			"high_pric": "256424",
			"low_pric": "241051",
			"trde_prica": "7891",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

### 업종주봉조회요청 (ka20007)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| inds_cd      | 업종코드     | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주<br/>101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701: KRX100<br/>나머지 ※ 업종코드 참고 |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description |
| --------------------- | -------------- | ------ | -------- | ------ | ----------- |
| inds_cd               | 업종코드       | String | N        | 20     |             |
| inds_stk_pole_qry     | 업종주봉조회   | LIST   | N        |        |             |
| - cur_prc             | 현재가         | String | N        | 20     |             |
| - trde_qty            | 거래량         | String | N        | 20     |             |
| - dt                  | 일자           | String | N        | 20     |             |
| - open_pric           | 시가           | String | N        | 20     |             |
| - high_pric           | 고가           | String | N        | 20     |             |
| - low_pric            | 저가           | String | N        | 20     |             |
| - trde_prica          | 거래대금       | String | N        | 20     |             |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |             |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |             |
| - stk_infr            | 종목정보       | String | N        | 20     |             |
| - pred_close_pric     | 전일종가       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "001",
	"base_dt": "20241122"
}
```

#### 응답 예시

```json
{
	"inds_cd": "001",
	"inds_stk_pole_qry": [
		{
			"cur_prc": "238457",
			"trde_qty": "1988",
			"dt": "20241118",
			"open_pric": "244182",
			"high_pric": "279354",
			"low_pric": "237521",
			"trde_prica": "86023",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "248731",
			"trde_qty": "491",
			"dt": "20241111",
			"open_pric": "256115",
			"high_pric": "275840",
			"low_pric": "241690",
			"trde_prica": "31221",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "262459",
			"trde_qty": "2740",
			"dt": "20241105",
			"open_pric": "258897",
			"high_pric": "273980",
			"low_pric": "251876",
			"trde_prica": "199996",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "175851",
			"trde_qty": "1849",
			"dt": "20241028",
			"open_pric": "192710",
			"high_pric": "203154",
			"low_pric": "160807",
			"trde_prica": "93455",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

### 업종월봉조회요청 (ka20008)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| inds_cd      | 업종코드     | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주<br/>101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701: KRX100<br/>나머지 ※ 업종코드 참고 |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description |
| --------------------- | -------------- | ------ | -------- | ------ | ----------- |
| inds_cd               | 업종코드       | String | N        | 20     |             |
| inds_mth_pole_qry     | 업종월봉조회   | LIST   | N        |        |             |
| - cur_prc             | 현재가         | String | N        | 20     |             |
| - trde_qty            | 거래량         | String | N        | 20     |             |
| - dt                  | 일자           | String | N        | 20     |             |
| - open_pric           | 시가           | String | N        | 20     |             |
| - high_pric           | 고가           | String | N        | 20     |             |
| - low_pric            | 저가           | String | N        | 20     |             |
| - trde_prica          | 거래대금       | String | N        | 20     |             |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |             |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |             |
| - stk_infr            | 종목정보       | String | N        | 20     |             |
| - pred_close_pric     | 전일종가       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "002",
	"base_dt": "20241122"
}
```

#### 응답 예시

```json
{
	"inds_cd": "002",
	"inds_mth_pole_qry": [
		{
			"cur_prc": "237044",
			"trde_qty": "4586",
			"dt": "20241101",
			"open_pric": "167825",
			"high_pric": "285472",
			"low_pric": "154868",
			"trde_prica": "310647",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "164837",
			"trde_qty": "10944",
			"dt": "20241002",
			"open_pric": "264799",
			"high_pric": "307362",
			"low_pric": "151279",
			"trde_prica": "726698",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "264799",
			"trde_qty": "16025",
			"dt": "20240902",
			"open_pric": "267667",
			"high_pric": "298760",
			"low_pric": "191274",
			"trde_prica": "1212938",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		},
		{
			"cur_prc": "228272",
			"trde_qty": "828829",
			"dt": "20240801",
			"open_pric": "279434",
			"high_pric": "293154",
			"low_pric": "227409",
			"trde_prica": "60578562",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

### 업종년봉조회요청 (ka20019)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com (KRX만 지원가능)
- **URL**: /api/dostk/chart
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element      | 한글명       | Type   | Required | Length | Description                                                    |
| ------------ | ------------ | ------ | -------- | ------ | -------------------------------------------------------------- |
| inds_cd      | 업종코드     | String | Y        | 3      | 001:종합(KOSPI), 002:대형주, 003:중형주, 004:소형주<br/>101:종합(KOSDAQ), 201:KOSPI200, 302:KOSTAR, 701: KRX100<br/>나머지 ※ 업종코드 참고 |
| base_dt      | 기준일자     | String | Y        | 8      | YYYYMMDD                                                       |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element               | 한글명         | Type   | Required | Length | Description |
| --------------------- | -------------- | ------ | -------- | ------ | ----------- |
| inds_cd               | 업종코드       | String | N        | 20     |             |
| inds_yr_pole_qry      | 업종년봉조회   | LIST   | N        |        |             |
| - cur_prc             | 현재가         | String | N        | 20     |             |
| - trde_qty            | 거래량         | String | N        | 20     |             |
| - dt                  | 일자           | String | N        | 20     |             |
| - open_pric           | 시가           | String | N        | 20     |             |
| - high_pric           | 고가           | String | N        | 20     |             |
| - low_pric            | 저가           | String | N        | 20     |             |
| - trde_prica          | 거래대금       | String | N        | 20     |             |
| - bic_inds_tp         | 대업종구분     | String | N        | 20     |             |
| - sm_inds_tp          | 소업종구분     | String | N        | 20     |             |
| - stk_infr            | 종목정보       | String | N        | 20     |             |
| - pred_close_pric     | 전일종가       | String | N        | 20     |             |

#### 요청 예시

```json
{
	"inds_cd": "001",
	"base_dt": "20241122"
}
```

#### 응답 예시

```json
{
	"inds_cd": "001",
	"inds_yr_pole_qry": [
		{
			"cur_prc": "238630",
			"trde_qty": "50610088",
			"dt": "20240313",
			"open_pric": "269471",
			"high_pric": "300191",
			"low_pric": "160807",
			"trde_prica": "1150879139",
			"bic_inds_tp": "",
			"sm_inds_tp": "",
			"stk_infr": "",
			"pred_close_pric": ""
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
``` 