# 키움증권 API 문서

## 국내주식 REST API

### 테마

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 테마그룹별요청 | ka90001 | 테마 그룹별 정보 조회 |
| 테마구성종목요청 | ka90002 | 테마 구성종목 정보 조회 |

---

### 테마그룹별요청 (ka90001)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/thme
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명         | Type   | Required | Length | Description                                                                             |
| -------------- | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| qry_tp         | 검색구분       | String | Y        | 1      | 0:전체검색, 1:테마검색, 2:종목검색                                                      |
| stk_cd         | 종목코드       | String | N        | 6      | 검색하려는 종목코드                                                                     |
| date_tp        | 날짜구분       | String | Y        | 2      | n일전 (1일 ~ 99일 날짜입력)                                                             |
| thema_nm       | 테마명         | String | N        | 50     | 검색하려는 테마명                                                                       |
| flu_pl_amt_tp  | 등락수익구분   | String | Y        | 1      | 1:상위기간수익률, 2:하위기간수익률, 3:상위등락률, 4:하위등락률                          |
| stex_tp        | 거래소구분     | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                    |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| thema_grp              | 테마그룹별       | LIST   | N        |        |             |
| - thema_grp_cd         | 테마그룹코드     | String | N        | 20     |             |
| - thema_nm             | 테마명           | String | N        | 20     |             |
| - stk_num              | 종목수           | String | N        | 20     |             |
| - flu_sig              | 등락기호         | String | N        | 20     |             |
| - flu_rt               | 등락율           | String | N        | 20     |             |
| - rising_stk_num       | 상승종목수       | String | N        | 20     |             |
| - fall_stk_num         | 하락종목수       | String | N        | 20     |             |
| - dt_prft_rt           | 기간수익률       | String | N        | 20     |             |
| - main_stk             | 주요종목         | String | N        | 20     |             |

#### 요청 예시

```json
{
	"qry_tp": "0",
	"stk_cd": "",
	"date_tp": "10",
	"thema_nm": "",
	"flu_pl_amt_tp": "1",
	"stex_tp": "1"
}
```

#### 응답 예시

```json
{
	"thema_grp": [
		{
			"thema_grp_cd": "319",
			"thema_nm": "건강식품",
			"stk_num": "5",
			"flu_sig": "2",
			"flu_rt": "+0.02",
			"rising_stk_num": "1",
			"fall_stk_num": "0",
			"dt_prft_rt": "+157.80",
			"main_stk": "삼성전자"
		},
		{
			"thema_grp_cd": "452",
			"thema_nm": "SNS(Social Network Service)",
			"stk_num": "3",
			"flu_sig": "5",
			"flu_rt": "-0.09",
			"rising_stk_num": "0",
			"fall_stk_num": "1",
			"dt_prft_rt": "+67.60",
			"main_stk": "삼성전자"
		},
		{
			"thema_grp_cd": "553",
			"thema_nm": "반도체_후공정장비",
			"stk_num": "5",
			"flu_sig": "5",
			"flu_rt": "-0.27",
			"rising_stk_num": "0",
			"fall_stk_num": "1",
			"dt_prft_rt": "+56.88",
			"main_stk": "삼성전자"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---

### 테마구성종목요청 (ka90002)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /api/dostk/thme
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| authorization | 접근토큰     | String | Y        | 1000   | 토큰 지정시 토큰타입("Bearer") 붙혀서 호출<br/>예) Bearer Egicyx...                     |
| cont-yn       | 연속조회여부 | String | N        | 1      | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 cont-yn값 세팅  |
| next-key      | 연속조회키   | String | N        | 50     | 응답 Header의 연속조회여부값이 Y일 경우 다음데이터 요청시 응답 Header의 next-key값 세팅 |
| api-id        | TR명         | String | Y        | 10     |                                                                                         |

#### 요청 Body

| Element        | 한글명         | Type   | Required | Length | Description                                                                             |
| -------------- | -------------- | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| date_tp        | 날짜구분       | String | N        | 1      | 1일 ~ 99일 날짜입력                                                                     |
| thema_grp_cd   | 테마그룹코드   | String | Y        | 6      | 테마그룹코드 번호                                                                       |
| stex_tp        | 거래소구분     | String | Y        | 1      | 1:KRX, 2:NXT, 3:통합                                                                    |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| cont-yn  | 연속조회여부 | String | N        | 1      | 다음 데이터가 있을시 Y값 전달       |
| next-key | 연속조회키   | String | N        | 50     | 다음 데이터가 있을시 다음 키값 전달 |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element                | 한글명           | Type   | Required | Length | Description |
| ---------------------- | ---------------- | ------ | -------- | ------ | ----------- |
| flu_rt                 | 등락률           | String | N        | 20     |             |
| dt_prft_rt             | 기간수익률       | String | N        | 20     |             |
| thema_comp_stk         | 테마구성종목     | LIST   | N        |        |             |
| - stk_cd               | 종목코드         | String | N        | 20     |             |
| - stk_nm               | 종목명           | String | N        | 20     |             |
| - cur_prc              | 현재가           | String | N        | 20     |             |
| - flu_sig              | 등락기호         | String | N        | 20     |             |
| - pred_pre             | 전일대비         | String | N        | 20     |             |
| - flu_rt               | 등락율           | String | N        | 20     |             |
| - acc_trde_qty         | 누적거래량       | String | N        | 20     |             |
| - sel_bid              | 매도호가         | String | N        | 20     |             |
| - sel_req              | 매도잔량         | String | N        | 20     |             |
| - buy_bid              | 매수호가         | String | N        | 20     |             |
| - buy_req              | 매수잔량         | String | N        | 20     |             |
| - dt_prft_rt_n         | 기간수익률n      | String | N        | 20     |             |

#### 요청 예시

```json
{
	"date_tp": "2",
	"thema_grp_cd": "100",
	"stex_tp": "1"
}
```

#### 응답 예시

```json
{
	"flu_rt": "0.00",
	"dt_prft_rt": "0.00",
	"thema_comp_stk": [
		{
			"stk_cd": "005930",
			"stk_nm": "삼성전자",
			"cur_prc": "57800",
			"flu_sig": "3",
			"pred_pre": "0",
			"flu_rt": "0.00",
			"acc_trde_qty": "0",
			"sel_bid": "0",
			"sel_req": "0",
			"buy_bid": "0",
			"buy_req": "0",
			"dt_prft_rt_n": "0.00"
		},
		{
			"stk_cd": "005930",
			"stk_nm": "삼성전자",
			"cur_prc": "36700",
			"flu_sig": "3",
			"pred_pre": "0",
			"flu_rt": "0.00",
			"acc_trde_qty": "0",
			"sel_bid": "0",
			"sel_req": "0",
			"buy_bid": "0",
			"buy_req": "0",
			"dt_prft_rt_n": "0.00"
		},
		{
			"stk_cd": "005930",
			"stk_nm": "삼성전자",
			"cur_prc": "17380",
			"flu_sig": "3",
			"pred_pre": "0",
			"flu_rt": "0.00",
			"acc_trde_qty": "0",
			"sel_bid": "0",
			"sel_req": "0",
			"buy_bid": "0",
			"buy_req": "0",
			"dt_prft_rt_n": "0.00"
		},
		{
			"stk_cd": "005930",
			"stk_nm": "삼성전자",
			"cur_prc": "1410",
			"flu_sig": "3",
			"pred_pre": "0",
			"flu_rt": "0.00",
			"acc_trde_qty": "0",
			"sel_bid": "0",
			"sel_req": "0",
			"buy_bid": "1410",
			"buy_req": "1000",
			"dt_prft_rt_n": "0.00"
		}
	],
	"return_code": 0,
	"return_msg": "정상적으로 처리되었습니다"
}
```

---
