# 키움증권 API 문서

## OAuth 인증 REST API

### 토큰

#### TR 목록

| TR명 | 코드 | 설명 |
| ---- | ---- | ---- |
| 접근토큰발급 | au10001 | OAuth2 방식으로 접근토큰 발급 |
| 접근토큰폐기 | au10002 | 발급된 접근토큰 폐기 |

---

### 접근토큰발급 (au10001)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /oauth2/token
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| Content-Type  | 콘텐츠타입   | String | Y        | 50     | application/json;charset=UTF-8                                                          |

#### 요청 Body

| Element    | 한글명     | Type   | Required | Length | Description                |
| ---------- | ---------- | ------ | -------- | ------ | -------------------------- |
| grant_type | grant_type | String | Y        |        | client_credentials 입력    |
| appkey     | 앱키       | String | Y        |        |                            |
| secretkey  | 시크릿키   | String | Y        |        |                            |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

| Element     | 한글명     | Type   | Required | Length | Description |
| ----------- | ---------- | ------ | -------- | ------ | ----------- |
| expires_dt  | 만료일     | String | Y        |        |             |
| token_type  | 토큰타입   | String | Y        |        |             |
| token       | 접근토큰   | String | Y        |        |             |

#### 요청 예시

```json
{
	"grant_type": "client_credentials",
	"appkey": "AxserEsdcredca.....",
	"secretkey": "SEefdcwcforehDre2fdvc...."
}
```

#### 응답 예시

```json
{
	"expires_dt":"20241107083713",
	"token_type":"bearer",
	"token":"WQJCwyqInphKnR3bSRtB9NE1lv...",
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---

### 접근토큰폐기 (au10002)

#### 기본 정보

- **Method**: POST
- **운영 도메인**: https://api.kiwoom.com
- **모의투자 도메인**: https://mockapi.kiwoom.com(KRX만 지원가능)
- **URL**: /oauth2/revoke
- **Format**: JSON
- **Content-Type**: application/json;charset=UTF-8

#### 요청 Header

| Element       | 한글명       | Type   | Required | Length | Description                                                                             |
| ------------- | ------------ | ------ | -------- | ------ | --------------------------------------------------------------------------------------- |
| Content-Type  | 콘텐츠타입   | String | Y        | 50     | application/json;charset=UTF-8                                                          |

#### 요청 Body

| Element   | 한글명     | Type   | Required | Length | Description |
| --------- | ---------- | ------ | -------- | ------ | ----------- |
| appkey    | 앱키       | String | Y        |        |             |
| secretkey | 시크릿키   | String | Y        |        |             |
| token     | 접근토큰   | String | Y        |        |             |

#### 응답 Header

| Element  | 한글명       | Type   | Required | Length | Description                         |
| -------- | ------------ | ------ | -------- | ------ | ----------------------------------- |
| api-id   | TR명         | String | Y        | 10     |                                     |

#### 응답 Body

토큰 폐기 성공시 기본 응답 메시지만 반환

#### 요청 예시

```json
{
	"appkey": "AxserEsdcredca.....",
	"secretkey": "SEefdcwcforehDre2fdvc....",
	"token": "WQJCwyqInphKnR3bSRtB9NE1lv..."
}
```

#### 응답 예시

```json
{
	"return_code":0,
	"return_msg":"정상적으로 처리되었습니다"
}
```

---
