# 🎉 Version 0.4.2 Deployment Complete! 🎉

## Deployment Summary - November 21, 2025

### ✅ Successfully Deployed Version 0.4.2!

**Package**: `parallel-llm`  
**Version**: 0.4.2  
**PyPI URL**: https://pypi.org/project/parallel-llm/0.4.2/  
**Deployment Time**: November 21, 2025, 12:30 PM IST

---

## 📦 Key Updates in v0.4.2

### 1. Smart GPU Installation (Default)
- **Default Behavior**: `pip install parallel-llm` now attempts to install GPU dependencies (`triton`, `flash-attn`, `xformers`) by default.
- **Platform Guarded**: These dependencies are marked with `platform_system == "Linux"`.
    - **On Linux**: They are installed automatically.
    - **On Windows/Mac**: They are skipped automatically, preventing installation errors.

### 2. Solved Dependency Conflicts
- Fixed the `ERROR: No matching distribution found for triton>=2.2.0` on Windows.
- You can now install the package on Windows without any extra flags or errors.

### 3. CPU Support
- CPU support is now the fallback if GPU dependencies cannot be installed (e.g., on Windows or non-CUDA Linux).
- An optional `cpu` extra exists (`pip install parallel-llm[cpu]`) but is effectively a no-op since the core package supports CPU out of the box.

---

## 🚀 Installation Guide

### Standard Installation (Recommended)
This will install GPU support if you are on Linux, and CPU-only if you are on Windows/Mac.

```bash
pip install parallel-llm==0.4.2
```

### Verification
To verify the installation:

```bash
python -c "import parallel_llm; print(f'Installed v{parallel_llm.__version__}')"
```

---

## 🔗 Links
- **PyPI**: https://pypi.org/project/parallel-llm/
- **GitHub**: https://github.com/furqan-y-khan/parallel-llm

---

*Deployment completed successfully by Antigravity*
