"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.At = exports.OnDeploy = exports.dateToCron = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const cdk = require("@aws-cdk/core");
function dateToCron(date) {
    const minutes = date.getUTCMinutes();
    const hours = date.getUTCHours();
    const days = date.getUTCDay();
    const months = date.getUTCMonth() + 1;
    const years = date.getUTCFullYear();
    return `${minutes} ${hours} ${days} ${months} ? ${years}`;
}
exports.dateToCron = dateToCron;
;
class OnDeploy extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const date = new Date();
        const minutesToAdd = props.offsetMinutes || 10;
        const future = new Date(date.getTime() + minutesToAdd * 60000);
        this.schedule = events.Schedule.expression('cron(' + dateToCron(future) + ')');
    }
}
exports.OnDeploy = OnDeploy;
_a = JSII_RTTI_SYMBOL_1;
OnDeploy[_a] = { fqn: "@renovosolutions/cdk-library-one-time-event.OnDeploy", version: "1.0.235" };
class At extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.schedule = events.Schedule.expression('cron(' + dateToCron(props.date) + ')');
    }
}
exports.At = At;
_b = JSII_RTTI_SYMBOL_1;
At[_b] = { fqn: "@renovosolutions/cdk-library-one-time-event.At", version: "1.0.235" };
//# sourceMappingURL=data:application/json;base64,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