"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query Permission {
  permissions: permissions_v1 {
    ... on PermissionGitlabGroupMembership_v1 {
      name
      group
      access
      pagerduty {
        name
        instance {
          name
          token {
            ...VaultSecret
          }
        }
        scheduleID
        escalationPolicyID
      }
      roles {
        users {
          org_username
        }
        bots {
          org_username
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class PermissionV1(ConfiguredBaseModel):
    ...


class PagerDutyInstanceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    token: VaultSecret = Field(..., alias="token")


class PagerDutyTargetV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    instance: PagerDutyInstanceV1 = Field(..., alias="instance")
    schedule_id: Optional[str] = Field(..., alias="scheduleID")
    escalation_policy_id: Optional[str] = Field(..., alias="escalationPolicyID")


class UserV1(ConfiguredBaseModel):
    org_username: str = Field(..., alias="org_username")


class BotV1(ConfiguredBaseModel):
    org_username: Optional[str] = Field(..., alias="org_username")


class RoleV1(ConfiguredBaseModel):
    users: list[UserV1] = Field(..., alias="users")
    bots: list[BotV1] = Field(..., alias="bots")


class PermissionGitlabGroupMembershipV1(PermissionV1):
    name: str = Field(..., alias="name")
    group: str = Field(..., alias="group")
    access: str = Field(..., alias="access")
    pagerduty: Optional[list[PagerDutyTargetV1]] = Field(..., alias="pagerduty")
    roles: Optional[list[RoleV1]] = Field(..., alias="roles")


class PermissionQueryData(ConfiguredBaseModel):
    permissions: list[Union[PermissionGitlabGroupMembershipV1, PermissionV1]] = Field(..., alias="permissions")


def query(query_func: Callable, **kwargs: Any) -> PermissionQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        PermissionQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return PermissionQueryData(**raw_data)
