"""
Generated by qenerate plugin=pydantic_v1. DO NOT MODIFY MANUALLY!
"""
from collections.abc import Callable  # noqa: F401 # pylint: disable=W0611
from datetime import datetime  # noqa: F401 # pylint: disable=W0611
from enum import Enum  # noqa: F401 # pylint: disable=W0611
from typing import (  # noqa: F401 # pylint: disable=W0611
    Any,
    Optional,
    Union,
)

from pydantic import (  # noqa: F401 # pylint: disable=W0611
    BaseModel,
    Extra,
    Field,
    Json,
)

from reconcile.gql_definitions.fragments.vault_secret import VaultSecret


DEFINITION = """
fragment VaultSecret on VaultSecret_v1 {
  path
  field
  version
  format
}

query StatusPages {
  status_pages: status_page_v1 {
    name
    description
    pageId
    url
    apiUrl
    credentials {
      ...VaultSecret
    }
    components {
      name
      displayName
      description
      path
      groupName
      app {
        name
      }
      status_config: status {
        provider
        ... on ManualStatusProvider_v1 {
          manual {
            componentStatus
            from
            until
          }
        }
      }
    }
    maintenances {
      name
      message
      scheduledStart
      scheduledEnd
      affectedServices {
        name
      }
      announcements {
        provider
        ... on MaintenanceStatuspageAnnouncement_v1 {
          page {
            name
          }
          remindSubscribers
          notifySubscribersOnStart
          notifySubscribersOnCompletion
        }
      }
    }
  }
}
"""


class ConfiguredBaseModel(BaseModel):
    class Config:
        smart_union=True
        extra=Extra.forbid


class AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class StatusProviderV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class ManualStatusProviderConfigV1(ConfiguredBaseModel):
    component_status: str = Field(..., alias="componentStatus")
    q_from: Optional[str] = Field(..., alias="from")
    until: Optional[str] = Field(..., alias="until")


class ManualStatusProviderV1(StatusProviderV1):
    manual: ManualStatusProviderConfigV1 = Field(..., alias="manual")


class StatusPageComponentV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    display_name: str = Field(..., alias="displayName")
    description: Optional[str] = Field(..., alias="description")
    path: str = Field(..., alias="path")
    group_name: Optional[str] = Field(..., alias="groupName")
    app: AppV1 = Field(..., alias="app")
    status_config: Optional[list[Union[ManualStatusProviderV1, StatusProviderV1]]] = Field(..., alias="status_config")


class MaintenanceV1_AppV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class MaintenanceAnnouncementV1(ConfiguredBaseModel):
    provider: str = Field(..., alias="provider")


class MaintenanceStatuspageAnnouncementV1_StatusPageV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")


class MaintenanceStatuspageAnnouncementV1(MaintenanceAnnouncementV1):
    page: MaintenanceStatuspageAnnouncementV1_StatusPageV1 = Field(..., alias="page")
    remind_subscribers: Optional[bool] = Field(..., alias="remindSubscribers")
    notify_subscribers_on_start: Optional[bool] = Field(..., alias="notifySubscribersOnStart")
    notify_subscribers_on_completion: Optional[bool] = Field(..., alias="notifySubscribersOnCompletion")


class MaintenanceV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    message: str = Field(..., alias="message")
    scheduled_start: str = Field(..., alias="scheduledStart")
    scheduled_end: str = Field(..., alias="scheduledEnd")
    affected_services: list[MaintenanceV1_AppV1] = Field(..., alias="affectedServices")
    announcements: Optional[list[Union[MaintenanceStatuspageAnnouncementV1, MaintenanceAnnouncementV1]]] = Field(..., alias="announcements")


class StatusPageV1(ConfiguredBaseModel):
    name: str = Field(..., alias="name")
    description: str = Field(..., alias="description")
    page_id: str = Field(..., alias="pageId")
    url: Optional[str] = Field(..., alias="url")
    api_url: str = Field(..., alias="apiUrl")
    credentials: VaultSecret = Field(..., alias="credentials")
    components: Optional[list[StatusPageComponentV1]] = Field(..., alias="components")
    maintenances: Optional[list[MaintenanceV1]] = Field(..., alias="maintenances")


class StatusPagesQueryData(ConfiguredBaseModel):
    status_pages: Optional[list[StatusPageV1]] = Field(..., alias="status_pages")


def query(query_func: Callable, **kwargs: Any) -> StatusPagesQueryData:
    """
    This is a convenience function which queries and parses the data into
    concrete types. It should be compatible with most GQL clients.
    You do not have to use it to consume the generated data classes.
    Alternatively, you can also mime and alternate the behavior
    of this function in the caller.

    Parameters:
        query_func (Callable): Function which queries your GQL Server
        kwargs: optional arguments that will be passed to the query function

    Returns:
        StatusPagesQueryData: queried data parsed into generated classes
    """
    raw_data: dict[Any, Any] = query_func(DEFINITION, **kwargs)
    return StatusPagesQueryData(**raw_data)
