"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
test('create a cluster parameter group', () => {
    // GIVEN
    const stack = new cdk.Stack();
    // WHEN
    new lib_1.ClusterParameterGroup(stack, 'Params', {
        description: 'desc',
        parameters: {
            param: 'value',
        },
    });
    // THEN
    assert_1.expect(stack).to(assert_1.haveResource('AWS::Redshift::ClusterParameterGroup', {
        Description: 'desc',
        ParameterGroupFamily: 'redshift-1.0',
        Parameters: [
            {
                ParameterName: 'param',
                ParameterValue: 'value',
            },
        ],
    }));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFyYW1ldGVyLWdyb3VwLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJwYXJhbWV0ZXItZ3JvdXAudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDRDQUFvRTtBQUNwRSxxQ0FBcUM7QUFDckMsZ0NBQStDO0FBRS9DLElBQUksQ0FBQyxrQ0FBa0MsRUFBRSxHQUFHLEVBQUU7SUFDNUMsUUFBUTtJQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO0lBRTlCLE9BQU87SUFDUCxJQUFJLDJCQUFxQixDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7UUFDekMsV0FBVyxFQUFFLE1BQU07UUFDbkIsVUFBVSxFQUFFO1lBQ1YsS0FBSyxFQUFFLE9BQU87U0FDZjtLQUNGLENBQUMsQ0FBQztJQUVILE9BQU87SUFDUCxlQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDLHFCQUFZLENBQUMsc0NBQXNDLEVBQUU7UUFDdkUsV0FBVyxFQUFFLE1BQU07UUFDbkIsb0JBQW9CLEVBQUUsY0FBYztRQUNwQyxVQUFVLEVBQUU7WUFDVjtnQkFDRSxhQUFhLEVBQUUsT0FBTztnQkFDdEIsY0FBYyxFQUFFLE9BQU87YUFDeEI7U0FDRjtLQUNGLENBQUMsQ0FBQyxDQUFDO0FBRU4sQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBleHBlY3QgYXMgY2RrRXhwZWN0LCBoYXZlUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ2x1c3RlclBhcmFtZXRlckdyb3VwIH0gZnJvbSAnLi4vbGliJztcblxudGVzdCgnY3JlYXRlIGEgY2x1c3RlciBwYXJhbWV0ZXIgZ3JvdXAnLCAoKSA9PiB7XG4gIC8vIEdJVkVOXG4gIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gIC8vIFdIRU5cbiAgbmV3IENsdXN0ZXJQYXJhbWV0ZXJHcm91cChzdGFjaywgJ1BhcmFtcycsIHtcbiAgICBkZXNjcmlwdGlvbjogJ2Rlc2MnLFxuICAgIHBhcmFtZXRlcnM6IHtcbiAgICAgIHBhcmFtOiAndmFsdWUnLFxuICAgIH0sXG4gIH0pO1xuXG4gIC8vIFRIRU5cbiAgY2RrRXhwZWN0KHN0YWNrKS50byhoYXZlUmVzb3VyY2UoJ0FXUzo6UmVkc2hpZnQ6OkNsdXN0ZXJQYXJhbWV0ZXJHcm91cCcsIHtcbiAgICBEZXNjcmlwdGlvbjogJ2Rlc2MnLFxuICAgIFBhcmFtZXRlckdyb3VwRmFtaWx5OiAncmVkc2hpZnQtMS4wJyxcbiAgICBQYXJhbWV0ZXJzOiBbXG4gICAgICB7XG4gICAgICAgIFBhcmFtZXRlck5hbWU6ICdwYXJhbScsXG4gICAgICAgIFBhcmFtZXRlclZhbHVlOiAndmFsdWUnLFxuICAgICAgfSxcbiAgICBdLFxuICB9KSk7XG5cbn0pOyJdfQ==