
from ..customParserApiClient import createRequest, get_help
from ...Utils.help_formatter import CustomSubparserHelpFormatter

def mutation_xdr_parse(mutation_subparsers):
    mutation_xdr_parser = mutation_subparsers.add_parser('xdr', 
            help='xdr() mutation operation', 
            usage=get_help("mutation_xdr"), formatter_class=CustomSubparserHelpFormatter)

    def _show_mutation_xdr_help(args, configuration=None):
        """Show help when mutation_xdr is called without subcommand"""
        print("Usage: catocli mutation xdr <subcommand> [options]")
        print("\nAvailable subcommands:")
        print("  analystFeedback                analystFeedback operation\n  addStoryComment                addStoryComment operation\n  deleteStoryComment             deleteStoryComment operation")
        print("\nFor help on a specific subcommand:")
        print("  catocli mutation xdr <subcommand> -h")
        return None

    mutation_xdr_subparsers = mutation_xdr_parser.add_subparsers()
    mutation_xdr_parser.set_defaults(func=_show_mutation_xdr_help)

    mutation_xdr_analystFeedback_parser = mutation_xdr_subparsers.add_parser('analystFeedback', 
            help='analystFeedback() xdr operation', 
            usage=get_help("mutation_xdr_analystFeedback"))

    mutation_xdr_analystFeedback_parser.add_argument('json', nargs='?', default='{}', help='Variables in JSON format (defaults to empty object if not provided).')
    mutation_xdr_analystFeedback_parser.add_argument('-accountID', help='The cato account ID to use for this operation. Overrides the account_id value in the profile setting.  This is use for reseller and MSP accounts to run queries against cato sub accounts from the parent account.')
    mutation_xdr_analystFeedback_parser.add_argument('-t', const=True, default=False, nargs='?', help='Print GraphQL query without sending API call')
    mutation_xdr_analystFeedback_parser.add_argument('-v', const=True, default=False, nargs='?', help='Verbose output')
    mutation_xdr_analystFeedback_parser.add_argument('-p', const=True, default=False, nargs='?', help='Pretty print')
    mutation_xdr_analystFeedback_parser.add_argument('-n', '--stream-events', dest='stream_events', help='Send events over network to host:port TCP')
    mutation_xdr_analystFeedback_parser.add_argument('-z', '--sentinel', dest='sentinel', help='Send events to Sentinel customerid:sharedkey')
    mutation_xdr_analystFeedback_parser.add_argument('-H', '--header', action='append', dest='headers', help='Add custom headers in "Key: Value" format. Can be used multiple times.')
    mutation_xdr_analystFeedback_parser.add_argument('--headers-file', dest='headers_file', help='Load headers from a file. Each line should contain a header in "Key: Value" format.')
    mutation_xdr_analystFeedback_parser.add_argument('--trace-id', dest='trace_id', action='store_true', help='Enable tracing and print the trace ID from the response')
    mutation_xdr_analystFeedback_parser.set_defaults(func=createRequest,operation_name='mutation.xdr.analystFeedback')

    mutation_xdr_addStoryComment_parser = mutation_xdr_subparsers.add_parser('addStoryComment', 
            help='addStoryComment() xdr operation', 
            usage=get_help("mutation_xdr_addStoryComment"))

    mutation_xdr_addStoryComment_parser.add_argument('json', nargs='?', default='{}', help='Variables in JSON format (defaults to empty object if not provided).')
    mutation_xdr_addStoryComment_parser.add_argument('-accountID', help='The cato account ID to use for this operation. Overrides the account_id value in the profile setting.  This is use for reseller and MSP accounts to run queries against cato sub accounts from the parent account.')
    mutation_xdr_addStoryComment_parser.add_argument('-t', const=True, default=False, nargs='?', help='Print GraphQL query without sending API call')
    mutation_xdr_addStoryComment_parser.add_argument('-v', const=True, default=False, nargs='?', help='Verbose output')
    mutation_xdr_addStoryComment_parser.add_argument('-p', const=True, default=False, nargs='?', help='Pretty print')
    mutation_xdr_addStoryComment_parser.add_argument('-n', '--stream-events', dest='stream_events', help='Send events over network to host:port TCP')
    mutation_xdr_addStoryComment_parser.add_argument('-z', '--sentinel', dest='sentinel', help='Send events to Sentinel customerid:sharedkey')
    mutation_xdr_addStoryComment_parser.add_argument('-H', '--header', action='append', dest='headers', help='Add custom headers in "Key: Value" format. Can be used multiple times.')
    mutation_xdr_addStoryComment_parser.add_argument('--headers-file', dest='headers_file', help='Load headers from a file. Each line should contain a header in "Key: Value" format.')
    mutation_xdr_addStoryComment_parser.add_argument('--trace-id', dest='trace_id', action='store_true', help='Enable tracing and print the trace ID from the response')
    mutation_xdr_addStoryComment_parser.set_defaults(func=createRequest,operation_name='mutation.xdr.addStoryComment')

    mutation_xdr_deleteStoryComment_parser = mutation_xdr_subparsers.add_parser('deleteStoryComment', 
            help='deleteStoryComment() xdr operation', 
            usage=get_help("mutation_xdr_deleteStoryComment"))

    mutation_xdr_deleteStoryComment_parser.add_argument('json', nargs='?', default='{}', help='Variables in JSON format (defaults to empty object if not provided).')
    mutation_xdr_deleteStoryComment_parser.add_argument('-accountID', help='The cato account ID to use for this operation. Overrides the account_id value in the profile setting.  This is use for reseller and MSP accounts to run queries against cato sub accounts from the parent account.')
    mutation_xdr_deleteStoryComment_parser.add_argument('-t', const=True, default=False, nargs='?', help='Print GraphQL query without sending API call')
    mutation_xdr_deleteStoryComment_parser.add_argument('-v', const=True, default=False, nargs='?', help='Verbose output')
    mutation_xdr_deleteStoryComment_parser.add_argument('-p', const=True, default=False, nargs='?', help='Pretty print')
    mutation_xdr_deleteStoryComment_parser.add_argument('-n', '--stream-events', dest='stream_events', help='Send events over network to host:port TCP')
    mutation_xdr_deleteStoryComment_parser.add_argument('-z', '--sentinel', dest='sentinel', help='Send events to Sentinel customerid:sharedkey')
    mutation_xdr_deleteStoryComment_parser.add_argument('-H', '--header', action='append', dest='headers', help='Add custom headers in "Key: Value" format. Can be used multiple times.')
    mutation_xdr_deleteStoryComment_parser.add_argument('--headers-file', dest='headers_file', help='Load headers from a file. Each line should contain a header in "Key: Value" format.')
    mutation_xdr_deleteStoryComment_parser.add_argument('--trace-id', dest='trace_id', action='store_true', help='Enable tracing and print the trace ID from the response')
    mutation_xdr_deleteStoryComment_parser.set_defaults(func=createRequest,operation_name='mutation.xdr.deleteStoryComment')
