
## CATO-CLI - query.policy.antiMalwareFileHash.policy:
[Click here](https://api.catonetworks.com/documentation/#query-query.policy.antiMalwareFileHash.policy) for documentation on this operation.

### Usage for query.policy.antiMalwareFileHash.policy:

```bash
catocli query policy antiMalwareFileHash policy -h

catocli query policy antiMalwareFileHash policy <json>

catocli query policy antiMalwareFileHash policy "$(cat < query.policy.antiMalwareFileHash.policy.json)"

catocli query policy antiMalwareFileHash policy '{"antiMalwareFileHashPolicyInput":{"policyRevisionInput":{"id":"id","type":"PRIVATE"}}}'

catocli query policy antiMalwareFileHash policy '{
    "antiMalwareFileHashPolicyInput": {
        "policyRevisionInput": {
            "id": "id",
            "type": "PRIVATE"
        }
    }
}'
```

## Advanced Usage
### Additional Examples
- Parse the query response using jq to get names and ids only
- Parse the query response using jq to get names and ids with index included:

# Parse the query response using jq to get names and ids only

```bash
# Parse the query response using jq to get names and ids only
catocli query policy antiMalwareFileHash policy | jq '.data.policy.antiMalwareFileHash.policy.rules[].rule | {name: .name, id: .id}'
```

# Parse the query response using jq to get names and ids with index included:

```bash
# Parse the query response using jq to get names and ids with index included:
catocli query policy antiMalwareFileHash policy | jq -r '.data.policy.antiMalwareFileHash.policy.rules[] | "\(.rule.index) | \(.rule.name) | \(.rule.id)"'
```


#### Operation Arguments for query.policy.antiMalwareFileHash.policy ####

`accountId` [ID] - (required) N/A    
`antiMalwareFileHashPolicyInput` [AntiMalwareFileHashPolicyInput] - (required) N/A    
