
## CATO-CLI - query.policy.applicationControl.policy:
[Click here](https://api.catonetworks.com/documentation/#query-query.policy.applicationControl.policy) for documentation on this operation.

### Usage for query.policy.applicationControl.policy:

```bash
catocli query policy applicationControl policy -h

catocli query policy applicationControl policy <json>

catocli query policy applicationControl policy "$(cat < query.policy.applicationControl.policy.json)"

catocli query policy applicationControl policy '{"applicationControlPolicyInput":{"policyRevisionInput":{"id":"id","type":"PRIVATE"}}}'

catocli query policy applicationControl policy '{
    "applicationControlPolicyInput": {
        "policyRevisionInput": {
            "id": "id",
            "type": "PRIVATE"
        }
    }
}'
```

## Advanced Usage
### Additional Examples
- Parse the query response using jq to get names and ids only
- Parse the query response using jq to get names and ids with index included:

# Parse the query response using jq to get names and ids only

```bash
# Parse the query response using jq to get names and ids only
catocli query policy applicationControl policy | jq '.data.policy.applicationControl.policy.rules[].rule | {name: .name, id: .id}'
```

# Parse the query response using jq to get names and ids with index included:

```bash
# Parse the query response using jq to get names and ids with index included:
catocli query policy applicationControl policy | jq -r '.data.policy.applicationControl.policy.rules[] | "\(.rule.index) | \(.rule.name) | \(.rule.id)"'
```


#### Operation Arguments for query.policy.applicationControl.policy ####

`accountId` [ID] - (required) N/A    
`applicationControlPolicyInput` [ApplicationControlPolicyInput] - (required) N/A    
